<?php

/**
 * init.form350.php - General Ledger account detail popup - Accommodation Tab
 * Job: 281
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_accommodation.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			if(db_pr_business_ledger_allow($iUnitID)) {
				// Process the data to be saved
				$editedFields = explode("_",$_SERVER['argv'][3]);
				// Knock off the extra empty array
				array_pop($editedFields);
				$master = $lDB->isMaster;
				$lDB->isMaster = "1";
				foreach ( $editedFields as $data ) {
					$d = explode(":",$data);
					$GLOBALS['lDB']->put("
						UPDATE
							ac_accomm_type
						SET
							ac_accomm_type.fn_cost_centre_id = '" . $d[1] . "'
						WHERE
							ac_accomm_type.ac_accomm_type_ix = '" . $d[0] . "'
					");
				}
				$lDB->isMaster = $master;
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" )	{
				$filterSQL = "";
			} elseif($filterField == "fn_cost_centre") {
				if(empty($filterText)) {
					$filterSQL .= "
						AND fn_cost_centre.fn_cost_centre_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(fn_cost_centre.fn_cost_centre_code LIKE '" . $lDB->like($filterText) . "')
							OR (fn_cost_centre.fn_cost_centre_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(fn_cost_centre.fn_cost_centre_code, ': ', fn_cost_centre.fn_cost_centre_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$sortSQL = " " . $sortData[0] . " " . $sortData[1] . ", ";
			break;
	}
}	

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

// In order to keep all the properties and accommodation types in order we have
// to jump through loops.
$property_master_list = $GLOBALS['lDB']->get("SELECT pr_business_id FROM pr_business WHERE pr_bus_inactive_yn = '0' ORDER BY pr_business_parent ASC LIMIT 1",4);

calAcRecurse($property_master_list);
global $calAcRecurseResult;

$p1 = getPropChildren($iUnitID);
$p2 = getPropChildren($iUnitID);

$allProperties	= array_merge($p1,$p2);
$propertyIDs		= array_unique($allProperties);

$tempPropData = $propertyIDs;
$acPropList = array ();
$defaultPropList = array();

foreach ($tempPropData as $item) {
	array_push($acPropList, $item);
}

foreach ( $calAcRecurseResult as $k => $v ) {
	if ( in_array($v, $acPropList) ) {
		array_push($defaultPropList, $v);
	}
}

// Get the accommodation information we need ----------------------------------
$tempAccommIds = array();

foreach ( $defaultPropList as $pID ) {
	$thisAccommId = $GLOBALS['lDB'] -> get("
		SELECT 
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc,
			ac_accomm_type.fn_cost_centre_id,
			pr_persona.pr_name_last,
			fn_cost_centre.fn_cost_centre_code,
			fn_cost_centre.fn_cost_centre_desc
		FROM
			ac_accomm_type
		INNER JOIN pr_business ON
			pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON
			pr_persona.pr_persona_ix = pr_business.pr_business_id
		LEFT JOIN fn_cost_centre ON
			fn_cost_centre.fn_cost_centre_ix = ac_accomm_type.fn_cost_centre_id
		WHERE
			pr_business.pr_business_id = '" . $pID . "'
		" . $filterSQL . "
		ORDER BY
			" . $sortSQL . "
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_sequence
	",2);
	array_push($tempAccommIds,$thisAccommId);
}

$accommIDs = array();

foreach ( $tempAccommIds as $a ) {
	foreach ( $a as $b ) {
		array_push($accommIDs,$b);
	}
}

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre.fn_cost_centre_ind = '2' 
	ORDER BY 
		fn_cost_centre.fn_cost_centre_desc
",2);

$propertyName = "";

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$accommHTML = "";
$hiddenDiv = "";
foreach ( $accommIDs as $a ) {
	// Build the cost centre selection box ---------------------------------------
	$options = "<select id=\"cell2Select" . $a['ac_accomm_type_ix'] . "\" style=\"width: 221px;\">
			<option value=\"\">None</option>		
	";
	foreach ( $costCentres as $cc ) {
		$selected = "";
		if ( $cc['fn_cost_centre_ix'] == $a['fn_cost_centre_id'] ) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"$cc[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($cc['fn_cost_centre_code'].": ".$cc['fn_cost_centre_desc'])."</option>\n";
	}
	$options .= "</select>\n";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $a['ac_accomm_type_ix'] . "',1);\" onmouseout=\"hover('" . $a['ac_accomm_type_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $a['ac_accomm_type_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	if ( $propertyName != $a['pr_name_last'] ) {
		$propertyName = $a['pr_name_last'];
		$accommHTML .= "
			<tr>
				<td class=\"bl br colDk\" style=\"width:275px;\">" . t_encodeHTMLField($a['pr_name_last']) . "</td>
				<td class=\"bl br colDk\" style=\"width:225px;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
			</tr>
		";
	}

	$costCentreLabel = t_encodeHTMLField($a['fn_cost_centre_code'] . ": " . $a['fn_cost_centre_desc']);
	if ( $a['fn_cost_centre_code'] == "" && $a['fn_cost_centre_desc'] == "") {
		$costCentreLabel = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$accommHTML .= "
		<tr id=\"" . $a['ac_accomm_type_ix'] . "\" " . $mouseOver . ">
			<td id=\"cell1" . $a['ac_accomm_type_ix'] . "\" class=\"bl br\" style=\"width:275px;\" " . $onClick . ">&nbsp;" . t_encodeHTMLField($a['ac_accomm_desc']) . "</td>
			<td id=\"cell2" . $a['ac_accomm_type_ix'] . "\" class=\"br\" style=\"width:225px;\" " . $onClick . ">" . $costCentreLabel . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>";
		
	$hiddenDiv .= "<span id=\"hidden" . $a['ac_accomm_type_ix'] . "\">" . $options . "</span>\n";
}

$GLOBALS['temp']['accommHTML']	= $accommHTML;
$GLOBALS['temp']['hiddenDiv']		= $hiddenDiv;
$GLOBALS['temp']['unitName']		= $unitName;
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']			= $iUnitID;
