<?php

/**
 * init.form351.php - General Ledger account detail popup - Banks/Cash Points Tab
 * Job: 282
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_banks.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
//				db_rf_bank_inv_set($pr_business_id,$rf_bank_id,$fn_ledger_id_account,$fn_ledger_id_deposit)
			$updateList = array();
			foreach ( $editedFields as $data ) {
				$d = explode(":",$data);
				$bank_ledger_id = db_rf_bank_inv_exists($d[0]);
				$d[1] = str_replace("cell2","account",$d[1]);
				$d[1] = str_replace("cell3","deposit",$d[1]);
				$d[1] = explode("|",$d[1]);
				$d[2] = explode("|",$d[2]);
				for($count=0;$count<sizeof($d[1]);$count++) {
					if(!array_key_exists($d[0],$updateList)) {
						$updateList[$d[0]] = array();
					}
					$updateList[$d[0]]['fn_ledger_'.$d[1][$count].'_id'] = $d[2][$count];
					//db_rf_bank_inv_update($bank_ledger_id,$d[1],$d[2],$iUnitID);
				}
			}
			foreach($updateList as $key=>$item) {
				if(!array_key_exists("fn_ledger_account_id",$item)) {
					$item['fn_ledger_account_id'] = $GLOBALS['lDB']->get("
						SELECT fn_ledger_id_account FROM rf_bank_inv WHERE pr_business_id = '$iUnitID' AND rf_bank_id = '$key'
					",4);
				}
				if(!array_key_exists("fn_ledger_deposit_id",$item)) {
					$item['fn_ledger_deposit_id'] = $GLOBALS['lDB']->get("
						SELECT fn_ledger_id_deposit FROM rf_bank_inv WHERE pr_business_id = '$iUnitID' AND rf_bank_id = '$key'
					",4);
				}
				db_rf_bank_inv_set($iUnitID,$key,$item['fn_ledger_account_id'],$item['fn_ledger_deposit_id']);
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" )	{
				$filterSQL = "";
			} elseif(preg_match("/fn_ledger/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];
			break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$banks = $GLOBALS['lDB']->get("
	SELECT
		pr_bus_bank.rf_bank_id as bankID,
		rf_bank.rf_bank_abbrev,
		rf_bank.rf_bank_acc_name,
		glAcc.fn_ledger_ix AS acc_ledger_ix,
		glAcc.fn_ledger_code AS acc_ledger_code,
		glAcc.fn_ledger_desc AS acc_ledger_desc,
		glDep.fn_ledger_ix AS dep_ledger_ix,
		glDep.fn_ledger_code AS dep_ledger_code,
		glDep.fn_ledger_desc AS dep_ledger_desc
	FROM
		pr_bus_bank
	LEFT JOIN rf_bank ON
		rf_bank.rf_bank_ix = pr_bus_bank.rf_bank_id
	LEFT JOIN rf_bank_inv ON
		rf_bank_inv.rf_bank_id = pr_bus_bank.rf_bank_id AND rf_bank_inv.pr_business_id = '".$iUnitID."'
	LEFT JOIN fn_ledger AS glAcc ON
		glAcc.fn_ledger_ix = rf_bank_inv.fn_ledger_id_account AND glAcc.pr_business_id = '".$iUnitID."'
	LEFT JOIN fn_ledger AS glDep ON 
		glDep.fn_ledger_ix = rf_bank_inv.fn_ledger_id_deposit AND glDep.pr_business_id = '".$iUnitID."'
	WHERE 
		pr_bus_bank.pr_business_id = '" . $iUnitID . "'
	" . $filterSQL . "
	" . $sortSQL . "
",2);

$glCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		fn_ledger
	WHERE
		fn_ledger.pr_business_id = '" . $iUnitID . "' 
	ORDER BY fn_ledger.fn_ledger_code 
",2);

$bankHTML = "";

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$hiddenDiv = "";
if ( count($banks) > 0 ) {
	foreach ( $banks as $b ) {
		// Build the Account GL Code selection box -----------------------------------
		$accOptions = "<select id=\"cell2" . $b['bankID'] . "Select\" style=\"width:170px;\">
			<option value=\"\">None</option>
		";
		foreach ( $glCodes as $g ) {
			$selected = '';
			if ( $g[0] == $b['acc_ledger_ix'] ) {
				$selected = ' selected="selected"';
			}
			$accOptions .= '<option value="' . $g[0] . '"' . $selected . '>' . t_encodeHTMLField($g[1] . ': ' . $g[2]) . '</option>';
		}
		$accOptions .= '</select>';
	
		// Build the Deposit GL Code selection box -----------------------------------
		$depOptions = "<select id=\"cell3" . $b['bankID'] . "Select\" style=\"width:145px;\">
			<option value=\"\">None</option>			
		";
		foreach ( $glCodes as $g ) {
			$selected = '';
			if ( $g[0] == $b['dep_ledger_ix'] ) {
				$selected = ' selected="selected"';
			}
			$depOptions .= '<option value="' . $g[0] . '"' . $selected . '>' . t_encodeHTMLField($g[1] . ': ' . $g[2]) . '</option>';
		}
		$depOptions .= '</select>';

		if($allowEdit) {
			$mouseOver = 'style="cursor: pointer;" onmouseover="hover(\'' . $b['bankID'] . '\',1);" onmouseout="hover(\'' . $b['bankID'] . '\',0);"';
			$onClick = 'onclick="glEdit(\'' . $b['bankID'] . '\',event);"';
		} else {
			$mouseOver = "";
			$onClick = "";
		}

		$accDesc = t_encodeHTMLField($b['acc_ledger_code'] . ": " . $b['acc_ledger_desc']);
		if ( $b['acc_ledger_code'] == "" ) {
			$accDesc = "<span class=\"txti txtg\">Click to set GL code</span>";
		}

		$depDesc = t_encodeHTMLField($b['dep_ledger_code'] . ": " . $b['dep_ledger_desc']);
		if ( $b['dep_ledger_code'] == "" ) {
			$depDesc = "<span class=\"txti txtg\">Click to set GL code</span>";
		}
	
		$bankHTML .= '
			<tr id="' . $b['bankID'] . '" ' . $mouseOver . '>
				<td id="cell1' . $b['bankID'] . '" class="bl br" style="width:175px;" ' . $onClick . '>' . t_encodeHTMLField($b['rf_bank_acc_name']) . '</td>
				<td id="cell2' . $b['bankID'] . '" class="br" style="width:175px;" ' . $onClick . '>' . $accDesc . '</td>
				<td id="cell3' . $b['bankID'] . '" class="br" style="width:150px;" ' . $onClick . '>' . $depDesc . '</td>
				<td class="br"><img src="/resource/Resrequest/Application/public/img/1x1.gif" /></td>
			</tr>';
			
		$hiddenDiv .= '<span id="cell2' . $b['bankID'] . 'Hidden">' . $accOptions . '</span>';
		$hiddenDiv .= '<span id="cell3' . $b['bankID'] . 'Hidden">' . $depOptions . '</span>';
	}
} else {
	$bankHTML = '<td colspan="3" align="center" class="lastCell txti">There are no Banks/Cashpoints associated with this invoicing unit.</td>';
}
$GLOBALS['temp']['bankHTML']		= $bankHTML;
$GLOBALS['temp']['hiddenDiv']		= $hiddenDiv;
$GLOBALS['temp']['unitName']		= $unitName;
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']			= $iUnitID;
