<?php

/**
 * init.form352.php - General Ledger account detail popup - Extra Categories Tab
 * Job: 283
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_extra_categories.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);

			foreach ( $editedFields as $data ) {
				$d = explode(":",$data);
				$ac_extra_cat_inv_ix = db_ac_extra_cat_inv_exists($d[0],$iUnitID);


				$d[1] = str_replace("cell2","fn_cost_centre_1_id",$d[1]);
				$d[1] = str_replace("cell3","fn_cost_centre_2_id",$d[1]);
				$d[1] = str_replace("cell4","fn_ledger_id",$d[1]);
				$d[1] = explode("|",$d[1]);
				$d[2] = explode("|",$d[2]);

				if($ac_extra_cat_inv_ix) {
					db_ac_extra_cat_inv_update($ac_extra_cat_inv_ix,$d[1],$d[2]);
				} else {
					// If the user has only entered the Cost Centre or the GL Code, we need
					// to poulate the missing values to make the insert work
					$fields = array("fn_cost_centre_1_id","fn_cost_centre_2_id","fn_ledger_id");

					foreach( $fields as $f ) {
						$input_arr[$f] = "";
						for( $i = 0; $i < count($d[1]); $i++ ) {
							if ( $f == $d[1][$i] ) {
								$input_arr[$f] = $d[2][$i];
							}
						}
					}
					db_ac_extra_cat_inv_insert($d[0],$iUnitID,$input_arr['fn_cost_centre_1_id'],$input_arr['fn_cost_centre_2_id'],$input_arr['fn_ledger_id']);
				}
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_cost_centre|fn_ledger/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			/*$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];*/
			break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre.fn_cost_centre_ind <> '2' 
",2);

$costCentres2 = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre.fn_cost_centre_ind = '2' 
",2);

$glCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		fn_ledger
	WHERE
		fn_ledger.pr_business_id = '" . $iUnitID . "'
	ORDER BY 
		fn_ledger.fn_ledger_code
",2);

$extraCatData = $GLOBALS['lDB']->get("
	SELECT
		ac_extra_category.ac_extra_category_ix,
		ac_extra_category.ac_extra_cat_desc,
		fn_cost_centre_1.fn_cost_centre_ix AS fn_cost_centre_1_ix,
		fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_1_code,
		fn_cost_centre_1.fn_cost_centre_desc AS fn_cost_centre_1_desc,
		fn_cost_centre_2.fn_cost_centre_ix AS fn_cost_centre_2_ix,
		fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_2_code,
		fn_cost_centre_2.fn_cost_centre_desc AS fn_cost_centre_2_desc,
		ac_extra_cat_inv.fn_cost_centre_2_id,
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		ac_extra_category
		LEFT JOIN ac_extra_cat_inv ON ac_extra_category.ac_extra_category_ix = ac_extra_cat_inv.ac_extra_category_id 
			AND	ac_extra_cat_inv.pr_business_id = '" . $iUnitID . "'
		LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = ac_extra_cat_inv.fn_cost_centre_1_id
		LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = ac_extra_cat_inv.fn_cost_centre_2_id
		LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = ac_extra_cat_inv.fn_ledger_id 
	WHERE
		1
	" . $filterSQL . "
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "ac_extra_cat_desc";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $extraCatData as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$extraCatHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	// Build the Cost Centre selection box ---------------------------------------
	$options = "<select id=\"cell2" . $extraCatData[$k]['ac_extra_category_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $costCentres as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $extraCatData[$k]['fn_cost_centre_1_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_code'].": ".$c['fn_cost_centre_desc'])."</option>\n";
	}
	$options .= "</select>\n";

	// Build the Cost Centre selection box ---------------------------------------
	$options2 = "<select id=\"cell3" . $extraCatData[$k]['ac_extra_category_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $costCentres2 as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $extraCatData[$k]['fn_cost_centre_2_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$options2 .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_code'].": ".$c['fn_cost_centre_desc'])."</option>\n";
	}
	$options2 .= "</select>\n";
	
	// Build the GL Code selection box -------------------------------------------
	$glOptions = "<select id=\"cell4" . $extraCatData[$k]['ac_extra_category_ix'] . "Select\" style=\"width:140px;\">
			<option value=\"\">None</option>			
	";
	foreach ( $glCodes as $g ) {
		$selected = "";
		if ( $g['fn_ledger_ix'] == $extraCatData[$k]['fn_ledger_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$glOptions .= "<option value=\"$g[fn_ledger_ix]\" $selected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	}
	$glOptions .= "</select>\n";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $extraCatData[$k]['ac_extra_category_ix'] . "',1);\" onmouseout=\"hover('" . $extraCatData[$k]['ac_extra_category_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $extraCatData[$k]['ac_extra_category_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$costCentreLabel = t_encodeHTMLField($extraCatData[$k]['fn_cost_centre_1_code'] . ": " .$extraCatData[$k]['fn_cost_centre_1_desc']);
	if ( $extraCatData[$k]['fn_cost_centre_1_code'] == "" && $extraCatData[$k]['fn_cost_centre_1_desc'] == "" ) {
		$costCentreLabel = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$costCentreLabel2 = t_encodeHTMLField($extraCatData[$k]['fn_cost_centre_2_code'] . ": " .$extraCatData[$k]['fn_cost_centre_2_desc']);
	if ( $extraCatData[$k]['fn_cost_centre_2_code'] == "" && $extraCatData[$k]['fn_cost_centre_2_desc'] == "" ) {
		$costCentreLabel2 = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$ledgerLabel = t_encodeHTMLField($extraCatData[$k]['fn_ledger_code'] . ": " . $extraCatData[$k]['fn_ledger_desc']);
	if ( $extraCatData[$k]['fn_ledger_code'] == "" ) {
		$ledgerLabel = "<span class=\"txti txtg\">Click here to assign a GL Code</span>";
	}

	$extraCatHTML .= "
		<tr id=\"" . $extraCatData[$k]['ac_extra_category_ix'] . "\" " . $mouseOver . ">
			<td id=\"cell1" . $extraCatData[$k]['ac_extra_category_ix'] . "\" class=\"bl br\" style=\"width:105px;\" " . $onClick . ">" . t_encodeHTMLField($extraCatData[$k]['ac_extra_cat_desc']) . "</td>
			<td id=\"cell2" . $extraCatData[$k]['ac_extra_category_ix'] . "\" class=\"br\" style=\"width:125px;\" " . $onClick . ">" . $costCentreLabel . "</td>
			<td id=\"cell3" . $extraCatData[$k]['ac_extra_category_ix'] . "\" class=\"br\" style=\"width:125px;\" " . $onClick . ">" . $costCentreLabel2 . "</td>
			<td id=\"cell4" . $extraCatData[$k]['ac_extra_category_ix'] . "\" class=\"br\" style=\"width:145px;\" " . $onClick . ">" . $ledgerLabel . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
	";
		
	$hiddenDiv .= "
		<span id=\"cell2" . $extraCatData[$k]['ac_extra_category_ix'] . "Hidden\">" . $options . "</span>
		<span id=\"cell3" . $extraCatData[$k]['ac_extra_category_ix'] . "Hidden\">" . $options2 . "</span>
		<span id=\"cell4" . $extraCatData[$k]['ac_extra_category_ix'] . "Hidden\">" . $glOptions . "</span>
	";
}

$GLOBALS['temp']['extraCatHTML']	= $extraCatHTML;
$GLOBALS['temp']['hiddenDiv']			= $hiddenDiv;
$GLOBALS['temp']['unitName']			= $unitName;
$GLOBALS['temp']['fun_job_id']		= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']				= $iUnitID;
