<?php

/**
 * init.form353.php - General Ledger account detail popup - Extras Tab
 * Job: 284
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_extras.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['filterArg'] = "";
$GLOBALS['temp']['sortArg'] = "";

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$d = explode(":",$data);
				$ac_extra_inv_ix = db_ac_extra_inv_exists($d[0],$iUnitID);


				$d[1] = str_replace("cell2","fn_cost_centre_1_id",$d[1]);
				$d[1] = str_replace("cell3","fn_cost_centre_2_id",$d[1]);
				$d[1] = str_replace("cell4","fn_ledger_id",$d[1]);
				$d[1] = explode("|",$d[1]);
				$d[2] = explode("|",$d[2]);

				//debug($d[1],$d[2]);

				if ( $ac_extra_inv_ix ) {
					db_ac_extra_inv_update($ac_extra_inv_ix,$d[1],$d[2],$iUnitID);
				} else {
					// If the user has only entered the Cost Centre or the GL Code, we need
					// to poulate the missing values to make the insert work
					$fields = array("fn_cost_centre_1_id","fn_cost_centre_2_id","fn_ledger_id");

					foreach( $fields as $f ) {
						$input_arr[$f] = "";
						for( $i = 0; $i < count($d[1]); $i++ ) {
							if ( $f == $d[1][$i] ) {
								$input_arr[$f] = $d[2][$i];
							}
						}
					}
					db_ac_extra_inv_insert($d[0],$input_arr['fn_cost_centre_1_id'],$input_arr['fn_cost_centre_2_id'],$input_arr['fn_ledger_id'],$iUnitID);
				}
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$GLOBALS['temp']['filterArg'] = $_SERVER['argv'][3];
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_cost_centre|fn_ledger/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$GLOBALS['temp']['sortArg'] = $_SERVER['argv'][3];
			/*$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];*/
			break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre.fn_cost_centre_ind <> '2' 
	ORDER BY 
		fn_cost_centre.fn_cost_centre_desc
",2);

$costCentres2 = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre.fn_cost_centre_ind = '2' 
	ORDER BY 
		fn_cost_centre.fn_cost_centre_desc
",2);

$glCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		fn_ledger
	WHERE
		fn_ledger.pr_business_id = '" . $iUnitID . "'
	ORDER BY 
		fn_ledger.fn_ledger_code
",2);

$sqlFrom = "
	FROM
		ac_extra
		LEFT JOIN ac_extra_inv ON ac_extra_inv.ac_extra_id = ac_extra.ac_extra_ix 
			AND ac_extra_inv.pr_business_id = '$iUnitID'
		LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = ac_extra_inv.fn_cost_centre_1_id
		LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = ac_extra_inv.fn_cost_centre_2_id
		LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = ac_extra_inv.fn_ledger_id 
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
		LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN ac_extra_cat_inv ON ac_extra_cat_inv.ac_extra_category_id = ac_extra.ac_extra_category_id
			AND ac_extra_cat_inv.pr_business_id = '$iUnitID'
		LEFT JOIN fn_cost_centre AS fn_cost_centre_1_cat ON fn_cost_centre_1_cat.fn_cost_centre_ix = ac_extra_cat_inv.fn_cost_centre_1_id
		LEFT JOIN fn_cost_centre AS fn_cost_centre_2_cat ON fn_cost_centre_2_cat.fn_cost_centre_ix = ac_extra_cat_inv.fn_cost_centre_2_id
		LEFT JOIN fn_ledger AS fn_ledger_cat ON fn_ledger_cat.fn_ledger_ix = ac_extra_cat_inv.fn_ledger_id 
	WHERE
		rf_currency.rf_currency_ix IS NOT NULL
		$filterSQL	
";

$showInactive = $_SERVER['argv'][5];
if($showInactive == "1") {
	$GLOBALS['temp']['showInactiveChecked'] = "checked";
} else {
	$GLOBALS['temp']['showInactiveChecked'] = "";
	$sqlFrom .= "
		AND ac_extra.ac_inactive_yn = '0'
	";
}


$totalRows = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	$sqlFrom
",4);
$page = $_SERVER['argv'][4];
if($page == "" || !is_numeric($page)) {
	$page = 1;
}
$pageLength = 30;
$GLOBALS['temp']['pageCount'] = ceil($totalRows/$pageLength);
$GLOBALS['temp']['pageNum'] = $page;
$GLOBALS['temp']['nextPageNum'] = $page+1;
$GLOBALS['temp']['prevPageNum'] = $page-1;

if ($page == 1) {
	$GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
} else {
	$GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
}
if ($page >= $GLOBALS['temp']['pageCount']) {
	$GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
} else {
	$GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
}
$totalPages = ceil($totalRows/$pageLength);
if (($totalPages - $page) < 2 ) {
	$startPage = $totalPages - 2;
} elseif($page < 4) {
	$startPage = 4;
} else {
	$startPage = $page;
}
$pageList = "";
if ($page != 1) {
	$pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
} else {
	$pageList = "<B>1</B>";
}
for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
	if ($count == $page) {
		$pageList .= ", <B>$count</B>";
	} else {
		$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
	}
}
if (($totalPages - $page) > 3 ) {
	$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
}
$GLOBALS['temp']['pageList'] = $pageList;

$limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
$GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);


// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "ac_ext_desc";
	$sort_order = "ASC";
}

$extras = $GLOBALS['lDB']->get("
	SELECT
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_desc,
		fn_cost_centre_1.fn_cost_centre_ix AS fn_cost_centre_1_ix,
		fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_1_code,
		fn_cost_centre_1.fn_cost_centre_desc AS fn_cost_centre_1_desc,
		fn_cost_centre_2.fn_cost_centre_ix AS fn_cost_centre_2_ix,
		fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_2_code,
		fn_cost_centre_2.fn_cost_centre_desc AS fn_cost_centre_2_desc,
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc,
		fn_cost_centre_1_cat.fn_cost_centre_ix AS fn_cost_centre_1_cat_ix,
		fn_cost_centre_1_cat.fn_cost_centre_code AS fn_cost_centre_1_cat_code,
		fn_cost_centre_1_cat.fn_cost_centre_desc AS fn_cost_centre_1_cat_desc,
		fn_cost_centre_2_cat.fn_cost_centre_ix AS fn_cost_centre_2_cat_ix,
		fn_cost_centre_2_cat.fn_cost_centre_code AS fn_cost_centre_2_cat_code,
		fn_cost_centre_2_cat.fn_cost_centre_desc AS fn_cost_centre_2_cat_desc,
		fn_ledger_cat.fn_ledger_ix AS fn_ledger_cat_ix,
		fn_ledger_cat.fn_ledger_code AS fn_ledger_cat_code,
		fn_ledger_cat.fn_ledger_desc AS fn_ledger_cat_desc,
		ac_extra.ac_inactive_yn
		$sqlFrom
	ORDER BY
		$sort_field $sort_order
	$limit
",2);
$keys = array_keys($extras);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$extraHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	// Build the Cost Centres selection box --------------------------------------
	$ccOptions = "<select id=\"cell2" . $extras[$k]['ac_extra_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $costCentres as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $extras[$k]['fn_cost_centre_1_ix'] ) {
			$selected = ' selected="selected"';
		}
		$ccOptions .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_code'].": ".$c['fn_cost_centre_desc'])."</option>\n";
	}
	$ccOptions .= "</select>\n";

	// Build the Cost Centres selection box --------------------------------------
	$ccOptions2 = "<select id=\"cell3" . $extras[$k]['ac_extra_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $costCentres2 as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $extras[$k]['fn_cost_centre_2_ix'] ) {
			$selected = ' selected="selected"';
		}
		$ccOptions2 .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_code'].": ".$c['fn_cost_centre_desc'])."</option>\n";
	}
	$ccOptions2 .= "</select>\n";
	

	// Build the GL Code selection box -------------------------------------------
	$glOptions = "<select id=\"cell4" . $extras[$k]['ac_extra_ix'] . "Select\" style=\"width:140px;\">
			<option value=\"\">None</option>			
	";
	foreach ( $glCodes as $g ) {
		$selected = "";
		if ( $g['fn_ledger_ix'] == $extras[$k]['fn_ledger_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$glOptions .= "<option value=\"$g[fn_ledger_ix]\" $selected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	}
	$glOptions .= "</select>\n";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $extras[$k]['ac_extra_ix'] . "',1);\" onmouseout=\"hover('" . $extras[$k]['ac_extra_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $extras[$k]['ac_extra_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$costCentreLabel = t_encodeHTMLField($extras[$k]['fn_cost_centre_1_code'] . ": " . $extras[$k]['fn_cost_centre_1_desc']);
	if ( $extras[$k]['fn_cost_centre_1_code'] == "" ) {
		if($extras[$k]['fn_cost_centre_1_cat_code'] == "") {
			$costCentreLabel = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
		} else {
			$costCentreLabel = "<span class=\"txti txtg\">".$extras[$k]['fn_cost_centre_1_cat_code'] . ": " . $extras[$k]['fn_cost_centre_1_cat_desc']."</span>";
		}
	}

	$costCentreLabel2 = t_encodeHTMLField($extras[$k]['fn_cost_centre_2_code'] . ": " . $extras[$k]['fn_cost_centre_2_desc']);
	if ( $extras[$k]['fn_cost_centre_2_code'] == "" ) {
		if($extras[$k]['fn_cost_centre_2_cat_code'] == "") {
			$costCentreLabel2 = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
		} else {
			$costCentreLabel2 = "<span class=\"txti txtg\">".$extras[$k]['fn_cost_centre_2_cat_code'] . ": " . $extras[$k]['fn_cost_centre_2_cat_desc']."</span>";
		}
	}

	$ledgerLabel = t_encodeHTMLField($extras[$k]['fn_ledger_code'] . ": " . $extras[$k]['fn_ledger_desc']);
	if ( $extras[$k]['fn_ledger_code'] == "" ) {
		if($extras[$k]['fn_ledger_cat_code'] == "") {
			$ledgerLabel = "<span class=\"txti txtg\">Click here to assign a GL Code</span>";
		} else {
			$ledgerLabel = "<span class=\"txti txtg\">".$extras[$k]['fn_ledger_cat_code'] . ": " . $extras[$k]['fn_ledger_cat_desc']."</span>";
		}
	}

	$ac_ext_desc = t_encodeHTMLField($extras[$k]['ac_ext_desc']);
	if($extras[$k]['ac_inactive_yn'] == "1") {
		$ac_ext_desc = "<span class=\"txti txtgr\">$ac_ext_desc</span>";
	}

	$extraHTML .= "
		<tr id=\"" . $extras[$k]['ac_extra_ix'] . "\" " . $mouseOver . ">\n
			<td id=\"cell1" . $extras[$k]['ac_extra_ix'] . "\" class=\"bl br\" style=\"width:105px;\" " . $onClick . ">" . $ac_ext_desc . "</td>
			<td id=\"cell2" . $extras[$k]['ac_extra_ix'] . "\" class=\"br\" style=\"width:125px;\" " . $onClick . ">" . $costCentreLabel . "</td>
			<td id=\"cell3" . $extras[$k]['ac_extra_ix'] . "\" class=\"br\" style=\"width:125px;\" " . $onClick . ">" . $costCentreLabel2 . "</td>
			<td id=\"cell4" . $extras[$k]['ac_extra_ix'] . "\" class=\"br\" style=\"width:145px;\" " . $onClick . ">" . $ledgerLabel . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>\n";

	$hiddenDiv .= "<span id=\"cell2" . $extras[$k]['ac_extra_ix'] . "Hidden\">" . $ccOptions . "</span>\n";
	$hiddenDiv .= "<span id=\"cell3" . $extras[$k]['ac_extra_ix'] . "Hidden\">" . $ccOptions2 . "</span>\n";
	$hiddenDiv .= "<span id=\"cell4" . $extras[$k]['ac_extra_ix'] . "Hidden\">" . $glOptions . "</span>\n";
}

$GLOBALS['temp']['extraHTML']		= $extraHTML;
$GLOBALS['temp']['hiddenDiv']		= $hiddenDiv;
$GLOBALS['temp']['unitName']		= $unitName;
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']			= $iUnitID;
