<?php

/**
 * init.form354.php - General Ledger account detail popup - Rate Component Tab
 * Job: 285
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_rate_component.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$d = explode(":",$data);

				$d[1] = str_replace("cell2","fn_cost_centre_2_id",$d[1]);
				$d[1] = str_replace("cell3","fn_ledger_id",$d[1]);
				$d[1] = explode("|",$d[1]);
				$d[2] = explode("|",$d[2]);

				$values = array();
				foreach($d[1] as $fKey=>$field) {
					$values[$field] = $d[2][$fKey];
				}

				$rt_component_inv_ix = db_rt_component_inv_exists($d[0],$iUnitID);
				$rt_component_inv = $lDB->get("
					SELECT
						rt_component_inv.fn_cost_centre_2_id,
						rt_component_inv.fn_ledger_id
					FROM
						rt_component_inv
					WHERE
						rt_component_inv.rt_component_inv_ix = '$rt_component_inv_ix'
				",1);

				if(!array_key_exists("fn_ledger_id",$values)) {
					$values['fn_ledger_id'] = $rt_component_inv['fn_ledger_id'];
				}
				if(!array_key_exists("fn_cost_centre_2_id",$values)) {
					$values['fn_cost_centre_2_id'] = $rt_component_inv['fn_cost_centre_2_id'];
				}
				if ( $rt_component_inv_ix ) {
					db_rt_component_inv_update($rt_component_inv_ix, $values['fn_cost_centre_2_id'], $values['fn_ledger_id'], $iUnitID);
				} else {
					db_rt_component_inv_insert($d[0],$values['fn_cost_centre_2_id'],$values['fn_ledger_id'],$iUnitID);
				}
			}
			break;

		case ("copy") :
			$sourceUnitID = $_SERVER['argv'][3];
			$codes = $GLOBALS['lDB']->get("
				SELECT
					rt_component_inv.rt_component_id,
					rt_component_inv.fn_cost_centre_2_id,
					rt_component_inv.fn_ledger_id
				FROM
					rt_component_inv
				WHERE
					rt_component_inv.rt_component_inv_inactive_yn = '0'
				AND
					pr_business_id = '" . $sourceUnitID . "'
			",2);

			foreach ( $codes as $c ) {
				db_rt_component_inv_insert($c[0],$c[1],$c[2],$iUnitID);
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_cost_centre|fn_ledger/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];
			break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$costCentres2 = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '$iUnitID'
	AND 
		fn_cost_centre.fn_cost_centre_ind = '2' 
	ORDER BY 
		fn_cost_centre.fn_cost_centre_desc
",2);

$glCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		fn_ledger
	WHERE
		fn_ledger.pr_business_id = '$iUnitID'
	ORDER BY 
		fn_ledger.fn_ledger_code
",2);

$rateComponents = $GLOBALS['lDB']->get("
	SELECT
		rt_component.rt_component_ix,
		rt_component.rt_component_desc,
		fn_cost_centre.fn_cost_centre_ix AS fn_cost_centre_2_ix,
		fn_cost_centre.fn_cost_centre_code AS fn_cost_centre_2_code,
		fn_cost_centre.fn_cost_centre_desc AS fn_cost_centre_2_desc,
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		rt_component
		LEFT JOIN rt_component_inv ON
			rt_component_inv.rt_component_id = rt_component.rt_component_ix 
			AND rt_component_inv.pr_business_id = '$iUnitID'
		LEFT JOIN fn_cost_centre ON fn_cost_centre.fn_cost_centre_ix = rt_component_inv.fn_cost_centre_2_id
		LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rt_component_inv.fn_ledger_id
	WHERE
		rt_component.rt_component_inactive_yn = '0'
	" . $filterSQL . " 
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "rt_component_desc";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $rateComponents as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$rateCompHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	// Build the Cost Centres selection box --------------------------------------
	$ccOptions2 = "<select id=\"cell2" . $rateComponents[$k]['rt_component_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $costCentres2 as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $rateComponents[$k]['fn_cost_centre_2_ix'] ) {
			$selected = ' selected="selected"';
		}
		$ccOptions2 .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_code'].": ".$c['fn_cost_centre_desc'])."</option>\n";
	}
	$ccOptions2 .= "</select>\n";
	

	// Build the GL Code selection box -------------------------------------------
	$glOptions = "<select id=\"cell3" . $rateComponents[$k]['rt_component_ix'] . "Select\" style=\"width:140px;\">
			<option value=\"\">None</option>			
	";
	foreach ( $glCodes as $g ) {
		$selected = "";
		if ( $g['fn_ledger_ix'] == $rateComponents[$k]['fn_ledger_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$glOptions .= "<option value=\"$g[fn_ledger_ix]\" $selected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	}
	$glOptions .= "</select>\n";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $rateComponents[$k]['rt_component_ix'] . "',1);\" onmouseout=\"hover('" . $rateComponents[$k]['rt_component_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $rateComponents[$k]['rt_component_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$costCentreLabel2 = t_encodeHTMLField($rateComponents[$k]['fn_cost_centre_2_code'] . ": " . $rateComponents[$k]['fn_cost_centre_2_desc']);
	if ( $rateComponents[$k]['fn_cost_centre_2_code'] == "" ) {
		$costCentreLabel2 = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$ledgerLabel = t_encodeHTMLField($rateComponents[$k]['fn_ledger_code'] . ": " . $rateComponents[$k]['fn_ledger_desc']);
	if ( $rateComponents[$k]['fn_ledger_code'] == "" ) {
		$ledgerLabel = "<span class=\"txti txtg\">Click here to assign a GL Code</span>";
	}

	$rateCompHTML .= "
		<tr id=\"" . $rateComponents[$k]['rt_component_ix'] . "\" " . $mouseOver . ">\n
			<td id=\"cell1" . $rateComponents[$k]['rt_component_ix'] . "\" class=\"bl br\" style=\"width:200px;\" " . $onClick . ">" . t_encodeHTMLField($rateComponents[$k]['rt_component_desc']) . "</td>
			<td id=\"cell2" . $rateComponents[$k]['rt_component_ix'] . "\" class=\"bl br\" style=\"width:150px;\" " . $onClick . ">" . $costCentreLabel2 . "</td>
			<td id=\"cell3" . $rateComponents[$k]['rt_component_ix'] . "\" class=\"br\" style=\"width:150px;\" " . $onClick . ">" . $ledgerLabel . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>\n";
		
	$hiddenDiv .= "<span id=\"cell2" . $rateComponents[$k]['rt_component_ix'] . "Hidden\">" . $ccOptions2 . "</span>\n";
	$hiddenDiv .= "<span id=\"cell3" . $rateComponents[$k]['rt_component_ix'] . "Hidden\">" . $glOptions . "</span>\n";
}

$GLOBALS['temp']['rateCompHTML']	= $rateCompHTML;
$GLOBALS['temp']['hiddenDiv']			= $hiddenDiv;
$GLOBALS['temp']['unitName']			= $unitName;
$GLOBALS['temp']['fun_job_id']		= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']				= $iUnitID;
