<?php

/**
 * init.form355.php - General Ledger account detail popup - Tax Rates Tab
 * Job: 286
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_tax_rates.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "ORDER BY rf_tax_rate.rf_tax_rate_desc";
$error = array();
$GLOBALS['temp']['showError'] = "display: none;";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$thisData = explode(":",$data);
				$tax_data = explode("|",$thisData[0]);
				$rf_tax_ind	= $tax_data[0];
				$rf_tax_id = $tax_data[1];

				$rf_tax_inv_ix = db_rf_tax_inv_exists($rf_tax_id, $rf_tax_ind, $iUnitID);
				if ( $rf_tax_inv_ix ) {
					db_rf_tax_inv_update($rf_tax_inv_ix, $thisData[1], $iUnitID);
				} else {		
					db_rf_tax_inv_insert($thisData[1], $iUnitID, $rf_tax_id, $rf_tax_ind);
				}
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_ledger/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			break;
	}
}

// Get fn_system setting to determine whether Tax Groups are to be used
$taxGroupsYN = $GLOBALS['lDB']->get("
	SELECT 
		fn_system.fn_sys_tax_groups_yn 
	FROM 
		fn_system 
		INNER JOIN pr_business ON pr_business.fn_system_id = fn_system.fn_system_ix
	WHERE 
		pr_business.pr_business_id = '" . $iUnitID . "'
		",4);

// Display the current data ---------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$GLOBALS['temp']['iUnitID']	 = $iUnitID;

$glCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		fn_ledger
	WHERE
		fn_ledger.pr_business_id = '$iUnitID'
	ORDER BY 
		fn_ledger.fn_ledger_code
",2);


$taxRateCodes = $GLOBALS['lDB']->get("
	SELECT
		rf_tax_rate.rf_tax_rate_ix AS ixfield,
		rf_tax_rate.rf_tax_rate_desc AS descfield,
		'Tax Rate' as typefield,
 		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_ledger.fn_ledger_desc
	FROM
		rf_tax_rate
		LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_id = rf_tax_rate.rf_tax_rate_ix
			AND rf_tax_inv.pr_business_id = '$iUnitID' AND rf_tax_inv.rf_tax_ind = 10
		LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id 
	WHERE
		rf_tax_rate_inactive_yn = '0'
		$filterSQL
",2);

if ($taxGroupsYN == "1"){
	$taxGroupCodes = $GLOBALS['lDB']->get("
		SELECT
			rt_tax_group.rt_tax_group_ix AS ixfield,
			rt_tax_group.rt_tax_group_desc AS descfield,
			'Tax Group' as typefield,
	 		fn_ledger.fn_ledger_ix,
			fn_ledger.fn_ledger_code,
			fn_ledger.fn_ledger_desc
		FROM
			rt_tax_group
			LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_id = rt_tax_group.rt_tax_group_ix
				AND rf_tax_inv.pr_business_id = '$iUnitID' AND rf_tax_inv.rf_tax_ind = 20
			LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id 
		WHERE
			rt_tax_group_inactive_yn = '0'
			
	",2);

	$allTaxCodes = array_merge($taxRateCodes,$taxGroupCodes);
} else {
	$allTaxCodes = $taxRateCodes;
}

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "fn_ledger_code";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $allTaxCodes as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$taxRateHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	$finalKey = (($allTaxCodes[$k]['typefield'] == "Tax Rate") ? "10" : "20")."|".$allTaxCodes[$k]['ixfield'];
	$finalDesc = $allTaxCodes[$k]['descfield'];
	$finalType = $allTaxCodes[$k]['typefield'];

	// Build the GL Code selection box -------------------------------------------
	$glOptions = "<select id=\"cell2" . $finalKey . "Select\" style=\"width:244px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $glCodes as $g ) {
		$selected = "";
		if ( $g['fn_ledger_ix'] == $allTaxCodes[$k]['fn_ledger_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$glOptions .= "<option value=\"$g[fn_ledger_ix]\" $selected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	}
	$glOptions .= "</select>\n";
	
	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $finalKey . "',1);\" onmouseout=\"hover('" . $finalKey . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $finalKey. "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$ledgerLabel = t_encodeHTMLField($allTaxCodes[$k]['fn_ledger_code'] . ": " . $allTaxCodes[$k]['fn_ledger_desc']);
	if ( $allTaxCodes[$k]['fn_ledger_code'] == "" ) {
		$ledgerLabel = "<span class=\"txti txtg\">Click here to assign a GL code</span>";
	}
	
	$taxRateHTML .= "
		<tr id=\"" . $finalKey . "\" " . $mouseOver . ">\n
			<td id=\"cell0" . $finalKey . "\" class=\"bl br\" style=\"width:100px;\" " . $onClick . ">" . $finalType . "</td>
			<td id=\"cell1" . $finalKey . "\" class=\"bl br\" style=\"width:150px;\" " . $onClick . ">" . $finalDesc . "</td>
			<td id=\"cell2" . $finalKey . "\" class=\"br\" style=\"width:250px;\" $onClick>$ledgerLabel</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>\n";

	$hiddenDiv .= "<span id=\"cell2" . $finalKey . "Hidden\">" . $glOptions . "</span>\n";
	
}

$GLOBALS['temp']['unitName'] = $unitName;
$GLOBALS['temp']['taxRateHTML']	= $taxRateHTML;
$GLOBALS['temp']['hiddenDiv'] = $hiddenDiv;
$GLOBALS['temp']['fun_job_id'] = $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID'] = $iUnitID;
