<?php

/**
 * init.form356.php - General Ledger account detail popup - Debtor Codes Tab
 * Job: 287
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_debtor_codes.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "ORDER BY fn_debtor.fn_debtor_code";
$error = array();
$GLOBALS['temp']['showError'] = "display: none;";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

$exists = false;
if ( $_SERVER['argc'] > 2 ) {
	switch ( $_SERVER['argv'][2] ) {
		case ("add") :
			// Process the data to be saved
			$addedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($addedFields);
			foreach ( $addedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = rawurldecode($item);
				}
				$dupe = db_fn_debtor_check_duplicate($thisData[1],$thisData[2],$iUnitID);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_debtor_insert($thisData[1],$thisData[2],$thisData[3],$iUnitID,$thisData[4],$thisData[5]);
				}				
			}
			break;

		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = rawurldecode($item);
				}
				$dupe = db_fn_debtor_check_duplicate($thisData[1],$thisData[2],$iUnitID,$thisData[0]);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_debtor_update($thisData[0],$thisData[1],$thisData[2],$thisData[3],$iUnitID,$thisData[4],$thisData[5]);
				}
			}
			break;

		case ("copy") :
			$sourceUnitID = $_SERVER['argv'][3];
			$codes = $GLOBALS['lDB']->get("
				SELECT
					fn_debtor_code,
					fn_debtor_desc,
					rf_currency_id
				FROM
					fn_debtor
				WHERE
					pr_business_id = '" . $sourceUnitID . "'
			",2);

			foreach ( $codes as $c ) {
				$dupe = db_fn_debtor_check_duplicate($c[0],$c[1],$iUnitID);

				if ( $dupe > 0 ) {
					array_push($error,array($c[0],$c[1]));
				} else {
					db_fn_debtor_insert($c[0],$c[1],$c[2],$iUnitID);
				}
			}		
			break;

		case ("delete") :
			$codes = explode(":",$_SERVER['argv'][3]);
			foreach ( $codes as $c ) {
				// Check if this Debtor Code is used somewhere. If so, set to inactive,
				// rather than deleting it
				$where[$c] = array();
				
				$pr_persona_inv_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_persona_inv WHERE pr_persona_inv.fn_debtor_id = '" . $c . "'",4);
				if ( $pr_persona_inv_count > 0 ) { 
					$exists = true;
					// Get a list of all the pr_persona records that are linked to the debtor code
					$personaIds = $GLOBALS['lDB']->get("
						SELECT
							pr_persona.pr_persona_ix
						FROM
							pr_persona
						INNER JOIN pr_persona_inv ON 
							pr_persona_inv.pr_persona_id = pr_persona.pr_persona_ix
						WHERE
							pr_persona_inv.fn_debtor_id = '" . $c . "'
					",3);
					foreach ( $personaIds as $p ) {
						array_push($where[$c],$p);
					}
				}

				if ( !$exists ) {
					db_fn_debtor_delete('delete',$c);
				}				
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);
			if(empty($filterText)) {
				$filterText = "*";
			}

			if($filterText == "*") {
				$filterSQL = "";
			} else {
				// Looking for a partial match, so field LIKE filterText
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			break;

		case "importUpload":
			$type = $_POST['glUploadType'];
			$uploadData = file($_FILES['glUploadFile']['tmp_name']);
			$data = array();
			$duplicates = [];
			foreach($uploadData as $line) {
				$line = str_getcsv($line);
				if(sizeof($line) < 2) {
					continue; // ignore empty lines
				}
				list($code,$desc) = $line;
				$code = trim($code);
				$desc = trim($desc);
				if($code != "") { // Ignore blank codes
					array_push($data,array(
						'code'=>$code,
						'description'=>$desc,
					));
					$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_debtor WHERE fn_debtor_code = '$code' AND pr_business_id = '$iUnitID'",4);
					if($check > 0) {
						$duplicates[] = [
							'code'=>$code,
							'description'=>$desc
						];
					}					
				}
			}
			session_set("glUploadData",$data);
				
			echo "
				<script language=\"javascript\">
					var records = ".sizeof($data)."
					var duplicates = ".json_encode($duplicates).";
					parent.importGLConfirm(records,duplicates);
				</script>
			";
			die();
			break;
		case "importConfirm":
			if(is_array($_SESSION['glUploadData'])) {
				$data = $_SESSION['glUploadData'];
			} else {
				$data = array();
			}
			$type = $_SERVER['argv'][3];

			foreach($data as $item) {
				$code = $item['code'];
				$desc = $item['description'];
				$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_debtor WHERE fn_debtor_code = '$code' AND pr_business_id = '$iUnitID'",4);
				if($check > 0) {
					$fn_debtor_id = $GLOBALS['lDB']->get("SELECT fn_debtor_ix FROM fn_debtor WHERE fn_debtor_code = '$code' AND pr_business_id = '$iUnitID'",4);
					db_fn_debtor_update($fn_debtor_id,$code,$desc,"",$iUnitID);
				} else {
					db_fn_debtor_insert($code,$desc,"",$iUnitID);
				}
			}
			break;
			
	}
}

// Display the current data ---------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$GLOBALS['temp']['iUnitID']	 = $iUnitID;

$debtorCodes = $GLOBALS['lDB']->get("
	SELECT 
		fn_debtor.fn_debtor_ix,
		fn_debtor.fn_debtor_code,
		fn_debtor.fn_debtor_desc,
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_name,
		rf_currency.rf_currency_symbol,
		fn_debtor.fn_debtor_export_yn,
		fn_debtor.pr_persona_id,
		pr_persona.pr_name_first,
		pr_persona.pr_name_last
	FROM
		fn_debtor
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
		LEFT JOIN pr_persona on pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
	WHERE 
		fn_debtor.pr_business_id = '" . $iUnitID . "'
	AND
		fn_debtor.fn_debtor_inactive_yn = '0'
	" . $filterSQL . "
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "fn_debtor_code";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $debtorCodes as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$currencies = $GLOBALS['lDB']->get("
	SELECT
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_name,
		rf_currency.rf_currency_symbol
	FROM
		rf_currency
	WHERE
		rf_currency.rf_currency_inactive_yn = '0'
	ORDER BY
		rf_currency.rf_currency_name
",2);

$currencyOptions = "
	<option value=\"\">None</option>
";
foreach($currencies as $currency) {
	$currencyOptions .= "<option value=\"$currency[rf_currency_ix]\">$currency[rf_currency_name] ($currency[rf_currency_symbol])</option>\n";
}
$GLOBALS['temp']['currencyOptions'] = $currencyOptions;

$GLOBALS['temp']['exportOptions'] = "
	<option value=\"0\">No</option>
	<option value=\"1\">Yes</option>
";


$debtorCodesHTML = "";
$hiddenDiv = "";
foreach($keys as $k) {

	$currencyOptions = "<select id=\"input3" . $debtorCodes[$k]['fn_debtor_ix'] . "Select\" style=\"width:96px;\">
			<option value=\"\">None</option>	
	";
	foreach ( $currencies as $c ) {
		$selected = "";
		if ( $c['rf_currency_ix'] == $debtorCodes[$k]['rf_currency_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$currencyOptions .= "<option value=\"$c[rf_currency_ix]\" $selected>".t_encodeHTMLField($c['rf_currency_name']." (".$c['rf_currency_symbol']).")</option>\n";
	}
	$currencyOptions .= "</select>\n";

	$pr_name_raw = $pr_name = t_encodeHTMLField(trim($debtorCodes[$k]['pr_name_first'] . " " . $debtorCodes[$k]['pr_name_last']));
	if($pr_name == "") {
		$pr_name = "<span class=\"txti\">None</span>";
		$pr_name_raw = "None";
	}

	$primaryEdit = "<input id=\"input4" . $debtorCodes[$k]['fn_debtor_ix'] . "Name\" type=\"text\" style=\"width:54px\" value=\"$pr_name_raw\" readonly />
		<button id=\"input4" . $debtorCodes[$k]['fn_debtor_ix'] . "\" class=\"button txts\" type=\"button\" style=\"width: 20px; height: 20px;\" onclick=\"getDebtorContact(this);\">
			<img src=\"/resource/Resrequest/Application/public/img/icon_search_16.gif\" width=\"16\" height=\"16\" alt=\"Search\" />
		</button>
		<input id=\"input4" .  $debtorCodes[$k]['fn_debtor_ix'] . "Id\" type=\"hidden\" value=\"".$debtorCodes[$k]['pr_persona_id']."\" />
	";


	$exportNoSelected = "";
	$exportYesSelected = "";
	$exportDesc = "";
	if($debtorCodes[$k]['fn_debtor_export_yn'] == "1") {
		$exportYesSelected = "selected";
		$exportDesc = "Yes";
	} else {
		$exportNosSelected = "selected";
		$exportDesc = "No";
	}
	$exportOptions = "<select id=\"input5" . $debtorCodes[$k]['fn_debtor_ix'] . "Select\" style=\"width:46px;\">
			<option value=\"0\" $exportNoSelected>No</option>
			<option value=\"1\" $exportYesSelected>Yes</option>
		</select>
	";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $debtorCodes[$k]['fn_debtor_ix'] . "',1);\" onmouseout=\"hover('" . $debtorCodes[$k]['fn_debtor_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $debtorCodes[$k]['fn_debtor_ix'] . "',event);\"";
		$checkbox = "<input type=\"checkbox\" id=\"check" . $debtorCodes[$k]['fn_debtor_ix'] . "\" />";
	} else {
		$mouseOver = "";
		$onClick = "";
		$checkbox = "";
	}

	if(!empty($debtorCodes[$k]['rf_currency_ix'])) {
		$currencyLabel = t_encodeHTMLField($debtorCodes[$k]['rf_currency_name'] . " (" . $debtorCodes[$k]['rf_currency_symbol'] . ")");
	} else {
		$currencyLabel = "None";
	}

	$debtorCodesHTML .= "
		<tr id=\"" . $debtorCodes[$k]['fn_debtor_ix'] . "\" " . $mouseOver . ">
			<td class=\"bl br\" style=\"width:26px\">$checkbox</td>
			<td id=\"input1" . $debtorCodes[$k]['fn_debtor_ix'] . "\" class=\"br\" " . $onClick . " style=\"width:125px; overflow:hidden;\">" . t_encodeHTMLField($debtorCodes[$k]['fn_debtor_code']) . "</td>
			<td id=\"input2" . $debtorCodes[$k]['fn_debtor_ix'] . "\" class=\"br\" " . $onClick . " style=\"width:120px; overflow:hidden;\">" . t_encodeHTMLField($debtorCodes[$k]['fn_debtor_desc']) . "</td>
			<td id=\"input3" . $debtorCodes[$k]['fn_debtor_ix'] . "\" class=\"br\" " . $onClick . " style=\"width:90px; overflow:hidden;\">" . $currencyLabel . "</td>
			<td id=\"input4Cell" . $debtorCodes[$k]['fn_debtor_ix'] . "\" class=\"br\" " . $onClick . " style=\"width:85px; overflow:hidden;\">$pr_name</td>
			<td id=\"input5" . $debtorCodes[$k]['fn_debtor_ix'] . "\" class=\"br\" " . $onClick . " style=\"width:50px; overflow:hidden;\" align=\"center\">$exportDesc</td>
			<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
	";

	$hiddenDiv .= "
		<span id=\"input1" . $debtorCodes[$k]['fn_debtor_ix'] . "Hidden\">
			<textarea id=\"input1" . $debtorCodes[$k]['fn_debtor_ix'] . "Value\">" . $debtorCodes[$k]['fn_debtor_code'] . "</textarea>
		</span>\n";	
	$hiddenDiv .= "
		<span id=\"input2" . $debtorCodes[$k]['fn_debtor_ix'] . "Hidden\">
			<textarea id=\"input2" . $debtorCodes[$k]['fn_debtor_ix'] . "Value\">" . $debtorCodes[$k]['fn_debtor_desc'] . "</textarea>
		</span>\n";	
	$hiddenDiv .= "<span id=\"input3" . $debtorCodes[$k]['fn_debtor_ix'] . "Hidden\">" . $currencyOptions . "</span>\n";	
	$hiddenDiv .= "<span id=\"input4" . $debtorCodes[$k]['fn_debtor_ix'] . "Hidden\">" . $primaryEdit . "</span>\n";	
	$hiddenDiv .= "<span id=\"input5" . $debtorCodes[$k]['fn_debtor_ix'] . "Hidden\">" . $exportOptions . "</span>\n";
}

$GLOBALS['temp']['unitName'] 				= $unitName;
$GLOBALS['temp']['debtorCodesHTML']	= $debtorCodesHTML;
$GLOBALS['temp']['hiddenDiv'] = $hiddenDiv;
$GLOBALS['temp']['fun_job_id']			= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']					= $iUnitID;

// Error notification on duplicate --------------------------------------------
if ( count($error) > 0 ) {

	$GLOBALS['temp']['showError'] = "";
	
	$GLOBALS['temp']['errorContents'] = "<span class=\"txtwh txtb\">Some of the data you entered duplicates data in the database already. Below is a list of your input that contains either a duplicate GL Code or a duplicate description:</span><br /><br />\n";

	$GLOBALS['temp']['errorContents'] .= "<table width=\"95%\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\" summary=\"\" class=\"bt br bl\">\n";

	$GLOBALS['temp']['errorContents'] .= "<tr>
																					<thead>
																						<th class=\"colDk bb br\">Debtor Code</th>
																						<th class=\"colDk bb\">Debtor Code Description</th>
																					</thead>
																				</tr>\n";

	foreach ( $error as $e ) {
		$GLOBALS['temp']['errorContents'] .= "<tr>
																						<td class=\"colWh bb br\">" . $e[0] . "</td>
																						<td class=\"colWh bb\">" . $e[1] . "</td>
																					</tr>\n";
	}

	$GLOBALS['temp']['errorContents'] .= "<tr class=\"colLt\">
																					<td colspan=\"2\" align=\"right\">
																						<button type=\"button\" class=\"button\" onclick=\"closeError();\">
																							<img src=\"/resource/Resrequest/Application/public/img/icon_ok_16.gif\" width=\"16\" height=\"16\" alt=\"OK\" />
																							<span>OK</span>
																						</button>
																					</td>
																				</tr>\n";

	$GLOBALS['temp']['errorContents'] .= "</table>\n";
}

// Error notification on delete -----------------------------------------------
if ( $exists ) {

	$GLOBALS['temp']['showError'] = '';
	
	$GLOBALS['temp']['errorContents'] = "<span class=\"txtwh txtb\">Some of the Debtor Codes you selected to delete are used elsewhere in the system. Below is a list of the codes and who they are linked to:</span><br /><br />\n";

	$GLOBALS['temp']['errorContents'] .= "<table width=\"95%\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\" summary=\"\" class=\"bt br bl\">\n";

	$GLOBALS['temp']['errorContents'] .= "<tr>
																					<thead>
																						<th class=\"colDk bb br\">Debtor Code</th>
																						<th class=\"colDk bb\">Contact</th>
																					</thead>
																				</tr>\n";

	foreach( $where as $code => $contacts ) {
		if ( $contacts ) {
			$glCode = $GLOBALS['lDB']->get("SELECT fn_debtor.fn_debtor_code FROM fn_debtor WHERE fn_debtor.fn_debtor_ix = '" . $code . "'",4);
			
			$GLOBALS['temp']['errorContents'] .= "<tr>
																							<td class=\"colWh bb br\" valign=\"top\">" . $glCode . "</td>\n";

			$GLOBALS['temp']['errorContents'] .= "<td class=\"colWh bb\" valign=\"top\">";

			foreach ( $contacts as $cID ) {
				$contactName = $GLOBALS['lDB']->get("
					SELECT
						IFNULL(CONCAT(CONCAT(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),IFNULL(pr_persona.pr_name_last,pr_persona.pr_name_first))
					FROM
						pr_persona
					WHERE
						pr_persona.pr_persona_ix = '" . $cID . "'
				",4);
				$GLOBALS['temp']['errorContents'] .= $contactName . "<br />";
			}
		}
		$GLOBALS['temp']['errorContents'] .= "</td>\n</tr>\n";
	}

	$GLOBALS['temp']['errorContents'] .= "<tr class=\"colLt\">
																					<td colspan=\"2\" align=\"right\">
																						<button type=\"button\" class=\"button\" onclick=\"closeError();\">
																							<img src=\"/resource/Resrequest/Application/public/img/icon_ok_16.gif\" width=\"16\" height=\"16\" alt=\"OK\" />
																							<span>OK</span>
																						</button>
																					</td>
																				</tr>\n";
	$GLOBALS['temp']['errorContents'] .= "</table>\n";
}
