<?php

/**
 * init.form357.php - General Ledger account detail popup - Contacts/Debtors Tab
 * Job: 288
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_contacts_debtors.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "ORDER BY prName";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['filterArg'] = "";
$GLOBALS['temp']['sortArg'] = "";

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$d = explode(":",$data);
				$pr_persona_inv_ix = db_pr_persona_inv_exists($d[0],$iUnitID);
				if ( $pr_persona_inv_ix ) {
					db_pr_persona_inv_update($pr_persona_inv_ix, $d[1], $iUnitID);
				} else {
					db_pr_persona_inv_insert($d[1], $iUnitID, $d[0]);
				}
			}
			break;

		case ("copy") :
			$sourceUnitID = $_SERVER['argv'][3];
			$codes = $GLOBALS['lDB']->get("
				SELECT
					pr_persona_inv.fn_debtor_id,
					pr_persona_inv.pr_persona_id
				FROM
					pr_persona_inv
				WHERE
					pr_business_id = '" . $sourceUnitID . "'
			",2);

			foreach ( $codes as $c ) {
				db_pr_persona_inv_insert($c[0],$iUnitID,$c[1]);
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$GLOBALS['temp']['filterArg'] = $_SERVER['argv'][3];
			$filterField = $rawFilterField = rawurldecode($glFilterData[0]);
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_debtor/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				// When filtering on the contact name,  some cases only have a pr_name_first
				// or pr_name_last. We need to be able to filter on these fields, as well as
				// the concatenation of both if they both are not null. Fun.
				if ( $filterField == "prName" ) {
					$filterField = "TRIM(IFNULL(CONCAT(CONCAT(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),IFNULL(pr_persona.pr_name_last,pr_persona.pr_name_first)))";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($rawFilterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);

			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$GLOBALS['temp']['sortArg'] = $_SERVER['argv'][3];
			$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];
			break;
	}
}

// Display the current data ---------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$debtorCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_debtor.fn_debtor_ix,
		fn_debtor.fn_debtor_code,
		fn_debtor.fn_debtor_desc
	FROM
		fn_debtor
	WHERE
		fn_debtor.pr_business_id = '$iUnitID'
	ORDER BY 
		fn_debtor.fn_debtor_code
",2);

$sqlFrom = "
	FROM
		pr_persona
		LEFT JOIN pr_persona_inv ON
			pr_persona_inv.pr_persona_id = pr_persona.pr_persona_ix 
			AND pr_persona_inv.pr_business_id = '$iUnitID'
		LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = pr_persona_inv.fn_debtor_id
		INNER JOIN fn_folio ON fn_folio.fn_folio_to_id = pr_persona.pr_persona_ix
		$filterSQL
";

$totalRows = $GLOBALS['lDB']->get("
	SELECT
		COUNT(DISTINCT pr_persona_ix)
	$sqlFrom
",4);
$page = $_SERVER['argv'][4];
if($page == "" || !is_numeric($page)) {
	$page = 1;
}
$pageLength = 30;
$GLOBALS['temp']['pageCount'] = ceil($totalRows/$pageLength);
$GLOBALS['temp']['pageNum'] = $page;
$GLOBALS['temp']['nextPageNum'] = $page+1;
$GLOBALS['temp']['prevPageNum'] = $page-1;

$pageList = "";

		if ($page == 1) {
			$GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
		} else {
			$GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
		}
		if ($page >= $GLOBALS['temp']['pageCount']) {
			$GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
		} else {
			$GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
		}
		$totalPages = ceil($totalRows/$pageLength);
		if (($totalPages - $page) < 2 ) {
			$startPage = $totalPages - 2;
		} elseif($page < 4) {
			$startPage = 4;
		} else {
			$startPage = $page;
		}
		if ($page != 1) {
			$pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
		} else {
			$pageList = "<B>1</B>";
		}
		for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
			if ($count == $page) {
				$pageList .= ", <B>$count</B>";
			} else {
				$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
			}
		}
		if (($totalPages - $page) > 3 ) {
			$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
		}
		$GLOBALS['temp']['pageList'] = $pageList;

		$limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
		$GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);


if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "prName";
	$sort_order = "ASC";
}		
$contactDebtors = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		pr_persona.pr_persona_ix AS contactDebtorID,
		TRIM(IFNULL(CONCAT(CONCAT(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),IFNULL(pr_persona.pr_name_last,pr_persona.pr_name_first))) as prName,
		fn_debtor.fn_debtor_ix,
		fn_debtor.fn_debtor_code,
		fn_debtor.fn_debtor_desc,
		CONCAT(fn_debtor.fn_debtor_code,' ',fn_debtor.fn_debtor_desc) AS debtorCode
	$sqlFrom
	ORDER BY $sort_field $sort_order
	$limit
",2);

// Natural sorting ------------------------------------------------------------

/*$sort_array = array();
foreach ( $contactDebtors as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);*/
$keys = array_keys($contactDebtors);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$contactDebtorHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	// Build the Debtor Code selection box ---------------------------------------
	$options = "<select id=\"cell2Select" . $contactDebtors[$k]['contactDebtorID'] . "\" style=\"width: 190px;\">
			<option value=\"\">None</option>	
		
	";
	foreach ( $debtorCodes as $d ) {
		$selected = "";
		if ( $d[0] == $contactDebtors[$k]['fn_debtor_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"" . $d[0] . "\"" . $selected . ">" . t_encodeHTMLField($d[1] . ": " . $d[2]) . "</option>\n";
	}
	$options .= "</select>\n";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $contactDebtors[$k]['contactDebtorID'] . "',1);\" onmouseout=\"hover('" . $contactDebtors[$k]['contactDebtorID'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $contactDebtors[$k]['contactDebtorID'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$desc = t_encodeHTMLField($contactDebtors[$k]['fn_debtor_code'] . ": " . $contactDebtors[$k]['fn_debtor_desc']);
	if ( $contactDebtors[$k]['fn_debtor_code'] == "" ) {
		$desc = "<span class=\"txti txtg\">Click here to assign a Debtor Code</span>";
	}

	$contactDebtorHTML .= "
		<tr id=\"" . $contactDebtors[$k]['contactDebtorID'] . "\" " . $mouseOver . ">
			<td id=\"cell1" . $contactDebtors[$k]['contactDebtorID'] . "\" class=\"bl br\" style=\"width:300px;\" " . $onClick . ">" . t_encodeHTMLField(trim($contactDebtors[$k]['prName'])) . "</td>
			<td id=\"cell2" . $contactDebtors[$k]['contactDebtorID'] . "\" class=\"br\" style=\"width:200px;\" " . $onClick . ">" . $desc . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>\n";
		
	$hiddenDiv .= "<span id=\"hidden" . $contactDebtors[$k]['contactDebtorID'] . "\">" . $options . "</span>\n";
}

$GLOBALS['temp']['contactDebtorHTML']	= $contactDebtorHTML;
$GLOBALS['temp']['hiddenDiv']					= $hiddenDiv;
$GLOBALS['temp']['unitName']					= $unitName;
$GLOBALS['temp']['fun_job_id']				= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']						= $iUnitID;
