<?php

/**
 * init.form358.php - Financial Ledger batch interface
 * Job: 278
 * Function: 101
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_batch.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],15,"");

$iUnitID = $_SERVER['argv'][1];
$unitCode = $GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$iUnitID'",4);
$unitCurrency = $GLOBALS['lDB']->get("
	SELECT
		rf_currency.rf_currency_symbol
	FROM
		pr_business
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
	WHERE
		pr_business.pr_business_id = '$iUnitID'
",4);
$GLOBALS['temp']['fn_system_email'] = $GLOBALS['lDB']->get("
	SELECT fn_system_email FROM pr_business WHERE pr_business_id = '$iUnitID'
",4);
$GLOBALS['temp']['pr_email'] = $GLOBALS['lDB']->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$GLOBALS[userid]'",4);
$error = array();
$GLOBALS['temp']['showError'] = "display: none;";

$batchStateFilter = $_SERVER['argv'][4];
$batchYearFilter = trim($_SERVER['argv'][6]);
$debtorExportCurrency = $_SERVER['argv'][7];
$debtorExportType = $_SERVER['argv'][8];
switch($debtorExportType) {
case "all":
	$debtorExportType = TRAN_DEBTOR_EXPORT_ALL;
	break;
case "new":
	$debtorExportType = TRAN_DEBTOR_EXPORT_NEW;
	break;
case "old":
	$debtorExportType = TRAN_DEBTOR_EXPORT_OLD;
	break;
}
$debtorExportMark = $_SERVER['argv'][9];
$allowSelect = $_SERVER['argv'][10];
$GLOBALS['temp']['allowSelect'] = $allowSelect;

$exportTo = $_SERVER['argv'][11];
$exportFromEmail = $_SERVER['argv'][12];
$exportToEmail = $_SERVER['argv'][13];

$options = $_SERVER['argv'][14];

define("REP_VIEW_HTML",0);
define("REP_VIEW_PDF",1);
define("REP_EMAIL_PDF",2);
define("REP_SEND_PDF",3);
define("REP_VIEW_CSV",4);

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
    $renderMode = "pdf";
    $renderType = "view";
    break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
	break;
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = "Batch list";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,14))."+$newOptions";

	$GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal -------------------------------------------------------------
	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
  
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$GLOBALS['temp']['princName']	= $principalInfo['name'];
	$GLOBALS['temp']['fax']				= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel']	= $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);

	$GLOBALS['temp']['emailTo'] = "";
}


$GLOBALS['temp']['batchStateOpenSelected'] = "";
$GLOBALS['temp']['batchStateClosedSelected'] = "";
$GLOBALS['temp']['batchStateDeletedSelected'] = "";
$GLOBALS['temp']['batchStateAllSelected'] = "";
switch($batchStateFilter) {
case "open":
default:
	$GLOBALS['temp']['batchStateOpenSelected'] = "selected";
	$batchStateSQL = "
		AND fn_batch.fn_batch_closed_yn != '1'
		AND fn_batch.ad_delete_date = '0000-00-00 00:00:00'		
	";
	break;
case "closed":
	$GLOBALS['temp']['batchStateClosedSelected'] = "selected";
	$batchStateSQL = "
		AND fn_batch.fn_batch_closed_yn != '0'
		AND fn_batch.ad_delete_date = '0000-00-00 00:00:00'		
	";
	break;
case "deleted":
	$GLOBALS['temp']['batchStateDeletedSelected'] = "selected";
	$batchStateSQL = "
		AND fn_batch.ad_delete_date != '0000-00-00 00:00:00'		
	";
	break;
case "all":
	$GLOBALS['temp']['batchStateAllSelected'] = "selected";
	$batchStateSQL = "";
	break;
}

if ( $_SERVER['argc'] > 2 ) {
	switch ( $_SERVER['argv'][2] ) {
		case ("add") :
			// Process the data to be saved
			$addedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($addedFields);
			foreach ( $addedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = addslashes(rawurldecode($item));
				}
				$dupe = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						fn_batch
					WHERE
						fn_batch_name = '$thisData[1]'
						AND pr_business_id = '$iUnitID'
				",4); //0; //db_fn_debtor_check_duplicate($thisData[1],$thisData[2],$iUnitID);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_batch_insert($iUnitID, $thisData[1], $thisData[2], $thisData[3]);
				}
			}
			break;

		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = addslashes(rawurldecode($item));
				}
				$dupe = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						fn_batch
					WHERE
						fn_batch_name = '$thisData[1]'
						AND pr_business_id = '$iUnitID'
						AND fn_batch_ix != '$thisData[0]'
				",4);//0; //db_fn_debtor_check_duplicate($thisData[1],$thisData[2],$iUnitID,$thisData[0]);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_batch_update($thisData[0],$thisData[1],$thisData[2],$thisData[3]);
				}
			}
			break;

		case ("delete") :
			$codes = explode(":",$_SERVER['argv'][3]);
			foreach ( $codes as $c ) {
				// Check if this Debtor Code is used somewhere. If so, set to inactive,
				// rather than deleting it
				
				db_fn_batch_delete_by_id($c);
			}
			break;
		case "export":
			$fn_batch_id = $_SERVER['argv'][3];
			$batchWhere = "
				1
			";
			$batchDate = date("YmdHis");
			if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
				$batchWhere = "
					fn_batch.fn_batch_ix = '$fn_batch_id'
				";
				$batchDate = date("YmdHis", strtotime($lDB->get("SELECT ad_modify_date FROM fn_batch WHERE fn_batch_ix = '" . $lDB->escape($fn_batch_id) . "'",4)));
			}
			$unixLines = true;
			$useTabs = false;
			$fixFilename = true;
			$exportType = 'csv';
			$contentType = 'text/plain';
			switch($_SERVER['argv'][5]) {
			case "debtor":
				$csvFile = tran_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."__debtor_generic_".date("YmdHis");
				$unixLines = false;
				break;	
			case "tran":
				$csvFile = tran_export($batchWhere);
				$filename = $unitCode."_".$fn_batch_id."_journal_generic_".date("YmdHis");
				break;
			case "tran_item":
				$csvFile = tran_item_export($batchWhere,false,true);
				$filename = $unitCode."_".$fn_batch_id."_journal_generic_".date("YmdHis");
				break;
			case "tran_item_summary":
				$csvFile = tran_item_export($batchWhere,true,true);
				$filename = $unitCode."_".$fn_batch_id."_journal_generic_".date("YmdHis");
				break;
			case "pastel_partner_tran":
				$csvFile = tran_pastel_journal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_journal_partner_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_partner_debtor":
				$csvFile = tran_pastel_partner_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_partner_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_partner_11_tran":
				$csvFile = tran_pastel_journal($fn_batch_id,11);
				$filename = $unitCode."_".$fn_batch_id."_journal_partner_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_partner_11_tran_summary":
				$csvFile = tran_pastel_journal_summary($fn_batch_id,11);
				$filename = $unitCode."_".$fn_batch_id."_journal_summary_partner_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_partner_11_debtor":
				$csvFile = tran_pastel_partner_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark,11);
				$filename = $unitCode."_".$fn_batch_id."_debtor_partner_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_partner_11_dtr_journal":
				$csvFile = tran_pastel_journal($fn_batch_id, 11, true, $iUnitID);
				$filename = $unitCode."_".$fn_batch_id."debtor_journal_partner_".date("YmdHis");
				$unixLines = false;
				break;
			case "quickbooks_direct_tran":
				$csvFile = tran_quickbooks_journal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_journal_quickbooks_direct_".date("YmdHis").".iif";
				$unixLines = false;
				$useTabs = true;
				$fixFilename = false;
				break;
			case "quickbooks_direct_debtor":	// Using the new Quickbooks 13 debtor export for this
				$csvFile = tran_quickbooks_zed_axis_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_quickbooks_direct_".date("YmdHis");
				$unixLines = false;
				break;	
			case "quickbooks_direct_invoice":
				$csvFile = tran_quickbooks_direct_invoice($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_invoice_quickbooks_direct_".date("YmdHis").".txt";
				$unixLines = false;
				$useTabs = true;
				$fixFilename = false;
				break;
			case "quickbooks_direct_credit_note":
				$csvFile = tran_quickbooks_direct_credit_memo($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_credit_memo_quickbooks_direct_".date("YmdHis").".txt";
				$unixLines = false;
				$useTabs = true;
				$fixFilename = false;
				break;
			case "quickbooks_direct_payment":
				$csvFile = tran_quickbooks_direct_payment($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_payment_quickbooks_direct_".date("YmdHis").".txt";
				$unixLines = false;
				$useTabs = true;
				$fixFilename = false;
				break;
			case "pastel_evolution_tran":
				$csvFile = tran_pastel_evolution_journal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_journal_evolution_".date("YmdHis");
				$unixLines = false;
				$useTabs = true;
				break;
			case "pastel_evolution_7_tran":
				$csvFile = tran_pastel_evolution_7_journal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_journal_evolution_7_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_evolution_7_journal":
				$sageEvolutionInterface = new SageEvolutionInterface($GLOBALS['lDB'], $iUnitID);
				$csvFile = $sageEvolutionInterface->exportJournal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_gl_journal_evolution_7_".date("YmdHis");
				$unixLines = false;
				break;
			case "pastel_evolution_debtor":
			case "pastel_evolution_7_debtor":
				$csvFile = tran_pastel_evolution_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_evolution_".date("YmdHis");
				$unixLines = false;
				break;	
			case "quickbooks_zed_axis_journals_debtor":
				$csvFile = tran_quickbooks_zed_axis_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_quickbooks_zed_axis_".date("YmdHis");
				$unixLines = false;
				break;	
			case "quickbooks_zed_axis_invoices_debtor":
				$csvFile = tran_quickbooks_zed_axis_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_quickbooks_zed_axis_".date("YmdHis");
				$unixLines = false;
				break;	
			case "quickbooks_zed_axis_journals_tran":
				$csvFile = tran_quickbooks_zed_axis_journal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_journal_quickbooks_zed_axis_".date("YmdHis");
				$unixLines = false;
				break;
			case "quickbooks_zed_axis_invoices_invoice":
				$csvFile = tran_quickbooks_zed_axis_invoice($fn_batch_id,$iUnitID);
				$filename = $unitCode."_".$fn_batch_id."_invoice_quickbooks_zed_axis_".date("YmdHis");
				$unixLines = false;
				break;
			case "quickbooks_zed_axis_invoices_payment":
				$csvFile = tran_quickbooks_zed_axis_payment($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_payment_quickbooks_zed_axis_".date("YmdHis");
				$unixLines = false;
				break;		
			case "quickbooks_zed_axis_invoices_refund":
				$csvFile = tran_quickbooks_zed_axis_journal($fn_batch_id, true);
				$filename = $unitCode."_".$fn_batch_id."_refund_quickbooks_zed_axis_".date("YmdHis");
				break;		
			case "sage_tran":
				$csvFile = tran_sage_journal($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_journal_sage_".date("YmdHis");
				$unixLines = false;
				break;
			case "sage_debtor":
				$csvFile = tran_sage_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_sage_".date("YmdHis");
				$unixLines = false;
				break;
			case "tally_invoice":
				$output = tran_tally_invoice($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_invoice_tally_".date("YmdHis").".xml";
				$exportType = "string";
				$contentType = "text/xml";
				break;
			case "sage_300_debtor":
				$csvFile = tran_sage_300_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_debtor_sage_300_".date("YmdHis");
				$unixLines = false;
				break;
			case "sage_300_credit_note":
				error_log("Case sage_300_credit_note");
				$csvFile = sage_300_tran_item_export($batchWhere,false,true,true);
				$filename = $unitCode."_".$fn_batch_id."_credit_note_sage_300_".date("YmdHis");
				break;
			case "sage_300_tran":
				$csvFile = sage_300_tran_item_export($batchWhere,false,true);
				$filename = $unitCode."_".$fn_batch_id."_invoice_sage_300_".date("YmdHis");
				break;
			case "sage_300_tran_summary":
				$csvFile = sage_300_tran_item_export($batchWhere,true,true);
				$filename = $unitCode."_".$fn_batch_id."_journal_summary_sage_300_".date("YmdHis");
				break;
			case "sage_300_payment":
				error_log("Case sage_300_payment");
				$csvFile = sage_300_payment($batchWhere);
				$filename = $unitCode."_".$fn_batch_id."_payment_sage_300_".date("YmdHis");
				break;
			case "xero_invoice":
				$xeroInterface = new XeroInterface($GLOBALS['lDB'], $iUnitID);
				$csvFile = $xeroInterface->exportInvoices($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_invoice_xero_".date("YmdHis");
				break;
			case "great_plains_invoice":
				$greatPlainsInterface = new GreatPlainsInterface($GLOBALS['lDB'], $iUnitID);
				$csvFile = $greatPlainsInterface->exportInvoices($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_invoice_great_plains_".date("YmdHis");
				break;
			case "twinfields_invoice":
				$twinfieldsInterface = new TwinfieldsInterface($GLOBALS['lDB'], $iUnitID);
				$csvFile = $twinfieldsInterface->exportInvoices($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_invoice_twinfields_".date("YmdHis");
				break;
			case "netsuite_debtor":
				$csvFile = tran_netsuite_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark);
				$filename = $unitCode."_".$fn_batch_id."_".$batchDate."_debtor";
				break;
			case "netsuite_payment":
				$csvFile = tran_netsuite_payment($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_".$batchDate."_payment";
				break;
			case "netsuite_invoice":
				$filename = $unitCode."_".$fn_batch_id."_".$batchDate."_invoice";
				$csvFiles = tran_netsuite_invoice($fn_batch_id);
				$files = [];
				foreach($csvFiles as $name=>$content) {
					$files[$filename . "_" . $name . ".csv"] = csv_array_to_text($content,$unixLines,$useTabs);
				}
				unset($csvFiles);
				$exportType = "zip";
				break;
			case "netsuite_all":
				$filename = $unitCode."_".$fn_batch_id."_".$batchDate;
				$csvFiles = tran_netsuite_invoice($fn_batch_id);
				$files = [];
				foreach($csvFiles as $name=>$content) {
					$files[$filename . "_invoice_" . $name . ".csv"] = csv_array_to_text($content,$unixLines,$useTabs);
				}
				unset($csvFiles);
				$files[$filename . "_payment.csv"] = csv_array_to_text(tran_netsuite_payment($fn_batch_id),$unixLines,$useTabs);
				$files[$filename . "_debtor.csv"] = csv_array_to_text(tran_netsuite_debtor($fn_batch_id,$iUnitID,$debtorExportCurrency,$debtorExportType,$debtorExportMark),$unixLines,$useTabs);
				$exportType = "zip";
			case "sun_systems_tran_summary":
				$sunSystemsInterface = new SunSystemsInterface($GLOBALS['lDB'], $iUnitID);
				$csvFile = $sunSystemsInterface->exportTransactionSummary($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_tran_summary_sun_systems_".date("YmdHis");
				break;
			case "sun_systems_tran":
				$sunSystemsInterface = new SunSystemsInterface($GLOBALS['lDB'], $iUnitID);
				$csvFile = $sunSystemsInterface->exportTransactions($fn_batch_id);
				$filename = $unitCode."_".$fn_batch_id."_transactions_sun_systems_".date("YmdHis");
				break;
			}
			if($exportTo == "file") {
				if ($exportType == "csv") {
					csv_output($filename,$csvFile,true,$unixLines,$useTabs,$fixFilename);
				} else {
					if(headers_sent()) {
						echo('Some data has already been output to browser, can\'t send file');
					}
					header('Content-Type: '.$contentType);
					if($exportType == "zip") {
						header("Content-Transfer-Encoding: Binary");
						$zip = new Zip($files);
						$output = $zip->export();
						$contentType = "application/zip";
						$filename .= ".zip";
					}
					header("Cache-control: private");
					header('Content-Length: '.strlen($output));
					$filename = strtolower(str_replace(" ","_",$filename));
					header("Content-Disposition: attachment; filename=$filename");
					echo $output;
					flush();
					die();
				}
			} else {
				$headers = $headers = "From: ".$GLOBALS['princName']."<$exportFromEmail>\r\n";
				$subject = $filename;
				$message = "Export attached.";
				if($exportType == "zip") {
					$data = [];
					foreach($files as $name=>$content) {
						$data[] = [
							'filename'=>$name,
							'data'=>$content
						];
					};
				} else {
					if($fixFilename) {
						$filename = csv_fix_filename($filename,$useTabs);
					}
					$data = csv_array_to_text($csvFile,$unixLines,$useTabs);
				}
				$error = email($exportFromEmail, $exportToEmail, $subject, $headers, $message, 0, 0, "", "ResRequest User", $data, $filename);
				if (!$error) {
					echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				} else {
					echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				}
				die();
			}
			break;
		case "close":
			db_fn_batch_close($_SERVER['argv'][3]);
			break;
		case "open":
			db_fn_batch_open($_SERVER['argv'][3]);
			break;

	}
}

// Display the current data ---------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$GLOBALS['temp']['currentMonth']	= date("m");
$GLOBALS['temp']['currentYear']		= date("Y");

$batchYearFilterSQL = "";
if($batchYearFilter != "") {
	$batchYearFilterSQL = "
		AND fn_batch.fn_year_id = '$batchYearFilter'
	";
}

$batches = $GLOBALS['lDB']->get("
	SELECT 
		fn_batch.fn_batch_ix,
		fn_batch.fn_batch_name,
		fn_batch.fn_batch_closed_yn,
		fn_batch.fn_batch_note,
		fn_year.fn_year_ix,
		fn_year.fn_year_desc,
		fn_year.fn_year_status_ind,
		fn_batch.ad_delete_date
	FROM
		fn_batch
		LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
	WHERE 
		fn_batch.pr_business_id = '" . $iUnitID . "'
		$batchStateSQL
		$batchYearFilterSQL
	ORDER BY fn_batch.ad_create_date
",2);


if($renderMode == "html") {
	if(db_pr_business_ledger_allow($iUnitID)) {
		$allowEdit = true;
		$GLOBALS['temp']['allowEditStyle'] = "";
	} else {
		$allowEdit = false;
		$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
	}

	$batchesHTML = "";
	$select_button_style = "";
	if($allowSelect == "1") {
		$select_button_style = "visibility: hidden;";
	}
	foreach ( $batches as $d ) {

		$mouseOver	= 'onmouseover="hover(\'' . $d['fn_batch_ix'] . '\',1);" onmouseout="hover(\'' . $d['fn_batch_ix'] . '\',0);" style="cursor: pointer;"';
		$onClick		= 'onclick="editBatch(\'' . $d['fn_batch_ix'] . '\',event);"';

		if($d['fn_batch_closed_yn'] != "1") {
			$closed = "&nbsp;";
			$select_button = '<input type="button" class="button bGoNew16" style="width:20px; height:20px; '.$select_button_style.'" onmouseout="nd();" onmouseover="overlib(\'Click to select this batch.\',LEFT,WIDTH,130);" onclick="setBatch(\''.$d['fn_batch_ix'].'\',\''.t_encodeOverlib($d['fn_batch_name']).'\');" value="" />';
			$close_button = "<input type=\"button\" class=\"button bCheckIn\" style=\"width:20px; height:20px; background-position: center;\" onmouseout=\"nd();\" onmouseover=\"overlib('Click to close this batch.',LEFT,WIDTH,130);\" onclick=\"closeBatch('".$d['fn_batch_ix']."');\" />";
		} else {
			$closed = "x";
			$select_button = '<input type="button" class="button bGoNew16" style="width:20px; height:20px;'.$select_button_style.'" onmouseout="nd();" onmouseover="overlib(\'You must re-open this batch before you may select it.\',LEFT,WIDTH,200);" />';
			if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] < 15) {
				$close_button = "<input type=\"button\" class=\"button bCheckOut\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('You must have management access in order to re-open this batch.',LEFT,WIDTH,200);\" />";
			} else {
				if($d['fn_year_status_ind'] == "20") {
					$close_button = "<input type=\"button\" class=\"button bCheckOut\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('The year must be re-opened in order to re-open this batch.',LEFT,WIDTH,200);\" />";
				} else {
					$close_button = "<input type=\"button\" class=\"button bCheckOut\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('Click to open this batch.',LEFT,WIDTH,130);\" onclick=\"openBatch('".$d['fn_batch_ix']."');\" />";
				}
			}
		}	

		$export_button = '<input id="exportButton'.$d['fn_batch_ix'].'" type="button" class="button bExport16" style="width:20px; height:20px;" onmouseout="nd();" onmouseover="overlib(\'Click to export this batch.\',LEFT,WIDTH,130);" onclick="toggleExport(\''.$d['fn_batch_ix'].'\');" />';

		$audit_button = '<input type="button" class="button bAudit" style="width:20px; height:20px;" onmouseout="nd();" onmouseover="overlib(\'Click to view the audit trail of this batch.\',LEFT,WIDTH,130);" onclick="auditBatch(\''.$d['fn_batch_ix'].'\');" />';
	
		if($d['ad_delete_date'] != "0000-00-00 00:00:00") {
			$textClass = "txtg txti";
			$noteDisabled = "disabled";
			$buttons = $export_button . '&nbsp;' . $audit_button;
			$deleteCheck = '<td align="center" onmouseout="nd();" onmouseover="overlib(\'Unable to select this batch for deletion because it is already deleted.\',WIDTH,150);"><input type="checkbox" disabled></td>';
		} else {
			$textClass = "";
			$noteDisabled = "";
			$buttons = $select_button . '&nbsp;' . $close_button. '&nbsp;' . $export_button . '&nbsp;' . $audit_button;
			$tranCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_tran WHERE fn_tran.fn_batch_id = '$d[fn_batch_ix]'",4);
			if($tranCount > 0) {
				$deleteCheck = '<td align="center" onmouseout="nd();" onmouseover="overlib(\'Unable to select this batch for deletion because there are transactions linked to it.\',WIDTH,150);"><input type="checkbox" disabled></td>';
			} else {
				$deleteCheck = '<td align="center"><input type="checkbox" id="check' . $d['fn_batch_ix'] . '" /></td>';
			}
		}

		if(!$allowEdit) {
			$mouseOver = "";
			$onClick = "";
			$deleteCheck = "<td align=\"center\">&nbsp;</td>";
			$textClass = "txtg";
			$buttons = $export_button . "&nbsp;" . $audit_button;
		}

		if(trim($d['fn_year_desc']) != "") {
			$yearDesc = $d['fn_year_desc'] . '<input type="hidden" id="yearHidden' . $d['fn_batch_ix'] . '" value="'. $d['fn_year_ix'] .'" />';
		} else {
			$yearDesc = '&nbsp;<input type="hidden" id="yearHidden' . $d['fn_batch_ix'] . '" value="" />';
		}

		$lastExport = $GLOBALS['lDB']->get("
			SELECT
				ad_create_date
			FROM
				ad_batch
			WHERE
				fn_batch_id = '$d[fn_batch_ix]'
				AND ad_batch_action_ind = '".DB_AD_BATCH_EXPORT."'
			ORDER BY
			ad_create_date DESC
		",4);
		$export_dateTime = makeDateTime($lastExport);
		$export_date = $export_dateTime['date'];
		if(trim($export_date) == "") {
			$export_date = "<span class=\"$textClass txti\">not posted</span>";
		}

		// Add &nbsp; to replace blank data so the HTML table will display correctly
		if ( $export_date == "" ) {
			$export_date = "&nbsp;";
		}

		if(trim($d['fn_batch_note']) != "") {
			$batch_note = '<textarea readonly '.$noteDisabled.' style="width:110px;">'.$d['fn_batch_note'].'</textarea><textarea class="collapse" id="noteHidden' . $d['fn_batch_ix'] . '">' . $d['fn_batch_note'] . '</textarea>';
		} else {
			$batch_note = '&nbsp;<input type="hidden" id="noteHidden' . $d['fn_batch_ix'] . '" value=\'\' />';
		}

		$invoiceInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
				AND fn_tran_item.fn_tran_item_amt >= 0
		",1);
		fixAmtDisplay($invoiceInfo['value'],2);

		$creditNoteInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
				AND fn_tran_item.fn_tran_item_amt < 0
		",1);
		fixAmtDisplay($creditNoteInfo['value'],2);

		$paymentInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
				AND fn_tran_item.fn_tran_item_amt <= 0
		",1);
		fixAmtDisplay($paymentInfo['value'],2);

		$refundInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
				AND fn_tran_item.fn_tran_item_amt > 0
		",1);
		fixAmtDisplay($refundInfo['value'],2);

		$depositInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_DEPOSIT."'
		",1);
		fixAmtDisplay($depositInfo['value'],2);

		$poReceiptInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_SUPP."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PO_RECEIPT."'
		",1);
		fixAmtDisplay($poReceiptInfo['value'],2);
		$returnsInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_SUPP."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_RETURN."'
		",1);
		fixAmtDisplay($returnsInfo['value'],2);
		$costofSalesInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_EXPENSE."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_COS."'
		",1);
		fixAmtDisplay($costofSalesInfo['value'],2);
		$issuesInfo = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*) AS count,
				ABS(SUM(fn_tran_item.fn_tran_item_amt)) AS value
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_EXPENSE."' 
			WHERE
				fn_tran.fn_batch_id = '$d[fn_batch_ix]'
				AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_ISSUE."'
		",1);
		fixAmtDisplay($issuesInfo['value'],2);

		$batchesHTML .= '
			<tr id="' . $d['fn_batch_ix'] . '" ' . $mouseOver . '>
				'.$deleteCheck.'
				<td style="height:40px;" id="ix' . $d['fn_batch_ix'] . '" ' . $onClick . ' class="' . $textClass . '">' . $d['fn_batch_ix'] . '</td>
				<td id="name' . $d['fn_batch_ix'] .'" ' . $onClick . ' class="' . $textClass . '">' . $d['fn_batch_name'] . '</td>
				<td id="year' . $d['fn_batch_ix'] .'" ' . $onClick . ' class="' . $textClass . '">' . $yearDesc . '</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$invoiceInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$invoiceInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$creditNoteInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$creditNoteInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$paymentInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$paymentInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$refundInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$refundInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$depositInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$depositInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$poReceiptInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$poReceiptInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$returnsInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$returnsInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$costofSalesInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$costofSalesInfo['count'].'</td>
				<td class="uk-text-center" onmouseover="overlib(\''.$issuesInfo['value'].' '.$unitCurrency.'\',WIDTH,100);" onmouseout="nd();">'.$issuesInfo['count'].'</td>
				<td id="closed' . $d['fn_batch_ix'] . '" ' . $onClick . ' align="center" class="' . $textClass . '">' . $closed . '</td>
				<td id="exportDate' . $d['fn_batch_ix'] . '" ' . $onClick . ' align="center" class="' . $textClass . '">' . $export_date . '</td>
				<td id="note' . $d['fn_batch_ix'] . '" ' . $onClick . ' align="center">' . $batch_note . '</td>
				<td class="lastCell" align="center" style="text-indent: -20px">' . $buttons . '</td>
			</tr>
		';
	}
	if($batchesHTML == "") {
		$batchesHTML = "
			<tr>
				<td colspan=\"13\" class=\"txti\" align=\"center\">No records found</td>
			</tr>
		";
	}

	$activeYears = $GLOBALS['lDB']->get("
		SELECT
			fn_year.fn_year_ix,
			fn_year.fn_year_status_ind
		FROM
			fn_year
		WHERE
			fn_year.pr_business_id = '$iUnitID'
	",2);
	$activeYear = "";
	if(sizeof($activeYears) == 1) {
		$activeYear = $activeYears[0]['fn_year_ix'];
	}
	$years = $GLOBALS['lDB']->get("
		SELECT
			fn_year.fn_year_ix,
			fn_year.fn_year_desc
		FROM
			fn_year
		WHERE	
			fn_year.pr_business_id = '$iUnitID'
		ORDER BY 
			fn_year.fn_year_desc ASC
	",2);

	$yearOptions = "";
	$batchYearFilterOptions = "";
	$batchYearFound = false;
	foreach($years as $year) {
		$selected = "";
		if($year['fn_year_ix'] == $activeYear) {
			$selected = "selected";
		}
		$yearOptions .= "<option $selected value=\"$year[fn_year_ix]\">$year[fn_year_desc]</option>";

		$selected = "";
		if($year['fn_year_ix'] == $batchYearFilter) {
			$selected = "selected";
			$batchYearFound = true;
		}
		$batchYearFilterOptions .= "<option $selected value=\"$year[fn_year_ix]\">$year[fn_year_desc]</option>";
	}
	$GLOBALS['temp']['yearOptions'] = $yearOptions;
	$GLOBALS['temp']['batchYearFilterOptions'] = $batchYearFilterOptions;
	if($batchYearFound) {
		$GLOBALS['temp']['batchYearFilterAllSelected'] = "selected";
	} else {
		$GLOBALS['temp']['batchYearFilterAllSelected'] = "";
	}

	$currencies = $GLOBALS['lDB']->get("
		SELECT
			rf_currency.rf_currency_ix,
			rf_currency.rf_currency_name,
			rf_currency.rf_currency_symbol
		FROM
			rf_currency
		WHERE
			rf_currency.rf_currency_inactive_yn = '0'
		ORDER BY
			rf_currency.rf_currency_name
	",2);
	$currencyOptions = "";
	foreach($currencies as $currency) {
		$currencyOptions .= "<option value=\"$currency[rf_currency_ix]\">$currency[rf_currency_name] ($currency[rf_currency_symbol])</option>\n";
	}
	$GLOBALS['temp']['currencyOptions'] = $currencyOptions;

	// Error notification on duplicates -------------------------------------------
	if ( count($error) > 0 ) {
		$GLOBALS['temp']['showError'] = "";	
		$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the data you entered duplicates data in the database already. Below is a list of your input that contains either a duplicate name:</span><br /><br />';	
		$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';	
		$GLOBALS['temp']['errorContents'] .= '
			<tr>
				<thead>
					<th class="colDk bb br">Batch Name</th>
				</thead>
			</tr>
		';

		foreach ( $error as $e ) {
			$GLOBALS['temp']['errorContents'] .= '
				<tr>
					<td class="colWh bb br">' . $e[0] . '</td>
				</tr>
			';
		}

		$GLOBALS['temp']['errorContents'] .= '
			<tr class="colLt">
				<td colspan="3" align="right">
					<button type="button" class="button" onclick="closeError();">
						<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
						<span>OK</span>
					</button>
				</td>
			</tr>
		';

		$GLOBALS['temp']['errorContents'] .= '</table>';
	}

	$GLOBALS['temp']['unitName'] 		= $unitName;
	$GLOBALS['temp']['batchesHTML']	= $batchesHTML;
	$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];
	$GLOBALS['temp']['iUnitID']			= $iUnitID;
	$GLOBALS['temp']['export_options'] = tran_export_options($iUnitID); 

	$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
}

if($renderMode == "csv") {
	$csvFile = array();

	array_push($csvFile,array("Batch list"));
	array_push($csvFile,array());

	array_push($csvFile,array("Id","Name","Year","Closed","Last Export","Note"));
	foreach($batches as $batch) {
		$lastExport = $GLOBALS['lDB']->get("
			SELECT
				ad_create_date
			FROM
				ad_batch
			WHERE
				fn_batch_id = '$batch[fn_batch_ix]'
				AND ad_batch_action_ind = '".DB_AD_BATCH_EXPORT."'
			ORDER BY
			ad_create_date DESC
		",4);
		$export_dateTime = makeDateTime($lastExport);
		$export_date = $export_dateTime['date'];
		if(trim($export_date) == "") {
			$export_date = "Not Posted";
		}

		array_push($csvFile,array(
			$batch['fn_batch_ix'],
			$batch['fn_batch_name'],
			$batch['fn_year_desc'],
			($batch['fn_batch_closed_yn'] != "1")?"No":"Yes",
			$export_date,
			$batch['fn_batch_note']
		));
	}

	$csvText = "";
	
	foreach ( $csvFile as $csvLine ) {
		$first = true;
		
		foreach ( $csvLine as $csvItem ) {
			if ( !$first ) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"" . str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}

	if ( headers_sent() ) {
		echo('Some data has already been output to browser, can\'t send CSV file');
	}
	
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: ' . strlen($csvText));
	header("Content-Disposition: inline; filename=payments_due_" . chng_date(date("Y-m-d"),"-") . ".csv");
	echo $csvText;
	flush();
	die();
}

if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {

	$pdf = new PDF("Batch List");
	$reportLabel = "Batch List";
	// Main PDF header
	$headerArray = array(
		array('name'=>"Year",'value'=>"Something")
	);	
	$pdf->ReportHeader($reportLabel, $headerArray);
	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetFont('Arial', '', 6);

	$pdf->Row(array(
		array('width'=>"10%",'data'=>"Id",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"10%",'data'=>"Name",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"10%",'data'=>"Year",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"10%",'data'=>"Closed",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"10%",'data'=>"Last Export",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"50%",'data'=>"Name",'border'=>"LRTB",'fill'=>"1")
	));
	foreach($batches as $batch) {
		$lastExport = $GLOBALS['lDB']->get("
			SELECT
				ad_create_date
			FROM
				ad_batch
			WHERE
				fn_batch_id = '$batch[fn_batch_ix]'
				AND ad_batch_action_ind = '".DB_AD_BATCH_EXPORT."'
			ORDER BY
			ad_create_date DESC
		",4);
		$export_dateTime = makeDateTime($lastExport);
		$export_date = $export_dateTime['date'];
		if(trim($export_date) == "") {
			$export_date = "Not Posted";
		}

		$pdf->Row(array(
			array('width'=>"10%",'data'=>$batch['fn_batch_ix'],'border'=>"LRTB"),
			array('width'=>"10%",'data'=>$batch['fn_batch_name'],'border'=>"LRTB"),
			array('width'=>"10%",'data'=>$batch['fn_year_desc'],'border'=>"LRTB"),
			array('width'=>"10%",'data'=>($batch['fn_batch_closed_yn'] != "1")?"No":"Yes",'border'=>"LRTB"),
			array('width'=>"10%",'data'=>$export_date,'border'=>"LRTB"),
			array('width'=>"50%",'data'=>$batch['fn_batch_note'],'border'=>"LRTB")
		));
	}

	if($renderType == "view") {
		$pdf->OutPut();
		die();
	}

	if($renderType == "send") {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

		// close the pdf
		if($pdf->state<3) $pdf->Close();

		/* and now mail it */
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Update report from $fromDate to $toDate.pdf";
		}

		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
		if(!$error) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
			die();
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
			die();
		}
	}
	
}

function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
   }
