<?php

/**
 * init.form359.php - Payment Item Report
 * Job: 291
 * Function: 102 (Report: Payment Item) 
*/


if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}   

$pf_object_id = db_pf_object_by_name("payment_item_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Payment Item Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_payment_item.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],20,"");

$dateType = $_SERVER['argv'][1];
$GLOBALS['temp']['datePaidChecked'] = "checked";
$GLOBALS['temp']['dateRecordedChecked'] = "";
if($dateType == "1") {
	$GLOBALS['temp']['datePaidChecked'] = "";
	$GLOBALS['temp']['dateRecordedChecked'] = "checked";
}
$fromDate = useDate("from", $_SERVER['argv'][2]);
$toDate = useDate("to", $_SERVER['argv'][3]);
$recordFromDate = useDate("recordFrom", $_SERVER['argv'][4]);
$recordToDate = useDate("recordTo", $_SERVER['argv'][5]);
$travelFromDate = useDate("travelFrom",$_SERVER['argv'][14]);
$travelToDate = useDate("travelTo",$_SERVER['argv'][15]);
$checkedTravel = $_SERVER['argv'][16];
$arriveFromDate = useDate("arriveFrom",$_SERVER['argv'][17]);
$arriveToDate = useDate("arriveTo",$_SERVER['argv'][18]);
$checkedArrive = $_SERVER['argv'][19];


$bankFilter = useFilter("bank",$_SERVER['argv'][6],"SELECT rf_bank.rf_bank_acc_name FROM rf_bank WHERE rf_bank.rf_bank_ix =","rv_payment.rf_bank_id",false,"None","0");
$currenciesFilter = useFilter("currencies",$_SERVER['argv'][7],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_payment_item.rf_currency_id",false,false,false);
$methodFilter = useFilter("mthdpay",$_SERVER['argv'][8],"SELECT rf_mthd_pmnt.rf_mthd_pmnt_desc FROM rf_mthd_pmnt WHERE rf_mthd_pmnt.rf_mthd_pmnt_ix =","rv_payment.rf_mthd_pmnt_id",false,false,false);

$folioCheck = $_SERVER['argv'][9];
$invoiceCheck = $_SERVER['argv'][10];
$invoiceFilter = "";
if($folioCheck == "0" && $invoiceCheck == "0") { // Invoice filter default
	$folioCheck = "1";
	$invoiceCheck = "1";
}
if($folioCheck == "1" && $invoiceCheck == "0") { // Uninvoiced folios only
	$invoiceFilter = "
		AND fn_invoice.fn_invoice_ix IS NULL
	";
}
if($folioCheck == "0" && $invoiceCheck == "1") { // Invoiced folios only
	$invoiceFilter = "
		AND fn_invoice.fn_invoice_ix IS NOT NULL
	";
}

$GLOBALS['temp']['checkedTravel'] = "";
if($checkedTravel == 1) {
	$GLOBALS['temp']['checkedTravel'] = "checked";
}

$GLOBALS['temp']['checkedArrive'] = "";
if($checkedArrive == 1) {
	$GLOBALS['temp']['checkedArrive'] = "checked";
}

$GLOBALS['temp']['folioChecked'] = "";
if($folioCheck == "1") {
	$GLOBALS['temp']['folioChecked'] = "checked";
}
$GLOBALS['temp']['invoiceChecked'] = "";
if($invoiceCheck == "1") {
	$GLOBALS['temp']['invoiceChecked'] = "checked";	
}
$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
$GLOBALS['temp']['filterStatus'] = "expand";
if($_SERVER['argv'][11] == "1" && $_SERVER['argc'] > 1) {
	$GLOBALS['temp']['showHideButtonText'] = "<< Show Filters";
	$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
}
$options = $_SERVER['argv'][12];

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = "Payment Item Report";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,12))."+".$newOptions;

	$GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal -------------------------------------------------------------
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
  
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$GLOBALS['temp']['princName']	= $principalInfo['name'];
	$GLOBALS['temp']['fax']				= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel']	= $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);

	$GLOBALS['temp']['emailTo'] = "";
}



$GLOBALS['temp']['dataClass'] = "collapse";
if($_SERVER['argc'] > 1) {
	$dateWhere = "
		(
			(
				rv_payment.rv_pmnt_date >= '".$fromDate['jsDate']."'
				AND rv_payment.rv_pmnt_date <= '".$toDate['jsDate']."'
			)
		)	
	";
	if($dateType == "1") {
		$dateWhere = "
			(
				(
					rv_payment.rv_pmnt_date_created >= '$recordFromDate[jsDate] 00:00:00'
					AND rv_payment.rv_pmnt_date_created <= '$recordToDate[jsDate] 23:59:59'
				)
			)
		";
	}
	
	if($checkedTravel == 1) {
		$dateWhere .= " AND 
			(
				(
					rv_reservation.rv_date_arrive >= '" . $travelFromDate['jsDate'] . "' 
					AND 
					rv_reservation.rv_date_arrive <= '" . $travelToDate['jsDate'] . "'
				)
			OR 
				(
					rv_reservation.rv_date_depart >= '" . $travelFromDate['jsDate'] . "' 
					AND 
					rv_reservation.rv_date_depart <= '".$travelToDate['jsDate']."'
				)
			OR 
				(
					rv_reservation.rv_date_arrive < '" . $travelFromDate['jsDate'] . "' 
					AND 
					rv_reservation.rv_date_depart > '" . $travelToDate['jsDate'] . "'
				)
			)
		";
	}
	if($checkedArrive == 1) {
		$dateWhere .= "
			AND rv_reservation.rv_date_arrive >= '" . $arriveFromDate['jsDate'] . "' 
			AND rv_reservation.rv_date_arrive <= '" . $arriveToDate['jsDate'] . "'
		";
	}
	
	$list = $lDB->get("
		SELECT DISTINCT
			rv_payment.rv_payment_ix,
			rv_payment_item.rv_reservation_id,
			fn_invoice.fn_invoice_ix,
			rv_reservation.rv_res_name,
			rv_payment.rv_pmnt_date_created,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			rf_bank.rf_bank_acc_name,
			rv_payment.rv_pmnt_date,
			rv_payment_item.rv_payment_item_amt,
			rf_currency.rf_currency_symbol,
			rf_mthd_pmnt.rf_mthd_pmnt_desc,
			rv_payment.rv_pmnt_ref,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
            rv_payment_item.rv_payment_item_ix
		FROM
			rv_payment_item
			INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			LEFT JOIN fn_invoice ON 
				fn_invoice.fn_folio_id = rv_payment_item.fn_folio_id 
				AND fn_invoice.fn_inv_void_yn = 0 
				AND fn_invoice.fn_inv_reverse_ind = 0
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
			LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id
			INNER JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
			INNER JOIN rv_reservation ON rv_payment_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			$dateWhere
			$bankFilter[where] $currenciesFilter[where] $methodFilter[where] $invoiceFilter
	",2);
	$totals = array();
	foreach($list as $item) {
		if(!array_key_exists($item['rf_currency_symbol'],$totals)) {
			$totals[$item['rf_currency_symbol']] = $item['rv_payment_item_amt'];
		} else {
			$totals[$item['rf_currency_symbol']] += $item['rv_payment_item_amt'];
		}
	}
	if($renderMode == "html") {

		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		if(sizeof($list) > 0) {
			$rows = "";
			$rowHTML = Join("", file(__DIR__ . "/../../../public/html/rep_payment_item_rows.htm"));
			foreach($list as $item) {
				$item['rv_pmnt_date_fmt'] = chng_date($item['rv_pmnt_date'],"-");
				$item['rv_pmnt_date_created_fmt'] = chng_date(substr($item['rv_pmnt_date_created'],0,10),"-");
				$item['rv_date_arrive'] = chng_date(substr($item['rv_date_arrive'],0,10),"-");
				$item['rv_date_depart'] = chng_date(substr($item['rv_date_depart'],0,10),"-");
				$item['pr_name'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
				if($item['pr_name'] == "") {
					$item['pr_name'] = "Cash";
				}
				if(trim($item['rf_bank_acc_name']) == "") {
					$item['rf_bank_acc_name'] = "None";
				}
				fixAmtDisplay($item['rv_payment_item_amt'],2);
				$item['res_job'] = "646";
				if($GLOBALS['jobLevelArray'][647] >= 10 && canEditReservation($item['rv_reservation_id'])) {
					$item['res_job'] = "647";
				}
				if(trim($item['rv_pmnt_ref']) == "") {
					$item['rv_pmnt_ref'] = "&nbsp;";
				}
				$rows .= showpage($item,$rowHTML);
			}
			$totalRowHTML = Join("", file(__DIR__ . "/../../../public/html/rep_payment_item_total_rows.htm"));
			$first = true;
			foreach($totals as $currency=>$total) {
				$item = array(
					"total"=> number_format((float)$total, 2, '.', ''),
					"rf_currency_symbol"=>$currency,
				);
				$item['total_label'] = "";
				$item['totalClass'] = "";
				if($first) {
					$item['total_label'] = "Totals";
					$item['totalClass'] = "bt";
				}
				$rows .= showpage($item,$totalRowHTML);
				$first = false;
			}
		} else {
			$rows = "
				<tr>
					<td colspan=\"10\" align=\"center\" class=\"txti\">No records found</td>
				</tr>
			";
		}
		$GLOBALS['temp']['rows'] = $rows;
		$GLOBALS['temp']['dataClass'] = "";
	}
	if ( $renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
		$pdf = new PDF("Payments Due","L");
		$reportLabel = "Payments Due";
		// Main PDF header
		if($dateType == "0") {
			$dateHeader = array("name"=>"Credit date range", "value"=>chng_date($fromDate['jsDate'],"-") . " to " . chng_date($toDate['jsDate'],"-"));
		} else {
			$dateHeader = array("name"=>"Recorded date range", "value"=>chng_date($recordFromDate['jsDate'],"-") . " to " . chng_date($recordToDate['jsDate'],"-"));
		}
		$headerArray = array(
			$dateHeader,
			array("name"=>"Bank / cash point", "value"=>$bankFilter['names']),
			array("name"=>"Currency", "value"=>$currenciesFilter['names']),
			array("name"=>"Method of payment", "value" => $bankFilter['names']),
			array("name"=>"Show uninvoiced folios", "value"=>($folioCheck=="1"?"Yes":"No")),
			array("name"=>"Show invoiced folios", "value"=>($invoiceCheck=="1"?"Yes":"No"))
		);
		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);

		$pdf->Row(array(
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Payment No."),
			array("width"=>"7%","border"=>"LRTB","fill"=>"1","data"=>"Reservation No."),
			array("width"=>"7%","border"=>"LRTB","fill"=>"1","data"=>"Invoice No."),
			array("width"=>"9%","border"=>"LRTB","fill"=>"1","data"=>"Reservation Name."),
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Recorded on"),
			array("width"=>"12%","border"=>"LRTB","fill"=>"1","data"=>"Payer / payee"),
			array("width"=>"12%","border"=>"LRTB","fill"=>"1","data"=>"Bank / cash point"),
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Credit date"),
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Amount","align"=>"R"),
			array("width"=>"4%","border"=>"LRTB","fill"=>"1","data"=>"Currency","align"=>"C"),
			array("width"=>"7%","border"=>"LRTB","fill"=>"1","data"=>"Payment method"),
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Reference"),
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Arrival Date"),
			array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"Departure Date")
		));

		foreach($list as $item) {
			$item['rv_pmnt_date_fmt'] = chng_date($item['rv_pmnt_date'],"-");
			$item['rv_pmnt_date_created_fmt'] = chng_date(substr($item['rv_pmnt_date_created'],0,10),"-");
			$item['rv_date_arrive'] = chng_date(substr($item['rv_date_arrive'],0,10),"-");
			$item['rv_date_depart'] = chng_date(substr($item['rv_date_depart'],0,10),"-");
			$item['pr_name'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
			if($item['pr_name'] == "") {
				$item['pr_name'] = "Cash";
			}
			if(trim($item['rf_bank_acc_name']) == "") {
				$item['rf_bank_acc_name'] = "None";
			}
			fixAmtDisplay($item['rv_payment_item_amt'],2);
			$pdf->Row(array(
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_payment_ix']),
				array("width"=>"7%","border"=>"LR","data"=>$item['rv_reservation_id']),
				array("width"=>"7%","border"=>"LR","data"=>$item['fn_invoice_ix']),
				array("width"=>"9%","border"=>"LR","data"=>$item['rv_res_name']),
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_pmnt_date_created_fmt']),
				array("width"=>"12%","border"=>"LR","data"=>$item['pr_name']),
				array("width"=>"12%","border"=>"LR","data"=>$item['rf_bank_acc_name']),
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_pmnt_date_fmt']),
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_payment_item_amt'],"align"=>"R"),
				array("width"=>"4%","border"=>"LR","data"=>$item['rf_currency_symbol'],"align"=>"C"),
				array("width"=>"7%","border"=>"LR","data"=>$item['rf_mthd_pmnt_desc']),
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_pmnt_ref']),
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_date_arrive']),
				array("width"=>"6%","border"=>"LR","data"=>$item['rv_date_depart'])
			));
		}
		$first = true;
		foreach($totals as $currency=>$total) {
			$totalLabel = "";
			if($first) {
				$totalLabel = "Totals";
			}
			
			$pdf->Row(array(
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>$totalLabel),
				array("width"=>"7%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"7%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"9%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"12%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"12%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>$total,"align"=>"R"),
				array("width"=>"4%","border"=>"LRTB","fill"=>"1","data"=>$currency,"align"=>"C"),
				array("width"=>"7%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>""),
				array("width"=>"6%","border"=>"LRTB","fill"=>"1","data"=>"")
			));
			$first = false;
		}


		$pdf->Ln(2);
		$pdf->ReportHeader($reportLabel, $headerArray);


		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}

		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}

	if ( $renderMode == "csv" ) {
		$csvFile = array();

		array_push($csvFile,array("Payment Item Report"));
		array_push($csvFile,array());
		if($dateType == "0") {
			array_push($csvFile,array("Credit date range",$fromDate['jsDate'] . " to " . $toDate['jsDate']));
		} else {
			array_push($csvFile,array("Recorded date range",$recordFromDate['jsDate'] . " to " . $recordToDate['jsDate']));
		}
		array_push($csvFile,array("Bank / cash point",$bankFilter['names']));
		array_push($csvFile,array("Currency",$currenciesFilter['names']));
		array_push($csvFile,array("Method of payment",$methodFilter['names']));
		array_push($csvFile,array("Show uninvoiced folios",($folioCheck=="1"?"Yes":"No")));
		array_push($csvFile,array("Show invoiced folios",($invoiceCheck=="1"?"Yes":"No")));
		array_push($csvFile,array());

		array_push($csvFile,array(
			"Payment number",
			"Reservation number",
			"Invoice number",
			"Reservation name",
			"Recorded on",
			"Payer / payee",
			"Bank / cash point",
			"Credit date",
			"Amount",
			"Currency",
			"Payment method",
			"Reference",
			"Arrival Date",
			"Departure Date"
		));

		foreach($list as $item) {
			$item['pr_name'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
			if($item['pr_name'] == "") {
				$item['pr_name'] = "Cash";
			}
			if(trim($item['rf_bank_acc_name']) == "") {
				$item['rf_bank_acc_name'] = "None";
			}
			array_push($csvFile,array(
				$item['rv_payment_ix'],
				$item['rv_reservation_id'],
				$item['fn_invoice_ix'],
				$item['rv_res_name'],
				$item['rv_pmnt_date_created'],
				$item['pr_name'],
				$item['rf_bank_acc_name'],
				$item['rv_pmnt_date'],
				$item['rv_payment_item_amt'],
				$item['rf_currency_symbol'],
				$item['rf_mthd_pmnt_desc'],
				$item['rv_pmnt_ref'],
				$item['rv_date_arrive'],
				$item['rv_date_depart']
			));
		}
		foreach($totals as $currency => $total) {
			array_push($csvFile,array(
				"Totals",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				$total,
				$currency,
				"",
				"",
				"",
				""
			));			
		}
	
		$csvText = "";
	
		foreach ( $csvFile as $csvLine ) {
			$first = true;
		
			foreach ( $csvLine as $csvItem ) {
				if ( !$first ) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"" . str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}

		if ( headers_sent() ) {
			echo('Some data has already been output to browser, can\'t send CSV file');
		}
	
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: ' . strlen($csvText));
		header("Content-Disposition: inline; filename=payments_due_" . str_replace(" ","_",chng_date(date("Y-m-d"),"-")) . ".csv");
		echo $csvText;
		flush();
		die();
	}	
}


function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
