<?php
// Colour functions
global $colours;
$colours = array(
//	'preset'=>array("ff0000","00ff00","0000ff","ffff00","00ffff","ff00ff"),
	'preset'=>array("ffcccc","99ccff","99cccc","cc99cc","cccc99","ffcc33","66cccc","9999ff","ffffcc","a4c1b6","bff939","e0dccf","abfef5","efdbf0","9fa257","4d8dce"),
	'reservation'=>array(
		'pointer'=>0,
		'allocated'=>array()
	),
	'agent'=>array(
		'pointer'=>0,
		'allocated'=>array()
	),
	'consultant'=>array(
		'pointer'=>0,
		'allocated'=>array()
	)
);

function allocateColour($name, $id) {
	global $colours;

	$preset = $colours['preset'];
	$allocated =& $colours[$name]['allocated'];
	$pointer =& $colours[$name]['pointer'];

	if(array_key_exists($id,$allocated)) {
		$colour = $allocated[$id];
	} else {
		$colour = $preset[$pointer];
		$allocated[$id] = $colour;
		$pointer++;
		if($pointer >= sizeof($preset)) {
			$pointer = 0;
		}
	}	
	return $colour;
}

function getColourFromField($colour) {
	return $colour;
}

function getReservationColour($rv_reservation_ix) {
	return allocateColour("reservation",$rv_reservation_ix);
}

function getAgentColour($pr_agent_id) {
	return allocateColour("agent",$pr_agent_id);
}

function getConsultantColour($pr_consultant_id) {
	return allocateColour("consultant",$pr_consultant_id);
}

function getPaymentColour($accommAmount, $extraAmount, $travelAmount,$paidAmount) {
	$total = $accommAmount + $extraAmount + $travelAmount;
	$outstanding = $total - $paidAmount;
	if ( $outstanding == 0 ) {
		// Fully paid
		return "107df8";
	} else if($outstanding > 0) {
		if ( $paidAmount == 0 ) {
			// Unpaid
			return "ff0000";
		} else {
			// Part paid
			return "ff8000";
		}
	} else {
		// Overpaid
		return "00ff00";
	}
}
