<?php

/**
 * init.form360.func.output.php - Accommodation chart output functions
 */

function getRowSpans($chart, $type, $showIds) {
	$rowSpans = array();
	$data = $chart[$type];
	foreach($chart['rows'] as $row) {
		$rowSpans[$row['id']] = array();
		foreach($chart['columns'] as $col) {
			$rowSpan =& $rowSpans[$row['id']];
			foreach($showIds as $showId) {
				$cell = isset($data[$row['id']][$col['id']][$showId]['value']) ? $data[$row['id']][$col['id']][$showId]['value'] : "";
				if ( !array_key_exists($showId,$rowSpan) ) {
					$rowSpan[$showId] = 1;
				}
				if ( is_array($cell) ) {
					if ( sizeof($cell) > $rowSpan[$showId] ) {
						$rowSpan[$showId] = sizeof($cell);
					}
				}
			}
		}
	}
	
	return $rowSpans;
}

function generateChart($chartSections,$chartIds,$chart,$showUnitLabel,$showUnitNumber,$showDatePAX,$autoRoom, $showCatExtras) {
	define("MAX_CHAR_HTML", 31);
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$rowClass = isset($rowClass) ? $rowClass : "";
	$error = false;

	$rows = '
		<col width="150" />
		<col width="150" />
	';

	$numTH = count($chart['columns']);
	$GLOBALS['temp']['chartTableWidth'] = 300 + $numTH*200;
	for ( $i = 0; $i < $numTH; $i++ ) {
		$rows .= '<col width="200" />';
	}

	if ( $chart['direction'] == "1" ) {
		$rows .= '
			<tr style="height: 25px;">
				<td>&nbsp;</td>
				<td>&nbsp;</td>
		';

		$property_name = '';
		$modCount = 0;
		foreach ( $chart['columns'] as $col ) {
			if ( $property_name != $col['property'] ) {
				$property_name = $col['property'];
				if ( $modCount%2 == 0 ) {
					$bg_style = "colLtt";
				} else {
					$bg_style = "colLt";
				}
				$modCount++;
				$rows .= '<td class="' . $bg_style . ' bt bl">' . $property_name . '</td>';
			} else {
				$rows .= '<td class="' . $bg_style . ' bt">&nbsp;</td>';
			}
		}

		$rows .= '
			<tr>
				<td>&nbsp;</td>
				<td class="colLtDk bt bl">Details</td>
		';

		// Room names and numbers ---------------------------------------------------
		$property_name = "";
		$modCount = 0;
		foreach ( $chart['columns'] as $col ) {
			if ( $property_name != $col['property'] ) {
				$property_name = $col['property'];
				if ( $modCount%2 == 0 ) {
					$bg_style = "colLtt";
				} else {
					$bg_style = "colLt";
				}
				$modCount++;
			}
			$rows .= '<td class="' . $bg_style . ' bt bl">' . t_encodeHTML($col['accommodation']);
			if ( $showUnitLabel == "1" && isset($col['unit_label'])) {
				$rows .= '<br />' . t_encodeHTML($col['unit_label']);
			}
			if ( $showUnitNumber == "1" ) {
				$rows .= '<br />' . t_encodeHTML($col['room']);
			}
			$rows .= '</td>';
		}
	} else {
		// Dates along top
		$rows .= '
			<tr style="height: 30px;">
				<td>&nbsp;</td>
				<td class="colLtDk bt bl" valign="top">Details</td>
		';

		foreach ( $chart['columns'] as $col ) {
			$thisDate = explode("-",$col['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
			$rows .= '<td class="colLt bt bl">' . $displayDate . ' ' . $col['name'];
			if ( $showDatePAX == "1" ) {
				$rows .= '<br />PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
			}
			$rows .= '</td>';
		}
	}
	$rows .= '</tr>';

	$roomRowSpans	= getRowSpans($chart,"room",$showIds);
	$departRowSpans	= getRowSpans($chart,"depart",$departIds);

	$showDepartureInfo = true;

	$modcount = 0;

	if ( $chart['direction'] == "2" ) {
		$property_name = "";
		$anotherCount = 0;
	}

	foreach ( $chart['rows'] as $row ) {

		if ( $chart['direction'] == '1' ) {
			$thisDate	= explode("-",$row['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		}

		if ( $modcount%2 == 0 ) {
			$colourBand = 'colLtt';
		} else {
			$colourBand = 'colLt';
		}

		// Here we look at each row and try to determine if there is any departure
		// information in any of the row's columns. If not, then we don't display 
		// the departure row
		$departInfoExists = false;
		foreach ( $chart['columns'] as $col ) {
			$d = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
			if ( count($d) > 0  && $d != "") {
				foreach ( $d as $blah ) {
					if ( isset($blah['value']) && $blah['value'] != "" ) {
						$departInfoExists = true;
					}
				}
			}
		}

		if ( count($departIds) > 0 && $departInfoExists && $showDepartureInfo ) {
			$bool_depart = true;
			$top_line_style = 'border-top: 1px dashed #ccc;';
			// [START] Departure information row --------------------------------------
			if ( $chart['direction'] == '1' ) {
				$rows .= '
					<tr' . $rowClass . '>
						<td valign="top" class="' . $colourBand . ' bt bl">
						<strong><span>DEPART</span></strong><br />
							' . $displayDate . ' ' . t_encodeHTML($row['name']) . '
						</td>
						<td valign="top" class="colLtDk bl bt">
							<table width="100%" border="0" cellpadding="1" cellspacing="0" summary="">
				';
			} else {
				if ( $property_name != $row['property'] ) {
					$property_name = $row['property'];
					if ( $anotherCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}

					$anotherCount++;
					$rows .= '
						<tr' . $rowClass . ' style="height: 25px; line-height: 25px;">
							<td colspan="' . ($numTH + 2) . '" valign="top" class="' . $bg_style . ' bt bl"><strong>' . t_encodeHTML($row['property']) . '</strong></td>
						</tr>
					';

					$modcount = 1;
				}

				if ( $modcount%2 == 0 ) {
					$colourBand = 'colDkDk';
				} else {
					$colourBand = $bg_style;
				}

				$rows .= '
					<tr' . $rowClass . '>
						<td valign="top" class="' . $colourBand . ' bt bl">
							<strong><span>DEPART</span></strong><br />
							' . t_encodeHTML($row['accommodation']) . '
				';

				if ( $showUnitLabel == "1" && isset($row['unit_label'])) {
					$rows .= '<br />' . t_encodeHTML($row['unit_label']);
				}

				if ( $showUnitNumber == "1" && isset($row['room'])) {
					$rows .= '<br />' . t_encodeHTML($row['room']);
				}

				$rows .= '</td>
						<td valign="top" class="colLtDk bl bt">
							<table width="100%" border="0" cellpadding="1" cellspacing="0" summary="">
				';
			}

			// [START] Departure section headings -------------------------------------
			foreach ( $departIds as $departId ) {
				$sectionId = 0;
				$repFlag = 0;
				foreach ( $chartSections as $item ) {
					if ( $item['id'] == $departId ) {
						if($departId<23){
							if ( strlen($item['label']) > MAX_CHAR_HTML+2 ) {
								$item['label'] = substr($item['label'],0,MAX_CHAR_HTML) . "..";
							}
							$rows .= '
								<tr style="height: 18px;">
									<td>' . $item['label'] . '</td>
								</tr>
							';
							if ( $departRowSpans[$row['id']][$departId] > 1 ) {
								for ( $count = 1; $count < $departRowSpans[$row['id']][$departId]; $count++ ){
									$rows .= '
										<tr style="height: 18px;">
											<td>&nbsp;</td>
										</tr>
									';
								}
							}
						}
						else if($departId>=23) {
							for ( $count = 0; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
								if($departId ==23 || $departId == 26) {
									if(in_array($departId, $departIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId]['label'] . '</td>
												</tr>
											';
									}
									if(in_array($departId+1, $departIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId+1]['label'] . '</td>
												</tr>
											';
									}
									if(in_array($departId+2, $departIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId+2]['label'] . '</td>
												</tr>
											';
									}
									$repflag = 1;
								}
								else if(($departId ==24 || $departId == 27) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId]['label'] . '</td>
												</tr>
											';
									}
									if(in_array($departId+1, $departIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId+1]['label'] . '</td>
												</tr>
											';
									}
									$repflag = 1;
								}
								else if(($departId ==25 || $departId == 28) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId]['label'] . '</td>
												</tr>
											';
									}
									
									$repflag = 1;
								}
							}
						}
						if($item['id']==25){
							$repflag = 0;
						}
					}
					$sectionId++;
				}
			}
			$rows .= '</table></td>';
			// [ END ] Departure section headings -------------------------------------
		

			// [START] Departure information ------------------------------------------				
			foreach ( $chart['columns'] as $col ) {
				$d = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
				$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";
	
				$initialColour = "#f2f2f2";
				if ( $b ) {
					$initialColour = "#c0c0c0";				
				}
	
				$rows .= '
					<td valign="top" class="bl bt" style="background-color: ' . $initialColour . ';">
						<table width="100%" border="0" cellpadding="1" cellspacing="0" summary="">
						';

				$first = true;
				$error = false;
				$errorDesc = "";
				foreach ( $departIds as $departId ) {
					$repFlag = 0;
					$colour			= $initialColour;
					$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";

					// Provisional booking
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 20 ) {
						$fontColour = '#369';
					}

					// Provisional expiring today
					if ( isset($d['rv_provision_expiry_date']) && $d['rv_provision_expiry_date'] == date("Y-m-d") ) {
						$colour			= "#f1c55d";
						$fontColour	= "#000";
					}
					
					// Allocation
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 15 ) {
						$fontColour = "#999";
					}
					
					$errorMsg = '<img src="/resource/Resrequest/Application/public/img/icon_error_12.gif" width="12" height="12" alt="" style="display: inline;" onmouseover="overlib(\'%status%\');" onmouseout="nd();" />';

					// We have an expired provisional that is roomed
					if (
                        isset($d['rv_provision_expiry_date']) &&
                        $d['rv_provision_expiry_date'] != 0000-00-00 &&
                        $d['rv_provision_expiry_date'] < date("Y-m-d") &&
                        $d['rf_reservation_status_id'] != "30"  // Status is not confirmed
                    ) {
						$error = true;
						$msg = "You have an expired provisional that has been roomed.";
						$errorDesc = str_replace("%status%", $msg, $errorMsg);
					}

					// [START] Reservation status error handling ----------------------------
					// Quotation
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == "0" ) {
						$error = true;
						$msg = "You have a quotation that has been roomed.";
						$errorDesc = str_replace("%status%", $msg, $errorMsg);
					}

					// Waitlisted
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 10 ) {
						$error = true;
						$msg = "You have a waitlisted that has been roomed.";
						$errorDesc = str_replace("%status%", $msg, $errorMsg);
					}

					// Cancelled
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 90 ) {
						$error = true;
						$msg = "You have a cancelled reservation that has been roomed.";
						$errorDesc = str_replace("%status%", $msg, $errorMsg);
					}

					// Add clickthrough to cell ----------------------------------------------
					$clickThrough = "";
					$pointer = '';
					if ( isset($d['rv_reservation_id']) && $d['rv_reservation_id'] != "" ) {
						$clickThrough = "onclick=\"window.location = '/reservation.php?2+" . $d['rv_reservation_id'] . "'\"";
						$pointer = 'cursor: pointer;';
					}

					if ( isset($d[$departId]['value']) && !is_array($d[$departId]['value']) ) {							
						// [ START ] Reservation status error handling ----------------------------
						if ( $first && $error == true) {
								$d[$departId]['value'] = $errorDesc . ' ' . $d[$departId]['value'];
							}
						// [ END ] Reservation status error handling ----------------------------

						// You have a roomed overbooking! Double silly bugger!
						if ( isset($d['overbooked']) && $d['overbooked']) {
							$error = true;
							$msg = "You have a room-level overbooking.";
							$errorDesc = str_replace("%status%", $msg, $errorMsg);
							if ( $first ) {
								$d[$departId]['value'] = $errorDesc . ' ' . join("/",$d['overbookedList']);
							}
						}
						
						
						// [ START ] Colour handling ----------------------------
						if ( isset($departId) && in_array($departId,$colourIds) && isset($d[$departId]['colour']) && $d[$departId]['colour'] != "" ) {
							$colour = "#" . $d[$departId]['colour'];
						}
						if ( $error ) {
							$colour	 = "#db4242";
							$fontColour = "#fff";
						}
						// [ END ] Colour handling ----------------------------
						
						if ( trim($d[$departId]['value']) == '' ) {
							$d[$departId]['value'] = "&nbsp;";
						}

						if ( strlen($d[$departId]['value']) > MAX_CHAR_HTML+2) {
							if ($first &&  $error == true) {
							
							} else {
								$d[$departId]['value'] = substr($d[$departId]['value'],0,MAX_CHAR_HTML) . '..';
							}
						}
						$first = false;
						$rows .= '<tr><td style="background-color: ' . $colour . '; color: ' . $fontColour . '; height: 18px;' . $pointer . '" ' . $clickThrough . '>'. $d[$departId]['value'] . '</td></tr>';
					} else {
						if($departId <23){
						$used = 0;
						if (isset($d[$departId]['value'])) {
							foreach ( $d[$departId]['value'] as $cellItem ) {
								$colour		= $initialColour;
								if ( $first && $error == true) {
										$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
									}
								
								// You have a roomed overbooking! Double silly bugger!
								if ( isset($d['overbooked']) && $d['overbooked']) {
									$error = true;
									$msg = "You have a room-level overbooking.";
									$errorDesc = str_replace("%status%", $msg, $errorMsg);
									if ( $first ) {
										$cellItem['value'] = $erorrDesc . ' ' . join("/",$d['overbookedList']);
									}
								}
								$first = false;

								// [ START ] Colour handling ---------------------------------------------
								if ( in_array($departId,$colourIds) && $cellItem['colour'] != "" ) {
									$colour = '#' . $cellItem['colour'];
								}
								if ( $error ) {
									$colour			= "#db4242";
									$fontColour	= "#fff";
								}
								// [ END ] Colour handling ---------------------------------------------

								if ( strlen($cellItem['value']) > MAX_CHAR_HTML+2 && !$first ) {
									$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
								}

								$rows .= '
									<tr>
										<td style="background-color: ' . $colour . '; color: ' . $fontColour . '; height: 18px; ' . $pointer . '" ' . $clickThrough . '>'. $cellItem['value'] . '</td>
									</tr>
								';
								$used++;
							}
						}
						if ( $used < $departRowSpans[$row['id']][$departId] ) {
							for ( $count = 0; $count < ($departRowSpans[$row['id']][$departId] - $used); $count++ ) {
								$colour = $initialColour;
								if ( $error ) {
									$colour = '#db4242';
									$fontColour = '#fff';
								}

								if ( $first ) {
									$output = $errorDesc;
									$first = false;
								} else {
									$output = "&nbsp;";
								}

								$clickThrough = "";
								$pointer = '';

								$rows .= '
									<tr>
										<td style="background-color: ' . $colour . '; color: ' . $fontColour . '; height: 18px;">' . $output . '</td>
									</tr>
								';
							}
						}
					}
					else if($departId>=23) {
						if($departId==26) {
							$repFlag = 0;
						}
						else if(!in_array(26,$departIds) && $departId == 27) {
							$repFlag = 0;
						}
						else if(!in_array(26,$departIds) && !in_array(27,$departIds) && $departId == 28) {
							$repFlag = 0;
						}

						for ( $count = 0; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
							$cellItem = isset($d[$departId]['value'][$count]) ? $d[$departId]['value'][$count] : array();
							if ( $first && $error == true ) {
									$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
							}

							// We have a roomed overbooking!
							if ( isset($d['overbooked']) && $d['overbooked']) {
								$error = true;
								$msg = "You have a room-level overbooking.";
								$errorDesc = str_replace("%status%", $msg, $errorMsg);
								if ( $first ) {
									$cellItem['value'] = $erorrDesc . ' ' . join("/",$c['overbookedList']);
								}
							}
							$first = false;

							if ( isset($cellItem['value']) && strlen($cellItem['value']) > MAX_CHAR_HTML+2 && !$first ) {
								$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
							}

							// [START] Colour handling ---------------------------------------------
							$colour		= $initialColour;
							$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
							if ( in_array($departId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != "" ) {
								$colour = '#' . $cellItem['colour'];
							}
							if ( $error ) {
								$colour			= "#db4242";
								$fontColour	= "#fff";
							}
							// [ END ] Colour handling ---------------------------------------------

							if(!isset($cellItem['value']) || $cellItem['value'] == '') {
								$colour = $initialColour;
								if ( $error ) {
									$colour = '#db4242';
									$fontColour = '#fff';
								}

								if ( $first ) {
									$output = $errorDesc;
									$first = false;
								} else {
									$output = "&nbsp;";
								}

								$clickThrough = "";
								$pointer = '';
							}

							if($departId ==23 || $departId == 26) {
								if(in_array($departId, $departIds)) {
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. (isset($cellItem['value']) ? $cellItem['value'] : "") . '</td>
												</tr>
											';
								}
								if(in_array($departId+1, $departIds)) {
									$cellItem2 = isset($d[$departId+1]['value'][$count]) ? $d[$departId+1]['value'][$count] : array();
									$noteVal = !empty($cellItem2) ? ( strlen($cellItem2['value'])>MAX_CHAR_HTML+2? substr($cellItem2['value'],0,MAX_CHAR_HTML)."..":$cellItem2['value'] ) : "";
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $noteVal . '</td>
											</tr>
										';
								}
								if(in_array($departId+2, $departIds)) {
									$cellItem3 = isset($d[$departId+2]['value'][$count]) ? $d[$departId+2]['value'][$count] : array();
									$noteVal = !empty($cellItem3) ? ( strlen($cellItem3['value'])>MAX_CHAR_HTML+2? substr($cellItem3['value'],0,MAX_CHAR_HTML)."..":$cellItem3['value'] ) : "";
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $noteVal . '</td>
											</tr>
										';
								}
								$repflag = 1;
							}
							else if(($departId ==24 || $departId == 27) && $repflag == 0) {
								if(in_array($departId, $departIds)) {
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $cellItem['value'] . '</td>
												</tr>
											';
								}
								if(in_array($departId+1, $departIds)) {
									$cellItem2 = isset($d[$departId+1]['value'][$count]) ? $d[$departId+1]['value'][$count] : array();
									$noteVal = !empty($cellItem2) ? ( strlen($cellItem2['value'])>MAX_CHAR_HTML+2? substr($cellItem2['value'],0,MAX_CHAR_HTML)."..":$cellItem2['value'] ) : "";
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $noteVal . '</td>
											</tr>
										';
								}
								$repflag = 1;
							}
							else if(($departId ==25 || $departId == 28) && $repflag == 0) {
								if(in_array($departId, $departIds)) {
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $cellItem['value'] . '</td>
												</tr>
											';
								}
								$repflag = 0;
							}
						}
					}
					$first = false;
				}
			}
			// [ END ] Departure information -----------------------------------------
			$rows .= '</table></td>';
		}
		$rows .= '</tr>';
	} else {
			$bool_depart = false;
			$top_line_style = 'border-top: 1px solid #000;';
		}

		// [START] Room information row -------------------------------------------
		if ( $chart['direction'] == "1" ) {

			if ( $showDatePAX == "1" ) {
				$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
			} else {
				$paxCount = '';
			}

			$rows .= '<tr' . $rowClass . '>';
			$rows .= '
				<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '">
				<strong><span>ARR/STAYOVER</span></strong><br>' . $displayDate . ' ' . t_encodeHTML($row['name']) . '<br />' . $paxCount . '
				</td>
				<td valign="top" class="colLtDk bl" style="' . $top_line_style . '">
					<table width="100%" border="0" cellpadding="1" cellspacing="0" summary="">
			';
		} else {
			if ( $property_name != $row['property'] ) {
				$property_name = $row['property'];
				if ( $anotherCount%2 == 0 ) {
					$bg_style = "colLtt";
				} else {
					$bg_style = "colLt";
				}

				$anotherCount++;
				
				$rows .= '
					<tr' . $rowClass . ' style="height: 25px; line-height: 25px;">
						<td colspan="' . ($numTH + 2) . '" valign="top" class="' . $bg_style . ' bt bl"><strong>' . t_encodeHTML($row['property']) . '</strong></td>
					</tr>
				';
				
				$modcount = 1;
				
			}

			if ( $modcount%2 == 0 ) {
				$colourBand = 'colDkDk';
			} else {
				$colourBand = $bg_style;
			}

			$rows .= '<tr' . $rowClass . '><td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '"><strong><span>ARR/STAYOVER</span></strong><br>' . t_encodeHTML($row['accommodation']);

			if ( isset($showUnitLabel) && $showUnitLabel == "1" && isset($row['unit_label'])) {
				$rows .= '<br />' . t_encodeHTML($row['unit_label']);
			}
			if ( isset($showUnitNumber) && $showUnitNumber == "1" && isset($row['room'])) {
				$rows .= '<br />' . t_encodeHTML($row['room']);
			}
			
					
			$rows .= '
				</td>
				<td valign="top" class="colLtDk bl" style="' . $top_line_style . '">
					<table width="100%" border="0" cellpadding="1" cellspacing="0" summary="">
			';
		}
	
		// [START] Room data headings ----------------------------------------------
		foreach ( $showIds as $showId ) {
			$sectionId = 0;
			$repFlag = 0;
			foreach ( $chartSections as $item ) {
				if ( $item['id'] == $showId ) { 
					if($showId<23){
						if ( strlen($item['label']) > MAX_CHAR_HTML+2 ) {
							$item['label'] = substr($item['label'],0,MAX_CHAR_HTML) . "..";
						}
						$rows .= '
							<tr style="height: 18px;">
								<td>' . $item['label'] . '</td>
							</tr>
						';
						if ( $roomRowSpans[$row['id']][$showId] > 1 ) {
							for ( $count = 1; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
								$rows .= '
									<tr style="height: 18px;">
										<td>&nbsp;</td>
									</tr>
								';
							}
						}
					}
					else if($showId>=23) {
						for ( $count = 0; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
							if($showId ==23 || $showId == 26) {
								$rows .= '
										<tr style="height: 18px;">
											<td>' . $chartSections[$sectionId]['label'] . '</td>
										</tr>
									';
								if(in_array($showId+1, $showIds)) {
									$rows .= '
											<tr style="height: 18px;">
												<td>' . $chartSections[$sectionId+1]['label'] . '</td>
											</tr>
										';
								}
								if(in_array($showId+2, $showIds)) {
									$rows .= '
											<tr style="height: 18px;">
												<td>' . $chartSections[$sectionId+2]['label'] . '</td>
											</tr>
										';
								}
								$repflag = 1;
							}
							else if(($showId ==24 || $showId == 27) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId]['label'] . '</td>
												</tr>
											';
									}
									if(in_array($showId+1, $showIds)) {
										$rows .= '
												<tr style="height: 18px;">
													<td>' . $chartSections[$sectionId+1]['label'] . '</td>
												</tr>
											';
									}
									$repflag = 1;
								}
								else if(($showId ==25 || $showId == 28) && $repflag == 0) {
									if(in_array($showId, $showIdss)) {
										$rows .= '
											<tr style="height: 18px;">
												<td>' . $chartSections[$sectionId]['label'] . '</td>
											</tr>
										';
									}
									$repflag = 1;
								}
						}
					}
					if($item['id']==25){
							$repflag = 0;
						}
				}
				$sectionId++;
			}
		}
		$rows .= '</table></td>';
		// [ END ] Room data headings ----------------------------------------------

		// [START] Room information ------------------------------------------------
		foreach ( $chart['columns'] as $col ) {
			$c = isset($chart['room'][$row['id']][$col['id']]) ? $chart['room'][$row['id']][$col['id']] : "";
			$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

			$initialColour = "#fff";
			$initialFontColour = "#000";
			if ( $b ) {
				$initialColour = "#c0c0c0";
			}

			$rows .= '
					<td valign="top" class="bl" style="background-color: ' . $initialColour . ';' . $top_line_style . '">
							<table width="100%" border="0" cellpadding="1" cellspacing="0" summary="">
					';
	
			$first = true;
			$error = false;
			$repFlag = 0;
			$errorDesc = "";
			foreach ( $showIds as $showId ) {
				$colour			= $initialColour;
				$fontColour = $initialFontColour;

				// Provisional booking
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 20 ) {
					$fontColour = '#369';
				}

				// Provisional expiring today
				if ( isset($c['rv_provision_expiry_date']) && $c['rv_provision_expiry_date'] == date("Y-m-d") )  {
					$colour = "#f1c55d";
					$fontColour = "#000";
				}

				// Allocation
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 15 ) {
					$fontColour = "#999";
				}
				
				$errorMsg = '<img src="/resource/Resrequest/Application/public/img/icon_error_12.gif" width="12" height="12" alt="" style="display: inline;" onmouseover="overlib(\'%status%\');" onmouseout="nd();" />';

				// We have an expired provisional that is roomed
				if (
                    isset($c['rv_provision_expiry_date']) &&
                    $c['rv_provision_expiry_date'] != 0000-00-00 &&
                    isset($c['rv_provision_expiry_date']) &&
                    $c['rv_provision_expiry_date'] < date("Y-m-d") &&
                    $c['rf_reservation_status_id'] != "30"  // Status is not confirmed
                ) {
					$error = true;
					$msg = "You have an expired provisional that has been roomed.";
					$errorDesc = str_replace("%status%", $msg, $errorMsg);
				}

				// [START] Reservation status error handling ----------------------------
				// Quotation
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == "0" ) {
					$error = true;
					$msg = "You have a quotation that has been roomed.";
					$errorDesc = str_replace("%status%", $msg, $errorMsg);
				}

				// Waitlisted
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 10 ) {
					$error = true;
					$msg = "You have a waitlisted that has been roomed.";
					$errorDesc = str_replace("%status%", $msg, $errorMsg);
				}

				// Cancelled
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 90 ) {
					$error = true;
					$msg = "You have a cancelled reservation that has been roomed.";
					$errorDesc = str_replace("%status%", $msg, $errorMsg);
				}

				// Add clickthrough to cell ----------------------------------------------
				$clickThrough = "";
				$pointer = '';
				if ( isset($c['rv_reservation_id']) && $c['rv_reservation_id'] != "" ) {
					$clickThrough = "onclick=\"window.location = '/reservation.php?2+" . $c['rv_reservation_id'] . "'\"";
					$pointer = 'cursor: pointer;';
				}
		
				if ( isset($c[$showId]['value']) && !is_array($c[$showId]['value']) ) {
					// [ START ] Reservation status error handling ----------------------------
					if ( $first &&  $error == true) {
						$c[$showId]['value'] = $errorDesc . ' ' . $c[$showId]['value'];
					}
					// [ END ] Reservation status error handling ----------------------------

					// We have a roomed overbooking!
					if ( isset($c['overbooked']) && $c['overbooked'] ) {
						$error = true;
						$msg = "You have a room-level overbooking.";
						$errorDesc = str_replace("%status%", $msg, $errorMsg);
						if ( $first ) {
							$c[$showId]['value'] = $errorDesc . ' ' . join("/",$c['overbookedList']);
						}
					}
					
					// [START] Colour handling ----------------------------------------------
					if ( in_array($showId,$colourIds) && $c[$showId]['colour'] != "" ) {
						$colour = "#" . $c[$showId]['colour'];
					}
					if ( $error ) {
						$colour			= "#db4242";
						$fontColour = "#fff";
					}
					// [ END ] Colour handling ----------------------------------------------

					if(trim($c[$showId]['value']) == "") {
						$c[$showId]['value'] = "&nbsp;";
					}

					if ( strlen($c[$showId]['value']) > MAX_CHAR_HTML+2) {
						if ( $first &&  $error == true) {
							
						} else {
							$c[$showId]['value'] = substr($c[$showId]['value'],0,MAX_CHAR_HTML) . "..";
						}
					}
					$first = false;
					$rows .= '
						<tr>
							<td style="background-color: ' . $colour . '; color: ' . $fontColour . '; height: 18px;' . $pointer . '" ' . $clickThrough . '>' . $c[$showId]['value'] . '</td>
						</tr>
					';
				} 
				else {
					$used = 0;
					if($showId <23){
						if (isset($c[$showId]['value'])) {
							foreach ( $c[$showId]['value'] as $cellItem ) {
								if ( $first && $error == true ) {
										$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
								}

								// We have a roomed overbooking!
								if ( isset($c['overbooked']) && $c['overbooked'] ) {
									$error = true;
									$msg = "You have a room-level overbooking.";
									$errorDesc = str_replace("%status%", $msg, $errorMsg);
									if ( $first ) {
										$cellItem['value'] = $erorrDesc . ' ' . join("/",$c['overbookedList']);
									}
								}
								$first = false;

								if ( strlen($cellItem['value']) > MAX_CHAR_HTML+2 && !$first ) {
									$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
								}

								// [START] Colour handling ---------------------------------------------
								$colour			= $initialColour;
								if ( in_array($showId,$colourIds) && $cellItem['colour'] != "" ) {
									$colour = '#' . $cellItem['colour'];
								}
								if ( $error ) {
									$colour			= "#db4242";
									$fontColour	= "#fff";
								}
								// [ END ] Colour handling ---------------------------------------------

									
								$rows .= '
									<tr>
										<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $cellItem['value'] . '</td>
									</tr>
								';
											
								$used++;
							}
						}

						if ( $used < $roomRowSpans[$row['id']][$showId] ) {
							for ( $count = 0; $count < ($roomRowSpans[$row['id']][$showId] - $used); $count++ ) {
								$colour = $initialColour;
								if ( $error ) {
									$colour = '#db4242';
									$fontColour = '#fff';
								}

								if ( $first ) {
									$output = $errorDesc;
									$first = false;
								} else {
									$output = "&nbsp;";
								}

								$clickThrough = "";
								$pointer = '';

								$rows .= '
									<tr>
										<td style="background-color: ' . $colour . '; color: ' . $fontColour . '; height: 18px;">' . $output . '</td>
									</tr>
								';
							}
						}
					}
					else if($showId>=23) {
						if($showId==26) {
							$repFlag = 0;
						}
						else if(!in_array(26,$showIds) && $showId == 27) {
							$repFlag = 0;
						}
						else if(!in_array(26,$showIds) && !in_array(27,$showIds) && $showId == 28) {
							$repFlag = 0;
						}
						for ( $count = 0; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
							$cellItem = isset($c[$showId]['value'][$count]) ? $c[$showId]['value'][$count] : array();
							if ( $first && $error == true ) {
									$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
							}

							// We have a roomed overbooking!
							if ( isset($c['overbooked']) && $c['overbooked'] ) {
								$error = true;
								$msg = "You have a room-level overbooking.";
								$errorDesc = str_replace("%status%", $msg, $errorMsg);
								if ( $first ) {
									$cellItem['value'] = $erorrDesc . ' ' . join("/",$c['overbookedList']);
								}
							}
							$first = false;

							if ( isset($cellItem['value']) && strlen($cellItem['value']) > MAX_CHAR_HTML+2 && !$first ) {
								$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
							}

							// [START] Colour handling ---------------------------------------------
							$colour		= $initialColour;
							$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
							if ( in_array($showId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != "" ) {
								$colour = '#' . $cellItem['colour'];
							}
							if ( $error ) {
								$colour			= "#db4242";
								$fontColour	= "#fff";
							}
							// [ END ] Colour handling ---------------------------------------------

							if(!isset($cellItem['value']) || $cellItem['value'] == '') {
								$colour = $initialColour;
								if ( $error ) {
									$colour = '#db4242';
									$fontColour = '#fff';
								}

								if ( $first ) {
									$output = $errorDesc;
									$first = false;
								} else {
									$output = "&nbsp;";
								}

								$clickThrough = "";
								$pointer = '';
							}

							if($showId ==23 || $showId == 26) {
								if(in_array($showId, $showIds)) {
								$rows .= '
										<tr>
											<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. (isset($cellItem['value']) ? $cellItem['value'] : "") . '</td>
										</tr>
										';
								}
								if(in_array($showId+1, $showIds)) {
									$cellItem2 = isset($c[$showId+1]['value'][$count]) ? $c[$showId+1]['value'][$count] : array();
									$noteVal = !empty($cellItem2) ? ( strlen($cellItem2['value'])>MAX_CHAR_HTML+2? substr($cellItem2['value'],0,MAX_CHAR_HTML)."..":$cellItem2['value'] ) : "";
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $noteVal . '</td>
											</tr>
										';
								}
								if(in_array($showId+2, $showIds)) {
									$cellItem3 = isset($c[$showId+2]['value'][$count]) ? $c[$showId+2]['value'][$count] : array();
									$noteVal = !empty($cellItem3) ? ( strlen($cellItem3['value'])>MAX_CHAR_HTML+2? substr($cellItem3['value'],0,MAX_CHAR_HTML)."..":$cellItem3['value'] ) : "";
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $noteVal . '</td>
											</tr>
										';
								}
								$repflag = 1;
							}
							else if(($showId ==24 || $showId == 27) && $repflag == 0) {
								if(in_array($showId, $showIds)) {
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $cellItem['value'] . '</td>
											</tr>
											';
								}
								if(in_array($showId+1, $showIds)) {
									$cellItem2 = isset($c[$showId+1]['value'][$count]) ? $c[$showId+1]['value'][$count] : array();
									$noteVal = !empty($cellItem2) ? ( strlen($cellItem2['value'])>MAX_CHAR_HTML+2? substr($cellItem2['value'],0,MAX_CHAR_HTML)."..":$cellItem2['value'] ) : "";
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $noteVal . '</td>
											</tr>
										';
								}
								$repflag = 1;
							}
							else if(($showId ==25 || $showId == 28) && $repflag == 0) {
								if(in_array($showId, $showIds)) {
									$rows .= '
											<tr>
												<td style="background-color: ' . $colour . '; color: ' . $fontColour . ';' . $pointer . ' height: 18px;" ' . $clickThrough . '>'. $cellItem['value'] . '</td>
												</tr>
											';
								}
								$repflag = 1;
							}
						}
					}
	
					$first = false;
				}
			}
			$rows .= '</table></td>';
		}
		// [ END ] Room information -----------------------------------------------
		$rows .= '</tr>';

		$modcount++;
	}
	return $rows;
}

function generateNotes($noteSections,$noteIds,$notes,$noteSort) {
	$html = '';

	// debug($noteIds);
	// debug($noteSections);
	// debug($notes);
	
	/* ---------------------------------------------------------------------------
	ORDER FOR NOTES:
	Reservation notes
	Internal memos
	Extras notes
	Extras internal memos
	Only show extras with notes/memos
	Travel notes
	Travel internal memos
	Only show travel with notes/memos
	Guest information
	Guest specific information
		Guest names
		Guest notes
		Guest internal memos
		Special events
	Room lock reason
	---------------------------------------------------------------------------	*/

	if ( count($notes) > 0 ) {

		switch ( $noteSort ) {
			case "1":
				$mainColHeading = array("Arrival date","Departure date","Res. Name","Res. Number");
				break;
			case "2":
				$mainColHeading = array("Departure date","Res. Name","Res. Number","Arrival date");
				break;
			case "3":
				$mainColHeading = array("Res. Number","Arrival date","Departure date","Res. Name");
				break;
			case "4":
				$mainColHeading = array("Res. Name","Arrival date","Departure date","Res. Number");
				break;
		}

		$html .= '
			<table width="500" border="0" cellpadding="0" cellspacing="0" summary="" style="table-layout: fixed;">
				<col width="125" />
				<col width="125" />
				<col width="125" />
				<col width="125" />
				<tr style="height: 25px;">
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[0]) ? $mainColHeading[0] : "") . '</strong></td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[1]) ? $mainColHeading[1] : "") . '</strong></td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[2]) ? $mainColHeading[2] : "") . '</strong></td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[3]) ? $mainColHeading[3] : "") . '</strong></td>
				</tr>
			</table>
		';

		foreach ( $notes as $item ) {
			// Used to suppress reservations with no notes --------------------------
			$note_exists	= false;
			$note_html		= '';
			if ( count($item) > 0 ) {
				/* -------------------------------------------------------------------------
					TITLE SORT ORDER
					1: Arrival date
					2: Departure date
					3: Reservation ID
					4: Reservation name
				------------------------------------------------------------------------- */
				switch ( $noteSort ) {
					case "1":
						$mainColHeading = array("Arrival date","Departure date","Res. Name","Res. Number");
						$title = array($item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_res_name'],$item['rv_reservation_ix']);
						break;
					case "2":
						$mainColHeading = array("Departure date","Res. Name","Res. Number","Arrival date");
						$title = array($item['rv_date_depart_fmt'],$item['rv_res_name'],$item['rv_reservation_ix'],$item['rv_date_arrive_fmt']);
						break;
					case "3":
						$mainColHeading = array("Departure date","Res. Name","Res. Number","Arrival date");
						$title = array($item['rv_reservation_ix'],$item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_res_name']);
						break;
					case "4":
						$title = array($item['rv_res_name'],$item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_reservation_ix']);
						break;
				}

				$note_html .= '
					<table width="500" border="0" cellpadding="0" cellspacing="0" summary="" style="table-layout: fixed;">
						<col width="125" />
						<col width="125" />
						<col width="125" />
						<col width="125" />
						<tr>
							<td valign="top" class="bt"><strong><u>' . $title[0] . '</u></strong></td>
							<td valign="top" class="bt"><strong><u>' . $title[1] . '</u></strong></td>
							<td valign="top" class="bt"><strong><u>' . $title[2] . '</u></strong></td>
							<td valign="top" class="bt"><strong><u>' . $title[3] . '</u></strong></td>
						</tr>
					</table>

					<table width="660" border="0" cellpadding="1" cellspacing="0" summary="">
						<col width="125" />
						<col width="125" />
						<col />
				';

				// [START] Reservation Notes -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNote"),$noteIds) ) {
					if ( isset($item['rv_note_general']) && $item['rv_note_general'] != "" ) {
						$note_exists = true;

						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Reservation notes:</td>
								<td>' . nl2br($item['rv_note_general']) . '</td>
							</tr>
						';
					}
				}
				// [ END ] Reservation Notes -----------------------------------------------

				// [START] Internal Memos --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resMemo"),$noteIds) ) {
					if ( isset($item['rv_note_internal']) && trim($item['rv_note_internal']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Internal memos:</td>
								<td>' . nl2br($item['rv_note_internal']) . '</td>
							</tr>
						';
					}
				}
				// [ END ] Internal Memos --------------------------------------------------

				// [START] Extras ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"extraMemo"),$noteIds) && count($item['extras']) > 0 ) {
					if ( in_array(findSectionId($noteSections,"extraOnly"),$noteIds) ) {
						$extraOnly = true;
					} else {
						$extraOnly = false;
					}
					$first = true;
					foreach ( $item['extras'] as $extra ) {
						if ( ( $extraOnly &&  ( $extra['rv_extra_note'] != "" || $extra['rv_extra_note_internal'] != "" ) ) || !$extraOnly ) {
							if ( $first ) {
								$title = "Extras";
								$first = false;
							} else {
								$title = "&nbsp;";
							}

							if ( isset($extra['ac_desc']) && $extra['ac_desc'] != "" ) {
								$extra_room_link = ' (' . $extra['ac_desc'] . ')';
							} else {
								$extra_room_link = '';
							}

							$extra_category_column = '';
							$extra_category_column_content = '';

							if ( in_array(findSectionId($noteSections,"extraCat"),$noteIds) ) {
								$extra_category_column = '<col width="80" />';
								$extra_category_column_content = '<td valign="top">' . t_encodeHTML($extra['ac_extra_cat_desc']) . '</td>';
							}

							if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) ) {
								$extras_note_column = '<col />';
								$extras_note_column_content = '<td valign="top">' . t_encodeHTML($extra['rv_extra_note']) . '</td>';
							}
							if ( in_array(findSectionId($noteSections,"extraMemo"),$noteIds) ) {
								$extras_memo_column = '<col/>';
								$extras_memo_column_content = '<td valign="top">' . t_encodeHTML($extra['rv_extra_note_internal']) . '</td>';
							}



							$note_exists = true;
							$note_html .= '
								<tr>
									<td>&nbsp;</td>
									<td valign="top">' . $title . '</td>
									<td>
										<table width="100%" border="0" cellpadding="2" cellspacing="0" summary="" style="table-layout: fixed;">
											<col width="80" />
											' . $extra_category_column . '
											<col />
											'.(isset($extras_note_column) ? $extras_note_column : "").'
											'.(isset($extras_memo_column) ? $extras_memo_column : "").'
											<tr>
												<td valign="top">' . $extra['rv_extra_date_serv'] . '</td>
												' . $extra_category_column_content . '
												<td valign="top">' . t_encodeHTML($extra['ac_ext_desc']) . $extra_room_link . '</td>
												'.(isset($extras_note_column_content) ? $extras_note_column_content : "").'
												'.(isset($extras_memo_column_content) ? $extras_memo_column_content : "").'
											</tr>
										</table>
									</td>
								</tr>
							';
						}
					}
				}
				// [ END ] Extras ----------------------------------------------------------

				// [START] Travel notes & internal memos -----------------------------------
				if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds) && count($item['travel']) > 0) {
					if ( in_array(findSectionId($noteSections,"travelOnly"),$noteIds) ) {
						$travelOnly = true;
					} else {
						$travelOnly = false;
					}
					$first = true;
					foreach ( $item['travel'] as $travel ) {
						if ( ( $travelOnly &&  ( $travel['rv_extra_note'] != "" || $extra['rv_extra_note_internal'] != "" ) ) || !$travelOnly ) {
							if ( $first ) {
								$title = "Travel";
								$first = false;
							} else {
								$title = "&nbsp;";
							}

							$travel_category_column = '';
							$travel_category_column_content = '';

							if ( in_array(findSectionId($noteSections,"travelCat"),$noteIds) ) {
								$travel_category_column = '<col width="80" />';
								$travel_category_column_content = '<td valign="top">' . t_encodeHTML($travel['ac_extra_cat_desc']) . '</td>';
							}

							if ( in_array(findSectionId($noteSections,"extraCat"),$noteIds) ) {
								$extra_cat_column = '<col />';
								$extra_cat_column_content = '<td valign="top">' . t_encodeHTML($travel['ac_ext_desc']) . '</td>';
							}
							if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) ) {
								$travel_note_column = '<col />';
								$travel_note_column_content = '<td valign="top">' . t_encodeHTML(nl2br($travel['rv_extra_note'])) . '</td>';
							}
							if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
								$travel_memo_column = '<col />';
								$travel_memo_column_content = '<td valign="top">' . t_encodeHTML(nl2br($travel['rv_extra_note_internal'])) . '</td>';
							}

							$note_exists = true;
							$note_html .= '
								<tr>
									<td>&nbsp;</td>
									<td valign="top">' . $title . '</td>
									<td>
										<table width="100%" border="0" cellpadding="2" cellspacing="0" summary="" style="table-layout: fixed;">
											<col width="80" />
											' . $travel_category_column . '
											'.(isset($extra_cat_column) ? $extra_cat_column : "").'
											'.(isset($travel_note_column) ? $travel_note_column : "").'
											'.(isset($travel_memo_column) ? $travel_memo_column : "").'
											<tr>
												<td valign="top">' . $travel['rv_extra_date_serv'] . '</td>
												' . (isset($travel_category_column_content) ? $travel_category_column_content : "") . '
												'.(isset($extra_cat_column_content) ? $extra_cat_column_content : "").'
												'.(isset($travel_note_column_content) ? $travel_note_column_content : "").'
												'.(isset($travel_memo_column_content) ? $travel_memo_column_content : "").'
											</tr>
										</table>
									</td>
								</tr>
							';
						}
					}
				}
				// [ END ] Travel notes & internal memos -----------------------------------

				// [START] Guest information -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					if ( isset($item['rv_note_guests']) && trim($item['rv_note_guests']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Guest information:</td>
								<td>' . nl2br($item['rv_note_guests']) . '</td>
							</tr>
						';
					}
				}
				// [ END ] Guest information -----------------------------------------------

				// [START] Guest specific information --------------------------------------
				// [START] Guest names -----------------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestName"),$noteIds) ) {
					$guestNames = array();
					foreach ( $item['guests'] as $guests ) {
						array_push($guestNames,$guests['pr_name']);
					}

					if ( count($guestNames) > 0 ) {
						$guestNamesDisplay = join(", ",$guestNames);

						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Guest names:</td>
								<td>' . $guestNamesDisplay . '</td>
							</tr>
						';
					}
				}
				// [ END ] Guest names -----------------------------------------------------
				
				// [START] Guest nationality ------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestNationality"),$noteIds) ) {
					$guestNationality = array();
					foreach ( $item['guests'] as $guests ) {
						if ( !in_array($guests['nationality'],$guestNationality) && trim($guests['nationality']) != "" ) {
							array_push($guestNationality,$guests['nationality']);
						}
					}

					if ( count($guestNationality) > 0 ) {
						$guestNationalityDisplay = join("<br />",$guestNationality);

						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Guest nationality:</td>
								<td>' . $guestNationalityDisplay . '</td>
							</tr>
						';
					}
				}
				// [ END ] Guest nationality -----------------------------------------------

				// [START] Guest notes -----------------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					$guestNotes = array();
					foreach ( $item['guests'] as $guests ) {
						if ( isset($guests['pr_guest_note']) && trim($guests['pr_guest_note']) != "" ) {
							array_push($guestNotes,$guests['pr_name'] . ': ' . $guests['pr_guest_note']);
						}
					}

					if ( count($guestNotes) > 0 ) {
						$guestNotesDisplay = join("<br />",$guestNotes);
						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Guest notes:</td>
								<td>' . $guestNotesDisplay . '</td>
							</tr>
						';
					}
				}
				// [ END ] Guest notes -----------------------------------------------------

				// [START] Guest internal memos --------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestMemo"),$noteIds) ) {
					$guestInternalMemos = array();
					foreach ( $item['guests'] as $guests ) {
						if ( isset($guests['pr_guest_memo']) && trim($guests['pr_guest_memo']) != "" ) {
							array_push($guestInternalMemos,$guests['pr_name'] . ': ' . $guests['pr_guest_memo']);
						}
					}

					if ( count($guestInternalMemos) > 0 ) {
						$guestInternalMemosDisplay = join("<br />",$guestInternalMemos);
						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Guest internal memos:</td>
								<td>' . $guestInternalMemosDisplay . '</td>
							</tr>
						';
					}
				}
				// [ END ] Guest internal memos --------------------------------------------

				// [START] Guest special events --------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestSpecial"),$noteIds) ) {
					$guestSpecialEvents = array();
					foreach ( $item['guests'] as $guest ) {
						if ( $guest['has_birthday'] == "1" && $guest['pr_birthdate'] != "0000-00-00" ) {
							$date = ': ' . $guest['pr_birthdate'];
							array_push($guestSpecialEvents,"Birthday" . $date . ' - ' . $guest['pr_name'] );
						}
						if ( $guest['has_anniversary'] == "1" && $guest['pr_anniversary'] != "0000-00-00" ) {
							$date = ': ' . $guest['pr_anniversary'];
							array_push($guestSpecialEvents,"Anniversary" . $date . ' - ' . $guest['pr_name']);
						}
					}

					if ( count($guestSpecialEvents) > 0 ) {
						$guestSpecialEventsDisplay = join("<br />",$guestSpecialEvents);

						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">Guest special events:</td>
								<td>' . $guestSpecialEventsDisplay . '</td>
							</tr>
						';
					}
				}
				// [ END ] Guest special events --------------------------------------------
				// [ END ] Guest specific information --------------------------------------

				// [START] Room lock reason ------------------------------------------------
				if ( in_array(findSectionId($noteSections,"roomLockReason"),$noteIds) && isset($item['lock_reasons']) && count($item['lock_reasons']) > 0 ) {
					$first = true;
					foreach ( $item['lock_reasons'] as $lock ) {
						if ( $first ) {
							$title = "Room request reason";
							$first = false;
						} else {
							$title = "&nbsp;";
						}

						$note_exists = true;
						$note_html .= '
							<tr>
								<td>&nbsp;</td>
								<td valign="top">' . $title . '</td>
								<td>
									<table width="100%" border="0" cellpadding="0" cellspacing="0" summary="">
										<tr>
											<td valign="top">' . $lock['value'] . '</td>
										</tr>
									</table>
								</td>
							</tr>
						';
					}
				}
				// [ END ] Room lock reason ------------------------------------------------
				$note_html .= '</table>';
			}
			if ( $note_exists ) {
				$html .= $note_html;
			}
		}
	}
	return $html;
}

function generatePDFNotes($noteSections,$noteIds,$notes,$noteSort) {

	$pdfRow	   = array();
	$pdfNotes	 = array();
	$pdfNoteArray = array();

	$cellwidth   = '25';
	$x_cellwidth = '12.5';

// debug($noteIds);
// debug($noteSections);
// debug($notes);

	/* ---------------------------------------------------------------------------
	ORDER FOR NOTES:
	Reservation notes
	Internal memos
	Extras notes
	Extras internal memos
	Only show extras with notes/memos
	Travel notes
	Travel internal memos
	Only show travel with notes/memos
	Guest information
	Guest specific information
		Guest names
		Guest notes
		Guest internal memos
		Special events
	Room lock reason
	---------------------------------------------------------------------------	*/

	if ( count($notes) > 0 ) {

		switch ( $noteSort ) {
			case "1":
				$mainColHeading = array("Arrival date","Departure date","Res. Name","Res. Number");
				break;
			case "2":
				$mainColHeading = array("Departure date","Res. Name","Res. Number","Arrival date");
				break;
			case "3":
				$mainColHeading = array("Res. Number","Arrival date","Departure date","Res. Name");
				break;
			case "4":
				$mainColHeading = array("Res. Name","Arrival date","Departure date","Res. Number");
				break;
		}

		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[0],'border'=>'LTRB'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[1],'border'=>'LTRB'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[2],'border'=>'LTRB'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[3],'border'=>'LTRB'));

		array_push($pdfNotes,$pdfRow);
		$pdfRow = array();

		foreach ( $notes as $item ) {
			// Used to suppress reservations with no notes --------------------
			$note_exists = false;

			if ( count($item) > 0 ) {
				/* ------------------------------------------------------------
					TITLE SORT ORDER
					1: Arrival date
					2: Departure date
					3: Reservation ID
					4: Reservation name
				------------------------------------------------------------ */
				switch ( $noteSort ) {
					case "1":
						$title = array($item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_res_name'],$item['rv_reservation_ix']);
						break;
					case "2":
						$title = array($item['rv_date_depart_fmt'],$item['rv_res_name'],$item['rv_reservation_ix'],$item['rv_date_arrive_fmt']);
						break;
					case "3":
						$title = array($item['rv_reservation_ix'],$item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_res_name']);
						break;
					case "4":
						$title = array($item['rv_res_name'],$item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_reservation_ix']);
						break;
				}

				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[0],'border'=>'LTRB'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[1],'border'=>'LTRB'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[2],'border'=>'LTRB'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[3],'border'=>'LTRB'));

				array_push($pdfNotes,$pdfRow);
				$pdfRow = array();

				// [START] Reservation Notes -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNote"),$noteIds) ) {
					if ( isset($item['rv_note_general']) && $item['rv_note_general'] != '' ) {
						$note_exists = true;

						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Reservation notes:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$item['rv_note_general'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Reservation Notes -----------------------------------------------

				// [START] Internal Memos --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resMemo"),$noteIds) ) {
					if ( isset($item['rv_note_internal']) && trim($item['rv_note_internal']) != "" ) {
						$note_exists = true;

						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Internal memos:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$item['rv_note_internal'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Internal Memos --------------------------------------------------

				// [START] Extras ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"extraMemo"),$noteIds) && count($item['extras']) > 0 ) {
					if ( in_array(findSectionId($noteSections,"extraOnly"),$noteIds) ) {
						$extraOnly = true;
					} else {
						$extraOnly = false;
					}
					$first = true;
					foreach ( $item['extras'] as $extra ) {
						if ( ( $extraOnly &&  ( $extra['rv_extra_note'] != "" || $extra['rv_extra_note_internal'] != "" ) ) || !$extraOnly ) {
							if ( $first ) {
								$title = "Extras";
								$first = false;
							} else {
								$title = " ";
							}

							if ( isset($extra['ac_desc']) && $extra['ac_desc'] != "" ) {
								$extra_room_link = ' (' . $extra['ac_desc'] . ')';
							} else {
								$extra_room_link = '';
							}

							$note_exists = true;
							array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$cellwidth . '%', 'data'=>$title, 'border'=> 'LTRB'));

							// Extra information
							if ( in_array(findSectionId($noteSections,"extraCat"),$noteIds) ) {
								$x_cellwidth = 10;
							}

							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=> $extra['rv_extra_date_serv'], 'border'=>'LTRB'));
							
							if ( in_array(findSectionId($noteSections,"extraCat"),$noteIds) ) {
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$extra['ac_extra_cat_desc'],'border'=>'LTRB'));
							}
							array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$extra['ac_ext_desc'] . $extra_room_link,'border'=>'LTRB'));
							
							if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) ) {
								$data = $extra['rv_extra_note'];
							} else {
								$data = '';
							}
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$data, 'border'=> 'LTRB'));	
							
							if ( in_array(findSectionId($noteSections,"extraMemo"),$noteIds) ) {
								$data = $extra['rv_extra_note_internal'];
							} else {
								$data = '';
							}
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$data, 'border'=> 'LTRB'));
							
							
							array_push($pdfNotes,$pdfRow);
							$pdfRow = array();
						}
					}
				}
				// [ END ] Extras ----------------------------------------------------------

				// [START] Travel notes & internal memos -----------------------------------
				if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
					if ( in_array(findSectionId($noteSections,"travelOnly"),$noteIds) ) {
						$travelOnly = true;
					} else {
						$travelOnly = false;
					}
					$first = true;
					foreach ( $item['travel'] as $travel ) {
						if ( ( $travelOnly &&  ( $travel['rv_extra_note'] != "" || $extra['rv_extra_note_internal'] != "" ) ) || !$travelOnly ) {
							if ( $first ) {
								$title = "Travel";
								$first = false;
							} else {
								$title = " ";
							}

							$note_exists = true;
							array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title,'border'=>'LTRB'));

							if ( in_array(findSectionId($noteSections,"travelCat"),$noteIds) ) {
								$x_cellwidth = 10;
							}

							array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['rv_extra_date_serv'],'border'=>'LTRB'));
							if ( in_array(findSectionId($noteSections,"travelCat"),$noteIds) ) {
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['ac_extra_cat_desc'],'border'=>'LTRB'));
							}
							array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['ac_ext_desc'],'border'=>'LTRB'));
							if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) && isset($extra['rv_extra_note']) ) {
								$data = $extra['rv_extra_note'];
							} else {
								$data = '';
							}
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$data, 'border'=> 'LTRB'));
							
							if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) && isset($extra['rv_extra_note_internal']) ) {
								$data = $extra['rv_extra_note_internal'];
							} else {
								$data = '';
							}
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$data, 'border'=> 'LTRB'));
						/*	if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['rv_extra_note_internal'],'border'=>'LTRB'));
							}*/
							
							array_push($pdfNotes,$pdfRow);
							$pdfRow = array();
						}
					}
				}
				// [ END ] Travel notes & internal memos ----------------------------------

				// [START] Guest information -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					if ( isset($item['rv_note_guests']) && trim($item['rv_note_guests']) != "" ) {
						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest information:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$item['rv_note_guests'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest information -----------------------------------------------

				// [START] Guest specific information --------------------------------------
				// [START] Guest names -----------------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestName"),$noteIds) ) {
					$guestNames = array();
					foreach ( $item['guests'] as $guests ) {
						array_push($guestNames,$guests['pr_name']);
					}

					if ( count($guestNames) > 0 ) {
						$guestNamesDisplay = join(", ",$guestNames);

						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest names:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$guestNamesDisplay,'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest names ----------------------------------------

				// [START] Guest nationality ----------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestNationality"),$noteIds) ) {
					$guestNationality = array();
					foreach ( $item['guests'] as $guests ) {
						if ( !in_array($guests['nationality'],$guestNationality) && trim($guests['nationality']) != "" ) {
							array_push($guestNationality,$guests['nationality']);
						}
					}

					if ( count($guestNationality) > 0 ) {
						$guestNationalityDisplay = join("\n",$guestNationality);

						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest nationality:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$guestNationalityDisplay,'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest nationality ----------------------------------

				// [START] Guest notes ----------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					$guestNotes = array();
					foreach ( $item['guests'] as $guests ) {
						if ( isset($guests['pr_guest_note']) && trim($guests['pr_guest_note']) != "" ) {
							array_push($guestNotes,$guests['pr_name'] . ': ' . $guests['pr_guest_note']);
						}
					}

					if ( count($guestNotes) > 0 ) {
						$guestNotesDisplay = join(" ",$guestNotes);
						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest notes:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$guestNotesDisplay,'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest notes ----------------------------------------

				// [START] Guest internal memos -------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestMemo"),$noteIds) ) {
					$guestInternalMemos = array();
					foreach ( $item['guests'] as $guests ) {
						if ( trim($guests['pr_guest_memo']) != '' ) {
							array_push($guestInternalMemos,$guests['pr_name'] . ': ' . $guests['pr_guest_memo']);
						}
					}

					if ( count($guestInternalMemos) > 0 ) {
						$guestInternalMemosDisplay = join("\n",$guestInternalMemos);
						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest internal memos:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$guestInternalMemosDisplay,'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest internal memos -------------------------------

				// [START] Guest special events -------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && in_array(findSectionId($noteSections,"guestSpecial"),$noteIds) ) {
					$guestSpecialEvents = array();
					foreach ( $item['guests'] as $guest ) {
						if ( $guest['has_birthday'] == "1" && $guest['pr_birthdate'] != "0000-00-00" ) {
							$date = ': ' . $guest['pr_birthdate'];
							array_push($guestSpecialEvents,"Birthday" . $date . ' - ' . $guest['pr_name'] );
						}
						if ( $guest['has_anniversary'] == "1" && $guest['pr_anniversary'] != "0000-00-00" ) {
							$date = ': ' . $guest['pr_anniversary'];
							array_push($guestSpecialEvents,"Anniversary" . $date . ' - ' . $guest['pr_name']);
						}
					}

					if ( count($guestSpecialEvents) > 0 ) {
						$guestSpecialEventsDisplay = join("\n",$guestSpecialEvents);

						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest special events:','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 2) . '%','data'=>$guestSpecialEventsDisplay,'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest special events -------------------------------
				// [ END ] Guest specific information -------------------------

				// [START] Room lock reason -----------------------------------
				if ( in_array(findSectionId($noteSections,"roomLockReason"),$noteIds) && isset($item['lock_reasons']) && count($item['lock_reasons']) > 0 ) {
					$first = true;
					foreach ( $item['lock_reasons'] as $lock ) {
						if ( $first ) {
							$title = "Room request reason";
							$first = false;
						} else {
							$title = " ";
						}

						$note_exists = true;
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title,'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 20) . '%','data'=>$lock['value'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Room lock reason -----------------------------------
			}
			if ( $note_exists ) {
				array_push($pdfNoteArray,$pdfNotes);
				$pdfNotes = array();
			}
		}
	}
	return $pdfNoteArray;
}

function generateLegend($chartSections,$chartIds,$data) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$legendIds = $chartIds['legend'];

	$legend = '';
	$legendArrayRoom = array();
	$legendArrayDepart = array();
	$legendArrayRoomShow = array();
	$legendArrayDepartShow = array();

	foreach ( $data['rows'] as $row )	{
		foreach ( $data['columns'] as $col ) {
			$c = isset($data['room'][$row['id']][$col['id']]) ? $data['room'][$row['id']][$col['id']] : "";
			$d = isset($data['depart'][$row['id']][$col['id']]) ? $data['depart'][$row['id']][$col['id']] : "";

			foreach ( $showIds as $showId ) {
				if ( in_array($showId,$legendIds) ) {
	
					if ( !isset($c[$showId]['value']) || !is_array($c[$showId]['value']) ) {
						if ( in_array($showId,$colourIds) && isset($c[$showId]['colour']) && $c[$showId]['colour'] != "" ) {
							$colour = "#" . $c[$showId]['colour'];
							$key = $c[$showId]['value'];
							$legendArrayRoom[$key] = $colour;
							if ( !isset($legendArrayRoomShow[$key]) || !is_array($legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = array();
							}
							if ( !in_array($showId,$legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = $showId;
							}
						}
					}
				}
			}

			foreach ( $departIds as $departId ) {
				if ( in_array($departId,$legendIds) ) {
					if ( !isset($d[$departId]['value']) || !is_array($d[$departId]['value']) ) {
						if ( in_array($departId,$colourIds) && isset($d[$departId]['colour']) && $d[$departId]['colour'] != "" ) {
							$colour	= "#" . $d[$departId]['colour'];
							$key		= $d[$departId]['value'];
							$legendArrayDepart[$key] = $colour;
							if ( !isset($legendArrayDepartShow[$key]) || !is_array($legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = array();
							}
							if ( !in_array($departId,$legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = $departId;
							}
						}
					}
				}
			}
		}
	}

	$merged		= array_merge($legendArrayRoom,$legendArrayDepart);
	$mergedShow	= array_merge($legendArrayRoomShow,$legendArrayDepartShow);
	asort($mergedShow);

	$thisSection = "";
	foreach ( $mergedShow as $description => $section ) {
		if ( $thisSection != $section ) {
			$thisSection = $section;
			$legend .= '<div style="clear: both; margin: 0px 2px;" class="bt"><strong>' . $chartSections[$section-1]['label'] . '(s):</strong></div>';
		}

		$legend .= '
			<div style="float: left; width: 250px; margin: 2px;">
				<table width="250" border="0" cellpadding="0" cellspacing="0" summary="" style="table-layout: fixed;">
					<col width="20" />
					<col width="230" />
					<tr>
						<td class="bAll" style="background-color: ' . $merged[$description] . ';">&nbsp;</td>
						<td>&nbsp;' . $description . '</td>
					</tr>
				</table>
			</div>
		';
	}
	$legend .= '<hr style="clear: both; margin: 0; height: 1px; visibility: hidden;" />';
	return $legend;
}


function generatePDFLegend($chartSections,$chartIds,$data) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$legendIds = $chartIds['legend'];

	$legend = '';

	$legendArrayRoom   = array();
	$legendArrayDepart = array();
	$legendArrayRoomShow = array();
	$legendArrayDepartShow = array();

	foreach ( $data['rows'] as $row ) {
		foreach ( $data['columns'] as $col ) {
			$c = isset($data['room'][$row['id']][$col['id']]) ? $data['room'][$row['id']][$col['id']] : "";
			$d = isset($data['depart'][$row['id']][$col['id']]) ? $data['depart'][$row['id']][$col['id']] : "";

			foreach ( $showIds as $showId ) {
				if ( in_array($showId,$legendIds) ) {

					if ( !isset($c[$showId]['value']) || !is_array($c[$showId]['value']) ) {
						if ( in_array($showId,$colourIds) && isset($c[$showId]['colour']) && $c[$showId]['colour'] != "" ) {
							$colour = "#" . $c[$showId]['colour'];
							$key = $c[$showId]['value'];
							$legendArrayRoom[$key] = $colour;
							if ( !isset($legendArrayRoomShow[$key]) || !is_array($legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = array();
							}
							if ( !in_array($showId,$legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = $showId;
							}
						}
					}
				}
			}

			foreach ( $departIds as $departId ) {
				if ( in_array($departId,$legendIds) ) {
					if ( !isset($d[$departId]['value']) || !is_array($d[$departId]['value']) ) {
						if ( in_array($departId,$colourIds) && isset($d[$departId]['colour']) && $d[$departId]['colour'] != '' ) {
							$colour = '#' . $d[$departId]['colour'];
							$key	= $d[$departId]['value'];
							$legendArrayDepart[$key] = $colour;
							if ( !isset($legendArrayDepartShow[$key]) || !is_array($legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = array();
							}
							if ( !in_array($departId,$legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = $departId;
							}
						}
					}
				}
			}
		}
	}

	$merged	 = array_merge($legendArrayRoom,$legendArrayDepart);
	$mergedShow = array_merge($legendArrayRoomShow,$legendArrayDepartShow);
	asort($mergedShow);

	$thisSection = '';
	$legendRow = array();
	$pdfLegend = array(
						array(array('width'=>'100%','data'=>'<B>LEGEND</B>','fontSize'=>'8','border'=>'TRL')),
						array(array('width'=>'100%','data'=>'','border'=>'TRL')),
						array(
								array('width'=>'2%','data'=>'','border'=>'L'),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xd0,0xd0,0xd0),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Blocked Room','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0x10,0x7d,0xf8),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Paid','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xff,0x80,0x00),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Part Paid','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xff,0x00,0x00),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'No Payment','border'=>'R')
							),
						array(array('width'=>'100%','data'=>'','border'=>'RL')),
						array(
								array('width'=>'2%','data'=>'','border'=>'L'),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xf1,0xc5,0x5d),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Provisional expiring today','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xdb,0x42,0x42),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Expired provisional','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xf2,0xf2,0xf2),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Departure information','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'23%','data'=>'Provisional reservation','textColor'=>array(0x33,0x66,0x99),'border'=>'R')
							),
						array(array('width'=>'100%','data'=>'','border'=>'BRL'))
					);
	$count = 1;
	foreach ( $mergedShow as $description => $section ) {
		if ( $thisSection != $section ) {
			$thisSection = $section;
			array_push($pdfLegend,array(array('width'=>'100%','data'=>$chartSections[$section-1]['label'] . '(s):','border'=>'TRLB')));
		}

		$colour = array(
						hexdec(substr($merged[$description],1,2)),
						hexdec(substr($merged[$description],3,2)),
						hexdec(substr($merged[$description],5,2))
						);

		array_push($legendRow,array('width'=>'2%','data'=>'','border'=>''));
		array_push($legendRow,array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>$colour,'border'=>'LTRB'));
		array_push($legendRow,array('width'=>'20%','data'=>$description,'border'=>''));

		if ( $count%4 == 0 ) {
			// Add nice borders for the legend sections -----------------------
			for ( $i = 0; $i < 12; $i++ ) {
				if ( $i == 0 ) {
					$legendRow[$i]['border'] = 'L';
				}
				if ( $i == 11 ) {
					$legendRow[$i]['border'] = 'R';
				}
			}
			array_push($legendRow,array('width'=>'100%','data'=>'','border'=>'RL'));
			array_push($pdfLegend,$legendRow);
			$legendRow = array();
		}
		$count++;
	}
	array_push($pdfLegend,array(array('width'=>'100%','data'=>'','border'=>'T')));

	return $pdfLegend;

}


function outputHTML($chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showLegend,$showUnitLabel,$showUnitNumber,$showDatePAX,$autoRoom,$data, $showCatExtras) {
	
	$GLOBALS['temp']['showResults']   = '';
	$GLOBALS['temp']['displayChart']  = '';
	$GLOBALS['temp']['displayNotes']  = '';
	$GLOBALS['temp']['displayLegend'] = '';

	if ( $showChart  == '2' ) { $GLOBALS['temp']['displayChart']  = "collapse printCollapse"; }
	if ( $showNotes  == '2' ) { $GLOBALS['temp']['displayNotes']  = "collapse printCollapse"; }
	if ( $showLegend == '2' ) { $GLOBALS['temp']['displayLegend'] = "collapse printCollapse"; }

	$GLOBALS['temp']['rows']   = generateChart($chartSections,$chartIds,$data['chart'],$showUnitLabel,$showUnitNumber,$showDatePAX,$autoRoom, $showCatExtras);
	$GLOBALS['temp']['notes']  = generateNotes($noteSections,$noteIds,$data['notes'],$noteSort);
	$GLOBALS['temp']['legend'] = generateLegend($chartSections,$chartIds,$data['chart']);
}

function outputPDF($renderType,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showLegend,$showUnitLabel,$showUnitNumber,$showDatePAX,$data,$fromDate,$toDate,$propertyFilter, $showCatExtras,$title) {
	$error = false;
	define("MAX_CHAR_PDF",18);
	$cells = array();
	$multiCell = array();
	$tempCell = array();
	$pdf = new PDF($title,'L');
	$reportLabel = $title;
	$pdfFontSize = 6;
	$pdf->SetFont('Arial', '', $pdfFontSize);

	$pdf_chart_data = $data['chart'];

	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];

	$cellwidth   = 10;
	$table_width = 100;
	$max_columns_per_page = 8;
	$number_of_pages = ceil(count($data['chart']['columns'])/($max_columns_per_page));

	$pdfPage = array();
	$row_count = 0;
	if ( $pdf_chart_data['direction'] == "1" ) {
		$pdfRow = array();

		array_push($pdfRow,array('width'=>$cellwidth*2 . '%','data'=>'','border'=>''));
		// Room names along top
		$property_name   = '';
		$colcount		= 0;
		$current_page	= 0;
		$pdfDataRow	  = $pdfRow;
		$current_property = array();
		foreach ( $pdf_chart_data['columns'] as $col ) {
			$this_cell_width = $colcount * $cellwidth;

			if ( $colcount == $max_columns_per_page ) {
				foreach ( $current_property as $c ) {
					array_push($pdfDataRow,array('width'=>$cellwidth * $c['count'] . '%','data'=> ( isset($c['name']) ? $c['name'] : ""),'border'=>'LTRB'));
				}
				
				$pdfPageHeader[0][$current_page] = $pdfDataRow;
				$pdfDataRow	= $pdfRow;
				$current_property = array();
				$property_name = '';
				$colcount	  = 0;
				$current_page++;
			}

			if ( $property_name != $col['property'] ) {
				array_push($current_property,array('name'=>$col['property']));
				$property_name = $col['property'];
			}
			$colcount++;

			if ( count($current_property) > 1 ) {
				$current_property[count($current_property) - 1]['count'] = $colcount - $current_property[count($current_property) - 2]['count'];
			} else {
				$current_property[count($current_property) - 1]['count'] = $colcount;
			}
		}
		$pdfRow = array();

		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>''));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Details','border'=>'LTRB'));

		// Room names and numbers ---------------------------------------------
		$colcount	 = 0;
		$current_page = 0;
		$pdfDataRow = $pdfRow;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			if ( $colcount == $max_columns_per_page ) {
				$pdfPageHeader[1][$current_page] = $pdfDataRow;
				$pdfDataRow = $pdfRow;
				$colcount = 0;
				$current_page++;
			}

			$accommCell = $col['accommodation'];
			if ( $showUnitLabel == "1" && isset($col['unit_label']) ) {
				$accommCell .= "\n" . $col['unit_label'];
			}
			if ( $showUnitNumber == "1" && isset($col['room']) ) {
				$accommCell .= "\n" . $col['room'];
			}
			array_push($pdfDataRow,array('width'=>$cellwidth.'%','data'=>$accommCell,'border'=>'LTRB'));
			$colcount++;
		} 
		
	} else {
		// Dates along top
		$pdfRow = array();
		array_push($pdfRow,array('width'=>$cellwidth .  '%','data'=>'','border'=>'LTRB'));
		array_push($pdfRow,array('width'=>$cellwidth .  '%','data'=>'Details','border'=>'LTRB'));

		$colcount	 = 0;
		$current_page = 0;
		$pdfDataRow = $pdfRow;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			if ( $colcount == $max_columns_per_page ) {
				$pdfPageHeader[0][$current_page] = $pdfDataRow;
				$pdfDataRow = $pdfRow;
				$colcount = 0;
				$current_page++;
			}

			$thisDate = explode("-",$col['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
			$dateRow = $displayDate . " " . $col['name'];
			if ( $showDatePAX == "1" ) {
				$dateRow .= "\nPAX " . $col['pax_total'] . " (Ad:" . $col['pax_adult'] . " Ch:" . $col['pax_child'] . ")";
			}
			array_push($pdfDataRow,array('width'=>$cellwidth .  '%','data'=>$dateRow,'border'=>'LTRB'));
			$colcount++;
		}
	}
	$rowCount = 3;
	$roomRowSpans	= getRowSpans($pdf_chart_data,"room",$showIds);
	$departRowSpans	= getRowSpans($pdf_chart_data,"depart",$departIds);
	
	$showDepartureInfo = true;

	if ( $pdf_chart_data['direction'] == '2' ) {
		$property_name	= '';
	}

	foreach ( $pdf_chart_data['rows'] as $row ) {
		$pdfRow = array();
		$totalSubCellRoom = array_sum($roomRowSpans[$row['id']]);
		$totalSubCellDepart = array_sum($departRowSpans[$row['id']]);
		$multiCell[$rowCount] = array();

		if ( $pdf_chart_data['direction'] == "1" ) {
			$thisDate = explode("-",$row['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		}

		// Place the property name
		if ( $pdf_chart_data['direction'] == "2" ) {
			if ( $property_name != $row['property'] ) {
				$property_name = $row['property'];
				for ( $i = 0; $i < $number_of_pages; $i++ ) {
					$pdfPage[$row_count][$i] = array(array('width'=>$table_width . '%','data'=>$property_name,'border'=>'LTRB'));
				}
				$row_count++;
			}
		}

		// Here we look at each row and try to determine if there is any departure
		// information in any of the row's columns. If not, then we don't display 
		// the departure row
		$departInfoExists = false;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			$d = isset($pdf_chart_data['depart'][$row['id']][$col['id']]) ? $pdf_chart_data['depart'][$row['id']][$col['id']] : array();
			if ( count($d) > 0  && $d != "" ) {
				foreach ( $d as $blah ) {
					if ( isset($blah['value']) && $blah['value'] != "" ) {
						$departInfoExists = true;
					}
				}
			}
		}

		// [START] Display Departure information ------------------------------
		if ( count($departIds) > 0 && $departInfoExists && $showDepartureInfo ) {
			// [START] Departure information row ------------------------------
			if ( $pdf_chart_data['direction'] == "1" ) {
				$roomInfo = $displayDate . " " . $row['name'];
				$cell = array('width'=>$cellwidth . '%','data'=>'DEPART','border'=>'LR');
				array_push($tempCell, $cell);
				$cell = array('width'=>$cellwidth .  '%','data'=>$roomInfo,'border'=>'LRT');
				array_push($tempCell, $cell);
				
				for($count=3; $count<=$totalSubCellDepart;$count++) {
					if($count == $totalSubCellDepart) {
						$styleId = 'LRB';
					} else {
						$styleId = 'LR';
					}
					$cell = array('width'=>$cellwidth . '%','data'=>'','border'=>$styleId);
					array_push($tempCell, $cell);
				}
				array_push($multiCell[$rowCount], $tempCell);
				
			} else {
				$roomInfo = $row['accommodation'];
				if ( $showUnitLabel == "1" && isset($row['unit_label'])) {
					$roomInfo .= "\n" . $row['unit_label'];
				}
				if ( $showUnitNumber == "1" && isset($row['room'])) {
					$roomInfo .= "\n" . $row['room'];
				}
				$roomInfo = "DEPART\n" . $roomInfo; 
			
			}
			array_push($pdfRow, $tempCell);
			
			// [START] Departure section headings -----------------------------
			$tempCell = array();
			$styleFlag = 1;   
			foreach ( $departIds as $departId ) {
				$sectionId = 0;
				$repFlag = 0;
				if($styleFlag == 1) {
					$styleId = "LRT";
				} else if($styleFlag == $totalSubCellDepart) {
					$styleId = "LRB";
				} else {
					$styleId = "LR";
				}
				
				foreach ( $chartSections as $item ) {
					if ( $item['id'] == $departId ) {
						if($departId<23){
							$dep_data = strlen($item['label'])>MAX_CHAR_PDF?substr($item['label'],0,MAX_CHAR_PDF) . "..":$item['label'];
							$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$styleId);
							array_push($tempCell, $cell);
														
							if ( $departRowSpans[$row['id']][$departId] > 1 ) {
								for ( $count = 1; $count < $departRowSpans[$row['id']][$departId]; $count++ ){
									$cell = array('width'=>$cellwidth.'%','data'=>'','border'=>$styleId);
									array_push($tempCell, $cell);
									$styleFlag++;
								}
							}
						}

						else if($departId>=23) {
							for ( $count = 0; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
								if($departId ==23 || $departId == 26) {
									if(in_array($departId, $departIds)) {
										$dep_data = strlen($chartSections[$sectionId]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId]['label'];
										$cell = array('width'=>$cellwidth.'%', 'data'=>$dep_data, 'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+1, $departIds)) {
										if($styleFlag+1 == $totalSubCellDepart) {
											$styleId = "LRB";
										}
										$dep_data = strlen($chartSections[$sectionId+1]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId+1]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId+1]['label'];
										
										$cell = array('width'=>$cellwidth. '%', 'data'=>$dep_data, 'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+2, $departIds)) {
										if($styleFlag+2 == $totalSubCellDepart) {
											$styleId = "LRB";
										}
										$dep_data = strlen($chartSections[$sectionId+2]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId+2]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId+2]['label'];
										
										$cell = array('width'=>$cellwidth. '%','data'=>$dep_data, 'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($departId ==24 || $departId == 27) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$dep_data = strlen($chartSections[$sectionId]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId]['label'];
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data, 'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+1, $departIds)) {
										if($styleFlag+1 == $totalSubCellDepart) {
											$styleId = "LRB";
										}
										$dep_data = strlen($chartSections[$sectionId+1]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId+1]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId+1]['label'];
										
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data, 'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($departId ==25 || $departId == 28) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$dep_data = strlen($chartSections[$sectionId]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId]['label'];
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									
									$repflag = 1;
								}
								$styleFlag++;
							}
						}
						if($item['id']==25){
							$repflag = 0;
						}
					}
					$sectionId++;
				}
				if($departId<23){
					$styleFlag++;
				}
			}
			
			array_push($multiCell[$rowCount], $tempCell);
			array_push($pdfRow, $tempCell);
			$tempCell = array();
			
			// [ END ] Departure section headings -----------------------------

			// [START] Departure information ----------------------------------
			$colcount	 = 0;
			$current_page = 0;
			$pdfDataRow   = $pdfRow;
			foreach ( $pdf_chart_data['columns'] as $col ) {
				if ( $colcount == $max_columns_per_page ) {
					$pdfPage[$current_page][$row_count] = $pdfDataRow;
					$pdfDataRow = $pdfRow;
					$colcount = 0;
					$current_page++;
				}

				$d = isset($pdf_chart_data['depart'][$row['id']][$col['id']]) ? $pdf_chart_data['depart'][$row['id']][$col['id']] : "";
				$b = isset($pdf_chart_data['block'][$row['id']][$col['id']]) ? $pdf_chart_data['block'][$row['id']][$col['id']] : "";
				
				$initialColour = array(0xff,0xff,0xff);
				if ( $b ) {
					$initialColour = array(0xc0,0xc0,0xc0);
				}
				$styleFlag = 1;
				foreach ( $departIds as $departId ) {
					// [START] Colour Handling --------------------------------
					 $colour	 = $initialColour;
					$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";

					// Provisional booking
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 20 ) {
						$fontColour = array(0x33,0x66,0x99);
					}

					// Provisional expiring today
					if ( isset($d['rv_provision_expiry_date']) && $d['rv_provision_expiry_date'] == date("Y-m-d") ) {
						$colour	 = array(0xf1,0xc5,0x5d);
						$fontColour = array(0x00,0x00,0x00);
					}

					// Allocation
					if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 15 ) {
						$fontColour = array(0x99,0x99,0x99);
					}
					// [ END ] Colour Handling ------------------------------------
					
					if($styleFlag == 1) {
						$border = "LRT";
					} else if ($styleFlag == $totalSubCellDepart) {
						$border = "LRB";
					} else {
						$border = "LR";
					}

					if ( isset($d[$departId]['value']) && !is_array($d[$departId]['value']) ) {
						// [START] Colour handling ----------------------------------------------
						if ( in_array($departId,$colourIds) && isset($d[$departId]['colour']) && $d[$departId]['colour'] != "" ) {
							$colour = array( 
									hexdec(substr($d[$departId]['colour'],0,2)),
									hexdec(substr($d[$departId]['colour'],2,2)),
									hexdec(substr($d[$departId]['colour'],4,2))
								);
						}	

						if ( $error ) {
							$colour		= array(0xdb,0x42,0x42);
							$fontColour = array(0xff,0xff,0xff);
						}
						// [END] Colour handling ----------------------------------------------

						$dep_data = strlen($d[$departId]['value'])>MAX_CHAR_PDF?substr($d[$departId]['value'],0,MAX_CHAR_PDF) :$d[$departId]['value'];
							
						$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> 1, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
						array_push($tempCell, $cell);
											
					} else {
						if($departId <23){
							$used = 0;
							if (isset($d[$departId]['value'])) {
								foreach ( $d[$departId]['value'] as $cellItem ) {
									// [START] Colour handling -----------------------------------------
									if ( in_array($departId,$colourIds) && $cellItem['colour'] != "" ) {
										$colour = array( 
												 hexdec(substr($cellItem['colour'],0,2)),
												 hexdec(substr($cellItem['colour'],2,2)),
												 hexdec(substr($cellItem['colour'],4,2))
												);
									}
									if ( $error ) {
										$colour	= array(0xdb,0x42,0x42);
										$fontColour	= array(0xff,0xff,0xff);
									}
									// [ END ] Colour handling -----------------------------------------
										
									$dep_data = strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'];
									
									$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> 1, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
									$used++;
								}
							}
							if ( $used < $departRowSpans[$row['id']][$departId] ) {
								for ( $count = 0; $count < ($departRowSpans[$row['id']][$departId] - $used); $count++ ) {
									$cell = array('width'=>$cellwidth . '%','data'=>'', 'border'=>$border);
									array_push($tempCell, $cell);
								}
							}
						}
						else if($departId>=23) {
							if($departId==26) {
								$repFlag = 0;
							} else if(!in_array(26,$departIds) && $departId == 27) {
								$repFlag = 0;
							}
							else if(!in_array(26,$departIds) && !in_array(27,$departIds) && $departId == 28) {
									$repFlag = 0;
							}
							for ( $count = 0; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
								$first = false;
								$cellItem = isset($d[$departId]['value'][$count]) ? $d[$departId]['value'][$count] : array();
								$cellItem2 = isset($d[$departId+1]['value'][$count]) ? $d[$departId+1]['value'][$count] : array();
								$cellItem3 = isset($d[$departId+2]['value'][$count]) ? $d[$departId+2]['value'][$count] : array();
								
								// [START] Colour handling ---------------------------------------------
								$fill1 = 0;
								 $colour	 = $initialColour;
								$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
								
								if ( in_array($departId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != "" ) {
									$colour = array( 
										 hexdec(substr($cellItem['colour'],0,2)),
										 hexdec(substr($cellItem['colour'],2,2)),
										 hexdec(substr($cellItem['colour'],4,2))
									);
								}
								if(!empty($colour)) {
									$fill = 1;
								}
										
								// [ END ] Colour handling --------------------------------------------
									
								if($departId ==23 || $departId == 26) {
									if(in_array($departId, $departIds)) {
										$dep_data = !empty($cellItem['value']) ? ( strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'] ) : "";
										
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+1, $departIds)) {
										if($styleFlag+1 == $totalSubCellDepart) {
											$border = "LRB";
										}
										$dep_data = !empty($cellItem2['value']) ? ( strlen($cellItem2['value'])>MAX_CHAR_PDF?substr($cellItem2['value'],0,MAX_CHAR_PDF):$cellItem2['value'] ) : "";
										
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+2, $departIds)) {
										if($styleFlag+2 == $totalSubCellDepart) {
											$border = "LRB";
										}
										$dep_data = !empty($cellItem3['value']) ? ( strlen($cellItem3['value'])>MAX_CHAR_PDF?substr($cellItem3['value'],0,MAX_CHAR_PDF):$cellItem3['value'] ) : "";
											
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($departId ==24 || $departId == 27) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$dep_data = strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'];
											
										$cell = array('width'=>$cellwidth. '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
											array_push($tempCell, $cell);
									}
									if(in_array($departId+1, $departIds)) {
										if($styleFlag+1 == $totalSubCellDepart) {
											$border = "LRB";
										}
										$dep_data = !empty($cellItem2['value']) ? ( strlen($cellItem2['value'])>MAX_CHAR_PDF?substr($cellItem2['value'],0,MAX_CHAR_PDF):$cellItem2['value'] ) : "";
										
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($departId ==25 || $departId == 28) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$dep_data = strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'];
										
										$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
										array_push($tempCell, $cell);
									}
									$repflag = 0;
								}
							}
						}
						$first = false;
					}
					if (isset($contFlag)) {
						$contFlag++;
					} else {
						$contFlag = 1;
					}
					
					if( (isset($departId) && $departId<23) || (isset($d[$departId]['value']) && !is_array($d[$departId]['value'])) ) {
						if (isset($styleFlag)) {
							$styleFlag++;
						} else {
							$styleFlag = 1;
						}
					}
				}
				array_push($multiCell[$rowCount], $tempCell);
				array_push($pdfDataRow, $tempCell);
				$tempCell = array();
				$colcount++;
			}
			$row_count++;
			$cells = array();
			$rowCount++;
			$multiCell[$rowCount] = array();
		} else {
			$bool_depart = false;
		}
		// [ END ] Display Departure information ------------------------------

		$pdfRow = array();
		// [START] Room information row ---------------------------------------------
		if ( $pdf_chart_data['direction'] == "1" ) {
			$roomInfo = $displayDate . '' . $row['name'];
			if ( $showDatePAX == "1" ) {
				$paxCount = "PAX " . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
			}

			$cell = array('width'=>$cellwidth . '%','data'=>'ARR/STAYOVER','border'=>'LR');
			array_push($tempCell, $cell);
			$cell = array('width'=>$cellwidth . '%','data'=>$roomInfo,'border'=>'LRT');
			array_push($tempCell, $cell);
			
			$cell = array('width'=>$cellwidth . '%','data'=>$paxCount,'border'=>'LR');
			array_push($tempCell, $cell);
			
			for($count=4; $count<=$totalSubCellRoom;$count++) {
				if($count == $totalSubCellRoom) {
					$styleId = 'LRB';
				} else {
					$styleId = 'LR';
				}
				$cell = array('width'=>$cellwidth . '%','data'=>'','border'=>$styleId);
				array_push($tempCell, $cell);
			}
			array_push($multiCell[$rowCount], $tempCell);

		} else {
			$roomInfo = $row['accommodation'];
			if ( $showUnitLabel == "1" ) {
				$roomInfo .= "\n" . (isset($row['unit_label']) ? $row['unit_label'] : "");
			}
			if ( $showUnitNumber == "1" ) {
				$roomInfo .= "\n" . $row['room'];
			}
			$roomInfo = $row['property'] . "\n" . $roomInfo;
		}
		array_push($pdfRow, $tempCell);
		
		// [START] Room data headings -----------------------------------------
		$room_data_headings = '';
		$tempCell = array();
		$styleFlag = 1;
		foreach ( $showIds as $showId ) {
			$sectionId = 0;
			$repFlag = 0;
			if($styleFlag == 1) {
				$styleId = "LRT";
			} else if($styleFlag == $totalSubCellRoom) {
				$styleId = "LRB";
			} else {
				$styleId = "LR";
			}
			foreach ( $chartSections as $item ) {
				if ( $item['id'] == $showId ) {
					if($showId<23){
						$rep_data = strlen($item['label'])>MAX_CHAR_PDF?substr($item['label'],0,MAX_CHAR_PDF) . "..":$item['label'];
						
						$cell = array('width'=>$cellwidth . '%', 'data'=>$rep_data,'border'=>$styleId);
						array_push($tempCell, $cell);
						
						if ( $roomRowSpans[$row['id']][$showId] > 1 ) {
							for ( $count = 1; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
								$cell = array('width'=>$cellwidth . '%', 'data'=>'', 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
						}
					}
					else if($showId>=23) {
						for ( $count = 0; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
							if($showId ==23 || $showId == 26) {
								$rep_data = strlen($chartSections[$sectionId]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId]['label'];
							
								$cell = array('width'=>$cellwidth . '%','data'=>$rep_data,'border'=>$styleId);
								array_push($tempCell, $cell);
																
								if(in_array($showId+1, $showIds)) {
									if($styleFlag+1 == $totalSubCellRoom) {
										$styleId = "LRB";
									}
									$rep_data = strlen($chartSections[$sectionId+1]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId+1]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId+1]['label'];
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data,'border'=>$styleId);
									array_push($tempCell, $cell);
								}
								if(in_array($showId+2, $showIds)) {
									if($styleFlag+2 == $totalSubCellRoom) {
										$styleId = "LRB";
									}
									$rep_data = strlen($chartSections[$sectionId+2]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId+2]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId+2]['label'];
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border' => $styleId);
									array_push($tempCell, $cell);
								}
								$repflag = 1;
							}
							else if(($showId ==24 || $showId == 27) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$rep_data = strlen($chartSections[$sectionId]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId]['label'];
										
										$cell = $cell = array('width'=>$cellwidth . '%','data'=>$rep_data,'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($showId+1, $showIds)) {
										if($styleFlag+1 == $totalSubCellRoom) {
											$styleId = "LRB";
										}
										
										$rep_data =  strlen($chartSections[$sectionId+1]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId+1]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId+1]['label'];
										
										$cell = array('width'=>$cellwidth . '%','data'=>$rep_data,'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($showId ==25 || $showId == 28) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$rep_data = strlen($chartSections[$sectionId]['label'])>MAX_CHAR_PDF?substr($chartSections[$sectionId]['label'],0,MAX_CHAR_PDF) . "..":$chartSections[$sectionId]['label'];
										$cell = $cell = array('width'=>$cellwidth . '%','data'=>$rep_data,'border'=>$styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								$styleFlag++;
						}	
					}
					if($item['id']==25){
						$repflag = 0;
					}
				}
				$sectionId++;
			}
			if($showId<23){
				$styleFlag++;
			}
		}
		array_push($multiCell[$rowCount], $tempCell);
		array_push($pdfRow, $tempCell);
		$tempCell = array();
		
		// [ END ] Room data headings -----------------------------------------

		// [START] Room information -------------------------------------------
		$column_count = 0;
		$current_page = 0;
		$pdfDataRow = $pdfRow;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			if ( $column_count == $max_columns_per_page ) {
				$pdfPage[$current_page][$row_count] = $pdfDataRow;
				$pdfDataRow = $pdfRow;
				$column_count = 0;
				$current_page++;
			}

			$c = isset($pdf_chart_data['room'][$row['id']][$col['id']]) ? $pdf_chart_data['room'][$row['id']][$col['id']] : "";
			$b = isset($pdf_chart_data['block'][$row['id']][$col['id']]) ? $pdf_chart_data['block'][$row['id']][$col['id']] : "";

			$initialColour	  = array(0xff,0xff,0xff);
			$initialFontColour  = array(0x00,0x00,0x00);
			if ( $b ) {
				$initialColour = array(0xc0,0xc0,0xc0);
			}

			$first = true;
			$repFlag = 0;
			$styleFlag = 1;
			foreach ( $showIds as $showId ) {
				// [START] Colour handling ----------------------------------------
				$colour	 = $initialColour;
				$fontColour = $initialFontColour;
						
				// Provisional booking
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 20 ) {
					$fontColour = array(0x33,0x66,0x99);
				}

				// Provisional expiring today
				if ( isset($c['rv_provision_expiry_date']) && $c['rv_provision_expiry_date'] == date("Y-m-d") ) {
					$colour	 = array(0xf1,0xc5,0x5d);
					$fontColour	= array(0x00,0x00,0x00);
				}
				// Allocation
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 15 ) {
					$fontColour = array(0x99,0x99,0x99);
				}

				if($styleFlag == 1) {
						$border = "LRT";
				} else if($styleFlag == $totalSubCellRoom) {
				 	$border = "LRB";
				} else {
					$border = "LR";
				}
				// [ END ] Colour handling ----------------------------------------------

				if ( isset($c[$showId]['value']) && !is_array($c[$showId]['value']) ) {
					// [START] Colour handling ----------------------------------------------
					if ( in_array($showId,$colourIds) && isset($c[$showId]['colour']) && $c[$showId]['colour'] != "" ) {
						$colour = array( 
							hexdec(substr($c[$showId]['colour'],0,2)),
							hexdec(substr($c[$showId]['colour'],2,2)),
							hexdec(substr($c[$showId]['colour'],4,2))
						);
					}
					if ( $error ) {
						$colour	= array(0xdb,0x42,0x42);
						$fontColour = array(0xff,0xff,0xff);
					}
					// [ END ] Colour handling ----------------------------------------------

					$rep_data = strlen($c[$showId]['value'])>MAX_CHAR_PDF?substr($c[$showId]['value'],0,MAX_CHAR_PDF):$c[$showId]['value'];
					
					$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border'=>$border, 'fill'=> 1, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
					array_push($tempCell, $cell);
					
				} else {
					$used = 0;
					if($showId <23){
						$used = 0;
						if (isset($c[$showId]['value'])) {
							foreach ( $c[$showId]['value'] as $cellItem ) {
								// [START] Colour handling ---------------------------------------------
								if ( in_array($showId,$colourIds) && $cellItem['colour'] != "" ) {
									$colour = array( 
											 hexdec(substr($cellItem['colour'],0,2)),
											 hexdec(substr($cellItem['colour'],2,2)),
											 hexdec(substr($cellItem['colour'],4,2))
											);
								}
								if ( $error ) {
									$colour			= array(0xdb,0x42,0x42);
									$fontColour	= array(0xff,0xff,0xff);
								}
								// [ END ] Colour handling --------------------------------------------
								$rep_data = '';	
								$rep_data = strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF) :$cellItem['value'];
								
								$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border'=>$border, 'fill'=> 1, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
								array_push($tempCell, $cell);
								$used++;
							}
						}
						if ( $used < $roomRowSpans[$row['id']][$showId] ) {
							for ( $count = 0; $count < ($roomRowSpans[$row['id']][$showId] - $used); $count++ ) {
								$cell = array('width'=>$cellwidth . '%','data'=>'', 'border'=>$border);
								array_push($tempCell, $cell);
							}
						}
					}
					else if($showId>=23) {
						if($showId==26) {
							$repFlag = 0;
						}
						else if(!in_array(26,$showIds) && $showId == 27) {
							$repFlag = 0;
						}
						else if(!in_array(26,$showIds) && !in_array(27,$showIds) && $showId == 28) {
							$repFlag = 0;
						}
						
						$fg = $roomRowSpans[$row['id']][$showId];
						for ( $countRow = 0; $countRow < $roomRowSpans[$row['id']][$showId]; $countRow++ ) {
							$cellItem = isset($c[$showId]['value'][$countRow]) ? $c[$showId]['value'][$countRow] : array();
							$cellItem2 = isset($c[$showId+1]['value'][$countRow]) ? $c[$showId+1]['value'][$countRow] : array();
							$cellItem3 = isset($c[$showId+2]['value'][$countRow]) ? $c[$showId+2]['value'][$countRow] : array();

							if ( $first && $error == true ) {
									$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
							}

							// [START] Colour handling ---------------------------------------------
							$colour	 = $initialColour;
							$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
							$fill = 0;
							if ( in_array($showId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != "" ) {
								$colour = array( 
								 hexdec(substr($cellItem['colour'],0,2)),
								 hexdec(substr($cellItem['colour'],2,2)),
								 hexdec(substr($cellItem['colour'],4,2))
								);
							}
								
							if(!empty($colour)) {
								$fill = 1;
							}
							// [ END ] Colour handling --------------------------------------------
														
							if($showId ==23 || $showId == 26) {
								if(in_array($showId, $showIds)) {
									$rep_data = !empty($cellItem['value']) ? ( strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF) :$cellItem['value'] ) : "";
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
								}
								if(in_array($showId+1, $showIds)) {
									if($styleFlag+1 == $totalSubCellRoom) {
										$border = "LRB";
									}
									$rep_data= !empty($cellItem2['value']) ? ( strlen($cellItem2['value'])>MAX_CHAR_PDF?substr($cellItem2['value'],0,MAX_CHAR_PDF) :$cellItem2['value'] ) : "";
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
									
								}
								
								if(in_array($showId+2, $showIds)) {
									if($styleFlag+2 == $totalSubCellRoom) {
										$border = "LRB";
									}
									$rep_data = !empty($cellItem3['value']) ? ( strlen($cellItem3['value'])>MAX_CHAR_PDF?substr($cellItem3['value'],0,MAX_CHAR_PDF) :$cellItem3['value'] ) : "";
									
									$cell = array('width'=>$cellwidth. '%','data'=>$rep_data, 'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
								}
								$repflag = 1;
							}
							else if(($showId ==24 || $showId == 27) && $repflag == 0) {
								if(in_array($showId, $showIds)) {
									$rep_data = strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF) :$cellItem['value'];
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data.$countRow."ajay", 'border'=>$border1, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
								}
								if(in_array($showId+1, $showIds)) {
									if($styleFlag+1 == $totalSubCellRoom) {
										$border = "LRB";
									}
									$rep_data = !empty($cellItem2['value']) ? ( strlen($cellItem2['value'])>MAX_CHAR_PDF?substr($cellItem2['value'],0,MAX_CHAR_PDF) :$cellItem2['value'] ) : "";
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
								}
								$repflag = 1;
							}
							else if(($showId ==25 || $showId == 28) && $repflag == 0) {
								if(in_array($showId, $showIds)) {
									$rep_data= strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF) :$cellItem['value'];
									
									$cell = array('width'=>$cellwidth . '%','data'=>$rep_data, 'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
									array_push($tempCell, $cell);
									
								}
								$repflag = 1;
							}
							$styleFlag++;
						}
					}
					$first = false;
				}
					
				if( (isset($showId) && $showId<23) || (isset($c[$showId]['value']) && !is_array($c[$showId]['value'])) ) {
					if (isset($styleFlag)) {
						$styleFlag++;
					} else {
						$styleFlag = 1;
					}
				}
			}
			array_push($multiCell[$rowCount], $tempCell);
			array_push($pdfDataRow, $tempCell);
			$tempCell = array();

			if (isset($column_count)) {
				$column_count++;
			} else {
				$column_count = 1;
			}
		}
		if (isset($row_count)) {
			$row_count++;
		} else {
			$row_count = 1;
		}
		if (isset($modcount)) {
			$modcount++;
		} else {
			$modcount = 1;
		}
	}

	$header_line_count = 0;
	$line_count = 0;
	$page_count = count($pdfPage);

	$cells = array();
	$rows = array();
	$temparr=array();
			
	for ( $i = 0; $i < $page_count; $i++ ) {
		if(isset($pdfPageHeader[0][$i]) && is_array($pdfPageHeader[0][$i])) {
			$header_line_count = $pdf -> getMaxLines($pdfPageHeader[0][$i]);
			$pdf -> Row($pdfPageHeader[0][$i]);
		}

		if ( $pdf_chart_data['direction'] == '1') {
			if(isset($pdfPageHeader[1][$i]) && is_array($pdfPageHeader[1][$i])) {
				$pdf -> Row($pdfPageHeader[1][$i]);
				$header_line_count += $pdf -> getMaxLines($pdfPageHeader[1][$i]);
			}
		}

		$line_count += $header_line_count;
		if(isset($pdfPage[$i]) && is_array($pdfPage[$i])) {
			foreach( $pdfPage[$i] as $r ) {
				$line_count += $pdf -> getMaxLines($r);
				// Make sure we don't have cells spanning two pages
				if ( $line_count > 48 ) {
					$pdf -> AddPage();
					$pdf -> Row($pdfPageHeader[0][$i]);
					if ( $pdf_chart_data['direction'] == '1' ) {
						$pdf -> Row($pdfPageHeader[1][$i]);
					}
					$line_count = 0 + $header_line_count + $pdf -> getMaxLines($r);
				}
				if (isset($r[1])) {
					for ($cal=0;$cal<count($r[1]);$cal++) {
						for ($crow=0;$crow<count($r);$crow++) {
							if(!empty($r[$crow][$cal])) {
									array_push($cells,$r[$crow][$cal]);
							} else {
									array_push($cells,array( 'width' => '10%', 'data'=>'', 'border' => 'LR' )); 
							}
						}
						if(!empty($cells)){
							$pdf -> Row($cells);
						} 
						$cells = array();
					}
				}
			} 
		}
		$pdf -> Ln(2);
		$line_count += 2;
	} 
	// [ END ] Chart ----------------------------------------------------------

	// [START] Legend ---------------------------------------------------------
	$legend = generatePDFLegend($chartSections,$chartIds,$data['chart']);
	$line_count = 0;
	foreach( $legend as $l ) {
		$line_count += $pdf -> getMaxLines($l);
		if ( $line_count > 48 ) {
			$pdf -> AddPage();
			$line_count = 0 + $pdf -> getMaxLines($l);
		}
		$pdf -> Row($l);
	}
	// [ END ] Legend ---------------------------------------------------------

	// [START] Notes ----------------------------------------------------------
	$notes = generatePDFNotes($noteSections,$noteIds,$data['notes'],$noteSort);
	$line_count = 0;
	foreach ( $notes as $n ) {
		foreach ( $n as $a ) {
			$line_count += $pdf -> getMaxLines($a);
			if ( $line_count > 48 ) {
				$pdf -> AddPage();
				$line_count = 0 + $pdf -> getMaxLines($a);
			}
			$pdf -> Row($a);
		}
	}
	// [ END ] Notes ----------------------------------------------------------

	$pdf -> Ln(2);
	$headerArray = array(
							array('name' => "Date range", 'value' => "$fromDate to $toDate"),
							array('name' => "Property", 'value' => $propertyFilter),
						);

	$pdf->ReportHeader($reportLabel, $headerArray);
	if ( $renderType == 'view' ) {
		$pdf->OutPut();
		die();
	}

	if ( $renderType == 'send' ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

		// close the pdf
		if ( $pdf->state < 3) {
			$pdf->Close();
		}

		// and now mail it
		if ( $attachmentName != '!attachmentName!' ) {
			$pdfName = $attachmentName;
		} else {
			$pdfName = 'Update report from ' . $fromDate . ' to ' . $toDate . '.pdf';
		}

		// (from, to, subject, headers, message, action, emailID, resID)
		$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$pdf->buffer,$pdfName);
		if ( !$error ) {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								opener.openMessage("Your email has been sent.");
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		} else {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								opener.openMessage("Error sending email!");
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		}
	}
}

function generateXLSNotes($noteSections,$noteIds,$notes,$noteSort, &$xls) {
	$html = '';
	define('NOTECOLWIDTH',130);
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$header_styleArr = array( 
		'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
		'border' => array($borderL, $borderR, $borderT, $borderB),
		'font' => array('Bold' => '1', 'Size' => '8')
	);
	$sub_header_style = array( 
		'border' => array($borderL, $borderR, $borderT, $borderB),
		'font' => array('Bold' => '1', 'Size' => '8')
	);

	$cell_style = array( 
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
	$cell_styleLRT = array( 
		'border' => array($borderL, $borderR, $borderT)
	);
	$cell_styleLR = array( 
		'border' => array($borderL,$borderR)
	);

	$header_styleId = $xls->addStyle($header_styleArr);
	$sub_header_styleId = $xls->addStyle($sub_header_style);
	$cell_styleId = $xls->addStyle($cell_style);
	$cell_styleIdLRT = $xls->addStyle($cell_styleLRT);
	$cell_styleIdLR = $xls->addStyle($cell_styleLR);
	
	/* ---------------------------------------------------------------------------
	ORDER FOR NOTES:
	Itinerary Summary
	Notes
	Memos
	Guest information
	Guest Details
	Extras
	Extras notes
	Extras memos
	Travel
	Travel notes
	Travel memos
	Room lock reason
	---------------------------------------------------------------------------	*/
	$mainColHeading = array();
	if ( count($notes) > 0 ) {
		switch ( $noteSort ) {
		case "1":
			$mainColHeading = array("Arrival date","Departure date","Res. Name","Res. Number");
			break;
		case "2":
			$mainColHeading = array("Departure date","Res. Name","Res. Number","Arrival date");
			break;
		case "3":
			$mainColHeading = array("Res. Number","Arrival date","Departure date","Res. Name");
			break;
		case "4":
			$mainColHeading = array("Res. Name","Arrival date","Departure date","Res. Number");
			break;
		}
				
		$xls->Column(NOTECOLWIDTH,2,0);
		$xls->Column(60,2,0);
		$xls->Column(70,2,0);
		$xls->Column(70,2,0);
		$xls->Column(70,2,0);
		$xls->Column(80,2,0);
		$xls->Column(80,2,0);
		$xls->Column(100,2,0);
		$xls->Column(50,2,0);
		$xls->Column(50,2,0);
		
		$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($mainColHeading[0]) ? $mainColHeading[0] : "")), $header_styleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($mainColHeading[1]) ? $mainColHeading[1] : "")), $header_styleId, '', '', '', '', '1');
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($mainColHeading[2]) ? $mainColHeading[2] : "")), $header_styleId, '', '', '', '', '1');
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($mainColHeading[3]) ? $mainColHeading[3] : "")), $header_styleId, '', '', '', '', '1');
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($mainColHeading[4]) ? $mainColHeading[4] : "")), $header_styleId, '', '', '', '', '2');
		array_push($cells, $cell);

		$row = $xls->Row($cells);
		array_push($rows,$row);
		$cells = array();

		$rowCount = 2;
		foreach ( $notes as $item ) {
			// Used to suppress reservations with no notes --------------------------
			
			$title = array();
			$mainColHeading = array();
			if ( count($item) > 0 ) {
				/* -------------------------------------------------------------------------
					TITLE SORT ORDER
					1: Arrival date
					2: Departure date
					3: Reservation ID
					4: Reservation name
					5: Property
				------------------------------------------------------------------------- */
				switch ( $noteSort ) {
				case "1":
					$title = array($item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_res_name'],$item['rv_reservation_ix']);
					break;
				case "2":
					$title = array($item['rv_date_depart_fmt'],$item['rv_res_name'],$item['rv_reservation_ix'],$item['rv_date_arrive_fmt']);
					break;
				case "3":
					$title = array($item['rv_reservation_ix'],$item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_res_name']);
					break;
				case "4":
					$title = array($item['rv_res_name'],$item['rv_date_arrive_fmt'],$item['rv_date_depart_fmt'],$item['rv_reservation_ix']);
					break;
				}
								
				$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($title[0]) ? $title[0] : "")), $header_styleId);
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($title[1]) ? $title[1] : "")), $header_styleId, '', '', '', '', '1');
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($title[2]) ? $title[2] : "")), $header_styleId, '', '', '', '', '1');
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($title[3]) ? $title[3] : "")), $header_styleId, '', '', '', '', '1');
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($title[4]) ? $title[4] : "")), $header_styleId, '', '', '', '', '2');
				array_push($cells, $cell);

				$row = $xls->Row($cells);
				array_push($rows,$row);
				$cells = array();
				$rowCount++;
				
				// [START] Itinerary Summary -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"itinerarySum"),$noteIds) ) {
					
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Itinerary summary'), $cell_styleIdLRT);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Arrive'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Depart'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Night'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Property'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Accomm'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Rms'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Ad'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Chld'), $sub_header_styleId);
					array_push($cells, $cell);
					
					$row = $xls->Row($cells);
					array_push($rows,$row);
					$cells = array();
											
					foreach ( $item['itinerary'] as $itinerary ) {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['room']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['resArrive']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['resDepart']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['nights']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['propName']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['accom']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['rooms']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['adults']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['childs']), $cell_styleId);
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
					}
						
				}
				// [ END ] Itinerary Summary -----------------------------------------------

				// [START] Reservation Notes -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNote"),$noteIds) ) {
					if ( isset($item['rv_note_general']) && $item['rv_note_general'] != "" ) {
						$note_exists = true;
						$data  = $item['rv_note_general'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Notes'),$cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
					}
				}
				// [ END ] Reservation Notes -----------------------------------------------

				// [START] Internal Memos --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resMemo"),$noteIds) ) {
					if ( isset($item['rv_note_internal']) && trim($item['rv_note_internal']) != "" ) {
						$note_exists = true;
						$data  = $item['rv_note_internal'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Memos'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Internal Memos --------------------------------------------------

				// [START] Guest information -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					if ( isset($item['rv_note_guests']) && trim($item['rv_note_guests']) != "" ) {
						$note_exists = true;
						$data  = $item['rv_note_guests'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest information'), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Guest information -----------------------------------------------

				// [START] Guest Details--------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && !empty($item['guests'] )) {
					
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest details'), $cell_styleIdLRT);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest names'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Nationality'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Last Dep'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String','data'=>'Visits'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'B-day'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Anniv'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Notes'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Memos'), $sub_header_styleId, '', '', '', '', '0');
					array_push($cells, $cell);

					$row = $xls->Row($cells);
					array_push($rows,$row);
					$cells = array();

					$event_styleArr = array( 
						'interior' => array('Color' => '#8d9ce7', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT, $borderB),
						'font' => array('Size' => '8')
						);
					$event_styleId = $xls->addStyle($event_styleArr);
										
					foreach ( $item['guests'] as $guests ) {
						$note_data = $guests['pr_guest_note'];
						$memo_data = $guests['pr_guest_memo'];
						$birthday = $guests['pr_birthdate'] != '0000-00-00'? $guests['pr_birthdate']:'';
						$anivrsry = $guests['pr_anniversary'] != '0000-00-00'? $guests['pr_anniversary']:'';
						
						$birthStyleId = '';
						if($guests['has_birthday'] == 1) {
							$birthStyleId = $event_styleId;
						} else {
							$birthStyleId = $cell_styleId;
						}

						if($guests['has_anniversary'] == 1) {
							$annhStyleId = $event_styleId;
						} else {
							$annhStyleId = $cell_styleId;
						}
							
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'1'), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['pr_name']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['nationality']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['last_depart']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$guests['total_visit']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$birthday), $birthStyleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$anivrsry), $annhStyleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$note_data), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$memo_data), $cell_styleId, '', '', '', '', '0');
						array_push($cells, $cell);

						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
					}
				}
				
				// [ END ] Guest Details --------------------------------------

				// [START] Extras ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
					if(!empty($item['extras']) || !empty($item['travel'])) {
						$title = 'Extras';
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$title), $cell_styleIdLRT);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Travel'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Date'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Qty'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Category'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Desc'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Notes'), $sub_header_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Memos'), $sub_header_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
										
						if(!empty($item['extras'])) {
							foreach ( $item['extras'] as $extra ) {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($extra['ac_desc']) ? $extra['ac_desc'] : "")), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>'-'), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($extra['rv_extra_date_serv']) ? $extra['rv_extra_date_serv'] : "")), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'Number', 'data'=>(isset($extra['rv_extra_units']) ? $extra['rv_extra_units'] : "")), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($extra['ac_extra_cat_desc']) ? $extra['ac_extra_cat_desc'] : "")), $cell_styleId);
								array_push($cells, $cell);
								
								$extra_desc = '';
								if ( in_array(findSectionId($noteSections,"extras"),$noteIds) ) {
									$extra_desc = $extra['ac_ext_desc'];
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$extra_desc), $cell_styleId);
								array_push($cells, $cell);

								$extras_note = '';
								if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) ) {
									$extras_note = $extra['rv_extra_note'];
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$extras_note), $cell_styleId);
								array_push($cells, $cell);

								$extras_memo = '';
								if ( in_array(findSectionId($noteSections,"extraMemo"),$noteIds)) {
									$extras_memo = $extra['rv_extra_note_internal'];
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$extras_memo), $cell_styleId, '', '', '', '', '1');
								array_push($cells, $cell);

								$row = $xls->Row($cells);
								array_push($rows,$row);
								$cells = array();
								$rowCount++;
								$note_exists = true;
							}
						}

						if(!empty($item['travel'])) {
							foreach ( $item['travel'] as $travel ) {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($extra['ac_desc']) ? $extra['ac_desc'] : "")), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>'Yes'), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($travel['rv_extra_date_serv']) ? $travel['rv_extra_date_serv'] : "")), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'Number', 'data'=>(isset($travel['rv_extra_units']) ? $travel['rv_extra_units'] : "")), $cell_styleId);
								array_push($cells, $cell);
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($travel['ac_extra_cat_desc']) ? $travel['ac_extra_cat_desc'] : "")), $cell_styleId);
								array_push($cells, $cell);
							
								$travel_desc = '';
								if ( in_array(findSectionId($noteSections,"travel"),$noteIds) ) {
									$travel_desc = $travel['ac_ext_desc'];
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel_desc), $cell_styleId);
								array_push($cells, $cell);

								$travel_note = '';
								if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) ) {
									$travel_note = $travel['rv_extra_note'];
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel_note), $cell_styleId);
								array_push($cells, $cell);

								$travel_memo = '';
								if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
									$travel_memo = $travel['rv_extra_note_internal'];
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel_memo), $cell_styleId, '', '', '', '', '1');
								array_push($cells, $cell);

								$row = $xls->Row($cells);
								array_push($rows,$row);
								$cells = array();
								$rowCount++;
							}
						}
					} 
				}
			
				// [ END ] Extras ----------------------------------------------------------

				// [START] Financials ------------------------------------------------
				if ( in_array(findSectionId($noteSections,"financials"),$noteIds) && !empty($item['financial'] )) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Financials'), $cell_styleIdLRT);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Folio/Inv'), $sub_header_styleId, '', '', '', '', '1');
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Payee'), $sub_header_styleId, '', '', '', '', '1');
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Total'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Paid'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Total due'), $sub_header_styleId, '', '', '', '', '1');
					array_push($cells, $cell);
					
					$row = $xls->Row($cells);
					array_push($rows,$row);
					$cells = array();

					foreach ( $item['financial'] as $financial ) {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'1'), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'INV '. $financial['fn_invoice_ix']), $cell_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['fn_inv_to']), $cell_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['total']. ' '. $financial['fn_inv_curr']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['paid']. ' ' . $financial['fn_inv_curr']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['due']. ' ' . $financial['fn_inv_curr']), $cell_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
				
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
					}
				}
				// [ END ] Financials ------------------------------------------------

				// [START] Source --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resSource"),$noteIds) ) {
					if ( isset($item['source']) && trim($item['source']) != "" ) {
						$note_exists = true;
						$data  = $item['source'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Source'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Source --------------------------------------------------

				// [START] Agent --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resAgent"),$noteIds) ) {
					if ( isset($item['agent']) && trim($item['agent']) != "" ) {
						$note_exists = true;
						$data  = $item['agent'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Agent'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Agent --------------------------------------------------
				
			}
			//a blank row
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId, '', '', '', '', '9');
			array_push($cells, $cell);

			$row = $xls->Row($cells);
			array_push($rows,$row);
			$cells = array();
		}
	}
	return $rows;
}

function outputCSV($data,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showLegend,$showUnitLabel,$showUnitNumber,$showDatePAX,$fromDate,$toDate,$propertyFilter, $showCatExtras="", $reportName="", $repType="xls") {
	$error = false;
	define("COLWIDTH",160);
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();
	$csv_chart_data = $data['chart'];
	$csv_notes_data = $data['notes'];
		
	$showIds	= $chartIds['room'];
	$colourIds	= $chartIds['colour'];
	$departIds  = $chartIds['depart'];

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$defaultStyle = array( 
					'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
					'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
					'font' => array('Size' => '8')
					);
	
	$xls = new XLS($defaultStyle);
	
	$borderLRTStyle = array("border" => array($borderL, $borderR, $borderT));
	$borderLTBStyle = array("border" => array($borderL, $borderT, $borderB));
	$borderRTBStyle = array("border" => array($borderR, $borderT, $borderB));
	$borderTBStyle	= array("border" => array($borderB, $borderT));
	$borderLRStyle	= array("border" => array($borderL, $borderR));
	$borderLRTBStyle= array("border" => array($borderL, $borderR, $borderT, $borderB));

	$borderLRTStyleId = $xls->addStyle($borderLRTStyle);
	$borderLTBStyleId = $xls->addStyle($borderLTBStyle);
	$borderTBStyleId = $xls->addStyle($borderTBStyle);
	$borderLRStyleId = $xls->addStyle($borderLRStyle);
	$borderLRTBStyleId = $xls->addStyle($borderLRTBStyle);

	$header_style = array( 
						"interior" => array("Color" => "#f7f2d9", "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT, $borderB)
						);
					
	$header_styleId = $xls->addStyle($header_style);

	$multiCell[1] = array();
	$multiCell[2] = array();

	if ( $csv_chart_data['direction'] == "1" ) {
		// Room names along top
		$rows = array();
		$xls->Column(130);
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		 array_push($tempCell, $cell);
		
		$xls->Column(130);
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell, $cell);

		$property_name = "";
		$modCount = 0;
		$columnCount = 1;	
		foreach ( $csv_chart_data['columns'] as $col ) {
			$xls->Column(COLWIDTH);
			if ( $modCount%2 == 0 ) {
					$bg_color = "#FCF3DA";
				} else {
					$bg_color = "#F8E8BB";
				}
			
			if ( $property_name != $col['property'] ) {
				$property_name = $col['property'];
				$modCount++;

				$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderT, $borderB)
						);
					
				$bg_styleId = $xls->addStyle($bg_style);
				$cell = $xls->Cell(array("type"=>"String", "data" =>$property_name), $bg_styleId);
			} else {
				if($columnCount == count($csv_chart_data['columns'])) {
					$border = array($borderR, $borderT, $borderB);
				} else {
					$border = array($borderT, $borderB);
				}
				$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => $border
						);
					
				$bg_styleId = $xls->addStyle($bg_style);
				$cell = $xls->Cell(array("type"=>"String", "data" => ""), $bg_styleId);
			}
			array_push($tempCell, $cell);
			$columnCount++;
		}

		array_push($multiCell[1], $tempCell);
		$tempCell = array();
		
		$cell = $xls->Cell(array("type"=>"String", "data"=>""));
		array_push($tempCell, $cell);
		
		$cell = $xls->Cell(array("type"=>"String", "data"=>"Details"), $header_styleId);
		array_push($tempCell, $cell);
				
		// Room names and numbers ---------------------------------------------------
		$modCount = 0;
		foreach ( $csv_chart_data['columns'] as $col ) {
			if ( $property_name != $col['property'] ) {
				$property_name = $col['property'];
				if ( $modCount%2 == 0 ) {
					$bg_color = "#FCF3DA";
				} else {
					$bg_color = "#F8E8BB";
				}
				$modCount++;
			}
			
			$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT, $borderB)
						);
					
			$bg_styleId = $xls->addStyle($bg_style);


			$accommCell = $col['accommodation'];
			if ( $showUnitLabel == "1" ) {
				$accommCell .= "&#10;" . (isset($col['unit_label']) ? $col['unit_label'] : "");
			}
			if ( $showUnitNumber == "1" ) {
				$accommCell .= "&#10;" . $col['room'];
			}
			
			$cell = $xls->Cell(array("type"=>"String", "data"=>$accommCell),$bg_styleId);
			array_push($tempCell, $cell);
			
		}
		array_push($multiCell[2], $tempCell);
		$tempCell = array();
		
	} else {
		// Dates along top
		$xls->Column(130);
		$cell = $xls->Cell(array("type"=>"String", "data"=>""));
		array_push($tempCell, $cell);
		$xls->Column(130);

		
		$bg_style = array( 
						"interior" => array("Color" => "#F8E8BB", "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT, $borderB)
						);
					
		$bg_styleId = $xls->addStyle($bg_style);

		$cell = $xls->Cell(array("type"=>"String", "data"=>"Details"), $header_styleId);
		array_push($tempCell, $cell);
	
		foreach ( $csv_chart_data['columns'] as $col ) {
			$xls->Column(COLWIDTH);
			$thisDate = explode("-",$col['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
			$dateRow = $displayDate . " " . $col['name'];
			if ( $showDatePAX == "1" ) {
				$dateRow .= "&#10;PAX " . $col['pax_total'] . " (Ad:" . $col['pax_adult'] . " Ch:" . $col['pax_child'] . ")";
			}
			$cell = $xls->Cell(array("type"=>"String", "data"=>$dateRow), $bg_styleId);
			array_push($tempCell, $cell);
		}

		array_push($multiCell[1], $tempCell);
		$tempCell = array();
	}
	
	$roomRowSpans	= getRowSpans($csv_chart_data,"room",$showIds);
	$departRowSpans	= getRowSpans($csv_chart_data,"depart",$departIds);

	$showDepartureInfo = true;
	$modCount = 0;
	$rowCount = 3;

	if ( $csv_chart_data['direction'] == "2" ) {
		$property_name = "";
		$anotherCount = 0;
		$rowCount = 2;
	}

			$hdr_style1 = array( 
						"interior" => array("Color" => "#f7f2d9", "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT)
						);
			$hdr_style2 = array( 
						"interior" => array("Color" => "#f7f2d9", "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderB)
						);
			$hdr_style3 = array( 
						"interior" => array("Color" => "#f7f2d9", "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR)
						);
					
		$hdr_styleId1 = $xls->addStyle($hdr_style1);
		$hdr_styleId2 = $xls->addStyle($hdr_style2);
		$hdr_styleId3 = $xls->addStyle($hdr_style3);
	
	
	foreach ( $csv_chart_data['rows'] as $row ) {
		$totalSubCellRoom = array_sum($roomRowSpans[$row['id']]);
		$totalSubCellDepart = array_sum($departRowSpans[$row['id']]);
		if ( $csv_chart_data['direction'] == "2" ) {
			$property_name = "";
		}
		$multiCell[$rowCount] = array();
		if ( $csv_chart_data['direction'] == '1' ) {
			$thisDate	= explode("-",$row['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		}

		if ( $modCount%2 == 0 ) {
			$bg_color = "#FCF3DA";
		} else {
			$bg_color = "#F8E8BB";
		}
		
		$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT, $borderB)
						);
		
		$bg_style1 = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT)
						);
		$bg_style2 = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderB)
						);
		$bg_style3 = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR)
						);
		
		$b_style = array( 
						'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT),
						'font' => array('Bold' => '1', 'Size' => '8')
						);
					
		$b_styleId = $xls->addStyle($b_style);
		
		$bg_styleId = $xls->addStyle($bg_style);
		$bg_styleId1 = $xls->addStyle($bg_style1);
		$bg_styleId2 = $xls->addStyle($bg_style2);
		$bg_styleId3 = $xls->addStyle($bg_style3);
		
		// Here we look at each row and try to determine if there is any departure
		// information in any of the row's columns. If not, then we don't display 
		// the departure row
		$departInfoExists = false;
		if(isset($csv_chart_data['columns']) && is_array($csv_chart_data['columns'])) {
			foreach ( $csv_chart_data['columns'] as $col ) {
				$d = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : array();
				if ( count($d) > 0 && $d != "" ) {
					foreach ( $d as $blah ) {
						if ( isset($blah['value']) && $blah['value'] != "" ) {
							$departInfoExists = true;
						}
					}
				}
			}
		}
		
		if ( count($departIds) > 0 && $departInfoExists && $showDepartureInfo ) {
			$bool_depart = true;
			
			// [START] Departure information row --------------------------------------
			if ( $csv_chart_data['direction'] == '1' ) {
				$roomInfo = $displayDate . ' ' . $row['name'];
				$cell = $xls->Cell(array("type"=>"String", "data"=>"DEPART"), $b_styleId);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>"String", "data"=>$roomInfo), $bg_styleId3);
				array_push($tempCell, $cell); 

				for($count=2; $count<=$totalSubCellDepart;$count++) {
					if($count == $totalSubCellDepart) {
						$styleId = $bg_styleId2;
					}
					else {
						$styleId = $bg_styleId3;
					}
					$cell = $xls->Cell(array("type"=>"String", "data"=>""), $styleId);
					array_push($tempCell, $cell);
				}


				array_push($multiCell[$rowCount], $tempCell);
			} else {
				if ( $property_name != $row['property'] ) {
					$property_name = $row['property'];
					if ( $anotherCount%2 == 0 ) {
						$bg_color = "#FCF3DA";
					} else {
						$bg_color = "#F8E8BB";
					}

					$anotherCount++;

					$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderT, $borderB)
						);
					
					$bg_styleId = $xls->addStyle($bg_style);
									
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'<B>' . $row['property'] . '</B>'), $bg_styleId);
					array_push($tempCell, $cell);
					for ($i=1; $i<=count($csv_chart_data['columns'])+2; $i++) {
						if($i == count($csv_chart_data['columns'])+1) {
							$border = array($borderR, $borderT, $borderB);
						} else {
							$border = array($borderT, $borderB);
						}
						$bg_style = array( 
								"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
								"border" => $border
								);
							
						$bg_styleId = $xls->addStyle($bg_style);
						$cell = $xls->Cell(array("type"=>"String", "data" => ""), $bg_styleId);
						array_push($tempCell, $cell);
					}
					array_push($multiCell[$rowCount], $tempCell);
					$tempCell = array();
					$rowCount++;
					$modcount = 1;
					$multiCell[$rowCount] = array();
				}

				if ( $modcount%2 == 0 ) {
					$bg_color = '#dbc790';
				}
				
				$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderT)
						);
					
				$bg_styleId = $xls->addStyle($bg_style);

				$bg_style2 = array( 
					"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
					"border" => array($borderR, $borderL, $borderB)
					);
				
				$bg_styleId2 = $xls->addStyle($bg_style2);

				$bg_style3 = array( 
					"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
					"border" => array($borderL, $borderR)
					);
				
				$bg_styleId3 = $xls->addStyle($bg_style3);
				
				$b_style = array( 
						'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT),
						'font' => array('Bold' => '1', 'Size' => '8')
						);
					
				$b_styleId = $xls->addStyle($b_style);

				$cell = $xls->Cell(array("type"=>"String", "data"=>"DEPART"), $b_styleId);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>"String", "data"=>$row['accommodation']), $bg_styleId3);
				array_push($tempCell, $cell);
				$i = 2;
				if ( $showUnitLabel == "1" ) {
					$cell = $xls->Cell(array("type"=>"String", "data"=>$row['unit_label']), $bg_styleId3);
					array_push($tempCell, $cell);
					$i++;
				}

				if ( $showUnitNumber == "1" ) {
					$cell = $xls->Cell(array("type"=>"String", "data"=>$row['room']), $bg_styleId3);
					array_push($tempCell, $cell);
					$i++;
				}
				

				for($count=$i; $count<=$totalSubCellDepart;$count++) {
					if($count == $totalSubCellDepart) {
						$styleId = $bg_styleId2;
					}
					else {
						$styleId = $bg_styleId3;
					}
					$cell = $xls->Cell(array("type"=>"String", "data"=>""), $styleId);
					array_push($tempCell, $cell);
				}
				array_push($multiCell[$rowCount], $tempCell);
			}

			// [START] Departure section headings --------------------------------------
			$tempCell = array();
			$styleFlag = 1;
			
			foreach ($departIds as $departId ) {
				$sectionId = 0;
				$repFlag = 0;
				if($styleFlag == 1) {
					$styleId = $hdr_styleId1;
				}
				else if($styleFlag == $totalSubCellDepart) {
					$styleId = $hdr_styleId2;
				}
				else {
					$styleId = $hdr_styleId3;
				}
				foreach ( $chartSections as $item ) {
					if ( $item['id'] == $departId ) {
						if($departId<23){
							$cell = $xls->Cell(array("type"=>"String", "data"=>$item['label']), $styleId);
							array_push($tempCell, $cell);
							
							if ( $departRowSpans[$row['id']][$departId] > 1 ) {
								for ( $count = 1; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
									$cell = $xls->Cell(array("type"=>"String", "data"=>''), $styleId);
									array_push($tempCell, $cell);
									$styleFlag++;
								}
							}
						}
						else if($departId>=23) {
							for ( $count = 0; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
								if($styleFlag == 1) {
									$styleId = $hdr_styleId1;
								}
								else if($styleFlag == $totalSubCellDepart) {
									$styleId = $hdr_styleId2;
								}
								else {
									$styleId = $hdr_styleId3;
								}

								if($departId ==23 || $departId == 26) {
									if(in_array($departId, $departIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+1, $departIds)) {
										if($styleFlag+1 == $totalSubCellDepart) {
											$styleId = $hdr_styleId2;
										}
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId+1]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+2, $departIds)) {
										if($styleFlag+2 == $totalSubCellDepart) {
											$styleId = $hdr_styleId2;
										}
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId+2]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($departId ==24 || $departId == 27) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($departId+1, $departIds)) {
										if($styleFlag+1 == $totalSubCellDepart) {
											$styleId = $hdr_styleId2;
										}
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId+1]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($departId ==25 || $departId == 28) && $repflag == 0) {
									if(in_array($departId, $departIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									
									$repflag = 1;
								}
								$styleFlag++;
							}
						}
						if($item['id']==25){
							$repflag = 0;
						}
					}
					$sectionId++;
				}
					if($departId<23){
						$styleFlag++;
					}
				}
				array_push($multiCell[$rowCount], $tempCell);
				$tempCell = array();
				
				
			// [ END ] Departure section headings -------------------------------------

			// [START] Departure information -------------------------------------------
				foreach ( $csv_chart_data['columns'] as $col ) {
					$d = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : "";
					$b = isset($csv_chart_data['block'][$row['id']][$col['id']]) ? $csv_chart_data['block'][$row['id']][$col['id']] : "";

					$initialColour	  = array(0xff,0xff,0xff);
					$initialFontColour  = array(0x00,0x00,0x00);
					if ( $b ) {
						$initialColour = array(0xc0,0xc0,0xc0);
					}

					$contFlag = 1;
					$styleFlag = 1;
					foreach ( $departIds as $departId ) {
						$colour			= $initialColour;
						$fontColour = $initialFontColour;

						// Provisional booking
						if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 20 ) {
							$fontColour = array(0x33,0x66,0x99);
						}

						// Provisional expiring today
						if ( isset($d['rv_provision_expiry_date']) && $d['rv_provision_expiry_date'] == date("Y-m-d") )  {
							$colour = array(0xf1,0xc5,0x5d);
							$fontColour = array(0x00,0x00,0x00);
						}

						// Allocation
						if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 15 ) {
							$fontColour = array(0x99,0x99,0x99);
						}

						if($styleFlag == 1) {
								$border = array($borderL, $borderR, $borderT);
						}
						else if ($styleFlag == count($departIds)) {
							$border = array($borderL, $borderR, $borderB);
						}
						else {
							$border = array($borderL, $borderR);
						}

						if ( !isset($d[$departId]['value']) || !is_array($d[$departId]['value']) ) {
							// [START] Colour handling ----------------------------------------------
							if ( in_array($departId,$colourIds) && isset($d[$departId]['colour']) && $d[$departId]['colour'] != "" ) {
								$colour = array( 
									hexdec(substr($d[$departId]['colour'],0,2)),
									hexdec(substr($d[$departId]['colour'],2,2)),
									hexdec(substr($d[$departId]['colour'],4,2))
								);
							}	

							if ( $error ) {
								$colour			= array(0xdb,0x42,0x42);
								$fontColour = array(0xff,0xff,0xff);
							}
							// [END] Colour handling ----------------------------------------------
							$colour = $xls->rgb2html($colour);
							$style1 = array( "interior" => array("Color" => $colour, "Pattern"=>"Solid"),
							"border" => $border
							);
							
							$stId = $xls->addStyle($style1);
							if (isset($d[$departId]['value'])) {
								$cell = $xls->Cell(array("type"=>"String", "data"=>$d[$departId]['value']), $stId);
								array_push($tempCell, $cell);
							}

							if ($departRowSpans[$row['id']][$departId] >1) {
								for ( $count = 1; $count < ($departRowSpans[$row['id']][$departId]); $count++ ) {
									$cell = $xls->Cell(array("type"=>"String", "data"=>''), $stId);
									array_push($tempCell, $cell);
								}
							}
						} else {
							if($departId <23){
								$used = 0;
								foreach ( $d[$departId]['value'] as $cellItem ) {
									// [START] Colour handling ---------------------------------------------
									$colour		= $initialColour;
									$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
									if ( in_array($departId,$colourIds) && $cellItem['colour'] != "" ) {
										$colour = array( 
											 hexdec(substr($cellItem['colour'],0,2)),
											 hexdec(substr($cellItem['colour'],2,2)),
											 hexdec(substr($cellItem['colour'],4,2))
											);
									}
									if ( $error ) {
										$colour			= array(0xdb,0x42,0x42);
										$fontColour	= array(0xff,0xff,0xff);
									}
									$colour = $xls->rgb2html($colour);
									// [ END ] Colour handling --------------------------------------------
									$style1 = array( 
										"interior" => array("Color" => $colour, "Pattern"=>"Solid"),
										"border" => $border
										);
									
									$stId = $xls->addStyle($style1);

									$cell = $xls->Cell(array("type"=>"String", "data"=>$cellItem['value']), $stId);
									array_push($tempCell, $cell);
									$used++;
								}
								if ( $used < $departRowSpans[$row['id']][$departId] ) {
									for ( $count = 0; $count < ($departRowSpans[$row['id']][$departId] - $used); $count++ ) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>''), $stId);
										array_push($tempCell, $cell);
									}
								}
							}
							else if($departId>=23) {
								if($departId==26) {
									$repFlag = 0;
								}
								else if(!in_array(26,$departIds) && $departId == 27) {
									$repFlag = 0;
								}
								else if(!in_array(26,$departIds) && !in_array(27,$departIds) && $departId == 28) {
										$repFlag = 0;
								}
								
								for ( $count = 0; $count < $departRowSpans[$row['id']][$departId]; $count++ ) {
									$first = false;
									$cellItem = isset($d[$departId]['value'][$count]) ? $d[$departId]['value'][$count] : array();
									$cellItem2 = isset($d[$departId+1]['value'][$count]) ? $d[$departId+1]['value'][$count] : array();
									$cellItem3 = isset($d[$departId+2]['value'][$count]) ? $d[$departId+2]['value'][$count] : array();
									
									// [START] Colour handling ---------------------------------------------
									$colour		= $initialColour;
									$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
									if ( in_array($departId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != "" ) {
										$colour = array( 
											 hexdec(substr($cellItem['colour'],0,2)),
											 hexdec(substr($cellItem['colour'],2,2)),
											 hexdec(substr($cellItem['colour'],4,2))
										);
									}
									$colour1 = $xls->rgb2html($colour);

									if (in_array($departId+1,$colourIds) && isset($cellItem2['colour']) && $cellItem2['colour'] != "") {
											$colour = array( 
											 hexdec(substr($cellItem2['colour'],0,2)),
											 hexdec(substr($cellItem2['colour'],2,2)),
											 hexdec(substr($cellItem2['colour'],4,2))
											);
										}
										$colour2 = $xls->rgb2html($colour);

										if (in_array($departId+2,$colourIds) && isset($cellItem3['colour']) && $cellItem3['colour'] !="") {
											$colour = array( 
											 hexdec(substr($cellItem3['colour'],0,2)),
											 hexdec(substr($cellItem3['colour'],2,2)),
											 hexdec(substr($cellItem3['colour'],4,2))
											);
										}
										$colour3 = $xls->rgb2html($colour);
									// [ END ] Colour handling --------------------------------------------
									$style1 = array( "interior" => array("Color" => $colour1, "Pattern"=> "Solid"),
									"border" => $border
									);

									$style2 = array("interior" => array("Color" => $colour2, "Pattern"=>"Solid"),
									"border" => $border
									);

									$style3 = array("interior" => array("Color" => $colour3, "Pattern"=>"Solid"),
									"border" => $border
									);
									
									$stId1 = $xls->addStyle($style1);
									$stId2 = $xls->addStyle($style2);
									$stId3 = $xls->addStyle($style3);

									if($departId ==23 || $departId == 26) {
										if(in_array($departId, $departIds)) {
											$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem['value']) ? $cellItem['value'] : "") ), $stId1);
												array_push($tempCell, $cell);
												//$depart_information .= $cellItem['value'];
										}
										if(in_array($departId+1, $departIds)) {
											$cellItem2 = isset($d[$departId+1]['value'][$count]) ? $d[$departId+1]['value'][$count] : array();
											$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem2['value']) ? $cellItem2['value'] : ""), $stId2));
												array_push($tempCell, $cell);
											}
											if(in_array($departId+2, $departIds)) {
												$cellItem3 = isset($d[$departId+2]['value'][$count]) ? $d[$departId+2]['value'][$count] : array();
												$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem3['value']) ? $cellItem3['value'] : "")), $stId3);
												array_push($tempCell, $cell);
												
											}
											$repflag = 1;
										}
										else if(($departId ==24 || $departId == 27) && $repflag == 0) {
											if(in_array($departId, $departIds)) {
												$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem['value']) ? $cellItem['value'] : "") ), $stId1);
												array_push($tempCell, $cell);
											}
											if(in_array($departId+1, $departIds)) {
												$cellItem2 = isset($d[$departId+1]['value'][$count]) ? $d[$departId+1]['value'][$count] : array();
												$cell = $xls->Cell(array("type"=>"String", "data"=>$cellItem2['value']), $stId2);
												array_push($tempCell, $cell);
											}
											$repflag = 1;
										}
										else if(($departId ==25 || $departId == 28) && $repflag == 0) {
											if(in_array($departId, $departIds)) {
												$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem['value']) ? $cellItem['value'] : "") ), $stId1);
												array_push($tempCell, $cell);
											}
											$repflag = 0;
										}
									}
								}
								$first = false;
							}
							$contFlag++;
							if( (isset($departId) && $departId<23) || (isset($c[$departId]['value']) && !is_array($c[$departId]['value'])) ){
								$styleFlag++;
							}
						}
						
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
					}
					
					$cells = array();
					$rowCount++;
					$multiCell[$rowCount] = array();
		} else {
			$bool_depart = false;
		}
		
		// [START] Room information row -------------------------------------------
		if ( $csv_chart_data['direction'] == "1" ) {
			$roomInfo = $displayDate . " " . $row['name'];
			if ( $showDatePAX == "1" ) {
				$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
			} else {
				$paxCount = '';
			}
			
			$cell = $xls->Cell(array("type"=>"String", "data"=>"ARR/STAYOVER"), $b_styleId);
			array_push($tempCell, $cell);
			$cell = $xls->Cell(array("type"=>"String", "data"=>$roomInfo), $bg_styleId3);
			array_push($tempCell, $cell);
			$cell = $xls->Cell(array("type"=>"String", "data"=>$paxCount), $bg_styleId3);
			array_push($tempCell, $cell);
			
			for($count=4; $count<=$totalSubCellRoom;$count++) {
				if($count == $totalSubCellRoom) {
					$styleId = $bg_styleId2;
				}
				else {
					$styleId = $bg_styleId3;
				}
				$cell = $xls->Cell(array("type"=>"String", "data"=>""), $styleId);
				array_push($tempCell, $cell);
			}
			
			array_push($multiCell[$rowCount], $tempCell);
		} else {
			$bg_style = array( 
						"interior" => array("Color" => "#F8E8BB", "Pattern"=>"Solid"),
						"border" => array($borderL, $borderB, $borderT)
						);
					
			$bg_styleId = $xls->addStyle($bg_style);

			$bg_style1 = array( 
					"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
					"border" => array($borderL, $borderR, $borderT)
					);
			$bg_style2 = array( 
							"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
							"border" => array($borderL, $borderR, $borderB)
							);
			$bg_style3 = array( 
							"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
							"border" => array($borderL, $borderR)
							);

			$b_style = array( 
						'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT),
						'font' => array('Bold' => '1', 'Size' => '8')
						);
					
			$b_styleId = $xls->addStyle($b_style);
						
			$bg_styleId = $xls->addStyle($bg_style);
			$bg_styleId1 = $xls->addStyle($bg_style1);
			$bg_styleId2 = $xls->addStyle($bg_style2);
			$bg_styleId3 = $xls->addStyle($bg_style3);

			if ( $property_name != $row['property'] ) {
				$property_name = $row['property'];
				if ( $anotherCount%2 == 0 ) {
					$bg_color = "#FCF3DA";
					} else {
						$bg_color = "#F8E8BB";
					}

				$anotherCount++;
				
				$cell = $xls->Cell(array('type'=>'String', 'data'=>'<B>' . $property_name . '</B>'), $bg_styleId);
				array_push($tempCell, $cell);

				for ($i=1; $i<count($csv_chart_data['columns'])+2; $i++) {
					if($i == count($csv_chart_data['columns'])+1) {
						$border = array($borderR, $borderT, $borderB);
					} else {
						$border = array($borderT, $borderB);
					}
					$bg_style = array( 
							"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
							"border" => $border
							);
						
					$bg_styleId = $xls->addStyle($bg_style);
					$cell = $xls->Cell(array("type"=>"String", "data" => ""), $bg_styleId);
					array_push($tempCell, $cell);
				}

				array_push($multiCell[$rowCount], $tempCell);
				$tempCell = array();
				$rowCount++;
				$multiCell[$rowCount] = array();		
				$modcount = 1;
			} 

			if ( $modcount%2 == 0 ) {
				$bg_color = '#dbc790';
			} 
			$bg_style = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderT, $borderR)
						);
			$bg_style2 = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR, $borderB)
						);
			$bg_style3 = array( 
						"interior" => array("Color" => $bg_color, "Pattern"=>"Solid"),
						"border" => array($borderL, $borderR)
						);
			
			$bg_styleId = $xls->addStyle($bg_style);
			$bg_styleId2 = $xls->addStyle($bg_style2);
			$bg_styleId3 = $xls->addStyle($bg_style3);

				$cell = $xls->Cell(array("type"=>"String", "data"=>"ARR/STAYOVER"), $b_styleId);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>"String", "data"=>$row['accommodation']), $bg_styleId3);
				array_push($tempCell, $cell);
				$i = 2;
				if ( $showUnitLabel == "1" ) {
					$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($row['unit_label']) ? $row['unit_label'] : "")), $bg_styleId3);
					array_push($tempCell, $cell);
					$i++;
				}

				if ( $showUnitNumber == "1" ) {
					$cell = $xls->Cell(array("type"=>"String", "data"=>$row['room']), $bg_styleId3);
					array_push($tempCell, $cell);
					$i++;
				}

				for($count=$i; $count<=$totalSubCellRoom;$count++) {
					if($count == $totalSubCellRoom) {
						$styleId = $bg_styleId2;
					}
					else {
						$styleId = $bg_styleId3;
					}
					$cell = $xls->Cell(array("type"=>"String", "data"=>""), $styleId);
					array_push($tempCell, $cell);
				}
				array_push($multiCell[$rowCount], $tempCell);
		
		}
		
		// [START] Room data headings -------------------------------------------
		$room_data_headings = '';
		$tempCell = array();
		$styleFlag = 1;
		foreach ( $showIds as $showId ) {
			$sectionId = 0;
			$repFlag = 0;
			if($styleFlag == 1) {
				$styleId = $hdr_styleId1;
			}
			else if($styleFlag == $totalSubCellRoom) {
				$styleId = $hdr_styleId2;
			}
			else {
				$styleId = $hdr_styleId3;
			}
			foreach ( $chartSections as $item ) {
				if ( $item['id'] == $showId ) {
					if($showId<23){
						$cell = $xls->Cell(array("type"=>"String", "data"=>$item['label']), $styleId);
						array_push($tempCell, $cell);
						if ( $roomRowSpans[$row['id']][$showId] > 1 ) {
							for ( $count = 1; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
								$cell = $xls->Cell(array("type"=>"String", "data"=>''), $styleId);
								array_push($tempCell, $cell);
							}
						}
					}
					else if($showId>=23) {
						for ( $count = 0; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
							if($styleFlag == 1) {
								$styleId = $hdr_styleId1;
							}
							else if($styleFlag == $totalSubCellRoom) {
								$styleId = $hdr_styleId2;
							}
							else {
								$styleId = $hdr_styleId3;
							}

							if($showId ==23 || $showId == 26) {
								$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId]['label']), $styleId);
								array_push($tempCell, $cell);
																
								if(in_array($showId+1, $showIds)) {
									if($styleFlag+1 == $totalSubCellRoom) {
										$styleId = $hdr_styleId2;
									}
									$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId+1]['label']), $styleId);
									array_push($tempCell, $cell);
								}
								if(in_array($showId+2, $showIds)) {
									if($styleFlag+2 == $totalSubCellRoom) {
										$styleId = $hdr_styleId2;
									}
									$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId+2]['label']), $styleId);
									array_push($tempCell, $cell);
								}
								$repflag = 1;
							}
							else if(($showId ==24 || $showId == 27) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									if(in_array($showId+1, $showIds)) {
										if($styleFlag+1 == $totalSubCellRoom) {
											$styleId = $hdr_styleId2;
										}
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId+1]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($showId ==25 || $showId == 28) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>$chartSections[$sectionId]['label']), $styleId);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								$styleFlag++;
						}	
					}
					if($item['id']==25){
						$repflag = 0;
					}
				}
				$sectionId++;
			}
			if($showId<23){
				$styleFlag++;
			}
		}
		
		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		// [ END ] Room data headings -----------------------------------------------
		
		// [START] Room information -------------------------------------------------
		foreach ( $csv_chart_data['columns'] as $col ) {
			$c = isset($csv_chart_data['room'][$row['id']][$col['id']]) ? $csv_chart_data['room'][$row['id']][$col['id']] : "";
			$b = isset($csv_chart_data['block'][$row['id']][$col['id']]) ? $csv_chart_data['block'][$row['id']][$col['id']] : "";
			
			$initialColour	  = array(0xff,0xff,0xff);
			$initialFontColour  = array(0x00,0x00,0x00);
			if ( $b ) {
				$initialColour = array(0xc0,0xc0,0xc0);
			}

			$room_information = "";
			$first = true;
			$repFlag = 0;
			$styleFlag = 1;
			foreach ( $showIds as $showId ) {
				$colour			= $initialColour;
				$fontColour = $initialFontColour;

				// Provisional booking
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 20 ) {
					$fontColour = array(0x33,0x66,0x99);
				}

				// Provisional expiring today
				if ( isset($c['rv_provision_expiry_date']) && $c['rv_provision_expiry_date'] == date("Y-m-d") )  {
					$colour = array(0xf1,0xc5,0x5d);
					$fontColour = array(0x00,0x00,0x00);
				}

				// Allocation
				if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 15 ) {
					$fontColour = array(0x99,0x99,0x99);
				}

				if($styleFlag == 1) {
						$border = array($borderL, $borderR, $borderT);
				}
				else if ($styleFlag == count($showIds)) {
					$border = array($borderL, $borderR, $borderB);
				}
				else {
					$border = array($borderL, $borderR);
				}

				if ( !isset($c[$showId]['value']) || !is_array($c[$showId]['value']) ) {
					// [START] Colour handling ----------------------------------------------
					if ( in_array($showId,$colourIds) && isset($c[$showId]['colour']) && $c[$showId]['colour'] != "" ) {
						$colour = array( 
							hexdec(substr($c[$showId]['colour'],0,2)),
							hexdec(substr($c[$showId]['colour'],2,2)),
							hexdec(substr($c[$showId]['colour'],4,2))
						);
					}
					if ( $error ) {
						$colour		= array(0xdb,0x42,0x42);
						$fontColour = array(0xff,0xff,0xff);
					}
					// [ END ] Colour handling ----------------------------------------------
					
					$colour = $xls->rgb2html($colour);
					
					$style1 = array( 
						"interior" => array("Color" => $colour, "Pattern"=>"Solid"),
						"border" => $border
						);
					
					if (isset($c[$showId]['value'])) {
						$stId = $xls->addStyle($style1);
						$cell = $xls->Cell(array("type"=>"String", "data"=>$c[$showId]['value']), $stId);
						array_push($tempCell, $cell);
					}

					if ($roomRowSpans[$row['id']][$showId] >1) {
						for ( $count = 1; $count < ($roomRowSpans[$row['id']][$showId]); $count++ ) {
							$cell = $xls->Cell(array("type"=>"String", "data"=>''), $stId);
							array_push($tempCell, $cell);
						}
					}
				} else {
						$used = 0;
						if($showId <23){
							foreach ( $c[$showId]['value'] as $cellItem ) {
								// [START] Colour handling ---------------------------------------------
								$colour		= $initialColour;
								$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
								if ( in_array($showId,$colourIds) && $cellItem['colour'] != "" ) {
									$colour = array( 
										 hexdec(substr($cellItem['colour'],0,2)),
										 hexdec(substr($cellItem['colour'],2,2)),
										 hexdec(substr($cellItem['colour'],4,2))
										);
									//$colour = '#' . $cellItem['colour'];
									//$colour = '#FF9900';
									
								}
								if ( $error ) {
									$colour			= array(0xdb,0x42,0x42);
									$fontColour	= array(0xff,0xff,0xff);
								}
								$colour = $xls->rgb2html($colour);
								// [ END ] Colour handling --------------------------------------------
								$style1 = array("interior" => array("Color" => $colour, "Pattern"=>"Solid"),
								"border" => $border
								);
								
								$stId = $xls->addStyle($style1);
								
								$cell = $xls->Cell(array("type"=>"String", "data"=>$cellItem['value']), $stId);
								array_push($tempCell, $cell);
								$used++;
							}
							if ( $used < $roomRowSpans[$row['id']][$showId] ) {
								for ( $count = 0; $count < ($roomRowSpans[$row['id']][$showId] - $used); $count++ ) {
									$cell = $xls->Cell(array("type"=>"String", "data"=>''), $stId);
									array_push($tempCell, $cell);
								}
							}

						} else if($showId>=23) {
							
							if($showId==26) {
								$repFlag = 0;
							}
							else if(!in_array(26,$showIds) && $showId == 27) {
								$repFlag = 0;
							}
							else if(!in_array(26,$showIds) && !in_array(27,$showIds) && $showId == 28) {
								$repFlag = 0;
							}

							for ( $count = 0; $count < $roomRowSpans[$row['id']][$showId]; $count++ ) {
								$cellItem = isset($c[$showId]['value'][$count]) ? $c[$showId]['value'][$count] : array();
								$cellItem2 = isset($c[$showId+1]['value'][$count]) ? $c[$showId+1]['value'][$count] : array();
								$cellItem3 = isset($c[$showId+2]['value'][$count]) ? $c[$showId+2]['value'][$count] : array();

								if ( $first && $error == true ) {
										$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
								}

								if($styleFlag == 1) {
									$border1 = array($borderL, $borderR, $borderT);
								}
								else if ($styleFlag == $totalSubCellRoom) {
									$border1 = array($borderL, $borderR, $borderB);
								}
								else {
									$border1 = array($borderL, $borderR);
								}

								if($styleFlag+1 == 1) {
									$border2 = array($borderL, $borderR, $borderT);
								}
								else if ($styleFlag+1 == $totalSubCellRoom) {
									$border2 = array($borderL, $borderR, $borderB);
								}
								else {
									$border2 = array($borderL, $borderR);
								}

								if($styleFlag+2 == 1) {
									$border3 = array($borderL, $borderR, $borderT);
								}
								else if ($styleFlag+2 == $totalSubCellRoom) {
									$border3 = array($borderL, $borderR, $borderB);
								}
								else {
									$border3 = array($borderL, $borderR);
								}

								// [START] Colour handling ---------------------------------------------
								$colour		= $initialColour;
								$fontColour = isset($initialFontColour) ? $initialFontColour : "#000";
								if ( in_array($showId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != "" ) {
									$colour = array( 
									 hexdec(substr($cellItem['colour'],0,2)),
									 hexdec(substr($cellItem['colour'],2,2)),
									 hexdec(substr($cellItem['colour'],4,2))
									);
								}
								$colour1 = $xls->rgb2html($colour);

								if (in_array($showId+1,$colourIds) && isset($cellItem2['colour']) && $cellItem2['colour'] != "") {
									$colour = array( 
									 hexdec(substr($cellItem2['colour'],0,2)),
									 hexdec(substr($cellItem2['colour'],2,2)),
									 hexdec(substr($cellItem2['colour'],4,2))
									);
								}
								$colour2 = $xls->rgb2html($colour);

								if (in_array($showId+2,$colourIds) && isset($cellItem3['colour']) && $cellItem3['colour'] != "") {
									$colour = array( 
									 hexdec(substr($cellItem3['colour'],0,2)),
									 hexdec(substr($cellItem3['colour'],2,2)),
									 hexdec(substr($cellItem3['colour'],4,2))
									);
								}
								$colour3 = $xls->rgb2html($colour);
								// [ END ] Colour handling --------------------------------------------
								$style1 = array("interior" => array("Color" => $colour1,
																	"Pattern"=>"Solid"),
												"border" => $border1
												);

								$style2 = array("interior" => array("Color" => $colour2, "Pattern"=>"Solid"),
								"border" => $border2
								);

								$style3 = array("interior" => array("Color" => $colour3, "Pattern"=>"Solid"),
								"border" => $border3
								);
									
								$stId1 = $xls->addStyle($style1);
								$stId2 = $xls->addStyle($style2);
								$stId3 = $xls->addStyle($style3);
							
								if($showId ==23 || $showId == 26) {
									if(in_array($showId, $showIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem['value']) ? $cellItem['value'] : "") ), $stId1);
										array_push($tempCell, $cell);
									}
									if(in_array($showId+1, $showIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data" => (isset($cellItem2['value']) ? $cellItem2['value'] : "") ), $stId2);
										array_push($tempCell, $cell);
									}
									if(in_array($showId+2, $showIds)) {
										//$cellItem3 = $c[$showId+2]['value'][$count];
										$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem3['value']) ? $cellItem3['value'] : "")), $stId3);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($showId ==24 || $showId == 27) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem['value']) ? $cellItem['value'] : "") ), $stId1);
										array_push($tempCell, $cell);
									}
									if(in_array($showId+1, $showIds)) {
										//$cellItem2 = $c[$showId+1]['value'][$count];
										$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem2['value']) ? $cellItem2['value'] : "") ), $stId2);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								else if(($showId ==25 || $showId == 28) && $repflag == 0) {
									if(in_array($showId, $showIds)) {
										$cell = $xls->Cell(array("type"=>"String", "data"=>(isset($cellItem['value']) ? $cellItem['value'] : "") ), $stId1);
										array_push($tempCell, $cell);
									}
									$repflag = 1;
								}
								$styleFlag++;
							}
						}
						$first = false;
					}
					if( (isset($showId) && $showId<23) || (isset($c[$showId]['value']) && !is_array($c[$showId]['value'])) ){
						$styleFlag++;
					}
				}
				array_push($multiCell[$rowCount], $tempCell);
				$tempCell = array();
			}
          
			if (isset($modcount)) {
				$modcount++;
			} else {
				$modcount = 1;
			}
			if (isset($rowCount)) {
				$rowCount++;
			} else {
				$rowCount = 1;
			}
		}
		  
		$cells = array();
		$rows = array();
		$temparr=array();
		$headerFlag = true;
		
		foreach($multiCell as $rowId=>$temparr) {
			if($rowId<=2) {
				if($headerFlag == true) {
					foreach($temparr as $cellArr) {
						foreach($cellArr as $tmp) {
							array_push($cells,$tmp);
						}
						$row = $xls->Row($cells);
						$cells = array();
						array_push($rows,$row);
					}
				}
			}
			else {
				if (isset($temparr[1])) {
					for ($cal=0;$cal<count($temparr[1]);$cal++) {
						for ($crow=0;$crow<count($temparr);$crow++) {
							if(isset($temparr[$crow][$cal])) {
								array_push($cells,$temparr[$crow][$cal]);
							}
							else {
								$cell = $xls->Cell(array("type"=>"String", "data"=>''), $borderLRStyleId);
								array_push($cells,$cell);
							}
						}
						if(!empty($cells)){
							$row = $xls->Row($cells);
							array_push($rows,$row);
						}
						$cells = array();
					}
				}
			}
			if($rowId==2) {
				$headerFlag = false;
			}
		}
		
		$table = $xls->Table($rows);
		array_push($tables, $table);
		
		// [ END ] Chart -------------------------------------------------------------
		
		// [START] Notes -------------------------------------------------------------
		if($showNotes == 1) {
			$notesTables = array();
			$note_table = array();
			
			$note_rows = generateXLSNotes($noteSections,$noteIds, $csv_notes_data, $noteSort, $xls);
			$note_table = $xls->Table($note_rows,2);
			array_push($notesTables, $note_table);
		}
		// [ END ] Notes -------------------------------------------------------------

		// Build the final XLS file ------------------------------------------------
		if($showChart == 1) {
			$xls->Worksheet($tables,1,"chart");
		}
		if($showNotes == 1) {
			$xls->Worksheet($notesTables,2,"notes");
		}
		
		$xls->genrateWorkbook($reportName, $repType);
}


function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;

	$pdfName = "Room report - $fromDate to $toDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,29))."+$newOptions+".join("+",array_slice($_SERVER['argv'],30,4));

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (isset($detail['pr_name_first']) && trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (isset($detail['pr_name_second']) && trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (isset($detail['pr_name_last']) && trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}
