<?php

/**
 * init.form360.php - Room report
 * Job: 292
 * Function: 103 (Report: Accommodation Chart)
*/
if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("room_chart");
processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);

$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Accommodation Chart";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_room.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$_SERVER['argv'] = array_pad($_SERVER['argv'],34,"");

$dateType = $_SERVER['argv'][1];
$dayCount = $_SERVER['argv'][2];
if(trim($dayCount) == "") {
	$dayCount = "0";
}
$GLOBALS['temp']['dayCount'] = $dayCount;

$GLOBALS['temp']['dateTypeTodayChecked'] = "";
$GLOBALS['temp']['dateTypeDayCountChecked'] = "";
$GLOBALS['temp']['dateTypeRangeChecked'] = "";
switch($dateType) {
case "1":
	$GLOBALS['temp']['dateTypeTodayChecked'] = "checked";
	$fromDate = useDate("from",date("Y-m-d"));
	$toDate = useDate("to",date("Y-m-d"));
	break;
case "2":
	$GLOBALS['temp']['dateTypeDayCountChecked'] = "checked";
	$fromDate = useDate("from",date("Y-m-d"));
	$toDate = useDate("to",date("Y-m-d",time() + (86400*$dayCount)));
	break;
default:
	$GLOBALS['temp']['dateTypeRangeChecked'] = "checked";
	$fromDate = useDate("from", $_SERVER['argv'][3]);
	$toDate = useDate("to", $_SERVER['argv'][4]);
	break;
}
if($_SERVER['argc'] < 2 && trim($_SERVER['argv'][5]) == "") {
	$_SERVER['argv'][5] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}
$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][5],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","ac_accomm_type.ac_accomm_type_ix",$accommACL,false,false);

if($_SERVER['argc'] == 1) {
	$_SERVER['argv'][7] = "30:20";
}
$statusACL = array("20","30","15");
$statusFilter = useFilter("statusRoom",$_SERVER['argv'][6],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$componantsACL= $lDB->get("
	SELECT DISTINCT
			rt_component.rt_component_ix
		FROM
			rt_component 
		WHERE
			rt_component_inactive_yn = '0'
",3);

$componentsFilter = useFilter("components",$_SERVER['argv'][33],"SELECT DISTINCT rt_component.rt_component_desc FROM rt_component WHERE rt_component_ix =", "rv_res_item_comp.rt_component_id", false, false, false);

$extraFilterType = $_SERVER['argv'][7];
if($extraFilterType == 1) {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "checked";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "";
} else {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "checked";
}

$extraFilter = useFilter("extras", $_SERVER['argv'][8], "SELECT ac_ext_desc FROM ac_extra WHERE ac_extra.ac_extra_ix =", "ac_extra.ac_extra_ix", false, false, false);
if($extraFilter['ids'] != "") {
   $catList = $lDB->get("
      SELECT DISTINCT
         ac_extra.ac_extra_category_id,
         ac_extra_category.ac_extra_cat_desc
      FROM
         ac_extra
         INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      WHERE
         ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
   ",2);
   $extraFilterRows = "";
   $extraFilterIds = "";
   foreach($catList as $item) {
      $extraList = $lDB->get("
         SELECT
            ac_extra.ac_extra_ix as ac_extra_ix,
            ac_ext_desc
         FROM
            ac_extra
         WHERE
            ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
            AND ac_extra.ac_extra_category_id = '$item[ac_extra_category_id]'
      ",2);
      $extraNames = "";
      $extraIds = "";
      foreach($extraList as $extraItem) {
         if($extraNames != "") {
            $extraNames .= ", ";
         }
         $extraNames .= $extraItem['ac_ext_desc'];
         if($extraIds != "") {
            $extraIds .= ":";
         }
         $extraIds .= $extraItem['ac_extra_ix'];
      }
      $extraFilterRows .= "
         <tr id=\"extra_$item[ac_extra_category_id]\">
            <td><textarea rows=1 style=\"width: 80px; height: 20px;\" id=\"extraCatText\" class=\"txtg\" readonly tabIndex=\"-1\">$item[ac_extra_cat_desc]</textarea></td>
            <td><textarea rows=1 style=\"width: 200px; height: 20px;\" id=\"extraText\" class=\"txtg\" readonly tabIndex=\"-1\">$extraNames</textarea></td>
            <td><input type=button class=\"button bDelete\" style=\"width:20; background-position: center;\" value=\"\" onclick=\"removeExtraIds('$item[ac_extra_category_id]');\"></td>
         </tr>
      ";
      $extraFilterIds .= "
         <input type=\"hidden\" id=\"extraIds_$item[ac_extra_category_id]\" name=\"extraIds\" value=\"$extraIds\">
      ";
   }
   $GLOBALS['temp']['extraFilterRows'] = $extraFilterRows;
   $GLOBALS['temp']['extraFilterIds'] = $extraFilterIds;
   $GLOBALS['temp']['extraAllClass'] = "collapse printCollapse";
} else {
   $GLOBALS['temp']['extraFilterRows'] = "";
   $GLOBALS['temp']['extraFilterIds'] = "";
   $GLOBALS['temp']['extraAllClass'] = "";
}

$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][9], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_ix", false, false, false);

if($extraFilterType == 1) {
	$extraFilterFinal = $extraCategoryFilter;
} else {
	$extraFilterFinal = $extraFilter;
}

$showExtra = $_SERVER['argv'][10];
$GLOBALS['temp']['extraShowAllChecked'] = "";
$GLOBALS['temp']['extraShowPropChecked'] = "";
$GLOBALS['temp']['extraShowNonChecked'] = "";
switch($showExtra) {
case "1":
	$GLOBALS['temp']['extraShowAllChecked'] = "checked";
	break;
default:
case "2":
	$GLOBALS['temp']['extraShowPropChecked'] = "checked";
	break;
case "3":
	$GLOBALS['temp']['extraShowNonChecked'] = "checked";
	break;
}

$direction = $_SERVER['argv'][11];
$GLOBALS['temp']['directionRoomChecked'] = "checked";
$GLOBALS['temp']['directionDateChecked'] = "";
if($direction == "2") {
	$GLOBALS['temp']['directionRoomChecked'] = "";
	$GLOBALS['temp']['directionDateChecked'] = "checked";
}

$roomSort = $_SERVER['argv'][12];
$GLOBALS['temp']['roomSortNumberChecked'] = "checked";
$GLOBALS['temp']['roomSortAccommChecked'] = "";
$roomSortSQL = "
			(ac_desc+0),
			ac_desc	
";
if($roomSort == "2") {
	$GLOBALS['temp']['roomSortNumberChecked'] = "";
	$GLOBALS['temp']['roomSortAccommChecked'] = "checked";
	$roomSortSQL = "
			ac_accomm_type.ac_accomm_desc,
			(ac_desc+0),
			ac_desc		
	";
}

$autoRoom = $_SERVER['argv'][13];
$GLOBALS['temp']['autoRoomChecked'] = "checked";
$GLOBALS['temp']['autoRoomWarning'] = "collapse printCollapse";
if($autoRoom == "2") {
	$GLOBALS['temp']['autoRoomChecked'] = "";
	$GLOBALS['temp']['autoRoomWarning'] = "";
}

$showChart = $_SERVER['argv'][14];
$GLOBALS['temp']['showChartChecked'] = "checked";
$GLOBALS['temp']['chartOptionStyle'] = "";
if($showChart == "2") {
	$GLOBALS['temp']['showChartChecked'] = "";
	$GLOBALS['temp']['chartOptionStyle'] = "display: none;";
}

$showNotes = $_SERVER['argv'][15];
$GLOBALS['temp']['showNotesChecked'] = "checked";
$GLOBALS['temp']['notesOptionStyle'] = "";
if($showNotes == "2") {
	$GLOBALS['temp']['showNotesChecked'] = "";
	$GLOBALS['temp']['notesOptionStyle'] = "display: none;";
}

$showAccomm = $_SERVER['argv'][16];
$GLOBALS['temp']['showAccommChecked'] = "checked";
if($showAccomm == "2") {
	$GLOBALS['temp']['showAccommChecked'] = "";
}

$showPAX = $_SERVER['argv'][17];
$GLOBALS['temp']['showPAXChecked'] = "checked";
if($showPAX == "2") {
	$GLOBALS['temp']['showPAXChecked'] = "";
}

$showLegend = $_SERVER['argv'][18];
$GLOBALS['temp']['showLegendChecked'] = "checked";
if($showLegend == "2") {
	$GLOBALS['temp']['showLegendChecked'] = "";
}

$showUnitLabel = $_SERVER['argv'][19];
$GLOBALS['temp']['showUnitLabelChecked'] = "checked";
if($showUnitLabel == "2") {
	$GLOBALS['temp']['showUnitLabelChecked'] = "";
}

$showUnitNumber = $_SERVER['argv'][20];
$GLOBALS['temp']['showUnitNumberChecked'] = "checked";
if($showUnitNumber == "2") {
	$GLOBALS['temp']['showUnitNumberChecked'] = "";
}

$showDatePAX = $_SERVER['argv'][21];
$GLOBALS['temp']['showDatePAXChecked'] = "checked";
if($showDatePAX == "2") {
	$GLOBALS['temp']['showDatePAXChecked'] = "";
}

$showCatExtras = $_SERVER['argv'][32];
$GLOBALS['temp']['showCatExtrasChecked'] = "checked";
if($showCatExtras == "2") {
	$GLOBALS['temp']['showCatExtrasChecked'] = "";
}

$roomJoins = array(
	array('table'=>'rv_res_item_group'),
	array('table'=>'rv_reservation_item','type'=>'INNER','on'=>'rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id','requires'=>"rv_res_item_group"),
	array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",'requires'=>"rv_reservation_item"),
	array('table'=>"pr_persona",'alias'=>"pr_agent_name",'type'=>"LEFT",'on'=>"pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_consultant",'type'=>"LEFT",'on'=>"pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_originator",'type'=>"LEFT",'on'=>"pr_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_country",'type'=>"LEFT",'on'=>"rf_country.rf_country_ix = rv_reservation.rf_country_id",'requires'=>"rv_reservation"),
	array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id",'requires'=>"rv_reservation"),
	array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id"),
	array('table'=>"ac_accomm_room",'type'=>"LEFT",'on'=>"ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id")
);
$itemJoins = array(
	array('table'=>'rv_reservation_item'),
	array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",'requires'=>"rv_reservation_item"),
	array('table'=>"pr_persona",'alias'=>"pr_agent_name",'type'=>"LEFT",'on'=>"pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_consultant",'type'=>"LEFT",'on'=>"pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_originator",'type'=>"LEFT",'on'=>"pr_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_country",'type'=>"LEFT",'on'=>"rf_country.rf_country_ix = rv_reservation.rf_country_id",'requires'=>"rv_reservation"),
	array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id",'requires'=>"rv_reservation"),
	array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id"),
);

$resJoins = array(
	array('table'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_agent_name",'type'=>"LEFT",'on'=>"pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_consultant",'type'=>"LEFT",'on'=>"pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_originator",'type'=>"LEFT",'on'=>"pr_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_country",'type'=>"LEFT",'on'=>"rf_country.rf_country_ix = rv_reservation.rf_country_id",'requires'=>"rv_reservation"),
	array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id",'requires'=>"rv_reservation")
);

// Do not use the ID to refer to a section as it may chance, rather add a 'name' field
$chartSections = array(
	array('id'=>1 ,'label'=>"Reservation number",                        'type'=>"string",  'fields'=>array("rv_reservation.rv_reservation_ix"),'colour'=>array('function'=>"getReservationColour",'fields'=>array("rv_reservation.rv_reservation_ix")),'style'=>array('bold'=>"1")),
	array('id'=>2 ,'label'=>"Reservation name",                          'type'=>"string",'fields'=>array("rv_reservation.rv_res_name"),'colour'=>array('function'=>"getReservationColour",'fields'=>array("rv_reservation.rv_reservation_ix"))),
	array('id'=>3,  'label'=>"PAX",                                      'type'=>"complex", 'fields'=>array("rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count"), 'function'=>"getPax"),
	array('id'=>4,  'label'=>"Itinerary dates",                          'type'=>"complex", 'fields'=>array("rv_reservation_item.rv_item_date_arrive","rv_reservation_item.rv_item_date_depart"), 'function'=>"getItineraryDates"),
	array('id'=>5,  'label'=>"Reservation status",                       'type'=>"string",  'fields'=>array("rf_reservation_status.rf_reservation_status_desc")),
	array('id'=>6,  'label'=>"Date status set",                          'type'=>"complex", 'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date"), 'function'=>"getStatusDate"),
	array('id'=>7,  'label'=>"Agent",                                    'type'=>"string",  'fields'=>array("pr_agent_name.pr_name_last as pr_agent_name"),'blank'=>"Direct",'colour'=>array('function'=>"getAgentColour",'fields'=>array("rv_reservation.rv_agent_id"))),
	array('id'=>8,  'label'=>"Originator",                               'type'=>"string",  'fields'=>array("pr_originator.pr_name_last as pr_originator_name"),'blank'=>"No originator",'colour'=>array('function'=>"getAgentColour",'fields'=>array("rv_reservation.rv_origin_agent_id"))),
	array('id'=>9,  'label'=>"Voucher",                                  'type'=>"string",  'fields'=>array("rv_reservation.rv_agent_ref")),
	array('id'=>10,  'label'=>"Payment status",                           'type'=>"complex", 'fields'=>array("rv_reservation.rv_amt_accomm_payable","rv_reservation.rv_amt_extra_payable","rv_reservation.rv_amt_travel_payable","rv_reservation.rv_amt_paid"), 'function'=>"getPaymentStatus", 'colour'=>array('function'=>"getPaymentColour",'fields'=>array("rv_reservation.rv_amt_accomm_payable","rv_reservation.rv_amt_extra_payable","rv_reservation.rv_amt_travel_payable","rv_reservation.rv_amt_paid"))),
	array('id'=>11, 'label'=>"Rate type",                                'type'=>"string",  'fields'=>array("rt_rate_type.rt_rate_type_desc"), 'colour'=>array('function'=>"getColourFromField", 'fields'=>array("rt_rate_type.rt_rate_type_colour"))),
	array('id'=>12,  'label'=>"Consultant",                              'type'=>"string",  'fields'=>array("pr_consultant.pr_name_first as pr_consultant_name_first","pr_consultant.pr_name_last as pr_consultant_name_last"),'blank'=>"No consultant", 'colour'=>array('function'=>"getConsultantColour",'fields'=>array("rv_reservation.rv_consultant_id"))),
	array('id'=>13, 'label'=>"Source",                                   'type'=>"string",  'fields'=>array("rf_source.rf_source_desc"),'blank'=>"No source",'colour'=>array('function'=>'getColourFromField','fields'=>array("rf_source.rf_source_colour"))),
	array('id'=>14, 'label'=>"Nationality",                              'type'=>"string",  'fields'=>array("rf_country.rf_country_name"),'colour'=>array('function'=>"getColourFromField", 'fields'=>array("rf_country.rf_country_colour"))),
	array('id'=>15, 'label'=>"Date reservation created",                 'type'=>"date",    'fields'=>array("rv_reservation.rv_date_recorded")),
	array('id'=>16, 'label'=>"Last amended date",                        'type'=>"date",    'fields'=>array("rv_reservation.rv_date_changed")),
	array('id'=>17, 'label'=>"Rooming status", 'type'=>"complex", 'fields'=>array("ac_accomm_type.ac_accomm_type_ix","ac_accomm_room.ac_accomm_type_id","rv_res_item_group.rv_room_requested_yn","rv_res_item_group.rv_room_request_reason"), 'function'=>"getRoomInfo"),
	array('id'=>18, 'label'=>"Optional itineray requests",               'type'=>"complex", 'fields'=>array("rv_reservation_item.rv_reservation_item_ix"), 'function'=>"getOptionalComponents"),
	array('id'=>19, 'label'=>"Guest names",                              'type'=>"complex", 'fields'=>array("rv_res_item_group.rv_res_item_group_ix","rv_reservation.rv_reservation_ix"), 'function'=>"getGuestNames"),
	array('id'=>20, 'label'=>"Guest information",                        'type'=>"string",  'fields'=>array("rv_reservation.rv_note_guests")),
	array('id'=>21, 'label'=>"Reservation notes",                        'type'=>"string",  'fields'=>array("rv_reservation.rv_note_general")),
	array('id'=>22, 'label'=>"Reservation internal memos",               'type'=>"string",  'fields'=>array("rv_reservation.rv_note_internal")),
	array('id'=>23, 'label'=>"Travel",                                   'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'function'=>"getTravel", 'colour'=>array()),
	array('id'=>24, 'label'=>"Travel notes",                                   'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'name'=>"travelNote", 'key'=>"travel", 'function'=>"getTravelChartNotes"),
	array('id'=>25, 'label'=>"Travel internal memos",                         'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'name'=>"travelNote", 'key'=>"travel", 'function'=>"getTravelChartMemo"),
	array('id'=>26, 'label'=>"Extras",                                   'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'function'=>"getExtras", 'colour'=>array()),
	array('id'=>27, 'label'=>"Extras notes",                                   'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'function'=>"getExtrasChartNotes"),
	array('id'=>28, 'label'=>"Extras internal memos",                          'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'function'=>"getExtrasChartMemo")
);

$noteSections = array(
	array('id'=>1,  'label'=>"Reservation notes",     'type'=>"string", 'fields'=>array("rv_reservation.rv_note_general"), 'name'=>"resNote", 'key'=>'rv_note_general'),
	array('id'=>2,  'label'=>"Internal memos",        'type'=>"string", 'fields'=>array("rv_reservation.rv_note_internal"), 'name'=>"resMemo", 'key'=>'rv_note_internal'),
	array('id'=>3,  'label'=>"Extras notes",          'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"extraNote", 'key'=>"extras"),
	array('id'=>4,  'label'=>"Extras internal memos", 'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"extraMemo", 'key'=>"extras"),
	array('id'=>5,  'label'=>"Only show extras with notes/memos", 'type'=>"ignore", 'name'=>"extraOnly", 'hide'=>true, 'key'=>"extras"),
	array('id'=>6,  'label'=>"Show extra category", 'type'=>"ignore", 'name'=>"extraCat", 'hide'=>true, 'key'=>"extras"),
	array('id'=>7,  'label'=>"Travel notes",          'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"travelNote", 'key'=>"travel"),
	array('id'=>8,  'label'=>"Travel internal memos", 'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"travelMemo", 'key'=>"travel"),
	array('id'=>9,  'label'=>"Only show travel with notes/memos", 'type'=>"ignore", 'name'=>"travelOnly", 'hide'=>true, 'key'=>"travel"),
	array('id'=>10,  'label'=>"Show travel category", 'type'=>"ignore", 'name'=>"travelCat", 'hide'=>true, 'key'=>"travel"),
	array('id'=>11,  'label'=>"Guest information",     'type'=>"string", 'fields'=>array("rv_reservation.rv_note_guests"), 'name'=>"guestNote", 'key'=>'rv_note_guests'),
	array('id'=>12,  'label'=>"Guest specific information", 'type'=>"complex", 'name'=>"guestSpecific"),
	array('id'=>13,  'label'=>"Guest names",           'type'=>"complex", 'parent'=>"guestSpecific", 'name'=>"guestName"),
	array('id'=>14,  'label'=>"Guest nationality",     'type'=>"complex", 'parent'=>"guestSpecific", 'name'=>"guestNationality"),
	array('id'=>15,  'label'=>"Guest notes",           'type'=>"complex", 'parent'=>"guestSpecific", 'name'=>"guestNote"),
	array('id'=>16, 'label'=>"Guest internal memos",  'type'=>"complex", 'parent'=>"guestSpecific", 'name'=>"guestMemo"),
	array('id'=>17, 'label'=>"Special events",        'type'=>"complex", 'parent'=>"guestSpecific", 'name'=>"guestSpecial"),
	array('id'=>18, 'label'=>"Room request reason",      'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'function'=>"getLockReasons", 'name'=>"roomLockReason", 'key'=>"lock_reasons")
);
$chartIds = array(
	'room'=>trim($_SERVER['argv'][22])==""?array():explode(":",$_SERVER['argv'][22]),
	'depart'=>trim($_SERVER['argv'][23])==""?array():explode(":",$_SERVER['argv'][23]),
	'colour'=>trim($_SERVER['argv'][24])==""?array():explode(":",$_SERVER['argv'][24]),
	'legend'=>trim($_SERVER['argv'][25])==""?array():explode(":",$_SERVER['argv'][25])
);
$chartIds['combined'] = array_unique(array_merge($chartIds['room'],$chartIds['depart']));

$noteIds = trim($_SERVER['argv'][26])==""?array():explode(":",$_SERVER['argv'][26]);

$noteSort = $_SERVER['argv'][27];
$GLOBALS['temp']['noteSortArriveChecked'] = "";
$GLOBALS['temp']['noteSortDepartChecked'] = "";
$GLOBALS['temp']['noteSortIdChecked'] = "";
$GLOBALS['temp']['noteSortNameChecked'] = "";
switch($noteSort) {
case "1":
	$GLOBALS['temp']['noteSortArriveChecked'] = "checked";
	break;
case "2":
	$GLOBALS['temp']['noteSortDepartChecked'] = "checked";
	break;
case "3":
	$GLOBALS['temp']['noteSortIdChecked'] = "checked";
	break;
default:
	$GLOBALS['temp']['noteSortNameChecked'] = "checked";
	break;
}

$noteDate = $_SERVER['argv'][28];
$GLOBALS['temp']['noteDateReservationChecked'] = "checked";
$GLOBALS['temp']['noteDatePropertyChecked'] = "";
if($noteDate == "2") {
$GLOBALS['temp']['noteDateReservationChecked'] = "";
$GLOBALS['temp']['noteDatePropertyChecked'] = "checked";
}

$options = $_SERVER['argv'][29];

switch ( $options & 7 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
	break;
case REP_VIEW_OO:
	$renderMode = "oofice";
	$renderType = "";
	break;
}

if ( isset($renderMode) && $renderMode == "pdf" && isset($renderType) && $renderType == "email" ) {
	outputMail($form,$options,$fromDate['htmlDate'],$toDate['htmlDate']);
}

if(isset($renderMode) && $renderMode == "html") {
	$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");
	$GLOBALS['temp']['ChartOptions'] = createChartOptions($chartSections,$chartIds);
	$GLOBALS['temp']['NoteOptions'] = createNoteOptions($noteSections,$noteIds);
	$GLOBALS['temp']['showResults'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "";
}

if($_SERVER['argc'] > 1) {
	$days = dateSubtract($toDate['jsDate'],$fromDate['jsDate'])+1;
	$startDate = strtotime($fromDate['jsDate']);
	$dates = array();
	for($count=0; $count<$days; $count++) {
		$currentDate = date("Y-m-d",$startDate+(86400*$count));
		$pax = getPaxByDate($currentDate,$accommFilter['where']);
		$dates[$currentDate] = array_merge(array(
			'id'=>$currentDate,
			'name'=>chng_date($currentDate,"-")
		),$pax);
	}

	$accommList = $lDB->get("
		SELECT
			sc_accomm.ac_accomm_type_id
		FROM
			sc_accomm
		INNER JOIN sc_user ON 
			sc_accomm.sc_group_id = sc_user.sc_group_id
		AND 
			sc_user.pr_user_id = '" . $GLOBALS['userid'] . "'
	",3);
	$accommWhere = " IN ('".join("','",$accommList)."') ";

	$roomsRaw = $lDB->get("
		SELECT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc,
			ac_accomm_type.ac_accomm_label,
			ac_accomm_room.ac_accomm_room_ix,
			ac_accomm_room.ac_desc
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix $accommWhere
			$accommFilter[where]
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '$toDate[jsDate]'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '$fromDate[jsDate]'
				)
			)
		ORDER BY
			pr_name_last,
			$roomSortSQL
	",2);
	$rooms = array();
	foreach($roomsRaw as $room) {
		$rooms[$room['ac_accomm_room_ix']] = array(
			'id'=>$room['ac_accomm_room_ix'],
			'ac_accomm_type_ix'=>$room['ac_accomm_type_ix'],
			'property'=>$room['pr_name_last'],
			'accommodation'=>$room['ac_accomm_desc'],
			'unit_label'=>$room['ac_accomm_label'],
			'room'=>$room['ac_desc'],
			'name'=>$room['pr_name_last']."\n".$room['ac_accomm_desc']."\n".$room['ac_desc']
		);
	}

	$accommRaw = $lDB->get("
		SELECT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc
		FROM
			ac_accomm_type
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix $accommWhere
			$accommFilter[where]
		ORDER BY
			pr_name_last
	",2);
	$accommTypes = array();
	foreach($accommRaw as $accomm) {
		$accommTypes[$accomm['ac_accomm_type_ix']] = array(
			'id'=>$accomm['ac_accomm_type_ix'],
			'property'=>$accomm['pr_name_last'],
			'accomodation'=>$accomm['ac_accomm_desc'],
			'name'=>$accomm['pr_name_last']."\n".$accomm['ac_accomm_desc']
		);
	}

	$data = array(
		'chart'=>array(
			'rows'=>array(),
			'columns'=>array(),
			'room'=>array(),
			'depart'=>array()
		),
		'notes'=>array(),
		'summary'=>array()
	);
	
	$chart =& $data['chart'];
	$notes =& $data['notes'];
	$summary =& $data['summary'];
	if($direction == "1") {
		$chart['rows'] = $dates;
		$chart['columns'] = $rooms;
		$chart['direction'] = 1;

		$summary['rows'] = $dates;
		$summary['columns'] = $accommTypes;
		$summary['direction'] = 1;
	} else {
		$chart['rows'] = $rooms;
		$chart['columns'] = $dates;
		$chart['direction'] = 2;
		
		$summary['rows'] = $accommTypes;
		$summary['columns'] = $dates;
		$summary['direction'] = 1;
	}
	
	foreach($rooms as $room) {
		foreach($dates as $date) {
			if($direction == "1") {
				$rowId = $date['id'];
				$colId = $room['id'];
			} else {
				$rowId = $room['id'];
				$colId = $date['id'];
			}
			if(!array_key_exists($rowId,$chart['room'])) {
				$chart['room'][$rowId] = array($colId=>array());
			}
			if(!array_key_exists($rowId,$chart['depart'])) {
				$chart['depart'][$rowId] = array($colId=>array());
			}
			
			$dayData = getRoomDayData($chartSections,$chartIds,$roomJoins,$room['id'],$date['id'],$statusFilter['where'],$extraFilterFinal['where'],$showExtra, $showCatExtras, $componentsFilter['where']);
			
			$chart['room'][$rowId][$colId] = $dayData['room'];
			$chart['depart'][$rowId][$colId] = $dayData['depart'];
			$chart['block'][$rowId][$colId] = $dayData['block'];
		}
	}
	
	// [START] - Auto room data generation
	if($autoRoom == "1") {
		$unallocated = getUnallocated($chartSections,$chartIds,$itemJoins,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['where'],$statusFilter['where'], $componentsFilter['where']);
		roomUnallocated($chartSections,$chartIds,$chart,$unallocated,$extraFilterFinal['where'],$showExtra, $componentsFilter['where']);
	}
	// [END] - Auto room data generation

	// [START] - Summary data generation
	foreach($accommTypes as $accomm) {
		foreach($dates as $date) {
			if($direction == "1") {
				$rowId = $date['id'];
				$colId = $accomm['id'];
			} else {
				$rowId = $accomm['id'];
				$colId = $date['id'];
			}
			if(!array_key_exists($rowId,$summary)) {
				$summary[$rowId] = array();
			}
			if(!array_key_exists('totals',$summary['rows'][$rowId])) {
				$summary['rows'][$rowId]['totals'] = array(
					'occupancy'=>0,
					'in'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'arrive'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'stay'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'depart'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0)
				);
			}
			if(!array_key_exists('totals',$summary['columns'][$colId])) {
				$summary['columns'][$colId]['totals'] = array(
					'occupancy'=>0,
					'in'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'arrive'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'stay'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'depart'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0)
				);
			}
			$summaryRowTotal =& $summary['rows'][$rowId]['totals'];
			$summaryColTotal =& $summary['columns'][$colId]['totals'];

			$summaryCell = getSummaryData($accomm['id'],$date['id']);

			foreach($summaryCell as $summaryKey=>$summaryItem) {
				if($summaryKey == "occupancy") {
					$summaryRowTotal['occupancy'] += $summaryItem;
					$summaryColTotal['occupancy'] += $summaryItem;
				} else {
					foreach($summaryItem as $paxKey=>$paxItem) {
						$summaryRowTotal[$summaryKey][$paxKey] += $paxItem;
						$summaryColTotal[$summaryKey][$paxKey] += $paxItem;
					}
				}
			}
			$summary[$rowId][$colId] = $summaryCell;
		}
	}
	//debug($summary);
	// [END] - Summary data generation
	
	if($showNotes == "1") {
		$propertyIds = array();
		if(hasSection($noteSections,"extraNote",$noteIds) || hasSection($noteSections,"extraMemo",$noteIds)) {
			$accommIds = explode(":",$accommFilter['ids']);
			foreach($accommIds as $item) {
				array_push($propertyIds,$lDB->get("SELECT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type_ix = '$item'",4));
			}
			$propertyIds = array_unique($propertyIds);
		} 
		$GLOBALS['noteReservations'] = array_unique($GLOBALS['noteReservations']);	
		foreach($GLOBALS['noteReservations'] as $resId) {
			$notes[$resId] = getNotes($noteSections,$noteIds,$resJoins,$resId,$noteDate,$accommFilter['where']);
			// Special sections
			if(hasSection($noteSections,"extraNote",$noteIds) || hasSection($noteSections,"extraMemo",$noteIds)) {
				if(hasSection($noteSections,"extraOnly",$noteIds)) {
					$extraOnly = true;
				} else {
					$extraOnly = false;
				}
				$notes[$resId]['extras'] = getExtraNotes($resId,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['ids'],$extraFilterFinal['where'],$extraOnly,$showExtra,$propertyIds);
			}
			if(hasSection($noteSections,"travelNote",$noteIds) || hasSection($noteSections,"travelMemo",$noteIds)) {
				if(hasSection($noteSections,"travelOnly",$noteIds)) {
					$travelOnly = true;
				} else {
					$travelOnly = false;
				}
				$notes[$resId]['travel'] = getTravelNotes($resId,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['ids'],$extraFilterFinal['where'],$travelOnly,$showExtra,$propertyIds);
			}
			if(hasSection($noteSections,"guestSpecific",$noteIds)) {
				$notes[$resId]['guests'] = getGuestDetails($resId,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['where']);
			}
		}

		switch($noteSort) {
		case "1":
			usort($notes,"noteSortArrive");
			break;
		case "2":
			usort($notes,"noteSortDepart");
			break;
		case "3":
			usort($notes,"noteSortId");
			break;
		case "4":
			usort($notes,"noteSortName");
			break;
		}
		//debug($notes);
	}
	// [Data generation section ends]
	if(isset($renderMode) && $renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));		
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		outputHTML($chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showLegend,$showUnitLabel,$showUnitNumber,$showDatePAX,$autoRoom,$data,$showCatExtras);
	}
	if ( isset($renderMode) && $renderMode == "pdf" && isset($renderType) && ($renderType == "view" || $renderType == "send") ) {
		outputPDF($renderType,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showLegend,$showUnitLabel,$showUnitNumber,$showDatePAX,$data,$fromDate['htmlDate'],$toDate['htmlDate'],$accommFilter['names'], $showCatExtras,$title);
	}
	if ( isset($renderMode) && ($renderMode == "csv" || $renderMode == "oofice") ) {
		$repName = str_replace(" ", "", str_replace(" ","_",strtolower($title)) . "_" . $fromDate['htmlDate'] . "_to_" . $toDate['htmlDate']);
		if ( $renderMode == "oofice" ) {
			$repName = $repName.".xml";
			$repType = "xml";
		} else {
			$repName = $repName.".xlsx";
			$repType = "xls";
		}
		outputCSV($data,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showLegend,$showUnitLabel,$showUnitNumber,$showDatePAX,$fromDate['htmlDate'],$toDate['htmlDate'],$accommFilter['names'], $showCatExtras, $repName, $repType);
	}

}
