<?php
/*
 * $Id: init.form361.php,v 1.8 2012-08-06 15:37:25 light Exp $
 *
 * $Log: init.form361.php,v $
 * Revision 1.8  2012-08-06 15:37:25  light
 * Bug #7824 - Financial Analysis
 *
 * Revision 1.7  2011-08-25 10:29:46  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.6  2011-05-17 14:08:31  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.5  2010-09-08 13:56:31  light
 * Bug #7251 - Casio interface enhancements
 *
 * Revision 1.4  2007-07-05 13:00:02  light
 * Bug #5760 - Revenue report: Provide an accomm type filter
 *
 * Revision 1.3  2007-06-20 14:04:11  gregs
 * Changed accommodation name font weight
 *
 * Revision 1.2  2007-06-16 15:26:30  light
 * New room report
 *
 * Revision 1.1  2007-06-16 15:12:16  light
 * New room report
 *
 *
 */

/**
 * init.form361.php - Property and accommodation filter
 * Job: 293
 * Function: 66 (General access)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!array_key_exists($form, $GLOBALS)) {
	$GLOBALS[$form] = "";
}

if (!is_object($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/filter_prop.htm");
}


#--------------------------------------------
# Get all selection filters/parameters
#--------------------------------------------
$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$jobid = $_SERVER['argv'][0];
$accommIds = trim($_SERVER['argv'][1]);
if($accommIds == "") {
	$accommIds = array();
} else {
	$accommIds = explode(":",$accommIds);
}
$type = $_SERVER['argv'][2];
if(empty($type)) {
	$type = 1;
}
$GLOBALS['temp']['type'] = $type;

$alias = $_SERVER['argv'][3];
$GLOBALS['temp']['alias'] = $alias;

$sc_group_id = $GLOBALS['sc_group_id'];

$result = $GLOBALS['lDB'] -> get("SELECT sc_grp_code, sc_grp_desc FROM sc_group WHERE sc_group_id = '$sc_group_id'",1);
$GLOBALS['temp']['sc_grp_code'] = $result['sc_grp_code'];
$GLOBALS['temp']['sc_grp_desc'] = $result['sc_grp_desc'];

#---------------------------------------------------------------------#
# Start of Data access code                                           #
#---------------------------------------------------------------------#

$accommList = $lDB->get("
	SELECT
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc,
		pr_business.pr_business_id,
		pr_persona.pr_name_last,
		pr_business.pr_bus_name_short,
		ac_accomm_type.ac_accomm_type_inactive_yn,
		pr_business.pr_bus_inactive_yn
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		sc_accomm.sc_group_id='$sc_group_id'
		/*AND ac_accomm_type.ac_accomm_type_inactive_yn=0
		AND pr_business.pr_bus_inactive_yn=0*/
   ORDER BY
      pr_business.pr_business_id,
      ac_accomm_type.ac_accomm_sequence
",2);
if(sizeof($accommIds) == 0) {
	$accommIds = array();
	foreach($accommList as $item) {
		array_push($accommIds,$item['ac_accomm_type_ix']);
	}
}
//debug($accommList);
//debug($GLOBALS['property_id']);
$newAccommList = array();
$accommNames = "";
foreach($GLOBALS['property_id'] as $propertyId) {
	$first = true;
	foreach($accommList as $item) {
		if($item['pr_business_id'] == $propertyId) {
			$newItem = array();
			if($first) {
				$newItem['pr_name_last'] = $item['pr_name_last'];
				if($item['pr_bus_inactive_yn'] == "1") {
					$newItem['pr_name_last'] = "<span class=\"txtg\">" . $newItem['pr_name_last'] . "</span>";
				}
				$newItem['has_property'] = true;
			} else {
				$newItem['has_property'] = false;
			}
			$newItem['pr_business_id'] = $item['pr_business_id'];
			$newItem['ac_accomm_type_id'] = $item['ac_accomm_type_ix'];
			$newItem['ac_accomm_desc'] = $item['ac_accomm_desc'];
			if($item['ac_accomm_type_inactive_yn'] == "1") {
				$newItem['ac_accomm_desc'] = "<span class=\"txtg\">" . $newItem['ac_accomm_desc'] . "</span>";
			}
			$newItem['accomm_checked'] = "";
			if(in_array($item['ac_accomm_type_ix'],$accommIds)) {
				$newItem['accomm_checked'] = "checked=\"checked\"";
			}
			array_push($newAccommList,$newItem);
			$accommNames .= "accommNames['$item[ac_accomm_type_ix]'] = \"$item[ac_accomm_desc] - $item[pr_bus_name_short]\";\n";
			$first = false;
		}
	}
}
$accommList = $newAccommList;
$GLOBALS['temp']['accommNames'] = $accommNames;
//debug($accommList);
# Get ordered list of all accomm types


# Generate HTML output
$rows = "";
$propHTML = join("",File(__DIR__ . "/../../../public/html/filter_prop_row.htm"));
$accommHTML = join("",File(__DIR__ . "/../../../public/html/filter_prop_accomm_row.htm"));
foreach($accommList as $item) {
	if($item['has_property']) {
		$rows .= showpage($item,$propHTML);
	} else {
		$rows .= showpage($item,$accommHTML);
	}
}
$GLOBALS['temp']['rows'] = $rows;
