<?php

/**
 * init.form362.php - Overbooking report
 * Job: 294
 * Function: 104 (Report: Overbooking)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}   

$pf_object_id = db_pf_object_by_name("overbooking_chart");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Overbooking Chart";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_overbooking.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$GLOBALS['temp']['dateSingleChecked'] = "";
$GLOBALS['temp']['dateRangeChecked'] = "";
$dateType = $_SERVER['argv'][1];
if($dateType == "range") {
	$GLOBALS['temp']['dateRangeChecked'] = "checked";
} else {
	$GLOBALS['temp']['dateSingleChecked'] = "checked";
}

$fromDate = useDate("from", $_SERVER['argv'][2]);
if($_SERVER['argv'][3] == "") {
	list($toYear, $toMonth, $toDay) = explode("-",date("Y-m-d"));
	$toMonth++;
	$_SERVER['argv'][3] = date("Y-m-d",mktime(0,0,0,$toMonth,$toDay,$toYear));
}
$toDate = useDate("to", $_SERVER['argv'][3]);

$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][4],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);



$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
$GLOBALS['temp']['filterStatus'] = "expand";
if($_SERVER['argv'][5] == "1") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Show Filters";
	$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
}
$options = $_SERVER['argv'][6];

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = "Overbooking Report";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,6))."+".$newOptions;

	$GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal -------------------------------------------------------------
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
  
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$GLOBALS['temp']['princName']	= $principalInfo['name'];
	$GLOBALS['temp']['fax']				= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel']	= $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);

	$GLOBALS['temp']['emailTo'] = "";
}

$GLOBALS['temp']['dataClass'] = "collapse printCollapse";
if($_SERVER['argc'] > 1) {
	if($dateType == "single") {
		$maxDate = $lDB->get("
			SELECT
				MAX(rv_reservation.rv_date_depart)
			FROM
				rv_reservation
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			WHERE
				1
				$accommFilter[where]
		",4);
	} else {
		$maxDate = $toDate['jsDate'];
	}
	if(trim($_SERVER['argv'][4]) == "") {
		$accommList = $accommACL;
	} else {
		$accommList = explode(":",$_SERVER['argv'][4]);
	}
	$today = date("Y-m-d");
	$days = array();
	foreach($accommList as $accommId) {
		$accommInfo = $lDB->get("
			SELECT
				ac_accomm_type.ac_accomm_desc,
				pr_persona.pr_name_last
			FROM
				ac_accomm_type
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			WHERE
				ac_accomm_type.ac_accomm_type_ix = '$accommId'
		",1);
		
		$stock = new Stock($accommId, $fromDate['jsDate'], $maxDate);
		$avail = $stock->toAvailability();
		foreach($avail as $date=>$count) {
			if($count < 0) {
				if(!array_key_exists($date,$days)) {
					$days[$date] = array();
				}
				$dateDiff = dateSubtract($date, $today);
				$days[$date][$accommId] = array(
					'ac_accomm_type_id'=>$accommId,
					'ac_accomm_desc'=>$accommInfo['ac_accomm_desc'],
					'pr_name_last'=>$accommInfo['pr_name_last'],
					'list'=>$lDB->get("
						SELECT
							rv_reservation.rv_reservation_ix,
							rv_reservation.rv_res_name,
							rf_reservation_status.rf_reservation_status_desc,
							rv_reservation_item.rv_item_date_arrive,
							rv_reservation_item.rv_item_date_depart,
							rv_reservation_item.rv_item_accomm_count,
							rv_reservation_item.rv_item_adult_count,
							rv_reservation_item.rv_item_child_count,
							rv_reservation_item.rv_item_nights
						FROM
							rv_reservation_item
							INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
							LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
						WHERE
							rv_reservation_item.ac_accomm_type_id = '$accommId'
							AND rv_reservation_item.rv_item_date_arrive <= '$date'
							AND rv_reservation_item.rv_item_date_depart > '$date'
							AND (
								rv_reservation.rf_reservation_status_id = '30'
								OR (
									rv_reservation.rf_reservation_status_id = '30'
									AND rv_reservation.rv_provision_expiry_date >= '$today'
								) OR (
									rv_reservation.rf_reservation_status_id = '15'
									AND rv_reservation.rv_alloc_expiry_date <> '0000-00-00'
									AND rv_reservation.rv_alloc_expiry_date >= '$today'
								) OR (
									rv_reservation.rf_reservation_status_id = '15'
									AND rv_reservation.rv_alloc_expiry_date = '0000-00-00'
									AND rv_reservation.rv_alloc_expiry_days <= $dateDiff
								)				
							)
				",2));
			}
		}
	}
	//	debug($days);
	
	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$GLOBALS['temp']['dataClass'] = "expand";
		
		if(sizeof($days) > 0) {
			$rows = "";
			foreach($days as $date=>$day) {
				$dateFmt = chng_date($date,"-");
				foreach($day as $accommId=>$accommInfo) {
					$rows .= "
						<tr>
							<td class=\"outDk ".getEffectClass()."\">$dateFmt</td>
							<td class=\"outDk ".getEffectClass()."\" >$accommInfo[pr_name_last]</td>
							<td class=\"outDk ".getEffectClass()."\" >$accommInfo[ac_accomm_desc]</td>
							<td class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						</tr>
					";
					$r = 255 - rand(10,130);
					$g = 255 - rand(10,130);
					$b = 255 - rand(10,130);
					$bg = dechex($r).dechex($g).dechex($b);
					$bg = "";
					$rows .= "
						<tr>
							<td colspan=\"4\">
								<table id=\"dataTable\" width=\"770\" cellspacing=\"0\" cellpadding=\"2\" style=\"width:770; table-layout:fixed;\" align=\"center\">
								<col width=\"80\" />
								<col width=\"150\" />
								<col width=\"100\" />
								<col width=\"80\" />
								<col width=\"80\" />
								<col width=\"40\" />
								<col width=\"40\" />
								<col width=\"40\" />
								<col width=\"40\" />
								<col width=\"120\" />
													
								<tr height=\"25\">
									<td class=\"outLt\">Res #</td>
									<td class=\"outLt\">Res Name</td>
									<td class=\"outLt\">Status</td>
									<td class=\"outLt\" align=\"center\">Arrival</td>
									<td class=\"outLt\" align=\"center\">Departure</td>
									<td class=\"outLt\" align=\"center\">Nights</td>
									<td class=\"outLt\" align=\"center\">Rooms</td>
									<td class=\"outLt\" align=\"center\">Adult</td>
									<td class=\"outLt\" align=\"center\">Child</td>
									<td class=\"outLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
								</tr>
					";
					foreach($accommInfo['list'] as $resItem) {
						$rows .= "
								<tr style=\"background-color: #$bg;\">
									<td class=\"".getEffectClass()."\" >$resItem[rv_reservation_ix]</td>
									<td class=\"".getEffectClass()."\" >$resItem[rv_res_name]</td>
									<td class=\"".getEffectClass()."\" >$resItem[rf_reservation_status_desc]</td>
									<td class=\"".getEffectClass()."\" align=\"center\">".chng_date($resItem['rv_item_date_arrive'],"-")."</td>
									<td class=\"".getEffectClass()."\" align=\"center\" >".chng_date($resItem['rv_item_date_depart'],"-")."</td>
									<td class=\"".getEffectClass()."\" align=\"center\" >$resItem[rv_item_nights]</td>
									<td class=\"".getEffectClass()."\" align=\"center\" >$resItem[rv_item_accomm_count]</td>
									<td class=\"".getEffectClass()."\" align=\"center\" >$resItem[rv_item_adult_count]</td>
									<td class=\"".getEffectClass()."\" align=\"center\" >$resItem[rv_item_child_count]</td>
									<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
								</tr>
						";
					}
					$rows .= "
								</table>
							</td>
						</tr>
					";
				}
			}
			$GLOBALS['temp']['rows'] = $rows;
		} else {
			$GLOBALS['temp']['rows'] = "
				<tr>
					<td colspan=\"5\" align=\"center\"><span class=\"txti\">No records found.</span></td>
				</tr>
			";
		}
	}

	if ( $renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
		$pdf = new PDF("Overbooking Report","L");
		$reportLabel = "Overbooking Report";

		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);

		if(sizeof($days) > 0) {
			$pdf->Row(array(
				array('width'=>"5%",'data'=>"Date",'border'=>"LRTB",'fill'=>"1"),
				array('width'=>"20%",'data'=>"Property",'border'=>"LRTB",'fill'=>"1"),
				array('width'=>"20%",'data'=>"Accommodation type",'border'=>"LRTB",'fill'=>"1"),
				array('width'=>"55%",'border'=>"LRTB",'fill'=>"1")
			));
			foreach($days as $date=>$day) {
				$dateFmt = chng_date($date,"-");
				foreach($day as $accommId=>$accommInfo) {
					$pdf->Row(array(
						array('width'=>"5%",'data'=>$dateFmt,'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"20%",'data'=>$accommInfo['pr_name_last'],'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"20%",'data'=>$accommInfo['ac_accomm_desc'],'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"55%",'border'=>"LRTB",'fill'=>"1")
					));
					$pdf->Row(array(
						array('width'=>"5%",'data'=>"Res #",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"20%",'data'=>"Reservation name",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"20%",'data'=>"Status",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"5%",'data'=>"Arrival",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"5%",'data'=>"Departure",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"4%",'data'=>"Nights",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"4%",'data'=>"Rooms",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"4%",'data'=>"Adult",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"4%",'data'=>"Child",'border'=>"LRTB",'fill'=>"1"),
						array('width'=>"29%",'border'=>"LRTB",'fill'=>"1")
					));
					foreach($accommInfo['list'] as $resItem) {
						$pdf->Row(array(
							array('width'=>"5%",'data'=>$resItem['rv_reservation_ix'],'border'=>"LR"),
							array('width'=>"20%",'data'=>$resItem['rv_res_name'],'border'=>"LR"),
							array('width'=>"20%",'data'=>$resItem['rf_reservation_status_desc'],'border'=>"LR"),
							array('width'=>"5%",'data'=>chng_date($resItem['rv_item_date_arrive'],"-"),'border'=>"LR"),
							array('width'=>"5%",'data'=>chng_date($resItem['rv_item_date_depart'],"-"),'border'=>"LR"),
							array('width'=>"4%",'data'=>$resItem['rv_item_nights'],'border'=>"LR"),
							array('width'=>"4%",'data'=>$resItem['rv_item_accomm_count'],'border'=>"LR"),
							array('width'=>"4%",'data'=>$resItem['rv_item_adult_count'],'border'=>"LR"),
							array('width'=>"4%",'data'=>$resItem['rv_item_child_count'],'border'=>"LR"),
							array('width'=>"29%",'border'=>"LR")
						));
					}
				}
			}			
			$pdf->Row(array(
				array('width'=>"100%",'border'=>"T")
			));
		} else {
			$pdf->Row(array(
				array('width'=>"100%",'data'=>"No records found.",'align'=>"C")
			));
		}
		$pdf->Ln(2);

		// Main PDF header
		if($dateType == "single") {
			$dateFilter = array('name'=>"From date", 'value'=>$fromDate['htmlDate']);
		} else {
			$dateFilter = array('name'=>"Date range", 'value'=>$fromDate['htmlDate'] . " to " . $toDate['htmlDate']);
		}
		$headerArray = array(
			$dateFilter,
			array('name'=>"Property Filter", 'value'=>$accommFilter['names'])
		);
		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->ReportHeader($reportLabel, $headerArray);
		
		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}

		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = $_POST['mail_subj'];
			$message = $_POST['mail_body'];
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS[princName],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}	

	if ( $renderMode == "csv" ) {
		$csvFile = array();

		array_push($csvFile,array("Overbooking Report"));
		array_push($csvFile,array());
		if($dateType == "single") {
			$fileDate = $fromDate['jsDate'];
			array_push($csvFile,array("From date",$fromDate['jsDate']));
		} else {
			$fileDate = $fromDate['jsDate'] . "_to_" . $toDate['jsDate'];
			array_push($csvFile,array("Date range",$fromDate['jsDate'] . " to " . $toDate['jsDate']));
		}
		array_push($csvFile,array("Property filter",$accommFilter['names']));
		array_push($csvFile,array());

		if(sizeof($days) > 0) {
			array_push($csvFile,array("Date","Property","Accommodation"));
			foreach($days as $date=>$day) {
				foreach($day as $accommId=>$accommInfo) {
					array_push($csvFile,array($date,$accommInfo['pr_name_last'],$accommInfo['ac_accomm_desc']));
					array_push($csvFile,array("Reservation number","Reservation name","Status","Arrival","Departure","Nights","Rooms","Adult","Child"));
					foreach($accommInfo['list'] as $resItem) {
						array_push($csvFile,array($resItem['rv_reservation_ix'],$resItem['rv_res_name'],$resItem['rf_reservation_status_desc'],$resItem['rv_item_date_arrive'],$resItem['rv_item_date_depart'],$resItem['rv_item_nights'],$resItem['rv_item_accomm_count'],$resItem['rv_item_adult_count'],$resItem['rv_item_child_count']));
					}
				}
			}
		} else {
			array_push($csvFile,array("No records found"));
		}	
		$csvText = "";
	
		foreach ( $csvFile as $csvLine ) {
			$first = true;
		
			foreach ( $csvLine as $csvItem ) {
				if ( !$first ) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"" . str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}

		if ( headers_sent() ) {
			echo('Some data has already been output to browser, can\'t send CSV file');
		}
	
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: ' . strlen($csvText));
		header("Content-Disposition: inline; filename=overbooking_$fileDate.csv");
		echo $csvText;
		flush();
		die();
	}	
}

function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
}

function getEffectClass() {
	return ((rand(0,10) > 5)?"blah".(rand(1,3)):"foo");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
