<?php

/**
 * init.form363.php - Batch / Transaction maintenance
 * Job: 295
 * Function: 101 (Financial: GL Batch)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("transaction_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Ledger Transactions";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();
$GLOBALS['temp']['glMessage'] = "";
$GLOBALS['temp']['glRows'] = "";

// Form setup
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS['form363'] = new Form("form363","",__DIR__ . "/../../../public/html/fin_ledger_tran.htm");
}
$_SERVER['argv'] = array_pad($_SERVER['argv'],29,"");
$billingUnitId = $_SERVER['argv'][1];
$propertyACL = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		pr_business.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
",3);
$billingUnitIds = array();
foreach($propertyACL as $property) {
	$currId = $property;
	$businessId = "";
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn, pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",1);
		if($billingYN['pr_bus_billing_yn'] == "1" || $billingYN['pr_bus_billing_prop_yn'] == "1") {
			$businessId = $currId;
		} else {
			$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
		}
	}
	array_push($billingUnitIds,$businessId);
}
$billingUnitIds = array_unique($billingUnitIds);
$billingUnitList = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last
	FROM
		pr_persona
	WHERE
		pr_persona.pr_persona_ix IN ('".join("','",$billingUnitIds)."')
",2);
$billingUnitOptions = "";
foreach($billingUnitList as $item) {
	$selected = "";
	if($billingUnitId == $item['pr_persona_ix']) {
		$selected = "selected";
	}
	$billingUnitOptions .= "<option value=\"$item[pr_persona_ix]\" $selected>$item[pr_name_last]</option>";
}
$GLOBALS['temp']['billingUnitOptions'] = $billingUnitOptions;

if(isset($_POST['codes']) && $_POST['codes'] != "") {
	tran_update_mapping(json_decode($_POST['codes']), $billingUnitId);
}

if(isset($_POST['transactions']) && $_POST['transactions'] != "") {
	tran_regenerate(array_unique(explode(":",$_POST['transactions'])));
}

if($_SERVER['argc'] < 3) {
	$_SERVER['argv'][2] = "0";
}
$batchACL = $GLOBALS['lDB']->get("SELECT fn_batch_ix FROM fn_batch WHERE fn_batch_closed_yn = '0'",3);
array_unshift($batchACL,"0");
$batchFilter = useFilter("batch",$_SERVER['argv'][2], "SELECT fn_batch.fn_batch_name FROM fn_batch WHERE fn_batch.fn_batch_ix =", "fn_batch.fn_batch_ix",$batchACL,"Unallocated","0",true);
if(in_array("0", explode(":",$batchFilter['ids']))) {
	$hasUnallocated = true;
} else {
	$hasUnallocated = false;
}

$serverFilter = useFilter("server",$_SERVER['argv'][3],"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=","fn_tran.fn_tran_db",false,"Reservation Office","Res");
$resList = $GLOBALS['lDB']->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$serverFilter['where'] = str_replace("'Res'","'".join("','",$resList)."'",$serverFilter['where']);

$dateRange = $_SERVER['argv'][4];
$GLOBALS['temp']['dateRangeCreationChecked'] = "checked";
$GLOBALS['temp']['dateRangeLedgerChecked'] = "";
if($dateRange == "2") {
	$GLOBALS['temp']['dateRangeCreationChecked'] = "";
	$GLOBALS['temp']['dateRangeLedgerChecked'] = "checked";
}
if($_SERVER['argv'][5] == "") {
	$_SERVER['argv'][5] = date("Y-m-01");
	$_SERVER['argv'][6] = date("Y-m-t");
}
$fromDate = useDate("from", $_SERVER['argv'][5]);
$toDate = useDate("to", $_SERVER['argv'][6]);

if($_SERVER['argv'][7] == "") {
	$_SERVER['argv'][7] = date("Y-m-01");
	$_SERVER['argv'][8] = date("Y-m-t");
}
$fromLedgerDate = useDate("fromLedger", $_SERVER['argv'][7]);
$toLedgerDate = useDate("toLedger", $_SERVER['argv'][8]);

$invoiceRange = $_SERVER['argv'][9];
$GLOBALS['temp']['invoiceRangeChecked'] = "";
if($invoiceRange == "1") {
	$GLOBALS['temp']['invoiceRangeChecked'] = "checked";
}
$invoiceDB = $_SERVER['argv'][10];
$invoicePrefix = $_SERVER['argv'][11];

$invoiceDBArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		fn_folio_db
	FROM
		fn_folio
	ORDER BY
		fn_folio_db
",3);
$invoiceDBList = "";
foreach($invoiceDBArray as $item) {
	if($item == $invoiceDB) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$invoiceDBList .= "<option $selected value=\"$item\">$item</option>";
}
if($invoiceDB == "") {
	$GLOBALS['temp']['invoiceDBAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['invoiceDBAllSelected'] = "";
}
$GLOBALS['temp']['invoiceDBList'] = $invoiceDBList;
$invoicePrefixArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		fn_invoice_prefix
	FROM
		fn_invoice
	WHERE
		trim(fn_invoice_prefix) <> ''
	ORDER BY
		fn_invoice_prefix
",3);
$invoicePrefixList = "";
foreach($invoicePrefixArray as $item) {
	if($item == $invoicePrefix) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$invoicePrefixList .= "<option $selected value=\"$item\">$item</option>";	
}
if($invoicePrefix == "") {
	$GLOBALS['temp']['invoicePrefixAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['invoicePrefixAllSelected'] = "";
}
$GLOBALS['temp']['invoicePrefixList'] = $invoicePrefixList;

$invoiceFrom = $_SERVER['argv'][12];
$GLOBALS['temp']['invoiceFrom'] = $invoiceFrom;
$invoiceTo = $_SERVER['argv'][13];
$GLOBALS['temp']['invoiceTo'] = $invoiceTo;

$paymentRange = $_SERVER['argv'][14];
$GLOBALS['temp']['paymentRangeChecked'] = "";
if($paymentRange == "1") {
	$GLOBALS['temp']['paymentRangeChecked'] = "checked";
}

$paymentDB = $_SERVER['argv'][15];

$paymentDBArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		rv_payment_db
	FROM
		rv_payment
	ORDER BY
		rv_payment_db
",3);
$paymentDBList = "";
foreach($paymentDBArray as $item) {
	if($item == $paymentDB) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$paymentDBList .= "<option $selected value=\"$item\">$item</option>";
}
if($paymentDB == "") {
	$GLOBALS['temp']['paymentDBAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['paymentDBAllSelected'] = "";
}
$GLOBALS['temp']['paymentDBList'] = $paymentDBList;


$paymentFrom = $_SERVER['argv'][16];
$GLOBALS['temp']['paymentFrom'] = $paymentFrom;
$paymentTo = $_SERVER['argv'][17];
$GLOBALS['temp']['paymentTo'] = $paymentTo;

$fn_batch_id = $_SERVER['argv'][18];
$batchItems = $_SERVER['argv'][19];
if(trim($batchItems) != "") {
	$batchItemList = explode(":",$batchItems);
	foreach($batchItemList as $item) {
		db_fn_tran_set_batch($item,$fn_batch_id);
	}
}

$GLOBALS['temp']['fn_batch_id'] = "";
$GLOBALS['temp']['fn_batch_name'] = "None";
if($fn_batch_id != "") {
	$GLOBALS['temp']['fn_batch_id'] = $fn_batch_id;
	$batchInfo = $GLOBALS['lDB']->get("
		SELECT
			fn_batch.fn_batch_name,
			fn_year.fn_year_end_date
		FROM
			fn_batch
			LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
		WHERE
			fn_batch.fn_batch_ix = '$fn_batch_id'
	",1);
	$batchFromDate = $GLOBALS['lDB']->get("
		SELECT
			fn_year.fn_year_end_date
		FROM
			fn_year
		WHERE
			fn_year.fn_year_end_date < '$batchInfo[fn_year_end_date]'
			AND fn_year.pr_business_id = '$billingUnitId'
		ORDER BY
			fn_year.fn_year_end_date DESC
	",4);
	if(empty($batchFromDate)) {
		$batchFromDate = "0000-00-00";
	}
	$GLOBALS['temp']['fn_batch_name'] = $batchInfo['fn_batch_name'];
	$batchToDate = $batchInfo['fn_year_end_date'];
	$dateArray = explode("-",$batchToDate);
}

$showBatch = $_SERVER['argv'][20];
$GLOBALS['temp']['showBatch'] = $showBatch;

$sort = $_SERVER['argv'][21];
if(trim($sort) == "") {
	$sort = "7";
}
$GLOBALS['temp']['sort'] = $sort;

$GLOBALS['temp']['batchUp'] = "std";
$GLOBALS['temp']['batchDown'] = "std";
$GLOBALS['temp']['ledgerUp'] = "std";
$GLOBALS['temp']['ledgerDown'] = "std";
$GLOBALS['temp']['sourceUp'] = "std";
$GLOBALS['temp']['sourceDown'] = "std";
$GLOBALS['temp']['resUp'] = "std";
$GLOBALS['temp']['resDown'] = "std";
$GLOBALS['temp']['linkIdUp'] = "std";
$GLOBALS['temp']['linkIdDown'] = "std";
$GLOBALS['temp']['nameUp'] = "std";
$GLOBALS['temp']['nameDown'] = "std";
$GLOBALS['temp']['amountUp'] = "std";
$GLOBALS['temp']['amountDown'] = "std";

$sqlOrderBy = "ORDER BY ";
switch($sort) {
case 1:
	$sqlOrderBy .= "fn_batch.fn_batch_name, fn_tran.fn_tran_date_ledger, fn_tran.fn_tran_link_ind";
	$GLOBALS['temp']['batchUp'] = "down";
	break;
case 2:
	$sqlOrderBy .= "fn_batch.fn_batch_name DESC, fn_tran.fn_tran_date_ledger DESC, fn_tran.fn_tran_link_ind DESC";
	$GLOBALS['temp']['batchDown'] = "down";
	break;
case 3:
	$sqlOrderBy .= "fn_tran.fn_tran_date_ledger, fn_tran.fn_tran_link_ind";
	$GLOBALS['temp']['ledgerUp'] = "down";
	break;
case 4:
	$sqlOrderBy .= "fn_tran.fn_tran_date_ledger DESC,fn_tran.fn_tran_link_ind DESC";
	$GLOBALS['temp']['ledgerDown'] = "down";
	break;
case 5:
	$sqlOrderBy .= "fn_tran.fn_tran_link_ind, fn_tran.fn_tran_date_ledger";
	$GLOBALS['temp']['sourceUp'] = "down";
	break;
case 6:
	$sqlOrderBy .= "fn_tran.fn_tran_link_ind DESC, fn_tran.fn_tran_date_ledger DESC";
	$GLOBALS['temp']['sourceDown'] = "down";
	break;
case 7:
	$sqlOrderBy .= "fn_tran.rv_reservation_id, fn_tran.fn_tran_link_ind";
	$GLOBALS['temp']['resUp'] = "down";
	break;
case 8:
	$sqlOrderBy .= "fn_tran.rv_reservation_id DESC, fn_tran.fn_tran_link_ind DESC";
	$GLOBALS['temp']['resDown'] = "down";
	break;
case 9:
	$sqlOrderBy .= "fn_tran.fn_tran_link_id";
	$GLOBALS['temp']['linkIdUp'] = "down";
	break;
case 10:
	$sqlOrderBy .= "fn_tran.fn_tran_link_id DESC";
	$GLOBALS['temp']['linkIdDown'] = "down";
	break;
case 11:
	$sqlOrderBy .= "pr_folio.pr_name_first, pr_folio.pr_name_last";
	$GLOBALS['temp']['nameUp'] = "down";
	break;
case 12:
	$sqlOrderBy .= "pr_folio.pr_name_first DESC, pr_folio.pr_name_last DESC";
	$GLOBALS['temp']['nameDown'] = "down";
	break;
case 13:
	$sqlOrderBy .= "fn_tran.fn_tran_amt_incl, fn_tran.fn_tran_link_ind";
	$GLOBALS['temp']['amountUp'] = "down";
	break;
case 14:
	$sqlOrderBy .= "fn_tran.fn_tran_amt_incl DESC, fn_tran.fn_tran_link_ind DESC";
	$GLOBALS['temp']['amountDown'] = "down";
	break;
}

$options = $_SERVER['argv'][22];
define("REP_TRAN_CSV",4);
define("REP_TRAN_ITEM_CSV",5);
define("REP_TRAN_ITEM_SUMMARY_CSV",6);

switch ( $options & 15 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_TRAN_CSV:
	$renderMode = "csv";
	$renderType = "tran";
	break;
case REP_TRAN_ITEM_CSV:
	$renderMode = "csv";
	$renderType = "tran_item";
	break;
case REP_TRAN_ITEM_SUMMARY_CSV:
	$renderMode = "csv";
	$renderType = "tran_item_summary";
	break;
}

$reportType = $_SERVER['argv'][23];
if(empty($reportType) || ($reportType != "tran" && $reportType != "code" &&  $reportType != "invent")) {
	$reportType = "tran";
}

if($reportType == "tran") {
	$GLOBALS['temp']['reportTypeTranChecked'] = "checked";
	$GLOBALS['temp']['reportTypeCodeChecked'] = "";
	$GLOBALS['temp']['reportTypeInventChecked'] = "";
} elseif ($reportType == "invent") { 
	$GLOBALS['temp']['reportTypeTranChecked'] = "";
	$GLOBALS['temp']['reportTypeCodeChecked'] = "";
	$GLOBALS['temp']['reportTypeInventChecked'] = "checked";
} else {
	$GLOBALS['temp']['reportTypeTranChecked'] = "";
	$GLOBALS['temp']['reportTypeInventChecked'] = "";
	$GLOBALS['temp']['reportTypeCodeChecked'] = "checked";
}

$Inventory = new Inventory();
$inventoryData = $Inventory->getTranSettings($billingUnitId)[0];
$canPostInventory = isset($Inventory->InventoryInvoiceUnits[$billingUnitId]) ? $Inventory->InventoryInvoiceUnits[$billingUnitId]['pr_bus_post_inventory_yn'] : '0';
if ($canPostInventory) {
	$GLOBALS['temp']['reportTypeInventAllowed'] = '';
	$GLOBALS['temp']['glInventPOCheckShowHide'] 	 = $inventoryData['pr_bus_post_in_po_yn'] ? "" : "collapse";
	$GLOBALS['temp']['glInventPOSetCheck']			 = $inventoryData['pr_bus_post_in_po_yn'] ? "checked" : "";
	$GLOBALS['temp']['glInventRetCheckShowHide'] 	 = $inventoryData['pr_bus_post_in_returns_yn'] ? "" : "collapse";
	$GLOBALS['temp']['glInventRetSetCheck'] 		 = $inventoryData['pr_bus_post_in_returns_yn'] ? "checked" : "";
	$GLOBALS['temp']['glInventCOSCheckShowHide'] 	 = $inventoryData['pr_bus_post_in_cos_yn'] ? "" : "collapse";
	$GLOBALS['temp']['glInventCOSSetCheck'] 		 = $inventoryData['pr_bus_post_in_cos_yn'] ? "checked" : "";
	$GLOBALS['temp']['glInventIssuesCheckShowHide']  = $inventoryData['pr_bus_post_in_issues_yn'] ? "" : "collapse";
	$GLOBALS['temp']['glInventIssuesSetCheck']		 = $inventoryData['pr_bus_post_in_issues_yn'] ? "checked" : "";
	$GLOBALS['temp']['glInventTrfCheckShowHide'] 	 = $inventoryData['pr_bus_post_in_trfs_yn'] ? "" : "collapse";
	$GLOBALS['temp']['glInventTrfSetCheck'] 		 = $inventoryData['pr_bus_post_in_trfs_yn'] ? "checked" : "";
	$GLOBALS['temp']['glInventCOSVoidSetCheck']		 = "";
} else {
	$GLOBALS['temp']['reportTypeInventAllowed'] = ' collapse printCollapse';
}

$tranTypeFilter = str_replace(':', ',', $_SERVER['argv'][28]);
if ($reportType == "invent") {
	$GLOBALS['temp']['glInventPOSetCheck'] = "";
	$GLOBALS['temp']['glInventRetSetCheck'] = "";
	$GLOBALS['temp']['glInventCOSSetCheck'] = "";
	$GLOBALS['temp']['glInventIssuesSetCheck'] = "";
	$GLOBALS['temp']['glInventTrfSetCheck'] = "";

	$tranTypeChecks = explode(':', $_SERVER['argv'][28]);
	foreach($tranTypeChecks as $tranTypeInd) {
		switch ($tranTypeInd) {
			case 51:
				$GLOBALS['temp']['glInventPOSetCheck'] = $inventoryData['pr_bus_post_in_po_yn'] ? "checked" : "";
				break;
			case 52:
				$GLOBALS['temp']['glInventRetSetCheck'] = $inventoryData['pr_bus_post_in_returns_yn'] ? "checked" : "";
				break;
			case 53:
				$GLOBALS['temp']['glInventCOSSetCheck'] = $inventoryData['pr_bus_post_in_cos_yn'] ? "checked" : "";
				break;
			case 54:
				$GLOBALS['temp']['glInventIssuesSetCheck'] = $inventoryData['pr_bus_post_in_issues_yn'] ? "checked" : "";
				break;
			case 55:
				$GLOBALS['temp']['glInventTrfSetCheck'] = $inventoryData['pr_bus_post_in_trfs_yn'] ? "checked" : "";
				break;
			case "voids":
				$GLOBALS['temp']['glInventCOSVoidSetCheck'] = "checked";
				break;
		}
	}
}

$paymentLinkedToInvoiceChecked = ($_SERVER['argv'][26] == "0")?false:true;
$paymentNotLinkedToInvoiceChecked = ($_SERVER['argv'][27] == "0")?false:true;
$GLOBALS['temp']['paymentLinkedToInvoiceChecked'] = !$paymentLinkedToInvoiceChecked ? "" : "checked";
$GLOBALS['temp']['paymentNotLinkedToInvoiceChecked'] = !$paymentNotLinkedToInvoiceChecked ? "" : "checked";

$glCodeSetChecked = ($_SERVER['argv'][24] == "1")?true:false;
$glCodeUnsetChecked = ($_SERVER['argv'][25] == "1")?true:false;
if(!$glCodeSetChecked && !$glCodeUnsetChecked) {
	$glCodeSetChecked = true;
	$glCodeUnsetChecked = true;
}

$GLOBALS['temp']['glCodeSetChecked'] = "";
if($glCodeSetChecked) {
	$GLOBALS['temp']['glCodeSetChecked'] = "checked";
}

$GLOBALS['temp']['glCodeUnsetChecked'] = "";
if($glCodeUnsetChecked) {
	$GLOBALS['temp']['glCodeUnsetChecked'] = "checked";
}

$GLOBALS['temp']['showTranData'] = "collapse";
$GLOBALS['temp']['showCodeData'] = "collapse";

if($renderMode == "pdf" && $renderType == "email") {
   $pdfName = "Transaction report";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,22))."+".$newOptions;

// echo $formAction."<BR>";

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '".$userId."'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}

$GLOBALS['temp']['showHideFilterButtonText'] = "<< Hide Filters";
$GLOBALS['temp']['filterDivClass'] = "expand";
$GLOBALS['temp']['filterStatus'] = "";

if($_SERVER['argc'] > 2) {
	$GLOBALS['temp']['showHideFilterButtonText'] = ">> Show Filters";
	$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";

	$dateSQL = "";
	if($hasUnallocated) {
		if($dateRange == "1") {
			$dateSQL = "
				AND fn_tran.ad_create_date >= '$fromDate[jsDate] 00:00:00'
				AND fn_tran.ad_create_date <= '$toDate[jsDate] 23:59:59'
			";
		} else {
			$dateSQL = "
				AND fn_tran.fn_tran_date_ledger >= '$fromLedgerDate[jsDate] 00:00:00'
				AND fn_tran.fn_tran_date_ledger <= '$toLedgerDate[jsDate] 23:59:59'
			";
		}
	}

	$rangeSQL = "";
	if($invoiceRange == "1" && $paymentRange != "1") {
		$rangeSQL = "
			AND fn_invoice.fn_invoice_id >= '$invoiceFrom'
			AND fn_invoice.fn_invoice_id <= '$invoiceTo'
			";
		if($invoiceDB != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_db = '$invoiceDB'
			";
		}
		if($invoicePrefix != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_prefix = '$invoicePrefix'
			";
		}
	} elseif ($invoiceRange != "1" && $paymentRange == "1") {
		$rangeSQL = "
			AND rv_payment.rv_payment_id >= '$paymentFrom'
			AND rv_payment.rv_payment_id <= '$paymentTo'
		";
		if($paymentDB != "") {
			$rangeSQL .= "
				AND rv_payment.rv_payment_db = '$paymentDB'
			";
		}
	} elseif ($invoiceRange == "1" && $paymentRange == "1") {
		$rangeSQL = "
			AND (
				(
					fn_invoice.fn_invoice_id >= '$invoiceFrom'
					AND fn_invoice.fn_invoice_id <= '$invoiceTo'
		";
		if($invoiceDB != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_db = '$invoiceDB'
			";
		}
		if($invoicePrefix != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_prefix = '$invoicePrefix'
			";
		}
		$rangeSQL .= "
				) OR (					
					rv_payment.rv_payment_id >= '$paymentFrom'
					AND rv_payment.rv_payment_id <= '$paymentTo'
		";
		if($paymentDB != "") {
			$rangeSQL .= "
					AND rv_payment.rv_payment_db = '$paymentDB'
			";
		}
		$rangeSQL .= "
				)
			)
		";
	}

	$glCodeSQL = "";
	if(!$glCodeSetChecked || !$glCodeUnsetChecked) {
		$glCodeSQL = "
			AND (
				SELECT
					COUNT(fn_tran_item.fn_tran_item_ix)
				FROM
					fn_tran_item
					LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				WHERE
					fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
					AND fn_tran_item.fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
					AND (
						fn_ledger.fn_ledger_ix IS NULL
						OR TRIM(fn_ledger.fn_ledger_code) = ''
					)
			)";
		if($glCodeSetChecked) {
			$glCodeSQL .= " = 0
			";
		}
		if($glCodeUnsetChecked) {
			$glCodeSQL .= " != 0
			";
		}
	}
	$voidFilter = "";
	if ($tranTypeFilter == 'voids') {
		$tranTypeFilter = '53';
		$voidFilter = '
			AND
			(
				SELECT 
					count(fn_void_list.fn_tran_ix) 
				FROM 
					fn_tran as fn_void_list
				WHERE
					fn_void_list.fn_tran_inventory_doc = fn_tran.fn_tran_inventory_doc
			) > 1
		';
	}
	if($reportType == "tran" || $reportType == "invent") {
		if($reportType == "invent") {
			$list = $GLOBALS['lDB']->get("
				SELECT
					fn_tran.fn_tran_ix,
					fn_tran.fn_tran_date_ledger,
					fn_tran.fn_tran_link_ind,
					fn_tran.fn_tran_link_id,
					fn_tran.fn_tran_detail,
					fn_tran.fn_tran_inventory_doc,
					fn_tran_item.fn_tran_cost_ctr1_id,
					fn_cost_centre_1.fn_cost_centre_code AS rv_reservation_id, -- to fit in with report template
					fn_cost_centre_2.fn_cost_centre_code AS rv_res_name,
					fn_cost_centre_2.fn_cost_centre_code AS fn_tran_cost_ctr2_id,
					'' AS fn_folio_ix,
					pr_business.pr_bus_home_curr_id AS folio_currency_id,
					fn_tran_item.fn_supplier_code,
					fn_tran_item.fn_tran_item_note,
					'&nbsp;' as pr_folio_first,
					'' AS rv_payment_ix,
					'' AS pr_payment_last,
					'' AS pr_payment_first,
					fn_tran.fn_tran_amt_incl,
					pr_business.pr_bus_name_short,
					fn_tran.fn_batch_id,
					fn_batch.fn_batch_ix,
					fn_batch.fn_batch_name,
					fn_batch.fn_batch_closed_yn,
					fn_year.fn_year_desc,
					fn_year.fn_year_end_date,
					SUM(fn_tran_item.fn_tran_item_amt) as fn_tran_item_amt,
					false AS currency_mismatch,
					fn_tran_contra.fn_tran_ix AS fn_tran_contra_id,
					(
						SELECT
							COUNT(fn_tran_item.fn_tran_item_ix)
						FROM
							fn_tran_item 
							LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
						WHERE
							fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
							AND fn_tran_item.fn_tran_item_type_ind IN ('70', '71', '72', '73') 
							AND 
							(
								(
									(fn_ledger.fn_ledger_ix IS NULL
									OR TRIM(fn_ledger.fn_ledger_code) = '')
									AND 
									(fn_tran_item.fn_supplier_code IS NULL
									OR TRIM(fn_tran_item.fn_supplier_code) = '')
								)
							)
					) as fn_tran_unmapped
				FROM
					fn_tran
					INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
					LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
					LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
					LEFT JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
					LEFT JOIN fn_tran AS fn_tran_contra ON fn_tran.fn_tran_contra_id = fn_tran_contra.fn_tran_ix
					LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
					LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
				WHERE
					fn_tran.fn_tran_link_ind IN ($tranTypeFilter)
					AND 
					fn_tran.pr_business_id = '$billingUnitId'
					$dateSQL
					$rangeSQL
					$batchFilter[where]
					$serverFilter[where]
					$glCodeSQL
					$voidFilter
				GROUP BY
					fn_tran.fn_tran_ix
				$sqlOrderBy
			",2);

		} elseif($reportType == "tran") {
			$list = $GLOBALS['lDB']->get("
				SELECT
					fn_tran.fn_tran_ix,
					fn_tran.fn_tran_date_ledger,
					fn_tran.fn_tran_link_ind,
					fn_tran.fn_tran_link_id,
					fn_tran.rv_reservation_id,
					rv_reservation.rv_res_name,
					fn_folio.fn_folio_ix,
					fn_folio.rf_currency_id AS folio_currency_id,
					pr_folio.pr_name_last as pr_folio_last,
					pr_folio.pr_name_first as pr_folio_first,
					rv_payment.rv_payment_ix,
					pr_payment.pr_name_last as pr_payment_last,
					pr_payment.pr_name_first as pr_payment_first,
					fn_tran.fn_tran_amt_incl,
					pr_business.pr_bus_name_short,
					fn_tran.fn_batch_id,
					fn_batch.fn_batch_ix,
					fn_batch.fn_batch_name,
					fn_batch.fn_batch_closed_yn,
					fn_year.fn_year_desc,
					fn_year.fn_year_end_date,
					SUM(fn_tran_item.fn_tran_item_amt) as fn_tran_item_amt,
					fn_tran_contra.fn_tran_ix AS fn_tran_contra_id,
					(
						SELECT
							COUNT(fn_tran_item.fn_tran_item_ix)
						FROM
							fn_tran_item 
							LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
						WHERE
							fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
							AND fn_tran_item.fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
							AND (
								fn_ledger.fn_ledger_ix IS NULL
								OR TRIM(fn_ledger.fn_ledger_code) = ''
							)
					) as fn_tran_unmapped
				FROM
					fn_tran
					INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
					LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
					LEFT JOIN pr_persona AS pr_folio ON pr_folio.pr_persona_ix = fn_tran.pr_persona_id
					LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
					LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
					LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
					LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					LEFT JOIN pr_persona AS pr_payment ON pr_payment.pr_persona_ix = rv_payment.pr_persona_id
					LEFT JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
					LEFT JOIN fn_tran AS fn_tran_contra ON fn_tran.fn_tran_contra_id = fn_tran_contra.fn_tran_ix
				WHERE
					fn_tran.pr_business_id = '$billingUnitId'
					$dateSQL
					$rangeSQL
					$batchFilter[where]
					$serverFilter[where]
					$glCodeSQL
				GROUP BY
					fn_tran.fn_tran_ix
				$sqlOrderBy
			",2);
		}
		if((!$paymentLinkedToInvoiceChecked || !$paymentNotLinkedToInvoiceChecked ) && $reportType != "invent") {
			if (!empty($list)) {
				foreach($list as $key=>$item) {
					if ($item['fn_tran_link_ind'] == 10) {
						$fn_invoice_id = $GLOBALS['lDB']->get("
							SELECT
								fn_invoice.fn_invoice_ix
							FROM
								fn_tran
								LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
								LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
								LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_folio.fn_invoice_id
							WHERE
								fn_tran.fn_tran_ix = '".$item['fn_tran_ix']."'
						",4);

						if ($paymentLinkedToInvoiceChecked && !$paymentNotLinkedToInvoiceChecked) {
							if (empty($fn_invoice_id)) {
								unset($list[$key]);
							}
						}

						if (!$paymentLinkedToInvoiceChecked && $paymentNotLinkedToInvoiceChecked) {
							if (!empty($fn_invoice_id)) {
								unset($list[$key]);
							}
						}
					}
				}
			}
		}

		$billingCurrency = $GLOBALS['lDB']->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$billingUnitId'",4);
		if (!empty($list)) {
			foreach($list as $key=>$item) {
				$list[$key]['totalMismatch'] = false;
				list($fn_tran_date_ledger_date, $fn_tran_date_ledger_time) = explode(" ",$list[$key]['fn_tran_date_ledger']);
				$list[$key]['fn_tran_date_ledger_fmt'] = chng_date($fn_tran_date_ledger_date,"-");
				$list[$key]['fn_tran_link_desc'] =  db_fn_tran_link_desc($item['fn_tran_link_ind']);
				if ($item['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE && $item['fn_tran_link_ind'] != DB_FN_TRAN_LINK_PO_RECEIPT && $reportType != 'invent') {
					$pr_name = trim($item['pr_payment_first'] . " " . $item['pr_payment_last']);
					if($pr_name == "") {
						$pr_name = "Cash";
					}
					$list[$key]['fn_tran_link_id'] = $item['rv_payment_ix'];
				} elseif ( $reportType == 'invent') {
					$pr_name = trim($item['fn_tran_detail']);
				} else {
					$pr_name = trim($item['pr_folio_first'] . " " . $item['pr_folio_last']);
					if($pr_name == "") {
						$pr_name = "Cash";
					}
				}
				$list[$key]['pr_name'] = $pr_name;

				$list[$key]['fn_tran_amt_incl'] = round($item['fn_tran_amt_incl'],2);
				fixAmtDisplay($list[$key]['fn_tran_amt_incl'],2);

				$debtorCurrency = $GLOBALS['lDB']->get("
					SELECT
						fn_debtor.rf_currency_id
					FROM
						fn_tran_item
						INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
					WHERE
						fn_tran_item.fn_tran_id = '$item[fn_tran_ix]'
						AND fn_tran_item.fn_tran_item_type_ind = ".DB_FN_TRAN_ITEM_TYPE_DEBTOR."
				",4);
				if(empty($debtorCurrency)) {
					$debtorCurrency = $billingCurrency;
				}

				$currencyMismatch = false;
				if($debtorCurrency != $billingCurrency && $debtorCurrency != $item['folio_currency_id'] && $reportType != 'invent') {
					$currencyMismatch = true;
				}

				$list[$key]['currency_mismatch'] = $currencyMismatch;

				if ( !empty($item['fn_tran_link_ind']) && in_array($item['fn_tran_link_ind'], $Inventory->FnTranTypeInd)) {
					$itemTotal = $GLOBALS['lDB']->get("SELECT SUM(abs(fn_tran_item_amt))/2 FROM fn_tran_item WHERE fn_tran_id = '" . $item['fn_tran_ix'] . "'", 4);
					$hasZeroBalanceItem = $GLOBALS['lDB']->get("SELECT COUNT(fn_tran_item_amt) FROM fn_tran_item WHERE fn_tran_id = '" . $item['fn_tran_ix'] . "' AND fn_tran_item_amt = 0",4);
					$list[$key]['totalMismatch'] = abs($item['fn_tran_amt_incl']) != $itemTotal || $hasZeroBalanceItem ?? '1';
				}
			}
		}

		if($renderMode == "html") {
			$GLOBALS['temp']['showTranData'] = "";
			setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
			if(db_pr_business_ledger_allow($billingUnitId)) {
				$allowEdit = true;
				$GLOBALS['temp']['allowEditStyle'] = "";
			} else {
				$allowEdit = false;
				$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
			}

			
			$rowHTML = join("",file(__DIR__ . "/../../../public/html/fin_ledger_tran_row.htm"));
			$rows = "";
			if (!empty($list)) {
				foreach($list as $item) {
					$item['batch_check'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">"; // Default to no checkbox
					$item['cellClass'] = array();
					$item['errors'] = array();
					$stockLocationError = 0;
					if ($reportType == 'invent' && (empty($item['fn_tran_cost_ctr2_id']) || empty($item['fn_tran_cost_ctr1_id']))) {
						$stockLocationError = '1';
					}
					if(!empty($item['fn_tran_contra_id'])) {
						$item['cellClass'][] = "txti";
						$item['errors'][] = "This item is part of a voided pair of transactions.";
					}
					if($item['fn_tran_item_amt'] == 0 && !$item['currency_mismatch'] && $item['fn_tran_unmapped'] == 0 && $item['totalMismatch'] == '0' && $stockLocationError == '0') {
						if($allowEdit) {
							if($fn_batch_id == "") { // No batch selected
								if($item['fn_batch_ix'] != "" && $item['fn_batch_closed_yn'] == "0") {
									$item['batch_check'] = "<input type=\"checkbox\" name=\"batch_check\" id=\"$item[fn_tran_ix]\">";
								}
							} else { // Batch selected
								if($item['fn_batch_ix'] != $fn_batch_id && ($item['fn_batch_ix'] == "" || $item['fn_batch_closed_yn'] == "0")) {
									list($ledgerDate,$ledgerTime) = explode(" ",$item['fn_tran_date_ledger']);
									if($ledgerDate > $batchFromDate && $ledgerDate <= $batchToDate) {
										$item['batch_check'] = "<input type=\"checkbox\" name=\"batch_check\" id=\"$item[fn_tran_ix]\">";
									}
								}
							}
						}
					} else {
						$item['cellClass'][] = "txtred";
						if($item['fn_tran_item_amt'] != 0) {
							$item['errors'][] = "Error! This transaction does not balance.";
						}
						if($item['currency_mismatch']) {
							$item['errors'][] = "Error! Currency mismatch between debtor and folio.";
						}
						if($item['fn_tran_unmapped'] != 0) {
							$item['errors'][] = "Error! This transaction contains items with missing or unmapped GL codes.";
						}
						if($item['totalMismatch']) {
							$item['errors'][] = "Error! GL totals do not balance.";
						}
						if($stockLocationError == '1') {
							$item['errors'][] = "Error! This inventory transaction has no stock location.";
						}
					}
					if ($reportType == 'invent') {
						$item['fn_tran_link_id'] = trim($item['fn_tran_inventory_doc']);
					}
					$item['cellClass'] = join(" ", $item['cellClass']);
					$item['errors'] = join("<br/>",$item['errors']);
					$item['rowAttrOver'] = "onmouseover=\"this.style.backgroundColor='#cfc';";
					$item['rowAttrOut'] = "onmouseout=\"this.style.backgroundColor='';";
					if(!empty($item['errors'])) {
						$item['rowAttrOver'] .= " overlib('".t_encodeOverlib($item['errors'])."');";
						$item['rowAttrOut'] .= " nd();";
					}
					$item['rowAttrOver'] .= "\"";
					$item['rowAttrOut'] .= "\"";
					$item['rowAttr'] = "onclick=\"showTran('$item[fn_tran_ix]');\" class=\"imgLink\" $item[rowAttrOver] $item[rowAttrOut]";
					$rows .= showpage($item,$rowHTML);
				}
			}
			if(sizeof($list) > 0) {
				$GLOBALS['temp']['rows'] = $rows;
			} else {
				$GLOBALS['temp']['rows'] = "
					<tr>
						<td class=\"txti\" colspan=\"9\" align=\"center\">No records found</td>
					</tr>
				";
			}
		}

		if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
			$pdf = new PDF($title);
			$reportLabel = $title;
			// Main PDF header
			$headerArray = array();

			$pdf->Row(array(
				array('width'=>"20%", 'height'=>"4", 'data'=>"Batch", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"8%", 'height'=>"4", 'data'=>"Ledger date", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"10%", 'height'=>"4", 'data'=>"Source", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"8%", 'height'=>"4", 'data'=>"Res no.", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"8%", 'height'=>"4", 'data'=>"Inv / Pmt no.", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"26%", 'height'=>"4", 'data'=>"Res / Payee name", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"10%", 'height'=>"4", 'data'=>"Amount", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
			));
			if (!empty($list)) {
				foreach($list as $item) {
					$pdf->Row(array(
						array('width'=>"20%", 'height'=>"4", 'data'=>$item['fn_batch_name'], 'border'=>"LTB"),
						array('width'=>"8%", 'height'=>"4", 'data'=>$item['fn_tran_date_ledger_fmt'], 'border'=>"LTB"),
						array('width'=>"10%", 'height'=>"4", 'data'=>$item['fn_tran_link_desc'], 'border'=>"LTB"),
						array('width'=>"8%", 'height'=>"4", 'data'=>$item['rv_reservation_id'], 'border'=>"LTB"),
						array('width'=>"8%", 'height'=>"4", 'data'=>$item['fn_tran_link_id'], 'border'=>"LTB"),
						array('width'=>"26%", 'height'=>"4", 'data'=>$item['pr_name'], 'border'=>"LTB"),
						array('width'=>"10%", 'height'=>"4", 'data'=>$item['fn_tran_amt_incl'], 'border'=>"LRTB",'align'=>"R"),
					));
				}
			}

			$pdf->Ln(2);
			$pdfFontSize = 6;
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->ReportHeader($reportLabel, $headerArray);

			if($renderType == "view") {
				pdf_view($pdf);
			}
			if($renderType == "send") {
				pdf_send($pdf,"Transaction report");
			}
		}

		if($renderMode == "csv") {
			if($renderType == "tran_item") {
				$sql_where = "
						fn_tran.pr_business_id = '$billingUnitId'
						$dateSQL
						$rangeSQL
						$voidFilter
						$batchFilter[where]
						$serverFilter[where]
					$sqlOrderBy		
				";

				$csvFile = tran_item_export($sql_where,false,true);
				csv_output("ledger_transaction_items",$csvFile);
			}
			if($renderType == "tran_item_summary") {
				$sql_where = "
						fn_tran.pr_business_id = '$billingUnitId'
						$dateSQL
						$rangeSQL
						$voidFilter
						$batchFilter[where]
						$serverFilter[where]	
				";

				$csvFile = tran_item_export($sql_where,true,true);
				csv_output("ledger_transaction_items",$csvFile);
			}
			if($renderType == "tran") {

				$sql_where = "
					fn_tran.pr_business_id = '$billingUnitId'
					$dateSQL
					$rangeSQL
					$voidFilter
					$batchFilter[where]
					$serverFilter[where]
				";

				$sql_extra = "
					$sqlOrderBy
				";

				$csvFile = tran_export($sql_where, $sql_extra, true);
				csv_output("ledger_transactions",$csvFile);
			}
		}
	} else { // $reportType == "code"
		$folios = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				fn_tran.fn_folio_id
			FROM
				fn_tran
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
				LEFT JOIN pr_persona AS pr_folio ON pr_folio.pr_persona_ix = fn_folio.fn_folio_to_id
				LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
				LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
				LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
				LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
				LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				LEFT JOIN pr_persona AS pr_payment ON pr_payment.pr_persona_ix = rv_payment.pr_persona_id
			WHERE
				fn_tran.pr_business_id = '$billingUnitId'
				$dateSQL
				$rangeSQL
				$batchFilter[where]
				$serverFilter[where]
		",3);

		$glList = array();

		if($invoiceRange == "1" || $paymentRange == "1") {
			$hasRangeFilter = true;
		} else {
			$hasRangeFilter = false;
		}

		if(!$hasRangeFilter || $invoiceRange == "1") {
			/* Accommodation */
			$glList = $lDB->get("
				SELECT DISTINCT
					CONCAT('accomm','_',rt_component.rt_component_ix) AS 'id',
					rt_component.rt_component_ix AS 'item_id',
					'Accommodation' AS 'type',
					rt_component.rt_component_desc AS 'desc',
					fn_ledger.fn_ledger_ix AS 'fn_ledger_id',
					fn_ledger.fn_ledger_code,
					fn_ledger.fn_ledger_desc
				FROM
					rv_reservation_item
					INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
					LEFT JOIN rt_component_inv ON rt_component_inv.pr_business_id = '$billingUnitId'
						AND rt_component_inv.rt_component_id = rt_component.rt_component_ix
					LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rt_component_inv.fn_ledger_id
					INNER JOIN fn_tran ON fn_tran.fn_folio_id = rv_reservation_item.fn_folio_id
						AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
					LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
					LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
					LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				WHERE
					rv_reservation_item.fn_folio_id IN ('".join("','",$folios)."')
					AND rv_res_item_comp.rv_item_comp_amt_payable != 0
					$dateSQL
					$rangeSQL
					$batchFilter[where]
					$serverFilter[where]
				GROUP BY
					rt_component.rt_component_ix
				ORDER BY
					rt_component.rt_component_desc
			",2);

			/* Extras */
			$glList = array_merge($glList,$lDB->get("
				SELECT DISTINCT
					CONCAT('extra','_',ac_extra.ac_extra_ix) AS 'id',
					ac_extra.ac_extra_ix AS 'item_id',
					'Extra' AS 'type',
					ac_extra.ac_ext_desc AS 'desc',
					IF(fn_ledger.fn_ledger_ix IS NOT NULL, fn_ledger.fn_ledger_ix, fn_ledger_cat.fn_ledger_ix) AS 'fn_ledger_id',
					IF(fn_ledger.fn_ledger_ix IS NOT NULL, fn_ledger.fn_ledger_code, fn_ledger_cat.fn_ledger_code) AS 'fn_ledger_code',
					IF(fn_ledger.fn_ledger_ix IS NOT NULL, fn_ledger.fn_ledger_desc, fn_ledger_cat.fn_ledger_desc) AS 'fn_ledger_desc'
				FROM
					rv_extra
					LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
					LEFT JOIN pr_business AS pr_billing ON pr_billing.pr_business_id = fn_folio.pr_business_id
					INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
					LEFT JOIN ac_extra_inv ON ac_extra_inv.pr_business_id = '$billingUnitId'
						AND ac_extra_inv.ac_extra_id = ac_extra.ac_extra_ix
					LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = ac_extra_inv.fn_ledger_id
					INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
					LEFT JOIN ac_extra_cat_inv ON ac_extra_cat_inv.pr_business_id = '$billingUnitId'
						AND ac_extra_cat_inv.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
					LEFT JOIN fn_ledger AS fn_ledger_cat ON fn_ledger_cat.fn_ledger_ix = ac_extra_cat_inv.fn_ledger_id
					INNER JOIN fn_tran ON fn_tran.fn_folio_id = rv_extra.fn_folio_id
						AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
					LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
					LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
					LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				WHERE
					rv_extra.fn_folio_id IN ('".join("','",$folios)."')
					AND rv_extra.rv_extra_amt_payable != 0
					$dateSQL
					$rangeSQL
					$batchFilter[where]
					$serverFilter[where]
				GROUP BY
					ac_extra.ac_extra_ix
				ORDER BY
					ac_extra.ac_ext_desc
			",2));
		}

		if(!$hasRangeFilter || $paymentRange == "1") {
			/* Payments */
			$glList = array_merge($glList,$lDB->get("
				SELECT DISTINCT
					CONCAT('bank','_',rf_bank.rf_bank_ix) AS 'id',
					rf_bank.rf_bank_ix AS 'item_id',
					'Bank' AS 'type',
					rf_bank.rf_bank_acc_name AS 'desc',
					fn_ledger.fn_ledger_ix AS 'fn_ledger_id',
					fn_ledger.fn_ledger_code,
					fn_ledger.fn_ledger_desc
				FROM
					rv_payment_item
					INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					INNER JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
					LEFT JOIN rf_bank_inv ON rf_bank_inv.rf_bank_id = rv_payment.rf_bank_id AND rf_bank_inv.pr_business_id = fn_folio.pr_business_id
					LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rf_bank_inv.fn_ledger_id_account
					INNER JOIN fn_tran ON fn_tran.fn_folio_id = fn_folio.fn_folio_ix
						AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
					LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
				WHERE
					rv_payment_item.fn_folio_id IN ('".join("','",$folios)."')
					AND rv_payment_item.rv_pay_item_amt_rec != 0
					$dateSQL
					$rangeSQL
					$batchFilter[where]
					$serverFilter[where]
				GROUP BY
					rf_bank.rf_bank_ix
				ORDER BY
					rf_bank.rf_bank_acc_name
			",2));

			/* Deposit / deposit reversal */
			$glList = array_merge($glList,$lDB->get("
				SELECT DISTINCT
					CONCAT('deposit','_',rf_bank.rf_bank_ix) AS 'id',
					rf_bank.rf_bank_ix AS 'item_id',
					'Deposit' AS 'type',
					rf_bank.rf_bank_acc_name AS 'desc',
					fn_ledger.fn_ledger_ix AS 'fn_ledger_id',
					fn_ledger.fn_ledger_code,
					fn_ledger.fn_ledger_desc
				FROM
					rv_payment_item
					INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					INNER JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
					LEFT JOIN rf_bank_inv ON rf_bank_inv.rf_bank_id = rv_payment.rf_bank_id AND rf_bank_inv.pr_business_id = fn_folio.pr_business_id
					LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rf_bank_inv.fn_ledger_id_deposit
					INNER JOIN fn_tran ON fn_tran.fn_folio_id = fn_folio.fn_folio_ix AND (
						fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_DEPOSIT."'
						OR fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_REVERSAL."'
					)				
					LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
				WHERE
					rv_payment_item.fn_folio_id IN ('".join("','",$folios)."')
					AND rv_payment_item.rv_pay_item_amt_rec != 0
					$dateSQL
					$rangeSQL
					$batchFilter[where]
					$serverFilter[where]
				GROUP BY
					rf_bank.rf_bank_ix
				ORDER BY
					rf_bank.rf_bank_acc_name
			",2));
		}

		if(!$hasRangeFilter || $invoiceRange == "1") {
			/* Tax */
			$glList = array_merge($glList,$lDB->get("
				(
					SELECT DISTINCT
						CONCAT('tax','_',rf_tax_rate.rf_tax_rate_ix) AS 'id',
						rf_tax_rate.rf_tax_rate_ix AS 'item_id',
						'Tax' AS 'type',
						rf_tax_rate.rf_tax_rate_desc AS 'desc',
						fn_ledger.fn_ledger_ix AS 'fn_ledger_id',
						fn_ledger.fn_ledger_code,
						fn_ledger.fn_ledger_desc
					FROM
						rv_reservation_item
						INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
						INNER JOIN rv_res_item_comp_tax ON rv_res_item_comp_tax.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
						LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp_tax.rf_tax_rate_id
						LEFT JOIN rf_tax_inv ON 
							rf_tax_inv.rf_tax_id = rv_res_item_comp_tax.rf_tax_rate_id
							AND rf_tax_inv.rf_tax_ind = 10
							AND rf_tax_inv.pr_business_id = '$billingUnitId'
						LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
						INNER JOIN fn_tran ON fn_tran.fn_folio_id = rv_reservation_item.fn_folio_id
							AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
						LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
						LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
						LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
						LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					WHERE
						rv_reservation_item.fn_folio_id IN ('".join("','",$folios)."')
						AND rv_res_item_comp_tax.rv_res_item_comp_tax_amt != 0
						$dateSQL
						$rangeSQL
						$batchFilter[where]
						$serverFilter[where]
					GROUP BY
						rf_tax_rate.rf_tax_rate_ix
				) UNION DISTINCT (
					SELECT DISTINCT
						IF (
							rv_extra.rv_extra_tax_ind = 10,
							CONCAT('tax','_',rf_tax_rate.rf_tax_rate_ix),
							CONCAT('tax','_',rt_tax_group.rt_tax_group_ix)
							) AS 'id',
						IF (
							rv_extra.rv_extra_tax_ind = 10,
							rf_tax_rate.rf_tax_rate_ix,
							rt_tax_group.rt_tax_group_ix
							) AS 'item_id',
						'Tax' AS 'type',
						IF (
							rv_extra.rv_extra_tax_ind = 10,
							rf_tax_rate.rf_tax_rate_desc,
							rt_tax_group.rt_tax_group_desc
						) AS 'desc',
						fn_ledger.fn_ledger_ix,
						fn_ledger.fn_ledger_code,
						fn_ledger.fn_ledger_desc
					FROM
						rv_extra
						LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id
						LEFT JOIN rf_tax_inv ON 
							rf_tax_inv.rf_tax_id = rv_extra.rf_tax_id
							AND rf_tax_inv.rf_tax_ind = rv_extra.rv_extra_tax_ind
							AND rf_tax_inv.pr_business_id = '$billingUnitId'
						LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
						INNER JOIN fn_tran ON fn_tran.fn_folio_id = rv_extra.fn_folio_id
							AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
						LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
						LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
						LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
						LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
						LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_extra.rf_tax_id
					WHERE
						rv_extra.fn_folio_id IN ('".join("','",$folios)."')
						AND rv_extra_amt_tax != 0
						$dateSQL
						$rangeSQL
						$batchFilter[where]
						$serverFilter[where]
					GROUP BY
						rf_tax_rate.rf_tax_rate_ix
				) ORDER BY
					`desc`
			",2));
		}

		$newGLList = array();
		foreach($glList as $glKey=>$glItem) {
			$glItem['fn_ledger_label'] = tran_account_pair_label($glItem['fn_ledger_code'],$glItem['fn_ledger_desc']);

			// find transactions associated with each item
			switch($glItem['type']) {
			case "Accommodation":
				$transactions = $lDB->get("
					SELECT DISTINCT
						fn_tran.fn_tran_ix
					FROM
						fn_tran
						LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
						INNER JOIN rv_reservation_item ON rv_reservation_item.fn_folio_id = fn_tran.fn_folio_id
						INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					WHERE
						rv_res_item_comp.rt_component_id = '$glItem[item_id]'
						AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
						AND fn_tran.fn_folio_id IN ('".join("','",$folios)."')
						AND contra_tran.fn_tran_ix IS NULL
				",3);
				break;
			case "Extra":
				$transactions = $lDB->get("
					SELECT DISTINCT
						fn_tran.fn_tran_ix
					FROM
						fn_tran
						LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
						INNER JOIN rv_extra ON rv_extra.fn_folio_id = fn_tran.fn_folio_id
					WHERE
						rv_extra.ac_extra_id = '$glItem[item_id]'
						AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
						AND fn_tran.fn_folio_id IN ('".join("','",$folios)."')
						AND contra_tran.fn_tran_ix IS NULL
				",3);
				break;
			case "Bank":
				$transactions = $lDB->get("
					SELECT DISTINCT
						fn_tran.fn_tran_ix
					FROM
						fn_tran
						LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
						INNER JOIN rv_payment_item ON rv_payment_item.fn_folio_id = fn_tran.fn_folio_id
						INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					WHERE
						rv_payment.rf_bank_id = '$glItem[item_id]'
						AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
						AND fn_tran.fn_folio_id IN ('".join("','",$folios)."')
						AND contra_tran.fn_tran_ix IS NULL
				",3);
				break;
			case "Deposit":
				$transactions = $lDB->get("
					SELECT DISTINCT
						fn_tran.fn_tran_ix
					FROM
						fn_tran
						LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
						INNER JOIN rv_payment_item ON rv_payment_item.fn_folio_id = fn_tran.fn_folio_id
						INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					WHERE
						rv_payment.rf_bank_id = '$glItem[item_id]'
						AND (
							fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_DEPOSIT."'
							OR fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_REVERSAL."'
						)
						AND fn_tran.fn_folio_id IN ('".join("','",$folios)."')
						AND contra_tran.fn_tran_ix IS NULL
				",3);
				break;
			case "Tax":
				$transactions = $lDB->get("
					(
						SELECT DISTINCT
							fn_tran.fn_tran_ix
						FROM
							fn_tran
							LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
							INNER JOIN rv_reservation_item ON rv_reservation_item.fn_folio_id = fn_tran.fn_folio_id
							INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
							INNER JOIN rv_res_item_comp_tax ON rv_res_item_comp_tax.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
						WHERE
							rv_res_item_comp_tax.rf_tax_rate_id = '$glItem[item_id]'
							AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
							AND fn_tran.fn_folio_id IN ('".join("','",$folios)."')
							AND contra_tran.fn_tran_ix IS NULL
					) UNION DISTINCT (
						SELECT DISTINCT
							fn_tran.fn_tran_ix
						FROM
							fn_tran
							LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
							INNER JOIN rv_extra ON rv_extra.fn_folio_id = fn_tran.fn_folio_id
						WHERE
							rv_extra.rf_tax_id = '$glItem[item_id]'
							AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
							AND fn_tran.fn_folio_id IN ('".join("','",$folios)."')
							AND contra_tran.fn_tran_ix IS NULL
					)
				",3);
				break;
			}
			$glItem['count'] = sizeof($transactions);
			$glItem['transactions'] = join(":",$transactions);

			if(sizeof($transactions) > 0) {
				$newGLList[] = $glItem;
			}
		}

		$glList = $newGLList;
		unset($newGLList);

		$problemVoids = ($lDB->get("
			SELECT
				COUNT(*)
			FROM
				fn_tran
				LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
			WHERE
				fn_tran.fn_folio_id IN ('".join("','",$folios)."')
				AND contra_tran.fn_tran_ix IS NOT NULL
				AND fn_ledger.fn_ledger_ix IS NULL
		",4) > 0)?true:false;

		if($renderMode == "html") {
			$GLOBALS['temp']['showCodeData'] = "";
			setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
			$glRowItems = array();
			if($GLOBALS['jobLevelArray'][295] > 5) {
				$glRowItems['check'] = "
					<td onclick=\"event.cancelBubble = true;\"><input type=\"checkbox\" id=\"!id!\" name=\"code_check\" /></td>
				";
			} else {
				$glRowItems['check'] = "<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>";
			}
			if($GLOBALS['jobLevelArray'][276] > 5) {
				$glRowItems['lookupButton'] = "
					<button class=\"button txts\" type=\"button\" style=\"width: 20px; height: 20px;\" onclick=\"glSearch(event,'!id!');\">
						<img src=\"/resource/Resrequest/Application/public/img/icon_search_16.gif\" width=\"16\" height=\"16\" alt=\"Search\" />
					</button>
				";
			} else {
				$glRowItems['lookupButton'] = "";
			}
			$glRowHTML = showpage($glRowItems,join("",file(__DIR__ . "/../../../public/html/fin_ledger_tran_gl_row.htm")));
			

			$glRows = "";
			foreach($glList as $glItem) {
				$glRows .= showpage($glItem,$glRowHTML);
			}
			if($problemVoids) {
				$GLOBALS['temp']['glMessage'] = "
					<br />
					<div class=\"bAll colOrange\" style=\"width:752px; margin: auto; padding: 8px;\">
						There are voided transactions with missing mappings detected within the results of your chosen filters. It is not possible to remap or regenerate these transactions from the \"Check codes\" type report. Use the \"Transaction\" type report, <span class=\"link\" onclick=\"showTransactionType();\">filtered to show only transactons with mappings missing</span>, to find and correct these voided transactions.

					</div>
					<br />
				";
			}
			if(sizeof($glList) > 0) {
				$GLOBALS['temp']['glRows'] = $glRows;
			} else {
				$GLOBALS['temp']['glRows'] = "
					<tr>
						<td class=\"txti\" colspan=\"5\" align=\"center\">No records found</td>
					</tr>
				";
			}

			$glSearch = $GLOBALS['lDB']->get("
				SELECT
					fn_ledger.fn_ledger_ix,
					fn_ledger.fn_ledger_code,
					fn_ledger.fn_ledger_desc
				FROM
					fn_ledger
				WHERE
					fn_ledger.pr_business_id = '$billingUnitId'
			",2);
			$glSearchRows = "";
			$glSearchHTML = "
				<tr onclick=\"glSearchSelect('!fn_ledger_ix!','!fn_ledger_label!');\" class='linkrow' onmouseover=\"this.style.backgroundColor = '#CCFFCC';\"  onmouseout=\"this.style.backgroundColor = ''\">
					<td>!fn_ledger_label!</td>
				</tr>
			";
			foreach($glSearch as $gl) {
				$gl['fn_ledger_label'] = tran_account_pair_label($gl['fn_ledger_code'],$gl['fn_ledger_desc']);
				$glSearchRows .= showpage($gl, $glSearchHTML);
			}
			$GLOBALS['temp']['glSearchRows'] = $glSearchRows;
		}
		$GLOBALS['temp']['regenerateButton'] = "";
		if($GLOBALS['jobLevelArray'][295] > 5) {
			$GLOBALS['temp']['regenerateButton'] = "
				<td>
					<button type=\"button\" class=\"button\" onclick=\"regenTran();\">Regenerate transactions</button>
				</td>
			";
		}

		$GLOBALS['temp']['codeButtons'] = "";
		if($GLOBALS['jobLevelArray'][276] > 5) {
			$GLOBALS['temp']['codeButtons'] = "
				<td>
					<button type=\"button\" class=\"button\" onclick=\"saveCodes();\">Save changes</button>
				</td>
				<td>
					<button type=\"button\" class=\"button\" onclick=\"revertCodes();\">Revert changes</button>
				</td>
			";
		}
	}
}

$GLOBALS['temp']['tranItemPopupJob'] = "296";
if(isset($GLOBALS['jobLevelArray'][1018]) && $GLOBALS['jobLevelArray'][1018] > 5) {
	$GLOBALS['temp']['tranItemPopupJob'] = "1018";
}
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
//$billingUnitFilter = useFilter("billingUnit", $_SERVER['argv'][1], "SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =", "pr_business.pr_business_id",$billingUnitACL, false, false); //$propertyACL, "Not property specific","0");


function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
   }
