<?php

/**
 * init.form363.php - Transaction detail popup
 * Job: 296 (view), 1018 (edit), 1019 (edit save)
 * Function: 101 (Financial: GL Batch)
 */

if(isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_tran_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$fn_tran_id = $_SERVER['argv'][1];
$GLOBALS['temp']['fn_tran_id'] = $fn_tran_id;

if($pmode == 1) {
	if(isset($_POST['codes']) && $_POST['codes'] != "") {
		processCodes(array_unique(json_decode($_POST['codes']), SORT_REGULAR));
	}
	if(isset($_POST['close']) && $_POST['close'] == "1") {
		echo "
			<script language=\"javascript\">
				if(opener.generateReport) {
					opener.generateReport();
				}
				window.close();
			</script>
		";
	} else {
		redirectTo(" reservation.php?1018+".$fn_tran_id);
	}
	die();
}

$sort = $_SERVER['argv'][2];
if(trim($sort) == "") {
	$sort = "1";
}
$GLOBALS['temp']['sort'] = $sort;

$options = $_SERVER['argv'][3];

$GLOBALS['temp']['ledgerUp'] = "std";
$GLOBALS['temp']['ledgerDown'] = "std";
$GLOBALS['temp']['debtorUp'] = "std";
$GLOBALS['temp']['debtorDown'] = "std";
$GLOBALS['temp']['cost1Up'] = "std";
$GLOBALS['temp']['cost1Down'] = "std";
$GLOBALS['temp']['cost2Up'] = "std";
$GLOBALS['temp']['cost2Down'] = "std";
$GLOBALS['temp']['invoiceUp'] = "std";
$GLOBALS['temp']['invoiceDown'] = "std";
$GLOBALS['temp']['exchUp'] = "std";
$GLOBALS['temp']['exchDown'] = "std";
$GLOBALS['temp']['glUp'] = "std";
$GLOBALS['temp']['glDown'] = "std";

$sqlOrderBy = "ORDER BY ";
switch($sort) {
case 1:
	$sqlOrderBy .= "fn_ledger.fn_ledger_code";
	$GLOBALS['temp']['ledgerUp'] = "down";
	break;
case 2:
	$sqlOrderBy .= "fn_ledger.fn_ledger_code DESC";
	$GLOBALS['temp']['ledgerDown'] = "down";
	break;
case 3:
	$sqlOrderBy .= "fn_debtor.fn_debtor_code";
	$GLOBALS['temp']['debtorUp'] = "down";
	break;
case 4:
	$sqlOrderBy .= "fn_debtor.fn_debtor_code DESC";
	$GLOBALS['temp']['debtorDown'] = "down";
	break;
case 5:
	$sqlOrderBy .= "cost_centre_1.fn_cost_centre_code";
	$GLOBALS['temp']['cost1Up'] = "down";
	break;
case 6:
	$sqlOrderBy .= "cost_centre_1.fn_cost_centre_code DESC";
	$GLOBALS['temp']['cost1Down'] = "down";
	break;
case 7:
	$sqlOrderBy .= "cost_centre_2.fn_cost_centre_code";
	$GLOBALS['temp']['cost2Up'] = "down";
	break;
case 8:
	$sqlOrderBy .= "cost_centre_2.fn_cost_centre_code DESC";
	$GLOBALS['temp']['cost2Down'] = "down";
	break;
case 9:
	$sqlOrderBy .= "fn_tran_item.fn_tran_item_amt_source";
	$GLOBALS['temp']['invoiceUp'] = "down";
	break;
case 10:
	$sqlOrderBy .= "fn_tran_item.fn_tran_item_amt_source DESC";
	$GLOBALS['temp']['invoiceDown'] = "down";
	break;
case 13:
	$sqlOrderBy .= "fn_tran_item.fn_tran_item_amt";
	$GLOBALS['temp']['glUp'] = "down";
	break;
case 14:
	$sqlOrderBy .= "fn_tran_item.fn_tran_item_amt DESC";
	$GLOBALS['temp']['glDown'] = "down";
	break;
}


define("REP_TRAN_CSV",4);
define("REP_TRAN_ITEM_CSV",5);
define("REP_TRAN_ITEM_SUMMARY_CSV",6);

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_TRAN_CSV:
	$renderMode = "csv";
	$renderType = "tran";
	break;
case REP_TRAN_ITEM_CSV:
	$renderMode = "csv";
	$renderType = "tran_item";
	break;
case REP_TRAN_ITEM_SUMMARY_CSV:
	$renderMode = "csv";
	$renderType = "tran_item_summary";
	break;
}

$inventTranTypes = [DB_FN_TRAN_LINK_PO_RECEIPT,DB_FN_TRAN_LINK_RETURN,DB_FN_TRAN_LINK_COS,DB_FN_TRAN_LINK_ISSUE,DB_FN_TRAN_LINK_TRANSFER];
$inventTranItemTypes = [DB_FN_TRAN_ITEM_TYPE_SUPP,DB_FN_TRAN_ITEM_TYPE_INVENT,DB_FN_TRAN_ITEM_TYPE_INP_VAT,DB_FN_TRAN_ITEM_TYPE_EXPENSE];
$inventory = false;

if($renderMode == "pdf" && $renderType == "email") {
   $pdfName = "Transaction items";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,3))."+".$newOptions;

// echo $formAction."<BR>";

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '".$userId."'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}



$tranInfo = $GLOBALS['lDB']->get("
	SELECT
		fn_tran.fn_tran_link_ind,
		fn_tran.fn_tran_link_id,
		fn_tran.fn_tran_detail,
		fn_tran.fn_tran_date_ledger,
		fn_tran.ad_create_date,
		fn_tran.fn_tran_exch_rate,
		fn_tran.fn_tran_inventory_doc,
		fn_tran.fn_batch_id,
		fn_batch.fn_batch_name,
		pr_business.pr_business_id,
		pr_business.pr_bus_name_short,
		gl_currency.rf_currency_symbol AS gl_currency_symbol,
		folio_currency.rf_currency_symbol AS folio_currency_symbol,
		payment_currency.rf_currency_symbol AS payment_currency_symbol,
		fn_tran.fn_tran_amt_incl,
		fn_tran.fn_tran_amt_excl,
		fn_tran.rv_reservation_id,
		fn_year.fn_year_desc,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		rv_payment.rv_payment_ix
	FROM
		fn_tran
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
		LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
		LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
		LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
		LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
		LEFT JOIN rf_currency AS payment_currency ON payment_currency.rf_currency_ix = rv_payment.rf_currency_id
		INNER JOIN rf_currency AS gl_currency ON gl_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
		LEFT JOIN rf_currency AS folio_currency ON folio_currency.rf_currency_ix = fn_folio.rf_currency_id
		
	WHERE
		fn_tran.fn_tran_ix = '$fn_tran_id'
",1);
$tranInfo['fn_tran_link_desc'] =  db_fn_tran_link_desc($tranInfo['fn_tran_link_ind']);
list($fn_tran_date_ledger_date, $fn_tran_date_ledger_time) = explode(" ",$tranInfo['fn_tran_date_ledger']);
$tranInfo['fn_tran_date_ledger'] = chng_date($fn_tran_date_ledger_date,"-");
list($ad_create_date,$ad_create_time) = explode(" ",$tranInfo['ad_create_date']);
$tranInfo['ad_create_date'] = chng_date($ad_create_date,"-");
$tranInfo['fn_tran_amt_tax'] = $tranInfo['fn_tran_amt_incl'] - $tranInfo['fn_tran_amt_excl'];
fixAmtDisplay($tranInfo['fn_tran_amt_tax'],2);
if(trim($tranInfo['fn_batch_id']) == "" || $tranInfo['fn_batch_id'] == "0") {
	$tranInfo['fn_batch_id'] = "unallocated";
}
$tranInfo['pr_name'] = trim($tranInfo['pr_name_first'] . " " . $tranInfo['pr_name_last']);
if($tranInfo['pr_name'] == "") {
	$tranInfo['pr_name'] = "Cash";
}

if($tranInfo['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
	if( in_array( $tranInfo['fn_tran_link_ind'], $inventTranTypes )) {
		$inventory = true;
		$tranInfo['fn_tran_link_id'] = $tranInfo['fn_tran_inventory_doc'];
		$tranInfo['source_currency_symbol'] = $tranInfo['gl_currency_symbol'];
	}
	else {
		$tranInfo['fn_tran_link_id'] = $tranInfo['rv_payment_ix'];
		$tranInfo['source_currency_symbol'] = $tranInfo['payment_currency_symbol'];
	}
} else {
	$tranInfo['source_currency_symbol'] = $tranInfo['folio_currency_symbol'];
}
$tranInfo['fn_tran_amt_incl'] = round($tranInfo['fn_tran_amt_incl'],2);
fixAmtDisplay($tranInfo['fn_tran_amt_incl'],2);
$tranInfo['fn_tran_amt_excl'] = round($tranInfo['fn_tran_amt_excl'],2);
fixAmtDisplay($tranInfo['fn_tran_amt_excl'],2);

$GLOBALS['temp'] = array_merge($GLOBALS['temp'],$tranInfo);

$list = $GLOBALS['lDB']->get("
	SELECT
		fn_tran.fn_batch_id,
		pr_business.pr_bus_name_short,
		fn_year.fn_year_desc,
		fn_tran.fn_tran_date_ledger,
		rf_currency.rf_currency_symbol,
		fn_tran_item.fn_tran_item_ix,
		fn_tran_item.fn_tran_item_type_ind,
		fn_tran_item.fn_supplier_code,
		fn_tran_item.fn_ledger_id,
		fn_ledger.fn_ledger_ix,
		fn_ledger.fn_ledger_code,
		fn_debtor.fn_debtor_code,
		cost_centre_1.fn_cost_centre_code AS cost_centre_1_code,
		cost_centre_2.fn_cost_centre_code AS cost_centre_2_code,
		rt_component_inv.rt_component_inv_meal_code,
		fn_tran_item.fn_tran_item_amt_source,
		fn_tran_item.fn_tran_item_amt,
		fn_tran.fn_tran_detail
	FROM
		fn_tran_item
		INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran_item.rf_currency_id
		LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
		LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
		LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
		LEFT JOIN fn_cost_centre AS cost_centre_1 ON cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
		LEFT JOIN fn_cost_centre AS cost_centre_2 ON cost_centre_2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
		LEFT JOIN rt_component_inv ON rt_component_inv.rt_component_inv_ix = fn_tran_item.rt_component_inv_id
	WHERE
		fn_tran_item.fn_tran_id = '$fn_tran_id'
	$sqlOrderBy
",2);
foreach($list as $key=>$item) {
	$list[$key]['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
	fixAmtDisplay($list[$key]['fn_tran_item_amt'],2);
	$list[$key]['fn_tran_item_amt_source'] = round($item['fn_tran_item_amt_source'],2);
	fixAmtDisplay($list[$key]['fn_tran_item_amt_source'],2);
}

if($renderMode == "html") {
	$rowHTML = join("",file(__DIR__ . "/../../../public/html/fin_ledger_tran_pop_row.htm"));
	$rows = "";
	foreach($list as $item) {
		$disableClass = "";
		$item['fn_tran_item_type_desc'] =  db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']);
		if($action != 3) {
			if($item['fn_ledger_code'] == "0" || trim($item['fn_ledger_code']) == "") {
				$item['fn_ledger_code'] = "&nbsp;";
			}
		} else {
			if($item['fn_debtor_code'] == "0" || trim($item['fn_debtor_code']) == "") {
				$item['fn_debtor_code'] = "&nbsp;";
				if($inventory) { 
					if($item['fn_tran_item_type_ind'] == '70') { 
						$disableClass = "collapse"; 
						$item['fn_debtor_code'] = "
							<input id='" . $item['fn_tran_item_ix'] . "_fn_supplier_code' type='text' style='width:65px;' value='" . $item['fn_supplier_code'] . "' />
							<input id='" . $item['fn_tran_item_ix'] . "_fn_supplier_code_old' type='hidden' value='" . $item['fn_supplier_code'] . "' 
							<input id=\"$item[fn_tran_item_ix]\" name=\"tran_item\" type=\"hidden\" value=\"\" />
						";
					}
					if ($item['fn_tran_item_type_ind'] == '71' && empty($item['fn_ledger_code'])) {
						$item['fn_ledger_code'] = $item['fn_ledger_id'];
					}
				}				
			}
				$item['fn_ledger_code'] = "
				<input id=\"$item[fn_tran_item_ix]_fn_ledger_label\" type=\"text\" class=\"$disableClass\" value=\"$item[fn_ledger_code]\" readonly style=\"width:65px;\" />
				<button class=\"button txts $disableClass\" type=\"button\" style=\"width: 20px; height: 20px;\" onclick=\"glSearch(event,'$item[fn_tran_item_ix]');\">
					<img src=\"/resource/Resrequest/Application/public/img/icon_search_16.gif\" width=\"16\" height=\"16\" alt=\"Search\" />
				</button>
				<input id=\"$item[fn_tran_item_ix]_fn_ledger_id\" type=\"hidden\" value=\"$item[fn_ledger_ix]\" />
				<input id=\"$item[fn_tran_item_ix]_fn_ledger_id_old\" type=\"hidden\" value=\"$item[fn_ledger_ix]\" />
				<input id=\"$item[fn_tran_item_ix]\" name=\"tran_item\" type=\"hidden\" value=\"\" />
			";
		}
		if($item['cost_centre_1_code'] == "0" || trim($item['cost_centre_1_code']) == "") {
			$item['cost_centre_1_code'] = "&nbsp;";
			if (in_array($item['fn_tran_item_type_ind'],$inventTranItemTypes)) {
				$item['cost_centre_1_code'] = getBusinessCostCentreSelect($tranInfo['pr_business_id'],$item['fn_tran_item_ix'],1);
			}
		}
		if($item['cost_centre_2_code'] == "0" || trim($item['cost_centre_2_code']) == "") {
			$item['cost_centre_2_code'] = "&nbsp;";
			if (in_array($item['fn_tran_item_type_ind'],$inventTranItemTypes)) {
				$item['cost_centre_2_code'] = getBusinessCostCentreSelect($tranInfo['pr_business_id'],$item['fn_tran_item_ix'],2);
			}
		}
		$rows .= showpage($item,$rowHTML);
	}
	$GLOBALS['temp']['rows'] = $rows;
	$GLOBALS['temp']['fn_tran_id'] = $fn_tran_id;

	if($action == 3) {
		$glSearch = $GLOBALS['lDB']->get("
			SELECT
				fn_ledger.fn_ledger_ix,
				fn_ledger.fn_ledger_code,
				fn_ledger.fn_ledger_desc
			FROM
				fn_ledger
			WHERE
				fn_ledger.pr_business_id = '$tranInfo[pr_business_id]'
		",2);
		$glSearchRows = "";
		$glSearchHTML = "
			<tr onclick=\"glSearchSelect('!fn_ledger_ix!','!fn_ledger_label!');\" class='linkrow' onmouseover=\"this.style.backgroundColor = '#CCFFCC';\"  onmouseout=\"this.style.backgroundColor = ''\">
				<td>!fn_ledger_label!</td>
			</tr>
		";
		foreach($glSearch as $gl) {
			$gl['fn_ledger_label'] = $gl['fn_ledger_code'];
			$glSearchRows .= showpage($gl, $glSearchHTML);
		}
		$GLOBALS['temp']['glSearchRows'] = $glSearchRows;
	}

	$mode = "view";
	$GLOBALS['temp']['editToggleJob'] = "1018";
	if($action == 3) {
		$mode = "edit";
		$GLOBALS['temp']['editToggleJob'] = "296";
	}

	$pgEdit = "0";
	$pgSave = "0";
	if(isset($GLOBALS['jobLevelArray'][1018]) && $GLOBALS['jobLevelArray'][1018] > 5) {
		$pgEdit = "1";
		if($action == 3) {
			$pgSave = "1";
		}
	} elseif($action == 3) {
		redirectTo(" reservation.php?296+".$fn_tran_id);
	}

	$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgEdit\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgSave\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"$pgSave\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"1\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"mode\" value=\"$mode\">\n";
}

if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$pdf = new PDF("Transaction items");
	$reportLabel = "Transaction items";
	// Main PDF header
	$headerArray = array();
	//$pdf->ReportHeader($reportLabel, $headerArray);
	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetFont('Arial', '', 7);
	$pdf->Row(array(
		array('width'=>"25%", 'data'=>"Source",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['fn_tran_link_desc'],'border'=>"LRTB"),
		array('width'=>"25%", 'data'=>"Inv / Pmt no.",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['fn_tran_link_id'],'border'=>"LRTB")
	));
	$pdf->Row(array(
		array('width'=>"25%", 'data'=>"Ledger date",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['fn_tran_date_ledger'],'border'=>"LRTB"),
		array('width'=>"25%", 'data'=>"Create date",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['ad_create_date'],'border'=>"LRTB")
	));
	$pdf->Row(array(
		array('width'=>"25%", 'data'=>"Inv unit",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['pr_bus_name_short'],'border'=>"LRTB"),
		array('width'=>"25%", 'data'=>"Batch",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['fn_batch_name'],'border'=>"LRTB")
	));
	$pdf->Row(array(
		array('width'=>"25%", 'data'=>"Amount excl",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['fn_tran_amt_excl'],'border'=>"LRTB"),
		array('width'=>"25%", 'data'=>"Amount incl",'border'=>"LRTB",'fill'=>1),
		array('width'=>"25%", 'data'=>$tranInfo['fn_tran_amt_incl'],'border'=>"LRTB")
	));
	$pdf->Row(array(
		array('width'=>"25%", 'data'=>"Detail",'border'=>"LRTB",'fill'=>1),
		array('width'=>"75%", 'data'=>$tranInfo['fn_tran_detail'],'border'=>"LRTB")
	));
	$pdf->Ln(2);
	$pdf->Row(array(
		array('width'=>"12%", 'height'=>"4", 'data'=>"Source", 'border'=>"LTB", 'fill'=>1),
		array('width'=>"12%", 'height'=>"4", 'data'=>"Ledger", 'border'=>"LTB", 'fill'=>1),
		array('width'=>"12%", 'height'=>"4", 'data'=>"Debtor", 'border'=>"LTB", 'fill'=>1),
		array('width'=>"12%", 'height'=>"4", 'data'=>"Cost ctr 1", 'border'=>"LTB", 'fill'=>1),
		array('width'=>"12%", 'height'=>"4", 'data'=>"Cost ctr 2", 'border'=>"LTB", 'fill'=>1),
		array('width'=>"15%", 'height'=>"4", 'data'=>"Invoice amt", 'border'=>"LTB", 'fill'=>1, 'align'=>"R"),
		array('width'=>"10%", 'height'=>"4", 'data'=>"Exch", 'border'=>"LTB", 'fill'=>1, 'align'=>"R"),
		array('width'=>"15%", 'height'=>"4", 'data'=>"GL amount", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
	));
	foreach($list as $item) {
		$pdf->Row(array(
			array('width'=>"12%", 'height'=>"4", 'data'=>db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']), 'border'=>"LTB"),
			array('width'=>"12%", 'height'=>"4", 'data'=>$item['fn_ledger_code'], 'border'=>"LTB"),
			array('width'=>"12%", 'height'=>"4", 'data'=>$item['fn_debtor_code'], 'border'=>"LTB"),
			array('width'=>"12%", 'height'=>"4", 'data'=>$item['cost_centre_1_code'], 'border'=>"LTB"),
			array('width'=>"12%", 'height'=>"4", 'data'=>$item['cost_centre_2_code'], 'border'=>"LTB"),
			array('width'=>"15%", 'height'=>"4", 'data'=>$item['fn_tran_item_amt_source'], 'border'=>"LTB", 'align'=>"R"),
			array('width'=>"15%", 'height'=>"4", 'data'=>$item['fn_tran_item_amt'], 'border'=>"LRTB", 'align'=>"R")
		));
	}
	$pdf->Ln(2);
	$pdfFontSize = 6;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->ReportHeader($reportLabel, $headerArray);

	if($renderType == "view") {
		pdf_view($pdf);
	}
	if($renderType == "send") {
		pdf_send($pdf,"Transaction report popup");
	}
}

if($renderMode == "csv") {
	if($renderType == "tran_item") {
		$sql_where = "
				fn_tran_item.fn_tran_id = '$fn_tran_id'
			$sqlOrderBy
		";
		$csvFile = tran_item_export($sql_where, false, true);
		csv_output("ledger_transaction_items",$csvFile);
	}
	if($renderType == "tran_item_summary") {
		$csvFile = tran_item_export("fn_tran_item.fn_tran_id = '$fn_tran_id'", true, true);
		csv_output("ledger_transaction_items",$csvFile);
	}
	if($renderType == "tran") {
		$sql_where = "
				fn_tran.fn_tran_ix = '$fn_tran_id'
		";

		$csvFile = tran_export($sql_where);
		csv_output("ledger_transactions",$csvFile);
	}
}

function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
   }

	function getBusinessCostCentreSelect($pr_business_id,$fn_tran_item_ix,$cc_no) {
		$costCentreOptions = "<option value=\"&nbsp;\">&nbsp;</option>";
		$costCentreList = $GLOBALS['lDB']->get("
			SELECT
				fn_cost_centre.fn_cost_centre_ix,
				CONCAT(fn_cost_centre.fn_cost_centre_code, ': ', fn_cost_centre.fn_cost_centre_desc) AS cost_centre
			FROM
				fn_cost_centre
			WHERE 
				fn_cost_centre.fn_cost_centre_ind = '$cc_no'
				AND
				fn_cost_centre.pr_business_id = '$pr_business_id'
		", 6);
		foreach ($costCentreList as $costCentreItem) {
			$costCentreOptions .= "<option value='" . $costCentreItem['fn_cost_centre_ix'] . "'>" . $costCentreItem['cost_centre'] . "</option>";
		}
		return "<select id='" . $fn_tran_item_ix . "_fn_tran_cost_ctr" . $cc_no . "_id' class='uk-select cost_ctr" . $cc_no . "_mapping_error' style='width: 90px;' onchange=\"overlayPopup('Warning', 'Please confirm Cost ctr " . $cc_no . " selection.<br>It cannot be changed once saved.');changeAllCC(this.selectedIndex,$cc_no);\">" . $costCentreOptions . "</select>
				<input id=\"" . $fn_tran_item_ix . "_fn_tran_cost_ctr" . $cc_no . "_id_old\" type=\"hidden\" value=\"&nbsp;\" />
				<input id=\"$fn_tran_item_ix" . "_" . $cc_no . "\" name=\"tran_item\" type=\"hidden\" value=\"\" />";
	}
