<?php

/*
 * $Id$
 *
 * $Log$
 */

/**
 * init.form365.php - Rate dropdown
 * Job: 297
 * Function: 66
*/

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", "");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$agentId = $_SERVER['argv'][1];
$agentCount = $GLOBALS['lDB']->get("SELECT COUNT(pr_agent_id) FROM pr_agent WHERE pr_agent_id = '$agentId'",4);
$showAll = $_SERVER['argv'][2];

$accommId = $_SERVER['argv'][3];
$accommCount = $GLOBALS['lDB']->get("SELECT COUNT(ac_accomm_type_ix) FROM ac_accomm_type WHERE ac_accomm_type_ix = '$accommId'",4);
$fromDate = $_SERVER['argv'][4];

$currencyId = $_SERVER['argv'][5];
$currencySQL = "";
if(trim($currencyId) != "") {
	$currencySQL = "AND rt_rate_type.rf_currency_id = '$currencyId'";
}

$rateList = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_ix,
		rt_rate_type.rt_rate_type_desc,
		rt_rate_type.rt_rate_type_note,
		rt_rate_type.rt_rate_type_colour,
		rt_rate_type.rf_currency_id,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_inactive_yn = '0'
		$currencySQL
	ORDER BY
		rt_rate_type.rt_rate_type_desc
",2);

$agentList = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_rate.pr_agent_id = '$agentId'",3);
$defaultList = $GLOBALS['lDB']->get("SELECT rf_default_rate_id FROM rf_default_rate",3);

$newRateList = array();
foreach($rateList as $rate) {
	// Check if this rate is allocated to the specified agent
	$rate['agent'] = false;
	if($agentCount > 0 && in_array($rate['rt_rate_type_ix'],$agentList)) {
		$rate['agent'] = true;
	}
	if($agentCount == 0 && in_array($rate['rt_rate_type_ix'],$defaultList)) {
		$rate['agent'] = true;
	}

	// Check if this rate exists for the given accommodation type
	$rate['accomm'] = false;
	if($accommCount > 0) {
		$rateCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(rt_rate_component_ix)
			FROM
				rt_rate_component
				INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
				INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
			WHERE
				rt_rate.ac_accomm_type_id = '$accommId'
				AND rt_rate.rt_rate_type_id = '$rate[rt_rate_type_ix]'
				AND rt_period_date_from <= '$fromDate'
				AND rt_period_date_to >= '$fromDate'
		",4);
		if($rateCount > 0) {
			$rate['accomm'] = true;
		}
	}

	// Decide on whether to add this rate to the list or not
	if($GLOBALS['userStatusId'] > 1) { // Add all rates for internal users
		array_push($newRateList,$rate);
	} else {
		if($agentCount > 0) { // Add only agent specific rates for external users
			if($rate['agent']) {
				array_push($newRateList,$rate);
			}
		} else { // Add the default rates for public users
			if(in_array($rate['rt_rate_type_ix'],$defaultList)) {
				array_push($newRateList,$rate);
			}
		}
	}
}
$rateList = $newRateList;

$rateHTML = Join("",file(__DIR__ . "/../../../public/html/rate_list.htm"));
if($showAll == "1") {
	$rateHTML = str_replace("!rateDropdownToggleChecked!","checked",$rateHTML);
} else {
	$rateHTML = str_replace("!rateDropdownToggleChecked!","",$rateHTML);
}

if($GLOBALS['userStatusId'] > 1 && db_sc_group_get_user_setting("sc_grp_res_ovr_rate_type_yn") == "1") {
	$rateHTML = str_replace("!toggleClass!","outLt",$rateHTML);
} else {
	$rateHTML = str_replace("!toggleClass!","collapse",$rateHTML);
}

$rateRowHTML = Join("",file(__DIR__ . "/../../../public/html/rate_list_rows.htm"));
if($accommCount > 0) {
	$rateWidth = 160;
	$accommHTML = array(
		'outerRateWidth'=>$rateWidth,
		'innerRateWidth'=>$rateWidth-20,
		'accommCol'=>"<col width=\"50\" />",
		'accommHead'=>"<td class=\"outLt\" align=\"center\">Property</td>",
		'accommRow'=>"<td align=\"center\">!accommTick!</td>"
	);
} else {
	$rateWidth = 210;
	$accommHTML = array(
		'outerRateWidth'=>$rateWidth,
		'innerRateWidth'=>$rateWidth-20,
		'accommCol'=>"",
		'accommHead'=>"",
		'accommRow'=>""
	);
}
$rateHTML = showpage($accommHTML,$rateHTML);
$rateRowHTML = showpage($accommHTML,$rateRowHTML);

$headers = getallheaders();
$accept = array_map("trim",explode(",",$headers['Accept'] ?? ""));
if(in_array("application/json",$accept)) {
	$rateList = array_map(function($rate) {
		return [
			'rate_type_id'     => $rate['rt_rate_type_ix'],
			'rate_type_desc'   => $rate['rt_rate_type_desc'],
			'rate_type_note'   => $rate['rt_rate_type_note'],
			'rate_type_colour' => $rate['rt_rate_type_colour'],
			'currency_id'      => $rate['rf_currency_id'],
			'currency_symbol'  => $rate['rf_currency_symbol'],
			'agent'            => $rate['agent'],
			'accomm'           => $rate['accomm']
		];
	},$rateList);
	echo json_encode($rateList);
	die();
} else {
	$rows = "";

	foreach($rateList as $rate) {
		$rate['agentTick'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
		$rate['rowClass'] = "txtg";
		$rate['hasAgent'] = "false";
		$rate['agent_id'] = $agentId;
		if($rate['agent']) {
			$rate['agentTick'] = "<img src=\"/resource/Resrequest/Application/public/img/icon_select_16.gif\" />";
			$rate['rowClass'] = "";
			$rate['hasAgent'] = "true";
		}
		$rate['accommTick'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
		$rate['tba'] = " *TBA*";
		if($accommCount == 0) {
			$rate['tba'] = "";
		}
		if($rate['accomm']) {
			$rate['accommTick'] = "<img src=\"/resource/Resrequest/Application/public/img/icon_select_16.gif\" />";
			$rate['tba'] = "";
		}

		$rate['showNote']= "collapse";
		if(trim($rate['rt_rate_type_note']) != "") {
			$rate['showNote'] = "";
			$rate['rt_rate_type_note_fmt'] = t_encodeOverlib($rate['rt_rate_type_note']);
		}
		$rate['rt_rate_type_desc_fmt'] = t_encodeOverlib($rate['rt_rate_type_desc'] . ", " . $rate['rf_currency_symbol'] . $rate['tba']);

		$rate['rt_rate_type_desc'] = t_encodeHTMLField($rate['rt_rate_type_desc']);
		$rate['rf_currency_symbol'] = t_encodeHTMLField($rate['rf_currency_symbol']);
		if($showAll == "1" || ($showAll == "0" && $rate['agent'])) {
			$rows .= showpage($rate,$rateRowHTML);
		}
	}
	$output = str_replace("!rows!",$rows,$rateHTML);

	echo $output;
}
