<?php

require_once(__DIR__ . "/db.rf_exchange_rate.php");
require_once(__DIR__ . "/db.rv_payment.php");
require_once(__DIR__ . "/db.rv_payment_item.php");
require_once(__DIR__ . "/db.fn_folio.php");
require_once(__DIR__ . "/db.sc_group.php");

require_once(__DIR__ . "/class.template.php");
require_once(__DIR__ . "/functions.financial.php");
require_once(__DIR__ . "/functions.report.php");
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.financial.advanced.php');
require_once(__DIR__ . '/functions.mail.php');
require_once(__DIR__ . '/functions.payment.gateway.php');
require_once(__DIR__ . "/functions.files.php");

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone,
			rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if(empty($fax)) {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	", 4);
	if(empty($tel)) {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",2);
	$detail = $detail[0];
	$name = "";
	if(!empty($detail['pr_name_first'])) {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(!empty($detail['pr_name_second'])) {
		$name .= $detail['pr_name_second'] . " ";
	}
	if(!empty($detail['pr_name_last'])) {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if(empty($result['email'])) {
		$result['email'] = "";
	}
	return $result;
}

function relatedEmailSort($a, $b) {
	return strcasecmp($a['name'],$b['name']);
/*    if ($a['name'] == $b['name']) {
        return 0;
    }
	return ($a['name'] < $b['name']) ? -1 : 1;*/
}


function relatedEmailAddress($reservationId=false,$folioId=false) {
	if($GLOBALS['userStatusId'] < 2) {
		return array();
	}
	$personaArray = array();
	if($folioId === false) {
		if($reservationId !== false) {
			$lookup = $GLOBALS['lDB']->get("
				SELECT
					rv_corr_persona_id,
					rv_billing_persona_id,
					rv_agent_id,
					rv_consultant_id,
					rv_invoice_persona_id
				FROM
					rv_reservation
				WHERE
					rv_reservation_ix = '$reservationId'
			",1);
		} else {
			$lookup = array();
		}
	} else {
		$lookup = $GLOBALS['lDB']->get("
			SELECT
				fn_folio.fn_folio_to_id,
				rv_billing_persona_id,
				rv_corr_persona_id,
				rv_agent_id,
				rv_consultant_id,
				rv_invoice_persona_id
			FROM
				fn_folio 
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",1);
	}
	foreach($lookup as $item) {
		if (trim($item) != "" && $item != "0") {
			array_push($personaArray, $item);

			$linked = $GLOBALS['lDB']->get("
				SELECT
					pr_link.pr_link_from
				FROM
					pr_link
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				WHERE
					pr_link.pr_link_to = '$item'
					AND pr_link.rf_link_type_id = 'RS2'
					AND pr_sys_code != '9'
				ORDER BY
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
			",3);
			if(sizeof($linked) > 0) {
				$personaArray = array_merge($personaArray,$linked);
			}
		}
	}
	array_splice($personaArray, count($personaArray), 0, $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
		WHERE
			rf_link_type_id = 'RS1'
			AND pr_persona.pr_persona_inactive_yn = '0'
			AND pr_sys_code != '9'
	",3));
	array_push($personaArray,$GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default",4));
	array_push($personaArray, $GLOBALS['userid']);
	array_splice($personaArray, sizeof($personaArray), 0, getUsers(getAgent($GLOBALS['userid'])));
	$personaArray = array_unique($personaArray);
	$emailArray = array();
	foreach($personaArray as $id) {
		if ($id != "0") {
			if (getContactEmail($id) != "") {
				array_push($emailArray, array('email' => getContactEmail($id), 'name' => escapeName(getContactName($id)), 'id' => $id));
			}
		}
	}

	$firstItem = array_shift($emailArray);
	usort($emailArray,"relatedEmailSort");
	array_unshift($emailArray,$firstItem);
	return $emailArray;
}

/**
 * Get a list of all the user IDs linked to an agent
 * @param string $agentId
 * @return string
 */
function getUsers($agentId) {
	$userArray = $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
		WHERE
			pr_link_to = '$agentId'
			AND rf_link_type_id = 'RS2'
	",3);
	if (sizeof($userArray) > 0) {
		return $userArray;
	}
	return "0";
}

function getLinkedPersona($personaId) {
	$linkId = $GLOBALS['lDB']->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($linkId) != "" && $linkId != "0") {
		return $linkId;
	} else {
		return $personaId;
	}
}

function getContactEmail($personaId) {
	global $lDB;

	$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($email) == "" || $email == "0") {
		$personaId = getLinkedPersona($personaId);
		$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($email) == "" || $email == "0") {
			return "";
		} else {
			return $email;
		}
	} else {
		return $email;
	}
}

function getContactURL($personaId) {
	global $lDB;

	$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if (trim($url) == "" || $url == "0") {
		$personaId = getLinkedPersona($personaId);
		$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($url) == "" || $url == "0") {
			return "";
		} else {
			return $url;
		}
	} else {
		return $url;
	}
}

function getContactFax($personaId) {
	global $lDB;
	
	$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
	if (trim($faxNumber) == "" || $faxNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
		if (trim($faxNumber) == "" || $faxNumber == "0") {
			return "";
		} else {
			return $faxNumber;
		}
	} else {
		return $faxNumber;
	}
}

function getContactTelephone($personaId) {
	global $lDB;

	$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND pr_default_yn = 1", 4);
	if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '".$personaId."' AND pr_default_yn = 1", 4);
		if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
			return "";
		} else {
			return $telephoneNumber;
		}
	} else {
		return $telephoneNumber;
	}
}

function getContactName($personaId) {
	global $lDB;
	
	$nameArray = $lDB->get("
		SELECT
			/*0*/ pr_name_first,
			/*1*/ pr_name_second,
			/*2*/ pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$personaId'
	",1);
	$name = $nameArray['pr_name_last'];
	if (trim($nameArray['pr_name_second']) != "" && $nameArray['pr_name_second'] != "0") {
		$name = $nameArray['pr_name_second'] . " " . $name;
	}
	if (trim($nameArray['pr_name_first']) != "" && $nameArray['pr_name_first'] != "0") {
		$name = $nameArray['pr_name_first'] . " " . $name;
	}
	$link = $lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE
			pr_link.pr_link_from = '$personaId'
			AND pr_link.rf_link_type_id IN ('RS1','RS2')
	",4);
	if($link != "0" && trim($link) != "") {
		$name .= " (".$link.")";
	}
	if($lDB->get("SELECT rf_res_office_id FROM rf_default",4) == $personaId) {
		$name .= " (Res Office)";
	}
	return $name;
}
