<?php

/**
 * init.form366.php - Record payment
 * Job: 298 (Display), 299 (Add), 300 (Save Add), 301 (Delete)
 * Function: 69 (Payments: Record)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/payment_capture.htm");
}

$startup = "";
$GLOBALS['temp']['loadAfterInitialise'] = "";
$GLOBALS['temp']['saveAfterLoad'] = "";
$GLOBALS['temp']['rv_payment_gateway_id'] = "";
$logoFileName = imageFile("top_clientlogo", false);

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$GLOBALS['temp']['exchDecimalPlaces'] = exchDecimalPlaces();

if(isset($_POST['post_action']) && !empty($_POST['post_action'])) {
	if($_POST['post_action'] == "payment_gateway_popup") {
		$folios = json_decode($_POST['folios']);
		clearPaymentGateway();
		$pg_accounts = loadPaymentGateway(PAYMENT_GATEWAY_TYPE_RECORD_PAYMENT,$folios,$_POST['rv_pmnt_ref'],$_POST['amount'],$_POST['rf_currency_id']);
		$res = createPaymentGatewayPopup($pg_accounts);
		if($res) {
			echo $res;
		}
	}
	if($_POST['post_action'] == "pay_now") {
		$_POST['rv_reservation_id'] = $_SERVER['argv'][2];
		session_set("rv_payment_gateway_data",$_POST);
		$pg_accounts = loadPaymentGateway();
		initPaymentGateway($pg_accounts);
	}
	die();
}


if(isset($_POST['paymentAction']) && $_POST['paymentAction'] == "session") {
	$_POST = $_SESSION['rv_payment_gateway_data'];
	$_SERVER['argv'][2] = $_POST['rv_reservation_id'];
	$payment = $_SESSION['rv_payment_gateway_result'];
	if($payment['status'] == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
		$GLOBALS['temp']['saveAfterLoad'] = "1";
		$GLOBALS['temp']['rv_payment_gateway_id'] = $_SESSION['rv_payment_gateway_id'];
	} else {
		switch($payment['status']) {
		case DB_RV_PAYMENT_GATEWAY_DECLINED:
			$title = "Payment declined";
			$id = (!empty($payment['id'])?", reference $payment[id],":"");
			$message = "Your payment$id has been declined with the following error:<br /><br />$payment[message]";
			break;
		case DB_RV_PAYMENT_GATEWAY_ERROR:
			$title = "Payment error";
			$id = (!empty($payment['id'])?", reference $payment[id]":"");
			$message = "There has been an error while proccessing your payment$id:<br /><br />$payment[message]";
			break;
		}
		$startup .= "<script>showMessage('".t_encodeOverlib($message)."','".t_encodeOverlib($title)."');</script>";
	}
}

$rv_reservation_id = $_SERVER['argv'][2];
if($rv_reservation_id == "" || $rv_reservation_id == "conf") {
	$GLOBALS['tagList']['returnToRes'] = blankObject();
}		
$GLOBALS['temp']['rv_reservation_id'] = $rv_reservation_id;
if($pmode=="1") {
	$missingFolios = 0;
	// Add
	if($action == "2") {
		foreach($_POST['paidAmount'] as $fn_folio_id=>$rv_pay_item_amt_rec) {
			if (!db_fn_folio_exists($fn_folio_id)){
				$missingFolios = 1;
			}
		}

		if ($missingFolios == 0){
			$rv_pmnt_date = $_POST['creditYear'] . "-" . $_POST['creditMonth'] . "-" . $_POST['creditDay'];
			$rv_payment_id = db_rv_payment_insert($_POST['pr_persona_id'],$rv_pmnt_date,$_POST['bankId'],$_POST['rf_mthd_pmnt_id'],$_POST['rv_pmnt_ref'],$_POST['rv_pmnt_note']);		
			$rv_payment_gateway_id = false;
			if(isset($_POST['rv_payment_gateway_id']) && !empty($_POST['rv_payment_gateway_id'])) {
				$rv_payment_gateway_id = $_POST['rv_payment_gateway_id'];
			}
			if(db_sc_group_get_user_setting("sc_grp_res_void_payment_yn") != "1") { // check for negative items
				$foundNegative = false;
				foreach($_POST['paidAmount'] as $fn_folio_id=>$rv_pay_item_amt_rec) {
					$rv_pay_item_exch_rate = 1;
					if(isset($_POST['exchRate'][$fn_folio_id]) && $_POST['exchRate'][$fn_folio_id] != "") {
						$rv_pay_item_exch_rate = trimExchangeRate($_POST['exchRate'][$fn_folio_id]);
					}
					if($rv_pay_item_amt_rec < 0 || $rv_pay_item_exch_rate < 0) {
						$foundNegative = true;
						break;
					}
				}
				if($foundNegative) { // this should never be seen and be caught by the JavaScript
					die("FATAL ERROR: Negative payment not allowed");
				}
			}
			foreach($_POST['paidAmount'] as $fn_folio_id=>$rv_pay_item_amt_rec) {
			
				$rv_pay_item_exch_rate = 1;
				if(isset($_POST['exchRate'][$fn_folio_id]) && $_POST['exchRate'][$fn_folio_id] != "") {
					$rv_pay_item_exch_rate = trimExchangeRate($_POST['exchRate'][$fn_folio_id]);
				}
				$rv_pay_item_amt_rec = $_POST['paidAmount'][$fn_folio_id];
				if($rv_pay_item_amt_rec == "" || $rv_pay_item_amt_rec == 0 || !is_numeric($rv_pay_item_amt_rec)) {
					continue;
				}
				$gl_exch_rate =isset($_POST['glCurrencyExchange'][$fn_folio_id]) ? $_POST['glCurrencyExchange'][$fn_folio_id] : "";
				if($gl_exch_rate != "none" && ($gl_exch_rate == "" || $gl_exch_rate == 0 || !is_numeric($gl_exch_rate)) ) {
					$gl_exch_rate = false;
				}
				$invCheck = $lDB->get("SELECT COUNT(*) FROM fn_invoice WHERE fn_folio_id = '$fn_folio_id' AND fn_invoice.fn_inv_status_ind <> 8",4);
				if($invCheck > 0 && $gl_exch_rate === false) {
					$gl_exch_rate = $lDB->get("SELECT fn_inv_exch_rate FROM fn_invoice WHERE fn_folio_id = '$fn_folio_id' AND fn_invoice.fn_inv_status_ind <> 8",4);
				}
				
				db_rv_payment_item_insert($rv_payment_id,$fn_folio_id,$rv_pay_item_amt_rec,$rv_pay_item_exch_rate,$gl_exch_rate, false, $rv_payment_gateway_id);
				$rv_reservation_ix = $lDB->get("SELECT fn_folio.rv_reservation_id FROM fn_folio WHERE fn_folio.fn_folio_ix = '$fn_folio_id'",4);
				recalcTotals($rv_reservation_ix);
				ammendReservation($rv_reservation_ix,"Payment");

				$fromCurrencyId = $lDB->get("SELECT rf_currency_id FROM rf_bank WHERE rf_bank_ix = '$_POST[bankId]'",4);
				$toCurrencyId = $lDB->get("SELECT rf_currency_id FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);
				db_rf_exchange_rate_set($fromCurrencyId,$toCurrencyId,$rv_pay_item_exch_rate);
			}

			if(array_key_exists("glExch",$_POST) && is_array($_POST['glExch'])) {
				foreach($_POST['glExch'] as $glKey=>$glExch) {
					list($glCurrencyFrom,$glCurrencyTo) = explode("_",$glKey);
					db_rf_exchange_rate_set($glCurrencyFrom,$glCurrencyTo,$glExch);
				}
			}
		} else {
			redirectTo("reservation.php?299++$rv_reservation_id+++$missingFolios");
			die();
		}
	}

	// Delete/void
	if($action == "4") {
		$rv_payment_id = db_rv_payment_void_payment($_POST['contraItems'],$_POST['rv_pmnt_note']);
		ammendReservation($rv_reservation_id,"Void Payment");
	}
	redirectTo("reservation.php?298+$rv_payment_id+$rv_reservation_id");
	die();
}

$principal_id = $_SESSION['principal_id'];
$GLOBALS['temp']['customCSS'] = "";

if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/payment_capture.css")) {
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/payment_capture.css\" type=\"text/css\">
	";
}

if($action == 1) {
	$rv_payment_id = $_SERVER['argv'][1];
	$fn_folio_id = $_SERVER['argv'][3];
	if(trim($rv_reservation_id) == "") {
		$rv_reservation_id = $lDB->get("SELECT rv_reservation_id FROM rv_payment_item WHERE rv_payment_id = '$rv_payment_id'",4);
		$fn_folio_id = $lDB->get("SELECT fn_folio_ix from fn_folio WHERE rv_reservation_id = '$rv_reservation_id'",4);
	}
	$options = $_SERVER['argv'][4];

	switch($options & 7) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "";
	}
	
	$paymentCount = $lDB->get("SELECT COUNT(*) FROM rv_payment WHERE rv_payment_ix = '$rv_payment_id'",4);
	if($paymentCount < 1) {
		redirectTo("reservation.php?299");
		die();
	}
	$paymentInfo = $lDB->get("
		SELECT
			rv_payment.rv_payment_db,
			rv_payment.rv_payment_trf_yn,
			rv_payment.rv_pmnt_date,
			rv_payment.rv_pmnt_date_created,
			rv_payment.rf_mthd_pmnt_id,
			rv_payment.rv_pmnt_ref,
			rv_payment.rv_pmnt_note,
			rv_payment.rv_pmnt_user_id,
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			rv_payment.rf_currency_id,
			rf_currency.rf_currency_symbol,
			rf_mthd_pmnt.rf_mthd_pmnt_desc,
			rf_mthd_pmnt.rf_mthd_pmnt_sys_code,
			rf_bank.rf_bank_ix,
			rf_bank.rf_bank_acc_name
		FROM
			rv_payment
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
			LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
			LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment.rf_currency_id
		WHERE
			rv_payment.rv_payment_ix = '$rv_payment_id'
	",1);
	$resList = $lDB->get("SELECT DISTINCT rv_reservation_id FROM rv_payment_item WHERE rv_payment_id = '$rv_payment_id'",3);
	$rv_pmnt_user_id = $paymentInfo['rv_pmnt_user_id'];

	$paymentInfo['pr_name'] = trim($paymentInfo['pr_name_first'] . " " . $paymentInfo['pr_name_last']);
	if($paymentInfo['pr_name'] == "") {
		$paymentInfo['pr_name'] = "Cash";
	}
	
	$capturedDatetime = date("j M Y H:i:s", strtotime($paymentInfo['rv_pmnt_date_created']) );

	if($renderMode == "html") {
		$GLOBALS['tagList']['rv_payment_ix'] = setNewValue($rv_payment_id);
		if($paymentInfo['rv_pmnt_ref'] == ""){
			$GLOBALS['temp']['noRef'] = "collapse printCollapse";
		} else {
			$GLOBALS['tagList']['userRefNum'] = setNewValue($paymentInfo['rv_pmnt_ref']);
		}
		if($paymentInfo['rf_mthd_pmnt_sys_code'] == "0" || $paymentInfo['rf_mthd_pmnt_sys_code'] == "3") {
			$GLOBALS['tagList']['saveBut'] = setNewParam("class","collapse printCollapse");
			
			if(
				db_sc_group_get_user_setting("sc_grp_res_void_payment_yn") == "1"
				&& (
					canEditDB($paymentInfo['rv_payment_db'])
					|| ($paymentInfo['rv_payment_trf_yn'] == "0" && $paymentInfo['rv_payment_db'] == $GLOBALS['dbcode']) 
				)
			) {
				$GLOBALS['tagList']['delButton'] = setNewParam("class","button");                       
				$GLOBALS['tagList']['delButton2'] = setNewParam("class","button");                       
			}
		} else {
			$GLOBALS['tagList']['saveBut'] = setNewParam("class","expand");         
			$GLOBALS['tagList']['saveButton'] = blankObject();
		}

		$GLOBALS['tagList']['payGatewayBut'] = setNewParam("class", "collapse printCollapse");
	
		$GLOBALS['temp']['disable_input'] = "disabled";
		$GLOBALS['temp']['hidePayerSearch'] = " style=\"visibility:hidden\"";
		$GLOBALS['temp']['hideConf'] = "colLt";
		$GLOBALS['temp']['hideConfPrint'] = "button";
		$GLOBALS['temp']['hideConfEmail'] = "button";
		$GLOBALS['temp']['hideConfPdf'] = "button";	
		$GLOBALS['tagList']['findRes'] = blankObject();
		$divKey = "rowreplacer";	
		$rf_currency_id = $lDB->get("SELECT rf_currency_id FROM rv_payment WHERE rv_payment_ix = '$rv_payment_id'",4);

		$HTML = join("",file(__DIR__ . "/../../../public/html/temp.htm"));
	
		$GLOBALS['tagList'][$divKey]  = "<input type=\"hidden\" name=\"mode\" value=\"!mode!\" />\n";
		$GLOBALS['tagList'][$divKey] .= "<input type=\"hidden\" name=\"rv_contra_payment_id\" value=\"" . $record . "\" />\n";
		$GLOBALS['tagList'][$divKey] .= getItemsPerPayment($divKey,$resList,$paymentInfo['rf_currency_id'],$HTML,1,$rv_payment_id);

		$GLOBALS['temp']['rv_payment_id'] = $rv_payment_id;
		$GLOBALS['temp']['fn_folio_id'] = $fn_folio_id;
	}
	if ($renderMode == "pdf") {
		if($renderType == "email") {    
			$pdfName = "Payment Capture Receipt: Ref" . $paymentInfo['rv_pmnt_ref'];
			$attachmentTable = "
				<table border=\"0\" cellspacing=\"0\" width=\"100%\">
					<tr valign=\"top\">
						<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
						<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
					</tr>
				</table>";
			$newOptions = ($options & ~3) + 3;
			$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,4))."+$newOptions";

			$emailToSetup = "";
			if(sizeof($resList) == 1) {
				$relate = relatedEmailAddress($resList[0]);
			} else {
				$relate = relatedEmailAddress();
			}
			if (getContactEmail($paymentInfo['pr_persona_ix']) != "") {
				$check = false;
				foreach($relate as $item) {
					if($item['id'] == $paymentInfo['pr_persona_ix']) {
						$check = true;
					}
				}
				if(!$check) {
					array_push($relate, array('email'=>getContactEmail($paymentInfo['pr_persona_ix']), 'name'=>getContactName($paymentInfo['pr_persona_ix']),'id'=>$paymentInfo['pr_persona_ix']));
				}
			}
			usort($relate,"relatedEmailSort");
			$index = 1;
			foreach($relate as $item) {
				$emailToSetup .= "emailToName[emailToName.length] = \"$item[name]\"; emailToAddress[emailToAddress.length] = \"$item[email]\";";
				if($item['id'] == $paymentInfo['pr_persona_ix']) {
					$GLOBALS['temp']['emailToIndex'] = $index;
				}
				$index++;
			}
			if ($_SESSION['userStatusId'] == "0") {
				$emailToSetup .= "showSearch = false;";
			}			

			$GLOBALS[$form]->FormHTML = 
				str_replace("!emailToSetup!", str_replace("'", "\\'", $emailToSetup),
				str_replace("!formAction!",$formAction,
				str_replace("!attachmentInfo!",$attachmentTable,
				str_replace("!attachmentName!",$pdfName.".pdf",
				str_replace("!hasAttachment!","expand",
				str_replace("!emailBody!","",
				str_replace("!emailSubject!",$pdfName,
				join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))));
		
			$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
			$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
		
			$principalInfo = getPersonaDetail($principalId);
			$resOfficeInfo = getPersonaDetail($resOfficeId);
			$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
		
			$GLOBALS['temp']['princName'] = $principalInfo['name'];
			$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
			$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
			$userId = $_SESSION['userid'];
			$GLOBALS['temp']['emailFrom'] = $lDB->get("
				SELECT
					pr_persona.pr_email
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$userId'
			",4);
			$GLOBALS['temp']['emailTo'] = "";
		}
		if($renderType == "view" || $renderType == "send") {
			// PDF BEGIN

			$pdf = new PDF("Payment Capture Receipt");
			$reportLabel = "Payment Receipt";

			$logoY = $pdf->y;
			$pdf->Ln(0, 1);
			$server = $_SESSION['server'];
			$principal_id = $_SESSION['principal_id'];
			$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFileName");
		
			if ($pic['w'] > $pdf->GetPageWidth(1)/4) {
				$pic['w'] = $pdf->GetPageWidth(1)/4;
			}

			require_once(__DIR__ . '/functions.imageset.php');
			$logoWidth = imagesetLogoSizeOverride("paymentCaptureReceiptPdfLogoWidthOverride", $pic['w']);
			$finalH = $pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFileName", ($pdf->GetPageWidth(1)/3)-($pic['w']/1), $logoY, $logoWidth);
			if (($logoY + $finalH) > $pdf->y) {
				$pdf->y = $logoY + $finalH;
			}
		
			$pdf->Ln(1);
			$pdf->SetFont('Arial', '', 9);
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "97%", 'data'=>"Recorded Payment")
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "97%", 'data'=>"Thank-you. Your transaction was successful")
			));

			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Reference Number:", 'style'=>"B"),
				array('width'=> "80%", 'data'=>$paymentInfo['rv_pmnt_ref'], 'style'=>"B")
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Receipt Number:", 'style'=>"B"),
				array('width'=> "80%", 'data'=>$rv_payment_id, 'style'=>"B")
			));
		
			$pdf->Ln(10);


			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Payer/payee:"),
				array('width'=> "80%", 'data'=>$paymentInfo['pr_name'])
			));	
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Date:"),
				array('width'=> "80%", 'data'=>chng_date($paymentInfo['rv_pmnt_date'],"-"))
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Captured:"),
				array('width'=> "80%", 'data'=>$capturedDatetime)
			));
			list($cashierFirstname,$cashierLastname) = $lDB->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$rv_pmnt_user_id'",1);
			$cashierName = trim($cashierFirstname . " " . $cashierLastname);
			if(empty($cashierName)) {
				$cashierName = "Unknown";
			}
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Cashier:"),
				array('width'=> "80%", 'data'=>$cashierName)
			));	
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Currency:"),
				array('width'=> "80%", 'data'=>$paymentInfo['rf_currency_symbol'])
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Method of payment:"),
				array('width'=> "80%", 'data'=>$paymentInfo['rf_mthd_pmnt_desc'])
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Bank / Cash point:"),
				array('width'=> "80%", 'data'=>$paymentInfo['rf_bank_acc_name'])
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Ref/receipt number:"),
				array('width'=> "80%", 'data'=>$paymentInfo['rv_pmnt_ref'])
			));
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=> "20%", 'data'=>"Notes:"),
				array('width'=> "80%", 'data'=>$paymentInfo['rv_pmnt_note'])
			));
			$pdf->Ln(3);
			$pdf->SetFont('Arial', '', 8);
			$headRow = array();
			array_push($headRow,
				array('width'=> "3%", 'data'=>""),
				array('width'=>"10%", 'height'=>"5", 'data'=>"Res Number", 'border'=>"LT", 'style'=>"B", 'fill'=>1),
				array('width'=>"17%", 'height'=>"5", 'data'=>"Res Name", 'border'=>"TL", 'style'=>"B", 'fill'=>1),
				array('width'=>"20%", 'height'=>"5", 'data'=>"Agent", 'border'=>"TL", 'style'=>"B", 'fill'=>1),
				array('width'=>"50%", 'height'=>"5", 'data'=>"Amount", 'border'=>"TLR", 'align'=>"C", 'style'=>"B", 'fill'=>1)
			);
			$pdf->Row($headRow);
		
			$headRow2 = array();
			array_push($headRow2,
				array('width'=> "3%", 'data'=>""),
				array('width'=>"10%", 'height'=>"5", 'data'=>"", 'border'=>"LBR", 'style'=>"B", 'fill'=>1),
				array('width'=>"17%", 'height'=>"5", 'data'=>"", 'border'=>"BRL", 'style'=>"B", 'fill'=>1),
				array('width'=>"20%", 'height'=>"5", 'data'=>"", 'border'=>"BRL", 'style'=>"B", 'fill'=>1),
				array('width'=>"12%", 'height'=>"5", 'data'=>"Outstanding", 'border'=>"TBRL", 'style'=>"B", 'fill'=>1, 'align'=>"R"),
				array('width'=>"12%", 'height'=>"5", 'data'=>"Curr Pd", 'border'=>"TBRL", 'style'=>"B", 'fill'=>1, 'align'=>"R"),
				array('width'=>"12%", 'height'=>"5", 'data'=>"Conversion", 'border'=>"TBRL", 'style'=>"B", 'fill'=>1, 'align'=>"R"),
				array('width'=>"14%", 'height'=>"5", 'data'=>"Amount", 'border'=>"TBRL", 'style'=>"B", 'fill'=>1, 'align'=>"R")
			);
			$pdf->Row($headRow2);

			//Start of loop from advanced.php
			$resList = $lDB->get("SELECT DISTINCT rv_reservation_id FROM rv_payment_item WHERE rv_payment_id = '$rv_payment_id'",3);
		
			$mode = "1";
			$hmax = sizeof($resList);

			$totalPaid = 0;
		
			for ($h = 0; $h < $hmax; $h++) {
				$tagList = array();
				$rv_reservation_id = $resList[$h];
				$sql="SELECT DISTINCT ";
				if ($mode != "0") {
					$sql .= "
						rv_payment_item.rv_payment_item_ix,
						rv_payment_item.rv_payment_item_amt,
						rv_payment_item.rv_pay_item_amt_rec,
						rv_payment_item.rv_pay_item_exch_rate,
						rv_payment_item.rv_payment_contra_id,
						rv_payment_item.rv_payment_id,
					";
				}

				$sql .= "
					rv_reservation.rv_reservation_ix as resId,
					rv_reservation.rv_res_name as resName,
					pr_persona.pr_name_last as resAgent,
					fn_folio.fn_folio_ix as folioId,
					fn_folio.fn_folio_amount as folPayable,
					fn_folio.fn_folio_folio_num as folioNum,
					fn_folio.pr_business_id,
					fn_folio.fn_folio_to_id,
					fn_invoice.fn_invoice_prefix,
					fn_invoice.fn_invoice_ix as fnInvKey,
					rf_currency.rf_currency_symbol as folioCurr,
					rf_currency.rf_currency_ix as folioCurrId
				FROM
					rv_reservation
				";

				if ($mode != "0") {
					$sql .= "
						INNER JOIN rv_payment_item ON
							rv_payment_item.rv_payment_id = '".$record."' 
							AND rv_payment_item.rv_reservation_id = '".$rv_reservation_id."' 
					";
				}

				$sql .= "LEFT JOIN fn_folio ON ";
			
				if ($mode != "0") {
					$sql .= "fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id";
				} else {
					$sql .= "fn_folio.rv_reservation_id = rv_reservation.rv_reservation_ix ";
				}
			
				$sql .= "
					LEFT JOIN fn_invoice ON
						fn_invoice.fn_invoice_ix = fn_folio.fn_invoice_id
				";
			
				if ($mode == "0") {
					$sql .= "
						LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
					";
				} else {
					$sql .= "
						LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id 
					";
				}
			
				$sql .= "
					LEFT JOIN pr_persona ON
						pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
					WHERE
						rv_reservation.rv_reservation_ix = '".$rv_reservation_id."'
					ORDER BY
						fn_folio.fn_folio_folio_num
				";

				$result = $lDB->get($sql,2);

				$payData = array();
				$imax = sizeof($result);
			
				for ($i = 0; $i < $imax; $i++) {
					$payData[$i] = array();
					$row = $result[$i];
					$totalPaid += $row['rv_pay_item_amt_rec'];
					$rv_reservation_id = "";
				
					if ($i == 0) {
						$rv_reservation_id = $row['resId'];
					}

					$folioName = "Folio  ";
				
					if ($row['fnInvKey'] != "") {
						$folioName = "      ".$row['fn_invoice_prefix']." ";
						$folioName = "      ".$row['fnInvKey']." ";
					} else {
						$folioName .= $row['folioNum'];
					}

					$folioTitle = $folioName;

					if (trim($folioTitle) == "") {
						$folioTitle = "None";
					}
				
					$payData[$i]['folioName'] = setNewValue($folioTitle);
					$rowToLast = getPersona("pr_name_last",$row['fn_folio_to_id'],4);
					$rowToFirst = getPersona("pr_name_first",$row['fn_folio_to_id'],4);
				
					if($rowToFirst == "" || $rowToFirst == "0") {
						$row['TO'] = $rowToLast;
					} else {
						$row['TO'] = $rowToLast.", ".$rowToFirst;
					}
				
					if($rowToLast == "" || $rowToLast == "0"){
						$row['TO'] = $rowToFirst;
					}
				
					if ($row['fn_folio_to_id'] == "" || $row['fn_folio_to_id'] == "0") {
						$row['TO'] = "Cash";
					}
				
					$row['BUS'] = getPersona("pr_name_last",$row['pr_business_id'],4);
				
					if ($row['BUS'] == "0") {
						$row['BUS'] = "N/A";
					}

					// Outstanding. Why, thank you...
					$paid = $lDB->get("
						SELECT 
							SUM(rv_payment_item_amt) 
						FROM 
							rv_payment_item 
						WHERE 
							fn_folio_id = '".$row['folioId']."'
					",4);
				
					$amount = $row['folPayable'] - $paid;
					$amount = (string) $amount;
				
					fixAmtDisplay($amount);

					$payData[$i]['folio_curr1'] = $row['folioCurr'];

					if ($mode != "0") {
						fixAmtDisplay($row['rv_pay_item_amt_rec']);
						fixAmtDisplay($row['rv_pay_item_exch_rate'], exchDecimalPlaces());
						fixAmtDisplay($row['rv_payment_item_amt']);
					}

					$dataRow = array();
				
					if ($rv_reservation_id != "") {
						array_push($dataRow,
							array('width'=> "3%", 'data'=>""),
							array('width'=>"10%", 'height'=>"5", 'data'=>$rv_reservation_id, 'border'=>"LTBR"),
							array('width'=>"17%", 'height'=>"5", 'data'=>$row['resName'], 'border'=>"TBRL"),
							array('width'=>"20%", 'height'=>"5", 'data'=>$row['resAgent'], 'border'=>"TBRL"),
							array('width'=>"12%", 'height'=>"5", 'data'=>$amount." ".$row['folioCurr'], 'border'=>"TBRL", 'align'=>"R"),
							array('width'=>"12%", 'height'=>"5", 'data'=>$row['rv_pay_item_amt_rec']." ".$paymentInfo['rf_currency_symbol'], 'border'=>"TBRL", 'align'=>"R"),
							array('width'=>"12%", 'height'=>"5", 'data'=>$row['rv_pay_item_exch_rate'], 'border'=>"TBRL", 'align'=>"R"),
							array('width'=>"14%", 'height'=>"5", 'data'=>$row['rv_payment_item_amt']." ".$row['folioCurr'], 'border'=>"TBRL", 'align'=>"R"));
					} else {
						array_push($dataRow,
							array('width'=> "3%", 'data'=>""),
							array('width'=>"10%", 'height'=>"5", 'data'=>"", 'border'=>"LTBR"),
							array('width'=>"17%", 'height'=>"5", 'data'=>"", 'border'=>"TBRL"),
							array('width'=>"20%", 'height'=>"5", 'data'=>"", 'border'=>"TBRL"),
							array('width'=>"12%", 'height'=>"5", 'data'=>$amount." ".$row['folioCurr'], 'border'=>"TBRL", 'align'=>"R"),
							array('width'=>"12%", 'height'=>"5", 'data'=>$row['rv_pay_item_amt_rec']." ".$paymentInfo['rf_currency_symbol'], 'border'=>"TBRL", 'align'=>"R"),
							array('width'=>"12%", 'height'=>"5", 'data'=>$row['rv_pay_item_exch_rate'], 'border'=>"TBRL", 'align'=>"R"),
							array('width'=>"14%", 'height'=>"5", 'data'=>$row['rv_payment_item_amt']." ".$row['folioCurr'], 'border'=>"TBRL", 'align'=>"R"));
					}
				
					$pdf->Row($dataRow);

					$folioName = "Folio  ";
					$folioNumRow = array();
				
					if ($row['fnInvKey'] != "") {
						array_push($folioNumRow,
							array('width'=> "3%", 'data'=>""),
							array('width'=>"15%", 'height'=>"4", 'data'=>"Invoice Number:", 'border'=>"L"),
							array('width'=>"82%", 'height'=>"4", 'data'=>$row['fnInvKey']." ", 'border'=>"R")
						);
					} else {
						array_push($folioNumRow,
							array('width'=> "3%", 'data'=>""),
							array('width'=>"15%", 'height'=>"4", 'data'=>"Folio Number:", 'border'=>"L"),
							array('width'=>"82%", 'height'=>"4", 'data'=>$row['folioNum'], 'border'=>"R")
						);
					}
				
					$pdf->Row($folioNumRow);

					$folioToRow = array();
					array_push($folioToRow,
						array('width'=> "3%", 'data'=>""),
						array('width'=>"15%", 'height'=>"4", 'data'=>"To:", 'border'=>"L"),
						array('width'=>"82%", 'height'=>"4", 'data'=>t_encodeOverlib($row['TO']), 'border'=>"R")
					);
				
					$pdf->Row($folioToRow);

					$folioBusRow = array();
					array_push($folioBusRow,
						array('width'=> "3%", 'data'=>""),
						array('width'=>"15%", 'height'=>"4", 'data'=>"Business Unit:", 'border'=>"LB"),
						array('width'=>"82%", 'height'=>"4", 'data'=>t_encodeOverlib($row['BUS']), 'border'=>"RB")
					);
				
					$pdf->Row($folioBusRow);
				}
			}

			fixAmtDisplay($totalPaid,2);
			$pdf->Row(array(
				array('width'=> "3%", 'data'=>""),
				array('width'=>"59%", 'height'=>"5", 'data'=>"Total:", 'border'=>"LRTB", 'align'=>"R"),
				array('width'=>"12%", 'height'=>"5", 'data'=>$totalPaid." ".$paymentInfo['rf_currency_symbol'], 'border'=>"LRTB", 'align'=>"R"),
				array('width'=>"26%", 'height'=>"5", 'border'=>"LRTB", 'align'=>"R")
			));
			


			// PDF END

			if($renderType == "view") {
				$pdf->OutPut();
				die();
			}
		
			if($renderType == "send") {
				$to = $_POST['mail_to'];
				$from = $_POST['mail_from'];
				$subject = $_POST['mail_subj'];
				$message = $_POST['mail_body'];
				$attachmentName = $_POST['attachmentName'];
				$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

				// Close the pdf
				if ($pdf->state<3) {
					$pdf->Close();
				}

				// Mail the pdf
				if($attachmentName != "!attachmentName!") {
					$pdfName = $attachmentName;
				} else {
					$pdfName = "Update report from $fromDate to $toDate.pdf";
				}
			
				// (from, to, subject, headers, message, action, emailID, resID)
				$error = email($from, $to, $subject, $headers, $message, 0, 0, $rv_reservation_id, $GLOBALS['princName'],$pdf->buffer,$pdfName);
			
				if(!$error) {
					echo "
								<script type=\"text/javascript\">
									if (opener && !opener.closed) {
										opener.openMessage('Your email has been sent.');
									}
									window.close();
								</script>
							</body>
						</html>";
					die();
				 } else {
					echo "
								<script type=\"text/javascript\">
									if(opener && !opener.closed) {
										opener.openMessage('Error sending email!');
									}
									window.close();
								</script>
							</body>
						</html>";
					die();
				}
			}
		}
	}
	$bankList = $lDB->get("
		SELECT
			rf_bank.rf_bank_ix,
			rf_bank.rf_bank_abbrev,
			rf_bank.rf_bank_acc_name,
			rf_currency.rf_currency_ix,
			rf_currency.rf_currency_symbol
		FROM
			rf_bank
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
	",2);		
} else {
	$missingFolios = $_SERVER['argv'][5];
	if ($missingFolios == 1){
		$GLOBALS['temp']['missingFolios'] = "1";
	} else {
		$GLOBALS['temp']['missingFolios'] = "0";
	}
	$rv_payment_id = "";
	if(
		isset($_POST['pr_persona_id']) && (
			db_pr_persona_exists($_POST['pr_persona_id'])
			|| $_POST['pr_persona_id'] == "0"
		)
	) {
		$paymentInfo = array(
			'pr_persona_ix' => $_POST['pr_persona_id'],
			'pr_name' => $_POST['payer'],
			'rv_pmnt_date' => $_POST['creditYear'] . "-" . $_POST['creditMonth'] . "-" . $_POST['creditDay'],
			'rf_bank_ix' => $_POST['bankId'],
			'rf_mthd_pmnt_id' => $_POST['rf_mthd_pmnt_id'],
			'rv_pmnt_ref' => $_POST['rv_pmnt_ref'],
			'rv_pmnt_note' => $_POST['rv_pmnt_note']
		);
	} else {
		$paymentInfo = $lDB->get("
			SELECT 
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				fn_folio
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
			WHERE 
				rv_reservation_id = '$rv_reservation_id' 
			ORDER BY 
				fn_folio_folio_num 
		",1);
		$pr_name = trim( (isset($paymentInfo['pr_name_first']) ? $paymentInfo['pr_name_first'] : "") . " " . (isset($paymentInfo['pr_name_last']) ? $paymentInfo['pr_name_last'] : "") );
		if($pr_name == "") {
			$pr_name = "Cash";
			$paymentInfo['pr_persona_ix'] = "0";
		}
		$paymentInfo['pr_name'] = $pr_name;
	}
	$GLOBALS['temp']['disable_input'] = "";
	$GLOBALS['temp']['hidePayerSearch'] = "";
	$GLOBALS['temp']['hideConf'] = "collapse printCollapse";
	$GLOBALS['temp']['hideConfPrint'] = "collapse printCollapse";
	$GLOBALS['temp']['hideConfEmail'] = "collapse printCollapse";
	$GLOBALS['temp']['hideConfPdf'] = "collapse printCollapse";
	$GLOBALS['temp']['rv_payment_id'] = "";
	$GLOBALS['temp']['fn_folio_id'] = "";

	if(isset($_POST['paidAmount']) && is_array($_POST['paidAmount'])) {
		$reservations = array();
		foreach($_POST['paidAmount'] as $fn_folio_id=>$paidAmount) {
			list($rv_reservation_ix,$rv_res_name) = $lDB->get("
				SELECT
					rv_reservation.rv_reservation_ix,
					rv_reservation.rv_res_name
				FROM
					fn_folio
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
				WHERE
					fn_folio_ix = '$fn_folio_id'
			",1);
			if(!array_key_exists($rv_reservation_ix,$reservations)) {
				$reservations[$rv_reservation_ix] = array(
					'rv_reservation_id' => $rv_reservation_ix,
					'rv_res_name' => t_encodeOverlib($rv_res_name),
					'folios' => array()
				);
			}
			if(isset($_POST['exchRate']) && isset($_POST['exchRate'][$fn_folio_id])) {
				$exchRate = trimExchangeRate($_POST['exchRate'][$fn_folio_id]);
			} else {
				$exchRate = 1;
			}
			$reservations[$rv_reservation_ix]['folios'][$fn_folio_id] = array(
				'paidAmount' => $paidAmount,
				'exchRate' => $exchRate,
				'recptAmount' => $_POST['recptAmount'][$fn_folio_id],
				'glCurrencyExchange' => isset($_POST['glCurrencyExchange'][$fn_folio_id])?$_POST['glCurrencyExchange'][$fn_folio_id]:""
			);
		}
		$GLOBALS['temp']['loadAfterInitialise'] = "loadMultiRes(" . json_encode($reservations) . ");";
	} else {
		$checkRes = $lDB->get("SELECT COUNT(*) FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
		if($checkRes > 0) {
			$rv_res_name = $lDB->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
			$startup .= "<script>loadRes('$rv_reservation_id','','".t_encodeOverlib($rv_res_name)."');</script>";
		} else {
			$startup .= "<script>updatePayGatewayButton();</script>";
		}
	}

	$bankList = $lDB->get("
		SELECT
			rf_bank.rf_bank_ix,
			rf_bank.rf_bank_acc_name,
		    rf_bank.rf_bank_abbrev,
			rf_currency.rf_currency_ix,
			rf_currency.rf_currency_symbol,
			rf_bank_env.rf_bank_env_default_yn
		FROM
			rf_database
			INNER JOIN rf_bank_env ON rf_bank_env.rf_database_id = rf_database.rf_database_id
			INNER JOIN rf_bank ON rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			rf_database.rf_db_code = '$GLOBALS[dbcode]'
			AND rf_bank.rf_bank_inactive_yn = '0'
	",2);	

	$rv_pmnt_user_id = $GLOBALS['userid'];
}

list($cashierFirstname,$cashierLastname) = $lDB->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$rv_pmnt_user_id'",1);
$cashierName = trim($cashierFirstname . " " . $cashierLastname);
if(empty($cashierName)) {
	$cashierName = "Unknown";
}
$GLOBALS['temp']['cashier'] = $cashierName;
$GLOBALS['temp']['pr_name'] = $paymentInfo['pr_name'];
$GLOBALS['temp']['pr_persona_id'] = $paymentInfo['pr_persona_ix'];

$credit = useDate("credit", (isset($paymentInfo['rv_pmnt_date']) ? $paymentInfo['rv_pmnt_date'] : "") );

	
$bankOptions = "";
$bankCurrencyList = "";
$currencies = array();
	
foreach($bankList as $item) {
	$currencies[] = $item['rf_currency_ix'];
	$selected = "";
		
	if($action != "1" && !isset($paymentInfo['rf_bank_ix']) && $item['rf_bank_env_default_yn'] == "1") {
		$selected = "selected";
	}

	if($action != "1" && isset($paymentInfo['rf_bank_ix']) && $paymentInfo['rf_bank_ix'] == $item['rf_bank_ix']) {
		$selected = "selected";
	}

	if($action == "1" && $paymentInfo['rf_bank_ix'] == $item['rf_bank_ix']) {
		$selected = "selected";
	}

	$bankAccName = (isset($item['rf_bank_abbrev'] ) && $item['rf_bank_abbrev'] != "") ?  $item['rf_bank_acc_name'].' - '.$item['rf_bank_abbrev'] : $item['rf_bank_acc_name'];
		
	$bankOptions .= '<option ' . $selected . ' value="' . $item['rf_bank_ix'] . '">' . $bankAccName . '</option>';
	$bankCurrencyList .= "bankCurrencyIdArray['$item[rf_bank_ix]'] = \"$item[rf_currency_ix]\";\n";
	$bankCurrencyList .= "bankCurrencyNameArray['$item[rf_bank_ix]'] = \"$item[rf_currency_symbol]\";\n";
}	
$GLOBALS['temp']['bankCount'] = sizeof($bankList);
if(sizeof($bankList) > 0) {
	$GLOBALS['temp']['bankOptions'] = $bankOptions;
} else {
	$GLOBALS['temp']['bankOptions'] = '<option selected value="0">No banks or cash points defined for this environment</option>';
	$bankCurrencyList = "bankCurrencyIdArray[0] = \"0\";\n";
	$bankCurrencyList = "bankCurrencyNameArray[0] = \"Unknown\";\n";
}
$GLOBALS['temp']['bankCurrencyList'] = $bankCurrencyList;

$currencies = array_unique($currencies);
$exchanges = db_rf_exchange_rate_get_all_rates();
if(isset($_POST['glExch']) && is_array($_POST['glExch'])) {
	foreach($_POST['glExch'] as $exchKey=>$rf_exch_rate) {
		list($rf_exch_curr_from_id,$rf_exch_curr_to_id) = explode("_",$exchKey);
		$found = false;
		foreach($exchanges as $exchangeKey=>$exchange) {
			if(
				$rf_exch_curr_from_id == $exchange['rf_exch_curr_from_id']
				&& $rf_exch_curr_to_id == $exchange['rf_exch_curr_to_id']
			) {
				$found = true;
				$exchanges[$exchangeKey]['rf_exch_rate'] = $rf_exch_rate;
			}
		}
		if(!$found) {
			$exchanges[] = array(
				'rf_exch_curr_from_id'=>$rf_exch_curr_from_id,
				'rf_exch_curr_to_id'=>$rf_exch_curr_to_id,
				'rf_exch_rate'=>$rf_exch_rate
			);
		}
	}
}
$exchangeList = "";
foreach($exchanges as $exchange) {
	$exchangeList .= "exchangeArray['$exchange[rf_exch_curr_from_id]_to_$exchange[rf_exch_curr_to_id]'] = \"$exchange[rf_exch_rate]\";\n";
}
$GLOBALS['temp']['exchangeList'] = $exchangeList;

$GLOBALS['temp']['envCode'] 	= $dbcode;
$sysAdminId = $lDB->get("
	SELECT
		pr_persona_id
	FROM
		rf_sys_admin
	WHERE
		rf_sys_admin_primary = 1
	LIMIT 1
",4);
	
$sysAdminDetails = $lDB->get("
	SELECT
		pr_email,
		pr_name_first,
		pr_name_last
	FROM
		pr_persona
	WHERE
		pr_persona_ix = '$sysAdminId'
",1);
	
$GLOBALS['temp']['sysAdminName'] = trim($sysAdminDetails['pr_name_first'] . " " . $sysAdminDetails['pr_name_last']);
$GLOBALS['temp']['sysAdminEmail'] = $sysAdminDetails['pr_email'];

$methodWhere = "";
if($action == 2) {
	$methodWhere = "
	WHERE 
		rf_mthd_pmnt_inactive_yn = '0'
		AND rf_mthd_pmnt_sys_code = 0 
	";
}
$methodList = $lDB->get("
	SELECT 
		rf_mthd_pmnt_ix,
		rf_mthd_pmnt_desc 
	FROM 
		rf_mthd_pmnt 
	$methodWhere
	ORDER BY 
		rf_mthd_pmnt_desc
",2);
$methodOptions = "";
foreach($methodList as $item) {
	$selected = "";
	if(isset($paymentInfo['rf_mthd_pmnt_id']) && $item['rf_mthd_pmnt_ix'] == $paymentInfo['rf_mthd_pmnt_id']) {
		$selected = "selected";
	}
	$methodOptions .= "<option $selected value=\"$item[rf_mthd_pmnt_ix]\">$item[rf_mthd_pmnt_desc]</option>";
}
$GLOBALS['temp']['method_options'] = $methodOptions;

$GLOBALS['temp']['rv_pmnt_ref'] = isset($paymentInfo['rv_pmnt_ref']) ? $paymentInfo['rv_pmnt_ref'] : "";
$GLOBALS['temp']['rv_pmnt_note'] = isset($paymentInfo['rv_pmnt_note']) ? $paymentInfo['rv_pmnt_note'] : "";

$disabledList = array("rv_payment_payer");
$GLOBALS[$form]->Disable($disabledList);

$hideList = array("pr_persona_id");
$GLOBALS[$form]->Hide($hideList);

$view = 298;
$newr = 299;
$snewr = 300;
$edit = -1;
$sedit = -1;
$dele = 301;
	
// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit,2) == "15" || (isset($rv_payment_db) && $rv_payment_db == $GLOBALS['dbcode'] && $rv_payment_trf_yn == "0" && $GLOBALS['jobLevelArray'][$edit] == "15")) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || ($action == "3" && checkJob($edit,2) == "15")) {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
$GLOBALS['temp']['pgJobs']  = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
// End Access Control Toolbar Setup

$GLOBALS['temp']['new_record'] = "reservation.php?".$newr;

switch ($action) {
case (0) : // List Records
	break;		
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS[$form]->Arguments = (string) $dele."+".$record."+".$rv_reservation_id;
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+".$rv_reservation_id;
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = (string) $snewr."++".$rv_reservation_id;
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['mode'] = "new";
	break;	
case (4) : // Delete Record
	$GLOBALS['initrecord'] = $record;
	$GLOBALS['delrecord'] = $record;
	break;
}

$GLOBALS['temp']['allowVoid'] = db_sc_group_get_user_setting("sc_grp_res_void_payment_yn");

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
$GLOBALS['temp']['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/$logoFileName";
$GLOBALS['temp']['principalName'] = getContactFullName($principalId);

$GLOBALS['temp']['startup'] = $startup;

