<?php

/**
 * init.form367.php - General Ledger account detail popup - Year Tab
 * Job: 302
 * Function: 100
 */

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_year.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = " ORDER BY fn_cost_centre.fn_cost_centre_desc ";
$error = array();
$GLOBALS['temp']['showError'] = "display: none;";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

$exists = false;
if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
	case ("add") :
		$addedFields = explode("_",$_SERVER['argv'][3]);
		// Knock off the extra empty array
		array_pop($addedFields);
		foreach ( $addedFields as $data ) {
			$thisData = explode(":",$data);
			foreach($thisData as $key=>$item) {
				$thisData[$key] = rawurldecode($item);
			}
			$dupe = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					fn_year
				WHERE
					fn_year_desc = '$thisData[1]'
					AND pr_business_id = '$iUnitID'
			",4);

			if ( $dupe > 0 ) {
				array_push($error,array($thisData[1],$thisData[2]));
			} else {
				db_fn_year_insert($iUnitID,$thisData[1],$thisData[2]);
			}				
		}
		break;		
	case "edit":		
		// Process the data to be saved
		$editedFields = explode("_",$_SERVER['argv'][3]);
		// Knock off the extra empty array
		array_pop($editedFields);
		foreach ( $editedFields as $data ) {
			$thisData = explode(":",$data);
			foreach($thisData as $key=>$item) {
				$thisData[$key] = rawurldecode($item);
			}
			$dupe = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					fn_year
				WHERE
					fn_year_desc = '$thisData[1]'
					AND fn_year_ix != '$thisData[0]'
					AND pr_business_id = '$iUnitID'
			",4);

			if ( $dupe > 0 ) {
				array_push($error,array($thisData[1],$thisData[2]));
			} else {
				db_fn_year_update($thisData[0],$thisData[1],$thisData[2]);
			}
		}
		break;

	case ("delete") :
		$years = explode(":",$_SERVER['argv'][3]);
		foreach ( $years as $fn_year_id ) {
			$where[$fn_year_id] = array();
			
			$fn_batch_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_batch WHERE fn_year_id = '$fn_year_id'",4);
			if($fn_batch_count > 0) {
				$exists = true;
				array_push($where[$fn_year_id],"Batch");
			}				

			if ( !$exists ) {
				db_fn_year_delete_by_id($fn_year_id);
			}				
		}
		break;
	case ("filter") :
		$glFilterData = explode(":",$_SERVER['argv'][3]);
		$filterField = $glFilterData[0];
		$filterText = rawurldecode($glFilterData[1]);
		if(empty($filterText)) {
			$filterText = "*";
		}

		if ( $filterText == "*" )	{
			$filterSQL = "";
		} else {
			// Looking for a partial match, so field LIKE filterText
			$filterSQL .= " AND fn_year." . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
		}
		$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
		$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
	break;
	case ("sort") :
		$sortData = explode(":",$_SERVER['argv'][3]);
		break;
	case "open":
		$fn_year_id = $_SERVER['argv'][3];
		db_fn_year_set_status($fn_year_id,DB_FN_YEAR_STATUS_OPEN);
		break;
	case "close":
		$fn_year_id = $_SERVER['argv'][3];
		db_fn_year_set_status($fn_year_id,DB_FN_YEAR_STATUS_CLOSED);
		break;
	}
}

// Display the current data ---------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$years = $GLOBALS['lDB']->get("
	SELECT
		fn_year.fn_year_ix,
		fn_year.fn_year_desc,
		fn_year.fn_year_end_date,
		fn_year.fn_year_status_ind
	FROM
		fn_year
	WHERE
		fn_year.pr_business_id = '$iUnitID'
		$filterSQL
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "fn_year_desc";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $years as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$yearHTML = "";
foreach ( $keys as $k ) {
	$fn_year_ix = $years[$k]['fn_year_ix'];
	$fn_year_desc = t_encodeHTMLField($years[$k]['fn_year_desc']);
	$fn_year_status_ind = $years[$k]['fn_year_status_ind'];

	$fn_year_end_date = $years[$k]['fn_year_end_date'];
	$fn_year_end_date_fmt = chng_date($fn_year_end_date,"-");

	$batchToDate = $years[$k]['fn_year_end_date'];
	$dateArray = explode("-",$batchToDate);
	$batchFromDate = date("Y-m-d",mktime(0,0,0,$dateArray[1],$dateArray[2],$dateArray[0]-1));

	$tranCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			fn_tran
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		WHERE
			fn_batch.fn_batch_ix IS NULL
			AND fn_tran.fn_tran_date_ledger >= '$batchFromDate'
			AND fn_tran.fn_tran_date_ledger <= '$batchToDate'
			AND fn_tran.pr_business_id = '$iUnitID'
	",4);
	if($tranCount > 0) {
		$hasUnallocated = true;
	} else {
		$hasUnallocated = false;
	}

	$batchCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			fn_batch
		WHERE
			fn_year_id = '$fn_year_ix'
			AND fn_batch.ad_delete_date = '0000-00-00 00:00:00'
	",4);
	$checkbox = "&nbsp;";
	$onClick = "";
	$mouseOver = "";
	if($batchCount <= 0 && $fn_year_status_ind != DB_FN_YEAR_STATUS_CLOSED && $allowEdit) {
		$checkbox = "<input type=\"checkbox\" id=\"check$fn_year_ix\" />";
		$onClick = "onclick=\"glEdit('$fn_year_ix',event);\"";
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('$fn_year_ix',1);\" onmouseout=\"hover('$fn_year_ix',0);\"";
	}
	if($allowEdit) {
		if($fn_year_status_ind != DB_FN_YEAR_STATUS_CLOSED) {
			$openBatchCount = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					fn_batch
				WHERE
					fn_year_id = '$fn_year_ix'
					AND fn_batch_closed_yn = '0'
					AND fn_batch.ad_delete_date = '0000-00-00 00:00:00'
			",4);
			if($openBatchCount > 0) {
				$close_button = "<input type=\"button\" class=\"button bCheckIn\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('You must close all batches in order to close this year.',LEFT,WIDTH,200);\" />";
			} else {
				if($hasUnallocated) {
					$close_button = "<input type=\"button\" class=\"button bCheckIn\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('This year has unallocated transactions. You must allocate all transactions in order to close this year.',LEFT,WIDTH,200);\" />";
				} else {
					$close_button = "<input type=\"button\" class=\"button bCheckIn\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('Click to close this year.',LEFT,WIDTH,130);\" onclick=\"closeYear('$fn_year_ix');\" />";
				}
			}
		} else {
			if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] < 15) {
				$close_button = "<input type=\"button\" class=\"button bCheckOut\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('You must have management access in order to re-open this year.',LEFT,WIDTH,200);\" />";
			} else {
				$close_button = "<input type=\"button\" class=\"button bCheckOut\" style=\"width:20px; height:20px;\" onmouseout=\"nd();\" onmouseover=\"overlib('Click to open this year.',LEFT,WIDTH,130);\" onclick=\"openYear('$fn_year_ix');\" />";
			}
		}
	} else {
		$close_button = "&nbsp;";
	}

	$yearHTML .= "
		<tr id=\"$fn_year_ix\" $mouseOver>
			<td class=\"bl br\" style=\"width:26px;\">$checkbox</td>
			<td id=\"desc$fn_year_ix\" $onClick class=\"br\" style=\"width:238px\">$fn_year_desc</td>
			<td id=\"date$fn_year_ix\" $onClick class=\"br\" style=\"width:200px\">$fn_year_end_date_fmt<input type=hidden id=\"dateRaw$fn_year_ix\" value=\"$fn_year_end_date\"></td>
			<td class=\"br\" style=\"width:26px;\">$close_button</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
	";
	
}

// Error notification on duplicates -------------------------------------------
if ( count($error) > 0 ) {
	$GLOBALS['temp']['showError'] = "";	
	$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the data you entered duplicates data in the database already. Below is a list of your input that contains either a duplicate description:</span><br /><br />';	
	$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';	
	$GLOBALS['temp']['errorContents'] .= '
		<tr>
			<thead>
				<th class="colDk bb br">Year Description</th>
			</thead>
		</tr>
	';

	foreach ( $error as $e ) {
		$GLOBALS['temp']['errorContents'] .= '
			<tr>
				<td class="colWh bb br">' . $e[0] . '</td>
			</tr>
		';
	}

	$GLOBALS['temp']['errorContents'] .= '
		<tr class="colLt">
			<td colspan="3" align="right">
				<button type="button" class="button" onclick="closeError();">
					<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
					<span>OK</span>
				</button>
			</td>
		</tr>
	';

	$GLOBALS['temp']['errorContents'] .= '</table>';
}


// Error notification on delete -----------------------------------------------
if ($exists) {
	$GLOBALS['temp']['showError'] = "";	
	$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the Cost Centres you selected to delete are used elsewhere in the system. Below is a list of the Cost Centres and where they are used:</span><br /><br />';
	$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';
	$GLOBALS['temp']['errorContents'] .= '
		<tr>
			<thead>
				<th class="colDk bb br">Year Description</th>
				<th class="colDk bb">Section</th>
			</thead>
			</tr>
	';

	foreach($where as $fn_year_id => $section) {
		if($section) {
			$fn_year_desc = $GLOBALS['lDB']->get("SELECT fn_year_desc FROM fn_year WHERE fn_year_ix = '$fn_year_id'",4);
			$GLOBALS['temp']['errorContents'] .= '
				<tr>
					<td class="colWh bb br" valign="top">' . $fn_year_desc . '</td>
					<td class="colWh bb" valign="top">
			';

			foreach ($section as $s) {
				$GLOBALS['temp']['errorContents'] .= $s . '<br />';
			}
			$GLOBALS['temp']['errorContents'] .= '</td></tr>';
		}
	}

	$GLOBALS['temp']['errorContents'] .= '
		<tr class="colLt">
			<td colspan="3" align="right">
				<button type="button" class="button" onclick="closeError();">
					<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
					<span>OK</span>
				</button>
			</td>
		</tr>
	';
	$GLOBALS['temp']['errorContents'] .= '</table>';
}

$GLOBALS['temp']['yearRows'] = $yearHTML;
$GLOBALS['temp']['unitName'] = $unitName;
$GLOBALS['temp']['fun_job_id'] = $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID'] = $iUnitID;
$GLOBALS['temp']['today'] = date("Y-m-d");

