<?php

/**
 * init.form369.php - Sales analysis
 * Job: 304
 * Function: 105 (Reports Financials: Sales Analysis)
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],42,"");

$pf_object_id = db_pf_object_by_name("sales_analysis_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Sales Analysis Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();


if (!array_key_exists($form,$GLOBALS)) {
   $GLOBALS[$form] = "";
}


if (!is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_sales_analysis.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

$resetDate = false;
if(trim($_SERVER['argv'][1]) == "" || trim($_SERVER['argv'][2]) == "") {
	$resetDate = true;
	$today = date("Y-m-d");
	$todayArray = explode("-",$today);
	$first = date("Y-m-d",mktime(0,0,0,$todayArray[1],1,$todayArray[0]));
	$last = date("Y-m-d",mktime(0,0,0,$todayArray[1]+4,0,$todayArray[0]));
	$_SERVER['argv'][1] = $_SERVER['argv'][33] = $first;
	$_SERVER['argv'][2] = $_SERVER['argv'][34] = $last;
}


$fromDate = useDate("from", $_SERVER['argv'][1]);
$toDate = useDate("to", $_SERVER['argv'][2]);
$statusDateFromDate = useDate("statusDateFrom", $_SERVER['argv'][33]);
$statusDateToDate = useDate("statusDateTo", $_SERVER['argv'][34]);
$createDateFromDate = useDate("createDateFrom", $_SERVER['argv'][40]);
$createDateToDate = useDate("createDateTo", $_SERVER['argv'][41]);

$GLOBALS['temp']['fromDateFormat'] = chng_date($fromDate['jsDate'],"-");
$GLOBALS['temp']['toDateFormat'] = chng_date($toDate['jsDate'],"-");

if($resetDate) {
	$_SERVER['argv'][1] = $_SERVER['argv'][33] = "";
	$_SERVER['argv'][2] = $_SERVER['argv'][34] = "";
}

// Create an array of each month's start/end date
$currDate = $fromDate['jsDate'];
$dateArray = array();
while($currDate < $toDate['jsDate']) {
	list($currYear, $currMonth, $currDay) = explode("-",$currDate);
	array_push($dateArray,array(
		"start"=>date("Y-m-d",mktime(0,0,0,$currMonth,1,$currYear)),
		"end"=>date("Y-m-d",mktime(0,0,0,$currMonth+1,0,$currYear))
	));

	$currDate = date("Y-m-d",mktime(0,0,0,$currMonth+1,1,$currYear));
}
$dateArray[0]['start'] = $fromDate['jsDate'];
$dateArray[sizeof($dateArray)-1]['end'] = $toDate['jsDate'];

$GLOBALS['temp']['totalOnlyChecked'] = "";
$GLOBALS['temp']['includePaymentChecked'] = "";
$GLOBALS['temp']['includePayment'] = "No";
$showTotal = $_SERVER['argv']['35'];
$includePayment = $_SERVER['argv']['36'];

$GLOBALS['temp']['totalOnly'] = "No";
if($showTotal == 1) {
	$GLOBALS['temp']['totalOnlyChecked'] = "checked";
	$GLOBALS['temp']['totalOnly'] = "yes";
}

if($includePayment == 1) {
	$GLOBALS['temp']['includePaymentChecked'] = "checked";
	$GLOBALS['temp']['includePayment'] = "yes";
}

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][29];
$showHideButtonText = $_SERVER['argv'][30];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
//	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
//	}
}
// BUG #5484: END -------------------------------------------------------------

if($_SERVER['argv'][1] == "" && $_SERVER['argv'][4] == "" && $pf_option_id == "") {
	$_SERVER['argv'][4] = join(":",$GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}


$accommACL= $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][4],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

$agentACL = false;
if($userStatusId < 2) {
   $agentACL = array($calAgentId);
}
$agentFilter = useFilter("agent",$_SERVER['argv'][6],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][7],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_ag.pr_corr_country_id",false,false,false);
$agentSelect = $_SERVER['argv'][5];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentSelect == "country") {
   $GLOBALS['temp']['agentNameRadioChecked'] = "";
   $GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
   $agentWhere = $agentCountryFilter['where'];
} else {
   $agentWhere = $agentFilter['where'];
}

// Set defaults
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][8] == "" && $pf_option_id == "") {
	$_SERVER['argv'][8] = "30";
}
$statusACL = $GLOBALS['lDB']->get("
         SELECT
            rf_reservation_status_id
         FROM
            rf_reservation_status
         WHERE
		 	rf_reservation_status_id <> 25
			AND rf_reservation_status_id <> 97
",3);
$statusFilter = useFilter("statusAlloc",$_SERVER['argv'][8],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);			
$consultantFilter = useFilter("consultant",$_SERVER['argv'][9],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");
$originatorFilter = useFilter("originator",$_SERVER['argv'][10],"SELECT pr_persona.pr_name_first,pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");
$sourceFilter = useFilter("source",$_SERVER['argv'][11],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No source","0");
// 11 is nationality
$nationalityFilter = useFilter("nationality",$_SERVER['argv'][12],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");
$nationalityIds = explode(":",$nationalityFilter['ids']);
if(in_array("0",$nationalityIds)) {
	$nationalityFilter['where'] = "AND ( 1 ".$nationalityFilter['where']." OR rv_reservation.rf_country_id IS NULL )";
}
$rateFilter = useFilter("rate",$_SERVER['argv'][13],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type_ix=","rv_reservation_item.rt_rate_type_id",false,false,false);

$currenciesFilter = useFilter("currencies",$_SERVER['argv'][14],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","fn_folio.rf_currency_id",false,false,false);

list($rateOverride,$rateOverrideType,$rateOverrideAgentGranted,$rateOverrideAgentDenied) = array_pad(explode(":",$_SERVER['argv'][15]),4,"");
$GLOBALS['temp']['rateOverrideChecked'] = "";
if(!empty($rateOverride)) {
	$GLOBALS['temp']['rateOverrideChecked'] = "checked";
}
$GLOBALS['temp']['rateOverrideExcludeResChecked'] = "";
$GLOBALS['temp']['rateOverrideIncludeResChecked'] = "";
$GLOBALS['temp']['rateOverrideExcludeItemChecked'] = "";
$GLOBALS['temp']['rateOverrideIncludeItemChecked'] = "";
switch($rateOverrideType) {
default:
case "excludeRes":
	$GLOBALS['temp']['rateOverrideExcludeResChecked'] = "checked";
	break;
case "includeRes":
	$GLOBALS['temp']['rateOverrideIncludeResChecked'] = "checked";
	break;
case "excludeItem":
	$GLOBALS['temp']['rateOverrideExcludeItemChecked'] = "checked";
	break;
case "includeItem":
	$GLOBALS['temp']['rateOverrideIncludeItemChecked'] = "checked";
	break;
}
if(empty($rateOverrideAgentGranted) && empty($rateOverrideAgentDenied)) {
	$rateOverrideAgentGranted = "1";
	$rateOverrideAgentDenied = "1";
}
$GLOBALS['temp']['rateOverrideAgentGrantedChecked'] = "";
if(!empty($rateOverrideAgentGranted)) {
	$GLOBALS['temp']['rateOverrideAgentGrantedChecked'] = "checked";
}
$GLOBALS['temp']['rateOverrideAgentDeniedChecked'] = "";
if(!empty($rateOverrideAgentDenied)) {
	$GLOBALS['temp']['rateOverrideAgentDeniedChecked'] = "checked";
}

list($amountOverride,$amountOverrideType) = array_pad(explode(":",$_SERVER['argv'][16]),2,"");
$GLOBALS['temp']['amountOverrideChecked'] = "";
if(!empty($amountOverride)) {
	$GLOBALS['temp']['amountOverrideChecked'] = "checked";
}
$GLOBALS['temp']['amountOverrideExcludeResChecked'] = "";
$GLOBALS['temp']['amountOverrideIncludeResChecked'] = "";
$GLOBALS['temp']['amountOverrideExcludeItemChecked'] = "";
$GLOBALS['temp']['amountOverrideIncludeItemChecked'] = "";
switch($amountOverrideType) {
default:
case "excludeRes":
	$GLOBALS['temp']['amountOverrideExcludeResChecked'] = "checked";
	break;
case "includeRes":
	$GLOBALS['temp']['amountOverrideIncludeResChecked'] = "checked";
	break;
case "excludeItem":
	$GLOBALS['temp']['amountOverrideExcludeItemChecked'] = "checked";
	break;
case "includeItem":
	$GLOBALS['temp']['amountOverrideIncludeItemChecked'] = "checked";
	break;
}


$showRevenueOption = $_SERVER['argv'][17];
$GLOBALS['temp']['showRevenueChecked'] = "";
$GLOBALS['temp']['revenueDivClass'] = "collapse printCollapse";
$GLOBALS['temp']['showRevenue'] = "No";
if($showRevenueOption == "1") {
	$GLOBALS['temp']['showRevenueChecked'] = " checked ";
	$GLOBALS['temp']['revenueDivClass'] = "";
	$GLOBALS['temp']['showRevenue'] = "Yes";
}

$nightType = $_SERVER['argv'][37];

if($nightType == "room") {
	$GLOBALS['temp']['nightTypeRoomChecked'] = "checked";
	$showRoomConfig = "0";
	$nightLabel = "Rm";
} else {
	$GLOBALS['temp']['nightTypeBedChecked'] = "checked";
	$showRoomConfig = $_SERVER['argv'][18];
	$nightLabel = "Bed";
}

$GLOBALS['temp']['showRoomConfigChecked'] = " checked ";
$GLOBALS['temp']['showRoomConfig'] = "Yes ";
if($showRoomConfig == "0") {
	$GLOBALS['temp']['showRoomConfigChecked'] = "";
	$GLOBALS['temp']['showRoomConfig'] = "No ";
}

$level1 = $_SERVER['argv'][19];
$level2 = $_SERVER['argv'][20];

$totalBy = $_SERVER['argv'][21];
$GLOBALS['temp']['totalBy'] = $totalBy;
$GLOBALS['temp']['byInvoiceChecked'] = "";

$GLOBALS['temp']['totalBy'] = $totalBy;
$GLOBALS['temp']['byDayChecked'] = "";
if($totalBy == "invoice") {
	$GLOBALS['temp']['byInvoiceChecked'] = "checked";
} else {
	$GLOBALS['temp']['byDayChecked'] = "checked";
}

$commType = $_SERVER['argv'][22];
$GLOBALS['temp']['commType'] = $commType;
$GLOBALS['temp']['commNettChecked'] = "";
$GLOBALS['temp']['commGrossChecked'] = "";
$GLOBALS['temp']['commPayableChecked'] = "";
switch($commType) {
default:
case "nett":
	$GLOBALS['temp']['commNettChecked'] = "checked";
	break;
case "gross":
	$GLOBALS['temp']['commGrossChecked'] = "checked";
	break;
case "payable":
	$GLOBALS['temp']['commPayableChecked'] = "checked";
	break;
}

$showTax = $_SERVER['argv'][23];
$GLOBALS['temp']['showTaxChecked'] = "";
$GLOBALS['temp']['showTax'] = "No";
if($showTax == "1") {
	$GLOBALS['temp']['showTaxChecked'] = "checked";
	$GLOBALS['temp']['showTax'] = "Yes";
}

$excludeTBA = $_SERVER['argv'][24];
$GLOBALS['temp']['excludeTBAChecked'] = "";
$GLOBALS['temp']['excludeTBA'] = "No";
if($excludeTBA == "1") {
	$GLOBALS['temp']['excludeTBAChecked'] = "checked";
	$GLOBALS['temp']['excludeTBA'] = "Yes";
}

$componentsFilter = useFilter("components",$_SERVER['argv'][25],"SELECT rt_component.rt_component_desc FROM rt_component WHERE rt_component.rt_component_ix =","rv_res_item_comp.rt_component_id NOT ",false,false,false);


$roomUpgrade = $_SERVER['argv'][38];
$GLOBALS['temp']['roomUpgradeChecked'] = "";
if($roomUpgrade == 1) {
	$GLOBALS['temp']['roomUpgradeChecked'] = "checked";
}

$sortBy = $_SERVER['argv'][26];
if($sortBy == "") {
	$sortBy = 1;
}
$GLOBALS['temp']['imgSort1Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort5Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort6Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort7Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort8Mode'] = "std"; #(desc, desc)
switch($sortBy) {
	case 1:
		$GLOBALS['temp']['imgSort1Mode'] = "down";
		break;
	case 2:
		$GLOBALS['temp']['imgSort2Mode'] = "down";
		break;
	case 3:
		$GLOBALS['temp']['imgSort3Mode'] = "down";
		break;
	case 4:
		$GLOBALS['temp']['imgSort4Mode'] = "down";
		break;		
	case 5:
		$GLOBALS['temp']['imgSort5Mode'] = "down";
		break;		
	case 6:
		$GLOBALS['temp']['imgSort6Mode'] = "down";
		break;		
	case 7:
		$GLOBALS['temp']['imgSort7Mode'] = "down";
		break;		
	case 8:
		$GLOBALS['temp']['imgSort8Mode'] = "down";
		break;		
}
$GLOBALS['temp']['sortBy'] = $sortBy;

$options = $_SERVER['argv'][27];

switch ( $options & 7 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
}


$GLOBALS['temp']['statusDateChecked'] = "";
$statusDateChecked = $_SERVER['argv'][31];
if($statusDateChecked == 1) {
	$GLOBALS['temp']['statusDateChecked'] = "checked";
}

$GLOBALS['temp']['createDateChecked'] = "";
$createDateChecked = $_SERVER['argv'][39];
if($createDateChecked == 1) {
	$GLOBALS['temp']['createDateChecked'] = "checked";
}

$statusDateType = $_SERVER['argv'][32];
$GLOBALS['temp']['statusDateAllChecked'] = "";
$GLOBALS['temp']['statusDateCreateChecked'] = "";
$GLOBALS['temp']['statusDateCancelChecked'] = "";
$GLOBALS['temp']['statusDateConfirmChecked'] = "";
$GLOBALS['temp']['statusDateProvisionalChecked'] = "";
$GLOBALS['temp']['statusDateWaitlistChecked'] = "";
switch($statusDateType) {
case "all":
	$GLOBALS['temp']['statusDateAllChecked'] = "selected";
	break;
case "create":
	$GLOBALS['temp']['statusDateCreateChecked'] = "selected";
	break;
case "cancel":
	$GLOBALS['temp']['statusDateCancelChecked'] = "selected";
	break;
case "confirm":
	$GLOBALS['temp']['statusDateConfirmChecked'] = "selected";
	break;
case "provisional":
	$GLOBALS['temp']['statusDateProvisionalChecked'] = "selected";
	break;
case "waitlist":
	$GLOBALS['temp']['statusDateWaitlistChecked'] = "selected";
	break;
}

if($renderMode == "pdf" && $renderType == "email") {
   $pdfName = "Sales Analysis Report from  " . chng_date($fromDate['jsDate'],"-") . " to " . chng_date($toDate['jsDate'],"-");
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,27))."+$newOptions" . join("+",array_slice($_SERVER['argv'],28,10));

// echo $formAction."<BR>";

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '" . $userId . "'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}


function getLevel($level,$value) {
	$GLOBALS['temp']["level" . $level . 'All'] = "";
	$GLOBALS['temp']["level" . $level . 'Property'] = "";
	$GLOBALS['temp']["level" . $level . 'Accomm'] = "";
	$GLOBALS['temp']["level" . $level . 'Agent'] = "";
	$GLOBALS['temp']["level" . $level . 'AgentPostal'] = "";
	$GLOBALS['temp']["level" . $level . 'AgentPhysical'] = "";
	$GLOBALS['temp']["level" . $level . 'Contact'] = "";
	$GLOBALS['temp']["level" . $level . 'Source'] = "";
	$GLOBALS['temp']["level" . $level . 'Originator'] = "";
	$GLOBALS['temp']["level" . $level . 'Consultant'] = "";
	$GLOBALS['temp']["level" . $level . 'Nationality'] = "";
	$GLOBALS['temp']["level" . $level . 'RateType'] = "";
	$GLOBALS['temp']["level" . $level . 'Status'] = "";
	$GLOBALS['temp']["level" . $level . 'ResName'] = "";
	$GLOBALS['temp']["level" . $level . 'ResNo'] = "";

	$sqlOrderBy = "";
	$sqlGroupSelect = "";
	$sqlGroupJoin = "";
	$sqlGroupAuxSelect = "";
	$sqlGroupAuxJoin = "";
	$sqlOrderBy = "";
	$blankDesc = "";

	switch($value) {
	default:
	case "all":
		$GLOBALS['temp']['level' . $level . 'All'] = "selected";
		$sqlOrderBy = "";
		$blankDesc = "All";
		$sqlGroupSelect = "
			'' as id$level,
			'All' as name$level
		";
		$sqlGroupJoin = "";
		$sqlGroupAuxSelect = "";
		$sqlGroupAuxJoin = "";
		$GLOBALS['temp']['level' . $level . 'Name'] = "All";
		break;
	case "property":
		$GLOBALS['temp']['level' . $level . 'Property'] = "selected";
		$sqlOrderBy = "rv_reservation_item.pr_business_id";
		$sqlGroupSelect = "
				rv_reservation_item.pr_business_id as id$level,
				groupTable$level.pr_name_last as name$level
		";
		$sqlGroupJoin = "
			INNER JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation_item.pr_business_id
		";
		$blankDesc = "Unknown Property";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Property";
		break;
	case "accomm":
		$GLOBALS['temp']['level' . $level . 'Accomm'] = "selected";
		$sqlOrderBy = "rv_reservation_item.ac_accomm_type_id";
		$sqlGroupSelect = "
				rv_reservation_item.ac_accomm_type_id as id$level,
				CONCAT(groupTable".$level."_2.pr_bus_name_short,CONCAT(' - ',groupTable$level.ac_accomm_desc)) as name$level
		";
		$sqlGroupJoin = "
			INNER JOIN ac_accomm_type AS groupTable$level ON groupTable$level.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN pr_business AS groupTable".$level."_2 ON groupTable".$level."_2.pr_business_id = groupTable$level.pr_business_id
		";
		$sqlGroupAuxJoin = "
			LEFT JOIN rv_res_item_group AS groupTableAux$level ON groupTableAux$level.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			LEFT JOIN ac_accomm_type AS groupTableAux".$level."_2 ON groupTableAux".$level."_2.ac_accomm_type_ix = groupTableAux$level.ac_accomm_type_id
			LEFT JOIN pr_business AS groupTableAux".$level."_3 ON groupTableAux".$level."_3.pr_business_id = groupTableAux".$level."_2.pr_business_id
		";
		$sqlGroupAuxSelect = "
				groupTableAux$level.ac_accomm_type_id as id_aux$level,
				CONCAT(groupTableAux".$level."_3.pr_bus_name_short,CONCAT(' - ',groupTableAux".$level."_2.ac_accomm_desc)) as name_aux$level
		";
		$blankDesc = "Unknown Accommodation";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Accommodation";
		break;
	case "agent":
		$GLOBALS['temp']['level' . $level . 'Agent'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_agent_id";
		$sqlGroupSelect = "
				rv_reservation.rv_agent_id as id$level,
				groupTable$level.pr_name_last as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation.rv_agent_id
		";
		$blankDesc = "Direct";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Agent";
		break;
	case "agentPostal":
		$GLOBALS['temp']['level' . $level . 'AgentPostal'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_agent_id";
		$sqlGroupSelect = "
				groupTable".$level."_2.rf_country_ix as id$level,
				groupTable".$level."_2.rf_country_name as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rf_country AS groupTable".$level."_2 ON groupTable".$level."_2.rf_country_ix = groupTable$level.pr_corr_country_id
		";
		$blankDesc = "No country";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Agent postal country";
		break;
	case "agentPhysical":
		$GLOBALS['temp']['level' . $level . 'AgentPhysical'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_agent_id";
		$sqlGroupSelect = "
				groupTable".$level."_2.rf_country_ix as id$level,
				groupTable".$level."_2.rf_country_name as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rf_country AS groupTable".$level."_2 ON groupTable".$level."_2.rf_country_ix = groupTable$level.pr_phys_country_id
		";
		$blankDesc = "No country";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Agent physical country";
		break;
	case "contact":
		$GLOBALS['temp']['level' . $level . 'Contact'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_corr_persona_id";
		$sqlGroupSelect = "
				rv_reservation.rv_corr_persona_id as id$level,
				groupTable$level.pr_name_first as name".$level."_1,
				groupTable$level.pr_name_last as name".$level."_2
		";
		$sqlGroupJoin = "
			LEFT JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation.rv_corr_persona_id
		";
		$blankDesc = "No contact";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Contact";
		break;
	case "source":
		$GLOBALS['temp']['level' . $level . 'Source'] = "selected";
		$sqlOrderBy = "rv_reservation.rf_source_ix";
		$sqlGroupSelect = "
				rv_reservation.rf_source_ix as id$level,
				groupTable$level.rf_source_desc as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN rf_source AS groupTable$level ON groupTable$level.rf_source_ix = rv_reservation.rf_source_ix
		";
		$blankDesc = "No Source";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Source";
		break;
	case "originator":
		$GLOBALS['temp']['level' . $level . 'Originator'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_origin_agent_id";
		$sqlGroupSelect = "
				groupTable$level.pr_persona_ix as id$level,
				groupTable$level.pr_name_last as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation.rv_origin_agent_id
		";
		$blankDesc = "No Originator";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Originator";
		break;
	case "consultant":
		$GLOBALS['temp']['level' . $level . 'Consultant'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_consultant_id";
		$sqlGroupSelect = "
				rv_reservation.rv_consultant_id as id$level,
				groupTable$level.pr_name_first as name".$level."_1,
				groupTable$level.pr_name_last as name".$level."_2
		";
		$sqlGroupJoin = "
			INNER JOIN pr_persona AS groupTable$level ON groupTable$level.pr_persona_ix = rv_reservation.rv_consultant_id
		";
		$blankDesc = "No Consultant";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Consultant";
		break;
	case "nationality":
		$GLOBALS['temp']['level' . $level . 'Nationality'] = "selected";
		$sqlOrderBy = "rv_reservation.rf_country_id";
		$sqlGroupSelect = "
				groupTable$level.rf_country_ix as id$level,
				groupTable$level.rf_country_name as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN rf_country AS groupTable$level ON groupTable$level.rf_country_ix = rv_reservation.rf_country_id
		";
		$blankDesc = "No Nationality";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Nationality";
		break;
	case "rateType":
		$GLOBALS['temp']['level' . $level . 'RateType'] = "selected";
		$sqlOrderBy = "rv_reservation_item.rt_rate_type_id";
		$sqlGroupSelect = "
				groupTable$level.rt_rate_type_ix as id$level,
				groupTable$level.rt_rate_type_desc as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN rt_rate_type AS groupTable$level ON groupTable$level.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id
		";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Rate type";
		break;
	case "status":
		$GLOBALS['temp']['level' . $level . 'Status'] = "selected";
		$sqlOrderBy = "rv_reservation.rf_reservation_status_id";
		$sqlGroupSelect = "
				groupTable$level.rf_reservation_status_id as id$level,
				groupTable$level.rf_reservation_status_desc as name$level
		";
		$sqlGroupJoin = "
			LEFT JOIN rf_reservation_status AS groupTable$level ON groupTable$level.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Status";
		break;
	case "resname":
		$GLOBALS['temp']['level' . $level . 'ResName'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_res_name";
		$sqlGroupSelect = "
				rv_reservation.rv_reservation_ix as id$level,
				rv_reservation.rv_res_name as name$level
		";
		$sqlGroupJoin = "";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Res #";
		break;
	case "resno":
		$GLOBALS['temp']['level' . $level . 'ResNo'] = "selected";
		$sqlOrderBy = "rv_reservation.rv_reservation_ix";
		$sqlGroupSelect = "
				rv_reservation.rv_reservation_ix as id$level,
				rv_reservation.rv_reservation_ix as name$level
		";
		$sqlGroupJoin = "";
		$GLOBALS['temp']['level' . $level . 'Name'] = "Res #";
		break;
	}

	return array('sqlGroupSelect'=>$sqlGroupSelect, 'sqlGroupJoin'=>$sqlGroupJoin, 'sqlGroupAuxSelect'=>$sqlGroupAuxSelect, 'sqlGroupAuxJoin'=>$sqlGroupAuxJoin, 'sqlOrderBy'=>$sqlOrderBy, 'blankDesc'=>$blankDesc);
}

$sqlGroupAuxSelect = "";
$sqlGroupAuxJoin = "";

$level1SQL = getLevel("1",$level1);
$level2SQL = getLevel("2",$level2);

$sqlFrom = "
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
		LEFT JOIN pr_persona AS pr_ag ON pr_ag.pr_persona_ix = rv_reservation.rv_agent_id
		INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
";

if($totalBy == "day") {
	$sqlDateWhere = "
		(
			(rv_reservation_item.rv_item_date_arrive >= '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_arrive <= '$toDate[jsDate]')
			OR (rv_reservation_item.rv_item_date_depart >= '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_depart <= '$toDate[jsDate]')
			OR (rv_reservation_item.rv_item_date_arrive < '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_depart > '$toDate[jsDate]')
		)
	";
} else {
	$sqlDateWhere = "
		fn_folio.fn_folio_date >= '$fromDate[jsDate]' AND fn_folio.fn_folio_date <= '$toDate[jsDate]'
	";
}

if($statusDateChecked == 1) {
	switch($statusDateType) {
	case "all":
		$sqlDateWhere .= "
			AND (
				(
					rv_reservation.rv_date_recorded >= '$statusDateFromDate[jsDate]'
					AND rv_reservation.rv_date_recorded <= '$statusDateToDate[jsDate]'
				) OR (
					rv_reservation.rv_cancel_date >= '$statusDateFromDate[jsDate]'
					AND rv_reservation.rv_cancel_date <= '$statusDateToDate[jsDate]'
				) OR (
					rv_reservation.rv_confirmation_date >= '$statusDateFromDate[jsDate]'
					AND rv_reservation.rv_confirmation_date <= '$statusDateToDate[jsDate]'
				) OR (
					rv_reservation.rv_prov_date >= '$statusDateFromDate[jsDate]'
					AND rv_reservation.rv_prov_date <= '$statusDateToDate[jsDate]'
				) OR (
					rv_reservation.rv_wait_list_date >= '$statusDateFromDate[jsDate]'
					AND rv_reservation.rv_wait_list_date <= '$statusDateToDate[jsDate]'
				)

			)
		";
		break;
	case "create":
		$sqlDateWhere .= "
			AND rv_reservation.rv_date_recorded >= '$statusDateFromDate[jsDate]'
			AND rv_reservation.rv_date_recorded <= '$statusDateToDate[jsDate]'
		";
		break;
	case "cancel":
		$sqlDateWhere .= "
			AND rv_reservation.rv_cancel_date >= '$statusDateFromDate[jsDate]'
			AND rv_reservation.rv_cancel_date <= '$statusDateToDate[jsDate]'
		";
		break;
	case "confirm":
		$sqlDateWhere .= "
			AND rv_reservation.rv_confirmation_date >= '$statusDateFromDate[jsDate]'
			AND rv_reservation.rv_confirmation_date <= '$statusDateToDate[jsDate]'
		";
		break;
	case "provisional":
		$sqlDateWhere .= "
			AND rv_reservation.rv_prov_date >= '$statusDateFromDate[jsDate]'
			AND rv_reservation.rv_prov_date <= '$statusDateToDate[jsDate]'
		";
		break;
	case "waitlist":
		$sqlDateWhere .= "
			AND rv_reservation.rv_wait_list_date >= '$statusDateFromDate[jsDate]'
			AND rv_reservation.rv_wait_list_date <= '$statusDateToDate[jsDate]'
		";
		break;
	}
}

if($createDateChecked == 1) {
	$sqlDateWhere .= "
		AND rv_reservation.rv_date_recorded >= '$createDateFromDate[jsDate]'
		AND rv_reservation.rv_date_recorded <= '$createDateToDate[jsDate]'
	";
}

$sqlWhere = "
	WHERE
		$sqlDateWhere
		$accommFilter[where]
		$agentWhere
		$statusFilter[where]
		$consultantFilter[where]
		$originatorFilter[where]
		$sourceFilter[where] 
		$nationalityFilter[where]
		$rateFilter[where]
		$currenciesFilter[where]
";

if($_SERVER['argv'][1] != "" && $_SERVER['argv'][2] != "") {
	$GLOBALS['temp']['reportGenerated'] = "";

	$accommList = $GLOBALS['lDB']->get("
		SELECT
			DISTINCT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
		WHERE
			1
			".str_replace('ac_accomm_type_id','ac_accomm_type_ix',str_replace('rv_reservation_item','ac_accomm_type',$accommFilter['where']))."
	",3);

	if($level1 != "all") {
		if($level2 != "all") {
			$sqlGroupSelect = $level1SQL['sqlGroupSelect'] . "," . $level2SQL['sqlGroupSelect'];
			if(!empty($level1SQL['sqlGroupAuxSelect'])) {
				$sqlGroupAuxSelect .= "," . $level1SQL['sqlGroupAuxSelect'];
			}
			if(!empty($level2SQL['sqlGroupAuxSelect'])) {
				$sqlGroupAuxSelect .= "," . $level2SQL['sqlGroupAuxSelect'];
			}
			$sqlGroupJoin = $level1SQL['sqlGroupJoin'] . " " . $level2SQL['sqlGroupJoin'];
			if(!empty($level1SQL['sqlGroupAuxJoin'])) {
				$sqlGroupAuxJoin .= " " . $level1SQL['sqlGroupAuxJoin'];
			}
			if(!empty($level2SQL['sqlGroupAuxJoin'])) {
				$sqlGroupAuxJoin .= " " . $level2SQL['sqlGroupAuxJoin'];
			}
			$sqlOrderBy = $level1SQL['sqlOrderBy'] . "," . $level2SQL['sqlOrderBy'];
		} else {
			$sqlGroupSelect = $level1SQL['sqlGroupSelect'];
			if(!empty($level1SQL['sqlGroupAuxSelect'])) {
				$sqlGroupAuxSelect .= "," . $level1SQL['sqlGroupAuxSelect'];
			}
			$sqlGroupJoin = $level1SQL['sqlGroupJoin'];
			if(!empty($level1SQL['sqlGroupAuxJoin'])) {
				$sqlGroupAuxJoin .= " " . $level1SQL['sqlGroupAuxJoin'];
			}
			$sqlOrderBy = $level1SQL['sqlOrderBy'];
		}
		$groupByList = $GLOBALS['lDB']->get("SELECT DISTINCT $sqlGroupSelect $sqlGroupAuxSelect $sqlFrom $sqlGroupJoin $sqlGroupAuxJoin $sqlWhere ORDER BY $sqlOrderBy",2);
		$newGroupByList = array();
		foreach($groupByList as $item) {
			$newGroupByList[] = $item;
			if(!empty($item['id_aux1']) || !empty($item['id_aux2'])) {
				$item['id1'] = isset($item['id_aux1']) ? $item['id_aux1'] : "";
				$item['name1'] = isset($item['name_aux1']) ? $item['name_aux1'] : "";
				$item['id2'] = isset($item['id_aux2']) ? $item['id_aux2'] : "";
				$item['name2'] = isset($item['name_aux2']) ? $item['name_aux2'] : "";
				$newGroupByList[] = $item;
			}
		}
		$groupByList = $newGroupByList;
		if(is_array($groupByList)) {
			foreach($groupByList as $key=>$item) {
				if( (isset($item['name1_1']) && trim($item['name1_1']) != "") || (isset($item['name1_2']) && trim($item['name1_2']) != "") ) {
					$groupByList[$key]['name1'] = trim($item['name1_1'] . " " . $item['name1_2']);
				}
				if( (isset($item['name2_1']) && trim($item['name2_1']) != "") || (isset($item['name2_2']) && trim($item['name2_2']) != "") ) {
					$groupByList[$key]['name2'] = trim($item['name2_1'] . " " . $item['name2_2']);
				}
			}
		}
	} else {
		$groupByList = array(
			array("id"=>"0", "name"=>"All")
		);
		$sqlGroupSelect = $level1SQL['sqlGroupSelect'];
		$sqlGroupJoin = "";
		$sqlOrderBy = "";
	}

	$potentialArray = $dateArray;
	foreach($potentialArray as $potentialKey=>$potentialItem) {
		$monthDays = dateSubtract($potentialItem['end'],$potentialItem['start'])+1;
		$roomArray = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_room.ac_accomm_room_ix,
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_room.ac_accomm_room_inactive_yn,
				ac_accomm_type.ac_accomm_type_inactive_yn,
				ac_accomm_room.ac_accomm_room_inactive_date,
				ac_accomm_type.ac_accomm_type_inactive_date,
				ac_accomm_type.ac_accomm_capacity,
				ac_accomm_room.ac_accomm_room_create_date
			FROM
				ac_accomm_room
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			WHERE
				ac_accomm_type.ac_accomm_type_ix IN ('" . join("','",$accommList) . "')
				AND (
					(
						ac_accomm_room.ac_accomm_room_inactive_yn = '0'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
					) OR (
						ac_accomm_room.ac_accomm_room_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
					) OR (
						ac_accomm_type.ac_accomm_type_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'
						AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					) OR (
						ac_accomm_room.ac_accomm_room_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_type.ac_accomm_type_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'						
					)
				)
		",2);
		$roomCount = 0;
		$accommBedNight = 0;
		foreach($roomArray as $roomItem) {
			$startDate = $potentialItem['start'];
			$endDate = $potentialItem['end'];
			$addFirst = 1;
			if($roomItem['ac_accomm_room_create_date'] > $potentialItem['start']) {
				$startDate = $roomItem['ac_accomm_room_create_date'];
			}
			if($roomItem['ac_accomm_room_inactive_yn'] == "1") {
				$endDate = $roomItem['ac_accomm_room_inactive_date'];
				$addFirst = 0;
			}
			if($roomItem['ac_accomm_type_inactive_yn'] == "1") {
				$endDate = $roomItem['ac_accomm_type_inactive_date'];
				$addFirst = 0;
			}
			if($endDate < $startDate) { continue; }
			if($endDate > $potentialItem['end']) {
				$endDate = $potentialItem['end'];
				$addFirst = 1;
			}
			$roomCount += dateSubtract($endDate,$startDate)+$addFirst;
			$accommBedNight += $roomItem['ac_accomm_capacity'] * (dateSubtract($endDate,$startDate)+$addFirst);
		}
		$potentialArray[$potentialKey]['roomCount'] = $roomCount;
		$potentialArray[$potentialKey]['accommBedNight'] = $accommBedNight;

		$blockCount = 0;
		$blockBedNight = 0;
		// Find blocked rooms for each day.
		list($year, $month, $day) = explode("-",$potentialItem['start']);
		for($dayCount = 1; $dayCount <= $monthDays; $dayCount++) {
			$currDate = date("Y-m-d",mktime(0,0,0,$month,$dayCount,$year));
			$blockArray = $GLOBALS['lDB']->get("
				SELECT
					DISTINCT ac_accomm_room_block.ac_accomm_room_id,
					ac_accomm_type.ac_accomm_capacity
				FROM
					ac_accomm_block
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_block.ac_accomm_type_id
					INNER JOIN ac_accomm_room_block ON ac_accomm_room_block.ac_accomm_block_id = ac_accomm_block.ac_accomm_block_ix
					INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
				WHERE
					ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$accommList)."')		
					AND ac_accomm_block.ac_start_date <= '" . $currDate . "'
					AND ac_accomm_block.ac_end_date > '" . $currDate . "'
					AND (
						(
							ac_accomm_room.ac_accomm_room_inactive_yn = '0'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						) OR (
							ac_accomm_room.ac_accomm_room_inactive_date > '" . $currDate . "'
							AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						) OR (
							ac_accomm_type.ac_accomm_type_inactive_date > '" . $currDate . "'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'
							AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						) OR (
							ac_accomm_room.ac_accomm_room_inactive_date > '" . $currDate . "'
							AND ac_accomm_type.ac_accomm_type_inactive_date > '" . $currDate . "'
							AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						)
				)
			",2);
			foreach($blockArray as $blockItem) {
				$blockCount += 1;
				$blockBedNight += $blockItem['ac_accomm_capacity'];
			}
		}
		$potentialArray[$potentialKey]['blockCount'] = $blockCount;
		$potentialArray[$potentialKey]['blockBedNight'] = $blockBedNight;

		$potentialArray[$potentialKey]['potentialBedNight'] = $potentialArray[$potentialKey]['accommBedNight'] - $potentialArray[$potentialKey]['blockBedNight'];
		$potentialArray[$potentialKey]['adultBeds'] = 0;
		$potentialArray[$potentialKey]['childBeds'] = 0;
		$potentialArray[$potentialKey]['totalBeds'] = 0;
	}

	$roomCountTotal = 0;
	$accommBedNightTotal = 0;
	$blockCountTotal = 0;
	$blockBedNightTotal = 0;
	$potentialBedNightTotal = 0;
	foreach($potentialArray as $potentialKey=>$potentialItem) {
		$roomCountTotal += $potentialItem['roomCount'];
		$accommBedNightTotal += $potentialItem['accommBedNight'];
		$blockCountTotal += $potentialItem['blockCount'];
		$blockBedNightTotal += $potentialItem['blockBedNight'];
		$potentialBedNightTotal += $potentialItem['potentialBedNight'];
	}

	function reservationHasRateOverride($rv_reservation_id) {
		global $lDB;

		$rt_rate_type_id = $lDB->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

		$count = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rt_rate_type_id != '$rt_rate_type_id'
				AND rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
		",4);
		if($count > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationItemHasRateOverride($rv_reservation_item_id) {
		global $lDB;

		$res_rate_type_id = $lDB->get("
			SELECT
				rv_reservation.rt_rate_type_id
			FROM 
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
		",4);

		$item_rate_type_id = $lDB->get("
			SELECT
				rv_reservation_item.rt_rate_type_id
			FROM 
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
		",4);

		if($res_rate_type_id != $item_rate_type_id) {
			return true;
		} else {
			return false;
		}
	}
	
	function reservationHasOverride($rv_reservation_id) {
		global $lDB;

		$overrideCount = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				INNER JOIN rv_res_item_rate_grp ON rv_res_item_rate_grp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			WHERE
				rv_reservation.rv_reservation_ix = '" . $rv_reservation_id . "'
				AND (
					rv_res_item_comp.rv_item_comp_var <> 0
					OR rv_reservation_item.rv_item_overide_amt IS NOT NULL
					OR rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt IS NOT NULL
				)
		",4);
		if($overrideCount > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationItemHasOverride($rv_reservation_item_id) {
		global $lDB;

		$overrideCount = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation_item
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				INNER JOIN rv_res_item_rate_grp ON rv_res_item_rate_grp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '" . $rv_reservation_item_id . "'
				AND (
					rv_res_item_comp.rv_item_comp_var <> 0
					OR rv_reservation_item.rv_item_overide_amt IS NOT NULL
					OR rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt IS NOT NULL
				)
		",4);
		if($overrideCount > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationHasAgentRateOverride($rv_reservation_id) {
		global $lDB;

		$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

		$check = $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
		if($check > 0) {
			$allowRateList = $lDB->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_id = '$pr_agent_id'",3);
		} else {
			$allowRateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",3);
		}
		
		$itemRateList = $lDB->get("SELECT DISTINCT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_id = '$rv_reservation_id'",3);

		$check = array_diff($itemRateList,$allowRateList);
		if(sizeof($check) > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationItemHasAgentRate($rv_reservation_item_id) {
		global $lDB;

		$rv_reservation_id = $lDB->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4);
		$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

		$check = $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
		if($check > 0) {
			$allowRateList = $lDB->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_id = '$pr_agent_id'",3);
		} else {
			$allowRateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",3);
		}

		$itemRateList = $lDB->get("SELECT DISTINCT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",3);

		$check = array_diff($itemRateList,$allowRateList);
		if(sizeof($check) > 0) {
			return true;
		} else {
			return false;
		}
	}

	$list = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_invoice_currency_id,
			rf_currency.rf_currency_symbol,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_amt_nett,
			rv_reservation_item.rv_item_amt_gross,
			rv_reservation_item.rv_item_amt_payable,
			rv_reservation_item.rv_item_amt_tax,
			fn_folio.fn_folio_date,
			rv_reservation.rv_amt_paid as totalPayment,
			$sqlGroupSelect
		$sqlFrom
		$sqlGroupJoin
		$sqlWhere
	",2);

	if($roomUpgrade == 1) {
		$newList = array();
		foreach($list as $item) {
			if($level1 == "accomm" || $level2 == "accomm") {
				$rooms = $GLOBALS['lDB']->get("
					SELECT
						rv_res_item_group.ac_accomm_type_id,
						COUNT(rv_res_item_group.rv_res_item_group_ix) as count
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					WHERE
						rv_res_item_group.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
					GROUP BY
						rv_res_item_group.ac_accomm_type_id
				",2);
		
				$item['rv_item_accomm_count_orig'] = $item['rv_item_accomm_count'];
				$left = $item['rv_item_accomm_count'];
				foreach($rooms as $room) {
					$newItem = $item;
					$newItem['rv_item_accomm_count_orig'] = $item['rv_item_accomm_count_orig'];
					$newItem['rv_item_accomm_count'] = $room['count'];
					$newItem['rv_item_amt_nett'] = round($item['rv_item_amt_nett'] / $item['rv_item_accomm_count_orig'] * $room['count'],2);
					$newItem['rv_item_amt_gross'] = round($item['rv_item_amt_gross'] / $item['rv_item_accomm_count_orig'] * $room['count'],2);
					$newItem['rv_item_amt_payable'] = round($item['rv_item_amt_payable'] / $item['rv_item_accomm_count_orig'] * $room['count'],2);
					$newItem['rv_item_amt_tax'] = round($item['rv_item_amt_tax'] / $item['rv_item_accomm_count_orig'] * $room['count'],2);
					if($level1 == "accomm") {
						$newItem['id1'] = $room['ac_accomm_type_id'];
					} else {
						$newItem['id2'] = $room['ac_accomm_type_id'];
					}
					$newList[] = $newItem;
					$left -= $room['count'];
				}
				if($left > 0) {
					$item['rv_item_accomm_count'] = $left;
					$item['rv_item_amt_nett'] = round($item['rv_item_amt_nett'] / $item['rv_item_accomm_count_orig'] * $left,2);
					$item['rv_item_amt_gross'] = round($item['rv_item_amt_gross'] / $item['rv_item_accomm_count_orig'] * $left,2);
					$item['rv_item_amt_payable'] = round($item['rv_item_amt_payable'] / $item['rv_item_accomm_count_orig'] * $left,2);
					$item['rv_item_amt_tax'] = round($item['rv_item_amt_tax'] / $item['rv_item_accomm_count_orig'] * $left,2);
					$newList[] = $item;
				}
			} else {
				$newList[] = $item;
			}
		}
		$list = $newList;
	}

	$bedNightGrid = array();
	$revenueGrid = array();
	$monthTotals = $dateArray;
	foreach($monthTotals as $monthKey=>$monthItem) {
		$final =& $monthTotals[$monthKey];
		$final['adultBeds'] = 0;
		$final['childBeds'] = 0;
		$final['totalBeds'] = 0;
		$final['resList'] = array();
		$final['revenue'] = 0;		
		$final['totalPayment'] = 0;
	}
	unset($final);
	$resList = array();
	$grandTotalAdult = 0;
	$grandTotalChild = 0;
	$grandTotalRevenue = 0;
	
	foreach($list as $item) {
		$id1 = $item['id1'];
		$id2 = isset($item['id2']) ? $item['id2'] : "";
		if($showRevenueOption == "1") {
			$id3 = $item['rv_invoice_currency_id'];
		} else {
			$id3 = "";
		}

		if(!empty($rateOverride)) {
			switch($rateOverrideType) {
			default:
			case "excludeRes":
				$check = !reservationHasRateOverride($item['rv_reservation_ix']);
				break;
			case "includeRes":
				$check = reservationHasRateOverride($item['rv_reservation_ix']);
				break;
			case "excludeItem":
				$check = !reservationItemHasRateOverride($item['rv_reservation_item_ix']);
				break;
			case "includeItem":
				$check = reservationItemHasRateOverride($item['rv_reservation_item_ix']);
				break;
			}
			if(!$check) { continue; }

			if(empty($rateOverrideAgentGranted) || empty($rateOverrideAgentDenied)) {
				switch($rateOverrideType) {
				default:
				case "excludeRes":						
				case "includeRes":
					$check = reservationHasAgentRateOverride($item['rv_reservation_ix']);
					break;
				case "excludeItem":
				case "includeItem":
					$check = reservationItemHasAgentRate($item['rv_reservation_item_ix']);
					break;
				}
				if(!empty($rateOverrideAgentGranted)) { $check = !$check; }
				if(!$check) { continue; }
			}
		}
		
		if(!empty($amountOverride)) {
			switch($amountOverrideType) {
			default:
			case "excludeRes":
				$check = !reservationHasOverride($item['rv_reservation_ix']);
				break;
			case "includeRes":
				$check = reservationHasOverride($item['rv_reservation_ix']);
				break;
			case "excludeItem":
				$check = !reservationItemHasOverride($item['rv_reservation_item_ix']);
				break;
			case "includeItem":
				$check = reservationItemHasOverride($item['rv_reservation_item_ix']);
				break;
			}
			if(!$check) { continue; }
		}

		$compCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_comp WHERE rv_reservation_item_id = '$item[rv_reservation_item_ix]'",4);
		if($compCount < 1 && $excludeTBA) {
			continue;
		}
		if(trim($componentsFilter['ids']) != "") {
			$compExclude = $GLOBALS['lDB']->get("
				SELECT
					rv_res_item_comp.rv_item_comp_amt_nett,
					rv_res_item_comp.rv_item_comp_amt_gross,
					rv_res_item_comp.rv_item_comp_amt_payable,
					rv_res_item_comp.rv_item_comp_amt_tax
				FROM
					rv_res_item_comp
				WHERE
					rv_res_item_comp.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
					$componentsFilter[where]
			",2);
			foreach($compExclude as $excludeItem) {
				if($roomUpgrade == 1) {
					$item['rv_item_amt_nett'] -= round($excludeItem['rv_item_comp_amt_nett'] / $item['rv_item_accomm_count_orig'] * $item['rv_item_accomm_count'],2);
					$item['rv_item_amt_gross'] -= round($excludeItem['rv_item_comp_amt_gross'] / $item['rv_item_accomm_count_orig'] * $item['rv_item_accomm_count'],2);
					$item['rv_item_amt_payable'] -= round($excludeItem['rv_item_comp_amt_payable'] / $item['rv_item_accomm_count_orig'] * $item['rv_item_accomm_count'],2);
					$item['rv_item_amt_tax'] -= round($excludeItem['rv_item_comp_amt_tax'] / $item['rv_item_accomm_count_orig'] * $item['rv_item_accomm_count'],2);
				} else {
					$item['rv_item_amt_nett'] -= $excludeItem['rv_item_comp_amt_nett'];
					$item['rv_item_amt_gross'] -= $excludeItem['rv_item_comp_amt_gross'];
					$item['rv_item_amt_payable'] -= $excludeItem['rv_item_comp_amt_payable'];
					$item['rv_item_amt_tax'] -= $excludeItem['rv_item_comp_amt_tax'];
				}
			}
		}

		switch($commType) {
		default:
		case "nett":
			$baseRevenue = $item['rv_item_amt_nett'];
			break;
		case "gross":
			$baseRevenue = $item['rv_item_amt_gross'];
			break;
		case "payable":
			$baseRevenue = $item['rv_item_amt_payable'];
			break;
		}
		if($showTax != "1") {
			$baseRevenue -= $item['rv_item_amt_tax'];
		}
		$item1 =& $bedNightGrid[$id1];
		if(!is_array($item1)) {
			$item1 = array('resList'=>array());//$dateArray;
		}
		$item2 =& $bedNightGrid[$id1][$id2];
		if(!is_array($item2)) {
			$item2 = array('resList'=>array());
		}
		$item3 =& $bedNightGrid[$id1][$id2][$id3];
		if(!is_array($item3)) {
			$item3 = $dateArray;
			$item3['resList'] = array();
			foreach($item3 as $dateKey=>$dateItem) {
				if($dateKey === "resList") {
					continue;
				}
				$final =& $bedNightGrid[$id1][$id2][$id3][$dateKey];
				$final['adultBeds'] = 0;
				$final['childBeds'] = 0;
				$final['totalBeds'] = 0;
				$final['totalPayment'] = 0;
				$final['resList'] = array();
				$final['revenue'] = 0;
			}
			unset($final);
		}
		$revenueItem =& $revenueGrid[$item['rf_currency_symbol']];
		if(!is_array($revenueItem)) {
			$revenueItem = $dateArray;
			foreach($revenueItem as $dateKey=>$dateItem) {
				$revenueFinal =& $revenueItem[$dateKey];
				$revenueFinal['adultBeds'] = 0;
				$revenueFinal['childBeds'] = 0;
				$revenueFinal['totalBeds'] = 0;
				$revenueFinal['totalPayment'] = 0;
				$revenueFinal['resList'] = array();
				$revenueFinal['revenue'] = 0;
			}
		}
		
		foreach($item3 as $dateKey=>$dateItem) {
			if($dateKey === "resList") {
				continue;
			}
			$final =& $bedNightGrid[$id1][$id2][$id3][$dateKey];
			$revenueFinal =& $revenueItem[$dateKey];
			$itemStart = $item['rv_item_date_arrive'];
			list($itemEndYear, $itemEndMonth, $itemEndDay) = explode("-",$item['rv_item_date_depart']);
			$itemEnd = date("Y-m-d",mktime(0,0,0,$itemEndMonth,$itemEndDay-1,$itemEndYear));
			if($totalBy == "day") {
				$dateCheck = ($dateItem['start'] >= $itemStart && $dateItem['start'] <= $itemEnd)
					|| ($dateItem['end'] >= $itemStart && $dateItem['end'] <= $itemEnd)
					|| ($dateItem['start'] < $itemStart && $dateItem['end'] > $itemEnd);
			} else {
				$dateCheck = $item['fn_folio_date'] >= $dateItem['start'] && $item['fn_folio_date'] <= $dateItem['end'];
			}
			if($dateCheck) {
				array_push($resList,$item['rv_reservation_ix']);
				array_push($item1['resList'],$item['rv_reservation_ix']);
				array_push($item2['resList'],$item['rv_reservation_ix']);
				array_push($item3['resList'],$item['rv_reservation_ix']);
				// Find final start / ends
				if($totalBy == "day") {
					if($dateItem['start'] > $item['rv_item_date_arrive']) {
						$finalStart = $dateItem['start'];
					} else {
						$finalStart = $item['rv_item_date_arrive'];
					}
					if($dateItem['end'] < $item['rv_item_date_depart']) {
						$finalEnd = $dateItem['end'];
					} else {
						$finalEnd = $itemEnd;
					}
					$days = dateSubtract($finalEnd,$finalStart)+1;
					if($item['rv_item_nights'] != 0) {
						$revenue = $baseRevenue / $item['rv_item_nights'] * $days;
					} else {
						$revenue = 0;
					}
				} else {
					$days = $item['rv_item_nights'];
					$revenue = $baseRevenue;
				}

				$accomm = $item['rv_item_accomm_count'];
				if($nightType == "room") {
					$adults = 1;
					$children = 0;
				} else {
					$adults = $item['rv_item_adult_count'];
					$children = $item['rv_item_child_count'];
				}

				$adultBeds = $days * $accomm * $adults;
				$childBeds = $days * $accomm * $children;

				$final['adultBeds'] += $adultBeds;
				$final['childBeds'] += $childBeds;
				$grandTotalAdult += $adultBeds;
				$grandTotalChild += $childBeds;
				$potentialArray[$dateKey]['adultBeds'] += $adultBeds;
				$potentialArray[$dateKey]['childBeds'] += $childBeds;
				$potentialArray[$dateKey]['totalBeds'] += $adultBeds + $childBeds;
				array_push($final['resList'],$item['rv_reservation_ix']);
				if(!isset($potentialArray[$dateKey]['resList'])) {
					$potentialArray[$dateKey]['resList'] = array();
				}
				array_push($potentialArray[$dateKey]['resList'],$item['rv_reservation_ix']);
				$final['revenue'] += $revenue;
				$final['totalPayment'] += $item['totalPayment'];
				$grandTotalRevenue += $revenue;

				$revenueFinal['adultBeds'] += $adultBeds;
				$revenueFinal['childBeds'] += $childBeds;
				array_push($revenueFinal['resList'],$item['rv_reservation_ix']);
				$revenueFinal['revenue'] += $revenue;
				$revenueFinal['totalPayment'] += $item['totalPayment'];

				$monthFinal =& $monthTotals[$dateKey];
				$monthFinal['adultBeds'] += $adultBeds;
				$monthFinal['childBeds'] += $childBeds;
				array_push($monthFinal['resList'],$item['rv_reservation_ix']);
				$monthFinal['revenue'] += $revenue;
				$monthFinal['totalPayment'] += $item['totalPayment'];
				unset($monthFinal);
			}
		}
	}

	foreach($potentialArray as $dateKey=>$item) {
		if(isset($item['resList']) && is_array($item['resList'])) {
			$potentialArray[$dateKey]['resList'] = array_unique($item['resList']);
			$potentialArray[$dateKey]['resCount'] = sizeof($potentialArray[$dateKey]['resList']);
		}
	}
	//debug($potentialArray);
	$resList = array_unique($resList);
	$resCount = sizeof($resList);
	$grandTotal = $grandTotalAdult + $grandTotalChild;
	unset($item1);
	unset($item2);
	unset($item3);
	unset($revenueItem);
	unset($revenueFinal);
	unset($final);

	// Remove blanks and replace with 0's and calculate totals
	foreach($bedNightGrid as $id1=>$item1) {
		$level1Adult = 0;
		$level1Child = 0;
		$level1Total = 0;
		$level1Revenue = 0;
		$level1Payment = 0;
		$level1Yield = 0;
		$level1PercActual = 0;
		$level1PercTotal = 0;
		$level1PercRevenue = 0;
		$level1PercRes = 0;
		foreach($item1 as $id2=>$item2) {
			if($id2 === "resList") {
				continue;
			}
			$level2Adult = 0;
			$level2Child = 0;
			$level2Total = 0;
			$level2Revenue = 0;
			$level2Payment = 0;
			$level2Yield = 0;
			$level2PercActual = 0;
			$level2PercTotal = 0;
			$level2PercRevenue = 0;
			$level2PercRes = 0;
			foreach($item2 as $id3=>$item3) {
				if($id3 === "resList") {
					continue;
				}
				$level3Adult = 0;
				$level3Child = 0;
				$level3Total = 0;
				$level3Revenue = 0;
				$level3Payment = 0;
				$level3Yield = 0;
				$level3PercActual = 0;
				$level3PercTotal = 0;
				$level3PercRevenue = 0;
				$level3PercRes = 0;
				foreach($item3 as $totalKey=>$totals) {
					if($totalKey === "resList") {
						continue;
					}
					$total =& $bedNightGrid[$id1][$id2][$id3][$totalKey];
					if(trim($total['adultBeds']) == "") { $total['adultBeds'] = 0; }
					if(trim($total['childBeds']) == "") { $total['childBeds'] = 0; }
					$total['totalBeds'] = $total['adultBeds'] + $total['childBeds'];
					$total['resList'] = array_unique($total['resList']);
					$total['resCount'] = sizeof($total['resList']);
					if($total['totalBeds'] != 0) {
						$total['yield'] = $total['revenue'] / $total['totalBeds'];
					} else {
						$total['yield'] = 0;
					}
					if($potentialArray[$totalKey]['totalBeds'] != 0) {
						$total['percActual'] = $total['totalBeds'] / $potentialArray[$totalKey]['totalBeds'] * 100;
					} else {
						$total['percActual'] = 0;
					}
					if($nightType == "room") {		
						if($potentialArray[$totalKey]['roomCount'] != 0) {
							$total['percTotal'] = $total['totalBeds'] / $potentialArray[$totalKey]['roomCount'] * 100;
						} else {
							$total['percTotal'] = 0;
						}
					} else {
						if($potentialArray[$totalKey]['potentialBedNight'] != 0) {
							$total['percTotal'] = $total['totalBeds'] / $potentialArray[$totalKey]['potentialBedNight'] * 100;
						} else {
							$total['percTotal'] = 0;
						}
					}
					if($grandTotalRevenue != 0) {
						$total['percRevenue'] = $total['revenue'] / $grandTotalRevenue * 100;
					} else {
						$total['percRevenue'] = 0;
					}
					if(isset($potentialArray[$totalKey]['resCount']) && $potentialArray[$totalKey]['resCount'] != 0) {
						$total['percRes'] = $total['resCount'] / $potentialArray[$totalKey]['resCount'] * 100;
					} else {
						$total['percRes'] = 0;
					}

					$level3Adult += $total['adultBeds'];
					$level3Child += $total['childBeds'];
					$level3Total += $total['totalBeds'];
					$level3Revenue += $total['revenue'];
					$level3Payment += $total['totalPayment'];
					$level3Yield += $total['yield'];
					$level3PercActual += $total['percActual'];
					$level3PercTotal += $total['percTotal'];
					$level3PercRevenue += $total['percRevenue'];
					$level3PercRes = 0.47474;

					fixAmtDisplay($total['revenue'],2);
					fixAmtDisplay($total['totalPayment'],2);
					fixAmtDisplay($total['yield'],2);
					fixAmtDisplay($total['percActual'],2);
					fixAmtDisplay($total['percTotal'],2);
					fixAmtDisplay($total['percRevenue'],2);
					fixAmtDisplay($total['percRes'],2);
				}
				$total =& $bedNightGrid[$id1][$id2][$id3]['grandTotal'];

				if($level3Total != 0) {
					$level3Yield = $level3Revenue / $level3Total;
				} else {
					$level3Yield = 0;
				}
				

				$level3ResCount = sizeof(array_unique($bedNightGrid[$id1][$id2][$id3]['resList']));
				if($level3ResCount != 0) {
					$level3PercRes = $level3ResCount / $resCount * 100;
				} else {
					$level3PercRes = 0;
				}

				if($grandTotal != 0) {
					$level3PercActual = $level3Total / $grandTotal * 100;
				} else {
					$level3PercActual = 0;
				}
				if($nightType == "room") {		
					if($roomCountTotal != 0) {
						$level3PercTotal = $level3Total / $roomCountTotal * 100;
					} else {
						$level3PercTotal = 0;
					}
				} else {
					if($potentialBedNightTotal != 0) {
						$level3PercTotal = $level3Total / $potentialBedNightTotal * 100;
					} else {
						$level3PercTotal = 0;
					}
				}
				

				$level2Adult += $level3Adult;
				$level2Child += $level3Child;
				$level2Total += $level3Total;
				$level2Revenue += $level3Revenue;
				$level2Payment += $level3Payment;
				$level2Yield += $level3Yield;
				$level2PercActual += $level3PercActual;
				$level2PercTotal += $level3PercTotal;
				$level2PercRevenue += $level3PercRevenue;
				$level2PercRes += $level3PercRes;
				
				fixAmtDisplay($percTotal,2);
				fixAmtDisplay($level3Revenue,2);
				fixAmtDisplay($level3Payment,2);
				fixAmtDisplay($level3Yield,2);
				fixAmtDisplay($level3PercActual,2);
				fixAmtDisplay($level3PercTotal,2);
				fixAmtDisplay($level3PercRevenue,2);
				fixAmtDisplay($level3PercRes,2);

				$total['adultBeds'] = $level3Adult;
				$total['childBeds'] = $level3Child;
				$total['totalBeds'] = $level3Total;
				$total['resCount'] = sizeof(array_unique($bedNightGrid[$id1][$id2][$id3]['resList']));
				$total['revenue'] = $level3Revenue;
				$total['totalPayment'] = $level3Payment;
				$total['yield'] = $level3Yield;
				$total['percActual'] = $level3PercActual;
				$total['percTotal'] = $level3PercTotal;
				$total['percRevenue'] = $level3PercRevenue;
				$total['percRes'] = $level3PercRes;
			}
			$total =& $bedNightGrid[$id1][$id2]['grandTotal'];

			$level1Adult += $level2Adult;
			$level1Child += $level2Child;
			$level1Revenue += $level2Revenue;
			$level1Payment += $level2Payment;
			$level1Yield += $level2Yield;
			$level1PercActual += $level2PercActual;
			$level1PercTotal += $level2PercTotal;
			$level1PercRevenue += $level2PercRevenue;
			$level1PercRes += $level2PercRes;

			fixAmtDisplay($level2Revenue,2);
			fixAmtDisplay($level2Payment,2);
			fixAmtDisplay($level2Yield,2);
			fixAmtDisplay($level2PercActual,2);
			fixAmtDisplay($level2PercTotal,2);
			fixAmtDisplay($level2PercRevenue,2);
			fixAmtDisplay($level2PercRes,2);

			$total['adultBeds'] = $level2Adult;
			$total['childBeds'] = $level2Child;
			$total['totalBeds'] = $level2Total;
			$total['resCount'] = sizeof(array_unique($bedNightGrid[$id1][$id2]['resList']));
			$total['revenue'] = $level2Revenue;
			$total['totalPayment'] = $level2Payment;
			$total['yield'] = $level2Yield;
			$total['percActual'] = $level2PercActual;
			$total['percTotal'] = $level2PercTotal;
			$total['percRevenue'] = $level2PercRevenue;
			$total['percRes'] = $level2PercRes;

		}
		$total =& $bedNightGrid[$id1]['grandTotal'];

		fixAmtDisplay($level1Revenue,2);
		fixAmtDisplay($level1Payment,2);
		fixAmtDisplay($level1Yield,2);
		fixAmtDisplay($level1PercActual,2);
		fixAmtDisplay($level1PercTotal,2);
		fixAmtDisplay($level1PercRevenue,2);
		fixAmtDisplay($level1PercRes,2);

		$total['adultBeds'] = $level1Adult;
		$total['childBeds'] = $level1Child;
		$total['totalBeds'] = $level1Total;
		$total['resCount'] = sizeof(array_unique($bedNightGrid[$id1]['resList']));
		$total['revenue'] = $level1Revenue;
		$total['totalPayment'] = $level1Payment;
		$total['yield'] = $level1Yield;
		$total['percActual'] = $level1PercActual;
		$total['percTotal'] = $level1PercTotal;
		$total['percRevenue'] = $level1PercRevenue;
		$total['percRes'] = $level1PercRes;
	}
	unset($total);
	// Apply Sorting...
	foreach($bedNightGrid as $id1=>$item1) {
		if($id1 === "grandTotal" || $id1 === "resList") { 
			continue;
		}
		foreach($item1 as $id2=>$item2) {
			if($id2 === "grandTotal" || $id2 === "resList") { 
				continue;
			}
			foreach($item2 as $id3=>$item3) {
				if($id3 === "grandTotal" || $id3 === "resList") { 
					continue;
				}
				$item =& $bedNightGrid[$id1][$id2][$id3];
				$item['id'] = $id3;
				if($showRevenueOption == "1") {
					$item['name'] = $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$id3'",4);
				} else {
					$item['name'] = "n/a";
				}
			}
			$item =& $bedNightGrid[$id1][$id2];
			$item['id'] = $id2;
			if(trim($id2) == "" || $id2 == "0") {
				$item['name'] = $level2SQL['blankDesc'];
			} else {
				foreach($groupByList as $groupItem) {
					if($groupItem['id2'] == $id2) {
						$item['name'] = $groupItem['name2'];
					}
				}
			}
		}
		$item =& $bedNightGrid[$id1];
		$item['id'] = $id1;
		if(trim($id1) == "" || $id1 == "0") {
			$item['name'] = $level1SQL['blankDesc'];
		} else {
			foreach($groupByList as $groupItem) {
				if($groupItem['id1'] == $id1) {
					$item['name'] = $groupItem['name1'];
				}
			}
		}
	}
	unset($item);
	function sortNameDsc($a, $b) {
		if($a['name'] == $b['name']) { return 0; }
		if($a['name'] > $b['name']) {
			return 1;
		} else {
			return -1;
		}
	}
	
	function sortNameAsc($a, $b) {
		if($a['name'] == $b['name']) { return 0; }
		if($a['name'] > $b['name']) {
			return -1;
		} else {
			return 1;
		}
	}

	function sortPercDsc($a, $b) {
		if($a['grandTotal']['percTotal'] == $b['grandTotal']['percTotal']) { return 0; }
		if($a['grandTotal']['percTotal'] > $b['grandTotal']['percTotal']) {
			return 1;
		} else {
			return -1;
		}
	}

	function sortPercAsc($a, $b) {
		if($a['grandTotal']['percTotal'] == $b['grandTotal']['percTotal']) { return 0; }
		if($a['grandTotal']['percTotal'] > $b['grandTotal']['percTotal']) {
			return -1;
		} else {
			return 1;
		}
	}

	function sortBedNightsDsc($a, $b) {
		$aTotal = $a['grandTotal']['adultBeds'] + $a['grandTotal']['childBeds'];
		$bTotal = $b['grandTotal']['adultBeds'] + $b['grandTotal']['childBeds'];
		if($aTotal == $bTotal) { return 0; }
		if($aTotal > $bTotal) {
			return 1;
		} else {
			return -1;
		}
	}

	function sortBedNightsAsc($a, $b) {
		$aTotal = $a['grandTotal']['adultBeds'] + $a['grandTotal']['childBeds'];
		$bTotal = $b['grandTotal']['adultBeds'] + $b['grandTotal']['childBeds'];
		if($aTotal == $bTotal) { return 0; }
		if($aTotal > $bTotal) {
			return -1;
		} else {
			return 1;
		}
	}

	function sortRevenueDsc($a, $b) {
		if($a['grandTotal']['revenue'] == $b['grandTotal']['revenue']) { return 0; }
		if($a['grandTotal']['revenue'] > $b['grandTotal']['revenue']) {
			return 1;
		} else {
			return -1;
		}
	}
	
	function sortRevenueAsc($a, $b) {
		if($a['grandTotal']['revenue'] == $b['grandTotal']['revenue']) { return 0; }
		if($a['grandTotal']['revenue'] > $b['grandTotal']['revenue']) {
			return -1;
		} else {
			return 1;
		}
	}

//	debug($bedNightGrid);
	switch($sortBy) {
		case 1:
			usort($bedNightGrid, "sortNameDsc");
			break;
		case 2:
			usort($bedNightGrid, "sortNameAsc");
			break;
		case 3:
			usort($bedNightGrid, "sortPercDsc");
			break;
		case 4:
			usort($bedNightGrid, "sortPercAsc");
			break;
		case 5:
			usort($bedNightGrid, "sortBedNightsDsc");
			break;
		case 6:
			usort($bedNightGrid, "sortBedNightsAsc");
			break;
		case 7:
			usort($bedNightGrid, "sortRevenueDsc");
			break;
		case 8:
			usort($bedNightGrid, "sortRevenueAsc");
			break;
	}


	foreach($revenueGrid as $revenueKey=>$revenueItem) {
		$revenueAdult = 0;
		$revenueChild = 0;
		$revenueTotal = 0;
		$revenueRevenue = 0;
		$revenuePayment = 0;
		$revenueYield = 0;
		$revenuePercActual = 0;
		$revenuePercTotal = 0;
		$revenuePercRevenue = 0;
		$revenuePercRes = 0;
		$revenueRes = 0;
		foreach($revenueItem as $dateKey=>$dateItem) {
			$total =& $revenueGrid[$revenueKey][$dateKey];

			if(trim($total['adultBeds']) == "") { $total['adultBeds'] = 0; }
			if(trim($total['childBeds']) == "") { $total['childBeds'] = 0; }
			$total['totalBeds'] = $total['adultBeds'] + $total['childBeds'];
			$total['resList'] = array_unique($total['resList']);
			$total['resCount'] = sizeof($total['resList']);
			if($total['totalBeds'] != 0) {
				$total['yield'] = $total['revenue'] / $total['totalBeds'];
			} else {
				$total['yield'] = 0;
			}
			if($potentialArray[$dateKey]['totalBeds'] != 0) {
				$total['percActual'] = $total['totalBeds'] / $potentialArray[$dateKey]['totalBeds'] * 100;
			} else {
				$total['percActual'] = 0;
			}
			if($nightType == "room") {		
				if($potentialArray[$dateKey]['roomCount'] != 0) {
					$total['percTotal'] = $total['totalBeds'] / $potentialArray[$dateKey]['roomCount'] * 100;
				} else {
					$total['percTotal'] = 0;
				}
			} else {
				if($potentialArray[$dateKey]['potentialBedNight'] != 0) {
					$total['percTotal'] = $total['totalBeds'] / $potentialArray[$dateKey]['potentialBedNight'] * 100;
				} else {
					$total['percTotal'] = 0;
				}
			}
			if($grandTotalRevenue != 0) {
				$total['percRevenue'] = $total['revenue'] / $grandTotalRevenue * 100;
			} else {
				$total['percRevenue'] = 0;
			}
			if(isset($potentialArray[$dateKey]['resCount']) && $potentialArray[$dateKey]['resCount'] != 0) {
				$total['percRes'] = $total['resCount'] / $potentialArray[$dateKey]['resCount'] * 100;
			} else {
				$total['percRes'] = 0;
			}

			$revenueAdult += $total['adultBeds'];
			$revenueChild += $total['childBeds'];
			$revenueTotal += $total['totalBeds'];
			$revenueRevenue += $total['revenue'];
			$revenuePayment += $total['totalPayment'];
			$revenueYield += $total['yield'];
			$revenuePercActual += $total['percActual'];
			$revenuePercTotal += $total['percTotal'];
			$revenuePercRevenue += $total['percRevenue'];

			fixAmtDisplay($total['revenue'],2);
			fixAmtDisplay($total['totalPayment'],2);
			fixAmtDisplay($total['yield'],2);
			fixAmtDisplay($total['percActual'],2);
			fixAmtDisplay($total['percTotal'],2);
			fixAmtDisplay($total['percRevenue'],2);
			fixAmtDisplay($total['percRes'],2);
		}
		unset($total);
		$total =& $revenueGrid[$revenueKey]['grandTotal'];

		if($revenueTotal != 0) {
			$revenueYield = $revenueRevenue / $revenueTotal;
		} else {
			$revenueYield = 0;
		}
		if($grandTotal != 0) {
			$revenuePercActual = $revenueTotal / $grandTotal * 100;
		} else {
			$revenuePercActual = 0;
		}
		if($nightType == "room") {		
			if($roomCountTotal != 0) {
				$revenuePercTotal = $revenueTotal / $roomCountTotal * 100;
			} else {
				$revenuePercTotal = 0;
			}
		} else {
			if($potentialBedNightTotal != 0) {
				$revenuePercTotal = $revenueTotal / $potentialBedNightTotal * 100;
			} else {
				$revenuePercTotal = 0;
			}
		}
		

		fixAmtDisplay($revenueRevenue,2);
		fixAmtDisplay($revenuePayment,2);
		fixAmtDisplay($revenueYield,2);
		fixAmtDisplay($revenuePercActual,2);
		fixAmtDisplay($revenuePercTotal,2);
		fixAmtDisplay($revenuePercRevenue,2);
		fixAmtDisplay($revenuePercRes,2);

		$total['adultBeds'] = $revenueAdult;
		$total['childBeds'] = $revenueChild;
		$total['totalBeds'] = $revenueTotal;
		$total['revenue'] = $revenueRevenue;
		$total['totalPayment'] = $revenuePayment;
		$total['yield'] = $revenueYield;
		$total['percActual'] = $revenuePercActual;
		$total['percTotal'] = $revenuePercTotal;
		$total['percRevenue'] = $revenuePercRevenue;

		$total['resCount'] = "";
		$total['percRes'] = "";
		//$total['percRes'] = $revenuePercRes;
	}
	unset($total);

	$monthAdult = 0;
	$monthChild = 0;
	$monthTotal = 0;
	$monthmonth = 0;
	$monthYield = 0;
	$monthRevenue = 0;
	$monthPayment = 0;
	$monthPercActual = 0;
	$monthPercTotal = 0;
	$monthPercRevenue = 0;
	$monthPercRes = 0;
	foreach($monthTotals as $dateKey=>$dateItem) {
		$total =& $monthTotals[$dateKey];

		if(trim($total['adultBeds']) == "") { $total['adultBeds'] = 0; }
		if(trim($total['childBeds']) == "") { $total['childBeds'] = 0; }
		$total['totalBeds'] = $total['adultBeds'] + $total['childBeds'];
		$total['resList'] = array_unique($total['resList']);
		$total['resCount'] = sizeof($total['resList']);
		if($total['totalBeds'] != 0) {
			$total['yield'] = $total['revenue'] / $total['totalBeds'];
		} else {
			$total['yield'] = 0;
		}
		if($potentialArray[$dateKey]['totalBeds'] != 0) {
			$total['percActual'] = $total['totalBeds'] / $potentialArray[$dateKey]['totalBeds'] * 100;
		} else {
			$total['percActual'] = 0;
		}
		if($nightType == "room") {		
			if($potentialArray[$dateKey]['roomCount'] != 0) {
				$total['percTotal'] = $total['totalBeds'] / $potentialArray[$dateKey]['roomCount'] * 100;
			} else {
				$total['percTotal'] = 0;
			}
		} else {
			if($potentialArray[$dateKey]['potentialBedNight'] != 0) {
				$total['percTotal'] = $total['totalBeds'] / $potentialArray[$dateKey]['potentialBedNight'] * 100;
			} else {
				$total['percTotal'] = 0;
			}
		}
		if($grandTotalRevenue != 0) {
			$total['percRevenue'] = $total['revenue'] / $grandTotalRevenue * 100;
		} else {
			$total['percRevenue'] = 0;
		}
		if(isset($potentialArray[$dateKey]['resCount']) && $potentialArray[$dateKey]['resCount'] != 0) {
			$total['percRes'] = $total['resCount'] / $potentialArray[$dateKey]['resCount'] * 100;
		} else {
			$total['percRes'] = 0;
		}

		$monthAdult += $total['adultBeds'];
		$monthChild += $total['childBeds'];
		$monthTotal += $total['totalBeds'];
		$monthRevenue += $total['revenue'];
		$monthPayment += $total['totalPayment'];
		$monthYield += $total['yield'];
		$monthPercActual += $total['percActual'];
		$monthPercTotal += $total['percTotal'];
		$monthPercRevenue += $total['percRevenue'];

		fixAmtDisplay($total['revenue'],2);
		fixAmtDisplay($total['totalPayment'],2);
		fixAmtDisplay($total['yield'],2);
		fixAmtDisplay($total['percActual'],2);
		fixAmtDisplay($total['percTotal'],2);
		fixAmtDisplay($total['percRevenue'],2);
		fixAmtDisplay($total['percRes'],2);
	}
	unset($total);

	$total =& $monthTotals['grandTotal'];

	$monthPercRes = 100;

	if($grandTotal != 0) {
		$monthPercActual = $monthTotal / $grandTotal * 100;
	} else {
		$monthPercActual = 0;
	}
	if($nightType == "room") {		
		if($roomCountTotal != 0) {
			$monthPercTotal = $monthTotal / $roomCountTotal * 100;
		} else {
			$monthPercTotal = 0;
		}
	} else {
		if($potentialBedNightTotal != 0) {
			$monthPercTotal = $monthTotal / $potentialBedNightTotal * 100;
		} else {
			$monthPercTotal = 0;
		}
	}
	

	fixAmtDisplay($monthRevenue,2);
	fixAmtDisplay($monthYield,2);
	fixAmtDisplay($monthPayment,2);
	fixAmtDisplay($monthPercActual,2);
	fixAmtDisplay($monthPercTotal,2);
	fixAmtDisplay($monthPercRevenue,2);
	fixAmtDisplay($monthPercRes,2);

	$total['adultBeds'] = $monthAdult;
	$total['childBeds'] = $monthChild;
	$total['totalBeds'] = $monthTotal;
	$total['resCount'] = $resCount;
	$total['revenue'] = $monthRevenue;
	$total['totalPayment'] = $monthPayment;
	$total['yield'] = $monthYield;
	$total['percActual'] = $monthPercActual;
	$total['percTotal'] = $monthPercTotal;
	$total['percRevenue'] = $monthPercRevenue;
	$total['percRes'] = $monthPercRes;

	unset($total);
	

	$args = array_slice($_SERVER['argv'],1,41);
	$argList = join("+",$args);

	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));


		$headRows1 = "";
		$headRows2 = "";
		$headRows3 = "";
		$rows = "";
		$colspan = 5;
		$bedColSpan = "1";
		if($showRoomConfig == "1") {
			$colspan += 2;
			$bedColSpan = "3";
		}
		if($showRevenueOption == "1") {
			$colspan += 2;
		}
		if($includePayment == "1") {
			$colspan += 1;
		}
		$currRowCount = 0;
		foreach($bedNightGrid as $id1=>$item1) {
			$name1 = $item1['name'];
			$clickId1 = $item1['id'];
			if(trim($clickId1) == "") {
				$clickId1 = "0";
			}
			$overlibName1 = t_encodeOverlib($name1);
			if(strlen($name1) > 20) {
				$name1 = substr($name1,0,18) . "...";
			}
			$finalName1 = $name1;
			$currRowCount++;
			foreach($item1 as $id2=>$item2) {
				if($id2 === "id" || $id2 === "name" || $id2 === "grandTotal" || $id2 === "resList") {
					continue;
				} 
				$name2 = $item2['name'];
				$clickId2 = $item2['id'];
				if(trim($clickId2) == "") {
					$clickId2 = "0";
				}
				$overlibName2 = t_encodeOverlib($name2);
				if(strlen($name2) > 20) {
					$name2 = substr($name2,0,18) . "...";
				}	
				$finalName2 = $name2;
				foreach($item2 as $id3=>$item3) {
					if($id3 === "id" || $id3 === "name" || $id3 === "grandTotal" || $id3 === "resList") {
						continue;
					} 
					$name3 = $item3['name'];
					$clickId3 = $item3['id'];
					$clickId3 = "$item1[id]+$item2[id]+$item3[id]";
					if(trim($clickId3) == "") {
						$clickId3 = "0";
					}
					$overlibName3 = t_encodeOverlib($name3);
					if(strlen($name3) > 20) {
						$name3 = substr($name3,0,18) . "...";
					}	
					$headRows1 .= "
						<tr>
							<td height=\"18\" class=\"outLt\" style=\"cursor: pointer; white-space: nowrap\" onclick=\"openDetailPopup('" . $argList . "+row+" . $clickId3 . "');\" onmouseover=\"rowOn(" . $currRowCount . "); overlib('" . $overlibName1 . "',WIDTH,100);\" onmouseout=\"rowOff(" . $currRowCount . "); nd();\" nowrap>" . $finalName1 . "</td>
						</tr>
					 ";
					$headRows2 .= "
						<tr>
							<td height=\"18\" class=\"outLt\" style=\"cursor: pointer; white-space: nowrap\" onclick=\"openDetailPopup('" . $argList . "+row+" . $clickId3 . "');\" onmouseover=\"rowOn(" . $currRowCount . "); overlib('" . $overlibName2 . "',WIDTH,100);\" onmouseout=\"rowOff(" . $currRowCount . "); nd();\" nowrap>" . $finalName2 . "</td>
						</tr>
					";
					$headRows3 .= "
						<tr>
							<td height=\"18\" class=\"outLt\" style=\"cursor: pointer; white-space: nowrap\" onclick=\"openDetailPopup('" . $argList . "+row+" . $clickId3 . "');\" onmouseover=\"rowOn(" . $currRowCount . ");\" onmouseout=\"rowOff(" . $currRowCount . ");\" nowrap>" . $name3 . "</td>
						</tr>
					";
					$rows .= "
						<tr id=\"groupRow" . $currRowCount . "\">
					";
					$currColCount = 0;
					if($showTotal != "1") {
						foreach($item3 as $cellId=>$cell) {
							if(!is_array($cell) || $cellId === "grandTotal" || $cellId === "resList") {
								continue;
							}
							$adult = $cell['adultBeds'];
							$child = $cell['childBeds'];
							$total = $cell['totalBeds'];
							if($showRoomConfig == "1") {
								$rows .= "
								<td id=\"groupCellR".$currRowCount."C".$currColCount."A\" height=\"18\" align=\"right\" class=\"br bb\">$adult&nbsp;</td>
								<td id=\"groupCellR".$currRowCount."C".$currColCount."B\" height=\"18\" align=\"right\" class=\"br bb\">$child&nbsp;</td>
								";
							}
							$rows .= "
								<td id=\"groupCellR".$currRowCount."C".$currColCount."C\" height=\"18\" align=\"right\" class=\"br bb\">$total&nbsp;</td>
								<td id=\"groupCellR".$currRowCount."C".$currColCount."D\" height=\"18\" align=\"right\" class=\"br bb\">$cell[resCount]&nbsp;</td>
							";
							if($showRevenueOption == "1") {
								$rows .= "
									<td id=\"groupCellR".$currRowCount."C".$currColCount."E\" height=\"18\" align=\"right\" class=\"br bb\">$cell[revenue]&nbsp;</td>
								";
							}
							if($includePayment == "1") {
								$rows .= "
									<td id=\"groupCellR".$currRowCount."C".$currColCount."F\" height=\"18\" align=\"right\" class=\"br bb colGry\">$cell[totalPayment]&nbsp;</td>
								";
							}
							if($showRevenueOption == "1") {
								$rows .= "
									<td id=\"groupCellR".$currRowCount."C".$currColCount."G\" height=\"18\" align=\"right\" class=\"br bb\">$cell[yield]&nbsp;</td>
								";
							}
							$rows .="
								<td id=\"groupCellR".$currRowCount."C".$currColCount."H\" height=\"18\" align=\"right\" class=\"br bb\">$cell[percActual]&nbsp;</td>
								<td id=\"groupCellR".$currRowCount."C".$currColCount."I\" height=\"18\" align=\"right\" class=\"br bb\">$cell[percTotal]&nbsp;</td>
								<td id=\"groupCellR".$currRowCount."C".$currColCount."J\" height=\"18\" align=\"right\" class=\"br bb\">$cell[percRes]&nbsp;</td>
							";
							$currColCount++;
						}
					}
					if($showRoomConfig == "1") {
						$rows .= "
				 		<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['adultBeds']."&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['childBeds']."&nbsp;</td>
						";
					}
					$rows .= "
						<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['totalBeds']."&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['resCount']."&nbsp;</td>
					";
					if($showRevenueOption == "1") {
						$rows .= "
							<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['revenue']."&nbsp;</td>
						";
					}
					if($includePayment == "1") {
						$rows .= "
							<td height=\"18\" align=\"right\" class=\"br bb colGry\">".$item3['grandTotal']['totalPayment']."&nbsp;</td>
						";
					}
					if($showRevenueOption == "1") {
						$rows .= "
							<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['yield']."&nbsp;</td>
						";
					}
					$rows .= "
						<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['percActual']."&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['percTotal']."&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">".$item3['grandTotal']['percRes']."&nbsp;</td>
					    <td align=\"right\" class=\"br bb\">".$item2['grandTotal']['percTotal']."%&nbsp;</td>                    
				  	</tr>
					";
					$currRowCount++;
					$finalName2 = "&nbsp;";
				}
				$finalName1 = "&nbsp;";
			}
		}
		$GLOBALS['temp']['groupHeadRows1'] = $headRows1;
		$GLOBALS['temp']['groupHeadRows2'] = $headRows2;
		$GLOBALS['temp']['groupHeadRows3'] = $headRows3;
		$GLOBALS['temp']['groupRows'] = $rows;
		
		$colListHead = "";
		$colList = "";
		$colListRevenue = "";

		$dateCol1 = "<tr>";
		$dateCol2 = "<tr>";
		$dateCol3 = "<tr>";

		$blankHeadRow = "
		  <tr>
	    	<td class=\"outLt\" height=\"18\">&nbsp;</td>
		  </tr>
		";
		$blankRow = "
		  <tr>
		";
		$revenueFiller = "";

		$currColCount = 0;
		if($showTotal != "1") {
			foreach($dateArray as $dateItem) {
				list($year,$month,$day) = explode("-",$dateItem['start']);
				$monthFmt = date("F Y",mktime(0,0,0,$month,$day,$year));
				if($showRoomConfig == "1") {			
					$colListHead .= "
					<col width=\"30\" />
					<col width=\"30\" />
					";
				}
				$colListHead .= "
					<col width=\"55\" />
					<col width=\"60\" />
				";
				if($showRevenueOption == "1") {
					$colListHead .= "
						<col width=\"60\" />
					";
				}
				if($includePayment == "1") {
					$colListHead .= "
						<col width=\"60\" />
					";
				}
				if($showRevenueOption == "1") {
					$colListHead .= "
						<col width=\"60\" />
					";
				}
				$colListHead .= "
					<col width=\"60\" />
					<col width=\"60\" />
					<col width=\"60\" />
				";
				$colList .= "
					<colgroup id=\"groupCol$currColCount\">
				";
				if($showRoomConfig == "1") {			
					$colList .= "
					<col width=\"30\" />
					<col width=\"30\" />
					";
				}
				$colList .= "
					<col width=\"55\" />
					<col width=\"60\" />
				";
				if($showRevenueOption == "1") {
					$colList .= "
						<col width=\"60\" />
					";
				}
				if($includePayment == "1") {
					$colList .= "
						<col width=\"60\" />
					";
				}
				if($showRevenueOption == "1") {
					$colList .= "
						<col width=\"60\" />
					";
				}
				$colList .= "
					<col width=\"60\" />
					<col width=\"60\" />
					<col width=\"60\" />
					</colgroup>
				";
				$colListRevenue .= "
					<colgroup id=\"revenueCol$currColCount\">
				";
				if($showRoomConfig == "1") {			
					$colListRevenue .= "
					<col width=\"30\" />
					<col width=\"30\" />
					";
				}
				$colListRevenue .= "
					<col width=\"55\" />
					<col width=\"60\" />
				";
				if($showRevenueOption == "1") {
					$colListRevenue .= "
						<col width=\"60\" />
					";
				}
				if($includePayment == "1") {
					$colListRevenue .= "
						<col width=\"60\" />
					";
				}
				if($showRevenueOption == "1") {
					$colListRevenue .= "
						<col width=\"60\" />
					";
				}
				$colListRevenue .= "
					<col width=\"60\" />
					<col width=\"60\" />
					<col width=\"60\" />
					</colgroup>
				";
				if($showTotal != "1") {
					$dateCol1 .= "
						<td colspan=\"$colspan\" align=\"center\" class=\"outDk\" style=\"cursor:pointer;\" onclick=\"openDetailPopup('" . $argList . "+col+" . $dateItem['start'] . "++');\" onmouseover=\"colOn($currColCount);\" onmouseout=\"colOff($currColCount);\">$monthFmt</td>
					";
				}
				$dateCol2 .= "
					<td colspan=\"$bedColSpan\" align=\"center\" class=\"outDk\">$nightLabel nights</td>
					<td rowspan=\"2\" align=\"right\" class=\"outDk\">Res<br />Count</td>
				";
				if($showRevenueOption == "1") {
					$dateCol2 .= "
						<td rowspan=\"2\" align=\"right\" class=\"outDk\">Revenue</td>
					";
				}
				if($includePayment == "1") {
					$dateCol2 .= "
						<td rowspan=\"2\" align=\"right\" class=\"outDk\">Payments Received</td>
					";
				}
				if($showRevenueOption == "1") {
					$dateCol2 .= "
						<td rowspan=\"2\" align=\"right\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showYieldOverlib();\">Yield</td>
					";
				}
				if($nightType == "room") {
					$dateCol2 .= "
						<td rowspan=\"2\" align=\"right\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showActualRoomNightsOverlib();\">% of<br />act r/n</td>
						<td rowspan=\"2\" align=\"right\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showPotentialRoomNightsColOverlib();\">% of<br />pot r/n</td>
					";
				} else {
					$dateCol2 .= "
						<td rowspan=\"2\" align=\"right\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showActualBedNightsOverlib();\">% of<br />act b/n</td>
						<td rowspan=\"2\" align=\"right\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showPotentialBedNightsColOverlib();\">% of<br />pot b/n</td>
					";
				}				
				$dateCol2 .= "
					<td rowspan=\"2\" align=\"right\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showResOverlib();\">% of<br />res</td>
				";
				if($showRoomConfig == "1") {			
					$dateCol3 .= "
					<td align=\"right\" class=\"outDk\">Ad&nbsp;</td>
					<td align=\"right\" class=\"outDk\">Ch&nbsp;</td>
					";
				}
				$dateCol3 .= "
					<td align=\"right\" class=\"outDk\">Total&nbsp;</td>
				";
				if($showRoomConfig == "1") {			
					$blankRow .= "
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					";
				}
				$blankRow .= "
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				";
				if($showRevenueOption == "1") {
					$blankRow .= "
						<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					";
				}
				if($includePayment == "1") {
					$blankRow .= "
						<td height=\"18\" align=\"center\" class=\"br bb colGry\">&nbsp;</td>
					";
				}
				if($showRevenueOption == "1") {
					$blankRow .= "
						<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					";
				}
				$blankRow .= "
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				";
				if($showRoomConfig == "1") {			
					$revenueFiller .= "
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
					";
				}
				$revenueFiller .= "
					<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				";
				$currColCount++;
			}
		}

		if($showRoomConfig == "1") {			
			$colListHead .= "
			<col width=\"30\" />
			<col width=\"30\" />
			";
		}
		$colListHead .= "
			<col width=\"55\" />
			<col width=\"60\" />
		";
		if($showRevenueOption == "1") {
			$colListHead .= "
				<col width=\"60\" />
			";
		}
		if($includePayment == "1") {
			$colListHead .= "
				<col width=\"60\" />
			";
		}
		if($showRevenueOption == "1") {
			$colListHead .= "
				<col width=\"60\" />
			";
		}
		$colListHead .= "
			<col width=\"60\" />
			<col width=\"60\" />
			<col width=\"60\" />
			<col width=\"55\" />
		";
		if($showRoomConfig == "1") {			
			$colList .= "
			<col width=\"30\" />
			<col width=\"30\" />
			";
		}
		$colList .= "
			<col width=\"55\" />
			<col width=\"60\" />
		";
		if($showRevenueOption == "1") {
			$colList .= "
				<col width=\"60\" />
			";
		}
		if($includePayment == "1") {
			$colList .= "
				<col width=\"60\" />
			";
		}
		if($showRevenueOption == "1") {
			$colList .= "
				<col width=\"60\" />
			";
		}
		$colList .= "
			<col width=\"60\" />
			<col width=\"60\" />
			<col width=\"60\" />
			<col width=\"55\" />
		";		
		if($showRoomConfig == "1") {			
			$colListRevenue .= "
			<col width=\"30\" />
			<col width=\"30\" />
			";
		}
		$colListRevenue .= "
			<col width=\"55\" />
			<col width=\"60\" />
		";
		if($showRevenueOption == "1") {
			$colListRevenue .= "
				<col width=\"60\" />
			";
		}
		if($includePayment == "1") {
			$colListRevenue .= "
				<col width=\"60\" />
			";
		}
		if($showRevenueOption == "1") {
			$colListRevenue .= "
				<col width=\"60\" />
			";
		}
		if($includePayment == "1") {
			$colListRevenue .= "
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"55\" />
			";
		} else {
			$colListRevenue .= "
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"60\" />
				<col width=\"55\" />
			";
		}


		$dateCol1 .= "
  			<td colspan=\"$colspan\" align=\"right\" class=\"outDk\">Total&nbsp;</td>
	    	<td rowspan=\"3\" align=\"right\" class=\"outDk\">% of Pot.<img class=\"imgLink printCollapse\" src=\"images/arrow_ascend_".$GLOBALS['temp']['imgSort3Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(3);\"><img class=\"imgLink printCollapse\" src=\"images/arrow_descend_".$GLOBALS['temp']['imgSort4Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(4);\"></td>
		  </tr>
		  ";
		$dateCol2 .= "
				<td colspan=\"$bedColSpan\" align=\"center\" class=\"outDk\">$nightLabel nights</td>
				<td rowspan=\"2\" class=\"outDk\">Res<br />Count</td>
		";
		if($showRevenueOption == "1") {
			$dateCol2 .= "
				<td rowspan=\"2\" class=\"outDk\">Revenue<br /><img class=\"imgLink printCollapse\" src=\"images/arrow_ascend_".$GLOBALS['temp']['imgSort7Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(7);\"><img class=\"imgLink printCollapse\" src=\"images/arrow_descend_".$GLOBALS['temp']['imgSort8Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(8);\"></td>
			";
		}
		if($includePayment == "1") {
			$dateCol2 .= "
				<td rowspan=\"2\" class=\"outDk\">Payments Received</td>
			";
		}
		if($showRevenueOption == "1") {
			$dateCol2 .= "
				<td rowspan=\"2\" class=\"outDk\">Yield</td>
			";
		}
		if($nightType == "room") {		
			$dateCol2 .= "
					<td rowspan=\"2\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showActualRoomNightsOverlib();\">% of<br />act r/n</td>
					<td rowspan=\"2\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showPotentialRoomNightsColOverlib();\">% of<br />pot r/n</td>
			";
		} else {
			$dateCol2 .= "
					<td rowspan=\"2\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showActualBedNightsOverlib();\">% of<br />act b/n</td>
					<td rowspan=\"2\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showPotentialBedNightsColOverlib();\">% of<br />pot b/n</td>
			";
		}
		$dateCol2 .= "
				<td rowspan=\"2\" class=\"outDk\" onmouseout=\"nd();\" onmouseover=\"showResOverlib();\">% of<br />res</td>
			</tr>
		";
		if($showRoomConfig == "1") {			
			$dateCol3 .= "
			  	<td align=\"right\" class=\"outDk\">Ad&nbsp;</td>
				<td align=\"right\" class=\"outDk\">Ch&nbsp;</td>
			";
		}
		$dateCol3 .= "
		  		<td align=\"right\" class=\"outDk\">Total&nbsp;<img class=\"imgLink printCollapse\" src=\"images/arrow_ascend_".$GLOBALS['temp']['imgSort5Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(5);\"><img class=\"imgLink printCollapse\" src=\"images/arrow_descend_".$GLOBALS['temp']['imgSort6Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(6);\"></td>
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$blankRow .= "
			  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
			";
		}
		$blankRow .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
		";
		if($showRevenueOption == "1") {
			$blankRow .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
			";
		}
		if($includePayment == "1") {
			$blankRow .= "
				<td align=\"right\" class=\"br bb colGry\">&nbsp;</td>
			";
		}
		if($showRevenueOption == "1") {
			$blankRow .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
			";
		}
		$blankRow .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
	    	<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>  
		";
		if($showRoomConfig == "1") {			
			$revenueFiller .= "
			  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
			";
		}
		$revenueFiller .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
    		<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>  
		";

		$GLOBALS['temp']['colListHead'] = $colListHead;
		$GLOBALS['temp']['colList'] = $colList;
		$GLOBALS['temp']['colListRevenue'] = $colListRevenue;
		$GLOBALS['temp']['dateCol1'] = $dateCol1;
		$GLOBALS['temp']['dateCol2'] = $dateCol2;
		$GLOBALS['temp']['dateCol3'] = $dateCol3;
		$GLOBALS['temp']['blankHeadRow'] = $blankHeadRow;
		$GLOBALS['temp']['blankRow'] = $blankRow;
		$GLOBALS['temp']['revenueFiller'] = $revenueFiller;


		$revHeadRow = "";
		$revRow = "";
		foreach($revenueGrid as $id=>$item) {
			$revHeadRow .= "
				<tr>
					<td height=\"18\" class=\"outLt\" width=\"280\" colspan=\"2\"><span style=\"width:30;\">&nbsp;</span></td>
					<td height=\"18\" class=\"outLt\" width=\"50\"><span style=\"width:30;\">$id</span></td>
				</tr>
			";
			$revRow .= "
				<tr>
			";
			if($showTotal != "1") {
				foreach($item as $totalKey=>$totals) {
					if($totalKey !== "grandTotal" && $totalKey !== "name"  && $totalKey !== "id") {
						if($showRoomConfig == "1") {
							$revRow .= "
								<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['adultBeds'] . "&nbsp;</td>					
								<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['childBeds'] . "&nbsp;</td>
							";
						}
						$revRow .= "
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['totalBeds'] . "&nbsp;</td>
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['resCount'] . "&nbsp;</td>
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['revenue'] . "&nbsp;</td>
						";

						if($includePayment == "1") {
							$revRow .= "
								<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb colGry\">" . $totals['totalPayment'] . "&nbsp;</td>
							";
						}

						$revRow .= "
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['yield'] . "&nbsp;</td>
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['percActual'] . "&nbsp;</td>
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['percTotal'] . "&nbsp;</td>
							<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['percRes'] . "&nbsp;</td>
						";
					}				
				}
			}
			if($showRoomConfig == "1") {
				$revRow .= "
						<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['adultBeds']."&nbsp;</td>
						<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['childBeds']."&nbsp;</td>
				";
			}
			$revRow .= "
					<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['totalBeds']."&nbsp;</td>
					<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['resCount']."&nbsp;</td>
					<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['revenue']."&nbsp;</td>
				";
			if($includePayment == "1") {
				$revRow .= "
					<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb colGry\">".$item['grandTotal']['totalPayment']."&nbsp;</td>
				";
			}
			$revRow .= "
				<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['yield']."&nbsp;</td>
				<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['percActual']."&nbsp;</td>
				<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['percTotal']."&nbsp;</td>
				<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['percRes']."&nbsp;</td>
				<td class=\"br bb\" align=\"right\">".$item['grandTotal']['percTotal']."%&nbsp;</td>
			</tr>    
			";
		}
		$GLOBALS['temp']['revenueHeadRows'] = $revHeadRow;
		$GLOBALS['temp']['revenueRows'] = $revRow;

		$headRowBlank = "
		  <tr>
	    	<td class=\"outLt\" height=\"18\">&nbsp</td>
		  </tr>
		";
		$potentialHeadRow = "
		  <tr>
	    	<td class=\"outLt\" height=\"18\">Potential</td>
		  </tr>
		";
		$potentialRow = "
		  <tr>
		";
		$roomNightHeadRow = "
		  <tr>
		    <td class=\"outLt\" align=\"right\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showTotalRoomNightsOverlib();\">Total room nights</td>
		  </tr>
		";
		$roomNightRow = "
		  <tr>
		";
		$blockHeadRow = "
		  <tr>
		    <td class=\"outLt\" align=\"right\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showBlockedRoomNightsOverlib();\">Blocked room nights</td>
		  </tr>
		";
		$blockRow = "
		  <tr>
		";
		$potentialBedNightHeadRow = "
		  <tr>
		    <td class=\"outLt\" align=\"right\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showPotentialBedNightsOverlib();\">Potential bed nights</td>
		  </tr>
		";
		$potentialBedNightRow = "
		  <tr>
		";
		if($showTotal != "1") {
			foreach($potentialArray as $potentialItem) {
				if($showRoomConfig == "1") {			
					$potentialRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$potentialRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRevenueOption == "1") {
					$potentialRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}

				if($includePayment == "1") {
					$potentialRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
					";
				}

				if($showRevenueOption == "1") {
					$potentialRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$potentialRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRoomConfig == "1") {			
					$roomNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$roomNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb\">" . $potentialItem['roomCount'] . "&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRevenueOption == "1") {
					$roomNightRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				if($includePayment == "1") {
					$roomNightRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
					";
				}
				if($showRevenueOption == "1") {
					$roomNightRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$roomNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRoomConfig == "1") {			
					$blockRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$blockRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb\">" . $potentialItem['blockCount'] . "&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRevenueOption == "1") {
					$blockRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				if($includePayment == "1") {
					$blockRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
					";
				}
				if($showRevenueOption == "1") {
					$blockRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$blockRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRoomConfig == "1") {			
					$potentialBedNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$potentialBedNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb\">" . $potentialItem['potentialBedNight'] . "&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
				if($showRevenueOption == "1") {
					$potentialBedNightRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				if($includePayment == "1") {
					$potentialBedNightRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
					";
				}
				if($showRevenueOption == "1") {
					$potentialBedNightRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
				$potentialBedNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
			}
		}
		if($showRoomConfig == "1") {			
			$potentialRow .= "
	  		<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$potentialRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		";
		if($showRevenueOption == "1") {
			$potentialRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		if($includePayment == "1") {
			$potentialRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
			";
		}
		if($showRevenueOption == "1") {
			$potentialRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$potentialRow .= "
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
	    	<td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$roomNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$roomNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">$roomCountTotal&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		";
		if($showRevenueOption == "1") {
			$roomNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		if($includePayment == "1") {
			$roomNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
			";
		}
		if($showRevenueOption == "1") {
			$roomNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$roomNightRow .= "
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		    <td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$blockRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$blockRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">$blockCountTotal&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		";
		if($showRevenueOption == "1") {
			$blockRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		if($includePayment == "1") {
			$blockRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
			";
		}
		if($showRevenueOption == "1") {
			$blockRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$blockRow .= "
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		    <td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$potentialBedNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$potentialBedNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">$potentialBedNightTotal&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		";
		if($showRevenueOption == "1") {
			$potentialBedNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		if($includePayment == "1") {
			$potentialBedNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
			";
		}
		if($showRevenueOption == "1") {
			$potentialBedNightRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$potentialBedNightRow .= "
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
		    <td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		$GLOBALS['temp']['potentialHeadRow1'] = $potentialHeadRow;
		$GLOBALS['temp']['potentialHeadRow2'] = $headRowBlank;
		$GLOBALS['temp']['potentialHeadRow3'] = $headRowBlank;
		$GLOBALS['temp']['potentialRow'] = $potentialRow;
		$GLOBALS['temp']['roomNightHeadRow1'] = $roomNightHeadRow;
		$GLOBALS['temp']['roomNightHeadRow2'] = $headRowBlank;
		$GLOBALS['temp']['roomNightHeadRow3'] = $headRowBlank;
		$GLOBALS['temp']['roomNightRow'] = $roomNightRow;
		$GLOBALS['temp']['blockHeadRow1'] = $blockHeadRow;
		$GLOBALS['temp']['blockHeadRow2'] = $headRowBlank;
		$GLOBALS['temp']['blockHeadRow3'] = $headRowBlank;
		$GLOBALS['temp']['blockRow'] = $blockRow;
		$GLOBALS['temp']['potentialBedNightHeadRow1'] = $potentialBedNightHeadRow;
		$GLOBALS['temp']['potentialBedNightHeadRow2'] = $headRowBlank;
		$GLOBALS['temp']['potentialBedNightHeadRow3'] = $headRowBlank;
		$GLOBALS['temp']['potentialBedNightRow'] = $potentialBedNightRow;		

		$monthTotalHeadRow = "
			  <tr>
    			<td class=\"outLt\" height=\"18\">Total occupied</td>
			  </tr>
		";
		$monthTotalRow = "
			  <tr>
	    ";
		if($showTotal != "1") {
			foreach($monthTotals as $monthKey=>$monthItem) {
				if($monthKey !== "grandTotal" && $monthKey !== "name" && $monthKey !== "id") {
					$adult = $monthItem['adultBeds'];
					$child = $monthItem['childBeds'];
					$total = $monthItem['totalBeds'];
					if($showRoomConfig == "1") {
						$monthTotalRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb\">$adult&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">$child&nbsp;</td>
						";
					}
					$monthTotalRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb\">$total&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">$monthItem[resCount]&nbsp;</td>
					";
					if($showRevenueOption == "1") {
						$monthTotalRow .= "
							<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
						";
					}
					if($includePayment == "1") {
						$monthTotalRow .= "
							<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
						";
					}
					if($showRevenueOption == "1") {
						$monthTotalRow .= "
							<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
						";
					}
					$monthTotalRow .= "
						<td height=\"18\" align=\"right\" class=\"br bb\">$monthItem[percActual]&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">$monthItem[percTotal]&nbsp;</td>
						<td height=\"18\" align=\"right\" class=\"br bb\">$monthItem[percRes]&nbsp;</td>
					";
				}
			}
		}
		if($showRoomConfig == "1") {
			$monthTotalRow .= "
  				<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['adultBeds']."&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['childBeds']."&nbsp;</td>
			";
		}
		$monthTotalRow .= "
		  		<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['totalBeds']."&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['resCount']."&nbsp;</td>
		";
		if($showRevenueOption == "1") {
			$monthTotalRow .= "
		  		<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		if($includePayment == "1") {
			$monthTotalRow .= "
		  		<td height=\"18\" align=\"right\" class=\"br bb colGry\">&nbsp;</td>
			";
		}
		if($showRevenueOption == "1") {
			$monthTotalRow .= "
		  		<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$monthTotalRow .= "
		  		<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['percActual']."&nbsp;</td>
		  		<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['percTotal']."&nbsp;</td>
		  		<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['percRes']."&nbsp;</td>
			    <td align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['percTotal']."%&nbsp;</td>                    
	  		</tr>
		";
		$GLOBALS['temp']['monthTotalHeadRow1'] = $monthTotalHeadRow;
		$GLOBALS['temp']['monthTotalHeadRow2'] = $headRowBlank;
		$GLOBALS['temp']['monthTotalHeadRow3'] = $headRowBlank;
		$GLOBALS['temp']['monthTotalRow'] = $monthTotalRow;
	}	

	if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	}

	$rateOverrideFilter = "None";
	if(!empty($rateOverride)) {
		switch($rateOverrideType) {
		default:
		case "excludeRes":
			$rateOverrideFilter = "Exclude overrides";
			break;
		case "includeRes":
			$rateOverrideFilter = "Reservations including overrides only";
			break;
		case "excludeItem":
			$rateOverrideFilter = "Itinerary items with overrides only";
			break;
		case "includeItem":
			$rateOverrideFilter = "Itinerary items without overrides only";
			break;
		}			
	}		
	$GLOBALS['temp']['rateOverrideFilter'] = $rateOverrideFilter;

	$amountOverrideFilter = "None";
	if(!empty($amountOverride)) {
		switch($amountOverrideType) {
		default:
		case "excludeRes":
			$amountOverrideFilter = "Exclude overrides";
			break;
		case "includeRes":
			$amountOverrideFilter = "Reservations including overrides only";
			break;
		case "excludeItem":
			$amountOverrideFilter = "Itinerary items with overrides only";
			break;
		case "includeItem":
			$amountOverrideFilter = "Itinerary items without overrides only";
			break;
		}			
	}		
	$GLOBALS['temp']['amountOverrideFilter'] = $amountOverrideFilter;

	if($renderMode == "csv") {
		$csvFile = array();
		$headerLine = array();
		array_push($csvFile,array("Sales Analysis Report"));
		array_push($csvFile,array());
		array_push($csvFile,array("Date range",$fromDate['jsDate'] . " to " . $toDate['jsDate']));
		array_push($csvFile,array("Show Total Only",($showTotal=="1"?"Yes":"No")));
		array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
		array_push($csvFile,array("Agent",$agentFilter['names']));
		array_push($csvFile,array("Agent country",$agentCountryFilter['names']));
		array_push($csvFile,array("Status",$statusFilter['names']));
		array_push($csvFile,array("Consultant",$consultantFilter['names']));
		array_push($csvFile,array("Originator",$originatorFilter['names']));
		array_push($csvFile,array("Source",$sourceFilter['names']));
		array_push($csvFile,array("Nationality",$nationalityFilter['names']));
		array_push($csvFile,array("Rate",$rateFilter['names']));
		array_push($csvFile,array("Currency",$currenciesFilter['names']));
		array_push($csvFile,array("Totals",$totalBy));
		array_push($csvFile,array("Exclude TBA",$excludeTBA=="1"?"Yes":"No"));
		array_push($csvFile,array("Rate amount override filter",$amountOverrideFilter));
		array_push($csvFile,array("Rate type override filter",$rateOverrideFilter));
		array_push($csvFile,array("Include Revenue",($showRevenueOption=="1"?"Yes":"No")));
		if($showRevenueOption == "1") {
			array_push($csvFile,array("Component",$componentsFilter['names']));
		}
		if($showRevenueOption == "1") {
			array_push($csvFile,array("Include tax",$showTax=="1"?"Yes":"No"));
		}
		if($showRevenueOption == "1") {
			array_push($csvFile,array("Commission",$commType));
		}
		if($showRevenueOption == "1") {
			array_push($csvFile,array("Include Payment",($includePayment=="1"?"Yes":"No")));
		}
		array_push($csvFile,array("Include adult / child count",($showRoomConfig=="1"?"Yes":"No")));
		array_push($csvFile,array("Level 1",$level1));
		array_push($csvFile,array("Level 2",$level2));
		array_push($csvFile,array());

		$dateRow1 = array('','','');
		$dateRow2 = array('','','');
		if($showTotal != "1") {
			foreach($dateArray as $dateItem) {
				list($year,$month,$day) = explode("-",$dateItem['start']);
				$monthFmt = date("F Y",mktime(0,0,0,$month,$day,$year));
				if($showRoomConfig == "1") {						
					array_push($dateRow1,$monthFmt,'','','','');
					if($includePayment == "1") {
						array_push($dateRow1,'');
					}
					array_push($dateRow1,'','','','');
					array_push($dateRow2,'Adults','Children','Total','Res count','Revenue');
					if($includePayment == "1") {
						array_push($dateRow2,'Payment received');
					}
					array_push($dateRow2,'Yield');
					if($nightType == "room") {		
						array_push($dateRow2,'% of act r/n','% of pot r/n');
					} else {
						array_push($dateRow2,'% of act b/n','% of pot b/n');
					}
					array_push($dateRow2,'% of res');
				} else {
					array_push($dateRow1,$monthFmt,'','');
					if($includePayment == "1") {
						array_push($dateRow1,'');
					}
					array_push($dateRow1,'','','','');
					array_push($dateRow2,'Total','Res count','Revenue');
					if($includePayment == "1") {
						array_push($dateRow2,'Payment received');
					}
					array_push($dateRow2,'Yield');
					if($nightType == "room") {		
						array_push($dateRow2,'% of act r/n','% of pot r/n');
					} else {
						array_push($dateRow2,'% of act b/n','% of pot b/n');
					}
					array_push($dateRow2,'% of res');
				}
			}
		}
		if($showRoomConfig == "1") {						
			array_push($dateRow1,'Total','','','','');
			if($includePayment == "1") {
				array_push($dateRow1,'','');
			}
			array_push($dateRow1,'','','','% of potential');
			array_push($dateRow2,'Adults','Children','Total','Res count','Revenue');
			if($includePayment == "1") {
				array_push($dateRow2,'Payment received');
			}
			array_push($dateRow2,'Yield');
			if($nightType == "room") {		
				array_push($dateRow2,'% of act r/n','% of pot r/n');
			} else {
				array_push($dateRow2,'% of act b/n','% of pot b/n');
			}
			array_push($dateRow2,'% of res');
		} else {
			array_push($dateRow1,'Total','','');
			if($includePayment == "1") {
				array_push($dateRow1,'');
			}
			array_push($dateRow1,'','','','','% of potential');
			array_push($dateRow2,'Total','Res count','Revenue');
			if($includePayment == "1") {
				array_push($dateRow2,'Payment received');
			}
			array_push($dateRow2,'Yield');
			if($nightType == "room") {		
				array_push($dateRow2,'% of act r/n','% of pot r/n');
			} else {
				array_push($dateRow2,'% of act b/n','% of pot b/n');
			}
			array_push($dateRow2,'% of res');
		}

		array_push($csvFile,$dateRow1);
		array_push($csvFile,$dateRow2);
		foreach($bedNightGrid as $id1=>$item1) {
			$name1 = $item1['name'];
			foreach($item1 as $id2=>$item2) {
				if($id2 === "id" || $id2 === "name" || $id2 === "grandTotal" || $id2 === "resList") {
					continue;
				} 
				$name2 = $item2['name'];
				foreach($item2 as $id3=>$item3) {
					if($id3 === "id" || $id3 === "name" || $id3 === "grandTotal" || $id3 === "resList") {
						continue;
					} 
					$name3 = $item3['name'];
					$row = array($name1,$name2,$name3);
					if($showTotal != "1") {
						foreach($item3 as $cellId=>$cell) {
							if(!is_array($cell) || $cellId === "grandTotal" || $cellId === "resList") {
								continue;
							}
							$adult = $cell['adultBeds'];
							$child = $cell['childBeds'];
							$total = $cell['totalBeds'];
							if($showRoomConfig == "1") {
								array_push($row,$adult,$child);
							}
							array_push($row,$total,$cell['resCount'],$cell['revenue']);
							if($includePayment == "1") {
								array_push($row,$cell['totalPayment']);
							}
							array_push($row,$cell['yield'],$cell['percActual'],$cell['percTotal'],$cell['percRes']);
						}
					}

					if($showRoomConfig == "1") {
						array_push($row,$item3['grandTotal']['adultBeds'],$item3['grandTotal']['childBeds']);
					}
					array_push($row,$item3['grandTotal']['totalBeds'],$item3['grandTotal']['resCount'],$item3['grandTotal']['revenue']);
					if($includePayment == "1") {
						array_push($row,$item3['grandTotal']['totalPayment']);
					}
					array_push($row,$item3['grandTotal']['yield'],$item3['grandTotal']['percActual'],$item3['grandTotal']['percTotal'],$item3['grandTotal']['percRes'],$item2['grandTotal']['percTotal']);
					
					array_push($csvFile,$row);
				}
			}
		}
		array_push($csvFile,array());


		$monthTotalRow = array('Total occupied','','');
		if($showTotal != "1") {
			foreach($monthTotals as $monthKey=>$monthItem) {
				if($monthKey !== "grandTotal") {
					$adult = $monthItem['adultBeds'];
					$child = $monthItem['childBeds'];
					$total = $monthItem['totalBeds'];
					if($showRoomConfig == "1") {						
						array_push($monthTotalRow,$adult,$child,$total);
					} else {
						array_push($monthTotalRow,$total);
					}
					array_push($monthTotalRow,$monthItem['resCount'],'','',$monthItem['percActual'],$monthItem['percTotal'],$monthItem['percRes']);
				}
			}
		}
		if($showRoomConfig == "1") {						
			array_push($monthTotalRow,$monthTotals['grandTotal']['adultBeds'],$monthTotals['grandTotal']['childBeds'],$monthTotals['grandTotal']['totalBeds']);
		} else {
			array_push($monthTotalRow,$monthTotals['grandTotal']['totalBeds']);
		}
		array_push($monthTotalRow,$monthTotals['grandTotal']['resCount'],'','',$monthTotals['grandTotal']['percActual'],$monthTotals['grandTotal']['percTotal'],$monthTotals['grandTotal']['percRes'],$monthTotals['grandTotal']['percTotal']);
		array_push($csvFile,$monthTotalRow);

		$roomNightRow = array('Total room nights','','');
		$blockRow = array('Blocked room nights','','');
		$potentialBedNightRow = array('Potential bed nights','','');
		if($showTotal != "1") {
			foreach($potentialArray as $potentialItem) {
				if($showRoomConfig == "1") {						
					array_push($roomNightRow,'','',$potentialItem['roomCount']);
					array_push($blockRow,'','',$potentialItem['blockCount']);
					array_push($potentialBedNightRow,'','',$potentialItem['potentialBedNight']);
				} else {
					array_push($roomNightRow,$potentialItem['roomCount']);
					array_push($blockRow,$potentialItem['blockCount']);
					array_push($potentialBedNightRow,$potentialItem['potentialBedNight']);
				}
				array_push($roomNightRow,'','','','','','');
				array_push($blockRow,'','','','','','');
				array_push($potentialBedNightRow,'','','','','','');
			}
		}
		if($showRoomConfig == "1") {						
			array_push($roomNightRow,'','',$roomCountTotal,'');
			array_push($blockRow,'','',$blockCountTotal,'');
			array_push($potentialBedNightRow,'','',$potentialBedNightTotal,'');
		} else {
			array_push($roomNightRow,$roomCountTotal,'');
			array_push($blockRow,$blockCountTotal,'');
			array_push($potentialBedNightRow,$potentialBedNightTotal,'');
		}
		array_push($roomNightRow,'','','','','','');
		array_push($blockRow,'','','','','','');
		array_push($potentialBedNightRow,'','','','','','');
		

		array_push($csvFile,array('Potential'));
		array_push($csvFile,$roomNightRow);
		array_push($csvFile,$blockRow);
		array_push($csvFile,$potentialBedNightRow);
		array_push($csvFile,array());

		if($showRevenueOption == "1") {
			array_push($csvFile,array('Total revenue per currency'));
			foreach($revenueGrid as $id=>$item) {
				$revBedNightRow = array('','',$id);
				if($showTotal != "1") {
					foreach($item as $totalKey=>$totals) {
						if($totalKey !== "grandTotal" && $totalKey !== "name" && $totalKey !== "id") {
							if($showRoomConfig == "1") {						
								array_push($revBedNightRow,$totals['adultBeds'],$totals['childBeds'],$totals['totalBeds']);
							} else {
								array_push($revBedNightRow,$totals['totalBeds']);
							}
							array_push($revBedNightRow,$totals['resCount'],$totals['revenue']);
							if($includePayment == "1") {
								array_push($revBedNightRow,$totals['totalPayment']);
							}
							array_push($revBedNightRow,$totals['yield'],$totals['percActual'],$totals['percTotal'],$totals['percRes']);
						}
					}
				}
				if($showRoomConfig == "1") {						
					array_push($revBedNightRow,$item['grandTotal']['adultBeds'],$item['grandTotal']['childBeds']);
				}
				array_push($revBedNightRow,$item['grandTotal']['totalBeds'],$item['grandTotal']['resCount'],$item['grandTotal']['revenue']);
				if($includePayment == "1") {
					array_push($revBedNightRow,$item['grandTotal']['totalPayment']);
				}
				array_push($revBedNightRow,$item['grandTotal']['yield'],$item['grandTotal']['percActual'],$item['grandTotal']['percTotal'],$item['grandTotal']['percRes'],$item['grandTotal']['percTotal']);
				array_push($csvFile,$revBedNightRow);
			}
			array_push($csvFile,array());
		}
		
		$csvText = "";
		foreach($csvFile as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
		if(headers_sent()) {
			//    echo('Some data has already been output to browser, can\'t send PDF file');
		}
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=sales_analysis_".str_replace(" ","_",chng_date(date("Y-m-d"),"-")).".csv");
		echo $csvText;
		flush();
		die();
	}
} else {
	$GLOBALS['temp']['reportGenerated'] = " class=\"collapse\" ";
}

function getPersonaFax($personaId) {
   $fax = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone, rf_phone_type
      WHERE
         pr_phone.pr_persona_id = '" . $personaId . "'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
   if(trim($fax) == "" || $fax == "0") {
      $fax = "";
   }
   return $fax;
}

function getPersonaTelephone($personaId) {
   $tel = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '" . $personaId . "'
         AND pr_phone.pr_default_yn = '1'",4);
   if(trim($tel) == "" || $tel == "0") {
      $tel = "";
   }
   return $tel;
}

function getPersonaDetail($personaId) {
   $detail = $GLOBALS['lDB']->get("
      SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '".$personaId."'",2);
   $detail = $detail[0];
   $name = "";
   if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
      $name .= $detail['pr_name_first'] . " ";
   }
   if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
      $name .= $detail['pr_name_second'] . " ";
   }
   if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
      $name .= $detail['pr_name_last'] . " ";
   }
   $result = array();
   $result['name'] = trim($name);
   $result['fax'] = getPersonaFax($personaId);
   $result['telephone'] = getPersonaTelephone($personaId);
   $result['email'] = $detail['pr_email'];
   if(trim($result['email']) == "" || $result['email'] == "0") {
      $result['email'] = "";
   }
   return $result;
}
