<?php

require_once(__DIR__ . '/db.rv_extra.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.csv.php');
require_once(__DIR__ . '/functions.pdf.php');

require_once(__DIR__ . '/functions.profile.php');

$profileFields = array(
	/*  1 */ "", // from date
	/*  2 */ "", // to date
	/*  3 */ "statusFilter",
	/*  4 */ "propertyExtraFilter",
	/*  5 */ "extraFilterType",
	/*  6 */ "extraFilter",
	/*  7 */ "categoryFilter",
	/*  8 */ "cols",
	/*  9 */ "",
	/*  10 */ "",
	/*  11 */ "",
	/*  12 */ "extraSupplierFilter",
	/*  13 */ "reference",
	/*  14 */ "showTotals"
);


function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;

	$pdfName = "Extra report - $fromDate to $toDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,10))."+$newOptions+".join("+",array_slice($_SERVER['argv'],11,4));

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

function getCol($id) {
	global $cols;

	foreach($cols as $item) {
		if($item['id'] == $id) {
			return $item;
		}
	}
	return false;
}

function trimRecordDate($recordDate) {
	return chng_date(substr($recordDate,0,10),"-");
}
