<?php

/**
 * init.form371.php - Extra Report
 * Job: 306
 * Function: 59 (Report: Extras)
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("extra_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Extras Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_extra.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],15,"");
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$fromDate = useDate("from", $_SERVER['argv'][1]);
$toDate = useDate("to", $_SERVER['argv'][2]);

$statusACL = $lDB->get("
   SELECT
      rf_reservation_status_id
    FROM
      rf_reservation_status
    WHERE
      rf_reservation_status_id <> 25
",3);
$statusFilter = useFilter("status",$_SERVER['argv'][3],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$propertyACL = $lDB->get("
   SELECT DISTINCT
      ac_accomm_type.pr_business_id
   FROM
      sc_accomm, ac_accomm_type, pr_business, pr_persona
   WHERE
      sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
      AND   sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
      AND   ac_accomm_type.ac_accomm_type_inactive_yn=0
      AND   ac_accomm_type.pr_business_id = pr_business.pr_business_id
      /*AND pr_business.pr_bus_inactive_yn= '0'*/
      AND   pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
", 3);
array_push($propertyACL,"0");
$propertyFilter = useFilter("propertiesExtra", $_SERVER['argv'][4], "SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =", "rv_extra.pr_business_id", $propertyACL, "Not property specific","0");

$extraSupplierFilter = useFilter("extraSupplier",$_SERVER['argv'][12],"SELECT IFNULL(CONCAT(CONCAT(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_extra.pr_supplier_id",false,"Direct booking","0",true);

$reference = $_SERVER['argv'][13];
$referenceSQL = "";
if(trim($reference) != "") {
	$referenceSQL = " AND rv_extra.rv_extra_ref LIKE ('".str_replace("*", "%", $reference)."') ";
}
$GLOBALS['temp']['reference'] = $reference;

$showTotals = $_SERVER['argv'][14] == "1" ? true : false;
$GLOBALS['temp']['showTotals'] = $showTotals ? "checked" : "";

$extraFilterType = $_SERVER['argv'][5];
$GLOBALS['temp']['extraFilterTypeCategory'] = "";
$GLOBALS['temp']['extraFilterTypeExtra'] = "";
if($extraFilterType == "1") {
	$GLOBALS['temp']['extraFilterTypeCategory'] = "checked";
} else {
	$GLOBALS['temp']['extraFilterTypeExtra'] = "checked";
}
$extraFilter = useFilter("extras", $_SERVER['argv'][6], "SELECT ac_ext_desc FROM ac_extra WHERE ac_extra.ac_extra_ix =", "ac_extra.ac_extra_ix", false, false, false);
if($extraFilter['ids'] != "") {
   $catList = $lDB->get("
      SELECT DISTINCT
         ac_extra.ac_extra_category_id,
         ac_extra_category.ac_extra_cat_desc
      FROM
         ac_extra
         INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      WHERE
         ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
   ",2);
   $extraFilterRows = "";
   $extraFilterIds = "";
   foreach($catList as $item) {
      $extraList = $lDB->get("
         SELECT
            ac_extra.ac_extra_ix as ac_extra_ix,
            ac_ext_desc
         FROM
            ac_extra
         WHERE
            ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
            AND ac_extra.ac_extra_category_id = '$item[ac_extra_category_id]'
      ",2);
      $extraNames = "";
      $extraIds = "";
      foreach($extraList as $extraItem) {
         if($extraNames != "") {
            $extraNames .= ", ";
         }
         $extraNames .= $extraItem['ac_ext_desc'];
         if($extraIds != "") {
            $extraIds .= ":";
         }
         $extraIds .= $extraItem['ac_extra_ix'];
      }
      $extraFilterRows .= "
         <tr id=\"extra_$item[ac_extra_category_id]\">
            <td width=\"80\" ><textarea rows=1 style=\"width:80;\" id=\"extraCatText\" class=\"txtg\" readonly tabIndex=\"-1\">$item[ac_extra_cat_desc]</textarea></td>
            <td width=\"300\"><textarea rows=1 style=\"width:300;\" id=\"extraText\" class=\"txtg\" readonly tabIndex=\"-1\">$extraNames</textarea></td>
            <td><input type=button class=\"button bDelete\" style=\"width:20; background-position: center;\" value=\"\" onclick=\"removeExtraIds('$item[ac_extra_category_id]');\"></td>
         </tr>
      ";
      $extraFilterIds .= "
         <input type=\"hidden\" id=\"extraIds_$item[ac_extra_category_id]\" name=\"extraIds\" value=\"$extraIds\">
      ";
   }
   $GLOBALS['temp']['extraFilterRows'] = $extraFilterRows;
   $GLOBALS['temp']['extraFilterIds'] = $extraFilterIds;
   $GLOBALS['temp']['extraAllClass'] = "collapse printCollapse";
} else {
   $GLOBALS['temp']['extraFilterRows'] = "";
   $GLOBALS['temp']['extraFilterIds'] = "";
   $GLOBALS['temp']['extraAllClass'] = "";
}


$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][7], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_ix", false, false, false);

if($extraFilterType == "1") {
	$extraFilterSQL = $extraCategoryFilter['where'];
} else {
	$extraFilterSQL = $extraFilter['where'];
}

global $cols;

$cols = array(
	array('id'=>1,'label'=>"Quantity",'type'=>"string",'fields'=>array("rv_extra.rv_extra_units"),'width'=>"50"),
	array('id'=>2,'label'=>"Reservation number",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix"),'width'=>"65"),
	array('id'=>3,'label'=>"Extra",'type'=>"string",'fields'=>array("ac_extra.ac_ext_desc"),'width'=>"100"),
	array('id'=>4,'label'=>"Service date",'type'=>"date",'fields'=>array("rv_extra.rv_extra_date_serv"),'width'=>"70"),
	array('id'=>5,'label'=>"Property",'type'=>"string",'fields'=>array("pr_business.pr_bus_name_short"),'width'=>"50"),
	array('id'=>6,'label'=>"Room / Unit",'type'=>"string",'fields'=>array("ac_accomm_room.ac_desc"),'width'=>"40"),
	array('id'=>7,'label'=>"Category",'type'=>"string",'fields'=>array("ac_extra_category.ac_extra_cat_desc"),'width'=>"100"),
	array('id'=>8,'label'=>"Reservation name",'type'=>"string",'fields'=>array("rv_reservation.rv_res_name"),'width'=>"100"),
	array('id'=>9,'label'=>"Charge amount",'type'=>"string",'fields'=>array("rv_extra.rv_extra_amt_payable"),'width'=>"80",'align'=>"r"),
	array('id'=>10,'label'=>"Guest(s)",'type'=>"complex",'fields'=>array("rv_res_item_group.rv_res_item_group_ix"),'function'=>"getGuestNames",'width'=>"100"),
	array('id'=>11,'label'=>"Exchange rate",'type'=>"string",'fields'=>array("rv_extra.rv_extra_exch_rate"),'width'=>"60",'align'=>"r"),
	array('id'=>12,'label'=>"Unit amount",'type'=>"string",'fields'=>array("rv_extra.rv_extra_charge"),'width'=>"50",'align'=>"r"),
	array('id'=>13,'label'=>"Tax rate",'type'=>"string",'fields'=>array("rv_extra.rv_extra_tax_perc"),'width'=>"50"),
	array('id'=>14,'label'=>"Discount",'type'=>"string",'fields'=>array("rv_extra.rv_extra_discount"),'width'=>"50",'align'=>"r"),
	array('id'=>15,'label'=>"Commission received",'type'=>"string",'fields'=>array("rv_extra.rv_extra_comm_rec"),'width'=>"70",'align'=>"r"),
	array('id'=>16,'label'=>"Commission paid",'type'=>"string",'fields'=>array("rv_extra.rv_extra_comm_pay"),'width'=>"70",'align'=>"r"),
	array('id'=>17,'label'=>"Invoice to",'type'=>"string",'fields'=>array("pr_folio.pr_name_first","pr_folio.pr_name_last"),'width'=>"90"),
	array('id'=>18,'label'=>"POS",'type'=>"string",'fields'=>array("ac_pos.ac_pos_name_rr"),'width'=>"90"),
	array('id'=>19,'label'=>"Extra note",'type'=>"string",'fields'=>array("rv_extra.rv_extra_note"),'width'=>"200"),
	array('id'=>20,'label'=>"Extra internal memo",'type'=>"string",'fields'=>array("rv_extra.rv_extra_note_internal"),'width'=>"200"),
	array('id'=>21,'label'=>"Extra total amount",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_units","rv_extra.rv_extra_charge","rv_extra.rv_extra_ind","rv_extra.rv_extra_nights"),'function'=>"getTotalCharge",'width'=>"80",'align'=>"r"),
	array('id'=>22,'label'=>"Folio total amount",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_units","rv_extra.rv_extra_charge","rv_extra.rv_extra_ind","rv_extra.rv_extra_nights","rv_extra.rv_extra_exch_rate"),'function'=>"getTotalCharge",'width'=>"80",'align'=>"r"),
	array('id'=>23,'label'=>"Code table amount",'type'=>"string",'fields'=>array("ac_extra.ac_ext_amount"),'width'=>"50",'align'=>"r"),
	array('id'=>24,'label'=>"Code table currency",'type'=>"string",'fields'=>array("code_currency.rf_currency_symbol as code_currency_rf_currency_symbol"),'width'=>"60"),
	array('id'=>25,'label'=>"Code table tax",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_tax_ind", "rv_extra.rf_tax_id", "code_tax_rate.rf_tax_rate_perc"),'function'=>"getCodeTableTax",'width'=>"40"),
	array('id'=>26,'label'=>"Code table commission received",'type'=>"string",'fields'=>array("ac_extra.ac_ext_comm_rec"),'width'=>"70",'align'=>"r"),
	array('id'=>27,'label'=>"Code table commission paid",'type'=>"string",'fields'=>array("ac_extra.ac_ext_comm_pay"),'width'=>"70",'align'=>"r"),
	array('id'=>28,'label'=>"Agent",'type'=>"complex",'fields'=>array("rv_reservation.rv_reservation_ix"),'width'=>"100",'function'=>"getAgentName"),
	array('id'=>29,'label'=>"Reservation status",'type'=>"string",'fields'=>array("rf_reservation_status.rf_reservation_status_desc"),'width'=>"80"),
	array('id'=>30,'label'=>"Service By",'type'=>"string",'fields'=>array("pr_extra_supplier.pr_name_first","pr_extra_supplier.pr_name_last") ,'width'=>"100"),
	array('id'=>31,'label'=>"Reference",'type'=>"string",'fields'=>array("rv_extra.rv_extra_ref"),'width'=>"80"),
	array('id'=>32,'label'=>"ETD",'type'=>"string",'fields'=>array("rv_extra.rv_extra_travel_etd"),'width'=>"40"),
	array('id'=>33,'label'=>"ETA",'type'=>"string",'fields'=>array("rv_extra.rv_extra_travel_eta"),'width'=>"40"),
	array('id'=>34,'label'=>"Type",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind"),'function'=>"getExtraType",'width'=>"100"),
	//array('id'=>35,'label'=>"Type icon",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind"),'function'=>'getExtraTypeIcon','width'=>"20"),
	array('id'=>36,'label'=>"Adults",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind","rv_extra.rv_extra_adult_count"),'function'=>"getAdults",'width'=>"100"),
	array('id'=>37,'label'=>"Children",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind","rv_extra.rv_extra_child_count"),'function'=>"getChildren",'width'=>"100"),
	array('id'=>38,'label'=>"Arrival date",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind","rv_extra.rv_extra_date_serv"),'function'=>"getArrive",'width'=>"100"),
	array('id'=>39,'label'=>"Departure date",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind","rv_extra.rv_extra_date_depart"),'function'=>"getDepart",'width'=>"100"),
	array('id'=>40,'label'=>"Nights",'type'=>"complex",'fields'=>array("rv_extra.rv_extra_ind","rv_extra.rv_extra_nights"),'function'=>"getNights",'width'=>"100"),
	array('id'=>41,'label'=>"Charge amount currency",'type'=>"string",'fields'=>array("folio_currency.rf_currency_symbol as folio_currency_rf_currency_symbol"),'width'=>"50"),
	array('id'=>42,'label'=>"Extra total amount currency",'type'=>"string",'fields'=>array("extra_currency.rf_currency_symbol as extra_currency_rf_currency_symbol"),'width'=>"50"),	
	array('id'=>43,'label'=>"Folio total amount currency",'type'=>"string",'fields'=>array("folio_currency.rf_currency_symbol as folio_currency_rf_currency_symbol"),'width'=>"50"),
	array('id'=>44,'label'=>"Consultant",'type'=>"complex",'fields'=>array("rv_reservation.rv_reservation_ix"),'width'=>"100", 'function'=>"getConsultantName"),
	array('id'=>45,'label'=>"Record date",'type'=>"complex",'fields'=>array("rv_extra.ad_create_date"),'width'=>"70", 'function'=>"trimRecordDate")
);

function colCompare($a, $b)
{
    if ($a['label'] == $b['label']) {
        return 0;
    }
    return ($a['label'] < $b['label']) ? -1 : 1;
}
usort($cols, "colCompare");

$joins = array(
	array('table'=>"rv_extra"),
	array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id",'requires'=>"rv_extra"),
	array('table'=>"ac_extra",'type'=>"INNER",'on'=>"ac_extra.ac_extra_ix = rv_extra.ac_extra_id",'requires'=>"rv_extra"),
	array('table'=>"pr_business",'type'=>"LEFT",'on'=>"pr_business.pr_business_id = rv_extra.pr_business_id",'requires'=>"rv_extra"),
	array('table'=>"rv_res_item_group",'type'=>"LEFT",'on'=>"rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id",'requires'=>"rv_extra"),
	array('table'=>"ac_accomm_room",'type'=>"LEFT",'on'=>"ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id",'requires'=>"rv_res_item_group"),
	array('table'=>"ac_extra_category",'type'=>"INNER",'on'=>"ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id",'requires'=>"ac_extra"),
	array('table'=>"fn_folio",'type'=>"LEFT",'on'=>"fn_folio.fn_folio_ix = rv_extra.fn_folio_id",'requires'=>"rv_extra"),
	array('table'=>"pr_persona",'alias'=>"pr_folio",'type'=>"LEFT",'on'=>"pr_folio.pr_persona_ix = fn_folio.fn_folio_to_id",'requires'=>"fn_folio"),
	array('table'=>"ac_pos",'type'=>"LEFT",'on'=>"ac_pos.ac_pos_ix = rv_extra.ac_pos_id",'requires'=>"rv_extra"),
	array('table'=>"rf_currency",'alias'=>"extra_currency",'type'=>"LEFT",'on'=>"extra_currency.rf_currency_ix = rv_extra.rf_currency_id",'requires'=>"rv_extra"),
	array('table'=>"rf_currency",'alias'=>"folio_currency",'type'=>"LEFT",'on'=>"folio_currency.rf_currency_ix = fn_folio.rf_currency_id",'requires'=>"fn_folio"),
	array('table'=>"rf_currency",'alias'=>"code_currency",'type'=>"LEFT",'on'=>"code_currency.rf_currency_ix = ac_extra.rf_currency_id",'requires'=>"ac_extra"),
	array('table'=>"rf_tax_rate",'alias'=>"code_tax_rate",'type'=>"LEFT",'on'=>"code_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id",'requires'=>"ac_extra"),
	array('table'=>"rt_tax_group",'alias'=>"code_tax_group",'type'=>"LEFT",'on'=>"code_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id",'requires'=>"ac_extra"),
	array('table'=>"pr_persona",'alias'=>"pr_agent",'type'=>"LEFT",'on'=>"pr_agent.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"LEFT",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id"),
	array('table'=>"pr_persona",'type'=>"LEFT",'alias'=>"pr_extra_supplier",'on'=>"pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id")
);

$colArg = $_SERVER['argv'][8];
$colArray = array();
$colOrder = array();
$colSort = array();
$colHeader = false;
if ($showTotals) {
	// Add two columns for Totals and Currency labels, with special ID's 1000 and 1001
	$colArg = "1,0,,,70,,,,1000:1,0,,,70,,,,1001:" . $colArg;
}
if(trim($colArg) != "") {
	$count = 0;
	foreach(explode(":",$colArg) as $item) {
		$col = explode(",",$item);
		if(array_key_exists(8, $col) && $col[8] != "") {
			$id = $col[8];
		} else {
			$id = $count+1;
		}
		$colItem = getCol($id);
		$colActive[$id] = $col[0];
		$colOrder[$id] = $col[1];
		$colSort[$id] = $col[2];
		$width = $col[4];
		if(!is_numeric($width)) {
			$width = $colItem['width'];
		}
		$label = trim($col[5]);
		if($label == "") {
			$label = $colItem['label'];
		}
		$header = trim($col[6]);
		if($header != "") {
			$colHeader = true;
		}
		$align = trim($col[7]);
		if($align == "") {
			$align = isset($colItem['align']) ? $colItem['align'] : "";
		}
		$colArray[$id] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"align"=>$align
		);
		$count++;
	}
}
asort($colOrder);
asort($colSort);

$colData = array();

foreach($cols as $colKey=>$colItem) {
	$width = $colItem['width'];
	$sort = "";
	$direction = "";
	$label = $colItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$align = isset($colItem['align']) ? $colItem['align'] : "";
	$id = $colItem['id'];

	if(isset($colArray[$id]['active']) && $colArray[$id]['active'] == "1") {
		$width = $colArray[$id]['width'];
		$sort = $colArray[$id]['sort'];
		$direction = $colArray[$id]['direction'];		
		$label = $colArray[$id]['label'];
		$active = "1";
		$order = $colArray[$id]['order'];
		$header = $colArray[$id]['header'];
		$align = $colArray[$id]['align'];
	}
	$colDataItem = array(
		'"id":"'.$colItem['id'].'"',
		'"name":"'.$colItem['label'].'"',
		'"width":"'.$width.'"',
		'"sort":"'.$sort.'"',
		'"direction":"'.$direction.'"',
		'"label":"'.$label.'"',
		'"active":"'.$active.'"',
		'"order":"'.$order.'"',
		'"header":"'.$header.'"',
		'"align":"'.$align.'"'
	);
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}
$colData = '['.join(",",$colData).']';
$GLOBALS['temp']['colData'] = $colData;

$page = $_SERVER['argv'][9];
if (trim($page) == "") {
	$page = "1";
}
$GLOBALS['temp']['page'] = $page;
$options = $_SERVER['argv'][10];

switch ( $options & 7 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	outputMail($form,$options,$fromDate['htmlDate'],$toDate['htmlDate']);
}

$GLOBALS['temp']['makeReport'] = "collapse printCollapse";
$GLOBALS['temp']['dataWidth'] = "0";
$GLOBALS['temp']['filterDivClass'] = "expand";
$GLOBALS['temp']['showHideFilterButtonText'] = "<< Hide Filters"; 
if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideFilterButtonText'] = "<< Show Filters"; 
	$reportTitle = $GLOBALS['temp']['title'];
	$sql = buildSQL($cols,$colArray,$colSort,$joins);
	$select = array(
		"rv_extra.rv_extra_ix",
		"rv_reservation.rv_reservation_ix"
	);
	$select = array_unique(array_merge($sql['select'],$select));
	$from = array(
		"rv_extra",
		"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id",
		"INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id",
		"INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id"
	);
	$from = array_unique(array_merge($sql['from'],$from));
	$finalSelectSQL = "
		SELECT
			".join(",\n",$select)."
	";
	$finalFromSQL = "
		FROM
			".join("\n",$from)."
		WHERE
			rv_extra.rv_extra_void_ind = 0
			AND (
				(
					rv_extra.rv_extra_date_serv = '0000-00-00'
					AND (
						(
							rv_reservation.rv_date_arrive >= '$fromDate[jsDate]'
							AND rv_reservation.rv_date_arrive <= '$toDate[jsDate]'
						) OR (
							rv_reservation.rv_date_depart >= '$fromDate[jsDate]'
							AND rv_reservation.rv_date_depart <= '$toDate[jsDate]'
						) OR (
							rv_reservation.rv_date_arrive < '$fromDate[jsDate]'
							AND rv_reservation.rv_date_depart > '$toDate[jsDate]'
						)
					)
				) OR (
					rv_extra_ind <> ".DB_RV_EXTRA_ACCOMMODATION."
					AND rv_extra.rv_extra_date_serv >= '$fromDate[jsDate]'
					AND rv_extra.rv_extra_date_serv <= '$toDate[jsDate]'
				) OR (
					rv_extra_ind = ".DB_RV_EXTRA_ACCOMMODATION."
					AND (
						(
							rv_extra.rv_extra_date_serv >= '$fromDate[jsDate]'
							AND rv_extra.rv_extra_date_serv <= '$toDate[jsDate]'
						) OR (
							rv_extra.rv_extra_date_depart >= '$fromDate[jsDate]'
							AND rv_extra.rv_extra_date_depart <= '$toDate[jsDate]'
						) OR (
							rv_extra.rv_extra_date_serv < '$fromDate[jsDate]'
							AND rv_extra.rv_extra_date_depart > '$toDate[jsDate]'
						)
					)
				)
			)
			$extraFilterSQL
			$propertyFilter[where]
			$statusFilter[where]
			$extraSupplierFilter[where]
			$referenceSQL
	";

	$order = trim(join(",",$sql['sort']));
	if($order != "") {
		$order = " ORDER BY $order ";
	}
	$limit = "";

	if($renderMode == "html") {

		$totalRows = $lDB->get("SELECT COUNT(*) $finalFromSQL",4);

		$pageLength = 35;
		$GLOBALS['temp']['pageCount'] = ceil($totalRows/$pageLength);
		$GLOBALS['temp']['pageNum'] = $page;
		$GLOBALS['temp']['nextPageNum'] = $page+1;
		$GLOBALS['temp']['prevPageNum'] = $page-1;
		if ($page == 1) {
			$GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
		} else {
			$GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
		}
		if ($page >= $GLOBALS['temp']['pageCount']) {
			$GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
		} else {
			$GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
		}
		$totalPages = ceil($totalRows/$pageLength);
		$pageList = isset($pageList) ? $pageList : "";
		if (($totalPages - $page) < 2 ) {
			$startPage = $totalPages - 2;
		} elseif($page < 4) {
			$startPage = 4;
		} else {
			$startPage = $page;
		}
		if ($page != 1) {
			$pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
		} else {
			$pageList = "<B>1</B>";
		}
		for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
			if ($count == $page) {
				$pageList .= ", <B>$count</B>";
			} else {
				$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
			}
		}
		if (($totalPages - $page) > 3 ) {
			$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
		}
		$GLOBALS['temp']['pageList'] = $pageList;

		$limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
		$GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);

		$pageLast = $page == $totalPages ? true : false;
	}

	// Build up Totals for use at bottom of resultset (for HTML, only on last page of resultset)
	if ($showTotals) {
		// 21: Extra total amount
		// 22: Folio total amount
		// 16: Commission paid
		// 15: Commission received
		// 12: Unit amount
		// 1: Quantity
		// 9: Charge amount
		$totalsFields = array("21", "22", "16", "15", "12", "1", "9");
		$list = $lDB->get($finalSelectSQL . $finalFromSQL,2);

		$newList = array();
		$resList = array();
		foreach($list as $item) {
			$newItem = array();

			foreach($colOrder as $key=>$colItem) {
				if($colArray[$key]['active'] == "1") {
					$values = array();
					$colItem = getCol($key);

					if (empty($colItem)) {
						$newItem[$key] = "";
						continue;
					}

					foreach($colItem['fields'] as $field) {
						array_push($values,$item[getFieldName($field)]);
					}
					switch($colItem['type']) {
					default:
					case "string":
						$value = trim(str_replace("\r","",join(" ",$values)));
						break;
					case "date":
						$value = "";
						if($values[0] != "0000-00-00") {
							$value = chng_date($values[0],"-");
						}
						break;
					case "complex":
						if(function_exists($colItem['function'])) {
							$value = call_user_func_array($colItem['function'],$values);
						} else {
							$value = "NOT IMPLEMENTED";
						}
						break;
					}
					$newItem[$key] = $value;
				}
			}		
			if(sizeof($newItem) > 0) {
				array_push($newList,$newItem);
				array_push($resList,$item['rv_reservation_ix']);
			}
		}
		$list = $newList;
		$newList = null;
		$totals = array();

		foreach ($list as $listKey => $item) {
			foreach ($item as $key => $value) {
				if (in_array($key, $totalsFields)) {
					$currency = "Unknown";
					if ($key == 9 && isset($list[$listKey][41]) && !empty($list[$listKey][41])) {		// Charge amount
						$currency = $list[$listKey][41];
					}
					if ($key == 21 && isset($list[$listKey][42]) && !empty($list[$listKey][42])) {		// Extra total amount
						$currency = $list[$listKey][42];
					}
					if ($key == 22 && isset($list[$listKey][43]) && !empty($list[$listKey][43])) {		// Folio total amount
						$currency = $list[$listKey][43];
					}
					if (!isset($totals[$key][$currency])) {
						$totals[$key][$currency] = 0;
					}
					$totals[$key][$currency] += $value;
				}
			}
		}

		$totalsCurrencies= array();
		foreach ($totals as $key => $item) {
			foreach ($item as $currency => $value) {
				$totalsCurrencies[] = $currency;
				$totals[$key][$currency] = db_round($value, 2);
			}
		}
		$totalsCurrencies = array_unique($totalsCurrencies);
	}

	$list = $lDB->get($finalSelectSQL . $finalFromSQL . $order . $limit,2);

	$newList = array();
	$resList = array();
	foreach($list as $item) {
		$newItem = array();

		foreach($colOrder as $key=>$colItem) {
			if($colArray[$key]['active'] == "1") {
				$values = array();
				$colItem = getCol($key);

				if (empty($colItem)) {
					$newItem[$key] = "";
					continue;
				}

				foreach($colItem['fields'] as $field) {
					array_push($values,$item[getFieldName($field)]);
				}
				switch($colItem['type']) {
				default:
				case "string":
					$value = trim(str_replace("\r","",join(" ",$values)));
					break;
				case "date":
					$value = "";
					if($values[0] != "0000-00-00") {
						$value = chng_date($values[0],"-");
					}
					break;
				case "complex":
					if(function_exists($colItem['function'])) {
						$value = call_user_func_array($colItem['function'],$values);
					} else {
						$value = "NOT IMPLEMENTED";
					}
					break;
				}
				$newItem[$key] = $value;
			}
		}		
		if(sizeof($newItem) > 0) {
			array_push($newList,$newItem);
			array_push($resList,$item['rv_reservation_ix']);
		}
	}
	$list = $newList;
	$newList = null;

	if($renderMode == "html") {		
		$GLOBALS['temp']['makeReport'] = "";
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$dataCol = "";
		$dataHeader1 = "";
		$dataHeader2 = "";
		$dataColCount = 0;
		$dataWidth = 0;
		$lastHeader = "";
		$lastHeaderCount = 0;

		if ($showTotals && !$pageLast) {
			// Remove data in order to not show Totals columns except on last page
			unset($colOrder[1000]);
			unset($colOrder[1001]);
			unset($colArray[1000]);
			unset($colArray[1001]);
			foreach ($list as $key => $value) {
				unset($list[$key]['1000']);
				unset($list[$key]['1001']);
			}
		}

		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1") {
				$dataCol .= "<col width=\"".$colArray[$key]['width']."\" />";
				$align = "";
				if($colArray[$key]['align'] == "c") {
					$align = "align=\"center\"";
				}
				if($colArray[$key]['align'] == "r") {
					$align = "align=\"right\"";
				}
				if($colHeader) {
					if($lastHeader != "" && $lastHeader != $colArray[$key]['header']) {
						$dataHeader1 .= "<td class=\"outLt\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
						$lastHeader = "";
						$lastHeaderCount = 0;
					}
					if($colArray[$key]['header'] != "") {
						$dataHeader2 .= "<td class=\"outLt\" $align>".$colArray[$key]['label']."</td>";
						$lastHeader = $colArray[$key]['header'];
						$lastHeaderCount++;
					} else {
						$dataHeader1 .= "<td class=\"outLt\" rowspan=\"2\" $align>".$colArray[$key]['label']."</td>";
					}
				} else {
					$dataHeader1 .= "<td class=\"outLt\" $align>".$colArray[$key]['label']."</td>";
				}
				$dataColCount++;
				$dataWidth += $colArray[$key]['width'];
			}
		}
		$GLOBALS['temp']['dataCol'] = $dataCol;
		if($lastHeader != "") {
			$dataHeader1 .= "<td class=\"outLt\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
		}
		$dataHeader = "<tr>$dataHeader1</tr>";
		if($colHeader) {
			$dataHeader .= "<tr>$dataHeader2</tr>";
		}
		$GLOBALS['temp']['dataHeader'] = $dataHeader;
		$GLOBALS['temp']['dataColCount'] = $dataColCount;
		$GLOBALS['temp']['dataWidth'] = $dataWidth;

		$rows = "";
		foreach($list as $listKey=>$item) {
			$resId = $resList[$listKey];
			$rows .= "<tr class='linkrow' onclick=\"window.location='/reservation.php?610+$resId';\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">";
			foreach($item as $key=>$cell) {
				$align = "";
				if($colArray[$key]['align'] == "c") {
					$align = "align=\"center\"";
				}
				if($colArray[$key]['align'] == "r") {
					$align = "align=\"right\"";
				}
				if($cell == "") {
					$cell = "&nbsp;";
				} else {
					$cell = str_replace("\n","<br />",$cell);
				}
				$rows .= "<td class=\"br\" $align style=\"overflow:hidden;\">$cell</td>";
			}
			$rows .= "</tr>";
		}

		if ($showTotals && $pageLast) {
			$rows .= "<tr class='colGry'><td valign='top'><strong>Totals</strong></td><td>" . join($totalsCurrencies, "<br>") . "</td>";
			foreach ($list[0] as $id => $value) {
				if (!in_array($id, array("1000", "1001"))) {	// Skip over first two special cells for Totals and Currency
					if (isset($totals[$id])) {
						$itemTotals = array();
						foreach ($totalsCurrencies as $currency) {
							$itemTotals[] = isset($totals[$id][$currency]) ? $totals[$id][$currency] : db_round("0", 2);
						}
						$align = "";
						if($colArray[$id]['align'] == "c") {
							$align = "center";
						}
						if($colArray[$id]['align'] == "r") {
							$align = "right";
						}
						$rows .= "<td align='" . $align . "'>" . join($itemTotals, "<br>") . "</td>";
					} else {
						$rows .= "<td>&nbsp;</td>";
					}
				}
			}
			$rows .= "</tr>";
		}

		$GLOBALS['temp']['dataRows'] = $rows;
	}
	if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF($reportTitle,"L");


		$pdf->SetFont('Arial', '', 9);
		$pdf->Row(array(
			array('data'=>"<B>$reportTitle: $GLOBALS[principal_name]</B>")
		));
		$pdf->SetFont('Arial', '', 8);
		$pdf->Row(array(
			array('data'=>"Date range: " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate'])
		));

		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->Row(array(array()));
		// Main PDF header
		$headerArray = array();

		$header1 = array();
		$header2 = array();
		$totalWidth = 0;
		$lastHeader = "";
		$lastHeaderWidth = 0;
		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1") {
				$width = $colArray[$key]['width'] / 770 * 100;
				$align = strtoupper($colArray[$key]['align']);
				if($colHeader) {
					if($lastHeader != "" && $lastHeader != $colArray[$key]['header']) {
						array_push($header1,array('width'=>$lastHeaderWidth."%",'data'=>$lastHeader,'fill'=>"1",'align'=>"C",'border'=>"LRTB"));
						$lastHeader = "";
						$lastHeaderWidth = 0;
					}					
					if($colArray[$key]['header'] != "") {
						$lastHeader = $colArray[$key]['header'];
						$lastHeaderWidth += $width;
					} else {
						array_push($header1,array('width'=>$width."%",'fill'=>"1",'align'=>"C",'border'=>"LRTB"));
					}
					array_push($header2,array('width'=>$width . "%", 'data'=>$colArray[$key]['label'],'fill'=>"1",'border'=>"LRTB",'align'=>$align));
				} else {
					array_push($header1,array('width'=>$width . "%", 'data'=>$colArray[$key]['label'],'fill'=>"1",'border'=>"LRTB",'align'=>$align));
				}
				$totalWidth += $width;

			}
		}
		if($colHeader) {
			if($lastHeader != "") {
				array_push($header1,array('width'=>$lastHeaderWidth."%",'data'=>$lastHeader,'fill'=>"1",'align'=>"C",'border'=>"LRTB"));
			}
			$pdf->Row($header1);
			$pdf->Row($header2);
		} else {
			$pdf->Row($header1);
		}

		foreach($list as $item) {
			$row = array();
			foreach($item as $key=>$cell) {
				$align = strtoupper($colArray[$key]['align']);
				array_push($row,array('width'=>($colArray[$key]['width'] / 770 * 100) . "%",'data'=>$cell,'border'=>"LR",'align'=>$align));
			}
			$pdf->Row($row);
		}

		if ($showTotals) {
			$row = array();
			foreach($list[0] as $id=>$value) {
				if ($id == "1000") {
					$cell = "Totals";
				} else if ($id == "1001") {
					$cell = join($totalsCurrencies, "\n");
				} else if (isset($totals[$id])) {
					$itemTotals = array();
					foreach ($totalsCurrencies as $currency) {
						$itemTotals[] = isset($totals[$id][$currency]) ? $totals[$id][$currency] : db_round("0", 2);
					}
					$cell = join($itemTotals, "\n");
				} else {
					$cell = "";
				}
				$align = strtoupper($colArray[$id]['align']);
				array_push($row,array('width'=>($colArray[$id]['width'] / 770 * 100) . "%",'data'=>$cell,'fill'=>"1",'border'=>"LRT",'align'=>$align));
			}
			$pdf->Row($row);
		}

		$pdf->Row(array(array('width'=>$totalWidth."%",'border'=>"T")));

		$pdf->Ln(2);
		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->ReportHeader($reportTitle, $headerArray);
		
		if($renderType == "view") {
			pdf_view($pdf);
		}
		if($renderType == "send") {
			pdf_send($pdf,$reportTitle);
		}
		
	}
	
	if ($showTotals) {
		$totalPopulated = false;
		$totalLabel = "Totals";
		foreach ($totalsCurrencies as $currency) {
			$rowValues = array($totalLabel, $currency);
			foreach($list[0] as $id=>$value) {
				if (in_array($id, array("1000", "1001"))) {
					continue;
				}
				if (isset($totals[$id]) && isset($totals[$id][$currency])) {
					$rowValues[] = $totals[$id][$currency];
				} else if (isset($totals[$id]) && in_array($id, $totalsFields)) {
					$rowValues[] = db_round("0", 2);
				} else {
					$rowValues[] = "";
				}
			}
			array_push($list, $rowValues);
			$totalLabel = "";
		}
	}

	if ( $renderMode == "csv" ) {
		$csv = array();
		array_push($csv,array($reportTitle));
		array_push($csv,array());
		array_push($csv,array("Date range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
		array_push($csv,array("Status",$statusFilter['names']));
		array_push($csv,array("Property",$propertyFilter['names']));
		if($extraFilterType == "1") {
			array_push($csv,array("Extra category",$extraCategoryFilter['names']));
		} else {
			array_push($csv,array("Extra",$extraCategoryFilter['names']));
		}
		array_push($csv,array("Service By: " . $extraSupplierFilter['names']));
		if($reference) {
			array_push($csv,array("Reference: " . $reference));
		}
		array_push($csv,array());

		$header1 = array();
		$header2 = array();
		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1") {
				if($colHeader) {
					array_push($header1,$colArray[$key]['header']);
					array_push($header2,$colArray[$key]['label']);
				} else {
					array_push($header1,$colArray[$key]['label']);
				}
			}
		}
		if($colHeader) {
			array_push($csv,$header1,$header2);
		} else {
			array_push($csv,$header1);
		}
		$csv = array_merge($csv,$list);
				
		
		csv_output("extra_report_".$fromDate['jsDate']."_to_".$toDate['jsDate'],$csv);
	}
	
}

function getFieldArray($field) {
	$fieldList = preg_split("/ as /i",$field);
	$alias = isset($fieldList[1]) ? trim($fieldList[1]): "";
	$fieldList = explode(".",$fieldList[0]);
	$table = trim($fieldList[0]);
	$field = trim($fieldList[1]);
	return array('table'=>$table, 'field'=>$field, 'alias'=>$alias);
}

function getFieldName($field) {
	$fieldArray = getFieldArray($field);
	if($fieldArray['alias'] != "") {
		return $fieldArray['alias'];
	} else {
		return $fieldArray['field'];
	}
}

function getFieldTable($field) {
	$fieldArray = getFieldArray($field);
	return $fieldArray['table'];
}

function inJoin($alias,$joins) {
	foreach($joins as $join) {
		if( (isset($join['alias']) && $join['alias'] == $alias) || (isset($join['table']) && $join['table'] == $alias) ) {
			return true;
		}
	}
	return false;
}

function buildSQL($cols,$colArray,$colSort,$joins) {
	if(isset($chartName) && $chartName != "") {
		$showIds = $chartIds[$chartName];
		$colourIds = $chartIds['colour'];
	} else {
		$showIds = isset($chartIds) ? $chartIds : "";
		$colourIds = array();
	}
	$select = array();
	$from = array();
	foreach($cols as $key=>$item) {		
		$id = $item['id'];
		if($colArray[$id]['active'] == "1") {
			$fields = array();
			if(is_array($item['fields'])) {
				$fields = $item['fields'];
			}
			foreach($fields as $field) {
				if(inJoin(getFieldTable($field),$joins) && !in_array($field,$select)) {
					array_push($select,$field);
					$fieldArray = explode(".",$field);
					$from = array_merge($from,getJoins($fieldArray[0],$joins));
				}
			}	
		}
	}
	$select = array_unique($select);
	$from = array_unique($from);

	$sort = array();
	foreach($colSort as $key=>$item) {
		if($colArray[$key]['active'] == "1" && $item != "") {
			$colItem = getCol($key);
			if(is_array($colItem['fields'])) {
				$fields = $colItem['fields'];
			}
			if($colArray[$key]['direction'] == "a") {
				$direction = "asc";
			} else {
				$direction = "desc";
			}
			foreach($fields as $fieldKey=>$field) {
				$fields[$fieldKey] = $field . " " . $direction;
			}
			$sort = array_merge($sort,$fields);
		}
	}
	return array('select'=>$select, 'from'=>$from,'sort'=>$sort);
}

function getJoins($alias,$joins) {
	foreach($joins as $join) {
		if( (isset($join['alias']) && $join['alias'] == $alias) || ( (!isset($join['alias']) || $join['alias'] == "") && (isset($join['table']) && $join['table'] == $alias) )) {
			if(!array_key_exists("type",$join)) {
				return array($join['table']);
			} else {
				if(!isset($join['alias']) || $join['alias'] == "") {
					$result = array("$join[type] JOIN $join[table] ON $join[on]");
				} else {
					$result = array("$join[type] JOIN $join[table] AS $join[alias] ON $join[on]");
				}
				if(isset($join['requires']) && $join['requires'] != "") {
					$require = getJoins($join['requires'],$joins);
					return array_merge($require,$result);
				} else {
					return $result;
				}
			}
		}
	}
}

function getGuestNames($rv_res_item_group_ix) {
	$guestNameList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id AND rv_res_item_guest.rv_res_item_group_id != ''
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '$rv_res_item_group_ix'
	",2);
	$guestNames = array();
	foreach($guestNameList as $guestName) {
		array_push($guestNames, trim($guestName['pr_name_first'] . " " . $guestName['pr_name_last']));
	}
	return join(", ",$guestNames);
}

function getAgentName($rv_reservation_id) {
	$pr_name_last = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",4);

	if(trim($pr_name_last) == "") {
		return "Direct";
	} else {
		return $pr_name_last;
	}
}

function getConsultantName($rv_reservation_id) {
	$res_consultant_name = $GLOBALS['lDB']->get("
		SELECT
			concat(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",4);

	if(trim($res_consultant_name) == "") {
		return "Direct";
	} else {
		return trim($res_consultant_name);
	}
}

function getTotalCharge($rv_extra_units,$rv_extra_charge,$rv_extra_ind,$rv_extra_nights,$rv_extra_exch_rate=1) {
	$total = $rv_extra_units * $rv_extra_charge * $rv_extra_exch_rate;
	if ($rv_extra_ind == DB_RV_EXTRA_ACCOMMODATION) { 
		$total *= $rv_extra_nights;
	}
	fixAmtDisplay($total,2);
	return "$total";

}

function getExtraType($rv_extra_ind) {
	switch($rv_extra_ind) {
	case DB_RV_EXTRA_GENERAL:
		return "General";
	case DB_RV_EXTRA_ACTIVITY:
		return "Activity";
	case DB_RV_EXTRA_TRAVEL:
		return "Travel";
	case DB_RV_EXTRA_ACCOMMODATION:
		return "Accommodation";
	}
}

function getExtraTypeIcon($rv_extra_ind) {
}

function getAdults($rv_extra_ind,$rv_extra_adult_count) {
	if($rv_extra_ind == DB_RV_EXTRA_ACCOMMODATION) {
		return $rv_extra_adult_count;
	} else {
		return "";
	}
}

function getChildren($rv_extra_ind,$rv_extra_child_count) {
	if($rv_extra_ind == DB_RV_EXTRA_ACCOMMODATION) {
		return $rv_extra_child_count;
	} else {
		return "";
	}
}

function getArrive($rv_extra_ind,$rv_extra_date_serv) {
	if($rv_extra_ind == DB_RV_EXTRA_ACCOMMODATION) {
		return chng_date($rv_extra_date_serv,"-");
	} else {
		return "";
	}
}

function getDepart($rv_extra_ind,$rv_extra_date_depart) {
	if($rv_extra_ind == DB_RV_EXTRA_ACCOMMODATION) {
		return chng_date($rv_extra_date_depart,"-");
	} else {
		return "";
	}
}

function getNights($rv_extra_ind,$rv_extra_nights) {
	if($rv_extra_ind == DB_RV_EXTRA_ACCOMMODATION) {
		return $rv_extra_nights;
	} else {
		return "";
	}
}

function getCodeTableTax($rv_extra_tax_ind, $rf_tax_id, $rf_tax_rate_perc) {
	if ($rv_extra_tax_ind == 20) {
		return $GLOBALS['lDB']->get("
			SELECT
				SUM(rf_tax_rate.rf_tax_rate_perc)
			FROM
				rt_tax_group
				LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = rt_tax_group.rt_tax_group_ix
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
			WHERE
				rt_tax_group.rt_tax_group_ix = '".$rf_tax_id."'
		",4);
	} else {
		return $rf_tax_rate_perc;
	}
}
