<?php
/*
 * $Id: init.form373.php,v 1.5 2011-05-30 12:50:04 light Exp $
 *
 * $Log: init.form373.php,v $
 * Revision 1.5  2011-05-30 12:50:04  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.4  2011-05-17 14:08:32  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.3  2010-10-04 18:02:30  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.2  2010-10-04 16:46:58  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.1  2008-08-01 08:34:18  light
 * Added new rate report shell
 *
 *
 */

/**
 * init.form373.php - Rate Report
 * Job: 308
 * Function: 72 (Report: Rate Sheet)
*/

if($_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!array_key_exists($form,$GLOBALS)) {
   $GLOBALS[$form] = "";
}

if (!is_object($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_rate.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$rt_rate_type_id = $_SERVER['argv'][1];
$rateList = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_ix,
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_inactive_yn = '0'
	ORDER BY
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
",2);
$finalRateList = $rateList;
$rateOptions = "<option value=\"\">All</option>";
foreach($rateList as $item) {
	$selected = "";
	if($item['rt_rate_type_ix'] == $rt_rate_type_id) {
		$finalRateList = array($item);
		$selected = "selected";
	}
	$rateOptions .= "<option $selected value=\"$item[rt_rate_type_ix]\">$item[rt_rate_type_desc] ($item[rf_currency_symbol])</option>";
}
$GLOBALS['temp']['rateOptions'] = $rateOptions;
$rateTypeSQL = "";
if($rt_rate_type_id != "") {
	$rateTypeSQL = "
		AND rt_rate.rt_rate_type_id = '$rt_rate_type_id'
	";
}
$rateList = array();
foreach($finalRateList as $item) {
	$rateList[$item['rt_rate_type_ix']] = $item;
}

$rt_period_id = $_SERVER['argv'][2];
$periodList = $GLOBALS['lDB']->get("
	SELECT
		rt_period.rt_period_ix,
		rt_period.rt_period_desc,
		rt_period.rt_period_date_from,
		rt_period.rt_period_date_to
	FROM
		rt_period
	WHERE
		rt_period.rt_period_inactive_yn = '0'
	ORDER BY
		rt_period.rt_period_date_from,
		rt_period.rt_period_date_to,
		rt_period.rt_period_desc
",2);
$finalPeriodList = $periodList;
$periodOptions = "<option value=\"\">All</option>";
foreach($periodList as $item) {
	$selected = "";
	if($item['rt_period_ix'] == $rt_period_id) {
		$finalPeriodList = array($item);
		$selected = "selected";
	}
	$item['rt_period_date_from'] = chng_date($item['rt_period_date_from'],"-");
	$item['rt_period_date_to'] = chng_date($item['rt_period_date_to'],"-");
	$periodOptions .= "<option $selected value=\"$item[rt_period_ix]\">$item[rt_period_desc] ($item[rt_period_date_from] - $item[rt_period_date_to])</option>";
}
$GLOBALS['temp']['periodOptions'] = $periodOptions;
$periodSQL = "";
if($rt_period_id != "") {
	$perioSQL = "
		AND rt_rate.rt_period_id = '$rt_period_id'
	";
}
$periodList = array();
foreach($finalPeriodList as $item) {
	$periodList[$item['rt_period_ix']] = $item;
}

if($_SERVER['argc'] < 2) {
	$_SERVER['argv'][3] = join(":",$GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}


$accommACL= $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][3],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rt_rate.ac_accomm_type_id",$accommACL,false,false);
if($accommFilter['ids'] != "") {
	$accommSQL = "
		AND ac_accomm_type.ac_accomm_type_ix IN ('".join("','",explode(":",$accommFilter['ids']))."')
	";
} else {
	$accommSQL = "
		AND ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$accommACL)."')
	";
}
$finalPropertyList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		1
		$accommSQL
	ORDER BY
		pr_persona.pr_name_last
",2);
$properyList = array();
foreach($finalPropertyList as $item) {
	$finalAccommList = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type.pr_business_id = '$item[pr_business_id]'
			$accommSQL
		ORDER BY
			ac_accomm_type.ac_accomm_desc
	",2);
	$accommList = array();
	foreach($finalAccommList as $accommItem) {
		$accommList[$accommItem['ac_accomm_type_ix']] = $accommItem;
	}
	$item['accomm'] = $accommList;
	$item['accommTotal'] = sizeof($accommList);
	$propertyList[$item['pr_business_id']] = $item;
}
			

$GLOBALS['temp']['reportGenerated'] = "class=\"printCollapse collapse\"";
$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
$GLOBALS['temp']['filterStatus'] = "";
if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['reportGenerated'] = "";
	$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";

	$data = array();
	// Create a blank data structure
	foreach($rateList as $rateKey=>$rateItem) {
		$rateData =& $data[$rateKey];
		$rateData = array();
		foreach($periodList as $periodKey=>$periodItem) {
			$periodData =& $rateData[$periodKey];
			$peiodData = array();
			foreach($propertyList as $propertyKey=>$propertyItem) {
				$propertyData =& $periodData[$propertyKey];
				$propertyData = array();
				foreach($propertyItem['accomm'] as $accommKey=>$accommItem) {
					$accommData =& $propertyData[$accommKey];
					$accommData = array();
				}
			}
		}
	}	

	$list = $GLOBALS['lDB']->get("
		SELECT
			rt_rate.rt_rate_ix,
			rt_period.rt_period_ix,
			rt_rate_type.rt_rate_type_ix,
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_type_ix
		FROM
			rt_rate
			INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
		WHERE
			1
			$periodSQL
			$rateTypeSQL
			$accommFilter[where]
		ORDER BY
			rt_rate_type.rt_rate_type_ix,
			rt_period.rt_period_ix,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc
	",2);
	foreach($list as $item) {
		$data[$item['rt_rate_type_ix']][$item['rt_period_ix']][$item['pr_business_id']][$item['ac_accomm_type_ix']] = $item;
	}


	$rows = "";
	foreach($data as $rateKey=>$rateItem) {
		foreach($rateItem as $periodKey=>$periodItem) {
			foreach($periodItem as $propertyKey=>$propertyItem) {
				$accommCount = 0;
				foreach($propertyItem as $accommKey=>$accommItem) {
					if(sizeof($accommItem) > 0) {
						$accommCount++;
					}
				}
				if(sizeof($propertyItem) > 0) {
					$accommPerc = $accommCount / sizeof($propertyItem) * 100;
				} else {
					$accommPerc = 0;
				}
				fixAmtDisplay($accommPerc,0);
				$colClass = "txt";
				if($accommPerc == 0) {
					$colClass = "txtred";
				} elseif($accommPerc < 100) {
					$colClass = "txtgr";
				}
				$rows .= "
					<tr>
						<td class=\"$colClass\">".$rateList[$rateKey]['rt_rate_type_desc']."</td>
						<td class=\"$colClass\">".$periodList[$periodKey]['rt_period_desc']."</td>
						<td class=\"$colClass\">".$propertyList[$propertyKey]['pr_name_last']."</td>
						<td class=\"$colClass\">".$accommPerc."</td>
					</tr>
				";
			}
		}
	}
	$GLOBALS['temp']['rows'] = $rows;
}
