<?php

/**
 * init.form374.php - Age Analysis and Cash Flow Forecast reports
 * Job: 309 (Age Analysis Report), 310 (Cash Flow Forecast Report)
 * Function: 106 (Reports Financials: Age Analysis), 107 (Reports Financials: Cash Flow Forecast)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}


if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_paymentplan.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],20,"");
$groupRows = "";
$rows = "";

$job = $_SERVER['argv'][0];
$GLOBALS['temp']['job'] = $job;
$GLOBALS['temp']['ageAnalysisClass'] = "collapse printCollapse";
$GLOBALS['temp']['cashFlowClass'] = "collapse printCollapse";
if($job == "309") {
	// Age analysis
	$report = "ageAnalysis";
	$GLOBALS['temp']['ageAnalysisClass'] = "";
	$GLOBALS['temp']['title'] = "Age Analysis";
} else {
	// Cash flow
	$report = "cashFlow";
	$GLOBALS['temp']['cashFlowClass'] = "";
	$GLOBALS['temp']['title'] = "Cash Flow Forecast";
}

$totalMonthCount = 12;
$monthCount = $_SERVER['argv'][1];
if($monthCount == "") {
	$monthCount = 1;
}
$monthOptions = "";
for($count=1;$count<=$totalMonthCount;$count++) {
	$selected = "";
	if($count == $monthCount) {
		$selected = "selected";
	}
	$monthOptions .= "
		<option value=\"$count\" $selected>$count</option>
	";
}
$GLOBALS['temp']['monthOptions'] = $monthOptions;

$today = date("Y-m-d");
$todayArray = explode("-",$today);
$dateArray = array();
for($count=0; $count<$monthCount; $count++) {
	$finalCount = $count;
	if($report == "ageAnalysis") {
		$finalCount *= -1;
	}
	if($finalCount != 0) {
		$monthLabel = "";
		if($finalCount > 0) {
			$monthLabel .= "+";
		}
		/*$monthLabel .= $finalCount . " month";
		if($finalCount > 1 || $finalCount < -1) {
			$monthLabel .= "s";
		}*/
		$monthLabel = ($finalCount * 30) . " days";
	} else {
		$monthLabel = "Current";
	}
	$startTime = mktime(0,0,0,$todayArray[1]+$finalCount,1,$todayArray[0]);
	$endTime = mktime(0,0,0,$todayArray[1]+$finalCount+1,0,$todayArray[0]);
	$dateData = array(
		'name'=>date("M-y",$startTime),
		'start'=>date("Y-m-d",$startTime),
		'end'=>date("Y-m-d",$endTime),
		'count'=>$monthLabel
	);
	array_push($dateArray,$dateData);
}
if($report == "ageAnalysis") {
	$dateArray = array_reverse($dateArray);
}
$startDate = $dateArray[0]['start'];
$endDate = $dateArray[sizeof($dateArray)-1]['end'];

$includeSummary = $_SERVER['argv'][2];
$GLOBALS['temp']['includeSummaryChecked'] = "";
if($includeSummary == "1") {
	$GLOBALS['temp']['includeSummaryChecked'] = "checked";
}


$includePrevious = $_SERVER['argv'][3];
$GLOBALS['temp']['includePreviousChecked'] = "";
if($includePrevious == "1") {
	$GLOBALS['temp']['includePreviousChecked'] = "checked";
}

$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 15
		AND rf_reservation_status_id <> 97
",3);

$agentACL = false;

if ( $userStatusId < 2 ) {
	$agentACL = array($calAgentId);
}

$agentFilter = useFilter("agent",$_SERVER['argv'][4],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");

if ( $_SERVER['argc'] < 2 ) {
	$_SERVER['argv'][5] = "30";
}

$statusFilter = useFilter("status",$_SERVER['argv'][5],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$statusStr = $statusFilter['names'];

if($_SERVER['argc'] < 2) {
	$_SERVER['argv'][6] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}


$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][6],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

$consultantFilter = useFilter("consultant",$_SERVER['argv'][7],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

$paymentPlanFilter = useFilter("paymentPlan",$_SERVER['argv'][8],"SELECT IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc) as nameLast FROM ac_pay_plan WHERE ac_pay_plan.ac_pay_plan_ix =","rv_reservation.ac_pay_plan_id",false,false,false);

$groupBy = explode(":",$_SERVER['argv'][9]);

$groupByArray = array(
	"all"=>array(
		'name'=>"All",
		'select'=>"
			'' AS id%,
			'All' AS name%
		",
	),
	"agent"=>array(
		'name'=>"Agent",
		'select'=>"
			rv_reservation.rv_agent_id AS id%,
			groupTable%.pr_name_last AS name%
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable% ON groupTable%.pr_persona_ix = rv_reservation.rv_agent_id
		",
		'blank'=>"Direct"
	),
	"agentPostalCountry"=>array(
		'name'=>"Agent postal country",
		'select'=>"
			groupTable%_2.rf_country_ix as id%,
			groupTable%_2.rf_country_name as name%			
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable% ON groupTable%.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rf_country AS groupTable%_2 ON groupTable%_2.rf_country_ix = groupTable%.pr_corr_country_id
		",
		'blank'=>"No country"
	),
	"agentPhysicalCountry"=>array(
		'name'=>"Agent physical country",
		'select'=>"
			groupTable%_2.rf_country_ix as id%,
			groupTable%_2.rf_country_name as name%
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable% ON groupTable%.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rf_country AS groupTable%_2 ON groupTable%_2.rf_country_ix = groupTable%.pr_phys_country_id
		",
		'blank'=>"No country"
	),
	"consultant"=>array(
		'name'=>"Consultant",
		'select'=>"
			rv_reservation.rv_consultant_id as id%,
			groupTable%.pr_name_first as name%_1,
			groupTable%.pr_name_last as name%_2
		",
		'join'=>"
			INNER JOIN pr_persona AS groupTable% ON groupTable%.pr_persona_ix = rv_reservation.rv_consultant_id
		",
		'blank'=>"No consultant"
	),
	"contact"=>array(
		'name'=>"Contact",
		'select'=>"
			rv_reservation.rv_corr_persona_id as id%,
			groupTable%.pr_name_first as name%_1,
			groupTable%.pr_name_last as name%_2
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable% ON groupTable%.pr_persona_ix = rv_reservation.rv_corr_persona_id
		",
		'blank'=>"No contact"
	),
	"monthArrive"=>array(
		'name'=>"Month of arrival",
		'select'=>"
			rv_reservation.rv_date_arrive as id%,
			rv_reservation.rv_date_arrive as name%
		",
		'join'=>"",
		'blank'=>"No month of arrival",
		'month'=>true
	),
	"monthDepart"=>array(
		'name'=>"Month of departure",
		'select'=>"
			rv_reservation.rv_date_depart as id%,
			rv_reservation.rv_date_depart as name%
		",
		'join'=>"",
		'blank'=>"No month of depart",
		'month'=>true
	),
	"nationality"=>array(
		'name'=>"Nationality",
		'select'=>"
			groupTable%.rf_country_ix as id%,
			groupTable%.rf_country_name as name%
		",
		'join'=>"
			LEFT JOIN rf_country AS groupTable% ON groupTable%.rf_country_ix = rv_reservation.rf_country_id
		",
		'blank'=>"No nationality"
	),
	"originator"=>array(
		'name'=>"Originator",
		'select'=>"
			groupTable%.pr_persona_ix as id%,
			groupTable%.pr_name_last as name%
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable% ON groupTable%.pr_persona_ix = rv_reservation.rv_origin_agent_id
		",
		'blank'=>"No originator"
	),
	"rateType"=>array(
		'name'=>"Rate type",
		'select'=>"
			groupTable%.rt_rate_type_ix as id%,
			groupTable%.rt_rate_type_desc as name%
		",
		'join'=>"
			LEFT JOIN rt_rate_type AS groupTable% ON groupTable%.rt_rate_type_ix = rv_reservation.rt_rate_type_id
		",
		'blank'=>"No rate type"
	),
	"source"=>array(
		'name'=>"Source",
		'select'=>"
			rv_reservation.rf_source_ix as id%,
			groupTable%.rf_source_desc as name%
		",
		'join'=>"
			LEFT JOIN rf_source AS groupTable% ON groupTable%.rf_source_ix = rv_reservation.rf_source_ix
		",
		'blank'=>"No source"
	),
	"status"=>array(
		'name'=>"Status",
		'select'=>"
			groupTable%.rf_reservation_status_id as id%,
			groupTable%.rf_reservation_status_desc as name%
		",
		'join'=>"
			LEFT JOIN rf_reservation_status AS groupTable% ON groupTable%.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		",
		'blank'=>"No status"
	),
	"reservation_number"=>array(
		'name'=>"Reservation number",
		'select'=>"
			rv_reservation.rv_reservation_ix as id%,
			rv_reservation.rv_reservation_ix as name%
		",
		'join'=>"",
		'blank'=>"No reservation number"
	),
	"reservation_name"=>array(
		'name'=>"Reservation name",
		'select'=>"
			rv_reservation.rv_reservation_ix as id%,
			rv_reservation.rv_res_name as name%
		",
		'join'=>"",
		'blank'=>"No reservation name"
	)
);

$groups = 10;
$GLOBALS['temp']['groupCount'] = $groups;
$groupRowHTML = join("",file(__DIR__ . "/../../../public/html/rep_paymentplan_group_row.htm"));
for($count=0;$count<$groups;$count++) {
	$groupByOptions = "";
	foreach($groupByArray as $groupByKey=>$groupByItem) {
		$selected = "";
		if(isset($groupBy[$count]) && isset($groupByKey) && $groupBy[$count] == $groupByKey) {
			$selected = "selected";
		}
		$groupByOptions .= "
			<option value=\"$groupByKey\" $selected>$groupByItem[name]</option>
		";

	}
	$groupRows .= str_replace("!group!",$count,
		str_replace("!level!",$count+1,
		str_replace("!groupByOptions!",$groupByOptions,$groupRowHTML)));
}
$GLOBALS['temp']['groupRows'] = $groupRows;

$includeCredits = $_SERVER['argv'][10];
if($includeCredits == "1") {
	$GLOBALS['temp']['includeCredits'] = "checked";
} else {
	$GLOBALS['temp']['includeCredits'] = "";
}


$includeExtras = $_SERVER['argv'][11];
$GLOBALS['temp']['includeExtras'] = "";
if($includeExtras == "1") {
	$GLOBALS['temp']['includeExtras'] = "checked";
}

$dateRange = $_SERVER['argv'][12];
if($dateRange == "1") {
	$GLOBALS['temp']['travelDateRange'] = "checked";
	$GLOBALS['temp']['travelDateRangeSpan'] = "class=\"expand\"";
} else {
	$GLOBALS['temp']['travelDateRange'] = "";
	$GLOBALS['temp']['travelDateRangeSpan'] = "class=\"collapse\"";
}

$dateRangeType = $_SERVER['argv'][19];
if(empty($dateRangeType)) {
	$dateRangeType = "travel";
}
$GLOBALS['temp']['dateRangeTypeTravelSelected'] = "";
$GLOBALS['temp']['dateRangeTypeArriveSelected'] = "";
$GLOBALS['temp']['dateRangeTypeDepartSelected'] = "";
switch($dateRangeType) {
case "travel":
	$GLOBALS['temp']['dateRangeTypeTravelSelected'] = "selected";
	break;
case "arrive":
	$GLOBALS['temp']['dateRangeTypeArriveSelected'] = "selected";
	break;
case "depart":
	$GLOBALS['temp']['dateRangeTypeDepartSelected'] = "selected";
	break;
}

$fromTravelDate = useDate("fromTravel", $_SERVER['argv'][13]);
$toTravelDate = useDate("toTravel", $_SERVER['argv'][14]);




$overrideStartDate = $_SERVER['argv'][15];
$GLOBALS['temp']['overrideStartDate'] = "";
if($overrideStartDate == "1") {
	$GLOBALS['temp']['overrideStartDate'] = "checked";
}

$fromDateRaw = $_SERVER['argv'][16];
if($overrideStartDate != "1" || $fromDateRaw == "") {
	$firstDateArray = explode("-",$dateArray[0]['start']);
	$fromDateRaw = date("Y-m-d",mktime(0,0,0,$firstDateArray[1]-12,1,$firstDateArray[0]));
}
$fromDate = useDate("from", $fromDateRaw);

$finalFromDate = $fromDate['jsDate'];
if($finalFromDate > $startDate) {
	$finalFromDate = $startDate;
}

$options = $_SERVER['argv'][17];

switch ( $options & 7 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
}

$GLOBALS['temp']['filterStatus'] = "";
$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";

$GLOBALS['temp']['advancedForm'] = "collapse";
$GLOBALS['temp']['advancedTag'] = "<<  More";

$GLOBALS['temp']['pageDetail'] = "collapse printCollapse";
if($_SERVER['argc'] > 2) {
	$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	$GLOBALS['temp']['pageDetail'] = "expand";
	$joins = array();
	$selects = array();
	for($count=0;$count<$groups;$count++) {
		if($count > 0 && $groupBy[$count] == "all") {
			$groups = $count;
			break;
		}
		if (isset($groupByArray[$groupBy[$count]]['join'])) {
			array_push($joins,str_replace("%",$count,$groupByArray[$groupBy[$count]]['join']));
		}
		array_push($selects,str_replace("%",$count,$groupByArray[$groupBy[$count]]['select']));
	}

	$paymentsDueOption = 0;

	if($dateRange == "1") {
		switch($dateRangeType) {
		case "travel":
			$sqlTravelWhere = "
				AND (
					(
						rv_reservation.rv_date_arrive >= '$fromTravelDate[jsDate]' 
						AND rv_reservation.rv_date_arrive <= '$toTravelDate[jsDate]'
					) OR (
						rv_reservation.rv_date_depart >= '$fromTravelDate[jsDate]' 
						AND rv_reservation.rv_date_depart <= '$toTravelDate[jsDate]'
					) OR (
						rv_reservation.rv_date_arrive < '$fromTravelDate[jsDate]' 
						AND rv_reservation.rv_date_depart > '$toTravelDate[jsDate]'
					)
				)
			";
			$paymentsDueOption += 8;
			break;
		case "arrive":
			$sqlTravelWhere = "
				AND rv_reservation.rv_date_arrive >= '$fromTravelDate[jsDate]' 
				AND rv_reservation.rv_date_arrive <= '$toTravelDate[jsDate]'
			";			
			break;
		case "depart":
			$sqlTravelWhere = "
				AND rv_reservation.rv_date_depart >= '$fromTravelDate[jsDate]' 
				AND rv_reservation.rv_date_depart <= '$toTravelDate[jsDate]'
			";
			break;
		}
	} else {
		$sqlTravelWhere = "";
	}
		
	$list = $lDB->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_invoice_currency_id,
			".join(",",$selects)."
		FROM
			rv_pay_plan_item
			INNER JOIN rv_reservation ON rv_pay_plan_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			".join("\n",$joins)."
		WHERE		
			rv_pay_plan_item.rv_pay_plan_date >= '$finalFromDate'
			$agentFilter[where]
			$statusFilter[where]
			$consultantFilter[where]
			$paymentPlanFilter[where]
			$accommFilter[where]
			$sqlTravelWhere
	",2);
	foreach($list as $key=>$item) {
		for($count=0;$count<$groups;$count++) {
			if(array_key_exists("month",$groupByArray[$groupBy[$count]])) {
				$dateSplit = explode("-",$item['id'.$count]);
				$date = mktime(0,0,0,$dateSplit[1],$dateSplit[2],$dateSplit[0]);

				$list[$key]['id'.$count] = $dateSplit[0] . "-" . $dateSplit[1];
				$list[$key]['name'.$count] = date("M Y",$date);

			}
		}		
		$planList = $lDB->get("
			SELECT
				rv_pay_plan_item.rv_pay_plan_date,
				rv_pay_plan_item.rv_pay_plan_amount
			FROM
				rv_pay_plan_item
			WHERE
				rv_pay_plan_item.rv_reservation_id = '$item[rv_reservation_ix]'
			ORDER BY
				rv_pay_plan_item.rv_pay_plan_date
		",2);
		$folioTotal = $lDB->get("
			SELECT
				SUM(fn_folio.fn_folio_amount)
			FROM
				fn_folio
				INNER JOIN rf_database ON rf_database.rf_db_code = fn_folio.fn_folio_db
			WHERE
				fn_folio.rv_reservation_id = '$item[rv_reservation_ix]'
				AND fn_folio.rf_currency_id = '$item[rv_invoice_currency_id]'
				AND rf_database.rf_db_env_type_ind = '2'
		",4);
		if($includeExtras) {
			$folioTotal += $lDB->get("
				SELECT
					SUM(fn_folio.fn_folio_amount)
				FROM
					fn_folio
					INNER JOIN rf_database ON rf_database.rf_db_code = fn_folio.fn_folio_db
				WHERE
					fn_folio.rv_reservation_id = '$item[rv_reservation_ix]'
					AND fn_folio.rf_currency_id = '$item[rv_invoice_currency_id]'
					AND rf_database.rf_db_env_type_ind = '4'
			",4);
		}
		$planTotal = 0;
		foreach($planList as $planKey=>$planItem) {
			$planTotal += $planItem['rv_pay_plan_amount'];
		}
		if($planTotal != $folioTotal) {
			$diff = $folioTotal - $planTotal;
			$planList[sizeof($planList)-1]['rv_pay_plan_amount'] += $diff;
		}
		$paymentTotal = $lDB->get("
			SELECT
				SUM(rv_payment_item.rv_payment_item_amt)
			FROM
				rv_payment_item
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
				INNER JOIN rf_database ON rf_database.rf_db_code = fn_folio.fn_folio_db
			WHERE
				rv_payment_item.rv_reservation_id = '$item[rv_reservation_ix]'
				AND fn_folio.rf_currency_id = '$item[rv_invoice_currency_id]'
				AND rf_database.rf_db_env_type_ind = '2'
		",4);
		if($includeExtras) {
			$paymentTotal += $lDB->get("
				SELECT
					SUM(rv_payment_item.rv_payment_item_amt)
				FROM
					rv_payment_item
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
					INNER JOIN rf_database ON rf_database.rf_db_code = fn_folio.fn_folio_db
				WHERE
					rv_payment_item.rv_reservation_id = '$item[rv_reservation_ix]'
					AND fn_folio.rf_currency_id = '$item[rv_invoice_currency_id]'
					AND rf_database.rf_db_env_type_ind = '4'
			",4);
		}
		$outstanding = $folioTotal - $paymentTotal;
		$newPlanList = array();
		$currTotal = $paymentTotal;
		foreach($planList as $planKey=>$planItem) {
			if($planItem['rv_pay_plan_amount'] <= $currTotal) {
				$currTotal -= $planItem['rv_pay_plan_amount'];
			} else {
				if($currTotal > 0) {
					$planItem['outstanding'] = $planItem['rv_pay_plan_amount'] - $currTotal;
					$currTotal = 0;
				} else {
					$planItem['outstanding'] = $planItem['rv_pay_plan_amount'];
				}
				array_push($newPlanList,$planItem);
			}
		}
		if($includeCredits == "1" && $currTotal > 0) {
			$planItem = $planList[sizeof($planList)-1];
			$planItem['rv_pay_plan_amount'] = $currTotal * -1;
			$planItem['outstanding'] = $currTotal * -1;
			$newPlanList = array($planItem);
		}
		$planList = $newPlanList;
		$list[$key]['plan_list'] = $planList;
	}

	global $sortGroupCount;
	global $sortGroupByArray;
	global $sortGroupBy;

	$sortGroupCount = $groups;
	$sortGroupByArray = $groupByArray;
	$sortGroupBy = $groupBy;
	function sortGroups($a, $b) {
		global $sortGroupCount;
		global $sortGroupByArray;
		global $sortGroupBy;
		for($count=0;$count<$sortGroupCount;$count++) {
			if(array_key_exists("month",$sortGroupByArray[$sortGroupBy[$count]])) {
				$nameA = $a['id'.$count];
				$nameB = $b['id'.$count];
			} else {
				if( (isset($a['name'.$count."_1"]) && trim($a['name'.$count."_1"]) != "") || (isset($a['name'.$count."_2"]) && trim($a['name'.$count."_2"]) != "") ) {
					$nameA = trim($a['name'.$count."_1"] . " " . $a['name'.$count."_2"]);
				} else {
					$nameA = isset($a['name'.$count]) ? $a['name'.$count] : "";
				}
				if(empty($nameA)) {
					$nameA = $sortGroupByArray[$sortGroupBy[$count]]['blank'];
				}
			
				if( (isset($b['name'.$count."_1"]) && trim($b['name'.$count."_1"]) != "") || (isset($b['name'.$count."_2"]) && trim($b['name'.$count."_2"]) != "") ) {
					$nameB = trim($b['name'.$count."_1"] . " " . $b['name'.$count."_2"]);
				} else {
					$nameB = isset($b['name'.$count]) ? $b['name'.$count] : "";
				}
				if(empty($nameB)) {
					$nameB = $sortGroupByArray[$sortGroupBy[$count]]['blank'];
				}
			}
			
			if($nameA == $nameB) {
				continue;
			} else {
				return strcasecmp($nameA,$nameB);
			}
		}
		return 0;
	}

	usort($list,"sortGroups");

	if($includeSummary) {
		$lastDateArray = explode("-",$dateArray[sizeof($dateArray)-1]['end']);
		$afterToTime = mktime(0,0,0,$lastDateArray[1]+1,1,$lastDateArray[0]);
		if($report == "ageAnalysis") {
			$monthLabel = "";
		} else {
			$monthLabel = ">" . ($monthCount-1) . " months";
		}
		array_push($dateArray,array(
			'name'=>"Future",
			'start'=>date("Y-m-d",$afterToTime),
			'end'=>"9999-99-99",
			'count'=>$monthLabel
		));
	}

	if($includePrevious) {
		$firstDateArray = explode("-",$dateArray[0]['start']);
		$beforeFromTime = mktime(0,0,0,$firstDateArray[1],0,$firstDateArray[0]);
		if($report == "ageAnalysis") {
			$monthLabel = ">" . ($monthCount-1) . " months";
		} else {
			$monthLabel = "";
		}
		array_unshift($dateArray,array(
			'name'=>"Past",
			'start'=>$finalFromDate,
			'end'=>date("Y-m-d",$beforeFromTime),
			'count'=>$monthLabel
		));
	}

	$data = array();
	$label = array();
	foreach($list as $item) {
		$curr = array();
		for($count=0;$count<$groups;$count++) {
			if( (isset($item['name'.$count."_1"]) && trim($item['name'.$count."_1"]) != "") || (isset($item['name'.$count."_2"]) && trim($item['name'.$count."_2"]) != "") ) {
				$name = trim($item['name'.$count."_1"] . " " . $item['name'.$count."_2"]);
			} else {
				$name = isset($item['name'.$count]) ? $item['name'.$count] : "";
			}
			if(empty($name)) {
				$name = $groupByArray[$groupBy[$count]]['blank'];
			}
			$label[$count][$item['id'.$count]] = $name;
			array_push($curr,$item['id'.$count]);
		}
		array_push($curr,$item['rv_invoice_currency_id']);
		if(!isset($label['currency']) || !is_array($label['currency'])) {
			$label['currency'] = array();
		}
		if(!isset($label['currency'][$item['rv_invoice_currency_id']]) || !is_string($label['currency'][$item['rv_invoice_currency_id']])) {
			$label['currency'][$item['rv_invoice_currency_id']] = $lDB->get("
				SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$item[rv_invoice_currency_id]'
			",4);
		}
		$curr = join("_",$curr);
		if(!isset($data[$curr]) || !is_array($data[$curr])) {
			$data[$curr] = $dateArray;
		}
		foreach($item['plan_list'] as $planItem) {
			foreach($data[$curr] as $key=>$dateItem) {
				if($planItem['rv_pay_plan_date'] >= $dateItem['start'] && $planItem['rv_pay_plan_date'] <= $dateItem['end']) {
					if(!isset($data[$curr][$key]['value']) || !is_numeric($data[$curr][$key]['value'])) {
						$data[$curr][$key]['value'] = 0;
					}
					$data[$curr][$key]['value'] += $planItem['outstanding'];
				}
			}
		}
	}

	// Remove blank (all zero) records
	$newData = array();
	foreach($data as $key=>$dates) {
		$found = false;
		foreach($dates as $item) {
			if(!empty($item['value'])) {
				$found = true;
			}
		}
		if($found) {
			$newData[$key] = $dates;
		}
	}
	$data = $newData;

	$totals = array();
	foreach($data as $key=>$dates) {
		$groupKeys = explode("_",$key);
		$currencyId = array_pop($groupKeys);
		if(!isset($totals[$currencyId]) || !is_array($totals[$currencyId])) {
			$totals[$currencyId] = $dateArray;
		}
		foreach($dates as $dateKey=>$dateItem) {
			if(!isset($totals[$currencyId][$dateKey]['value']) || !is_numeric($totals[$currencyId][$dateKey]['value'])) {
				$totals[$currencyId][$dateKey]['value'] = 0;
			}
			$totals[$currencyId][$dateKey]['value'] += (isset($dateItem['value']) ? $dateItem['value'] : "");
		}
	}

	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$drillDownWarning = "overlib('Note that due to this report calculating totals only for the months included and the payments due calculating totals on all past months, the totals in the payments due may differ from the totals on this report.');";
		if(!$includePrevious) {
			$rowWarning = $drillDownWarning;
		} else {
			$rowWarning = "";
		}
		
		$width = 0;
		$cols = "";
		$rows = "
			<tr>
		";
		for($count=0;$count<$groups;$count++) { 
			$width += 200;
			$cols .= "
				<col width=\"200\" />
			";
			$rows .= "
				<td class=\"outDk\">".$groupByArray[$groupBy[$count]]['name']."</td>
			";
		}
		$width += 40;
		$cols .= "
			<col width=\"40\" />
		";
		$rows .= "
			<td class=\"outDk\" align=\"center\">Curr</td>
		";
		$colCount = 0;
		foreach($dateArray as $dateItem) {
			$paymentsDueUrl = array(
				/*  0 */ "reservation.php?706",
				/*  1 */ $dateItem['end'],
				/*  2 */ $fromTravelDate['jsDate'],
				/*  3 */ $toTravelDate['jsDate'],
				/*  4 */ $agentFilter['ids'],
				/*  5 */ $statusFilter['ids'],
				/*  6 */ $accommFilter['ids'],
				/*  7 */ $consultantFilter['ids'],
				/*  8 */ $paymentPlanFilter['ids'],
				/*  9 */ 0,
				/* 10 */ 0,
				/* 11 */ $includeExtras,
				/* 12 */ 0,
				/* 13 */ '',
				/* 14 */ $paymentsDueOption,
				/* 15 */ 1,
				/* 16 */ 1,
				/* 17 */ '',
				/* 18 */ 0,
				/* 19 */ 1,
				/* 20 */ 0,
				/* 21 */ 1,
				/* 22 */ $dateItem['start']
			);
			$onclick = "onclick=\"drillDown('".join("+",$paymentsDueUrl)."');\"";
			
			$width += 100;
			$cols .= "
				<col width=\"100\" id=\"dateCol$colCount\">
			";

			$rows .= "
				<td class=\"outDk\" style=\"cursor: pointer;\" align=\"right\" onmouseover=\"colOn($colCount);$drillDownWarning\" onmouseout=\"colOff($colCount);nd();\" $onclick>$dateItem[count]<br />$dateItem[name]</td>
			";
			$colCount++;
		}
		$rows .= "
			</tr>
		";
		$allowPaymentsDue = true;
		if($dateRange == "1" && $dateRangeType != "travel") {
			$allowPaymentsDue = false;
		}
		
		$drillToRes = false;
		$drillToResCount = 0;
		$agentCount = -1;
		$statusCount = -1;
		$consultantCount = -1;
		$paymentPlanCount = -1;
		for($count=0;$count<$groups;$count++) {
			if($groupBy[$count] != "all" && $groupBy[$count] != "agent" && $groupBy[$count] != "status" && $groupBy[$count] != "consultant" && $groupBy[$count] != "paymentPlan") {
				$allowPaymentsDue = false;
			}
			if($groupBy[$count] == "reservation_number" || $groupBy[$count] == "reservation_name") {
				$drillToRes = true;
				$drillToResCount = $count;
			}
			if($groupBy[$count] == "agent") {
				$agentCount = $count;
			}
			if($groupBy[$count] == "status") {
				$statusCount = $count;
			}
			if($groupBy[$count] == "consultant") {
				$consultantCount = $count;
			}
			if($groupBy[$count] == "paymentPlan") {
				$paymentPlanCount = $count;
			}
		}
		foreach($data as $key=>$item) {
			$groupKeys = explode("_",$key);
			if($allowPaymentsDue) {
				if($agentCount != -1) {
					$agentURL = $groupKeys[$agentCount];
				} else {
					$agentURL = $agentFilter['ids'];
				}
				if($statusCount != -1) {
					$statusURL = $groupKeys[$statusCount];
				} else {
					$statusURL = $statusFilter['ids'];
				}
				if($consultantCount != -1) {
					$consultantURL = $groupKeys[$consultantCount];
				} else {
					$consultantURL = $consultantFilter['ids'];
				}
				if($paymentPlanCount != -1) {
					$paymentPlanURL = $groupKeys[$paymentPlanCount];
				} else {
					$paymentPlanURL = $paymentPlanFilter['ids'];
				}
				$paymentsDueUrl = array(
					/*  0 */ "reservation.php?706",
					/*  1 */ $endDate,
					/*  2 */ $fromTravelDate['jsDate'],
					/*  3 */ $toTravelDate['jsDate'],
					/*  4 */ $agentURL,
					/*  5 */ $statusURL,
					/*  6 */ $accommFilter['ids'],
					/*  7 */ $consultantURL,
					/*  8 */ $paymentPlanURL,
					/*  9 */ 0,
					/* 10 */ 0,
					/* 11 */ $includeExtras,
					/* 12 */ 0,
					/* 13 */ '',
					/* 14 */ $paymentsDueOption,
					/* 15 */ 1,
					/* 16 */ 1,
					/* 17 */ '',
					/* 18 */ 0,
					/* 19 */ 1,
					/* 20 */ 0,
					/* 21 */ 1,
					/* 22 */ $finalFromDate
				);
				$onclick = "onclick=\"drillDown('".join("+",$paymentsDueUrl)."');\"";
			} else {
				if($drillToRes) {
					$resId = $groupKeys[$drillToResCount];
					$resJob = 0;
					if(canEditReservation($resId)) {
						$resJob = 2;
					}
					$onclick = "onclick=\"window.location = '/reservation.php?$resJob+$resId';\"";
				} else {
					$onclick = "onclick=\"openMessage('Drill-down to the payments due report is only allowed for groupings of all, agent, status, consultant and payment plan. Drill-down to a reservation is only allowed when the reservation name or reservation number groupings are used. Drill-down is also not allowed when a filter by arrival or departure date is being used.',false,160);\"";
				}
			}
			$rows .= "
				<tr class=\"imgLink\" onmouseover=\"rowOn(this);$rowWarning\" onmouseout=\"rowOff(this); nd();\" $onclick>
			";
			$count = 0;
			for($count=0; $count<sizeof($groupKeys)-1; $count++) {
				$finalLabel = $label[$count][$groupKeys[$count]];
				if(empty($finalLabel)) {
					$finalLabel = "&nbsp;";
				}
				$rows .= "
					<td class=\"outLt\">".$finalLabel."</td>
				";
			}
			$rows .= "
				<td class=\"outLt\" align=\"center\">".$label['currency'][$groupKeys[sizeof($groupKeys)-1]]."</td>
			";
			foreach($item as $dateItem) {
				$value = isset($dateItem['value']) ? $dateItem['value'] : "";
				if(empty($value)) {
					$value = "&nbsp;";
				} else {
					fixAmtDisplay($value,2);
				}

				$rows .= "
					<td class=\"br bb\" align=\"right\">$value</td>
				";
			}
			$rows .= "
				</tr>
			";
		}
		$first = true;
		foreach($totals as $key=>$dates) {
			$totalLabel = "&nbsp;";
			if($first) {
				$totalLabel = "Totals&nbsp;";
			}
			$rows .= "
				<tr>
					<td colspan=\"".$groups."\" align=\"right\" class=\"outDk\">$totalLabel</td>
					<td class=\"outDk\" align=\"center\">".$label['currency'][$key]."</td>
			";
			foreach($dates as $date) {
				$value = $date['value'];
				if(empty($value)) {
					$value = "&nbsp;";
				} else {
					fixAmtDisplay($value,2);
				}
				$rows .= "
					<td class=\"br bb txtb\" align=\"right\">$value</td>
				";
			}
			$rows .= "
				</tr>
			";
			$first = false;
		} 
		$GLOBALS['temp']['dataWidth'] = $width;
		$GLOBALS['temp']['cols'] = $cols;
		$GLOBALS['temp']['rows'] = $rows;
		 
		if(sizeof($data) == 0) {
			$GLOBALS['temp']['dataWidth'] = 750;
			$GLOBALS['temp']['cols'] = "<col width=\"750\">";
			$GLOBALS['temp']['rows'] = "
				<tr>
					<td class=\"txti\" align=\"center\">No data matched your filter criteria.</td> 
				</tr>
			";
		}
	}

	if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		if($report == "ageAnalysis") {
			$reportLabel = "Age Analysis";
		} else {
			$reportLabel = "Cash Flow Forecast";
		}
		$pdf = new PDF($reportLabel);

		// Main PDF header
	
		$headerArray = array(
			array('name'=>"Agent", 'value'=>$agentFilter['names']),
		);
		$pdf->ReportHeader($reportLabel, $headerArray);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetFont('Arial', '', 6);

		$pdf->Ln(2);		

		if($renderType == "view") {
			pdf_view($pdf);
		}

		if($renderType == "send") {
			pdf_send($pdf,$reportLabel);
		}
	}
	
	if($renderMode == "csv") {
		$csvFile = array();
		
		if($report == "ageAnalysis") {
			$filename = "age_analysis_".str_replace(" ","_",chng_date(date("Y-m-d"),"-"));
		} else {
			$filename = "cash_flow_forecast_".str_replace(" ","_",chng_date(date("Y-m-d"),"-"));
		}
		
		$csvFile = array();
		$headerLine = array();
		
		array_push($csvFile,array("$report Report"));
		array_push($csvFile,array());
		array_push($csvFile,array("Months",$monthCount));
		array_push($csvFile,array("Include past column",$includePrevious=="1"?"Yes":"No"));
		array_push($csvFile,array("Include future column",$includeSummary=="1"?"Yes":"No"));
		array_push($csvFile,array("Agent",$agentFilter['names']));
		array_push($csvFile,array("Status",$statusFilter['names']));
		array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
		array_push($csvFile,array("Consultant",$consultantFilter['names']));
		array_push($csvFile,array("Payment Plan",$paymentPlanFilter['names']));
		array_push($csvFile,array("grouping Options"));
		foreach($groupBy as $key=>$group) {
			array_push($csvFile,array("level".($key+1),$group));
		}
		array_push($csvFile,array("Include Credits",$includeCredits=="1"?"Yes":"No"));
		array_push($csvFile,array("Include Onsite Extras",$includeExtras=="1"?"Yes":"No"));
		if($dateRange == "1") {
			array_push($csvFile,array("Travel date range",$fromTravelDate['jsDate']." to ".$toTravelDate['jsDate']));
		}
		if($overrideStartDate == "1") {
			array_push($csvFile,array("Override start date",$finalFromDate));
		}
		array_push($csvFile,array());
		for($count=0;$count<$groups;$count++) { 
			$headerLine[] = $groupByArray[$groupBy[$count]]['name'];
		}
		$headerLine[] = "Curr";
		foreach($dateArray as $dateItem) {
			$headerLine[] = "(".$dateItem['count']." ".$dateItem['name'].")";
		}
		array_push($csvFile,$headerLine);

		foreach($data as $key=>$item) {
			$dataLine = array();
			$groupKeys = explode("_",$key);
			for($count=0; $count<sizeof($groupKeys)-1; $count++) {
				$finalLabel = $label[$count][$groupKeys[$count]];
				$dataLine[] = $finalLabel;
			}
			
			$dataLine[] = $label['currency'][$groupKeys[sizeof($groupKeys)-1]];
			
			foreach($item as $dateItem) {
				if(!empty($dateItem['value'])) {
					fixAmtDisplay($dateItem['value'],2);
				} else {
					$dateItem['value'] = "";
				}
				$dataLine[] = $dateItem['value'];
			}
			array_push($csvFile,$dataLine);
		}
		
		$first = true;
		foreach($totals as $key=>$dates) {
			$dataLine = array();
			$totalLabel = "";
			if($first) {
				$totalLabel = "Totals";
			}
			$dataLine[] = $totalLabel;
			for($count=0; $count<sizeof($groupKeys)-2; $count++) {
				$dataLine[] = "";
			}
			$dataLine[] = $label['currency'][$key];
			
			foreach($dates as $date) {
				if(!empty($date['value'])) {
					fixAmtDisplay($date['value'],2);
				} else {
					$date['value'] = "0";
				}
				$dataLine[] = $date['value'];
			}
			array_push($csvFile,$dataLine);
			$first = false;
		}

		csv_output($filename,$csvFile);
	}	
}
