<?php

/**
 * init.form376.func.data.php - Operations chart data functions
 */

function short_date ($olddate,$more=":"){
	if ($olddate != "" && $olddate != "0000-00-00" && $olddate != "0000-00-00 00:00:00" && $olddate != "0") {
		list($year,$month,$day) = explode($more,$olddate);
		
		if ($month < 1) { $month = "01"; }
		if ($day < 1) { $day = "01"; }
		return ($day.$more.$month.$more.$year);	
	}
}

function getFieldArray($field) {
	$fieldList = preg_split("/ as /i",$field);
	$alias = isset($fieldList[1]) ? trim($fieldList[1]) : "";
	$fieldList = explode(".",$fieldList[0]);
	$table = trim($fieldList[0]);
	$field = trim($fieldList[1]);
	return array('table'=>$table, 'field'=>$field, 'alias'=>$alias);
}

function getFieldName($field) {
	$fieldArray = getFieldArray($field);
	if($fieldArray['alias'] != "") {
		return $fieldArray['alias'];
	} else {
		return $fieldArray['field'];
	}
}

function getFieldTable($field) {
	$fieldArray = getFieldArray($field);
	return $fieldArray['table'];
}

function inJoin($alias,$joins=array()) {
	foreach($joins as $join) {
		if( (isset($join['alias']) && $join['alias'] == $alias) || (isset($join['table']) && $join['table'] == $alias) ) {
			return true;
		}
	}
	return false;
}

function buildSQL($chartSections,$chartIds,$chartName,$joins) {
	if($chartName != "") {
		$showIds = $chartIds[$chartName];
		$colourIds = $chartIds['colour'];
	} else {
		$showIds = $chartIds;
		$colourIds = array();
	}
	$select = array();
	$from = array();
	foreach($chartSections as $item) {		
		if(in_array($item['id'],$showIds)) {
			$fields = array();
			if(isset($item['fields']) && is_array($item['fields'])) {
				$fields = $item['fields'];
			}
			if(in_array($item['id'],$colourIds) && is_array($item['colour']) && is_array($item['colour']['fields'])) {
				$fields = array_merge($fields,$item['colour']['fields']);
			}	
			foreach($fields as $field) {
				if(inJoin(getFieldTable($field),$joins) && !in_array($field,$select)) {
					array_push($select,$field);
					$fieldArray = explode(".",$field);
					$from = array_merge($from,getJoins($fieldArray[0],$joins));
				}
			}	
		}
	}
	$select = array_unique($select);
	$from = array_unique($from);
	return array('select'=>$select, 'from'=>$from);
}

function getJoins($alias,$joins=array()) {
	foreach($joins as $join) {
		if( (isset($join['alias']) && $join['alias'] == $alias) || ( (!isset($join['alias']) || $join['alias'] == "") && (isset($join['table']) && $join['table'] == $alias) )) {
			if(!array_key_exists("type",$join)) {
				return array($join['table']);
			} else {
				if(!isset($join['alias']) || $join['alias'] == "") {
					$result = array("$join[type] JOIN $join[table] ON $join[on]");
				} else {
					$result = array("$join[type] JOIN $join[table] AS $join[alias] ON $join[on]");
				}
				if(isset($join['requires']) && $join['requires'] != "") {
					$require = getJoins($join['requires'],$joins);
					return array_merge($require,$result);
				} else {
					return $result;
				}
			}
		}
	}
}

global $noteReservations;
$noteReservations = array();
function buildCell($chartSections,$chartIds,$chartName,$dataSet,$date,$extraWhere,$showExtra,$showCatExtra="", $componentsWhere="", $rateWhere="") {
	global $noteReservations;
	$showIds = $chartIds[$chartName];
	$colourIds = $chartIds['colour'];
	$room = array();
	
	foreach($showIds as $showId) {
		$fields = array();
		$colourFields = array();
		foreach($chartSections as $item) {
			if($item['id'] == $showId) {
				if(array_key_exists("fields",$item)) {
					foreach($item['fields'] as $field) {
						$fieldName = getFieldName($field);
						$fieldValue = isset($dataSet[$fieldName]) ? $dataSet[$fieldName] : "";

						if(trim($fieldValue) == "" || $fieldValue == "0") {
							array_push($fields,"");
						} else {
							if($item['type'] == "date") {
								$fieldValue = chng_date($fieldValue,"-");
							}
							array_push($fields,$fieldValue);
						}
					}
				}
				if($item['type'] != "complex") {
					$fieldValue = trim(join(" ",$fields));
					if(array_key_exists("blank",$item) && $fieldValue == "") {
						$fieldValue = $item['blank'];
					}
				} else {
					if(isset($item['function']) && function_exists($item['function'])) {
						array_push($fields,$date,$extraWhere,$showExtra,$dataSet['pr_business_id'], $showCatExtra, $componentsWhere, $rateWhere);
						$fieldValue = call_user_func_array($item['function'],$fields);
					} else {
						$fieldValue = "NOT IMPLEMENTED";
					}
				}
				if(in_array($showId,$colourIds) && array_key_exists("function",$item['colour'])) {
					foreach($item['colour']['fields'] as $field) {
						$fieldName = getFieldName($field);
						array_push($colourFields,isset($dataSet[$fieldName])?$dataSet[$fieldName]:"");
					}
					if(function_exists($item['colour']['function'])) {
						$fieldColour = call_user_func_array($item['colour']['function'],$colourFields);
					}
					//$fieldColour = "00ff00";
				} else {
					$fieldColour = "";
				}
			}
		}
		
		$room[$showId] = array('value'=>(isset($fieldValue) ? $fieldValue : ""),'colour'=>(isset($fieldColour) ? $fieldColour : ""));
	}
	array_push($noteReservations,$dataSet['rv_reservation_ix']);
	$room['rf_reservation_status_id'] = $dataSet['rf_reservation_status_id'];
	$room['rv_provision_expiry_date'] = $dataSet['rv_provision_expiry_date'];
	$room['rv_reservation_id'] = $dataSet['rv_reservation_ix'];
	$room['rv_res_name'] = isset($dataSet['rv_res_name']) ? $dataSet['rv_res_name'] : "";

	return $room;
}
/**
 * This function builds up the data needed for one day
 */
 
function buildDay($chartSections,$chartIds,$chartName,$dataSet,$date,$extraWhere,$showExtra, $showCatExtra, $componentsWhere='', $rateWhere='') {
	if(sizeof($dataSet) == 0) {
		$cell = array();
	} else {
		$cell = buildCell($chartSections,$chartIds,$chartName,$dataSet[0],$date,$extraWhere,$showExtra, $showCatExtra, $componentsWhere, $rateWhere);
		if(sizeof($dataSet) > 1) { // Overbooking
			$cell['overbooked'] = true;
			$overbookedList = array();
			foreach($dataSet as $item) {
				array_push($overbookedList,$item['rv_reservation_ix']);
			}
			$cell['overbookedList'] = $overbookedList;
		}
	}
	return $cell;
}

function getRoomDayData($chartSections,$chartIds,$roomJoins,$ac_accomm_room_id,$date,$statusFilter,$extraWhere,$showExtra, $showCatExtra, $componentsWhere='', $combArrSo=1, $rateWhere='') {
	global $lDB;

	// Check room for inactivation and/or blocking
	$blocked = false;

	$blockCheck = $lDB->get("
		SELECT
			count(ac_accomm_room_block.ac_accomm_room_block_ix)
		FROM
			ac_accomm_room_block
			INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
		WHERE
			ac_accomm_room_block.ac_accomm_room_id = '$ac_accomm_room_id'
			AND ac_accomm_block.ac_start_date <= '$date'
			AND ac_accomm_block.ac_end_date > '$date'
	",4);
	$activeCheck = $lDB->get("
		SELECT
			COUNT(DISTINCT ac_accomm_room_ix)
		FROM
			ac_accomm_room
		WHERE
			ac_accomm_room.ac_accomm_room_ix = '$ac_accomm_room_id'
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date > '$date'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date < '$date'
				)
			)
		
	",4);
	if($blockCheck > 0 || $activeCheck > 0) {
		$blocked = true;
	}

	// Build up data for in house bookings
	$roomShowIds = $chartIds['room'];
	if(sizeof($roomShowIds) > 0) {
		$sql = buildSQL($chartSections,$chartIds,'room',$roomJoins);
		$select = array(
			"rv_reservation.rv_reservation_ix",
			"rv_reservation.rf_reservation_status_id",
			"rv_reservation.rv_provision_expiry_date",
			"rv_reservation_item.pr_business_id"
		);
		$select = array_unique(array_merge($sql['select'],$select));
		$fromFirst = array(
			"rv_res_item_group"
		);
		$from = array(
			"INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id",
			"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id"
		);
		$from = array_unique(array_merge($fromFirst,array_merge($from,$sql['from'])));
		
		if($combArrSo == '1') {
			$sql = "
				SELECT
					".join("
,",$select)."
				FROM
					".join("
",$from)."
				WHERE
					rv_res_item_group.ac_accomm_room_id = '$ac_accomm_room_id'
					AND rv_reservation_item.rv_item_date_arrive <= '$date'
					AND rv_reservation_item.rv_item_date_depart > '$date'
					$statusFilter
					$rateWhere
				";
		} else {
			$sql = "
				SELECT
					".join("
,",$select)."
				FROM
					".join("
",$from)."
				WHERE
					rv_res_item_group.ac_accomm_room_id = '$ac_accomm_room_id'
					AND rv_reservation_item.rv_item_date_arrive = '$date'
					$statusFilter
					$rateWhere
				";
		}
		
		$inRoom = $lDB->get($sql,2);
		$room = buildDay ($chartSections,$chartIds,'room',$inRoom,$date,$extraWhere,$showExtra, $showCatExtra, $componentsWhere, $rateWhere);
	}

	// Build up data for departures
	$departShowIds = $chartIds['depart'];
	if(sizeof($departShowIds) > 0) {
		$sql = buildSQL($chartSections,$chartIds,'depart',$roomJoins);
		$select = array(
			"rv_reservation.rv_reservation_ix",
			"rv_reservation.rf_reservation_status_id",
			"rv_reservation.rv_provision_expiry_date",
			"rv_reservation_item.pr_business_id"
		);
		$select = array_unique(array_merge($sql['select'],$select));
		$fromFirst = array(
			"rv_res_item_group"
		);
		$from = array(
			"INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id",
			"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id"
		);
		
		$from = array_unique(array_merge($fromFirst,array_merge($from,$sql['from'])));
		$depart = $lDB->get("
			SELECT
				".join("
,",$select)."
			FROM
				".join("
",$from)."
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$ac_accomm_room_id'
				AND rv_reservation_item.rv_item_date_depart = '$date'
				$statusFilter
				$rateWhere
			",2);
		$depart = buildDay($chartSections,$chartIds,'depart',$depart,$date,$extraWhere,$showExtra, $showCatExtra, $componentsWhere, $rateWhere);
	}

	if($combArrSo == '2') {
		// Build up data for stay over
		$roomSoverIds = $chartIds['stayOver'];
		if(sizeof($roomSoverIds) > 0) {
			$sql = buildSQL($chartSections,$chartIds,'stayOver',$roomJoins);
			$select = array(
				"rv_reservation.rv_reservation_ix",
				"rv_reservation.rf_reservation_status_id",
				"rv_reservation.rv_provision_expiry_date",
				"rv_reservation_item.pr_business_id"
			);
			$select = array_unique(array_merge($sql['select'],$select));
			$fromFirst = array(
				"rv_res_item_group"
			);
			$from = array(
				"INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id",
				"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id"
			);
			$from = array_unique(array_merge($fromFirst,array_merge($from,$sql['from'])));
			$soRoom = $lDB->get("
				SELECT
					".join("
,",$select)."
				FROM
					".join("
",$from)."
				WHERE
					rv_res_item_group.ac_accomm_room_id = '$ac_accomm_room_id'
					AND rv_reservation_item.rv_item_date_arrive < '$date'
					AND rv_reservation_item.rv_item_date_depart > '$date'
					$statusFilter
					$rateWhere
				",2);
			
			$stayOver = buildDay($chartSections,$chartIds,'stayOver',$soRoom,$date,$extraWhere,$showExtra, $showCatExtra, $componentsWhere, $rateWhere);
		}
	} else {
		$stayOver = array();
	}


	$day = array(
		'room'=>(isset($room) ? $room : array()),
		'depart'=>(isset($depart) ? $depart : array()),
		'stayOver'=>(isset($stayOver) ? $stayOver : array()),
		'block'=>$blocked
	);
	return $day;
}

function compareNights($a, $b) {
	if(
		(
			$a['rf_reservation_status_id'] == 15
			&& $b['rf_reservation_status_id'] == 15
		) || (
			$a['rf_reservation_status_id'] > 15
			&& $b['rf_reservation_status_id'] > 15
		)
	) {
		$nightsA = dateSubtract($a['rv_item_date_depart'],$a['rv_item_date_arrive']);
		$nightsB = dateSubtract($b['rv_item_date_depart'],$b['rv_item_date_arrive']);
	    if ($nightsA == $nightsB) {
    	    return 0;
	    }
    	return ($nightsA > $nightsB) ? -1 : 1;
	} else {
		return ($a['rf_reservation_status_id'] > $b['rf_reservation_status_id']) ? -1 : 1;
	}
}

function getUnallocated($chartSections,$chartIds,$itemJoins,$fromDate,$toDate,$accommWhere,$statusWhere, $showCatExtras='', $componentsWhere='', $rateWhere='') {
	global $lDB;
	$sql = buildSQL($chartSections,$chartIds,"combined",$itemJoins);
	$select = array(
		"rv_reservation.rv_reservation_ix",
		"rv_reservation_item.rv_reservation_item_ix",
		"rv_reservation_item.rv_item_accomm_count",
		"rv_reservation_item.rv_item_date_arrive",
		"rv_reservation_item.rv_item_date_depart",
		"ac_accomm_type.ac_accomm_type_ix",
		"rv_reservation.rf_reservation_status_id",
		"rv_reservation.rv_provision_expiry_date",
		"rv_reservation.rv_alloc_expiry_date",
		"rv_reservation.rv_alloc_expiry_days",
		"rv_reservation_item.pr_business_id"
	);
	$select = array_unique(array_merge($sql['select'],$select));
	$fromFirst = array(
		"rv_reservation_item"
	);
	$from = array(
		"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",
		"INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id"
	);
	$from = array_unique(array_merge($fromFirst,array_merge($sql['from'],$from)));
	
	$list = $lDB->get("
		SELECT
			".join(",
",$select)."
		FROM
			".join("
",$from)."
		WHERE
			(
				(
					rv_reservation_item.rv_item_date_arrive >= '$fromDate' 
					AND rv_reservation_item.rv_item_date_arrive <= '$toDate'
				) OR (
					rv_reservation_item.rv_item_date_depart >= '$fromDate' 
					AND rv_reservation_item.rv_item_date_depart <= '$toDate'
				) OR (
					rv_reservation_item.rv_item_date_arrive < '$fromDate' 
					AND rv_reservation_item.rv_item_date_depart > '$toDate'
				)
			)
			$accommWhere
			$statusWhere
			$rateWhere
			AND (
				(
					rv_reservation.rf_reservation_status_id <> '20'
					AND rv_reservation.rf_reservation_status_id <> '15'
				) OR (
					rv_reservation.rf_reservation_status_id = '20'
					AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
				) OR (
					rv_reservation.rf_reservation_status_id = '15'
					AND rv_reservation.rv_alloc_expiry_date <> '0000-00-00'
					AND rv_reservation.rv_alloc_expiry_date >= '" . date("Y-m-d") . "'
				) OR (
					rv_reservation.rf_reservation_status_id = '15'
					AND rv_reservation.rv_alloc_expiry_date = '0000-00-00'
					AND rv_reservation.rv_alloc_expiry_days <= ".dateSubtract($toDate, date("Y-m-d"))."
				)				
			)
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
	",2);
	
	$newList = array();
	foreach($list as $item) {
		$allow = true;

		$roomCount = $lDB->get("
			SELECT
				COUNT(rv_res_item_group.rv_res_item_group_ix)
			FROM
				rv_res_item_group
				LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_res_item_group.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
				AND ac_accomm_room.ac_accomm_room_ix IS NOT NULL
		",4);
		$item['rv_item_room_count'] = $roomCount;
		if($item['rv_item_room_count'] >= $item['rv_item_accomm_count']) {
			$allow = false;
		}


		if($item['rf_reservation_status_id'] == "15" && $item['rv_alloc_expiry_date'] == "0000-00-00") {
			$today = date("Y-m-d");
			$todayArray = explode("-",$today);
			$checkDate = date("Y-m-d",mktime(0,0,0,$todayArray[1],$todayArray[2]+$item['rv_alloc_expiry_days'],$todayArray[0]));
			$fromDate = $item['rv_item_date_arrive'];
			$toDate = $item['rv_item_date_depart'];
			if($checkDate > $fromDate) {
				$fromDate = $checkDate;
			}
			if($fromDate > $toDate) {
				$allow = false;
			}
			$item['rv_item_date_arrive'] = $fromDate;
		}

		if($allow) {
			$unroomedGroups = $lDB->get("
				SELECT
					rv_res_item_group.rv_res_item_group_ix
				FROM
					rv_res_item_group
					LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				WHERE
					rv_res_item_group.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
					AND ac_accomm_room.ac_accomm_room_ix IS NULL
			",3);
			foreach($unroomedGroups as $rv_res_item_group_id) {
				$guestCount = $lDB->get("
					SELECT
						COUNT(rv_res_item_guest.rv_res_item_guest_ix)
					FROM
						rv_res_item_guest
					WHERE
						rv_res_item_guest.rv_res_item_group_id = '$rv_res_item_group_id'
				",4);
				if($guestCount > 0) {
					$extraItem = $item;
					$extraItem['rv_item_room_count'] = 0;
					$extraItem['rv_item_accomm_count'] = 1;
					$extraItem['rv_res_item_group_ix'] = $rv_res_item_group_id;
					$item['rv_item_accomm_count'] -= 1;
					array_push($newList,$extraItem);
				}
			}

			if($item['rv_item_accomm_count'] > 0) {
				array_push($newList,$item);
			}
		}
	}
	$list = $newList;
	usort($list,"compareNights");
	return $list;
}

function &bindCell(&$chart,$chartName,$room,$date) {
	if($chart['direction'] == 1) {
		return $chart[$chartName][$date][$room];
	} else {
		return $chart[$chartName][$room][$date];
	}
}

function findRoom($chartSections,$chartIds,&$chart,$item,$extraWhere,$showExtra, $showCatExtras="", $componentsWhere="", $rateWhere='') {

	$ac_accomm_type_id = $item['ac_accomm_type_ix'];
	$fromDate = $item['rv_item_date_arrive'];
	$toDate = $item['rv_item_date_depart'];
	if($chart['direction'] == 1) {
		$dateKey = 'rows';
		$roomKey = 'columns';
	} else {
		$dateKey = 'columns';
		$roomKey = 'rows';
	}
	
	$dates = array_keys($chart[$dateKey]);
	$chartFromDate = $dates[0];
	$chartToDate = $dates[sizeof($dates)-1];
	$days = dateSubtract($toDate,$fromDate);
	$fromDateArray = explode("-",$fromDate);

	// Create a list of stayover dates
	$roomDates = array();
	$soDates = array();
	for($count=0; $count<$days; $count++) {
		$newDate = date("Y-m-d",mktime(0,0,0,$fromDateArray[1],$fromDateArray[2]+$count,$fromDateArray[0]));
		if($chart['combArrSty'] == '2') {
			if($newDate == $fromDate) {
				if($newDate >= $chartFromDate && $newDate <= $chartToDate) {
					array_push($roomDates,$fromDate);
				}
			}
			
			//if($chartFromDate > $fromDate && $toDate > $chartToDate) {
			if($newDate > $fromDate && $toDate > $newDate) {
				if($newDate >= $chartFromDate && $newDate <= $chartToDate) {
					array_push($soDates,$newDate);
				}
			}
			
		} else {
			if($newDate >= $chartFromDate && $newDate <= $chartToDate) {
				array_push($roomDates,$newDate);
			}
		}
	}
	$allDates = array_unique(array_merge($roomDates,$soDates));
		
	foreach($chart[$roomKey] as $room) {	// Iterate through all rooms ...
		if($room['ac_accomm_type_ix'] == $ac_accomm_type_id) {//and find the correct accommodation type 
			$found = true;

			foreach($allDates as $date) { // Check if this item will fit ..
				if(sizeof(bindCell($chart,'room',$room['id'],$date)) != 0 || sizeof(bindCell($chart,'stayOver',$room['id'],$date)) != 0 || bindCell($chart,'block',$room['id'],$date)) {
					$found = false;
				}
				if($chart['combArrSty'] == '2' && sizeof(bindCell($chart,'stayOver',$room['id'],$date)) != 0) {
					$found = false;
				}
			}

/*			foreach($roomDates as $date) { // Check if this item will fit ..
				if(sizeof(bindCell($chart,'room',$room['id'],$date)) != 0 || sizeof(bindCell($chart,'stayOver',$room['id'],$date)) != 0 || bindCell($chart,'block',$room['id'],$date)) {
					$found = false;
				}
			}

			if($chart['combArrSty'] == '2') {
				foreach($soDates as $date) { // Check if this item will fit ..
					if(sizeof(bindCell($chart,'room',$room['id'],$date)) != 0 || sizeof(bindCell($chart,'stayOver',$room['id'],$date)) != 0 || bindCell($chart,'block',$room['id'],$date)) {
						$found = false;
					}
				}
			}*/
			if($toDate <= $chartToDate) { // If the departure date lies on the chart, check it as well...
				if(sizeof(bindCell($chart,'depart',$room['id'],$toDate)) != 0) {
					$found = false;
				}
			}
			if($found == true) { // Finally, if it fits in this room, allocate it...
				foreach($roomDates as $date) {
					// Bind the variable $cell to the correct cell in the room chart
					$cell =& bindCell($chart,'room',$room['id'],$date); 
					$cell = buildCell($chartSections,$chartIds,'room',$item,$date,$extraWhere,$showExtra, $showCatExtras, $componentsWhere, $rateWhere);
				} 
				if($chart['combArrSty'] == '2') {
					foreach($soDates as $date) {
						// Bind the variable $cell to the correct cell in the stay over chart
						$cell =& bindCell($chart,'stayOver',$room['id'],$date); 
						$cell = buildCell($chartSections,$chartIds, 'stayOver',$item,$date,$extraWhere, $showExtra, $showCatExtras, $componentsWhere, $rateWhere);
					}
				}
				if($toDate <= $chartToDate) {
					// Bind the variable $cell to the correct cell in the depart chart
					$cell =& bindCell($chart,'depart',$room['id'],$toDate); 
					$cell = buildCell($chartSections,$chartIds,'depart',$item,$toDate,$extraWhere,$showExtra, $showCatExtras, $componentsWhere, $rateWhere);
				}
				return true;
			}
		}
	}
	return false;
}

function addOverbooking($chartSections,$chartIds,&$chart,$item,$extraWhere,$showExtra, $showCatExtras="", $componentsWhere="", $rateWhere="") {
	global $lDB;
	static $overbookingCount = 0;
	$ac_accomm_type_id = $item['ac_accomm_type_ix'];
	$fromDate = $item['rv_item_date_arrive'];
	$toDate = $item['rv_item_date_depart'];
	if($chart['direction'] == 1) {
		$dateKey = 'rows';
		$roomKey = 'columns';
	} else {
		$dateKey = 'columns';
		$roomKey = 'rows';
	}
	$dates = array_keys($chart[$dateKey]);
	$chartFromDate = $dates[0];
	$chartToDate = $dates[sizeof($dates)-1];
	$days = dateSubtract($toDate,$fromDate);
	$fromDateArray = explode("-",$fromDate);

	// Create a list of stayover dates
	$roomDates = array();
	$soDates = array();
	for($count=0; $count<$days; $count++) {
		$newDate = date("Y-m-d",mktime(0,0,0,$fromDateArray[1],$fromDateArray[2]+$count,$fromDateArray[0]));
		if($chart['combArrSty'] == '2') {
			if($newDate == $fromDate) {
				if($newDate >= $chartFromDate && $newDate <= $chartToDate) {
					array_push($roomDates,$fromDate);
				}
			}
			
			//if($chartFromDate > $fromDate && $toDate > $chartToDate) {
			if($newDate > $fromDate && $toDate > $newDate) {
				if($newDate >= $chartFromDate && $newDate <= $chartToDate) {
					array_push($soDates,$newDate);
				}
			}
		} else {
			if($newDate >= $chartFromDate && $newDate <= $chartToDate) {
				array_push($roomDates,$newDate);
			}
		}
	}
	
	$property = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$item[pr_business_id]'", 4);
	$accommodation = $lDB->get("SELECT ac_accomm_desc FROM ac_accomm_type WHERE ac_accomm_type_ix = '$item[ac_accomm_type_ix]'", 4);
	
	$tempArr = array();
	$lastProp = "";
	$firstFlag = 1;

	$stprop = '';
	static $stpropArr = array();
	$firstProp = 1;
	$colcount = 1;
	$propCount = 0;
	foreach($chart[$roomKey] as $k=>$val) {
		if ( $property == $val['property']) {
			$propCount += 1;
		}
	}
	
	foreach($chart[$roomKey] as $k=>$val) {
		$tempArr[$k] = $val;
		if ( $property == $val['property']) {
			if($colcount == $propCount) {
				$tempArr['overbooking'.$overbookingCount] = array(
					'id'=>"overbooking".$overbookingCount,
					'ac_accomm_type_ix'=>"overbooking",
					'property'=>$property,
					'accommodation'=>$accommodation,
					'room'=>"overbooking",
					'name'=>"Overbooking
". ($overbookingCount+1)	
				); 
			}
			$colcount++;
		}
	}

	$chart[$roomKey] = $tempArr;

	foreach($roomDates as $date) {
		$cell =& bindCell($chart,'room','overbooking'.$overbookingCount,$date);
		$cell = buildCell($chartSections,$chartIds,'room',$item,$date,$extraWhere,$showExtra, $showCatExtras, $componentsWhere, $rateWhere);
	}
	if($chart['combArrSty'] == '2') {
		foreach($soDates as $date) {
			// Bind the variable $cell to the correct cell in the stay over chart
			$cell =& bindCell($chart,'stayOver','overbooking'.$overbookingCount,$date); 
			$cell = buildCell($chartSections,$chartIds, 'stayOver',$item,$date,$extraWhere, $showExtra, $showCatExtras, $componentsWhere, $rateWhere);
		}
	}
	
	if($toDate <= $chartToDate) {
		$cell =& bindCell($chart,'depart','overbooking'.$overbookingCount,$toDate);
		$cell = buildCell($chartSections,$chartIds,'depart',$item,$toDate,$extraWhere,$showExtra, $showCatExtras, $componentsWhere, $rateWhere);
	}
	$overbookingCount++;
	
}

function roomUnallocated($chartSections,$chartIds,&$chart,$unallocated,$extraWhere,$showExtra, $showCatExtras="", $componentsWhere="", $rateWhere="") {
	foreach($unallocated as $item) {
		$needed = $item['rv_item_accomm_count'] - $item['rv_item_room_count'];
		for($count=0; $count<$needed; $count++) {
			if(!findRoom($chartSections,$chartIds,$chart,$item,$extraWhere,$showExtra, $showCatExtras, $componentsWhere, $rateWhere)) {
				addOverbooking($chartSections,$chartIds,$chart,$item,$extraWhere,$showExtra, $showCatExtras, $componentsWhere, $rateWhere);
			}
		}
	}
}

function buildNote($noteSections,$noteIds,$dataSet) {

	$note = array(
		'rv_reservation_ix'=>$dataSet['rv_reservation_ix'],
		'rv_res_name'=>$dataSet['rv_res_name'],
		'rv_date_arrive'=>$dataSet['rv_date_arrive'],
		'rv_date_depart'=>$dataSet['rv_date_depart'],
		'property'=>$dataSet['property'],
		'pr_business_id'=>$dataSet['pr_business_id'],
		'property_short_name_list'=>$dataSet['property_short_name_list'],
		'rv_date_arrive_fmt'=>chng_date($dataSet['rv_date_arrive'],"-"),
		'rv_date_depart_fmt'=>chng_date($dataSet['rv_date_depart'],"-"),
		'adult'=>$dataSet['adult'],
		'child'=>$dataSet['child'],
		'nights'=>$dataSet['nights'],
		'accom'=>$dataSet['accom'],
		'rooms'=>$dataSet['rooms'],
		'sections'=>array()
	);
	$notes =& $note['sections'];
	$hide = false;
	foreach($noteIds as $noteId) {
		$fields = array();
		foreach($noteSections as $item) {
			if($item['id'] == $noteId) {
				if($item['type'] == "ignore") {
					continue;
				}
				$key = "";
				if(array_key_exists("key",$item)) {
					$key = $item['key'];
				}
				$hide = isset($item['hide']) ? $item['hide'] : false;
				if(array_key_exists("fields",$item)) {
					foreach($item['fields'] as $field) {
						$fieldName = getFieldName($field);
						$fieldValue = $dataSet[$fieldName];
						if(trim($fieldValue) == "" || $fieldValue == "0") {
							array_push($fields,"");
						} else {
							if($item['type'] == "date") {
								$fieldValue = chng_date($fieldValue,"-");
							}
							array_push($fields,$fieldValue);
						}
					}				
				}
				if($item['type'] != "complex") {
					$fieldValue = trim(join(" ",$fields));
					if(array_key_exists("blank",$item) && $fieldValue == "") {
						$fieldValue = $item['blank'];
					}
				} else {
					if(isset($item['function']) && function_exists($item['function'])) {
						$fieldValue = call_user_func_array($item['function'],$fields);
					} else {
						$fieldValue = "NOT IMPLEMENTED";
					}
				}
			}
		}
		if(!$hide && isset($fieldValue)) {
			$notes[$noteId] = $fieldValue;
			if(isset($key) && $key != "") {
				$note[$key] = $fieldValue;
			}
		}
	}
	return $note;
}

function getNotes($noteSections,$noteIds,$resJoins,$resId,$noteDate,$accommWhere) {
	global $lDB;
	
	if(sizeof($noteIds) > 0) {
		$sql = buildSQL($noteSections,$noteIds,'',$resJoins);
		$select = array(
			"rv_reservation.rv_reservation_ix",
			"rv_reservation.rv_res_name",
			"rv_reservation.rv_date_arrive",
			"rv_reservation.rv_date_depart"
		);
		$select = array_unique(array_merge($sql['select'],$select));
		$from = array(
			"rv_reservation"
		);
		$from = array_unique(array_merge($sql['from'],$from));
		
		$list = $lDB->get("
			SELECT
				".join(",
",$select)."
			FROM
				".join("
",$from)."
			WHERE
				rv_reservation.rv_reservation_ix = '$resId'
		",1);

		$propList = $lDB->get("
				SELECT
					rv_reservation_item.pr_business_id,rv_reservation_item.rv_item_adult_count, rv_reservation_item.rv_item_child_count, rv_reservation_item.rv_item_nights, 
					rv_reservation_item.rv_item_accomm_count,
					pr_persona.pr_name_last,
					ac_accomm_type.ac_accomm_desc,
					pr_business.pr_bus_name_short
				FROM
					rv_reservation_item
					INNER JOIN pr_persona ON rv_reservation_item.pr_business_id = pr_persona.pr_persona_ix
					INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
					INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
				WHERE
					rv_reservation_item.rv_reservation_id = '$resId'
		",2);
		$list['pr_business_id'] = $propList[0]['pr_business_id'];
		$list['adult'] = $propList[0]['rv_item_adult_count'];
		$list['child'] = $propList[0]['rv_item_child_count'];
		$list['nights'] = $propList[0]['rv_item_nights'];
		$list['accom'] = $propList[0]['ac_accomm_desc'];
		$list['rooms'] = $propList[0]['rv_item_accomm_count'];
		$list['property'] = $propList[0]['pr_name_last'];
		
		if($noteDate == "2") {
			$itemList = $lDB->get("
				SELECT
					MIN(rv_reservation_item.rv_item_date_arrive) as rv_date_arrive,
					MAX(rv_reservation_item.rv_item_date_depart) as rv_date_depart
				FROM
					rv_reservation_item
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				WHERE
					rv_reservation_item.rv_reservation_id = '$resId'
					$accommWhere
			",1);
			$list['rv_date_arrive'] = $itemList['rv_date_arrive'];
			$list['rv_date_depart'] = $itemList['rv_date_depart'];
		}
		// $list['property_short_name_list'] = join(",",$lDB->get("
			// SELECT DISTINCT
				// pr_business.pr_bus_name_short
			// FROM
				// ac_accomm_type
				// INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			// WHERE
				// 1
				// $accommWhere
			// ORDER BY
				// pr_business.pr_bus_name_short
		// ",3));
		foreach ($propList as $propList){
			$propShortNames[] = $propList['pr_bus_name_short'];
		}
		$propShortNames = array_unique($propShortNames);
		$list['property_short_name_list'] = join(",",$propShortNames);
		return buildNote($noteSections,$noteIds,$list);
	} else {
		return array();
	}
}

function getPaxByDate($date,$accommWhere,$type=1) {
	global $lDB;

	switch($type) {
		case 1: // in-house
			$dateWhere = "
				rv_reservation_item.rv_item_date_arrive <= '$date' 
				AND rv_reservation_item.rv_item_date_depart > '$date'				
			";
			break;
		case 2: // arrive
			$dateWhere = "
				rv_reservation_item.rv_item_date_arrive = '$date' 
			";
			break;
		case 3: // stay-over
			$dateWhere = "
				rv_reservation_item.rv_item_date_arrive < '$date' 
				AND rv_reservation_item.rv_item_date_depart > '$date'				
			";
			break;
		case 4: // depart
			$dateWhere = "
				rv_reservation_item.rv_item_date_depart = '$date'
			";
			break;
	}

	$pax = $lDB->get("
		SELECT
			SUM(rv_reservation_item.rv_item_accomm_count) as occupancy_total,
			SUM(rv_reservation_item.rv_item_accomm_count * rv_reservation_item.rv_item_adult_count) as pax_adult,
			SUM(rv_reservation_item.rv_item_accomm_count * rv_reservation_item.rv_item_child_count) as pax_child
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		WHERE
			$dateWhere
			AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR (
					rv_reservation.rf_reservation_status_id = '20'
					AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
				)
			)
			$accommWhere				
	",1);
	$newPAX = array(
		'occupancy_total'=>$pax['occupancy_total'],
		'pax_adult'=>$pax['pax_adult'],
		'pax_child'=>$pax['pax_child'],
		'pax_total'=>$pax['pax_adult'] + $pax['pax_child']
	);
	return $newPAX;
}

function getSummaryData($accommId,$date) {
	$in = getPaxByDate($date,"AND ac_accomm_type_ix = '$accommId'",1);
	$arrive = getPaxByDate($date,"AND ac_accomm_type_ix = '$accommId'",2);
	$stay = getPaxByDate($date,"AND ac_accomm_type_ix = '$accommId'",3);
	$depart = getPaxByDate($date,"AND ac_accomm_type_ix = '$accommId'",4);

	$summary = array(
		'occupancy'=>$in['occupancy_total'],
		'in'=>$in,
		'arrive'=>$arrive,
		'stay'=>$stay,
		'depart'=>$depart
	);

	return $summary; 
}

// Complex field functions
function getPax($adultCount, $childCount) {
	if(trim($adultCount) == "") { $adultCount = "0"; }
	if(trim($childCount) == "") { $childCount = "0"; }
	return "Ad: $adultCount, Ch: $childCount";
}

function getAdults($adultCount) {
	if(trim($adultCount) == "") { $adultCount = "0"; }
	return $adultCount;
}

function getChildren($childCount) {
	if(trim($childCount) == "") { $childCount = "0"; }
	return $childCount;
}

function getItineraryDates($dateArrive, $dateDepart) {
	return chng_date($dateArrive,"-") . " to " . chng_date($dateDepart,"-");
}

function getItineraryDate($dateDD) {
	return chng_date($dateDD,"-");
}

function getItineraryDateDD($dateDD) {
	$dataArr = explode("-", $dateDD);
	return $dataArr[2];
}

function getItineraryDateMM($dateDD) {
	$dataArr = explode("-", $dateDD);
	return $dataArr[1];
}

function getItineraryNoOfNights($dateArrive, $dateDepart) {
	return (strtotime($dateDepart) - strtotime($dateArrive))/(60*60*24); 
	//return (chng_date($dateDepart,"-") - chng_date($dateArrive,"-"));
}

function getStatusDate($statusId, $confirmDate, $provDate) {
	if($statusId == "30") {
		return chng_date($confirmDate,"-");
	} else {
		return chng_date($provDate,"-");
	}
}

function getPaymentStatus($accommAmount, $extraAmount, $travelAmount,$paidAmount) {
	$total = $accommAmount + $extraAmount + $travelAmount;
	$outstanding = $total - $paidAmount;
	if($outstanding == 0) {
		return "Paid";
	} else if($outstanding > 0) {
		if($paidAmount == 0) {
			return "No payment";
		} else {
			return "Part paid";
		}
	} else {
		return "Over paid";
	}
}

function getOptionalComponents($resItemId,$date='', $extraWhere='', $showExtra='',$pr_business_id='', $showCatExtra='', $componantWhere='') {
	$compArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
		INNER JOIN rt_component ON
			rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '" . $resItemId . "'
		AND 
			rv_item_comp_option_yn = '1'
		$componantWhere	
		ORDER BY rt_component.rt_component_abbrv
			
	",2);

	$compList = "";
	
	if(isset($compArray) && is_array($compArray) && !empty($compArray)) {
		foreach ( $compArray as $item ) {
			if ( $compList != "" ) {
				$compList .= ", ";
			}
			$compList .= $item['rt_component_abbrv'];
		}
	}

	return $compList;
}


function getRoomInfo($accommId, $roomAccommId,$rv_room_requested_yn,$rv_room_request_reason) {
	if(!$roomAccommId) {
		$roomStatus =  "Not roomed";
	} else {
		if($accommId == $roomAccommId) {
			$roomStatus = "Roomed";
		} else {
			$roomStatus = "Upgraded";
		}
	}
	$rv_room_request_reason = trim($rv_room_request_reason);
	if($rv_room_requested_yn == "1" && $rv_room_request_reason != "") {
		$roomStatus .= ", " . $rv_room_request_reason;
	}
	return $roomStatus;
}

function buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,$type,$extraWhere,$showExtra,$propertyId, $showExtraCat, $noteType='') {
	$travelCode = array(0,1,3);
	if($type == "T") {
		$travelCode = array(2);
	}

	switch($showExtra) {
	case "1":
		$propertyJoin = "
			LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
		";
		$propertyWhere = "
			AND (
				pr_business.pr_business_id IS NULL
				OR rv_extra.pr_business_id = '$propertyId'
			)
		";
		break;
	case "2":
		$propertyJoin = "";
		$propertyWhere = "
			AND rv_extra.pr_business_id = '$propertyId'
		";
		break;
	case "3":
		$propertyJoin = "
			LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
		";
		$propertyWhere = "
			AND pr_business.pr_business_id IS NULL
		";
		break;
	}
	
	$list = $GLOBALS['lDB']->get ("
		SELECT 
			ac_extra.ac_ext_desc,
			ac_extra.ac_ext_colour,
			ac_extra_category.ac_extra_cat_colour,
			ac_extra_category.ac_extra_cat_desc,
			ac_extra_category.ac_extra_cat_abbrv,
			rv_extra.rv_extra_date_serv,
			rv_extra.rv_extra_note,
			rv_extra.rv_extra_travel_eta,
			rv_extra.rv_extra_travel_etd,
			rv_extra.rv_extra_note_internal,
			CONCAT_WS(' ', pr_persona.pr_name_first, pr_persona.pr_name_last) as rv_extra_supplier,
			rv_extra.pr_supplier_id
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN ac_extra_category ON ac_extra_category_ix = ac_extra.ac_extra_category_id
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
			LEFT JOIN pr_persona ON rv_extra.pr_supplier_id = pr_persona.pr_persona_ix
			$propertyJoin
		WHERE
			rv_extra.rv_reservation_id = '$rv_reservation_ix'
			AND ( rv_extra.rv_extra_date_serv = '0000-00-00' 
				OR if(rv_extra.rv_extra_ind='3',rv_extra.rv_extra_date_serv <= '$date' 
				AND rv_extra.rv_extra_date_depart >= '$date',rv_extra.rv_extra_date_serv = '$date'
				) 
			)
			AND (
				rv_res_item_group.rv_res_item_group_ix IS NULL
				OR rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_ix'
			)
			AND rv_extra.rv_extra_ind IN ('".join("','",$travelCode)."')
			AND rv_extra.rv_extra_void_ind = '0'
			$extraWhere
			$propertyWhere
	",2);
	
	$newList = array();
	if(isset($list) && is_array($list)) {
		foreach($list as $item) {
			$colour = trim($item['ac_ext_colour']);
			if($colour == "") {
				$colour = trim($item['ac_extra_cat_colour']);
			}
			
			//Code added to identified type of notes needed.
			if($noteType == "note") {
				$val = $item['rv_extra_note'];
			}
			else if($noteType == "internal") {
				$val = $item['rv_extra_note_internal'];
			} else if($noteType == "eta") {
				$val = $item['rv_extra_travel_eta'];
			} else if($noteType == "etd") {
				$val = $item['rv_extra_travel_etd'];
			} else if($noteType == "supplier") {
				$val = $item['rv_extra_supplier'];
			} else {
				if($showExtraCat == "1") {
					$val = strtoupper($item['ac_extra_cat_abbrv']).":";
				} else {
					$val = "";
				}
				$val .= $item['ac_ext_desc'];
				
			}

			array_push($newList,array(
				'value'=>$val,
				'colour'=>$colour
			));
		}	
	}
	
	return $newList;
}

function getExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId, $showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"E",$extraWhere,$showExtra,$propertyId, $showCatExtra);
}

function getTravel($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId, $showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"T",$extraWhere,$showExtra,$propertyId, $showCatExtra);
}

function getExtrasChartNotes($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId,$showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"E",$extraWhere,$showExtra,$propertyId,$showCatExtra,"note");
}

function getTravelChartNotes($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId,$showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"T",$extraWhere,$showExtra,$propertyId,$showCatExtra,"note");
}

function getExtrasChartMemo($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId,$showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"E",$extraWhere,$showExtra,$propertyId,$showCatExtra,"internal");
}

function getTravelChartMemo($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId,$showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"T",$extraWhere,$showExtra,$propertyId,$showCatExtra,"internal");
}

function getTravelETA($rv_reservation_ix, $rv_res_item_group_ix, $date, $extraWhere, $showExtra, $propertyId, $showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"T",$extraWhere,$showExtra,$propertyId, $showCatExtra,"eta");
}

function getTravelETD($rv_reservation_ix, $rv_res_item_group_ix, $date, $extraWhere, $showExtra, $propertyId, $showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"T",$extraWhere,$showExtra,$propertyId, $showCatExtra,"etd");
}

function getTravelSupplier($rv_reservation_ix, $rv_res_item_group_ix, $date, $extraWhere, $showExtra, $propertyId, $showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"T",$extraWhere,$showExtra,$propertyId, $showCatExtra,"supplier");
}

function getExtrasChartSupplier($rv_reservation_ix,$rv_res_item_group_ix,$date,$extraWhere,$showExtra,$propertyId,$showCatExtra) {
	return buildExtras($rv_reservation_ix,$rv_res_item_group_ix,$date,"E",$extraWhere,$showExtra,$propertyId,$showCatExtra,"supplier");
}


function getGuestNames($rv_res_item_group_ix, $rv_reservation_ix) {
	if($rv_res_item_group_ix != "") {
		$guestNameList = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_res_item_guest.rv_res_item_group_id = '$rv_res_item_group_ix'
		
		",2);
	}
	$guestNames = array();
	if(isset($guestNameList) && is_array($guestNameList)) {
		foreach($guestNameList as $guestName) {
			array_push($guestNames, array('value'=>trim($guestName['pr_name_first'] . " " . $guestName['pr_name_last'])));
		}
	}
	return $guestNames;
}

// Returns Yes/No for now
function getGuestVisits($rv_res_item_group_ix) {
	global $lDB;
	if($rv_res_item_group_ix != "") {
	
		$guestIdList = $lDB->get("
			SELECT
				rv_res_item_guest.pr_guest_id
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_res_item_guest.rv_res_item_group_id = '$rv_res_item_group_ix'		
		",3);	

		if(isset($guestIdList) && is_array($guestIdList)) {
			$guestCountList = $lDB->get("
				SELECT
					COUNT(DISTINCT rv_reservation.rv_reservation_ix) as visits
				FROM
					rv_res_item_guest
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				WHERE
					rv_res_item_guest.pr_guest_id IN ('".join("','",$guestIdList)."')
					AND rv_reservation.rf_reservation_status_id = '30'
					AND rv_reservation_item.rv_item_date_depart < '".date("Y-m-d")."'
				GROUP BY
					rv_res_item_guest.pr_guest_id			
				ORDER BY
					visits DESC				
			",2);
		}		
	

	}

	if(isset($guestCountList) && is_array($guestCountList)) {
		if (isset($guestCountList[0]['visits']) && $guestCountList[0]['visits'] >= 1){
			return "Yes";
		} else {
			return "No";
		}
	}
}

function getContactName($rv_corr_persona_id) {
	$conNameList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			pr_persona 
		WHERE pr_persona.pr_persona_ix = '$rv_corr_persona_id'
	",2);
	$conName = array();
	if(isset($conNameList) && is_array($conNameList)) {
		foreach($conNameList as $con) {
			array_push($conName, array('value'=>trim($con['pr_name_first'] . " " . $con['pr_name_last'])));
		}
	}
	
	return $conName;
}

function buildExtraNotes($rv_reservation_id,$fromDate,$toDate,$accommIds,$extraWhere,$onlyNotes,$type,$showExtra,$propertyIds) {
	global $lDB;
	$travelCode = array(0,1,3);
	if($type == "T") {
		$travelCode = array(2);
	}
	
	if(isset($propertyIds) && is_array($propertyIds) && !empty($propertyIds)) {
		$properties = join("','",$propertyIds);
	} else {
		$properties = "";
	}

	switch($showExtra) {
	case "1":
		$propertyJoin = "
			LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
		";
		$propertyWhere = "
			AND (
				pr_business.pr_business_id IS NULL
				OR rv_extra.pr_business_id IN ('".$properties."')
			)
		";
		break;
	case "2":
		$propertyJoin = "";
		$propertyWhere = "
			AND rv_extra.pr_business_id IN ('".$properties."')
		";
		break;
	case "3":
		$propertyJoin = "
			LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
		";
		$propertyWhere = "
			AND pr_business.pr_business_id IS NULL
		";
		break;
	}
		
	$notes = $lDB->get("
		SELECT
			ac_extra.ac_ext_desc,
			ac_extra_category.ac_extra_cat_desc,
			rv_extra.rv_extra_ix as id,
			rv_extra.rv_extra_date_serv,
			rv_extra.rv_extra_note,
			rv_extra.rv_extra_note_internal,
			rv_extra.rv_extra_units,
			ac_accomm_room.ac_desc
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN ac_extra_category ON ac_extra_category_ix = ac_extra.ac_extra_category_id
			$propertyJoin
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_extra.rv_reservation_id = '$rv_reservation_id'
			AND (
				rv_extra.rv_extra_date_serv = '0000-00-00'
				OR (
					rv_extra.rv_extra_date_serv >= '$fromDate'
					AND rv_extra.rv_extra_date_serv <= '$toDate'
				)
			)
			AND rv_extra.rv_extra_ind IN ('".join("','",$travelCode)."')
			AND rv_extra.rv_extra_void_ind = '0'
			$extraWhere
			$propertyWhere
		ORDER BY
			rv_extra.rv_extra_date_serv,
			ac_extra_category.ac_extra_cat_desc,
			ac_extra.ac_ext_desc
	",2);
	
	if(isset($notes) && is_array($notes)) {
		foreach($notes as $key=>$item) {
			$notes[$key]['rv_extra_date_serv'] =  chng_date($notes[$key]['rv_extra_date_serv'],"-");
		}
	}
		
	return $notes;
}

function getExtraNotes($rv_reservation_id,$fromDate,$toDate,$accommIds,$extraWhere,$onlyNotes=false,$showExtra,$propertyIds) {
	return buildExtraNotes($rv_reservation_id,$fromDate,$toDate,$accommIds,$extraWhere,$onlyNotes,"E",$showExtra,$propertyIds);
}

function getTravelNotes($rv_reservation_id,$fromDate,$toDate,$accommIds,$extraWhere,$onlyNotes=false,$showExtra,$propertyIds) {
	return buildExtraNotes($rv_reservation_id,$fromDate,$toDate,$accommIds,$extraWhere,$onlyNotes,"T",$showExtra,$propertyIds);
}

function getItinerarySummary($resNum, $accommWhere) {
	$summaryArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item_ix,
			rv_reservation_item.pr_business_id,
			pr_persona.pr_name_last as propName,
			rv_reservation_item.rv_item_date_arrive as resArrive,
			rv_reservation_item.rv_item_date_depart as resDepart,
			rv_reservation_item.rv_item_adult_count as adults,
			rv_reservation_item.rv_item_child_count as childs, 
			rv_reservation_item.rv_item_nights as nights, 
			rv_reservation_item.rv_item_accomm_count as rooms,
			ac_accomm_type.ac_accomm_desc as accom,
			ac_accomm_room.ac_desc as room,
			rv_res_item_group.rv_room_requested_yn,
			rv_res_item_group.rv_room_request_reason
		FROM
			rv_reservation_item
		INNER JOIN ac_accomm_type ON 
			ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_persona ON 
			pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		LEFT JOIN rv_res_item_group ON 
			rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		LEFT JOIN ac_accomm_room ON 
			ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id 
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $resNum . "'
			group by rv_reservation_item.rv_reservation_item_ix
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last
	",2);

    foreach ($summaryArray as $key => $summary) {
        if ($summary['rooms'] > 1) {
            $roomNames = $GLOBALS['lDB']->get("
                SELECT DISTINCT
                    ac_accomm_room.ac_desc as room
                FROM
                    rv_reservation_item
                LEFT JOIN rv_res_item_group ON 
                    rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
                LEFT JOIN ac_accomm_room ON 
                    ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id 
                WHERE
                    rv_reservation_item.rv_reservation_item_ix = '" . $summary['rv_reservation_item_ix'] . "'
                ORDER BY
                    rv_reservation_item.rv_item_date_arrive,
                    rv_reservation_item.rv_item_date_depart
            ",3);
            $summaryArray[$key]['room'] = implode(",
", $roomNames);
        }
    }

	for ( $summaryCount = 0; $summaryCount < sizeof($summaryArray); $summaryCount++ ) {
		$optionals = getOptionalComponents($summaryArray[$summaryCount]['rv_reservation_item_ix']);
		if($optionals != "") {
			$summaryArray[$summaryCount]['accom'] .= " ($optionals)";
		}
		$summaryArray[$summaryCount]['resArrive'] = chng_date($summaryArray[$summaryCount]['resArrive'],"-");
		$summaryArray[$summaryCount]['resDepart'] = chng_date($summaryArray[$summaryCount]['resDepart'],"-");
		
	}
	
	return $summaryArray;
}

function getLockReasons($rv_reservation_ix) {
	$lockList = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_room.ac_desc,
			rv_res_item_group.rv_room_request_reason
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_ix'
			AND rv_room_requested_yn = '1'
	",2);
	$result = array();
	if(isset($lockList) && is_array($lockList)) {
		foreach($lockList as $lockItem) {
			array_push($result,array(
				'ac_desc'=>$lockItem['ac_desc'],
				'rv_room_request_reason'=>$lockItem['rv_room_request_reason'],
				'value'=>"$lockItem[ac_desc]: $lockItem[rv_room_request_reason]"
			));
		}
	}
	return $result;
}
	
function getGuestDetails($rv_reservation_id,$fromDate,$toDate,$accommWhere) {
	global $lDB;
	$guestList = $lDB->get("
		SELECT DISTINCT
			pr_guest.pr_guest_id,
			pr_guest.pr_guest_note,
			pr_guest.pr_guest_memo,
			pr_persona.pr_anniversary,
			pr_persona.pr_birthdate,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			ac_accomm_room.ac_desc,
			res_country.rf_country_name AS res_country_name,
			guest_country.rf_country_name AS guest_country_name
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id

			LEFT JOIN rf_country AS res_country ON res_country.rf_country_ix = rv_reservation.rf_country_id
			LEFT JOIN rf_country AS guest_country ON guest_country.rf_country_ix = pr_guest.rf_country_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
			$accommWhere
			AND (
				(
					rv_reservation_item.rv_item_date_arrive >= '$fromDate' 
					AND rv_reservation_item.rv_item_date_arrive <= '$toDate'
				) OR (
					rv_reservation_item.rv_item_date_depart >= '$fromDate' 
					AND rv_reservation_item.rv_item_date_depart <= '$toDate'
				) OR (
					rv_reservation_item.rv_item_date_arrive < '$fromDate' 
					AND rv_reservation_item.rv_item_date_depart > '$toDate'
				)
			)			
		ORDER BY
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
	",2);

	$result = array();
	$startArray = explode("-",$fromDate);
	$endArray = explode("-", $toDate);
	$end = mktime(0,0,0,$endArray[1],$endArray[2],$endArray[0]);
	$start = mktime(0,0,0,$startArray[1],$startArray[2],$startArray[0]);

	foreach($guestList as $item) {
		$hasBirth = false;
		$hasAnniversary = false;
		if($item['pr_birthdate'] != "0000-00-00") {
			$birthArray = explode("-",$item['pr_birthdate']);
						
			$birthStart = mktime(0,0,0,$birthArray[1],$birthArray[2],$startArray[0]);
			$birthEnd = mktime(0,0,0,$birthArray[1],$birthArray[2],$endArray[0]);
			$birthStartDiff = abs($start - $birthStart);
			$birthEndDiff = abs($end - $birthEnd);
			
			if(($birthStart >= $start && $birthEnd <= $end) || $birthStartDiff <= 864000 || $birthEndDiff <= 864000) { 
				// 864000 is 10 days of seconds, 60*60*24 = 86400, 86400 * 10 = 864000
				$hasBirth = true;
			}
			
			$item['pr_birthdate'] = short_date($item['pr_birthdate'],"-");
		}

		if($item['pr_anniversary'] != "0000-00-00") {
			$anniversaryArray = explode("-",$item['pr_anniversary']);
			$anniversaryStart = mktime(0,0,0,$anniversaryArray[1],$anniversaryArray[2],$startArray[0]);
			$anniversaryEnd = mktime(0,0,0,$anniversaryArray[1],$anniversaryArray[2],$endArray[0]);
			$anniversaryStartDiff = abs($start - $anniversaryStart);
			$anniversaryEndDiff = abs($end - $anniversaryEnd);
			
			if(($anniversaryStart >= $start && $anniversaryEnd <= $end) || $anniversaryStartDiff <= 864000 || $anniversaryEndDiff <= 864000) { 
				// 864000 is 10 days of seconds, 60*60*24 = 86400, 86400 * 10 = 864000
					$hasAnniversary = true;
			}
			$item['pr_anniversary'] = short_date($item['pr_anniversary'],"-");
		}
		
		$last_depart = $lDB->get("
			SELECT
				MAX(rv_reservation_item.rv_item_date_depart)
			FROM
				rv_res_item_guest
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			
			WHERE
				rv_res_item_guest.pr_guest_id = '$item[pr_guest_id]'
				AND rv_reservation_item.rv_item_date_depart < '".date("Y-m-d")."'
		",4);
		$last_depart = short_date($last_depart, "-");
		
		$total_visit = $lDB->get("
			SELECT
				COUNT(DISTINCT rv_reservation_item.rv_reservation_id)
			FROM
				rv_res_item_guest
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				 rv_res_item_guest.pr_guest_id = '$item[pr_guest_id]'
				 AND rv_reservation_item.rv_item_date_depart < '".date("Y-m-d")."'
		",4);



		$nationality = "";
		if(trim($item['res_country_name']) != "") {
			$nationality = $item['res_country_name'];
		}

		if(trim($item['guest_country_name']) != "") {
			$nationality = $item['guest_country_name'];
		}
		
		$result[$item['pr_guest_id']] = array(
			'pr_name'=>trim($item['pr_name_first'] . " " . $item['pr_name_last']),
			'pr_guest_note'=>$item['pr_guest_note'],
			'pr_guest_memo'=>$item['pr_guest_memo'],
			'pr_anniversary'=>$item['pr_anniversary'],
			'pr_birthdate'=>$item['pr_birthdate'],
			'has_birthday'=>$hasBirth,
			'has_anniversary'=>$hasAnniversary,
			'ac_desc'=>$item['ac_desc'],
			'nationality'=>$nationality,
			'last_depart' => $last_depart,
			'total_visit' => $total_visit>0?$total_visit:0
		);
	}
	return $result;
}

function getFinancials($rv_reservation_id) {
	global $lDB;
	$invoiceList = $lDB->get("
		SELECT
			fn_invoice_db,
			fn_invoice_trf_yn,
			fn_invoice_ix,
			fn_invoice.fn_invoice_prefix,
			fn_invoice.fn_inv_date,
			pr_persona.pr_name_last,
			fn_invoice.fn_inv_to,
			fn_invoice.fn_inv_print_count,
			fn_invoice.fn_inv_curr,
			fn_folio.fn_folio_ix,
			fn_invoice.fn_inv_status_ind
		FROM
			fn_invoice
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
			LEFT JOIN pr_persona ON pr_persona_ix = fn_folio.pr_business_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		WHERE
			fn_invoice.rv_reservation_id = '$rv_reservation_id'
	",2);

	foreach($invoiceList as $id=>$item) {
		$totals = $lDB->get("
			SELECT
				SUM(fn_inv_item_amount) as total,
				SUM(fn_inv_item_amt_comm) as comm,
				SUM(fn_inv_item_amt_tax) as tax
			FROM
				fn_invoice_item
			WHERE
				fn_invoice_id = '$item[fn_invoice_ix]'
		",1);
		
		$paymentTotal = $lDB->get("
			SELECT
				SUM(rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				fn_folio_id = '$item[fn_folio_ix]'
		",4);
		$amountPayable = $totals['total']  - $paymentTotal;

		$invoiceList[$id]['total'] = number_format($totals['total'],2);
		$invoiceList[$id]['paid'] = ($paymentTotal !='')?number_format($paymentTotal,2):'0.00';
		$invoiceList[$id]['due'] = number_format($amountPayable,2);
	}
	return $invoiceList;
}

function getInvoiceCurrency($fn_folio_id) {
	$fn_inv_curr = $GLOBALS['lDB']->get("SELECT fn_inv_curr FROM fn_invoice WHERE fn_invoice_ix = '".$fn_folio_id."' ", 4);

	return $fn_inv_curr;
}
