<?php

/**
 * init.form376.func.output.php - Operations chart output functions
 */

define("MAX_CHAR_HTML", 31);
define("MAX_CHAR_PDF",18);

function getRowSpans($chart, $type, $showIds) {
	$rowSpans = array();
	$data = $chart[$type];
	foreach($chart['rows'] as $row) {
		$rowSpans[$row['id']] = array();
		foreach($chart['columns'] as $col) {
			$rowSpan =& $rowSpans[$row['id']];
			foreach($showIds as $showId) {
				$cell = isset($data[$row['id']][$col['id']][$showId]['value']) ? $data[$row['id']][$col['id']][$showId]['value'] : "";
				if ( !array_key_exists($showId,$rowSpan) ) {
					$rowSpan[$showId] = 1;
				}
				if ( is_array($cell) ) {
					if ( sizeof($cell) > $rowSpan[$showId] ) {
						$rowSpan[$showId] = sizeof($cell);
					}
				}
			}
		}
	}
	
	return $rowSpans;
}

function getCommonRowSpan($chart,$showIds, $rowId, $flag='room') {
	$rowSpans = array();
	$rowSpan_room = getRowSpans($chart,'room',$showIds);
	$rowSpans_room = $rowSpan_room[$rowId];
	$rowSpan_so = getRowSpans($chart,'stayOver',$showIds);
	$rowSpans_so = $rowSpan_so[$rowId];
	$rowSpan_depart = getRowSpans($chart,'depart',$showIds);
	$rowSpans_depart = $rowSpan_depart[$rowId];
	foreach($rowSpans_room as $key=>$item) {
		$rowSpans[$key] = max($item, $rowSpans_so[$key], $rowSpans_depart[$key]);
	}
	return $rowSpans;
}

function getDetailType($id, $section) {
	if($id == ''){
		return 0;
	}
	if($id == findSectionId($section, "travel") || 
		$id == findSectionId($section, "travelNote") || 
		$id == findSectionId($section, "travelMemo") || 
		$id == findSectionId($section, "travelETA") ||
		$id == findSectionId($section, "travelETD") ||
		$id == findSectionId($section, "travelSupplier") ||
		$id == findSectionId($section, "extras") || 
		$id == findSectionId($section, "extraNote") || 
		$id == findSectionId($section, "extraMemo") ||
		$id == findSectionId($section, "extraSupplier")) {
		return 1;
	} else {
		return 0;
	}
}

function getHeaderAtr($chartSections, $departId, $attribute) {
	foreach ( $chartSections as $item ) {
		if ( $item['id'] == $departId ) {
			if($attribute == 'width') {
				$attributeVal = (is_numeric($item['width']) && $item['width'] != '') ?$item['width']:200;
			}
			if($attribute == 'align') {
				if($item['align'] == 'r') {
					$attributeVal = "right";
				} else if($item['align'] == 'c') {
					$attributeVal = "center";
				} else {
					$attributeVal = "left";
				}
			}

			if($attribute == 'header') {
				$attributeVal = $item['header'];
			}
			if($attribute == 'label') {
				$attributeVal = $item['label'];
			}
			if($attribute == 'numeric') {
				$item['numeric'] = isset($item['numeric']) ? $item['numeric'] : false;
				if($item['numeric'] && $item['numeric'] == 1) {
					$attributeVal = "Number";
				} else {
					$attributeVal = "String";
				}
				
			}
			break;
		}
	}
	return isset($attributeVal) ? $attributeVal : "";
}

function createDetailHeader($chartSections, $departId, $departIds, $rowId, $departRowSpans) {
	$rowHTML = '';
	$align = getHeaderAtr($chartSections, $departId, "align");
	foreach ( $chartSections as $item ) {
		if ( $item['id'] == $departId ) {
			$label = $item['header'] !=''?$item['header']:$item['label'];
			if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
				$label = substr($label,0,MAX_CHAR_HTML) . "..";
			}
			
			$rowHTML .= '
						<tr style="height:18px;">
							<td valign="top" align="'.$align.'" style="border-collapse:collapse">' . $label . '</td>
						</tr>
					';
			if ( $departRowSpans[$rowId][$departId] > 1 ) {
				for ( $count = 1; $count < $departRowSpans[$rowId][$departId]; $count++ ){
					$rowHTML .= '
								<tr style="height:18px;">
									<td>&nbsp;</td>
								</tr>
							';
				}
			}
		}
	}
	
	return $rowHTML;
}

function createDetailHeaderRow($chartSections, $detailIds, $perdayIds=array()) {
	$dataHeader = array();
	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	foreach ( $chartSections as $item ) {
		foreach ( $detailIds as $showId ) {
			if(in_array($showId, $perdayIds)) {
				continue;
			}

			$align = getHeaderAtr($chartSections, $showId, "align");

			if ( isset($item['id']) && $item['id'] == $showId ) {
				if($lastHeader != "" && $lastHeader != $item['header']) {
					$dataHeader1 .= "<td class=\"bt br bb\" colspan=\"$lastHeaderCount\" align=\"center\" style='border-collapse:collapse'>".$lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if(isset($item['header']) && $item['header'] != "") {
					$dataHeader2 .= "<td class=\"br\" align = '$align' style='border-collapse:collapse'>" .$item['label']."</td>";
					$lastHeader = $item['header'];
					$lastHeaderCount++;
				} else {
					$dataHeader1 .= "<td class=\"bt br\" rowspan=\"2\" align='$align' style='border-collapse:collapse'>". $item['label']."</td>";
				}
			
				break;
			}
		}
		
	}
	if($lastHeader != "") {
		$dataHeader1 .= "<td class=\"bt br bb\" colspan=\"$lastHeaderCount\" align=\"center\" style='border-collapse:collapse'>".$lastHeader. "</td>";
	}
	$dataHeader[1] = $dataHeader1;
	$dataHeader[2] = $dataHeader2;
	
	return $dataHeader;
}

function createHeaderDetailAsRow($detailIds, $chartSections, $perdayIds=array(), $rowSpans, $totalSubCell) {
	$rowHTML = '';
	$repFlag = 0;
	$processedId = array();
	$align = "";
	$etaId = "";
	$etdId = "";
	

	foreach ( $detailIds as $departId ) {
		if(!in_array($departId, $perdayIds)) {
			$align = getHeaderAtr($chartSections, $departId, "align");
			$typeId = getDetailType($departId, $chartSections);
			if($typeId == 1) {
					if($departId == findSectionId($chartSections,"extras") || $departId == findSectionId($chartSections, "extraNote") || $departId == findSectionId($chartSections, "extraMemo")){
					$descId = findSectionId($chartSections, "extras");
					$noteId = findSectionId($chartSections, "extraNote");
					$memoId = findSectionId($chartSections, "extraMemo");
					$supId = findSectionId($chartSections, "extraSupplier");
					$travelFlag = 0;
				} else {
					$descId = findSectionId($chartSections, "travel");
					$noteId = findSectionId($chartSections,"travelNote");
					$memoId = findSectionId($chartSections,"travelMemo");
					$etaId = findSectionId($chartSections,"travelETA");
					$etdId = findSectionId($chartSections,"travelETD");
					$supId = findSectionId($chartSections, "travelSupplier");
					$travelFlag = 1;
					
				}
			}

			foreach ( $chartSections as $item ) {
				if ( $item['id'] == $departId ) {
					if ($typeId == 1) {
						if(!in_array($departId, $processedId)) {
							$repFlag = 0;
						}

						for ( $count = 0; $count < $rowSpans[ $departId]; $count++ ) {
							if($departId == $descId  && $repFlag == 0) {
								if(in_array($departId, $detailIds)) {
									$label = getHeaderAtr($chartSections, $departId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px !important;">
											<td valign="top" align="'.(isset($align) ? $align : "").'" style="overflow:hidden; white-space:nowrap;width:50px !important">' . $label .'</td>
										</tr>
									';
									if(!in_array($departId,$processedId)) {
										array_push($processedId, $departId);
									}
								}
								
								if($travelFlag == 1) {
									if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etaId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$nextFlag = isset($nextFlag) ? $nextFlag+1 : 1;
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.(isset($align) ? $align : "").'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etaId, $processedId)) {
											array_push($processedId, $etaId);
										}
									}

									if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etdId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$nextFlag = isset($nextFlag) ? $nextFlag+1 : 1;
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etdId, $processedId)) {
											array_push($processedId, $etdId);
										}
									}
								}
								
								if(in_array($memoId, $detailIds) && !in_array($memoId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $memoId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($memoId, $processedId)) {
										array_push($processedId, $memoId);
									}
								}
								if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $noteId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($noteId, $processedId)) {
										array_push($processedId, $noteId);
									}
								}
								if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $supId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($supId, $processedId)) {
										array_push($processedId, $supId);
									}
								}
								
								if($count == $rowSpans[$departId]-1) {
									$repFlag = 1;
								}
							
							} else if(($departId == $noteId) && $repFlag == 0) {
								if(in_array($departId, $detailIds)) {
									$label = getHeaderAtr($chartSections, $departId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($departId, $processedId)) {
										array_push($processedId, $departId);
									}
								}
								if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $supId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($supId, $processedId)) {
										array_push($processedId, $supId);
									}
								}
								if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $descId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;width:50px !important">' . $label . '</td>
										</tr>
									';
									if(!in_array($descId, $processedId)) {
										array_push($processedId, $descId);
									}
								}

								if($travelFlag == 1) {
									if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etaId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etaId, $processedId)) {
											array_push($processedId, $etaId);
										}
									}

									if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etdId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etdId, $processedId)) {
											array_push($processedId, $etdId);
										}
									}
								}
								if(in_array($memoId, $detailIds) && !in_array($memoId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $memoId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($memoId, $processedId)) {
										array_push($processedId, $memoId);
									}
								}
								if($count == $rowSpans[$departId]-1) {
									$repFlag = 1;
								}

							} else if(($departId == $memoId) && $repFlag == 0) {
								if(in_array($departId, $detailIds)) {
									$label = getHeaderAtr($chartSections, $departId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($departId, $processedId)) {
										array_push($processedId, $departId);
									}
								}
								if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $noteId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($noteId, $processedId)) {
										array_push($processedId, $noteId);
									}
								}
								if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $supId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($supId, $processedId)) {
										array_push($processedId, $supId);
									}
								}
								if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $descId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;width:50px !important">' . $label . '</td>
										</tr>
									';
									if(!in_array($descId, $processedId)) {
										array_push($processedId, $descId);
									}
								}
								
								if($travelFlag == 1) {
									if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etaId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etaId, $processedId)) {
											array_push($processedId, $etaId);
										}
									}

									if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etdId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$nextFlag = isset($nextFlag) ? $nextFlag+1 : 1;
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etdId, $processedId)) {
											array_push($processedId, $etdId);
										}
									}
								}
								
								if($count == $rowSpans[$departId]-1) {
									$repFlag = 1;
								}

							} else if(($departId == $etaId) && $repFlag == 0) {
								if($travelFlag == 1) {
									if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etaId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etaId, $processedId)) {
											array_push($processedId, $etaId);
										}
									}

									if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etdId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
																					
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etdId, $processedId)) {
											array_push($processedId, $etdId);
										}
									}
								}
								if(in_array($memoId, $detailIds) && !in_array($memoId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $memoId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($memoId, $processedId)) {
										array_push($processedId, $memoId);
									}
								}
								if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $noteId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($noteId, $processedId)) {
										array_push($processedId, $noteId);
									}
								}
								if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $supId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($supId, $processedId)) {
										array_push($processedId, $supId);
									}
								}
								if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $descId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;width:50px !important">' . $label . '</td>
										</tr>
									';
									if(!in_array($descId, $processedId)) {
										array_push($processedId, $descId);
									}
								}
								if($count == $rowSpans[$departId]-1) {
									$repFlag = 1;
								}

							} else if(($departId == $etdId) && $repFlag == 0) {
								if($travelFlag == 1) {
									if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etdId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etdId, $processedId)) {
											array_push($processedId, $etdId);
										}
									}
								}
								if(in_array($memoId, $detailIds) && !in_array($memoId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $memoId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($memoId, $processedId)) {
										array_push($processedId, $memoId);
									}
								}
								if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $noteId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($noteId, $processedId)) {
										array_push($processedId, $noteId);
									}
								}
								if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $supId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($supId, $processedId)) {
										array_push($processedId, $supId);
									}
								}
								if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $descId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;width:50px !important">' . $label . '</td>
										</tr>
									';
									if(!in_array($descId, $processedId)) {
										array_push($processedId, $descId);
									}
								}
								if($travelFlag == 1) {
									if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etaId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etaId, $processedId)) {
											array_push($processedId, $etaId);
										}
									}
								}
								if($count == $rowSpans[$departId]-1) {
									$repFlag = 1;
								}
							} else if(($departId == $supId) && $repFlag == 0) {
								if(in_array($departId, $detailIds)) {
									$label = getHeaderAtr($chartSections, $departId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($departId, $processedId)) {
										array_push($processedId, $departId);
									}
								}
								if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $descId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;width:50px !important">' . $label . '</td>
										</tr>
									';
									if(!in_array($descId, $processedId)) {
										array_push($processedId, $descId);
									}
								}

								if($travelFlag == 1) {
									if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etaId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etaId, $processedId)) {
											array_push($processedId, $etaId);
										}
									}

									if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
										$label = getHeaderAtr($chartSections, $etdId, 'label');
										if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
											$label = substr($label,0,MAX_CHAR_HTML) . "..";
										}
										$rowHTML .= '
											<tr style="height:18px; !important;">
												<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
											</tr>
										';
										if(!in_array($etdId, $processedId)) {
											array_push($processedId, $etdId);
										}
									}
								}
								if(in_array($memoId, $detailIds) && !in_array($memoId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $memoId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($memoId, $processedId)) {
										array_push($processedId, $memoId);
									}
								}
								if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $noteId, 'label');
									if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
										$label = substr($label,0,MAX_CHAR_HTML) . "..";
									}
									$rowHTML .= '
										<tr style="height:18px; !important;">
											<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
										</tr>
									';
									if(!in_array($noteId, $processedId)) {
										array_push($processedId, $noteId);
									}
								}
								if($count == $rowSpans[$departId]-1) {
									$repFlag = 1;
								}

							}
						}
						
					} else {
						$label = $item['header'] !=''? $item['header'] .'('.$item['label'].')' : $item['label'];
						if ( mb_strlen($label) > MAX_CHAR_HTML+2 ) {
							$label = substr($label,0,MAX_CHAR_HTML) . "..";
						}
						$rowHTML .= '
									<tr style="height:18px; !important;">
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap;">' . $label . '</td>
									</tr>
								';	
														
						
						if ( $rowSpans[$departId] > 1 ) {
							for ( $count = 1; $count < $rowSpans[$departId]; $count++ ){
								$rowHTML .= '
											<tr style="height:18px; !important;">
												<td align="'.$align.'" style="overflow:hidden; white-space:nowrap;">&nbsp;</td>
											</tr>
										';
							}
						}
					}
				}
			}
		}
	}
	
	return $rowHTML;
}

function createRoomDetail($chart, $type, $departId, $colourIds, $rowId,$colId, $detailAs=1, $rowSpan=1, $chartSections) {
	
	$colour			= "#fff";
	$fontColour		= "#000";
	$repFlag		= 0;
	$ColInnerHTML	= '';
	$brdrCls		= 'br';
	$error 			= false;
	$first 			= false;

	$d = isset($chart[$type][$rowId][$colId]) ? $chart[$type][$rowId][$colId] : array();
	$b = isset($chart['block'][$rowId][$colId]) ? $chart['block'][$rowId][$colId] : array();
	if ( $b != "" ) {
		$colour = "#c0c0c0";				
	}
	
	if( isset($detailAs) && $detailAs == 2) {
		$align = getHeaderAtr($chartSections, $departId, 'align');
	} else {
		$align = "left";
	}

	// Provisional booking
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 20 ) {
		$fontColour = '#369';
	}

	// Provisional expiring today
	if ( isset($d['rv_provision_expiry_date']) && $d['rv_provision_expiry_date'] == date("Y-m-d") ) {
		$colour		= "#f1c55d";
		$fontColour	= "#000";
	}
			
	// Allocation
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 15 ) {
		$fontColour = "#999";
	}
	
	$errorMsg = '<img src="/resource/Resrequest/Application/public/img/icon_error_12.gif" width="12" height="12" alt="" style="display: inline;" onmouseover="overlib(\'%status%\');" onmouseout="nd();" />';

	// We have an expired provisional that is roomed
	if (
        isset($d['rv_provision_expiry_date']) &&
        $d['rv_provision_expiry_date'] != 0000-00-00 &&
        $d['rv_provision_expiry_date'] < date("Y-m-d") &&
        $d['rf_reservation_status_id'] != "30"  // Status is not confirmed
    ) {
		$error = true;
		$msg = "You have an expired provisional that has been roomed.";
		$errorDesc = str_replace("%status%", $msg, $errorMsg);
	}

	// [START] Reservation status error handling ----------------------------
	// Quotation
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == "0" ) {
		$error = true;
		$msg = "You have a quotation that has been roomed.";
		$errorDesc = str_replace("%status%", $msg, $errorMsg);
	}

	// Waitlisted
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 10 ) {
		$error = true;
		$msg = "You have a waitlisted that has been roomed.";
		$errorDesc = str_replace("%status%", $msg, $errorMsg);
	}

	// Cancelled
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 90 ) {
		$error = true;
		$msg = "You have a cancelled reservation that has been roomed.";
		$errorDesc = str_replace("%status%", $msg, $errorMsg);
	}

	// Add clickthrough to cell ----------------------------------------------
	$clickThrough = "";
	$pointer = '';
	if ( isset($d['rv_reservation_id']) && $d['rv_reservation_id'] != "" ) {
		$clickThrough = "onclick=\"window.location = '/reservation.php?2+" . $d['rv_reservation_id'] . "'\"";
		$pointer = 'cursor: pointer;';
	}

	if ( isset($chart['direction']) && $chart['direction'] == "2" ) {
		if($chart['rows'][$rowId]['room'] == "overbooking") {
			$colour = "#db4242";
		}
	} else {
		if($chart['columns'][$colId]['room'] == "overbooking") {
			$colour = "#db4242";
		}
	}
	
	if ( isset($d[$departId]['value']) && !is_array($d[$departId]['value']) ) {	
		// [ START ] Reservation status error handling ----------------------------
		if ( $first && $error == true) {
			$d[$departId]['value'] = $errorDesc . ' ' . $d[$departId]['value'];
		}
		// [ END ] Reservation status error handling ----------------------------

		// You have a roomed overbooking! Double silly bugger!
		if ( isset($d['overbooked']) && $d['overbooked']) {
			$error = true;
			$msg = "You have a room-level overbooking.";
			$errorDesc = str_replace("%status%", $msg, $errorMsg);
			if ( $first ) {
				$d[$departId]['value'] = $errorDesc . ' ' . join("/",$d['overbookedList']);
			}
		}
		
		// [ START ] Colour handling ----------------------------
		if ( in_array($departId,$colourIds) && $d[$departId]['colour'] != "" ) {
			$colour = "#" . $d[$departId]['colour'];
		}
		if ( $error ) {
			$colour	 = "#db4242";
			$fontColour = "#fff";
		}
		// [ END ] Colour handling ----------------------------

		if ( trim($d[$departId]['value']) == '' ) {
			$d[$departId]['value'] = "&nbsp;";
		}

		if ( mb_strlen($d[$departId]['value']) > MAX_CHAR_HTML+2 ) {
			if ( $first && $error == true) {
			} else {
				$d[$departId]['value'] = substr($d[$departId]['value'],0,MAX_CHAR_HTML) . '..';
			}
		}
		
		if($detailAs == 2) {
			$max = recursive_array_max($rowSpan[$rowId]);
			$h = $max>1?$max*18:18;
		} else {
			$h = $rowSpan[$rowId][$departId]>1?$rowSpan[$rowId][$departId]*18:18;
		}
		
		$ColInnerHTML .= '<td valign="top" class="'.$brdrCls.'" style="height:'.$h.'px; white-space:nowrap; overflow:hidden; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour . '; ' . $pointer . '" ' . $clickThrough .'align="'.$align.'">'. nl2br($d[$departId]['value']).'&nbsp;';
		
		if($detailAs == 2) {
			$max = recursive_array_max($rowSpan[$rowId]);
			$h = $max>1?$max*18:18;
			if ($max>1) {
				for ( $count = 1; $count < $max; $count++ ) {
					$ColInnerHTML .= '<br>&nbsp;';
				}
			}
		} else {
			if ($rowSpan[$rowId][$departId]>1) {
				for ( $count = 1; $count < ($rowSpan[$rowId][$departId]); $count++ ) {
					$ColInnerHTML .= '<br>&nbsp;';
				}
			}
		}
		

		$ColInnerHTML .= '</td>';
			
	} else {
		$used = 0;
		if($detailAs == 2) {
			$max = recursive_array_max($rowSpan[$rowId]);
			$h = $max>1?$max*18:18;
		} else {
			$h = $rowSpan[$rowId][$departId]>1?$rowSpan[$rowId][$departId]*18:18;
		}
		if ( $error ) {
			$colour	 = "#db4242";
			$fontColour = "#fff";
		}
		$ColInnerHTML .= '<td valign="top" class="'.$brdrCls.'" style="height:'.$h.'px; overflow:hidden; white-space:nowrap; background-color: ' . $colour . '; color: ' . $fontColour . ';'.$pointer .'"' .$clickThrough .' align="'.$align.'">';
		if (isset($d[$departId]['value'])) {
			foreach ( $d[$departId]['value'] as $cellItem ) {
				if ( $first && $error == true) {
					$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
				}
						
				// You have a roomed overbooking! Double silly bugger!
				if ( isset($d['overbooked']) && $d['overbooked']) {
					$error = true;
					$msg = "You have a room-level overbooking.";
					$errorDesc = str_replace("%status%", $msg, $errorMsg);
					if ( $first ) {
						$cellItem['value'] = $erorrDesc . ' ' . join("/",$d['overbookedList']);
					}
				}
				$first = false;

				// [ START ] Colour handling ---------------------------------------------
				if ( in_array($departId,$colourIds) && $cellItem['colour'] != "" ) {
					$colour = '#' . $cellItem['colour'];
				}
				if ( $error ) {
					$colour		= "#db4242";
					$fontColour	= "#fff";
				}
				// [ END ] Colour handling ---------------------------------------------

				if ( mb_strlen($cellItem['value']) > MAX_CHAR_HTML+2 && !$first ) {
					$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
				}

				$ColInnerHTML .= '
					<div style="background-color: ' . $colour . '; color: ' . $fontColour . '; 
					height:18px; white-space:nowrap; overflow:hidden;">'.nl2br($cellItem['value']) .'</div>
				'; 
				$used++;
			}
		}
		if($used<1) {
			$used = 1;
		}
		
		if(empty($d[$departId]['value'])) {
			$ColInnerHTML .= '&nbsp;';
		}
		$ColInnerHTML .= '</td>';
		$first = false;
	}
		
	return $ColInnerHTML;
}

function createRoomDetailsAsRow($chartIds, $data, $chartSections, $flag, $rowId, $colId, $combinedFlag=0) {
	$tempArr = array();
	$cellwidth   = 10;
	$initialColour	  = "#fff";
	$initialFontColour  = "#000";
	$align = "";
	$error = false;
	
	if($combinedFlag == 1) {
		$detailIds = $chartIds['combined'];
	} else {
		$detailIds = $chartIds[$flag];
	}
	$perDayIds = $chartIds['perDay'];
	$colourIds = $chartIds['colour'];
	$c = isset($data[$flag][$rowId][$colId]) ? $data[$flag][$rowId][$colId] : "";
	$b = isset($data['block'][$rowId][$colId]) ? $data['block'][$rowId][$colId] : "";
	
	if ( $b != "" ) {
		$initialColour = array(0xc0,0xc0,0xc0);
	}
	
	if($combinedFlag == 1) {
		$rowSpanR = getRowSpans($data, 'room', $detailIds);
		$rowSpanS = getRowSpans($data, 'stayOver', $detailIds);
		$rowSpanD = getRowSpans($data, 'depart', $detailIds);
	}
	
	$rowSpan = getRowSpans($data,$flag,$detailIds);
	$rowSpans = $rowSpan[$rowId];
	$totalSubCell = array_sum($rowSpans);
	
	$roomInformation = '';
	$first = true;
	$repFlag = 0;
	$styleFlag = 1;
	$processedId = array();
	$ColInnerHTML = "";
	$etaId = "";
	$etdId = "";
	
	foreach ( $detailIds as $showId ) {
		if(in_array($showId, $perDayIds)) {
			continue;
		}

		if($combinedFlag == 1) {
			$rowSpan[$rowId][$showId] = max($rowSpanR[$rowId][$showId], $rowSpanS[$rowId][$showId], $rowSpanD[$rowId][$showId]);
		}

		$typeId = getDetailType($showId, $chartSections);
		if($typeId == 1) {
			if($showId == findSectionId($chartSections,"extras") || 
			$showId == findSectionId($chartSections,"extraNote") || 
			$showId == findSectionId($chartSections,"extraMemo")){
				$descId = findSectionId($chartSections,"extras");
				$noteId = findSectionId($chartSections,"extraNote");
				$memoId = findSectionId($chartSections,"extraMemo");
				$supId = findSectionId($chartSections, "extraSupplier");
				$travelFlag = 0;
			} else {
				$descId = findSectionId($chartSections,"travel");
				$noteId = findSectionId($chartSections,"travelNote");
				$memoId = findSectionId($chartSections,"travelMemo");
				$etaId = findSectionId($chartSections,"travelETA");
				$etdId = findSectionId($chartSections,"travelETD");
				$supId = findSectionId($chartSections, "travelSupplier");
				$travelFlag = 1;
			}
		}

		$colour		= $initialColour;
		$fontColour = $initialFontColour;

		// Provisional booking
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 20 ) {
			$fontColour = '#369';
		}
		
		// Provisional expiring today
		if ( isset($c['rv_provision_expiry_date']) && $c['rv_provision_expiry_date'] == date('Y-m-d') )  {
			$colour		= "#f1c55d";
			$fontColour	= "#000";
		}

		// Allocation
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 15 ) {
			$fontColour = "#999";
		}

		$errorMsg = '<img src="/resource/Resrequest/Application/public/img/icon_error_12.gif" width="12" height="12" alt="" style="display: inline;" onmouseover="overlib(\'%status%\');" onmouseout="nd();" />';

		// We have an expired provisional that is roomed
		if (
            isset($c['rv_provision_expiry_date']) &&
            $c['rv_provision_expiry_date'] != 0000-00-00 &&
            $c['rv_provision_expiry_date'] < date("Y-m-d") &&
            $c['rf_reservation_status_id'] != "30"  // Status is not confirmed
        ) {
			$error = true;
			$msg = "You have an expired provisional that has been roomed.";
			$errorDesc = str_replace("%status%", $msg, $errorMsg);
		}

		// [START] Reservation status error handling ----------------------------
		// Quotation
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == "0" ) {
			$error = true;
			$msg = "You have a quotation that has been roomed.";
			$errorDesc = str_replace("%status%", $msg, $errorMsg);
		}

		// Waitlisted
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 10 ) {
			$error = true;
			$msg = "You have a waitlisted that has been roomed.";
			$errorDesc = str_replace("%status%", $msg, $errorMsg);
		}

		// Cancelled
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 90 ) {
			$error = true;
			$msg = "You have a cancelled reservation that has been roomed.";
			$errorDesc = str_replace("%status%", $msg, $errorMsg);
		}
		
		// Add clickthrough to cell ----------------------------------------------
		$clickThrough = "";
		$pointer = '';
		if ( isset($c['rv_reservation_id']) && $c['rv_reservation_id'] != "" ) {
			$clickThrough = "onclick=\"window.location = '/reservation.php?2+" . $c['rv_reservation_id'] . "'\"";
			$pointer = 'cursor: pointer;';
		}

		if ( isset($data['direction']) && $data['direction'] == "2" ) {
			if($data['rows'][$rowId]['room'] == "overbooking") {
				$colour = "#db4242";
			}
		} else {
			if($data['columns'][$colId]['room'] == "overbooking") {
				$colour = "#db4242";
			}
		}
		
		if (isset($c[$showId]['value']) && !is_array($c[$showId]['value']) && $typeId != 1) {
			
			// [ START ] Reservation status error handling ----------------------------
			if ( $first && $error == true) {
				$c[$showId]['value'] = $errorDesc . ' ' . $c[$showId]['value'];
			}
			// [ END ] Reservation status error handling ----------------------------

			// You have a roomed overbooking! Double silly bugger!
			if ( isset($c['overbooked']) && $c['overbooked'] ) {
				$error = true;
				$msg = "You have a room-level overbooking.";
				$errorDesc = str_replace("%status%", $msg, $errorMsg);
				if ( $first ) {
					$c[$showId]['value'] = $errorDesc . ' ' . join("/",$c['overbookedList']);
				}
			}
					
			// [ START ] Colour handling ----------------------------
			if ( in_array($showId,$colourIds) && $c[$showId]['colour'] != "" ) {
				$colour = "#" . $c[$showId]['colour'];
			}
			if ( $error ) {
				$colour	 = "#db4242";
				$fontColour = "#fff";
			}
			// [ END ] Colour handling ----------------------------

			if ( trim($c[$showId]['value']) == '' ) {
				$c[$showId]['value'] = "&nbsp;";
			}

			if ( mb_strlen($c[$showId]['value']) > MAX_CHAR_HTML+2 ) {
				if ( $first && $error == true) {
				} else {
					$c[$showId]['value'] = substr($c[$showId]['value'],0,MAX_CHAR_HTML) . '..';
				}
			}
			$first = false;

			if (isset($ColInnerHTML)) {
				$ColInnerHTML .= '<tr> <td style="white-space:nowrap; overflow:hidden; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour . '; height: 18px;' . $pointer . '" valign="top" align="'.(isset($align) ? $align : "").'" ' . $clickThrough . '>' . $c[$showId]['value'].'&nbsp;</td></tr>';
			} else {
				$ColInnerHTML = '<tr> <td style="white-space:nowrap; overflow:hidden; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour . '; height: 18px;' . $pointer . '" valign="top" align="'.(isset($align) ? $align : "").'" ' . $clickThrough . '>' . $c[$showId]['value'].'&nbsp;</td></tr>';
			}

			if ($rowSpan[$rowId][$showId]>1 ) {
				for ( $count = 1; $count < ($rowSpan[$rowId][$showId]); $count++ ) {
					$ColInnerHTML .= '
						<tr style="height:18px;" >
							<td valign="top" align="'.$align.'" style="white-space:nowrap; overflow:hidden; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour . '; height: 18px;">&nbsp;</td>
						</tr>';
				}
			}
		
		} else {
			$used = 0;
			if ($typeId == 1) {
				if(!in_array($showId, $processedId)) {
					$repFlag = 0;
				}

				for ( $count = 0; $count < $rowSpans[$showId]; $count++ ) {
					$cellItem	  = isset($c[$showId]['value'][$count]) ? $c[$showId]['value'][$count] : array();
					$cellItemDesc = isset($c[$descId]['value'][$count]) ? $c[$descId]['value'][$count] : array();
					$cellItemNote = isset($c[$noteId]['value'][$count]) ? $c[$noteId]['value'][$count] : array();
					$cellItemMemo = isset($c[$memoId]['value'][$count]) ? $c[$memoId]['value'][$count] : array();
					$cellItemSup = isset($c[$supId]['value'][$count]) ? $c[$supId]['value'][$count] : array();

					if ( isset($cellItem['value']) && mb_strlen($cellItem['value']) > MAX_CHAR_HTML+2) {
						$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
					}
					if ( isset($cellItemDesc['value']) && mb_strlen($cellItemDesc['value']) > MAX_CHAR_HTML+2) {
						$cellItemDesc['value'] = substr($cellItemDesc['value'],0,MAX_CHAR_HTML) . "..";
					}
					if ( isset($cellItemNote['value']) && mb_strlen($cellItemNote['value']) > MAX_CHAR_HTML+2) {
						$cellItemNote['value'] = substr($cellItemNote['value'],0,MAX_CHAR_HTML) . "..";
					}
					if ( isset($cellItemMemo['value']) && mb_strlen($cellItemMemo['value']) > MAX_CHAR_HTML+2) {
						$cellItemMemo['value'] = substr($cellItemMemo['value'],0,MAX_CHAR_HTML) . "..";
					}
					if ( isset($cellItemSup['value']) && mb_strlen($cellItemSup['value']) > MAX_CHAR_HTML+2) {
						$cellItemSup['value'] = substr($cellItemSup['value'],0,MAX_CHAR_HTML) . "..";
					}
					
					if ( $first && $error == true ) {
						$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
					}
					
					// [START] Colour handling ---------------------------------------------
					if ( in_array($showId,$colourIds) && isset($cellItem['colour']) && $cellItem['colour'] != '' ) {
						$colour = '#' . $cellItem['colour'];
					}
					
					$colourDesc = $colourNote = $colourMemo = $colourSup = $colour;
					if ( in_array($descId,$colourIds) && isset($cellItemDesc['colour']) && $cellItemDesc['colour'] != '' ) {
						$colourDesc = '#' . $cellItemDesc['colour'];
					}
					if ( in_array($noteId,$colourIds) && isset($cellItemNote['colour']) && $cellItemNote['colour'] != '' ) {
						$colourNote = '#' . $cellItemNote['colour'];
					}
					if ( in_array($memoId,$colourIds) && isset($cellItemMemo['colour']) && $cellItemMemo['colour'] != '' ) {
						$colourMemo = '#' . $cellItemMemo['colour'];
					}
					if ( in_array($supId,$colourIds) && isset($cellItemSup['colour']) && $cellItemSup['colour'] != '' ) {
						$colourSup = '#' . $cellItemSup['colour'];
					}
					
					if($travelFlag == 1) {
						$cellItemEta = isset($c[$etaId]['value'][$count]) ? $c[$etaId]['value'][$count] : array();
						$cellItemEtd = isset($c[$etdId]['value'][$count]) ? $c[$etdId]['value'][$count] : array();
						
						if ( isset($cellItemEta['value']) && mb_strlen($cellItemEta['value']) > MAX_CHAR_HTML+2) {
							$cellItemEta['value'] = substr($cellItemEta['value'],0,MAX_CHAR_HTML) . "..";
						}
						if ( isset($cellItemEtd['value']) && mb_strlen($cellItemEtd['value']) > MAX_CHAR_HTML+2) {
							$cellItemEtd['value'] = substr($cellItemEtd['value'],0,MAX_CHAR_HTML) . "..";
						}
						
						$colourETA = $colourETD = $colour;
						if ( in_array($etaId,$colourIds) && $cellItemEta['colour'] != '' ) {
							$colourETA = '#' . $cellItemEta['colour'];
						}
						if ( in_array($etdId,$colourIds) && $cellItemEtd['colour'] != '' ) {
							$colourETD = '#' . $cellItemEtd['colour'];
						}
					}
					
					if ( $error ) {
						$colour	 = $colourDesc =  $colourNote =  $colourMemo = $colourSup = $colourETA = $colourETD = "#db4242";
						$fontColour = "#fff";
					}
					// [ END ] Colour handling --------------------------------------------

					if($showId == $descId  && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItem['value']) ? $cellItem['value'] : "") .'&nbsp;</td>
								</tr>
							';
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}

						if($travelFlag == 1) {

							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETA) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEta['value']) ? $cellItemEta['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETD) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds) && !in_array($memoId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourMemo) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourNote) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemNote['value']) ? $cellItemNote['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds) && !in_array($supId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourSup) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					}
					else if(($showId == $noteId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItem['value']) ? $cellItem['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						if(in_array($supId, $detailIds) && !in_array($supId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourSup) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds ) && !in_array($descId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourDesc) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETA) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEta['value']) ? $cellItemEta['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETD) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds) && !in_array($memoId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourMemo) . '; color: ' .
									$fontColour . '; height:18px;">' . (isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					}
					else if(($showId == $memoId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItem['value']) ? $cellItem['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourNote) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItemNote['value']) ? $cellItemNote['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds) && !in_array($supId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourSup) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourDesc) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETA) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEta['value']) ? $cellItemEta['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETD) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}

						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					} else if(($showId == $etaId) && $repFlag == 0) {
						if($travelFlag == 1) {
							if(in_array($showId, $detailIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItem['value']) ? $cellItem['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($showId, $processedId)) {
									array_push($processedId, $showId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETD) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds) && !in_array($memoId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourMemo) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourNote) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItemNote['value']) ? $cellItemNote['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds) && !in_array($supId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourSup) . '; color: ' . colourConvert($fontColour) . '; height:18px;">' . (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourDesc) . '; color: ' . colourConvert($fontColour) . '; height:18px;">' . (isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}

					} else if(($showId == $etdId) && $repFlag == 0) {
						if($travelFlag == 1) {
							if(in_array($showId, $detailIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItem['value']) ? $cellItem['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($showId, $processedId)) {
									array_push($processedId, $showId);
								}
							}
						}
						if(in_array($memoId, $detailIds)  && !in_array($memoId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourMemo) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds)  && !in_array($noteId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourNote) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItemNote['value']) ? $cellItemNote['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds) && !in_array($supId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourSup) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds)  && !in_array($descId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourDesc) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETA) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEta['value']) ? $cellItemEta['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					}
					else if(($showId == $supId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . 
									$fontColour . '; height:18px;">' . (isset($cellItem['value']) ? $cellItem['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						if(in_array($descId, $detailIds ) && !in_array($descId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourDesc) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETA) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEta['value']) ? $cellItemEta['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								$ColInnerHTML .= '
									<tr>
										<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourETD) . '; color: ' . 
										$fontColour . '; height:18px;">' . (isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "") . '&nbsp;</td>
									</tr>
								';
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds) && !in_array($memoId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourMemo) . '; color: ' .
									$fontColour . '; height:18px;">' . (isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							$ColInnerHTML .= '
								<tr>
									<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colourNote) . '; color: ' . $fontColour . '; height:18px;">' . (isset($cellItemNote['value']) ? $cellItemNote['value'] : "") . '&nbsp;</td>
								</tr>
							';
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					}
					$styleFlag++;
				}

			} else {
				$used = 0;
				if (isset($c[$showId]['value'])) {
					foreach ( $c[$showId]['value'] as $cellItem ) {
						// [ START ] Colour handling ---------------------------------------------
            $cellItem['colour'] = isset($cellItem['colour']) ? $cellItem['colour'] : "";
						if ( in_array($showId,$colourIds) && $cellItem['colour'] != "" ) {
							$colour = '#' . $cellItem['colour'];
						}
						if ($error) {
							$colour		= "#db4242";
							$fontColour	= "#fff";
						}
						// [ END ] Colour handling ---------------------------------------------
						
						if ( mb_strlen($cellItem['value']) > MAX_CHAR_HTML+2 && !$first ) {
							$cellItem['value'] = substr($cellItem['value'],0,MAX_CHAR_HTML) . "..";
						}
						
						$ColInnerHTML .= '
							<tr>
								<td valign="top" align="'.$align.'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour.
								';height:18px;">'. (isset($cellItem['value']) ? $cellItem['value'] : "") . '&nbsp;</td>
							</tr>
						';
						
						$used++;
					}
				}
				if ($error) {
					$colour		= "#db4242";
					$fontColour	= "#fff";
				}

				$ColInnerHTML = isset($ColInnerHTML) ? $ColInnerHTML : "";
				if ( $used < $rowSpan[$rowId][$showId] ) {
					for ( $count = 0; $count < ($rowSpan[$rowId][$showId] - $used); $count++ ) {
						if (is_array($colour)) {
							$colour = "#" . dechex(hexdec($colour[0])) . dechex(hexdec($colour[1])) . dechex(hexdec($colour[2]));
						}

						$ColInnerHTML .= '
							<tr style="height:18px;">
								<td valign="top" align="'.(isset($align) ? $align : "").'" style="overflow:hidden; white-space:nowrap; background-color: ' . colourConvert($colour) . '; color: ' . $fontColour . '; height:18px;">&nbsp;</td>
							</tr>
						';	
					}
				}
			}
			
			$first = false;
		}
	}
	return $ColInnerHTML;
}

function createCols($detailIds, $chartSections, $detailsAs=1, $perDayIds=array()) {
	$colHTML = '';
	foreach ( $detailIds as $departId ) {
		if(!empty($perDayIds) && in_array($departId, $perDayIds)) {
				continue;
		}
		$w = getHeaderAtr($chartSections, $departId, 'width');
		$colHTML .= '<col style="width:'.$w.'px;" />';
	}
	return $colHTML;
}

function createInnerRoomDetails($chart,$type, $rowId, $colId, $chartIds, $chartSections) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds = $chartIds['perDay'];
	$combinedIds = $chartIds['combined'];
	$initialColour	  = "#fff";
	$initialFontColour  = "#000";
	$error = false;
	$errorDesc = "";
	
	$detailIds = $chartIds[$type];
	$colWidth =200;

	$roomRowSpans	= getRowSpans($chart,"room",$showIds);
	$departRowSpans	= getRowSpans($chart,"depart",$departIds);
	$stayOverRowSpans = getRowSpans($chart,"stayOver",$stayOverIds);
	$detailRowSpans = getRowSpans($chart,$type,$detailIds);

	$d = isset($chart[$type][$rowId][$colId]) ? $chart[$type][$rowId][$colId] : "";
	$b = isset($chart['block'][$rowId][$colId]) ? $chart['block'][$rowId][$colId] : "";
		
	$initialColour = "#f2f2f2";
	if ( $b != "" ) {
		$initialColour = "#c0c0c0";				
	}

	if(isset($chart['columns'][$colId]['room']) && $chart['columns'][$colId]['room'] == "overbooking") {
		$initialColour = "#db4242";
	}

	$colour		= $initialColour;
	$fontColour = $initialFontColour;

	
	$totalWidth = 0;
	if($chart['sep_asd'] == '2') {
		if($chart['detailAs'] == '2') {
			foreach ( $showIds as $showId ) {
				if(in_array($showId, $perDayIds)) {
					continue;
				}
				$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
			}
			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				foreach ( $stayOverIds as $showId ) {
					if(in_array($showId, $perDayIds)) {
						continue;
					}
					$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
				}
			}
			foreach ( $departIds as $showId ) {
				if(in_array($showId, $perDayIds)) {
					continue;
				}
				$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
			}
				
		} else {
			$totalWidth += $colWidth;
			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				$totalWidth += $colWidth;
			}
			if(count($departIds)>0) {
				$totalWidth += $colWidth;
			}
		}
	} else {
		$optionIds = $combinedIds;
		if($chart['sep_asd'] == '3') {
			$optionIds = $detailIds;
		}
		if($chart['detailAs'] == '2') {
			foreach ( $optionIds as $showId ) {
				if(in_array($showId, $perDayIds)) {
					continue;
				}
				$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
			}
			
		} else {
			$totalWidth += $colWidth;
		}
	}

	if($chart['detailAs'] == '2') {
		$style = 'style="width:'.$totalWidth.'px; table-layout: fixed; height:100% !important; border-collapse:collapse;"';
	} elseif($chart['detailAs'] == '1' && $chart['sep_asd'] == '2') {
		$style = 'style="width:'.$totalWidth.'px; table-layout: fixed; height:100% !important; border-collapse:collapse;"';
	} else {
		$style = 'style="width:'.$totalWidth.'px; table-layout: fixed; border-collapse:collapse;"';
	}
	$colHTML = '<table border="0" cellpadding="1" cellspacing="0" summary="" '.$style.'>';
	
	if($chart['sep_asd'] == '2') {
		if($chart['detailAs'] == '2') {
			if(count($showIds)>0) {
				$colHTML .= createCols($showIds, $chartSections, 2, $perDayIds);
			}
			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				$colHTML .= createCols($stayOverIds, $chartSections, 2, $perDayIds);
			}
			if(count($departIds)>0) {
				$colHTML .= createCols($departIds, $chartSections, 2, $perDayIds);
			}
		
		} else {
			if(count($showIds)>0) {
				$colHTML .= '<col style="width:'.$colWidth.'px" />';
			}
			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				$colHTML .= '<col style="width:'.$colWidth.'px" />';
			}
			if(count($departIds)>0) {
				$colHTML .= '<col style="width:'.$colWidth.'px" />';
			}
		}
	} else {
		$optionIds = $combinedIds;
		if($chart['sep_asd'] == '3') {
			$optionIds = $detailIds;
		}
		if($chart['detailAs'] == '2') {
			$colHTML .= createCols($optionIds, $chartSections, 2, $perDayIds);
			
		} else {
			$colHTML .= '<col style="width:'.$colWidth.'px" />';
		}
	}
		
	$first = true;
	
	if($chart['sep_asd'] == '2') {
		if($chart['detailAs'] == '2') {
			//$colHTML .= '<tr style="height: 100% !important;">';
			$colHTML .= '<tr>';
			foreach ($showIds as $departId ) {
				if(!in_array($departId, $perDayIds)) {
					$colHTML .= createRoomDetail($chart, 'room', $departId, $colourIds, $rowId, $colId,2, $roomRowSpans, $chartSections);
				}
			}

			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				foreach ($stayOverIds as $departId ) {
					if(!in_array($departId, $perDayIds)) {
						$colHTML .= createRoomDetail($chart, 'stayOver', $departId, $colourIds, $rowId, $colId, 2, $stayOverRowSpans, $chartSections);
					}
				}
			}
			foreach ($departIds as $departId ) {
				if(!in_array($departId, $perDayIds)) {
					$colHTML .= createRoomDetail($chart, 'depart', $departId, $colourIds, $rowId, $colId, 2, $departRowSpans, $chartSections);
				}
			}
						
			$colHTML .= '</tr>';
		
		} else {
			$colHTML .= '
				<tr style="height: 100% !important;">
					<td class="bl" valign="top">
						<table border="0" cellpadding="1" cellspacing="0" summary="" width="100%">
			';
			$colHTML .= createRoomDetailsAsRow($chartIds, $chart, $chartSections, 'room', $rowId, $colId,1);
			$colHTML .= '</table></td>';

			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				$colHTML .= '
					<td class="bl" valign="top">
						<table border="0" cellpadding="1" cellspacing="0" summary="" width="100%">
				';
				$colHTML .= createRoomDetailsAsRow($chartIds, $chart, $chartSections, 'stayOver', $rowId, $colId,1);
				$colHTML .= '</table></td>';
			}
			if(count($departIds)>0) {
				$colHTML .= '
					<td class="bl" valign="top">
						<table border="0" cellpadding="1" cellspacing="0" summary="" width="100%">
				';
				$colHTML .= createRoomDetailsAsRow($chartIds, $chart, $chartSections, 'depart', $rowId, $colId,1);
				$colHTML .= '</table></td>';
			}
			$colHTML .= '</tr>';
		}
		
	} else {
		if($chart['detailAs'] == '2') {
			$optionIds = $combinedIds;
			if($chart['sep_asd'] == '3') {
				$optionIds = $detailIds;
			}
			$colHTML .= '<tr>';
			foreach ($optionIds as $departId) {
				if(!in_array($departId, $perDayIds)) {
					$colHTML .= createRoomDetail($chart, $type, $departId, $colourIds, $rowId, $colId, 2,$detailRowSpans, $chartSections);
				}
			}
			$colHTML .= '</tr>';
		} else {
			$colHTML .= createRoomDetailsAsRow($chartIds, $chart, $chartSections, $type, $rowId, $colId);
		} 
	}
	$colHTML .= '</table>';
		
	return $colHTML;
}

function perDayDetail($d, $departId, $colourIds, $rowId, $detailAs=1, $rowSpan=1, $chartSections) {
	$fontColour		= "#000";
	$repFlag		= 0;
	$ColInnerHTML	= '';
	$brdrCls = 'br';

	if($detailAs == 2) {
		$align = getHeaderAtr($chartSections, $departId, 'align');
	} else {
		$align = "left";
	}

	$label = getHeaderAtr($chartSections, $departId, 'label');
	// Add clickthrough to cell ----------------------------------------------
	$clickThrough = "";
	$pointer = '';
	if ( isset($d['rv_reservation_id']) && $d['rv_reservation_id'] != "" ) {
		$clickThrough = "onclick=\"window.location = '/reservation.php?2+" . $d['rv_reservation_id'] . "'\"";
		$pointer = 'cursor: pointer;';
	}
	
	if ( isset($d[$departId]['value']) && !is_array($d[$departId]['value']) ) {	
		if(isset($d[$departId]['value']) && $d[$departId]['value'] != "") {
			// [ START ] Colour handling ----------------------------
      $colour = "";
			if ( in_array($departId,$colourIds) && $d[$departId]['colour'] != "" ) {
				$colour = "#" . $d[$departId]['colour'];
			}
			// [ END ] Colour handling ----------------------------

			if ( trim($d[$departId]['value']) == '' ) {
				$d[$departId]['value'] = "&nbsp;";
			}

			$h = $rowSpan[$rowId][$departId]*18;
			$ColInnerHTML .= '<td valign="top" style="word-wrap: break-word; background-color: ' . colourConvert($colour) . '; color: ' . colourConvert($fontColour) . '; ' . $pointer . '" ' . $clickThrough .'align="'.$align.'"> <b>'.$label.': </b>' . nl2br($d[$departId]['value']);

			$ColInnerHTML .= '</td>';
		}
	
	} else {
		$used = 0;
		$h = count($d[$departId]['value'])>1?count($d[$departId]['value'])*18:18;
		$perDayHtml = "";
		foreach ( $d[$departId]['value'] as $cellItem ) {
			// [ START ] Colour handling ---------------------------------------------
			if ( in_array($departId,$colourIds) && $cellItem['colour'] != "" ) {
				$colour = '#' . $cellItem['colour'];
			}
			// [ END ] Colour handling ---------------------------------------------
			if($perDayHtml != "") {
				$perDayHtml .= "<br>";
			}
			$perDayHtml .= isset($cellItem['value']) ? $cellItem['value'] : "";
			$used++;
		}
		if($perDayHtml != "") {
			$ColInnerHTML .= '<td valign="top" style="word-wrap: break-word; '.$pointer 
							.'"' .$clickThrough .' align="'.$align.'"><b>'.$label.': </b> '.nl2br($perDayHtml);
			$ColInnerHTML .= '</td>';
		}
	}
		
	return $ColInnerHTML;
}

function cretaePerDayDetails($chart,$type, $rowId, $colIds, $chartIds, $chartSections) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds = $chartIds['perDay'];
	
	$detailIds = $chartIds[$type];
	$colWidth =200;

	$roomRowSpans	= getRowSpans($chart,"room",$showIds);
	$departRowSpans	= getRowSpans($chart,"depart",$departIds);
	$stayOverRowSpans= getRowSpans($chart,"stayOver",$stayOverIds);


	$colHTML = '<table border="0" cellpadding="1" cellspacing="0" summary="" style="border-collapse:collapse; table-layout: fixed;" class="table-wrap">';

	if(is_array($colIds) && !empty($colIds)) {
		$resIds = array();
		foreach($colIds as $colId) {
			$dataFlag = false;
			foreach ($perDayIds as $departId ) {
				if(!empty($chart[$type][$rowId][$colId][$departId]['value'])) {
					$dataFlag = true;
				}
			}

			if($dataFlag) {
				if($chart[$type][$rowId][$colId]['rv_reservation_id']) {
					if(!in_array($chart[$type][$rowId][$colId]['rv_reservation_id'], $resIds)) {
						if(!empty($resIds)) {
							$colHTML .= '<tr><td valign="top" style="height:18px;">&nbsp;</td></tr>';
						}
						$colHTML .= '<tr><td valign="top" style="height:18px; word-wrap: break-word;"> 
									<b>Res#: </b>' . $chart[$type][$rowId][$colId]['rv_reservation_id'].
								'</td></tr>';
						$colHTML .= '<tr><td valign="top" style="height:18px; word-wrap: break-word;"> 
										<b>Res name: </b>' . $chart[$type][$rowId][$colId]['rv_res_name']. 
									'</td></tr>';
						
						foreach ($perDayIds as $departId ) {
							if(empty($chart[$type][$rowId][$colId][$departId]['value'])) {
								continue;
							}
							$data = perDayDetail($chart[$type][$rowId][$colId], $departId, $colourIds, $rowId, 2, $roomRowSpans, $chartSections);
							if($data != "") {
								$colHTML .= '<tr style="height: 100% !important;">';
								$colHTML .= $data;
								$colHTML .= '</tr>';
							}
						}
						
						array_push($resIds,$chart[$type][$rowId][$colId]['rv_reservation_id']);
					}
				}
			}
		}
	}
	
	$colHTML .= '</table>';
	return $colHTML;
}

function perDayRowHTML($data, $perDayIds, $colourIds, $rowId, $detailAs, $roomRowSpans, $chartSections) {
	$dataFlag = false;
	foreach ($perDayIds as $departId ) {
		if(!empty($data[$departId]['value'])) {
			$dataFlag = true;
		}
	}

	$colHTML = '<tr><td valign="top" style="height:18px; word-wrap: break-word;"> <b>Res#: </b>' . 
				$data['rv_reservation_id']. '</td></tr>';
	$colHTML .= '<tr><td valign="top" style="height:18px; word-wrap: break-word;"> <b>Res name: </b>' . 
				$data['rv_res_name'].'</td></tr>';

	foreach ($perDayIds as $departId ) {
		if(empty($data[$departId]['value'])) {
			continue;
		}
		$dataHtml = perDayDetail($data, $departId, $colourIds, $rowId, $detailAs, $roomRowSpans, $chartSections);
		if($dataHtml != "") {
			$colHTML .= '<tr style="height: 100% !important;">';
			$colHTML .= $dataHtml;
			$colHTML .= '</tr>';
		}
	}

	return $colHTML;
}

function cretaePerDayDetailsRows($chart, $type, $rowIdsArr, $chartIds, $chartSections) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds = $chartIds['perDay'];
	
	$detailIds = $chartIds[$type];
	$colWidth =200;
	$roomRowSpans	= getRowSpans($chart,"room",$showIds);
	$departRowSpans	= getRowSpans($chart,"depart",$departIds);
	$stayOverRowSpans	= getRowSpans($chart,"stayOver",$stayOverIds);
	
	$spn = 1;
	if($chart['sep_asd'] == '1') {
		$spn++;
	}
	if($chart['detailAs'] == '1') {
		$spn ++;
	}

	$colHTML = '<tr>
					<td colspan="'.$spn.'" class="bt bl bb" valign="top">Details</td>
			';
	foreach ( $chart['columns'] as $col ) {
		$resIds = array();
		$colHTML .= '<td class="bt bl bb" valign="top">';
		$colHTML .= '<table border="0" cellpadding="1" cellspacing="0" summary="" style="border-collapse:collapse;" class="table-wrap">';
		$nodata = 0;
		if(!empty($rowIdsArr)) {
			foreach($rowIdsArr as $rowId) {
				if($chart['sep_asd'] == '3') {
					if($chart[$type][$rowId][$col['id']]['rv_reservation_id']) {
						if(!in_array($chart[$type][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
							$dataFlag = false;
							foreach ($perDayIds as $departId ) {
								if(!empty($chart[$type][$rowId][$col['id']][$departId]['value'])) {
									$dataFlag = true;
								}
							}
							if(!empty($resIds) && $dataFlag) {
								$colHTML .= '<tr><td valign="top" style="height:18px;">&nbsp;</td></tr>';
							}
							if($dataFlag) {
								$colHTML .= perDayRowHTML($chart[$type][$rowId][$col['id']], $perDayIds, $colourIds, $rowId, 2, $roomRowSpans, $chartSections);
								array_push($resIds,$chart[$type][$rowId][$col['id']]['rv_reservation_id']);
							}
							
						}
					}
					if(!$chart[$type][$rowId][$col['id']]['rv_reservation_id']) {
						$nodata = 1;
					}
				} else {
					if(isset($chart['room'][$rowId][$col['id']]['rv_reservation_id']) && !empty($chart['room'][$rowId][$col['id']]['rv_reservation_id'])) {
						if(!in_array($chart['room'][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
							$dataFlag = false;
							foreach ($perDayIds as $departId ) {
								if(!empty($chart['room'][$rowId][$col['id']][$departId]['value'])) {
									$dataFlag = true;
								}
							}
							if($dataFlag) {
								$colHTML .= perDayRowHTML($chart['room'][$rowId][$col['id']], $perDayIds, $colourIds, $rowId, 2, $roomRowSpans, $chartSections);
								array_push($resIds,$chart['room'][$rowId][$col['id']]['rv_reservation_id']);
							}
							
						}
					}

					if($chart['combArrSty'] == '2' && $chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']) {
						if(!in_array($chart['stayOver'][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
							$dataFlag = false;
							foreach ($perDayIds as $departId ) {
								if(!empty($chart['stayOver'][$rowId][$col['id']][$departId]['value'])) {
									$dataFlag = true;
								}
							}
							if($dataFlag) {
								$colHTML .= perDayRowHTML($chart['stayOver'][$rowId][$col['id']], $perDayIds, $colourIds, $rowId, 2, $roomRowSpans, $chartSections);
								array_push($resIds, $chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']);
							}
							
						}
					}

					if(isset($chart['depart'][$rowId][$col['id']]['rv_reservation_id']) && !empty($chart['depart'][$rowId][$col['id']]['rv_reservation_id'])) {
						if(!in_array($chart['depart'][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
							$dataFlag = false;
							foreach ($perDayIds as $departId ) {
								if(!empty($chart['depart'][$rowId][$col['id']][$departId]['value'])) {
									$dataFlag = true;
								}
							}
							if($dataFlag) {
								$colHTML .= perDayRowHTML($chart['depart'][$rowId][$col['id']], $perDayIds, $colourIds, $rowId, 2, $roomRowSpans, $chartSections);
								array_push($resIds, $chart['depart'][$rowId][$col['id']]['rv_reservation_id']);
							}
							
						}
					}

          if(
            (!isset($chart['room'][$rowId][$col['id']]['rv_reservation_id']) || empty($chart['room'][$rowId][$col['id']]['rv_reservation_id'])) 
            && (!isset($chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']) || empty($chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']))
            && (!isset($chart['depart'][$rowId][$col['id']]['rv_reservation_id']) || empty($chart['depart'][$rowId][$col['id']]['rv_reservation_id']))) {
						$nodata = 1;
					}
				}
			}
			if($nodata == 1) {
				$colHTML .= '<tr><td valign="top">&nbsp;</td></tr>';
			}
		} else {
			$colHTML .= '<tr><td valign="top">&nbsp;</td></tr>';
		}
		$colHTML .= '</table>';
		$colHTML .= '</td>';
	}	
	return $colHTML;
}

function generateChart($chartSections,$chartIds,$chart,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$autoRoom, $showCatExtras,$showEmptyRooms) {
	$showIds	 = $chartIds['room'];
	$colourIds	 = $chartIds['colour'];
	$departIds	 = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds   = $chartIds['perDay'];
	$combinedIds = $chartIds['combined'];
	$initialColour	  = "#fff";
	$initialFontColour  = "#000";
	$rowClass = "";
	
	if($chart['combArrSty'] == '1') {
		$combination = "Inhouse";
	} else {
		$combination = "Arrival";
	}
	
	$rows = '<col style="width:200px;" />';
	$tableExtraWidth = 200;
	$totalRows = 0;
	$extraRows = 1;
	if($chart['sep_asd'] == '1') {
		$rows .= '<col style="width:150px;" />';
		$tableExtraWidth +=150;
		$extraRows++;
	}
	if($chart['detailAs'] == '1') {
		$rows .= '<col style="width:150px;" />';
		$tableExtraWidth +=150;
		$extraRows++;
	}
	
	$numSubCols = 1;
	if($chart['sep_asd'] == '2') {
		if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
			$numSubCols += 1;
		}
		if(count($departIds) >0 ) {
			$numSubCols += 1;
		}
	}

	$numDetCols = 0;
	$totalWidth = 0;
	if($chart['detailAs'] == '2') {
		if($chart['sep_asd'] == '2') {
			//$numDetCols = (count($showIds)-count($perDayIds))>0?count($showIds)-count($perDayIds):0;
			foreach ( $showIds as $showId ) {
				if(in_array($showId, $perDayIds)) {
					continue;
				} else {
					$numDetCols += 1;
					$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
					$totalRows++;
				}
			}

			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				//$numDetCols += count($stayOverIds)-count($perDayIds);
				foreach ( $stayOverIds as $showId ) {
					if(in_array($showId, $perDayIds)) {
						continue;
					} else {
							$numDetCols += 1;
						$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
						$totalRows++;
					}
				}
			}
			//$numDetCols += count($departIds)-count($perDayIds);
			foreach ( $departIds as $departId ) {
				if(in_array($departId, $perDayIds)) {
					continue;
				} else {
					$numDetCols += 1;
					$totalWidth += getHeaderAtr($chartSections, $departId, 'width');
					$totalRows++;
				}
			}
		} else if($chart['sep_asd'] == '1') {
			$numDetCols = count($combinedIds)-count($perDayIds);
			foreach ( $combinedIds as $showId ) {
				if(in_array($showId, $perDayIds)) {
					continue;
				}
				$totalWidth += getHeaderAtr($chartSections, $showId, 'width');
				$totalRows++;
			}
		}
	} else {
		$totalWidth = 200;
		$totalRows++;
		if($chart['sep_asd'] == '2') {
			$numDetCols = $numSubCols;
			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				$totalWidth += 200;
				$totalRows++;
			}
			if(count($departIds)>0) {
				$totalWidth += 200;
			}
			$totalRows++;
		}
	}

	$colspn = $numDetCols;
	$colspnVal = ($colspn>1)?$colspn:1;

	$totalWidth = ($totalWidth>0)?$totalWidth:200;
	$numTH = count($chart['columns']);
	if($chart['direction'] == "1") {
		$firstProp = 1;
		$colcount = 1;
		$property_name = '';
		foreach ( $chart['columns'] as $col ) {
			if ( $property_name != $col['property'] ) {
				if($firstProp != 1) {
					if(count($chartIds['perDay'])>0) {
						$rows .= '<col  style="width:300px;" />';
						$tableExtraWidth = $tableExtraWidth + 300;
						$extraRows++;
					}
				}
				$property_name = $col['property'];
				$firstProp = 0;
			}
			$rows .= '<col  style="width:'.$totalWidth.'px;" />';
						
			if($colcount == count($chart['columns'])) {
				if(count($chartIds['perDay'])>0) {
					$rows .= '<col  style="width:300px;" />';
					$tableExtraWidth = $tableExtraWidth + 300;
					$extraRows++;
				}
			}
			$colcount++;
		}
	} else {
		foreach ( $chart['columns'] as $col ) {
			$rows .= '<col  style="width:'.$totalWidth.'px;" />';
		}
	}
	
	$GLOBALS['temp']['chartTableWidth'] = $tableExtraWidth + $numTH * $totalWidth;
	$GLOBALS['temp']['totalRows'] = $extraRows + ($totalRows*$numTH);

	if ( $chart['direction'] == "1" ) {
		$rows .= '<tr style="height:25px;">
					<td>&nbsp;</td>';
		if($chart['sep_asd'] == '1') {
			$rows .= '<td>&nbsp;</td>';
		}
		if($chart['detailAs'] == '1') {
			$rows .= '<td>&nbsp;</td>';
		}
		
		$property_name = '';
		$modCount = 0;
		$firstProp = 1;
		$colcount = 1;
		$bg_style = "colLt";
		foreach ( $chart['columns'] as $col ) {
			if ( $property_name != $col['property'] ) {
				if($firstProp != 1) {
					if(count($chartIds['perDay'])>0) {
						$rows .= '<td class="' . $bg_style . ' bt">&nbsp;</td>';
					}
				}

				$property_name = $col['property'];
				if ( $modCount%2 == 0 ) {
					$bg_style = "colLtt";
				} else {
					$bg_style = "colLt";
				}
				$modCount++;
				$firstProp = 0;
				if($col['room'] == "overbooking") {
					$rows .= '<td class="' . $bg_style . ' bt bl">&nbsp;</td>';
				} else {
					$rows .= '<td class="' . $bg_style . ' bt bl">' . $property_name . '</td>';
				}
			} else {
				$rows .= '<td class="' . $bg_style . ' bt">&nbsp;</td>';
			}
			if($colcount == count($chart['columns'])) {
				if(count($chartIds['perDay'])>0) {
					$rows .= '<td class="' . $bg_style . ' bt">&nbsp;</td>';
					
				}
			}
			$colcount++;
		}
		
		$rows .= '</tr>';
		$rows .= '
			<tr>
				<td>&nbsp;</td>';
		if($chart['sep_asd'] == '1') {
			$rows .= '<td>&nbsp;</td>';
		}
		if($chart['detailAs'] == '1') {
			$rows .= '<td class="colLtDk bt bl">Details</td>';
		}
		// Room names and numbers ---------------------------------------------------
		$property_name = "";
		$modCount = 0;
		$firstProp = 1;
		$colcount = 1;
		$bg_style = "colLt";
		
		foreach ( $chart['columns'] as $col ) {
			if ( $property_name != $col['property'] ) {
				if($firstProp != 1) {
					if(count($chartIds['perDay'])>0) {
						$rows .= '<td class="' . $bg_style . ' bt bl" style="width:200px;">Details</td>';
					}
				}
				if ( $modCount%2 == 0 ) {
					$bg_style = "colLtt";
				} else {
					$bg_style = "colLt";
				}
				$modCount++;
				$property_name = $col['property'];
				$firstProp = 0;
			}
			$rows .= '<td class="' . $bg_style . ' bt bl">
						<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidth.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">';
			if($chart['sep_asd'] == '2') {
				if($chart['detailAs'] == '2') {
					if(count($showIds)>0) {
						$rows .= createCols($showIds, $chartSections, 2, $perDayIds);
					}
					if($chart['combArrSty'] == '2' && count($stayOverIds) >0) {
						$rows .= createCols($stayOverIds, $chartSections, 2, $perDayIds);
						
					}
					if(count($departIds)>0) {
						$rows .= createCols($departIds, $chartSections, 2, $perDayIds);
					}
					
				} else {
					if(count($showIds)>0) {
						$rows .= '<col style="width:200px;" />';
					}
					if($chart['combArrSty'] == '2' && count($stayOverIds) >0) {
						$rows .= '<col style="width:200px;" />';
					}
					if(count($departIds)>0) {
						$rows .= '<col style="width:200px;" />';
					}
				}
			} else {
				if($chart['detailAs'] == '2') {
					$rows .= createCols($combinedIds, $chartSections, 2, $perDayIds);
					
				} else {
					$rows .= '<col style="width:200px;" />';
				}
			}
					
			if($col['room'] == "overbooking") {
				$roomName = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($col['property'])."<br>Accommodation:" .t_encodeOverlib($col['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
				$tdStyle = "style='font-size: 12px;font-weight: bold;'";
			} else {
				if ( $hideAccommType == "1" ) {
					$roomName = "";
				} else {
					$roomName = t_encodeHTML($col['accommodation']);
				}
				if ( $showUnitLabel == "1" ) {
					$roomName .= ' ' . t_encodeHTML($col['unit_label']);
				}
				if ( $showUnitNumber == "1" ) {
					$roomName .= ' ' . t_encodeHTML($col['room']);
				}
				$tdStyle = "";
			}

			$rows .= '<tr><td colspan='.$colspnVal.' '.$tdStyle.'>';
			
			$rows .= $roomName .'</td></tr>';
			if($chart['sep_asd'] == '2') {
				$spnRoom = 1;
				$spnSO = 1;
				$spnDep = 1;
				if($chart['detailAs'] == '2') {
					$spnRoom = count($showIds)-(count($perDayIds)-count(array_diff($perDayIds, $showIds)));
					$spnSO = count($stayOverIds)-(count($perDayIds)-count(array_diff($perDayIds, $stayOverIds)));
					$spnDep = count($departIds)-(count($perDayIds)-count(array_diff($perDayIds, $departIds)));
				}
				$rows .= '<tr>';
				$rows .= '<td colspan="'.$spnRoom.'" class="bt">'.$combination.'</td>';
				if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
					$rows .= '<td colspan="'.$spnSO.'" class="bt bl">Stay Over</td>';
				}
				if(count($departIds)>0) {
					$rows .= '<td colspan="'.$spnDep.'" class="bt bl">Depart</td>';
				}
				$rows .= '</tr>';
				
			}
			if($chart['detailAs'] == '2') {
				$row1 = '<tr style="background-color: #f6f6f6;">';
				$row2 = '<tr style="background-color: #f6f6f6;">';
				if($chart['sep_asd'] == '2') {
					if(count($showIds)>0) {
						$dataHeader = createDetailHeaderRow($chartSections, $showIds, $perDayIds);
						$row1 .= $dataHeader[1];
						$row2 .= $dataHeader[2];
					}
					
					if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
						$dataHeader = createDetailHeaderRow($chartSections, $stayOverIds, $perDayIds);
						$row1 .= $dataHeader[1];
						$row2 .= $dataHeader[2];
					}
					if(count($departIds)>0) {
						$dataHeader = createDetailHeaderRow($chartSections, $departIds, $perDayIds);
						$row1 .= $dataHeader[1];
						$row2 .= $dataHeader[2];
					}
								
				} else {
					$dataHeader = createDetailHeaderRow($chartSections, $combinedIds, $perDayIds);
					$row1 .= $dataHeader[1];
					$row2 .= $dataHeader[2];
				}
				$row1 .= '</tr>';
				$row2 .= '</tr>';
				$rows .= $row1.$row2;
			}
			
			$rows .= '</table></td>';

			if($colcount == count($chart['columns'])) {
				if(count($chartIds['perDay'])>0) {
					$rows .= '<td class="' . $bg_style . ' bt bl" style="width:200px;">Details</td>';
				}
			}
			$colcount++;
		}
		$rows .= '</tr>';

	} else {
		// Dates along top
		$rows .= '<tr valign="top">
					<td>&nbsp;</td>';
		if($chart['sep_asd'] == '1') {
			$rows .= '<td>&nbsp;</td>';
		}
		if($chart['detailAs'] == '1') {
				$rows .= '<td class="colLtDk bt bl" valign="top">Details</td>';
		}

		foreach ( $chart['columns'] as $col ) {
			$rows .= '<td class="colLt bt bl">
						<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidth.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">';
						
			if($chart['sep_asd'] == '2') {
				if($chart['detailAs'] == '2') {
					if(count($showIds)>0) {
						$rows .= createCols($showIds, $chartSections, 2, $perDayIds);
					}
					if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
						$rows .= createCols($stayOverIds, $chartSections, 2, $perDayIds);
					}
					if(count($departIds)>0) {
						$rows .= createCols($departIds, $chartSections, 2, $perDayIds);
					}
					
				} else {
					if(count($showIds)>0) {
						$rows .= '<col style="width:200px;" />';
					}
					if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
						$rows .= '<col style="width:200px;" />';
					}
					if(count($departIds)>0) {
						$rows .= '<col style="width:200px;" />';
					}
				}
			} else {
				if($chart['detailAs'] == '2') {
					$rows .= createCols($combinedIds, $chartSections, 2, $perDayIds);
				} else {
					$rows .= '<col style="width:200px;" />';
				}
			}

			$rows .= '<tr>
						<td colspan='.$colspnVal.'>';
			$thisDate = explode("-",$col['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
			$displayDate .= ' ' . $col['name'];

			if ( $showDatePAX == "1" ) {
				$displayDate .= '<br />PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
			}
						
			$rows .= $displayDate .'</td></tr>';
			if($chart['sep_asd'] == '2') {
				$spnRoom = 1;
				$spnSO = 1;
				$spnDep = 1;
				if($chart['detailAs'] == '2') {
					$spnRoom = count($showIds)-(count($perDayIds)-count(array_diff($perDayIds, $showIds)));
					$spnSO = count($stayOverIds)-(count($perDayIds)-count(array_diff($perDayIds, $stayOverIds)));
					$spnDep = count($departIds)-(count($perDayIds)-count(array_diff($perDayIds, $departIds)));
				}
				$rows .= '<tr>';
				if(count($showIds)>0) {
					$rows .= '<td colspan="'.$spnRoom.'" class="bt">'.$combination.'</td>';
				}
				if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
					$rows .= '<td colspan="'.$spnSO.'" class="bt bl">Stay Over</td>';
				}			
				if(count($departIds)>0) {
					$rows .= '<td colspan="'.$spnDep.'" class="bt bl">Depart</td>';
				}
				$rows .= '</tr>';
				
			}
			if($chart['detailAs'] == '2') {
				$row1 = '<tr style="background-color: #f6f6f6">';
				$row2 = '<tr style="background-color: #f6f6f6">';
				if($chart['sep_asd'] == '2') {
					if(count($showIds)>0) {
						$dataHeader = createDetailHeaderRow($chartSections, $showIds, $perDayIds);
						$row1 .= $dataHeader[1];
						$row2 .= $dataHeader[2];
					}
					
					if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
						$dataHeader = createDetailHeaderRow($chartSections, $stayOverIds, $perDayIds);
						$row1 .= $dataHeader[1];
						$row2 .= $dataHeader[2];
					}
					
					if(count($departIds)>0) {
						$dataHeader = createDetailHeaderRow($chartSections, $departIds, $perDayIds);
						$row1 .= $dataHeader[1];
						$row2 .= $dataHeader[2];
					}
					
				} else {
					$dataHeader = createDetailHeaderRow($chartSections, $combinedIds, $perDayIds);
					$row1 .= $dataHeader[1];
					$row2 .= $dataHeader[2];
				}
				
				$row1 .= '</tr>';
				$row2 .= '</tr>';
				$rows .= $row1.$row2;
			}
			$rows .= '</table></td>';
		}
		$rows .= '</tr>';
	}

	$showDepartureInfo = true;
	$modcount = 0;

	if ( $chart['direction'] == "2" ) {
		$property_name = "";
		$anotherCount = 0;
		$firstProperty = 1;
		$rowcounter = 1;
		$rowIdsArr = array();
	}

	foreach ( $chart['rows'] as $row ) {
		$roomInfoExists = false;
		$stayOverInfoExists = false;
		$departInfoExists = false;
		
		if ( $chart['direction'] == '1' ) {
			$thisDate	= explode("-",$row['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		}

		if ( $modcount%2 == 0 ) {
			$colourBand = 'colLtt';
		} else {
			$colourBand = 'colLt';
		}
		
		foreach ( $chart['columns'] as $col ) {
			$c = isset($chart['room'][$row['id']][$col['id']]) ? $chart['room'][$row['id']][$col['id']] : array();
			if ( is_array($c) && count($c) > 0  ) {
				foreach ( $c as $blah ) {
					if ( isset($blah['value']) && $blah['value'] != "" ) {
						$roomInfoExists = true;
					}
				}
			}
		}

		// [START] Room information row -------------------------------------------
		if ( count($showIds) > 0 && ($roomInfoExists || $showEmptyRooms == 1)) {
			if ( $chart['direction'] == "1" ) {
				if ( $showDatePAX == "1" ) {
					$paxCount = '<br>PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
				} else {
					$paxCount = '';
				}

				$rows .= '<tr style="height:35px; height:100% !important;" >';
				$rows .= '<td valign="top" class="' . $colourBand . ' bl bt" >' . $displayDate . ' ' 
							. t_encodeHTML($row['name']) . $paxCount. '</td>
						 ';
				if($chart['sep_asd'] == '1') {
					$rows .= '<td valign="top" class="' . $colourBand . ' bl bt" >'. $combination . '</td>';
				}
				
				if($chart['detailAs'] == '1') {
					$rows .= '<td valign="top" class="colLtDk bl bt">
					<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
				}
				
			} else {
				if ( $property_name != $row['property'] ) {
					if($firstProperty != 1) {
						if(count($chartIds['perDay'])>0) {
							$rows .= cretaePerDayDetailsRows($chart, 'room', $rowIdsArr, $chartIds, $chartSections);
						}
						$rowIdsArr = array();
					}
					$firstProperty = 0;
					$property_name = $row['property'];
					
					if ( $anotherCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}

					$anotherCount++;

					$cnt = 1;
					if($chart['sep_asd'] == '1') {
						$cnt++;
					}
					if($chart['detailAs'] == '1') {
						$cnt++;
					}
					
					$propName = t_encodeHTML($row['property']);
					if($row['room'] == "overbooking") {
						$propName = "";
					}
					
					$rows .= '
						<tr' . $rowClass . ' style="height:25px; line-height:25px;">
							<td colspan="' . ($numTH + $cnt) . '" valign="top" class="' . $bg_style . ' bt bl bb br"><strong>' . $propName . '</strong></td>
						</tr>
					';
					
					$modcount = 1;
					
				}

				if ( $modcount%2 == 0 ) {
					$colourBand = 'colDkDk';
				} else {
					$colourBand = $bg_style;
				}
				
				if($row['room'] == "overbooking") {
					$roomInfo = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($row['property'])."<br>Accommodation:" .t_encodeOverlib($row['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
					$tdStyle = "style='font-size: 12px;font-weight: bold;'";
				} else {
					if ( $hideAccommType == "1" ) {
						$roomInfo = "";
					} else {
						$roomInfo = t_encodeHTML($row['accommodation']);
					}					
					if ( $showUnitLabel == "1" ) {
						$roomInfo .= ' ' . t_encodeHTML($row['unit_label']);
					}
					if ( $showUnitNumber == "1" ) {
						$roomInfo .= ' ' . t_encodeHTML($row['room']);
					}
					$tdStyle = "";
				}

				$rows .= '<tr' . $rowClass . '>';
				$rows .= '<td valign="top" class="' . $colourBand . ' bl bt" '.$tdStyle.'>';
				
				$rows .= $roomInfo."</td>";

				if($chart['sep_asd'] == '1') {
					$rows .= '<td valign="top" class="' . $colourBand . ' bl bt">'.$combination.'</td>';
				}
				if($chart['detailAs'] == '1') {
				$rows .= '<td valign="top" class="colLtDk bl bt">
						<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
				}
				
			}
			
			if($chart['detailAs'] == '1') {
				// [START] Room data headings ----------------------------------------------
				if($chart['sep_asd'] == '2') {
					$rowSpans = getCommonRowSpan($chart,$combinedIds, $row['id']);
				} else {
					$rowSpan = getRowSpans($chart,'room',$showIds);
					$rowSpans = $rowSpan[$row['id']];
				}
				$totalSubCell = array_sum($rowSpans);
				$rows .= createHeaderDetailAsRow($showIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
				
				$rows .= '</table></td>';
				// [ END ] Room data headings ----------------------------------------------
			}
			
			// [START] Room information ------------------------------------------------
			$firstProp = 1;
			$colcount = 1;
			$prop = '';
			$colIds = array();
			foreach ( $chart['columns'] as $kId=>$col ) {
				$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

				$initialColour = "#fff";
				$initialFontColour = "#000";
				if ( $b != "" ) {
					$initialColour = "#c0c0c0";
				}
				
				if(isset($col['room']) && $col['room'] == "overbooking") {
					$initialColour = "#db4242";
				}
				
				if($chart['direction'] == "1") {
					if ( $prop != $col['property'] ) {
						if($firstProp != 1) {
							if(count($chartIds['perDay'])>0) {
								$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . ';">'; 
								$rows .= cretaePerDayDetails($chart,'room', $row['id'], $colIds, $chartIds, $chartSections);
								$rows .= '</td>';
							}
							$colIds = array();
						}
						$prop = $col['property'];
						$firstProp = 0;
					}
				}

				$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . '; ">'; 
				$rows .= createInnerRoomDetails($chart,'room', $row['id'], $col['id'], $chartIds, $chartSections);
				$rows .= '</td>';

				if($chart['direction'] == "1") {
					if($colcount == count($chart['columns'])) {
						array_push($colIds, $col['id']);
						if(count($chartIds['perDay'])>0) {
							$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . ';">'; 
							$rows .= cretaePerDayDetails($chart,'room', $row['id'], $colIds, $chartIds, $chartSections);
							$rows .= '</td>';
						}
						$colIds = array();
					} else {
						array_push($colIds, $col['id']);
					}
					$colcount++;
					
				}
			}
			// [ END ] Room information -----------------------------------------------
			$rows .= '</tr>';
			$bool_room = true;
			$top_line_style = 'border-top: 1px dashed #ccc;';

		} else {
			$bool_room = false;
			$top_line_style = 'border-top: 1px solid #000;';
		}
		
		if($chart['sep_asd'] == '1' || ($bool_room == false && $stayOverInfoExists == false && $departInfoExists == false)) {
			$bool_stayOver = false;
			if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
				// [START] Stay Over information row -------------------------------------------
				foreach ( $chart['columns'] as $col ) {
					$d = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : array();
					if ( is_array($d) && count($d) > 0  ) {
						foreach ( $d as $blah ) {
							if ( isset($blah['value']) && $blah['value'] != "" ) {
								$stayOverInfoExists = true;
							}
						}
					}
				}
				
				if ( count($stayOverIds) > 0 && $stayOverInfoExists) {
					if ( $chart['direction'] == "1" ) {
						$rows .= '<tr  style="height:35px; height:100% !important;">';
						if($bool_room == false){
							if ( $showDatePAX == "1" ) {
								$paxCount = '<br>PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
							} else {
								$paxCount = '';
							}
							$rows .= '
								<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '">' . $displayDate . ' ' . t_encodeHTML($row['name']) .$paxCount. '</td>';
						} else {
							$rows .= '<td valign="top" class="'.$colourBand.' bl">&nbsp;</td>';
						}
						if($chart['sep_asd'] == '1') {
							$rows .= '<td valign="top" class="' . $colourBand . ' bl" style="'. $top_line_style . '"> Stay Over</td>';
						}
						
						if($chart['detailAs'] == '1') {
							$rows .= '<td valign="top" class="colLtDk bl" style="' . $top_line_style . '">
								  <table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
						}
					} else {
						if ( $property_name != $row['property'] ) {
							if($firstProperty != 1) {
								if(count($chartIds['perDay'])>0) {
									$rows .= cretaePerDayDetailsRows($chart,'stayOver', $rowIdsArr, $chartIds, $chartSections);
									$rowIdsArr = array();
								}
							}
							$firstProperty = 0;
							$pre_rowId = $row['id'];
							$property_name = $row['property'];
							if ( $anotherCount%2 == 0 ) {
								$bg_style = "colLtt";
							} else {
								$bg_style = "colLt";
							}

							$cnt = 1;
							if($chart['sep_asd'] == '1') {
								$cnt++;
							}
							if($chart['detailAs'] == '1') {
								$cnt++;
							}

							$anotherCount++;
							
							$rows .= '<tr' . $rowClass . ' style="height:25px; line-height: 25px;">
										<td colspan="' . ($numTH + $cnt) . '" valign="top" class="'. $bg_style .' bt bl">
										<strong>' . t_encodeHTML($row['property']) . '</strong></td>
									 </tr>
									';
							
							$modcount = 1;
						}

						if ( $modcount%2 == 0 ) {
							$colourBand = 'colDkDk';
						} else {
							$colourBand = $bg_style;
						}

						
						$rows .= '<tr' . $rowClass . ' style="height:35px; height:100% !important;">';
						if($bool_room == false){
							if ( $hideAccommType == "1" ) {
								$roomInfo = "";
							} else {
								$roomInfo = t_encodeHTML($row['accommodation']);
							}							
							if ( $showUnitLabel == "1" ) {
								$roomInfo .= '&nbsp;' . t_encodeHTML($row['unit_label']);
							}
							if ( $showUnitNumber == "1" ) {
								$roomInfo .= '&nbsp;' . t_encodeHTML($row['room']);
							}
							$rows .= '<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style.
									'">'. $roomInfo. '</td>';
								
						} else {
							$rows .= '<td valign="top" class="' . $colourBand . ' bl" >&nbsp;</td>';
						}
						if($chart['sep_asd'] == '1') {
							$rows .= '<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '"> Stay Over</td>';
						}
						if($chart['detailAs'] == '1') {
							$rows .= '<td valign="top" class="colLtDk bl" style="' . $top_line_style . '">
								 <table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
						}
					}

					if($chart['detailAs'] == '1') {
						// [START] Stay Over data headings ----------------------------------------------
						$rowSpan = getRowSpans($chart,'stayOver',$stayOverIds);
						$rowSpans = $rowSpan[$row['id']];
						$totalSubCell = array_sum($rowSpans);
						$rows .= createHeaderDetailAsRow($stayOverIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
						$rows .= '</table></td>';
						// [ END ] Stay Over data headings ----------------------------------------------
					}
					
					// [START] Stay Over information ------------------------------------------------
					$prop = '';
					$firstProp = 1;
					$colcount = 1;
					$colIds = array();
					foreach ( $chart['columns'] as $col ) {
						$c = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : "";
						$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

						$initialColour = "#fff";
						$initialFontColour = "#000";
						if ( $b != "" ) {
							$initialColour = "#c0c0c0";
						}

						if($chart['direction'] == "1") {
							if ( $prop != $col['property'] ) {
								if($firstProp != 1) {
									if(count($chartIds['perDay'])>0) {
										$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . ';">'; 
										$rows .= cretaePerDayDetails($chart,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
										$rows .= '</td>';
									}
									$colIds = array();
								}
								$prop = $col['property'];
								$firstProp = 0;
							}
							if(!empty($chart['stayOver'][$row['id']][$col['id']])) {
								$columnId = $col['id'];
							}
						}
						
						$rows .= '
								<td valign="top" class="bl" style="background-color: ' . $initialColour . ';' . $top_line_style . '">'; 
						$rows .= createInnerRoomDetails($chart,'stayOver', $row['id'], $col['id'], $chartIds, $chartSections);

						$rows .= '</td>';

						if($chart['direction'] == "1") {
							if($colcount == count($chart['columns'])) {
								array_push($colIds, $col['id']);
								if(count($chartIds['perDay'])>0) {
									$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . ';">'; 
									$rows .= cretaePerDayDetails($chart,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
									$rows .= '</td>';
								}
								$colIds = array();
							} else {
								array_push($colIds, $col['id']);
							}
							$colcount++;
						}
					}
					// [ END ] Stay Over information -----------------------------------------------
					$rows .= '</tr>';
					$bool_stayOver = true;
					$top_line_style = 'border-top: 1px dashed #ccc;';

				} else {
					$bool_stayOver = false;
					$top_line_style = 'border-top: 1px solid #000;';
				}
			}
		

		/* Here we look at each row and try to determine if there is any departure information in any of the row's columns. If not, then we don't display the departure row */
		foreach ( $chart['columns'] as $col ) {
			$d = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
			if ( is_array($d) && count($d) > 0  ) {
				foreach ( $d as $blah ) {
					if ( isset($blah['value']) && $blah['value'] != "" ) {
						$departInfoExists = true;
					}
				}
			}
		}
		
		if ( count($departIds) > 0 && $departInfoExists && $showDepartureInfo ) {
			if($chart['sep_asd'] == '1' || ($chart['sep_asd'] == '2' && $bool_room == false && $stayOverInfoExists == false)){
			// [START] Departure information row --------------------------------------
			if ( $chart['direction'] == '1' ) {
				$rows .= '<tr' . (isset($rowClass) ? $rowClass : "") . '  style="height:35px; height:100% !important;">';
				if($bool_room == false && $stayOverInfoExists == false){
					$rows .= '
						<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '">' . $displayDate . ' ' . t_encodeHTML($row['name']) . '</td>';
				} else {
					$rows .= '
						<td valign="top" class="' . $colourBand .' bl">&nbsp;</td>';
				} 

				if($chart['sep_asd'] == '1') {
					$rows .= '<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style
							 . '">Depart</td>';
				}
					
				if($chart['detailAs'] == '1') {
					$rows .='<td valign="top" class="colLtDk bl" style="' . $top_line_style . '">
							 <table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
				}

			} else {
				if ( $property_name != $row['property'] ) {
					if($firstProperty != 1) {
						if(count($chartIds['perDay'])>0) {
							$rows .= cretaePerDayDetailsRows($chart,'depart', $rowIdsArr, $chartIds, $chartSections);
							$rowIdsArr = array();
						}
					}
					$firstProperty = 0;
					$pre_rowId = $row['id'];
					$property_name = $row['property'];
					if ( $anotherCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}

					$cnt = 1;
					if($chart['sep_asd'] == '1') {
						$cnt++;
					}
					if($chart['detailAs'] == '1') {
						$cnt++;
					}

					$anotherCount++;
					$rows .= '
						<tr' . $rowClass . ' style="height:25px; line-height:25px;">
							<td colspan="' . ($numTH + $cnt) . '" valign="top" class="' . $bg_style . ' bt bl"><strong>' . t_encodeHTML($row['property']) . '</strong></td>
						</tr>
					';

					$modcount = 1;
				}

				if ( $modcount%2 == 0 ) {
					$colourBand = 'colDkDk';
				} else {
					$colourBand = $bg_style;
				}

				if ( $hideAccommType == "1" ) {
					$roomInfo = "";
				} else {
					$roomInfo = t_encodeHTML($row['accommodation']);
				}						
				if ( $showUnitLabel == "1" ) {
					$roomInfo .= '&nbsp;' . (isset($row['unit_label']) ? t_encodeHTML($row['unit_label']) : "");
				}
				if ( $showUnitNumber == "1" ) {
					$roomInfo .= '&nbsp;' . (isset($row['room']) ? t_encodeHTML($row['room']) : "");
				}
				
				$rows .= '<tr' . (isset($rowClass) ? $rowClass : "") . '  style="height:35px; height:100% !important;">';
				if($bool_room == false && $stayOverInfoExists == false){
						$rows .= '<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '">	' . $roomInfo . '</td>
						';
				} else {
					$rows .= '<td valign="top" class="' . $colourBand . ' bl" >	&nbsp;</td>';
				}

				if($chart['sep_asd'] == '1') {
					$rows .= '<td valign="top" class="' . $colourBand . ' bl" style="' . $top_line_style . '">Depart</td>';
				}
						
				if($chart['detailAs'] == '1') {
					$rows .= '<td valign="top" class="colLtDk bl" style="' . $top_line_style . '">
								<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">';
				}
			}
			
			if($chart['detailAs'] == '1') {
				// [START] Departure section headings -------------------------------------
				$rowSpan = getRowSpans($chart,'depart',$departIds);
				$rowSpans = $rowSpan[$row['id']];
				$totalSubCell = array_sum($rowSpans);
				$rows .= createHeaderDetailAsRow($departIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
				$rows .= '</table></td>';
				// [ END ] Departure section headings -------------------------------------
			}

			// [START] Departure information ------------------------------------------	
			$prop = '';
			$firstProp = 1;
			$colcount = 1;
			$colIds = array();
			foreach ( $chart['columns'] as $col ) {
				$c = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : "";
				$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

				$initialColour = "#fff";
				$initialFontColour = "#000";
				if ( $b != "" ) {
					$initialColour = "#c0c0c0";
				}

				if($chart['direction'] == "1") {
					if ( $prop != $col['property'] ) {
						if($firstProp != 1) {
							if(count($chartIds['perDay'])>0) {
								$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . ';">'; 
								$rows .= cretaePerDayDetails($chart,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
								$rows .= '</td>';
							}
							$colIds = array();
						}
						$prop = $col['property'];
						$firstProp = 0;
					}
					if(!empty($chart['depart'][$row['id']][$col['id']])) {
						$columnId = $col['id'];
					}
				}

				$rows .= '
						<td valign="top" class="bl" style="background-color: ' . $initialColour . ';' . $top_line_style .'">'; 
				$rows .= createInnerRoomDetails($chart,'depart', $row['id'], $col['id'], $chartIds, $chartSections);
				$rows .= '</td>';

				if($chart['direction'] == "1") {
					if($colcount == count($chart['columns'])) {
						array_push($colIds, $col['id']);
						if(count($chartIds['perDay'])>0) {
							$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . '; ">'; 
							$rows .= cretaePerDayDetails($chart,'depart', $row['id'], $colIds, $chartIds, $chartSections);
							$rows .= '</td>';
						}
						$colIds = array();
					} else {
						array_push($colIds, $col['id']);
					}
					$colcount++;
				}
			}
			$rows .= '</tr>';
			$bool_depart = true;
			$top_line_style = 'border-top: 1px dashed #ccc;';
		}
		} else {
			$bool_depart = false;
			$top_line_style = 'border-top: 1px solid #000;';
		}
	}
	
	if($roomInfoExists || $stayOverInfoExists || $departInfoExists) {
		$modcount++;
	}
	
	if($chart['direction'] == "2") {
		if($rowcounter == count($chart['rows'])) {
			array_push($rowIdsArr, $row['id']);
			if(count($chartIds['perDay'])>0) {
				$rows .= cretaePerDayDetailsRows($chart,'room', $rowIdsArr, $chartIds, $chartSections);
				$rowIdsArr = array();
			}
		} else {
			array_push($rowIdsArr, $row['id']);
		}
		$rowcounter++;
	}
	
	}
	return $rows;
}

function generateChartAsTables($chartSections,$chartIds,$chart,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$autoRoom, $showCatExtras,$showEmptyRooms) {
	$showIds	 = $chartIds['room'];
	$colourIds	 = $chartIds['colour'];
	$departIds	 = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds   = $chartIds['perDay'];
	$combinedIds = $chartIds['combined'];
	
	$propRoomsArr = array();
	
	if($chart['combArrSty'] == '1') {
		$combination = "Inhouse";
	} else {
		$combination = "Arrival";
	}
	
	$tableExtraWidth = 150;
	$totalRows = 0;
	$extraRows = 1;
	$rows = "";
	$anotherCount = 0;
	$modcount = 0;
	$rowClass = "";
	
	if($chart['detailAs'] == '1') {
		$tableExtraWidth +=150;
		$extraRows++;
	}
		
	$totalWidthRoom = 0;
	$totalWidthSO = 0;
	$totalWidthDepart = 0;
	if($chart['detailAs'] == '2') {
		$numDetColsRoom = count($showIds)-count($perDayIds);
		foreach ( $showIds as $showId ) {
			if(in_array($showId, $perDayIds)) {
				continue;
			}
			$totalWidthRoom += getHeaderAtr($chartSections, $showId, 'width');
			$totalRows++;
		}

		$numDetColsSO = count($stayOverIds)-count($perDayIds);
		foreach ( $stayOverIds as $showId ) {
			if(in_array($showId, $perDayIds)) {
				continue;
			}
			$totalWidthSO += getHeaderAtr($chartSections, $showId, 'width');
		}

		$numDetColsDepart = count($departIds)-count($perDayIds);
		foreach ( $departIds as $departId ) {
			if(in_array($departId, $perDayIds)) {
				continue;
			}
			$totalWidthDepart += getHeaderAtr($chartSections, $departId, 'width');
		}
		
	} else {
		$totalWidthRoom = 200;
		$totalWidthSO = 200;
		$totalWidthDepart = 200;
		$totalRows++;
	}

	$colspnRoom			= (isset($numDetColsRoom) && $numDetColsRoom>1)?$numDetColsRoom:1;
	$colspnSO			= (isset($numDetColsSO) && $numDetColsSO>1)?$numDetColsSO:1;
	$colspnDepart		= (isset($numDetColsDepart) && $numDetColsDepart>1)?$numDetColsDepart:1;

	$totalWidthRoom		= ($totalWidthRoom>0)?$totalWidthRoom:200;
	$totalWidthSO		= ($totalWidthSO>0)?$totalWidthSO:200;
	$totalWidthDepart	= ($totalWidthDepart>0)?$totalWidthDepart:200;

	$totalWidth = max($totalWidthRoom, $totalWidthSO, $totalWidthDepart);
	$numTH = count($chart['columns']);
	if($chart['direction'] == "1") {
		foreach ( $chart['columns'] as $col ) {
			if (isset($propRoomsArr[$col['property']])) {
				$propRoomsArr[$col['property']] += 1;
			} else {
				$propRoomsArr[$col['property']] = 1;
			}
		}

		if(count($chartIds['perDay'])>0) {
			$tableExtraWidth = $tableExtraWidth + 300;
			$extraRows++;
		}
	} 
	
	$GLOBALS['temp']['totalRows'] = $extraRows + ($totalRows*$numTH);
	$rows .= '<tr style="height:25px;"><td valign="top">';
	
	if ( $chart['direction'] == "1" ) {
		$property_name = '';
		$modCount = 0;
		$firstProp = 1;
		$colcount = 1;
		$bg_style = "colLt";
		
		foreach ( $chart['columns'] as $col) {
			if ( $property_name != $col['property']  && $col['room'] != "overbooking") {
				if($firstProp != 1) {
					$rows .= '<br><br>';
				}
				$property_name = $col['property'];
				$firstProp = 0;
				$propColspan = $propRoomsArr[$col['property']]+$extraRows;
				$roomInfoExists = false;
				foreach ( $chart['rows'] as $row ) {
					foreach ( $chart['columns'] as $col ) {
						if ( $property_name == $col['property'] ) {
							$c = isset($chart['room'][$row['id']][$col['id']]) ? $chart['room'][$row['id']][$col['id']] : array();
							if ( is_array($c) && count($c) > 0  ) {
								foreach ( $c as $blah ) {
									if ( isset($blah['value']) && $blah['value'] != "" ) {
										$roomInfoExists= true;
									}
								}
							}
						}
					}
				}
				if(count($showIds) > 0 && $roomInfoExists) {
					$colCount = 0;
					foreach($propRoomsArr as $count) {
						$colCount += $count;
					}
					$tWidth = $tableExtraWidth + $colCount * $totalWidth;
					$rows .= '<table style="table-layout:fixed; border-collapse:collapse;width:'. $tWidth.'px" cellpadding="1" cellspacing="0" summary="" class="bb br">';
					$rows .= '<col style="width:150px;" />';
					if($chart['detailAs'] == '1') {
						$rows .= '<col style="width:150px;" />';
					}
					
					for($i=0; $i<$propRoomsArr[$col['property']]; $i++) {
						$rows .= '<col  style="width:'.$totalWidth.'px;" />';
					}
					if(count($chartIds['perDay'])>0) {
						$rows .= '<col  style="width:300px;" />';
					}

					if ( $modCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}
					$modCount++;
					$rows .= '<tr style="height:25px;">';
					$rows .= '<td class="' . $bg_style . ' bAll txtb" colspan="'.$propColspan.'">' . $property_name . '</td>';
					
					$rows .= '
						</tr>
						<tr style="height:10px;">
							<td colspan="'.$propColspan.'">&nbsp;</td>
						</tr>
						<tr style="height:25px;">
							<td class="' . $bg_style . ' bAll txtb" colspan="'.$propColspan.'">' . $combination . '</td>
						</tr>
						<tr style="height:10px;">
							<td colspan="'.$propColspan.'">&nbsp;</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
					';
					if($chart['detailAs'] == '1') {
						$rows .= '<td class="colLtDk bAll">Details</td>';
					}
					
					$colcount = 1;
					foreach ( $chart['columns'] as $col ) {
						if ( $property_name == $col['property'] ) {
							if ( $modCount%2 == 0 ) {
								$bg_style = "colLtt";
							} else {
								$bg_style = "colLt";
							}
							$modCount++;
							
							$rows .= '
								<td class="' . $bg_style . ' bAll">
								<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidthRoom.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">
							';
							
							if($chart['detailAs'] == '2') {
								$rows .= createCols($showIds, $chartSections, 2, $perDayIds);
								
							} else {
								$rows .= '<col style="width:200px;" />';
							}
							
							if($col['room'] == "overbooking") {
								$roomName = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($col['property'])."<br>Accommodation:" .t_encodeOverlib($col['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
								$tdStyle = "style='font-size: 12px;font-weight: bold;'";
							} else {
								if ( $hideAccommType == "1" ) {
									$roomName = "";
								} else {
									$roomName = t_encodeHTML($col['accommodation']);
								}									
								if ( $showUnitLabel == "1" ) {
									$roomName .= ' ' . t_encodeHTML($col['unit_label']);
								}
								if ( $showUnitNumber == "1" ) {
									$roomName .= ' ' . t_encodeHTML($col['room']);
								}
								$tdStyle = "";
							}
							$rows .= '<tr><td colspan='.$colspnRoom.' '.$tdStyle.'>';
							$rows .= $roomName .'</td></tr>';
						
							if($chart['detailAs'] == '2') {
								$row1 = '<tr style="background-color: #f6f6f6;">';
								$row2 = '<tr style="background-color: #f6f6f6;">';
								$dataHeader = createDetailHeaderRow($chartSections, $showIds, $perDayIds);
								$row1 .= $dataHeader[1];
								$row2 .= $dataHeader[2];
								
								$row1 .= '</tr>';
								$row2 .= '</tr>';
								$rows .= $row1.$row2;
							}
						
							$rows .= '</table></td>';
						
							if($colcount == $propRoomsArr[$col['property']]) {
								if(count($chartIds['perDay'])>0) {
									$rows .= '<td class="' . $bg_style . ' bAll" style="width:200px;">Details</td>';
								}
							}
							$colcount++;
						}
					}
					
					$rows .= '</tr>';
					
					$modcount = 0;
					
					foreach ( $chart['rows'] as $row ) {
						$dayRoomInfoExists = false;
						$thisDate	= explode("-",$row['id']);
						$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
						
						if ( $modcount%2 == 0 ) {
							$colourBand = 'colLtt';
						} else {
							$colourBand = 'colLt';
						}
						
						foreach ( $chart['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								$c = isset($chart['room'][$row['id']][$col['id']]) ? $chart['room'][$row['id']][$col['id']] : array();
								if ( is_array($c) && count($c) > 0  ) {
									foreach ( $c as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$dayRoomInfoExists= true;
										}
									}
								}
							}
						}
						
						// [START] Room information row -------------------------------------------
						if ($dayRoomInfoExists || $showEmptyRooms == 1) {
							if ( $showDatePAX == "1" ) {
								$paxCount = '<br>PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
							} else {
								$paxCount = '';
							}
							
							$rows .= '
								<tr style="height:35px; height:100% !important;" >
									<td valign="top" class="' . $colourBand . ' bAll" >' . $displayDate . ' ' . t_encodeHTML($row['name']) . $paxCount. '</td>
							';
							if($chart['detailAs'] == '1') {
								$rows .= '<td valign="top" class="colLtDk bAll">
								<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
							}
												
							if($chart['detailAs'] == '1') {
								// [START] Room data headings ----------------------------------------------
								$rowSpan = getRowSpans($chart,'room',$showIds);
								$rowSpans = $rowSpan[$row['id']];
								$totalSubCell = array_sum($rowSpans);
								$rows .= createHeaderDetailAsRow($showIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
								
								$rows .= '</table></td>';
								// [ END ] Room data headings ----------------------------------------------
							}
							
							// [START] Room information ------------------------------------------------
							$colcount = 1;
							$prop = '';
							$colIds = array();
							foreach ( $chart['columns'] as $kId=>$col ) {
								if ( $property_name == $col['property'] ) {
									$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

									$initialColour = "#fff";
									$initialFontColour = "#000";
									if ( $b != "" ) {
										$initialColour = "#c0c0c0";
									}
									
									if($col['room'] == "overbooking") {
										$initialColour = "#db4242";
									}
								
									if ( $prop != $col['property'] ) {
										$prop = $col['property'];
										$firstProp = 0;
									}
									
									$rows .= '<td valign="top" class="bAll" style="background-color: ' . $initialColour . '; ">'; 
									$rows .= createInnerRoomDetails($chart,'room', $row['id'], $col['id'], $chartIds, $chartSections);
									$rows .= '</td>';

									if($colcount == $propRoomsArr[$col['property']]) {
										array_push($colIds, $col['id']);
										if(count($chartIds['perDay'])>0) {
											$rows .= '<td valign="top" class="bAll">'; 
											$rows .= cretaePerDayDetails($chart,'room', $row['id'], $colIds, $chartIds, $chartSections);
											$rows .= '</td>';
										}
										$colIds = array();
									} else {
										array_push($colIds, $col['id']);
									}
									$colcount++;
								}
							}
							// [ END ] Room information -----------------------------------------------
							$rows .= '</tr>';
							$bool_room = true;
												
						} else {
							$bool_room = false;
						}
						
						if($roomInfoExists) {
							$modcount++;
						}
					}
					$rows .= '</table>';
					$rows .= '<br>';
				}
				
				$modcount = 0;
				$bool_stayOver = false;
				$stayOverInfoExists = false;
				if (isset($chart['rows']) && isset($chart['columns'])) {
					foreach ( $chart['rows'] as $row ) {
						foreach ( $chart['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								$d = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : array();
								if ( is_array($d) && count($d) > 0  ) {
									foreach ( $d as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$stayOverInfoExists = true;
										}
									}
								}
							}
						}
					}
				}
				if($chart['combArrSty'] == '2' && count($stayOverIds)>0 && $stayOverInfoExists) {
					$tWidth = $tableExtraWidth + $propRoomsArr[$property_name] * $totalWidthSO;
					$rows .= '<table style="table-layout:fixed; border-collapse:collapse;width:'. $tWidth.'px;" cellpadding="1" cellspacing="0" summary="" class="bb br">';
					$rows .= '<col style="width:150px;" />';
					if($chart['detailAs'] == '1') {
						$rows .= '<col style="width:150px;" />';
					}
					
					for($i=0; $i<$propRoomsArr[$property_name]; $i++) {
						$rows .= '<col style="width:'.$totalWidthSO.'px;" />';
					}

					if(count($chartIds['perDay'])>0) {
						$rows .= '<col  style="width:300px;" />';
					}
														
					if ( $modCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}
					$modCount++;
					$firstProp = 0;
					if(!$roomInfoExists) {
						$rows .= '<tr style="height:25px;">';
						$rows .= '<td class="' . $bg_style . ' bAll txtb" colspan="'.$propColspan.'">' . $property_name . '</td>';
						
						$rows .= '
							</tr>
							<tr style="height:10px;">
								<td colspan="'.$propColspan.'">&nbsp;</td>
							</tr>
							';
					}
					$rows .= '
						<tr style="height:25px;">
							<td class="' . $bg_style . ' bAll txtb" colspan="'.$propColspan.'">Stay Over</td>
						</tr>
						<tr style="height:10px;">
							<td colspan="'.$propColspan.'">&nbsp;</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
					';
					
					if($chart['detailAs'] == '1') {
						$rows .= '<td class="colLtDk bt bl">Details</td>';
					}
					
					$colcount = 1;
					foreach ( $chart['columns'] as $col ) {
						if ( $property_name == $col['property'] ) {
							if ( $modCount%2 == 0 ) {
								$bg_style = "colLtt";
							} else {
								$bg_style = "colLt";
							}
							$modCount++;
													
							$rows .= '
								<td class="' . $bg_style . ' bt bl">
								<table border="0" width="'.$totalWidthSO.'" cellpadding="1" cellspacing="0" style="width:'.$totalWidthSO.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">
							';
							
							if($chart['detailAs'] == '2') {
								$rows .= createCols($stayOverIds, $chartSections, 2, $perDayIds);
								
							} else {
								$rows .= '<col style="width:200px;" />';
							}
						
							if($col['room'] == "overbooking") {
								$roomName = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($col['property'])."<br>Accommodation:" .t_encodeOverlib($col['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
								$tdStyle = "style='font-size: 12px;font-weight: bold;'";
							} else {
								if ( $hideAccommType == "1" ) {
									$roomName = "";
								} else {
									$roomName = t_encodeHTML($col['accommodation']);
								}								
								if ( $showUnitLabel == "1" ) {
									$roomName .= ' ' . t_encodeHTML($col['unit_label']);
								}
								if ( $showUnitNumber == "1" ) {
									$roomName .= ' ' . t_encodeHTML($col['room']);
								}
								$tdStyle = "";
							}
							
							$rows .= '<tr><td colspan='.$colspnSO.' '.$tdStyle.'>';
							$rows .= $roomName .'</td></tr>';
						
							if($chart['detailAs'] == '2') {
								$row1 = '<tr style="background-color: #f6f6f6;">';
								$row2 = '<tr style="background-color: #f6f6f6;">';
								$dataHeader = createDetailHeaderRow($chartSections, $stayOverIds, $perDayIds);
								$row1 .= $dataHeader[1];
								$row2 .= $dataHeader[2];
								
								$row1 .= '</tr>';
								$row2 .= '</tr>';
								$rows .= $row1.$row2;
							}
						
							$rows .= '</table></td>';
						
							if($colcount == $propRoomsArr[$property_name]) {
								if(count($chartIds['perDay'])>0) {
									$rows .= '<td class="' . $bg_style . ' bAll" style="width:200px;">Details</td>';
								}
							}
							$colcount++;
						}
					}
					
					$rows .= '</tr>';
					
					foreach ( $chart['rows'] as $row ) {
						$stayOverDayInfoExists = false;
											
						if ( $chart['direction'] == '1' ) {
							$thisDate	= explode("-",$row['id']);
							$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
						}

						if ( $modcount%2 == 0 ) {
							$colourBand = 'colLtt';
						} else {
							$colourBand = 'colLt';
						}
						
						// [START] Stay Over information row -------------------------------------------
						$bool_stayOver = false;
						foreach ( $chart['columns'] as $col ) {
							$d = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : array();
							if ( is_array($d) && count($d) > 0  ) {
								foreach ( $d as $blah ) {
									if ( isset($blah['value']) && $blah['value'] != "" ) {
										$stayOverDayInfoExists = true;
									}
								}
							}
						}
							
						if ( count($stayOverIds) > 0 && $stayOverDayInfoExists) {
							$rows .= '<tr  style="height:35px; height:100% !important;">';
							if ( $showDatePAX == "1" ) {
								$paxCount = '<br>PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
							} else {
								$paxCount = '';
							}
							$rows .= '
								<td valign="top" class="' . $colourBand . ' bAll">' . $displayDate . ' ' . t_encodeHTML($row['name']) .$paxCount. '</td>';
							
							if($chart['detailAs'] == '1') {
								$rows .= '<td valign="top" class="colLtDk bAll">
									  <table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
							}
							

							if($chart['detailAs'] == '1') {
								// [START] Stay Over data headings ----------------------------------------------
								$rowSpan = getRowSpans($chart,'stayOver',$stayOverIds);
								$rowSpans = $rowSpan[$row['id']];
								$totalSubCell = array_sum($rowSpans);
								$rows .= createHeaderDetailAsRow($stayOverIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
								$rows .= '</table></td>';
								// [ END ] Stay Over data headings ----------------------------------------------
							}
							
							// [START] Stay Over information ------------------------------------------------
							$prop = '';
							$colcount = 1;
							$colIds = array();
							foreach ( $chart['columns'] as $col ) {
								if ( $property_name == $col['property'] ) {
									$c = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : "";
									$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

									$initialColour = "#fff";
									$initialFontColour = "#000";
									if ( $b != "" ) {
										$initialColour = "#c0c0c0";
									}

									$rows .= '
											<td valign="top" class="bAll" style="background-color: ' . $initialColour . ';">'; 
									$rows .= createInnerRoomDetails($chart,'stayOver', $row['id'], $col['id'], $chartIds, $chartSections);

									$rows .= '</td>';

									if($colcount == $propRoomsArr[$property_name]) {
										array_push($colIds, $col['id']);
										if(count($chartIds['perDay'])>0) {
											$rows .= '<td valign="top" class="bAll" style="background-color: ' . $initialColour . ';">'; 
											$rows .= cretaePerDayDetails($chart,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
											$rows .= '</td>';
										}
										$colIds = array();
									} else {
										array_push($colIds, $col['id']);
									}
									$colcount++;
									
								}
							}
							// [ END ] Stay Over information -----------------------------------------------
							$rows .= '</tr>';
							$bool_stayOver = true;
						
						} else {
							$bool_stayOver = false;
						}

						if($stayOverInfoExists) {
							$modcount++;
						}
					}

					$rows .= '</table>';
					$rows .= '<br>';
				}

				$departInfoExists = false;
				if (isset($chart['rows']) && isset($chart['columns'])) {
					foreach ( $chart['rows'] as $row ) {
						foreach ( $chart['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								$d = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
								if ( is_array($d) && count($d) > 0  ) {
									foreach ( $d as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$departInfoExists = true;
										}
									}
								}
							}
						}
					}
				}
				if(count($departIds)>0 && $departInfoExists) {
					$modcount = 0;
					$showDepartureInfo = true;
					$tWidth = $tableExtraWidth + $propRoomsArr[$property_name] * $totalWidthDepart;
					$rows .= '<table style="table-layout:fixed; border-collapse:collapse;width:'.$tWidth.'px" cellpadding="1" cellspacing="0" summary="" class="br bb">';
					$rows .= '<col style="width:150px;" />';
					if($chart['detailAs'] == '1') {
						$rows .= '<col style="width:150px;" />';
					}
					
					for($i=0; $i<$propRoomsArr[$property_name]; $i++) {
						$rows .= '<col  style="width:'.$totalWidthDepart.'px;" />';
					}
					if(count($chartIds['perDay'])>0) {
						$rows .= '<col  style="width:300px;" />';
					}
					
									
					if ( $modCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}
					$modCount++;
					$firstProp = 0;
					if(!$roomInfoExists && !$stayOverInfoExists) {
						$rows .= '<tr style="height:25px;">';
						$rows .= '<td class="' . $bg_style . ' bAll" colspan="'.$propColspan.'">' . $property_name . '</td>';
						
						$rows .= '
							</tr>
							<tr style="height:10px;">
								<td colspan="'.$propColspan.'">&nbsp;</td>
							</tr>
						';
					}
					
					$rows .= '
						<tr style="height:25px;">
							<td class="' . $bg_style . ' bAll txtb" colspan="'.$propColspan.'">Depart</td>
						</tr>
						<tr style="height:10px;">
							<td colspan="'.$propColspan.'">&nbsp;</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
					';
					if($chart['detailAs'] == '1') {
						$rows .= '<td class="colLtDk bAll">Details</td>';
					}
					
					$colcount = 1;
					foreach ( $chart['columns'] as $col ) {
						if ( $property_name == $col['property'] ) {
							if ( $modCount%2 == 0 ) {
								$bg_style = "colLtt";
							} else {
								$bg_style = "colLt";
							}
							$modCount++;
							
						
							$rows .= '<td class="' . $bg_style . ' bAll">
										<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidthDepart.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">';
							
							if($chart['detailAs'] == '2') {
								$rows .= createCols($departIds, $chartSections, 2, $perDayIds);
								
							} else {
								$rows .= '<col style="width:200px;" />';
							}
						
							if($col['room'] == "overbooking") {
								$roomName = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($col['property'])."<br>Accommodation:" .t_encodeOverlib($col['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
								$tdStyle = "style='font-size: 12px;font-weight: bold;'";
							} else {
								if ( $hideAccommType == "1" ) {
									$roomName = "";
								} else {
									$roomName = t_encodeHTML($col['accommodation']);
								}									
								if ( $showUnitLabel == "1" ) {
									$roomName .= ' ' . t_encodeHTML($col['unit_label']);
								}
								if ( $showUnitNumber == "1" ) {
									$roomName .= ' ' . t_encodeHTML($col['room']);
								}
								$tdStyle = "";
							}
							$rows .= '<tr><td colspan='.$colspnDepart.' '.$tdStyle.'>';
							$rows .= $roomName .'</td></tr>';
						
							if($chart['detailAs'] == '2') {
								$row1 = '<tr style="background-color: #f6f6f6;">';
								$row2 = '<tr style="background-color: #f6f6f6;">';
								$dataHeader = createDetailHeaderRow($chartSections, $departIds, $perDayIds);
								$row1 .= $dataHeader[1];
								$row2 .= $dataHeader[2];
								
								$row1 .= '</tr>';
								$row2 .= '</tr>';
								$rows .= $row1.$row2;
							}
						
							$rows .= '</table></td>';
						
							if($colcount == $propRoomsArr[$property_name]) {
								if(count($chartIds['perDay'])>0) {
									$rows .= '<td class="' . $bg_style . ' bAll" style="width:200px;">Details</td>';
								}
							}
							$colcount++;
						}
					}
					
					$rows .= '</tr>';

					foreach ( $chart['rows'] as $row ) {
						$departDayInfoExists = false;
						foreach ( $chart['columns'] as $col ) {
							$d = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
							if ( is_array($d) && count($d) > 0  ) {
								foreach ( $d as $blah ) {
									if ( isset($blah['value']) && $blah['value'] != "" ) {
										$departDayInfoExists = true;
									}
								}
							}
						}

						if ($departDayInfoExists && $showDepartureInfo ) {
							$thisDate	= explode("-",$row['id']);
							$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
							
							// [START] Departure information row --------------------------------------
							$rows .= '<tr' . (isset($rowClass) ? $rowClass : "") . '  style="height:35px; height:100% !important;">';
							$rows .= '
								<td valign="top" class="' . $colourBand . ' bAll">' . $displayDate . ' ' . t_encodeHTML($row['name']) . '</td>';
								
							if($chart['detailAs'] == '1') {
								$rows .='
									<td valign="top" class="colLtDk bAll">
									<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">
								';
							}
							
							if($chart['detailAs'] == '1') {
								// [START] Departure section headings -------------------------------------
								$rowSpan = getRowSpans($chart,'depart',$departIds);
								$rowSpans = $rowSpan[$row['id']];
								$totalSubCell = array_sum($rowSpans);
								$rows .= createHeaderDetailAsRow($departIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
								$rows .= '</table></td>';
								// [ END ] Departure section headings -------------------------------------
							}

							// [START] Departure information ------------------------------------------	
							$prop = '';
							$colcount = 1;
							$colIds = array();
							foreach ( $chart['columns'] as $col ) {
								if ( $property_name == $col['property'] ) {
									$c = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : "";
									$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

									$initialColour = "#fff";
									$initialFontColour = "#000";
									if ( $b != "" ) {
										$initialColour = "#c0c0c0";
									}

									$rows .= '
											<td valign="top" class="bAll" style="background-color: ' . $initialColour . ';">'; 
									$rows .= createInnerRoomDetails($chart,'depart', $row['id'], $col['id'], $chartIds, $chartSections);
									$rows .= '</td>';
									
									if($colcount == $propRoomsArr[$property_name]) {
										array_push($colIds, $col['id']);
										if(count($chartIds['perDay'])>0) {
											$rows .= '<td valign="top" class="bl bt" style="background-color: ' . $initialColour . '; ">'; 
											$rows .= cretaePerDayDetails($chart,'depart', $row['id'], $colIds, $chartIds, $chartSections);
											$rows .= '</td>';
										}
										$colIds = array();
									} else {
										array_push($colIds, $col['id']);
									}
									$colcount++;
								}
							}
							$rows .= '</tr>';
							$bool_depart = true;
											
						} else {
							$bool_depart = false;
						}

					}
					$rows .= '</table>';
				}

			} else {
				//$rows .= '<td class="' . $bg_style . ' bt">&nbsp;</td>';
			}
			if($colcount == count($chart['columns'])) {
				if(count($chartIds['perDay'])>0) {
					$rows .= '<td class="' . $bg_style . ' bt">&nbsp;</td>';
					
				}
			}
			$colcount++;
		}
		
		$rows .= '</tr>';
		
		
	} else {
		// Dates along top
		
		$firstProperty = 1;
		$property_name = "";
		foreach ( $chart['rows'] as $row ) {
			$roomInfoExists = false;
			$stayOverInfoExists = false;
			$departInfoExists = false;
		
			if ( $modcount%2 == 0 ) {
				$colourBand = 'colLtt';
			} else {
				$colourBand = 'colLt';
			}
		
			if ( $property_name != $row['property'] && $row['room'] != "overbooking") {
				
				$property_name = $row['property'];
				foreach ( $chart['rows'] as $dateRow ) {
					if ( $property_name == $dateRow['property'] ) {
						foreach ( $chart['columns'] as $col ) {
							$c = isset($chart['room'][$dateRow['id']][$col['id']]) ? $chart['room'][$dateRow['id']][$col['id']] : array();
							if ( is_array($c) && count($c) > 0  ) {
								foreach ( $c as $blah ) {
									if ( isset($blah['value']) && $blah['value'] != "" ) {
										$roomInfoExists = true;
									}
								}
							}
						}
					}
				}

				if($firstProperty != 1) {
					$rows .= '<br><br>';
				}

				if ( count($showIds) > 0 && $roomInfoExists) {
					$tWidth = $tableExtraWidth + count($chart['columns']) * $totalWidthRoom;
					$rows .= '<table style="table-layout:fixed; border-collapse:collapse;width:'.$tWidth.'px" cellpadding="1" cellspacing="0" summary="">';
					$rows .= '<col style="width:150px;" />';
					if($chart['detailAs'] == '1') {
						$rows .= '<col style="width:150px;" />';
					}
					
					for($i=0; $i<count($chart['columns']); $i++) {
						$rows .= '<col  style="width:'.$totalWidthRoom.'px;" />';
					}
													
					$firstProperty = 0;
										
					if ( $anotherCount%2 == 0 ) {
						$bg_style = "colLtt";
					} else {
						$bg_style = "colLt";
					}

					$anotherCount++;

					$cnt = 1;
					if($chart['detailAs'] == '1') {
						$cnt++;
					}
					
					$propName = t_encodeHTML($row['property']);
					if($row['room'] == "overbooking") {
						$propName = "";
					}
					$propColspan = count($chart['columns'])+$extraRows;
					
					$rows .= '
						<tr style="height:25px;">
							<td colspan="' . $propColspan . '" valign="top" class="' . $bg_style . ' bt bl bb br"><strong>' . $propName . '</strong></td>
						</tr>
						<tr style="height:10px;">
							<td colspan="'.$propColspan.'">&nbsp;</td>
						</tr>
						<tr style="height:25px;">
							<td class="colLt bAll txtb" colspan="'.$propColspan.'">' . $combination . '</td>
						</tr>
						<tr style="height:10px;">
							<td colspan="'.$propColspan.'">&nbsp;</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
					';
					
					if($chart['detailAs'] == '1') {
						$rows .= '<td class="colLtDk bt bl">Details</td>';
					}
					foreach ( $chart['columns'] as $col ) {
						$rows .= '<td class="colLt bAll" style="background-color: #FFFFFF;">
									<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidthRoom.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">';
									
						if($chart['detailAs'] == '2') {
							$rows .= createCols($showIds, $chartSections, 2, $perDayIds);
						} else {
							$rows .= '<col style="width:200px;" />';
						}
						
						$rows .= '
							<tr style="background-color: #FFFFFF;">
								<td colspan='.$colspnRoom.'>
						';
						
						$thisDate = explode("-",$col['id']);
						$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
						$displayDate .= ' ' . $col['name'];

						if ( $showDatePAX == "1" ) {
							$displayDate .= '<br />PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
						}
									
						$rows .= $displayDate .'</td></tr>';
						
						if($chart['detailAs'] == '2') {
							$row1 = '<tr class="'.$bg_style.'">';
							$row2 = '<tr class="'.$bg_style.'">';
							
							$dataHeader = createDetailHeaderRow($chartSections, $showIds, $perDayIds);
							$row1 .= $dataHeader[1];
							$row2 .= $dataHeader[2];
														
							$row1 .= '</tr>';
							$row2 .= '</tr>';
							$rows .= $row1.$row2;
						}
						$rows .= '</table></td>';
					}
					$rows .= '</tr>';
					$modcount = 1;

					$rowcounter = 1;
					$rowIdsArr = array();
					foreach ( $chart['rows'] as $row ) {
						if ( $property_name == $row['property'] ) {
							$rowInfoExists = false;
							foreach ( $chart['columns'] as $col ) {
								$c = isset($chart['room'][$row['id']][$col['id']]) ? $chart['room'][$row['id']][$col['id']] : array();
								if ( is_array($c) && count($c) > 0  ) {
									foreach ( $c as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$rowInfoExists = true;
										}
									}
								}
							}
							if($rowInfoExists || $showEmptyRooms == 1) {
								if($row['room'] == "overbooking") {
									$roomInfo = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($row['property'])."<br>Accommodation:" .t_encodeOverlib($row['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
									$tdStyle = "style='font-size: 12px;font-weight: bold;'";
								} else {
									if ( $hideAccommType == "1" ) {
										$roomInfo = "";
									} else {
										$roomInfo = t_encodeHTML($row['accommodation']);
									}										
									if ( $showUnitLabel == "1" ) {
										$roomInfo .= ' ' . t_encodeHTML($row['unit_label']);
									}
									if ( $showUnitNumber == "1" ) {
										$roomInfo .= ' ' . t_encodeHTML($row['room']);
									}
									$tdStyle = "";
								}
								
								$rows .= '<tr' . $rowClass . '>';
								$rows .= '<td valign="top" class="' . $colourBand . ' bAll" '.$tdStyle.'>';
								$rows .= $roomInfo."</td>";

								if($chart['detailAs'] == '1') {
									$rows .= '
										<td valign="top" class="colLtDk bAll">
											<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">
									';
									
									// [START] Room data headings ----------------------------------------------
									$rowSpan = getRowSpans($chart,'room',$showIds);
									$rowSpans = $rowSpan[$row['id']];
									$totalSubCell = array_sum($rowSpans);
									$rows .= createHeaderDetailAsRow($showIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
									
									$rows .= '</table></td>';
									// [ END ] Room data headings ------------------------------------------
								}
							
								// [START] Room information ------------------------------------------------
								
								foreach ( $chart['columns'] as $kId=>$col ) {
									$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

									$initialColour = "#fff";
									$initialFontColour = "#000";
									if ( $b != "" ) {
										$initialColour = "#c0c0c0";
									}
									
									if(isset($col['room']) && $col['room'] == "overbooking") {
										$initialColour = "#db4242";
									}
									
									$rows .= '<td valign="top" class="bAll" style="background-color: ' . $initialColour . '; ">'; 
									$rows .= createInnerRoomDetails($chart,'room', $row['id'], $col['id'], $chartIds, $chartSections);
									$rows .= '</td>';

									$c = isset($chart['room'][$row['id']][$col['id']]) ? $chart['room'][$row['id']][$col['id']] : array();
									if(!in_array($row['id'], $rowIdsArr) && !empty($c)) {
										array_push($rowIdsArr, $row['id']);
									}
								}
								// [ END ] Room information -----------------------------------------------
								$rows .= '</tr>';
								$bool_room = true;
								$top_line_style = 'border-top: 1px dashed #ccc;';
							}
							
						}
					
						if($rowcounter == count($chart['rows'])) {
							if(count($chartIds['perDay'])>0) {
								$rows .= cretaePerDayDetailsRows($chart,'room', $rowIdsArr, $chartIds, $chartSections);
								$rowIdsArr = array();
								$resIdsArr = array();
							}
						} 
						$rowcounter++;
					}
					
					$rows .= '</table>';
					$rows .= '<br>';
				}
				
				if($chart['combArrSty'] == '2' && count($stayOverIds)>0) {
					// [START] Stay Over information row -------------------------------------------
					foreach ( $chart['rows'] as $dateRow ) {
						if ( $property_name == $dateRow['property'] ) {
							foreach ( $chart['columns'] as $col ) {
								$d = isset($chart['stayOver'][$dateRow['id']][$col['id']]) ? $chart['stayOver'][$dateRow['id']][$col['id']] : array();
								if ( is_array($d) && count($d) > 0  ) {
									foreach ( $d as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$stayOverInfoExists = true;
										}
									}
								}
							}
						}
					}

					if ($stayOverInfoExists) {
						$tWidthSO = $tableExtraWidth + count($chart['columns']) * $totalWidthSO;
						
						$rows .= '<table style="table-layout:fixed; border-collapse:collapse;width:'.$tWidthSO.'px" cellpadding="1" cellspacing="0" summary="">';
						$rows .= '<col style="width:150px;" />';
						if($chart['detailAs'] == '1') {
							$rows .= '<col style="width:150px;" />';
						}
						
						for($i=0; $i<count($chart['columns']); $i++) {
							$rows .= '<col  style="width:'.$totalWidthSO.'px;" />';
						}
															
						if ( $anotherCount%2 == 0 ) {
							$bg_style = "colLtt";
						} else {
							$bg_style = "colLt";
						}
						
						$anotherCount++;
						
						$cnt = 1;
						if($chart['detailAs'] == '1') {
							$cnt++;
						}
						
						$propColspan = count($chart['columns'])+$extraRows;
						
						if(!$roomInfoExists) {
							$propName = t_encodeHTML($row['property']);
							$rows .= '
								<tr style="height:25px;">					
									<td colspan="' . $propColspan . '" valign="top" class="'.$bg_style. ' bAll"><strong>' . $propName . '</strong></td>
								</tr>
								<tr style="height:10px;">
									<td colspan="'.$propColspan.'">&nbsp;</td>
								</tr>
							';
						}
						$rows .= '
							<tr style="height:25px;">
								<td class="colLt bAll txtb" colspan="'.$propColspan.'">Stay Over</td>
							</tr>
							<tr style="height:10px;">
								<td colspan="'.$propColspan.'">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
						';
						if($chart['detailAs'] == '1') {
							$rows .= '<td class="colLtDk bAll">Details</td>';
						}
						foreach ( $chart['columns'] as $col ) {
							$rows .= '
								<td class="colLt bAll">
								<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidthSO.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">
							';
										
							if($chart['detailAs'] == '2') {
								$rows .= createCols($stayOverIds, $chartSections, 2, $perDayIds);
							} else {
								$rows .= '<col style="width:200px;" />';
							}
							
							$rows .= '<tr style="background-color: #FFFFFF;">
										<td colspan='.$colspnSO.'>';
							$thisDate = explode("-",$col['id']);
							$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
							$displayDate .= ' ' . $col['name'];

							if ( $showDatePAX == "1" ) {
								$displayDate .= '<br />PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
							}
										
							$rows .= $displayDate .'</td></tr>';
							
							if($chart['detailAs'] == '2') {
								$row1 = '<tr style="background-color: #f6f6f6;">';
								$row2 = '<tr style="background-color: #f6f6f6;">';
								
								$dataHeader = createDetailHeaderRow($chartSections, $stayOverIds, $perDayIds);
								$row1 .= $dataHeader[1];
								$row2 .= $dataHeader[2];
															
								$row1 .= '</tr>';
								$row2 .= '</tr>';
								$rows .= $row1.$row2;
							}
							$rows .= '</table></td>';
						}
						$rows .= '</tr>';
						$modcount = 1;
						$rowcounter = 1;
						$rowIdsArr = array();
						foreach ( $chart['rows'] as $row ) {
							if ( $property_name == $row['property'] ) {
								$rowInfoExists = false;
								foreach ( $chart['columns'] as $col ) {
									$c = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$rowInfoExists = true;
											}
										}
									}
								}
								if($rowInfoExists || $showEmptyRooms == 1) {
									if ( $modcount%2 == 0 ) {
										$colourBand = 'colDkDk';
									} else {
										$colourBand = $bg_style;
									}

									$rows .= '<tr' . $rowClass . ' style="height:35px; height:100% !important;">';
								
									if($row['room'] == "overbooking") {
										$roomInfo = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($row['property'])."<br>Accommodation:" .t_encodeOverlib($row['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
										$tdStyle = "style='font-size: 12px;font-weight: bold;'";
									} else {
										if ( $hideAccommType == "1" ) {
											$roomInfo = "";
										} else {
											$roomInfo = t_encodeHTML($row['accommodation']);
										}										
										if ( $showUnitLabel == "1" ) {
											$roomInfo .= ' ' . t_encodeHTML($row['unit_label']);
										}
										if ( $showUnitNumber == "1" ) {
											$roomInfo .= ' ' . t_encodeHTML($row['room']);
										}
										$tdStyle = "";
									}
								
									$rows .= '<td valign="top" class="' . $colourBand . ' bAll" '.$tdStyle.'>'. $roomInfo. '</td>';
										
								
									if($chart['detailAs'] == '1') {
										$rows .= '<td valign="top" class="colLtDk bAll">
											 <table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; border-collapse:collapse;" summary="">';
										
										// [START] Stay Over data headings --------------------------
										$rowSpan = getRowSpans($chart,'stayOver',$stayOverIds);
										$rowSpans = $rowSpan[$row['id']];
										$totalSubCell = array_sum($rowSpans);
										$rows .= createHeaderDetailAsRow($stayOverIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
										$rows .= '</table></td>';
										// [ END ] Stay Over data headings --------------------------
									}

									// [START] Stay Over information --------------------------------
									$prop = '';
									foreach ( $chart['columns'] as $col ) {
										$c = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : "";
										$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

										$initialColour = "#fff";
										$initialFontColour = "#000";
										if ( $b != "" ) {
											$initialColour = "#c0c0c0";
										}

										$rows .= '
												<td valign="top" class="bAll" style="background-color: ' . $initialColour . ';">'; 
										$rows .= createInnerRoomDetails($chart,'stayOver', $row['id'], $col['id'], $chartIds, $chartSections);

										$rows .= '</td>';

										$c = isset($chart['stayOver'][$row['id']][$col['id']]) ? $chart['stayOver'][$row['id']][$col['id']] : array();
										if(!in_array($row['id'], $rowIdsArr) && !empty($c)) {
											array_push($rowIdsArr, $row['id']);
										}
									}
									// [ END ] Stay Over information ----------------------------------
									$rows .= '</tr>';
									$bool_stayOver = true;
									$top_line_style = 'border-top: 1px dashed #ccc;';
								}
							}

							if($rowcounter == count($chart['rows'])) {
								if(count($chartIds['perDay'])>0) {
									$rows .= cretaePerDayDetailsRows($chart,'stayOver', $rowIdsArr, $chartIds, $chartSections);
									$rowIdsArr = array();
								}
							} 
							$rowcounter++;
						}
						$rows .= '</table>';
						$rows .= '<br>';
					}
				}

				if(count($departIds) > 0) {
					$departInfoExists = false;
					foreach ( $chart['rows'] as $dateRow ) {
						if ( $property_name == $dateRow['property'] ) {
							foreach ( $chart['columns'] as $col ) {
								$d = isset($chart['depart'][$dateRow['id']][$col['id']]) ? $chart['depart'][$dateRow['id']][$col['id']] : array();
								if ( is_array($d) && count($d) > 0  ) {
									foreach ( $d as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$departInfoExists = true;
										}
									}
								}
							}
						}
					}
					if($departInfoExists) {
						$tWidthDep = $tableExtraWidth + count($chart['columns']) * $totalWidthDepart;
						$rows .= '<table style="table-layout:fixed; border-collapse:collapse;width:' .$tWidthDep.'px" cellpadding="1" cellspacing="0" summary="" class="bb br">';
						$rows .= '<col style="width:150px;" />';
						if($chart['detailAs'] == '1') {
							$rows .= '<col style="width:150px;" />';
						}
												
						for($i=0; $i<count($chart['columns']); $i++) {
							$rows .= '<col  style="width:'.$totalWidthDepart.'px;" />';
						}
																											
						if ( $anotherCount%2 == 0 ) {
							$bg_style = "colLtt";
						} else {
							$bg_style = "colLt";
						}
						
						$anotherCount++;
						
						$cnt = 1;
						if($chart['detailAs'] == '1') {
							$cnt++;
						}
						$propColspan = count($chart['columns'])+$extraRows;
						
						if(!$roomInfoExists && !$stayOverInfoExists) {
							$propName = t_encodeHTML($row['property']);
							$rows .= '
								<tr style="height:25px;">
									<td colspan="' . $propColspan . '" valign="top" class="' . $bg_style . ' bAll"><strong>' . $propName . '</strong></td>
								</tr>
								<tr style="height:10px;">
									<td colspan="'.$propColspan.'">&nbsp;</td>
								</tr>
							';
						}
						
						$rows .= '
							<tr style="height:25px;">
								<td class="colLt bAll txtb" colspan="'.$propColspan . '">Depart</td>
							</tr>
							<tr style="height:10px;">
								<td colspan="'.$propColspan.'">&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
						';
						if($chart['detailAs'] == '1') {
							$rows .= '<td class="colLtDk bAll">Details</td>';
						}
						foreach ( $chart['columns'] as $col ) {
							$rows .= '<td class="colLt bAll">
										<table border="0" cellpadding="1" cellspacing="0" style="width:'.$totalWidthDepart.'px; table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">';
										
							if($chart['detailAs'] == '2') {
								$rows .= createCols($departIds, $chartSections, 2, $perDayIds);
							} else {
								$rows .= '<col style="width:200px;" />';
							}
														
							$rows .= '<tr style="background-color: #FFFFFF;">
										<td colspan='.$colspnDepart.'>';
							$thisDate = explode("-",$col['id']);
							$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
							$displayDate .= ' ' . $col['name'];

							if ( $showDatePAX == "1" ) {
								$displayDate .= '<br />PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
							}
										
							$rows .= $displayDate .'</td></tr>';
							
							if($chart['detailAs'] == '2') {
								$row1 = '<tr style="background-color: #f6f6f6;">';
								$row2 = '<tr style="background-color: #f6f6f6;">';
								
								$dataHeader = createDetailHeaderRow($chartSections, $departIds, $perDayIds);
								$row1 .= $dataHeader[1];
								$row2 .= $dataHeader[2];
															
								$row1 .= '</tr>';
								$row2 .= '</tr>';
								$rows .= $row1.$row2;
							}
							$rows .= '</table></td>';
						}
						$rows .= '</tr>';
						$modcount = 1;
						$rowcounter = 1;
						$rowIdsArr = array();
						foreach ( $chart['rows'] as $row ) {
							if ( $property_name == $row['property'] ) {
								$rowInfoExists = false;
								foreach ( $chart['columns'] as $col ) {
									$c = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$rowInfoExists = true;
											}
										}
									}
								}
								if($rowInfoExists || $showEmptyRooms == 1) {
									$rows .= '<tr' . (isset($rowClass) ? $rowClass : "") . '  style="height:35px; height:100% !important;">';
									
									if($row['room'] == "overbooking") {
										$roomInfo = "<img src='/resource/Resrequest/Application/public/img/icon_error_16.gif' alt='' style='display: inline;' onmouseover=\"overlib('Property:".t_encodeOverlib($row['property'])."<br>Accommodation:" .t_encodeOverlib($row['accommodation'])."');\" onmouseout='nd();' />&nbsp;Overbooking";
										$tdStyle = "style='font-size: 12px;font-weight: bold;'";
									} else {
										if ( $hideAccommType == "1" ) {
											$roomInfo = "";
										} else {
											$roomInfo = t_encodeHTML($row['accommodation']);
										}											
										if ( $showUnitLabel == "1" ) {
											$roomInfo .= ' ' . t_encodeHTML($row['unit_label']);
										}
										if ( $showUnitNumber == "1" ) {
											$roomInfo .= ' ' . t_encodeHTML($row['room']);
										}
										$tdStyle = "";
									}
									
									$rows .= '<td valign="top" class="' . $colourBand . ' bAll" '.$tdStyle.'>' . $roomInfo . '</td>
										';
									if($chart['detailAs'] == '1') {
										$rows .= '
											<td valign="top" class="colLtDk bAll">
											<table border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed; height: 100% !important; border-collapse:collapse;" summary="">
										';
										
										// [START] Departure section headings ------------------------------
										$rowSpan = getRowSpans($chart,'depart',$departIds);
										$rowSpans = $rowSpan[$row['id']];
										$totalSubCell = array_sum($rowSpans);
										$rows .= createHeaderDetailAsRow($departIds, $chartSections, $perDayIds, $rowSpans, $totalSubCell);
										$rows .= '</table></td>';
										// [ END ] Departure section headings -------------------------------
									}
									
									// [START] Departure information ----------------------------------------	
									$prop = '';
										
									foreach ( $chart['columns'] as $col ) {
										$c = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : "";
										$b = isset($chart['block'][$row['id']][$col['id']]) ? $chart['block'][$row['id']][$col['id']] : "";

										$initialColour = "#fff";
										$initialFontColour = "#000";
										if ( $b != "" ) {
											$initialColour = "#c0c0c0";
										}

										$rows .= '
												<td valign="top" class="bAll" style="background-color: ' . $initialColour . ';">'; 
										$rows .= createInnerRoomDetails($chart,'depart', $row['id'], $col['id'], $chartIds, $chartSections);
										$rows .= '</td>';

										$c = isset($chart['depart'][$row['id']][$col['id']]) ? $chart['depart'][$row['id']][$col['id']] : array();
										if(!in_array($row['id'], $rowIdsArr) && !empty($c)) {
											array_push($rowIdsArr, $row['id']);
										}
									}
									$rows .= '</tr>';
									$bool_depart = true;
									$top_line_style = 'border-top: 1px dashed #ccc;';
								}
							}
							
							if($rowcounter == count($chart['rows'])) {
								if(count($chartIds['perDay'])>0) {
									$rows .= cretaePerDayDetailsRows($chart,'depart', $rowIdsArr, $chartIds, $chartSections);
									$rowIdsArr = array();
								}
							} 
							$rowcounter++;
							
						}
						$rows .= '</table>';
					}
				}

			}
	
		
		}
	}
	$rows .= '</td></tr>';
	$GLOBALS['temp']['chartTableWidth'] = $tableExtraWidth + $numTH * $totalWidth;
	return $rows;
}

function genrateNotesHeader($noteSort, $notesHeader, $header=1, $item = array()) {
	$mainColHeading = array();
	$title = array();	
	if(empty($item)) {
		$item['rv_date_arrive_fmt'] = '';
		$item['rv_date_depart_fmt'] = '';
		$item['rv_res_name'] = '';
		$item['rv_reservation_ix'] = '';
		$item['property'] = '';
	}
	switch ( $noteSort ) {
					case "6":
					case "1":
						if(in_array(4, $notesHeader)) {
							$mainColHeading[] = "Arrival date";
							$title [] = $item['rv_date_arrive_fmt'];		//Arrival date
						}
						if(in_array(5, $notesHeader)) {
							$mainColHeading[] = "Departure date";
							$title [] = $item['rv_date_depart_fmt'];		//Departure date
						}
						if(in_array(3, $notesHeader)) {
							$mainColHeading[] = "Res. Name";
							$title [] = $item['rv_res_name'];
						}
						if(in_array(2, $notesHeader)) {
							$mainColHeading[] = "Res. Number";
							$title [] = $item['rv_reservation_ix'];
						}
						if(in_array(1, $notesHeader)) {
							$mainColHeading[] = "Property Filter";
							$title[] = isset($item['property_short_name_list']) ? $item['property_short_name_list'] : "";
						}
						break;
					case "2":
						if(in_array(5, $notesHeader)) {
							$mainColHeading[] = "Departure date";
							$title [] = $item['rv_date_depart_fmt'];
						}
						if(in_array(3, $notesHeader)) {
							$mainColHeading[] = "Res. Name";
							$title [] = $item['rv_res_name'];
						}
						if(in_array(2, $notesHeader)) {
							$mainColHeading[] = "Res. Number";
							$title [] = $item['rv_reservation_ix'];
						}
						if(in_array(1, $notesHeader)) {
							$mainColHeading[] = "Property Filter";
							$title[] = isset($item['property_short_name_list']) ? $item['property_short_name_list'] : "";
						}
						if(in_array(4, $notesHeader)) {
							$mainColHeading[] = "Arrival date";
							$title [] = $item['rv_date_arrive_fmt'];
						}
					case "3":
						if(in_array(2, $notesHeader)) {
							$mainColHeading[] = "Res. Number";
							$title [] = $item['rv_reservation_ix'];
						}
						if(in_array(1, $notesHeader)) {
							$mainColHeading[] = "Property Filter";
							$title[] = isset($item['property_short_name_list']) ? $item['property_short_name_list'] : "";
						}
						if(in_array(4, $notesHeader)) {
							$mainColHeading[] = "Arrival date";
							$title [] = $item['rv_date_arrive_fmt'];
						}
						if(in_array(5, $notesHeader)) {
							$mainColHeading[] = "Departure date";
							$title [] = $item['rv_date_depart_fmt'];
						}
						if(in_array(3, $notesHeader)) {
							$mainColHeading[] = "Res. Name";
							$title [] = $item['rv_res_name'];
						}
						break;
					case "4":
						if(in_array(3, $notesHeader)) {
							$mainColHeading[] = "Res. Name";
							$title [] = $item['rv_res_name'];
						}
						if(in_array(4, $notesHeader)) {
							$mainColHeading[] = "Arrival date";
							$title [] = $item['rv_date_arrive_fmt'];
						}
						if(in_array(5, $notesHeader)) {
							$mainColHeading[] = "Departure date";
							$title [] = $item['rv_date_depart_fmt'];
						}
						if(in_array(1, $notesHeader)) {
							$mainColHeading[] = "Property Filter";
							$title[] = isset($item['property_short_name_list']) ? $item['property_short_name_list'] : "";
						}
						if(in_array(2, $notesHeader)) {
							$mainColHeading[] = "Res. Number";
							$title [] = $item['rv_reservation_ix'];
						}
					case "5":
						if(in_array(1, $notesHeader)) {
							$mainColHeading[] = "Property Filter";
							$title[] = isset($item['property_short_name_list']) ? $item['property_short_name_list'] : "";
						}
						if(in_array(3, $notesHeader)) {
							$mainColHeading[] = "Res. Name";
							$title [] = $item['rv_res_name'];
						}
						if(in_array(4, $notesHeader)) {
							$mainColHeading[] = "Arrival date";
							$title [] = $item['rv_date_arrive_fmt'];
						}
						if(in_array(5, $notesHeader)) {
							$mainColHeading[] = "Departure date";
							$title [] = $item['rv_date_depart_fmt'];
						}
						
						if(in_array(2, $notesHeader)) {
							$mainColHeading[] = "Res. Number";
							$title [] = $item['rv_reservation_ix'];
						}
						break;
				}

		if ($header == 1) {
			return $mainColHeading;
		} else {
			return $title;
		}
}

function generateNotes($noteSections,$noteIds,$notes,$noteSort, $notesHeader) {
	$html = '';
	
	// debug($noteIds);
	// debug($noteSections);
	// debug($notes);
	
	/* ---------------------------------------------------------------------------
		ORDER FOR NOTES:  (new as per Jill - 2011-07-12)
		 Itinerary Summary
		 Room lock reason
		 Notes
		 Memos
		 Guest information
		 Guest Details
		>Nationality
		>Source
		>Rate type
		>Payment plan
		>Agent
		>Contact person
		>Originator
		>Consultant
		 Extras
		 Extras notes
		 Extras memos
		 Travel
		 Travel notes
		 Travel memos
		>Financials
	---------------------------------------------------------------------------	*/
	$mainColHeading = array();
	if ( count($notes) > 0 ) {
		$mainColHeading = genrateNotesHeader($noteSort, $notesHeader);
		$html .= '
			<table width="770" border="0" cellpadding="0" cellspacing="0" summary="" style="table-layout: fixed;" class="table-wrap">
				<col style="width:125px" />
				<col style="width:125px" />
				<col style="width:125px" />
				<col style="width:125px" />
				<col />
				<tr style="height:25px;">
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[0]) ? $mainColHeading[0] : "") . '</strong>&nbsp;</td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[1]) ? $mainColHeading[1] : "") . '</strong>&nbsp;</td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[2]) ? $mainColHeading[2] : "") . '</strong>&nbsp;</td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[3]) ? $mainColHeading[3] : "") . '</strong>&nbsp;</td>
					<td valign="top" class="bt"><strong>' . (isset($mainColHeading[4]) ? $mainColHeading[4] : "") . '</strong>&nbsp;</td>
				</tr>
			</table>
		';

		foreach ( $notes as $item ) {
			// Used to suppress reservations with no notes --------------------------
			$note_exists	= false;
			$note_html		= '';
			$title = array();
			$mainColHeading = array();
			if ( count($item) > 0 ) {
				/* -------------------------------------------------------------------------
					TITLE SORT ORDER
					1: Arrival date
					2: Departure date
					3: Reservation ID
					4: Reservation name
					5: Property
				------------------------------------------------------------------------- */
				$title = genrateNotesHeader($noteSort, $notesHeader, 0, $item);
				$note_html .= '
					<table width="770" border="0" cellpadding="0" cellspacing="0" summary="" style="table-layout: fixed;" class="table-wrap">
						<col style="width:125px" />
						<col style="width:125px" />
						<col style="width:125px" />
						<col style="width:125px" />
						<col />
						<tr bgcolor="#C1C1C1">
							<td valign="top" class="bt txtb">' . (isset($title[0]) ? $title[0] : "") . '&nbsp;</td>
							<td valign="top" class="bt txtb">' . (isset($title[1]) ? $title[1] : "") . '&nbsp;</td>
							<td valign="top" class="bt txtb">' . (isset($title[2]) ? $title[2] : "") . '&nbsp;</td>
							<td valign="top" class="bt txtb">' . (isset($title[3]) ? $title[3] : "") . '&nbsp;</td>
							<td valign="top" class="bt txtb">' . (isset($title[4]) ? $title[4] : "") . '&nbsp;</td>
						</tr>
					</table>

					<table width="770" border="0" cellpadding="1" cellspacing="0" summary="" class="table-wrap">
						<col style="width:125px" />
						<col />
				';

				// [START] Voucher ---------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resVoucher"),$noteIds) ) {
					if ( isset($item['voucher']) && trim($item['voucher']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Voucher</td>
								<td>'.$item['voucher'].'&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Voucher ---------------------------------------------------------

				// [START] Internal Consultant --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resIntConsultant"),$noteIds) ) {
					if ( isset($item['intconsultant']) && trim($item['intconsultant']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Internal Consultant</td>
								<td>' . nl2br($item['intconsultant']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Internal Consultant --------------------------------------------------				
				
				// [START] Status ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resStatus"),$noteIds) ) {
					if ( isset($item['status']) && trim($item['status']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Status</td>
								<td>'.$item['status'].'&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Status ----------------------------------------------------------
			
				// [START] Itinerary Summary -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"itinerarySum"),$noteIds) ) {
					if(sizeof($item['itinerary'])) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top" class="brdr_right">Itinerary summary</td>
								<td valign="top">
								<table width="100%" cellpadding="2" cellspacing="0" summary="" style="table-layout: fixed; border:1px solid #000000;" class="table-wrap">
										<tr>
											<td valign="top" class="note_detail txtb" style="width:85px">Room</td>
											<td valign="top" class="note_detail txtb" style="width:65px">Arrive</td>
											<td valign="top" class="note_detail txtb" style="width:65px">Depart</td>
											<td valign="top" class="note_detail txtb" style="width:30px">Night</td>
											<td valign="top" class="note_detail txtb" style="width:135px">Property</td>
											<td valign="top" class="note_detail txtb">Accomm</td>
											<td valign="top" class="note_detail txtb" style="width:25px">Rms</td>
											<td valign="top" class="note_detail txtb" style="width:25px">Ad</td>
											<td valign="top" class="note_detail txtb" style="width:25px">Chld</td>
							</tr>
						';
						$roomRequestFootnotes = array();
						foreach ( $item['itinerary'] as $itinerary ) {
							if ($itinerary['rv_room_requested_yn'] == 1){
								$room = $itinerary['room']."*";
							} else {
								$room = $itinerary['room'];
							}
						
							$note_html .= '
								<tr>
									<td class="note_detail">'.$room.'&nbsp;</td>
									<td class="note_detail">'.$itinerary['resArrive'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['resDepart'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['nights'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['propName'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['accom'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['rooms'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['adults'].'&nbsp;</td>
									<td class="note_detail">'.$itinerary['childs'].'&nbsp;</td>
								</tr>
							';
							
							if (isset($itinerary['rv_room_request_reason']) && $itinerary['rv_room_request_reason'] != ""){
								$roomRequestFootnotes[] = "* " . nl2br($itinerary['room']) . ": " . nl2br($itinerary['rv_room_request_reason']);
							}							
							
						}
						$note_html .= '
									</table>
								</td>
							</tr>
						';
						
						foreach($roomRequestFootnotes as $roomRequestFootnote){
							$note_html .= "
								<tr>
									<td valign=\"top\"></td>
									<td>".$roomRequestFootnote."</td>
								</tr>
							";						
						}
						
					}
					
				}
				// [ END ] Itinerary Summary -----------------------------------------------

				// [START] Reservation Notes -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNote"),$noteIds) ) {
					if ( isset($item['rv_note_general']) && $item['rv_note_general'] != "" ) {
						$note_exists = true;

						$note_html .= '
							<tr>
								<td valign="top">Notes</td>
								<td>' . nl2br($item['rv_note_general']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Reservation Notes -----------------------------------------------				
				
				// [START] Internal Memos --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resMemo"),$noteIds) ) {
					if ( isset($item['rv_note_internal']) && trim($item['rv_note_internal']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Memos</td>
								<td>' . nl2br($item['rv_note_internal']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Internal Memos --------------------------------------------------						

				// [START] Guest information -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					if ( isset($item['rv_note_guests']) && trim($item['rv_note_guests']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Guest information</td>
								<td>' . nl2br($item['rv_note_guests']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Guest information -----------------------------------------------

				// [START] Guest Details--------------------------------------
				
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds)) {
					if(!empty($item['guests'])) {
						$nameDetail = '';
						$nationDetail = '';
						$noteDetail = '';
						$memosDetail = '';
						$anniversaryDetail = '';
						$birthDetail = '';
						$note_exists = true;

						$note_html .= '
							<tr>
								<td valign="top">Guest details</td>
								<td>
								<table width="100%" border="0" cellpadding="2" cellspacing="0" summary="" style="table-layout: fixed; border:1px solid #000000;">
									<col style="width:35px;" />
									<col style="width:80px;" />
									<col style="width:65px;" />
									<col style="width:65px;" />
									<col style="width:35px;" />
									<col style="width:65px;" />
									<col style="width:65px;" />
									<col />
									<col />
								
									<tr>
										<td class="note_detail txtb">Room</td>
										<td valign="top" class="note_detail txtb">Guest name</td>
										<td valign="top" class="note_detail txtb">Nationality</td>
										<td class="note_detail txtb">Last Dep</td>
										<td class="note_detail txtb">Visits</td>
										<td valign="top" class="note_detail txtb">B-day</td>
										<td valign="top" class="note_detail txtb">Anniv</td>
										<td valign="top" class="note_detail txtb">Notes</td>
										<td valign="top" class="note_detail txtb">Memos</td>
									</tr>
						';

						// [START] Guest names -----------------------------------------------------
					
						foreach ( $item['guests'] as $guests ) {
							$birthday = $guests['pr_birthdate'] != '0000-00-00'? $guests['pr_birthdate']:'&nbsp;';
							$anivrsry = $guests['pr_anniversary'] != '0000-00-00'? $guests['pr_anniversary']:'&nbsp;';
							
							$birthBgcolor = '';
							if($guests['has_birthday'] && $guests['pr_birthdate'] != '0000-00-00') {
								$birthBgcolor = 'bgcolor = #8d9ce7';
							} 
							
							$annBgcolor = '';
							if($guests['has_anniversary'] && $guests['pr_anniversary'] != '0000-00-00') {
								$annBgcolor = 'bgcolor = #8d9ce7';
							} 

							$note_html .= '	
									<tr>
										<td class="note_detail">'.$guests['ac_desc'].'&nbsp;</td>
										<td class="note_detail">'.$guests['pr_name'].'&nbsp;</td>
										<td class="note_detail">' .$guests['nationality']. '&nbsp; </td>
										<td class="note_detail">'.$guests['last_depart'].'&nbsp;</td>
										<td class="note_detail" align="center">'. $guests['total_visit']. '&nbsp;</td>
										<td class="note_detail" '.$birthBgcolor.'>'. $birthday. '&nbsp; </td>
										<td class="note_detail" '.$annBgcolor.'>' .$anivrsry. '&nbsp;</td>
										<td class="note_detail">' .$guests['pr_guest_note'] . '&nbsp; </td>
										<td class="note_detail">'. $guests['pr_guest_memo']. '&nbsp; </td>
									</tr>
							';
						}
						
						$note_html .= '		
								</table></td>
							</tr>'
						;
				
					} 
				}

				if ( in_array(findSectionId($noteSections,"resNationality"),$noteIds)) {
					if(isset($item['nationality']) && $item['nationality'] != "") {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Res nationality</td>
								<td>' . nl2br($item['nationality']) . '&nbsp;</td>
							</tr>
						';
					}
				}
	
				// [ END ] Guest Details --------------------------------------

				// [START] Source --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resSource"),$noteIds) ) {
					if ( isset($item['source']) && trim($item['source']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Source</td>
								<td>' . nl2br($item['source']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Source --------------------------------------------------

				// [START] Rate Type --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resRateType"),$noteIds) ) {
					if ( isset($item['ratetype']) && trim($item['ratetype']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Rate Type</td>
								<td>' . nl2br($item['ratetype']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Rate Type --------------------------------------------------						

				// [START] Payment Plan --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resPaymentPlan"),$noteIds) ) {
					if ( isset($item['paymentplan']) && trim($item['paymentplan']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Payment Plan</td>
								<td>' . nl2br($item['paymentplan']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Payment Plan --------------------------------------------------	
				
				// [START] Agent --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resAgent"),$noteIds) ) {
					if ( isset($item['agent']) && trim($item['agent']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Agent</td>
								<td>' . nl2br($item['agent']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Agent --------------------------------------------------
				
				// [START] Contact Person --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resContactPerson"),$noteIds) ) {
					if ( isset($item['contactperson'][0]['value']) && trim($item['contactperson'][0]['value']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Contact Person</td>
								<td>' . nl2br($item['contactperson'][0]['value']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Contact Person --------------------------------------------------				
				
				// [START] Repeat Guests --------------------------------------------------
				
				if ( in_array(findSectionId($noteSections,"resRepeatGuests"),$noteIds) ) {
					if ( isset($item['repeatguests']) && trim($item['repeatguests']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Repeat Guests</td>
								<td>' . nl2br($item['repeatguests']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Repeat Guests --------------------------------------------------

				// [START] Originator --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resOriginator"),$noteIds) ) {
					if ( isset($item['originator']) && trim($item['originator']) != "" ) {
						$note_exists = true;
						$note_html .= '
							<tr>
								<td valign="top">Originator</td>
								<td>' . nl2br($item['originator']) . '&nbsp;</td>
							</tr>
						';
					}
				}
				// [ END ] Originator --------------------------------------------------				
				
				// [START] Extras ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"travel"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
					
					if(!empty($item['extras']) || !empty($item['travel'])) {
						$first = true;
						$title = 'Extras';
						$note_exists = true;
						
						$note_html .= '
									<tr>
										<td valign="top">' . $title . '</td>
										<td>
											<table width="100%" border="0" cellpadding="2" cellspacing="0" summary="" style="table-layout: fixed; border:1px solid #000000;">
						';
						if(in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"travel"),$noteIds)) {
							$note_html .= '
												<col style="width:35px;" />
												<col style="width:40px;" />
												<col style="width:30px;" />
												<col style="width:70px;" />
												<col style="width:105px;" />
												<col style="width:130px;" />
							';
						}
						if(in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
							$note_html .= '
												<col />
							';
						}
						if(in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
							$note_html .= '
												<col />
							';
						}
						$note_html .= '
											<tr>
						';
						if(in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"travel"),$noteIds)) {
							$note_html .= '
												<td valign="top" class="note_detail txtb">Room</td>
												<td valign="top" class="note_detail txtb">Travel</td>
												<td valign="top" class="note_detail txtb">Qty</td>
												<td valign="top" class="note_detail txtb">Date</td>
												<td valign="top" class="note_detail txtb">Category</td>
												<td valign="top" class="note_detail txtb">Desc</td>
							';
						}
						if(in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
							$note_html .= '
												<td valign="top" class="note_detail txtb">Notes</td>
							';
						}
						if(in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
							$note_html .= '
												<td valign="top" class="note_detail txtb">Memos</td>
							';
						}

						$note_html .= '
											</tr>
									';

						if(!empty($item['extras'])) {
							foreach ( $item['extras'] as $extra ) {
								if ( isset($extra['ac_desc']) && $extra['ac_desc'] != "" ) {
									$extra_room_link = ' (' . $extra['ac_desc'] . ')';
								} else {
									$extra_room_link = '';
								}

								$extra_category = '';
								$extras_note = '';
								$extras_memo = '';
								if ( in_array(findSectionId($noteSections,"extras"),$noteIds) ) {
									$extra_category = $extra['ac_ext_desc'];
								}

								if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) ) {
									$extras_note = $extra['rv_extra_note'];
								}
								if ( in_array(findSectionId($noteSections,"extraMemo"),$noteIds) ) {
									$extras_memo = $extra['rv_extra_note_internal'];
								}

								$note_html .= '
									<tr>
								';
								if(in_array(findSectionId($noteSections,"extras"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">'.$extra['ac_desc'].'&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail" align="center">' . $extra['rv_extra_units'].'&nbsp;</td>
										<td valign="top" class="note_detail">' . $extra['rv_extra_date_serv'] . '&nbsp;</td>
										<td valign="top" class="note_detail">'.t_encodeHTML($extra['ac_extra_cat_desc']) . '&nbsp;</td>
										<td valign="top" class="note_detail">' . t_encodeHTML($extra_category) . '&nbsp;</td>
									';
								} elseif(in_array(findSectionId($noteSections,"travel"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
									';
								}
								if(in_array(findSectionId($noteSections,"extraNote"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">' . t_encodeHTML($extras_note) . '&nbsp;</td>
									';
								} elseif(in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">&nbsp;</td>
									';
								}
								if(in_array(findSectionId($noteSections,"extraMemo"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">' . t_encodeHTML($extras_memo) . '&nbsp;</td>
									';
								} elseif(in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">&nbsp;</td>
									';
								}

								$note_html .= '
									</tr>
								';
							}
						}

						if(!empty($item['travel'])) {
							foreach ( $item['travel'] as $travel ) {
								$travel_cat = '';
								$travel_note = '';
								$travel_memo = '';
								if ( in_array(findSectionId($noteSections,"travel"),$noteIds) ) {
									$travel_cat = $travel['ac_ext_desc'];
								}
								if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) ) {
									$travel_note = trim($travel['rv_extra_note']);
								}
								if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
									$travel_memo = trim($travel['rv_extra_note_internal']);
								}

								$note_exists = true;
								$note_html .= '
									<tr>
								';
								if(in_array(findSectionId($noteSections,"travel"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">'.$travel['ac_desc'].'&nbsp;</td>
										<td valign="top" class="note_detail">Yes</td>
										<td valign="top" class="note_detail" align="center">' . $travel['rv_extra_units'].'&nbsp;</td>
										<td valign="top" class="note_detail">' . $travel['rv_extra_date_serv'] . '&nbsp;</td>
										<td valign="top" class="note_detail">' . t_encodeHTML($travel['ac_extra_cat_desc']). '&nbsp;</td>
										<td valign="top" class="note_detail">' . t_encodeHTML($travel_cat) . '&nbsp;</td>
									';
								} elseif(in_array(findSectionId($noteSections,"extras"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
										<td valign="top" class="note_detail">&nbsp;</td>
									';
								}
								if(in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">' . t_encodeHTML($travel_note) . '&nbsp;</td>
									';
								} elseif(in_array(findSectionId($noteSections,"extraNote"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">&nbsp;</td>
									';
								}
								if(in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">' . t_encodeHTML($travel_memo) . '&nbsp;</td>
									';
								} elseif(in_array(findSectionId($noteSections,"extraMemo"),$noteIds)) {
									$note_html .= '
										<td valign="top" class="note_detail">&nbsp;</td>
									';
								}
								$note_html .= '
									</tr>
								';
							}
						}
								
						$note_html .= '</table>
									</td>
								</tr>
						';
					}

				}
				// [ END ] Extras ----------------------------------------------------------

				// [START] Financials ------------------------------------------------
				if ( in_array(findSectionId($noteSections,"financials"),$noteIds)) {
					$note_exists = true;
					if(!empty($item['financial'])) {
						$note_html .= '
									<tr>
										<td valign="top">Financials</td>
										<td>
											<table width="100%" border="0" cellpadding="2" cellspacing="0" summary="" style="table-layout: fixed; border:1px solid #000000;">
												<tr>
													<td valign="top" class="note_detail txtb" align="right" style="width:40px"> Room</td>
													<td valign="top" class="note_detail txtb" align="right" style="width:130px">Folio/Inv</td>
													<td valign="top" class="note_detail txtb" align="right" tyle="width:120px">Payee</td>
													<td valign="top" class="note_detail txtb" align="right" tyle="width:120px">Total</td>
													<td valign="top" class="note_detail txtb" align="right">Paid</td>
													<td valign="top" class="note_detail txtb" align="right">Total due</td>
												</tr>';
					
							foreach ( $item['financial'] as $financial ) {
								$note_html .= '<tr>
													<td valign="top" class="note_detail" align="right">1</td>
													<td valign="top" class="note_detail" align="right">INV ' . $financial['fn_invoice_ix']. '&nbsp;</td>
													<td valign="top" class="note_detail" align="right">'.$financial['fn_inv_to'].'&nbsp;</td>
													<td valign="top" class="note_detail" align="right">'.$financial['total']. '&nbsp;' . $financial['fn_inv_curr']. '</td>
													<td valign="top" class="note_detail" align="right">'.$financial['paid']. '&nbsp;' . $financial['fn_inv_curr']. '</td>
													<td valign="top" class="note_detail" align="right">'.$financial['due']. '&nbsp;' . $financial['fn_inv_curr']. '</td>
												</tr>';
							}
					
						$note_html .= '	</table>
										</td>
									</tr>
									';
						}
				}
				// [ END ] Financials ------------------------------------------------

		

			
				$note_html .= '</table>';
			}
			if ( $note_exists ) {
				$html .= $note_html;
			}
		}
	}
	return $html;
}

function generateLegend($chartSections,$chartIds,$data) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$legendIds = $chartIds['legend'];

	$legend = '';
	$legendArrayRoom = array();
	$legendArrayDepart = array();
	$legendArrayRoomShow = array();
	$legendArrayDepartShow = array();

	foreach ( $data['rows'] as $row )	{
		foreach ( $data['columns'] as $col ) {
			$c = isset($data['room'][$row['id']][$col['id']]) ? $data['room'][$row['id']][$col['id']] : "";
			$d = isset($data['depart'][$row['id']][$col['id']]) ? $data['depart'][$row['id']][$col['id']] : "";

			foreach ( $showIds as $showId ) {
				if ( in_array($showId,$legendIds) ) {
	
					if ( isset($c[$showId]['value']) && !is_array($c[$showId]['value']) ) {
						if ( in_array($showId,$colourIds) && isset($c[$showId]['colour']) && $c[$showId]['colour'] != "" ) {
							$colour = "#" . $c[$showId]['colour'];
							$key = $c[$showId]['value'];
							$legendArrayRoom[$key] = $colour;
							if ( !isset($legendArrayRoomShow[$key]) || !is_array($legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = array();
							}
							if ( !in_array($showId,$legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = $showId;
							}
						}
					}
				}
			}

			foreach ( $departIds as $departId ) {
				if ( in_array($departId,$legendIds) ) {
					if ( isset($d[$departId]['value']) && !is_array($d[$departId]['value']) ) {
						if ( in_array($departId,$colourIds) && isset($d[$departId]['colour']) && $d[$departId]['colour'] != "" ) {
							$colour	= "#" . $d[$departId]['colour'];
							$key		= $d[$departId]['value'];
							$legendArrayDepart[$key] = $colour;
							if ( !isset($legendArrayDepartShow[$key]) || !is_array($legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = array();
							}
							if ( !in_array($departId,$legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = $departId;
							}
						}
					}
				}
			}
		}
	}

	$merged		= array_merge($legendArrayRoom,$legendArrayDepart);
	$mergedShow	= array_merge($legendArrayRoomShow,$legendArrayDepartShow);
	asort($mergedShow);

	$thisSection = "";
	foreach ( $mergedShow as $description => $section ) {
		if ( $thisSection != $section ) {
			$thisSection = $section;
			$legend .= '<div style="clear: both; margin: 0px 2px;" class="bt"><strong>' . $chartSections[$section-1]['label'] . '(s):</strong></div>';
		}

		$legend .= '
			<div style="float: left; width: 250px; margin: 2px;">
				<table width="250" border="0" cellpadding="0" cellspacing="0" summary="" style="table-layout: fixed;">
					<col style="width:20px" />
					<col style="width:230px" />
					<tr>
						<td class="bAll" style="background-color: ' . $merged[$description] . ';">&nbsp;</td>
						<td>&nbsp;' . $description . '</td>
					</tr>
				</table>
			</div>
		';
	}
	$legend .= '<hr style="clear: both; margin: 0; height:1px; visibility: hidden;" />';
	return $legend;
}

function outputHTML($chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$autoRoom,$data, $showCatExtras, $noteHeader) {
	$GLOBALS['temp']['showResults']   = '';
	$GLOBALS['temp']['displayChart']  = '';
	$GLOBALS['temp']['displayNotes']  = '';
	$GLOBALS['temp']['displayLegend'] = '';

	if ($showChart  == '2') {
		$GLOBALS['temp']['displayChart']  = "collapse printCollapse";
		$GLOBALS['temp']['totalRows'] = "0";
	} else {
		if($data['chart']['sep_asd'] == '3') {
			$GLOBALS['temp']['rows']   = generateChartAsTables($chartSections,$chartIds,$data['chart'],$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$autoRoom, $showCatExtras,$showEmptyRooms);
		} else {
			$GLOBALS['temp']['rows']   = generateChart($chartSections,$chartIds,$data['chart'],$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$autoRoom, $showCatExtras,$showEmptyRooms);
		}
	}

	if ($showNotes  == '2') {
		$GLOBALS['temp']['displayNotes']  = "collapse printCollapse";
	} else {
		$GLOBALS['temp']['notes']  = generateNotes($noteSections,$noteIds,$data['notes'],$noteSort, $noteHeader);
	}

	if ($showLegend == '2' || $showChart  == '2') {
		$GLOBALS['temp']['displayLegend'] = "collapse printCollapse";
	} else {
		$GLOBALS['temp']['legend'] = generateLegend($chartSections,$chartIds,$data['chart']);
	}

	$GLOBALS['temp']['notes']  = generateNotes($noteSections,$noteIds,$data['notes'],$noteSort, $noteHeader);
	$GLOBALS['temp']['legend'] = generateLegend($chartSections,$chartIds,$data['chart']);
}

function createHeaderPDF($detailIds, $chartSections, $rowSpans, $totalSubCell) {
	$tempCell = array();
	$styleFlag = 1;
	$cellwidth   = 10;
	foreach ( $detailIds as $departId ) {
		$sectionId = 0;
		$repFlag = 0;
		if($styleFlag == 1) {
			$styleId = "LRT";
		} else if($styleFlag == $totalSubCell) {
			$styleId = "LRB";
		} else {
			$styleId = "LR";
		}

		$typeId = getDetailType($departId, $chartSections);
		if($typeId == 1) {
			if($departId == findSectionId($chartSections,"extras") || $departId == findSectionId($chartSections,"extraNote") || $departId == findSectionId($chartSections,"extraMemo")){
				$descId = findSectionId($chartSections,"extras");
				$noteId = findSectionId($chartSections,"extraNote");
				$memoId = findSectionId($chartSections,"extraMemo");
			} else {
				$descId = findSectionId($chartSections,"travel");
				$noteId = findSectionId($chartSections,"travelNote");
				$memoId = findSectionId($chartSections,"travelMemo");
			}
		}
				
		foreach ( $chartSections as $item ) {
			if ( $item['id'] == $departId ) {
				if ($typeId == 1){
					for ( $count = 0; $count < $rowSpans[ $departId]; $count++ ) {
						if($departId == $descId) {
							if(in_array($departId, $detailIds)) {
								$label = $chartSections[$sectionId]['header'] !=''?$chartSections[$sectionId]['header']:$chartSections[$sectionId]['label'];
								if ( mb_strlen($label) > MAX_CHAR_PDF ) {
									$label = substr($label,0,MAX_CHAR_PDF) . "..";
								}

								$cell = array('width'=>$cellwidth.'%', 'data'=>$label, 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
							if(in_array($noteId, $detailIds)) {
								if($styleFlag+1 == $totalSubCell) {
									$styleId = "LRB";
								}
								$label = $chartSections[$sectionId+1]['header'] !=''?$chartSections[$sectionId+1]['header']:$chartSections[$sectionId+1]['label'];
								if ( mb_strlen($label) > MAX_CHAR_PDF ) {
									$label = substr($label,0,MAX_CHAR_PDF) . "..";
								}
																		
								$cell = array('width'=>$cellwidth. '%', 'data'=>$label, 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
							if(in_array($memoId, $detailIds)) {
								if($styleFlag+2 == $totalSubCell) {
									$styleId = "LRB";
								}
								$label = $chartSections[$sectionId+2]['header'] !=''?$chartSections[$sectionId+2]['header']:$chartSections[$sectionId+1]['label'];
								if ( mb_strlen($label) > MAX_CHAR_PDF ) {
									$label = substr($label,0,MAX_CHAR_PDF) . "..";
								}
																			
								$cell = array('width'=>$cellwidth. '%','data'=>$label, 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
							$repFlag = 1;
						}
						else if(($departId == $noteId) && $repFlag == 0) {
							if(in_array($departId, $detailIds)) {
								$label = $chartSections[$sectionId]['header'] !=''?$chartSections[$sectionId]['header']:$chartSections[$sectionId]['label'];
								if ( mb_strlen($label) > MAX_CHAR_PDF ) {
									$label = substr($label,0,MAX_CHAR_PDF) . "..";
								}
								$cell = array('width'=>$cellwidth . '%','data'=>$label, 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
							if(in_array($memoId, $detailIds)) {
								if($styleFlag+1 == $totalSubCell) {
									$styleId = "LRB";
								}
								$label = $chartSections[$sectionId+1]['header'] !=''? $chartSections[$sectionId+1]['header'] : $chartSections[$sectionId+1]['label'];
								if ( mb_strlen($label) > MAX_CHAR_PDF ) {
									$label = substr($label,0,MAX_CHAR_PDF) . "..";
								}
								$cell = array('width'=>$cellwidth . '%','data'=>$label, 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
							$repFlag = 1;
						}
						else if(($departId == $memoId) && $repFlag == 0) {
							if(in_array($departId, $detailIds)) {
								$label = $chartSections[$sectionId]['header'] !=''? $chartSections[$sectionId]['header'] : $chartSections[$sectionId]['label'];
								if ( mb_strlen($label) > MAX_CHAR_PDF ) {
									$label = substr($label,0,MAX_CHAR_PDF) . "..";
								}
								$cell = array('width'=>$cellwidth . '%', 'data'=>$label, 'border'=>$styleId);
								array_push($tempCell, $cell);
							}
							
							$repFlag = 1;
						}
						$styleFlag++;
					}
						
				} else {
					$label = $item['header'] !=''? $item['header'] : $item['label'];
					if ( mb_strlen($label) > MAX_CHAR_PDF ) {
						$label = substr($label,0,MAX_CHAR_PDF) . "..";
					}
					$cell = array('width'=>$cellwidth . '%','data'=>$label,'border'=>$styleId);
					array_push($tempCell, $cell);
														
					if ( $rowSpans[$departId] > 1 ) {
						for ( $count = 1; $count < $rowSpans[$departId]; $count++ ){
							$cell = array('width'=>$cellwidth.'%','data'=>'','border'=>$styleId);
							array_push($tempCell, $cell);
							$styleFlag++;
						}
					}
				}
												
				if($item['id']== findSectionId($chartSections,"travelMemo")){
					$repFlag = 0;
				}
			}
			$sectionId++;
		}
		if($typeId == 0){
			$styleFlag++;
		}
	} 
	return $tempCell;
}

function createRoomDetailsPDF($chartIds, $data, $chartSections, $flag, $rowId, $colId) {
	$tempArr = array();
	$cellwidth   = 10;
	$initialColour	  = array(0xff,0xff,0xff);
	$initialFontColour  = array(0x00,0x00,0x00);
	
	$detailIds = $chartIds[$flag];
	$colourIds = $chartIds['colour'];
	$c = isset($data[$flag][$rowId][$colId]) ? $data[$flag][$rowId][$colId] : "";
	$b = isset($data['block'][$rowId][$colId]) ? $data['block'][$rowId][$colId] : "";
	
	if ( $b != "" ) {
		$initialColour = array(0xc0,0xc0,0xc0);
	}
	
	$rowSpan = getRowSpans($data,$flag,$detailIds);
	$rowSpans = $rowSpan[$rowId];
	$totalSubCell = array_sum($rowSpans);
	
	$roomInformation = '';
	$first = true;
	$repFlag = 0;
	$styleFlag = 1;
			
	foreach ( $detailIds as $showId ) {
		
		$typeId = getDetailType($showId, $chartSections);
		if($typeId == 1) {
			if($showId == findSectionId($chartSections,"extras") || $showId == findSectionId($chartSections,"extraNote") || $showId == findSectionId($chartSections,"extraMemo")){
				$descId = findSectionId($chartSections,"extras");
				$noteId = findSectionId($chartSections,"extraNote");
				$memoId = findSectionId($chartSections,"extraMemo");
			} else {
				$descId = findSectionId($chartSections,"travel");
				$noteId = findSectionId($chartSections,"travelNote");
				$memoId = findSectionId($chartSections,"travelMemo");
			}
		}

		$colour			= $initialColour;
		$fontColour = $initialFontColour;

		// Provisional booking
		if ( $c['rf_reservation_status_id'] == 20 ) {
			$fontColour = array(0x33,0x66,0x99);
		}

		// Provisional expiring today
		if ( $c['rv_provision_expiry_date'] == date('Y-m-d') )  {
			$colour = array(0xf1,0xc5,0x5d);
			$fontColour = array(0x00,0x00,0x00);
		}

		// Allocation
		if ( $c['rf_reservation_status_id'] == 15 ) {
			$fontColour = array(0x99,0x99,0x99);
		}

		if($styleFlag == 1) {
			$border = "LRT";
		} else if ($styleFlag == $totalSubCell) {
			$border = "LRB";
		} else {
			$border = "LR";
		}

		if ( !is_array($c[$showId]['value']) ) {
			// [START] Colour handling ----------------------------------------------
			if ( in_array($showId,$colourIds) && $c[$showId]['colour'] != '' ) {
				$colour = array( 
					hexdec(substr($c[$showId]['colour'],0,2)),
					hexdec(substr($c[$showId]['colour'],2,2)),
					hexdec(substr($c[$showId]['colour'],4,2))
				);
			}
			if ( $error ) {
				$colour		= array(0xdb,0x42,0x42);
				$fontColour = array(0xff,0xff,0xff);
			}
			// [ END ] Colour handling ----------------------------------------------
			
						
			$dep_data = mb_strlen($c[$showId]['value'])>MAX_CHAR_PDF?substr($c[$showId]['value'],0,MAX_CHAR_PDF) :$c[$showId]['value'];
							
			$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> 1, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
						
			array_push($tempArr, $cell);

		} else {
			$used = 0;
			if ($typeId == 1){
				if($showId == findSectionId($chartSections,"extras")) {
					$repFlag = 0;
				} else if(!in_array(findSectionId($chartSections,"extras"),$detailIds) && $showId == findSectionId($chartSections,"extraNote")) {
					$repFlag = 0;
				}
				else if(!in_array(findSectionId($chartSections,"extras"),$detailIds) && !in_array(findSectionId($chartSections,"extraNote"),$detailIds) && $showId == findSectionId($chartSections,"extraMemo")) {
						$repFlag = 0;
				}

				for ( $count = 0; $count < $rowSpans[$showId]; $count++ ) {
					$cellItem	  = isset($c[$showId]['value'][$count]) ? $c[$showId]['value'][$count] : array();
					$cellItemNote = isset($c[$showId+1]['value'][$count]) ? $c[$showId+1]['value'][$count] : array();
					$cellItemMemo = isset($c[$showId+2]['value'][$count]) ? $c[$showId+2]['value'][$count] : array();

					if ( $first && $error == true ) {
							$cellItem['value'] = $errorDesc . ' ' . $cellItem['value'];
					}

					// [START] Colour handling ---------------------------------------------
					if ( in_array($showId,$colourIds) && $cellItem['colour'] != '' ) {
						$colour = array( 
						 hexdec(substr($cellItem['colour'],0,2)),
						 hexdec(substr($cellItem['colour'],2,2)),
						 hexdec(substr($cellItem['colour'],4,2))
						);
					}
					if(!empty($colour)) {
						$fill = 1;
					}
					// [ END ] Colour handling --------------------------------------------
												
					if($showId == $descId) {
						if(in_array($showId, $detailIds)) {
							$dep_data = !empty($cellItem['value']) ? ( mb_strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'] ) : "qqq";
										
							$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
							array_push($tempArr, $cell);
						}
						if(in_array($noteId, $detailIds)) {
							if($styleFlag+1 == $totalSubCell) {
								$border = "LRB";
							}
							$dep_data = !empty($cellItemNote['value']) ? ( mb_strlen($cellItemNote['value'])>MAX_CHAR_PDF?substr($cellItemNote['value'],0,MAX_CHAR_PDF):$cellItemNote['value'] ) : "qqq";
							
							$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
							array_push($tempArr, $cell);
						}
						if(in_array($memoId, $detailIds)) {
							if($styleFlag+2 == $totalSubCellDepart) {
								$border = "LRB";
							}
							$dep_data = !empty($cellItemMemo['value']) ? ( mb_strlen($cellItemMemo['value'])>MAX_CHAR_PDF?substr($cellItemMemo['value'],0,MAX_CHAR_PDF):$cellItemMemo['value'] ) : "qqq";
											
							$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
							array_push($tempArr, $cell);
						}
						$repFlag = 1;

					}
					else if(($showId == $noteId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$dep_data = !empty($cellItem['value']) ? ( mb_strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'] ) : "qqq";
											
							$cell = array('width'=>$cellwidth. '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
							array_push($tempArr, $cell);
						}
						if(in_array($memoId, $detailIds)) {
							if($styleFlag+1 == $totalSubCellDepart) {
								$border = "LRB";
							}
							$dep_data = !empty($cellItemNote['value']) ? ( mb_strlen($cellItemNote['value'])>MAX_CHAR_PDF?substr($cellItemNote['value'],0,MAX_CHAR_PDF):$cellItemNote['value'] ) : "qqq";
							
							$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
							array_push($tempArr, $cell);
						}
						$repFlag = 1;
					}
					else if(($showId == $memoId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$dep_data = !empty($cellItem['value']) ? ( mb_strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'] ) : "qqq";
										
							$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> $fill, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
							array_push($tempArr, $cell);
						}
						$repFlag = 1;
					}
					$styleFlag++;
				}

			} else {
				foreach ( $c[$showId]['value'] as $cellItem ) {
					// [START] Colour handling -----------------------------------------
					if ( in_array($departId,$colourIds) && $cellItem['colour'] != "" ) {
						$colour = array( 
								 hexdec(substr($cellItem['colour'],0,2)),
								 hexdec(substr($cellItem['colour'],2,2)),
								 hexdec(substr($cellItem['colour'],4,2))
								);
					}
					if ( $error ) {
						$colour	= array(0xdb,0x42,0x42);
						$fontColour	= array(0xff,0xff,0xff);
					}
					// [ END ] Colour handling -----------------------------------------
						
					$dep_data = !empty($cellItem['value']) ? ( mb_strlen($cellItem['value'])>MAX_CHAR_PDF?substr($cellItem['value'],0,MAX_CHAR_PDF):$cellItem['value'] ) : "qqq";
					
					$cell = array('width'=>$cellwidth . '%','data'=>$dep_data,'border'=>$border, 'fill'=> 1, 'fillColor'	=> $colour, 'textColor'	=> $fontColour);
			
					array_push($tempArr, $cell);
					$used++;
				}
				if ( $used < $rowSpans[$showId] ) {
					for ( $count = 0; $count < ($rowSpans[$showId] - $used); $count++ ) {
						$cell = array('width'=>$cellwidth . '%','data'=>'', 'border'=>$border);
						array_push($tempArr, $cell);
					}
				}
			}
			
			$first = false;
		}
		if($typeId == 0 || !is_array($c[$showId]['value'])){
			$styleFlag++;
		}
	}
	return $tempArr;
}

function generatePDFNotes($noteSections,$noteIds,$notes,$noteSort, $notesHeader) {

	$pdfRow	   = array();
	$pdfNotes	 = array();
	$pdfNoteArray = array();

	$cellwidth   = '20';
	$x_cellwidth = '8';

	// debug($noteIds);
	// debug($noteSections);
	// debug($notes);

	/* ---------------------------------------------------------------------------
	ORDER FOR NOTES:
	Itinerary Summary
	Notes
	Memos
	Guest information
	Guest Details
	Extras
	Extras notes
	Extras memos
	Travel
	Travel notes
	Travel memos
	Room lock reason
	---------------------------------------------------------------------------	*/

	if ( count($notes) > 0 ) {
		$mainColHeading = genrateNotesHeader($noteSort, $notesHeader);
		
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[0],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[1],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[2],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[3],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$mainColHeading[3],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));

		array_push($pdfNotes,$pdfRow);
		array_push($pdfNoteArray,$pdfNotes);
		$pdfRow = array();
	
		$first_note = true;
		foreach ( $notes as $item ) {
			// Used to suppress reservations with no notes --------------------
			$note_exists = false;
			$pdfNotes = array();
			if ( count($item) > 0 ) {
				/* ------------------------------------------------------------
					TITLE SORT ORDER
					1: Arrival date
					2: Departure date
					3: Reservation ID
					4: Reservation name
					4: Property
				------------------------------------------------------------ */
				
				$title = genrateNotesHeader($noteSort, $notesHeader, 0, $item);
				
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[0],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[1],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[2],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[3],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));
				array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>$title[4],'border'=>'LTRB', 'style' => 'B', 'fill' => '1'));

				array_push($pdfNotes,$pdfRow);
				$pdfRow = array();
				$first_note = false;

				// [START] Itinerary Summary -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"itinerarySum"),$noteIds) ) {
					if ( isset($item['rv_note_general']) && $item['rv_note_general'] != "" ) {
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Itinerary summary','border'=>'LTR'));

						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Room', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Arrive', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Depart', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Night', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%','data'=>'Property', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%','data'=>'Accomm', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Rms', 'border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Ad','border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Chld','border'=>'LTRB', 'style' =>'B'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
						foreach ( $item['itinerary'] as $itinerary ) {
							array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LR'));
							array_push($pdfRow,array('width'=>$x_cellwidth .'%', 'data'=>$itinerary['room'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth .'%', 'data'=>$itinerary['resArrive'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$itinerary['resDepart'] , 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$itinerary['nights'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%', 'data'=>$itinerary['propName'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%', 'data'=>$itinerary['accom'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$itinerary['rooms'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$itinerary['adults'], 'border'=>'LTRB'));
							array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$itinerary['childs'], 'border'=>'LTRB'));
							array_push($pdfNotes,$pdfRow);
							$pdfRow = array();
						}
					}
				} 
				// [ END ] Itinerary Summary -----------------------------------------------


				// [START] Reservation Notes -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNote"),$noteIds) ) {
					if ( $item['rv_note_general'] != '' ) {
						$note_exists = true;

						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Notes', 'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 4) . '%', 'data'=>$item['rv_note_general'], 'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Reservation Notes -----------------------------------------------

				// [START] Internal Memos --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resMemo"),$noteIds) ) {
					if ( isset($item['rv_note_internal']) && trim($item['rv_note_internal']) != "" ) {
						$note_exists = true;

						//array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Memos','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 4) . '%','data'=>$item['rv_note_internal'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Internal Memos --------------------------------------------------

				// [START] Guest information -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					if ( isset($item['rv_note_guests']) && trim($item['rv_note_guests']) != "" ) {
						$note_exists = true;
						//array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest information','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 4) . '%','data'=>$item['rv_note_guests'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Guest information -----------------------------------------------
				
				// [START] Guest Details --------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && !empty($item['guests'])) {
					array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Guest details', 'border'=>'LTR'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Room','border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Guest name', 'border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Nationality', 'border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Last Dep','border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Visits', 'border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'B-day', 'border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Anniv','border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%','data'=>'Notes','border'=>'LTRB', 'style' =>'B'));
					array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%','data'=>'Memos','border'=>'LTRB', 'style' =>'B'));
					array_push($pdfNotes,$pdfRow);
					$pdfRow = array();
					foreach ( $item['guests'] as $guests ) {
						$birthFill = 0;
						$birthColor = array(0xff,0xff,0xff);
						$annFill = 0;
						$annColor = array(0xff,0xff,0xff);
						if($guests['has_birthday'] == 1) {
							$birthFill = 1;
							$birthColor = array(0x8d,0x9c,0xe7);
						}
						if($guests['has_anniversary'] == 1) {
							$annFill = 1;
							$annColor = array(0x8d,0x9c,0xe7);
						}
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LR'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'1','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$guests['pr_name'], 'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$guests['nationality'], 'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$guests['last_depart'], 'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$guests['total_visit'], 'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$x_cellwidth .'%', 'data'=>$guests['pr_birthdate'], 'border'=>'LTRB', 'fill' =>$birthFill, 'fillcolor'=>$birthColor));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$guests['pr_anniversary'], 'border'=>'LTRB', 'fill' =>$annFill, 'fillcolor'=>$annColor));
						array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%', 'data'=>$guests['pr_guest_note'], 'border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$x_cellwidth*1.5 . '%', 'data' => $guests['pr_guest_memo'], 'border'=>'LTRB'));
						
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}

					
				}
				
				// [ END ] Guest specific information -------------------------

				// [START] Nationality -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNationality"),$noteIds) ) {
					if ( isset($item['nationality']) && trim($item['nationality']) != "" ) {
						$note_exists = true;
						//array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Res nationality','border'=>'LTRB'));
						array_push($pdfRow,array('width'=>($cellwidth * 4) . '%','data'=>$item['nationality'],'border'=>'LTRB'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Nationality -----------------------------------------------
				
							
				// [START] Extras ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
					
					if(!empty($item['extras']) || !empty($item['travel'])) {
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Extras','border'=>'LTR'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Room','border'=>'LTRB', 'style' =>'B'));
						
						array_push($pdfRow,array('width'=>$x_cellwidth/2 . '%','data'=>'Travel','border'=>'LTRB', 'style' =>'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth/2 . '%','data'=>'Qty','border'=>'LTRB', 'style' => 'B', 'align' => 'C'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Date','border'=>'LTRB', 'style' => 'B'));
						
						array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Category','border'=>'LTRB', 'style' => 'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%','data'=>'Description','border'=>'LTRB', 'style' => 'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%','data'=>'Notes','border'=>'LTRB', 'style' => 'B'));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%','data'=>'Memos','border'=>'LTRB', 'style' => 'B'));
						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					
						if(!empty($item['extras'])) {
							foreach ( $item['extras'] as $extra ) {
								$extra_category_data =  array('width'=>$x_cellwidth*2 .'%', 'data'=>'', 'border'=>'LTRB');
								if ( in_array(findSectionId($noteSections,"extras"),$noteIds) ) {
									$extra_category_data =  array('width'=>$x_cellwidth*2 . '%', 'data'=>$extra['ac_ext_desc'], 'border'=>'LTRB');
								}

								$extras_note_data = array('width'=>$x_cellwidth*2 . '%', 'data'=>'', 'border'=>'LTRB');
								if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) ) {
									$extras_note_data = array('width'=>$x_cellwidth*2 .'%', 'data'=>$extra['rv_extra_note'], 'border'=>'LTRB');
								}

								$extras_memos_data = array('width'=>$x_cellwidth*2 . '%', 'data'=>'', 'border'=>'LTRB');
								if ( in_array(findSectionId($noteSections,"extraMemo"),$noteIds) ) {
									$extras_memos_data = array('width'=>$x_cellwidth*2 .'%', 'data'=>$extra['rv_extra_note_internal'], 'border'=>'LTRB');
								}

								array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'', 'border'=>'LR'));
								array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$extra['ac_desc'], 'border'=>'LTRB'));
								array_push($pdfRow,array('width'=>$x_cellwidth/2 . '%', 'data'=>'', 'border'=>'LTRB'));
								array_push($pdfRow,array('width'=>$x_cellwidth/2 . '%', 'data'=>$extra['rv_extra_units'], 'border'=>'LTRB', 'align'=>'C'));
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$extra['rv_extra_date_serv'], 'border'=>'LTRB'));
								
								array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$extra['ac_extra_cat_desc'], 'border'=>'LTRB'));
								array_push($pdfRow, $extra_category_data);
								array_push($pdfRow, $extras_note_data);
								array_push($pdfRow, $extras_memos_data);
								
								array_push($pdfNotes, $pdfRow);
								$pdfRow = array();
							}
						}
						if(!empty($item['travel'])) {
							foreach ( $item['travel'] as $travel ) {
								$travel_category_data =  array('width'=>$x_cellwidth*2 . '%', 'data'=>'', 'border'=>'LTRB');
								if ( in_array(findSectionId($noteSections,"travel"),$noteIds) ) {
									$travel_category_data =  array('width'=>$x_cellwidth*2 . '%', 'data'=>$travel['ac_ext_desc'], 'border'=>'LTRB');
								}

								$travel_note_data = array('width'=>$x_cellwidth*2 . '%', 'data'=>'', 'border'=>'LTRB');
								if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) ) {
									$travel_note_data = array('width'=>$x_cellwidth*2 .'%', 'data'=>$travel['rv_extra_note'], 'border'=>'LTRB');
								}
															
								$travel_memos_data = array('width'=>$x_cellwidth*2 . '%', 'data'=>'', 'border'=>'LTRB');
								if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
									$travel_memos_data = array('width'=>$x_cellwidth*2 .'%', 'data'=>$travel['rv_extra_note_internal'], 'border'=>'LTRB');
								}
															
								array_push($pdfRow,array('width'=>$cellwidth .'%','data'=>'','border'=>'LR'));
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['ac_desc'], 'border'=>'LTRB'));
								array_push($pdfRow,array('width'=>$x_cellwidth/2 . '%','data'=>'Yes','border'=>'LTRB'));
								array_push($pdfRow,array('width'=>$x_cellwidth/2 . '%','data'=>$travel['rv_extra_units'],'border'=>'LTRB', 'align'=>'C'));
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['rv_extra_date_serv'], 'border'=>'LTRB'));
								array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>$travel['ac_extra_cat_desc'], 'border'=>'LTRB'));
								array_push($pdfRow, $travel_category_data);
								array_push($pdfRow, $travel_note_data);
								array_push($pdfRow, $travel_memos_data);
								
								array_push($pdfNotes, $pdfRow);
								$pdfRow = array();
							}
						}
					}
				}

				// [START] Financials ------------------------------------------------
				if ( in_array(findSectionId($noteSections,"financials"),$noteIds) && !empty($item['financial'] )) {
					array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Financials', 'border'=>'LTR'));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Room','border'=>'LTRB', 'style' =>'B', align=>"R"));
					array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%', 'data'=>'Folio/Inv', 'border'=>'LTRB', 'style' =>'B', align=>"R"));
					array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%','data'=>'Payee','border'=>'LTRB', 'style' => 'B', align=>"R"));
					array_push($pdfRow,array('width'=>$x_cellwidth . '%','data'=>'Total','border'=>'LTRB', 'style' => 'B', align=>"R"));
					array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%','data'=>'Paid','border'=>'LTRB', 'style' => 'B', align=>"R"));
					array_push($pdfRow, array('width'=>$x_cellwidth*2 . '%','data'=>'Total due', 'border'=>'LTRB', 'style' => 'B', align=>"R"));

					array_push($pdfNotes,$pdfRow);
					$pdfRow = array();

					foreach ( $item['financial'] as $financial ) {
						array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>'LR'));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>'', 'border'=>'LTRB', align=>"R"));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%', 'data'=>'INV '.$financial['fn_invoice_ix'], 'border'=>'LTRB', align=>"R"));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%', 'data'=>$financial['fn_inv_to'], 'border'=>'LTRB', align=>"R"));
						array_push($pdfRow,array('width'=>$x_cellwidth . '%', 'data'=>$financial['total']. ' '. $financial['fn_inv_curr'], 'border'=>'LTRB', align=>"R"));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%', 'data'=>$financial['paid'] . ' ' . $financial['fn_inv_curr'], 'border'=>'LTRB', align=>"R"));
						array_push($pdfRow,array('width'=>$x_cellwidth*2 . '%', 'data'=>$financial['due']. ' ' . $financial['fn_inv_curr'], 'border'=>'LTRB', align=>"R"));

						array_push($pdfNotes,$pdfRow);
						$pdfRow = array();
					}
				}
				// [ END ] Financials -----------------------------------
			}
			if ( $note_exists ) {
				array_push($pdfRow,array('width'=>$cellwidth*5 . '%','data'=>'', 'border'=>'TB'));
				array_push($pdfNotes,$pdfRow);
				$pdfRow = array();
				
				array_push($pdfNoteArray,$pdfNotes);
			}
		}
	}
	return $pdfNoteArray;
}

function generatePDFLegend($chartSections,$chartIds,$data) {
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$legendIds = $chartIds['legend'];

	$legend = '';

	$legendArrayRoom   = array();
	$legendArrayDepart = array();
	$legendArrayRoomShow = array();
	$legendArrayDepartShow = array();

	foreach ( $data['rows'] as $row ) {
		foreach ( $data['columns'] as $col ) {
			$c = isset($data['room'][$row['id']][$col['id']]) ? $data['room'][$row['id']][$col['id']] : "";
			$d = isset($data['depart'][$row['id']][$col['id']]) ? $data['depart'][$row['id']][$col['id']] : "";

			foreach ( $showIds as $showId ) {
				if ( in_array($showId,$legendIds) ) {

					if ( !is_array($c[$showId]['value']) ) {
						if ( in_array($showId,$colourIds) && $c[$showId]['colour'] != "" ) {
							$colour = "#" . $c[$showId]['colour'];
							$key = $c[$showId]['value'];
							$legendArrayRoom[$key] = $colour;
							if ( !is_array($legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = array();
							}
							if ( !in_array($showId,$legendArrayRoomShow[$key]) ) {
								$legendArrayRoomShow[$key] = $showId;
							}
						}
					}
				}
			}

			foreach ( $departIds as $departId ) {
				if ( in_array($departId,$legendIds) ) {
					if ( !is_array($d[$departId]['value']) ) {
						if ( in_array($departId,$colourIds) && $d[$departId]['colour'] != '' ) {
							$colour = '#' . $d[$departId]['colour'];
							$key	= $d[$departId]['value'];
							$legendArrayDepart[$key] = $colour;
							if ( !is_array($legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = array();
							}
							if ( !in_array($departId,$legendArrayDepartShow[$key]) ) {
								$legendArrayDepartShow[$key] = $departId;
							}
						}
					}
				}
			}
		}
	}

	$merged	 = array_merge($legendArrayRoom,$legendArrayDepart);
	$mergedShow = array_merge($legendArrayRoomShow,$legendArrayDepartShow);
	asort($mergedShow);

	$thisSection = '';
	$legendRow = array();
	$pdfLegend = array(
						array(array('width'=>'100%','data'=>'<B>LEGEND</B>','fontSize'=>'8','border'=>'TRL')),
						array(array('width'=>'100%','data'=>'','border'=>'TRL')),
						array(
								array('width'=>'2%','data'=>'','border'=>'L'),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xd0,0xd0,0xd0),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Blocked Room','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0x10,0x7d,0xf8),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Paid','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xff,0x80,0x00),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Part Paid','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xff,0x00,0x00),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'No Payment','border'=>'R')
							),
						array(array('width'=>'100%','data'=>'','border'=>'RL')),
						array(
								array('width'=>'2%','data'=>'','border'=>'L'),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xf1,0xc5,0x5d),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Provisional expiring today','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xdb,0x42,0x42),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Expired provisional','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>array(0xf2,0xf2,0xf2),'border'=>'LTRB'),
								array('width'=>'20%','data'=>'Departure information','border'=>''),
								array('width'=>'2%','data'=>'','border'=>''),
								array('width'=>'23%','data'=>'Provisional reservation','textColor'=>array(0x33,0x66,0x99),'border'=>'R')
							),
						array(array('width'=>'100%','data'=>'','border'=>'BRL'))
					);
	$count = 1;
	foreach ( $mergedShow as $description => $section ) {
		if ( $thisSection != $section ) {
			$thisSection = $section;
			array_push($pdfLegend,array(array('width'=>'100%','data'=>$chartSections[$section-1]['label'] . '(s):','border'=>'TRLB')));
		}

		$colour = array(
						hexdec(substr($merged[$description],1,2)),
						hexdec(substr($merged[$description],3,2)),
						hexdec(substr($merged[$description],5,2))
						);

		array_push($legendRow,array('width'=>'2%','data'=>'','border'=>''));
		array_push($legendRow,array('width'=>'3%','data'=>'','fill'=>1,'fillColor'=>$colour,'border'=>'LTRB'));
		array_push($legendRow,array('width'=>'20%','data'=>$description,'border'=>''));

		if ( $count%4 == 0 ) {
			// Add nice borders for the legend sections -----------------------
			for ( $i = 0; $i < 12; $i++ ) {
				if ( $i == 0 ) {
					$legendRow[$i]['border'] = 'L';
				}
				if ( $i == 11 ) {
					$legendRow[$i]['border'] = 'R';
				}
			}
			array_push($legendRow,array('width'=>'100%','data'=>'','border'=>'RL'));
			array_push($pdfLegend,$legendRow);
			$legendRow = array();
		}
		$count++;
	}
	array_push($pdfLegend,array(array('width'=>'100%','data'=>'','border'=>'T')));

	return $pdfLegend;
}

function outputPDF($renderType,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$data,$fromDate,$toDate,$propertyFilter, $showCatExtras, $noteHeader, $notePdfOrientation) {

	define("MAX_CHAR_PDF",18);
	$cells = array();
	$multiCell = array();
	$tempCell = array();

	if($showNotes == 1 && $notePdfOrientation=='P') {
		$ornt = 'P';
	} else {
		$ornt = 'L';
	}
	$pdf = new PDF("Room report",$ornt);
	$reportLabel = "Room report";
	$pdfFontSize = 6;
	$pdf->SetFont('Arial', '', $pdfFontSize);

	$pdf_chart_data = $data['chart'];

	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];

	$cellwidth   = 10;
	$table_width = 100;
	$max_columns_per_page = 8;
	$number_of_pages = ceil(count($data['chart']['columns'])/($max_columns_per_page));

	$pdfPage = array();
	$row_count = 0;
	if ( $pdf_chart_data['direction'] == "1" ) {
		$pdfRow = array();
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>''));

		//if($pdf_chart_data['detailAs'] == '1') {
			array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>''));
		//}

		// Room names along top
		$property_name   = '';
		$colcount		= 0;
		$current_page	= 0;
		$pdfDataRow	  = $pdfRow;
		$current_property = array();
		foreach ( $pdf_chart_data['columns'] as $col ) {
			$this_cell_width = $colcount * $cellwidth;

			if ( $colcount == $max_columns_per_page ) {
				foreach ( $current_property as $c ) {
					array_push($pdfDataRow,array('width'=>$cellwidth * $c['count'] . '%','data'=>$c['name'],'border'=>'LTRB'));
				}
				
				$pdfPageHeader[0][$current_page] = $pdfDataRow;
				$pdfDataRow	= $pdfRow;
				$current_property = array();
				$property_name = '';
				$colcount	  = 0;
				$current_page++;
			}

			if ( $property_name != $col['property'] ) {
				array_push($current_property,array('name'=>$col['property']));
				$property_name = $col['property'];
			}
			$colcount++;

			if ( count($current_property) > 1 ) {
				$current_property[count($current_property) - 1]['count'] = $colcount - $current_property[count($current_property) - 2]['count'];
			} else {
				$current_property[count($current_property) - 1]['count'] = $colcount;
			}
		}
		$pdfRow = array();
		
		array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>''));
		
		//if($pdf_chart_data['sep_asd'] == '1') {
		//	array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>''));
		//}
		//if($pdf_chart_data['detailAs'] == '1') {
			array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'Details','border'=>'LTRB'));
		//}

		// Room names and numbers ---------------------------------------------
		$colcount	 = 0;
		$current_page = 0;
		$pdfDataRow = $pdfRow;

		$colspn = 1;
		if($pdf_chart_data['sep_asd'] == '2') {
			if($pdf_chart_data['combArrSty'] == '1') {
				$colspn = 2;
			} else {
				$colspn = 3;
			}
		}
		
		$detColspan = 1;
		if($pdf_chart_data['detailAs'] == '2') {
			$detColspan = count($showIds);
		}

		$colspn = $colspn*$detColspan;
		$colspnVal = ($colspn>1)?$colspn:1;


		foreach ( $pdf_chart_data['columns'] as $col ) {
			if ( $colcount == $max_columns_per_page ) {
				$pdfPageHeader[1][$current_page] = $pdfDataRow;
				$pdfDataRow = $pdfRow;
				$colcount = 0;
				$current_page++;
			}

			if ( $hideAccommType == "1" ) {
				$accommCell = "";
			} else {
				$accommCell = $col['accommodation'];
			}				
			if ( $showUnitLabel == "1" ) {
				$accommCell .= "
" . $col['unit_label'];
			}
			if ( $showUnitNumber == "1" ) {
				$accommCell .= "
" . $col['room'];
			}
			array_push($pdfDataRow,array('width'=>$cellwidth.'%','data'=>$accommCell,'border'=>'LTRB'));
			$colcount++;
		} 
		
	} else {
		// Dates along top
		$pdfRow = array();
		array_push($pdfRow,array('width'=>$cellwidth .  '%','data'=>'','border'=>'LTRB'));
		array_push($pdfRow,array('width'=>$cellwidth .  '%','data'=>'Details','border'=>'LTRB'));

		$colcount	 = 0;
		$current_page = 0;
		$pdfDataRow = $pdfRow;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			if ( $colcount == $max_columns_per_page ) {
				$pdfPageHeader[0][$current_page] = $pdfDataRow;
				$pdfDataRow = $pdfRow;
				$colcount = 0;
				$current_page++;
			}

			$thisDate = explode("-",$col['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
			$dateRow = $displayDate . " " . $col['name'];
			if ( $showDatePAX == "1" ) {
				$dateRow .= "
PAX " . $col['pax_total'] . " (Ad:" . $col['pax_adult'] . " Ch:" . $col['pax_child'] . ")";
			}
			array_push($pdfDataRow,array('width'=>$cellwidth .  '%','data'=>$dateRow,'border'=>'LTRB'));
			$colcount++;
		}
	}
	$rowCount = 3;
	$roomRowSpans	= getRowSpans($pdf_chart_data,"room",$showIds);
	$departRowSpans	= getRowSpans($pdf_chart_data,"depart",$departIds);
	$stayOverRowSpans	= getRowSpans($pdf_chart_data,"stayOver",$stayOverIds);
	
	$showDepartureInfo = true;

	if ( $pdf_chart_data['direction'] == '2' ) {
		$property_name	= '';
	}

	foreach ( $pdf_chart_data['rows'] as $row ) {
		$pdfRow = array();
		
		$totalSubCellRoom = (!empty($roomRowSpans[$row['id']]))?max($roomRowSpans[$row['id']]):1;
		$totalSubCellDepart = (!empty($departRowSpans[$row['id']]))?max($departRowSpans[$row['id']]):1;
		$totalSubCellStayOver = (!empty($stayOverRowSpans[$row['id']]))?max($stayOverRowSpans[$row['id']]):1;
		$multiCell[$rowCount] = array();

		if ( $pdf_chart_data['direction'] == "1" ) {
			$thisDate = explode("-",$row['id']);
			$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		}

		// Place the property name
		if ( $pdf_chart_data['direction'] == "2" ) {
			if ( $property_name != $row['property'] ) {
				$property_name = $row['property'];
				for ( $i = 0; $i < $number_of_pages; $i++ ) {
					$pdfPage[$row_count][$i] = array(array('width'=>$table_width . '%','data'=>$property_name,'border'=>'LTRB'));
				}
				$row_count++;
			}
		}

		//$pdfRow = array();
		// [START] Room information row ---------------------------------------------
		if ( $pdf_chart_data['direction'] == "1" ) {
			if($pdf_chart_data['combArrSty'] == '1') {
				$combination = "Inhouse";
			} else {
				$combination = "Arrival";
			}
			
			$roomInfo = $displayDate . '' . $row['name'];
			if ( $showDatePAX == "1" ) {
				$paxCount = "PAX " . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
			}

			$cell = array('width'=>$cellwidth . '%','data'=>$combination, 'border'=>'LRT');
			array_push($tempCell, $cell);
			$cell = array('width'=>$cellwidth . '%','data'=>$roomInfo, 'border'=>'LR');
			array_push($tempCell, $cell);
			
			$cell = array('width'=>$cellwidth . '%','data'=>$paxCount, 'border'=>'LR');
			array_push($tempCell, $cell);
			for($count=4; $count<=$totalSubCellRoom;$count++) {
				if($count == $totalSubCellRoom) {
					$styleId = 'LRB';
				} else {
					$styleId = 'LR';
				}
				$cell = array('width'=>$cellwidth . '%','data'=>'','border'=>$styleId);
				array_push($tempCell, $cell);
			}
			array_push($multiCell[$rowCount], $tempCell);

		} else {
			if ( $hideAccommType == "1" ) {
				$roomInfo = "";
			} else {
				$roomInfo = $row['accommodation'];
			}				
			if ( $showUnitLabel == "1" ) {
				$roomInfo .= "
" . $row['unit_label'];
			}
			if ( $showUnitNumber == "1" ) {
				$roomInfo .= "
" . $row['room'];
			}
			$roomInfo = $row['property'] . "
" . $roomInfo;
		}
		array_push($pdfRow, $tempCell);
		
		// [START] Room data headings -----------------------------------------
		$tempCell = array();
		$tempCell = createHeaderPDF($showIds, $chartSections, $roomRowSpans[$row['id']], $totalSubCellRoom);

		array_push($multiCell[$rowCount], $tempCell);
		array_push($pdfRow, $tempCell);
		$tempCell = array();
		
		// [ END ] Room data headings -----------------------------------------

		// [START] Room information -------------------------------------------
		$column_count = 0;
		$current_page = 0;
		$pdfDataRow = $pdfRow;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			if ( $column_count == $max_columns_per_page ) {
				$pdfPage[$current_page][$row_count] = $pdfDataRow;
				$pdfDataRow = $pdfRow;
				$column_count = 0;
				$current_page++;
			}

			$tempCell = createRoomDetailsPDF($chartIds, $pdf_chart_data, $chartSections, 'room', $row['id'], $col['id']);

			array_push($multiCell[$rowCount], $tempCell);
			array_push($pdfDataRow, $tempCell);
			$tempCell = array();

			$column_count++;
		}

		// [ START ] Display stay over informatyion ---------------------------------
		if($pdf_chart_data['sep_asd'] != '2') {
			$stayOverInfoExists = false;
			$bool_stayOver = false;
			$tempCell = array();
			$pdfRow = array();
			if($pdf_chart_data['combArrSty'] == '2') {
				// [START] Stay Over information row ---------------------------------
				foreach ( $pdf_chart_data['columns'] as $col ) {
					$d = isset($pdf_chart_data['stayOver'][$row['id']][$col['id']]) ? $pdf_chart_data['stayOver'][$row['id']][$col['id']] : array();
					if ( is_array($d) && count($d) > 0  ) {
						foreach ( $d as $blah ) {
							if ( isset($blah['value']) && $blah['value'] != "" ) {
								$stayOverInfoExists = true;
							}
						}
					}
				}
			
				if ( count($stayOverIds) > 0 && $stayOverInfoExists) {
					$bool_stayOver = true;
					if ( $pdf_chart_data['direction'] == "1" ) {
						$roomInfo = $displayDate . " " . $row['name'];
						$cell = array('width'=>$cellwidth . '%','data'=>'Stay Over','border'=>'LRT');
						array_push($tempCell, $cell);
						$cell = array('width'=>$cellwidth .  '%','data'=>$roomInfo,'border'=>'LR');
						array_push($tempCell, $cell);
										
						for($count=3; $count<=$totalSubCellStayOver;$count++) {
							if($count == $totalSubCellStayOver) {
								$styleId = 'LRB';
							} else {
								$styleId = 'LR';
							}
							$cell = array('width'=>$cellwidth . '%','data'=>'','border'=>$styleId);
							array_push($tempCell, $cell);
						}
						array_push($multiCell[$rowCount], $tempCell);
					} else {
						if ( $hideAccommType == "1" ) {
							$roomInfo = "";
						} else {
							$roomInfo = $row['accommodation'];
						}							
						if ( $showUnitLabel == "1" ) {
							$roomInfo .= "
" . $row['unit_label'];
						}
						if ( $showUnitNumber == "1" ) {
							$roomInfo .= "
" . $row['room'];
						}
						$roomInfo = "Stay Over
" . $roomInfo; 
					}
					array_push($pdfRow, $tempCell);
			
					// [START] Stay Over section headings -----------------------------
					$tempCell = array();
					$tempCell = createHeaderPDF($stayOverIds, $chartSections, $stayOverRowSpans[$row['id']], $totalSubCellStayOver);
			
					array_push($multiCell[$rowCount], $tempCell);
					array_push($pdfRow, $tempCell);
					$tempCell = array();
				
					// [ END ] Stay Over section headings -----------------------------

					// [START] Stay Over information ----------------------------------
					$colcount	 = 0;
					$current_page = 0;
					$pdfDataRow   = $pdfRow;
					foreach ( $pdf_chart_data['columns'] as $col ) {
						if ( $colcount == $max_columns_per_page ) {
							$pdfPage[$current_page][$row_count] = $pdfDataRow;
							$pdfDataRow = $pdfRow;
							$colcount = 0;
							$current_page++;
						}

						$tempCell = createRoomDetailsPDF($chartIds, $pdf_chart_data, $chartSections, 'stayOver', $row['id'], $col['id']);

						array_push($multiCell[$rowCount], $tempCell);
						array_push($pdfDataRow, $tempCell);
						$tempCell = array();
						$colcount++;
					}
					$row_count++;
					$cells = array();
					$rowCount++;
					$multiCell[$rowCount] = array();

				} else {
					$bool_stayOver = false;
					$top_line_style = 'border-top: 1px solid #000;';
				}
			}
		}

		// [ END ] Display stay over informatyion

		$pdfRow = array();
		// Here we look at each row and try to determine if there is any departure
		// information in any of the row's columns. If not, then we don't display 
		// the departure row
		$departInfoExists = false;
		foreach ( $pdf_chart_data['columns'] as $col ) {
			$d = isset($pdf_chart_data['depart'][$row['id']][$col['id']]) ? $pdf_chart_data['depart'][$row['id']][$col['id']] : array();
			if ( is_array($d) && count($d) > 0  ) {
				foreach ( $d as $blah ) {
					if ( isset($blah['value']) && $blah['value'] != "" ) {
						$departInfoExists = true;
					}
				}
			}
		}

		// [START] Display Departure information ------------------------------
		if ( count($departIds) > 0 && $departInfoExists && $showDepartureInfo ) {
			// [START] Departure information row ------------------------------
			if ( $pdf_chart_data['direction'] == "1" ) {
				$roomInfo = $displayDate . " " . $row['name'];
				$cell = array('width'=>$cellwidth . '%','data'=>'Depart','border'=>'LRT');
				array_push($tempCell, $cell);
				$cell = array('width'=>$cellwidth .  '%','data'=>$roomInfo,'border'=>'LR');
				array_push($tempCell, $cell);
								
				for($count=3; $count<=$totalSubCellDepart;$count++) {
					if($count == $totalSubCellDepart) {
						$styleId = 'LRB';
					} else {
						$styleId = 'LR';
					}
					$cell = array('width'=>$cellwidth . '%','data'=>'','border'=>$styleId);
					array_push($tempCell, $cell);
				}
				
				array_push($multiCell[$rowCount], $tempCell);
								
				//if($pdf_chart_data['detailAs'] == '1') {
				//	array_push($pdfRow,array('width'=>$cellwidth . '%','data'=>'','border'=>''));
				//}

				
			} else {
				if ( $hideAccommType == "1" ) {
					$roomInfo = "";
				} else {
					$roomInfo = $row['accommodation'];
				}					
				if ( $showUnitLabel == "1" ) {
					$roomInfo .= "
" . $row['unit_label'];
				}
				if ( $showUnitNumber == "1" ) {
					$roomInfo .= "
" . $row['room'];
				}
				$roomInfo = "Depart
" . $roomInfo; 
			
			}
			array_push($pdfRow, $tempCell);
			$tempCell = array();
						
			// [START] Departure section headings -----------------------------
			$tempCell = array();
			$styleFlag = 1;   
			
			$tempCell = createHeaderPDF($departIds, $chartSections, $departRowSpans[$row['id']], $totalSubCellDepart);
			
			array_push($multiCell[$rowCount], $tempCell);
			array_push($pdfRow, $tempCell);
			$tempCell = array();
			
			// [ END ] Departure section headings -----------------------------

			// [START] Departure information ----------------------------------
			$colcount	 = 0;
			$current_page = 0;
			$pdfDataRow   = $pdfRow;
			foreach ( $pdf_chart_data['columns'] as $col ) {
				if ( $colcount == $max_columns_per_page ) {
					$pdfPage[$current_page][$row_count] = $pdfDataRow;
					$pdfDataRow = $pdfRow;
					$colcount = 0;
					$current_page++;
				}

				$tempCell = array();
				$tempCell = createRoomDetailsPDF($chartIds, $pdf_chart_data, $chartSections, 'depart', $row['id'], $col['id']);
				
				array_push($multiCell[$rowCount], $tempCell);
				array_push($pdfDataRow, $tempCell);
				$tempCell = array();
				$colcount++;
			}
			$row_count++;
			$cells = array();
			$rowCount++;
			$multiCell[$rowCount] = array();
		} else {
			$bool_depart = false;
		}
		// [ END ] Display Departure information -----------------------------------
		
		$row_count++;
		$modcount++;
	}

	$header_line_count = 0;
	$line_count = 0;
	$page_count = count($pdfPage);

	$cells = array();
	$rows = array();
	$temparr=array();
			
	if($showChart == 1) {
		for ( $i = 0; $i < $page_count; $i++ ) {
			$header_line_count = $pdf -> getMaxLines($pdfPageHeader[0][$i]);
			$pdf -> Row($pdfPageHeader[0][$i]);
			if ( $pdf_chart_data['direction'] == '1' ) {
				$pdf -> Row($pdfPageHeader[1][$i]);
				$header_line_count += $pdf -> getMaxLines($pdfPageHeader[1][$i]);
			}

			$line_count += $header_line_count;
			if(is_array($pdfPage[$i])) {
				foreach( $pdfPage[$i] as $r ) {
					$line_count += $pdf -> getMaxLines($r);
					// Make sure we don't have cells spanning two pages
					if ( $line_count > 48 ) {
						$pdf -> AddPage();
						$pdf -> Row($pdfPageHeader[0][$i]);
						if ( $pdf_chart_data['direction'] == '1' ) {
							$pdf -> Row($pdfPageHeader[1][$i]);
						}
						$line_count = 0 + $header_line_count + $pdf -> getMaxLines($r);
					}
					
					for ($cal=0;$cal<count($r[1]);$cal++) {
						for ($crow=0;$crow<count($r);$crow++) {
							if(!empty($r[$crow][$cal])) {
									array_push($cells,$r[$crow][$cal]);
							} else {
									array_push($cells,array( 'width' => '10%', 'data'=>'', 'border' => 'LR' )); 
							}
						}
						if(!empty($cells)){
							$pdf -> Row($cells);
						} 
						$cells = array();
					}
				} 
			}
			$pdf -> Ln(2);
			$line_count += 2;
		} 
	}
	// [ END ] Chart ----------------------------------------------------------

	// [START] Legend ---------------------------------------------------------
	if($showLegend ==1 && $showChart == 1) {
		$legend = generatePDFLegend($chartSections,$chartIds,$data['chart']);
		$line_count = 0;
		foreach( $legend as $l ) {
			$line_count += $pdf -> getMaxLines($l);
			if ( $line_count > 48 ) {
				$pdf -> AddPage();
				$line_count = 0 + $pdf -> getMaxLines($l);
			}
			$pdf -> Row($l);
		}
	}
	// [ END ] Legend ---------------------------------------------------------

	// [START] Notes ----------------------------------------------------------
	if($showNotes == 1) {
		$notes = generatePDFNotes($noteSections,$noteIds,$data['notes'],$noteSort,$noteHeader);
		if($showChart == 1) {
			$pdf -> AddPage();
		}
		$line_count = 0;
		foreach ( $notes as $n ) {
			foreach ( $n as $a ) {
				$line_count += $pdf -> getMaxLines($a);
				if ( $line_count > 48 ) {
					$pdf -> AddPage();
					$line_count = 0 + $pdf -> getMaxLines($a);
				}
				$pdf -> Row($a);
			}
		}
	}
	// [ END ] Notes ----------------------------------------------------------

	$pdf -> Ln(2);
	$headerArray = array(
							array(name => "Date range", value => "$fromDate to $toDate"),
							array(name => "Property", value => $propertyFilter),
						);
	if ( $line_count > 40 ) {
		$pdf -> AddPage();
	}

	$pdf->ReportHeader($reportLabel, $headerArray);
	if ( $renderType == 'view' ) {
		$pdf->OutPut();
		die();
	}

	if ( $renderType == 'send' ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r
";

		// close the pdf
		if ( $pdf->state < 3) {
			$pdf->Close();
		}

		// and now mail it
		if ( $attachmentName != '!attachmentName!' ) {
			$pdfName = $attachmentName;
		} else {
			$pdfName = 'Update report from ' . $fromDate . ' to ' . $toDate . '.pdf';
		}

		// (from, to, subject, headers, message, action, emailID, resID)
		$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$pdf->buffer,$pdfName);
		if ( !$error ) {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								opener.openMessage("Your email has been sent.");
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		} else {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								opener.openMessage("Error sending email!");
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		}
	}
}

function createHeaderXLS($chartIds, $data, $chartSections, $flag, $rowId, $colId, &$xls, $styles=array()) {
	$tempArr = array();
	$perdayIds = $chartIds['perDay'];
	if($data['sep_asd'] == '2') {
		$detailIds = $chartIds['combined'];
		$rowSpans = getCommonRowSpan($data,$detailIds, $rowId, $flag);
		
	} else {
		$detailIds = $chartIds[$flag];
		$rowSpan = getRowSpans($data,$flag,$detailIds);
		$rowSpans = $rowSpan[$rowId];
	}
	$totalSubCell = array_sum($rowSpans);
	
	$styleFlag = 1;
	$repFlag = 0;
	$processedId = array();
	foreach ( $detailIds as $departId ) {
		if(in_array($departId, $perdayIds)) {
			continue;
		}
		
		if($styleFlag == 1) {
			$styleId = $styles['styleLRT'];
		}
		else if($styleFlag == $totalSubCell) {
			$styleId = $styles['styleLRB'];
		}
		else {
			$styleId = $styles['styleLR'];
		}

		$typeId = getDetailType($departId, $chartSections);
		if($typeId == 1) {
			if($departId == findSectionId($chartSections,"extras") || $departId == findSectionId($chartSections,"extraNote") || $departId == findSectionId($chartSections,"extraMemo")){
				$descId = findSectionId($chartSections,"extras");
				$noteId = findSectionId($chartSections,"extraNote");
				$memoId = findSectionId($chartSections,"extraMemo");
				$supId = findSectionId($chartSections, "extraSupplier");
				$travelFlag = 0;
			} else {
				$descId = findSectionId($chartSections,"travel");
				$noteId = findSectionId($chartSections,"travelNote");
				$memoId = findSectionId($chartSections,"travelMemo");
				$etaId = findSectionId($chartSections,"travelETA");
				$etdId = findSectionId($chartSections,"travelETD");
				$supId = findSectionId($chartSections, "travelSupplier");
				$travelFlag = 1;
			}
		}
				
		foreach ( $chartSections as $item ) {
			if ( $item['id'] == $departId ) {
				if($styleFlag == 1) {
					$styleId = $styles['styleLRT'];
				}
				else if($styleFlag == $totalSubCell) {
					$styleId = $styles['styleLRB'];
				}
				else {
					$styleId = $styles['styleLR'];
				}		
				if ($typeId == 1) {
					if(!in_array($departId, $processedId)) {
						$repFlag = 0;
					}
					
					for ( $count = 0; $count < $rowSpans[$departId]; $count++ ) {
						if($departId == $descId && $repFlag == 0) {
							if(in_array($departId, $detailIds)) {
								$label = getHeaderAtr($chartSections, $departId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($departId, $processedId)) {
									array_push($processedId, $departId);
								}
							}
							$nextFlag = 0;
							if($travelFlag == 1) {
								if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
									if(($styleFlag+$nextFlag) == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etaId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etaId, $processedId)) {
										array_push($processedId, $etaId);
									}
								}

								if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etdId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etdId, $processedId)) {
										array_push($processedId, $etdId);
									}
								}
							}
							if(in_array($memoId, $detailIds)  && !in_array($memoId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $memoId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($memoId, $processedId)) {
									array_push($processedId, $memoId);
								}
							}
							if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $noteId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($noteId, $processedId)) {
									array_push($processedId, $noteId);
								}
							}
							if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $supId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($supId, $processedId)) {
									array_push($processedId, $supId);
								}
							}
							
							if($count == $rowSpans[$departId]-1) {
								$repFlag = 1;
							}
							
						} else if(($departId == $noteId) && $repFlag == 0) {
							$nextFlag = 0;
							if(in_array($departId, $detailIds)) {
								$label = getHeaderAtr($chartSections, $departId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($departId, $processedId)) {
									array_push($processedId, $departId);
								}
							}
							if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $supId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($supId, $processedId)) {
									array_push($processedId, $supId);
								}
							}
							if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $descId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($descId, $processedId)) {
									array_push($processedId, $descId);
								}
							}
							if(in_array($memoId, $detailIds)  && !in_array($memoId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $memoId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($memoId, $processedId)) {
									array_push($processedId, $memoId);
								}
							}
							if($travelFlag == 1) {
								if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etaId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etaId, $processedId)) {
										array_push($processedId, $etaId);
									}
								}

								if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etdId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etdId, $processedId)) {
										array_push($processedId, $etdId);
									}
								}
							}
							if($count == $rowSpans[$departId]-1) {
								$repFlag = 1;
							}
						}
										
						else if(($departId == $memoId) && $repFlag == 0) {
							if(in_array($departId, $detailIds)) {
								$label = getHeaderAtr($chartSections, $memoId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($departId, $processedId)) {
									array_push($processedId, $departId);
								}
							}
							$nextFlag = 0;
							if(in_array($noteId, $detailIds)  && !in_array($noteId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $noteId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($noteId, $processedId)) {
									array_push($processedId, $noteId);
								}
							}
							if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $supId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($supId, $processedId)) {
									array_push($processedId, $supId);
								}
							}
							if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $descId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($descId, $processedId)) {
									array_push($processedId, $descId);
								}
							}
							if($travelFlag == 1) {
								if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etaId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etaId, $processedId)) {
										array_push($processedId, $etaId);
									}
								}

								if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etdId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etdId, $processedId)) {
										array_push($processedId, $etdId);
									}
								}
							}
							if($count == $rowSpans[$departId]-1) {
								$repFlag = 1;
							}

						} else if(($departId == $etaId) && $repFlag == 0) {
							if($travelFlag == 1) {
								if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
									$label = getHeaderAtr($chartSections, $etaId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$styleFlag++;
									if(!in_array($etaId, $processedId)) {
										array_push($processedId, $etaId);
									}
								}
								$nextFlag = 0;
								if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etdId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;	
									$styleFlag++;
									if(!in_array($etdId, $processedId)) {
										array_push($processedId, $etdId);
									}
								}
							}
							if(in_array($memoId, $detailIds)  && !in_array($memoId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $memoId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($memoId, $processedId)) {
									array_push($processedId, $memoId);
								}
							}
							if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $noteId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($noteId, $processedId)) {
									array_push($processedId, $noteId);
								}
							}
							if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $supId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($supId, $processedId)) {
									array_push($processedId, $supId);
								}
							}
							if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $descId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($descId, $processedId)) {
									array_push($processedId, $descId);
								}
							}
							if($count == $rowSpans[$departId]-1) {
								$repFlag = 1;
							}

						} else if(($departId == $etdId) && $repFlag == 0) {
							if($travelFlag == 1) {
								if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
									if($styleFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $memoId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$styleFlag++;
									if(!in_array($departId, $processedId)) {
										array_push($processedId, $departId);
									}
								}
							}
							$nextFlag = 0;
							if(in_array($memoId, $detailIds)  && !in_array($memoId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $memoId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($memoId, $processedId)) {
									array_push($processedId, $memoId);
								}
							}
							if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $noteId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($noteId, $processedId)) {
									array_push($processedId, $noteId);
								}
							}
							if(in_array($supId, $detailIds) && !in_array($supId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $supId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($supId, $processedId)) {
									array_push($processedId, $supId);
								}
							}
							if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $descId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($descId, $processedId)) {
									array_push($processedId, $descId);
								}
							}
							if($travelFlag == 1) {
								if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etaId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etaId, $processedId)) {
										array_push($processedId, $etaId);
									}
								}

							}
							if($count == $rowSpans[$departId]-1) {
								$repFlag = 1;
							}
						}
						else if(($departId == $supId) && $repFlag == 0) {
							if(in_array($departId, $detailIds)) {
								$label = getHeaderAtr($chartSections, $departId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($departId, $processedId)) {
									array_push($processedId, $departId);
								}
							}
							$nextFlag = 0;
							if(in_array($descId, $detailIds)  && !in_array($descId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $descId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($descId, $processedId)) {
									array_push($processedId, $descId);
								}
							}
							if($travelFlag == 1) {
								if(in_array($etaId, $detailIds) && !in_array($etaId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etaId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etaId, $processedId)) {
										array_push($processedId, $etaId);
									}
								}

								if(in_array($etdId, $detailIds) && !in_array($etdId, $perdayIds)) {
									if($styleFlag+$nextFlag == $totalSubCell) {
										$styleId = $styles['styleLRB'];
									}
									$label = getHeaderAtr($chartSections, $etdId, 'label');
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
									array_push($tempArr, $cell);
									$nextFlag++;
									$styleFlag++;
									if(!in_array($etdId, $processedId)) {
										array_push($processedId, $etdId);
									}
								}
							}
							if(in_array($memoId, $detailIds)  && !in_array($memoId, $perdayIds)) {
								if($styleFlag+1 == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $memoId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($memoId, $processedId)) {
									array_push($processedId, $memoId);
								}
							}
							if(in_array($noteId, $detailIds) && !in_array($noteId, $perdayIds)) {
								if($styleFlag+$nextFlag == $totalSubCell) {
									$styleId = $styles['styleLRB'];
								}
								$label = getHeaderAtr($chartSections, $noteId, 'label');
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$label), $styleId);
								array_push($tempArr, $cell);
								$nextFlag++;
								$styleFlag++;
								if(!in_array($noteId, $processedId)) {
									array_push($processedId, $noteId);
								}
							}
							if($count == $rowSpans[$departId]-1) {
								$repFlag = 1;
							}
						}
					}

				} else {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['label']), $styleId);
					array_push($tempArr, $cell);
					$styleFlag++;
														
					if ( $rowSpans[$departId] > 1 ) {
						for ( $count = 1; $count < $rowSpans[$departId]; $count++ ){
							if($styleFlag == 1) {
								$styleId = $styles['styleLRT'];
							}
							else if($styleFlag == $totalSubCell) {
								$styleId = $styles['styleLRB'];
							}
							else {
								$styleId = $styles['styleLR'];
							}		
							$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
						}
					}
				}
												
				//if($item['id']== findSectionId($chartSections,"travelMemo")){
				//	$repFlag = 0;
				//}
			}
		}
	} 
	
	return $tempArr;
}

function createDetailHeaderRowXLS(&$xls, $chartSections, $departId, $bg_styleId) {
	$cell = '';
	foreach ( $chartSections as $item ) {
		if ( $item['id'] == $departId ) {
			//$label = $item['header'] !=''?$item['header']:$item['label'];
			$label = $item['label'];
			$cell = $xls->Cell(array('type'=>'String', 'data' => $label), $bg_styleId);
		}
		
	}
	return $cell;
}

function createRoomDetailXLS(&$xls, $chart, $type, $departId, $colourIds, $rowId, $colId, $detailAs=1, $rowSpan=array(), $dataType = "String") {
	$colour		= array(0xff,0xff,0xff);
	$fontColour = array(0x00,0x00,0x00);
	$repFlag	= 0;
	$errorDesc	= '';
	$styleFlag	= 1;
	$tempArr	= array();
	$d = isset($chart[$type][$rowId][$colId]) ? $chart[$type][$rowId][$colId] : "";
	$b = isset($chart['block'][$rowId][$colId]) ? $chart['block'][$rowId][$colId] : "";
	$error = false;
	
	if ( $b != "" ) {
		$colour = array(0xc0,0xc0,0xc0);
	}
	
	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');
	if($styleFlag == 1) {
		$border = array($borderL, $borderR, $borderT);
	}
	else if ($styleFlag == $rowSpan[$departId]) {
		$border = array($borderL, $borderR, $borderB);
	}
	else {
		$border = array($borderL, $borderR);
	}
		
	// Provisional booking
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 20 ) {
		$fontColour = array(0x33,0x66,0x99);
	}

	// Provisional expiring today
	if ( isset($d['rv_provision_expiry_date']) && $d['rv_provision_expiry_date'] == date("Y-m-d") ) {
		$colour = array(0xf1,0xc5,0x5d);
		$fontColour = array(0x00,0x00,0x00);
	}
			
	// Allocation
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 15 ) {
		$fontColour = array(0x99,0x99,0x99);
	}

	// We have an expired provisional that is roomed
	if (
        isset($d['rv_provision_expiry_date']) &&
        $d['rv_provision_expiry_date'] != 0000-00-00 &&
        $d['rv_provision_expiry_date'] < date("Y-m-d") &&
        $d['rf_reservation_status_id'] != "30"  // Status is not confirmed
    ) {
		$error = true;
		$errorDesc = "You have an expired provisional that has been roomed.";
	}
	// [START] Reservation status error handling ----------------------------
	// Quotation
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == "0" ) {
		$error = true;
		$errorDesc = "You have a quotation that has been roomed.";
	}

	// Waitlisted
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 10 ) {
		$error = true;
		$errorDesc = "You have a waitlisted that has been roomed.";
	}

	// Cancelled
	if ( isset($d['rf_reservation_status_id']) && $d['rf_reservation_status_id'] == 90 ) {
		$error = true;
		$errorDesc = "You have a cancelled reservation that has been roomed.";
	}
	
	// You have a roomed overbooking! 
	if ( isset($d['overbooked']) && $d['overbooked']) {
		$error = true;
		$errorDesc = "You have a room-level overbooking.";
	}

	if ( isset($chart['direction']) && $chart['direction'] == "2" ) {
		if($chart['rows'][$rowId]['room'] == "overbooking") {
			$colour	= array(0xdb,0x42,0x42);
			$error = true;
		}
	} else {
		if($chart['columns'][$colId]['room'] == "overbooking") {
			$colour	= array(0xdb,0x42,0x42);
			$error = true;
		}
	}
	
	if ( isset($d[$departId]['value']) && !is_array($d[$departId]['value']) ) {	
		if($d[$departId]['value'] == "") {
			$dataType = "String";
		}
		
		// [ START ] Colour handling ----------------------------
		if ( in_array($departId,$colourIds) && $d[$departId]['colour'] != "" ) {
			$colour = array( 
					hexdec(substr($d[$departId]['colour'],0,2)),
					hexdec(substr($d[$departId]['colour'],2,2)),
					hexdec(substr($d[$departId]['colour'],4,2))
				);
		}
		
		if ($error == true ) {
			$colour		= array(0xdb,0x42,0x42);
			$fontColour = array(0xff,0xff,0xff);
		}
		$colour = $xls->rgb2html($colour);
		$fontColour = $xls->rgb2html($fontColour);
		if($colour == "#000000") { 
			$colour = "#ffffff"; 
		}
			
		// [ END ] Colour handling ----------------------------

		$roomCellStyle = array( 
			'interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
			'font' => array('Color' => $fontColour, 'Size' => '8'),
			'border' => $border
		);
			
		$roomCellStyleId = $xls->addStyle($roomCellStyle);

		if($errorDesc == '') {
			$cell = $xls->Cell(array('type'=>$dataType, 'data'=>$d[$departId]['value']), $roomCellStyleId);
		} else {
			$cell = $xls->Cell(array('type'=>$dataType, 'data'=>$d[$departId]['value']), $roomCellStyleId, '', '', $errorDesc);
		}
		array_push($tempArr, $cell);
		if (isset($rowSpan[$departId]) && $rowSpan[$departId]>1 ) {
			for ( $count = 0; $count < ($rowSpan[$departId]); $count++ ) {
				$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $roomCellStyleId);
				array_push($tempArr, $cell);
			}
		}
			
	} else {
		$used = 0;
		$data = '';
		if($styleFlag == 1) {
			$border = array($borderL, $borderR, $borderT);
		}
		else if ($styleFlag == $rowSpan[$departId]-1) {
			$border = array($borderL, $borderR, $borderB);
		}
		else {
			$border = array($borderL, $borderR);
		}
		
		if (isset($d[$departId]['value'])) {
			foreach ( $d[$departId]['value'] as $cellItem ) {
				
				// [START] Colour handling ---------------------------------------------
				$colour	  = array(0xff,0xff,0xff);
				$fontColour  = array(0x00,0x00,0x00);
				if ( in_array($departId,$colourIds) && $cellItem['colour'] != '' ) {
					$colour = array( 
						 hexdec(substr($cellItem['colour'],0,2)),
						 hexdec(substr($cellItem['colour'],2,2)),
						 hexdec(substr($cellItem['colour'],4,2))
						);
				}
				if($detailAs == 2 && $cellItem['value'] === "") {
					$cellItem['value'] = '
';
				}
				if($data == '' || $data == '
') {
					$data .= $cellItem['value'];
				} else {
					$data .= '
'.$cellItem['value'];
				}
				$used++;
			}
		}
		
		if ( $error ) {
			$colour= array(0xdb,0x42,0x42);
			$fontColour	= array(0xff,0xff,0xff);
		}

		$colour = $xls->rgb2html($colour);
		$fontColour = $xls->rgb2html($fontColour);
		if($colour == "#000000") { 
			$colour = "#ffffff"; 
		}
		// [ END ] Colour handling --------------------------------------------
		$roomCellStyle = array(
			'interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
			'font' => array('Color' => $fontColour, 'Size' => '8'),
			'border' => $border
		);
				
		$roomCellStyleId = $xls->addStyle($roomCellStyle);
		if($data == "") {
			$dataType = "String";
		}
		$cell = $xls->Cell(array('type'=>$dataType, 'data'=>$data), $roomCellStyleId);
		array_push($tempArr, $cell);
		if ( isset($rowSpan[$departId]) && $used < $rowSpan[$departId] ) {
			for ( $count = 0; $count < ($rowSpan[$departId] - $used); $count++ ) {
				$roomCellStyle = array('interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
			'border' => $border);
				if($count == ($rowSpan[$departId] - $used)) {
					$roomCellStyle = array('interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
					'border' => $border);
				} 
				
				$roomCellStyleId = $xls->addStyle($roomCellStyle);
				$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $roomCellStyleId);
				array_push($tempArr, $cell);
			}
		}
					
		$first = false;
	}
		
	return $tempArr;
}

function createRoomDetailsAsRowXLS(&$xls, $chartIds, $data, $chartSections, $flag, $rowId, $colId) {
	$initialColour	  = array(0xff,0xff,0xff);
	$initialFontColour  = array(0x00,0x00,0x00);
	$tempArr = array();
	$error = false;
	
	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');
			
	$perDayIds = $chartIds['perDay'];
	$colourIds = $chartIds['colour'];
	$c = isset($data[$flag][$rowId][$colId]) ? $data[$flag][$rowId][$colId] : "";
	$b = isset($data['block'][$rowId][$colId]) ? $data['block'][$rowId][$colId] : "";
	
	if ( $b != "" ) {
		$initialColour = array(0xc0,0xc0,0xc0);
	}

	if($data['sep_asd'] == '2') {
		$detailIds = $chartIds['combined'];
		if($data['detailAs'] == '1') {
			$combinedIds = $chartIds['combined'];
			$rowSpans = getCommonRowSpan($data,$detailIds, $rowId, $flag);
		} else {
			$rowSpans = getCommonRowSpan($data,$detailIds, $rowId, $flag);
		}
	} else {
		$detailIds = $chartIds[$flag];
		$rowSpan = getRowSpans($data,$flag,$detailIds);
		$rowSpans = $rowSpan[$rowId];
	}
	
	$totalSubCell = array_sum($rowSpans);
	
	$first = true;
	$repFlag = 0;
	$styleFlag = 1;
	$processedId = array();		
	foreach ( $detailIds as $showId ) {
		if(in_array($showId, $perDayIds)) {
			continue;
		}
		$colour			= $initialColour;
		$fontColour = $initialFontColour;
		
		// Provisional booking
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 20 ) {
			$fontColour = array(0x33,0x66,0x99);
		}

		// Provisional expiring today
		if ( isset($c['rv_provision_expiry_date']) && $c['rv_provision_expiry_date'] == date('Y-m-d') )  {
			$colour		= array(0xf1,0xc5,0x5d);
			$fontColour	= array(0x00,0x00,0x00);
		}

		// Allocation
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 15 ) {
			$fontColour = array(0x99,0x99,0x99);
		}

		// We have an expired provisional that is roomed
		if (
            isset($c['rv_provision_expiry_date']) &&
            $c['rv_provision_expiry_date'] != 0000-00-00 &&
            $c['rv_provision_expiry_date'] < date("Y-m-d") &&
            $c['rf_reservation_status_id'] != "30"  // Status is not confirmed
        ) {
			$error = true;
			$errorDesc = "You have an expired provisional that has been roomed.";
		}
		// [START] Reservation status error handling ----------------------------
		// Quotation
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == "0" ) {
			$error = true;
			$errorDesc = "You have a quotation that has been roomed.";
		}

		// Waitlisted
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 10 ) {
			$error = true;
			$errorDesc = "You have a waitlisted that has been roomed.";
		}

		// Cancelled
		if ( isset($c['rf_reservation_status_id']) && $c['rf_reservation_status_id'] == 90 ) {
			$error = true;
			$errorDesc = "You have a cancelled reservation that has been roomed.";
		}

		// You have a roomed overbooking!
		if ( isset($c['overbooked']) && $c['overbooked'] ) {
			$error = true;
			$errorDesc = "You have a room-level overbooking.";
		}

		if ( isset($data['direction']) && $data['direction'] == "2" ) {
			if($data['rows'][$rowId]['room'] == "overbooking") {
				$error = true;
				$colour	= array(0xdb,0x42,0x42);
			}
		} else {
			if($data['columns'][$colId]['room'] == "overbooking") {
				$error = true;
				$colour	= array(0xdb,0x42,0x42);
			}
		}

		if(isset($styleFlag) && $styleFlag == 1) {
			$border = array($borderL, $borderR, $borderT);
		}
		else if (isset($styleFlag) && $styleFlag == $totalSubCell) {
			$border = array($borderL, $borderR, $borderB);
		}
		else {
			$border = array($borderL, $borderR);
		}

		$typeId = getDetailType($showId, $chartSections);
		if($typeId == 1) {
			if($showId == findSectionId($chartSections,"extras") || 
			$showId == findSectionId($chartSections,"extraNote") || 
			$showId == findSectionId($chartSections,"extraMemo")){
				$descId = findSectionId($chartSections,"extras");
				$noteId = findSectionId($chartSections,"extraNote");
				$memoId = findSectionId($chartSections,"extraMemo");
				$supId = findSectionId($chartSections, "extraSupplier");
				$travelFlag = 0;
			} else {
				$descId = findSectionId($chartSections,"travel");
				$noteId = findSectionId($chartSections,"travelNote");
				$memoId = findSectionId($chartSections,"travelMemo");
				$etaId = findSectionId($chartSections,"travelETA");
				$etdId = findSectionId($chartSections,"travelETD");
				$supId = findSectionId($chartSections, "travelSupplier");
				$travelFlag = 1;
			}
		}

		$dataType = getHeaderAtr($chartSections, $showId, 'numeric');
		
		if ( !isset($c[$showId]['value']) || !is_array($c[$showId]['value']) ) {
			if(!isset($c[$showId]['value']) || $c[$showId]['value'] == "") {
				$dataType = "String";
			}					
			// [ START ] Colour handling ----------------------------
			if ( in_array($showId,$colourIds) && isset($c[$showId]['colour']) && $c[$showId]['colour'] != "" ) {
				$colour = array( 
					hexdec(substr($c[$showId]['colour'],0,2)),
					hexdec(substr($c[$showId]['colour'],2,2)),
					hexdec(substr($c[$showId]['colour'],4,2))
				);
			}
			if ( $error ) {
				$colour		= array(0xdb,0x42,0x42);
				$fontColour = array(0xff,0xff,0xff);
			}
			$colour = $xls->rgb2html($colour);
			$fontColour = $xls->rgb2html($fontColour);
			if($colour == "#000000") { 
				$colour = "#ffffff"; 
			}
			// [ END ] Colour handling ----------------------------

			if ( !isset($c[$showId]['value']) || trim($c[$showId]['value']) == '' ) {
				$c[$showId]['value'] = "&nbsp;";
			}

			$roomCellStyle = array( 
				'interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
				'font' => array('Color' => $fontColour, 'Size' => '8'),
				'border' => $border
			);
			
			$roomCellStyleId = $xls->addStyle($roomCellStyle);
			if(!isset($errorDesc) || $errorDesc == '') {
				$cell = $xls->Cell(array('type'=>$dataType, 'data'=>$c[$showId]['value']), $roomCellStyleId);
			} else {
				$cell = $xls->Cell(array('type'=>$dataType, 'data'=>$c[$showId]['value']), $roomCellStyleId, '', '', $errorDesc);
			}
			
			array_push($tempArr, $cell);
			$styleFlag++;
			if ($rowSpans[$showId]>1 ) {
				for ( $count = 1; $count < ($rowSpans[$showId]); $count++ ) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $roomCellStyleId);
					array_push($tempArr, $cell);
					$styleFlag++;
				}
			}
	
		} else {
			$used = 0;
			if ($typeId == 1) {
				if(!in_array($showId, $processedId)) {
					$repFlag = 0;
				}

				for ( $count = 0; $count < $rowSpans[$showId]; $count++ ) {
					$cellItem	  = isset($c[$showId]['value'][$count]) ? $c[$showId]['value'][$count] : array();
					$cellItemDesc = isset($c[$descId]['value'][$count]) ? $c[$descId]['value'][$count] : array();
					$cellItemNote = isset($c[$noteId]['value'][$count]) ? $c[$noteId]['value'][$count] : array();
					$cellItemMemo = isset($c[$memoId]['value'][$count]) ? $c[$memoId]['value'][$count] : array();
					$cellItemSup = isset($c[$supId]['value'][$count]) ? $c[$supId]['value'][$count] : array();
					
					if($styleFlag == 1) {
						$border = array($borderL, $borderR, $borderT);
					}
					else if ($styleFlag == $totalSubCell) {
						$border = array($borderL, $borderR, $borderB);
					}
					else {
						$border = array($borderL, $borderR);
					}

					// [START] Colour handling ---------------------------------------------
					if ( in_array($showId,$colourIds) && $cellItem['colour'] != '' ) {
						$colour = array( 
						 hexdec(substr($cellItem['colour'],0,2)),
						 hexdec(substr($cellItem['colour'],2,2)),
						 hexdec(substr($cellItem['colour'],4,2))
						);
						$colour = $xls->rgb2html($colour);
					}
					if(is_array($colour)) {
						$colour = $xls->rgb2html($colour);
					}
					$colourDesc = $colourNote = $colourMemo = $colourSup = $colour;
									
					if($travelFlag == 1) {
						$cellItemEta = isset($c[$etaId]['value'][$count]) ? $c[$etaId]['value'][$count] : array();
						$cellItemEtd = isset($c[$etdId]['value'][$count]) ? $c[$etdId]['value'][$count] : array();

						$colourETA = $colourETD = $colour;
					}

					if ( $error ) {
						$colourDesc = $colourNote = $colourMemo = $colourSup = $colourETA = $colourETD = "#db4242";
						$fontColour = array(0xff,0xff,0xff);
					}
					$fontColour = $xls->rgb2html($fontColour);
										
					// [ END ] Colour handling --------------------------------------------
					$roomCellStyle = array('interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
											'font' => array('Color' => $fontColour, 'Size' => '8'),
											'border' => $border
									);
					$roomCellLRBStyle = array('interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
											'font' => array('Color' => $fontColour, 'Size' => '8'),
											'border' => array($borderL, $borderR, $borderB)
									);

					$roomCellStyleId	 = $xls->addStyle($roomCellStyle);
					$roomCellLRBStyleId = $xls->addStyle($roomCellLRBStyle);
					$styleId = $roomCellStyleId;
					if($showId == $descId   && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						$nextFlag = 0;
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
										$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEta['value']) ? $cellItemEta['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
										$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds)  && !in_array($memoId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds)  && !in_array($noteId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemNote['value']) ? $cellItemNote['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds)  && !in_array($supId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemSup['value']) ? $cellItemSup['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}

					}
					else if(($showId == $noteId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						$nextFlag = 0;
						if(in_array($supId, $detailIds)  && !in_array($supId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") ), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "")), $styleId);

							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEta['value']) ? $cellItemEta['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds)  && !in_array($memoId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					}
					else if(($showId == $memoId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						$nextFlag = 0;
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemNote['value']) ? $cellItemNote['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds)  && !in_array($supId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") ), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEta['value']) ? $cellItemEta['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}

					} else if(($showId == $etaId) && $repFlag == 0) {
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds)) {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							$nextFlag = 0;
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds) && !in_array($memoId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemNote['value']) ? $cellItemNote['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds)  && !in_array($supId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") ), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}

					} else if(($showId == $etdId) && $repFlag == 0) {
						if($travelFlag == 1) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							if(!in_array($etdId, $processedId)) {
								array_push($processedId, $etdId);
							}
						}
						$nextFlag = 0;
						if(in_array($memoId, $detailIds) && !in_array($memoId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds) && !in_array($noteId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemNote['value']) ? $cellItemNote['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if(in_array($supId, $detailIds)  && !in_array($supId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemSup['value']) ? $cellItemSup['value'] : "") ), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($supId, $processedId)) {
								array_push($processedId, $supId);
							}
						}
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEta['value']) ? $cellItemEta['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
						}
					}
					else if(($showId == $supId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							if(!in_array($showId, $processedId)) {
								array_push($processedId, $showId);
							}
						}
						$nextFlag = 0;
						if(in_array($descId, $detailIds) && !in_array($descId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemDesc['value']) ? $cellItemDesc['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($descId, $processedId)) {
								array_push($processedId, $descId);
							}
						}
						
						if($travelFlag == 1) {
							if(in_array($etaId, $detailIds) && !in_array($etaId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEta['value']) ? $cellItemEta['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etaId, $processedId)) {
									array_push($processedId, $etaId);
								}
							}
							if(in_array($etdId, $detailIds) && !in_array($etdId, $perDayIds)) {
								if(($styleFlag+$nextFlag) == $totalSubCell) {
									$styleId = $roomCellLRBStyleId;
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemEtd['value']) ? $cellItemEtd['value'] : "")), $styleId);
								array_push($tempArr, $cell);
								$styleFlag++;
								$nextFlag++;
								if(!in_array($etdId, $processedId)) {
									array_push($processedId, $etdId);
								}
							}
						}
						if(in_array($memoId, $detailIds)  && !in_array($memoId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "")), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($memoId, $processedId)) {
								array_push($processedId, $memoId);
							}
						}
						if(in_array($noteId, $detailIds)  && !in_array($noteId, $perDayIds)) {
							if(($styleFlag+$nextFlag) == $totalSubCell) {
								$styleId = $roomCellLRBStyleId;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => (isset($cellItemNote['value']) ? $cellItemNote['value'] : "") ), $styleId);
							array_push($tempArr, $cell);
							$styleFlag++;
							$nextFlag++;
							if(!in_array($noteId, $processedId)) {
								array_push($processedId, $noteId);
							}
						}
						if($count == $rowSpans[$showId]-1) {
							$repFlag = 1;
						}
					}
					//$styleFlag++;
				}

			} else {
				foreach ( $c[$showId]['value'] as $cellItem ) {
					// [START] Colour handling ---------------------------------------------
					if ( in_array($showId,$colourIds) && $cellItem['colour'] != '' ) {
						$colour = array( 
							 hexdec(substr($cellItem['colour'],0,2)),
							 hexdec(substr($cellItem['colour'],2,2)),
							 hexdec(substr($cellItem['colour'],4,2))
							);
					}
					if ( $error ) {
						$colour		= array(0xdb,0x42,0x42);
						$fontColour	= array(0xff,0xff,0xff);
					}
					$cell_colour = $xls->rgb2html($colour);
					$fontColour = $xls->rgb2html($fontColour);
										
					// [ END ] Colour handling --------------------------------------------
					$roomCellStyle = array('interior' => array('Color' => $cell_colour, 'Pattern'=>'Solid'),
											'font' => array('Color' => $fontColour, 'Size' => '8'),
											'border' => $border
					);
					
					$roomCellStyleId = $xls->addStyle($roomCellStyle);
					if(!isset($cellItem['value']) || $cellItem['value'] == "") {
						$dataType = "String";
					}	
					$cell = $xls->Cell(array('type'=>$dataType, 'data'=>(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId);
					array_push($tempArr, $cell);
					$used++;
					$styleFlag++;
				}
				if ( $error ) {
					$colour			= array(0xdb,0x42,0x42);
					$fontColour	= array(0xff,0xff,0xff);
				}
				
				if ( $used < $rowSpans[$showId] ) {
					$cell_colour = $xls->rgb2html($colour);
					$fontColour = $xls->rgb2html($fontColour);
					$roomCellStyle = array('interior' => array('Color' => $cell_colour, 'Pattern'=>'Solid'),
											'font' => array('Color' => $fontColour, 'Size' => '8'),
											'border' => $border
					);
						
					$roomCellStyleId = $xls->addStyle($roomCellStyle);
					for ( $count = 0; $count < ($rowSpans[$showId] - $used); $count++ ) {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $roomCellStyleId);
						array_push($tempArr, $cell);
						$styleFlag++;
					}
				}
			}
			
			$first = false;
		}
	}
	return $tempArr;
}

function PerDayDataXLS($chart,$type, $rowId, $colId, $chartIds, $chartSections) {
	$rowIds = $chartIds[$type];
	$detailIds = $chartIds['perDay'];
	$c = isset($chart[$type][$rowId][$colId]) ? $chart[$type][$rowId][$colId] : array();
	
	if($chart['sep_asd'] == '2') {
		$rowSpans = getCommonRowSpan($chart,$rowIds, $rowId, $type);
	} else {
		$rowSpan = getRowSpans($chart,$type,$rowIds);
		$rowSpans = $rowSpan[$rowId];
	}
			
	$repFlag = 0;
	$cellData = '';
	foreach ( $detailIds as $showId ) {
		$label = getHeaderAtr($chartSections, $showId, 'label');
		if($cellData != '') {
			$cellData .= '
';
		}
		if (!is_array($c[$showId]['value'])) {
			if(isset($c[$showId]['value']) && $c[$showId]['value'] != '') {
				$cellData .= '<B>'.$label.':</B> '.$c[$showId]['value'];
			}
		} else {
			$used = 0;
			$tempData = "";
			foreach ( $c[$showId]['value'] as $cellItem ) {
				if($tempData != ''  && $cellItem['value'] !='') {
					$tempData .= '
';
				}
				if($cellItem['value'] !='') {
					$tempData .= $cellItem['value'];
				}
			}
			
			if($tempData !='') {
				$cellData .= '<B>'.$label.':</B> '.$tempData;
			}
		}
	} 
	
	return $cellData;
}

function cretaePerDayDetailsAsColXLS(&$xls, $chart,$type, $rowId, $colIdsArr=array(), $chartIds, $chartSections, $colspnVal=0) {
	$colWidth = 200;
	$tempArr = array();
	$mainArr = array();
	$rowIds = $chartIds[$type];
	$detailIds = $chartIds['perDay'];
	$colourIds = $chartIds['colour'];
	$c = isset($chart[$type][$rowId][$colId]) ? $chart[$type][$rowId][$colId] : "";
	$b = isset($chart['block'][$rowId][$colId]) ? $chart['block'][$rowId][$colId] : "";
	
	$initialColour	  = array(0xff,0xff,0xff);
	$initialFontColour  = array(0x00,0x00,0x00);
	if ( $b != "" ) {
		$initialColour = array(0xc0,0xc0,0xc0);
	}

	if($chart['sep_asd'] == '2') {
		$rowSpans = getCommonRowSpan($chart,$rowIds, $rowId, $type);
	} else {
		$rowSpan = getRowSpans($chart,$type,$rowIds);
		$rowSpans = $rowSpan[$rowId];
	}
	$totalSubCell = array_sum($rowSpans);
		
	if($chart['direction'] == "2") {
		$totalSubCell = count($detailIds);
	}
		
	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');
			
	$repFlag = 0;
	$styleFlag = 1;

	if($chart['detailAs'] == '1') {
		$mrgDown = $totalSubCell-1;
	} else {
		$mrgDown = 0;
	}

	$roomCellStyle = array( 
		'interior' => array('Pattern'=>'Solid'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
	$roomCellStyleId = $xls->addStyle($roomCellStyle);
	
	$cell = $xls->Cell(array('type'=>'String', 'data'=>'<B>Res#: </B>'.$chart[$type][$rowId][$colId]['rv_reservation_id']),'', '', '', '', $colspnVal);
	array_push($tempArr, $cell);
	$cell = $xls->Cell(array('type'=>'String', 'data'=>'<B>Res name: </B>'.$chart[$type][$rowId][$colId]['rv_res_name']),'', '', '', '', $colspnVal);
	array_push($tempArr, $cell);
						
	foreach ( $detailIds as $showId ) {
		$colour		= $initialColour;
		$fontColour = $initialFontColour;
		$label = getHeaderAtr($chartSections, $showId, 'label');
		
		if($styleFlag == 1) {
			$border = array($borderL, $borderR, $borderT);
		}
		else if ($styleFlag == $totalSubCell) {
			$border = array($borderL, $borderR, $borderB);
		}
		else {
			$border = array($borderL, $borderR);
		}

		$typeId = getDetailType($showId, $chartSections);
		if($typeId == 1) {
			if($showId == findSectionId($chartSections,"extras") || 
			$showId == findSectionId($chartSections,"extraNote") || 
			$showId == findSectionId($chartSections,"extraMemo")){
				$descId = findSectionId($chartSections,"extras");
				$noteId = findSectionId($chartSections,"extraNote");
				$memoId = findSectionId($chartSections,"extraMemo");
			} else {
				$descId = findSectionId($chartSections,"travel");
				$noteId = findSectionId($chartSections,"travelNote");
				$memoId = findSectionId($chartSections,"travelMemo");
			}
		}

		if ( !is_array($c[$showId]['value']) ) {
			
			// [ START ] Colour handling ----------------------------
			if ( in_array($showId,$colourIds) && $c[$showId]['colour'] != "" ) {
				$colour = array( 
					hexdec(substr($c[$showId]['colour'],0,2)),
					hexdec(substr($c[$showId]['colour'],2,2)),
					hexdec(substr($c[$showId]['colour'],4,2))
				);
			}
			
			$colour = $xls->rgb2html($colour);
			if($colour == "#000000") { 
				$colour = "#ffffff"; 
			}
			// [ END ] Colour handling ----------------------------

			if ( trim($c[$showId]['value']) == '' ) {
				$c[$showId]['value'] = "&nbsp;";
			}

			$roomCellStyle = array( 
				'interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
				'border' => $border
			);
			
			$roomCellStyleId = $xls->addStyle($roomCellStyle);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.$c[$showId]['value']), $roomCellStyleId, '', '', '', '', $colspnVal);
			array_push($tempArr, $cell);
			$styleFlag++;
			if ($rowSpan[$rowId][$showId]>1 ) {
				for ( $count = 0; $count < ($rowSpan[$rowId][$showId]); $count++ ) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $roomCellStyleId,'', '', '', '', $colspnVal);
					array_push($tempArr, $cell);
					$styleFlag++;
				}
			}
	
		} else {
			$used = 0;
			if ($typeId == 1){
				if($showId == findSectionId($chartSections,"extras")) {
					$repFlag = 0;
				} 
				else if(!in_array(findSectionId($chartSections,"extras"),$detailIds) && $showId == findSectionId($chartSections,"extraNote")) {
					$repFlag = 0;
				}
				else if(!in_array(findSectionId($chartSections,"extras"),$detailIds) && !in_array(findSectionId($chartSections,"extraNote"),$detailIds) && $showId == findSectionId($chartSections,"extraMemo")) {
						$repFlag = 0;
				}

				for ( $count = 0; $count < $rowSpans[$showId]; $count++ ) {
					$cellItem	  = isset($c[$showId]['value'][$count]) ? $c[$showId]['value'][$count] : array();
					$cellItemNote = isset($c[$showId+1]['value'][$count]) ? $c[$showId+1]['value'][$count] : array();
					$cellItemMemo = isset($c[$showId+2]['value'][$count]) ? $c[$showId+2]['value'][$count] : array();

					if($styleFlag == 1) {
						$borderDesc = array($borderL, $borderR, $borderT);
					}
					else if ($styleFlag == $totalSubCell) {
						$borderDesc = array($borderL, $borderR, $borderB);
					}
					else {
						$borderDesc = array($borderL, $borderR);
					}

					if($styleFlag+1 == 1) {
						$borderNote = array($borderL, $borderR, $borderT);
					}
					else if ($styleFlag+1 == $totalSubCell) {
						$borderNote = array($borderL, $borderR, $borderB);
					}
					else {
						$borderNote = array($borderL, $borderR);
					}

					if($styleFlag+2 == 1) {
						$borderMemo = array($borderL, $borderR, $borderT);
					}
					else if ($styleFlag+2 == $totalSubCell) {
						$borderMemo = array($borderL, $borderR, $borderB);
					}
					else {
						$borderMemo = array($borderL, $borderR);
					}

					// [START] Colour handling ---------------------------------------------
					$colour1 = $colour2 = $colour3 = "#ffffff";
					if ( in_array($showId,$colourIds) && $cellItem['colour'] != '' ) {
						$colour = array( 
						 hexdec(substr($cellItem['colour'],0,2)),
						 hexdec(substr($cellItem['colour'],2,2)),
						 hexdec(substr($cellItem['colour'],4,2))
						);
						$colour1 = $xls->rgb2html($colour);
					}
					
					if (in_array($showId+1,$colourIds) && $cellItemNote['colour'] != '') {
						$colour = array( 
						 hexdec(substr($cellItemNote['colour'],0,2)),
						 hexdec(substr($cellItemNote['colour'],2,2)),
						 hexdec(substr($cellItemNote['colour'],4,2))
						);
						$colour2 = $xls->rgb2html($colour);
					}
					

					if (in_array($showId+2,$colourIds) && $cellItemMemo['colour'] != '') {
						$colour = array( 
						 hexdec(substr($cellItemMemo['colour'],0,2)),
						 hexdec(substr($cellItemMemo['colour'],2,2)),
						 hexdec(substr($cellItemMemo['colour'],4,2))
						);
						$colour3 = $xls->rgb2html($colour);
					}
					
					// [ END ] Colour handling --------------------------------------------
					$roomCellStyle = array('interior' => array('Color' => $colour1,
														'Pattern'=>'Solid'),
									'border' => $borderDesc
									);

					$roomCellNoteStyle = array('interior' => array('Color' => $colour2, 'Pattern'=>'Solid'),
									'border' => $borderNote
									);

					$roomCellMemoStyle = array('interior' => array('Color' => $colour3, 'Pattern'=>'Solid'),
									'border' => $borderMemo
							);
								
					$roomCellStyleId	= $xls->addStyle($roomCellStyle);
					$roomCellNoteStyleId = $xls->addStyle($roomCellNoteStyle);
					$roomCellMemoStyleId = $xls->addStyle($roomCellMemoStyle);
							
					if($showId == $descId) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId, '', '', '', '', $colspnVal);
							array_push($tempArr, $cell);
							$styleFlag++;
						}
						$label = getHeaderAtr($chartSections, $noteId, 'label');
						if(in_array($noteId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data' => $label.': '.(isset($cellItemNote['value']) ? $cellItemNote['value'] : "") ), $roomCellNoteStyleId, '', '', '', '', $colspnVal);
							array_push($tempArr, $cell);
							$styleFlag++;
						}
						$label = getHeaderAtr($chartSections, $memoId, 'label');
						if(in_array($memoId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.(isset($cellItemMemo['value']) ? $cellItemMemo['value'] : "")), $roomCellMemoStyleId, '', '', '', '', $colspnVal);
							array_push($tempArr, $cell);
							$styleFlag++;
						}
						$repFlag = 1;

					}
					else if(($showId == $noteId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId, '', '', '', '', $colspnVal);
							array_push($tempArr, $cell);
							$styleFlag++;
						}

						$label = getHeaderAtr($chartSections, $memoId, 'label');
						if(in_array($memoId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.(isset($cellItemNote['value']) ? $cellItemNote['value'] : "")), $roomCellNoteStyleId, '', '', '', '', $colspnVal);
							array_push($tempArr, $cell);
							$styleFlag++;
						}
						$repFlag = 1;
					}
					else if(($showId == $memoId) && $repFlag == 0) {
						if(in_array($showId, $detailIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId, '', '', '', '', $colspnVal);
							array_push($tempArr, $cell);
							$styleFlag++;
						}
						$repFlag = 1;
					}
					$styleFlag++;
				}

			} else {
				foreach ( $c[$showId]['value'] as $cellItem ) {
					// [START] Colour handling ---------------------------------------------
					if ( in_array($showId,$colourIds) && $cellItem['colour'] != '' ) {
						$colour = array( 
							 hexdec(substr($cellItem['colour'],0,2)),
							 hexdec(substr($cellItem['colour'],2,2)),
							 hexdec(substr($cellItem['colour'],4,2))
							);
					}
					if ( $error ) {
						$colour			= array(0xdb,0x42,0x42);
						$fontColour	= array(0xff,0xff,0xff);
					}
					$colour = $xls->rgb2html($colour);
					// [ END ] Colour handling --------------------------------------------
					$roomCellStyle = array('interior' => array('Color' => $colour, 'Pattern'=>'Solid'),
					'border' => $border
					);
					
					$roomCellStyleId = $xls->addStyle($roomCellStyle);
					
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$label.': '.(isset($cellItem['value']) ? $cellItem['value'] : "")), $roomCellStyleId, '', '', '', '', $colspnVal);
					array_push($tempArr, $cell);
					$used++;
					$styleFlag++;
				}
				if ( $used < $rowSpans[$showId] ) {
					for ( $count = 0; $count < ($rowSpans[$showId] - $used); $count++ ) {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $roomCellStyleId, '', '', '', '', $colspnVal);
						array_push($tempArr, $cell);
						$styleFlag++;
					}
				}
			}
		}
	} 
	
	array_push($mainArr, $tempArr);
	return $mainArr;
}

function cretaePerDayDetailsXLS(&$xls, $chart, $type, $rowId, $colIdsArr=array(), $chartIds, $chartSections, $colspnVal=0) {
	$tempArr = array();
	$mainArr = array();
	$cellArr = array();

	$perDayCellStyle = array( 
				'interior' => array('Pattern'=>'Solid'),
				'border' => array(array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1'),
							array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1'), 
							array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1'), 
							array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1'))
			);
			
	$perDayCellStyleId = $xls->addStyle($perDayCellStyle);
	
	$resIds = array();
	$ColData = '';
	if(is_array($colIdsArr) && !empty($colIdsArr)) {
		foreach($colIdsArr as $colId) {
			if($chart['room'][$rowId][$colId]['rv_reservation_id']) {
				if(!in_array($chart['room'][$rowId][$colId]['rv_reservation_id'], $resIds)) {
					if(!empty($resIds)) {
						$ColData .= '

';
					}
					$tempData = PerDayDataXLS($chart,'room', $rowId, $colId, $chartIds, $chartSections);
					if($tempData != '') {
						$ColData .= '<B>Res#: </B>'.$chart['room'][$rowId][$colId]['rv_reservation_id'].'
';
						$ColData .= '<B>Res name: </B>'.$chart['room'][$rowId][$colId]['rv_res_name'].'
';
						$ColData .= $tempData;
						array_push($resIds, $chart['room'][$rowId][$colId]['rv_reservation_id']);
					}
				}
			}
			
			if($chart['combArrSty'] == '2' && $chart['stayOver'][$rowId][$colId]['rv_reservation_id']) {
				if(!in_array($chart['stayOver'][$rowId][$colId]['rv_reservation_id'], $resIds)) {
					if(!empty($resIds)) {
						$ColData .= '

';
					}
					$tempData = PerDayDataXLS($chart,'stayOver', $rowId, $colId, $chartIds, $chartSections);
					if($tempData != '') {
						$ColData .= '<B>Res#: </B>'.$chart['stayOver'][$rowId][$colId]['rv_reservation_id']. '
';
						$ColData .= '<B>Res name: </B>'.$chart['stayOver'][$rowId][$colId]['rv_res_name']. '
';
						$ColData .= $tempData;
						array_push($resIds, $chart['stayOver'][$rowId][$colId]['rv_reservation_id']);
					}
				}
			}
			
			if($chart['depart'][$rowId][$colId]['rv_reservation_id']) {
				if(!in_array($chart['depart'][$rowId][$colId]['rv_reservation_id'], $resIds)) {
					if(!empty($resIds)) {
						$ColData .= '

';
					}
					$tempData = PerDayDataXLS($chart,'depart', $rowId, $colId, $chartIds, $chartSections);
					if($tempData != '') {
						$ColData .= '<B>Res#: </B>'.$chart['depart'][$rowId][$colId]['rv_reservation_id'] . '
';
						$ColData .= '<B>Res name: </B>'.$chart['depart'][$rowId][$colId]['rv_res_name'].'
';
						$ColData .= $tempData;
						array_push($resIds,$chart['depart'][$rowId][$colId]['rv_reservation_id']);
					}
				}
			}
		}
	}
	$rowIds = $chartIds[$type];
	$perDayIds = $chartIds['perDay'];
	if($chart['detailAs'] == '1') {
		$mrgDown = count($rowIds)-(1+count($perDayIds)-count(array_diff($perDayIds, $rowIds)));
	} else {
		$mrgDown = 0;
	}
		
	$cell = $xls->Cell(array('type'=>'String', 'data'=>$ColData), $perDayCellStyleId,'', '', '', '', $colspnVal);
	array_push($cellArr, $cell);
	array_push($mainArr, $cellArr);
	$cellArr = array();
		
	return $mainArr;
}

function cretaePerDayDetailsRowsXLS(&$xls, $chart, $type, $rowIdsArr, $chartIds, $chartSections, $colspnVal) {
	$tempArr = array();
	$mainArr = array();
	$cellArr = array();

	$perDayCellStyle = array( 
		'interior' => array('Pattern'=>'Solid'),
		'border' => array(array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1'),
					array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1'), 
					array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1'), 
					array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1'))
	);
			
	$perDayCellStyleId = $xls->addStyle($perDayCellStyle);
	$mainArr[0]= array();
	$x = 1;
	if($chart['sep_asd'] == '1') {
		$mainArr[$x] = array();
		$x++;
	}
	if($chart['detailAs'] == '1') {
		$mainArr[$x] = array();
	}

	$resCount = 0;
	foreach ( $chart['columns'] as $col ) {
		$resIds = array();
		$ColData = '';
		
		foreach($rowIdsArr as $rowId) {
			if($chart['sep_asd'] == '3') {
				if($chart[$type][$rowId][$col['id']]['rv_reservation_id']) {
					if(!in_array($chart[$type][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
						if(!empty($resIds)) {
							$ColData .= '

';
						}
						$tempData = PerDayDataXLS($chart,$type, $rowId, $col['id'], $chartIds, $chartSections);
						if($tempData != '') {
							$ColData .= '<B>Res#: </B>'.$chart[$type][$rowId][$col['id']]['rv_reservation_id'] .'
';
							$ColData .= '<B>Res name: </B>'.$chart[$type][$rowId][$col['id']]['rv_res_name']. '
';
							$ColData .= $tempData;
							array_push($resIds, $chart[$type][$rowId][$col['id']]['rv_reservation_id']);
						}
					}
				}
			} else {
				if($chart['room'][$rowId][$col['id']]['rv_reservation_id']) {
					if(!in_array($chart['room'][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
						if(!empty($resIds)) {
							$ColData .= '

';
						}
						$tempData = PerDayDataXLS($chart,'room', $rowId, $col['id'], $chartIds, $chartSections);
						if($tempData != '') {
							$ColData .= '<B>Res#: </B>'.$chart['room'][$rowId][$col['id']]['rv_reservation_id'].'
';
							$ColData .= '<B>Res name: </B>'.$chart['room'][$rowId][$col['id']]['rv_res_name'].'
';
							$ColData .= $tempData;
							array_push($resIds, $chart['room'][$rowId][$col['id']]['rv_reservation_id']);
						}
					}
				}
				
				if($chart['combArrSty'] == '2' && $chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']) {
					if(!in_array($chart['stayOver'][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
						if(!empty($resIds)) {
							$ColData .= '

';
						}
						$tempData = PerDayDataXLS($chart,'stayOver',$rowId,$col['id'],$chartIds, $chartSections);
						if($tempData != '') {
							$ColData .= '<B>Res#: </B>'.$chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']. '
';
							$ColData .= '<B>Res name: </B>'.$chart['stayOver'][$rowId][$col['id']]['rv_res_name']. '
';
							$ColData .= $tempData;
							array_push($resIds, $chart['stayOver'][$rowId][$col['id']]['rv_reservation_id']);
						}
					}
				}
				
				if($chart['depart'][$rowId][$col['id']]['rv_reservation_id']) {
					if(!in_array($chart['depart'][$rowId][$col['id']]['rv_reservation_id'], $resIds)) {
						if(!empty($resIds)) {
							$ColData .= '

';
						}
						$tempData = PerDayDataXLS($chart,'depart',$rowId, $col['id'], $chartIds, $chartSections);
						if($tempData != '') {
							$ColData .= '<B>Res#: </B>'.$chart['depart'][$rowId][$col['id']]['rv_reservation_id'].'
';
							$ColData .= '<B>Res name: </B>'.$chart['depart'][$rowId][$col['id']]['rv_res_name'].'
';
							$ColData .= $tempData;
							array_push($resIds,$chart['depart'][$rowId][$col['id']]['rv_reservation_id']);
						}
					}
				}
			}
		}
		$resCount = max(count($resIds), $resCount);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>$ColData), $perDayCellStyleId,'', '', '', '', $colspnVal);
		array_push($cellArr, $cell);
		array_push($mainArr, $cellArr);
		$cellArr = array();
	}

	$resCount = $resCount*(count($chartIds['perDay'])+3);
	$extra = '';
	for($i=0; $i<$resCount; $i++) {
		$extra = $extra.'
';
	}

	$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'.$extra), $perDayCellStyleId);
	array_push($cellArr, $cell);
	$mainArr[0]= $cellArr;
	$cellArr = array();
	
	$x = 1;
	if($chart['sep_asd'] == '1') {
		$cell = $xls->Cell(array('type'=>'String', 'data'=>''.$extra), $perDayCellStyleId);
		array_push($cellArr, $cell);
		$mainArr[$x] = $cellArr;
		$cellArr = array();
		$x++;
	}
	if($chart['detailAs'] == '1') {
		$cell = $xls->Cell(array('type'=>'String', 'data'=>''.$extra), $perDayCellStyleId);
		array_push($cellArr, $cell);
		$mainArr[$x] = $cellArr;
		$cellArr = array();
	}
	
	return $mainArr;
}

function createInnerRoomDetailsXLS(&$xls, $chart,$type, $rowId, $colId, $chartIds, $chartSections) {
	$colWidth = 200;
	$showIds   = $chartIds['room'];
	$colourIds = $chartIds['colour'];
	$departIds = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds = $chartIds['perDay'];
	$combinedIds = $chartIds['combined'];
	$row = isset($row) ? $row : array();

	$roomRowSpans	= getRowSpans($chart,"room",$showIds);
	$departRowSpans	= getRowSpans($chart,"depart",$departIds);
	$stayOverRowSpans	= getRowSpans($chart,"stayOver",$stayOverIds);

	if($chart['sep_asd'] == '2') {
		$rowSpans_room = getCommonRowSpan($chart, $showIds, $rowId, 'room');
		$rowSpans_stayOver = getCommonRowSpan($chart, $stayOverIds, $rowId, 'stayOver');
		$rowSpans_depart = getCommonRowSpan($chart, $departIds, $rowId, 'depart');
	} else {
		$row['id'] = isset($row['id']) ? $row['id'] : "";
		$rowSpans_room = isset($roomRowSpans[$row['id']]) ? $roomRowSpans[$row['id']] : "";
		$rowSpans_depart = isset($departRowSpans[$row['id']]) ? $departRowSpans[$row['id']] : "";
		$rowSpans_stayOver = isset($stayOverRowSpans[$row['id']]) ? $stayOverRowSpans[$row['id']] : "";
	}
	
	$tempArr = array();
	$mainArr = array();
	$initialColour	  = array(0xff,0xff,0xff);
	$initialFontColour  = array(0x00,0x00,0x00);

	$d = isset($chart[$type][$rowId][$colId]) ? $chart[$type][$rowId][$colId] : "";
	$b = isset($chart['block'][$rowId][$colId]) ? $chart['block'][$rowId][$colId] : "";
		
	$initialColour = array(0xf2,0xf2,0xf2);
	if ( $b != "" ) {
		$initialColour = array(0xc0,0xc0,0xc0);			
	}

	$colour		= $initialColour;
	$fontColour = $initialFontColour;

	$first = true;
	$error = false;
			
	if($chart['sep_asd'] == '2') {
		if($chart['detailAs'] == '2') {
			foreach ($showIds as $departId ) {
				$dataType = getHeaderAtr($chartSections, $departId, 'numeric');
				if(!in_array($departId, $perDayIds)) {
					$cell = createRoomDetailXLS($xls, $chart, 'room', $departId, $colourIds, $rowId, $colId, 2, $rowSpans_room, $dataType);
					array_push($mainArr, $cell);
					$tempArr = array();
				}
			}
							
			if($chart['combArrSty'] == '2') {
				foreach ($stayOverIds as $departId ) {
					$dataType = getHeaderAtr($chartSections, $departId, 'numeric');
					if(!in_array($departId, $perDayIds)) {
						$cell= createRoomDetailXLS($xls, $chart, 'stayOver', $departId, $colourIds, $rowId, $colId, 2, $rowSpans_stayOver, $dataType);
						array_push($mainArr, $cell);
						$tempArr = array();
					}
				}
			}
			
			foreach ($departIds as $departId ) {
				$dataType = getHeaderAtr($chartSections, $departId, 'numeric');
				if(!in_array($departId, $perDayIds)) {
					$cell = createRoomDetailXLS($xls, $chart,'depart', $departId, $colourIds, $rowId, $colId, 2, $rowSpans_depart, $dataType);
					array_push($mainArr, $cell);
					$tempArr = array();
				}
			}	
		} else {
			$tempArr = createRoomDetailsAsRowXLS($xls, $chartIds, $chart, $chartSections, 'room', $rowId, $colId);
			array_push($mainArr, $tempArr);
			$tempArr = array();

			if($chart['combArrSty'] == '2') {
				$tempArr = createRoomDetailsAsRowXLS($xls, $chartIds, $chart, $chartSections, 'stayOver', $rowId, $colId);
				array_push($mainArr, $tempArr);
				$tempArr = array();
			}

			if(count($departIds)>0) {
				$tempArr = createRoomDetailsAsRowXLS($xls, $chartIds, $chart, $chartSections, 'depart', $rowId, $colId);
				array_push($mainArr, $tempArr);
				$tempArr = array();
			}
		}
		
	} else {
		if($chart['detailAs'] == '2') {
			if($chart['sep_asd'] == '3') {
				$detailIds = $chartIds[$type];
			} else {
				$detailIds = $combinedIds;
			}

			foreach ($detailIds as $showId) {
				$dataType = getHeaderAtr($chartSections, $showId, 'numeric');
				if(!in_array($showId, $perDayIds)) {
					$cell = createRoomDetailXLS($xls, $chart, $type, $showId, $colourIds, $rowId, $colId, 2,$rowSpans_room, $dataType);
					array_push($mainArr, $cell);
					$tempArr = array();
				}
			}
		} else {
			$tmpArr = createRoomDetailsAsRowXLS($xls, $chartIds, $chart, $chartSections, $type, $rowId, $colId);
			array_push($mainArr, $tmpArr);
			
		} 
	}
	return $mainArr;
}

function generateXLSNotes($noteSections,$noteIds,$notes,$noteSort, $notesHeader, &$xls) {
	$html = '';
	define('NOTECOLWIDTH',130);
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$header_styleArr = array( 
		'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
		'border' => array($borderL, $borderR, $borderT, $borderB),
		'font' => array('Bold' => '1', 'Size' => '8')
	);
	$sub_header_style = array( 
		'border' => array($borderL, $borderR, $borderT, $borderB),
		'font' => array('Bold' => '1', 'Size' => '8')
	);

	$cell_style = array( 
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
	$cell_styleLRT = array( 
		'border' => array($borderL, $borderR, $borderT)
	);
	$cell_styleLR = array( 
		'border' => array($borderL,$borderR)
	);

	$header_styleId = $xls->addStyle($header_styleArr);
	$sub_header_styleId = $xls->addStyle($sub_header_style);
	$cell_styleId = $xls->addStyle($cell_style);
	$cell_styleIdLRT = $xls->addStyle($cell_styleLRT);
	$cell_styleIdLR = $xls->addStyle($cell_styleLR);
	
	/* ---------------------------------------------------------------------------
		ORDER FOR NOTES:  (new as per Jill - 2011-07-12)
		 Itinerary Summary
		 Room lock reason
		 Notes
		 Memos
		 Guest information
		 Guest Details
		>Nationality
		>Source
		>Rate type
		>Payment plan
		>Agent
		>Contact person
		>Originator
		>Consultant
		 Extras
		 Extras notes
		 Extras memos
		 Travel
		 Travel notes
		 Travel memos
		>Financials
	---------------------------------------------------------------------------	*/
	$mainColHeading = array();
	if ( count($notes) > 0 ) {
		$mainColHeading = genrateNotesHeader($noteSort, $notesHeader);
		
		$xls->Column(NOTECOLWIDTH,2,0);
		$xls->Column(60,2,0);
		$xls->Column(70,2,0);
		$xls->Column(70,2,0);
		$xls->Column(70,2,0);
		$xls->Column(80,2,0);
		$xls->Column(80,2,0);
		$xls->Column(100,2,0);
		$xls->Column(50,2,0);
		$xls->Column(50,2,0);
		
		$cell = $xls->Cell(array('type'=>'String', 'data' => $mainColHeading[0]), $header_styleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $mainColHeading[1]), $header_styleId, '', '', '', '', '1');
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $mainColHeading[2]), $header_styleId, '', '', '', '', '1');
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $mainColHeading[3]), $header_styleId, '', '', '', '', '1');
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $mainColHeading[4]), $header_styleId, '', '', '', '', '2');
		array_push($cells, $cell);

		$row = $xls->Row($cells);
		array_push($rows,$row);
		$cells = array();

		$rowCount = 2;
		foreach ( $notes as $item ) {
			// Used to suppress reservations with no notes --------------------------
			
			$title = array();
			$mainColHeading = array();
			if ( count($item) > 0 ) {
				/* -------------------------------------------------------------------------
					TITLE SORT ORDER
					1: Arrival date
					2: Departure date
					3: Reservation ID
					4: Reservation name
					5: Property
				------------------------------------------------------------------------- */
				$title = genrateNotesHeader($noteSort, $notesHeader, 0, $item);
				
				$cell = $xls->Cell(array('type'=>'String', 'data' => $title[0]), $header_styleId);
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => $title[1]), $header_styleId, '', '', '', '', '1');
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => $title[2]), $header_styleId, '', '', '', '', '1');
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => $title[3]), $header_styleId, '', '', '', '', '1');
				array_push($cells, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data' => $title[4]), $header_styleId, '', '', '', '', '2');
				array_push($cells, $cell);

				$row = $xls->Row($cells);
				array_push($rows,$row);
				$cells = array();
				$rowCount++;

				// [START] Voucher ---------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resVoucher"),$noteIds) ) {
					if ( isset($item['voucher']) && $item['voucher'] != "" ) {
						$note_exists = true;
						$data  = $item['voucher'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Voucher'),$cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
					}
				}
				// [ END ] Voucher ---------------------------------------------------------
				
				// [START] Internal Consultant --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resIntConsultant"),$noteIds) ) {
					if ( isset($item['intconsultant']) && trim($item['intconsultant']) != "" ) {
						$note_exists = true;
						$data  = $item['intconsultant'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Internal Consultant'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Internal Consultant --------------------------------------------------
				
				// [START] Status ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resStatus"),$noteIds) ) {
					if ( isset($item['status']) && $item['status'] != "" ) {
						$note_exists = true;
						$data  = $item['status'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Status'),$cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
					}
				}
				// [ END ] Status ----------------------------------------------------------
				
				// [START] Itinerary Summary -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"itinerarySum"),$noteIds) ) {
					
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Itinerary summary'), $cell_styleIdLRT);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Arrive'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Depart'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Night'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Property'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Accomm'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Rms'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Ad'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Chld'), $sub_header_styleId);
					array_push($cells, $cell);
					
					$row = $xls->Row($cells);
					array_push($rows,$row);
					$cells = array();
					
					$roomRequestFootnotes = array();
					foreach ( $item['itinerary'] as $itinerary ) {

						if ($itinerary['rv_room_requested_yn'] == 1){
							$room = $itinerary['room']."*";
						} else {
							$room = $itinerary['room'];
						}					
					
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$room), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['resArrive']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['resDepart']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['nights']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['propName']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$itinerary['accom']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['rooms']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['adults']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$itinerary['childs']), $cell_styleId);
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();

						if (isset($itinerary['rv_room_request_reason']) && $itinerary['rv_room_request_reason'] != ""){
							$roomRequestFootnotes[] = "* " . nl2br($itinerary['room']) . ": " . nl2br($itinerary['rv_room_request_reason']);
						}	
					}
					$cells = array();
					foreach ($roomRequestFootnotes as $roomRequest){
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomRequest), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();					
					}					
						
				}
				// [ END ] Itinerary Summary -----------------------------------------------

				// [START] Reservation Notes -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNote"),$noteIds) ) {
					if ( isset($item['rv_note_general']) && $item['rv_note_general'] != "" ) {
						$note_exists = true;
						$data  = $item['rv_note_general'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Notes'),$cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
					}
				}
				// [ END ] Reservation Notes -----------------------------------------------

				// [START] Internal Memos --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resMemo"),$noteIds) ) {
					if ( isset($item['rv_note_internal']) && trim($item['rv_note_internal']) != "" ) {
						$note_exists = true;
						$data  = $item['rv_note_internal'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Memos'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Internal Memos --------------------------------------------------

				// [START] Guest information -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"guestNote"),$noteIds) ) {
					if ( isset($item['rv_note_guests']) && trim($item['rv_note_guests']) != "" ) {
						$note_exists = true;
						$data  = $item['rv_note_guests'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest information'), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Guest information -----------------------------------------------

				// [START] Guest Details--------------------------------------
				if ( in_array(findSectionId($noteSections,"guestSpecific"),$noteIds) && !empty($item['guests'] )) {
					
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest details'), $cell_styleIdLRT);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest names'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Nationality'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Last Dep'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String','data'=>'Visits'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'B-day'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Anniv'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Notes'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Memos'), $sub_header_styleId, '', '', '', '', '0');
					array_push($cells, $cell);

					$row = $xls->Row($cells);
					array_push($rows,$row);
					$cells = array();

					$event_styleArr = array( 
						'interior' => array('Color' => '#8d9ce7', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT, $borderB),
						'font' => array('Size' => '8')
						);
					$event_styleId = $xls->addStyle($event_styleArr);
										
					foreach ( $item['guests'] as $guests ) {
						$note_data = $guests['pr_guest_note'];
						$memo_data = $guests['pr_guest_memo'];
						$birthday = $guests['pr_birthdate'] != '0000-00-00'? $guests['pr_birthdate']:'';
						$anivrsry = $guests['pr_anniversary'] != '0000-00-00'? $guests['pr_anniversary']:'';
						
						$birthStyleId = '';
						if($guests['has_birthday'] == 1) {
							$birthStyleId = $event_styleId;
						} else {
							$birthStyleId = $cell_styleId;
						}

						if($guests['has_anniversary'] == 1) {
							$annhStyleId = $event_styleId;
						} else {
							$annhStyleId = $cell_styleId;
						}
							
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['ac_desc']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['pr_name']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['nationality']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$guests['last_depart']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'Number', 'data'=>$guests['total_visit']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$birthday), $birthStyleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$anivrsry), $annhStyleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$note_data), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$memo_data), $cell_styleId, '', '', '', '', '0');
						array_push($cells, $cell);

						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
					}
				}
				
				// [ END ] Guest Details --------------------------------------

				// [START] Nationality -----------------------------------------------
				if ( in_array(findSectionId($noteSections,"resNationality"),$noteIds) ) {
					if ( isset($item['nationality']) && trim($item['nationality']) != "" ) {
						$note_exists = true;
						$data  = $item['nationality'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Res nationality'), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Nationality -----------------------------------------------
				
				// [START] Extras ----------------------------------------------------------
				if ( in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"travel"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
					if(!empty($item['extras']) || !empty($item['travel'])) {
						$title = 'Extras';
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$title), $cell_styleIdLRT);
						array_push($cells, $cell);
						$span = 8;
						if(in_array(findSectionId($noteSections,"extras"),$noteIds) || in_array(findSectionId($noteSections,"travel"),$noteIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
							array_push($cells, $cell);
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Travel'), $sub_header_styleId);
							array_push($cells, $cell);
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Date'), $sub_header_styleId);
							array_push($cells, $cell);
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Qty'), $sub_header_styleId);
							array_push($cells, $cell);
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Category'), $sub_header_styleId);
							array_push($cells, $cell);
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Desc'), $sub_header_styleId);
							array_push($cells, $cell);
							$span = 2;
						}
						if(
							(in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds))
							&& (in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds))
						) {
							$span = ((int) $span / 2)-1;
							$noteSpan = $span;
							$memoSpan = $span+1;
						} else {
							$noteSpan = $memoSpan = $span;
						}
						if(in_array(findSectionId($noteSections,"extraNote"),$noteIds) || in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Notes'), $sub_header_styleId, '', '', '', '', $noteSpan);
							array_push($cells, $cell);
						}
						if(in_array(findSectionId($noteSections,"extraMemo"),$noteIds) || in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Memos'), $sub_header_styleId, '', '', '', '', $memoSpan);
							array_push($cells, $cell);
						}
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
										
						if(!empty($item['extras'])) {
							foreach ( $item['extras'] as $extra ) {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
								array_push($cells, $cell);
								if(in_array(findSectionId($noteSections,"extras"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extra['ac_desc']), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'-'), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extra['rv_extra_date_serv']), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'Number', 'data'=>$extra['rv_extra_units']), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extra['ac_extra_cat_desc']), $cell_styleId);
									array_push($cells, $cell);
									$extra_desc = '';
									if ( in_array(findSectionId($noteSections,"extras"),$noteIds) ) {
										$extra_desc = $extra['ac_ext_desc'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extra_desc), $cell_styleId);
									array_push($cells, $cell);									
								} elseif(in_array(findSectionId($noteSections,"travel"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'Number', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
								}
								
								if(in_array(findSectionId($noteSections,"extraNote"),$noteIds)) {
									$extras_note = '';
									if ( in_array(findSectionId($noteSections,"extraNote"),$noteIds) ) {
										$extras_note = $extra['rv_extra_note'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extras_note), $cell_styleId, '', '', '', '', $noteSpan);
									array_push($cells, $cell);
								} elseif(in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId, '', '', '', '', $noteSpan);
									array_push($cells, $cell);
								}

								if(in_array(findSectionId($noteSections,"extraMemo"),$noteIds)) {
									$extras_memo = '';
									if ( in_array(findSectionId($noteSections,"extraMemo"),$noteIds)) {
										$extras_memo = $extra['rv_extra_note_internal'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extras_memo), $cell_styleId, '', '', '', '', $memoSpan);
									array_push($cells, $cell);
								} elseif(in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId, '', '', '', '', $memoSpan);
									array_push($cells, $cell);
								}

								$row = $xls->Row($cells);
								array_push($rows,$row);
								$cells = array();
								$rowCount++;
								$note_exists = true;
							}
						}

						if(!empty($item['travel'])) {
							foreach ( $item['travel'] as $travel ) {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
								array_push($cells, $cell);
								if(in_array(findSectionId($noteSections,"travel"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$extra['ac_desc']), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'Yes'), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel['rv_extra_date_serv']), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'Number', 'data'=>$travel['rv_extra_units']), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel['ac_extra_cat_desc']), $cell_styleId);
									array_push($cells, $cell);
							
									$travel_desc = '';
									if ( in_array(findSectionId($noteSections,"travel"),$noteIds) ) {
										$travel_desc = $travel['ac_ext_desc'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel_desc), $cell_styleId);
									array_push($cells, $cell);
								} elseif(in_array(findSectionId($noteSections,"extras"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'Number', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId);
									array_push($cells, $cell);
								}

								if(in_array(findSectionId($noteSections,"travelNote"),$noteIds)) {
									$travel_note = '';
									if ( in_array(findSectionId($noteSections,"travelNote"),$noteIds) ) {
										$travel_note = $travel['rv_extra_note'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel_note), $cell_styleId, '', '', '', '', $noteSpan);
									array_push($cells, $cell);
								} elseif(in_array(findSectionId($noteSections,"extraNote"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId, '', '', '', '', $noteSpan);
									array_push($cells, $cell);
								}

								if(in_array(findSectionId($noteSections,"travelMemo"),$noteIds)) {
									$travel_memo = '';
									if ( in_array(findSectionId($noteSections,"travelMemo"),$noteIds) ) {
										$travel_memo = $travel['rv_extra_note_internal'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$travel_memo), $cell_styleId, '', '', '', '', $memoSpan);
									array_push($cells, $cell);
								} elseif(in_array(findSectionId($noteSections,"extraMemo"),$noteIds)) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId, '', '', '', '', $memoSpan);
									array_push($cells, $cell);
								}

								$row = $xls->Row($cells);
								array_push($rows,$row);
								$cells = array();
								$rowCount++;
							}
						}
					} 
				}
			
				// [ END ] Extras ----------------------------------------------------------

				// [START] Financials ------------------------------------------------
				if ( in_array(findSectionId($noteSections,"financials"),$noteIds) && !empty($item['financial'] )) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Financials'), $cell_styleIdLRT);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Room'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Folio/Inv'), $sub_header_styleId, '', '', '', '', '1');
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Payee'), $sub_header_styleId, '', '', '', '', '1');
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Total'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Paid'), $sub_header_styleId);
					array_push($cells, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Total due'), $sub_header_styleId, '', '', '', '', '1');
					array_push($cells, $cell);
					
					$row = $xls->Row($cells);
					array_push($rows,$row);
					$cells = array();

					foreach ( $item['financial'] as $financial ) {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleIdLR);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'1'), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'INV '. $financial['fn_invoice_ix']), $cell_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['fn_inv_to']), $cell_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['total']. ' '. $financial['fn_inv_curr']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['paid']. ' ' . $financial['fn_inv_curr']), $cell_styleId);
						array_push($cells, $cell);
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$financial['due']. ' ' . $financial['fn_inv_curr']), $cell_styleId, '', '', '', '', '1');
						array_push($cells, $cell);
				
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
					}
				}
				// [ END ] Financials ------------------------------------------------

				// [START] Source --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resSource"),$noteIds) ) {
					if ( isset($item['source']) && trim($item['source']) != "" ) {
						$note_exists = true;
						$data  = $item['source'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Source'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Source --------------------------------------------------

				// [START] Repeat Guests --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resRepeatGuests"),$noteIds) ) {
					if ( isset($item['repeatguests']) && trim($item['repeatguests']) != "" ) {
						$note_exists = true;
						$data  = $item['repeatguests'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Repeat Guests'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Repeat Guests --------------------------------------------------

				// [START] Rate Type --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resRateType"),$noteIds) ) {
					if ( isset($item['ratetype']) && trim($item['ratetype']) != "" ) {
						$note_exists = true;
						$data  = $item['ratetype'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Rate Type'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Rate Type --------------------------------------------------				
				
				// [START] Payment Plan --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resPaymentPlan"),$noteIds) ) {
					if ( isset($item['paymentplan']) && trim($item['paymentplan']) != "" ) {
						$note_exists = true;
						$data  = $item['paymentplan'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Payment Plan'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Payment Plan --------------------------------------------------

				// [START] Agent --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resAgent"),$noteIds) ) {
					if ( isset($item['agent']) && trim($item['agent']) != "" ) {
						$note_exists = true;
						$data  = $item['agent'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Agent'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells,'30', '1');
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Agent --------------------------------------------------		

				// [START] Contact Person --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resContactPerson"),$noteIds) ) {
					if ( isset($item['contactperson'][0]['value']) && trim($item['contactperson'][0]['value']) != "" ) {
						$note_exists = true;
						$data  = $item['contactperson'][0]['value'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Contact Person'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Contact Person --------------------------------------------------

				// [START] Originator --------------------------------------------------
				if ( in_array(findSectionId($noteSections,"resOriginator"),$noteIds) ) {
					if ( isset($item['originator']) && trim($item['originator']) != "" ) {
						$note_exists = true;
						$data  = $item['originator'];
						$cell = $xls->Cell(array('type'=>'String', 'data'=>'Originator'),$cell_styleId);
						array_push($cells, $cell);
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId, '', '', '', '', '8');
						array_push($cells, $cell);
						
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						$rowCount++;
					}
				}
				// [ END ] Originator --------------------------------------------------				

			}
			//a blank row
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $cell_styleId, '', '', '', '', '9');
			array_push($cells, $cell);

			$row = $xls->Row($cells);
			array_push($rows,$row);
			$cells = array();
		}
	}
	return $rows;
}

function outputCSV($data,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$fromDate,$toDate,$propertyFilter, $noteHeader, $showCatExtras="", $reportName="", $repType="xls") {
	define('COLWIDTH',160);
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();
	
	$csv_chart_data = $data['chart'];
	$csv_notes_data = $data['notes'];
		
	$showIds	= $chartIds['room'];
	$colourIds	= $chartIds['colour'];
	$departIds  = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds   = $chartIds['perDay'];
	$combinedIds = $chartIds['combined'];

	if($csv_chart_data['combArrSty'] == '1') {
		$combination = "Inhouse";
	} else {
		$combination = "Arrival";
	}

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$defaultStyle = array( 
		'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
		'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
		'font' => array('Size' => '8')
	);
	
	$xls = new XLS($defaultStyle);

	if($showChart == "1") {

		$borderLRTStyle = array('border' => array($borderL, $borderR, $borderT));
		$borderLTBStyle = array('border' => array($borderL, $borderT, $borderB));
		$borderRTBStyle = array('border' => array($borderR, $borderT, $borderB));
		$borderTBStyle	= array('border' => array($borderB, $borderT));
		$borderLRStyle	= array('border' => array($borderL, $borderR));
		$borderLRTBStyle= array('border' => array($borderL, $borderR, $borderT, $borderB));

		$borderLRTStyleId = $xls->addStyle($borderLRTStyle);
		$borderLTBStyleId = $xls->addStyle($borderLTBStyle);
		$borderTBStyleId = $xls->addStyle($borderTBStyle);
		$borderLRStyleId = $xls->addStyle($borderLRStyle);
		$borderLRTBStyleId = $xls->addStyle($borderLRTBStyle);

		$header_style = array( 
			'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);
						
		$header_styleId = $xls->addStyle($header_style);

		$rowCount =	1;
		$multiCell[$rowCount] = array();
		$xls->Column(130,1,0);
		if ( $csv_chart_data['direction'] == '2' ) {
			$cell = $xls->Cell(array('type'=>'String', 'data'=>'
'));
		} else {
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
		}
		array_push($tempCell, $cell);
		
		if($csv_chart_data['sep_asd'] == '1') {
			$xls->Column(130,1,0);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
			array_push($tempCell, $cell);
		}
		
		if($csv_chart_data['detailAs'] == '1') {
			$xls->Column(130,1,0);
			$hdr_data = '';
			$mrgDown = 0;
			if($csv_chart_data['sep_asd'] == '2') {
				$mrgDown = 1;
			}
			if ( $csv_chart_data['direction'] == '2' ) {
				$hdr_data = 'Details
';
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$hdr_data), $header_styleId);
			} else {
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$hdr_data));
			}
			array_push($tempCell, $cell);
		}

		$numSubCols = 1;
		if($csv_chart_data['sep_asd'] == '2') {
			if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0) {
				$numSubCols += 1;
			}
			if(count($departIds) >0 ) {
				$numSubCols += 1;
			}
		}

		$numDetCols = 0;
		$totalWidth = 0;
		
		if($csv_chart_data['sep_asd'] == '2') {
			if($csv_chart_data['detailAs'] == '2') {
				foreach ( $showIds as $showId ) {
					if(in_array($showId, $perDayIds)) {
						continue;
					} 
					$numDetCols += 1;
				}
				if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0) {
					foreach ( $stayOverIds as $showId ) {
						if(in_array($showId, $perDayIds)) {
							continue;
						} 
						$numDetCols += 1;
					}
				}
				if(count($departIds)>0) {
					foreach ( $departIds as $departId ) {
						if(in_array($departId, $perDayIds)) {
							continue;
						} 
						$numDetCols += 1;
					}
				}
				/*$numDetCols = count($showIds)-(count($perDayIds)-count(array_diff($perDayIds, $showIds)));
				if($csv_chart_data['combArrSty'] == '2') {
					$numDetCols += count($stayOverIds)-(count($perDayIds)-count(array_diff($perDayIds, $stayOverIds)));
				} 
				$numDetCols += count($departIds)-(count($perDayIds)-count(array_diff($perDayIds, $departIds)));*/
			} else {
				$numDetCols = $numSubCols;
			}
		} else {
			if($csv_chart_data['detailAs'] == '2') {
				$numDetCols = count($combinedIds)-(count($perDayIds)-count(array_diff($perDayIds, $combinedIds)));
			}
		}

		$numProp = $numDetCols>0?$numDetCols:1;
		$numTH = count($csv_chart_data['columns']) * $numProp;
		$countCols = count($csv_chart_data['columns']) * $numSubCols;
		$propFlag = 0;
			
		$firstProp = 1;
		$colcount = 1;
		$property_name = '';
		foreach ( $csv_chart_data['columns'] as $col ) {
			if($csv_chart_data['direction'] == "1") {
				if ( $property_name != $col['property'] ) {
					if($firstProp != 1) {
						if(count($chartIds['perDay'])>0) {
							$xls->Column(250,1,0);
						}
					}
					$property_name = $col['property'];
					$firstProp = 0;
				}
			}
			if($csv_chart_data['sep_asd'] == '2') {
				if($csv_chart_data['detailAs'] == '2') {
					foreach ( $showIds as $showId ) {
						if(!empty($perDayIds) && in_array($showId, $perDayIds)) {
							$propFlag++;
							continue;
						}
						$cWidth = getHeaderAtr($chartSections, $showId, 'width');
						$xls->Column($cWidth,1,0);
						$propFlag++;
					}
					if($csv_chart_data['combArrSty'] == '2') {
						foreach ( $stayOverIds as $showId ) {
							if(!empty($perDayIds) && in_array($showId, $perDayIds)) {
								$propFlag++;
								continue;
							}
							$cWidth = getHeaderAtr($chartSections, $showId, 'width');
							$xls->Column($cWidth,1,0);
							$propFlag++;
						}
					}
					foreach ( $departIds as $departId ) {
						if(!empty($perDayIds) && in_array($departId, $perDayIds)) {
							$propFlag++;
							continue;
						}
						$cWidth = getHeaderAtr($chartSections, $departId, 'width');
						$xls->Column($cWidth,1,0);
						$propFlag++;
					}


				} else {
					$xls->Column(COLWIDTH,1,0);
					if($csv_chart_data['combArrSty'] == '2') {
						$xls->Column(COLWIDTH,1,0);
					}
					if(count($departIds)>0) {
						$xls->Column(COLWIDTH,1,0);
					}
				}

			} else {
				if($csv_chart_data['detailAs'] == '2') {
					foreach ( $combinedIds as $showId ) {
						if(!empty($perDayIds) && in_array($showId, $perDayIds)) {
							$propFlag++;
							continue;
						}
						$cWidth = getHeaderAtr($chartSections, $showId, 'width');
						$xls->Column($cWidth,1,0);
						$propFlag++;
					}
				} else {
					$xls->Column(COLWIDTH,1,0);
				}
			}
									
			if($csv_chart_data['direction'] == "1") {
				if($colcount == count($csv_chart_data['columns'])) {
					if(count($chartIds['perDay'])>0) {
						$xls->Column(250,1,0);
					}
				}
				$colcount++;
			}
		}
		
		$colspnVal = $numProp-1;
		
		if ( $csv_chart_data['direction'] == '1' ) {
			// Room names along top
			$property_name = '';
			$modCount = 0;
			$columnCount = 1;
			$firstProp = 1;
			foreach ( $csv_chart_data['columns'] as $col ) {
				if ( $modCount%2 == 0 ) {
					$bg_color = '#FCF3DA';
				} else {
					$bg_color = '#F8E8BB';
				}
				
				if ( $property_name != $col['property'] ) {
					$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderT, $borderB)
							);
						
					$bg_styleId = $xls->addStyle($bg_style);

					if($csv_chart_data['direction'] == "1") {
						if($firstProp != 1) {
							if(count($chartIds['perDay'])>0) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
								array_push($tempCell, $cell);
							}
						}
					}

					$property_name = $col['property'];
					$firstProp = 0;
					$modCount++;

					$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $colspnVal);

				} else {
					if($columnCount == count($csv_chart_data['columns'])) {
						$border = array($borderR, $borderT, $borderB);
					} else {
						$border = array($borderT, $borderB);
					}
					$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => $border
							);
						
					$bg_styleId = $xls->addStyle($bg_style);
					$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId, '', '', '', '', $colspnVal);
				}
				array_push($tempCell, $cell);
				if($csv_chart_data['direction'] == "1") {
					if($columnCount == count($csv_chart_data['columns'])) {
						if(count($chartIds['perDay'])>0) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
								array_push($tempCell, $cell);
							}
					}
				}

				$columnCount++;
			}

			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();
			
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
			array_push($tempCell, $cell);
			
			if($csv_chart_data['sep_asd'] == '1') {
				$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
				array_push($tempCell, $cell);
			}
			if($csv_chart_data['detailAs'] == '1') {
				$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
				array_push($tempCell, $cell);
			}

			// Room names and numbers ---------------------------------------------------
			$property_name = "";
			$modCount = 0;
			
			$firstProp = 1;
			$columnCount = 1;
			foreach ( $csv_chart_data['columns'] as $col ) {
				if ( $property_name != $col['property'] ) {
					if ( $modCount%2 == 0 ) {
						$bg_color = '#FCF3DA';
					} else {
						$bg_color = '#F8E8BB';
					}

					$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderR, $borderT, $borderB)
							);
						
					$bg_styleId = $xls->addStyle($bg_style);

					if($csv_chart_data['direction'] == "1") {
						if($firstProp != 1) {
							if(count($chartIds['perDay'])>0) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => 'Details'), $bg_styleId);
								array_push($tempCell, $cell);
							}
						}
					}
								
					$modCount++;
					$firstProp = 0;
					$property_name = $col['property'];
				}
				
				if ( $hideAccommType == "1" ) {
					$accommCell = "";
				} else {
					$accommCell = (isset($col['accommodation']) ? $col['accommodation'] : "");
				}			
				if ( $showUnitLabel == '1' ) {
					$accommCell .= ' ' . (isset($col['unit_label']) ? $col['unit_label'] : "");
				}
				if ( $showUnitNumber == '1' ) {
					$accommCell .= ' ' . (isset($col['room']) ? $col['room'] : "");
				}
				
				$cell = $xls->Cell(array('type'=>'String', 'data' => $accommCell), $bg_styleId, '', '', '', '', $colspnVal);
				array_push($tempCell, $cell);

				if($csv_chart_data['direction'] == "1") {
					if($columnCount == count($csv_chart_data['columns'])) {
						if(count($chartIds['perDay'])>0) {
							$cell = $xls->Cell(array('type'=>'String', 'data' => 'Details'), $bg_styleId);
							array_push($tempCell, $cell);
						}
					}
				}
				$columnCount++;
			}
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount++;
			$multiCell[$rowCount] = array();

		} else {
			// Dates along top
			$bg_style = array( 
							'interior' => array('Color' => '#F8E8BB', 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderR, $borderT, $borderB)
							);
						
			$bg_styleId = $xls->addStyle($bg_style);

			foreach ( $csv_chart_data['columns'] as $col ) {
				$bg_color = '#F8E8BB';
				if ( isset($col['property']) && $property_name != $col['property'] ) {
					$property_name = $col['property'];
					if ( $modCount%2 == 0 ) {
						$bg_color = '#FCF3DA';
					} else {
						$bg_color = '#F8E8BB';
					}
					$modCount++;
				}
				
				$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderR, $borderT, $borderB)
							);
						
				$bg_styleId = $xls->addStyle($bg_style);

				$thisDate = explode('-',$col['id']);
				$displayDate = date('D',mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
				$dateRow = $displayDate . ' ' . $col['name'];
				if ( $showDatePAX == '1' ) {
					$dateRow .= '
PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
				}
				$cell = $xls->Cell(array('type'=>'String', 'data' => $dateRow), $bg_styleId, '', '', '', '', $colspnVal);
				array_push($tempCell, $cell);
			}
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount++;
			$multiCell[$rowCount] = array();
		}
		
		if($csv_chart_data['sep_asd'] == '2') {
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
			array_push($tempCell, $cell);
			if($csv_chart_data['detailAs'] == '1') {
				$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
				array_push($tempCell, $cell);
			}
			
			$firstProp = 1;
			$columnCount = 1;
			$prop='';
			foreach ( $csv_chart_data['columns'] as $col ) {
				if ( isset($col['property']) && $prop != $col['property'] ) {
					if($csv_chart_data['direction'] == "1") {
						if($firstProp != 1) {
							if(count($chartIds['perDay'])>0) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
								array_push($tempCell, $cell);
							}
						}
					}
								
					$firstProp = 0;
					$prop = $col['property'];
				}

				$spn = 0;
				$spnRoom = 0;
				$spnSO = 0;
				$spnDep = 0;
				if($csv_chart_data['detailAs'] == '2') {
					$spn = count($showIds) - (1+count($perDayIds));
					if(count($showIds)>0) {
						$spnRoom = count($showIds)-(1+count($perDayIds)-count(array_diff($perDayIds, $showIds)));
					}
					if(count($stayOverIds)>0) {
						$spnSO = count($stayOverIds)-(1+count($perDayIds)-count(array_diff($perDayIds, $stayOverIds)));
					}
					if(count($departIds)>0) {
						$spnDep = count($departIds)-(1+count($perDayIds)-count(array_diff($perDayIds, $departIds)));
					}
				}
				
				
				if(count($showIds)>0) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => $combination), $bg_styleId, '', '', '', '', $spnRoom);
					array_push($tempCell, $cell);
				}
				if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => 'Stay Over'), $bg_styleId, '', '', '', '', $spnSO);
					array_push($tempCell, $cell);
				} 
				if(count($departIds)>0) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => 'Depart'), $bg_styleId, '', '', '', '', $spnDep);
					array_push($tempCell, $cell);
				}
				
				if($csv_chart_data['direction'] == "1") {
					if($columnCount == count($csv_chart_data['columns'])) {
						if(count($chartIds['perDay'])>0) {
							$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
							array_push($tempCell, $cell);
						}
					}
					$columnCount++;
				}
			}
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount++;
			$multiCell[$rowCount] = array();
		}
		
		if($csv_chart_data['detailAs'] == '2') {
			$tmpCellNxt = array();
			$indexCounter = 1;
			$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
			array_push($tempCell, $cell);
			$indexCounter++;
			if($csv_chart_data['sep_asd'] == '1') {
				$cell = $xls->Cell(array('type'=>'String', 'data'=>''), '', '', '', '', '', 0, 1);
				array_push($tempCell, $cell);
				$indexCounter++;
			}

			$firstProp = 1;
			$columnCount = 1;
			$property_name = '';
			foreach ( $csv_chart_data['columns'] as $col ) {
				if ( $property_name != $col['property']) {
					if ( $modCount%2 == 0 ) {
						$bg_color = '#FCF3DA';
					} else {
						$bg_color = '#F8E8BB';
					}

					$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderR, $borderT, $borderB)
							);
						
					$bg_styleId = $xls->addStyle($bg_style);

					if($csv_chart_data['direction'] == "1") {
						if($firstProp != 1) {
							if(count($chartIds['perDay'])>0) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId, '', '', '', '', 0, 1);
								array_push($tempCell, $cell);
								$indexCounter++;
							}
						}
					}
								
					$modCount++;
					$firstProp = 0;
					$property_name = $col['property'];
				}
				if($csv_chart_data['sep_asd'] == '2') {
					$lastHeader = "";
					$lastHeaderCount = 0;
					foreach ( $chartSections as $item ) {
						foreach ( $showIds as $showId ) {
							if(in_array($showId, $perDayIds)) {
								continue;
							}
							if ( $item['id'] == $showId ) {
								if($lastHeader != "" && $lastHeader != $item['header']) {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
									array_push($tempCell, $cell);
									//$indexCounter++;
									
									$lastHeader = "";
									$lastHeaderCount = 0;
								}
								
								if(isset($item['header']) && $item['header'] != "") {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
									array_push($tmpCellNxt, $cell);
									$lastHeader = $item['header'];
									//$indexCounter++;
									$lastHeaderCount++;
								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
									array_push($tempCell, $cell);
									//$indexCounter++;
								}
								$indexCounter++;
								break;
							}
						}
					}
					//$indexCounter--;
					if(isset($lastHeader) && $lastHeader != "") {
						$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
						array_push($tempCell, $cell);
						//$indexCounter++;
					}
					
					$lastHeader = "";
					
					
					/*foreach ( $showIds as $showId ) {
						if(!in_array($showId, $perDayIds)) {
							$cell = createDetailHeaderRowXLS($xls, $chartSections, $showId, $bg_styleId);
							array_push($tempCell, $cell);
						}
					} */

					if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0) {
						$lastHeader = "";
						$lastHeaderCount = 0;
						foreach ( $chartSections as $item ) {
							foreach ( $stayOverIds as $showId ) {
								if(in_array($showId, $perDayIds)) {
									continue;
								}
								if ( $item['id'] == $showId ) {
									if($lastHeader != "" && $lastHeader != $item['header']) {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
										array_push($tempCell, $cell);
										//$indexCounter++;
										
										$lastHeader = "";
										$lastHeaderCount = 0;
									}
									if(isset($item['header']) && $item['header'] != "") {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
										array_push($tmpCellNxt, $cell);
										$lastHeader = $item['header'];
										//$indexCounter++;
										$lastHeaderCount++;
									} else {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
										array_push($tempCell, $cell);
										//$indexCounter++;
									}
									$indexCounter++;
									break;
								}
							}
						}
						//$indexCounter--;
						if($lastHeader != "") {
							$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
							array_push($tempCell, $cell);
							//$indexCounter++;
						}
						$lastHeader = "";

						/*foreach ( $stayOverIds as $showId ) {
							if(!in_array($showId, $perDayIds)) {
								$cell = createDetailHeaderRowXLS($xls, $chartSections, $showId, $bg_styleId);
								array_push($tempCell, $cell);
							}
						} */
					} 
					
					$lastHeader = "";
					$lastHeaderCount = 0;
					foreach ( $chartSections as $item ) {
						foreach ( $departIds as $showId ) {
							if(in_array($showId, $perDayIds)) {
								continue;
							}
							if ( $item['id'] == $showId ) {
								if($lastHeader != "" && $lastHeader != $item['header']) {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
									array_push($tempCell, $cell);
									//$indexCounter++;
									
									$lastHeader = "";
									$lastHeaderCount = 0;
								}
								if(isset($item['header']) && $item['header'] != "") {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
									array_push($tmpCellNxt, $cell);
									$lastHeader = $item['header'];
									$lastHeaderCount++;
									//$indexCounter++;
								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
									array_push($tempCell, $cell);
									//$indexCounter++;
								}
								$indexCounter++;
								break;
							}
						}
					}
					//$indexCounter--;
					if($lastHeader != "") {
						$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
						array_push($tempCell, $cell);
						//$indexCounter++;
					}
					$lastHeader = "";

					/*foreach ( $departIds as $departId ) {
						if(!in_array($departId, $perDayIds)) {
							$cell= createDetailHeaderRowXLS($xls, $chartSections, $departId,$bg_styleId);
							array_push($tempCell, $cell);
						}
					} */

				} else {
					$lastHeader = "";
					$lastHeaderCount = 0;
					
					foreach ( $chartSections as $item ) {
						foreach ( $combinedIds as $showId ) {
							if(in_array($showId, $perDayIds)) {
								continue;
							}
							
							if ( $item['id'] == $showId ) {
								if($lastHeader != "" && $lastHeader != $item['header']) {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
									array_push($tempCell, $cell);
									//$indexCounter++;
									
									$lastHeader = "";
									$lastHeaderCount = 0;
								}
								if(isset($item['header']) && $item['header'] != "") {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
									array_push($tmpCellNxt, $cell);
									$lastHeader = $item['header'];
									$lastHeaderCount++;
									
								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
									array_push($tempCell, $cell);
									
								}
								$indexCounter++;
								break;
							}
						}
					}
					
					if($lastHeader != "") {
						$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
						array_push($tempCell, $cell);
					}
					$lastHeader = "";
				}
				if($csv_chart_data['direction'] == "1") {
					if($columnCount == count($csv_chart_data['columns'])) {
						if(count($chartIds['perDay'])>0) {
							$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId, "", "", "", "", 0, 1);
							array_push($tempCell, $cell);
							$indexCounter++;
						}
					}
				}
				$columnCount++;
			}
			
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount++;
			$multiCell[$rowCount] = array();
			array_push($multiCell[$rowCount], $tmpCellNxt);
			$tmpCellNxt = array();
			$rowCount++;
			$multiCell[$rowCount] = array();
		}

		$roomRowSpans		= getRowSpans($csv_chart_data,'room',$showIds);
		$departRowSpans		= getRowSpans($csv_chart_data,'depart',$departIds);
		$stayOverRowSpans	= getRowSpans($csv_chart_data,"stayOver",$stayOverIds);

		$showDepartureInfo = true;
		$modcount = 0;
		
		if ( $csv_chart_data['direction'] == '2' ) {
			$property_name = "";
			$anotherCount = 0;
			$firstProperty = 1;
			$rowcounter = 1;
			$rowIdsArr = array();
		}

		$hdr_styleLRT = array( 
						'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT)
						);
		$hdr_styleLRB = array( 
						'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderB)
						);
		$hdr_styleLR = array( 
						'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR)
						);
					
		$hdr_styleIdLRT = $xls->addStyle($hdr_styleLRT);
		$hdr_styleidLRB = $xls->addStyle($hdr_styleLRB);
		$hdr_styleidLR = $xls->addStyle($hdr_styleLR);
		if($showChart == 1) {
			foreach ( $csv_chart_data['rows'] as $row ) {
				if($csv_chart_data['sep_asd'] == '2') {
					if($csv_chart_data['detailAs'] == '2') {
						$rowSpans_room = getCommonRowSpan($csv_chart_data, $showIds, $row['id'], 'room');
						$rowSpans_stayOver = getCommonRowSpan($csv_chart_data, $stayOverIds, $row['id'], 'stayOver');
						$rowSpans_depart = getCommonRowSpan($csv_chart_data, $departIds, $row['id'], 'depart');
					} else {
						$rowSpans_room = getCommonRowSpan($csv_chart_data, $combinedIds, $row['id'], 'room');
						$rowSpans_stayOver = getCommonRowSpan($csv_chart_data, $combinedIds, $row['id'], 'stayOver');
						$rowSpans_depart = getCommonRowSpan($csv_chart_data, $combinedIds, $row['id'], 'depart');
					}
				} else {
					$rowSpans_room = $roomRowSpans[$row['id']];
					$rowSpans_depart = $departRowSpans[$row['id']];
					$rowSpans_stayOver = $stayOverRowSpans[$row['id']];
				}
				$totalSubCellRoom = (!empty($rowSpans_room))?max($rowSpans_room):1;
				$totalSubCellStayOver = (!empty($rowSpans_stayOver))?max($rowSpans_stayOver):1;
				$totalSubCellDepart = (!empty($rowSpans_depart))?max($rowSpans_depart):1;
				
				
				if ( $csv_chart_data['direction'] == '2' ) {
					//$property_name_data = '';
				}
				
				$multiCell[$rowCount] = array();
				if ( $csv_chart_data['direction'] == '1' ) {
					$thisDate	= explode('-',$row['id']);
					$displayDate = date('D',mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
				}

				if ( isset($modCount) && $modCount%2 == 0 ) {
					$bg_color = '#FCF3DA';
				} else {
					$bg_color = '#F8E8BB';
				}

				$bg_style = array( 
					'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderT, $borderB)
				);

				$bg_styleLRT = array( 
					'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderT)
				);
				$bg_styleLRB = array( 
					'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderB)
				);
				$bg_styleLR = array( 
					'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR)
				);

				$b_style = array( 
					'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderT),
					'font' => array('Bold' => '1', 'Size' => '8')
				);
							
				$b_styleId = $xls->addStyle($b_style);
				$bg_styleId = $xls->addStyle($bg_style);
				$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
				$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
				$bg_styleIdLR = $xls->addStyle($bg_styleLR);

				$roomInfoExists = false;
				$stayOverInfoExists = false;
				$departInfoExists = false;
				
				if(is_array($csv_chart_data['columns'])) {
					foreach ( $csv_chart_data['columns'] as $col ) {
						$c = isset($csv_chart_data['room'][$row['id']][$col['id']]) ? $csv_chart_data['room'][$row['id']][$col['id']] : array();
						if ( is_array($c) && count($c) > 0  ) {
							foreach ( $c as $blah ) {
								if ( isset($blah['value']) && $blah['value'] != "" ) {
									$roomInfoExists = true;
								}
							}
						}
					}
				}
				
				if ( count($showIds) > 0 && ($roomInfoExists || $showEmptyRooms == 1)) {
					// [START] Room information row -------------------------------------------
					if ( $csv_chart_data['direction'] == '1' ) {
						$roomInfo = $displayDate . ' ' . $row['name'];
						if ( $showDatePAX == '1' ) {
							$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
						} else {
							$paxCount = '';
						}
						if($csv_chart_data['sep_asd'] == '1') {
							$tempCellGrouping = array();
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$combination), $b_styleId);
							array_push($tempCellGrouping, $cell);
						}
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomInfo.'
'.$paxCount), $b_styleId);
						array_push($tempCell, $cell);
										
						if($csv_chart_data['detailAs'] == '1') {
							$i = 1;
							if($csv_chart_data['sep_asd'] == '2') {
								$detailIds = $combinedIds;
							} else {
								$detailIds = $showIds;
							}
							foreach($detailIds as $showId) {
								if(in_array($showId, $perDayIds)) {
									continue;
								}
								for($count=0; $count<$rowSpans_room[$showId];$count++) {
									if($count == $totalSubCellRoom-1 && $i==count($detailIds)) {
										$styleId = $bg_styleIdLRB;
									}
									else {
										$styleId = $bg_styleIdLR;
									}
									if($i>1) {
										$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
										array_push($tempCell, $cell);
									}
									
									if($csv_chart_data['sep_asd'] == '1' && $i>1) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
										array_push($tempCellGrouping, $cell);
									}
								}
								$i++;
							}
						}
						
						array_push($multiCell[$rowCount], $tempCell);
						if($csv_chart_data['sep_asd'] == '1') {
							array_push($multiCell[$rowCount], $tempCellGrouping);
							$tempCellGrouping = array();
						}
						
					} else {
						$bg_style = array( 
									'interior' => array('Color' => '#F8E8BB', 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderB, $borderT)
									);
								
						$bg_styleLRT = array( 
								'interior' => array('Color' => '#FCF3DA', 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT)
								);
						$bg_styleLRB = array( 
										'interior' => array('Color' => '#FCF3DA', 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderB)
										);
						$bg_styleLR = array( 
										'interior' => array('Color' => '#FCF3DA', 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR)
										);
						$b_style = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderR, $borderT),
									'font' => array('Bold' => '1', 'Size' => '8')
									);
								
						$b_styleId = $xls->addStyle($b_style);
						$bg_styleId = $xls->addStyle($bg_style);
						$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
						$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
						$bg_styleIdLR = $xls->addStyle($bg_styleLR);

						if ( $property_name != $row['property'] ) {
							if($firstProperty != 1) {
								$perDayCount = count($chartIds['perDay']);
								if($perDayCount > 0) {
									$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'room', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
									$rowIdsArr = array();
									foreach ($rowArr as $arr) {
										array_push($multiCell[$rowCount], $arr);
									}

									$tempCell = array();
									$rowCount++;
									$multiCell[$rowCount] = array();
								}
							}
							$firstProperty = 0;
							$property_name = $row['property'];
							if ( $anotherCount%2 == 0 ) {
								$bg_color = '#FCF3DA';
							} else {
								$bg_color = '#F8E8BB';
							}
							$anotherCount++;
							
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$property_name), $bg_styleId);
							array_push($tempCell, $cell);
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$cnt = 1;
							if($csv_chart_data['sep_asd'] == '1') {
								$cnt++;
							}
							if($csv_chart_data['detailAs'] == '1') {
								$cnt++;
							}
							for ($i=1; $i<$numTH+$cnt; $i++) {
								if($i == $numTH+$cnt-1) {
									$border = array($borderR, $borderT, $borderB);
								} else {
									$border = array($borderT, $borderB);
								}
								$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => $border
											);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
								array_push($tempCell, $cell);
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
							}

							$rowCount++;
							$multiCell[$rowCount] = array();		
							$modcount = 1;
						} 
						
						if ( $modcount%2 == 0 ) {
							$bg_color = '#dbc790';
						}
						
						if($csv_chart_data['combArrSty'] == '1') {
							$combination = "Inhouse";
						} else {
							$combination = "Arrival";
						}

						$bg_style = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderT, $borderR)
									);
						$bg_styleLRB = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderR, $borderB)
									);
						$bg_styleLR = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderR)
									);
						
						$b_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT),
								'font' => array('Bold' => '1', 'Size' => '8')
								);
							
						$b_styleId = $xls->addStyle($b_style);
						$bg_styleId = $xls->addStyle($bg_style);
						$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
						$bg_styleIdLR = $xls->addStyle($bg_styleLR);

						if($csv_chart_data['sep_asd'] == '1') {
							$tempCellGrouping = array();
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$combination), $b_styleId);
							array_push($tempCellGrouping, $cell);
						}

						if ( $hideAccommType == "1" ) {
							$room_data = "";
						} else {
							$room_data = $row['accommodation'];
						}						
						if ( $showUnitLabel == '1'  && isset($row['unit_label']) ) {
							$room_data .= ' '.$row['unit_label'];
						}
						if ( $showUnitNumber == '1' && isset($row['room']) ) {
							$room_data .= ' '.$row['room'];
						}
						
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$room_data), $b_styleId);
						array_push($tempCell, $cell);
						
						if($csv_chart_data['detailAs'] == '1') {
							$i = 1;
							if($csv_chart_data['sep_asd'] == '2') {
								$detailIds = $combinedIds;
							} else {
								$detailIds = $showIds;
							}
							foreach($detailIds as $showId) {
								if(in_array($showId, $perDayIds)) {
									continue;
								}
								
								for($count=0; $count<$roomRowSpans[$row['id']][$showId];$count++) {
									if($count == $totalSubCellRoom-1  && $i==count($detailIds)) {
										$styleId = $bg_styleIdLRB;
									}
									else {
										$styleId = $bg_styleIdLR;
									}
									
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
									array_push($tempCell, $cell);
																
									if($csv_chart_data['sep_asd'] == '1' && $i>1) {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
										array_push($tempCellGrouping, $cell);
									}
								}
								$i++;
							}
						}
						
						array_push($multiCell[$rowCount], $tempCell);
						if($csv_chart_data['sep_asd'] == '1') {
							array_push($multiCell[$rowCount], $tempCellGrouping);
							$tempCellGrouping = array();
						}
					}
					
					// [START] Room data headings -------------------------------------------
					if($csv_chart_data['detailAs'] == '1') {
						$tempCell = array();
						$styleFlag = 1;

						$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
						
						$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'room', $row['id'], $col['id'], $xls, $styles);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
					}
					// [ END ] Room data headings -----------------------------------------------

					// [START] Room information -------------------------------------------------
					$firstProp = 1;
					$columnCount = 1;
					$prop = '';
					$colIds = array();
					foreach ( $csv_chart_data['columns'] as $col ) {
						if ( isset($col['property']) && $prop != $col['property'] ) {
							if($csv_chart_data['direction'] == "1") {
								if($firstProp != 1) {
									if(count($chartIds['perDay'])>0) {
										$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data, 'room', $row['id'], $colIds, $chartIds, $chartSections);
										
										foreach ($arr as $tmp) {
											array_push($multiCell[$rowCount], $tmp);
										}
										$tempCell = array();
									}
									$colIds = array();
								}
							}
							$prop = $col['property'];
							$firstProp = 0;
						}

						$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'room', $row['id'], $col['id'], $chartIds, $chartSections);
						
						foreach ($mainArr as $tmp) {
							array_push($multiCell[$rowCount], $tmp);
						}
						$tempCell = array();

						if($csv_chart_data['direction'] == "1") {
							if($columnCount == count($csv_chart_data['columns'])) {
								array_push($colIds, $col['id']);
								if(count($chartIds['perDay'])>0) {
									$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'room', $row['id'], $colIds, $chartIds, $chartSections);
						
									foreach ($arr as $tmp) {
										array_push($multiCell[$rowCount], $tmp);
									}
									$tempCell = array();
								}
								$colIds = array();
							} else {
								array_push($colIds, $col['id']);
							}
							$columnCount++;
						}
					}
					$cells = array();
					$rowCount++;
					$multiCell[$rowCount] = array();
					$bool_room = true;
				} else {
					$bool_room = false;
				} 
				
				
				if($csv_chart_data['sep_asd'] == '1' || ($bool_room == false && $stayOverInfoExists == false && $departInfoExists == false)) {
					// [ START ] Display stay over informatyion ---------------------------------
					
					$bool_stayOver = false;
					$tempCell = array();
					
					if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0) {
						// [START] Stay Over information row ---------------------------------
						foreach ( $csv_chart_data['columns'] as $col ) {
							$d = isset($csv_chart_data['stayOver'][$row['id']][$col['id']]) ? $csv_chart_data['stayOver'][$row['id']][$col['id']] : array();
							if ( is_array($d) && count($d) > 0  ) {
								foreach ( $d as $blah ) {
									if ( isset($blah['value']) && $blah['value'] != "" ) {
										$stayOverInfoExists = true;
									}
								}
							}
						}
						
						if ( count($stayOverIds) > 0 && $stayOverInfoExists) {
							$bool_stayOver = true;
							if ( $csv_chart_data['direction'] == '1' ) {
								$roomInfo = $displayDate . ' ' . $row['name'];
								if ( $showDatePAX == '1' ) {
									$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
								} else {
									$paxCount = '';
								}
								if($bool_room == false){
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomInfo.'
'.$paxCount), $b_styleId);
									array_push($tempCell, $cell);
									
								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $bg_styleIdLR);
									array_push($tempCell, $cell);
									
								}

								if($csv_chart_data['sep_asd'] == '1') {
									$tempCellGrouping = array();
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'Stay Over'), $b_styleId);
									array_push($tempCellGrouping, $cell);
								}

								if($csv_chart_data['detailAs'] == '1') {
									$i = 1;
									if($csv_chart_data['sep_asd'] == '2') {
										$detailIds = $combinedIds;
									} else {
										$detailIds = $stayOverIds;
									}
									foreach($detailIds as $showId) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}
										for($count=0; $count<$rowSpans_stayOver[$showId];$count++) {
											if($count == $totalSubCellStayOver-1 && $i== count($detailIds)) {
												$styleId = $bg_styleIdLRB;
											}
											else {
												$styleId = $bg_styleIdLR;
											}
											if($i>1) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
											
											if($csv_chart_data['sep_asd'] == '1' && $i>1) {
											$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCellGrouping, $cell);
											}
										}
										$i++;
									}
								}
								
								array_push($multiCell[$rowCount], $tempCell);
								if($csv_chart_data['sep_asd'] == '1') {
									array_push($multiCell[$rowCount], $tempCellGrouping);
									$tempCellGrouping = array();
								}
								
							} else {
								if ( $property_name != $row['property'] ) {
									if($firstProperty != 1) {
										$perDayCount = count($chartIds['perDay']);
										if($perDayCount > 0) {
											$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'stayOver', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
											$rowIdsArr = array();

											foreach ($rowArr as $arr) {
												array_push($multiCell[$rowCount], $arr);
											}

											$tempCell = array();
											$rowCount++;
											$multiCell[$rowCount] = array();
										}
									}
									$firstProperty = 0;
									$property_name = $row['property'];
									if ( $anotherCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}
									$anotherCount++;

									$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderT, $borderB)
										);
									
									$bg_styleId = $xls->addStyle($bg_style);

									$cell = $xls->Cell(array('type'=>'String', 'data'=>$property_name), $bg_styleId);
									array_push($tempCell, $cell);
									array_push($multiCell[$rowCount], $tempCell);
									$tempCell = array();
									$cnt = 1;
									if($csv_chart_data['sep_asd'] == '1') {
										$cnt++;
									}
									if($csv_chart_data['detailAs'] == '1') {
										$cnt++;
									}

									for ($i=1; $i<$numTH+$cnt; $i++) {
										if($i == $numTH+$cnt-1) {
											$border = array($borderR, $borderT, $borderB);
										} else {
											$border = array($borderT, $borderB);
										}
										$bg_style = array( 
													'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
													'border' => $border
													);
											
										$bg_styleId = $xls->addStyle($bg_style);
										$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
										array_push($tempCell, $cell);
										array_push($multiCell[$rowCount], $tempCell);
										$tempCell = array();
									}
									$rowCount++;
									$modcount = 1;
									$multiCell[$rowCount] = array();
								}
								if ( $modcount%2 == 0 ) {
									$bg_color = '#dbc790';
								}
								$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT)
											);
									
								$bg_styleId = $xls->addStyle($bg_style);

								$bg_styleLRB = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderR, $borderL, $borderB)
											);
									
								$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);

								$bg_styleLR = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR)
											);
									
								$bg_styleIdLR = $xls->addStyle($bg_styleLR);
												
								$b_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT),
											'font' => array('Bold' => '1', 'Size' => '8')
											);
									
								$b_styleId = $xls->addStyle($b_style);

								if($csv_chart_data['sep_asd'] == '1') {
									$tempCellGrouping = array();
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'Stay Over'), $b_styleId);
									array_push($tempCellGrouping, $cell);
								}

								if ( $hideAccommType == "1" ) {
									$room_data = "";
								} else {
									$room_data = $row['accommodation'];
								}								
								if ( $showUnitLabel == '1' ) {
									$room_data .= ' '.$row['unit_label'];
								}
								if ( $showUnitNumber == '1' ) {
									$room_data .= ' '.$row['room'];
								}
								
								if($bool_room == false){
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$room_data), $b_styleId);
									array_push($tempCell, $cell);
								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $bg_styleIdLR);
									array_push($tempCell, $cell);
								}

								if($csv_chart_data['detailAs'] == '1') {
									$k = 1;
									if($csv_chart_data['sep_asd'] == '2') {
										$detailIds = $combinedIds;
									} else {
										$detailIds = $stayOverIds;
									}
									foreach($detailIds as $showId) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}

										for($count=0; $count<$rowSpans_stayOver[$showId];$count++) {
											if($count == $rowSpans_stayOver[$showId]-1 && $k== count($detailIds)) {
												$styleId = $bg_styleIdLRB;
											}
											else {
												$styleId = $bg_styleIdLR;
											}
											if($k>=2) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
											
											if($csv_chart_data['sep_asd'] == '1' && $k>1) {
											$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCellGrouping, $cell);
											}
										}
										$k++;
									}
								}

								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
								
								if($csv_chart_data['sep_asd'] == '1') {
									array_push($multiCell[$rowCount], $tempCellGrouping);
									$tempCellGrouping = array();
								}
							}

							// [START] StayOver section headings --------------------------------------
							if($csv_chart_data['detailAs'] == '1') {
								$tempCell = array();
								$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
								$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'stayOver', $row['id'], $col['id'], $xls, $styles);
								
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
							}
										
							// [ END ] StayOver section headings -------------------------------------

							// [START] StayOver information -------------------------------------------
							$firstProp = 1;
							$columnCount = 1;
							$prop = '';
							$colIds = array();
							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $prop != $col['property'] ) {
									if($csv_chart_data['direction'] == "1") {
										if($firstProp != 1) {
											if(count($chartIds['perDay'])>0) {
												$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
									
												foreach ($arr as $tmp) {
													array_push($multiCell[$rowCount], $tmp);
												}
												$tempCell = array();
											}
											$colIds = array();
										}
									}
									$prop = $col['property'];
									$firstProp = 0;
								}

								$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'stayOver', $row['id'], $col['id'], $chartIds, $chartSections);
								
								foreach ($mainArr as $tmp) {
									array_push($multiCell[$rowCount], $tmp);
								}
								$tempCell = array();

								if($csv_chart_data['direction'] == "1") {
									if($columnCount == count($csv_chart_data['columns'])) {
										array_push($colIds, $col['id']);
										if(count($chartIds['perDay'])>0) {
											$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
											foreach ($arr as $tmp) {
												array_push($multiCell[$rowCount], $tmp);
											}
											$tempCell = array();
										}
										$colIds = array();
									} else {
										array_push($colIds, $col['id']);
									}
									$columnCount++;
								}
							}
							
							$cells = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						} else {
							$bool_stayOver = false;
						}
					}

					// [ END ] Display stay over informatyion
				
					// [START] Departure information row --------------------------------------
					
					// Here we look at each row and try to determine if there is any departure
					// information in any of the row's columns. If not, then we don't display the departure row
					if(is_array($csv_chart_data['columns'])) {
						foreach ( $csv_chart_data['columns'] as $col ) {
							$d = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : array();
							if ( is_array($d) && count($d) > 0  ) {
								foreach ( $d as $blah ) {
									if ( isset($blah['value']) && $blah['value'] != '' ) {
										$departInfoExists = true;
									}
								}
							}
						}
					}
							
					if ( count($departIds) > 0 && $departInfoExists && $showDepartureInfo ) {
						if($csv_chart_data['sep_asd'] == '1' || ($csv_chart_data['sep_asd'] == '2' && $bool_room == false && $stayOverInfoExists == false)){
						$bool_depart = true;
							if ( $csv_chart_data['direction'] == '1' ) {
								$roomInfo = $displayDate . ' ' . $row['name'];
								$j=1;
								if($csv_chart_data['sep_asd'] == '1') {
									$tempCellGrouping = array();
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'Depart'), $b_styleId);
									array_push($tempCellGrouping, $cell);
								}
								if($bool_room == false && $bool_stayOver == false){
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomInfo), $b_styleId);
									array_push($tempCell, $cell);
								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $bg_styleIdLR);
									array_push($tempCell, $cell);
								}

								if($csv_chart_data['detailAs'] == '1') {
									$i = 1;
									if($csv_chart_data['sep_asd'] == '2') {
										$detailIds = $combinedIds;
									} else {
										$detailIds = $departIds;
									}
									foreach($detailIds as $departId) {
										if(in_array($departId, $perDayIds)) {
											continue;
										}
										for($count=0; $count<$rowSpans_depart[$departId];$count++) {
											if($count == $rowSpans_depart[$departId]-1 && $i== count($detailIds)) {
												$styleId = $bg_styleIdLRB;
											}
											else {
												$styleId = $bg_styleIdLR;
											}
											if($i>=2) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
											
											if($csv_chart_data['sep_asd'] == '1' && $i>1) {
											$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCellGrouping, $cell);
											}
										}
										$i++;
									}
								}
								
								array_push($multiCell[$rowCount], $tempCell);
								if($csv_chart_data['sep_asd'] == '1') {
									array_push($multiCell[$rowCount], $tempCellGrouping);
									$tempCellGrouping = array();
								}
								
							} else {
								if ( $property_name != $row['property'] ) {
									if($firstProperty != 1) {
										$perDayCount = count($chartIds['perDay']);
										if($perDayCount > 0) {
											$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'depart', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
											$rowIdsArr = array();
											foreach ($rowArr as $arr) {
												array_push($multiCell[$rowCount], $arr);
											}

											$tempCell = array();
											$rowCount++;
											$multiCell[$rowCount] = array();
										}
									}
									$firstProperty = 0;
									$pre_rowId = $row['id']; 
									$property_name = $row['property'];
									if ( $anotherCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$anotherCount++;

									$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderT, $borderB)
										);
									
									$bg_styleId = $xls->addStyle($bg_style);
													
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'<B>' . $row['property'] . '</B>'), $bg_styleId);
									array_push($tempCell, $cell);
									$cnt = 1;
									if($csv_chart_data['sep_asd'] == '1') {
										$cnt++;
									}
									if($csv_chart_data['detailAs'] == '1') {
										$cnt++;
									}

									for ($i=1; $i<$numTH+$cnt; $i++) {
										if($i == $numTH+$cnt-1) {
											$border = array($borderR, $borderT, $borderB);
										} else {
											$border = array($borderT, $borderB);
										}
										$bg_style = array( 
													'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
													'border' => $border
													);
											
										$bg_styleId = $xls->addStyle($bg_style);
										$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId);
										array_push($tempCell, $cell);
										array_push($multiCell[$rowCount], $tempCell);
										$tempCell = array();
									}

									array_push($multiCell[$rowCount], $tempCell);
									$tempCell = array();
									$rowCount++;
									$modcount = 1;
									$multiCell[$rowCount] = array();
								}

								if ( $modcount%2 == 0 ) {
									$bg_color = '#dbc790';
								}
								
								$bg_style = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderR, $borderT)
									);
									
								$bg_styleId = $xls->addStyle($bg_style);

								$bg_styleLRB = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderR, $borderL, $borderB)
									);
									
								$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);

								$bg_styleLR = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderR)
									);
									
								$bg_styleIdLR = $xls->addStyle($bg_styleLR);
												
								$b_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT),
										'font' => array('Bold' => '1', 'Size' => '8')
										);
									
								$b_styleId = $xls->addStyle($b_style);
								$j=1;
								if($csv_chart_data['sep_asd'] == '1') {
									$tempCellGrouping = array();
									$cell = $xls->Cell(array('type'=>'String', 'data'=>'Depart'), $b_styleId);
									array_push($tempCellGrouping, $cell);
									//$j++;
								}
								if($bool_room == false && $bool_stayOver == false){
									if ( $hideAccommType == "1" ) {
										$room_data = "";
									} else {
										$room_data = $row['accommodation'];
									}								
									if ( $showUnitLabel == '1' ) {
										$room_data .= ' '.$row['unit_label'];
									}
									if ( $showUnitNumber == '1' ) {
										$room_data .= ' '.$row['room'];
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$room_data), $bg_styleIdLR);
									array_push($tempCell, $cell);

								} else {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $bg_styleIdLR);
									array_push($tempCell, $cell);
								}

								
								if($csv_chart_data['detailAs'] == '1') {
									$i = 1;
									if($csv_chart_data['sep_asd'] == '2') {
										$detailIds = $combinedIds;
									} else {
										$detailIds = $departIds;
									}
									foreach($detailIds as $departId) {
										if(in_array($departId, $perDayIds)) {
											continue;
										}
										for($count=0; $count<$rowSpans_depart[$departId];$count++) {
											if($count == $totalSubCellDepart-1 && $i== count($detailIds)) {
												$styleId = $bg_styleIdLRB;
											}
											else {
												$styleId = $bg_styleIdLR;
											}
											if($i>=2) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
											
											if($csv_chart_data['sep_asd'] == '1' && $i>1) {
											$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCellGrouping, $cell);
											}
										}
										$i++;
									}
								}
																	
								array_push($multiCell[$rowCount], $tempCell);
								if($csv_chart_data['sep_asd'] == '1') {
									array_push($multiCell[$rowCount], $tempCellGrouping);
									$tempCellGrouping = array();
								}
							}

							// [START] Departure section headings --------------------------------------
							if($csv_chart_data['detailAs'] == '1') {
								$tempCell = array();
								$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
								$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'depart', $row['id'], $col['id'], $xls, $styles);
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
							}
							// [ END ] Departure section headings -------------------------------------

							// [START] Departure information -------------------------------------------
							$firstProp = 1;
							$columnCount = 1;
							$prop = '';
							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( isset($col['property']) && $prop != $col['property'] ) {
									if($csv_chart_data['direction'] == "1") {
										if($firstProp != 1) {
											if(count($chartIds['perDay'])>0) {
												$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'depart', $row['id'], $colIds, $chartIds, $chartSections);
									
												foreach ($arr as $tmp) {
													array_push($multiCell[$rowCount], $tmp);
												}
												$tempCell = array();
											} 
											$colIds = array();
										}
									}
									$prop = $col['property'];
									$firstProp = 0;
								}

								$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'depart', $row['id'], $col['id'], $chartIds, $chartSections);
								
								foreach ($mainArr as $tmp) {
									array_push($multiCell[$rowCount], $tmp);
								}
								$tempCell = array();

								if($csv_chart_data['direction'] == "1") {
									if($columnCount == count($csv_chart_data['columns'])) {
										array_push($colIds, $col['id']);
										if(count($chartIds['perDay'])>0) {
											$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'depart', $row['id'], $colIds, $chartIds, $chartSections);
								
											foreach ($arr as $tmp) {
												array_push($multiCell[$rowCount], $tmp);
											}
											$tempCell = array();
										}
										$colIds = array();
									} else {
										array_push($colIds, $col['id']);
									}
									$columnCount++;
								}
							}
							
							$cells = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						}
					} else {
						$bool_depart = false;
					}
				}

				if($csv_chart_data['direction'] == "2") {
					if($rowcounter == count($csv_chart_data['rows'])) {
						array_push($rowIdsArr, $row['id']);
						if(count($chartIds['perDay'])>0) {
							$perDayCount = count($chartIds['perDay']);
								if($perDayCount > 0) {
									$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'room', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
									$rowIdsArr = array();
									
									foreach ($rowArr as $arr) {
										array_push($multiCell[$rowCount], $arr);
									}

									$tempCell = array();
									$rowCount++;
									$multiCell[$rowCount] = array();
								}
						}
					} else {
						array_push($rowIdsArr, $row['id']);
					}
					$rowcounter++;
				}
				
				$modcount++;
				$rowCount++;
			}
		}
			$cells = array();
			$rows = array();
			$temparr=array();
			$headerFlag = true;
			if ( $csv_chart_data['direction'] == "2" ) {
				$hdr_rows = 1;
			} else {
				$hdr_rows = 2;
			}
			if($csv_chart_data['sep_asd'] == '2') {
				$hdr_rows++;
			}
			if($csv_chart_data['detailAs'] == '2') {
				$hdr_rows = $hdr_rows+2;
			}
			
			foreach($multiCell as $rowId=>$temparr) {
				if($rowId<= $hdr_rows) {
					if($headerFlag == true) {
						foreach($temparr as $cellArr) {
							foreach($cellArr as $tmp) {
								array_push($cells,$tmp);
							}
							
							$row = $xls->Row($cells,'25');
							$cells = array();
							array_push($rows,$row);
						}
					}
				}
				else {
					if (isset($temparr[1])) {
						for ($cal=0;$cal<count($temparr[1]);$cal++) {
							for ($crow=0;$crow<count($temparr);$crow++) {
								if(isset($temparr[$crow][$cal]) && $temparr[$crow][$cal] == -1) {
									
								} elseif(isset($temparr[$crow][$cal])) {
									array_push($cells,$temparr[$crow][$cal]);
								}
								else {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
									array_push($cells,$cell);
								}
							}
							
							if(!empty($cells)){
								$row = $xls->Row($cells);
								array_push($rows,$row);
							}
							$cells = array();
						}
					}
				}
				if($rowId==$hdr_rows) {
					$headerFlag = false;
				}
			}




		$table = $xls->Table($rows);
		array_push($tables, $table);
	}	
	// [ END ] Chart -------------------------------------------------------------

	// [START] Notes -------------------------------------------------------------
	if($showNotes == 1) {
		$notesTables = array();
		$note_table = array();
		$note_rows = generateXLSNotes($noteSections,$noteIds, $csv_notes_data, $noteSort, $noteHeader, $xls);
		$note_table = $xls->Table($note_rows,2);
		array_push($notesTables, $note_table);
	}
	// [ END ] Notes -------------------------------------------------------------

	// Build the final XLS file ------------------------------------------------
		
	if($showChart == 1) {
		$xls->Worksheet($tables,1,"chart");
	}
	if($showNotes == 1) {
		$xls->Worksheet($notesTables,2,"notes");
	}
	
	if ($repType == "csvFromXml") {
		$csv = array();
		if($showChart == 1) {
			$csv[] = xmlToCSV("<report>".join("", $rows)."</report>");
		}
		if($showNotes == 1) {
			$csv[] = "\"Notes\"";
			$csv[] = xmlToCSV("<report>".join("", $note_rows)."</report>");
		}

		header("Content-type: text/csv");
		header("Content-Disposition: attachment; filename=" . $reportName);
		header("Pragma: no-cache");
		header("Expires: 0");
		echo join("

", $csv);
		die;
	}

	$xls->genrateWorkbook($reportName, $repType);
}

function outputCSVAsTables($data,$chartSections,$chartIds,$noteSections,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$fromDate,$toDate,$propertyFilter, $noteHeader, $showCatExtras="", $reportName="", $repType="xls") {
	define('COLWIDTH',160);
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();
	$propRoomsArr = array();
	$temparr=array();

	$rowcounter=0;
	$modcount=0;
	$rowCount=0;
	
	$csv_chart_data = $data['chart'];
	$csv_notes_data = $data['notes'];
		
	$showIds	= $chartIds['room'];
	$colourIds	= $chartIds['colour'];
	$departIds  = $chartIds['depart'];
	$stayOverIds = $chartIds['stayOver'];
	$perDayIds   = $chartIds['perDay'];
	$combinedIds = $chartIds['combined'];

	if($csv_chart_data['combArrSty'] == '1') {
		$combination = "Inhouse";
	} else {
		$combination = "Arrival";
	}

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$defaultStyle = array( 
		'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
		'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
		'font' => array('Size' => '8')
	);
	
	$xls = new XLS($defaultStyle);

	if($showChart == "1") {
		$borderLRTStyle = array('border' => array($borderL, $borderR, $borderT));
		$borderLTBStyle = array('border' => array($borderL, $borderT, $borderB));
		$borderRTBStyle = array('border' => array($borderR, $borderT, $borderB));
		$borderTBStyle	= array('border' => array($borderB, $borderT));
		$borderLRStyle	= array('border' => array($borderL, $borderR));
		$borderLRTBStyle= array('border' => array($borderL, $borderR, $borderT, $borderB));

		$borderLRTStyleId = $xls->addStyle($borderLRTStyle);
		$borderLTBStyleId = $xls->addStyle($borderLTBStyle);
		$borderTBStyleId = $xls->addStyle($borderTBStyle);
		$borderLRStyleId = $xls->addStyle($borderLRStyle);
		$borderLRTBStyleId = $xls->addStyle($borderLRTBStyle);

		$header_style = array( 
			'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);
						
		$header_styleId = $xls->addStyle($header_style);

		$hdr_styleLRT = array( 
						'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT)
						);
		$hdr_styleLRB = array( 
						'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderB)
						);
		$hdr_styleLR = array( 
						'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR)
						);
					
		$hdr_styleIdLRT = $xls->addStyle($hdr_styleLRT);
		$hdr_styleidLRB = $xls->addStyle($hdr_styleLRB);
		$hdr_styleidLR = $xls->addStyle($hdr_styleLR);

		$rowCount =	1;
		$multiCell[$rowCount] = array();
		$xls->Column(130,1,0);
		if($csv_chart_data['detailAs'] == '1') {
			$xls->Column(130,1,0);
		}
		
		$numSubCols = 1;
		$numDetCols = 0;
		$totalWidth = 0;
		
		if($csv_chart_data['detailAs'] == '2') {
			$numDetCols = count($combinedIds)-(count($perDayIds)-count(array_diff($perDayIds, $combinedIds)));
		}
		
		$numProp = $numDetCols>0?$numDetCols:1;
		$colspnVal = $numProp-1;
		$numTH = count($csv_chart_data['columns']) * $numProp;
		$countCols = count($csv_chart_data['columns']) * $numSubCols;
		$propFlag = 0;
			
		$firstProp = 1;
		$colcount = 1;
		$property_name = '';

		foreach ( $csv_chart_data['columns'] as $col ) {
			if($csv_chart_data['direction'] == "1") {
				$propRoomsArr[$col['property']] += 1;
			} else {
				if (isset($propRoomsArr[$col['name']])) {
					$propRoomsArr[$col['name']] += 1;
				} else {
					$propRoomsArr[$col['name']] = 1;
				}
			}
		}
		if($csv_chart_data['direction'] == "1") {
			$maxProp = max($propRoomsArr);
		} else {
			$maxProp = count($csv_chart_data['columns']);
		}
		for($i=0; $i<$maxProp; $i++) {
			if($csv_chart_data['detailAs'] == '2') {
				foreach ( $combinedIds as $showId ) {
					if(!empty($perDayIds) && in_array($showId, $perDayIds)) {
						$propFlag++;
						continue;
					}
					$cWidth = getHeaderAtr($chartSections, $showId, 'width');
					$xls->Column($cWidth,1,0);
					$propFlag++;
				}
			} else {
				$xls->Column(COLWIDTH,1,0);
			}
		}

		$extraRows = 1;
		if($csv_chart_data['detailAs'] == '1') {
			$extraRows += 1;
		}

		if ( $csv_chart_data['direction'] == '1' ) {
			if(count($chartIds['perDay'])>0) {
				$xls->Column(250,1,0);
				$extraRows += 1;
			}
		}

		$roomRowSpans		= getRowSpans($csv_chart_data,'room',$showIds);
		$departRowSpans		= getRowSpans($csv_chart_data,'depart',$departIds);
		$stayOverRowSpans	= getRowSpans($csv_chart_data,"stayOver",$stayOverIds);
		
		if ( $csv_chart_data['direction'] == '2' ) {
			$anotherCount = 0;
			$firstProperty = 1;
			$rowcounter = 1;
			$rowIdsArr = array();
		}
		$property_name = "";
		if ( $csv_chart_data['direction'] == '1' ) {
			foreach ( $csv_chart_data['columns'] as $col) {
				if ( $modCount%2 == 0 ) {
					$bg_color = '#FCF3DA';
				} else {
					$bg_color = '#F8E8BB';
				}
				if ( $property_name != $col['property']  && $col['room'] != "overbooking") {
					$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderT, $borderB)
							);
					
					$bg_styleId = $xls->addStyle($bg_style);
					$propColspan = $propRoomsArr[$col['property']]+$extraRows-1;
					$property_name = $col['property'];
					$firstProp = 0;
					$modCount++;
					$roomInfoExists = false;
					foreach ( $csv_chart_data['rows'] as $row ) {
						foreach ( $csv_chart_data['columns'] as $col ) {
							if($property_name == $col['property']) {
								$c = isset($csv_chart_data['room'][$row['id']][$col['id']]) ? $csv_chart_data['room'][$row['id']][$col['id']] : array();
								if ( is_array($c) && count($c) > 0  ) {
									foreach ( $c as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$roomInfoExists = true;
										}
									}
								}
							}
						}
					}
					if(count($showIds) > 0 && $roomInfoExists) {
						$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data' => $combination), $bg_styleId, '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
						array_push($tempCell, $cell);
						
						if($csv_chart_data['detailAs'] == '1') {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
							array_push($tempCell, $cell);
						}

						// Room names and numbers ---------------------------------------------------
						$modCount = 0;
						$columnCount = 1;
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								if ( $modCount%2 == 0 ) {
									$bg_color = '#FCF3DA';
								} else {
									$bg_color = '#F8E8BB';
								}

								$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
										);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$modCount++;
							
							
								if ( $hideAccommType == "1" ) {
									$accommCell = "";
								} else {
									$accommCell = $col['accommodation'];
								}								
								if ( $showUnitLabel == '1' ) {
									$accommCell .= ' ' . $col['unit_label'];
								}
								if ( $showUnitNumber == '1' ) {
									$accommCell .= ' ' . $col['room'];
								}
								
								$cell = $xls->Cell(array('type'=>'String', 'data' => $accommCell), $bg_styleId, '', '', '', '', $colspnVal);
								array_push($tempCell, $cell);

								if($csv_chart_data['direction'] == "1") {
									if($columnCount == count($csv_chart_data['columns'])) {
										if(count($chartIds['perDay'])>0) {
											$cell = $xls->Cell(array('type'=>'String', 'data' => 'Details'), $bg_styleId);
											array_push($tempCell, $cell);
										}
									}
								}
							}
							$columnCount++;
						}
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount++;
						$multiCell[$rowCount] = array();

						if($csv_chart_data['detailAs'] == '2') {
							$tmpCellNxt = array();
							$indexCounter = 1;
							$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
							array_push($tempCell, $cell);
							$indexCounter++;
							if($csv_chart_data['sep_asd'] == '1') {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), '', '', '', '', '', 0, 1);
								array_push($tempCell, $cell);
								$indexCounter++;
							}

							$columnCount = 1;
							
							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $property_name == $col['property'] ) {
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT, $borderB)
											);
										
									$bg_styleId = $xls->addStyle($bg_style);
									$modCount++;
								}
								
								$lastHeader = "";
								$lastHeaderCount = 0;
								
								foreach ( $chartSections as $item ) {
									foreach ( $combinedIds as $showId ) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}
										
										if ( $item['id'] == $showId ) {
											if($lastHeader != "" && $lastHeader != $item['header']) {
												$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
												array_push($tempCell, $cell);
												//$indexCounter++;
												
												$lastHeader = "";
												$lastHeaderCount = 0;
											}
											if(isset($item['header']) && $item['header'] != "") {
												$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
												array_push($tmpCellNxt, $cell);
												$lastHeader = $item['header'];
												$lastHeaderCount++;
												
											} else {
												$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
												array_push($tempCell, $cell);
												
											}
											$indexCounter++;
											break;
										}
									}
								}
								
								if($lastHeader != "") {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
									array_push($tempCell, $cell);
								}
								$lastHeader = "";
								
								if($csv_chart_data['direction'] == "1") {
									if($columnCount == count($csv_chart_data['columns'])) {
										if(count($chartIds['perDay'])>0) {
											$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId, "", "", "", "", 0, 1);
											array_push($tempCell, $cell);
											$indexCounter++;
										}
									}
								}
								$columnCount++;
							}
							
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
							array_push($multiCell[$rowCount], $tmpCellNxt);
							$tmpCellNxt = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						}
						
						foreach ( $csv_chart_data['rows'] as $row ) {
							$rowSpans_room = $roomRowSpans[$row['id']];
							$rowSpans_depart = $departRowSpans[$row['id']];
							$rowSpans_stayOver = $stayOverRowSpans[$row['id']];
							
							$totalSubCellRoom = (!empty($rowSpans_room))?max($rowSpans_room):1;
							$totalSubCellStayOver = (!empty($rowSpans_stayOver))?max($rowSpans_stayOver):1;
							$totalSubCellDepart = (!empty($rowSpans_depart))?max($rowSpans_depart):1;
							
							$multiCell[$rowCount] = array();
							$thisDate	= explode('-',$row['id']);
							$displayDate = date('D',mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
							
							
							if ( $modCount%2 == 0 ) {
								$bg_color = '#FCF3DA';
							} else {
								$bg_color = '#F8E8BB';
							}

							$bg_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT, $borderB)
							);

							$bg_styleLRT = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT)
							);
							$bg_styleLRB = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderB)
							);
							$bg_styleLR = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR)
							);

							$b_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT),
								'font' => array('Bold' => '1', 'Size' => '8')
							);
										
							$b_styleId = $xls->addStyle($b_style);
							$bg_styleId = $xls->addStyle($bg_style);
							$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
							$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
							$bg_styleIdLR = $xls->addStyle($bg_styleLR);

							$roomDayInfoExists = false;
							if(is_array($csv_chart_data['columns'])) {
								foreach ( $csv_chart_data['columns'] as $col ) {
									$c = isset($csv_chart_data['room'][$row['id']][$col['id']]) ? $csv_chart_data['room'][$row['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$roomDayInfoExists = true;
											}
										}
									}
								}
							}
							
							if ( count($showIds) > 0 && ($roomDayInfoExists || $showEmptyRooms == 1)) {
								// [START] Room information row -------------------------------------------
								$roomInfo = $displayDate . ' ' . $row['name'];
								if ( $showDatePAX == '1' ) {
									$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
								} else {
									$paxCount = '';
								}
								if($csv_chart_data['sep_asd'] == '1') {
									$tempCellGrouping = array();
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$combination), $b_styleId);
									array_push($tempCellGrouping, $cell);
								}
									
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomInfo.'
'.$paxCount), $b_styleId);
								array_push($tempCell, $cell);
													
								if($csv_chart_data['detailAs'] == '1') {
									$i = 1;
									$detailIds = $showIds;
									
									foreach($detailIds as $showId) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}
										for($count=0; $count<$rowSpans_room[$showId];$count++) {
											if($count == $totalSubCellRoom-1 && $i==count($detailIds)) {
												$styleId = $bg_styleIdLRB;
											}
											else {
												$styleId = $bg_styleIdLR;
											}
											if($i>1) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
											
											if($csv_chart_data['sep_asd'] == '1' && $i>1) {
											$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCellGrouping, $cell);
											}
										}
										$i++;
									}
								}
								
								array_push($multiCell[$rowCount], $tempCell);
								if($csv_chart_data['sep_asd'] == '1') {
									array_push($multiCell[$rowCount], $tempCellGrouping);
									$tempCellGrouping = array();
								}
									
								// [START] Room data headings -------------------------------------------
								if($csv_chart_data['detailAs'] == '1') {
									$tempCell = array();
									$styleFlag = 1;

									$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
									
									$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'room', $row['id'], $col['id'], $xls, $styles);
									array_push($multiCell[$rowCount], $tempCell);
									$tempCell = array();
								}
								// [ END ] Room data headings -----------------------------------------------

								// [START] Room information -------------------------------------------------
								$firstProp = 1;
								$columnCount = 1;
								$prop = '';
								$colIds = array();
								foreach ( $csv_chart_data['columns'] as $col ) {
									if ( $property_name == $col['property'] ) {
										$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'room', $row['id'], $col['id'], $chartIds, $chartSections);
										
										foreach ($mainArr as $tmp) {
											array_push($multiCell[$rowCount], $tmp);
										}
										$tempCell = array();

										if($columnCount == count($csv_chart_data['columns'])) {
											array_push($colIds, $col['id']);
											if(count($chartIds['perDay'])>0) {
												$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'room', $row['id'], $colIds, $chartIds, $chartSections);
									
												foreach ($arr as $tmp) {
													array_push($multiCell[$rowCount], $tmp);
												}
												$tempCell = array();
											}
											$colIds = array();
										} else {
											array_push($colIds, $col['id']);
										}
									}
									$columnCount++;
									
								}
								$cells = array();
								$rowCount++;
								$multiCell[$rowCount] = array();
								$bool_room = true;
							} else {
								$bool_room = false;
							} 
									
							$modcount++;
							$rowCount++;
						}
						
						$headerFlag = true;
						$hdr_rows = 3;
						
						if($csv_chart_data['detailAs'] == '2') {
							$hdr_rows = $hdr_rows+2;
						}
						
						foreach($multiCell as $rowId=>$temparr) {
							if($rowId<= $hdr_rows) {
								if($headerFlag == true) {
									foreach($temparr as $cellArr) {
										foreach($cellArr as $tmp) {
											array_push($cells,$tmp);
										}
										
										$row = $xls->Row($cells);
										$cells = array();
										array_push($rows,$row);
									}
								}
							} else {
								if (isset($temparr[1])) {
									for ($cal=0;$cal<count($temparr[1]);$cal++) {
										for ($crow=0;$crow<count($temparr);$crow++) {
											if($temparr[$crow][$cal] == -1) {
												
											} elseif($temparr[$crow][$cal]) {
												array_push($cells,$temparr[$crow][$cal]);
											}
											else {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
												array_push($cells,$cell);
											}
										}
										
										if(!empty($cells)){
											$row = $xls->Row($cells);
											array_push($rows,$row);
										}
										$cells = array();
									}
								}
							} 
							if($rowId==$hdr_rows) {
								$headerFlag = false;
							}
						}		
						
						$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $borderTBStyleId, '', '', '', '', $propColspan);
						array_push($cells,$cell);
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						
						$rowCount = 1;
						$multiCell = array();
						$multiCell[$rowCount] = array();
					}
					
					$modcount = 0;
					$stayOverInfoExists = false;
					foreach ( $csv_chart_data['rows'] as $row ) {
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								$d = isset($csv_chart_data['stayOver'][$row['id']][$col['id']]) ? $csv_chart_data['stayOver'][$row['id']][$col['id']] : array();
								if ( is_array($d) && count($d) > 0  ) {
									foreach ( $d as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$stayOverInfoExists = true;
										}
									}
								}
							}
						}
					}
					
					if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0 && $stayOverInfoExists) {
						if(!$roomInfoExists) {
							$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $propColspan);
							array_push($tempCell, $cell);
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount += 1;
							$multiCell[$rowCount] = array();
						}
						$cell = $xls->Cell(array ('type'=>'String', 'data' => 'StayOver'), $bg_styleId, '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
						array_push($tempCell, $cell);
						
						if($csv_chart_data['detailAs'] == '1') {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
							array_push($tempCell, $cell);
						}

						// Room names and numbers ---------------------------------------------------
						$modCount = 0;
						$columnCount = 1;
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								if ( $modCount%2 == 0 ) {
									$bg_color = '#FCF3DA';
								} else {
									$bg_color = '#F8E8BB';
								}

								$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
										);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$modCount++;
							
							
								if ( $hideAccommType == "1" ) {
									$accommCell = "";
								} else {
									$accommCell = $col['accommodation'];
								}								
								if ( $showUnitLabel == '1' ) {
									$accommCell .= ' ' . $col['unit_label'];
								}
								if ( $showUnitNumber == '1' ) {
									$accommCell .= ' ' . $col['room'];
								}
								
								$cell = $xls->Cell(array('type'=>'String', 'data' => $accommCell), $bg_styleId, '', '', '', '', $colspnVal);
								array_push($tempCell, $cell);

								if($csv_chart_data['direction'] == "1") {
									if($columnCount == count($csv_chart_data['columns'])) {
										if(count($chartIds['perDay'])>0) {
											$cell = $xls->Cell(array('type'=>'String', 'data' => 'Details'), $bg_styleId);
											array_push($tempCell, $cell);
										}
									}
								}
							}
							$columnCount++;
						}
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount++;
						$multiCell[$rowCount] = array();

						if($csv_chart_data['detailAs'] == '2') {
							$tmpCellNxt = array();
							$indexCounter = 1;
							$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
							array_push($tempCell, $cell);
							$indexCounter++;
							if($csv_chart_data['sep_asd'] == '1') {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), '', '', '', '', '', 0, 1);
								array_push($tempCell, $cell);
								$indexCounter++;
							}

							$columnCount = 1;
							
							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $property_name == $col['property'] ) {
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT, $borderB)
											);
										
									$bg_styleId = $xls->addStyle($bg_style);
									$modCount++;
															
									$lastHeader = "";
									$lastHeaderCount = 0;
								
									foreach ( $chartSections as $item ) {
										foreach ( $combinedIds as $showId ) {
											if(in_array($showId, $perDayIds)) {
												continue;
											}
											
											if ( $item['id'] == $showId ) {
												if($lastHeader != "" && $lastHeader != $item['header']) {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
													array_push($tempCell, $cell);
													//$indexCounter++;
													
													$lastHeader = "";
													$lastHeaderCount = 0;
												}
												if(isset($item['header']) && $item['header'] != "") {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
													array_push($tmpCellNxt, $cell);
													$lastHeader = $item['header'];
													$lastHeaderCount++;
													
												} else {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
													array_push($tempCell, $cell);
													
												}
												$indexCounter++;
												break;
											}
										}
									}
									
									if($lastHeader != "") {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
										array_push($tempCell, $cell);
									}
									$lastHeader = "";
									
									if($csv_chart_data['direction'] == "1") {
										if($columnCount == count($csv_chart_data['columns'])) {
											if(count($chartIds['perDay'])>0) {
												$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId, "", "", "", "", 0, 1);
												array_push($tempCell, $cell);
												$indexCounter++;
											}
										}
									}
								}
								$columnCount++;
							}
							
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
							array_push($multiCell[$rowCount], $tmpCellNxt);
							$tmpCellNxt = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						}
						
						foreach ( $csv_chart_data['rows'] as $row ) {
							$rowSpans_stayOver = $stayOverRowSpans[$row['id']];
							$totalSubCellStayOver = (!empty($rowSpans_stayOver))?max($rowSpans_stayOver):1;
													
							$multiCell[$rowCount] = array();
							$thisDate	= explode('-',$row['id']);
							$displayDate = date('D',mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
													
							if ( $modCount%2 == 0 ) {
								$bg_color = '#FCF3DA';
							} else {
								$bg_color = '#F8E8BB';
							}

							$bg_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT, $borderB)
							);

							$bg_styleLRT = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT)
							);
							$bg_styleLRB = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderB)
							);
							$bg_styleLR = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR)
							);

							$b_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT),
								'font' => array('Bold' => '1', 'Size' => '8')
							);
										
							$b_styleId = $xls->addStyle($b_style);
							$bg_styleId = $xls->addStyle($bg_style);
							$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
							$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
							$bg_styleIdLR = $xls->addStyle($bg_styleLR);

							$stayOverDayInfoExists = false;
													
							if(is_array($csv_chart_data['columns'])) {
								foreach ( $csv_chart_data['columns'] as $col ) {
									$c = isset($csv_chart_data['stayOver'][$row['id']][$col['id']]) ? $csv_chart_data['stayOver'][$row['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$stayOverDayInfoExists = true;
											}
										}
									}
								}
							}
							
							if ( count($stayOverIds) > 0 && ($stayOverDayInfoExists || $showEmptyRooms == 1)) {
								// [START] Room information row -------------------------------------------
								$roomInfo = $displayDate . ' ' . $row['name'];
								if ( $showDatePAX == '1' ) {
									$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
								} else {
									$paxCount = '';
								}
																
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomInfo.'
'.$paxCount), $b_styleId);
								array_push($tempCell, $cell);
													
								if($csv_chart_data['detailAs'] == '1') {
									foreach($stayOverIds as $showId) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}
										for($count=0; $count<$rowSpans_stayOver[$showId];$count++) {
											$styleId = $bg_styleIdLR;
											if($i>1) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
										}
									}
								}
								
								array_push($multiCell[$rowCount], $tempCell);
																
								// [START] Stay Over data headings -------------------------------------------
								if($csv_chart_data['detailAs'] == '1') {
									$tempCell = array();
									$styleFlag = 1;

									$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
									
									$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'stayOver', $row['id'], $col['id'], $xls, $styles);
									array_push($multiCell[$rowCount], $tempCell);
									$tempCell = array();
								}
								// [ END ] Stay Over data headings -----------------------------------------------

								// [START] Stay Over information -------------------------------------------------
								$columnCount = 1;
								$colIds = array();
								foreach ( $csv_chart_data['columns'] as $col ) {
									if ( $property_name == $col['property'] ) {
										$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'stayOver', $row['id'], $col['id'], $chartIds, $chartSections);
										
										foreach ($mainArr as $tmp) {
											array_push($multiCell[$rowCount], $tmp);
										}
										$tempCell = array();

										if($columnCount == count($csv_chart_data['columns'])) {
											array_push($colIds, $col['id']);
											if(count($chartIds['perDay'])>0) {
												$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'stayOver', $row['id'], $colIds, $chartIds, $chartSections);
									
												foreach ($arr as $tmp) {
													array_push($multiCell[$rowCount], $tmp);
												}
												$tempCell = array();
											}
											$colIds = array();
										} else {
											array_push($colIds, $col['id']);
										}
									}
									$columnCount++;
									
								}
								$cells = array();
								$rowCount++;
								$multiCell[$rowCount] = array();
								
							} 
									
							$modcount++;
							$rowCount++;
						}
						
						$headerFlag = true;
						$hdr_rows = 2;
						
						if($csv_chart_data['detailAs'] == '2') {
							$hdr_rows = $hdr_rows+2;
						}
						
						foreach($multiCell as $rowId=>$temparr) {
							if($rowId<= $hdr_rows) {
								if($headerFlag == true) {
									foreach($temparr as $cellArr) {
										foreach($cellArr as $tmp) {
											array_push($cells,$tmp);
										}
										
										$row = $xls->Row($cells);
										$cells = array();
										array_push($rows,$row);
									}
								}
							} else {
								if (isset($temparr[1])) {
									for ($cal=0;$cal<count($temparr[1]);$cal++) {
										for ($crow=0;$crow<count($temparr);$crow++) {
											if($temparr[$crow][$cal] == -1) {
												
											} elseif($temparr[$crow][$cal]) {
												array_push($cells,$temparr[$crow][$cal]);
											}
											else {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
												array_push($cells,$cell);
											}
										}
										
										if(!empty($cells)){
											$row = $xls->Row($cells);
											array_push($rows,$row);
										}
										$cells = array();
									}
								}
							} 
							if($rowId==$hdr_rows) {
								$headerFlag = false;
							}
						}		
						
						$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $borderTBStyleId, '', '', '', '', $propColspan);
						array_push($cells,$cell);
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						
						$rowCount = 1;
						$multiCell = array();
						$multiCell[$rowCount] = array();
						
					}
					
					$modcount = 0;
					$departInfoExists = false;
					foreach ( $csv_chart_data['rows'] as $row ) {
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								$d = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : array();
								if ( is_array($d) && count($d) > 0  ) {
									foreach ( $d as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$departInfoExists = true;
										}
									}
								}
							}
						}
					}
					if(count($departIds)>0  && $departInfoExists) {
						if(!$roomInfoExists && !$stayOverInfoExists) {
							$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $propColspan);
							array_push($tempCell, $cell);
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount += 1;
							$multiCell[$rowCount] = array();
						}

						$cell = $xls->Cell(array('type'=>'String', 'data' => 'Depart'), $bg_styleId, '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data'=>'')) ;
						array_push($tempCell, $cell);
						
						if($csv_chart_data['detailAs'] == '1') {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
							array_push($tempCell, $cell);
						}

						// Room names and numbers ----------------------------------------------------------
						$modCount = 0;
						$columnCount = 1;
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $property_name == $col['property'] ) {
								if ( $modCount%2 == 0 ) {
									$bg_color = '#FCF3DA';
								} else {
									$bg_color = '#F8E8BB';
								}

								$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
										);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$modCount++;
							
							
								if ( $hideAccommType == "1" ) {
									$accommCell = "";
								} else {
									$accommCell = $col['accommodation'];
								}							
								if ( $showUnitLabel == '1' ) {
									$accommCell .= ' ' . $col['unit_label'];
								}
								if ( $showUnitNumber == '1' ) {
									$accommCell .= ' ' . $col['room'];
								}
								
								$cell = $xls->Cell(array('type'=>'String', 'data' => $accommCell), $bg_styleId, '', '', '', '', $colspnVal);
								array_push($tempCell, $cell);

								if($csv_chart_data['direction'] == "1") {
									if($columnCount == count($csv_chart_data['columns'])) {
										if(count($chartIds['perDay'])>0) {
											$cell = $xls->Cell(array('type'=>'String', 'data' => 'Details'), $bg_styleId);
											array_push($tempCell, $cell);
										}
									}
								}
							}
							$columnCount++;
						}
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount++;
						$multiCell[$rowCount] = array();

						if($csv_chart_data['detailAs'] == '2') {
							$tmpCellNxt = array();
							$indexCounter = 1;
							$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
							array_push($tempCell, $cell);
							$indexCounter++;
							
							$columnCount = 1;
							
							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $property_name == $col['property'] ) {
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT, $borderB)
											);
										
									$bg_styleId = $xls->addStyle($bg_style);
									$modCount++;
															
									$lastHeader = "";
									$lastHeaderCount = 0;
									
									foreach ( $chartSections as $item ) {
										foreach ( $combinedIds as $showId ) {
											if(in_array($showId, $perDayIds)) {
												continue;
											}
											
											if ( $item['id'] == $showId ) {
												if($lastHeader != "" && $lastHeader != $item['header']) {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
													array_push($tempCell, $cell);
													//$indexCounter++;
													
													$lastHeader = "";
													$lastHeaderCount = 0;
												}
												if(isset($item['header']) && $item['header'] != "") {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
													array_push($tmpCellNxt, $cell);
													$lastHeader = $item['header'];
													$lastHeaderCount++;
													
												} else {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
													array_push($tempCell, $cell);
													
												}
												$indexCounter++;
												break;
											}
										}
									}
									
									if($lastHeader != "") {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
										array_push($tempCell, $cell);
									}
									$lastHeader = "";
									
									if($csv_chart_data['direction'] == "1") {
										if($columnCount == count($csv_chart_data['columns'])) {
											if(count($chartIds['perDay'])>0) {
												$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $bg_styleId, "", "", "", "", 0, 1);
												array_push($tempCell, $cell);
												$indexCounter++;
											}
										}
									}
								}
								$columnCount++;
							}
							
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
							array_push($multiCell[$rowCount], $tmpCellNxt);
							$tmpCellNxt = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						}
						
						foreach ( $csv_chart_data['rows'] as $row ) {
							$rowSpans_depart = $departRowSpans[$row['id']];
							$totalSubCellDepart = (!empty($rowSpans_depart))?max($rowSpans_depart):1;
							
							$multiCell[$rowCount] = array();
							$thisDate	= explode('-',$row['id']);
							$displayDate = date('D',mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
							
							
							if ( $modCount%2 == 0 ) {
								$bg_color = '#FCF3DA';
							} else {
								$bg_color = '#F8E8BB';
							}

							$bg_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT, $borderB)
							);

							$bg_styleLRT = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT)
							);
							$bg_styleLRB = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderB)
							);
							$bg_styleLR = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR)
							);

							$b_style = array( 
								'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
								'border' => array($borderL, $borderR, $borderT),
								'font' => array('Bold' => '1', 'Size' => '8')
							);
										
							$b_styleId = $xls->addStyle($b_style);
							$bg_styleId = $xls->addStyle($bg_style);
							$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
							$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
							$bg_styleIdLR = $xls->addStyle($bg_styleLR);

							$departDayInfoExists = false;
							
							if(is_array($csv_chart_data['columns'])) {
								foreach ( $csv_chart_data['columns'] as $col ) {
									$c = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$departDayInfoExists = true;
											}
										}
									}
								}
							}
							
							if ( count($departIds) > 0 && ($departDayInfoExists || $showEmptyRooms == 1)) {
								// [START] Room information row -------------------------------------------
								$roomInfo = $displayDate . ' ' . $row['name'];
								if ( $showDatePAX == '1' ) {
									$paxCount = 'PAX ' . $row['pax_total'] . ' (Ad:' . $row['pax_adult'] . ' Ch:' . $row['pax_child'] . ')';
								} else {
									$paxCount = '';
								}
																
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$roomInfo.'
'.$paxCount), $b_styleId);
								array_push($tempCell, $cell);
													
								if($csv_chart_data['detailAs'] == '1') {
									$i = 1;
									$detailIds = $departIds;
									
									foreach($detailIds as $showId) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}
										for($count=0; $count<$rowSpans_depart[$showId];$count++) {
											$styleId = $bg_styleIdLR;
											if($i>1) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCell, $cell);
											}
											
											if($csv_chart_data['sep_asd'] == '1' && $i>1) {
											$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
												array_push($tempCellGrouping, $cell);
											}
										}
										$i++;
									}
								}
								
								array_push($multiCell[$rowCount], $tempCell);
																
								// [START] Depart data headings -------------------------------------------
								if($csv_chart_data['detailAs'] == '1') {
									$tempCell = array();
									$styleFlag = 1;

									$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
									
									$tempCell = createHeaderXLS($chartIds,$csv_chart_data, $chartSections, 'depart', $row['id'], $col['id'], $xls, $styles);
									array_push($multiCell[$rowCount], $tempCell);
									$tempCell = array();
								}
								// [ END ] Depart data headings -----------------------------------------------

								// [START] Depart information -------------------------------------------------
								$columnCount = 1;
								$prop = '';
								$colIds = array();
								foreach ( $csv_chart_data['columns'] as $col ) {
									if ( $property_name == $col['property'] ) {
										$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'depart', $row['id'], $col['id'], $chartIds, $chartSections);
										
										foreach ($mainArr as $tmp) {
											array_push($multiCell[$rowCount], $tmp);
										}
										$tempCell = array();

										if($columnCount == count($csv_chart_data['columns'])) {
											array_push($colIds, $col['id']);
											if(count($chartIds['perDay'])>0) {
												$arr = cretaePerDayDetailsXLS($xls, $csv_chart_data,'depart', $row['id'], $colIds, $chartIds, $chartSections);
									
												foreach ($arr as $tmp) {
													array_push($multiCell[$rowCount], $tmp);
												}
												$tempCell = array();
											}
											$colIds = array();
										} else {
											array_push($colIds, $col['id']);
										}
									}
									$columnCount++;
									
								}
								$cells = array();
								$rowCount++;
								$multiCell[$rowCount] = array();
								$bool_room = true;
							} else {
								$bool_room = false;
							} 
									
							$modcount++;
							$rowCount++;
						}
						
						$headerFlag = true;
						$hdr_rows = 2;
						
						if($csv_chart_data['detailAs'] == '2') {
							$hdr_rows = $hdr_rows+2;
						}
						
						foreach($multiCell as $rowId=>$temparr) {
							if($rowId<= $hdr_rows) {
								if($headerFlag == true) {
									foreach($temparr as $cellArr) {
										foreach($cellArr as $tmp) {
											array_push($cells,$tmp);
										}
										
										$row = $xls->Row($cells);
										$cells = array();
										array_push($rows,$row);
									}
								}
							} else {
								if (isset($temparr[1])) {
									for ($cal=0;$cal<count($temparr[1]);$cal++) {
										for ($crow=0;$crow<count($temparr);$crow++) {
											if($temparr[$crow][$cal] == -1) {
												
											} elseif($temparr[$crow][$cal]) {
												array_push($cells,$temparr[$crow][$cal]);
											}
											else {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
												array_push($cells,$cell);
											}
										}
										
										if(!empty($cells)){
											$row = $xls->Row($cells);
											array_push($rows,$row);
										}
										$cells = array();
									}
								}
							} 
							if($rowId==$hdr_rows) {
								$headerFlag = false;
							}
						}		
						
						$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $borderTBStyleId, '', '', '', '', $propColspan);
						array_push($cells,$cell);
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						
						$rowCount = 1;
						$multiCell = array();
						$multiCell[$rowCount] = array();
					
					}
				}
			}
		} else {
			// Dates along top
			$noOfCols = count($csv_chart_data['columns']);
			if($csv_chart_data['detailAs'] == '2') {
				$noOfCols = $noOfCols * (count($showIds) - count($perDayIds));
			}
			$propColspan = $noOfCols+$extraRows-1;
			$bg_color = '#F8E8BB';
			$bg_style = array( 
							'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
							'border' => array($borderL, $borderR, $borderT, $borderB)
							);
						
			$bg_styleId = $xls->addStyle($bg_style);
			$firstProperty = 1;
			foreach ( $csv_chart_data['rows'] as $row ) {
				$roomInfoExists = false;
				$stayOverInfoExists = false;
				$departInfoExists = false;
				if ( $property_name != $row['property'] && $row['room'] != "overbooking") {
					$property_name = $row['property'];
					foreach ( $csv_chart_data['rows'] as $dateRow ) {
						if ( $property_name == $dateRow['property'] ) {
							foreach ( $csv_chart_data['columns'] as $col ) {
								$c = isset($csv_chart_data['room'][$dateRow['id']][$col['id']]) ? $csv_chart_data['room'][$dateRow['id']][$col['id']] : array();
								if ( is_array($c) && count($c) > 0  ) {
									foreach ( $c as $blah ) {
										if ( isset($blah['value']) && $blah['value'] != "" ) {
											$roomInfoExists = true;
										}
									}
								}
							}
						}
					}
					
					if ( count($showIds) > 0 && $roomInfoExists) {
						$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data' => ""), '', '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data' => $combination), $bg_styleId, '', '', '', '', $propColspan);
						array_push($tempCell, $cell);
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount += 1;
						$multiCell[$rowCount] = array();

						$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
						array_push($tempCell, $cell);
						
						if($csv_chart_data['detailAs'] == '1') {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
							array_push($tempCell, $cell);
						}

						// Room names and numbers ---------------------------------------------------
						$modCount = 0;
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $property_name == $row['property'] ) {
								if ( $modCount%2 == 0 ) {
									$bg_color = '#FCF3DA';
								} else {
									$bg_color = '#F8E8BB';
								}

								$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
										);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$modCount++;
							
								$thisDate = explode("-",$col['id']);
								$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
								$displayDate .= ' ' . $col['name'];

								if ( $showDatePAX == "1" ) {
									$displayDate .= '
PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
								}
											
								$noOfCols = 1;
								if($csv_chart_data['detailAs'] == '2') {
									$noOfCols = $noOfCols * (count($showIds) - count($perDayIds));
								}
								$colspnVal = $noOfCols-1;
								$cell = $xls->Cell(array('type'=>'String', 'data' => $displayDate), $bg_styleId, '', '', '', '', $colspnVal);
								array_push($tempCell, $cell);
							}
						}
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount++;
						$multiCell[$rowCount] = array();

						if($csv_chart_data['detailAs'] == '2') {
							$tmpCellNxt = array();
							$indexCounter = 1;
							$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
							array_push($tempCell, $cell);
							$indexCounter++;
							if($csv_chart_data['sep_asd'] == '1') {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), '', '', '', '', '', 0, 1);
								array_push($tempCell, $cell);
								$indexCounter++;
							}

							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $property_name == $row['property'] ) {
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT, $borderB)
											);
										
									$bg_styleId = $xls->addStyle($bg_style);
									$modCount++;
															
									$lastHeader = "";
									$lastHeaderCount = 0;
								
									foreach ( $chartSections as $item ) {
										foreach ( $showIds as $showId ) {
											if(in_array($showId, $perDayIds)) {
												continue;
											}
											
											if ( $item['id'] == $showId ) {
												if($lastHeader != "" && $lastHeader != $item['header']) {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
													array_push($tempCell, $cell);
													//$indexCounter++;
													
													$lastHeader = "";
													$lastHeaderCount = 0;
												}
												if(isset($item['header']) && $item['header'] != "") {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
													array_push($tmpCellNxt, $cell);
													$lastHeader = $item['header'];
													$lastHeaderCount++;
													
												} else {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
													array_push($tempCell, $cell);
													
												}
												$indexCounter++;
												break;
											}
										}
									}
									
									if($lastHeader != "") {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
										array_push($tempCell, $cell);
									}
									$lastHeader = "";
								}
							}
							
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
							array_push($multiCell[$rowCount], $tmpCellNxt);
							$tmpCellNxt = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						}
						
						$rowcounter = 1;
						$rowIdsArr = array();
						foreach ( $csv_chart_data['rows'] as $daterow ) {
							if ( $property_name == $daterow['property'] ) {
								$rowInfoExists = false;
								foreach ( $csv_chart_data['columns'] as $col ) {
									$c = isset($csv_chart_data['room'][$daterow['id']][$col['id']]) ? $csv_chart_data['room'][$daterow['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$rowInfoExists = true;
											}
										}
									}
								}
								if($rowInfoExists || $showEmptyRooms == 1) {
									$rowSpans_room = $roomRowSpans[$daterow['id']];
									$totalSubCellRoom = (!empty($rowSpans_room))?max($rowSpans_room):1;
									
									$multiCell[$rowCount] = array();
									
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
									);

									$bg_styleLRT = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT)
									);
									$bg_styleLRB = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderB)
									);
									$bg_styleLR = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR)
									);

									$b_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT),
										'font' => array('Bold' => '1', 'Size' => '8')
									);
										
									$b_styleId = $xls->addStyle($b_style);
									$bg_styleId = $xls->addStyle($bg_style);
									$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
									$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
									$bg_styleIdLR = $xls->addStyle($bg_styleLR);
												
									// [START] Room information row -------------------------------------------
									if ( $hideAccommType == "1" ) {
										$room_data = "";
									} else {
										$room_data = $daterow['accommodation'];
									}									
									if ( $showUnitLabel == '1' ) {
										$room_data .= ' '.$daterow['unit_label'];
									}
									if ( $showUnitNumber == '1' ) {
										$room_data .= ' '.$daterow['room'];
									}
								
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$room_data), $b_styleId);
									array_push($tempCell, $cell);
															
									if($csv_chart_data['detailAs'] == '1') {
										$i = 1;
										$detailIds = $showIds;
										
										foreach($detailIds as $showId) {
											if(in_array($showId, $perDayIds)) {
												continue;
											}
											for($count=0; $count<$rowSpans_room[$showId];$count++) {
												if($count == $totalSubCellRoom-1 && $i==count($detailIds)) {
													$styleId = $bg_styleIdLRB;
												}
												else {
													$styleId = $bg_styleIdLR;
												}
												if($i>1) {
													$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
													array_push($tempCell, $cell);
												}
												
												if($csv_chart_data['sep_asd'] == '1' && $i>1) {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
													array_push($tempCellGrouping, $cell);
												}
											}
											$i++;
										}
									}
									
									array_push($multiCell[$rowCount], $tempCell);
																	
									// [START] Room data headings -------------------------------------------
									if($csv_chart_data['detailAs'] == '1') {
										$tempCell = array();
										$styleFlag = 1;

										$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
										
										$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'room', $daterow['id'], $col['id'], $xls, $styles);
										array_push($multiCell[$rowCount], $tempCell);
										$tempCell = array();
									}
									// [ END ] Room data headings -----------------------------------------------

									// [START] Room information -------------------------------------------------
									foreach ( $csv_chart_data['columns'] as $col ) {
										if ( $property_name == $daterow['property'] ) {
											$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'room', $daterow['id'], $col['id'], $chartIds, $chartSections);
											
											foreach ($mainArr as $tmp) {
												array_push($multiCell[$rowCount], $tmp);
											}
											$tempCell = array();

											$c = isset($csv_chart_data['room'][$dateRow['id']][$col['id']]) ? $csv_chart_data['room'][$dateRow['id']][$col['id']] : array();
											if(!in_array($daterow['id'], $rowIdsArr) && !empty($c)) {
												array_push($rowIdsArr, $daterow['id']);
											}
										}
									}
									$cells = array();
									$rowCount++;
									$multiCell[$rowCount] = array();
									$bool_room = true;
								}
							}		
							
							if($rowcounter == count($csv_chart_data['rows'])) {
								$multiCell[$rowCount] = array();
								if(count($chartIds['perDay'])>0) {
									$perDayCount = count($chartIds['perDay']);
									if($perDayCount > 0) {
										$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'room', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
										$rowIdsArr = array();
										
										foreach ($rowArr as $arr) {
											array_push($multiCell[$rowCount], $arr);
										}

										$tempCell = array();
										$rowCount++;
										$multiCell[$rowCount] = array();
									}
								}
							} 
							$rowcounter++;
							$modcount++;
							$rowCount++;
						}
						
						$headerFlag = true;
						$hdr_rows = 4;
						
						if($csv_chart_data['detailAs'] == '2') {
							$hdr_rows = $hdr_rows+2;
						}
						
						foreach($multiCell as $rowId=>$temparr) {
							if($rowId<= $hdr_rows) {
								if($headerFlag == true) {
									foreach($temparr as $cellArr) {
										foreach($cellArr as $tmp) {
											array_push($cells,$tmp);
										}
										
										$row = $xls->Row($cells);
										$cells = array();
										array_push($rows,$row);
									}
								}
							} else {
								if (isset($temparr[1])) {
									for ($cal=0;$cal<count($temparr[1]);$cal++) {
										for ($crow=0;$crow<count($temparr);$crow++) {
											if($temparr[$crow][$cal] == -1) {
												
											} elseif($temparr[$crow][$cal]) {
												array_push($cells,$temparr[$crow][$cal]);
											}
											else {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
												array_push($cells,$cell);
											}
										}
										
										if(!empty($cells)){
											$row = $xls->Row($cells);
											array_push($rows,$row);
										}
										$cells = array();
									}
								}
							} 
							if($rowId==$hdr_rows) {
								$headerFlag = false;
							}
						}		
						
						$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $borderTBStyleId, '', '', '', '', $propColspan);
						array_push($cells,$cell);
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						
						$rowCount = 1;
						$multiCell = array();
						$multiCell[$rowCount] = array();
					}

					if($csv_chart_data['combArrSty'] == '2' && count($stayOverIds)>0) {
						// [START] Stay Over information row -------------------------------------------
						foreach ( $csv_chart_data['rows'] as $dateRow ) {
							if ( $property_name == $dateRow['property'] ) {
								foreach ( $csv_chart_data['columns'] as $col ) {
									$d = isset($csv_chart_data['stayOver'][$dateRow['id']][$col['id']]) ? $csv_chart_data['stayOver'][$dateRow['id']][$col['id']] : array();
									if ( is_array($d) && count($d) > 0  ) {
										foreach ( $d as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$stayOverInfoExists = true;
											}
										}
									}
								}
							}
						}
						if ($stayOverInfoExists) {
							if(!$roomInfoExists) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $propColspan);
								array_push($tempCell, $cell);
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
								$rowCount += 1;
								$multiCell[$rowCount] = array();

								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), '', '', '', '', '', $propColspan);
								array_push($tempCell, $cell);
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
								$rowCount += 1;
								$multiCell[$rowCount] = array();
							}
							$cell = $xls->Cell(array('type'=>'String', 'data' => 'Stay Over'), $bg_styleId, '', '', '', '', $propColspan);
							array_push($tempCell, $cell);
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount += 1;
							$multiCell[$rowCount] = array();

							$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
							array_push($tempCell, $cell);
						
						if($csv_chart_data['detailAs'] == '1') {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
							array_push($tempCell, $cell);
						}

						// Room names and numbers ---------------------------------------------------
						$modCount = 0;
						foreach ( $csv_chart_data['columns'] as $col ) {
							if ( $modCount%2 == 0 ) {
								$bg_color = '#FCF3DA';
							} else {
								$bg_color = '#F8E8BB';
							}

							$bg_style = array( 
									'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
									'border' => array($borderL, $borderR, $borderT, $borderB)
									);
								
							$bg_styleId = $xls->addStyle($bg_style);
							$modCount++;
							
							$thisDate = explode("-",$col['id']);
							$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
							$displayDate .= ' ' . $col['name'];

							if ( $showDatePAX == "1" ) {
								$displayDate .= '
PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
							}
										
							$noOfCols = 1;
							if($csv_chart_data['detailAs'] == '2') {
								$noOfCols = $noOfCols * (count($stayOverIds) - count($perDayIds));
							}
							$colspnVal = $noOfCols-1;
							$cell = $xls->Cell(array('type'=>'String', 'data' => $displayDate), $bg_styleId, '', '', '', '', $colspnVal);
							array_push($tempCell, $cell);
							
						}
						array_push($multiCell[$rowCount], $tempCell);
						$tempCell = array();
						$rowCount++;
						$multiCell[$rowCount] = array();

						if($csv_chart_data['detailAs'] == '2') {
							$tmpCellNxt = array();
							$indexCounter = 1;
							$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
							array_push($tempCell, $cell);
							$indexCounter++;
							if($csv_chart_data['sep_asd'] == '1') {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''), '', '', '', '', '', 0, 1);
								array_push($tempCell, $cell);
								$indexCounter++;
							}

							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $modCount%2 == 0 ) {
									$bg_color = '#FCF3DA';
								} else {
									$bg_color = '#F8E8BB';
								}

								$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
										);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$modCount++;
														
								$lastHeader = "";
								$lastHeaderCount = 0;
									
								foreach ( $chartSections as $item ) {
									foreach ( $stayOverIds as $showId ) {
										if(in_array($showId, $perDayIds)) {
											continue;
										}
										
										if ( $item['id'] == $showId ) {
											if($lastHeader != "" && $lastHeader != $item['header']) {
												$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
												array_push($tempCell, $cell);
																								
												$lastHeader = "";
												$lastHeaderCount = 0;
											}
											if(isset($item['header']) && $item['header'] != "") {
												$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
												array_push($tmpCellNxt, $cell);
												$lastHeader = $item['header'];
												$lastHeaderCount++;
												
											} else {
												$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
												array_push($tempCell, $cell);
												
											}
											$indexCounter++;
											break;
										}
									}
								}
								
								if($lastHeader != "") {
									$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
									array_push($tempCell, $cell);
								}
								$lastHeader = "";
							}
							
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
							array_push($multiCell[$rowCount], $tmpCellNxt);
							$tmpCellNxt = array();
							$rowCount++;
							$multiCell[$rowCount] = array();
						}
						
						$rowcounter = 1;
						$rowIdsArr = array();
						foreach ( $csv_chart_data['rows'] as $row ) {
							if ( $property_name == $row['property'] ) {
								$rowInfoExists = false;
								foreach ( $csv_chart_data['columns'] as $col ) {
									$c = isset($csv_chart_data['stayOver'][$row['id']][$col['id']]) ? $csv_chart_data['stayOver'][$row['id']][$col['id']] : array();
									if ( is_array($c) && count($c) > 0  ) {
										foreach ( $c as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$rowInfoExists = true;
											}
										}
									}
								}
								if($rowInfoExists || $showEmptyRooms == 1) {
									$rowSpans_stayOver = $stayOverRowSpans[$row['id']];
									$totalSubCellStayOver = (!empty($rowSpans_stayOver))?max($rowSpans_stayOver):1;
									$multiCell[$rowCount] = array();
									
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
									);

									$bg_styleLRT = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT)
									);
									$bg_styleLRB = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderB)
									);
									$bg_styleLR = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR)
									);

									$b_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT),
										'font' => array('Bold' => '1', 'Size' => '8')
									);
										
									$b_styleId = $xls->addStyle($b_style);
									$bg_styleId = $xls->addStyle($bg_style);
									$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
									$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
									$bg_styleIdLR = $xls->addStyle($bg_styleLR);

									// [START] Room information row -------------------------------------------
									if ( $hideAccommType == "1" ) {
										$room_data = "";
									} else {
										$room_data = $row['accommodation'];
									}									
									if ( $showUnitLabel == '1' ) {
										$room_data .= ' '.$row['unit_label'];
									}
									if ( $showUnitNumber == '1' ) {
										$room_data .= ' '.$row['room'];
									}
									
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$room_data), $b_styleId);
									array_push($tempCell, $cell);
														
									if($csv_chart_data['detailAs'] == '1') {
										$detailIds = $stayOverIds;
										
										foreach($detailIds as $showId) {
											if(in_array($showId, $perDayIds)) {
												continue;
											}
											for($count=0; $count<$rowSpans_stayOver[$showId];$count++) {
												if($count == $totalSubCellStayOver-1 && $i==count($detailIds)) {
													$styleId = $bg_styleIdLRB;
												}
												else {
													$styleId = $bg_styleIdLR;
												}
												if($i>1) {
													$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
													array_push($tempCell, $cell);
												}
											}
										}
									}
									
									array_push($multiCell[$rowCount], $tempCell);
																	
									// [START] Stay Over data headings -------------------------------------------
									if($csv_chart_data['detailAs'] == '1') {
										$tempCell = array();
										$styleFlag = 1;

										$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
										
										$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'stayOver', $row['id'], $col['id'], $xls, $styles);
										array_push($multiCell[$rowCount], $tempCell);
										$tempCell = array();
									}
									// [ END ] Stay Over data headings -----------------------------------------------

									// [START] Stay Over information -------------------------------------------------
									foreach ( $csv_chart_data['columns'] as $col ) {
										if ( $property_name == $row['property'] ) {
											$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'stayOver', $row['id'], $col['id'], $chartIds, $chartSections);
											
											foreach ($mainArr as $tmp) {
												array_push($multiCell[$rowCount], $tmp);
											}
											$tempCell = array();

											$c = isset($csv_chart_data['stayOver'][$row['id']][$col['id']]) ? $csv_chart_data['stayOver'][$row['id']][$col['id']] : array();
											if(!in_array($row['id'], $rowIdsArr) && !empty($c)) {
												array_push($rowIdsArr, $row['id']);
											}
										}
									}
									$cells = array();
									$rowCount++;
									$multiCell[$rowCount] = array();
								}
									
							}		
							
							if($rowcounter == count($csv_chart_data['rows'])) {
								$multiCell[$rowCount] = array();
								if(count($chartIds['perDay'])>0) {
									$perDayCount = count($chartIds['perDay']);
									if($perDayCount > 0) {
										$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'stayOver', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
										$rowIdsArr = array();
										
										foreach ($rowArr as $arr) {
											array_push($multiCell[$rowCount], $arr);
										}

										$tempCell = array();
										$rowCount++;
										$multiCell[$rowCount] = array();
									}
								}
							} 
							$rowcounter++;
							$modcount++;
							$rowCount++;
						}
						
						$headerFlag = true;
						if(!$roomInfoExists) {
							$hdr_rows = 4;
						} else {
							$hdr_rows = 2;
						}
						
						if($csv_chart_data['detailAs'] == '2') {
							$hdr_rows = $hdr_rows+2;
						}
						
						foreach($multiCell as $rowId=>$temparr) {
							if($rowId<= $hdr_rows) {
								if($headerFlag == true) {
									foreach($temparr as $cellArr) {
										foreach($cellArr as $tmp) {
											array_push($cells,$tmp);
										}
										
										$row = $xls->Row($cells);
										$cells = array();
										array_push($rows,$row);
									}
								}
							} else {
								if (isset($temparr[1])) {
									for ($cal=0;$cal<count($temparr[1]);$cal++) {
										for ($crow=0;$crow<count($temparr);$crow++) {
											if(!isset($temparr[$crow][$cal]) || $temparr[$crow][$cal] == -1) {
												
											} elseif(isset($temparr[$crow][$cal])) {
												array_push($cells,$temparr[$crow][$cal]);
											}
											else {
												$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
												array_push($cells,$cell);
											}
										}
										
										if(!empty($cells)){
											$row = $xls->Row($cells);
											array_push($rows,$row);
										}
										$cells = array();
									}
								}
							} 
							if($rowId==$hdr_rows) {
								$headerFlag = false;
							}
						}		
						
						$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $borderTBStyleId, '', '', '', '', $propColspan);
						array_push($cells,$cell);
						$row = $xls->Row($cells);
						array_push($rows,$row);
						$cells = array();
						
						$rowCount = 1;
						$multiCell = array();
						$multiCell[$rowCount] = array();
					
						}
					}

					if(count($departIds) > 0) {
						$departInfoExists = false;
						foreach ( $csv_chart_data['rows'] as $dateRow ) {
							if ( $property_name == $dateRow['property'] ) {
								foreach ( $csv_chart_data['columns'] as $col ) {
									$d = isset($csv_chart_data['depart'][$dateRow['id']][$col['id']]) ? $csv_chart_data['depart'][$dateRow['id']][$col['id']] : array();
									if ( is_array($d) && count($d) > 0  ) {
										foreach ( $d as $blah ) {
											if ( isset($blah['value']) && $blah['value'] != "" ) {
												$departInfoExists = true;
											}
										}
									}
								}
							}
						}
						if($departInfoExists) {
							if(!$roomInfoExists && !$stayOverInfoExists) {
								$cell = $xls->Cell(array('type'=>'String', 'data' => $property_name), $bg_styleId, '', '', '', '', $propColspan);
								array_push($tempCell, $cell);
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
								$rowCount += 1;
								$multiCell[$rowCount] = array();

								$cell = $xls->Cell(array('type'=>'String', 'data' => ''), '', '', '', '', '', $propColspan);
								array_push($tempCell, $cell);
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
								$rowCount += 1;
								$multiCell[$rowCount] = array();
							}

							$cell = $xls->Cell(array('type'=>'String', 'data' => 'Depart'), $bg_styleId, '', '', '', '', $propColspan);
							array_push($tempCell, $cell);
							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount += 1;
							$multiCell[$rowCount] = array();

							$cell = $xls->Cell(array('type'=>'String', 'data'=>''));
							array_push($tempCell, $cell);
							
							if($csv_chart_data['detailAs'] == '1') {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>'Details'), $header_styleId);
								array_push($tempCell, $cell);
							}

							// Room names and numbers ---------------------------------------------------
							$modCount = 0;
							foreach ( $csv_chart_data['columns'] as $col ) {
								if ( $modCount%2 == 0 ) {
									$bg_color = '#FCF3DA';
								} else {
									$bg_color = '#F8E8BB';
								}

								$bg_style = array( 
										'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
										'border' => array($borderL, $borderR, $borderT, $borderB)
										);
									
								$bg_styleId = $xls->addStyle($bg_style);
								$modCount++;
							
								$thisDate = explode("-",$col['id']);
								$displayDate = date("D",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
								$displayDate .= ' ' . $col['name'];

								if ( $showDatePAX == "1" ) {
									$displayDate .= '
PAX ' . $col['pax_total'] . ' (Ad:' . $col['pax_adult'] . ' Ch:' . $col['pax_child'] . ')';
								}
											
								$noOfCols = 1;
								if($csv_chart_data['detailAs'] == '2') {
									$noOfCols = $noOfCols * (count($departIds) - count($perDayIds));
								}
								$colspnVal = $noOfCols-1;
								$cell = $xls->Cell(array('type'=>'String', 'data' => $displayDate), $bg_styleId, '', '', '', '', $colspnVal);
								array_push($tempCell, $cell);
							}

							array_push($multiCell[$rowCount], $tempCell);
							$tempCell = array();
							$rowCount++;
							$multiCell[$rowCount] = array();

							if($csv_chart_data['detailAs'] == '2') {
								$tmpCellNxt = array();
								$indexCounter = 1;
								$cell = $xls->Cell(array('type'=>'String', 'data'=>''),'', '', '', '', '', 0, 1);
								array_push($tempCell, $cell);
								$indexCounter++;
								if($csv_chart_data['sep_asd'] == '1') {
									$cell = $xls->Cell(array('type'=>'String', 'data'=>''), '', '', '', '', '', 0, 1);
									array_push($tempCell, $cell);
									$indexCounter++;
								}

								foreach ( $csv_chart_data['columns'] as $col ) {
									if ( $modCount%2 == 0 ) {
										$bg_color = '#FCF3DA';
									} else {
										$bg_color = '#F8E8BB';
									}

									$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT, $borderB)
											);
										
									$bg_styleId = $xls->addStyle($bg_style);
									$modCount++;
									$lastHeader = "";
									$lastHeaderCount = 0;
									
									foreach ( $chartSections as $item ) {
										foreach ( $departIds as $showId ) {
											if(in_array($showId, $perDayIds)) {
												continue;
											}
											
											if ( $item['id'] == $showId ) {
												if($lastHeader != "" && $lastHeader != $item['header']) {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
													array_push($tempCell, $cell);
													//$indexCounter++;
													
													$lastHeader = "";
													$lastHeaderCount = 0;
												}
												if(isset($item['header']) && $item['header'] != "") {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, $indexCounter);
													array_push($tmpCellNxt, $cell);
													$lastHeader = $item['header'];
													$lastHeaderCount++;
													
												} else {
													$cell = $xls->Cell(array('type'=>'String', 'data' => $item['label']), $bg_styleId, "", "", "", "", 0, 1);
													array_push($tempCell, $cell);
													
												}
												$indexCounter++;
												break;
											}
										}
									}
									
									if($lastHeader != "") {
										$cell = $xls->Cell(array('type'=>'String', 'data' => $lastHeader), $bg_styleId, "", "", "", "", $lastHeaderCount-1);
										array_push($tempCell, $cell);
									}
									$lastHeader = "";
									
								}
								
								array_push($multiCell[$rowCount], $tempCell);
								$tempCell = array();
								$rowCount++;
								$multiCell[$rowCount] = array();
								array_push($multiCell[$rowCount], $tmpCellNxt);
								$tmpCellNxt = array();
								$rowCount++;
								$multiCell[$rowCount] = array();
							}
							
							$rowcounter = 1;
							$rowIdsArr = array();
							foreach ( $csv_chart_data['rows'] as $row ) {
								if ( $property_name == $row['property'] ) {
									$rowInfoExists = false;
									foreach ( $csv_chart_data['columns'] as $col ) {
										$c = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : array();
										if ( is_array($c) && count($c) > 0  ) {
											foreach ( $c as $blah ) {
												if ( isset($blah['value']) && $blah['value'] != "" ) {
													$rowInfoExists = true;
												}
											}
										}
									}
									if($rowInfoExists || $showEmptyRooms == 1) {
										$rowSpans_depart = $departRowSpans[$row['id']];
										$totalSubCellDepart = (!empty($rowSpans_depart))?max($rowSpans_depart):1;
										
										$multiCell[$rowCount] = array();
										
										if ( $modCount%2 == 0 ) {
											$bg_color = '#FCF3DA';
										} else {
											$bg_color = '#F8E8BB';
										}

										$bg_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT, $borderB)
										);

										$bg_styleLRT = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT)
										);
										$bg_styleLRB = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderB)
										);
										$bg_styleLR = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR)
										);

										$b_style = array( 
											'interior' => array('Color' => $bg_color, 'Pattern'=>'Solid'),
											'border' => array($borderL, $borderR, $borderT),
											'font' => array('Bold' => '1', 'Size' => '8')
										);
												
										$b_styleId = $xls->addStyle($b_style);
										$bg_styleId = $xls->addStyle($bg_style);
										$bg_styleIdLRT = $xls->addStyle($bg_styleLRT);
										$bg_styleIdLRB = $xls->addStyle($bg_styleLRB);
										$bg_styleIdLR = $xls->addStyle($bg_styleLR);

										// [START] Room information row -------------------------------------------
										if ( $hideAccommType == "1" ) {
											$room_data = "";
										} else {
											$room_data = $row['accommodation'];
										}										
										if ( $showUnitLabel == '1' ) {
											$room_data .= ' '.$row['unit_label'];
										}
										if ( $showUnitNumber == '1' ) {
											$room_data .= ' '.$row['room'];
										}
										
										$cell = $xls->Cell(array('type'=>'String', 'data'=>$room_data), $b_styleId);
										array_push($tempCell, $cell);
															
										if($csv_chart_data['detailAs'] == '1') {
											$detailIds = $departIds;
											foreach($detailIds as $showId) {
												if(in_array($showId, $perDayIds)) {
													continue;
												}
												for($count=0; $count<$rowSpans_depart[$showId];$count++) {
													if($count == $totalSubCellDepart-1 && $i==count($detailIds)) {
														$styleId = $bg_styleIdLRB;
													}
													else {
														$styleId = $bg_styleIdLR;
													}
													if($i>1) {
														$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $styleId);
														array_push($tempCell, $cell);
													}
												}
												$i++;
											}
										}
										
										array_push($multiCell[$rowCount], $tempCell);
																		
										// [START] Depart data headings -----------------------------------------
										if($csv_chart_data['detailAs'] == '1') {
											$tempCell = array();
											$styleFlag = 1;

											$styles = array("styleLRT" => $hdr_styleIdLRT, "styleLRB" => $hdr_styleidLRB, "styleLR" => $hdr_styleidLR);
											
											$tempCell = createHeaderXLS($chartIds, $csv_chart_data, $chartSections, 'depart', $row['id'], $col['id'], $xls, $styles);
											array_push($multiCell[$rowCount], $tempCell);
											$tempCell = array();
										}
										// [ END ] Depart data headings -------------------------------------------

										// [START] Depart information ------------------------------------------
										foreach ( $csv_chart_data['columns'] as $col ) {
											if ( $property_name == $row['property'] ) {
												$mainArr = createInnerRoomDetailsXLS($xls, $csv_chart_data,'depart', $row['id'], $col['id'], $chartIds, $chartSections);
												
												foreach ($mainArr as $tmp) {
													array_push($multiCell[$rowCount], $tmp);
												}
												$tempCell = array();

												$c = isset($csv_chart_data['depart'][$row['id']][$col['id']]) ? $csv_chart_data['depart'][$row['id']][$col['id']] : array();
												if(!in_array($row['id'], $rowIdsArr) && !empty($c)) {
													array_push($rowIdsArr, $row['id']);
												}
											}
										}
										$cells = array();
										$rowCount++;
										$multiCell[$rowCount] = array();
									}
								}		
								
								if($rowcounter == count($csv_chart_data['rows'])) {
									$multiCell[$rowCount] = array();
									if(count($chartIds['perDay'])>0) {
										$perDayCount = count($chartIds['perDay']);
										if($perDayCount > 0) {
											$rowArr = cretaePerDayDetailsRowsXLS($xls, $csv_chart_data, 'depart', $rowIdsArr, $chartIds, $chartSections, $colspnVal);
											$rowIdsArr = array();
											
											foreach ($rowArr as $arr) {
												array_push($multiCell[$rowCount], $arr);
											}

											$tempCell = array();
											$rowCount++;
											$multiCell[$rowCount] = array();
										}
									}
								} 
								$rowcounter++;
								$modcount++;
								$rowCount++;
							}
							
							$headerFlag = true;
							if(!$roomInfoExists && !$stayOverInfoExists) {
								$hdr_rows = 4;
							} else {
								$hdr_rows = 2;
							}
													
							if($csv_chart_data['detailAs'] == '2') {
								$hdr_rows = $hdr_rows+2;
							}
							
							foreach($multiCell as $rowId=>$temparr) {
								if($rowId<= $hdr_rows) {
									if($headerFlag == true) {
										foreach($temparr as $cellArr) {
											foreach($cellArr as $tmp) {
												array_push($cells,$tmp);
											}
											
											$row = $xls->Row($cells);
											$cells = array();
											array_push($rows,$row);
										}
									}
								} else {
									if (isset($temparr[1])) {
										for ($cal=0;$cal<count($temparr[1]);$cal++) {
											for ($crow=0;$crow<count($temparr);$crow++) {
												if($temparr[$crow][$cal] == -1) {
													
												} elseif($temparr[$crow][$cal]) {
													array_push($cells,$temparr[$crow][$cal]);
												}
												else {
													$cell = $xls->Cell(array('type'=>'String', 'data'=>''), $borderLRStyleId);
													array_push($cells,$cell);
												}
											}
											
											if(!empty($cells)){
												$row = $xls->Row($cells);
												array_push($rows,$row);
											}
											$cells = array();
										}
									}
								} 
								if($rowId==$hdr_rows) {
									$headerFlag = false;
								}
							}		
							
							$cell = $xls->Cell(array('type'=>'String', 'data' => ''), $borderTBStyleId, '', '', '', '', $propColspan);
							array_push($cells,$cell);
							$row = $xls->Row($cells);
							array_push($rows,$row);
							$cells = array();
							
							$rowCount = 1;
							$multiCell = array();
							$multiCell[$rowCount] = array();
						}
					}

				}
			}
		}
		
		$table = $xls->Table($rows);
		array_push($tables, $table);
	}	
	// [ END ] Chart -------------------------------------------------------------

	// [START] Notes -------------------------------------------------------------
	if($showNotes == 1) {
		$notesTables = array();
		$note_table = array();
		$note_rows = generateXLSNotes($noteSections,$noteIds, $csv_notes_data, $noteSort, $noteHeader, $xls);
		$note_table = $xls->Table($note_rows,2);
		array_push($notesTables, $note_table);
	}
	// [ END ] Notes -------------------------------------------------------------

	// Build the final XLS file ------------------------------------------------
		
	if($showChart == 1) {
		$xls->Worksheet($tables,1,"chart");
	}
	if($showNotes == 1) {
		$xls->Worksheet($notesTables,2,"notes");
	}
	
	$xls->genrateWorkbook($reportName, $repType);
}

function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;

	$pdfName = 'Room report - $fromDate to $toDate';
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER[argv],0,6))."+$newOptions";

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (isset($detail['pr_name_first']) && trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (isset($detail['pr_name_second']) && trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (isset($detail['pr_name_last']) && trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}
