<?php

/**
 * init.form376.func.output.php - Operations chart functions
 */

require_once(__DIR__ . "/functions.report.php");
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');   
require_once(__DIR__ . '/functions.profile.php');   

require_once "class.xls.php";

require_once(__DIR__ . '/init.form376.func.profile.php');
require_once(__DIR__ . '/init.form376.func.colour.php');
require_once(__DIR__ . '/init.form376.func.data.php');
require_once(__DIR__ . '/init.form376.func.output.php');

// [STARRT] - Section functions
function findSectionId($sections,$name) {
	foreach($sections as $item) {
		if(isset($item['name']) && $item['name'] == $name) {
			return $item['id'];
		}
	}
}

function hasSection($sections,$name,$ids) {
	return in_array(findSectionId($sections,$name),$ids);
}
// [END] - Section functions

// [START] - Note sort functions
function noteSortArrive($a, $b) {
	$a['rv_date_arrive'] 	= isset($a['rv_date_arrive']) ? $a['rv_date_arrive'] : "";
	$b['rv_date_arrive'] 	= isset($b['rv_date_arrive']) ? $b['rv_date_arrive'] : "";
	$a['rv_date_depart'] 	= isset($a['rv_date_depart']) ? $a['rv_date_depart'] : "";
	$b['rv_date_depart'] 	= isset($b['rv_date_depart']) ? $b['rv_date_depart'] : "";
	$a['rv_res_name'] 		= isset($a['rv_res_name']) ? $a['rv_res_name'] : "";
	$b['rv_res_name'] 		= isset($b['rv_res_name']) ? $b['rv_res_name'] : "";
	$a['rv_reservation_ix'] = isset($a['rv_reservation_ix']) ? $a['rv_reservation_ix'] : "";
	$b['rv_reservation_ix'] = isset($b['rv_reservation_ix']) ? $b['rv_reservation_ix'] : "";
	$a['property']			= isset($a['property']) ? $a['property'] : "";
	$b['property']			= isset($b['property']) ? $b['property'] : "";

	if ($a['rv_date_arrive'] == $b['rv_date_arrive']) {
		if ($a['rv_date_depart'] == $b['rv_date_depart']) {
			if ($a['rv_res_name'] == $b['rv_res_name']) {
				if ($a['rv_reservation_ix'] == $b['rv_reservation_ix']) {
					if ($a['property'] == $b['property']) {
						return 0;
					}
				   return ($a['property'] < $b['property']) ? -1 : 1;
				}
			    return ($a['rv_reservation_ix'] < $b['rv_reservation_ix']) ? -1 : 1;
			}
			return ($a['rv_res_name'] < $b['rv_res_name']) ? -1 : 1;
		}
	    return ($a['rv_date_depart'] < $b['rv_date_depart']) ? -1 : 1;
    }
    return ($a['rv_date_arrive'] < $b['rv_date_arrive']) ? -1 : 1;
}

function noteSortDepart($a, $b) {
	$a['rv_date_arrive'] 	= isset($a['rv_date_arrive']) ? $a['rv_date_arrive'] : "";
	$b['rv_date_arrive'] 	= isset($b['rv_date_arrive']) ? $b['rv_date_arrive'] : "";
	$a['rv_date_depart'] 	= isset($a['rv_date_depart']) ? $a['rv_date_depart'] : "";
	$b['rv_date_depart'] 	= isset($b['rv_date_depart']) ? $b['rv_date_depart'] : "";
	$a['rv_res_name'] 		= isset($a['rv_res_name']) ? $a['rv_res_name'] : "";
	$b['rv_res_name'] 		= isset($b['rv_res_name']) ? $b['rv_res_name'] : "";
	$a['rv_reservation_ix'] = isset($a['rv_reservation_ix']) ? $a['rv_reservation_ix'] : "";
	$b['rv_reservation_ix'] = isset($b['rv_reservation_ix']) ? $b['rv_reservation_ix'] : "";
	$a['property']			= isset($a['property']) ? $a['property'] : "";
	$b['property']			= isset($b['property']) ? $b['property'] : "";

	if ($a['rv_date_depart'] == $b['rv_date_depart']) {
		if ($a['rv_res_name'] == $b['rv_res_name']) {
			if ($a['rv_reservation_ix'] == $b['rv_reservation_ix']) {
				if ($a['property'] == $b['property']) {
					if ($a['rv_date_arrive'] == $b['rv_date_arrive']) {
						return 0;
					}
					return ($a['rv_date_arrive'] < $b['rv_date_arrive']) ? -1 : 1;
				}
			    return ($a['property'] < $b['property']) ? -1 : 1;
			}
			return ($a['rv_reservation_ix'] < $b['rv_reservation_ix']) ? -1 : 1;
		}
		return ($a['rv_res_name'] < $b['rv_res_name']) ? -1 : 1;
    }
	return ($a['rv_date_depart'] < $b['rv_date_depart']) ? -1 : 1;
}

function noteSortId($a, $b) {
	$a['rv_reservation_ix'] = isset($a['rv_reservation_ix']) ? $a['rv_reservation_ix'] : "";
	$b['rv_reservation_ix'] = isset($b['rv_reservation_ix']) ? $b['rv_reservation_ix'] : "";

	if ($a['rv_reservation_ix'] == $b['rv_reservation_ix']) {
		return 0;
	}
	return ($a['rv_reservation_ix'] < $b['rv_reservation_ix']) ? -1 : 1;
}

function noteSortName($a, $b) {
	$a['rv_date_arrive'] 	= isset($a['rv_date_arrive']) ? $a['rv_date_arrive'] : "";
	$b['rv_date_arrive'] 	= isset($b['rv_date_arrive']) ? $b['rv_date_arrive'] : "";
	$a['rv_date_depart'] 	= isset($a['rv_date_depart']) ? $a['rv_date_depart'] : "";
	$b['rv_date_depart'] 	= isset($b['rv_date_depart']) ? $b['rv_date_depart'] : "";
	$a['rv_res_name'] 		= isset($a['rv_res_name']) ? $a['rv_res_name'] : "";
	$b['rv_res_name'] 		= isset($b['rv_res_name']) ? $b['rv_res_name'] : "";
	$a['rv_reservation_ix'] = isset($a['rv_reservation_ix']) ? $a['rv_reservation_ix'] : "";
	$b['rv_reservation_ix'] = isset($b['rv_reservation_ix']) ? $b['rv_reservation_ix'] : "";
	$a['property']			= isset($a['property']) ? $a['property'] : "";
	$b['property']			= isset($b['property']) ? $b['property'] : "";

	if ($a['rv_res_name'] == $b['rv_res_name']) {
		if ($a['rv_date_arrive'] == $b['rv_date_arrive']) {
			if ($a['rv_date_depart'] == $b['rv_date_depart']) {
				if ($a['property'] == $b['property']) {
					if ($a['rv_reservation_ix'] == $b['rv_reservation_ix']) {
						return 0;
					}
					return ($a['rv_reservation_ix'] < $b['rv_reservation_ix']) ? -1 : 1;
				}
				return ($a['property'] < $b['property']) ? -1 : 1;
			}
			return ($a['rv_date_depart'] < $b['rv_date_depart']) ? -1 : 1;
		}
		return ($a['rv_date_arrive'] < $b['rv_date_arrive']) ? -1 : 1;
    }
	return ($a['rv_res_name'] < $b['rv_res_name']) ? -1 : 1;
}

function noteSortProperty($a, $b) {
	$a['rv_date_arrive'] 	= isset($a['rv_date_arrive']) ? $a['rv_date_arrive'] : "";
	$b['rv_date_arrive'] 	= isset($b['rv_date_arrive']) ? $b['rv_date_arrive'] : "";
	$a['rv_date_depart'] 	= isset($a['rv_date_depart']) ? $a['rv_date_depart'] : "";
	$b['rv_date_depart'] 	= isset($b['rv_date_depart']) ? $b['rv_date_depart'] : "";
	$a['rv_res_name'] 		= isset($a['rv_res_name']) ? $a['rv_res_name'] : "";
	$b['rv_res_name'] 		= isset($b['rv_res_name']) ? $b['rv_res_name'] : "";
	$a['rv_reservation_ix'] = isset($a['rv_reservation_ix']) ? $a['rv_reservation_ix'] : "";
	$b['rv_reservation_ix'] = isset($b['rv_reservation_ix']) ? $b['rv_reservation_ix'] : "";
	$a['property']			= isset($a['property']) ? $a['property'] : "";
	$b['property']			= isset($b['property']) ? $b['property'] : "";

	if ($a['property'] == $b['property']) {
		if ($a['rv_res_name'] == $b['rv_res_name']) {
			if ($a['rv_date_arrive'] == $b['rv_date_arrive']) {
				if ($a['rv_date_depart'] == $b['rv_date_depart']) {
					if ($a['rv_reservation_ix'] == $b['rv_reservation_ix']) {
						return 0;
					}
					return ($a['rv_reservation_ix'] < $b['rv_reservation_ix']) ? -1 : 1;
				}
				return ($a['rv_date_depart'] < $b['rv_date_depart']) ? -1 : 1;
			}
			return ($a['rv_date_arrive'] < $b['rv_date_arrive']) ? -1 : 1;
		}
		return ($a['rv_res_name'] < $b['rv_res_name']) ? -1 : 1;
	}
	return ($a['property'] < $b['property']) ? -1 : 1;
}

function noteSortVoucher($a, $b) {
	$a['rv_date_arrive'] 	= isset($a['rv_date_arrive']) ? $a['rv_date_arrive'] : "";
	$b['rv_date_arrive'] 	= isset($b['rv_date_arrive']) ? $b['rv_date_arrive'] : "";
	$a['rv_date_depart'] 	= isset($a['rv_date_depart']) ? $a['rv_date_depart'] : "";
	$b['rv_date_depart'] 	= isset($b['rv_date_depart']) ? $b['rv_date_depart'] : "";
	$a['rv_res_name'] 		= isset($a['rv_res_name']) ? $a['rv_res_name'] : "";
	$b['rv_res_name'] 		= isset($b['rv_res_name']) ? $b['rv_res_name'] : "";
	$a['rv_reservation_ix'] = isset($a['rv_reservation_ix']) ? $a['rv_reservation_ix'] : "";
	$b['rv_reservation_ix'] = isset($b['rv_reservation_ix']) ? $b['rv_reservation_ix'] : "";
	$a['voucher']			= isset($a['voucher']) ? $a['voucher'] : "";
	$b['voucher']			= isset($b['voucher']) ? $b['voucher'] : "";
	
	if($a['voucher'] == $b['voucher']) {
		if ($a['rv_date_arrive'] == $b['rv_date_arrive']) {
			if ($a['rv_date_depart'] == $b['rv_date_depart']) {
				if ($a['rv_reservation_ix'] == $b['rv_reservation_ix']) {
					if ($a['rv_res_name'] == $b['rv_res_name']) {
						return 0;
					}
					return ($a['rv_res_name'] < $b['rv_res_name']) ? -1 : 1;
				}
				return ($a['rv_reservation_ix'] < $b['rv_reservation_ix']) ? -1 : 1;
			}
			return ($a['rv_date_depart'] < $b['rv_date_depart']) ? -1 : 1;
		} 
		return ($a['rv_date_arrive'] < $b['rv_date_arrive']) ? -1 : 1;				
	}
	return ($a['voucher'] < $b['voucher']) ? -1 : 1;
}
// [END] - Note sort functions


// [START] - Section filter functions
function buildCheck($name,$id,$isChecked,$onClick="") {
	$checked = "";
	if($isChecked) {
		$checked = "checked";
	}
	return "<input type=\"checkbox\" name=\"".$name."Check\" id=\"$name$id\" $checked onclick=\"$onClick\">";
}

function createChartOptions($chartSections,$chartIds) {
	$html = "";
	foreach($chartSections as $item) {
		
		// Create show checkbox
		$roomShowInput = buildCheck("Room",$item['id'],in_array($item['id'],$chartIds['room']),"linkCheckboxes('Room','" . $item['id'] . "')");
		$departShowInput = buildCheck("Depart",$item['id'],in_array($item['id'],$chartIds['depart']),"linkCheckboxes('Depart','" . $item['id'] . "')");
		
		// Create colour checkbox
		$colourInput = "";
		$legendInput = "";
		if(array_key_exists("colour",$item)) {
			$colourInput = buildCheck("Colour",$item['id'],in_array($item['id'],$chartIds['colour']),"linkCheckboxes('Colour','" . $item['id'] . "')");
			$legendInput = buildCheck("Legend",$item['id'],in_array($item['id'],$chartIds['legend']),"linkCheckboxes('Legend','" . $item['id'] . "')");
		}
		$html .= "
			<tr>
				<td align=\"center\">$roomShowInput</td>
				<td align=\"center\">$departShowInput</td>
				<td>$item[label]</td>
				<td align=\"center\">$colourInput</td>
				<td align=\"center\">$legendInput</td>
			</tr>
		";
	}	
	return $html;
}

function createNoteOptions($noteSections,$noteIds, $parentName="") {
	$html = "";
	foreach($noteSections as $item) {
		if($item['parent'] == $parentName) {
			$subSection = "";
			if($item['name'] != "") {
				$subSection = createNoteOptions($noteSections,$noteIds,$item['name']);
			}
			$itemChecked = in_array($item['id'],$noteIds);
			$onClick = "";
			if($subSection != "") {
				$onClick = "toggleCollapse('noteChild$item[id]');";
			}
			$noteInput = buildCheck("Note",$item['id'],$itemChecked,$onClick);
			$html .= "
				<tr>
					<td align=\"center\">$noteInput</td>
					<td>$item[label]</td>
				</tr>
			";
			if($subSection != "") {
				$rowClass = "collapse printCollapse";
				if($itemChecked) {
					$rowClass = "";
				}
				$html .= "
					<tr id=\"noteChild$item[id]\" class=\"$rowClass\">
						<td>&nbsp;</td>
						<td>
							<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:fixed;\">
							<col width=\"25\" />
							<col />
							$subSection
							</table>
						</td>
					</tr>
				";
			}
		}
	}	
	return $html;
}
// [END] - Section filter functions

function recursive_array_max($a) {
    foreach ($a as $value) {
        if (is_array($value)) {
            $value = recursive_array_max($value);
        }
        if (!(isset($max))) {
            $max = $value;
        } else {
            $max = $value > $max ? $value : $max;
        }
    }
    return $max;
}
