<?php

/**
 * init.form376.php - Operations Chart
 * Job: 312
 * Function: 109 (Report: Operations Chart)
 */

// Set the time limit to 30 minutes
@set_time_limit(1800);

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("operation_chart");
processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);

$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Operations Chart";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
  $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_operation.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$_SERVER['argv'] = array_pad($_SERVER['argv'],46,"");

$dateType = $_SERVER['argv'][1];
$dayCount = $_SERVER['argv'][2];
if(trim($dayCount) == "") {
	$dayCount = "7";
}
$GLOBALS['temp']['dayCount'] = $dayCount;

$GLOBALS['temp']['dateTypeTodayChecked'] = "";
$GLOBALS['temp']['dateTypeDayCountChecked'] = "";
$GLOBALS['temp']['dateTypeRangeChecked'] = "";
switch($dateType) {
case "1":
	$GLOBALS['temp']['dateTypeTodayChecked'] = "checked";
	$fromDate = useDate("from",date("Y-m-d"));
	$toDate = useDate("to",date("Y-m-d"));
	break;
case "2":
	$GLOBALS['temp']['dateTypeDayCountChecked'] = "checked";
	$fromDate = useDate("from",date("Y-m-d"));
	$toDate = useDate("to",date("Y-m-d",time() + (86400*$dayCount)));
	break;
case "4":
	$GLOBALS['temp']['dateTypeTomorrowChecked'] = "checked";
	$fromDate = useDate("from",date("Y-m-d",time() + (86400)));
	$toDate = useDate("to",date("Y-m-d",time() + (86400)));
	break;	
default:
	$GLOBALS['temp']['dateTypeRangeChecked'] = "checked";
	$fromDate = useDate("from", $_SERVER['argv'][3]);
	$toDate = useDate("to", $_SERVER['argv'][4]);
	break;
}
if($_SERVER['argc'] < 2 && trim($_SERVER['argv'][5]) == "") {
	$_SERVER['argv'][5] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}
$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][5],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","ac_accomm_type.ac_accomm_type_ix",$accommACL,false,false);

if($_SERVER['argc'] == 1) {
	$_SERVER['argv'][7] = "30:20";
}
$statusACL = array("20","30","15");
$statusFilter = useFilter("statusRoom",$_SERVER['argv'][6],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$extraFilterType = $_SERVER['argv'][7];
if($extraFilterType == 1) {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "checked";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "";
} else {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "checked";
}

$extraFilter = useFilter("extras", $_SERVER['argv'][8], "SELECT ac_ext_desc FROM ac_extra WHERE ac_extra.ac_extra_ix =", "ac_extra.ac_extra_ix", false, false, false);
if($extraFilter['ids'] != "") {
   $catList = $lDB->get("
      SELECT DISTINCT
         ac_extra.ac_extra_category_id,
         ac_extra_category.ac_extra_cat_desc
      FROM
         ac_extra
         INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      WHERE
         ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
   ",2);
   $extraFilterRows = "";
   $extraFilterIds = "";
   foreach($catList as $item) {
      $extraList = $lDB->get("
         SELECT
            ac_extra.ac_extra_ix as ac_extra_ix,
            ac_ext_desc
         FROM
            ac_extra
         WHERE
            ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
            AND ac_extra.ac_extra_category_id = '$item[ac_extra_category_id]'
      ",2);
      $extraNames = "";
      $extraIds = "";
      foreach($extraList as $extraItem) {
         if($extraNames != "") {
            $extraNames .= ", ";
         }
         $extraNames .= $extraItem['ac_ext_desc'];
         if($extraIds != "") {
            $extraIds .= ":";
         }
         $extraIds .= $extraItem['ac_extra_ix'];
      }
      $extraFilterRows .= "
         <tr id=\"extra_$item[ac_extra_category_id]\">
            <td><textarea rows=1 style=\"width: 80px; height: 20px;\" id=\"extraCatText\" class=\"txtg\" readonly tabIndex=\"-1\">$item[ac_extra_cat_desc]</textarea></td>
            <td><textarea rows=1 style=\"width: 200px; height: 20px;\" id=\"extraText\" class=\"txtg\" readonly tabIndex=\"-1\">$extraNames</textarea></td>
            <td><input type=button class=\"button bDelete\" style=\"width:20; background-position: center;\" value=\"\" onclick=\"removeExtraIds('$item[ac_extra_category_id]');\"></td>
         </tr>
      ";
      $extraFilterIds .= "
         <input type=\"hidden\" id=\"extraIds_$item[ac_extra_category_id]\" name=\"extraIds\" value=\"$extraIds\">
      ";
   }
   $GLOBALS['temp']['extraFilterRows'] = $extraFilterRows;
   $GLOBALS['temp']['extraFilterIds'] = $extraFilterIds;
   $GLOBALS['temp']['extraAllClass'] = "collapse printCollapse";
} else {
   $GLOBALS['temp']['extraFilterRows'] = "";
   $GLOBALS['temp']['extraFilterIds'] = "";
   $GLOBALS['temp']['extraAllClass'] = "";
}

$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][9], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_ix", false, false, false);

if($extraFilterType == 1) {
	$extraFilterFinal = $extraCategoryFilter;
} else {
	$extraFilterFinal = $extraFilter;
}

$showExtra = $_SERVER['argv'][10];
$GLOBALS['temp']['extraShowAllChecked'] = "";
$GLOBALS['temp']['extraShowPropChecked'] = "";
$GLOBALS['temp']['extraShowNonChecked'] = "";
switch($showExtra) {
case "1":
	$GLOBALS['temp']['extraShowAllChecked'] = "checked";
	break;
default:
case "2":
	$GLOBALS['temp']['extraShowPropChecked'] = "checked";
	break;
case "3":
	$GLOBALS['temp']['extraShowNonChecked'] = "checked";
	break;
}

$direction = $_SERVER['argv'][11];
$GLOBALS['temp']['directionRoomChecked'] = "checked";
$GLOBALS['temp']['directionDateChecked'] = "";
if($direction == "2") {
	$GLOBALS['temp']['directionRoomChecked'] = "";
	$GLOBALS['temp']['directionDateChecked'] = "checked";
}

if($_SERVER['argv'][12] == "") {
	$roomSort = $lDB->get("SELECT rf_accomm_sort_ind FROM rf_default", 4);
} else {
	$roomSort = $_SERVER['argv'][12];
}

if($roomSort == "1") {
	$GLOBALS['temp']['roomSortNumberChecked'] = "checked";
	$GLOBALS['temp']['roomSortAccommChecked'] = "";
	$roomSortSQL = "
				(ac_desc+0),
				ac_desc,
				ac_accomm_type.ac_accomm_sequence
	";
} else {
	$GLOBALS['temp']['roomSortNumberChecked'] = "";
	$GLOBALS['temp']['roomSortAccommChecked'] = "checked";
	$roomSortSQL = "
			ac_accomm_type.ac_accomm_sequence,
			(ac_desc+0),
			ac_desc		
	";
}

$autoRoom = $_SERVER['argv'][13];
$GLOBALS['temp']['autoRoomChecked'] = "checked";
$GLOBALS['temp']['autoRoomWarning'] = "collapse printCollapse";
if($autoRoom == "2") {
	$GLOBALS['temp']['autoRoomChecked'] = "";
	$GLOBALS['temp']['autoRoomWarning'] = "";
}

$showChart = $_SERVER['argv'][14];
$GLOBALS['temp']['showChartChecked'] = "checked";
$GLOBALS['temp']['chartOptionStyle'] = "";
if($showChart == "2") {
	$GLOBALS['temp']['showChartChecked'] = "";
	$GLOBALS['temp']['chartOptionStyle'] = "display: none;";
}

$showNotes = $_SERVER['argv'][15];
$GLOBALS['temp']['showNotesChecked'] = "checked";
$GLOBALS['temp']['notesOptionStyle'] = "";
if($showNotes == "2") {
	$GLOBALS['temp']['showNotesChecked'] = "";
	$GLOBALS['temp']['notesOptionStyle'] = "display: none;";
}

$showAccomm = $_SERVER['argv'][16];
$GLOBALS['temp']['showAccommChecked'] = "checked";
if($showAccomm == "2") {
	$GLOBALS['temp']['showAccommChecked'] = "";
}

$showPAX = $_SERVER['argv'][17];
$GLOBALS['temp']['showPAXChecked'] = "checked";
if($showPAX == "2") {
	$GLOBALS['temp']['showPAXChecked'] = "";
}

$showEmptyRooms = $_SERVER['argv'][43];
$GLOBALS['temp']['showEmptyRoomsChecked'] = "";
if($showEmptyRooms == "1") {
	$GLOBALS['temp']['showEmptyRoomsChecked'] = "checked";
}

$showLegend = $_SERVER['argv'][18];
$GLOBALS['temp']['showLegendChecked'] = "checked";
if($showLegend == "2") {
	$GLOBALS['temp']['showLegendChecked'] = "";
}

$showUnitLabel = $_SERVER['argv'][19];
$GLOBALS['temp']['showUnitLabelChecked'] = "checked";
if($showUnitLabel == "2") {
	$GLOBALS['temp']['showUnitLabelChecked'] = "";
}

$showUnitNumber = $_SERVER['argv'][20];
$GLOBALS['temp']['showUnitNumberChecked'] = "checked";
if($showUnitNumber == "2") {
	$GLOBALS['temp']['showUnitNumberChecked'] = "";
}

$hideAccommType = $_SERVER['argv'][44];
$GLOBALS['temp']['hideAccommTypeChecked'] = "";
if($hideAccommType == "1") {
	$GLOBALS['temp']['hideAccommTypeChecked'] = "checked";
}

$showDatePAX = $_SERVER['argv'][21];
$GLOBALS['temp']['showDatePAXChecked'] = "checked";
if($showDatePAX == "2") {
	$GLOBALS['temp']['showDatePAXChecked'] = "";
}

$roomJoins = array(
	array('table'=>'rv_res_item_group'),
	array('table'=>'rv_reservation_item','type'=>'INNER','on'=>'rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id','requires'=>"rv_res_item_group"),
	array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",'requires'=>"rv_reservation_item"),
	array('table'=>"pr_persona",'alias'=>"pr_agent_name",'type'=>"LEFT",'on'=>"pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_consultant",'type'=>"LEFT",'on'=>"pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_originator",'type'=>"LEFT",'on'=>"pr_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_country",'type'=>"LEFT",'on'=>"rf_country.rf_country_ix = rv_reservation.rf_country_id",'requires'=>"rv_reservation"),
	array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id",'requires'=>"rv_reservation"),
	array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id"),
	array('table'=>"ac_accomm_room",'type'=>"LEFT",'on'=>"ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id"),
	array('table'=>"ac_pay_plan",'type'=>"LEFT",'on'=>"ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id",'requires'=>"rv_reservation")
);
$itemJoins = array(
	array('table'=>'rv_reservation_item'),
	array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",'requires'=>"rv_reservation_item"),
	array('table'=>"pr_persona",'alias'=>"pr_agent_name",'type'=>"LEFT",'on'=>"pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_contact",'type'=>"LEFT",'on'=>"pr_contact.pr_persona_ix = rv_reservation.rv_corr_persona_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_consultant",'type'=>"LEFT",'on'=>"pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_originator",'type'=>"LEFT",'on'=>"pr_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_source",'type'=>"LEFT",'on'=>"pr_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_country",'type'=>"LEFT",'on'=>"rf_country.rf_country_ix = rv_reservation.rf_country_id",'requires'=>"rv_reservation"),
	array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id",'requires'=>"rv_reservation"),
	array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id"),
	array('table'=>"ac_pay_plan",'type'=>"LEFT",'on'=>"ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id",'requires'=>"rv_reservation")
);

$resJoins = array(
	array('table'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_agent_name",'type'=>"LEFT",'on'=>"pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_consultant",'type'=>"LEFT",'on'=>"pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_contact",'type'=>"LEFT",'on'=>"pr_contact.pr_persona_ix = rv_reservation.rv_corr_persona_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"pr_originator",'type'=>"LEFT",'on'=>"pr_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_country",'type'=>"LEFT",'on'=>"rf_country.rf_country_ix = rv_reservation.rf_country_id",'requires'=>"rv_reservation"),
	array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id",'requires'=>"rv_reservation"),
	array('table'=>"ac_pay_plan",'type'=>"LEFT",'on'=>"ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id",'requires'=>"rv_reservation"),
	array('table'=>'rv_reservation_item','type'=>'INNER','on'=>'rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix','requires'=>"rv_reservation"),
	array('table'=>"rv_res_item_group",'type'=>"LEFT",'on'=>"rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix",'requires'=>"rv_reservation_item")
);

// Do not use the ID to refer to a section as it may change, rather add a 'name' field

$cols = array (
	array (	'id'=>1 , 'label'=>"Res#", 'type'=>"string", 'fields'=>array("rv_reservation.rv_reservation_ix"),
			'colour'=>array('function'=>"getReservationColour", 'style'=>array('bold'=>"1"), 'width'=>"65", 'fields'=>array("rv_reservation.rv_reservation_ix")),  'fulDesc'=>"Reservation Number"
	),
	array (	'id'=>2 ,'label'=>"Res name", 'type'=>"string", 'fields'=>array("rv_reservation.rv_res_name"),
			'colour'=>array('function'=> "getReservationColour", 'fields'=>array("rv_reservation.rv_reservation_ix")), 'width'=>"150", 'fulDesc'=>"Reservation Name"
	),
	array ('id'=>3,  'label'=>"PAX", 'type'=>"complex", 'function'=>"getPax", 'width'=>"70", 
		   'fields'=>array("rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count")
	),
	array (	'id'=>4,  'label'=>"Ad", 'type'=>"complex", 'function'=>"getAdults", 'width'=>"30",
			'fields'=>array("rv_reservation_item.rv_item_adult_count"), 'numeric'=> 1
	),
	array (	'id'=>5,  'label'=>"Ch", 'type'=>"complex", 'function'=>"getChildren", 'width'=>"30", 
			'fields'=>array("rv_reservation_item.rv_item_child_count"), 'numeric'=> 1
	),
	array ('id'=>6,'label'=>"Itinerary dates",'type'=>"complex",'function'=>"getItineraryDates",'width'=>"150",			'fields'=>array("rv_reservation_item.rv_item_date_arrive","rv_reservation_item.rv_item_date_depart")
	),
	array (	'id'=>7, 'label'=>"Arrival", 'type'=>"complex", 'width'=>"70", 'function'=>"getItineraryDate", 
			'fields'=>array("rv_reservation_item.rv_item_date_arrive")
	),
	array (	'id'=>8, 'label'=>"Nights", 'type'=>"complex", 'function'=>"getItineraryNoOfNights", 'width'=>"40", 
			'fields'=>array("rv_reservation_item.rv_item_date_arrive", "rv_reservation_item.rv_item_date_depart"),
			'numeric'=> 1
	),
	array (	'id'=>9, 'label'=>"Departure", 'type'=>"complex", 'width'=>"70", 'function'=>"getItineraryDate",
			'fields'=>array("rv_reservation_item.rv_item_date_depart")
	),
	array (	'id'=>10,  'label'=>"Status", 'type'=>"string",  'width'=>"70", 
			'fields'=>array("rf_reservation_status.rf_reservation_status_desc")
	),
	array (	'id'=>11,  'label'=>"Status date", 'type'=>"complex", 'width'=>"70", 'function'=>"getStatusDate",  
			'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date")
	),
	array (	'id'=>12,  'label'=>"Agent", 'type'=>"string", 'width'=>"150", 'blank'=>"Direct",  
			'fields'=>array("pr_agent_name.pr_name_last as pr_agent_name"),  'colour'=>array('function'=>"getAgentColour", 'fields'=>array("rv_reservation.rv_agent_id"))
	),
	array (	'id'=>13,  'label'=>"Originator", 'type'=>"string", 'width'=>"150",   
			'fields'=>array("pr_originator.pr_name_last as pr_originator_name"),'blank'=>"No originator", 'colour'=>array('function'=>"getAgentColour", 'fields'=>array("rv_reservation.rv_origin_agent_id"))
	),
	array (	'id'=>14,  'label'=>"Voucher", 'type'=>"string", 'width'=>"120", 
			'fields'=>array("rv_reservation.rv_agent_ref")
	),
	array (	'id'=>15,  'label'=>"Pmt Status", 'type'=>"complex", 'width'=>"100", 'function'=>"getPaymentStatus",
			'fields'=>array("rv_reservation.rv_amt_accomm_payable","rv_reservation.rv_amt_extra_payable", "rv_reservation.rv_amt_travel_payable","rv_reservation.rv_amt_paid"),  'colour'=> array('function'=>"getPaymentColour", 'fields'=>array("rv_reservation.rv_amt_accomm_payable", "rv_reservation.rv_amt_extra_payable", "rv_reservation.rv_amt_travel_payable", "rv_reservation.rv_amt_paid"))
	),
	array (	'id'=>16, 'label'=>"Rate type", 'type'=>"string", 'fields'=>array("rt_rate_type.rt_rate_type_desc"), 
			'width'=>"100",	'colour'=>array('function'=>"getColourFromField", 'fields'=>array("rt_rate_type.rt_rate_type_colour"))
	),
	array ('id'=>17,  'label'=>"Contact Person", 'type'=>"complex", 'width'=>"150", 'function'=>"getContactName",
			'fields'=>array("rv_reservation.rv_corr_persona_id"),'blank'=>"No Contact",  'colour'=>array('function'=>"getContactColour",'fields'=>array("rv_reservation.rv_corr_persona_id"))
	),
	array (	'id'=>18,  'label'=>"Consultant", 'type'=>"string", 'width'=>"150", 'blank'=>"No consultant", 
			'fields'=>array("pr_consultant.pr_name_first as pr_consultant_name_first", "pr_consultant.pr_name_last as pr_consultant_name_last"), 'colour'=>array('function'=>"getConsultantColour", 'fields'=>array("rv_reservation.rv_consultant_id"))
	),
	array (	'id'=>19, 'label'=>"Source", 'type'=>"string", 'width'=>"120",'blank'=>"No source",
			'fields'=>array("rf_source.rf_source_desc"), 'colour'=>array('function'=>'getColourFromField', 'fields'=>array("rf_source.rf_source_colour"))
	),
	array (	'id'=>20, 'label'=>"Nationality", 'type'=>"string", 'width'=>"120",   
			'fields'=>array("rf_country.rf_country_name"), 'colour'=>array('function'=>"getColourFromField", 'fields'=>array("rf_country.rf_country_colour"))
	),
	array (	'id'=>21, 'label'=>"Booking date", 'type'=>"date", 'width'=>"70",   
			'fields'=>array("rv_reservation.rv_date_recorded")
	),
	array (	'id'=>22, 'label'=>"Last amended date", 'type'=>"date", 'width'=>"70",   
			'fields'=>array("rv_reservation.rv_date_changed"), 'fulDesc'=>"Last amended date"
	),
	array (	'id'=>23, 'label'=>"Optionals",'type'=>"complex", 'width'=>"150",'function'=>"getOptionalComponents",	
			'fields'=>array("rv_reservation_item.rv_reservation_item_ix")
	),
	array (	'id'=>24, 'label'=>"Rooming status", 'type'=>"complex", 'width'=>"100", 'function'=>"getRoomInfo",
			'fields'=>array("ac_accomm_type.ac_accomm_type_ix", "ac_accomm_room.ac_accomm_type_id", "rv_res_item_group.rv_room_requested_yn", "rv_res_item_group.rv_room_request_reason")
	),
	array (	'id'=>25, 'label'=>"Guest names", 'type'=>"complex",'width'=>"", 'function'=>"getGuestNames",
			'fields'=>array("rv_res_item_group.rv_res_item_group_ix","rv_reservation.rv_reservation_ix") 
	),
	array (	'id'=>26, 'label'=>"Guest information", 'type'=>"string", 'width'=>"", 'perDay'=>1,  
			'fields'=>array("rv_reservation.rv_note_guests"), 'fulDesc'=>"Guest information"
	),
	array (	'id'=>27, 'label'=>"Res notes", 'type'=>"string", 'width'=>"", 'fulDesc'=>"Reservation Notes",  
			'fields'=>array("rv_reservation.rv_note_general"), 'perDay'=>1
	),
	array (	'id'=>28, 'label'=>"Res internal memos", 'type'=>"string", 'width'=>"", 'perDay'=>1,   
			'fields'=>array("rv_reservation.rv_note_internal"), 'fulDesc'=>"Reservation internal memos"
	),
	array (	'id'=>29, 'label'=>"Travel description", 'type'=>"complex", 'width'=>"",  
			'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 
			'function'=>"getTravel", 'colour'=>array('function'=>'getColourFromField', 'perDay'=>1, 
			'fields'=>array("ac_extra.ac_ext_colour")), 'name'=>"travel", 'fulDesc'=>"Travel description"
	),
	array (	'id'=>30, 'label'=>"Travel notes", 'name'=>"travelNote", 'type'=>"complex", 'width'=>"", 
			'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 
			'name'=>"travelNote", 'key'=>"travel", 'function'=>"getTravelChartNotes", 'perDay'=>1, 'fulDesc'=>"Travel notes"
	),
	array ('id'=>31, 'label'=>"Travel internal memos",'name'=>"travelMemo", 'type'=>"complex", 'width'=>"", 'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'key'=>"travel", 'function'=>"getTravelChartMemo", 'perDay'=>1, 'fulDesc'=>"Travel internal memos"
	),
	array (	'id'=>32, 'label'=>"Travel ETD", 'type'=>"complex", 'width'=>"", 'fulDesc'=>"Travel ETD", 
			'fields'=>array("rv_reservation.rv_reservation_ix", "rv_res_item_group.rv_res_item_group_ix"), 'name'=>"travelETD", 'key'=>"travel", 'function'=>"getTravelETD"
	),
	array (	'id'=>33,'label'=>"Travel ETA", 'type'=>"complex", 'width'=>"",'name'=>"travelETA",  
			'fields'=>array("rv_reservation.rv_reservation_ix", "rv_res_item_group.rv_res_item_group_ix"), 
			'function'=>"getTravelETA", 'fulDesc'=>"Travel ETA", 'key'=>"travel"
	),
	array (	'id'=>34, 'label'=>"Extras description", 'name'=>"extras", 'type'=>"complex", 'width'=>"", 
			'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 
			'function'=>"getExtras", 'colour'=>array('function'=>'getColourFromField', 'perDay'=>1,
			'fields'=>array("ac_extra.ac_ext_colour")), 'fulDesc'=>"Extras description"
	),
	array (	'id'=>35, 'label'=>"Extras notes", 'name'=>"extraNote", 'type'=>"complex", 'width'=>"",  
			'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"), 'function'=>"getExtrasChartNotes", 'perDay'=>1, 'fulDesc'=>"Extras description"
	),
	array ( 'id'=>36, 'label'=>"Extras internal memos", 'name'=>"extraMemo", 'type'=>"complex", 'width'=>"", 
			'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"),
			'function'=>"getExtrasChartMemo", 'perDay'=>1, 'fulDesc'=>"Extras internal memos"
	),
	array ('id'=>37, 'label'=>"Arrival DD", 'type'=>"complex", 'width'=>"70", 'numeric'=> 1,  
		'fields'=>array("rv_reservation_item.rv_item_date_arrive"), 'function'=>"getItineraryDateDD"
	),
	array (	'id'=>38,  'label'=>"Arrival MM", 'type'=>"complex", 'width'=>"70", 'numeric'=> 1,		
			'fields'=>array("rv_reservation_item.rv_item_date_arrive"), 'function'=>"getItineraryDateMM"
	),
	array (	'id'=>39,  'label'=>"Departure DD", 'type'=>"complex", 'width'=>"70", 'numeric'=> 1,  
			'fields'=>array("rv_reservation_item.rv_item_date_depart"), 'function'=>"getItineraryDateDD"
	),
	array (	'id'=>40,  'label'=>"Departure MM", 'type'=>"complex", 'width'=>"70", 'numeric'=> 1,  
			'fields'=>array("rv_reservation_item.rv_item_date_depart"), 'function'=>"getItineraryDateMM"
	),
	array (	'id'=>41,  'label'=>"Invoice #", 'type'=>"string", 'width'=>"70",  
			'fields'=>array("rv_reservation_item.fn_invoice_id")
	),
	array (	'id'=>42, 'label'=>"Invoice currency", 'type'=>"complex", 'width'=>"70",  
			'fields'=>array("rv_reservation_item.fn_invoice_id"), 'function'=>"getInvoiceCurrency"
	),
	array (	'id'=>43, 'label'=>"Extras serviced by", 'name'=>"extraSupplier",  'type'=>"complex", 'width'=>"",  
			'fields'=>array("rv_reservation.rv_reservation_ix","rv_res_item_group.rv_res_item_group_ix"),
			'function'=>"getExtrasChartSupplier", 'perDay'=>1, 'fulDesc'=>"Extras serviced by"
	),
	array (	'id'=>44, 'label'=>"Travel extras serviced by",'type'=>"complex", 'width'=>"", 'name'=>"travelSupplier", 
			'fields'=>array("rv_reservation.rv_reservation_ix", "rv_res_item_group.rv_res_item_group_ix"),
			'key'=>"travel", 'function'=>"getTravelSupplier", 'fulDesc'=>"Travel extras serviced by"
	),
	array (	'id'=>45, 'label'=>"Payment Plan", 'type'=>"string", 'width'=>"", 'fulDesc'=>"Payment Plan",  
			'fields'=>array("ac_pay_plan.ac_pay_plan_desc"),'colour'=>array('function'=> "getPayPlanColour", 'fields'=>array("rv_reservation.ac_pay_plan_id"))
	),
	array (	'id'=>46, 'label'=>"Repeat guest", 'type'=>"complex",'width'=>"70", 'function'=>"getGuestVisits",
			'fields'=>array("rv_res_item_group.rv_res_item_group_ix","rv_reservation.rv_reservation_ix") 
	)
);


$noteCols = array(
	array('id'=>1,  'label'=>"Itinerary summary",     'type'=>"complex", 'fields'=>array("rv_reservation.rv_note_general"), 'name'=>"itinerarySum", 'key'=>'rv_note_general'),
	array('id'=>2,  'label'=>"Notes",     'type'=>"string", 'fields'=>array("rv_reservation.rv_note_general"), 'name'=>"resNote", 'key'=>'rv_note_general'),
	array('id'=>3,  'label'=>"Memos",        'type'=>"string", 'fields'=>array("rv_reservation.rv_note_internal"), 'name'=>"resMemo", 'key'=>'rv_note_internal'),
	array('id'=>4,  'label'=>"Guest information",     'type'=>"string", 'fields'=>array("rv_reservation.rv_note_guests"), 'name'=>"guestNote", 'key'=>'rv_note_guests'),
	array('id'=>5,  'label'=>"Guest details", 'type'=>"complex", 'name'=>"guestSpecific"),
	array('id'=>6,  'label'=>"Extras",'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"extras", 'key'=>"extras"),
	array('id'=>7,  'label'=>"Extras notes",'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"extraNote", 'key'=>"extras"),
	array('id'=>8,  'label'=>"Extras memos",'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"extraMemo", 'key'=>"extras"),
	array('id'=>9, 'label'=>"Travel",'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"travel", 'key'=>"travel"),
	array('id'=>10,  'label'=>"Travel notes",'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"travelNote", 'key'=>"travel"),
	array('id'=>11,  'label'=>"Travel memos",'type'=>"ignore", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'name'=>"travelMemo", 'key'=>"travel"),
	array('id'=>12, 'label'=>"Financials",      'type'=>"complex", 'fields'=>array("rv_reservation.rv_reservation_ix"), 'function'=>"getFinancials", 'name'=>"financials", 'key'=>"financial"),
	array('id'=>13,  'label'=>"Source",     'type'=>"string", 'fields'=>array("rf_source.rf_source_desc"), 'name'=>"resSource", 'key'=>'source'),
	array('id'=>14,  'label'=>"Agent",     'type'=>"string", 'fields'=>array("pr_agent_name.pr_name_last as pr_agent_name"), 'name'=>"resAgent", 'key'=>'agent'),
	array('id'=>15, 'label'=>"Nationality", 'type'=>"string", 'fields'=>array("rf_country.rf_country_name"), 'name'=>"resNationality", 'key'=>"nationality"),
	array('id'=>16, 'label'=>"Repeat Guests", 'type'=>"complex", 'function'=>"getGuestVisits", 'fields'=>array("rv_res_item_group.rv_res_item_group_ix","rv_reservation.rv_reservation_ix","rv_reservation_item.rv_reservation_item_ix"), 'name'=>"resRepeatGuests", 'key'=>"repeatguests"),
	array('id'=>17, 'label'=>"Internal Consultant", 'type'=>"string", 'fields'=>array("pr_consultant.pr_name_first as pr_consultant_name_first", "pr_consultant.pr_name_last as pr_consultant_name_last"), 'name'=>"resIntConsultant", 'key'=>"intconsultant"),
	array('id'=>18, 'label'=>"Contact Person", 'type'=>"complex", 'function'=>"getContactName", 'fields'=>array("rv_reservation.rv_corr_persona_id"), 'name'=>"resContactPerson", 'key'=>"contactperson"),
	array('id'=>19, 'label'=>"Originator", 'type'=>"string", 'fields'=>array("pr_originator.pr_name_first as pr_originator_name_first", "pr_originator.pr_name_last as pr_originator_name_last"), 'name'=>"resOriginator", 'key'=>"originator"),
	array('id'=>20, 'label'=>"Payment Plan", 'type'=>"string", 'fields'=>array("ac_pay_plan.ac_pay_plan_desc"), 'name'=>"resPaymentPlan", 'key'=>"paymentplan"),
	array('id'=>21, 'label'=>"Rate type", 'type'=>"string", 'fields'=>array("rt_rate_type.rt_rate_type_desc"), 'name'=>"resRateType", 'key'=>"ratetype"),
	array('id'=>22, 'label'=>"Status", 'type'=>"string", 'fields'=>array("rf_reservation_status.rf_reservation_status_desc"), 'name'=>"resStatus", 'key'=>"status"),
	array('id'=>23, 'label'=>"Voucher", 'type'=>"string", 'fields'=>array("rv_reservation.rv_agent_ref"), 'name'=>"resVoucher", 'key'=>"voucher")
);

$chartIds = array(
	'room'=>trim($_SERVER['argv'][22])==""?array():explode(":",$_SERVER['argv'][22]),
	'depart'=>trim($_SERVER['argv'][23])==""?array():explode(":",$_SERVER['argv'][23]),
	'stayOver'=>trim($_SERVER['argv'][37])==""?array():explode(":",$_SERVER['argv'][37]),
	'perDay'=>trim($_SERVER['argv'][38])==""?array():explode(":",$_SERVER['argv'][38]),
	'colour'=>trim($_SERVER['argv'][24])==""?array():explode(":",$_SERVER['argv'][24]),
	'legend'=>trim($_SERVER['argv'][25])==""?array():explode(":",$_SERVER['argv'][25])
);

if(is_array($chartIds['perDay']) && !empty($chartIds['perDay'])) {
	foreach($chartIds['perDay'] as $perId) {
		if(!isset($chartIds['room'][$perId]) && !isset($chartIds['stayOver'][$perId]) && !isset($chartIds['depart'][$perId])) {
			if(!in_array($perId, $chartIds['room'])) {
				array_push($chartIds['room'], $perId);
			}
			if(!in_array($perId, $chartIds['stayOver'])) {
				array_push($chartIds['stayOver'], $perId);
			}
			if(!in_array($perId, $chartIds['depart'])) {
				array_push($chartIds['depart'], $perId);
			}
		}
	}
}

$chartIds['combined'] = array_unique(array_merge($chartIds['room'], $chartIds['depart'], $chartIds['stayOver']));
$noteIds = trim($_SERVER['argv'][26])==""?array():explode(":", $_SERVER['argv'][26]);

$noteSort = $_SERVER['argv'][27];
$GLOBALS['temp']['noteSortArriveChecked'] = "";
$GLOBALS['temp']['noteSortDepartChecked'] = "";
$GLOBALS['temp']['noteSortIdChecked'] = "";
$GLOBALS['temp']['noteSortNameChecked'] = "";
$GLOBALS['temp']['noteSortPropChecked'] = "";
$GLOBALS['temp']['noteSortVoucher'] = "";
switch($noteSort) {
case "1":
	$GLOBALS['temp']['noteSortArriveChecked'] = "selected";
	break;
case "2":
	$GLOBALS['temp']['noteSortDepartChecked'] = "selected";
	break;
case "3":
	$GLOBALS['temp']['noteSortIdChecked'] = "selected";
	break;
case "4":
	$GLOBALS['temp']['noteSortNameChecked'] = "selected";
	break;
case "6":
	$GLOBALS['temp']['noteSortVoucher'] = "selected";
	break;
default:
	$GLOBALS['temp']['noteSortPropChecked'] = "selected";
	break;
}

$noteDate = $_SERVER['argv'][28];
$GLOBALS['temp']['noteDateReservationChecked'] = "checked";
$GLOBALS['temp']['noteDatePropertyChecked'] = "";
if($noteDate == "2") {
$GLOBALS['temp']['noteDateReservationChecked'] = "";
$GLOBALS['temp']['noteDatePropertyChecked'] = "checked";
}
$showDatesAllProps = $noteDate == "2" ? false : true;

$options = $_SERVER['argv'][29];

switch ( $options & 15 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
	break;
case REP_VIEW_CSV_FROM_XML:
	$renderMode = "csvFromXml";
	$renderType = "view";
	break;
case REP_VIEW_OO:
	$renderMode = "oofice";
	$renderType = "";
	break;
}

$showCatExtras = $_SERVER['argv'][31];
$GLOBALS['temp']['showCatExtrasChecked'] = "checked";
if($showCatExtras == "2") {
	$GLOBALS['temp']['showCatExtrasChecked'] = "";
}

$componantsACL= $lDB->get("
	SELECT DISTINCT
			rt_component.rt_component_ix
		FROM
			rt_component 
		WHERE
			rt_component_inactive_yn = '0'
",3);

$componentsFilter = useFilter("components",$_SERVER['argv'][32],"SELECT DISTINCT rt_component.rt_component_desc FROM rt_component WHERE rt_component_ix =", "rv_res_item_comp.rt_component_id", false, false, false);

$rateFilter = useFilter("rate",$_SERVER['argv'][42],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =","rv_reservation_item.rt_rate_type_id",false,false,false);

if($rateFilter['ids'] === "0") {
	$GLOBALS['temp']['rateIds'] = '<input type="hidden" id="rateIds" name="rateIds" value="">';
	$GLOBALS['temp']['rateNames'] = "All";
	$rateFilter['where'] = '';
}

$colArg = $_SERVER['argv'][33];
$colArray = array();
$colOrder = array();
$colSort = array();
$colHeader = false;

if(trim($colArg) != "") {
	$count = 0;
	foreach(explode(":",$colArg) as $item) {
		$col = explode(",",$item);
		$colActive[$count] = $col[0];
		$colOrder[$count] = $col[1];
		//$colSort[$count] = $col[2];
		$width = $col[2];
		if(!is_numeric($width)) {
			$width = isset($cols[$count]['width']) ? $cols[$count]['width'] : "";
		}
		
		$label = trim($col[3]);
		if($label == "") {
			$label = isset($cols[$count]['label']) ? $cols[$count]['label'] : "";
		}
		$header = trim($col[4]);
		if($header != "") {
			$colHeader = true;
		}
		$align = trim($col[5]);
		if($align == "") {
			$align = isset($cols[$count]['align']) ? $cols[$count]['align'] : "";
		}
		$colArray[$count] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			//"sort"=>$col[2],
			//"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"align"=>$align
		);
		$cols[$count]['order'] = $col[1];
		$cols[$count]['width'] = $width;
		$cols[$count]['label'] = $label;
		$cols[$count]['header'] = $header;
		$cols[$count]['align'] = $align;
		$count++;
	}
}
asort($colOrder);
asort($colSort);
$colData = array();

foreach($cols as $colKey=>$colItem) {
	$width = isset($colItem['width']) ? $colItem['width'] : "";
	$sort = "";
	$col_direction = "";
	$label = isset($colItem['label']) ? $colItem['label'] : "";
	$fulDesc = isset($colItem['fulDesc']) ? $colItem['fulDesc'] : "";
	$active = "";
	$order = "";
	$header = "";
	$align = isset($colItem['align']) ? $colItem['align'] : "";
	$roomcheck = "";
	$socheck = "";
	$departcheck = "";

	if(isset($colArray[$colKey]['active']) && $colArray[$colKey]['active'] == "1") {
		$width = $colArray[$colKey]['width'];
		//$sort = $colArray[$colKey]['sort'];
		//$col_direction = $colArray[$colKey]['direction'];		
		$label = $colArray[$colKey]['label'];
		$active = "1";
		$order = $colArray[$colKey]['order'];
		$header = $colArray[$colKey]['header'];
		$align = $colArray[$colKey]['align'];
		$roomcheck = in_array($colItem['id'],$chartIds['room'])?1:0;
		$socheck = in_array($colItem['id'],$chartIds['stayOver'])?1:0;
		$departcheck = in_array($colItem['id'],$chartIds['depart'])?1:0;
	}
	if(array_key_exists("perDay",$colItem)) {
		$pDay = 1;
	} else {
		$pDay = 0;
	}
	if(array_key_exists("colour",$colItem)) {
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			//'"sort":"'.$sort.'"',
			//'"direction":"'.$col_direction.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"align":"'.$align.'"',
			'"colorOpt":"1"',
			'"pDay":"'.$pDay.'"',
			'"room":"'.$roomcheck.'"',
			'"sover":"'.$socheck.'"',
			'"depart":"'.$departcheck.'"',
			'"perDay":"'.in_array($colItem['id'],$chartIds['perDay']).'"',
			'"color":"'.in_array($colItem['id'],$chartIds['colour']).'"',
			'"legend":"'.in_array($colItem['id'],$chartIds['legend']).'"',
			'"fulDesc":"'.$fulDesc.'"'
		);
	} else {
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			//'"sort":"'.$sort.'"',
			//'"direction":"'.$col_direction.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"align":"'.$align.'"',
			'"pDay":"'.$pDay.'"',
			'"room":"'.$roomcheck.'"',
			'"sover":"'.$socheck.'"',
			'"depart":"'.$departcheck.'"',
			'"perDay":"'.in_array($colItem['id'],$chartIds['perDay']).'"',
			'"fulDesc":"'.$fulDesc.'"'
		); 
	}
	array_push($colData,'{'.join(",",$colDataItem)."}
");
}

$colData = '['.join(",",$colData).']';
$GLOBALS['temp']['colData'] = $colData;

$sort_array = array();
$orderArr = array();
 foreach ($cols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}

array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $cols);

$sort_array = array();
foreach ($cols as $key => $row) {
   $sort_array[$key]  = $row['id'];
}

$newChartIds = array('room'=>array(), 'stayOver'=>array(), 'depart'=>array());
foreach($sort_array as $key=>$item) {
	if(in_array($item, $chartIds['room'])){
		$newChartIds['room'][] = $item;
	}
	if(in_array($item, $chartIds['stayOver'])){
		$newChartIds['stayOver'][] = $item;
	}
	if(in_array($item, $chartIds['depart'])){
		$newChartIds['depart'][] = $item;
	}
	if(in_array($item, $chartIds['combined'])){
		$newChartIds['combined'][] = $item;
	}
	
}

if (isset($newChartIds['room'])) {
	$chartIds['room'] = $newChartIds['room'];
}
if (isset($newChartIds['stayOver'])) {
	$chartIds['stayOver'] = $newChartIds['stayOver'];
}
if (isset($newChartIds['depart'])) {
	$chartIds['depart'] = $newChartIds['depart'];
}
if (isset($newChartIds['combined'])) {
	$chartIds['combined'] = $newChartIds['combined'];
}

$groupingSepAsRow = $_SERVER['argv'][34];
$GLOBALS['temp']['groupingSepAsRowChecked'] = "checked";
$GLOBALS['temp']['groupingSepAsColChecked'] = "";
$GLOBALS['temp']['groupingSepAsTabChecked'] = "";
if($groupingSepAsRow == "2") {
	$GLOBALS['temp']['groupingSepAsRowChecked'] = "";
	$GLOBALS['temp']['groupingSepAsColChecked'] = "checked";
	$GLOBALS['temp']['groupingSepAsTabChecked'] = "";
} else if($groupingSepAsRow == "3") {
	$GLOBALS['temp']['groupingSepAsRowChecked'] = "";
	$GLOBALS['temp']['groupingSepAsColChecked'] = "";
	$GLOBALS['temp']['groupingSepAsTabChecked'] = "checked";
}

$groupingCombArrSty = $_SERVER['argv'][35];
$GLOBALS['temp']['groupingCombArrStyChecked'] = "checked";
if($groupingCombArrSty == "2") {
	$GLOBALS['temp']['groupingCombArrStyChecked'] = "";
}

$groupingDupArrSty = $_SERVER['argv'][45];
$GLOBALS['temp']['groupingDupArrStyChecked'] = "";
if($groupingDupArrSty == "1") {
	$GLOBALS['temp']['groupingDupArrStyChecked'] = "checked";
}

$detailAsRow = $_SERVER['argv'][36];
$GLOBALS['temp']['detailAsRowChecked'] = "checked";
$GLOBALS['temp']['detailAsColChecked'] = "";
if($detailAsRow == "2") {
	$GLOBALS['temp']['detailAsRowChecked'] = "";
	$GLOBALS['temp']['detailAsColChecked'] = "checked";
}

$noteHeader = trim($_SERVER['argv'][39])==""?array(1,2,3,4,5):explode(":", $_SERVER['argv'][39]);
$GLOBALS['temp']['noteHeaderpropertyChecked'] = "";
$GLOBALS['temp']['noteHeaderIdChecked'] = "";
$GLOBALS['temp']['noteHeaderNameChecked'] = "";
$GLOBALS['temp']['noteHeaderArrChecked'] = "";
$GLOBALS['temp']['noteHeaderDepartChecked'] = "";

if(in_array(1, $noteHeader)) {
	$GLOBALS['temp']['noteHeaderpropertyChecked'] = "checked";
}
if(in_array(2, $noteHeader)) {
	$GLOBALS['temp']['noteHeaderIdChecked'] = "checked";
}
if(in_array(3, $noteHeader)) {
	$GLOBALS['temp']['noteHeaderNameChecked'] = "checked";
}
if(in_array(4, $noteHeader)) {
	$GLOBALS['temp']['noteHeaderArrChecked'] = "checked";
}
if(in_array(5, $noteHeader)) {
	$GLOBALS['temp']['noteHeaderDepartChecked'] = "checked";
}

$notePdfOrientation = $_SERVER['argv'][40];
$GLOBALS['temp']['pdfLandChecked'] = "selected";
$GLOBALS['temp']['pdfPotrChecked'] = "";
if($notePdfOrientation == 2) {
	$GLOBALS['temp']['pdfLandChecked'] = "";
	$GLOBALS['temp']['pdfPotrChecked'] = "selected";
}

$noteColArg = $_SERVER['argv'][41];

$noteColArray = array();
$noteColOrder = array();
$noteColSort = array();
$noteColHeader = false;
if(trim($noteColArg) != "") {
	$count = 0;
	foreach(explode(":",$noteColArg) as $item) {
		$noteCol = explode(",",$item);
		$colActive[$count] = $noteCol[0];
		$colOrder[$count] = $noteCol[1];
		
		$label = trim($noteCol[2]);
		if($label == "") {
			$label = isset($noteCols[$count]['label']) ? $noteCols[$count]['label'] : "q";
		}
		$align = trim($noteCol[3]);
		if($align == "") {
			$align = isset($noteCols[$count]['align']) ? $noteCols[$count]['align'] : "";
		}
		$noteColArray[$count] = array(
			"active"=>$noteCol[0],
			"order"=>$noteCol[1],
			"label"=>$label,
			"align"=>$align
		);
		$count++;
	}
}
asort($noteColOrder);

$noteColData = array();

foreach($noteCols as $noteColKey=>$noteColItem) {
	$label = $noteColItem['label'];
	$active = "";
	$order = "";
	$align = isset($noteColItem['align']) ? $noteColItem['align'] : "l";

	if(isset($noteColArray[$noteColKey]['active']) && $noteColArray[$noteColKey]['active'] == "1") {
		$label = $noteColArray[$noteColKey]['label'];
		$active = "1";
		$order = $noteColArray[$noteColKey]['order'];
		$align = $noteColArray[$noteColKey]['align'];
	}
	
	$noteColDataItem = array(
		'"id":"'.$noteColItem['id'].'"',
		'"name":"'.$noteColItem['label'].'"',
		'"active":"'.$active.'"',
		'"label":"'.$label.'"',
		'"order":"'.$order.'"',
		'"align":"'.$align.'"'		
	); 
	array_push($noteColData,'{'.join(",",$noteColDataItem)."}
");
}

$noteColData = '['.join(",",$noteColData).']';
$GLOBALS['temp']['noteColData'] = $noteColData;

if ( isset($renderMode) && $renderMode == "pdf" && isset($renderType) && $renderType == "email" ) {
	outputMail($form,$options,$fromDate['htmlDate'],$toDate['htmlDate']);
}

if(isset($renderMode) && $renderMode == "html") {
	$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");
	$GLOBALS['temp']['tomorrow'] = chng_date(date("Y-m-d",time() + (86400)),"-");
	$GLOBALS['temp']['showResults'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "";
}

if($_SERVER['argc'] > 1) {
	$days = dateSubtract($toDate['jsDate'],$fromDate['jsDate'])+1;
	$startDate = strtotime($fromDate['jsDate']);
	$dates = array();
	for($count=0; $count<$days; $count++) {
		$currentDate = date("Y-m-d",$startDate+(86400*$count));
		$pax = getPaxByDate($currentDate,$accommFilter['where']);
		$dates[$currentDate] = array_merge(array(
			'id'=>$currentDate,
			'name'=>chng_date($currentDate,"-")
		),$pax);
	}

	$accommList = $lDB->get("
		SELECT
			sc_accomm.ac_accomm_type_id
		FROM
			sc_accomm
		INNER JOIN sc_user ON 
			sc_accomm.sc_group_id = sc_user.sc_group_id
		AND 
			sc_user.pr_user_id = '" . $GLOBALS['userid'] . "'
	",3);
	$accommWhere = " IN ('".join("','",$accommList)."') ";
	
	$roomsRaw = $lDB->get("
		SELECT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc,
			ac_accomm_type.ac_accomm_label,
			ac_accomm_room.ac_accomm_room_ix,
			ac_accomm_room.ac_desc,
			pr_business.pr_business_sequence
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix $accommWhere
			$accommFilter[where]
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '$toDate[jsDate]'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '$fromDate[jsDate]'
				)
			)
		ORDER BY
			pr_business_sequence,
			$roomSortSQL
	",2); 
	$rooms = array();
	foreach($roomsRaw as $room) {
		$rooms[$room['ac_accomm_room_ix']] = array(
			'id'=>$room['ac_accomm_room_ix'],
			'ac_accomm_type_ix'=>$room['ac_accomm_type_ix'],
			'property'=>$room['pr_name_last'],
			'accommodation'=>$room['ac_accomm_desc'],
			'unit_label'=>$room['ac_accomm_label'],
			'room'=>$room['ac_desc'],
			'name'=>$room['pr_name_last']."
".$room['ac_accomm_desc']."
".$room['ac_desc']
		);
	}

	$accommRaw = $lDB->get("
		SELECT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc
		FROM
			ac_accomm_type
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix $accommWhere
			$accommFilter[where]
		ORDER BY
			pr_name_last
	",2);
	$accommTypes = array();
	foreach($accommRaw as $accomm) {
		$accommTypes[$accomm['ac_accomm_type_ix']] = array(
			'id'=>$accomm['ac_accomm_type_ix'],
			'property'=>$accomm['pr_name_last'],
			'accomodation'=>$accomm['ac_accomm_desc'],
			'name'=>$accomm['pr_name_last']."
".$accomm['ac_accomm_desc']
		);
	}

	$data = array(
		'chart'=>array(
			'rows'=>array(),
			'columns'=>array(),
			'room'=>array(),
			'depart'=>array(),
			'stayOver'=>array()
		),
		'notes'=>array(),
		'summary'=>array()
	);
	
	$chart =& $data['chart'];
	$notes =& $data['notes'];
	$summary =& $data['summary'];
	$chart['sep_asd'] = $groupingSepAsRow;
	$chart['combArrSty'] = $groupingCombArrSty;
	$chart['dupArrSty'] = $groupingDupArrSty;
	$chart['detailAs'] = $detailAsRow;

	$summary['sep_asd'] = $groupingSepAsRow;
	$summary['combArrSty'] = $groupingCombArrSty;
	$summary['dupArrSty'] = $groupingDupArrSty;
	$summary['detailAs'] = $detailAsRow;

	if($direction == "1") {
		$chart['rows'] = $dates;
		$chart['columns'] = $rooms;
		$chart['direction'] = 1;
		
		$summary['rows'] = $dates;
		$summary['columns'] = $accommTypes;
		$summary['direction'] = 1;
	} else {
		$chart['rows'] = $rooms;
		$chart['columns'] = $dates;
		$chart['direction'] = 2;
		
		$summary['rows'] = $accommTypes;
		$summary['columns'] = $dates;
		$summary['direction'] = 1;
	}
	
	foreach($rooms as $room) {
		foreach($dates as $date) {
			if($direction == "1") {
				$rowId = $date['id'];
				$colId = $room['id'];
			} else {
				$rowId = $room['id'];
				$colId = $date['id'];
			}
			if(!array_key_exists($rowId,$chart['room'])) {
				$chart['room'][$rowId] = array($colId=>array());
			}
			if(!array_key_exists($rowId,$chart['depart'])) {
				$chart['depart'][$rowId] = array($colId=>array());
			}
			
			$dayData = getRoomDayData($cols,$chartIds,$roomJoins,$room['id'],$date['id'],$statusFilter['where'],$extraFilterFinal['where'],$showExtra, $showCatExtras, $componentsFilter['where'], $chart['combArrSty'], $rateFilter['where']);
			//debug($dayData);
			$chart['room'][$rowId][$colId] = $dayData['room'];
			$chart['depart'][$rowId][$colId] = $dayData['depart'];
			$chart['block'][$rowId][$colId] = $dayData['block'];
			if($chart['combArrSty'] == '2') {
				if(!array_key_exists($rowId,$chart['stayOver'])) {
					$chart['stayOver'][$rowId] = array($colId=>array());
				}
				$chart['stayOver'][$rowId][$colId] = $dayData['stayOver'];
				
				if ($chart['dupArrSty'] == '1' && empty($dayData['stayOver'])){
					$chart['stayOver'][$rowId][$colId] = $dayData['room'];
				}
				
			}
		}
	}
	
	// [START] - Auto room data generation
	if($autoRoom == "1") {
		$unallocated = getUnallocated($cols,$chartIds,$itemJoins,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['where'],$statusFilter['where'], $showCatExtras, $componentsFilter['where'], $rateFilter['where']);
		roomUnallocated($cols,$chartIds,$chart,$unallocated,$extraFilterFinal['where'],$showExtra, $showCatExtras, $componentsFilter['where'], $rateFilter['where']);
	}
	// [END] - Auto room data generation

	// [START] - Summary data generation
	foreach($accommTypes as $accomm) {
		foreach($dates as $date) {
			if($direction == "1") {
				$rowId = $date['id'];
				$colId = $accomm['id'];
			} else {
				$rowId = $accomm['id'];
				$colId = $date['id'];
			}
			if(!array_key_exists($rowId,$summary)) {
				$summary[$rowId] = array();
			}
			if(!array_key_exists('totals',$summary['rows'][$rowId])) {
				$summary['rows'][$rowId]['totals'] = array(
					'occupancy'=>0,
					'in'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'arrive'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'stay'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'depart'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0)
				);
			}
			if(!array_key_exists('totals',$summary['columns'][$colId])) {
				$summary['columns'][$colId]['totals'] = array(
					'occupancy'=>0,
					'in'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'arrive'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'stay'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0),
					'depart'=>array('occupancy_total'=>0, 'pax_adult'=>0, 'pax_child'=>0, 'pax_total'=>0)
				);
			}
			$summaryRowTotal =& $summary['rows'][$rowId]['totals'];
			$summaryColTotal =& $summary['columns'][$colId]['totals'];

			$summaryCell = getSummaryData($accomm['id'],$date['id']);

			foreach($summaryCell as $summaryKey=>$summaryItem) {
				if($summaryKey == "occupancy") {
					$summaryRowTotal['occupancy'] += $summaryItem;
					$summaryColTotal['occupancy'] += $summaryItem;
				} else {
					foreach($summaryItem as $paxKey=>$paxItem) {
						$summaryRowTotal[$summaryKey][$paxKey] += $paxItem;
						$summaryColTotal[$summaryKey][$paxKey] += $paxItem;
					}
				}
			}
			$summary[$rowId][$colId] = $summaryCell;
		}
	}
	//debug($summary);
	// [END] - Summary data generation
	
	if($showNotes == "1") {
		if(hasSection($noteCols,"extras",$noteIds) || hasSection($noteCols,"extraNote",$noteIds) || hasSection($noteCols,"extraMemo",$noteIds) || hasSection($noteCols,"travel",$noteIds) || hasSection($noteCols,"travelNote",$noteIds) || hasSection($noteCols,"travelMemo",$noteIds)) {
			$accommIds = explode(":",$accommFilter['ids']);
			$propertyIds = array();
			foreach($accommIds as $item) {
				array_push($propertyIds,$lDB->get("SELECT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type_ix = '$item'",4));
			}
			$propertyIds = array_unique($propertyIds);
		} 

		$GLOBALS['noteReservations'] = array_filter(array_unique($GLOBALS['noteReservations']));
		foreach($GLOBALS['noteReservations'] as $resId) {
			$notes[$resId] = getNotes($noteCols,$noteIds,$resJoins,$resId,$noteDate,$accommFilter['where']);
			// Special sections
			if(hasSection($noteCols,"extras",$noteIds) || hasSection($noteCols,"extraNote",$noteIds) || hasSection($noteCols,"extraMemo",$noteIds)) {
				if(hasSection($noteCols,"extraOnly",$noteIds)) {
					$extraOnly = true;
				} else {
					$extraOnly = false;
				}
				$notes[$resId]['extras'] = getExtraNotes($resId,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['ids'],$extraFilterFinal['where'],$extraOnly,$showExtra,$propertyIds);
			}
			if(hasSection($noteCols,"travel",$noteIds) || hasSection($noteCols,"travelNote",$noteIds) || hasSection($noteCols,"travelMemo",$noteIds)) {
				if(hasSection($noteCols,"travelOnly",$noteIds)) {
					$travelOnly = true;
				} else {
					$travelOnly = false;
				}
				$notes[$resId]['travel'] = getTravelNotes($resId,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['ids'],$extraFilterFinal['where'],$travelOnly,$showExtra,$propertyIds);
			}
			if(hasSection($noteCols,"guestSpecific",$noteIds)) {
				$notes[$resId]['guests'] = getGuestDetails($resId,$fromDate['jsDate'],$toDate['jsDate'],$accommFilter['where']);
			}

			if(hasSection($noteCols,"itinerarySum",$noteIds)) {
				$notes[$resId]['itinerary'] = getItinerarySummary($resId, $accommFilter['where']);
			}
		}

		switch($noteSort) {
		case "1":
			usort($notes,"noteSortArrive");
			break;
		case "2":
			usort($notes,"noteSortDepart");
			break;
		case "3":
			usort($notes,"noteSortId");
			break;
		case "4":
			usort($notes,"noteSortName");
			break;
		case "5":
			usort($notes,"noteSortProperty");
			break;
		case "6":
			usort($notes,"noteSortVoucher");
			break;
		}
		//debug($notes);
	}
	// [Data generation section ends]
	if(isset($renderMode) && $renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";

		if (!$showDatesAllProps) {
			$propFilterIds = $lDB->get("
				SELECT
					DISTINCT pr_business_id
				FROM
					ac_accomm_type
				WHERE
					ac_accomm_type_ix IN ('" . join("','", explode(":",$accommFilter["ids"]))  . "')
			", 3);

			foreach ($data['notes'] as $key => $note) {
				foreach ($note['itinerary'] as $itinKey => $itinerary) {
					if (!in_array($itinerary['pr_business_id'], $propFilterIds)) {
						unset($data['notes'][$key]['itinerary'][$itinKey]);
					}
				}
			}
		}
		

		outputHTML($cols,$chartIds,$noteCols,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$autoRoom,$data,$showCatExtras, $noteHeader);
	}
	if ( isset($renderMode) && $renderMode == "pdf" && isset($renderType) && ($renderType == "view" || $renderType == "send") ) {
		outputPDF($renderType,$cols,$chartIds,$noteCols,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$data,$fromDate['htmlDate'],$toDate['htmlDate'],$accommFilter['names'], $showCatExtras, $noteHeader,$notePdfOrientation);
	}
	if ( isset($renderMode) && ($renderMode == "csv" || $renderMode == "oofice" || $renderMode == "csvFromXml") ) {
		$repName = str_replace(" ", "", "operations_chart_" .$fromDate['htmlDate'] . "_to_" . $toDate['htmlDate']);
		if ( $renderMode == "oofice" ) {
			$repName = $repName.".xml";
			$repType = "xml";
		} elseif ( $renderMode == "csvFromXml" ) {
			$repName = $repName.".csv";
			$repType = "csvFromXml";
		} else {
			$repName = $repName.".xlsx";
			$repType = "xls";
		}
		if($data['chart']['sep_asd'] == '3') {
			outputCSVAsTables($data,$cols,$chartIds,$noteCols,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$fromDate['htmlDate'],$toDate['htmlDate'],$accommFilter['names'], $noteHeader, $showCatExtras, $repName, $repType);
		} else {
			outputCSV($data,$cols,$chartIds,$noteCols,$noteIds,$noteSort,$showChart,$showNotes,$showAccomm,$showPAX,$showEmptyRooms,$showLegend,$showUnitLabel,$showUnitNumber,$hideAccommType,$showDatePAX,$fromDate['htmlDate'],$toDate['htmlDate'],$accommFilter['names'], $noteHeader, $showCatExtras, $repName, $repType);
		}
	}

} else {
	$GLOBALS['temp']['totalRows'] = 0;
}
