<?php
/*
 * $Id: init.form377.php,v 1.3 2011-05-17 14:08:33 light Exp $
 *
 * $Log: init.form377.php,v $
 * Revision 1.3  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.2  2010-03-04 21:39:56  light
 * Bug #7076 - Tripsheet Sorting Order
 *
 * Revision 1.1  2009-06-26 15:02:44  light
 * Bug #6630 - [DB] Guest relationship management
 *
 * 
 */

/**
 * init.form377.php - Add/Edit guest profile code table objects.
 * Job: 313, 314, 315, 316, 317, 318
 * Function: 112 (Code Tables: Guest Profile)
 */

$_SERVER['argv'][1] = (isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "");
$record = $_SERVER['argv'][1];
$options = (isset($_SERVER['argv'][2]) ? $_SERVER['argv'][2] : "");
$objectVal = (isset($_SERVER['argv'][3]) ? $_SERVER['argv'][3] : "");

if(isset($_POST['url']) && $_POST['url'] != "") {
	$linkurl = explode("#",$_POST['url']);
}

if(isset($linkurl[0]) && $linkurl[0] != "") {
	$_SERVER['argv'] = explode("+",substr($linkurl[0],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_guest_profile.htm");
	$GLOBALS['temp']['colData'] = "''";
}

switch ( $options & 7 ) {
case ADD_OBJECT:
	$renderMode = "guest";
	$renderType = "addObject";
	break;

case DEFINE_OBJECT:
	$renderMode = "guest";
	$renderType = "defineObject";
	$objHTML = Join("",file(__DIR__ . "/../../../public/html/code_guest_object_details.htm"));
	break;

case EDIT_OBJECT:
	$renderMode = "guest";
	$renderType = "editObject";
	$objHTML = Join("",file(__DIR__ . "/../../../public/html/code_guest_object_details.htm"));
	break;

default:
	$renderMode = "guest";
	$renderType = "addObject";
	$objHTML = Join("",file(__DIR__ . "/../../../public/html/code_guest_object_new.htm"));
	break;
}

if ($renderMode == "guest" && $renderType == "addObject") {
	$GLOBALS['temp']['objectCol'] = $objHTML;
}

$GLOBALS['temp']['objectCol'] = (isset($GLOBALS['temp']['objectCol']) ? $GLOBALS['temp']['objectCol'] : "");

if ($renderMode == "guest" && $renderType == "defineObject" || $renderType == "editObject") {
	$colData = array();
	$delClass = 0;
	$compChecked = '';
	$GLOBALS['temp']['colData'] = "''";
	if ($renderType == "defineObject") {
		$objVal = $_SERVER['argv'][3];
		$objLabel = '';
		$objId = '';
		if($objVal == DB_RF_OBJ_GUEST_RADIO || $objVal == DB_RF_OBJ_GUEST_CHECKBOX || $objVal == DB_RF_OBJ_GUEST_SELECTBOX) {
			for($i=0; $i<3; $i++) {
				$j = $i+1;
				$colDataItem = array(
					'"id":"'.$j.'"',
					'"data_id":""',
					'"content":""',
					'"status":"0"',
					'"active":"1"',
					'"delClass":"'.$delClass.'"',
					'"order":"'.$j.'"'
				); 
				array_push($colData,'{'.join(",",$colDataItem)."}\n");
			}
			$colData = '['.join(",",$colData).']';
			$GLOBALS['temp']['colData'] = $colData;
		}
	}
	if ($renderType == "editObject") {
		$objId = $_SERVER['argv'][1];
		if($objId != '') {
			$objDetails = db_rf_obj_guest_select($objId);
			$objVal = $objDetails['rf_obj_guest_type_ind'];
			$objLabel = $objDetails['rf_obj_guest_label'];
			
			if($objDetails['rf_obj_guest_mandatory_yn'] == '1') {
				$compChecked = 'checked = "checked"';
			}
			
			$cnt = count($objDetails['obj_data']);
			
			if(($objVal == DB_RF_OBJ_GUEST_RADIO || $objVal == DB_RF_OBJ_GUEST_CHECKBOX || $objVal == DB_RF_OBJ_GUEST_SELECTBOX) && $cnt>0) {
				for($i=0; $i<$cnt; $i++) {
					if($objDetails['obj_data'][$i]['rf_obj_guest_data_inactive_yn'] == 1) {
						$inactivechecked = 1;
						$delClass = 0;
					} else {
						$inactivechecked = 0;
						$delClass = 1;
					}
					$j = $i+1;
					$colDataItem = array(
						'"id":"'.$j.'"',
						'"data_id":"'.$objDetails['obj_data'][$i]['rf_obj_guest_data_ix'].'"',
						'"content":"'.t_encodeHTMLField($objDetails['obj_data'][$i]['rf_obj_guest_data_content']).'"',
						'"status":"'.$inactivechecked.'"',
						'"active":"1"',
						'"delClass":"'.$delClass.'"',
						'"order":"'.$objDetails['obj_data'][$i]['rf_obj_guest_data_sort_seq'].'"'
					); 
					array_push($colData,'{'.join(",",$colDataItem)."}\n");
				}
				$colData = '['.join(",",$colData).']';
				$GLOBALS['temp']['colData'] = $colData;
			}
		}
	}

	switch ( $objVal) {
	case DB_RF_OBJ_GUEST_TEXTBOX:
		$objType = "Text field";
		$compClass = '';
		$optionClass = 'style="display:none";';
		break;

	case DB_RF_OBJ_GUEST_TEXTAREA:
		$objType = "Text area";
		$compClass = 'style="display:none";';
		$optionClass = 'style="display:none";';
		break;

	case DB_RF_OBJ_GUEST_RADIO:
		$objType = "Radio button";
		$compClass = 'style="display:none";';
		$optionClass = '';
		break;
	
	case DB_RF_OBJ_GUEST_CHECKBOX:
		$objType = "Checkbox";
		$compClass = 'style="display:none";';
		$optionClass = '';
		break;
	
	case DB_RF_OBJ_GUEST_SELECTBOX:
		$objType = "Drop down";
		$compClass = '';
		$optionClass = '';
		break;
	case DB_RF_OBJ_GUEST_NUMERIC:
		$objType = "Numeric field";
		$compClass = '';
		$optionClass = 'style="display:none";';
		break;
	}
	
	$item['objId'] = $objId;
	$item['objType'] = $objType;
	$item['objLabel'] =  t_encodeHTMLField($objLabel);
	$item['objTypeVal'] = $objVal;
	$item['compChecked'] = $compChecked;
	$item['compClass'] = $compClass;
	$item['optionClass'] = $optionClass;
	$item['tripClass'] = "style='display:none;'";
	
	$GLOBALS['temp']['objectCol'] .= showpage($item, $objHTML);
}

$GLOBALS['passthrurecord'] = (isset($GLOBALS['passthrurecord']) ? $GLOBALS['passthrurecord'] : "");

$GLOBALS['autovar'] = "1";
if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = $GLOBALS['passthrurecord'];
		if ($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}

$GLOBALS['temp']['record'] = $record;
$GLOBALS[$form]->Get($action);

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

if ($action == "2" || isset($objDetails) && $objDetails['rf_obj_guest_inactive_yn'] == 0) {
	$GLOBALS['temp']['inactiveYn'] = " style=\"display:none\"";
	$GLOBALS['temp']['selInactive'] = '';
} else {
	if ($record == "" && $action == "1") {
		$GLOBALS['temp']['inactiveYn'] = " style=\"display:none\"";
		$GLOBALS['temp']['selInactive'] = '';
	} else {
		$GLOBALS['temp']['inactiveYn'] = "";
		$GLOBALS['temp']['selInactive'] = ' selected="selected"';
	}
}

$newr = 314;
$edit = $newr + 2;
$view = $newr - 1;
$dele = $newr + 4;
$sedit = $edit + 1;
$snewr = $newr + 1;

// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
// End Access Control Toolbar Setup
	
$GLOBALS['temp']['new_record'] = "reservation.php?".$newr;

switch ($action) {
case (0) : // List Records
	break;

case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+3";
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	break;

case (2) : // Add Record
	$GLOBALS[$form]->Arguments = (string) $snewr;
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['temp']['record'] = "";
	$GLOBALS['mode'] = "new";

	if($pmode == 1) {
		$rf_obj_guest_mandatory_yn = 0;
		if(isset($_POST['rf_obj_mandatory_yn']) && $_POST['rf_obj_mandatory_yn'] == '1'){
			$rf_obj_guest_mandatory_yn = 1;
		}
		
		$obj_guest_id = db_rf_obj_guest_insert($_POST['rf_obj_type_ind'], $_POST['rf_obj_label'], $rf_obj_guest_mandatory_yn);
		
		if($obj_guest_id && isset($_POST['att_label']) && count($_POST['att_label'])>0) {
			for($i=0; $i<count($_POST['att_label']); $i++) {
				if($_POST['att_label'][$i] !='') {
					$obj_guest_data_id = db_rf_obj_guest_data_insert($obj_guest_id, $_POST['att_label'][$i], $_POST['rf_obj_guest_data_sort_seq'][$i], 0,$_POST['att_status'][$i], $dbcode);
				}
			}
		}
	}
	break;

case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = (string) $sedit."+".$record;
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record."+3";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record;

	if($pmode == 1) {
		$rf_obj_guest_id = $_POST['rf_obj_ix'];
		$rf_obj_guest_mandatory_yn = 0;
		if(isset($_POST['rf_obj_mandatory_yn']) && $_POST['rf_obj_mandatory_yn'] == '1'){
			$rf_obj_guest_mandatory_yn = 1;
		}
		
		db_rf_obj_guest_update($rf_obj_guest_id, $_POST['rf_obj_label'], $rf_obj_guest_mandatory_yn);
		if(isset($_POST['rf_obj_guest_inactive_yn'])) {
			db_rf_obj_guest_set_inactive($rf_obj_guest_id, $_POST['rf_obj_guest_inactive_yn']);
		}
		
		$obj_guest_dataIds = $lDB->get("SELECT rf_obj_guest_data_ix FROM rf_obj_guest_data WHERE rf_obj_guest_id = '$rf_obj_guest_id'", 3);
		
		if(is_array($obj_guest_dataIds)) {
			foreach($obj_guest_dataIds as $obj_guest_dataId) {
				if(!in_array($obj_guest_dataId, $_POST['rf_obj_guest_data_id'])) {
					db_rf_obj_guest_data_delete($obj_guest_dataId);
				}
			}
		}

		$counter = (isset($_POST['rf_obj_guest_data_id']) ? count($_POST['rf_obj_guest_data_id']) : 0 );
		if($counter>0) {
			for($i=0; $i<$counter; $i++) {
				if($_POST['att_label'][$i] !='') {
					if($_POST['rf_obj_guest_data_id'][$i] != '') {
						db_rf_obj_guest_data_update($_POST['rf_obj_guest_data_id'][$i], $_POST['att_label'][$i], $_POST['rf_obj_guest_data_sort_seq'][$i], $_POST['att_status'][$i]);
					} else {
						$obj_guest_data_id = db_rf_obj_guest_data_insert($rf_obj_guest_id, $_POST['att_label'][$i], $_POST['rf_obj_guest_data_sort_seq'][$i], 0, $_POST['att_status'][$i], $dbcode);
					}
				}
			}
		}
	}
	break;

case (4) : // Delete Record
	if(db_pr_guest_obj_data_exists($record, "rf_obj_guest_id")) {
		db_rf_obj_guest_set_inactive($record, 1);
	} else {
		$res = db_rf_obj_guest_delete($record);
	}
	break;
}

if($options!="" && $objectVal != ""){
	$GLOBALS['temp']['new_record'] .= "++".$options."+".$objectVal;
}
