<?php
/*
 * $Id: init.form378.php,v 1.2 2011-05-17 14:08:33 light Exp $
 *
 * $Log: init.form378.php,v $
 * Revision 1.2  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.1  2009-06-26 15:02:44  light
 * Bug #6630 - [DB] Guest relationship management
 *
 *
*/

/**
 * init.form378.php - Listing of guest profile code table objects.
 * Job: 313, 314, 315, 316, 317, 318
 * Function: 112 (Code Tables: Guest Profile)
 */
require_once(__DIR__ . "/db.rf_obj_guest.php");
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_guest_profile_list.htm");
}

$selectjob = (isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "");
if (isset($_SERVER['argv'][4])) {
	$order = ($_SERVER['argv'][4] == "1" ? " desc" : " asc");
} else {
	$order = " asc";
}
$orderby = (isset($_SERVER['argv'][5]) ? $_SERVER['argv'][5] : 0);

// Counter for preventing duplicate entries
$counti = 0;

$GLOBALS['temp']['imgSort1'] = "";
$GLOBALS['temp']['imgSort2'] = "";
$GLOBALS['temp']['imgSort3'] = "";
$GLOBALS['temp']['imgSort4'] = "";
$GLOBALS['temp']['imgSort5'] = "";
$GLOBALS['temp']['imgSort6'] = "";

$GLOBALS['temp']['imgSort1Mode'] = "std"; #(name, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(name, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(abbrev, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(abbrev, desc)
$GLOBALS['temp']['imgSort5Mode'] = "std"; #(inactive, asc)
$GLOBALS['temp']['imgSort6Mode'] = "std"; #(inactive, desc)

switch ($orderby) {
case 1:
	$orderbyfield = "rf_obj_guest_label";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort3Mode'] = "down"; #(name, asc)
	}else {
		$GLOBALS['temp']['imgSort4Mode'] = "down"; #(name, desc)
	}
	break;

case 2:
	$orderbyfield = "rf_obj_guest_inactive_yn";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort6Mode'] = "down"; #(name, asc)
	}else {
		$GLOBALS['temp']['imgSort5Mode'] = "down"; #(name, desc)
	}
	break;

case 0:
default:
	$orderbyfield = "rf_obj_guest_sort_seq";
	break;
}

if (sizeof($GLOBALS[$form]->RecordList) < "1") {
	$RecordStart = "0";
	$where = " WHERE rf_obj_guest_sys_code=0";
	$tempcount = db_rf_obj_guest_select_by_condition($where, "rf_obj_guest_sort_seq", $order);
	
	$GLOBALS['temp']['numrows'] = sizeof($tempcount);
	$RecordCount = sizeof($tempcount);
	$Limit = $RecordCount;
	$RecordLimit = $RecordStart-- + $Limit++;

	$GLOBALS['temp']['selectjob'] = "";
	
	$sortclick = "0";
	if(checkjob("316") == true){
		$selectjob = "316";
		if($record == ""){
			$sortclick = "314";
		}
	}else {
		$selectjob = "313";
	}
	if ($sortclick == "0") {
		$sortclick = $selectjob;
	}

	$GLOBALS['temp']['selectjob'] = $selectjob;
	$GLOBALS['temp']['sortclick'] = $sortclick;
	$GLOBALS['temp']['rows'] = "";
	if ($RecordCount != "0") {
		$list = db_rf_obj_guest_select_by_condition($where, $orderbyfield, $order);
		$rowHtml = Join("",File(__DIR__ . "/../../../public/html/code_guest_profile_rows.htm"));

		foreach($list as $item) {
			if ($item['rf_obj_guest_ix'] != "" && $item['rf_obj_guest_label'] != "") {
				if($item['rf_obj_guest_ix'] != $record){
					if(canEditDB($item['rf_obj_guest_db'])) {
						$item['rf_obj_guest_label'] = "<span id='obj_guest".(string) $counti++."'>". $item['rf_obj_guest_label']. "</span>";
					} else {
						$item['rf_obj_guest_label'] = "<span class='txtg' id='obj_guest".(string) $counti++."'>" .$item['rf_obj_guest_label']."</span>";
					}
				}
				
				if ($item['rf_obj_guest_inactive_yn'] == '1') {
					$item['rf_obj_guest_inactive_yn'] = "x";
				} else {
					$item['rf_obj_guest_inactive_yn'] = "";
				}
				$item['selectjob'] = $selectjob;
				if(canEditDB($item['rf_obj_guest_db'])) {
					$item['rowClass'] = "linkrow";
					$item['itemClass'] = "";
					$item['canEdit'] = "";
				} else {
					$item['rowClass'] = "";
					$item['itemClass'] = "txtg";
					$item['canEdit'] = "return;";
				}

				$item['rf_obj_guest_type'] = db_rf_obj_guest_type_ind_desc($item['rf_obj_guest_type_ind']);
				$GLOBALS['temp']['rows'] .= showpage($item, $rowHtml);
			}
		}
	} else {
		$noDataRow = "
			<tr class='txt' height='20'>
				<td height='20' class='txt' colspan=3 align=center>&nbsp;&nbsp;
					There are no guest objects.</td>
			   </tr>";
		$GLOBALS['temp']['rows'] = $noDataRow;
	}
}

$GLOBALS['temp']['rowCount'] = (string) $counti;
$GLOBALS['temp']['orderButtonText'] = 'Set display order on Guest profile screen';
