<?php
/*
 * $Id: init.form382.php,v 1.2 2011-05-17 14:08:33 light Exp $
 *
 * $Log: init.form382.php,v $
 * Revision 1.2  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.1  2009-06-26 15:02:44  light
 * Bug #6630 - [DB] Guest relationship management
 *
 *
*/

/**
 * init.form382.php - Listing of guest tripsheet code table objects.
 * Job: 322, 323, 324, 325, 326, 327
 * Function: 113 (Code Tables: Guest Tripsheet)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_guest_tripsheet_list.htm");
}

$selectjob = (isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "");
$orderby = (isset($_SERVER['argv'][4]) ? $_SERVER['argv'][4] : 0);

if (isset($_SERVER['argv'][5])) {
	$order = ($_SERVER['argv'][5] == "1" ? " desc" : " asc");
} else {
	$order = " asc";
}

// Counter for preventing duplicate entries
$counti = 0;

$GLOBALS['temp']['imgSort1'] = "";
$GLOBALS['temp']['imgSort2'] = "";
$GLOBALS['temp']['imgSort3'] = "";
$GLOBALS['temp']['imgSort4'] = "";
$GLOBALS['temp']['imgSort5'] = "";
$GLOBALS['temp']['imgSort6'] = "";
$GLOBALS['temp']['imgSort7'] = "";
$GLOBALS['temp']['imgSort8'] = "";

$GLOBALS['temp']['imgSort1Mode'] = "std"; #(name, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(name, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(object type, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(object type, desc)
$GLOBALS['temp']['imgSort5Mode'] = "std"; #(property, asc)
$GLOBALS['temp']['imgSort6Mode'] = "std"; #(property, desc)
$GLOBALS['temp']['imgSort7Mode'] = "std"; #(inactive, asc)
$GLOBALS['temp']['imgSort8Mode'] = "std"; #(inactive, desc)


switch ($orderby) {
case 1:
	$orderbyfield = "rf_obj_trip_label";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort1Mode'] = "down"; #(name, asc)
	}else {
		$GLOBALS['temp']['imgSort2Mode'] = "down"; #(name, desc)
	}
	break;
case 2:
	$orderbyfield = "rf_obj_trip_type";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort3Mode'] = "down"; #(type, asc)
	}else {
		$GLOBALS['temp']['imgSort4Mode'] = "down"; #(type, desc)
	}
	break;

case 3:
	$orderbyfield = "rf_obj_trip_property";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort6Mode'] = "down"; #(property, asc)
	}else {
		$GLOBALS['temp']['imgSort5Mode'] = "down"; #(property, desc)
	}
	break;
case 4:
	$orderbyfield = "rf_obj_trip_inactive_yn";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort6Mode'] = "down"; #(inactive, asc)
	}else {
		$GLOBALS['temp']['imgSort5Mode'] = "down"; #(inactive, desc)
	}
	break;
case 0:
default:
	$orderbyfield = "rf_obj_trip_property, rf_obj_trip_sort_seq";
	break;
}

if (sizeof($GLOBALS[$form]->RecordList) < "1") {
	$listSQL = "
		SELECT 
			rf_obj_trip_label,
			rf_obj_trip_sort_seq,
			rf_obj_trip_inactive_yn,
			rf_obj_trip_ix,
			rf_obj_trip_db,
			rf_obj_trip_type_ind, 
			if(pr_persona.pr_name_last!='',pr_persona.pr_name_last,'Not property specific') as rf_obj_trip_property
		FROM 
			rf_obj_trip 
			INNER JOIN rf_obj_trip_prop ON rf_obj_trip_prop.rf_obj_trip_id = rf_obj_trip.rf_obj_trip_ix
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_obj_trip_prop.pr_business_id "
	;
	$RecordStart = "0";
	$tempcount = $lDB->get($listSQL);
	$GLOBALS['temp']['numrows'] = sizeof($tempcount);
	$RecordCount = sizeof($tempcount);
	$Limit = $RecordCount;
	$RecordLimit = $RecordStart-- + $Limit++;

	$GLOBALS['temp']['selectjob'] = "";
	
	$sortclick = "0";
	if(checkjob("325") == true){
		$selectjob = "325";
		if($record == ""){
			$sortclick = "323";
		}
	}else {
		$selectjob = "322";
	}
	if ($sortclick == "0") {
		$sortclick = $selectjob;
	}

	$GLOBALS['temp']['selectjob'] = $selectjob;
	$GLOBALS['temp']['sortclick'] = $sortclick;
	$GLOBALS['temp']['rows'] = "";
	
	$where = (isset($where) ? $where : '');

	if ($RecordCount != "0") {
		$list = $lDB->get($listSQL	. $where . "
			ORDER BY 
				" . $orderbyfield ." ". $order
		, 2);
		
		# Add this line to each code table
		$rowHtml = Join("",File(__DIR__ . "/../../../public/html/code_guest_tripsheet_rows.htm"));
		foreach($list as $item) {
			if ($item['rf_obj_trip_ix'] != "" && $item['rf_obj_trip_label'] != "") {
				if ($item['rf_obj_trip_inactive_yn'] != "0") {
					$item['rf_obj_trip_inactive_yn'] = "x";
				} else {
					$item['rf_obj_trip_inactive_yn'] = "";
				}
				if($item['rf_obj_trip_ix'] == $record){
					$item['rf_obj_trip_label'] = $item['rf_obj_trip_label'];
				} else {                              	
					if(canEditDB($item['rf_obj_trip_db'])) {
						$item['rf_obj_trip_label'] = "<span id='obj_trip".(string) $counti++."'>". $item['rf_obj_trip_label']. "</span>";
					} else {
						$item['rf_obj_trip_label'] = "<span class='txtg' id='obj_trip".(string) $counti++."'>" . $item['rf_obj_trip_label']."</span>";
					}
				}
				
				$obj_trip['selectjob'] = $selectjob;
				if(canEditDB($item['rf_obj_trip_db'])) {
					$item['rowClass'] = "linkrow";
					$item['itemClass'] = "";
					$item['canEdit'] = "";
				} else {
					$item['rowClass'] = "";
					$item['itemClass'] = "txtg";
					$item['canEdit'] = "return;";
				}

				switch($item['rf_obj_trip_type_ind']) {
				case DB_RF_OBJ_TRIP_TEXTBOX:
					$rf_obj_trip_type = "Textfield";
					break;
				case DB_RF_OBJ_TRIP_TEXTAREA:
					$rf_obj_trip_type = "Textarea";
					break;
				case DB_RF_OBJ_TRIP_RADIO:
					$rf_obj_trip_type = "Radio button";
					break;
				case DB_RF_OBJ_TRIP_CHECKBOX:
					$rf_obj_trip_type = "Checkbox";
					break;
				case DB_RF_OBJ_TRIP_SELECTBOX:
					$rf_obj_trip_type = "Drop down";
					break;
				case DB_RF_OBJ_TRIP_NUMERIC:
					$rf_obj_trip_type = "Numeric field";
					break;
				}

				$item['rf_obj_trip_type'] = $rf_obj_trip_type;
				
				$GLOBALS['temp']['rows'] .= showpage($item, $rowHtml);
			}
		}
	} else {
		$noDataRow = "
			<tr class='txt' height='20'>
				<td height='20' class='txt' colspan=4 align=center>&nbsp;&nbsp;
					There are no trip objects.</td>
			   </tr>";
		$GLOBALS['temp']['rows'] = $it;
	}
}

$GLOBALS['temp']['rowCount'] = (string) $counti;
$GLOBALS['temp']['orderButtonText'] = 'Set display order on Guest tripsheet screen';
