<?php

/**
 * init.form384.func.php - Add/Edit guest tripsheet form.
 * Job: 330, 331, 332, 333, 334, 335
 * Function: 110 (Code Tables: Guest Profile)
 */

require_once(__DIR__ . '/class.audit.php');
require_once(__DIR__ . '/db.ad_persona_detail.php');
require_once(__DIR__ . "/db.pr_guest.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rf_obj_trip_data.php");
require_once(__DIR__ . "/db.rf_obj_trip.php");
require_once(__DIR__ . "/db.rv_trip_obj_data.php");

function createTripField($obj, $pr_guest_id, $rv_reservation_id, $action=1) {
	global $lDB;
	global $hasTripData;

	$tabindex = $obj['rf_obj_trip_sort_seq'];
	$compulsory = ($obj['rf_obj_trip_mandatory_yn'] == '1') ? " <b><span style='color: red;'>*</span></b>" : "";
		
	if($obj['rf_obj_trip_type_ind'] == '') {
		$obj['rf_obj_trip_type_ind'] = DB_RF_OBJ_TRIP_TEXTBOX;
	}
	$objHTML = '';
	$val = '';		
	
	$data_field = 'rv_trip_obj_data';
	if($obj['rf_obj_trip_type_ind'] == DB_RF_OBJ_TRIP_RADIO || $obj['rf_obj_trip_type_ind'] == DB_RF_OBJ_TRIP_CHECKBOX || $obj['rf_obj_trip_type_ind'] == DB_RF_OBJ_TRIP_SELECTBOX) {
		$data_field = 'rf_obj_trip_data_id';	
	}
	$tmp = "2";
	if($obj['rf_obj_trip_type_ind'] == DB_RF_OBJ_TRIP_CHECKBOX) {
		$tmp = "3";
	}

	$val = $lDB->get("
		SELECT 
			$data_field 
		FROM 
			rv_trip_obj_data 
		WHERE 
			pr_guest_id = '$pr_guest_id' 
			AND rf_obj_trip_id = '$obj[rf_obj_trip_ix]'
			AND rv_reservation_id = '$rv_reservation_id'
			AND pr_business_id = '$obj[pr_business_id]'
	", $tmp);
	if($obj['rf_obj_trip_type_ind'] != DB_RF_OBJ_TRIP_CHECKBOX) {
		$val = isset($val[0][$data_field]) ? $val[0][$data_field] : "";
	}

	// When any trip data is found at all, we set this variable.
	if (!empty($val)){
		$hasTripData = true;	
	}

	if($obj['rf_obj_trip_inactive_yn'] == 1) {
		$class = "txtg";
	} else {
		$class = "txt";
	}
	
	$inactiveYn = isset($inactiveYn) ? $inactiveYn : "";

	switch($obj['rf_obj_trip_type_ind']) {
	case DB_RF_OBJ_TRIP_TEXTBOX:
		$objHTML .= "
			<input type='text' tabindex='".$tabindex."' class='$class' maxlength='50' style='width: 170px;' name='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' id='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' value='$val' />
		";
		break;
		
	case DB_RF_OBJ_TRIP_TEXTAREA:
		$objHTML .= "
			<textarea name='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' id='rf_obj_trip_". $obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' style='width: 170px;' class='$class' tabindex='".$tabindex."' >". $val ."</textarea>
		";
		break;

	case DB_RF_OBJ_TRIP_RADIO:
		$obj_data = db_rf_obj_trip_data_select($obj['rf_obj_trip_ix'], 'rf_obj_trip_data_sort_seq');
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rf_obj_trip_data_inactive_yn'] != 0 && $val!=$data['rf_obj_trip_data_ix']) {
					continue;
				}
				
				if($data['rf_obj_trip_data_inactive_yn'] == 1 || $obj['rf_obj_trip_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "
					<input type='radio' class=\"uk-radio\" value='".$data['rf_obj_trip_data_ix']."' name='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."'
				";
				
				if($val == $data['rf_obj_trip_data_ix']) {
					$objHTML .= " checked='checked'";
				}
				$objHTML .= " tabindex='".$tabindex."'><span class='$inactClass'>". $data['rf_obj_trip_data_content']."</span><br>";
			}
		}
		break;

	case DB_RF_OBJ_TRIP_CHECKBOX:
		$obj_data = db_rf_obj_trip_data_select($obj['rf_obj_trip_ix'], 'rf_obj_trip_data_sort_seq');
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rf_obj_trip_data_inactive_yn'] != 0 && !in_array($data['rf_obj_trip_data_ix'], $val)) {
					continue;
				}
				
				if($data['rf_obj_trip_data_inactive_yn'] == 1 || $obj['rf_obj_trip_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "
					<input type='checkbox' class=\"uk-checkbox uk-margin-small-right\" value='".$data['rf_obj_trip_data_ix']."' name='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."[]'
				";
				if(is_array($val) && !empty($val) && in_array($data['rf_obj_trip_data_ix'], $val)) {
					$objHTML .= " checked='checked'";
				}
				$objHTML .= " tabindex='".$tabindex."'><span class='$inactClass'>". $data['rf_obj_trip_data_content'] ."<span><br>";
			}
		}
		break;
		
	case DB_RF_OBJ_TRIP_SELECTBOX:
		$obj_data = db_rf_obj_trip_data_select($obj['rf_obj_trip_ix'], 'rf_obj_trip_data_sort_seq');
		$objHTML .= $inactiveYn."
			<select name='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' style='width: 170px;' tabindex='".$tabindex."'>
				<option value=''>&nbsp;</option>	
		";
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rf_obj_trip_data_inactive_yn'] != 0 && $val != $data['rf_obj_trip_data_ix']) {
					continue;
				}
				
				if($data['rf_obj_trip_data_inactive_yn'] == 1 || $obj['rf_obj_trip_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "<option value='".$data['rf_obj_trip_data_ix']."'";
				if($val == $data['rf_obj_trip_data_ix']) {
					$objHTML .= " selected='selected'";
				}
				$objHTML .= " class='$inactClass'>". $data['rf_obj_trip_data_content']."</option>";
			}
		}
		$objHTML .= "</select>";
		break;
		
	case DB_RF_OBJ_TRIP_NUMERIC:
		$objHTML .=$inactiveYn. "
			<input type='text' tabindex='".$tabindex."' class='$class' maxlength='50' style='width: 170px;' value='$val' name='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' id='rf_obj_trip_".$obj['rf_obj_trip_ix']."_".$obj['pr_business_id']."' onkeypress='ensureNumeric()' />
		";
		break;
							
	}
	
	if(empty($val) && $obj['rf_obj_trip_inactive_yn'] !=0) {
		$rowHTML = "";	
	} else {

		$style = "";
		if($obj['rf_obj_trip_inactive_yn'] == 1) {
			$style = "txtg'";
		}
		$rowHTML = "<tr $style>
					<td class='$style' valign='top'>" .$obj['rf_obj_trip_label'] .":{$compulsory}</td>
					<td><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
					<td valign='top' align='left'>". $objHTML ."</td>
					<td><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
				</tr>
			"; 
	}
	return $rowHTML;
}
