<?php

/**
 * init.form384.php - Add/Edit guest tripsheet form.
 * Job: 330, 331, 332, 333, 334, 335
 * Function: 110 (Code Tables: Guest Profile)
 */

//$GLOBALS['bypassAddCheck'] = true;
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/guest_tripsheet_popup.htm");
	$fields = array (
		"pr_guest_id",
		"pr_guest_gender",
		"rf_guest_type_ix",
		"rf_country_id",
		"pr_guest_birthdate",
		"pr_guest_anniversary",
		"pr_guest_note",
		"pr_guest_memo",
		"pr_guest_primary_yn",
		"pr_guest_inactive_yn"
	);

	$field2 = array ( "pr_identity_no" );
	$GLOBALS[$form]->AddTable($lDB,"pr_persona",$field2,"pr_persona_ix = '$record'","","", (isset($ident) ? $ident : "") );
	$ident = "";
	$GLOBALS[$form]->AddTable($lDB,"pr_guest",$fields,"pr_guest_id = '$record'","","",$ident);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$record = $pr_guest_id = $_SERVER['argv'][2];
$rv_reservation_id = $_SERVER['argv'][3];
$tripId = $_SERVER['argv'][1];

$GLOBALS['temp']['lblCompulsoryMessage'] = '';
if(isset($_SERVER['argv'][4]) && $_SERVER['argv'][4] == '88') {
    $GLOBALS['temp']['lblCompulsoryMessage'] = 'Please fill in all compulsory fields.';
}

if($tripId == 0) {
	$mode = "new";
} else {
	$mode = "edit";
}

$field_count = $lDB->get("
	SELECT
		COUNT(rv_trip_obj_data_ix)
	FROM
		rv_trip_obj_data
	WHERE
		rv_reservation_id = '".$rv_reservation_id."'
		AND pr_guest_id = '".$pr_guest_id."'
", 4);

if ($field_count > 0 && $_SERVER['argv'][0] == "331") {
	$_SERVER['argv'][0] = "333";
	redirectTo(" reservation.php?".join("+", $_SERVER['argv']));
	die();
}

if ($lDB->isMaster == "1"){
	$GLOBALS['temp']['importDisabled'] = "";
} else {
	$GLOBALS['temp']['importDisabled'] = "hidden";
}

$reservation_details = $lDB->get("
	SELECT
		rv_reservation_item.rv_reservation_item_ix,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		property.pr_name_last,
		pr_business.pr_bus_name_short,
		property.pr_persona_ix as propertyId,
		accomm.ac_accomm_name_short,
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation_item.rv_reservation_item_ix,
		rf_reservation_status.rf_reservation_status_desc,
		agent.pr_name_last as guestName,
		ac_accomm_room.ac_desc
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
		INNER JOIN pr_persona AS property ON property.pr_persona_ix = rv_reservation_item.pr_business_id
		INNER JOIN ac_accomm_type AS accomm ON accomm.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN rv_res_item_guest ON (rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix)
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN pr_persona AS agent ON agent.pr_persona_ix = rv_res_item_guest.pr_guest_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
", 2);

$rowHTML = Join("", file(__DIR__ . "/../../../public/html/guest_tripsheet_res_rows.htm"));
$res_rows = '';

foreach ($reservation_details as $item) {
	$contactName = $item['rv_reservation_ix'].' '.$item['rv_res_name'].' Guest trip sheet:'.$item['guestName'];
	$item['rv_item_date_arrive'] = chng_date($item['rv_item_date_arrive'],"-");
	$item['rv_item_date_depart'] = chng_date($item['rv_item_date_depart'],"-");
	$item['pr_bus_name_short'] = substr($item['pr_bus_name_short'],0,7);
	$item['rf_reservation_status_desc'] = substr($item['rf_reservation_status_desc'],0,4);

	$res_rows .= showpage($item, $rowHTML);
}

$GLOBALS['temp']['contactName'] = $contactName;
$GLOBALS['temp']['reservation_id'] = $rv_reservation_id;
$GLOBALS['temp']['record'] = $record;
$GLOBALS['temp']['res_rows'] = $res_rows;
$trip_obj_details = $lDB->get("
	SELECT
		rf_obj_trip_ix, rf_obj_trip_label, rf_obj_trip_sort_seq,
		rf_obj_trip_type_ind, rf_obj_trip_mandatory_yn, rf_obj_trip_inactive_yn,
		rf_obj_trip_prop.pr_business_id,
		pr_persona.pr_name_last
	FROM
		rf_obj_trip
		INNER JOIN rf_obj_trip_prop ON rf_obj_trip.rf_obj_trip_ix = rf_obj_trip_prop.rf_obj_trip_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_obj_trip_prop.pr_business_id
	ORDER BY
		rf_obj_trip_prop.pr_business_id, rf_obj_trip.rf_obj_trip_sort_seq
", 2);

$tripArr = array();
foreach($trip_obj_details as $trip) {
	if($trip['pr_business_id'] == '0') {
		$trip['pr_name_last'] = "Not property specific";
	}
	if(!isset($tripArr[$trip['pr_business_id']]) || !is_array($tripArr[$trip['pr_business_id']])) {
		$tripArr[$trip['pr_business_id']] = array();
	}
	$tripArr[$trip['pr_business_id']][] = $trip;
}

$trip_row = "";
$hasTripData = false;
$hasMandatoryFields = false;
global $hasTripData;

foreach($tripArr as $propId => $trip_obj) {
	if($propId == '0'){
		$propName = "General (Not property specific)";
	} else {
		$propName = $trip_obj[0]['pr_name_last'];
	}
	$trip_row .= "
		<tr class=\"mdarkbar\">
			<td colspan='4'>".$propName."</td>
		</tr>
	";

	foreach($trip_obj as $trpObj) {
		if($action == 2 && isset($obj['rf_obj_trip_inactive_yn']) && $obj['rf_obj_trip_inactive_yn'] != 0) {
			continue;
		} else {
			$trip_row .= createTripField($trpObj, $pr_guest_id, $rv_reservation_id, $action);
            if ($trpObj['rf_obj_trip_mandatory_yn'] != '0') {
                $hasMandatoryFields = true;
            }
		}
	}
    
    if ($hasMandatoryFields) {
        $trip_row .= "<tr>
    					<td class='' valign='top'><span style='color: red;'>* compulsory fields</span> </td>
    					<td><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
    				</tr>";
    }
}

if ($hasTripData){
	$GLOBALS['temp']['hasTripData'] = "1";
}

$GLOBALS['temp']['trip_row'] = $trip_row;

$service_details = $lDB->get("
	SELECT DISTINCT
		rv_extra.rv_extra_ix as id,
		rv_extra.rv_extra_date_serv,
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last,
		pr_business.pr_bus_name_short,
		ac_extra.ac_extra_ix as ac_extra_ix,
		ac_extra.ac_ext_desc,
		ac_extra_category.ac_extra_cat_desc,
		ac_accomm_room.ac_desc
	FROM
		rv_extra
		INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
		LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
	WHERE
		rv_extra.rv_extra_void_ind = 0
		AND rv_extra.rv_reservation_id = '$rv_reservation_id'
	ORDER BY
		rv_extra_date_serv, ac_extra_cat_desc, ac_ext_desc
", 2);

$srv_rows = '';
foreach($service_details as $srv) {
	$srv_rows .= "
		<tr valign='top'>
			<td class='br'>".$srv['pr_bus_name_short']."&nbsp;</td>
			<td class='br'>".$srv['ac_desc']."&nbsp;</td>
			<td class='br'>".$srv['ac_extra_cat_desc']."&nbsp;</td>
			<td>".$srv['ac_ext_desc']."&nbsp;</td>
		</tr>
	";
}

$GLOBALS['temp']['srv_rows'] = $srv_rows;

$newr = 331;
$edit = 333;
$view = 330;
$dele = 335;
$sedit = 334;
$snewr = 332;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
$pgJOBS['saveclose'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}
if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDeleterole\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"".$pgJOBS['saveclose']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"1\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobPrint\" value=\"1\">\n";

$GLOBALS['temp']['closeonload'] = 1;

if($_SERVER['argv'][0] == 330) {
	$GLOBALS['temp']['showSaveButton'] = "style=\"display:none\"";
} else {
	$GLOBALS['temp']['showSaveButton'] = "";
}

switch ($action) {
case (0) : // List Records
	break;

case (1) : // Display Record

	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record;
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";

	break;

case (2) : // Add Record

	$GLOBALS[$form]->Arguments = $snewr."+".$record."+".$pr_guest_id."+".$rv_reservation_id;
	$GLOBALS['mode'] = "new";
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "javascript:document.forms.".$form.".submit();opener.setUserCheck()";
	$GLOBALS['temp']['del_record'] = "#";

	if ($pmode == "1") {
		$audit = new AuditTrail($pr_guest_id,TYPE_PERSONA, ['rv_reservation_id'=>$rv_reservation_id]);
		foreach($tripArr as $propId => $trip_obj) {
			foreach($trip_obj as $trpObj) {
				if(array_key_exists('rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId, $_POST)) {
					if(is_array($_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId])) {
						foreach($_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId] as $chk) {
							if($chk != "") {
								$rv_trip_obj_data_id = db_rv_trip_obj_data_insert($trpObj['rf_obj_trip_ix'], $pr_guest_id, $rv_reservation_id, $propId, $chk, $trpObj['rf_obj_trip_type_ind']);
								$all = db_rv_trip_obj_data_get_all($rv_trip_obj_data_id);

								$audit->addDetail("", $all['id'], "", $rv_trip_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "tripsheet", "rv_trip_obj_data.", $trpObj['rf_obj_trip_ix'], "", $all['value']);
							}
						}
					} else {
						if($_POST['rf_obj_trip_'.$trpObj['rf_obj_trip_ix'].'_'.$propId] != "") {

							$newAll = db_rf_obj_trip_get_all($trpObj['rf_obj_trip_ix'], $_POST['rf_obj_trip_'.$trpObj['rf_obj_trip_ix'].'_'.$propId]);
							$rv_trip_obj_data_id = db_rv_trip_obj_data_insert($trpObj['rf_obj_trip_ix'], $pr_guest_id, $rv_reservation_id, $propId,  $_POST['rf_obj_trip_'.$trpObj['rf_obj_trip_ix'].'_'.$propId],  $trpObj['rf_obj_trip_type_ind']);
							$audit->addDetail("", $newAll['id'], "", $rv_trip_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "tripsheet", "rv_trip_obj_data.", $trpObj['rf_obj_trip_ix'], "", $newAll['value']);
						}
					}
				}
			}
		}
		$audit->save("Tripsheet details (Add)");
		echo "<script language='javascript'>window.close();</script>";
	} else {
		if ($record == "") {
			if ($GLOBALS['gotInactive'] == "1") {
				echo "<body onload=\"opener.inactiveUser();window.close();\"></body>";
			}else{
				echo "<body onload=\"opener.clearUser();window.close();\"></body>";
			}
			die();
		}
	}
	break;

case (3) : // Edit Record

	$GLOBALS[$form]->Arguments = $sedit."+".$record."+".$pr_guest_id."+".$rv_reservation_id;
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record;
	$GLOBALS['temp']['save_record'] = "javascript:document.forms.".$form.".submit();opener.setUserCheck()";
	$GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record;

	if($pmode == 1) {
	    // Validate Trip sheet property
	    foreach($tripArr as $propId => $trip_obj) {
            foreach ($trip_obj as $trpObj) {
                if(isset($_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId])) {
                    if ($trpObj['rf_obj_trip_type_ind'] == DB_RF_OBJ_TRIP_CHECKBOX) {
                        if (isset($trpObj['rf_obj_trip_mandatory_yn']) && $trpObj['rf_obj_trip_mandatory_yn'] == '1') {
                            if (!is_array($_POST['rf_obj_trip_' . $trpObj['rf_obj_trip_ix'] . '_' . $propId])) {
                                redirectTo('/reservation.php?333+0+'.$pr_guest_id.'+'.$rv_reservation_id.'+88');
                                exit;
                            }
                            if (is_array($_POST['rf_obj_trip_' . $trpObj['rf_obj_trip_ix'] . '_' . $propId]) && count($_POST['rf_obj_trip_' . $trpObj['rf_obj_trip_ix'] . '_' . $propId]) == 0) {
                                redirectTo('/reservation.php?333+0+'.$pr_guest_id.'+'.$rv_reservation_id.'+88');
                                exit;
                            }
                        }
                    } else {
                        if (isset($trpObj['rf_obj_trip_mandatory_yn']) && $trpObj['rf_obj_trip_mandatory_yn'] == '1') {
                            if ($_POST['rf_obj_trip_' . $trpObj['rf_obj_trip_ix'] . '_' . $propId] == "") {
                                redirectTo('/reservation.php?333+0+'.$pr_guest_id.'+'.$rv_reservation_id.'+88');
                                die();
                            }
                        }
                    }
                }
            }
        }


		$audit = new AuditTrail($pr_guest_id,TYPE_PERSONA, ['rv_reservation_id'=>$rv_reservation_id]);
		foreach($tripArr as $propId => $trip_obj) {
			foreach($trip_obj as $trpObj) {

				if ($trpObj['rf_obj_trip_type_ind'] == DB_RF_OBJ_TRIP_CHECKBOX) {
					if(!isset($_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId])) {
						$_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId] = array();
					}
					$rv_trip_obj_data_ids = $lDB->get("
						SELECT
							rv_trip_obj_data_ix,
							rf_obj_trip_data_id
						FROM
							rv_trip_obj_data
						WHERE
							rf_obj_trip_id = '".$trpObj['rf_obj_trip_ix']."'
							AND pr_business_id = '".$propId."'
							AND rv_reservation_id = '".$rv_reservation_id."'
							AND pr_guest_id = '".$pr_guest_id."'
					", 6);
					$rf_obj_trip_data_ids = [];

					if(is_array($rv_trip_obj_data_ids) && !empty($rv_trip_obj_data_ids)) {
						foreach ($rv_trip_obj_data_ids as $rv_trip_obj_data) {
							$rv_trip_obj_data_id = $rv_trip_obj_data['rv_trip_obj_data_ix'];
							$rf_obj_trip_data_ids[] = $rf_obj_trip_data_id = $rv_trip_obj_data['rf_obj_trip_data_id'];
							if(!in_array($rf_obj_trip_data_id, $_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId])) {
								$all = db_rv_trip_obj_data_get_all($rv_trip_obj_data_id);
								$audit->addDetail($all['id'], "", $rv_trip_obj_data_id, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "tripsheet", "rv_trip_obj_data.", $trpObj['rf_obj_trip_ix'], $all['value'], "");
								db_rv_trip_obj_data_delete($rv_trip_obj_data_id);
							}
						}
					}

					foreach($_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId] as $chk) {
						if(!in_array($chk, $rf_obj_trip_data_ids) && $chk != "") {
							$rv_trip_obj_data_id = db_rv_trip_obj_data_insert($trpObj['rf_obj_trip_ix'], $pr_guest_id, $rv_reservation_id, $propId, $chk, $trpObj['rf_obj_trip_type_ind']);
							$all = db_rv_trip_obj_data_get_all($rv_trip_obj_data_id);

							$audit->addDetail("", $all['id'], "", $rv_trip_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "tripsheet", "rv_trip_obj_data.", $trpObj['rf_obj_trip_ix'], "", $all['value']);
						}
					}

				} else {
					if(isset($_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId])) {
						$newAll = db_rf_obj_trip_get_all($trpObj['rf_obj_trip_ix'], $_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId]);
						$rv_trip_obj_data_id = db_rv_trip_obj_data_select_by_id($trpObj['rf_obj_trip_ix'], $rv_reservation_id, $pr_guest_id, $propId);
						if($rv_trip_obj_data_id != '0') {
							$oldAll = db_rv_trip_obj_data_get_all($rv_trip_obj_data_id);
							$action = DB_AD_PERSONA_DETAIL_ACTION_EDIT;
						} else {
							$oldAll = ['id'=>"", 'value'=>""];
							$action = DB_AD_PERSONA_DETAIL_ACTION_ADD;
						}
						$rv_trip_obj_data_id = db_rv_trip_obj_data_insert($trpObj['rf_obj_trip_ix'], $pr_guest_id,  $rv_reservation_id, $propId, $_POST['rf_obj_trip_'. $trpObj['rf_obj_trip_ix'].'_'.$propId],  $trpObj['rf_obj_trip_type_ind']);
						$audit->addDetail($oldAll['id'], $newAll['id'], $rv_trip_obj_data_id, $rv_trip_obj_data_id, $action, "tripsheet", "rv_trip_obj_data.", $trpObj['rf_obj_trip_ix'], $oldAll['value'], $newAll['value']);
					}
				}
			}
		}
		echo "<script language='javascript'>window.close();</script>";
		$audit->save("Tripsheet details (Edit)");
	}
    break;

case (4) : // Delete Record
    echo "<body onload=\"opener.clearGuest();window.close();\"></body>";
    break;
}

$lDB->insert_override = $record;


