<?php

require_once(__DIR__ . "/functions.report.php");
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');   
require_once(__DIR__ . '/functions.profile.php');   

require_once "class.xls.php";
require_once(__DIR__ . '/init.form385.func.profile.php');

$fieldSort = array();
global $fieldSort;

function getTelephone($pr_persona_id = false) {
	global $lDB;
	if(empty($pr_persona_id)) return false;
	$defaultPhone = $lDB->get("
		SELECT 
			pr_phone_number
		FROM 
			pr_phone
		WHERE 
			pr_persona_id  = '$pr_persona_id' AND pr_default_yn = '1'
	", 4);
	
	if(!empty($defaultPhone)) return $defaultPhone;
	$linkId = $lDB->get("
		SELECT
			pr_persona_link_id
		FROM 
			pr_persona
		WHERE 
			pr_persona_ix  = '$pr_persona_id'
	", 4);

	if(empty($linkId)) return false;

	return $linkedPhone = $lDB->get("
		SELECT 
			pr_phone_number
		FROM 
			pr_phone
		WHERE 
			pr_persona_id  = '$linkId' AND pr_default_yn = '1'
	", 4);
}

function getCountry($rf_country_id = false) {
	if(empty($rf_country_id)) return false;
	return $country = $GLOBALS['lDB']->get("
		SELECT 
			rf_country_name
		FROM 
			rf_country
		WHERE 
			rf_country_ix  = '$rf_country_id'
	", 4);
}

function getRelatedFirstname($pr_persona_id = false) {
	if(empty($pr_persona_id)) return false;
	$relatedFirstname = $GLOBALS['lDB']->get("
		SELECT 
			pr_persona.pr_name_first
		FROM 
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE 
			pr_link.pr_link_from = '$pr_persona_id' AND pr_link.rf_link_type_id = 'RS3'
	", 4);

	if ($relatedFirstname == "0"){
		return "";
	} else {
		return $relatedFirstname;
	}
	
}

function getRelatedLastname($pr_persona_id = false) {
	if(empty($pr_persona_id)) return false;
	$relatedLastname = $GLOBALS['lDB']->get("
		SELECT 
			pr_name_last
		FROM 
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE 
			pr_link.pr_link_from = '$pr_persona_id' AND pr_link.rf_link_type_id = 'RS3'
	", 4);

	if ($relatedLastname == "0"){
		return "";
	} else {
		return $relatedLastname;
	}
	
}

function getRelatedEmail($pr_persona_id = false) {
	if(empty($pr_persona_id)) return false;
	$relatedEmail = $GLOBALS['lDB']->get("
		SELECT 
			pr_email
		FROM 
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE 
			pr_link.pr_link_from = '$pr_persona_id' AND pr_link.rf_link_type_id = 'RS3'
	", 4);

	if ($relatedEmail == "0"){
		return "";
	} else {
		return $relatedEmail;
	}
	
}

function getConsultantName($pr_name_first,$pr_name_last,$consultant_id) {
	$name = trim($pr_name_first . " " . $pr_name_last);

	if($name != "") {
		$activeConsultant = $GLOBALS['lDB']->get("
		SELECT
			sc_group.sc_grp_consultant_yn,
			pr_persona.pr_persona_inactive_yn
		FROM
			sc_group
			INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
			INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
		WHERE
			pr_persona.pr_persona_ix = '".$consultant_id."'
		", 1);

		$name = $activeConsultant['sc_grp_consultant_yn'] == 1 ? $name : "";
		if ($name != "" && $activeConsultant['pr_persona_inactive_yn'] == 1) {
			$name = "* ".$name;
		}
	}

	return $name;
}

function getBedNights($nights, $rooms, $adults, $children) {
	return $nights * $rooms * ($adults + $children);
}

function orderCompare($a, $b, $columnName) {
    if ($a['order'] == $b['order']) {
        return 0;
   	}
    return ($a['order'] < $b['order']) ? -1 : 1;
}

function compareSort($a,$b) {
	if($a['sort'] == $b['sort']) {
		return 0;
	}

	return ($a['sort'] < $b['sort']) ? -1 : 1;
}

function compareData($a,$b) {
	global $fieldSort;
	foreach($fieldSort as $field=>$sort) {
		if (isset($a[$field]) || isset($a['travel_history'][0][$field])) {
			$fieldA = isset($a[$field]) ? $a[$field] : $a['travel_history'][0][$field];
		} else {
			$fieldA = "";
		}
		if (isset($b[$field]) || isset($b['travel_history'][0][$field])) {
			$fieldB = isset($b[$field]) ? $b[$field] : $b['travel_history'][0][$field];
		} else {
			$fieldB = "";
		}
		if(array_key_exists($field . '_sort',$a)) {
			$fieldA = $a[$field . '_sort'];
		}
		if(array_key_exists($field . '_sort',$b)) {
			$fieldB = $b[$field . '_sort'];
		}
		switch($sort['sortType']) {
		case "ix":
			$ixSplitA = preg_split('/(?<!\d)(?=\d+)/', $fieldA);
			$dbCodeA = isset($ixSplitA[0]) ? $ixSplitA[0] : "";
			$idA = isset($ixSplitA[1]) ? $ixSplitA[1] : "";
			$ixSplitB = preg_split('/(?<!\d)(?=\d+)/', $fieldB);
			$dbCodeB = isset($ixSplitB[0]) ? $ixSplitB[0] : "";
			$idB = isset($ixSplitB[1]) ? $ixSplitB[1] : "";
			if($dbCodeA == $dbCodeB) {
				if(
					($sort['direction'] == "a" && ($idA < $idB))
					|| ($sort['direction'] == "d" && ($idA > $idB))
				) {
					return -1;
				}
				if(
					($sort['direction'] == "a" && ($idA > $idB))
					|| ($sort['direction'] == "d" && ($idA < $idB))
				) {
					return 1;
				}
			}
		default:
			if(
				($sort['direction'] == "a" && $fieldA < $fieldB)
				|| ($sort['direction'] == "d" && $fieldA > $fieldB)
			) {
				return -1;
			}
			if(
				($sort['direction'] == "a" && $fieldA > $fieldB)
				|| ($sort['direction'] == "d" && $fieldA < $fieldB)
			) {
				return 1;
			}
			break;
		}
	}
	return 0;
}

function sortData($cols,$travelCols,&$guestData) {
	//debug($guestData);
	global $fieldSort;
	$columns = array_merge($cols,$travelCols);
	foreach($columns as $col) {
		if(!empty($col['sort'])) {
			$fieldSort[$col['fields'][0]] = array('sort'=>$col['sort'],'direction'=>$col['direction'],'sortType'=>isset($col['sortType']) ? $col['sortType'] : "");
		}
	}
	if(sizeof($fieldSort) > 0) {
		uasort($fieldSort,'compareSort');
		uasort($guestData,'compareData');
	}
}

function outputHTML($cols,$travelCols,$guestData) {
	global $lDB;
	$GLOBALS['temp']['displayChart']  = '';
	$GLOBALS['temp']['showResults']   = '';
	$conScrollSet = array();
	$colsDisplay = 0;
	$travelDisplay = 0;
	$rows = '<col width="150" />';
	$rows .= '<col width="150" />';
	$rows .= '<col width="25" />';
	$tableWidth = 325;
	$colspan=3;
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$colsDisplay = 1;
			if(isset($col['breakFields']) && $col['breakFields'] == 1) {
				foreach($col['fields'] as $field) {
					$rows .= '<col width="'.$col['width'].'" />';
					$tableWidth += $col['width'];
					$colspan++;
				}
			}elseif($col['split'] != 1) {
				$rows .= '<col width="'.$col['width'].'" />';
				$tableWidth += $col['width'];
				$colspan++;
			} else{
				$objArr =  $lDB->get("
					SELECT 
						rf_obj_guest_data_ix
					FROM 
						rf_obj_guest_data
					WHERE 
						rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
				", 3);

				foreach($objArr as $obj) {
					$rows .= '<col width="'.$col['width'].'" />';
					$tableWidth += $col['width'];
					$colspan++;
				}
			} 
		}
	}
	
	$travelColspan=0;
	foreach($travelCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$travelDisplay = 1;
			if($col['split'] != 1) {
				$rows .= '<col width="'.$col['width'].'" />';
				$tableWidth += $col['width'];
				$travelColspan++;
			} else {
				$objArr =  $lDB->get("
					SELECT 
						rf_obj_trip_data_ix
					FROM 
						rf_obj_trip_data
					WHERE 
						rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
				", 3);
				
				foreach($objArr as $obj) {
					$rows .= '<col width="'.$col['width'].'" />';
					$tableWidth += $col['width'];
					$travelColspan++;
				}
			} 
		}
	}
	
	$GLOBALS['temp']['tableWidth']   = $tableWidth;

	$rows .= '
		<tr>
			<td colspan="'.$colspan.'" style="text-align:left" scope="col">Personal Information</td>
		';
	if($travelDisplay == 1) {
		$rows .= '<td colspan="'.$travelColspan.'" style="text-align:left" scope="col">Travel History</td>';
	}	
	$rows .= '</tr><tr>';

	$rows .= '
		<tr>
			<td class="colLt" rowspan="3" scope="col">Last Name</td>
			<td class="colLt" rowspan="3" scope="col">First Name</td>
			<td class="colLt" rowspan="3" scope="col">&nbsp;</td>		
	';
	$secondRow = '<tr>';
	$thirdRow = '<tr>';
	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	$splitFlag = 0;
	foreach($cols as $col) {
		
		if($col['align'] == "r") {
			$align = "right";
		} else if($col['align'] == "c") {
			$align = "center";
		} else {
			$align = "left";
		}
		if(isset($col['active']) && $col['active'] == 1) {
			if(isset($col['breakFields']) && $col['breakFields'] == 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*count($col['fields'])."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".count($col['fields'])."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*count($col['fields']);
				} else {
					$rows .= "<td class=\colLt\" colspan='".count($col['fields'])."' align='$align'>".$col['label']."</td>";
				}

				foreach($col['fields'] as $fname=>$field) {
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">'.$fname.'</td>';
				}
			}elseif($col['split'] != 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					if($splitFlag == 1) {
						$rowspn = 1;
					} else {
						$rowspn = 2;
						$colspan = $lastHeaderCount;
					}
					
					$rows .= "<td class=\"colLt\" colspan=\"$colspan\" rowspan=\"$rowspn\" align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					if($splitFlag == 1) {
						$secondRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					} else {
						$thirdRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					}
					
					$lastHeader = $col['header'];
					$lastHeaderCount++;
				} else {
					$rows .= "<td class=\"colLt\" rowspan=\"3\" align='$align'>".$col['label']."</td>";
				}
				
				//$rows .= '<td class="colLt" rowspan="2" scope="col" align="'.$align.'">'.$col['label'].'</td>';
			} else {
				$objArr =  $lDB->get("
					SELECT 
						rf_obj_guest_data_ix,rf_obj_guest_data_content
					FROM 
						rf_obj_guest_data
					WHERE 
						rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
				", 2);

				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*count($objArr)."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".count($objArr)."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*count($objArr);
				} else {
					$rows .= "<td class=\colLt\" colspan='".count($objArr)."' align='$align'>".$col['label']."</td>";
				}

				//$rows .= '<td class="colLt" colspan="'.count($objArr).'" scope="col" align="'.$align.'">'. $col['label'].'</td>';

				foreach($objArr as $obj) {
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">'.$obj['rf_obj_guest_data_content'].'</td>';
				}
			} 
		}
	}
	if($lastHeader != "") {
			if($splitFlag == 1) {
			$rowspn = 1;
		} else {
			$rowspn = 2;
			$colspan = $lastHeaderCount;
		}
		$rows .= "<td class=\"colLt\" colspan=\"$colspan\" align=\"center\">".$lastHeader. "</td>";
	}
	
	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	$splitFlag = 0;
	foreach($travelCols as $col) {
		if($col['align'] == "r") {
			$align = "right";
		} else if($col['align'] == "c") {
			$align = "center";
		} else {
			$align = "left";
		}

		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					if($splitFlag == 1) {
						$rowspn = 1;
					} else {
						$rowspn = 2;
						$colspan = $lastHeaderCount;
					}
					
					$rows .= "<td class=\"colLt\" colspan=\"$colspan\" rowspan=\"$rowspn\" align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					if($splitFlag == 1) {
						$secondRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					} else {
						$thirdRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					}
					
					$lastHeader = $col['header'];
					$lastHeaderCount++;
				} else {
					$rows .= "<td class=\"colLt\" rowspan=\"3\" align='$align'>".$col['label']."</td>";
				}
				//$rows .= '<td class="colLt" rowspan="3" scope="col" align="'.$align.'">'.$col['label'].'</td>';
			} else{
				$objArr =  $lDB->get("
					SELECT 
						rf_obj_trip_data_ix,rf_obj_trip_data_content
					FROM 
						rf_obj_trip_data
					WHERE 
						rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
				",2);
				
				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*count($objArr)."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".count($objArr)."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*count($objArr);
				} else {
					$rows .= "<td class=\colLt\" colspan='".count($objArr)."' align='$align'>".$col['label']."</td>";
				}

				//$rows .= '<td class="colLt" colspan="'.count($objArr).'" scope="col" align="'.$align.'">'. $col['label'].'</td>';

				foreach($objArr as $obj) {
					$thirdRow .= '<td scope="col" class="colLt" align="'.$align.'">'. $obj['rf_obj_trip_data_content'].'</td>';
				}
			} 
		}
	}

	if($lastHeader != "") {
			if($splitFlag == 1) {
			$rowspn = 1;
		} else {
			$rowspn = 2;
			$colspan = $lastHeaderCount;
		}
		$rows .= "<td class=\"colLt\" colspan=\"$colspan\" align=\"center\">".$lastHeader. "</td>";
	}

	$rows .= '</tr>';
	$secondRow .= '</tr>';
	$thirdRow .= '</tr>';
	
	$rows .= $secondRow;
	$rows .= $thirdRow;
	if(empty($guestData)) {
		$newColspan = $colspan+$travelColspan;
		$rows .= '
			<tr>
				<td colspan="'.$newColspan.'" style="text-align:left">No results found</td>
			</tr>
		';
		return $rows;
	}

	foreach($guestData as $guest) {
		array_push($conScrollSet, $guest['pr_guest_id']);
		$rowspan = count($guest['travel_history']);
		if($rowspan<1 || $travelDisplay == 0) {
			$rowspan = 1;
		}
		$firsrRec = 1;
		$lastResId = "";
		
		if ($guest['pr_guest_inactive_yn'] == '1'){
			$rowColor = "#e4e3e3";
			$rowFontStyle = "italic";
		} else {
			$rowColor = "";
			$rowFontStyle = "";
		}
		
		for($i=0; $i<$rowspan; $i++) {
			if ( $guest['pr_guest_id'] != "" ) {
                $clickThrough = $clickThroughRes = "onclick=\"window.location = '/reservation.php?45+" . $guest['pr_guest_id'] . "'\"";

                if(isset($guest['travel_history'][$i]['rv_reservation_ix']) && $guest['travel_history'][$i]['rv_reservation_ix'] != "" )  {
                    $clickThroughRes = "onclick=\"window.location = '/reservation.php?2+" . $guest['travel_history'][$i]['rv_reservation_ix'] . "'\"";
                }

				$pointer = 'cursor: pointer;';
			}
						
			if($firsrRec == 1) {
				$rows .= "
					<tr valign=\"top\" onmouseover=\"this.style.backgroundColor = '#cfc'\" onmouseout=\"this.style.backgroundColor = '$rowColor'\" style=\"background-color: $rowColor; font-style: $rowFontStyle;\">
						<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan'>". $guest['pr_name_last']."&nbsp;</td>
						<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan'>". $guest['pr_name_first']."&nbsp;</td>
						<td rowspan='$rowspan'><input class='button bAgent' style='width: 18px; height: 20px;' onclick='editGuest(\"".$guest['pr_guest_id']."\");' type='button'></td>
				";
				foreach($cols as $col) {
					if($col['align'] == "r") {
						$align = "right";
					} else if($col['align'] == "c") {
						$align = "center";
					} else {
						$align = "left";
					}

					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							if(isset($col['breakFields']) && $col['breakFields'] == 1) {
								foreach($col['fields'] as $field) {
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align'>".$guest[$field]."&nbsp;</td>";
								}
							} else {
								$values = array();
								foreach($col['fields'] as $field) {
									array_push($values,$guest[$field]);
								}
								switch($col['type']) {
									default:
									case "string":
										$value = $guest[$col['fields'][0]];
										break;
									case "complex":
										if(function_exists($col['function'])) {
											$value = call_user_func_array($col['function'],$values);
										} else {
											$value = "NOT IMPLEMENTED";
										}
									break;
								}
								$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan'>".	$value. "&nbsp;</td>";
							}
						} else {
							switch($col['objType']) {
								case '1':
								case '6':
									$field = "pr_guest_obj_data_text";
									break;
								case '2':
									$field = "pr_guest_obj_data_memo";
									break;
								case '3':
								case '4':
								case '5':
									$field = "rf_obj_guest_data_id";
									break;
							}
							
							$objVal = $lDB->get("
								SELECT 
									$field 
								FROM 
									pr_guest_obj_data 
								WHERE 
									rf_obj_guest_id = '".$col['rf_obj_guest_ix']."' 
									AND pr_guest_id = '".$guest['pr_guest_id']."'
							", 3);
							
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								$rows .= "<td rowspan='$rowspan'>".(isset($objVal[0]) ? $objVal[0] : "")."&nbsp;</td>";
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rf_obj_guest_data_ix,rf_obj_guest_data_content
									FROM rf_obj_guest_data
									WHERE rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
								",2);
								
								if($col['split'] ==1) {
									foreach($objArr as $obj) {
										if(in_array($obj['rf_obj_guest_data_ix'],$objVal)) {
											$val = "1";
										} else {
											$val = "&nbsp;";
										}
										$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align'>".$val."</td>";
									}
									//$rows .= "</tr></table>&nbsp;</td>";
								} else {
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align'>";
									$counter = 1;
									foreach($objArr as $obj) {
										if(in_array($obj['rf_obj_guest_data_ix'], $objVal)) {
											if($counter>1) {
												$rows .= "<br>";
											}
											$rows .= $obj['rf_obj_guest_data_content'];
											$counter++;
										}
									}
									$rows .= "&nbsp;</td>";

									
								}
								
							}
							
						}
					}
				}
			} else {
				$spn = 2;
				foreach($cols as $col) {
					if($col['align'] == "r") {
						$align = "right";
					} else if($col['align'] == "c") {
						$align = "center";
					} else {
						$align = "left";
					}
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							if(isset($col['breakFields']) && $col['breakFields'] == 1) {
								foreach($col['fields'] as $field) {
									$spn++;
								}
							} else {
								$spn++;
							}
						} else{
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								$spn++;
								
							} else  {
								$objArr =  $lDB->get("
											SELECT 
												rf_obj_guest_data_ix,rf_obj_guest_data_content
											FROM rf_obj_guest_data
											WHERE rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
											",2);
								
								if($col['split'] ==1) {
									foreach($objArr as $obj) {
										$spn++;
									}
								} else {
									$spn++;
								}
							}
						}
					}
				}
				$rows .= "
					<tr valign='top'  onmouseover='this.style.backgroundColor = \"#cfc\"
			;' onmouseout='this.style.backgroundColor = \"\"';'>";
						//<td colspan='".$spn."' style='border:0px;'>&nbsp;</td>
				//";
			}
			
			$class = "";
			$style = "";
			
			if($firsrRec==1) {
				$style = "style='border-bottom:0px; ".$pointer."'";
			} else if($firsrRec==$rowspan) {
				$style = "style='border-top:0px; ".$pointer."'";
			} else {
				if($lastResId != $guest['travel_history'][$i]['rv_reservation_ix']) {
					$style = "style='border-top:1px solid #663300;  border-bottom:0px; ".$pointer."'";
				} else {
					$style = "style='border-top:0px; border-bottom:0px; ".$pointer."'";
				}
			}

			foreach($travelCols as $col) {
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}

				if(isset($col['active']) && $col['active'] == 1) {
					if($col['objType'] =="") {
						$values = array();
						foreach($col['fields'] as $field) {
							array_push($values,(isset($guest['travel_history'][$i][$field]) ? $guest['travel_history'][$i][$field] : "") );
						}
						switch($col['type']) {
							default:
							case "string":
								$value = isset($guest['travel_history'][$i][$col['fields'][0]]) ? $guest['travel_history'][$i][$col['fields'][0]] : "";
								break;
							case "complex":
								if(function_exists($col['function'])) {
									$value = call_user_func_array($col['function'],$values);
								} else {
									$value = "NOT IMPLEMENTED";
								}
							break;
						}

                        $rows .= "<td $style align='$align' $class " . $clickThroughRes . ">" . trim($value) . "&nbsp;</td>";
					} else{
						switch($col['objType']) {
							case '1':
							case '2':
							case '6':
								$field = "rv_trip_obj_data";
								break;
							case '3':
							case '4':
							case '5':
								$field = "rf_obj_trip_data_id";
								break;
						}
						
						$pr_business_id = isset($guest['travel_history'][$i]['propertyId'])?$guest['travel_history'][$i]['propertyId']:"";
						$rv_reservation_id = isset($guest['travel_history'][$i]['rv_reservation_ix'])?$guest['travel_history'][$i]['rv_reservation_ix']:"";
						$objVal = $lDB->get("
							SELECT 
								$field 
							FROM 
								rv_trip_obj_data 
							WHERE 
								rf_obj_trip_id = '".$col['rf_obj_trip_ix']."' 
								AND pr_guest_id = '".$guest['pr_guest_id']."'
								AND rv_reservation_id = '$rv_reservation_id'
						",3);
						if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
							$rows .= "<td $style' align='$align' $class>".(isset($objVal[0]) ? $objVal[0] : "")."&nbsp;</td>";
						} else  {
							$objArr =  $lDB->get("
										SELECT 
											rf_obj_trip_data_ix,rf_obj_trip_data_content
										FROM rf_obj_trip_data
										WHERE rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
										",2);
							
							if($col['split'] ==1) {
								foreach($objArr as $obj) {
									if(in_array($obj['rf_obj_trip_data_ix'],$objVal)) {
										$val = "1";
									} else {
										$val = "&nbsp;";
									}
									$rows .= "<td $class>".$val."</td>";
								}
								
							} else {
								$rows .= "<td $style align='$align' $class>";
								$counter = 1;
								foreach($objArr as $obj) {
									if(in_array($obj['rf_obj_trip_data_ix'], $objVal)) {
										if($counter>1) {
											$rows .= "<br>";
										}
										$rows .= $obj['rf_obj_trip_data_content'];
										$counter++;
									}
								}
								$rows .= "&nbsp;</td>";
							}
						}
					}
				}
			}

			$rows .= '</tr>';
			$firsrRec++;
			$lastResId = isset($guest['travel_history'][$i]['rv_reservation_ix']) ? $guest['travel_history'][$i]['rv_reservation_ix'] : "";
		}
	}
	setContactScroll($conScrollSet);
	return $rows;
}

function outputCSV($cols,$travelCols,$guestData, $renderType="view", $repName="", $repType="xls", $travelHorizontal=0,$guestRepeat=false) {
	global $lDB;
	define("COLWIDTH",150);
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();
	$tempCell_nxt = array();
	$rowCount = 1;
	$multiCell[$rowCount] = array();
	$travelDisplay = 0;
	$firsrRec = 0;

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$defaultStyle = array( 
		'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
		'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
		'font' => array('Size' => '8')
	);
	
	$xls = new XLS($defaultStyle);

	$header_style = array( 
		'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
		'font' =>array('Bold' => '1'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
					
	$header_styleId = $xls->addStyle($header_style);

	$cell_style = array( 
		'interior' => array(),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);

	$inactive_style = array( 
		'interior' => array('Color' => '#e4e3e3', 'Pattern'=>'Solid'),
		'font' =>array('Italic' => '1', 'Size' => '8'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);	
	
	$cell_styleLR = array( 
		'interior' => array(),
		'border' => array($borderL, $borderR)
	);

	$cell_styleLRT = array( 
		'interior' => array(),
		'border' => array($borderL, $borderR, $borderT)
	);

	$cell_styleLRB = array( 
		'interior' => array(),
		'border' => array($borderL, $borderR, $borderB)
	);
					
	$cell_styleId = $xls->addStyle($cell_style);
	$inactive_styleId = $xls->addStyle($inactive_style);
	$cell_styleIdLR = $xls->addStyle($cell_styleLR);
	$cell_styleIdLRT = $xls->addStyle($cell_styleLRT);
	$cell_styleIdLRB = $xls->addStyle($cell_styleLRB);
	
	$xls->Column(COLWIDTH,1,0);
	$xls->Column(COLWIDTH,1,0);
		
	// Get highest number of reservations (for column count)
	$travelTrips = 0;
	$resCount = 0;
	foreach($guestData as $guest) {
		$resIds = array();
		foreach($guest['travel_history'] as $lineItem){
			$resIds[$lineItem['rv_reservation_ix']] = 1;
		}
		$resCount = count($resIds);
		if ($resCount > $travelTrips){
			$travelTrips = $resCount;
		}
	}		
	// ----
	
	$colspan=1;
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if(isset($col['breakFields']) && $col['breakFields'] == 1) {
				foreach($col['fields'] as $field) {
					$xls->Column($col['width'],1,0);
					$colspan++;
				}
			}elseif($col['split'] != 1) {
				$xls->Column($col['width'],1,0);
				$colspan++;
			} else{
				$objArr =  $lDB->get("
					SELECT 
						rf_obj_guest_data_ix
					FROM 
						rf_obj_guest_data
					WHERE 
						rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
				", 3);

				foreach($objArr as $obj) {
					$xls->Column($col['width'],1,0);
					$colspan++;
				}
			} 
		}
	}
	
	$travelColspan=-1;
	if ($travelHorizontal == 0){
		foreach($travelCols as $col) {
			if(isset($col['active']) && $col['active'] == 1) {
				$travelDisplay = 1;
				if($col['split'] != 1) {
					$xls->Column($col['width'],1,0);
					$travelColspan++;
				} else {
					$objArr =  $lDB->get("
						SELECT 
							rf_obj_trip_data_ix
						FROM 
							rf_obj_trip_data
						WHERE 
							rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
					", 3);
				
					foreach($objArr as $obj) {
						$xls->Column($col['width'],1,0);
						$travelColspan++;
					}
				} 
			}
		}
	} else {
		for($i=0; $i<$travelTrips; $i++) {	
			foreach($travelCols as $col) {
				if(isset($col['active']) && $col['active'] == 1) {
					$travelDisplay = 1;
					if($col['split'] != 1) {
						$xls->Column($col['width'],1,0);
						$travelColspan++;
					} else {
						$objArr =  $lDB->get("
							SELECT 
								rf_obj_trip_data_ix
							FROM 
								rf_obj_trip_data
							WHERE 
								rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
						", 3);
					
						foreach($objArr as $obj) {
							$xls->Column($col['width'],1,0);
							$travelColspan++;
						}
					} 
				}
			}
		}
	
	
	}
	
	
	// ----  Hide report header rows (not col headers)
	//	
	// $cell = $xls->Cell(array('type'=>'String', 'data' => "Personal Information"), $header_styleId, '', '', '', '', $colspan);
	// array_push($tempCell, $cell);
	// if($travelDisplay == 1) {
		// $cell = $xls->Cell(array('type'=>'String', 'data' => "Travel History"), $header_styleId, '', '', '', '', $travelColspan);
		// array_push($tempCell, $cell);
	// }
	//array_push($multiCell[$rowCount], $tempCell);
	
	$tempCell = array();
	$rowCount += 1;
	$multiCell[$rowCount] = array();

	$cell = $xls->Cell(array('type'=>'String', 'data'=>'Last name'), $header_styleId, "", "", "", "", 0);
	array_push($tempCell, $cell);
	$cell = $xls->Cell(array('type'=>'String', 'data'=>'First name'), $header_styleId, "", "", "", "", 0);
	array_push($tempCell, $cell);
	$index = 2;
		
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if(isset($col['breakFields']) && $col['breakFields'] == 1) {
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", count($col['fields'])-1);
				array_push($tempCell, $cell);
				foreach($col['fields'] as $fname=>$field) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$fname), $header_styleId, $index);
					
					array_push($tempCell_nxt, $cell);
					$index++;
				}
				$index--;
			}elseif($col['split'] != 1) {
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", 0);
				array_push($tempCell, $cell);
			} else {
				$objArr =  $lDB->get("
					SELECT 
						rf_obj_guest_data_ix,rf_obj_guest_data_content
					FROM 
						rf_obj_guest_data
					WHERE 
						rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
				", 2);
				
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", count($objArr)-1);
				array_push($tempCell, $cell);
				
				foreach($objArr as $obj) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$obj['rf_obj_guest_data_content']), $header_styleId, $index);
					
					array_push($tempCell_nxt, $cell);
					$index++;
				}
				$index--;
			} 
		}
	}
	
	if ($travelHorizontal == 0){
		foreach($travelCols as $col) {
			if(isset($col['active']) && $col['active'] == 1) {
				if($col['split'] != 1) {
					$index++;
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", 0);
					array_push($tempCell, $cell);
								
				} else{
					$objArr =  $lDB->get("
						SELECT 
							rf_obj_trip_data_ix,rf_obj_trip_data_content
						FROM 
							rf_obj_trip_data
						WHERE 
							rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
					",2);
					
					$index++;
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", count($objArr)-1);
					array_push($tempCell, $cell);
					
					foreach($objArr as $obj) {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$obj['rf_obj_trip_data_content']), $header_styleId, $index);
						array_push($tempCell_nxt, $cell);
						$index++;
					}
					$index--;
				} 
			}
		}
	} else {	// Horizontal Travel Columns
		// 2011-09-26 - Create headers
		for($i=0; $i<$travelTrips; $i++) {	

			foreach($travelCols as $col) {
				if(isset($col['active']) && $col['active'] == 1) {
					if($col['split'] != 1) {
						$index++;
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']." ".($i+1)), $header_styleId, "", "", "", "", 0);
						array_push($tempCell, $cell);
					} else{
						$objArr =  $lDB->get("
							SELECT 
								rf_obj_trip_data_ix,rf_obj_trip_data_content
							FROM 
								rf_obj_trip_data
							WHERE 
								rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
						",2);
						
						$index++;
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']." ".($i+1)), $header_styleId, "", "", "", "", count($objArr)-1);
						array_push($tempCell, $cell);
						
						foreach($objArr as $obj) {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$obj['rf_obj_trip_data_content']), $header_styleId, $index);
							array_push($tempCell_nxt, $cell);
							$index++;
						}
						$index--;
					} 
				}
			}		
		
		}
	}
	
	array_push($multiCell[$rowCount], $tempCell);
	$tempCell = array();
	$rowCount += 1;
	$multiCell[$rowCount] = array();

	if (!empty($tempCell_nxt)){
		array_push($multiCell[$rowCount], $tempCell_nxt);
		$tempCell_nxt = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();
	}

	
	if(empty($guestData)) {
		$newColspan = $colspan+$travelColspan;
		$cell = $xls->Cell(array('type'=>'String', 'data' => "No results found"), $cell_styleId, '', '', '', '', $newColspan);
		array_push($tempCell, $cell);
		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		return 0; 
	}

	foreach($guestData as $guest) {

		if ($guest['pr_guest_inactive_yn'] == '1'){
			$rowStyle = $inactive_styleId;
		} else {
			$rowStyle = $cell_styleId;
		}	
	
		if ($travelHorizontal == 0){
			$travelRec = count($guest['travel_history']);
			if($travelRec<1) {
				$travelRec = 1;
			}
			$firsrRec = 1;		
			for($i=0; $i<$travelRec; $i++) {
					
				if($firsrRec == 1) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['pr_name_last']), $rowStyle);
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['pr_name_first']), $rowStyle);
					array_push($tempCell, $cell);
					
					foreach($cols as $col) {
						if(isset($col['active']) && $col['active'] == 1) {
							if($col['objType'] =="") {
								if(isset($col['breakFields']) && $col['breakFields'] == 1) {
									foreach($col['fields'] as $field) {
										$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest[$field]), $rowStyle);
										array_push($tempCell, $cell);
									}
								} else {
									$values = array();
									foreach($col['fields'] as $field) {
										array_push($values,$guest[$field]);
									}
									switch($col['type']) {
										default:
										case "string":
											$value = $guest[$col['fields'][0]];
											break;
										case "complex":
											if(function_exists($col['function'])) {
												$value = call_user_func_array($col['function'],$values);
											} else {
												$value = "NOT IMPLEMENTED";
											}
										break;
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $rowStyle);
									array_push($tempCell, $cell);
								}
							} else{
								switch($col['objType']) {
									case '1':
									case '6':
										$field = "pr_guest_obj_data_text";
										break;
									case '2':
										$field = "pr_guest_obj_data_memo";
										break;
									case '3':
									case '4':
									case '5':
										$field = "rf_obj_guest_data_id";
										break;
								}
								
								$objVal = $lDB->get("
									SELECT 
										$field 
									FROM 
										pr_guest_obj_data 
									WHERE 
										rf_obj_guest_id = '".$col['rf_obj_guest_ix']."' 
										AND pr_guest_id = '".$guest['pr_guest_id']."'
								", 3);
								
								if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
									$dataValue = isset($objVal[0]) ? $objVal[0] : "";
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$dataValue), $rowStyle);
									array_push($tempCell, $cell);
									
								} else {
									$objArr =  $lDB->get("
										SELECT 
											rf_obj_guest_data_ix,rf_obj_guest_data_content
										FROM 
											rf_obj_guest_data
										WHERE 
											rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
									", 2);
									if($col['split'] ==1) {
										foreach($objArr as $obj) {
											if(in_array($obj['rf_obj_guest_data_ix'],$objVal)) {
												$val = "1";
											} else {
												$val = "";
											}
											$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $rowStyle);
											array_push($tempCell, $cell);
										}
									} else {
										$data = "";
										foreach($objArr as $obj) {
											if(in_array($obj['rf_obj_guest_data_ix'], $objVal)) {
												if($data != "") {
													$data .= "&#10;";
												}
												$data .= $obj['rf_obj_guest_data_content'];
											}
										}
										$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $rowStyle);
										array_push($tempCell, $cell);
									}
									
								}
								
							}
						}
					}
				} else {
					$spn = 1;
					foreach($cols as $col) {
						if(isset($col['active']) && $col['active'] == 1) {
							if($col['objType'] =="") {
								if(isset($col['breakFields']) && $col['breakFields'] == 1) {
									foreach($col['fields'] as $field) {
										$spn++;
									}
								} else {
									$spn++;
								}
							} else{
								if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
									$spn++;
								} else  {
									$objArr =  $lDB->get("
										SELECT 
											rf_obj_guest_data_ix,rf_obj_guest_data_content
										FROM 
											rf_obj_guest_data
										WHERE 
											rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
									", 2);
									
									if($col['split'] ==1) {
										foreach($objArr as $obj) {
											$spn++;
										}
									} else {
										$spn++;
									}
								}
							}
						}
					}
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), '', '', '', '', '', $spn);
					array_push($tempCell, $cell);
				}

				foreach($travelCols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {

							$values = array();
							foreach($col['fields'] as $field) {
								if(array_key_exists($i,$guest['travel_history']) && array_key_exists($field,$guest['travel_history'][$i])) {
									array_push($values,$guest['travel_history'][$i][$field]);
								} else {
									array_push($values,"");
								} 
							}
							switch($col['type']) {
								default:
								case "string":
									if(array_key_exists($i,$guest['travel_history']) && array_key_exists($col['fields'][0],$guest['travel_history'][$i])) {
										$value = $guest['travel_history'][$i][$col['fields'][0]];
									} else {
										$value = "";
									}
									break;
								case "complex":
									if(function_exists($col['function'])) {
										$value = call_user_func_array($col['function'],$values);
									} else {
										$value = "NOT IMPLEMENTED";
									}
								break;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $rowStyle);

							//$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['travel_history'][$i][$col['fields'][0]]), $rowStyle);
							array_push($tempCell, $cell);
						} else{
							switch($col['objType']) {
								case '1':
								case '2':
								case '6':
									$field = "rv_trip_obj_data";
									break;
								case '3':
								case '4':
								case '5':
									$field = "rf_obj_trip_data_id";
									break;
							}
							
							$objVal = array();
							if (isset($guest['travel_history'][$i])) {
								$objVal = $lDB->get("
									SELECT 
										$field 
									FROM 
										rv_trip_obj_data 
									WHERE 
										rf_obj_trip_id = '".$col['rf_obj_trip_ix']."' 
										AND pr_guest_id = '".$guest['pr_guest_id']."'
										AND pr_business_id = '".$guest['travel_history'][$i]['propertyId']."'
										AND rv_reservation_id = '".$guest['travel_history'][$i]['rv_reservation_ix']."'
								",3);
							}
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								if(!isset($objVal[0])) { $objVal[0] = ""; }
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$objVal[0]), $rowStyle);
								array_push($tempCell, $cell);
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rf_obj_trip_data_ix,rf_obj_trip_data_content
									FROM 
										rf_obj_trip_data
									WHERE 
										rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
								",2);
								if($col['split'] == 1) {
									foreach($objArr as $obj) {
										if(in_array($obj['rf_obj_trip_data_ix'],$objVal)) {
											$val = "1";
										} else {
											$val = "";
										}
										$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $rowStyle);
										array_push($tempCell, $cell);
									}
								} else {
									$data = "";
									foreach($objArr as $obj) {
										if(in_array($obj['rf_obj_trip_data_ix'], $objVal)) {
											if($data != "") {
												$data .= "&#10;";
											}
											$data .= $obj['rf_obj_trip_data_content'];
										}
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $rowStyle);
									array_push($tempCell, $cell);
								}
								
							}
							
						}
					}
				}

				array_push($multiCell[$rowCount], $tempCell);
				$tempCell = array();
				$rowCount += 1;
				$multiCell[$rowCount] = array();
				if(!$guestRepeat) {
					$firsrRec++;
				}
			}		
		} else {	// Horizontal Travel History
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['pr_name_last']), $rowStyle);
			array_push($tempCell, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['pr_name_first']), $rowStyle);
			array_push($tempCell, $cell);
			
			foreach($cols as $col) {
				if(isset($col['active']) && $col['active'] == 1) {
					if($col['objType'] =="") {
						if(isset($col['breakFields']) && $col['breakFields'] == 1) {
							foreach($col['fields'] as $field) {
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest[$field]), $rowStyle);
								array_push($tempCell, $cell);
							}
						} else {
							$values = array();
							foreach($col['fields'] as $field) {
								array_push($values,$guest[$field]);
							}
							switch($col['type']) {
								default:
								case "string":
									$value = $guest[$col['fields'][0]];
									break;
								case "complex":
									if(function_exists($col['function'])) {
										$value = call_user_func_array($col['function'],$values);
									} else {
										$value = "NOT IMPLEMENTED";
									}
								break;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $rowStyle);
							array_push($tempCell, $cell);
						}
					} else{
						switch($col['objType']) {
							case '1':
							case '6':
								$field = "pr_guest_obj_data_text";
								break;
							case '2':
								$field = "pr_guest_obj_data_memo";
								break;
							case '3':
							case '4':
							case '5':
								$field = "rf_obj_guest_data_id";
								break;
						}
						
						$objVal = $lDB->get("
							SELECT 
								$field 
							FROM 
								pr_guest_obj_data 
							WHERE 
								rf_obj_guest_id = '".$col['rf_obj_guest_ix']."' 
								AND pr_guest_id = '".$guest['pr_guest_id']."'
						", 3);
						
						if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
							$cell = $xls->Cell(array('type'=>'String', 'data'=>isset($objVal[0])?$objVal[0]:""), $rowStyle);
							array_push($tempCell, $cell);
							
						} else {
							$objArr =  $lDB->get("
								SELECT 
									rf_obj_guest_data_ix,rf_obj_guest_data_content
								FROM 
									rf_obj_guest_data
								WHERE 
									rf_obj_guest_data.rf_obj_guest_id = '".$col['rf_obj_guest_ix']."'
							", 2);
							if($col['split'] ==1) {
								foreach($objArr as $obj) {
									if(in_array($obj['rf_obj_guest_data_ix'],$objVal)) {
										$val = "1";
									} else {
										$val = "";
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $rowStyle);
									array_push($tempCell, $cell);
								}
							} else {
								$data = "";
								foreach($objArr as $obj) {
									if(in_array($obj['rf_obj_guest_data_ix'], $objVal)) {
										if($data != "") {
											$data .= "&#10;";
										}
										$data .= $obj['rf_obj_guest_data_content'];
									}
								}
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $rowStyle);
								array_push($tempCell, $cell);
							}
							
						}
						
					}
				}
			}
			// 2011-09-26 - Cell data
			// First group all line items into one row per reservation
			$travelHistGrouped = array();
			$resId = "";
			foreach ($guest['travel_history'] as $travelHistItem){

				foreach ($travelHistItem as $key => $item){
					switch ($key){
						case "rv_reservation_ix":
							$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = trim($item);
							break;	
						case "rv_res_name":
							$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = trim($item);
							break;								
						case "propertyId":
							if (isset($travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key]) && $travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] != ""){
								$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = $travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] . "|" . trim($item);
							} else {
								$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = trim($item);
							}
							break;
						case "travel_dates":
							if (!isset($travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key]) || $travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] == ""){
								$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = trim($item);
							} elseif (stristr($travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key],$item) === false){
								$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = $travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] . "&#10;" . trim($item);
							}
							break;							
						default:
							if (isset($travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key]) && $travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] != ""){
								$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = $travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] . "&#10;" . trim($item);
							} else {
								$travelHistGrouped[$travelHistItem['rv_reservation_ix']][$key] = trim($item);
							}
					}
					
				}
				
			}
			
			foreach ($travelHistGrouped as $resId => $travelHistItem){
				foreach($travelCols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {

							$values = array();
							foreach($col['fields'] as $field) {
								array_push($values,$travelHistItem[$field]);
							}
							switch($col['type']) {
								default:
								case "string":
									$value = $travelHistItem[$col['fields'][0]];
									break;
								case "complex":
									if(function_exists($col['function'])) {
										$value = call_user_func_array($col['function'],$values);
									} else {
										$value = "NOT IMPLEMENTED";
									}
								break;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $rowStyle);
							array_push($tempCell, $cell);
						} else{
							switch($col['objType']) {
								case '1':
								case '2':
								case '6':
									$field = "rv_trip_obj_data";
									break;
								case '3':
								case '4':
								case '5':
									$field = "rf_obj_trip_data_id";
									break;
							}
							
							// multiple properties
							$properties = explode("|",$travelHistItem['propertyId']);
							//debug($properties);
							$objVal = array();
							foreach($properties as $property){
								$singleObjVal = $lDB->get("
									SELECT 
										$field 
									FROM 
										rv_trip_obj_data 
									WHERE 
										rf_obj_trip_id = '".$col['rf_obj_trip_ix']."' 
										AND pr_guest_id = '".$guest['pr_guest_id']."'
										AND pr_business_id = '".$property."'
										AND rv_reservation_id = '".$resId."'
								",3);
								if (!empty($singleObjVal)){
									$objVal = array_merge($objVal, $singleObjVal);
								}
							}
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								$cell = $xls->Cell(array('type'=>'String', 'data'=>isset($objVal[0])?$objVal[0]:""), $rowStyle);
								array_push($tempCell, $cell);
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rf_obj_trip_data_ix,rf_obj_trip_data_content
									FROM 
										rf_obj_trip_data
									WHERE 
										rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
								",2);

								if($col['split'] == 1) {
									foreach($objArr as $obj) {
										if(in_array($obj['rf_obj_trip_data_ix'],$objVal)) {
											$val = "1";
										} else {
											$val = "";
										}
										$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $rowStyle);
										array_push($tempCell, $cell);
									}
								} else {
									$data = "";
									foreach($objArr as $obj) {
										if(in_array($obj['rf_obj_trip_data_ix'],$objVal)) {
											if($data != "") {
												$data .= "&#10;";
											}
											$data .= $obj['rf_obj_trip_data_content'];
										}
									}
									
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $rowStyle);
									array_push($tempCell, $cell);
								}
								
							}
							
						}
					}
				}
		
			}
			
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();
			$firsrRec++;
		}
		
	}
	$cells = array();
	$rows = array();
	$temparr=array();
	$headerFlag = 1;
	
	foreach($multiCell as $rowId=>$temparr) {
		foreach($temparr as $cellArr) {
			foreach($cellArr as $tmp) {
				array_push($cells,$tmp);
			}
			
			if($headerFlag<=3) {
				$row = $xls->Row($cells, 20, 1);
			} else {
				$row = $xls->Row($cells);
			}
			$cells = array();
			array_push($rows,$row);
		}
		$headerFlag++;
	}

    if ($repType == "csvFromXml") {
        $xml = "<report>".join("", $rows)."</report>";
        $csv = xmlToCSV($xml);

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=".$repName);
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $csv;
        die;
    }

	$table = $xls->Table($rows);
	array_push($tables, $table);
	$xls->Worksheet($tables);
	if ( $renderType == 'view' ) {
		$xls->genrateWorkbook($repName, $repType);
	}
	if ( $renderType == 'send' ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = $_POST['mail_subj'];
		$message = $_POST['mail_body'];
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
		$xlsSheet = $xls->genrateWorkbook($repName, $repType, 1);
		
		// and now mail it
		if ( $attachmentName != '!attachmentName!' ) {
			$pdfName = $attachmentName;
		} else {
			$pdfName = $repName;
		}

		// (from, to, subject, headers, message, action, emailID, resID)
		$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$xlsSheet,$pdfName);
		if ( !$error ) {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								opener.openMessage("Your email has been sent.");
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		} else {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								opener.openMessage("Error sending email!");
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		}
	}
}

function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;
	$fromDate = date("d-m-Y");
	$csvName = "guesthistory_$fromDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $csvName . ".xlsx</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 2;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,42))."+".$newOptions."+".join("+",array_slice($_SERVER['argv'],40,1));
	
	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$csvName.".xlsx",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!","Guest History Report: ".chng_date(date("Y-m-d"),"-"),
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}


// [STARRT] - Section functions
function findSectionId($sections,$name) {
	foreach($sections as $item) {
		if($item['name'] == $name) {
			return $item['id'];
		}
	}
}


function buildCheck($name,$id,$isChecked,$onClick="") {
	$checked = "";
	if($isChecked) {
		$checked = "checked";
	}
	return "<input type=\"checkbox\" name=\"".$name."Check\" id=\"$name$id\" $checked onclick=\"$onClick\">";
}

function getWeekDates() {
	$w = date("w");
	switch($w) {
	case 0:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-6, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d"), date("Y")));
		break;
	case 1:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d"), date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+6, date("Y")));
		break;
	case 2:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-1, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+5, date("Y")));
		break;
	case 3:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-2, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+4, date("Y")));
		break;
	case 4:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-3, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+3, date("Y")));
		break;
	case 5:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-4, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+2, date("Y")));
		break;
	case 6:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-5, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1, date("Y")));
		break;
	}

	$dateArray = array($fromDate, $toDate);
	return $dateArray;
}

function travelHTML($cols,$travelData) {
	global $lDB;
	$rows = '';
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$rows .= '<col width="'.$col['width'].'" />';
		}
	}

	$rows .= '<tr>
			';
	$secondRow = '<tr>';
	
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				$rows .= '<td class="colLt" rowspan="2" scope="col">'.$col['label'].'</td>';
			} else{
				$objArr =  $lDB->get("
									SELECT 
										rf_obj_trip_data_ix,rf_obj_trip_data_content
									FROM rf_obj_trip_data
									WHERE rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_trip_ix']."'
									",2);
			
				$rows .= '<td class="colLt" colspan="'.count($objArr).'" scope="col">'. $col['label'].'</td>';

				foreach($objArr as $obj) {
					$secondRow .= '<td scope="col">'.$obj['rf_obj_trip_data_content'].'</td>';
				}
			} 
		}
	}
	$rows .= '</tr>';
	$secondRow .= '</tr>';
	$rows .= $secondRow;

	foreach($travelData as $travel) {
		$rows .= "<tr>
				";
		foreach($cols as $col) {
			if(isset($col['active']) && $col['active'] == 1) {
				if($col['objType'] =="") {
					$rows .= "<td>".$travel[$col['fields'][0]]."&nbsp;</td>";
				} else{
					switch($col['objType']) {
						case '1':
						case '2':
						case '6':
							$field = "rv_trip_obj_data";
							break;
						case '3':
						case '4':
						case '5':
							$field = "rf_obj_trip_data_id";
							break;
					}
					
					$objVal = $lDB->get("SELECT $field FROM rv_trip_obj_data WHERE rf_obj_trip_id = '".$col['rf_obj_trip_ix']."' AND pr_guest_id = '".$travel['pr_guest_id']."'",4);
					if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
						$rows .= "<td>".$objVal."&nbsp;</td>";
					} else  {
						$objArr =  $lDB->get("
									SELECT 
										rf_obj_trip_data_ix,rf_obj_trip_data_content
									FROM rf_obj_trip_data
									WHERE rf_obj_trip_data.rf_obj_trip_id = '".$col['rf_obj_guest_ix']."'
									",2);
						foreach($objArr as $obj) {
							$newObjArr[$obj['rf_obj_guest_data_ix']] = $obj['rf_obj_guest_data_content'];
						}

						if($col['split'] ==1) {
							/*$rows .= "<td>
										<table width='100%'>
											<tr>";*/
							foreach($newObjArr as $key=>$item) {
								if($key == $objVal) {
									$val = "1";
								} else {
									$val = "&nbsp;";
								}
								$rows .= "<td>".$val."</td>";
							}
							//$rows .= "</tr></table>&nbsp;</td>";
						} else {
							$rows .= "<td>".$newObjArr[$col['rf_obj_guest_data_ix']]."&nbsp;</td>";
						}
						
					}
					
				}
			}
		}
		$rows .= '</tr>';
	}
		return $rows;
}
