<?php

/**
 * init.form389.func.php - Add Guest Servey Code
 * Job: 343
 * Function: 114 (Code Tables: Guest Survey)
 */

require_once(__DIR__ . '/db.zg_transfer_guest.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . '/functions.report.php'); 
require_once(__DIR__ . '/functions.profile.php');

DEFINE('LAST_SEVEN_DAYS_OPT',1);
DEFINE('LAST_FOURTEEN_DAYS_OPT',2);
DEFINE('LAST_WEEK_OPT',3);
DEFINE('THIS_MONTH_OPT',4);
DEFINE('LAST_MONTH_OPT',5);
DEFINE('CUSTOM_DATE_OPT',6);

$profileFields = array(
	/*  1 */ "propertyExtraFilter",
	/*  2 */ "dateOpt",
	/*  3 */ "fromDate",
	/*  4 */ "toDate",
	/*  5 */ "status"
);

function calculateDate($dateOpt=6) {
	switch($dateOpt) {
	case LAST_SEVEN_DAYS_OPT:
		$Start = strtotime("-8 days");
		$End = strtotime("-1 days");
		$date['start'] = date('Y-m-d',$Start); 
		$date['end'] = date('Y-m-d',$End); 
		break;
	case LAST_FOURTEEN_DAYS_OPT:
		$Start = strtotime("-15 days");
		$End = strtotime("-1 days");
		$date['start'] = date('Y-m-d',$Start); 
		$date['end'] = date('Y-m-d',$End); 
		break;
	case LAST_WEEK_OPT:
		$currentDay = date('w');
		$startDay = $currentDay+6;
		$endDay = $currentDay;
		$lastwkStart = strtotime("-$startDay days");
		$lastwkEnd = strtotime("-$endDay days");
		$date['start'] = date('Y-m-d',$lastwkStart); 
		$date['end'] = date('Y-m-d',$lastwkEnd);
		break;
	case THIS_MONTH_OPT:
		$startDay = date('d')-1;
		$endDay = date('t')-date('d');
		$monthStart = strtotime("-$startDay days");
		$monthEnd = strtotime("+$endDay days");
		$date['start'] = date('Y-m-d',$monthStart); 
		$date['end'] = date('Y-m-d',$monthEnd); 
		break;
	case LAST_MONTH_OPT:
		$endDay = date('d');
		$lastMonthEnd = strtotime("-$endDay days");
		$date['start'] = date('Y-m-d',mktime(0, 0, 0, date("m")-1, 1,   date("Y"))); 
		$date['end'] = date('Y-m-d',$lastMonthEnd); 
		break;
	default:
	case CUSTOM_DATE_OPT:
		$date['start'] = date('Y-m-d'); 
		$date['end'] = date('Y-m-d'); 
		break;
	}

	return $date;
}

function checkPropEntry($propId=null, $zg_trf_guest_status_ind=null, $pr_guest_id=null , $rv_reservation_id=null) {
	if(empty($zg_trf_guest_status_ind)) {
		$status = "zg_transfer_guest.zg_trf_guest_status_ind = null ";
	} else {
		$status = "zg_transfer_guest.zg_trf_guest_status_ind = '$zg_trf_guest_status_ind' ";
	}
	return $GLOBALS['lDB']->get("
		SELECT	
			count(zg_transfer_guest_prop.zg_transfer_guest_prop_ix )
		FROM 
			zg_transfer_guest_prop
			INNER JOIN zg_transfer_guest ON zg_transfer_guest.zg_transfer_guest_ix = zg_transfer_guest_prop.zg_transfer_guest_id
		WHERE 
			zg_transfer_guest_prop.pr_business_id = '$propId' AND 
			".$status." AND zg_transfer_guest.pr_guest_id = '$pr_guest_id'
			AND zg_transfer_guest.rv_reservation_id = '$rv_reservation_id'
	", 4);

}
