<?php

/**
 * init.form389.php - Display Guest Survey Page
 * Job: 343
 * Function: 114 (Code Tables: Guest Survey)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("survey_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Survey Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_survey.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$_SERVER['argv'] = array_pad($_SERVER['argv'],9,"");

$dbClause = "";
$dbOrder = "";

$sortBy = "8";

$last7daysRange = calculateDate(LAST_SEVEN_DAYS_OPT);
$last14daysRange = calculateDate(LAST_FOURTEEN_DAYS_OPT);
$lastWeekRange = calculateDate(LAST_WEEK_OPT);
$thisMonthRange = calculateDate(THIS_MONTH_OPT);
$lastMonthRange = calculateDate(LAST_MONTH_OPT);
$customDateRange = calculateDate(CUSTOM_DATE_OPT);

$GLOBALS['temp']['last7daysStart'] = $last7daysRange['start'];
$GLOBALS['temp']['last7daysEnd'] = $last7daysRange['end'];
$GLOBALS['temp']['last14daysStart'] = $last14daysRange['start'];
$GLOBALS['temp']['last14daysEnd'] = $last14daysRange['end'];
$GLOBALS['temp']['lastWeekStart'] = $lastWeekRange['start'];
$GLOBALS['temp']['lastWeekEnd'] = $lastWeekRange['end'];
$GLOBALS['temp']['thisMonthStart'] = $thisMonthRange['start'];
$GLOBALS['temp']['thisMonthEnd'] = $thisMonthRange['end'];
$GLOBALS['temp']['lastMonthStart'] = $lastMonthRange['start'];
$GLOBALS['temp']['lastMonthEnd'] = $lastMonthRange['end'];
$GLOBALS['temp']['customDateStart'] = $customDateRange['start'];
$GLOBALS['temp']['customDateEnd'] = $customDateRange['end'];

if(trim($_SERVER['argv'][6]) != "") {
	$sortBy = $_SERVER['argv'][6];
}

$GLOBALS['temp']['hideAll'] = "1";
if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['hideAll'] = "0";
}

$status = $_SERVER['argv'][3];
$propId = $_SERVER['argv'][4];
$propertyFilter = "";
if($propId != "") {
	$propertyFilter = "AND property.pr_persona_ix = '$propId' AND rv_reservation_item.pr_business_id='$propId' AND (zg_transfer_guest_prop.pr_business_id IS NULL OR zg_transfer_guest_prop.pr_business_id = '$propId')";
}


$propertyACL = $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		sc_accomm.sc_group_id = '".$GLOBALS['sc_group_id']."'
		AND ac_accomm_type.ac_accomm_type_inactive_yn=0
	ORDER BY
		pr_persona.pr_name_last
", 3);

$propertyOptions = "<option value=\"\">Select Property</option>";
foreach($propertyACL as $item) {
	$selected = "";
	$pr_name_last = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$item' ",4);
	if($pr_name_last != "0") {
		if($item == $propId) {
			$selected = "selected";
		}
		$propertyOptions .= "<option value=\"$item\" $selected>$pr_name_last</option>";
	}
}
$GLOBALS['temp']['propertyOptions'] = $propertyOptions;
$GLOBALS['temp']['propId'] = $propId;

$dateOpt = $_SERVER['argv'][5];
if(empty($dateOpt)) {
	$dateOpt = 6;
}
$dateOpt -= 1; 

if($_SERVER['argv'][1] != "") {
	$arriveDate	= $_SERVER['argv'][1];
} else {
	$arriveDate	= "";
}
if($_SERVER['argv'][2] != "") {
	$departDate	= $_SERVER['argv'][2];
} else {
	$departDate	= "";
}
$GLOBALS['temp']['dateOpt'] = $dateOpt;

$splitArr = useDate("arrive", $arriveDate);
$splitDep = useDate("depart", $departDate);

$GLOBALS['temp']['splitArr'] = $splitArr['jsDate'];

if(trim($departDate) != "") {
	$GLOBALS['temp']['splitDep'] = $splitDep['jsDate'];
} else {
	$GLOBALS['temp']['splitDep'] = date("Y-m-d",time());
}

$GLOBALS['temp']['printArr'] = $splitArr['htmlDate'];
$GLOBALS['temp']['printDep'] = $splitDep['htmlDate'];

if($arriveDate != "" && $departDate != "") {
	$dateExtra = "AND (rv_reservation.rv_date_depart <= '" . $departDate . "' AND rv_reservation.rv_date_arrive >= '" . $arriveDate . "')";
} else {
	$dateExtra = "";
}

$filterStatus = $_SERVER['argv'][7];
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "expand";
}

$statusList = explode(":",$status);
$statusListCond = array();
if(
	in_array(DB_ZG_TRANSFER_GUEST_FAILED,$statusList) 
	|| 
	(
		in_array(DB_ZG_TRANSFER_GUEST_FAILED,$statusList) 
		&& 
		in_array(DB_ZG_TRANSFER_GUEST_SUCCESS,$statusList)
	)
) {
	$statusListCond = array(DB_ZG_TRANSFER_GUEST_SUCCESS,DB_ZG_TRANSFER_GUEST_FAILED);
} else {
	$statusListCond = array(DB_ZG_TRANSFER_GUEST_SUCCESS);
}

$statusExtra = "";
if($status != "") { 
	$cond = " AND (";
	if(in_array(DB_ZG_TRANSFER_GUEST_UNLOGGED,$statusList)) {
		$statusExtra .= $cond."zg_transfer_guest.zg_trf_guest_status_ind IS NULL ";
		$cond = " OR ";
	}
	if(!empty($statusListCond)) {
		$statusExtra .= $cond." zg_transfer_guest.zg_trf_guest_status_ind IN ('".join("','",$statusListCond)."') ";
	}
	$statusExtra .=")";
}

$GLOBALS['temp']['statusNames'] = "All";
$GLOBALS['temp']['nlog'] = "";
$GLOBALS['temp']['slog'] = "";
$GLOBALS['temp']['flog'] = "";
if($status == "") {
	$GLOBALS['temp']['nlog'] = "checked";
	$GLOBALS['temp']['slog'] = "checked";
	$GLOBALS['temp']['flog'] = "checked";
}

$statusNameArray = array();
if(in_array(DB_ZG_TRANSFER_GUEST_UNLOGGED,$statusList)) {
	array_push($statusNameArray,"No survey request submitted");
	$GLOBALS['temp']['nlog'] = "checked";
}
if(in_array(DB_ZG_TRANSFER_GUEST_SUCCESS,$statusList)) {
	array_push($statusNameArray,"Survey integration successful");
	$GLOBALS['temp']['slog'] = "checked";
}
if(in_array(DB_ZG_TRANSFER_GUEST_FAILED,$statusList)) {
	array_push($statusNameArray,"Survey integration failed");
	$GLOBALS['temp']['flog'] = "checked";
}
 
$GLOBALS['temp']['statusNames'] = join(",",$statusNameArray);

$GLOBALS['temp']['batch_name'] = "Custom";

$dbClause = "WHERE  rv_reservation.rf_reservation_status_id IN ('20','30') " . $statusExtra . " " . $propertyFilter . " " . $dateExtra;

$GLOBALS['temp']['runBatch'] = "&nbsp;";

if($_SERVER['argc'] > 1) {

	$GLOBALS['temp']['imgSort1'] = "";
	$GLOBALS['temp']['imgSort2'] = "";
	$GLOBALS['temp']['imgSort3'] = "";
	$GLOBALS['temp']['imgSort4'] = "";
	$GLOBALS['temp']['imgSort5'] = "";
	$GLOBALS['temp']['imgSort6'] = "";
	$GLOBALS['temp']['imgSort7'] = "";
	$GLOBALS['temp']['imgSort8'] = "";
	$GLOBALS['temp']['imgSort9'] = "";
	$GLOBALS['temp']['imgSort10'] = "";
	$GLOBALS['temp']['imgSort11'] = "";
	$GLOBALS['temp']['imgSort12'] = "";

	$GLOBALS['temp']['imgSort1Mode'] = "";
	$GLOBALS['temp']['imgSort2Mode'] = "";
	$GLOBALS['temp']['imgSort3Mode'] = "";
	$GLOBALS['temp']['imgSort4Mode'] = "";
	$GLOBALS['temp']['imgSort5Mode'] = "";
	$GLOBALS['temp']['imgSort6Mode'] = "";
	$GLOBALS['temp']['imgSort7Mode'] = "";
	$GLOBALS['temp']['imgSort8Mode'] = "";
	$GLOBALS['temp']['imgSort9Mode'] = "";
	$GLOBALS['temp']['imgSort10Mode'] = "";
	$GLOBALS['temp']['imgSort11Mode'] = "";
	$GLOBALS['temp']['imgSort12Mode'] = "";

	$dbOrder = "ORDER BY ";

	switch ($sortBy) {
	case 0:
		$dbOrder .= "guest.pr_name_last,guest.pr_name_first";
		$GLOBALS['temp']['imgSort1Mode'] = "_z";
		break;
	case 1:
		$dbOrder .= "guest.pr_name_last DESC,guest.pr_name_first DESC";
		$GLOBALS['temp']['imgSort2Mode'] = "_z";
		break;
	case 2:
		$dbOrder .= "rv_reservation.rv_res_name";
		$GLOBALS['temp']['imgSort3Mode'] = "_z";
		break;
	case 3:
		$dbOrder .= "rv_reservation.rv_res_name DESC";
		$GLOBALS['temp']['imgSort4Mode'] = "_z";
		break;
	case 4:
		$dbOrder .= "property.pr_name_last";
		$GLOBALS['temp']['imgSort5Mode'] = "_z";
		break;
	case 5:
		$dbOrder .= "property.pr_name_last DESC";
		$GLOBALS['temp']['imgSort6Mode'] = "_z";
		break;
	case 6:
		$dbOrder .= "rv_reservation.rv_date_arrive DESC";
		$GLOBALS['temp']['imgSort7Mode'] = "_z";
		break;
	case 7:
		$dbOrder .= "rv_reservation.rv_date_arrive";
		$GLOBALS['temp']['imgSort8Mode'] = "_z";
		break;
	case 8:
		$dbOrder .= "rv_reservation.rv_date_depart DESC";
		$GLOBALS['temp']['imgSort9Mode'] = "_z";
		break;
	case 9:
		$dbOrder .= "rv_reservation.rv_date_depart";
		$GLOBALS['temp']['imgSort10Mode'] = "_z";
		break;
	}

	$options = $_SERVER['argv'][8];

	switch ($options & 7) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "";
		break;
	}

	$guestArray = $lDB->get("
		SELECT DISTINCT
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			property.pr_name_last,
			property.pr_persona_ix AS propertyId,
			accomm.ac_accomm_desc,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			pr_guest.pr_guest_id AS guestId,
			guest.pr_name_last AS guestLastName,
			guest.pr_name_first AS guestFirstName,
			rf_title.rf_title_desc AS title,
			guest.pr_email AS email,
			zg_transfer_guest.zg_trf_guest_status_ind AS status,
			zg_transfer_guest_prop.pr_business_id,
			pr_guest.pr_guest_primary_yn AS prime_guest 
		FROM
			rv_res_item_guest
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			INNER JOIN pr_persona AS property ON property.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN pr_persona AS guest ON guest.pr_persona_ix = rv_res_item_guest.pr_guest_id
			LEFT JOIN rf_title ON guest.pr_title_id = rf_title.rf_title_ix
			INNER JOIN ac_accomm_type AS accomm ON accomm.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN sc_accomm ON accomm.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
			LEFT JOIN zg_transfer_guest ON zg_transfer_guest.pr_guest_id = rv_res_item_guest.pr_guest_id 
				AND zg_transfer_guest.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN zg_transfer_guest_prop ON zg_transfer_guest.zg_transfer_guest_ix = zg_transfer_guest_prop.zg_transfer_guest_id AND zg_transfer_guest_prop.pr_business_id = rv_reservation_item.pr_business_id 
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id	
			$dbClause
			$dbOrder
	",2);
	
			
	$guestSuccess = array();
	$guestFailed = array();
	$guestNologged = array();
		
	$guestLen = count($guestArray);
	
	foreach($guestArray as $guest) {
		if($guest['status'] == "" ) {
			$guestNologged[$guest['rv_reservation_ix']][] = $guest['guestId'];
		} elseif($guest['status'] == DB_ZG_TRANSFER_GUEST_SUCCESS ) {
			$guestSuccess[$guest['rv_reservation_ix']][$guest['pr_business_id']][] = $guest['guestId'];
		} elseif($guest['status'] == DB_ZG_TRANSFER_GUEST_FAILED ) {
			$guestFailed[$guest['rv_reservation_ix']][$guest['pr_business_id']][] = $guest['guestId'];
		}
	}
	
	$accountArray = $lDB->get("
		SELECT DISTINCT
			zg_account.zg_account_ix,
			zg_account.zg_acc_name,
			zg_account_prop.pr_business_id
		FROM
			zg_account
			INNER JOIN zg_account_prop ON zg_account.zg_account_ix = zg_account_prop.zg_account_id
		WHERE
			zg_account.zg_account_inactive_yn !='1'
	",2);
	$propAccount = array();
	foreach($accountArray as $accnt) {
		$propAccount[$accnt['pr_business_id']] = $accnt['zg_acc_name'];
	}

	$includedGuests = array();

	if($renderMode == "html") {
		$out = "";
		$html = Join("\n",File(__DIR__ . "/../../../public/html/survey_find_row.htm"));
		
		foreach($guestArray as $guest) {
			if(!empty($guest['pr_business_id']) && ($guest['pr_business_id'] != $propId)) {
				continue;
			}
		
			if(in_array(DB_ZG_TRANSFER_GUEST_UNLOGGED,$statusList)) {
				if(
					(
						(
							isset($guestSuccess[$guest['rv_reservation_ix']][$propId])
							&&
							is_array($guestSuccess[$guest['rv_reservation_ix']][$propId]) 
							&& 
							in_array($guest['guestId'],$guestSuccess[$guest['rv_reservation_ix']][$propId])
						) || (
							isset($guestFailed[$guest['rv_reservation_ix']][$propId])
							&&
							is_array($guestFailed[$guest['rv_reservation_ix']][$propId]) 
							&& 
							in_array($guest['guestId'],$guestFailed[$guest['rv_reservation_ix']][$propId])
							)
					) 
					&& 
					$guest['status'] == ""
				)
					continue;
			}
			
			if(in_array(DB_ZG_TRANSFER_GUEST_FAILED,$statusList)) {
				if(
					(
						isset($guestSuccess[$guest['rv_reservation_ix']][$propId])
						&&
						is_array($guestSuccess[$guest['rv_reservation_ix']][$propId]) 
						&& 
						in_array($guest['guestId'],$guestSuccess[$guest['rv_reservation_ix']][$propId])
					) 
					&& 
					$guest['status'] == DB_ZG_TRANSFER_GUEST_FAILED
				)
					continue;
			}

			if(
				(
					!in_array(DB_ZG_TRANSFER_GUEST_FAILED,$statusList) 
					&& $guest['status'] == DB_ZG_TRANSFER_GUEST_FAILED
				) || (
					!in_array(DB_ZG_TRANSFER_GUEST_SUCCESS,$statusList) 
					&& 
					$guest['status'] == DB_ZG_TRANSFER_GUEST_SUCCESS
				)
			) {
				continue;
			}
			if(
				!empty($guest['status']) 
				&& 
				!checkPropEntry($guest['pr_business_id'], $guest['status'], $guest['guestId'], $guest['rv_reservation_ix'])
			) {
				if(
					is_array($guestSuccess[$guest['rv_reservation_ix']][$propId])
					&&
					in_array($guest['guestId'], $guestSuccess[$guest['rv_reservation_ix']][$propId])
				) {
					continue;
				}
				if(
					is_array($guestFailed[$guest['rv_reservation_ix']][$propId])
					&&
					in_array($guest['guestId'], $guestFailed[$guest['rv_reservation_ix']][$propId])
				) {
					continue;
				}
				$guest['status'] = "";
			}
			
			if(
				isset($includedGuests[$guest['rv_reservation_ix']][$propId])
				&&
				is_array($includedGuests[$guest['rv_reservation_ix']][$propId]) 
				&& in_array($guest['guestId'], $includedGuests[$guest['rv_reservation_ix']][$propId])
			) {
				continue;
			}

			$includedGuests[$guest['rv_reservation_ix']][$propId][] = $guest['guestId'];

			$onMouseOver = "";
			$onMouseOut = "";
			if($guest['email'] == "") {
				$onMouseOver = "overlib('Guest requires an email for survey batching')";
				$onMouseOut = "nd()";
			}
			if($guest['guestLastName'] == "") {
				$onMouseOver = "overlib('Guest requires a firstname and lastname for survey batching')";
				$onMouseOut = "nd()";
			}
			if($guest['guestFirstName'] == "") {
				$onMouseOver = "overlib('Guest requires a firstname and lastname for survey batching')";
				$onMouseOut = "nd()";
			}
			if(!in_array($guest['propertyId'], array_keys($propAccount))) {
				$onMouseOver = "overlib(' $guest[pr_name_last] does not belong to any active account')";
				$onMouseOut = "nd()";
			}
			if($guest['status'] == DB_ZG_TRANSFER_GUEST_SUCCESS) {
				$onMouseOver = "overlib('This guest is already surveyed')";
				$onMouseOut = "nd()";
			}
			if($guest['status'] == DB_ZG_TRANSFER_GUEST_FAILED) {
				$onMouseOver = "overlib('Use the Review Survey Batches report to resubmit failed records')";
				$onMouseOut = "nd()";
			}

			$guest['onMouseOver'] = $onMouseOver;
			$guest['onMouseOut'] = $onMouseOut;

			$guest['checkbox'] = "&nbsp;";
			$span = "txtg txtb";
			if(
				$guest['email'] != "" && $guest['guestFirstName'] != "" && $guest['guestLastName'] != "" 
				&& in_array($guest['propertyId'], array_keys($propAccount)) 
				&& $guest['status'] != DB_ZG_TRANSFER_GUEST_SUCCESS
				&& $guest['status'] != DB_ZG_TRANSFER_GUEST_FAILED
			) {
				$guest['checkbox'] = "<input type=\"checkbox\" account=\"".$propAccount[$guest['propertyId']]."\" onclick=\"accountCheckClick(this);\" name=\"guestCheck\" value=\"".$guest['guestId']."_".$guest['rv_reservation_ix']."\" />";
				$span = "txtb";
			}
			$guestName = $guest['guestFirstName']." ".$guest['guestLastName']." ".$guest['title'];
			if(strlen($guestName)>20) {
				$guestName = substr($guestName,0,20);
				$guestName .="....";
			}
			$guest['guestName'] = "<span class=\"".$span."\">".$guestName."</span>";
			if(!empty($guest['guestId'])) {
				$guest['guestImg'] = "<button onmouseout='nd()' align='right' style=\"width:20;height:20;\"  onmouseover=\"overlib('Show guest information',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130)\" class='button ' onclick='event.cancelBubble = true;editGuest(\"".$guest['guestId']."\")'><img src='/resource/Resrequest/Application/public/img/icon_contact_16.gif' valign='middle' class='imgLink'  ></button>";
			} else {
				$guest['guestImg'] = "";
			}
			$guest['primary'] = "&nbsp;";
			if($guest['prime_guest']) {
				$guest['primary'] = "<img src=\"/resource/Resrequest/Application/public/img/button_checked.gif\" border=\"0\">";
			}
			$guest['key'] = "<div style=\"background-color:green; width: 22px; height: 15px;\"></div>";
			if($guest['status'] == DB_ZG_TRANSFER_GUEST_SUCCESS) {
				$guest['key'] = "<div style=\"background-color:blue; width: 22px; height: 15px;\"></div>";
			}
			if($guest['status'] == DB_ZG_TRANSFER_GUEST_FAILED) {
				$guest['key'] = "<div style=\"background-color:red; width: 22px; height: 15px;\"></div>";
			}
			if(strlen($guest['rv_res_name']) > 15) {
				$guest['rv_res_name'] = substr($guest['rv_res_name'],0,15);
				$guest['rv_res_name'] .="...";
			}
			$guest['rv_item_date_arrive'] = chng_date($guest['rv_item_date_arrive'],"-");
			$guest['rv_item_date_depart'] = chng_date($guest['rv_item_date_depart'],"-");
			
			$out .= showpage($guest,$html);
		}
		
		$GLOBALS['temp']['rows'] = $out;

		$noresult = "
			<div style=\"text-align: left\">
				<p>&nbsp;&nbsp;Your search did not match any records.</p>
				<p>&nbsp;&nbsp;<b>Suggestions:</b><br />
				&nbsp;&nbsp;- Use wildcards to assist in your search<br />
				&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br />
				&nbsp;&nbsp;- Use a different keyword.</p>
			</div>
		";

		$defout = "
			<tr>
				<td colspan=\"4\" align=\"center\" class=\"txt\">" . $noresult . "</td>
			</tr>";

		$GLOBALS['temp']['hidePage'] = "";
		if($GLOBALS['temp']['rows'] == "") {
			$GLOBALS['temp']['rows'] = $defout;
			$GLOBALS['temp']['hidePage'] = "style=\"display: none;\"";
		}
		
		
		if(!empty($guestArray)) {
			$GLOBALS['temp']['runBatch'] = "<input onclick=\"runBatch();\" type=\"button\" style=\"height: 20px;margin-top:5px; text-align: center;\" class=\"button masterButton\" onmouseover=\"overlib('Contacts not selected will not be included in the batch')\" onmouseout=\"nd()\" value=\" Run batch interface\">";
		}
	}
}
$GLOBALS['temp']['sortby'] = $sortBy;
