<?php

/**
 *init.form390.func.php -- functions form request response xml
 */

require_once(__DIR__ . '/db.zg_transfer.php');
require_once(__DIR__ . '/db.zg_transfer_guest.php');
require_once(__DIR__ . "/functions.transfer.common.php");

function createSurveyRequestNew($guestData) { 
	$xml = Join("\n",File(__DIR__ . "/survey_process_row.xml"));
	$rows = "";	
	foreach($guestData as $val) {
		$arriveDate = explode("-",$val['rv_item_date_arrive']);
		$arriveDate = $arriveDate[1]."-".$arriveDate[2]."-".$arriveDate[0];
		$val['arriveDate'] = $arriveDate;
		foreach($val as $key=>$tempval) {
			$valNew[$key] = htmlentities($tempval);
		}
		$rows .= showpage($valNew,$xml);
	}
	
	return $rows; 
}

function xmlRequestProcess($data,$path="/bizapp/xmlapi/eguestsurv/",$server="www.divtech.co.za",$port="80") {
	$out = "POST http://$server:$port/$path HTTP/1.0\r\n" .
	'User-Agent: PHP' . "\r\n" .
	'Host: '. $server . ':' . $port . "\r\n" .
	'Content-Type: text/xml' . "\r\n" .
	'Content-Length: ' .strlen($data) . "\r\n\r\n" .
	$data;

	$fp=@fsockopen($server, $port);

	fputs($fp, $out, strlen($out));

	$in='';
	while($data=fread($fp, 32768)) {
		$in.=$data;
	}
	fclose($fp);
	$lines = explode("\n",$in);
	$status = explode(" ",$lines[0]);

	$line = array_shift($lines);
	while(trim($line) != "") {
		$line = array_shift($lines);
	} 

	return join("\n",$lines); 
}

function getResponseParse ($response) {
	$xml = xml_parser_create();
	xml_parse_into_struct($xml, $response, $vs);
	xml_parser_free($xml);
	$data = "";
	
	foreach($vs as $v){ 
		if($v['type'] == 'complete') {
			$v['value'] = isset($v['value']) ? $v['value'] : "NA";
			$resultarray[$v['tag']][] = $v['value'];
		}
	}
	
	return $resultarray;
}

function showSurveyProgress($message, $mode="0") {
	surveyBatchLogFile($message);
	$b1 = "";
	$b2 = "";
	if ($mode=="1") {
		$b1 = "<b>";
		$b2 = "</b>";
	}
	echo "<script>document.getElementById('displayDiv').innerHTML += '".addslashes($b1.$message.$b2)."<br>';document.getElementById('displayDiv').scrollTop = document.getElementById('displayDiv').scrollHeight;</script>\n";
	echo "<!--";
	for($a=0;$a<(3963-(strlen($message)));$a++) { echo "#"; }
	echo "-->\n";
	flush();
}

function hideProgressBar($message='') {
	surveyBatchLogFile($message);
	echo "<script>document.getElementById('divLoading').innerHTML = '$message';document.getElementById('bclose').style.display='block';document.getElementById('divLoading').className ='';document.getElementById('divLoading').style.margin= '0 0 0 105'</script>\n";
}

function surveyBatchLogFile($data) {
	$surveyBatchFilename = $GLOBALS['surveyBatchFilename'].".log";
	$newline = is_file($surveyBatchFilename) ? "\n" : "";
	$newline .= date("Y-m-d H:i:s")." - ";
	$logFile = @fopen($surveyBatchFilename,"a+");
	@fwrite($logFile,$newline.$data);
	@fclose($logFile);
}

function generateSurveyBatchFilename() {
	global $principal_id;
	global $dbcode;
	global $userid;

	// The second parameter is a placeholder for the transfer ID, which might be implemented in future
	$logFileName = $principal_id."_1_".str_replace(" ","_",str_replace(":","-",date("Y-m-d H:i:s")))."_".$dbcode."_".$userid;
	$logStash = getTransferDirDT37($logFileName,TRANSFER_DIR_SURVEY_BATCHES);
	$GLOBALS['surveyBatchFilename'] = $logStash.$logFileName;
}