<?php

/**
 * init.form390.php - Run Survey batch
 * Job: 346
 * Function: 115 (Guest Survey)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

generateSurveyBatchFilename();

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$_POST['selectedGuests'] = $_SERVER['argv'][1];
$_POST['selectedRes'] = $_SERVER['argv'][2];
$selectedProp = $_SERVER['argv'][3];
$referringBatch = $_SERVER['argv'][4];
if($referringBatch != "") {
	db_zg_transfer_update($referringBatch, DB_ZG_TRANSFER_RESENT, "This batch has already been resent.");
}

$_POST['selectedGuests'] = substr($_POST['selectedGuests'],0,-1);
$_POST['selectedRes'] = substr($_POST['selectedRes'],0,-1);
$guestArr = explode(":",$_POST['selectedGuests']);
$resArr = explode(":",$_POST['selectedRes']);

$openDateDisplay = date("d M Y G:i ");

$guestArray = $lDB->get("
	SELECT DISTINCT 
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.pr_business_id,
		rv_reservation_item.rv_reservation_id,
		rv_reservation_item.rv_item_nights,
		pr_guest.pr_guest_id AS guestId, 
		guest.pr_name_last AS guestLastName, 
		guest.pr_name_first AS guestFirstName, 
		guest.pr_email AS email,
		rf_country.rf_country_code,
		zg_account_prop.zg_acc_prop_code,
		zg_account.zg_acc_username,
		zg_account.zg_acc_password
	FROM 
		rv_res_item_guest
		INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id 
		INNER JOIN pr_persona AS guest ON guest.pr_persona_ix = rv_res_item_guest.pr_guest_id 
		INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		LEFT JOIN zg_account_prop ON zg_account_prop.pr_business_id = rv_reservation_item.pr_business_id 
		INNER JOIN zg_account ON zg_account_prop.zg_account_id = zg_account.zg_account_ix 
		LEFT JOIN rf_country ON guest.pr_phys_country_id = rf_country.rf_country_ix
	WHERE 
		rv_res_item_guest.pr_guest_id IN ('".join("','",$guestArr)."')
		AND rv_reservation.rv_reservation_ix IN ('".join("','",$resArr)."')
		AND zg_account_prop.pr_business_id = '$selectedProp'
		AND zg_account.zg_account_inactive_yn !=1
",2);

$guestidArray = array();
foreach($guestArray as $guest) {
	$guestidArray[$guest['guestId']] = $guest;
}
if(!empty($guestidArray)) {
	$zg_transfer_id = db_zg_transfer_insert('Transfer started to zg_transfer table');
} else {
	$zg_transfer_id = 0;
}

$dataArr['batchNo'] = $zg_transfer_id;
$dataArr['dateStart'] = $openDateDisplay;
$HTML = join("",file(__DIR__ . "/../../../public/html/survey_process.htm"));
$HTML = showpage($dataArr,$HTML);
echo $HTML;

showSurveyProgress('Survey started processing');
if(empty($guestidArray)) {
	showSurveyProgress("Sorry no corresponding account exists for the related properties. Please create account for the included properties.",1);
	hideProgressBar("Batch completed <b>with errors</b> ");
	echo "</body></html>";
	exit;
}

foreach ($guestidArray as $key=>$val) {
	$zg_transfer_guest_id = db_zg_transfer_guest_insert($zg_transfer_id, $val['guestId'], $val['pr_business_id'], $val['rv_reservation_id']);
	if($zg_transfer_guest_id) {
		$guestidArray [$key]['CUSTTRANSACTIONID'] = $zg_transfer_guest_id;
	}
}
$xmlSurvey = Join("\n",File(__DIR__ . "/survey_process.xml"));

$xmlSurveyRow = createSurveyRequestNew($guestidArray);
$xmlData['user_id'] = $guestArray[0]['zg_acc_username'];
$xmlData['password'] = $guestArray[0]['zg_acc_password'];
$xmlData['rows'] = $xmlSurveyRow;
$requestGuest = showpage($xmlData,$xmlSurvey);

showSurveyProgress('Connecting to Guest API....');

db_zg_transfer_set_request($zg_transfer_id, addslashes($requestGuest));
surveyBatchLogFile("Sending the following XML:");
surveyBatchLogFile($requestGuest);
$response = xmlRequestProcess($requestGuest);
surveyBatchLogFile("Received the following XML response:");
surveyBatchLogFile($response);

if(empty($response)) {
	foreach($guestidArray as $guest) {
		db_zg_transfer_guest_set_status($guest['CUSTTRANSACTIONID'], DB_ZG_TRANSFER_GUEST_FAILED);
	}
	showSurveyProgress(''.count($guestidArray).' guest survey failed due to integration setup or internet connectivity problems.  To re-submit, check integration settings and internet connections and then resend the batch.',1);
	hideProgressBar("Batch completed <b>with errors</b> ");
	db_zg_transfer_update($zg_transfer_id, DB_ZG_TRANSFER_FAILED, "Request not processed due to integration setup or internet connectivity problems.  To re-submit, check integration settings and internet connections and then resend the batch.");
	echo "</body></html>";
	exit;
}

db_zg_transfer_set_response($zg_transfer_id, addslashes($response));

showSurveyProgress($response);
showSurveyProgress('Request Xml sent to the API');
showSurveyProgress('Fetching response from Server');

$responseGuest = getResponseParse($response);
showSurveyProgress('Parsing Response Xml');

$guestCount = isset($responseGuest['CUSTID']) ? count($responseGuest['CUSTID']) : 0;
$failed = 0;
if($guestCount != 0) {
	for($i = 0;$i < $guestCount;$i++) {
		$status = DB_ZG_TRANSFER_GUEST_SUCCESS;
		if(strtolower($responseGuest['STATUS'][$i]) != "success") {
			$status = DB_ZG_TRANSFER_GUEST_FAILED;
			$failed ++;
		}
		db_zg_transfer_guest_set_status($responseGuest['CUSTTRANSACTIONID'][$i], $status);
	}

	$status = DB_ZG_TRANSFER_FAILED;
	if($failed == 0) {
		$log = "All guests are successfully surveyed.";
		$status = DB_ZG_TRANSFER_SUCCESS;
	} else {
		$log = "$failed guest survey failed due to integration setup or internet connectivity problems.  To re-submit, check integration settings and internet connections and then resend the batch.";
	}
} elseif(count($responseGuest['ERRORCODE'])) {
	$log = count($guestidArray)." guest survey failed due to <br/>".$responseGuest['ERRORCODE'][0]." : ".$responseGuest['ERRORMESSAGE'][0];
	$status = DB_ZG_TRANSFER_FAILED;
	foreach($guestidArray as $guest) {
		db_zg_transfer_guest_set_status($guest['CUSTTRANSACTIONID'], DB_ZG_TRANSFER_GUEST_FAILED);
	}
}
if($status == DB_ZG_TRANSFER_FAILED || ( isset($responseGuest['ERRORCODE']) && count($responseGuest['ERRORCODE']) > 0) ) {
	showSurveyProgress($log,1);
	$status = DB_ZG_TRANSFER_FAILED;
} else {
	showSurveyProgress($log);
}

db_zg_transfer_update($zg_transfer_id, $status, $log);

if($status == DB_ZG_TRANSFER_SUCCESS) {
	showSurveyProgress('Survey integration successfully completed', 1);
	hideProgressBar("Batch <b>successfully</b> completed");
} else {
	showSurveyProgress('Survey integration complete with errors', 1);
	hideProgressBar("Batch completed <b>with errors</b> ");
}

echo "</body></html>";
