<?php

/**
 * init.form391.php - Review Survey batch
 * Job: 347
 * Function: 115 (Review Survey batches)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/survey_review.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$dbClause = "";
$dbOrder = "";
$printString = "";
$pString = "";
$out = "";

$sortBy = "1";

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

if(trim($_SERVER['argv'][4]) != "") {
	$sortBy = $_SERVER['argv'][4];
}

$page = "1";
if($_SERVER['argv'][3] > "1") {
	$page = $_SERVER['argv'][3];
}

$GLOBALS['temp']['pgNum'] = (string) $page;

$GLOBALS['temp']['hideAll'] = "0";
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "") {
	$GLOBALS['temp']['hideAll'] = "1";
}

$pLimit = "10";
$limit = "35";

if($_SERVER['argv'][1] != "" || $_SERVER['argv'][2] != "") {
	$minDate = $_SERVER['argv'][1];
	$maxDate = $_SERVER['argv'][2];
} else {
	$minDate = date("Y-m-d",time());
	$maxDate = date("Y-m-d",time());
}
if($_SERVER['argv'][2] != "") {
	$maxDate = $_SERVER['argv'][2];
}

$splitMinDate = useDate("minDate", $minDate);
$splitMaxDate = useDate("maxDate", $maxDate);

$GLOBALS['temp']['splitMinDate'] = $splitMinDate['jsDate'];

if(trim($maxDate) != "") {
	$GLOBALS['temp']['splitMaxDate'] = $splitMaxDate['jsDate'];
}

$GLOBALS['temp']['printMinDate'] = $splitMinDate['htmlDate'];
$GLOBALS['temp']['printMaxDate'] = $splitMaxDate['htmlDate'];
$dateExtra = "";
if ( $minDate != "") {
	$minDate .= " 00:00:00";
	$dateExtra .= "AND (zg_transfer.zg_trf_date_close >= '" . $minDate . "')";
}

if ( $maxDate !="") {
	$maxDate .= " 23:59:59";
	$dateExtra .= "AND (zg_transfer.zg_trf_date_close <= '" . $maxDate . "')";
}

$filterStatus = $_SERVER['argv'][5];
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);

if ( $filterStatus == "" ) {
	$GLOBALS['temp']['filterStatus'] = "expand";
}

$dbClause = " WHERE  zg_transfer.zg_trf_status_ind != 0  ". $dateExtra;

if($_SERVER['argv'][1] != "" && $_SERVER['argv'][2] != "") {
	$total = $lDB->get("SELECT COUNT(DISTINCT zg_transfer.zg_transfer_ix) FROM zg_transfer	$dbClause",4);
	$realCount = (string) $total / $limit;
	$erg = explode(".",$realCount);
	$pCount = (int) $realCount;

	if(isset($erg[1]) && $erg[1] != "") {
		$pCount += "1";
	}

	if($pLimit > $pCount) {
		$pLimit = $pCount;
	}

	$pStart = $page - (int) ($pLimit/2);
	--$page;
	if($pStart < "1") {
		$pStart = "1";
	}

	if($pStart > $pCount) {
		$pStart = $pCount;
	}

	$pEnd = $pStart+$pLimit;

	if($pEnd > $pCount) {
		$pEnd = $pCount+1;
	}
	if($page > $pEnd) {
		$page = $pEnd-1;
	}
	$start = $page * $limit;

	$GLOBALS['temp']['imgSort1']	= "";
	$GLOBALS['temp']['imgSort2']	= "";

	$GLOBALS['temp']['imgSort1Mode']	= "";
	$GLOBALS['temp']['imgSort2Mode']	= "";

	$dbOrder = "ORDER BY ";

	switch($sortBy) {
	case 0:
		$dbOrder .= "zg_transfer.zg_trf_date_close";
		$GLOBALS['temp']['imgSort1Mode'] = "_z";
		break;
	case 1:
		$dbOrder .= "zg_transfer.zg_trf_date_close DESC";
		$GLOBALS['temp']['imgSort2Mode'] = "_z";
		break;
	}

	$options = $_SERVER['argv'][6];

	switch($options & 7) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "";
		break;
	}

	$dbLimit = "LIMIT ".$start.", ".$limit;

	$printString .= '<a class="txt"> of ' . $pCount . ' page(s)</a>';
	$pString = '<a class="txtbr">Pages:</a> ';

	if($pStart > "1") {
		$pString .= '<a href="#" onclick="ShowFrom(1);" class="txtbr">First</a>, ';
	}

	for($i = $pStart; $i < $pEnd; $i++) {
		if($i != $pStart) {
			$pString .= ", ";
		}
		$pString .= "<a class=\"txtbr\"";
		if($i != $page + 1) {
			$pString .= " href=\"javascript:ShowFrom(" . $i . ");\"";
		}
		$pString .= ">" . $i . "</a>";
	}

	if($pEnd < $pCount) {
		$pString .= "<a class=\"txtbr\">...</a> <a href=\"#\" onclick=\"javascript:ShowFrom(" . $pCount . ");\" class=\"txtbr\">Last</a>";
	}
	$pString .= "<a class=\"txtbr\"> of " . $pCount . " page(s)</a>";

	$GLOBALS['temp']['hideNext'] = "";
	$GLOBALS['temp']['hidePrev'] = "";
	$pNext = $page + 2;
	$pPrev = $page;
	$GLOBALS['temp']['pNext'] = (string) $pNext;
	$GLOBALS['temp']['pPrev'] = (string) $pPrev;

	if($page + 2 > $pCount) {
		$GLOBALS['temp']['hideNext'] = " style=\"visibility: hidden;\"";
	}

	if($page < "1") {
		$GLOBALS['temp']['hidePrev'] = " style=\"visibility: hidden;\"";
	}

	$batchArray = $lDB->get("
		SELECT 
			zg_transfer.zg_transfer_ix,
			zg_transfer.zg_trf_date_close,
			zg_transfer.zg_trf_status_ind,
			zg_transfer.zg_trf_log
		FROM
			zg_transfer
			$dbClause
			$dbOrder
			$dbLimit
	",2);

			
	if($renderMode == "html") {
		$html = Join("\n",File(__DIR__ . "/../../../public/html/survey_review_row.htm"));
		$i = 0;
		foreach($batchArray as $batch) {
			$batch['zg_trf_date_close'] = date("d M Y G:i ",strtotime($batch['zg_trf_date_close']));
			$guestArray = $lDB->get("
				SELECT 
					zg_transfer_guest.zg_trf_guest_status_ind,
					zg_transfer_guest.pr_guest_id,
					zg_transfer_guest.rv_reservation_id,
					zg_transfer_guest_prop.pr_business_id
				FROM
					zg_transfer_guest
					LEFT JOIN zg_transfer_guest_prop ON zg_transfer_guest.zg_transfer_guest_ix = zg_transfer_guest_prop.zg_transfer_guest_id
				WHERE
					zg_transfer_guest.zg_transfer_id = '$batch[zg_transfer_ix]'
			",2);
			$fail = "0";
			$resend = "&nbsp;";
			$log = "&nbsp;";
			$batch['success'] = "&nbsp;";
			$batch['fail'] = "&nbsp;";
			
			if(!empty($guestArray)) {
				$totalGuest = count($guestArray);
				$selectedGuests = "";
				$selectedRes = "";
				$selectedProp = $guestArray[0]['pr_business_id'];
				foreach($guestArray as $guest) {
					if($guest['zg_trf_guest_status_ind'] == DB_ZG_TRANSFER_FAILED) {
						$fail++;
						$selectedGuests .= $guest['pr_guest_id'] . ":";
						$selectedRes .= $guest['rv_reservation_id'] . ":";
					}
				}
				$success = $totalGuest - $fail;
			}
			if($success > 0) {
				$batch['success'] = "<div style=\"background-color:blue; width:100%; height:19px; float:left; text-align:center;  font-weight:bold; border-bottom:1px solid #fff\">".$success."</div>";
			}
			if($fail > 0) {
				$batch['fail'] = "<div style=\"background-color:#ff0000; width:100%; height:19px; float:left; display:inline; text-align:center;  font-weight:bold; border-bottom:1px solid #fff\">".$fail."</div>";
			}
			
			if($fail > 0) {
				if($batch['zg_trf_status_ind'] == DB_ZG_TRANSFER_FAILED) {
					$resend = "<form action=\"reservation.php?346\" style=\"margin:0px; padding:0px;\"  method=\"post\"><input type=\"hidden\" name=\"selectedguests\" id=\"selectedguests".$i."\" value=\"$selectedGuests\" />";
					$resend .= "<input type=\"hidden\" name=\"selectedres\" id=\"selectedres".$i."\" value=\"$selectedRes\" />";
					$resend .= "<input type=\"hidden\" name=\"propertiesExtraIds\" id=\"propertiesExtraIds".$i."\" value=\"$selectedProp\" />";
					$resend .= "<input type=\"hidden\" name=\"currentBatch\" id=\"currentBatch".$i."\" value=\"$batch[zg_transfer_ix]\" />";
					$resend .= "<div id=\"resendDiv".$i."\"><input type=\"button\" class=\"button\" onclick='event.cancelBubble = true;processBatch(\"".$i."\");hideResend(\"".$i."\");' name=\"resend\" value=\"Resend batch\" /></div></form>";
				}
				$log = "<img src='/resource/Resrequest/Application/public/img/button_alert_msg.gif' align=\"center\" valign=\"middle\" onmouseover=\"overlib('".$batch['zg_trf_log']."',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130)\"  onmouseout=\"nd()\" onclick='event.cancelBubble = true;technicalAlert(\"".$batch['zg_trf_log']."\")'  >";
			}
			$batch['log'] = $log;
			$batch['action'] = $resend;
			$out .= showpage($batch,$html);
			$i++;
		}
		$GLOBALS['temp']['rows'] = $out;
		$noresult = "
			<div style=\"text-align: left\">
				<p>&nbsp;&nbsp;Your search did not match any records.</p>
				<p>&nbsp;&nbsp;<b>Suggestions:</b><br />
				&nbsp;&nbsp;- Use wildcards to assist in your search<br />
				&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br />
				&nbsp;&nbsp;- Use a different keyword.</p>
			</div>
		";

		$defout = "
			<tr>
				<td colspan=\"4\" align=\"center\" class=\"txt\">" . $noresult . "</td>
			</tr>
		";

		$GLOBALS['temp']['hidePage'] = "";
		if($GLOBALS['temp']['rows'] == "") {
			$GLOBALS['temp']['rows'] = $defout;
			$GLOBALS['temp']['hidePage'] = "style=\"display: none;\"";
		}

	}
}

$GLOBALS['temp']['ofnum'] = $printString;
$GLOBALS['temp']['nextprev'] = $pString;
$GLOBALS['temp']['limited'] = isset($total) ? (string) $total : "";
$GLOBALS['temp']['sortby'] = isset($sortBy) ? $sortBy : "";
