<?php
/*
 * $Id: init.form393.func.php,v 1.3 2011-05-17 14:08:33 light Exp $
 *
 * $Log: init.form393.func.php,v $
 * Revision 1.3  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.2  2011-05-11 12:05:17  light
 * Bug #7542 - Public availability calendar: Send documentation
 *
 * Revision 1.1  2009-05-02 09:36:02  light
 * Bug #6299 - Extras extended: extra supplier notified from reservation
 *
 */

/**
 * init.form393.func.php - Required file inclusion here
 * Job: 349
 * 
 */

require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');

function relatedEmailAddress($reservationId, $personaId) {
	if($GLOBALS['userStatusId'] < 2) {
		return array();
	}
	$personaArray = array();
	$lookup = $GLOBALS['lDB']->get("
			SELECT
				fn_folio.fn_folio_to_id,
				rv_billing_persona_id,
				rv_corr_persona_id,
				rv_agent_id,
				rv_consultant_id,
				rv_invoice_persona_id
			FROM
				fn_folio 
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",1);
	foreach($lookup as $item) {
		if (trim($item) != "" && $item != "0") {
			array_push($personaArray, $item);

			$linked = $GLOBALS['lDB']->get("
				SELECT
					pr_link.pr_link_from
				FROM
					pr_link
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				WHERE
					pr_link.pr_link_to = '$item'
					AND pr_link.rf_link_type_id = 'RS2'
					AND pr_sys_code != '9'
				ORDER BY
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
			",3);
			if(sizeof($linked) > 0) {
				$personaArray = array_merge($personaArray,$linked);
			}
		}
	}
	array_splice($personaArray, count($personaArray), 0, $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
		WHERE
			rf_link_type_id = 'RS1'
			AND pr_persona.pr_persona_inactive_yn = '0'
			AND pr_sys_code != '9'
	",3));
	array_push($personaArray,$GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default",4));
	array_push($personaArray, $GLOBALS['userid']);
	array_splice($personaArray, sizeof($personaArray), 0, getUsers(getAgent($GLOBALS['userid'])));
	$personaArray = array_unique($personaArray);
	$emailArray = array();
	if(!in_array($personaId, $personaArray)) {
		array_unshift($personaArray, $personaId);
	}
	foreach($personaArray as $id) {
		if ($id != "0") {
			if (getContactEmail($id) != "") {
				array_push($emailArray, array(email => getContactEmail($id), name => escapeName(getContactName($id)), id => $id));
			}
		}
	}

	$firstItem = array_shift($emailArray);
	usort($emailArray,"relatedEmailSort");
	array_unshift($emailArray,$firstItem);
	return $emailArray;
}

function getUsers($agentId) {
	$userArray = $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
		WHERE
			pr_link_to = '$agentId'
			AND rf_link_type_id = 'RS2'
	",3);
	if (sizeof($userArray) > 0) {
		return $userArray;
	}
	return "0";
}

function relatedEmailSort($a, $b) {
	return strcasecmp($a['name'], $b['name']);
}

function getContactEmail($personaId) {
	global $lDB;

	$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($email) == "" || $email == "0") {
		$personaId = getLinkedPersona($personaId);
		$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($email) == "" || $email == "0") {
			return "";
		} else {
			return $email;
		}
	} else {
		return $email;
	}
}

function getContactName($personaId) {
	global $lDB;
	
	$nameArray = $lDB->get("
		SELECT
			pr_name_first,
			pr_name_second,
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$personaId'
	",1);
	$name = $nameArray['pr_name_last'];
	if (trim($nameArray['pr_name_second']) != "" && $nameArray['pr_name_second'] != "0") {
		$name = $nameArray['pr_name_second'] . " " . $name;
	}
	if (trim($nameArray['pr_name_first']) != "" && $nameArray['pr_name_first'] != "0") {
		$name = $nameArray['pr_name_first'] . " " . $name;
	}
	
	$link = $lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE
			pr_link.pr_link_from = '$personaId'
			AND pr_link.rf_link_type_id IN ('RS1','RS2')
	",4);
	if($link != "0" && trim($link) != "") {
		$name .= " (".$link.")";
	}
	
	if($lDB->get("SELECT rf_res_office_id FROM rf_default",4) == $personaId) {
		$name .= " (Res Office)";
	}
	return $name;
}

function getContactURL($personaId) {
	global $lDB;

	$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if (trim($url) == "" || $url == "0") {
		$personaId = getLinkedPersona($personaId);
		$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($url) == "" || $url == "0") {
			return "";
		} else {
			return $url;
		}
	} else {
		return $url;
	}
}

function getContactFax($personaId) {
	global $lDB;
	
	$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
	if (trim($faxNumber) == "" || $faxNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
		if (trim($faxNumber) == "" || $faxNumber == "0") {
			return "";
		} else {
			return $faxNumber;
		}
	} else {
		return $faxNumber;
	}
}

function getContactTelephone($personaId) {
	global $lDB;

	$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND pr_default_yn = 1", 4);
	if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '".$personaId."' AND pr_default_yn = 1", 4);
		if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
			return "";
		} else {
			return $telephoneNumber;
		}
	} else {
		return $telephoneNumber;
	}
}

function getLinkedPersona($personaId) {
	$linkId = $GLOBALS['lDB']->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($linkId) != "" && $linkId != "0") {
		return $linkId;
	} else {
		return $personaId;
	}
}
