<?php

/*
 * $Id: init.form394.php,v 1.11 2012-10-15 15:46:22 light Exp $
 *
 * $Log: init.form394.php,v $
 * Revision 1.11  2012-10-15 15:46:22  light
 * Bug #7974 - AVAIL & ROOMING CAL (Gym: Red)
 *
 * Revision 1.10  2011-05-30 11:42:42  light
 * Bug #7605 - [HOTFIX needed] Duplicate contacts dont differentiate inactive records
 *
 * Revision 1.9  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.8  2009-10-20 09:36:02  light
 * Bug #6990 - {Branched from 5.1.2 Bug #6966 } RES: Wizard - Duplicate Contacts
 *
 * Revision 1.7  2009-06-29 18:09:51  light
 * Bug #6807 - Duplicate contacts
 *
 * Revision 1.6  2009-06-23 14:11:36  light
 * Bug #6659 - Repeat guests
 *
 * Revision 1.5  2009-06-22 20:25:31  light
 * Bug #6659 - Repeat guests
 *
 * Revision 1.4  2009-05-04 15:49:25  light
 * Bug #6659 - Repeat guests
 *
 * Revision 1.3  2009-04-28 15:08:28  light
 * Bug #6659 - Repeat guests
 *
 * Revision 1.2  2009-04-28 15:04:50  light
 * Bug #6659 - Repeat guests
 *
 * Revision 1.1  2009-04-28 14:53:06  light
 * Bug #6659 - Repeat guests
 */

/**
 * init.form394.php - Duplicate contact check / popup
 * Job: 350
 * Function: 66 (General access)
 */

if($GLOBALS['userStatusId'] < "2") {
	die("Access denied");
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/contact_check.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$mode = $_SERVER['argv'][1];
$firstName = trim(rawurldecode($_SERVER['argv'][2]));
$lastName = trim(rawurldecode($_SERVER['argv'][3]));
$checkDuplicateGuestId = rawurldecode($_SERVER['argv'][5]);
$checkDuplicateGroupId = rawurldecode($_SERVER['argv'][6]);
$action = $_SERVER['argv'][4];

$config = $GLOBALS['lDB']->get("
	SELECT
		rf_persona_check_yn,
		rf_persona_first_yn,
		rf_persona_first_soundex_yn,
		rf_persona_first_exact_yn,
		rf_persona_first_match_yn,
		rf_persona_first_match_limit,
		rf_persona_last_yn,
		rf_persona_last_soundex_yn,
		rf_persona_last_exact_yn,
		rf_persona_last_match_yn,
		rf_persona_last_match_limit
	FROM
		rf_default
",1);

$sqlFirstNameArray = array();
if($config['rf_persona_first_yn'] == "1" && !empty($firstName)) {
	if($config['rf_persona_first_exact_yn'] == "1") {
		array_push($sqlFirstNameArray,"pr_persona.pr_name_first = '".addslashes($firstName)."'");
	}
	if($config['rf_persona_first_match_yn'] == "1") {
		array_push($sqlFirstNameArray,"pr_persona.pr_name_first LIKE '".substr(addslashes($firstName),0,$config['rf_persona_first_match_limit'])."%'");
	}
	if($config['rf_persona_first_soundex_yn'] == "1") {
		array_push($sqlFirstNameArray,"SOUNDEX(pr_persona.pr_name_first) = SOUNDEX('".addslashes($firstName)."')");
	}
}

$sqlLastNameArray = array();
if($config['rf_persona_last_yn'] == "1" && !empty($lastName)) {
	if($config['rf_persona_last_exact_yn'] == "1") {
		array_push($sqlLastNameArray,"pr_persona.pr_name_last = '".addslashes($lastName)."'");
	}
	if($config['rf_persona_last_match_yn'] == "1") {
		array_push($sqlLastNameArray,"pr_persona.pr_name_last LIKE '".substr(addslashes($lastName),0,$config['rf_persona_last_match_limit'])."%'");
	}
	if($config['rf_persona_last_soundex_yn'] == "1") {
		array_push($sqlLastNameArray,"SOUNDEX(pr_persona.pr_name_last) = SOUNDEX('".addslashes($lastName)."')");
	}
}

$sqlFirstName = trim(join(" OR ",$sqlFirstNameArray));
$sqlLastName = trim(join(" OR ",$sqlLastNameArray));
if($sqlFirstName != "" && $sqlLastName != "") {
	$sqlWhere = "($sqlFirstName) OR ($sqlLastName)";
} elseif($sqlFirstName != "" && $sqlLastName == "") {
	$sqlWhere = "($sqlFirstName)";
} elseif($sqlFirstName == "" && $sqlLastName != "") {
	$sqlWhere = "($sqlLastName)";
} elseif($sqlFirstName == "" && $sqlLastName == "") {
	$sqlWhere = "1";
}


if($mode == 1) {
	if($config['rf_persona_check_yn'] == 0 || $sqlWhere == "") {
		Respond();
	}
	$check = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			pr_persona
		WHERE
			$sqlWhere
	",4);
	if($check == 0) {
		Respond();
	} else {
		Respond(true);
	}
}

$selectContactCode = "";
switch($action) {
case "persona_pop":
	$GLOBALS['temp']['newContactCode'] = "opener.addContactFinalise();";
	$selectContactCode = "opener.selectContactFinalise('!pr_name_last_js!','!pr_name_first_js!','!pr_persona_ix!','!pr_email_js!','!pr_fax_js!','!pr_phone_number_js!','!pr_corr_addr_line1_js!','!pr_corr_addr_line2_js!','!pr_corr_post_code_js!','!linked!','!pr_phys_adder_line1_js!','!pr_phys_addr_line2_js!','!pr_phys_post_code_js!');";
	break;
case "contact_add":
	$GLOBALS['temp']['newContactCode'] = "opener.addContactFinalise();";
	$selectContactCode = "opener.selectContactFinalise('!pr_persona_ix!');";
	break;
case "rooming_add":
	$GLOBALS['temp']['newContactCode'] = "window.close();";
	$selectContactCode = "opener.selectContactFinalise('!pr_persona_ix!');";
	break;
case "user_add":
	$GLOBALS['temp']['newContactCode'] = "opener.addContactFinalise();";
	$selectContactCode = "opener.selectContactFinalise('!pr_persona_ix!');";
	break;
case "wizard_add":
	$GLOBALS['temp']['newContactCode'] = "window.close();";
	$selectContactCode = "opener.selectContactFinalise('!pr_persona_ix!','$checkDuplicateGuestId','$checkDuplicateGroupId');";
	break;
}

$list = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_email,
		pr_persona.pr_corr_addr_line1,
		pr_persona.pr_corr_addr_line2,
		pr_persona.pr_corr_post_code,
		pr_persona.pr_phys_addr_line1,
		pr_persona.pr_phys_addr_line2,
		pr_persona.pr_phys_post_code,
		pr_persona.pr_persona_link_id,
		rf_name_suffix.rf_suffix_desc,
		rf_title.rf_title_desc,
		pr_persona.pr_persona_inactive_yn
	FROM
		pr_persona
		LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
		LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
	WHERE
		$sqlWhere
	ORDER BY
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		pr_persona.pr_persona_inactive_yn
",2);

$html = "
	<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\" onmouseout=\"this.style.backgroundColor = '#FFFFFF'\" onclick=\"$selectContactCode; window.close();\">
		<td><div class=\"br !inactiveClass!\" style=\"width: 99px; height: 20px; overflow: hidden;\"><span class=\"!inactiveClass!\" style=\"white-space: nowrap;\">&nbsp;!pr_name_last!</span></div></td>
		<td><div class=\"br !inactiveClass!\" style=\"width: 99px; height: 20px; overflow: hidden;\"><span class=\"!inactiveClass!\" style=\"white-space: nowrap;\">&nbsp;!pr_name_first!</span></div></td>
		<td><div class=\"br !inactiveClass!\" style=\"width: 99px; height: 20px; overflow: hidden;\"><span class=\"!inactiveClass!\" style=\"white-space: nowrap;\">&nbsp;!pr_email!</span></div></td>
		<td><div class=\"br !inactiveClass!\" style=\"width: 99px; height: 20px; overflow: hidden;\"><span class=\"!inactiveClass!\" style=\"white-space: nowrap;\">&nbsp;!pr_phone_number!</span></div></td>
		<td align=\"center\"><div class=\"br !inactiveClass!\" style=\"height: 20px;\">!is_agent!</div></td>
		<td align=\"center\"><div class=\"br !inactiveClass!\" style=\"height: 20px;\">!is_guest!</div></td>
		<td align=\"center\"><div class=\"br !inactiveClass!\" style=\"height: 20px;\">!is_user!</div></td>
		<td align=\"center\" height=\"20\" onclick=\"event.cancelBubble = true;\" class=\"br !inactiveClass!\">
			<input type=\"button\" class=\"button bAgent\" style=\"width: 20px; height: 20px; background-position: center;\" onclick=\"!detail_click!\" />
		</td>
		<td class=\"!inactiveClass!\">
			<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />
		</td>
	</tr>
	";
$rows = "";

foreach($list as $item) {
	$item['linked'] = "0";
	$linkCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_persona WHERE pr_persona_ix = '$item[pr_persona_link_id]'",4);
	if($linkCheck > 0) {
		$linkedAddress = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_corr_addr_line1,
				pr_persona.pr_corr_addr_line2,
				pr_persona.pr_corr_post_code,
				pr_persona.pr_phys_addr_line1,
				pr_persona.pr_phys_addr_line2,
				pr_persona.pr_phys_post_code
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$item[pr_persona_link_id]'
		",1);
		$item['linked'] = "1";
		$item['pr_corr_addr_line1'] = $linkedAddress['pr_corr_addr_line1'];
		$item['pr_corr_addr_line2'] = $linkedAddress['pr_corr_addr_line2'];
		$item['pr_corr_post_code'] = $linkedAddress['pr_corr_post_code'];
		$item['pr_phys_addr_line1'] = $linkedAddress['pr_phys_addr_line1'];
		$item['pr_phys_addr_line2'] = $linkedAddress['pr_phys_addr_line2'];
		$item['pr_phys_post_code'] = $linkedAddress['pr_phys_post_code'];
	}
	$telephone = trim($GLOBALS['lDB']->get("
		SELECT
			pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$item[pr_persona_ix]'
		ORDER BY
			pr_default_yn DESC
	",4));
	if(empty($telephone)) {
		$telephone = "&nbsp;";
	}
	$item['pr_phone_number'] = $telephone;
	$agentCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$item[pr_persona_ix]'",4);
	if($agentCheck > 0) {
		$item['is_agent'] = "x";
	} else {
		$item['is_agent'] = "&nbsp;";
	}
	$guestCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_guest WHERE pr_guest_id = '$item[pr_persona_ix]'",4);
	if($guestCheck > 0) {
		$item['is_guest'] = "x";
	} else {
		$item['is_guest'] = "&nbsp;";
	}
	$userCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_user WHERE pr_user_id = '$item[pr_persona_ix]'",4);
	if($userCheck > 0) {
		$item['is_user'] = "x";
	} else {
		$item['is_user'] = "&nbsp;";
	}

	//$item['detail_click'] = "openDetails('!pr_persona_ix!','!pr_name_first_js!','!pr_name_last_js!','!rf_title_desc_js!','!rf_suffix_desc_js!');";
	$item['detail_click'] = "openPopup('reservation.php?682+$item[pr_persona_ix]',400,300);";


	$item['pr_name_last_js'] = t_encodeOverlib($item['pr_name_last']);
	$item['pr_name_first_js'] = t_encodeOverlib($item['pr_name_first']);
	$item['pr_email_js'] = t_encodeOverlib($item['pr_email']);
	$item['pr_phone_number_js'] = t_encodeOverlib($item['pr_phone_number']);
	$item['pr_corr_addr_line1_js'] = t_encodeOverlib($item['pr_corr_addr_line1']);
	$item['pr_corr_addr_line2_js'] = t_encodeOverlib($item['pr_corr_addr_line2']);
	$item['pr_corr_post_code_js'] = t_encodeOverlib($item['pr_corr_post_code']);
	$item['pr_phys_addr_line1_js'] = t_encodeOverlib($item['pr_phys_addr_line1']);
	$item['pr_phys_addr_line2_js'] = t_encodeOverlib($item['pr_phys_addr_line2']);
	$item['pr_phys_post_code_js'] = t_encodeOverlib($item['pr_phys_post_code']);
	$item['rf_title_desc_js'] = t_encodeOverlib($item['rf_title_desc']);
	$item['rf_suffix_desc_js'] = t_encodeOverlib($item['rf_suffix_desc']);

	$item['inactiveClass'] = "";
	if($item['pr_persona_inactive_yn'] == "1") {
		$item['inactiveClass'] = "txti colGry";
	}

	$rows .= showpage($item,$html);
}
if($rows != "") {
	$rows .= "
		<tr>
			<td colspan=\"9\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" height=\"1\"/></td>
		</tr>
	";
	$GLOBALS['temp']['rows'] = $rows;
} else {
	$GLOBALS['temp']['rows'] = "
		<tr>
			<td colspan=\"8\">No results found</td>
		</tr>
	";
}


function Respond($success=false,$debug=false) {
	if($debug !== false) {
		echo $debug;
		die();
	}

	if($success) {
		echo "1";
	} else {
		echo "0";
	}
	die();
}
