<?php

/**
 * init.form395.func.php - Including required files here
 */

require_once(__DIR__ . '/db.rf_default.php');

require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.mail.php');
require_once(__DIR__ . '/functions.financial.php');
require_once(__DIR__ . '/functions.property.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . '/functions.files.php');
require_once ('class.xls.php');
require_once(__DIR__ . "/functions.templates.php");

function getReservationExtra($reservationId){
	$resData = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation.rv_agent_id,
			pr_persona.pr_name_first as agent_name_first,
			pr_persona.pr_name_last as agent_name_last
		FROM
			rv_reservation
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rv_reservation_ix = '$reservationId'
	",1);
	
	$resData['rv_date_arrive'] = chng_date($resData['rv_date_arrive'],"-");
	$resData['rv_date_depart'] = chng_date($resData['rv_date_depart'],"-");
	$resData['agent'] = trim($resData['agent_name_first']." ".$resData['agent_name_last']);
	if(trim($resData['agent']) == "") {
		$resData['agent'] = "Direct";
	}
	return $resData;
}

function getDateRange($result) {
	$minDate = strtotime($result['rv_date_arrive']);
	$maxDate = strtotime($result['rv_date_depart']);
	foreach($result['resItems'] as $accom) {
		if(strtotime($accom['rv_item_date_arrive']) < $minDate) {
			$minDate = strtotime($accom['rv_item_date_arrive']);
		}
		if(strtotime($accom['rv_item_date_depart']) > $maxDate) {
			$maxDate = strtotime($accom['rv_item_date_depart']);
		}
	}
	
	foreach($result['resExtras'] as $extra) {
		if($extra['rv_extra_ind'] == '3') { 
			if($extra['rv_extra_nights'] == 0) {
				$extra['rv_extra_nights'] = 1;
			}
			$servDateEnd = strtotime($extra['rv_extra_date_depart']);
			$servDateStart = strtotime($extra['rv_extra_date_serv']);
			if($servDateStart < $minDate) {
				$minDate = $servDateStart;
			}
			if($servDateEnd > $maxDate) {
				$maxDate = $servDateEnd;
			}
			continue;
		}
		if(strtotime($extra['rv_extra_date_serv']) < $minDate) { 
			$minDate = strtotime($extra['rv_extra_date_serv']);
		}
		if(strtotime($extra['rv_extra_date_serv']) > $maxDate) { 
			$maxDate = strtotime($extra['rv_extra_date_serv']);
		}
	}
	$dateRange['minDate'] = $minDate;
	$dateRange['maxDate'] = $maxDate;
	return $dateRange;
}

function getMinMaxTravDate($result) {
	$result['resExtras'] = array_merge($result['resTravel'],$result['actExtras'],$result['resExtras'],$result['accomExtras']);
	$dateRange = getDateRange($result);
	$dateRange['maxDate'] = date(" j M Y",$dateRange['maxDate']);
	$dateRange['minDate'] = date(" j M Y",$dateRange['minDate']);
	return $dateRange;
}

function getDayItenaryDetails($result) {
	$dayItenaryDetails = array();
	$result['resExtras'] = array_merge($result['resTravel'],$result['actExtras'],$result['resExtras'],$result['accomExtras']);
	
	$dateRange = getDateRange($result);
	$itenaryTypeArr = array("General","Activity","Travel","Accommodation");
	$resDuration = ($dateRange['maxDate'] - $dateRange['minDate'])/86400;
	
	for($i=0;$i<=$resDuration;$i++) {
		$dayStamp = $dateRange['minDate']+(86400*$i);
		$dayItenaryDetails[$i]['doc_itenary_date'] = "Day ".($i+1)."<br/>".date(" D",$dayStamp).date(" j M Y",$dayStamp);
		$j = 0;
				
		foreach($result['resExtras'] as $extra) {
			$accomExtra = false;
			$accomPropCode = '';
			$accomPropCode = getPropertyCode($extra['pr_business_id']);
			if($accomPropCode != "") {
				$accomPropCode = " (".$accomPropCode.")";
			}
			$servDateEnd = strtotime($extra['rv_extra_date_depart']);
			$servDateStart = strtotime($extra['rv_extra_date_serv']);
            if ($extra['ac_extra_cat_ind'] == "3") {
                $accomExtra = true;
            }
            if (
                (
                    // Not accomm extra, and falls on current day
                    strtotime($extra['rv_extra_date_serv']) == $dayStamp &&
                    $extra['rv_extra_ind'] != '3'
                ) || (
                    // Is accomm extra, and current day falls within it's date range
                    $accomExtra &&
                    $dayStamp >= $servDateStart &&
                    $dayStamp < $servDateEnd
                )
            ) {
				$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_type'] = $itenaryTypeArr[$extra['rv_extra_ind']];
				$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] = $extra['ac_ext_desc'].$accomPropCode;
				if (
					($extra['rv_extra_ind'] == 2) 
					&& 
					(trim($extra['rv_extra_travel_eta']) != "" || trim($extra['rv_extra_travel_etd']) != "")
				) {
					$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] .= " (";
					if(trim($extra['rv_extra_travel_etd']) != "") {
						$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] .= "ETD ".$extra['rv_extra_travel_etd'];
					}
					if(trim($extra['rv_extra_travel_eta']) != "" && trim($extra['rv_extra_travel_etd']) != "") {
						$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] .= "/";
					}
					if(trim($extra['rv_extra_travel_eta']) != "") {
						$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] .= "ETA ".$extra['rv_extra_travel_eta'];
					}
					$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] .= ")";
				}
				$j++;
				$dayItenaryDetails[$i]['units'][] = $extra['rv_extra_units'];
				$dayItenaryDetails[$i]['rt_rate_type_desc'][] = "";
				
				if($accomExtra) {
					if($extra['total'] != "TBA" && $extra['rv_extra_nights'] != 0) {
						$extra['total'] = $extra['total'] / $extra['rv_extra_nights'] ;
					} 
					
					$pax = "";
					if($extra['rv_extra_adult_count']) {
						$pax .= $extra['rv_extra_adult_count']."A";
					}
					if($extra['rv_extra_child_count']) {
						if(!empty($pax)) {
							$pax .= "/";
						}
						$pax .= $extra['rv_extra_child_count']."C";
					}
					$dayItenaryDetails[$i]['pax'][] = $pax;
				} else {
					$dayItenaryDetails[$i]['pax'][] = "";
				}
				
				if($extra['total'] != "" && $extra['total'] != "TBA") {
					fixAmtDisplay($extra['total']);
					//$extra['total'] .= $extra['rf_currency_symbol'];
				}
				$dayItenaryDetails[$i]['compAmt'][] = $extra['total'];
			}
		}

		foreach($result['resItems'] as $accom) {
			$arriveStamp = strtotime($accom['rv_item_date_arrive']);
			$departStamp = strtotime($accom['rv_item_date_depart']);
			if($dayStamp >= $arriveStamp && $dayStamp < $departStamp) {
				$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_type'] = "Accommodation";
				$dayItenaryDetails[$i]['itenaryItem'][$j]['itenary_desc'] = $accom['pr_name_last']." - ".$accom['ac_accomm_desc'].getSeparateComponents($accom['rv_reservation_item_ix']);
				$j++;
				$dayItenaryDetails[$i]['units'][] = $accom['rv_item_accomm_count'];
				$pax = "";
				if($accom['rv_item_adult_count']) {
					$pax .= $accom['rv_item_adult_count']."A";
				}
				if($accom['rv_item_child_count']) {
					if(!empty($pax)) {
						$pax .= "/";
					}
					$pax .= $accom['rv_item_child_count']."C";
				}
				$dayItenaryDetails[$i]['pax'][] = $pax;
				$dayItenaryDetails[$i]['rt_rate_type_desc'][] = $accom['rt_rate_type_desc'];
				if($accom['compAmt'] != "TBA") {
					$amnt = $accom['compAmt']/$accom['noNights'];
				} else {
					$amnt = $accom['compAmt'];
				}
				
				if(($amnt != "" && $amnt != "TBA") || ($amnt == 0)) {
					fixAmtDisplay($amnt);
					$amnt .= $accom['rf_currency_symbol'];
				}
				$dayItenaryDetails[$i]['compAmt'][] = $amnt;
			}
		}
	}
	for($i=0;$i<=$resDuration;$i++) {
		if(empty($dayItenaryDetails[$i]['itenaryItem'])) {
			$dayItenaryDetails[$i]['itenaryItem'][0]['itenary_type'] = "";
			$dayItenaryDetails[$i]['itenaryItem'][0]['itenary_desc'] = "Own arrangements";
		}
	}
	return $dayItenaryDetails;
}

function getPropertyCode($pr_business_id) {
	if(empty($pr_business_id)) return false;
	return $GLOBALS['lDB']->get("
		SELECT
			pr_business.pr_bus_name_short
		FROM
			pr_business
		WHERE
			pr_business_id = '".$pr_business_id."'
	",4);
}

function getSeparateComponents($rv_reservation_item_id) {
	$includes = "";
	$optionsList = $GLOBALS['lDB']->get("
		SELECT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
			LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
			rv_reservation_item_id = '".$rv_reservation_item_id."'
			AND rv_item_comp_separate_yn = '1'
		ORDER BY rt_component.rt_component_abbrv
	",3);
	if (sizeof($optionsList > 0)) {
		$listI = join(", ",$optionsList);
		if (trim($listI) != "," && trim($listI) != "") {
			$includes .= "<br/>Includes: ".$listI;
		}
	}
}
function getMemoNoteDetails($result, $formatting = true) {
	$extraMemo = "";	
	$extraNote = "";
	$itenaryTypeArr = array("General","Activity","Travel","Accommodation");
	$result['resExtras'] = array_merge($result['resExtras'], $result['actExtras'], $result['accomExtras'], $result['resTravel']);
	$mergedExtra = array();
	foreach($result['resExtras'] as $extra) {
		$mergedExtra[strtotime($extra['rv_extra_date_serv'])][] = $extra;
	}
	ksort($mergedExtra);
	foreach($mergedExtra as $resExtra) {
		foreach($resExtra as $item) {
			if(isset($item['rv_res_item_group_ix'])) {
				// Only guests that are linked to the group and have a group set (i.e. are not orphaned)
				$guestList = $GLOBALS['lDB']->get("
					SELECT
						pr_persona.pr_name_first,
						pr_persona.pr_name_last
					FROM
						rv_res_item_guest
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					WHERE
						rv_res_item_guest.rv_res_item_group_id = '$item[rv_res_item_group_ix]'
				",2);
			}
			else {
				// We don't want to pull any guests
				$guestList = [];
			}
			$roomInfo = trim($item['ac_desc']);
			$guestNames = "";
			foreach($guestList as $guestItem) {
				if($guestNames != "") {
					$guestNames .= ", ";
				}
				$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
			}
			if($roomInfo != "" && $guestNames != "") {
				$roomInfo .= ": ";
			}
			if($guestNames != "") {
				$roomInfo .= $guestNames;
			}
			if($roomInfo != "") {
				if($formatting == true) {
					$roomInfo = "[$roomInfo]<br>";
				} else {
					$roomInfo = "[$roomInfo]\n";
				}
			}
			$extraDate = chng_date($item['rv_extra_date_serv'], "-");
			if (trim($extraDate) == "" || $extraDate == "0") {
				$extraDate = "";
			} else {
				if($item['rv_extra_ind'] == '3') {
					$extraDate .= " to ".chng_date($item['rv_extra_date_depart'], "-");
				}
				if($formatting == true) {
					$extraDate = $extraDate;
				}
			}
			
			if(trim($item['rv_extra_note']) != "" && $item['rv_extra_note'] != "0") {
				if($formatting == true) {
					$extraNote .= "
						$extraDate <u>$item[pr_name_last]</u> : $item[ac_ext_desc] ($item[ac_extra_cat_desc]) 
						$roomInfo   - ".t_encodeHTML($item['rv_extra_note'])."<br><br>
					";
				} else {
					$extraNote .= "\n$extraDate $item[pr_name_last]: $item[ac_ext_desc] ($item[ac_extra_cat_desc])$roomInfo  - $item[rv_extra_note]\n";
				}
			}
			
			if(trim($item['rv_extra_note_internal']) != "" && $item['rv_extra_note_internal'] != "0") {
				if($formatting == true) {
					$extraMemo .= "
						$extraDate <u>$item[pr_name_last]</u> : $item[ac_ext_desc] ($item[ac_extra_cat_desc])
						$roomInfo -".t_encodeHTML($item['rv_extra_note_internal'])."<br><br>
					";
				} else {
					$extraMemo .= "\n$extraDate $item[pr_name_last]: $item[ac_ext_desc] ($item[ac_extra_cat_desc])$roomInfo - $item[rv_extra_note_internal]\n";
				}
			}
		}
	}
	$extraMemoNote['extraMemo'] = $extraMemo;
	$extraMemoNote['extraNote'] = $extraNote;
	return $extraMemoNote;
}

function getReservationMemo($reservationId) {
	$memo = $GLOBALS['lDB']->get("SELECT rv_note_internal FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'",4);
	if (trim($memo) == "" || $memo == "0"){
		return "FALSE";
	} else {
		return $memo;
	}
}

function outputCSV($result, $toggleMap, $repName, $proformaNote, $customNotesList) {
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();
	$repName = str_replace(" ","",$repName);
	$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$borderL2 = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '2');
	$borderR2 = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '2');
	$borderT2 = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '2');
	$borderB2 = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '2');

	$defaultStyle = array( 
		'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
		'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
		'font' => array('Size' => '8')
	);
	
	$xls = new XLS($defaultStyle);
	$xls->Column(120);
	$xls->Column(60);
	$xls->Column(120);
	$xls->Column(40);
	$xls->Column(40);
	$xls->Column(80);

	$styleBold = array('font' => array('Bold' => '1'));
	$borderBStyle	= array("border" => array($borderB));

	$borderLRTStyle = array("border" => array($borderL, $borderR, $borderT));
	$borderLTStyle2	= array("border" => array($borderL2, $borderT2));
	$borderTRStyle2	= array("border" => array($borderT2, $borderR2));
	$borderTBStyle2	= array("border" => array($borderB2, $borderT2));
	$borderTStyle2C	= array(
		"border" => array($borderT2),"alignment" =>array("Horizontal" => "Center", "Vertical" => "Top", "WrapText" => "1")
	);
	$borderBStyle2 = array("border" => array($borderB2));
	$borderLStyle2R	= array(
		"border" => array($borderL2),"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1")
	);
	$borderRStyle2	= array("border" => array($borderR2));
	$borderLBRStyle2 = array("border" => array($borderL2, $borderB2, $borderR2));

	$bold = $xls->addStyle($styleBold);
	$borderBStyleId = $xls->addStyle($borderBStyle);
	$borderBStyleIdBold = $xls->addStyle(array_merge($borderBStyle, $styleBold));
	$borderTBStyleId2 = $xls->addStyle($borderTBStyle2);
	$borderTBStyleId2Bold = $xls->addStyle(array_merge($borderTBStyle2, $styleBold));
	$borderLTStyleId2 = $xls->addStyle($borderLTStyle2);
	$borderLTStyleId2Bold = $xls->addStyle(array_merge($borderLTStyle2, $styleBold));
	$borderTRStyleId2 = $xls->addStyle($borderTRStyle2);
	$borderTRStyleId2Bold = $xls->addStyle(array_merge($borderTRStyle2, $styleBold));
	$borderTStyleId2C = $xls->addStyle($borderTStyle2C);
	$borderTStyleId2CBold = $xls->addStyle(array_merge($borderTStyle2C, $styleBold));
	$borderLStyleId2R = $xls->addStyle($borderLStyle2R);
	$borderLStyleId2RBold = $xls->addStyle(array_merge($borderLStyle2R, $styleBold));
	$borderRStyleId2 = $xls->addStyle($borderRStyle2);
	$borderRStyleId2Bold = $xls->addStyle(array_merge($borderRStyle2, $styleBold));
	$borderLBRStyleId2 = $xls->addStyle($borderLBRStyle2);
	$borderLBRStyleId2Bold = $xls->addStyle(array_merge($borderLBRStyle2, $styleBold));

	$header_style = array( 
		"interior" => array("Color" => "#f7f2d9", "Pattern"=>"Solid"),
		"border" => array($borderL, $borderR, $borderT, $borderB)
	);
					
	$header_styleId = $xls->addStyle($header_style);
	$header_styleIdBold = $xls->addStyle(array_merge($header_style, $styleBold));

	$extraNoteMemo = getMemoNoteDetails($result,false);
	
	$extraNote = $extraNoteMemo['extraNote'];
	$extraMemo = $extraNoteMemo['extraMemo'];
	
	$rows = array();
	$bg_style = array( 
		"interior" => array("Pattern"=>"Solid")
	);
		
	$bg_styleId = $xls->addStyle($bg_style);
	$bg_styleIdBold = $xls->addStyle(array_merge($bg_style, $styleBold));
	$styleC = array( 
		"alignment" =>array("Horizontal" => "Center", "Vertical" => "Top", "WrapText" => "1")
	);
	$styleCId = $xls->addStyle($styleC);
	$styleCIdBold = $xls->addStyle(array_merge($styleC, $styleBold));
	$styleR = array( 
		"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1")
	);

	$styleRId = $xls->addStyle($styleR);
	$styleRIdBold = $xls->addStyle(array_merge($styleR, $styleBold));
	$cell = $xls->Cell(array("type"=>"String", "data" => "Reservation Office:"), $bg_styleIdBold);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));
	$tempCell = array();
	$addressArr = explode("\n",$result['fromAddress']);
	$regInfo = array();
	foreach($result['billingInfo'] as $item) {
		$regInfo[] = "$item[pr_name_last]";
		if(trim($item['pr_bus_statutory_1']) != "" && $item['pr_bus_statutory_1'] != "0") {
			$pr_bus_statutory_1_label = $item['pr_bus_statutory_label_1'] != "" ? $item['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
			$regInfo[] = $pr_bus_statutory_1_label.": $item[pr_bus_statutory_1]";
		}
		if(trim($item['pr_bus_statutory_2']) != "" && $item['pr_bus_statutory_2'] != "0") {
			$pr_bus_statutory_2_label = $item['pr_bus_statutory_label_2'] != "" ? $item['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
			$regInfo[] = $pr_bus_statutory_2_label.": $item[pr_bus_statutory_2]";
		}
		if(trim($item['pr_bus_statutory_3']) != "" && $item['pr_bus_statutory_3'] != "0") {
			$pr_bus_statutory_3_label = $item['pr_bus_statutory_label_3'] != "" ? $item['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
			$regInfo[] = $pr_bus_statutory_3_label.": $item[pr_bus_statutory_3]";
		}
	}
	$bigger = count($addressArr) > count($regInfo) ? count($addressArr) : count($regInfo);
	for($i=0;$i<$bigger;$i++) {
		$tempCell = array();
		if(!empty($addressArr[$i])) {
			$cell = $xls->Cell(array("type"=>"String", "data" => $addressArr[$i]));
		} else {
			$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		}
		array_push($tempCell,$cell);
		if($i == 0) {
			$cell = $xls->Cell(array("type"=>"String", "data" => $_SESSION['principal_name']),$styleCIdBold,"","","","",2);
		} else {
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),"","","","","",2);
		}
		array_push($tempCell,$cell);
		if(!empty($regInfo[$i])) {
			$cell = $xls->Cell(array("type"=>"String", "data" => $regInfo[$i]),$styleRId,"","","","",1);
		} else {
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),"","","","","",1);
		}
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
	}
	
	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => ""), $borderLTStyleId2);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" =>$result['docTitle'].$result['docRef'].""), $borderTStyleId2CBold,"","","","",3);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => ""), $borderTRStyleId2);
	array_push($tempCell, $cell);
	array_push($rows,$xls->Row($tempCell));
	
	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => "Reservation:"), $borderLStyleId2RBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['rv_res_name']), "","","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Travel Start Date: "), $bold,"","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['minDate']), $borderRStyleId2);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => "Reservation #:"), $borderLStyleId2RBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['rv_reservation_id']), "","","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Travel Depart Date: "), $bold,"","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['maxDate']), $borderRStyleId2);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => "Agent:"), $borderLStyleId2RBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['agent']), "","","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Created On: "), $bold,"","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['rv_date_recorded']), $borderRStyleId2);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => "Status:"), $borderLStyleId2RBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['rf_reservation_status_desc']), "","","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Last Updated: "), $bold,"","","","",1);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => $result['rv_date_changed']), $borderRStyleId2);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => ""), $borderLBRStyleId2,"","","","",5);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));
	
	$togglePlan = ($toggleMap & 1) == 1;
	$toggleRate = ($toggleMap & 2) == 2;
	$toggleReservationNote = ($toggleMap & 4) == 4;
	$toggleReservationMemo = ($toggleMap & 8) == 8;
	$toggleBankDetails = ($toggleMap & 16) == 16;
	$toggleGuestInformation = ($toggleMap & 32) == 32;
	$toggleCommission = ($toggleMap & 64) == 64;
	$toggleExtraNote = ($toggleMap & 128) == 128;
	$toggleExchNote = ($toggleMap & 256) == 256;
	$togglePropertyNoteCheck = ($toggleMap & 512) == 512;
	$toggleInternalMemoCheck = ($toggleMap & 1024) == 1024;
	
	$toggleCostSummary = ($toggleMap & 2048) == 2048;
	$toggleCancelPay = ($toggleMap & 4096) == 4096;
	$toggleTotal = ($toggleMap & 8192) == 8192;
	
	$toggleBookingTerms = ($toggleMap & 16384) == 16384;
	$togglePayReceipts = ($toggleMap & 32768) == 32768;
	$toggleTotalItem = ($toggleMap & 65536) == 65536;
	$toggleGross = ($toggleMap & 131072) == 131072;
	$togglePlanInv = ($toggleMap & 262144) == 262144;
	
	$dayItenaryDetails = getDayItenaryDetails($result);

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => ""),"","","","","",5);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));
	$styleGrey = array( 
		"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#C0C0C0", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderL, $borderB, $borderT)
	);
	$styleGreyId = $xls->addStyle($styleGrey);
	$styleGreyIdBold = $xls->addStyle(array_merge($styleGrey, $styleBold));

	$styleGreyR = array( 
		"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#C0C0C0", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderL, $borderB, $borderT)
	);
	$styleGreyIdR = $xls->addStyle($styleGreyR);
	$styleGreyIdRBold = $xls->addStyle(array_merge($styleGreyR, $styleBold));

	$styleWr = array( 
		"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#FFFFFF", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderL, $borderB, $borderT)
	);
	$styleWrId = $xls->addStyle($styleWr);
	$styleWrIdBold = $xls->addStyle(array_merge($styleWr, $styleBold));

	$styleWl = array( 
		"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#FFFFFF", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderL, $borderB, $borderT)
	);
	$styleWlId = $xls->addStyle($styleWl);
	$styleWlIdBold = $xls->addStyle(array_merge($styleWl, $styleBold));
	
	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => "Day/Date"), $styleGreyIdBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Itinerary"), $styleGreyIdBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => ""), $styleGreyId);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Units"), $styleGreyIdBold);
	array_push($tempCell,$cell);
	$cell = $xls->Cell(array("type"=>"String", "data" => "Pax/Unit"), $styleGreyIdBold);
	array_push($tempCell,$cell);
	if($toggleTotal) {
		$cell = $xls->Cell(array("type"=>"String", "data" => "Total"), $styleGreyIdRBold);
		array_push($tempCell,$cell);
	}
	if($toggleRate) {
		$cell = $xls->Cell(array("type"=>"String", "data" => "Rate Type"), $styleGreyIdBold);
		array_push($tempCell,$cell);
	}
	array_push($rows,$xls->Row($tempCell));
	
	foreach($dayItenaryDetails as $item) {
		$len = count($item['itenaryItem']) ? count($item['itenaryItem']):1;
		for($i = 0; $i < $len; $i++) {
			$tempCell = array();
			if($i==0) {
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['doc_itenary_date']), $styleWlId);
			} else {
				$cell = $xls->Cell(array("type"=>"String", "data" => ""), $styleWlId);
			}
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $item['itenaryItem'][$i]['itenary_type']), $styleWlId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $item['itenaryItem'][$i]['itenary_desc']), $styleWlId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => isset($item['units'][$i])?$item['units'][$i]:""), $styleWlId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => isset($item['pax'][$i])?$item['pax'][$i]:""), $styleWlId);
			array_push($tempCell,$cell);
			if($toggleTotal) {
				$cell = $xls->Cell(array("type"=>"String", "data" => isset($item['compAmt'][$i])?$item['compAmt'][$i]:""), $styleWrId);
				array_push($tempCell,$cell);
			}
			if($toggleRate) {
				$cell = $xls->Cell(array("type"=>"String", "data" => isset($item['rt_rate_type_desc'][$i])?$item['rt_rate_type_desc'][$i]:""), $styleWlId);
				array_push($tempCell,$cell);
			}
			array_push($rows,$xls->Row($tempCell));
		}
	}
	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => ""),"","","","","",5);
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));
	
	$styleT = array( 
		"interior" => array("Color" => "#F8E8BB", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderB)
	);
					
	$styleTId = $xls->addStyle($header_style);
	$styleTIdBold = $xls->addStyle(array_merge($header_style, $styleBold));

	$style = array( 
		"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderL, $borderB, $borderT)
	);
	$styleId = $xls->addStyle($style);
	$styleIdBold = $xls->addStyle(array_merge($style, $styleBold));

	$stylel = array( 
		"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderL, $borderB, $borderT)
	);
	$stylelId = $xls->addStyle($stylel);
	$stylelIdBold = $xls->addStyle(array_merge($stylel, $styleBold));

	$styleRt = array( 
		"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => "1"),
		"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
		"border" => array($borderR, $borderT)
	);
	$styleRtId = $xls->addStyle($styleRt);
	$styleRtIdBold = $xls->addStyle(array_merge($styleRt, $styleBold));

	$tempCell = array();
	if($toggleCostSummary) {
		$cell = $xls->Cell(array("type"=>"String", "data" => "Totals"),$styleTId,"","","","",5);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		$tempCell = array();
		if($toggleGross) {
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),$styleId,"","","","",3);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Gross"),$styleId);
			array_push($tempCell,$cell);
		} elseif($toggleCommission) {
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),$styleId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Gross"),$styleId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Commission"),$styleId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Nett"),$styleId,"","","","",1);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Due to Supplier"),$styleId);
			array_push($tempCell,$cell);
			
		} else {
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),$styleId,"","","","",3);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Due to Supplier"),$styleId);
			array_push($tempCell,$cell);
		}
		array_push($rows,$xls->Row($tempCell));
		
		if($toggleTotalItem) {
			if($result['compTotals']['Accommodation'][0] != "") {
				$tempCell = array();
				if($toggleGross) {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Accommodation"),$styleWlId,"","","","",3);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['acc_gross']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				} elseif ($toggleCommission) {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Accommodation"),$styleWlId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['acc_gross']),$styleWrId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['acc_comm']),$styleWrId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['acc_net']),$styleWrId,"","","","",1);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['acc_invoice']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				} else {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Accommodation"),$styleWlId,"","","","",3);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['acc_invoice']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				}
				array_push($rows,$xls->Row($tempCell));
			}
			if(isset($result['compTotals']['Extras'][0]) && $result['compTotals']['Extras'][0] != "") {
				$tempCell = array();
				if($toggleGross) {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Extras"),$styleWlId,"","","","",3);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['ext_gross']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				} elseif($toggleCommission) {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Extras"),$styleWlId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['ext_gross']),$styleWrId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['ext_comm']),$styleWrId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['ext_net']),$styleWrId,"","","","",1);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['ext_invoice']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				} else {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Extras"),$styleWlId,"","","","",3);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['ext_invoice']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				}
				array_push($rows,$xls->Row($tempCell));
			}
			if(isset($result['compTotals']['Travel'][0]) && $result['compTotals']['Travel'][0] != "") {
				$tempCell = array();
				if($toggleGross) {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Travel"),$styleWlId,"","","","",3);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['tra_gross']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				} elseif($toggleCommission) {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Travel"),$styleWlId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['tra_gross']." ".$result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['tra_comm']." ".$result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['tra_net']." ".$result['rf_currency_symbol']),$styleWrId,"","","","",1);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['tra_invoice']. " " . $result['rf_currency_symbol']." ".$result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				} else {
					$cell = $xls->Cell(array("type"=>"String", "data" => "Travel"),$styleWlId,"","","","",3);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $result['tra_invoice']. " " . $result['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
				}
				array_push($rows,$xls->Row($tempCell));
			}
		}

		$tempCell = array();
		if($toggleGross) {
			$cell = $xls->Cell(array("type"=>"String", "data" => "Total"),$stylelId,"","","","",3);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['total_gross']. " " . $result['rf_currency_symbol']),$styleWrId);
			array_push($tempCell,$cell);
		} elseif ($toggleCommission) {
			$cell = $xls->Cell(array("type"=>"String", "data" => "Total"),$stylelId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['total_gross']." ".$result['rf_currency_symbol']),$styleWrId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['total_comm']." ".$result['rf_currency_symbol']),$styleWrId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['total_net']." ".$result['rf_currency_symbol']),$styleWrId,"","","","",1);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['total_invoice']." ".$result['rf_currency_symbol']),$styleWrId);
			array_push($tempCell,$cell);
		} else {
			$cell = $xls->Cell(array("type"=>"String", "data" => "Total"),$stylelId,"","","","",3);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['total_invoice']." ".$result['rf_currency_symbol']),$styleWrId);
			array_push($tempCell,$cell);
		}
		
		array_push($rows,$xls->Row($tempCell));
		$tempCell = array();
	}
	
	if ($togglePlan) {
		$tempCell = array();
		if(sizeof($result['resItems']) > 0) {
			$cell = $xls->Cell(array("type"=>"String", "data" => "Payment Plan"),$bold,"","","","",5);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => "Payments according to the following schedule should be made:"),"","","","","",5);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => "Plan"),$styleTId,"","","","",5);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
			if(!$togglePlanInv) {
				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => "Date Due"),$stylelId,"","","","",4);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => "Amount"),$styleId);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));
				foreach($result['payItems'] as $item) {
					$tempCell = array();
					$cell = $xls->Cell(array("type"=>"String", "data" => $item['pay_date']),$styleWlId,"","","","",4);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $item['rv_pay_plan_amount']." ".$item['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
					array_push($rows,$xls->Row($tempCell));
				}
			} else {
				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => "Date Due"),$stylelId,"","","","",1);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => "Invoicing Unit"),$stylelId,"","","","",2);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => "Amount"),$styleId);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));
				foreach($result['payInvItems'] as $item) {
					$tempCell = array();
					$cell = $xls->Cell(array("type"=>"String", "data" => $item['pay_date']),$styleWlId,"","","","",1);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $item['pr_name']),$styleWlId,"","","","",2);
					array_push($tempCell,$cell);
					$cell = $xls->Cell(array("type"=>"String", "data" => $item['rv_pay_plan_amount']." ".$item['rf_currency_symbol']),$styleWrId);
					array_push($tempCell,$cell);
					array_push($rows,$xls->Row($tempCell));
				}
			}
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => $item['pay_date']),$styleTId,"","","","",5);
			array_push($rows,$xls->Row($tempCell));
			
		}
		if($toggleCancelPay) {
			$payedItems = $result['payedItems2'];
		} else {
			$payedItems = $result['payedItems'];
		}
	}

	if($togglePayReceipts) {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Receipts"),$bold,"","","","",2);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
				
		if(isset($payedItems) && sizeof($payedItems) != 0) {
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => "Payment Date"),$stylelId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Payer"),$stylelId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Method"),$stylelId);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Folio/Invoice"),$stylelId,"","","","",1);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => "Amount"),$styleId);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
			foreach($payedItems as $item) {
				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['pay_date']),$stylelId);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['pr_name_last']),$styleWlId);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['rf_mthd_pmnt_desc']),$styleWlId);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['fn_folio_folio_num'].(($item['fn_invoice_ix'])?"/":"").$item['fn_invoice_ix']),$styleWlId,"","","","",1);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['rv_payment_item_amt'] . " " . $item['invCurrSym']),$styleWrId);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));
			}
		}
		$styleNt = array( 
			"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => "1"),
			"interior" => array("Color" => "#FCF3DA", "Pattern"=>"Solid"),
			"border" => array($borderR, $borderL, $borderB)
		);
		$styleNtId = $xls->addStyle($styleNt);
		$styleNtIdBold = $xls->addStyle(array_merge($styleNt, $styleBold));

		$styleNtwr = array( 
			"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1"),
			"interior" => array("Color" => "#FFFFFF", "Pattern"=>"Solid"),
			"border" => array($borderR, $borderL, $borderB)
		);
		$styleNtrId = $xls->addStyle($styleNtwr);
		$styleNtrIdBold = $xls->addStyle(array_merge($styleNtwr, $styleBold));

		$styleLtbrwr = array( 
			"alignment" =>array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => "1"),
			"interior" => array("Color" => "#FFFFFF", "Pattern"=>"Solid"),
			"border" => array($borderR, $borderL, $borderB, $borderT)
		);
		$styleLtbrwrId = $xls->addStyle($styleLtbrwr);
		$styleLtbrwrIdBold = $xls->addStyle(array_merge($styleLtbrwr, $styleBold));

		$styleLtbrwl = array( 
			"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => "1"),
			"interior" => array("Color" => "#FFFFFF", "Pattern"=>"Solid"),
			"border" => array($borderR, $borderL, $borderB, $borderT)
		);
		$styleLtbrwlId = $xls->addStyle($styleLtbrwl);
		$styleLtbrwlIdBold = $xls->addStyle(array_merge($styleLtbrwl, $styleBold));

		$styleLtbrwc = array( 
			"alignment" =>array("Horizontal" => "Center", "Vertical" => "Top", "WrapText" => "1"),
			"interior" => array("Color" => "#FFFFFF", "Pattern"=>"Solid"),
			"border" => array($borderR, $borderL, $borderB, $borderT)
		);
		$styleLtbrwcId = $xls->addStyle($styleLtbrwc);
		$styleLtbrwcIdBold = $xls->addStyle(array_merge($styleLtbrwc, $styleBold));

		if($result['currencyCheck'] <= 1) {
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),"","","","","",2);
			array_push($tempCell,$cell);

			$cell = $xls->Cell(array("type"=>"String", "data" => "Total amount paid to date"),$styleNtId,"","","","",1);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['payedTotal']." ".$result['rf_currency_symbol']),$styleNtrId);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));

			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => ""),"","","","","",2);
			array_push($tempCell,$cell);

			$cell = $xls->Cell(array("type"=>"String", "data" => "Total amount still due"),$styleNtId,"","","","",1);
			array_push($tempCell,$cell);
			$cell = $xls->Cell(array("type"=>"String", "data" => $result['payOutstanding']." ".$result['rf_currency_symbol']),$styleNtrId);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
		}
		
	}

	if($toggleBankDetails) {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Bank Details"),$bold,"","","","",2);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		if(sizeof($result['bankInfo'])>0) {
			foreach($result['bankInfo'] as $item) {
				$bankDet = str_replace("<br>","\n",$item['rf_bank_detail_1']);
				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => "Acc Name: ".$item['rf_bank_acc_name'] . " (" . $item['rf_currency_name'] . ")"),"","","","","",4);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));

				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => "Acc No: ".$item['rf_bank_acc_no'] ),"","","","","",4);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));

				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => "Detail: ".$item['rf_bank_name']. " - " .$bankDet ),"","","","","",4);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));
			}
		} else {
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => "No Bank Details"),"","","","","",4);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
		}
	}

	if ($toggleExchNote) {
		
		$tempCell = array();
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Exchange Rate"),$bold,"","","","",5);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => $result['exchange']['note']),"","","","","",5);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Charge"),$styleNtId);
		array_push($tempCell,$cell);

		$cell = $xls->Cell(array("type"=>"String", "data" => "Currency Conversion"),$styleNtId);
		array_push($tempCell,$cell);

		$cell = $xls->Cell(array("type"=>"String", "data" => "Rate"),$styleNtId);
		array_push($tempCell,$cell);

		$cell = $xls->Cell(array("type"=>"String", "data" => "Expiry Date"),$styleNtId);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		if(sizeof($result['exchange']['extras'])>0){
			
			foreach($result['exchange']['extras'] as $item) {
				$tempCell = array();
								
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['ac_ext_desc']),$styleLtbrwlId);
				array_push($tempCell,$cell);
				$cell = $xls->Cell(array("type"=>"String", "data" => $item['curr_conversion']),$styleLtbrwlId);
				array_push($tempCell,$cell);

				$cell = $xls->Cell(array("type"=>"String", "data" => $item['rv_extra_exch_rate']),$styleLtbrwrId);
				array_push($tempCell,$cell);

				$cell = $xls->Cell(array("type"=>"String", "data" => $item['exch_expiry']),$styleLtbrwcId);
				array_push($tempCell,$cell);

				array_push($rows,$xls->Row($tempCell));
			}
			
		} else {
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => "No exchange rates"),$borderBStyleId,"","","","",3);
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
		}
	}

	if ($toggleReservationNote && trim($result['resNote']) != "") {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Reservation Notes"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$xls->Column(120,0);
		$tempCell = array();
		$result['resNote'] = $result['resNote'];
		$cell = $xls->Cell(array("type"=>"String", "data" => $result['resNote']));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
	}
	
	if ($toggleReservationMemo && trim($result['resMemo']) != "") {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Internal Memos"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$xls->Column(120,0);
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => $result['resMemo']));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
	}
	
	if ($toggleGuestInformation && trim($result['resGuestNote']) != "") {
		$xls->Column(120,0);
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Guest Information"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$xls->Column(120,0);
		$tempCell = array();
		
		$result['resGuestNote'] = $result['resGuestNote'];
		$cell = $xls->Cell(array("type"=>"String", "data" => $result['resGuestNote']));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
	}
	
	if($toggleExtraNote && (trim($extraNote) != "" )) {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Extras Notes"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		$extraNoteArr = explode("\n\n", $extraNote);
		foreach($extraNoteArr as $note) {
			$note = $note;
			$xls->Column(120,0);
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => trim($note)));
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
		}
	}
	
	if($toggleInternalMemoCheck) {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Extras Memo"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		if($extraMemo != "") {
			$extraMemoArr = explode("\n\n", $extraMemo);
			foreach($extraMemoArr as $memo) {
				$memo = $memo;
				$xls->Column(120,0);
				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => trim($memo)));
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));
			}
		}
	}
	
	if($togglePropertyNoteCheck) {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$xls->Column(120,0);
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Property Notes"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		foreach($result['propertyNotes'] as $item) {
			
			$tempCell = array();
			$cell = $xls->Cell(array("type"=>"String", "data" => $item['pr_name_last']));
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
			$xls->Column(120,0);
			$tempCell = array();
			$item['pr_bus_memo_info'] = $item['pr_bus_memo_info'];
			$cell = $xls->Cell(array("type"=>"String", "data" => $item['pr_bus_memo_info']));
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
		}
	}
	
	if($toggleBookingTerms) {
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => ""));
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));

		$terms = $GLOBALS['lDB']->get("select rf_booking_info from rf_custom where rf_custom_id = 1",4);
		removeSpecialChars($terms);
		
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => "Booking Terms and Conditions"), $bold);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
		
		$termsArr = explode("\n",$terms);
		
		foreach($termsArr as $term) {
			$xls->Column(120,0);
			$tempCell = array();
			
			$cell = $xls->Cell(array("type"=>"String", "data" => t_decodeHTML($term)));
			array_push($tempCell,$cell);
			array_push($rows,$xls->Row($tempCell));
		}
	}

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => ""));
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));

	if (trim(t_decodeHTML($proformaNote)) != "") {
		$xls->Column(120,0);
		$tempCell = array();
		$cell = $xls->Cell(array("type"=>"String", "data" => t_decodeHTML($proformaNote)),$styleLtbrwcId);
		array_push($tempCell,$cell);
		array_push($rows,$xls->Row($tempCell));
	}

	$tempCell = array();
	$cell = $xls->Cell(array("type"=>"String", "data" => ""));
	array_push($tempCell,$cell);
	array_push($rows,$xls->Row($tempCell));

	if($customNotesList != "") {
		$customArray = explode(",",$customNotesList); 
		if(sizeof($customArray) > 0) {
			foreach($customArray as $custNote) {
				$customNotes = $GLOBALS['lDB']->get("
					SELECT
						rf_note_custom.rf_note_custom_desc as custNoteDesc,
						rf_note_custom.rf_note_custom_hdg as custNoteHdg
					FROM
						rf_note_custom
					WHERE
						rf_note_custom.rf_note_custom_ix = '$custNote'
				",1);
				$customItems = $GLOBALS['lDB']->get("
					SELECT
						rf_note_cust_item.rf_note_cust_item_ix as itemId,
						rf_note_cust_item.rf_note_cust_item_path as itemImgName,
						rf_note_cust_item.rf_note_cust_item_seq as itemSeq,
						rf_note_cust_item.rf_note_cust_item_text as itemText,
						rf_note_cust_item.rf_note_cust_pg_brk_yn as newPage
					FROM
						rf_note_cust_item
					WHERE
						rf_note_cust_item.rf_note_custom_id = '$custNote'
					ORDER BY
						rf_note_cust_item.rf_note_cust_item_seq
				",2);

				
				$tempCell = array();
				$cell = $xls->Cell(array("type"=>"String", "data" => $customNotes['custNoteHdg']),$bold,"","","","",3);
				array_push($tempCell,$cell);
				array_push($rows,$xls->Row($tempCell));
				
				$itemNote = "";
				foreach($customItems as $item){
					if($item['itemText'] != "" || $item['itemText'] != null) {
						$tempCell = array();
						$cell = $xls->Cell(array("type"=>"String", "data" => $item['itemText']),"","","","","",3);
						array_push($tempCell,$cell);
						array_push($rows,$xls->Row($tempCell));
					} else { 
						$itemNote .= $imgPath.$item['itemImgName'];
						$imgPath = "$GLOBALS[images_dir_on_disk]/".$_SESSION['principal_id']."/custom/";
						if(file_exists($imgPath.$item['itemImgName'])) {
							$tempCell = array();
							$cell = $xls->Cell(array("type"=>"String", "data" => $imgPath.$item['itemImgName']),"","","","","",3);
							array_push($tempCell,$cell);
							array_push($rows,$xls->Row($tempCell));
						}
					}
				}
			}
		}
	}
	$table = $xls->Table($rows);
	array_push($tables, $table);
	$tempCell = array();
	$xls->Worksheet($tables);
	$xls->genrateWorkbook($repName);
}

function removeSpecialChars(&$str) {
	$str = str_replace(array('<br/>','<BR/>','\n','<br>','<BR>'),'&#10;',$str);
	$search = array (
		"'<script[^>]*?>.*?</script>'si",
		"'<p[\/\!]*?[^<>]*?>'si",
		"'<[\/\!]*?[^<>]*?>'si",         
		"'([\r\n])[\s]+'",                 
		"'&(quot|#34);'i",                 
		"'&(amp|#38);'i",
		"'&(lt|#60);'i",
		"'&(gt|#62);'i",
		"'&(nbsp|#160);'i",
		"'&(iexcl|#161);'i",
		"'&(cent|#162);'i",
		"'&(pound|#163);'i",
		"'&(copy|#169);'i"
	);
	$replace = array (
		"",
		" ",
		"",
		"\\1",
		"\"",
		"&",
		"<",
		">",
		" ",
		chr(161),
		chr(162),
		chr(163),
		chr(169)
	);
	$str = str_replace("</P>","\n",
		str_replace("<BR>","\n",urldecode($str)));
	$str = preg_replace ($search, $replace, $str);
	$str = preg_replace_callback(
		"'&#(\d+);'",
		function($matches) {
			return chr($matches[1]);
		},
		$str
	);
}

function removeBlank(&$arr) {
	foreach($arr as $key=>$item) {
		if(is_array($item) || trim($item) == "") {
			$arr[$key] = "&nbsp;";
		}
	}
}

function removeSpace(&$arr) {
	foreach($arr as $key=>$item) {
		$arr[$key] = str_replace("\n","",$arr[$key]);
		if(empty($arr[$key])) {
			$arr[$key] = " ";
		}
	}
}

function getBusinessDetails($resId, $selectedBanks, $options) {
	global $lDB;
	$businessArray = array();
	$businessArray = $lDB->get("
		SELECT DISTINCT
			pr_business_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '$resId'
			AND pr_business_id != ''
			AND pr_business_id != '0'
			AND pr_business_id IS NOT NULL
		",3);

	$businessArray = array_unique(array_merge($businessArray, $lDB->get("
		SELECT DISTINCT
			pr_business_id
		FROM
			rv_extra
		WHERE
			rv_extra.rv_reservation_id = '$resId'
			AND pr_business_id != ''
			AND pr_business_id != '0'
			AND pr_business_id IS NOT NULL
			AND rv_extra.rv_extra_void_ind = '0'
	",3)));
	$newBusinessArray = array();
	$propertyArray = array();
	foreach($businessArray as $item) {
		$currId = $item;
		while($currId != "0" && trim($currId) != "") {
			array_push($propertyArray,$currId);
			if($lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4) == "1"
				&& !in_array($currId, $newBusinessArray)) {
				array_push($newBusinessArray,$currId);
			}
			$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
			$currId = $parentId;
		}
	}
	$businessArray = $newBusinessArray;

	// Display only the banks for applicable properties in use on the reservation
	$businessArray = $lDB->get("SELECT DISTINCT pr_business_id FROM fn_folio WHERE rv_reservation_id = '$resId'",3);
	
	$currencyId = getInvCurr($resId);
	$busBankSql = $lDB->get("
		SELECT DISTINCT
			rf_bank.rf_bank_ix as busBankId
		FROM
			pr_bus_bank
			INNER JOIN rf_bank ON rf_bank.rf_bank_ix = pr_bus_bank.rf_bank_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			pr_bus_bank.pr_business_id IN ('".join("','",$businessArray)."')
			AND rf_bank.rf_bank_ind = '0'
			AND rf_bank.rf_bank_sys_code = '0'
			AND rf_bank.rf_currency_id = '$currencyId'
	",2);

	$busBankList = array();
	foreach($busBankSql as $busBankId){
		array_push($busBankList,$busBankId['busBankId']);
	}

	$bankList = $lDB->get("
		SELECT
			rf_bank.rf_bank_ix as bankId,
			rf_bank.rf_bank_acc_name as bankAccName,
			rf_currency.rf_currency_symbol as bankCurr
		FROM
			rf_bank
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			rf_bank.rf_bank_ind = '0'
			AND rf_bank.rf_bank_inactive_yn = '0'
			AND rf_bank.rf_bank_sys_code = '0'
		ORDER BY
			rf_bank.rf_bank_acc_name
	",2);

	$bankListRows = "";
	$bankIds = array();
	$showAll = true;
	$banksSelected = false;
	$bankListHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_bank_row.htm"));
	foreach($bankList as $bankListItem) {
		$bankListItem['checked'] = "";
		if (in_array($bankListItem['bankId'], $busBankList, true)) {
			$bankListItem['checked'] = "checked";
			$banksSelected = true;
			if(!$showAll) array_push($bankIds,$bankListItem['bankId']);
		}
		$bankListRows .= showpage($bankListItem,$bankListHTML);
		$GLOBALS['temp']['showHideBank'] = "";
		if($showAll) array_push($bankIds,$bankListItem['bankId']);
	}
	$GLOBALS['temp']['bankidList'] = join(",",$bankIds);
	if(!isset($GLOBALS['temp']['bankListRows'])) {
		$GLOBALS['temp']['bankListRows'] = "";
	}
	$GLOBALS['temp']['bankListRows'] .= $bankListRows;
	$bankSQL = $bankIds;

	if ( !(($options & 7) == REP_VIEW_PDF || ($options & 7) == REP_SEND_PDF) ) {
		$bankSQL = $bankIds;
	}
	
	if ($banksSelected == true) {
		$GLOBALS['temp']['bankDetailDefault'] = "expand";
	} else {
		$GLOBALS['temp']['bankDetailDefault'] = "collapse printCollapse";
	}

	if($selectedBanks != ""){
		$bankSQL = explode(",",$selectedBanks);
	}

	$bankArray = $lDB->get("
		SELECT DISTINCT
			rf_currency.rf_currency_symbol as rf_currency_name,
			rf_bank.rf_bank_name,
			rf_bank.rf_bank_acc_no,
			rf_bank.rf_bank_detail_1,
			rf_bank.rf_bank_detail_2,
			rf_bank.rf_bank_detail_3,
			rf_bank.rf_bank_acc_name,
			rf_bank.rf_bank_ix as bankId
		FROM
			rf_bank
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			rf_bank.rf_bank_ix IN ('".join("','",$bankSQL)."')
			AND rf_bank.rf_bank_ind = '0'
	",2);

	foreach($bankArray as $bankKey=>$bankItem) {
		$detail = trim($bankItem['rf_bank_detail_1']);
		if($bankItem['rf_bank_detail_2'] != "") {
			if(trim($detail) != "") {
				$detail .= "<br>";
			}
			$detail .= $bankItem['rf_bank_detail_2'];
		}
		if($bankItem['rf_bank_detail_3'] != "") {
			if(trim($detail) != "") {
				$detail .= "<br>";
			}
			$detail .= $bankItem['rf_bank_detail_3'];
		}
		$bankArray[$bankKey]['rf_bank_detail_1'] = $detail;

		if (in_array($bankItem['bankId'], $busBankList, true)) {
			$bankArray[$bankKey]['bankClass'] = "expand";
		} else {
			$bankArray[$bankKey]['bankClass'] = "collapse printCollapse";
		}
	}
	

	$businessArray = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_business.pr_bus_statutory_1,
			pr_business.pr_bus_statutory_2,
			pr_business.pr_bus_statutory_3,
			pr_business.pr_bus_statutory_label_1,
			pr_business.pr_bus_statutory_label_2,
			pr_business.pr_bus_statutory_label_3,
			pr_business.pr_business_id
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id IN ('".join("','",$businessArray)."')
	",2);

	$propertyArray = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_business.pr_bus_memo_info
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id IN ('".join("','",$propertyArray)."')
			AND trim(pr_business.pr_bus_memo_info) <> ''
	",2);
	
	return array('billingInfo'=>$businessArray, 'bankInfo'=>$bankArray, 'propertyNotes'=>$propertyArray);
}


function getContactEmail($personaId) {
	global $lDB;

	$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($email) == "" || $email == "0") {
		$personaId = getLinkedPersona($personaId);
		$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($email) == "" || $email == "0") {
			return "";
		} else {
			return $email;
		}
	} else {
		return $email;
	}
}

function getContactURL($personaId) {
	global $lDB;

	$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if (trim($url) == "" || $url == "0") {
		$personaId = getLinkedPersona($personaId);
		$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($url) == "" || $url == "0") {
			return "";
		} else {
			return $url;
		}
	} else {
		return $url;
	}
}

function getContactFax($personaId) {
	global $lDB;
	
	$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
	if (trim($faxNumber) == "" || $faxNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
		if (trim($faxNumber) == "" || $faxNumber == "0") {
			return "";
		} else {
			return $faxNumber;
		}
	} else {
		return $faxNumber;
	}
}

function getContactTelephone($personaId) {
	global $lDB;

	$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND pr_default_yn = 1", 4);
	if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '".$personaId."' AND pr_default_yn = 1", 4);
		if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
			return "";
		} else {
			return $telephoneNumber;
		}
	} else {
		return $telephoneNumber;
	}
}

function getContactName($personaId) {
	global $lDB;
	
	$nameArray = $lDB->get("
		SELECT
			pr_name_first,
			pr_name_second,
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$personaId'
	",1);
	$name = $nameArray['pr_name_last'];
	if (trim($nameArray['pr_name_second']) != "" && $nameArray['pr_name_second'] != "0") {
		$name = $nameArray['pr_name_second'] . " " . $name;
	}
	if (trim($nameArray['pr_name_first']) != "" && $nameArray['pr_name_first'] != "0") {
		$name = $nameArray['pr_name_first'] . " " . $name;
	}
	$link = $lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE
			pr_link.pr_link_from = '$personaId'
			AND pr_link.rf_link_type_id IN ('RS1','RS2')
	",4);
	if($link != "0" && trim($link) != "") {
		$name .= " (".$link.")";
	}
	if($lDB->get("SELECT rf_res_office_id FROM rf_default",4) == $personaId) {
		$name .= " (Res Office)";
	}
	return $name;
}

function getLinkedPersona($personaId) {
	$linkId = $GLOBALS['lDB']->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($linkId) != "" && $linkId != "0") {
		return $linkId;
	} else {
		return $personaId;
	}
}

function relatedEmailSort($a, $b) {
	return strcasecmp($a['name'],$b['name']);
}


function relatedEmailAddress($reservationId) {
	if($GLOBALS['userStatusId'] < 2) {
		return array();
	}
	$personaArray = array();
	$lookup = $GLOBALS['lDB']->get("
		SELECT
			rv_corr_persona_id,
			rv_billing_persona_id,
			rv_agent_id,
			rv_consultant_id,
			rv_invoice_persona_id
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$reservationId'
	",1);
	
	foreach($lookup as $item) {
		if (trim($item) != "" && $item != "0") {
			array_push($personaArray, $item);

			$linked = $GLOBALS['lDB']->get("
				SELECT
					pr_link.pr_link_from
				FROM
					pr_link
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				WHERE
					pr_link.pr_link_to = '$item'
					AND pr_link.rf_link_type_id = 'RS2'
					AND pr_sys_code != '9'
				ORDER BY
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
			",3);
			if(sizeof($linked) > 0) {
				$personaArray = array_merge($personaArray,$linked);
			}
		}
	}
	array_splice($personaArray, count($personaArray), 0, $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
		WHERE
			rf_link_type_id = 'RS1'
			AND pr_persona.pr_persona_inactive_yn = '0'
			AND pr_sys_code != '9'
	",3));
	array_push($personaArray,$GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default",4));
	array_push($personaArray, $GLOBALS['userid']);
	array_splice($personaArray, sizeof($personaArray), 0, getUsers(getAgent($GLOBALS['userid'])));
	$personaArray = array_unique($personaArray);
	$emailArray = array();
	foreach($personaArray as $id) {
		if ($id != "0") {
			if (getContactEmail($id) != "") {
				array_push($emailArray, array('email'=>getContactEmail($id), 'name'=>escapeName(getContactName($id)),'id'=>$id));
			}
		}
	}
	$firstItem = array_shift($emailArray);
	usort($emailArray,"relatedEmailSort");
	array_unshift($emailArray,$firstItem);
	return $emailArray;
}

function getUsers($agentId) {
	$userArray = $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
		WHERE
			pr_link_to = '$agentId'
			AND rf_link_type_id = 'RS2'
	",3);
	if (sizeof($userArray) > 0) {
		return $userArray;
	}
	return "0";
}

function hasContactDetails($pr_persona_id) {
	if(trim(getContactCorrAddress($pr_persona_id)) != "") {
		return true;
	}

	if(trim(getContactTelephone($pr_persona_id)) != "") {
		return true;
	}

	if(trim(getContactFax($pr_persona_id)) != "") {
		return true;
	}
	
	if(trim(getContactEmail($pr_persona_id)) != "") {
		return true;
	}

	if(trim(getContactURL($pr_persona_id)) != "") {
		return true;
	}

	return false;
}
