<?php

/**
 * init.form395.php - Itinerary Summary
 * Job: 351
 * Function: 50 (Availability calendar)
 */

if (!isset($_SESSION['userName'])) {
	redirectTo("/");
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/doc_itinerary.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],13,"");

$resId = trim($_SERVER['argv'][1]);
$options = $_SERVER['argv'][2];
$toggleMap = $_SERVER['argv'][4];
$addressArg = trim(urldecode($_SERVER['argv'][5]));
$commentArg	= trim(urldecode($_SERVER['argv'][6]));
$emailTo = trim($_SERVER['argv'][6]); 
$emailPersonaId	= $_SERVER['argv'][7];
$selectedBanks = $_SERVER['argv'][8];
$customNotesList = $_SERVER['argv'][9];
$hideFinancials	= $_SERVER['argv'][10];
$showSpecial = $_SERVER['argv'][11];
$showSpecialNote = $_SERVER['argv'][12];

$GLOBALS['temp']['widthToggle'] = 238;
if($options == "") { $options = 0; }

$GLOBALS['temp']['selectedBanks'] = $selectedBanks;
$GLOBALS['temp']['customNotesList']	= $customNotesList;
$GLOBALS['temp']['hideFinancials'] = $hideFinancials;

$GLOBALS['temp']['commissionLabel'] = commissionLabel();

$rf_mail_id = $GLOBALS['lDB']->get("SELECT rf_database.rf_mail_id FROM rf_database WHERE rf_database.rf_db_code = '$GLOBALS[dbcode]'",4);
$GLOBALS['temp']['rf_mail_id'] = "";
if($rf_mail_id == 2 && $GLOBALS['dbcode'][0] != "W") {
	$GLOBALS['temp']['rf_mail_id'] = $rf_mail_id;
}

$envType = $GLOBALS['lDB']->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_database.rf_db_code = '$dbcode'",4);
$GLOBALS['temp']['envType'] = $envType;

$GLOBALS['temp']['header_button_style'] = "visibility: hidden;";
if($userStatusId > 0) {
	$GLOBALS['temp']['header_button_style'] = "";
}

$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
$principalName = getContactFullName($principalId);
$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
$proformaNote = trim($GLOBALS['lDB']->get("SELECT rf_proforma_note FROM rf_default", 4));


$templateData = initTemplates($resId);

$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

define("REP_VIEW_XLS",4);
define("REP_VIEW_OFFICE",5);

switch ( $options & 7 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_XLS:
	$renderMode = "xls";
	$renderType = "";
	break;
case REP_VIEW_OFFICE:
	$renderMode = "oofice";
	$renderType = "";
	break;
}

// Get special details
$specials = db_sp_special_get_by_reservation($resId);

$docList = array();
$resIdList = array($GLOBALS['wizResId']);
if($resId != "") {
	$resIdList = explode("|",$resId);
}

foreach($resIdList as $item) {
	array_push($docList,array('resId'=>$item, 'folioId'=>"", 'invoiceId'=>""));
}

// Look up document defaults
list(
	$rf_doc_header_res_office_yn,
	$rf_doc_header_res_office_type_ind,
	$rf_doc_header_res_office_url_yn,
	$rf_doc_header_logo_yn,
	$rf_doc_header_logo_type_ind,
	$rf_doc_header_invoice_yn
) = $lDB->get("
	SELECT
		rf_doc_header_res_office_yn,
		rf_doc_header_res_office_type_ind,
		rf_doc_header_res_office_url_yn,
		rf_doc_header_logo_yn,
		rf_doc_header_logo_type_ind,
		rf_doc_header_invoice_yn
	FROM
		rf_default
",1);

foreach($docList as $docKey=>$docItem) {
	$principal_id = $_SESSION['principal_id'];
	$businessList = $GLOBALS['lDB']->get("SELECT DISTINCT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$docItem[resId]'",3);
	if($rf_doc_header_logo_type_ind == RF_DEFAULT_DOC_HEADER_LOGO_TYPE_SYSTEM) {
		$logoList = array();
		foreach($businessList as $pr_business_id) {
			$logoFilename = "";
			$currId = $pr_business_id;
			while($currId != "0" && trim($currId) != "" && $logoFilename == "") {
				$prefix = strtolower($lDB->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$currId'",4));
				$fileName = $prefix . '_mkg';
				$logoFilename = imageFile($fileName);
				$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
				$currId = $parentId;
			}
			if($logoFilename != "") {
				array_push($logoList,$logoFilename);
			}
		}
		$logoList = array_unique($logoList);
		if(sizeof($logoList) == 1) {
			$logoFilename = $logoList[0];
		} else {
			$fileName = 'top_client_mkg';
			$logoFilename = imageFile($fileName, false);
		}
	} else { // RF_DEFAULT_DOC_HEADER_LOGO_TYPE_FIRST_PARENT
		$commonParents = findCommonParents($businessList);
		foreach($commonParents as $pr_business_id) {
			$prefix = strtolower($lDB->get("
				SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$pr_business_id'
			",4));
			$fileName = $prefix . '_mkg';
			$logoFilename = imageFile($fileName);
			if (!empty($logoFilename)) {
				break;
			}
		}
		if(empty($logoFilename)) {
			$fileName = 'top_client_mkg';
			$logoFilename = imageFile($fileName, false);
		}
	}
	$docList[$docKey]['logoFilename'] = $logoFilename;
}

$GLOBALS['temp']['customCSS'] = "";

if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/financial_documents.css")) {
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/financial_documents.css\" type=\"text/css\">
	";
}

$guestServicesUrl = $GLOBALS['http'] . $GLOBALS['domain'] . '/guest';
$GLOBALS['temp']['guest_services_url'] = $guestServicesUrl;
$GLOBALS['temp']['guest_list_url'] = $guestListUrl = $guestServicesUrl . '/list';
$GLOBALS['temp']['guest_check_in_url'] = $guestCheckInUrl = $guestServicesUrl . '/check-in';

$payNowUrl = $GLOBALS['http'] . $GLOBALS['domain'] . '/reservation.php?1021';
require_once(__DIR__ . '/functions.imageset.php');
if (isV3Imageset($principal_id)) {
	// Different link if it's a V3+ imageset
	$payNowUrl = $GLOBALS['http'] . $GLOBALS['domain'] . '/public/paynow.php';
}
$GLOBALS['temp']['pay_now_url'] = $payNowUrl;

foreach($docList as $docKey=>$docItem) {
	$resId = $docItem['resId'];
	$logoFilename = $docItem['logoFilename'];
	$GLOBALS['temp']['resNum'] = $resId;

	$GLOBALS['temp']['doc_header_res_office_class'] = "";
	$GLOBALS['temp']['doc_header_res_office_width'] = "190";
	$GLOBALS['temp']['doc_header_filler_class'] = "collapse printCollapse";
	$GLOBALS['temp']['doc_header_filler_width'] = "";
	$GLOBALS['temp']['doc_header_logo_class'] = "";
	$GLOBALS['temp']['doc_header_logo_width'] = "";
	$GLOBALS['temp']['doc_header_logo_align'] = "center";
	$rf_doc_header_logo_align = "C";
	$GLOBALS['temp']['doc_header_invoice_class'] = "";
	$GLOBALS['temp']['doc_header_invoice_width'] = "190";

	// Count how many columns are shown and collapse any that are not
	$rf_doc_header_count = 0;
	if($rf_doc_header_res_office_yn == "1") {
		$rf_doc_header_count++;
	} else {
		$GLOBALS['temp']['doc_header_res_office_class'] = "collapse printCollapse";
		$GLOBALS['temp']['doc_header_res_office_width'] = "";
	}
	if($rf_doc_header_logo_yn == "1") {
		$rf_doc_header_count++;
	} else {
		$GLOBALS['temp']['doc_header_logo_class'] = "collapse printCollapse";
	}
	if($rf_doc_header_invoice_yn == "1") {
		$rf_doc_header_count++;
	} else {
		$GLOBALS['temp']['doc_header_invoice_class'] = "collapse printCollapse";
		$GLOBALS['temp']['doc_header_invoice_width'] = "";
	}

	// If there are only two or less columns showing, and the logo is hidden, enable the filler cell
	if($rf_doc_header_count < 3 && $rf_doc_header_logo_yn != "1") {
		$GLOBALS['temp']['doc_header_filler_class'] = "";
	}

	// If there are only two columns showing, and one of them is the logo...
	if($rf_doc_header_count == 2 && $rf_doc_header_logo_yn == "1") {
		if($rf_doc_header_res_office_yn == "1") {
			// ... set the alignment of the logo left if the other column is the res office details
			$GLOBALS['temp']['doc_header_logo_align'] = "";
			$rf_doc_header_logo_align = "L";
		} else {
			// ... else set the alignment of the logo right if the other column is the invoice details
			$GLOBALS['temp']['doc_header_logo_align'] = "right";
			$rf_doc_header_logo_align = "R";
		}	
	}

	$result = getReservationHeader($resId);
	$result = array_merge($result, getReservationExtra($resId));
	$result = array_merge($result,$GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_commission_perc,
			rv_reservation.rv_provision_expiry_date,
			rf_currency.rf_currency_symbol
		FROM 
			rv_reservation
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id
		WHERE
			rv_reservation.rv_reservation_ix = '$resId'
	",1));

	$result['rv_provision_expiry_date']	= chng_date($result['rv_provision_expiry_date'],"-");

	// Contact details for email popup
	$emailPopupTelephone = getContactTelephone($resOfficeId);
	if(!empty($emailPopupTelephone)) {
		$result['resOffTel'] = $emailPopupTelephone;
	} else {
		$result['resOffTel'] = "None";
	}

	$emailPopupFax = getContactFax($resOfficeId);
	if($emailPopupFax == "") {
		$emailPopupFax = str_pad("None", 16," ",STR_PAD_LEFT);
	} else {
		$emailPopupFax = str_pad($emailPopupFax, (strlen($emailPopupFax)+11)," ",STR_PAD_LEFT);
	}
	$result['fax'] = $emailPopupFax;

	// Res office contact details
	$resOfficeHeaderId = $resOfficeId;
	if($rf_doc_header_res_office_type_ind == RF_DEFAULT_DOC_HEADER_RES_OFFICE_TYPE_FIRST_PARENT) {
		$businessList = $lDB->get("SELECT DISTINCT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$docItem[resId]'",3);
		$commonParents = findCommonParents($businessList);
		foreach($commonParents as $pr_business_id) {
			if(hasContactDetails($pr_business_id)) {
				$resOfficeHeaderId = $pr_business_id;
				break;
			}
		}
	}
	$result['fromAddress'] = getContactCorrAddress($resOfficeHeaderId);

	$addresseeTelephone = getContactTelephone($resOfficeHeaderId);
	if($addresseeTelephone != "") {
		$result['fromAddress'] .= "Telephone: " . $addresseeTelephone . "\n";
	}

	$addresseeFax = getContactFax($resOfficeHeaderId);
	if($addresseeFax == "") {
		$addresseeFax = str_pad("None", 16," ",STR_PAD_LEFT);
	} else {
		$addresseeFax = str_pad($addresseeFax, (strlen($addresseeFax)+11)," ",STR_PAD_LEFT);
	}
	
	if(trim($addresseeFax) != "None") {
		$result['fromAddress'] .= "Fax: " . $addresseeFax . "\n";
	}
	
	$addresseeEmail = getContactEmail($resOfficeHeaderId);
	if($addresseeEmail != "") {
		$result['fromAddress'] .= "Email: " . $addresseeEmail . "\n";
	}

	$addresseeURL = getContactURL($resOfficeHeaderId);
	if($addresseeURL != "") {
		$result['fromAddress'] .= "Web: " . $addresseeURL . "\n";
	}

	if($rf_doc_header_res_office_url_yn == "1") {
		$result['fromAddress'] .= "Res-Web: " . $_SESSION['principal_name_short'] . ".resrequest.com\n";
	}
	$result = array_merge($result,getDocTitle($resId));
	$result['resId'] = $resId;
	$GLOBALS['temp']['printCount'] = -1;
	$GLOBALS['temp']['allowHideFin'] = "";
	$titleResName = $result['rv_res_name'];
	$result['resItems'] = getAccommRateData($resId);
	$result['resExtras'] = getExtraDetails($resId);
	$result['accomExtras'] = getExtraDetails($resId,3);
	$result['actExtras'] = getExtraDetails($resId,1);
	$result['resTravel'] = getExtraDetails($resId,2);
	$result['docTitle'] = $lDB->get("SELECT rf_itinerary_title FROM rf_default LIMIT 1",4);
	$result['docRef'] = $titleResName;
	$result['currencyCheck'] = $lDB->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '$resId'",4);
	$consolidatedLabel = addslashes($lDB->get("SELECT rf_doc_summary_comp_group_label FROM rf_default",4));
	$GLOBALS['temp']['consolidatedLabel'] = stripslashes($consolidatedLabel);
		
	$tmp = getPayItems($resId,false,true);
	$result['payOutstanding'] = $tmp['outstanding'];
	$result['payedTotal'] = $tmp['payedTotal'];
	$result['payTotal'] = isset($tmp['payTotal'])?$tmp['payTotal']:"";
	$result['payItems'] = $tmp['items'];
	$result['payInvItems'] = $tmp['splitItems'];
	$result['payedItems'] = $tmp['payments'];
	$result = array_merge($result,getPayItems($resId,false,true));

	$tmp2 = getPayItems($resId,false,false);
	$result['payOutstanding2']	= $tmp2['outstanding'];
	$result['payTotal2'] = isset($tmp['payTotal'])?$tmp2['payTotal']:"";
	$result['payItems2'] = $tmp2['items'];
	$result['payInvItems2'] = $tmp2['splitItems'];
	$result['payedItems2'] = $tmp2['payments'];
	$result['compTotals'] = getCompTotals($resId);
	$result['exchange'] = getExchange($resId);
	$result = array_merge($result,getResDocTotals($resId, $result['resItems'], $result['resExtras'], $result['resTravel'], "1"));

	// Per person charges
	$result['perPersonItems'] = getPerPerson($result['resItems']);

	$GLOBALS['temp']['noTravelTotal'] = "txts";
	if(!isset($result['compTotals']['Travel'][0]) || $result['compTotals']['Travel'][0] == "") {
		$GLOBALS['temp']['noTravelTotal'] = "collapse printCollapse";
	}
	$result['resNote'] = getReservationNote($resId);
	if(strtoupper($result['resNote']) == "FALSE") {
		$result['resNote'] = "";
	}

	$result['resMemo'] = getReservationMemo($resId);
	if(strtoupper($result['resMemo']) == "FALSE") {
		$result['resMemo'] = "";
	}

	$result['resGuestNote'] = $GLOBALS['lDB']->get("SELECT rv_note_guests FROM rv_reservation WHERE	rv_reservation_ix = '$resId'",4);
		
	$guestCountryId = trim($GLOBALS['lDB']->get("SELECT rf_country_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4));

	if($guestCountryId == "0" || $guestCountryId == "") {
		$guestNationality = "";
	} else {
		$guestNationality = trim($GLOBALS['lDB']->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '$guestCountryId'", 4));
		if ( $guestNationality == "0" ) {
			$guestNationality = "";
		} else {
			$guestNationality = "Nationality: " . $guestNationality;
		}
	}

	$result['guestNationality']	= $guestNationality;
	$result['proformaNote']	= $proformaNote;
	$result = array_merge($result,getBusinessDetails($resId,$selectedBanks,$options));

	if ($userStatusId < 2) {
		$GLOBALS['temp']['guestNationality'] = "";
		$GLOBALS['temp']['extraMemo'] = "";
		$GLOBALS['temp']['resMemo'] = "";
		$result['compTotals'] = array();
		//$result['total_comm'] = "";   Why do we do this?
	}

	$dayItenaryDetails = getDayItenaryDetails($result);
	$maxMinDate = getMinMaxTravDate($result);
	$result['minDate'] = $maxMinDate['minDate'];
	$result['maxDate'] = $maxMinDate['maxDate'];
 	if($renderMode == "html") {
		if(isset($GLOBALS['temp']['guestNationality']) && $GLOBALS['temp']['guestNationality'] != "") {
			$GLOBALS['temp']['guestNationality'] = "<br>$guestNationality<br><br>";
		}
		$resItenaryHTML = join("",file(__DIR__ . "/../../../public/html/docs_itinerary_rows.htm"));
		
		$resItenaryRows = "";
		foreach($dayItenaryDetails as $key=>$item) {
			$itemCount = count($item['itenaryItem']);
			for($i=0; $i<$itemCount; $i++) {
				$itenaryData['tdDescClass'] = "";
				if($i==0 && $key != 0) {
					$itenaryData['tdDescClass'] = "bdrTop";
				}
				if($key==0) {
					$tdDateClass = "leftRight";
				} else {
					$tdDateClass = "leftRight bdrTop";
				}
				$itenaryData['tdClass'] = "leftRight";
				if($i==0 && $key != 0) {
					$itenaryData['tdClass'] = "leftRight bdrTop";
				}
				if($i==0) {
					$itenaryData['doc_itenary_date'] = "<td rowspan='$itemCount' align='center' valign='top' class='$tdDateClass'><span style='padding-top:10px;'>$item[doc_itenary_date]</span></td>";
				} else {
					$itenaryData['doc_itenary_date'] = "";
				}
				$itenaryData['itenary_type'] = $item['itenaryItem'][$i]['itenary_type'];
				$itenaryData['itenary_desc'] = $item['itenaryItem'][$i]['itenary_desc'];
				$itenaryData['units'] = isset($item['units'][$i])?$item['units'][$i]:"";
				$itenaryData['rt_rate_type_desc'] = isset($item['rt_rate_type_desc'][$i])?$item['rt_rate_type_desc'][$i]:"";
				$itenaryData['pax'] = isset($item['pax'][$i])?$item['pax'][$i]:"";
				$itenaryData['compAmt'] = isset($item['compAmt'][$i])?$item['compAmt'][$i]:"";
				$resItenaryRows .= showpage($itenaryData, $resItenaryHTML);
			}
		}
		$GLOBALS['temp']['resItenaryRows'] = $resItenaryRows;
		$extraNoteMemo = getMemoNoteDetails($result);
		$extraNote = $extraNoteMemo['extraNote'];
		$extraMemo = $extraNoteMemo['extraMemo'];
		$GLOBALS['temp']['extraNote'] = $extraNote;
		if($extraMemo != "") {
			$extraMemo = $extraMemo;
		}
		$GLOBALS['temp']['extraMemo'] = $extraMemo;

		if(file_exists("$GLOBALS[images_dir_on_disk]/".$GLOBALS['principal_id']."/".$logoFilename)) {	
			$GLOBALS['temp']['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/$logoFilename";
		} else {
			$GLOBALS['temp']['logoURL'] = "/resource/Resrequest/Application/public/img/1x1.gif";
		}

		if(trim($result['resNote']) != "") {
			$result['resNote'] = t_encodeHTML($result['resNote']);
		}

		if(trim($result['resMemo']) != "") {
			$result['resMemo'] = t_encodeHTML($result['resMemo']);
		}

		if(trim($result['resGuestNote']) != "") {
			$result['resGuestNote'] = t_encodeHTML($result['resGuestNote']);
		}
		$GLOBALS['temp'] = array_merge($result, $GLOBALS['temp']);
		$GLOBALS['temp']['fromAddress'] = t_encodeHTML($result['fromAddress']);
		$GLOBALS['temp']['hideOptions'] = "";
		$GLOBALS['temp']['allowPayPlan'] = "expand";
		$GLOBALS['temp']['allowPayReceipts'] = "expand";
		$GLOBALS['temp']['allowPerPerson'] = "expand";
		$GLOBALS['temp']['allowResNote'] = "expand";
		$GLOBALS['temp']['allowResMemo'] = "expand";
		$GLOBALS['temp']['allowBankDetails'] = "expand";
		$GLOBALS['temp']['allowBankList'] = "expand";
		$GLOBALS['temp']['allowGuestInformation'] = "expand";
		$GLOBALS['temp']['allowCommission'] = "expand";
		$GLOBALS['temp']['allowExchNote'] = "expand";
		$GLOBALS['temp']['allowExtraNote'] = "expand";
		$GLOBALS['temp']['allowPropertyNote'] = "expand";
		$GLOBALS['temp']['allowCostSummary'] = "expand";
		$GLOBALS['temp']['allowInternalMemo'] = "expand";
		$GLOBALS['temp']['internalMemoDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['allowCancelledPayments'] = "expand";
		$GLOBALS['temp']['hideCommission'] = "yes";

		$GLOBALS['temp']['allowSpecial'] = "expand";
		$GLOBALS['temp']['specialDetailDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['specialChecked'] = "";
		$GLOBALS['temp']['specialNoteChecked'] = "";
		$GLOBALS['temp']['specialNoteExpanded'] = "collapse printCollapse";
		$specialNoteDefault = "collapse printCollapse";

		if($result['total_comm'] == 0 && ($result['rv_agent_id'] == "0" || trim($result['rv_agent_id']) == "") ) {
			$GLOBALS['temp']['hideCommission'] = "yes";
			$GLOBALS['temp']['widthToggle'] = 538;
		}

		$GLOBALS['temp']['hideTax'] = "";
		$rf_doc_settings = $GLOBALS['lDB']->get("SELECT rf_doc_settings FROM rf_default",4);
		if( ($rf_doc_settings & 33554432) != 33554432) {
			$GLOBALS['temp']['hideTax'] = "1";
		}
		
		if ($userStatusId < 2) {
			$GLOBALS['temp']['allowInternalMemo'] = "collapse printCollapse";
			$GLOBALS['temp']['allowResMemo'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCommission'] = "collapse printCollapse";
			$GLOBALS['temp']['widthToggle'] = 538;
			$GLOBALS['temp']['allowCancelledPayments'] = "collapse printCollapse";
			$GLOBALS['temp']['guestNationality'] = "";
			$GLOBALS['temp']['extraMemo'] = "";
			$result['compTotals'] = array();
			//$result['total_comm'] = "";		Why do we do this?
		}

		$GLOBALS['temp']['paymentPlanDefault'] = "expand";
		$GLOBALS['temp']['paymentReceiptsDefault'] = "expand";
		$GLOBALS['temp']['showPerPerson'] = "collapse printCollapse";
		$GLOBALS['temp']['invoicePaymentClass'] = "collapse printCollapse";
		$GLOBALS['temp']['exchangeRateDefault'] = "collapse printCollapse";
	
		if($result['resNote'] != "") {
			$GLOBALS['temp']['resNoteDefault'] = "expand";
		} else {
			$GLOBALS['temp']['resNoteDefault'] = "collapse printCollapse";
		}

		$GLOBALS['temp']['resMemoDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['guestInformationDefault'] = "expand";
		$GLOBALS['temp']['roomingDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['guestNoteDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['guestMemoDefault'] = "collapse printCollapse";
		if(trim($extraNote) != "") {
			$GLOBALS['temp']['extraNoteDefault'] = "expand";
		} else {
			$GLOBALS['temp']['allowExtraNote'] = "collapse printCollapse";
			$GLOBALS['temp']['extraNoteDefault'] = "collapse printCollapse";
		}
		
		//$GLOBALS['temp']['bankDetailDefault'] = "expand";
		$GLOBALS['temp']['showCreditCard'] = "collapse printCollapse";
		if(sizeof($result['propertyNotes']) > 0) {
			$GLOBALS['temp']['propertyNoteDefault'] = "expand";
		} else {
			$GLOBALS['temp']['propertyNoteDefault'] = "collapse printCollapse";
		}
		if(isset($bookingTerms) && sizeof($bookingTerms) > 0) {
			$GLOBALS['temp']['bookingTermsDefault'] = "expand";
		} else {
			$GLOBALS['temp']['bookingTermsDefault'] = "collapse printCollapse";
		}
		$GLOBALS['temp']['standardNoteDefault'] = "expand";
		$GLOBALS['temp']['folioDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['invoiceDefault'] = "collapse printCollapse";

		if(trim($result['proformaNote']) == "") {
			$GLOBALS['temp']['showStandardNote'] = "collapse printCollapse";
		} else {
			$GLOBALS['temp']['showStandardNote'] = "expand";
			$GLOBALS['temp']['proformaNote'] = t_encodeHTML($result['proformaNote']);
		}
		
		if(trim($result['resNote']) == "") {
			$GLOBALS['temp']['allowResNote'] = "collapse printCollapse";
		}

		if(trim($result['resMemo']) == "") {
			$GLOBALS['temp']['allowResMemo'] = "collapse printCollapse";
		}

		if(trim($result['resGuestNote']) == "") {
			$GLOBALS['temp']['allowGuestInformation'] = "collapse printCollapse";
			$GLOBALS['temp']['guestInformationDefault'] = "collapse printCollapse";
		}
		
		if(trim($extraMemo) == "") {
			$GLOBALS['temp']['allowInternalMemo'] = "collapse printCollapse";
		}

		$customNotes = $GLOBALS['lDB']->get("
			SELECT
				rf_note_custom.rf_note_custom_ix as custNoteId,
				rf_note_custom.rf_note_custom_desc as custNoteDesc,
				rf_note_custom.rf_note_custom_hdg as custNoteHdg
			FROM
				rf_note_custom
			ORDER BY
				rf_note_custom.rf_note_custom_desc
		",2);
		$customRows = "";
		$customIds = array();
		if(sizeof($customNotes) > 0) {
			$customNoteListHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_custom_note_row.htm"));
			foreach($customNotes as $custom) {
				$dbInd = $GLOBALS['lDB']->get("SELECT rf_database.rf_db_env_type_ind FROM rf_database WHERE rf_database.rf_db_code = '$GLOBALS[dbcode]'",4);
				if($dbInd == 2) {
					$checkDB = "AND rf_note_cust_default.rf_db_code = ''";
				} else {
					$checkDB = "AND rf_note_cust_default.rf_db_code = '$GLOBALS[dbcode]'";
				}
				
				$def = $GLOBALS['lDB']->get("
					SELECT
						rf_note_cust_def_ext_inv_yn,
						rf_note_cust_def_ext_summ_yn,
						rf_note_cust_def_ext_pro_yn,
						rf_note_cust_def_int_inv_yn,
						rf_note_cust_def_int_summ_yn,
						rf_note_cust_def_int_pro_yn
					FROM
						rf_note_cust_default
					WHERE
						rf_note_cust_default.rf_note_custom_id = '$custom[custNoteId]'
						$checkDB
				",1);
				$custom['check'] = "";
				if($userStatusId < 2) {
					if($def['rf_note_cust_def_ext_summ_yn'] == 1) {
						$check = "checked";
					}
				} else {
					if($def['rf_note_cust_def_int_summ_yn'] == 1) {
						$custom['check'] = "checked";
					}
				}
				array_push($customIds,$custom['custNoteId']);
				$customRows .= showpage($custom,$customNoteListHTML);
			}
			$GLOBALS['temp']['customRows'] = $customRows;
			$GLOBALS['temp']['customIds'] = join(",",$customIds);

			$imgPath = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/custom/";
			$customNote = "";
			foreach($customNotes as $custId) {
				$customItems = $GLOBALS['lDB']->get("
					SELECT
						rf_note_cust_item.rf_note_cust_item_ix as itemId,
						rf_note_cust_item.rf_note_cust_item_path as itemImgName,
						rf_note_cust_item.rf_note_cust_item_seq as itemSeq,
						rf_note_cust_item.rf_note_cust_item_text as itemText
					FROM
						rf_note_cust_item
					WHERE
						rf_note_cust_item.rf_note_custom_id = '$custId[custNoteId]'
					ORDER BY
						rf_note_cust_item.rf_note_cust_item_seq
				",2);

				$custId['itemNote'] = "";
				foreach($customItems as $item) {
					if($item['itemText'] != "" || $item['itemText'] != null) {
						$custId['itemNote'] .= t_encodeHTML($item['itemText']) . "<br />";
					} else {
						$custId['itemNote'] .= "<img src='" . $imgPath . $item['itemImgName'] . "'><br />";
					}
				}
				$customNoteHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_custom_note.htm"));
				$customNote .= showpage($custId,$customNoteHTML);
			}
			$GLOBALS['temp']['customNote'] = $customNote;
		} else {
			$GLOBALS['temp']['customNote'] = "";
			$GLOBALS['temp']['customRows'] = "<tr><td align=\"center\">There are no notes setup</td></tr>";
			$GLOBALS['temp']['customIds'] = "";
		}
				
		foreach($result['resItems'] as $item) {
			$item['total'] = trim($item['compAmt'] . " " . $item['rf_currency_symbol']);
			removeBlank($item);
			
		}
		
		$GLOBALS['temp']['proformaClass'] = "expand";
		
		$GLOBALS['temp']['costSummaryDefault'] = "";
		$GLOBALS['temp']['showPaymentTotals'] = "";
		
		if($result['currencyCheck'] > 1) {
			$GLOBALS['temp']['allowCostSummary'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCommission'] = "collapse printCollapse";
			$GLOBALS['temp']['widthToggle'] = 538;
			$GLOBALS['temp']['costSummaryDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['showPaymentTotals'] = "collapse printCollapse";
			$GLOBALS['temp']['allowPayPlan'] = "collapse printCollapse";
			$GLOBALS['temp']['paymentPlanDefault'] = 'collapse printCollapse';
		}
				
		$payItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_pay_item_rows.htm"));
		$payRows = "";
		foreach($result['payItems'] as $item) {
			removeBlank($item);
			$payRows .= showpage($item,$payItemHTML);
		}
		$GLOBALS['temp']['payRows'] = $payRows;

		$payInvItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_pay_inv_item_rows.htm"));
		$payInvRows = "";
		$lastDate = "";
		foreach($result['payInvItems'] as $item) {
			if($lastDate == $item['pay_date']) {
				$item['pay_date'] = "";
			} else {
				$lastDate = $item['pay_date'];
			}
			removeBlank($item);
			$payInvRows .= showpage($item,$payInvItemHTML);
		}
		$GLOBALS['temp']['payInvRows'] = $payInvRows;
		$payedItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_payed_item_rows.htm"));
		$payedRows = "";
		if(is_array($result['payedItems'])) {
			foreach($result['payedItems'] as $item) {
				removeBlank($item);
				$payedRows .= showpage($item,$payedItemHTML);
			}
		}
		$GLOBALS['temp']['noPayments'] = "";
		$GLOBALS['temp']['payedRows'] = $payedRows;
		if(trim($payedRows) == "") {
			$GLOBALS['temp']['noPayments'] = "collapse printCollapse";
			$GLOBALS['temp']['payedRows'] = "<tr><td colspan=8 class=\"txti\" align=\"center\">None</td></tr>";
		}

		$payedRows2 = "";
		if(is_array($result['payedItems2'])) {
			foreach($result['payedItems2'] as $item) {
				removeBlank($item);
				$payedRows2 .= showpage($item,$payedItemHTML);
			}
		}
		$GLOBALS['temp']['payedRows2'] = $payedRows2;
		if(trim($payedRows2) == "") {
			$GLOBALS['temp']['noPayments'] = "collapse printCollapse";
			$GLOBALS['temp']['payedRows2'] = "<tr><td colspan=\"8\" class=\"txti\" align=\"center\">None</td></tr>";
		}
		
		$perPersonRows = "";
		$perPersonHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_per_person_rows.htm"));
		$perPersonGroupRowHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_per_person_group_rows.htm"));
		foreach($result['perPersonItems'] as $perPersonItem) {
			$perPersonItem['rate_groups'] = array_reduce($perPersonItem['rate_groups'], function($html, $group) use ($perPersonGroupRowHTML) {
				$html .= showpage($group,$perPersonGroupRowHTML);
				return $html;
			}, "");
			$perPersonRows .= showpage($perPersonItem, $perPersonHTML);
		}
		if($perPersonRows != "") {
			$GLOBALS['temp']['perPersonRows'] = $perPersonRows;
		} else {
			$GLOBALS['temp']['perPersonRows'] = "<tr><td colspan=\"8\" class=\"txti\" align=\"center\">No per person charges</td></tr>";
		}

		$GLOBALS['temp']['exchNote'] = $result['exchange']['note'];
		$exchangeHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_exchange_item_rows.htm"));
		$exchangeRows = "";
		
		foreach($result['exchange']['extras'] as $item) {
			$exchangeRows .= showpage($item,$exchangeHTML);
		}
		if(trim($exchangeRows) != "") {
			$GLOBALS['temp']['exchRows'] = $exchangeRows;
		} else {
			$GLOBALS['temp']['exchRows'] = "<tr><td colspan=\"4\" class=\"txti\" align=\"center\">No exchange rates</td></tr>";
		}

		$propNotes = "";
		foreach($result['propertyNotes'] as $item) {
			$propNotes .= "<u>".$item['pr_name_last'] ."</u><br>" . t_encodeHTML($item['pr_bus_memo_info']) . "<br><br>";
		}
		$GLOBALS['temp']['propNotes'] = $propNotes;

		$terms = $lDB->get("select rf_booking_info from rf_custom where rf_custom_id = 1",4);
		$bookingTerms = urldecode($terms);
				
		$GLOBALS['temp']['bookingTerms'] = $bookingTerms;

		if (empty($specials)) { // No specials applied
			$GLOBALS['temp']['specialDetail'] = "None";
		} else { // Special is active, display by default
			$appliedSpecial = '';
			foreach ($specials as $special) {
				$appliedSpecial .= '<div>'.$special['sp_special_desc'].'</div>';
				$appliedSpecial .= '<div class="docSpecialNoteDetail" style="margin-bottom:5px;">&nbsp;-&nbsp;'.$special['sp_special_note'].'</div>';
			}
			$GLOBALS['temp']['specialDetail'] = $appliedSpecial;

			$GLOBALS['temp']['specialDetailDefault'] = "";
			$GLOBALS['temp']['specialChecked'] = "checked";
			$GLOBALS['temp']['specialNoteChecked'] = "checked";
			$GLOBALS['temp']['specialNoteExpanded'] = "";
		}

		$bankHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_itinerary_bank_row.htm"));
		$bankInfo = "";
		foreach($result['bankInfo'] as $item) {
			removeBlank($item);
			$bankInfo .= showpage($item,$bankHTML);
		}
		if(trim($bankInfo) != "") {
			$GLOBALS['temp']['bankInfo'] = $bankInfo;
		} else {
			$GLOBALS['temp']['bankInfo'] = "No Bank Details";
		}

		$regInfo = "";
		$folioProperties = $lDB->get("SELECT DISTINCT pr_business_id FROM fn_folio WHERE rv_reservation_id = '$resId'",3);
		foreach($result['billingInfo'] as $item) {
			if (isset($item['pr_business_id']) && !in_array($item['pr_business_id'], $folioProperties)) {
				continue;
			}
			$regInfo .= "<b>$item[pr_name_last]</b>";
			
			if(trim($item['pr_bus_statutory_1']) != "" && $item['pr_bus_statutory_1'] != "0") {
				$pr_bus_statutory_1_label = $item['pr_bus_statutory_label_1'] != "" ? $item['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
				$regInfo .= "<br>".$pr_bus_statutory_1_label.": $item[pr_bus_statutory_1]";
			}
			if(trim($item['pr_bus_statutory_2']) != "" && $item['pr_bus_statutory_2'] != "0") {
				$pr_bus_statutory_2_label = $item['pr_bus_statutory_label_2'] != "" ? $item['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
				$regInfo .= "<br>".$pr_bus_statutory_2_label.": $item[pr_bus_statutory_2]";
			}
			if(trim($item['pr_bus_statutory_3']) != "" && $item['pr_bus_statutory_3'] != "0") {
				$pr_bus_statutory_3_label = $item['pr_bus_statutory_label_3'] != "" ? $item['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
				$regInfo .= "<br>".$pr_bus_statutory_3_label.": $item[pr_bus_statutory_3]";
			}
			$regInfo .= "<br>";
		}
		$GLOBALS['temp']['regInfo'] = $regInfo;
		$GLOBALS['temp']['randomId'] = md5(uniqid(rand(), 1));
	}
		
	if($renderMode == "pdf" && $renderType != "email") {
		$regInfo = "";
		$folioProperties = $lDB->get("SELECT DISTINCT pr_business_id FROM fn_folio WHERE rv_reservation_id = '$resId'",3);
		foreach($result['billingInfo'] as $item) {
			if (isset($item['pr_business_id']) && !in_array($item['pr_business_id'], $folioProperties)) {
				continue;
			}
			$regInfo .= "<B>$item[pr_name_last]</B>";
			
			if(trim($item['pr_bus_statutory_1']) != "" && $item['pr_bus_statutory_1'] != "0") {
				$pr_bus_statutory_1_label = $item['pr_bus_statutory_label_1'] != "" ? $item['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
				$regInfo .= "\n".$pr_bus_statutory_1_label.": $item[pr_bus_statutory_1]";
			}
			if(trim($item['pr_bus_statutory_2']) != "" && $item['pr_bus_statutory_2'] != "0") {
				$pr_bus_statutory_2_label = $item['pr_bus_statutory_label_2'] != "" ? $item['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
				$regInfo .= "\n".$pr_bus_statutory_2_label.": $item[pr_bus_statutory_2]";
			}
			if(trim($item['pr_bus_statutory_3']) != "" && $item['pr_bus_statutory_3'] != "0") {
				$pr_bus_statutory_3_label = $item['pr_bus_statutory_label_3'] != "" ? $item['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
				$regInfo .= "\n".$pr_bus_statutory_3_label.": $item[pr_bus_statutory_3]";
			}
			$regInfo .= "\n";
		}
		$result['regInfo'] = $regInfo;
		
		$extraNoteMemo = getMemoNoteDetails($result,false);
		$extraNote = $extraNoteMemo['extraNote'];
		$extraMemo = $extraNoteMemo['extraMemo'];
		if($docKey == "0") {
			$pdf = new PDF("\t",'P','mm','A4',false);
		} else {
			$pdf->AddPage();
		}
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$togglePlan = ($toggleMap & 1) == 1;
		$toggleRate = ($toggleMap & 2) == 2;
		$toggleReservationNote = ($toggleMap & 4) == 4;
		$toggleReservationMemo = ($toggleMap & 8) == 8;
		$toggleBankDetails = ($toggleMap & 16) == 16;
		$toggleGuestInformation = ($toggleMap & 32) == 32;
		$toggleCommission = ($toggleMap & 64) == 64;
		$toggleExtraNote = ($toggleMap & 128) == 128;
		$toggleExchNote = ($toggleMap & 256) == 256;
		$togglePropertyNoteCheck = ($toggleMap & 512) == 512;
		$toggleInternalMemoCheck = ($toggleMap & 1024) == 1024;
		
		$toggleCostSummary = ($toggleMap & 2048) == 2048;
		$toggleCancelPay = ($toggleMap & 4096) == 4096;
		$toggleTotal = ($toggleMap & 8192) == 8192;
		
		$toggleBookingTerms = ($toggleMap & 16384) == 16384;
		$togglePayReceipts = ($toggleMap & 32768) == 32768;
		$toggleTotalItem = ($toggleMap & 65536) == 65536;
		$toggleGross = ($toggleMap & 131072) == 131072;
		$togglePlanInv = ($toggleMap & 262144) == 262144;
		$toggleCreditCard = ($toggleMap & 524288) == 524288;
		$togglePerPerson = ($toggleMap & 1048576) == 1048576;
		$toggleOnlineGuestCheckIn = ($toggleMap & 2097152) == 2097152;
		$togglePublicPayments = ($toggleMap & 4194304) == 4194304;		

		$documentAddress = $result['fromAddress'];
				
		$logoY = $pdf->y;
		$resOfficeHead = "";
		$resOfficeHead = "<B>Reservation Office:</B>\n";
		
		$scalingFactor = 1/$pdf->k;
		$sideColumnWidth = $scalingFactor * 190;
		$middleColumnWidth = $pdf->GetPageWidth(1) - ($sideColumnWidth*2);

		$logoWidth = $middleColumnWidth;
		
		if($rf_doc_header_logo_yn == "1") {
			if($rf_doc_header_count == 1) {
				$logoWidth = $pdf->GetPageWidth(1);
			} elseif($rf_doc_header_count == 2) {
				$logoWidth = $sideColumnWidth + $middleColumnWidth;
			}
		} else {
			if($rf_doc_header_count == 1) {
				$logoWidth = $sideColumnWidth + $middleColumnWidth;
			}
		}
		if($rf_doc_header_count > 0) {
			if($rf_doc_header_res_office_yn == "1") {
				$pdf->MultiCell($sideColumnWidth, $pdf->FontSize+1, $resOfficeHead.t_decodeHTML($result['fromAddress']), '', 'L', 0, 1);
			}
			$pdf->MultiCell($logoWidth, $pdf->FontSize+1, "", '', 0, '', 1);
			if($rf_doc_header_invoice_yn == "1") {
				$pdf->MultiCell($sideColumnWidth-10, $pdf->FontSize+1, t_decodeHTML($result['regInfo']), '', 'L', 0, 1);
			}
			$pdf->Ln(0, 4);
			if($rf_doc_header_logo_yn == "1") {
				$server = $_SESSION['server'];
				$principal_id = $_SESSION['principal_id'];
				if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$logoFilename")) {
					$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename");
					$pic['w'] = ($pic['w'] * $scalingFactor) - 2;
					if ($pic['w'] > $logoWidth) {
						$pic['w'] = $logoWidth;
					}
					$res_logo = explode(".",$logoFilename);
					if(substr($res_logo[0],-3,3) != "pdf") {
						$pdf_logo = $res_logo[0] . '_pdf.' . $res_logo[1];
						if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$pdf_logo")) {
							$logoFilename = $pdf_logo;
						}
					}
					if($GLOBALS['system'] != "training") {
						if($rf_doc_header_logo_align == "C") {
							$logoX = ($logoWidth / 2) - ($pic['w']/2);
						} elseif($rf_doc_header_logo_align == "R") {
							$logoX = $logoWidth - $pic['w'];
						} else {
							$logoX = 0;
						}
						if($rf_doc_header_res_office_yn == "1") {
							$logoX += $sideColumnWidth;
						}
						require_once(__DIR__ . '/functions.imageset.php');
						$logoWidth = imagesetLogoSizeOverride("itinerarySummaryPdfLogoWidthOverride", $pic['w']);
						$finalH = $pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename", $logoX, $logoY, $logoWidth);
					}
					if (($logoY + $finalH) > $pdf->y) {
						$pdf->y = $logoY + $finalH;
					}
				}
			}
		}
		$pdf->Ln(2);

		if(strlen($result['docRef']) > 32) {
			$result['docRef'] = substr($result['docRef'],0,32) . "...";
		}
		$pdf->SetFont('Arial', '', 11);
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>t_decodeHTML($result['docTitle'] ." " .$result['docRef']), 'border'=>"TLR", 'style'=>"B", 'align'=>"C")
		));
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"", 'border'=>"LR")
		));
		
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$resColHead = "\nReservation:\nReservation #:\nAgent\nStatus:";
		$resColData = "\n$result[rv_res_name]\n$result[rv_reservation_id]\n$result[agent]\n$result[rf_reservation_status_desc] ";
		$dateColHead = "\nTravel Start Date:\nTravel Depart Date:\nCreated On:\nLast Updated:";
		$dateColData = "\n$result[minDate]\n$result[maxDate]\n$result[rv_date_recorded]\n$result[rv_date_changed]";
		$pdf->Row(array(
			array('width'=>"14%", 'data'=>$resColHead, 'border'=>"L", 'style'=>"B"),
			array('width'=>"52%", 'data'=>$resColData, 'border'=>""),
			array('width'=>"16%", 'data'=>$dateColHead, 'border'=>"LTB", 'style'=>"B"),
			array('width'=>"15%", 'data'=>$dateColData, 'border'=>"TRB"),
			array('width'=>"3%", 'data'=>"", 'border'=>"R")
		));
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"", 'border'=>"LBR")
		));
		
		$itenDetWidth = 33;
		if(!$toggleRate) {
			$itenDetWidth += 14;
		}
		
		$pdf->Ln(4);
		
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$headerArray = array(
			array('width'=>"15%", 'data'=>"Day/Date", 'border'=>'LRTB', 'fill'=>1),
			array('width'=>"12%", 'data'=>"Itinerary", 'border'=>'LTB', 'fill'=>1),
			array('width'=>"$itenDetWidth %", 'data'=>"", 'border'=>'RTB', 'fill'=>1),
			array('width'=>"5%", 'data'=>"Units", 'border'=>'LRTB', 'align'=>'C', 'fill'=>1),
			array('width'=>"7%", 'data'=>"Pax/Unit", 'border'=>'LRTB', 'align'=>'C', 'fill'=>1)
		);
		if($toggleRate) {
			array_push($headerArray,
				array('width'=>"14%", 'data'=>"Rate Type", 'border'=>'LRTB', 'fill'=>1)
			);
		}
		if($toggleTotal) {
			array_push($headerArray,
				array('width'=>"14%", 'data'=>"Total", 'border'=>'LRTB', 'align'=>"R", 'fill'=>1)
			);
		}

		$pdf->Row($headerArray);
		
		foreach($dayItenaryDetails as $item) {
			$itenaryType = "";
			$itenaryDesc = "";
			$itenaryUnit = "";
			$itenaryPax = "";
			$itenaryRate = "";
			$itenaryTotal = "";

			$itenaryData['doc_itenary_date'] = str_replace("<br/>","\n",$item['doc_itenary_date']);
			$dateArr = explode("\n",$itenaryData['doc_itenary_date']);
			$itenaryData['doc_itenary_date'] = $dateArr[0]."\n".str_replace(array("<B>","</B>"),"",$dateArr[1]);
			if(is_array($item['itenaryItem'])) {
				foreach($item['itenaryItem'] as $itenHead) {
					$itenaryType .= $itenHead['itenary_type']."\n";
					$itenaryDesc .= $itenHead['itenary_desc']."\n";
				}
				if($itenaryType !="") {
					$itenaryType = substr($itenaryType,0,-1);
				}
				if($itenaryDesc !="") {
					$itenaryDesc = substr($itenaryDesc,0,-1);
				}
			}
			
			$itenaryData['doc_itenary_type'] = $itenaryType;
			$itenaryData['doc_itenary_desc'] = $itenaryDesc;
			if(isset($item['units']) && is_array($item['units'])) {
				removeSpace($item['units']);
				$itenaryUnit = implode("\n",$item['units']);
			}
			
			$itenaryData['doc_itenary_unit'] = $itenaryUnit;
			if(isset($item['pax']) && is_array($item['pax'])) {
				removeSpace($item['pax']);
				$itenaryPax = implode("\n",$item['pax']);
			}
			
			$itenaryData['doc_itenary_pax'] = $itenaryPax;
			
			if(isset($item['rt_rate_type_desc']) && is_array($item['rt_rate_type_desc'])) {
				removeSpace($item['rt_rate_type_desc']);
				$itenaryRate = implode("\n",$item['rt_rate_type_desc']);
			}
			$itenaryData['doc_itenary_rate_type'] = $itenaryRate;

			if(isset($item['compAmt']) && is_array($item['compAmt'])) {
				removeSpace($item['compAmt']);
				$itenaryTotal = implode("\n",$item['compAmt']);
			}
			
			$itenaryData['doc_itenary_total'] = $itenaryTotal;
			
				$dataArray = array(
				array('width'=>"15%", 'data'=>$itenaryData['doc_itenary_date'], 'align'=>'C', 'border'=>'LRB'),
				array('width'=>"12%", 'data'=>$itenaryData['doc_itenary_type'], 'border'=>'LB'),
				array('width'=>"$itenDetWidth %", 'data'=>$itenaryData['doc_itenary_desc'], 'border'=>'RB'),
				array('width'=>"5%", 'data'=>$itenaryData['doc_itenary_unit'], 'align'=>'C', 'border'=>'LRB'),
				array('width'=>"7%", 'data'=>$itenaryData['doc_itenary_pax'], 'align'=>'C', 'border'=>'LRB')
			);
			if($toggleRate) {
				array_push($dataArray,
					array('width'=>"14%", 'data'=>$itenaryData['doc_itenary_rate_type'], 'border'=>'LRB')
				);
			}
			if($toggleTotal) {
				array_push($dataArray,
					array('width'=>"14%", 'data'=>$itenaryData['doc_itenary_total'], 'border'=>'LRB', 'align'=>"R")
				);
			}
			$pdf->Row($dataArray);
		}
		
		$pdf->Ln(4);

		if($toggleCostSummary) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(array('data'=>"Totals", 'border'=>"LRTB", 'fill'=>1)));
			$pdf->SetFont('Arial', '', $pdfFontSize);
			if($toggleGross) {
				$headerRow = array (
					array('width'=>"86%", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"14%", 'data'=>"Gross", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
				);
			} elseif($toggleCommission) {
				$headerRow =  array(
					array('width'=>"44%", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"14%", 'data'=>"Gross", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
					array('width'=>"14%", 'data'=>"Commission", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
					array('width'=>"14%", 'data'=>"Nett", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
					array('width'=>"14%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
				);
			} else {
				$headerRow = array (
					array('width'=>"86%", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"14%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
				);
			}
			$pdf->Row($headerRow);
			if($toggleTotalItem) {
				if(isset($result['compTotals']['Accommodation'][0]) && $result['compTotals']['Accommodation'][0] != "") {
					if($toggleGross) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, stripslashes($consolidatedLabel), 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
					} elseif ($toggleCommission) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, stripslashes($consolidatedLabel), 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_gross'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_comm'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_net'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
											
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, stripslashes($consolidatedLabel), 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
					}
					$pdf->Ln(0, 1);
				}
				if(isset($result['compTotals']['Extras'][0]) && $result['compTotals']['Extras'][0] != "") {
					if($toggleGross) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Extras", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
					} elseif($toggleCommission) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, "Extras", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_gross'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_comm'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_net'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Extras", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
					}
					$pdf->Ln(0, 1);
				}
				if(isset($result['compTotals']['Travel'][0]) && $result['compTotals']['Travel'][0] != "") {
					if($toggleGross) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Travel", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
						
					} elseif($toggleCommission) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, "Travel", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_gross'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_comm'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_net'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);						
						
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Travel", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					}
					$pdf->Ln(0, 1);
				}
			}
			if($toggleGross) {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Total", 'LRTB', '', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
			} elseif ($toggleCommission) { 
				$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, "Total", 'LRTB', '', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_comm']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_net']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
			} else {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Total", 'LRTB', '', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
			}
			$pdf->Ln(0, 1);
			$pdf->Ln(4);
		}
		
		if ($togglePlan) {
			if(sizeof($result['resItems']) > 0) {
				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"100%",'data'=>"Payment Plan")
				));
				$pdf->Ln(1);
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"100%",'data'=>"Payments according to the following schedule should be made:")
				));
				$pdf->Ln(4);
				$pdf->Row(array(
					array('data'=>"Plan",'fill'=>1,'border'=>'LRTB')
				));
				if(!$togglePlanInv) {
					$pdf->Row(array(
						array('width'=>"86%",'data'=>"Date Due",'fill'=>1,'border'=>'LRTB'),
						array('width'=>"14%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
					));
					foreach($result['payItems'] as $item) {
						$pdf->Row(array(
							array('width'=>"86%",'data'=>$item['pay_date'],'border'=>'LR'),
							array('width'=>"14%",'data'=>$item['rv_pay_plan_amount'] . " " . $item['rf_currency_symbol'],'border'=>'LR', 'align'=>"R")
						));
					}
				} else {
					$pdf->Row(array(
						array('width'=>"20%",'data'=>"Date Due",'fill'=>1,'border'=>'LRTB'),
						array('width'=>"66%",'data'=>"Invoicing Unit",'fill'=>1,'border'=>'LRTB'),
						array('width'=>"14%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
					));
					foreach($result['payInvItems'] as $item) {
						$pdf->Row(array(
							array('width'=>"20%",'data'=>$item['pay_date'],'border'=>'LR'),
							array('width'=>"66%",'data'=>$item['pr_name'],'border'=>'LR'),
							array('width'=>"14%",'data'=>$item['rv_pay_plan_amount'] . " " . $item['rf_currency_symbol'],'border'=>'LR', 'align'=>"R")
						));
					}
				}
				$pdf->Row(array(
					array('width'=>"100%",'data'=>"",'border'=>'T')
				));
				$pdf->Ln(4);
			}
		}
		if($togglePayReceipts) {
			if($toggleCancelPay) {
				$payedItems = $result['payedItems2'];
			} else {
				$payedItems = $result['payedItems'];
			}
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%",'data'=>"Receipts")
			));
			$pdf->Ln(1);
			if(sizeof($payedItems) != 0) {
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"11%",'data'=>"Payment Date",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"13%",'data'=>"Payer",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"9%",'data'=>"Int #",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"8%",'data'=>"Ref",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"8%",'data'=>"Method",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"14%",'data'=>"Bank / Cash Point",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"6%",'data'=>"Curr",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"8%",'data'=>"Folio",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"9%",'data'=>"Invoice",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"14%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
				));
				foreach($payedItems as $item) {
					
					$pdf->Row(array(
						array('width'=>"11%",'data'=>$item['pay_date'],'border'=>'LRTB'),
						array('width'=>"13%",'data'=>$item['pr_name_last'],'border'=>'LRTB'),
						array('width'=>"9%",'data'=>$item['rv_payment_ix'],'border'=>'LRTB'),
						array('width'=>"8%",'data'=>$item['rv_pmnt_ref'],'border'=>'LRTB'),
						array('width'=>"8%",'data'=>$item['rf_mthd_pmnt_desc'],'border'=>'LRTB'),
						array('width'=>"14%",'data'=>$item['rf_bank_acc_name'],'border'=>'LRTB'),
						array('width'=>"6%",'data'=>$item['rf_currency_symbol'],'border'=>'LRTB'),
						array('width'=>"8%",'data'=>$item['fn_folio_folio_num'],'border'=>'LRTB'),
						array('width'=>"9%",'data'=>$item['fn_invoice_ix'],'border'=>'LRTB'),
						array('width'=>"14%",'data'=>$item['rv_payment_item_amt'] . " " . $item['invCurrSym'],'border'=>'LRTB', 'align'=>"R")
					));
				}
			}
			
			if($result['currencyCheck'] <= 1) {
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"63%",'data'=>"",'border'=>'TR', 'align'=>"R"),
					array('width'=>"23%",'data'=>"Total amount paid to date ",'border'=>'LRTB', 'fill'=>1),
					array('width'=>"14%",'data'=>$result['payedTotal']." ".$result['rf_currency_symbol'],'border'=>'LRTB', 'align'=>"R")
				));
				$pdf->Row(array(
					array('width'=>"63%",'data'=>"",'border'=>'R', 'align'=>"R"),
					array('width'=>"23%",'data'=>"Total amount STILL DUE ",'border'=>'LRTB', 'fill'=>1),
					array('width'=>"14%",'data'=>$result['payOutstanding']." ".$result['rf_currency_symbol'] ,'border'=>'LRTB', 'align'=>"R", 'style'=>"B")
				));
			}
			$pdf->Ln(4);
		}

		if($togglePerPerson) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row([
				['width'=>"100%",'data'=>"Per Person Charges"]
			]);
			$pdf->Ln(1);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row([
				['width'=>"10%",'data'=>"Arrive",'fill'=>1,'border'=>'LRTB'],
				['width'=>"10%",'data'=>"Depart",'fill'=>1,'border'=>'LRTB'],
				['width'=>"28%",'data'=>"Property",'fill'=>1,'border'=>'LRTB'],
				['width'=>"28%",'data'=>"Accomm",'fill'=>1,'border'=>'LRTB'],
				['width'=>"6%",'data'=>"Nights",'fill'=>1,'border'=>'LRTB','align'=>"R"],
				['width'=>"6%",'data'=>"Rooms",'fill'=>1,'border'=>'LRTB','align'=>"R"],
				['width'=>"6%",'data'=>"Adult",'fill'=>1,'border'=>'LRTB','align'=>"R"],
				['width'=>"6%",'data'=>"Child",'fill'=>1,'border'=>'LRTB','align'=>"R"]
			]);
			foreach($result['perPersonItems'] as $perPersonItem) {
				$pdf->Row([
					['width'=>"10%",'data'=>$perPersonItem['date_arrive'],'border'=>'LR'],
					['width'=>"10%",'data'=>$perPersonItem['date_depart'],'border'=>'LR'],
					['width'=>"28%",'data'=>$perPersonItem['pr_name_last'],'border'=>'LR'],
					['width'=>"28%",'data'=>$perPersonItem['ac_accomm_desc'],'border'=>'LR'],
					['width'=>"6%",'data'=>$perPersonItem['nights'],'border'=>'LR','align'=>"R"],
					['width'=>"6%",'data'=>$perPersonItem['rv_item_accomm_count'],'border'=>'LR','align'=>"R"],
					['width'=>"6%",'data'=>$perPersonItem['rv_item_adult_count'],'border'=>'LR','align'=>"R"],
					['width'=>"6%",'data'=>$perPersonItem['rv_item_child_count'],'border'=>'LR','align'=>"R"]
				]);
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"28%",'data'=>"",'border'=>'LR'],
					['width'=>"28%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR']
				]);
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"48%",'data'=>"Rate Group",'fill'=>1,'border'=>'LRTB'],
					['width'=>"14%",'data'=>"Per Unit / Person",'fill'=>1,'border'=>'LRTB','align'=>"R"],
					['width'=>"6%",'data'=>"Qty",'fill'=>1,'border'=>'LRTB','align'=>"R"],
					['width'=>"12%",'data'=>"Total Per Unit",'fill'=>1,'border'=>'LRTB','align'=>"R"]
				]);
				foreach($perPersonItem['rate_groups'] as $rateGroup) {
					$pdf->Row([
						['width'=>"10%",'data'=>"",'border'=>'LR'],
						['width'=>"10%",'data'=>"",'border'=>'LR'],
						['width'=>"48%",'data'=>$rateGroup['name'],'border'=>'LR'],
						['width'=>"14%",'data'=>$rateGroup['per_person'],'border'=>'LR','align'=>"R"],
						['width'=>"6%",'data'=>$rateGroup['qty'],'border'=>'LR','align'=>"R"],
						['width'=>"12%",'data'=>$rateGroup['per_night'],'border'=>'LR','align'=>"R"]
					]);
				}
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"48%",'data'=>"Total Per Night",'border'=>'LRB'],
					['width'=>"14%",'data'=>"",'border'=>'LRB','align'=>"R"],
					['width'=>"6%",'data'=>"",'border'=>'LRB','align'=>"R"],
					['width'=>"12%",'data'=>$perPersonItem['total_per_night'],'border'=>'LRB','align'=>"R"]
				]);
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LRB'],
					['width'=>"10%",'data'=>"",'border'=>'LRB'],
					['width'=>"48%",'data'=>"",'border'=>'B'],
					['width'=>"14%",'data'=>"",'border'=>'B'],
					['width'=>"6%",'data'=>"",'border'=>'B'],
					['width'=>"12%",'data'=>"",'border'=>'BR']
				]);
			}
			if(empty($result['perPersonItems'])) {
				$pdf->Row([
					['data'=>"No per person charges",'align'=>"C",'style'=>"I"]
				]);
			}
			$pdf->Ln(4);
		}

		if($showSpecial) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Special", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);

			if (empty($specials)) { // No specials applied
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "No Special", '', 1, 'L');
			} else {
				foreach ($specials as $special) {
					$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, $special['sp_special_desc'], '', 1, 'L');
					if($showSpecialNote) {
						if(trim($special['sp_special_note']) != "") {
							$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, ' - '.$special['sp_special_note'], '', 1, 'L');
						}
					}
				}
			}

			$pdf->Ln(4);
		}

		if($toggleBankDetails) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Bank Details", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);

			if(sizeof($result['bankInfo'])>0) {
				foreach($result['bankInfo'] as $item) {
					$bankDet = str_replace("<br>","\n",$item['rf_bank_detail_1']);
					$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Acc Name: ".$item['rf_bank_acc_name'] . " (" . $item['rf_currency_name'] . ")", '', 1, 'L');
					$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Acc No: ".$item['rf_bank_acc_no'], '', 1, 'L');
					$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, "Detail: ".$item['rf_bank_name'] . " - " .$bankDet, '', 1, 'L');
					$pdf->Ln(4);
				}
			} else {
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "No Bank Details", '', 1, 'L', 0);
			}
			$pdf->Ln(4);
		}
		if ($toggleExchNote) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Exchange Rate", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['exchange']['note'], '', 'L', 0, 0);
			$pdf->Ln(4);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.21, $pdf->FontSize+1, "Charge", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, "Currency Conversion", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.09, $pdf->FontSize+1, "Rate", 'LRTB', 'R', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.12, $pdf->FontSize+1, "Expiry Date", 'LRTB', 'C', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, "", '', 'L', 0, 1);
			$pdf->Ln(0, 1);
			if(sizeof($result['exchange']['extras'])>0){
				foreach($result['exchange']['extras'] as $item) {
					$pdf->Row(array(
						array('width' => "21%", 'data' => $item['ac_ext_desc'], 'border' => "LRTB"),
						array('width' => "18%", 'data' => $item['curr_conversion'], 'border' => "LRTB"),
						array('width' => "9%", 'data' => $item['rv_extra_exch_rate'], 'border' => "LRTB", 'align' => "R"),
						array('width' => "12%", 'data' => $item['exch_expiry'], 'border' => "LRTB", 'align' => "C")
					));
				}
			} else {
				$pdf->Row(array(array('width' => "60%", 'data' =>"No exchange rates", 'border' => "LRTB", 'align' => "C")));
			}
			$pdf->Ln(4);
		}
		if ($toggleReservationNote && trim($result['resNote']) != "") {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Reservation Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['resNote'], '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if ($toggleReservationMemo && trim($result['resMemo']) != "") {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Internal Memos", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['resMemo'], '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if ($toggleGuestInformation && trim($result['resGuestNote']) != "") {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Guest Information", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['resGuestNote'], '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		
		if($toggleExtraNote && (trim($extraNote) != "")) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Extras Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			if(trim($extraNote) != "") {
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $extraNote, '', 'L', 0, 0);
			}
			$pdf->Ln(4);
		}
		
		if($toggleInternalMemoCheck) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Extras Memo", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			if($extraMemo != "") {
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, "", '', 'L', 0, 0);
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $extraMemo, '', 'L', 0, 0);
			}
			$pdf->Ln(4);
		}
		if($togglePropertyNoteCheck) {
			$propNotes = "";
			foreach($result['propertyNotes'] as $item) {
				$propNotes .= $item['pr_name_last']."\n".$item['pr_bus_memo_info']."\n\n";
			}
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Property Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $propNotes, '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if($toggleBookingTerms) {
			$terms = $lDB->get("select rf_booking_info from rf_custom where rf_custom_id = 1",4);
			
			$search = array (
				"'<script[^>]*?>.*?</script>'si",  
				"'<[\/\!]*?[^<>]*?>'si",           
				"'([\r\n])[\s]+'",                 
				"'&(quot|#34);'i",                 
				"'&(amp|#38);'i",
				"'&(lt|#60);'i",
				"'&(gt|#62);'i",
				"'&(nbsp|#160);'i",
				"'&(iexcl|#161);'i",
				"'&(cent|#162);'i",
				"'&(pound|#163);'i",
				"'&(copy|#169);'i"
			);
			$replace = array (
				"",
				"",
				"\\1",
				"\"",
				"&",
				"<",
				">",
				" ",
				chr(161),
				chr(162),
				chr(163),
				chr(169)
			);
			$terms =
					str_replace("</div>","\n",
					str_replace("</DIV>","\n",
					str_replace("</p>","\n",
					str_replace("</P>","\n",
					str_replace("<br>","\n",
					str_replace("<BR>","\n",
				urldecode($terms)))))));
			$terms = preg_replace ($search, $replace, $terms);
			$terms = preg_replace_callback(
				"'&#(\d+);'",
				function($matches) {
					return chr($matches[1]);
				},
				$terms
			);

			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>"Booking Terms and Conditions")
			));
			$pdf->Ln(1);

			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>t_decodeHTML($terms))
			));
			$pdf->Ln(1);
		}

		if($toggleCreditCard) {
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"25%", 'data'=>"Authorisation to debit credit card",'style'=>"B"),
				array('width'=>"75%", 'data'=>" (Reference: ".$result['rv_reservation_id'].")")
			));
			$pdf->Ln(1);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card holder's name"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card holder's address"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>" (postal or physical)"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Passport or ID number"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"25%", 'data'=>" Date of birth"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Mother's maiden name"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);			
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card type"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Amex"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Visa"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Master"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Diners"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Other"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")

			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Credit card number"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card expiry date"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"25%", 'data'=>" Security code on reverse (CVC)"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Amount to be debited"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"25%", 'data'=>" Colour of card"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));			
			$pdf->Ln(10);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card holder's signature"),
				array('width'=>"60%", 'data'=>"", 'border'=>"B", 'align'=>"C"),
				array('width'=>"10%", 'data'=>"")
			));
			$pdf->Ln(5);
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>"Completing the credit card details authorises the service provider to deduct deposits and prepayments as detailed on this document")
			));
			$pdf->Ln(1);
		}
		
		if (trim(t_decodeHTML($proformaNote)) != "") {
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, t_decodeHTML($proformaNote), '', 'C', 0, 0);
			$pdf->Ln(4);
		}

		if ($toggleOnlineGuestCheckIn) {
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>'Online check-in','style'=>"B"),
			));
			$pdf->Write(5,'For your convenience use our ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Online Guest Services', $guestServicesUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,' to update your ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Guest List', $guestListUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,' or to ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Check In Online', $guestCheckInUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,'.');
			$pdf->Ln(8);
		}

		if ($togglePublicPayments) {
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>'Public Payments','style'=>"B"),
			));
			$pdf->Write(5,'For your convenience use our ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Pay Now', $payNowUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,' page to pay your account online.');
			$pdf->Ln(8);
		}

		if($customNotesList != "") {
			$customArray = explode(",",$customNotesList); 
			if(sizeof($customArray) > 0) {
				foreach($customArray as $custNote) {
					$customNotes = $GLOBALS['lDB']->get("
						SELECT
							rf_note_custom.rf_note_custom_desc as custNoteDesc,
							rf_note_custom.rf_note_custom_hdg as custNoteHdg
						FROM
							rf_note_custom
						WHERE
							rf_note_custom.rf_note_custom_ix = '$custNote'
					",1);
					$customItems = $GLOBALS['lDB']->get("
						SELECT
							rf_note_cust_item.rf_note_cust_item_ix as itemId,
							rf_note_cust_item.rf_note_cust_item_path as itemImgName,
							rf_note_cust_item.rf_note_cust_item_seq as itemSeq,
							rf_note_cust_item.rf_note_cust_item_text as itemText,
							rf_note_cust_item.rf_note_cust_pg_brk_yn as newPage
						FROM
							rf_note_cust_item
						WHERE
							rf_note_cust_item.rf_note_custom_id = '$custNote'
						ORDER BY
							rf_note_cust_item.rf_note_cust_item_seq
					",2);

					$hdgNewPage = "0";
					if($customItems[0]['newPage'] == "1") {
						$pdf->AddPage();
						$hdgNewPage = "1";
					}
					$pdf->Row(array(
						array('width'=>"100%", 'data'=>$customNotes['custNoteHdg'],'style'=>"B")
					));
          			$pdf->Ln(1);

					$itemNote = "";
					foreach($customItems as $item){
						if($item['newPage'] == "1" && $hdgNewPage == "0"){
							$pdf->AddPage();
						}
						if($item['itemText'] != "" || $item['itemText'] != null) {
							$pdf->Row(array(
								array('width'=>"100%", 'data'=>$item['itemText'])
							));
						} else { 
							$imgPath = "$GLOBALS[images_dir_on_disk]/".$_SESSION['principal_id']."/custom/";
							$itemNote .= $imgPath.$item['itemImgName'];
							if(file_exists($imgPath.$item['itemImgName'])) {
								$picY = $pdf->y;
								$picX = $pdf->x;
								$pic = $pdf->_parsejpg($imgPath.$item['itemImgName']);
								$finalH = $pdf->Image($imgPath.$item['itemImgName'], $picX, $picY, $pic['w']/3.5, $pic['h']/3.5);
								if (($picY + $finalH) > $pdf->y) {
									$pdf->y = $picY + $finalH;
								}
								$pdf->Ln(2);
							}
						}
						$hdgNewPage = "0";
					}
					$pdf->Ln(4);
				}
			}
		}
		
		if ($renderType == "save") {
			$pdf->OutPut('./PDF/current/invoice1.pdf');
		} elseif ($renderType == "view") {
			if($docKey == (sizeof($docList)-1)) {
				$pdf->OutPut();
				die();
			}
		} elseif ($renderType == "send") {
			if($docKey == (sizeof($docList)-1)) {
				$princName = isset($GLOBALS['princName'])?$GLOBALS['princName']:"";
				$to = $_POST['mail_to'];
				$from = $_POST['mail_from'];
				$subject = stripslashes($_POST['mail_subj']);
				$message = stripslashes($_POST['mail_body']);
				$headers = "From: ".$princName."<$from>\r\n";
				if ($pdf->state < 3) $pdf->Close();
				$pf_object_id = db_pf_object_by_name("email_document"); 
				
				$attachments = explode("|",$_POST['attachments']);
				
				$error = email($from, $to, $subject, $headers, $message, 0, 0, $resId, $princName, $pdf->buffer, $result['rv_reservation_id'].".pdf",$pf_object_id,$attachments);
				if (!$error) {
					echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				} else {
					echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				}
				session_restart();
				unset($_SESSION['documentComment']);
				unset($_SESSION['documentAddress']);
				session_write_close();
				die();
			}
		}
	}

	if($renderMode == "pdf" && $renderType == "email") {
		$GLOBALS['temp'] = array_merge($result, $GLOBALS['temp']);
		$GLOBALS['temp']['formAction'] = "reservation.php?351+".$result['rv_reservation_id']."+3+sort_of_random_number+".$toggleMap."++++".$selectedBanks."+".$customNotesList."+".$hideFinancials;
		$attachmentTable = "
			<table border=\"0\" cellspacing=\"0\" width=\"100%\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/email_pdf.png\"></td>
				<td id=\"attachmentLabel\" width=\"100%\">!rv_reservation_id!.pdf</td>
			</tr>
			</table>
		";
		if(!isset($_POST['comment'])) {
			if($_SESSION['userStatusId'] == "0") {
				$commentName = trim($_SESSION['publicData']['pr_name_first']." ".$_SESSION['publicData']['pr_name_last']);
				$commentTel = $_SESSION['publicData']['telephone'];
				$commentFax = $_SESSION['publicData']['fax'];
				$addresseeEmail = getContactEmail($resOfficeId);
				$GLOBALS['temp']['emailTo'] = $addresseeEmail;
			} else {
				$commentName = getContactName($GLOBALS['userid']);
				$commentTel = getContactTelephone($GLOBALS['userid']);
				$commentFax = getContactFax($GLOBALS['userid']);
			}
			$commentFax = str_pad($commentFax, (strlen($commentFax)+12)," ",STR_PAD_LEFT);
			$email_text = "We trust all is in order. Should you require any further assistance please contact us.\n\nRegards,\n$commentName";
			if(trim($commentTel) != "" && $commentTel != "0") {
				$email_text .=  "\nTel: " . $commentTel;
			}
			if(trim($commentFax) != "" && $commentFax != "0") {
				$email_text .= "\nFax: " . $commentFax;
			}
		} else {
			$email_text = stripslashes($_POST['comment']);
		}
		
		$email_text .= "\n\nAdobe Reader is recommended to open the attached PDF document. Adobe Reader can be downloaded at http://www.adobe.com\n";
		$emailToSetup = "";
		$relate = relatedEmailAddress($resId);
		
		foreach($relate as $item) {
			$emailToSetup .= "emailToName[emailToName.length] = \"".$item['name']."\"; emailToAddress[emailToAddress.length] = \"".$item['email']."\";";
		}
		if($_SESSION['userStatusId'] == "0") {
			$emailToSetup .= "showSearch = false;";
		}
		if(sizeof($docList) > 1 && $_SERVER['argv'][3] != "") { 
			$GLOBALS['temp']['folioId'] = $_SERVER['argv'][3];
		}
		$pf_object_name = "email_document";
		
		$autoCC = array();
		$autoClass = "collapse printCollapse";
		if(db_pf_object_exists_by_name($pf_object_name)) {
			$autoCC = getAutoCC(db_pf_object_by_name($pf_object_name));
			if(sizeof($autoCC) > 0) {
				$autoClass = "expand";
			}
		}

		$billingEmail = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_email
			FROM
				rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id
			WHERE
				rv_reservation.rv_reservation_ix = '$resId'
		",4);
		$invoiceEmail = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_email
			FROM
				rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id
			WHERE
				rv_reservation.rv_reservation_ix = '$resId'
		",4);
		
		// If we have a default template
		$template_toggle = "";
		if($templateData['text'] !== false) {
			$email_text = $templateData['text'];
			$template_toggle = $templateData['toggle'];
		}
		
		$GLOBALS[$form]->FormHTML =
			str_replace("!emailToSetup!", str_replace("'", "\\'", $emailToSetup),
			str_replace("!emailTo!","",
			str_replace("!billingEmail!",$billingEmail,
			str_replace("!invoiceEmail!",$invoiceEmail,
			str_replace("!toggleMap!", $toggleMap,
			str_replace("!email_type!", "3",
			str_replace("!attachmentInfo!", $attachmentTable,
			str_replace("!hasAttachment!", "expand",
			str_replace("!emailBody!", $email_text,
			str_replace("!auto_cc_class!",$autoClass,
			str_replace("!auto_cc!",join(", ",$autoCC),
			str_replace("!templateToggle!", $template_toggle,
			str_replace("!attachmentToggle!", attachmentToggle(),
			Join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))))))))));

		if ($_SESSION['userStatusId'] == "0") {
			$GLOBALS[$form]->FormHTML = str_replace("!emailToSetup!", "showSearch = false;", $GLOBALS[$form]->FormHTML);
		}
		$resIdList = "";
		foreach($docList as $resIdItem) {
			if($resIdList != "") {
				$resIdList .= ", ";
			}
			$resIdList .= $resIdItem['resId'];
		}
		$GLOBALS['temp']['emailSubject'] = "$result[rv_res_name] ($resIdList)";
		if(isset($_POST['comment']) && $_POST['comment'] != "") {
			session_set("documentComment",$_POST['comment']);
		}
		if(isset($_POST['address']) && $_POST['address'] != "") {
			session_set("documentAddress",t_decodeHTML($_POST['address']));
		}
		$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_email
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$_SESSION[userid]'
		",4);
		$GLOBALS['temp']['princName'] = $principalName;
	}
	
	if ( $renderMode == "xls" || $renderMode == "oofice") { 
		$repName = $result['rv_reservation_id']."-".$result['rv_res_name'];
		if ( $renderMode == "oofice" ) {
			$repName = $repName.".xml";
		} else {
			$repName = $repName.".xlsx";
		}
		
		outputCSV($result, $toggleMap, $repName, $proformaNote, $customNotesList);
	}
}

foreach($GLOBALS['temp'] as $key=>$item) {
	if(is_array($item)) {
		$GLOBALS['temp'][$key] = "";
	}
}
