<?php

/**
 * init.form396.func.php - API Audit Report
 * Job: 352
 * Function: 116 (Code Tables: API Audit)
 */

require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.csv.php');
require_once(__DIR__ . '/functions.pdf.php');
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.datetime.php');

DEFINE('LAST_SEVEN_DAYS_OPT',0);
DEFINE('LAST_FOURTEEN_DAYS_OPT',1);
DEFINE('LAST_WEEK_OPT',2);
DEFINE('THIS_MONTH_OPT',3);
DEFINE('LAST_MONTH_OPT',4);
DEFINE('CUSTOM_DATE_OPT',5);

$profileFields = array(
	/*  1 */ "fromDate",
	/*  2 */ "toDate",
	/*  3 */ "userIds",
	/*  4 */ "funcName",
	/*  5 */ "dateOpt",
	/*  6 */ "sortby",
	/*  7 */ "filters",
	/*  8 */ "renderOption",
	/*  9 */ "pageid"
);

function calculateDate($dateOpt=5) {
	switch($dateOpt) {
	case LAST_SEVEN_DAYS_OPT:
		$Start = strtotime("-8 days");
		$End = strtotime("-1 days");
		$date['start'] = date('Y-m-d',$Start); 
		$date['end'] = date('Y-m-d',$End); 
		break;
	case LAST_FOURTEEN_DAYS_OPT:
		$Start = strtotime("-15 days");
		$End = strtotime("-1 days");
		$date['start'] = date('Y-m-d',$Start); 
		$date['end'] = date('Y-m-d',$End); 
		break;
	case LAST_WEEK_OPT:
		$currentDay = date('w');
		$startDay = $currentDay+6;
		$endDay = $currentDay;
		$lastwkStart = strtotime("-$startDay days");
		$lastwkEnd = strtotime("-$endDay days");
		$date['start'] = date('Y-m-d',$lastwkStart); 
		$date['end'] = date('Y-m-d',$lastwkEnd);
		break;
	case THIS_MONTH_OPT:
		$startDay = date('d')-1;
		$endDay = date('t')-date('d');
		$monthStart = strtotime("-$startDay days");
		$monthEnd = strtotime("+$endDay days");
		$date['start'] = date('Y-m-d',$monthStart); 
		$date['end'] = date('Y-m-d',$monthEnd); 
		break;
	case LAST_MONTH_OPT:
		$endDay = date('d');
		$lastMonthEnd = strtotime("-$endDay days");
		$date['start'] = date('Y-m-d',mktime(0, 0, 0, date("m")-1, 1,   date("Y"))); 
		$date['end'] = date('Y-m-d',$lastMonthEnd); 
		break;
	default:
	case CUSTOM_DATE_OPT:
		$date['start'] = date('Y-m-d'); 
		$date['end'] = date('Y-m-d'); 
		break;
	}

	return $date;
}
function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;

	$pdfName = "API Audit Report - $fromDate to $toDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,8))."+$newOptions+".join("+",array_slice($_SERVER['argv'],9,1));

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);
	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}
