<?php

/**
 * init.form396.php - Display API Audit Report
 * Job: 352
 * Function: 116 (Code Tables: API Audit)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("audit_api_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "API Audit Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_api_audit.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$_SERVER['argv'] = array_pad($_SERVER['argv'],12,"");
$printString = "";
$pString = "";
$dbClause = "";
$dbOrder = "";

$sortBy = "1";

$last7daysRange = calculateDate(LAST_SEVEN_DAYS_OPT);
$last14daysRange = calculateDate(LAST_FOURTEEN_DAYS_OPT);
$lastWeekRange = calculateDate(LAST_WEEK_OPT);
$thisMonthRange = calculateDate(THIS_MONTH_OPT);
$lastMonthRange = calculateDate(LAST_MONTH_OPT);
$customDateRange = calculateDate(CUSTOM_DATE_OPT);

$GLOBALS['temp']['last7daysStart'] = $last7daysRange['start'];
$GLOBALS['temp']['last7daysEnd'] = $last7daysRange['end'];
$GLOBALS['temp']['last14daysStart'] = $last14daysRange['start'];
$GLOBALS['temp']['last14daysEnd'] = $last14daysRange['end'];
$GLOBALS['temp']['lastWeekStart'] = $lastWeekRange['start'];
$GLOBALS['temp']['lastWeekEnd'] = $lastWeekRange['end'];
$GLOBALS['temp']['thisMonthStart'] = $thisMonthRange['start'];
$GLOBALS['temp']['thisMonthEnd'] = $thisMonthRange['end'];
$GLOBALS['temp']['lastMonthStart'] = $lastMonthRange['start'];
$GLOBALS['temp']['lastMonthEnd'] = $lastMonthRange['end'];
$GLOBALS['temp']['customDateStart'] = $customDateRange['start'];
$GLOBALS['temp']['customDateEnd'] = $customDateRange['end'];

$timezone = !empty($_SERVER['argv'][11]) ? $_SERVER['argv'][11] : date("e");

$GLOBALS['temp']['timezoneName'] = $timezone;
$GLOBALS['temp']['timezoneFilterContainer'] = timezoneFilterContainerHTML();

if(trim($_SERVER['argv'][6]) != "") {
	$sortBy = $_SERVER['argv'][6];
}

$GLOBALS['temp']['hideAll'] = "1";
if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['hideAll'] = "0";
}


$GLOBALS['temp']['funcName'] = $_SERVER['argv'][4];
$funcName = strtoupper(str_replace("*","%",urldecode($_SERVER['argv'][4])));

$dateOpt = $_SERVER['argv'][5];
if(empty($dateOpt)) {
	$dateOpt = 6;
}
$dateOpt -= 1; 

$fromDate = $_SERVER['argv'][1] != "" ? $_SERVER['argv'][1] : "";
$toDate = $_SERVER['argv'][2] != "" ? $_SERVER['argv'][2] : "";

$GLOBALS['temp']['dateOpt'] = $dateOpt;

$splitFrom = useDate("from", $fromDate);
$splitTo = useDate("to", $toDate);

$GLOBALS['temp']['splitFrom'] = $splitFrom['jsDate'];

if(trim($toDate) != "") {
	$GLOBALS['temp']['splitTo'] = $splitTo['jsDate'];
} else {
	$GLOBALS['temp']['splitTo'] = date("Y-m-d",time());
}

if(trim($fromDate) != "") {
	$GLOBALS['temp']['splitFrom'] = $splitFrom['jsDate'];
} else {
	$GLOBALS['temp']['splitFrom'] = date("Y-m-d",time());
}

$GLOBALS['temp']['printFrom'] = $splitFrom['htmlDate'];
$GLOBALS['temp']['printTo'] = $splitTo['htmlDate'];
$dateExtra = "";

if($fromDate && $toDate) {
	$fromDate .= " 00:00:00";
	$toDate .= " 23:59:59";
	$dateExtra = "AND (ad_api.ad_api_time <= '" . $toDate . "' AND ad_api.ad_api_time >= '" . $fromDate . "')";
}

$filterStatus = $_SERVER['argv'][7];
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "expand";
}
$GLOBALS['temp']['filterValue'] = "<< Hide Filters";
if($_SERVER['argc']>1) {
	$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
	$GLOBALS['temp']['filterValue'] = "<< Show Filters";
}

$userFilter = useFilter("api_audit_user",$_SERVER['argv'][3],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","ad_api.pr_user_id",false,"All User","0");

$GLOBALS['temp']['batch_name'] = "Custom";

$dbClause = " WHERE  ad_api.ad_api_function LIKE '" . $funcName . "'" . $userFilter['where'] . " " . $dateExtra;

$page = "1";
if($_SERVER['argv'][9] > "1") {
	$page = $_SERVER['argv'][9];
}
$GLOBALS['temp']['pageid'] = (string) $page;

if($_SERVER['argc'] > 1) {

	$GLOBALS['temp']['imgSort1'] = "";
	$GLOBALS['temp']['imgSort2'] = "";
	$GLOBALS['temp']['imgSort3'] = "";
	$GLOBALS['temp']['imgSort4'] = "";
	$GLOBALS['temp']['imgSort5'] = "";
	$GLOBALS['temp']['imgSort6'] = "";
	$GLOBALS['temp']['imgSort1Mode'] = "";
	$GLOBALS['temp']['imgSort2Mode'] = "";
	$GLOBALS['temp']['imgSort3Mode'] = "";
	$GLOBALS['temp']['imgSort4Mode'] = "";
	$GLOBALS['temp']['imgSort5Mode'] = "";
	$GLOBALS['temp']['imgSort6Mode'] = "";
	
	$dbOrder = "ORDER BY ";

	switch ($sortBy) {
	case 0:
		$dbOrder .= "ad_api.ad_api_time";
		$GLOBALS['temp']['imgSort1Mode'] = "_z";
		break;
	case 1:
		$dbOrder .= "ad_api.ad_api_time DESC";
		$GLOBALS['temp']['imgSort2Mode'] = "_z";
		break;
	case 2:
		$dbOrder .= "pr_persona.pr_name_last,pr_persona.pr_name_first,ad_api.ad_api_time DESC";
		$GLOBALS['temp']['imgSort3Mode'] = "_z";
		break;
	case 3:
		$dbOrder .= "pr_persona.pr_name_last DESC,pr_persona.pr_name_first DESC,ad_api.ad_api_time DESC";
		$GLOBALS['temp']['imgSort4Mode'] = "_z";
		break;
	case 4:
		$dbOrder .= "ad_api.ad_api_function,ad_api.ad_api_time DESC";
		$GLOBALS['temp']['imgSort5Mode'] = "_z";
		break;
	case 5:
		$dbOrder .= "ad_api.ad_api_function DESC,ad_api.ad_api_time DESC";
		$GLOBALS['temp']['imgSort6Mode'] = "_z";
		break;
	}

	$options = $_SERVER['argv'][8];

	switch ($options & 7) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "";
		break;
	}
	
	 $listsql = "
		SELECT
			COUNT(*)
		FROM
			ad_api
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ad_api.pr_user_id
		$dbClause
	";
	$count = $GLOBALS['lDB']->get($listsql,1);
	$dbLimit = "";
	if($renderMode == "html") {
		$pLimit = "10";
		$limit = "35";

		$total = $count[0];
		$realCount = (string) $total / $limit;
		$erg = explode(".",$realCount);
		$pCount = (int) $realCount;
		if (isset($erg[1]) && $erg[1] != "") {
			$pCount += "1";
		}
		if ($pLimit > $pCount) {
			$pLimit = $pCount;
		}

		$pStart = $page - (int) ($pLimit/2);
		$page--;
		if ($pStart < "1") {
			$pStart = "1";
		}
		if ($pStart > $pCount) {
			$pStart = $pCount;
		}
		$pEnd = $pStart+$pLimit;
		if ($pEnd > $pCount) {
			$pEnd = $pCount+1;
		}
		if ($page > $pEnd) {
			$page = $pEnd-1;
		}
		$start = $page * $limit;
		$dbLimit = " LIMIT ".$start.", ".$limit;

		# Generate the page breaks
		$printString .= "<a class=txt> of ".$pCount." page(s)</a>";
		$pString .= "<a class=txtbr>Pages:</a> ";
		if ($pStart > "1") {
			$pString .= "<a href=\"javascript:ShowFrom(1);\" class=txtbr>First</a>, ";
		}
		for($i=$pStart;$i<$pEnd;$i++) {
			if ($i != $pStart) {
				$pString .= ", ";
			}
			$pString .= "<a class=txtbr";
			if ($i != $page+1) {
				$pString .= " href=\"javascript:ShowFrom($i);\"";
			}
			$pString .= ">".$i."</a>";
		}
		if ($pEnd < $pCount) {
			$pString .= "<a class=txtbr>...</a> <a href=\"javascript:ShowFrom(".$pCount.");\" class=txtbr>Last</a>";
		}
		$pString .= "<a class=txtbr> of ".$pCount." page(s)</a>";

		$GLOBALS['temp']['hideNext'] = "";
		$GLOBALS['temp']['hidePrev'] = "";
		$pNext = $page+2;
		$pPrev = $page;
		$GLOBALS['temp']['pNext'] = (string) $pNext;
		$GLOBALS['temp']['pPrev'] = (string) $pPrev;
		if ($page+2 > $pCount) {
			$GLOBALS['temp']['hideNext'] = " style=\"visibility:hidden;\"";
		}
		if ($page < "1") {
			$GLOBALS['temp']['hidePrev'] = " style=\"visibility:hidden;\"";
		}
			
		$count = $count[0];
		$GLOBALS['temp']['numrows'] = $count;
		$GLOBALS['temp']['ofnum'] = $printString;
		$GLOBALS['temp']['nextprev'] = $pString;
		$GLOBALS['temp']['limited'] = (string) $total;
	}
	
	
	$fromDate = date("d M Y G:i ",strtotime($fromDate));
	$toDate = date("d M Y G:i ",strtotime($toDate));
	if ( $renderMode == "pdf" && $renderType == "email" ) {
		outputMail($form,$options,$fromDate,$toDate);
	}

	$reportTitle = $GLOBALS['temp']['title'];
	$recListArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ad_api.ad_api_ix,
			ad_api.ad_api_time,
			ad_api.ad_api_time_tz,
			ad_api.ad_api_function,
			ad_api.pr_user_id,
			IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) AS pr_name
		FROM
			ad_api
			INNER JOIN pr_persona ON ad_api.pr_user_id = pr_persona.pr_persona_ix
			$dbClause
			$dbOrder
			$dbLimit
	",2);
	
	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$out = "";
		$html = Join("\n",File(__DIR__ . "/../../../public/html/rep_api_audit_row.htm"));
		$lastDate = "";
		foreach($recListArray as $audit) {
			$ad_api_datetime = convertDateTimeZone($audit['ad_api_time'], $audit['ad_api_time_tz'], $timezone);

			$audit['ad_api_date'] = $ad_api_datetime['date'];
			$audit['ad_api_time'] = "<span title=\"Original time zone: ".$audit['ad_api_time_tz'].", displaying ".$timezone."\">".$ad_api_datetime['time']."</span>";

			if($lastDate == $audit['ad_api_date']) {
				$audit['ad_api_date'] = "";
			} else {
				$lastDate = $audit['ad_api_date'];
			}
			if(!empty($audit['pr_user_id'])) {
				$audit['userImg'] = "<button onmouseout='nd()' align='right' style=\"width:20;height:20;\"  onmouseover=\"overlib('Show user information',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130)\" class='button ' onclick='event.cancelBubble = true;viewUser(\"".$audit['pr_user_id']."\")'><img src='/resource/Resrequest/Application/public/img/icon_contact_16.gif' valign='middle' class='imgLink'  ></button>";
			} else {
				$audit['userImg'] = "";
			}
			$out .= showpage($audit,$html);
		}
		if($out !="") {
			$GLOBALS['temp']['rows'] = $out;
		} else {
			$noresult = "
				<div style=\"text-align: left\">
					<p>&nbsp;&nbsp;Your search did not match any records.</p>
					<p>&nbsp;&nbsp;<b>Suggestions:</b><br />
					&nbsp;&nbsp;- Use wildcards to assist in your search<br />
					&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br />
					&nbsp;&nbsp;- Use a different keyword.</p>
				</div>
			";
			$out =  "
				<tr>
					<td colspan=\"4\" align=\"center\" class=\"txt\">" . $noresult . "</td>
				</tr>";
			$GLOBALS['temp']['rows'] = $out;
		}
	}

	if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF($reportTitle,"L");
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', 9);
		$pdf->Row(array(
			array('data'=>"<B>$reportTitle: $GLOBALS[principal_name]</B>")
		));
		$pdf->SetFont('Arial', '', 9);
		
		$headerArray = array(
			array('name'=>"Date range: ", 'value'=>$fromDate . " to " . $toDate),
			array('name'=>"User Filter: ", 'value'=>$GLOBALS['temp']['api_audit_userNames']),
			array('name'=>"Function Filter: ", 'value'=>$GLOBALS['temp']['funcName']),
			array('name'=>"Timezone display", 'value'=>$timezone)
		);
		$reportLabel = isset($reportLabel) ? $reportLabel : "";
		$pdf->ReportHeader($reportLabel, $headerArray);
		$pdf->Ln(0, 4);

		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->Row(array(array()));
		
		$headerArray = array(
			array('width'=>"20%", 'data'=>"Date/Time", 'border'=>'LRTB', 'fill'=>1),
			array('width'=>"40%", 'data'=>"User", 'border'=>'LRTB', 'fill'=>1),
			array('width'=>"20 %", 'data'=>"Function", 'border'=>'LRTB', 'fill'=>1)
		);
		$pdf->Row($headerArray);
		
		if($count != "0") {
			foreach($recListArray as $audit) {
				$ad_api_datetime = convertDateTimeZone($audit['ad_api_time'], $audit['ad_api_time_tz'], $timezone);
				$dataArray = array(
					array('width'=>"20%", 'data'=>$ad_api_datetime['datetime'], 'border'=>'LRTB'),
					array('width'=>"40%", 'data'=>$audit['pr_name'], 'border'=>'LRTB'),
					array('width'=>"20%", 'data'=>$audit['ad_api_function'], 'border'=>'LRTB')
				);
				$pdf->Row($dataArray);
			}
		}else {
			$dataArray = array(
				array('width'=>"80%", 'data'=>"No Record Found", 'border'=>'LRTB','align'=>'C')
			);
			$pdf->Row($dataArray);
		}
		
		$pdf->Ln(4);
		
		if($renderType == "view") {
			pdf_view($pdf);
		}
		if($renderType == "send") {
			pdf_send($pdf,$reportTitle);
		}
	}

	if ( $renderMode == "csv" ) {
		$csv = array();
		array_push($csv,array($reportTitle));
		array_push($csv,array());
		array_push($csv,array("Date range:",$fromDate . " to " . $toDate));
		array_push($csv,array("User Filter:",$GLOBALS['temp']['api_audit_userNames']));
		array_push($csv,array("Function Filter",$GLOBALS['temp']['funcName']));
		array_push($csv,array("Timezone display",$timezone));
		
		array_push($csv,array());
		
		array_push($csv,array("Date/Time","User","Function"));
		if($count != "0") {
			foreach($recListArray as $audit) {
				$ad_api_datetime = convertDateTimeZone($audit['ad_api_time'], $audit['ad_api_time_tz'], $timezone);
				array_push($csv,array($ad_api_datetime['datetime'],$audit['pr_name'],$audit['ad_api_function']));
			}
		} else {
			array_push($csv,array("No record Found"));
		}
		csv_output("Api_Audit"."_".$splitFrom['htmlDate'] . "_to_" . $splitTo['htmlDate'],$csv);
	}
}
$GLOBALS['temp']['sortby'] = $sortBy;
