<?php

/**
 * init.form397.php - Booking wizard step 3 (guests)
 * Job: 353
 * Function: 50 (Availability calendar)
 */

if($_SESSION['takenStep3']) {
	redirectTo(" reservation.php?693");
	die();
}
/*
    Check if reservation status is still provisional (25)
*/
$wizResId = isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "";
$wizResStatus = $lDB->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '{$wizResId}'", 4);

//Check if Reservation status in the db is still "In Progress"
//AND if the  status is not posted
//OR status is posted but is still "In Progress"
if( $wizResStatus == 25 &&
    (!isset($_POST['rf_reservation_status_id']) ||
    (isset($_POST['rf_reservation_status_id']) && $_POST['rf_reservation_status_id'] == 25))){
    session_set("wizResStatusUpdated",false);
    redirectTo("reservation.php?639");
    die();
}
/* End */


// Only set takenStep3 to false if the post status is different of "In Progress"
session_set("takenStep3",false);
session_set("wizResStatusUpdated",true);

// Clear stored booking-level rate
session_set("bookingRate","");

switch($_SESSION['whichCalendar']) {
case "quick_search":
	$GLOBALS['temp']['cancelJob'] = "693";
	break;
case "rooming_module":
	$GLOBALS['temp']['cancelJob'] = "1024";
	break;
default:
	$GLOBALS['temp']['cancelJob'] = "20";
	break;
}

if ($_SESSION['userStatusId'] > 1) {
	$internal = 1;
} else {
	$internal = 0;
}

$isMaster = $tempMasterData = $GLOBALS['lDB']->isMaster;
$GLOBALS['lDB']->isMaster = "1";

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

// Globals required by add field function
$GLOBALS['form'] = $form;
$tabcount = 0;


$wizResId = isset($_SESSION['wizResId'])?$_SESSION['wizResId']:"";

$GLOBALS['temp']['rv_res_id'] = $wizResId;

$validResId = false;

if ($lDB->get("select count(*) from rv_reservation where rv_reservation_ix = '".$wizResId."'",4) > 0) {
	$validResId = true;
}

if (!$validResId) {
	redirectTo(" ./reservation.php?20");
  die();
}

$GLOBALS['temp']['today'] = date("Ymd");

if(isset($_POST['onOpenAction']) && $_POST['onOpenAction']) {
	$GLOBALS['temp']['onOpenAction'] = $_POST['onOpenAction'];
} else {
	$GLOBALS['temp']['onOpenAction'] = "";
}

if(isset($_POST['resItemId']) && $_POST['resItemId']) {
	$GLOBALS['temp']['resItemId'] = $_POST['resItemId'];
} else {
	$GLOBALS['temp']['resItemId'] = "";
}

if(isset($_POST['selectedGroupId']) && $_POST['selectedGroupId']) {
	$GLOBALS['temp']['selectedGroupId'] = $_POST['selectedGroupId'];
} else {
	$GLOBALS['temp']['selectedGroupId'] = "";
}

if(isset($_POST['selectedGuestId']) && $_POST['selectedGuestId']) {
	$GLOBALS['temp']['selectedGuestId'] = $_POST['selectedGuestId'];
} else {
	$GLOBALS['temp']['selectedGuestId'] = "";
}


if(isset($_POST['rv_reservation_name']) && $_POST['rv_reservation_name']) {
	$GLOBALS['temp']['payplanStyle'] = "";
	if ($_POST['rv_agent_id'] == "") {
		$_POST['rv_agent_id'] = "0";
	}

	$record = $wizResId;
	$GLOBALS['temp']['record'] = (string) $record;
	$method = $_SERVER['argv'][2];
	$acPayPlanId = "";
	if ($method == "genPayPlan") {
		$acPayPlanId = $_SERVER['argv'][3];
	} else {
		if ($_POST['rv_agent_id'] != "0") {
			$acPayPlanId = $GLOBALS['lDB']->get("
				SELECT
					pr_agent.ac_pay_plan_id
				FROM
					pr_agent
					INNER JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = pr_agent.ac_pay_plan_id
				WHERE
					pr_agent.pr_agent_id = '$_POST[rv_agent_id]'
					AND ac_pay_plan.ac_pay_plan_inactive_yn = '0'
			",4);
		}
	}
	if (trim($acPayPlanId) == "" || $acPayPlanId == "0") {
		$acPayPlanId = $GLOBALS['lDB']->get("SELECT ac_pay_plan_id FROM rf_default",4);
	}
	genPaymentPlan($record,$acPayPlanId);

	if ($_SESSION['userStatusId'] > "0" && $internal == 1) {
		// Update contact record
		$personaAudit = new AuditTrail($_POST['rv_corr_persona_id'],TYPE_PERSONA);
		$personaChanges = false;
		$data = $GLOBALS['lDB']->get("SELECT pr_email, pr_corr_addr_line1, pr_corr_addr_line2, pr_corr_post_code FROM pr_persona WHERE pr_persona_ix = '$_POST[rv_corr_persona_id]'",1);
		if($data['pr_email'] != $_POST['pr_email'] || $data['pr_corr_addr_line1'] != $_POST['pr_corr_addr_line1']
			|| $data['pr_corr_addr_line2'] != $_POST['pr_corr_addr_line2'] || $data['pr_corr_post_code'] != $_POST['pr_corr_post_code']) {
			if ($isMaster) $GLOBALS['lDB']->put("
				UPDATE
					pr_persona
				SET
					pr_email = '".$lDB->escape($_POST['pr_email'])."',
					pr_corr_addr_line1 = '".$lDB->escape($_POST['pr_corr_addr_line1'])."',
					pr_corr_addr_line2 = '".$lDB->escape($_POST['pr_corr_addr_line2'])."',
					pr_corr_post_code = '".$lDB->escape($_POST['pr_corr_post_code'])."'
				WHERE
					pr_persona_ix = '$_POST[rv_corr_persona_id]'
			");
			if($data['pr_email'] != $_POST['pr_email']) {
				$personaAudit->addDetail($data['pr_email'], $_POST['pr_email'], $_POST['rv_corr_persona_id'], $_POST['rv_corr_persona_id'], DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_email");
				$personaChanges = true;
			}
			if($data['pr_corr_addr_line1'] != $_POST['pr_corr_addr_line1']) {
				$personaAudit->addDetail($data['pr_corr_addr_line1'], $_POST['pr_corr_addr_line1'], $_POST['rv_corr_persona_id'], $_POST['rv_corr_persona_id'], DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_corr_addr_line1");
				$personaChanges = true;
			}
			if($data['pr_corr_addr_line2'] != $_POST['pr_corr_addr_line2']) {
				$personaAudit->addDetail($data['pr_corr_addr_line2'], $_POST['pr_corr_addr_line2'], $_POST['rv_corr_persona_id'], $_POST['rv_corr_persona_id'], DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_corr_addr_line2");
				$personaChanges = true;
			}
			if($data['pr_corr_post_code'] != $_POST['pr_corr_post_code']) {
				$personaAudit->addDetail($data['pr_corr_post_code'], $_POST['pr_corr_post_code'], $_POST['rv_corr_persona_id'], $_POST['rv_corr_persona_id'], DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_corr_post_code");
				$personaChanges = true;
			}
		}

		// Update Fax
		$sql = "SELECT COUNT(*) FROM pr_phone WHERE rf_phone_type_id = 'RS1' AND pr_persona_id = '$_POST[rv_corr_persona_id]'";
		if (trim($_POST['contact_fax']) != "" && $GLOBALS['lDB']->get($sql,4) == "0") {
			// Add New
			$GLOBALS['lDB']->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_persona_id,
					rf_phone_type_id,
					pr_phone_number
				) VALUES (
					'$GLOBALS[dbcode]',
					'$_POST[rv_corr_persona_id]',
					'RS1',
					'$_POST[contact_fax]'
				)
			");
			$key = $GLOBALS['lDB']->insert_id;
			$personaAudit->addDetail("", $_POST['contact_fax'], "", $key, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
			$personaAudit->addDetail("", "RS1", "", $key, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
			$personaChanges = true;
		} else {
			$data = $GLOBALS['lDB']->get("SELECT pr_phone_ix,pr_phone_number FROM pr_phone WHERE pr_persona_id = '$_POST[rv_corr_persona_id]' AND rf_phone_type_id = 'RS1' LIMIT 1",1);
			$id = $data['pr_phone_ix'];
			$number = $data['pr_phone_number'];
			if ($_POST['contact_fax'] != $number) {
				// Update existing
				if ($isMaster) {
					$GLOBALS['lDB']->put("UPDATE pr_phone SET pr_phone_number = '".$lDB->escape($_POST['contact_fax'])."' WHERE pr_phone_ix = '$id'");

					$personaAudit->addDetail($number, $_POST['contact_fax'], $id, $id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "phone", "pr_phone.pr_phone_number");
					$personaChanges = true;
				}
			}
		}

		// Update default Telephone
		$sql = "SELECT COUNT(*) FROM pr_phone WHERE pr_default_yn = '1' AND pr_persona_id = '$_POST[rv_corr_persona_id]'";
		if (trim($_POST['contact_telephone']) != "" && $GLOBALS['lDB']->get($sql,4) == "0") {
			// Add New
			$def = $GLOBALS['lDB']->get("SELECT rf_phone_type_id FROM rf_default",4);
			$GLOBALS['lDB']->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_persona_id,
					rf_phone_type_id,
					pr_phone_number,
					pr_default_yn
				) VALUES (
					'$GLOBALS[dbcode]',
					'$_POST[rv_corr_persona_id]',
					'$def',
					'$_POST[contact_telephone]',
					'1'
				)
			");
			$key = $GLOBALS['lDB']->insert_id;
			$personaAudit->addDetail("", 1, "", $key, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
			$personaAudit->addDetail("", $_POST['contact_telephone'], "", $key, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
			$personaAudit->addDetail("", $def, "", $key, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
			$personaChanges = true;
		} else {
			$data = $GLOBALS['lDB']->get("SELECT pr_phone_ix,pr_phone_number FROM pr_phone WHERE pr_persona_id = '$_POST[rv_corr_persona_id]' and pr_default_yn = '1' LIMIT 1",1);
			$id = $data['pr_phone_ix'];
			$number = $data['pr_phone_number'];
			if ($_POST['contact_telephone'] != $number) {
				// Update existing
				if ($isMaster) {
					$GLOBALS['lDB']->put("UPDATE pr_phone SET pr_phone_number = '".$lDB->escape($_POST['contact_telephone'])."' WHERE pr_phone_ix = '$id'");
					$personaAudit->addDetail($number, $_POST['contact_telephone'], $id, $id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "phone", "pr_phone.pr_phone_number");
					$personaChanges = true;
				}
			}
		}
		if ($personaChanges) {
			$personaAudit->save("Contact details (Edit)");
		}
		// end contact record
	}

	$invoice_persona = "";
	if ($_POST['rv_agent_id'] != "0") {
		$invoice_persona = $_POST['rv_agent_id'];
		if ($_POST['rv_corr_persona_id'] == "0") {
			$billing_persona = $_POST['rv_agent_id'];
		}
	}

	if ($_POST['rv_corr_persona_id'] != "0") {
		$billing_persona = $_POST['rv_corr_persona_id'];
		if ($invoice_persona == "0" || $invoice_persona == "") {
			$invoice_persona = $_POST['rv_corr_persona_id'];
		}
	}

	// update the status information
	$today = date("Y-m-d");
	switch($_POST['rf_reservation_status_id']) {
	case "0":
		$status = "quotation";
		$status_result = "Please provide a quotation for this request - we acknowledge that no space is being held on our behalf.";
		break;
	case "10":
		$status = "waitlisted";
		$status_result = "We acknowledge that this reservation includes dates over which no accommodation is currently available.&nbsp;&nbsp;Please waitlist this reservation and advise us<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;when / if the rooms become available.";
		break;
	case "20":
		$status = "provisional";
		$status_result = "Please hold this reservation on a provisional basis only and advise us (by return email) the date on which this reservation status should be confirmed.";
		break;
	case "30":
		$status = "confirmed";
		$status_result = "Please confirm this reservation and forward the relevant documentation.";
		break;
	}

	// update the reservation
	/* All notes need to be stored in plain ASCII!
		rv_note_general = '".htmlspecialchars($note_general,ENT_QUOTES)."',
		rv_note_internal = '".htmlspecialchars($_POST[rv_note_internal],ENT_QUOTES)."',
	*/

	$GLOBALS['lDB']->put ("
		UPDATE
			rv_reservation
		SET
			rv_res_name = '".$lDB->escape($_POST['rv_reservation_name'])."',
			rf_source_ix = '".$lDB->escape($_POST['rf_source_ix'])."',
			rv_corr_persona_id = '".$lDB->escape($_POST['rv_corr_persona_id'])."',
			rv_origin_agent_id = '".$lDB->escape($_POST['rv_origin_agent_id'])."',
			rv_billing_persona_id = '".$lDB->escape($billing_persona)."',
			rv_invoice_persona_id = '".$lDB->escape($invoice_persona)."',
			rv_agent_ref = '".$lDB->escape($_POST['rv_agent_ref'])."'
		WHERE
			rv_reservation_ix = '$wizResId'
	");
	$provision_expiry_date = isset($_POST['pYear']) && isset($_POST['pMonth']) && isset($_POST['pDay']) ? $_POST['pYear']."-".$_POST['pMonth']."-".$_POST['pDay'] : false;
	db_rv_reservation_set_status($wizResId,$_POST['rf_reservation_status_id'],$provision_expiry_date, false, false);
	db_rv_note_insert($wizResId,$_POST['rf_country_id'],false,$_POST['rv_note_general'],false,$_POST['rv_note_internal']);

	// Check that the accommodation folios are being billed to someone. If not, bill to the contact.
	$folioIdList = $GLOBALS['lDB']->get("SELECT fn_folio_id FROM rv_reservation_item WHERE rv_reservation_id = '$wizResId'",3);
	foreach($folioIdList as $folioId) {
		$folioToId = $GLOBALS['lDB']->get("SELECT fn_folio_to_id FROM fn_folio WHERE fn_folio.fn_folio_ix = '$folioId'",4);
		$agentCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(pr_persona.pr_persona_ix)
			FROM
				rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
			WHERE
				rv_reservation.rv_reservation_ix = '$wizResId'
		",4);
		if($folioToId != $_POST['rv_corr_persona_id'] && $agentCount < 1) {
			$GLOBALS['lDB']->put("UPDATE fn_folio SET fn_folio_to_id = '$_POST[rv_corr_persona_id]' WHERE fn_folio_ix = '$folioId'");
		}
	}
	// END folio check
}

// Decide which FormHTML to use
if ($internal == "1"){
	if(!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/cal_step2_guest_detailsINT.htm");
	}
	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/cal_step2_guest_detailsINT.htm";
}

/*validResId($wizResId);

//$validResId = false;

if ($lDB->get("SELECT count(*) FROM rv_reservation WHERE rv_reservation_ix = '".$wizResId."'",4) > 0) {
	$validResId = true;
}

if (!$validResId) {
	redirectTo(" ./reservation.php?20");
  die();
} */

$resDetails = $GLOBALS['lDB']->get("SELECT rf_country_id, rv_note_guests FROM rv_reservation WHERE rv_reservation_ix = '".$wizResId."'", 1);

$GLOBALS[$form]->Arguments = "353";

addFormField("guest_nationality","85");
addFormField("rf_country_id");

// Exception fields (textbox)
$GLOBALS[$form.'_guest_nationality']->StyleType = "txt";
$GLOBALS[$form.'_guest_nationality']->Width = "365";

if(trim($resDetails['rf_country_id']) != "" && $resDetails['rf_country_id'] != "0") {
	$temp = $GLOBALS['lDB']->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '".$resDetails['rf_country_id']."'", 4);
	if(trim($temp) != "" && $temp != "0") {
		$GLOBALS[$form.'_guest_nationality']->Value = $temp;
	} else {
		$GLOBALS[$form.'_guest_nationality']->Value = "Unknown";
	}
	$GLOBALS[$form."_rf_country_id"]->Value = $resDetails['rf_country_id'];
} elseif (isset($_POST['rf_country_id']) && $_POST['rf_country_id'] != "") {
	// Populate field when form submitted (specifically when opening popup and page "refreshes")
	$temp = $GLOBALS['lDB']->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '".$_POST['rf_country_id']."'", 4);
	if(trim($temp) != "" && $temp != "0") {
		$GLOBALS[$form.'_guest_nationality']->Value = $temp;
		$GLOBALS[$form."_rf_country_id"]->Value = $_POST['rf_country_id'];
	}
}

$fieldname = "guest_names";
$GLOBALS['temp']['guestCaption'] = 'Guest names';
$GLOBALS[$form]->AddField($form."_".$fieldname,$fieldname,"","5");
$GLOBALS[$form.'_'.$fieldname]->Rows = "5";
$GLOBALS[$form.'_'.$fieldname]->Cols = "80";
$GLOBALS[$form.'_'.$fieldname]->StyleType = "txt";
$GLOBALS[$form.'_'.$fieldname]->TabIndex = 4;

// Populate field when form submitted (specifically when opening popup and page "refreshes")
if (isset($_POST['guest_names']) && trim($_POST['guest_names']) != "") {
	$GLOBALS[$form.'_'.$fieldname]->Value = $_POST['guest_names'];
} else {
	$GLOBALS[$form.'_'.$fieldname]->Value = "";
}

// Default select "Travelled Before" when form submitted (specifically when opening popup and page "refreshes")
if (isset($_POST['travelBefore'])) {
	if ($_POST['travelBefore'] == "1") {
		$GLOBALS['temp']['travelBefore1'] = "checked";
		$GLOBALS['temp']['travelBefore0'] = "";
	} else {
		$GLOBALS['temp']['travelBefore1'] = "";
		$GLOBALS['temp']['travelBefore0'] = "checked";
	}
} else {
	$GLOBALS['temp']['travelBefore1'] = "";
	$GLOBALS['temp']['travelBefore0'] = "";
}

if(trim($resDetails['rv_note_guests']) != "") {
	$GLOBALS[$form.'_'.$fieldname]->Value = $resDetails['rv_note_guests'];
	$GLOBALS['temp']['guestCaption'] = 'Guest Information';
}

$fieldname = "guest_notes";
$GLOBALS[$form]->AddField($form."_".$fieldname,$fieldname,"","5");
$GLOBALS[$form."_".$fieldname]->Rows = "5";
$GLOBALS[$form."_".$fieldname]->Cols = "80";
$GLOBALS[$form."_".$fieldname]->StyleType = "txt";
//$GLOBALS[$form."_".$fieldname]->TabIndex = 5;

// Populate field when form submitted (specifically when opening popup and page "refreshes")
if (isset($_POST['guest_notes']) && trim($_POST['guest_notes']) != "") {
	$GLOBALS[$form.'_'.$fieldname]->Value = $_POST['guest_notes'];
} else {
	$GLOBALS[$form.'_'.$fieldname]->Value = "";
}

if (isset($_POST['textarea']) && trim($_POST['textarea']) != "") {
	$GLOBALS['temp']['textarea_diet'] = $_POST['textarea'];
} else {
	$GLOBALS['temp']['textarea_diet'] = "";
}

if (isset($_POST['textarea2']) && trim($_POST['textarea2']) != "") {
	$GLOBALS['temp']['textarea_lpc'] = $_POST['textarea2'];
} else {
	$GLOBALS['temp']['textarea_lpc'] = "";
}


$GLOBALS['temp']['dietClass'] = '';
$GLOBALS['temp']['lpcClass'] = '';
$GLOBALS['temp']['travelBeforeClass'] = '';
if(strpos($resDetails['rv_note_guests'],"Repeat visitors:") !== false) {
	$GLOBALS['temp']['travelBeforeClass'] = 'class="collapse"';
}
if(strpos($resDetails['rv_note_guests'],"Dietary Requirements:") !== false) {
	$GLOBALS['temp']['dietClass'] = 'class="collapse"';
}

if(strpos($resDetails['rv_note_guests'],"Last Point of Contact:") !== false) {
	$GLOBALS['temp']['lpcClass'] = 'class="collapse"';
}

// End form fields

if(isset($_POST['copyguestList']) && $_POST['copyguestList'] != "") {
	$guestList = explode(":",$_POST['copyguestList']);
	$resItemId = $_POST['copyresItemId'];
}

if(isset($_POST['removeGroupId']) && $_POST['removeGroupId'] != "") {
	if($_POST['deleteAct'] == "group") {
		db_rv_res_item_guest_delete_by_group($_POST['removeGroupId']);
	} else {
		db_rv_res_item_guest_delete_by_group_guest($_POST['removeGuestId'], $_POST['removeGroupId']);
	}
	$guestName = getContactFullName($_POST['removeGuestId'],false);
	ammendReservation($wizResId,"Guests (Deleted : $guestName [".$_POST['removeGuestId']."])");
}

if(isset($_POST['guestImportList']) && $_POST['guestImportList'] != "") {
	$GLOBALS['temp']['guestImportList'] = $_POST['guestImportList'];
	$GLOBALS['temp']['resItemId'] = $_POST['resItemId'];
	$guestList = explode(":",$_POST['guestImportList']);
	$resItemId = $_POST['resItemId'];
	$groupId = $_POST['selectedGroupId'];

	if ($groupId == "" && isset($GLOBALS['newGroupId']) && $GLOBALS["newGroupId"] != "") {
		// Use the ID created earlier
		$groupId = $GLOBALS["newGroupId"];
	}

	if($groupId == "" && $resItemId != "") {
		$newGuestList = array();
		foreach($guestList as $item) {
			$check = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_res_item_guest_id)
				FROM
					rv_res_item_guest
				WHERE
					rv_reservation_item_id = '$resItemId'
				AND pr_guest_id = '$item'
			", 4);
			if($check == 0) {
			   array_push($newGuestList,$item);
			}
		}

		$guestList = $newGuestList;
		unset($newGuestList);
		if(sizeof($guestList) > 0) {
			$groupId = db_rv_res_item_group_insert($resItemId);
		}
	}
	foreach($guestList as $item) {
		db_pr_guest_insert($item);
		db_rv_reservation_guest_insert($wizResId,$item);
		if($groupId != "") {
			db_rv_res_item_guest_insert($item, $groupId);
		}
		$guestName = getContactFullName($item,false);
		ammendReservation($wizResId,"Guests (Insert: $guestName [$item])");
	}

}

if(isset($_POST['setRoomId']) && $_POST['setRoomId'] != "") {
	$args = explode("+",$_POST['setRoomId']);
	$groupId = $args[0];
	$roomList = explode(":",$args[1]);
	$resItemId = $args[2];
	// check if this room is allocated within this resItem....
	foreach($roomList as $roomId) {
		$checkAlloc = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_reservation_item_id = '$resItemId'
				AND ac_accomm_room_id = '$roomId'
				AND rv_res_item_group.rv_res_item_group_ix != '$groupId'
		",4);
		if($checkAlloc < 1) {
			$requestYN = $args[3];
			$requestReason = $_POST['requestReason'];
			if($roomId == "0" || trim($roomId) == "") {
				$requestYN = "0";
				$requestReason = "";
			}

			if($groupId == '') {
				$groupId = db_rv_res_item_group_insert($resItemId);
			}
			db_rv_res_item_group_set_room($groupId, $roomId, $requestYN, $requestReason);
		}
		$groupId = '';
	}
}
if(isset($_POST['checkInGroupId']) && $_POST['checkInGroupId'] != "") {
	db_rv_res_item_group_set_status($_POST['checkInGroupId'],5);
}
if(isset($_POST['checkOutGroupId']) && $_POST['checkOutGroupId'] != "") {
	db_rv_res_item_group_set_status($_POST['checkOutGroupId'],8);
}

if(isset($_POST['copyGroupId']) && $_POST['copyGroupId'] != "" && ($_POST['pasteGroupId'] != "" || $_POST['pasteResItemId'] != "")) {
	$fromGroupId = $_POST['copyGroupId'];
	$toGroupId = $_POST['pasteGroupId'];
	$toResItemId = $_POST['pasteResItemId'];
	$copyAct = $_POST['copyact'];
	$pasteGuestId = $_POST['pasteGuestId'];

	if($toGroupId == "") {
		$toGroupId = db_rv_res_item_group_insert($toResItemId);
	} else {
		if($copyAct == "copy" || $copyAct == "move") {
			db_rv_res_item_guest_delete_by_group($toGroupId);
		} else {
			if($pasteGuestId != "") {
				db_rv_res_item_guest_delete_by_group_guest($pasteGuestId, $toGroupId);
			}
		}
	}

	if($copyAct == "copyGuest") {
		db_rv_res_item_guest_insert($_POST['copyguestList'], $toGroupId);
	} else if($copyAct == "moveGuest") {
		$rv_res_item_guest_id = db_rv_res_item_guest_exists_by_guest_group($_POST['copyguestList'], $fromGroupId);
		db_rv_res_item_guest_set_group($rv_res_item_guest_id, $toGroupId);
		db_rv_res_item_guest_set_reservation_item($rv_res_item_guest_id, $toResItemId);
	} else {
		$guestList = $GLOBALS['lDB']->get("SELECT pr_guest_id FROM rv_res_item_guest WHERE rv_res_item_group_id = '$fromGroupId'", 3);

		foreach($guestList as $item) {
			if($copyAct == "copy") {
				db_rv_res_item_guest_insert($item, $toGroupId);
			} else {
				$rv_res_item_guest_id = db_rv_res_item_guest_exists_by_guest_group($item, $fromGroupId);
				db_rv_res_item_guest_set_group($rv_res_item_guest_id, $toGroupId);
				db_rv_res_item_guest_set_reservation_item($rv_res_item_guest_id, $toResItemId);
			}
		}
	}
}

// If non-stock-holding status has been selected, and for in case a room was specified on Step 1, remove any rooming information
if (isset($_POST['rf_reservation_status_id']) && in_array($_POST['rf_reservation_status_id'], array(0, 10, 90))) {
	removeRoomingInfo($wizResId, false);	// do not log it to the audit trail
}

// Audit trails
$reservation = $GLOBALS['lDB']->get("
	SELECT
		rv_res_name,
		rf_source_ix,
		rv_agent_id,
		rv_origin_agent_id,
		rv_corr_persona_id,
		rv_confirmation_date,
		rv_cancel_reason,
		rv_cancel_date,
		pr_reservation_user_id,
		rf_reservation_status_id,
		rv_consultant_id,
		rv_date_consultant,
		rv_agent_ref,
		rv_provision_expiry_date,
		rv_note_general,
		rv_note_internal
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$record'
", 1);
$reservationAuditTrail = new AuditTrail($record,TYPE_RESERVATION);
$moduleFieldValues = array();
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_res_name");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rf_source_ix");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_agent_id");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_origin_agent_id");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_corr_persona_id");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_confirmation_date");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.pr_reservation_user_id");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rf_reservation_status_id");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_consultant_id");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_date_consultant");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_agent_ref");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resdetail", "ad_module_field_name"=>"rv_reservation.rv_provision_expiry_date");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resnote", "ad_module_field_name"=>"rv_note.rv_note_general");
$moduleFieldValues[] = array("rf_audit_module_description_internal"=>"resnote", "ad_module_field_name"=>"rv_note.rv_note_internal");
	
foreach ($moduleFieldValues as $moduleFieldValue) {
	$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
	$reservationAuditTrail->addDetail(
		Null,
		$reservation[$moduleFieldName],
		Null,
		Null,
		DB_AD_RES_DETAIL_ACTION_ADD,
		$moduleFieldValue['rf_audit_module_description_internal'],
		$moduleFieldValue['ad_module_field_name']
	);
}
$reservationAuditTrail->save("Reservation Create - Details");

$rowCountArr = "";
$GLOBALS['temp']['rowCountArr'] = "";
if ($wizResId != "") {
	if (!$GLOBALS['lDB']->count("rv_reservation_item", "rv_reservation_id", $wizResId, 0)) {
		$reservationId = $wizResId;
		$tabcount = 8;
		$list = $lDB->get("
			SELECT
				rv_reservation_item_ix
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_id = '".$reservationId."'
			ORDER BY
				rv_item_date_arrive, ac_accomm_type_id
		", 3);

		$guestEditHTML = "
			<tr name=\"table!roomid!_!resItemId!\" id=\"table!roomid!_!resItemId!_!count!\">
				<td style=\"align:right;\">
				<input class=\"button bGuestPaste\" value=\"\" onclick=\"pasteGuest('!groupId!','!pr_persona_ix!', '!resItemId!', '!roomid!');\" style=\"width: 21px; height: 20px; text-align: left; display:none;\" type=\"button\" id=\"guest!count!_!roomid!_!resItemId!\" tabindex=\"!tab1!\"></td>
				<td>
				<input class=\"button bContImport\"  onclick=\"setData('!groupId!', '!roomid!', '!resItemId!'); guestImport();\" type=\"button\" style=\"width:20px;\" tabindex=\"!tab2!\" id=\"bImportguest!count!_!roomid!_!resItemId!\">
				</td>
				<td>
				<input type=\"text\" size=\"14\" id=\"lastname!count!_!roomid!_!resItemId!\" value=\"!pr_name_last!\" onfocus=\"lastnameFocus(!count!, '!roomid!', '!resItemId!');\" onkeydown=\"lastnameKeyDown(event,!count!, '!roomid!', '!resItemId!');\" onblur=\"blurCheck('lastname', !count!, '!roomid!', '!resItemId!');\" tabindex=\"!tab3!\" style=\"cursor:text;\"> </td>
				<td><lable for=\"firstname\"><input type=\"text\" size=\"14\" id=\"firstname!count!_!roomid!_!resItemId!\" value=\"!pr_name_first!\" onfocus=\"firstnameFocus(!count!, '!roomid!', '!resItemId!');\" onblur=\"blurCheck('firstname', !count!, '!roomid!', '!resItemId!');\" tabindex=\"!tab4!\"></lable></td>
				<td>
					<input type=\"button\" class=\"button bContactDuplicate16\" onclick=\"checkDuplicate('!count!', '!roomid!', '!pr_persona_ix!', '!groupId!','!resItemId!', '".$reservationId."');\" style=\"width:18; height:20;\" tabindex=\"!tab5!\" />
				</td>
				<td>
					<select id=\"title!count!_!roomid!_!resItemId!\" style=\"width:58px;\" tabindex=\"!tab6!\">
						<option value=\"\"></option>
						!titleOptions!
					</select>
				</td>
				<td>
					<input type=\"checkbox\" id=\"primary!count!_!roomid!_!resItemId!\" !primaryChecked! onclick=\"toggleSelectPrimary(!count!, '!roomid!', '!resItemId!');\" tabindex=\"!tab7!\">
					<input id=\"btnSelectPrimary!count!_!roomid!_!resItemId!\" type=\"button\" class=\"button bLink\" style=\"width:20; height: 20; !showSelectPrimary!\" onclick=\"showPrimary(this, !count!, '!roomid!', '!resItemId!');\" onmouseout=\"nd();\" onmouseover=\"showPrimaryOverlib(!count!, '!roomid!', '!resItemId!');\" tabindex=\"!tab8!\">
				</td>
				<td><input type=\"text\" size=\"15\" id=\"telephone!count!_!roomid!_!resItemId!\" value=\"!pr_phone_number!\" onfocus=\"telephoneFocus(!count!, '!roomid!', '!resItemId!');\" onblur=\"blurCheck('telephone', !count!, '!roomid!', '!resItemId!');\" tabindex=\"!tab9!\"></td>
				<td><input type=\"text\" size=\"15\" id=\"email!count!_!roomid!_!resItemId!\" value=\"!pr_email!\" onfocus=\"emailFocus(!count!, '!roomid!', '!resItemId!');\" onblur=\"blurCheck('email', !count!, '!roomid!', '!resItemId!');\" tabindex=\"!tab10!\"></td>
				<td><button id=\"categoryDropdownButtonguest!count!_!roomid!_!resItemId!\" type=\"button\" class=\"button bDropDown\" style=\"width: 16px; height: 20px;!existingGuest!\" onclick=\"showGuestItinMenu(event, '!groupId!', '!pr_persona_ix!', '!resItemId!', '!roomid!', '!count!');\" tabindex=\"!tab11!\"></button></td>
				<td><input type=\"button\" class=\"button bAgent\" style=\"width:18; height:20;!existingGuest!\" onclick=\"openGuest('!count!', '!roomid!', '!pr_persona_ix!','!resItemId!', '".$reservationId."');\" tabindex=\"!tab12!\" id=\"bAgentguest!count!_!roomid!_!resItemId!\">
				<input type=\"hidden\" id=\"id!count!_!roomid!_!resItemId!\" value=\"!pr_persona_ix!\">
				<input type=\"hidden\" id=\"oldTelephone!count!_!roomid!_!resItemId!\" value=\"!pr_phone_number!\">
				<input type=\"hidden\" id=\"primaryLinkId!count!_!roomid!_!resItemId!\" value=\"\">
				<input type=\"hidden\" id=\"primaryLinkCount!count!_!roomid!_!resItemId!\" value=\"\">
				<input type=\"hidden\" id=\"primaryLinkName!count!_!roomid!_!resItemId!\" value=\"!primaryName!\">
				<textarea id=\"pr_guest_note!count!_!roomid!_!resItemId!\" style=\"display:none;\">!pr_guest_note!</textarea>
				<textarea id=\"pr_guest_memo!count!_!roomid!_!resItemId!\"  style=\"display:none;\">!pr_guest_memo!</textarea>
				</td>
			</tr>
		";

		$titleArray = $GLOBALS['lDB']->get("
			SELECT
				rf_title_ix,
				rf_title_desc
			FROM
				rf_title
			WHERE
				rf_title_inactive_yn = '0'
		",2);

		$suffixArray = $GLOBALS['lDB']->get("
			SELECT
				rf_name_suffix_ix,
				rf_suffix_desc
			FROM
				rf_name_suffix
			WHERE
				rf_suffix_inactive_yn = '0'
		",2);


		$selectedRoomId = isset($_POST['selectedRoomId'])?$_POST['selectedRoomId']:"";
		$roomsArr = array();
		$guestRowsArr = array();

		$imax = sizeof($list);
		$itinRowHTML = Join("", file(__DIR__ . "/../../../public/html/cal_step2_guest_rows.htm"));
		$totalHTML = "";
		$combStr = "";
		$rowCountArr  = "var rowCountArr = new Array();";
		for ($x=0;$x<$imax;$x++) {
			$guestEditRows = "";
			$itemId = $list[$x];

			if($combStr == "" 	) {
				$combStr = 	$itemId.":";
			} else {
				$combStr .= "+".$itemId.":";
			}
			$resItem = getItemDetails($itemId);

			$totalCount = $resItem['rv_item_adult_count'] + $resItem['rv_item_child_count'];
			$rowCount = 0;
			$guestEditRows = "";
			$itinHTML = chng_date($resItem['rv_item_date_arrive'], "-")." to ".chng_date($resItem['rv_item_date_depart'], "-")." <b>".t_encodeHTMLField($resItem['pr_name_last'])."</b> ".t_encodeHTMLField($resItem['ac_accomm_desc'])." ".$resItem['noNights']." Nights - ".$resItem['rv_item_accomm_count']." Room (".$resItem['rv_item_adult_count']." Ad/".$resItem['rv_item_child_count']." Child)";
			$GLOBALS['temp']['itinHTML'] = $itinHTML;


			$totalRoom = $resItem['rv_item_accomm_count'];

			$roomIds = $GLOBALS['lDB']->get("SELECT ac_accomm_room_id FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'", 3);

			$groupIds = $GLOBALS['lDB']->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'", 3);
			$blankRoomCount = 1;
			$grpStr = "";
			if(is_array($groupIds) && !empty($groupIds)) {
				foreach ($groupIds as $groupId) {
					$rowCount = 0;
					$roomId = $GLOBALS['lDB']->get("
						SELECT
							ac_accomm_room_id
						FROM
							rv_res_item_group
						WHERE
							rv_res_item_group.rv_res_item_group_ix = '$groupId'
					", 4);

					$roomNameDisp = "Room #";
					if($roomId) {
						$roomName = $GLOBALS['lDB']->get("SELECT ac_desc FROM ac_accomm_room WHERE ac_accomm_room_ix = '$roomId'",4);
						$roomNameDisp = $roomName;
					} else {
						$roomName = "Room".$blankRoomCount;
						$roomId = $blankRoomCount;
						$blankRoomCount++;
					}
					if($grpStr == "") {
						$grpStr = $groupId."-".$roomId;
					} else {
						$grpStr .= "_".$groupId."-".$roomId;
					}
					$guestEditRows .= "
						<tr name='table".$roomId."_".$itemId."'>
							<td colspan='10'>
							<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">
							   <tr><td>
							    <input class=\"button bGuestPaste\" value=\"\" onclick=\"pasteRoom('".$groupId."','".$roomId."','".$itemId."');\" style=\"width: 21px; height: 20px; text-align: left; display:none;\" type=\"button\" id=\"".t_encodeHTMLField($roomName)."_".$itemId."\" tabindex=\"".$tabcount++."\"></td><td>
							<input class=\"button bRooms\" id=\"bRoom".t_encodeHTMLField($roomName)."_".$itemId."\" value=\"\" onclick=\"selectRoom('".$groupId."','".$roomId."','".$itemId."');\" style=\"width: 21px; height: 20px; text-align: left;\" type=\"button\" tabindex='".$tabcount++."'>
							<input type=\"text\" value=\"".t_encodeHTMLField($roomNameDisp)."\" readonly>
								   </td>
								   <td>
							<button id=\"categoryDropdownButton_".t_encodeHTMLField($roomName)."_".$itemId."\" type=\"button\" class=\"button bDropDown\" style=\"width: 16px; height: 20px;\" onclick=\"showItinMenu(event,'".$groupId."','".$roomId."','".$itemId."');\"  tabindex='".$tabcount++."'></button>
								   </td></tr></table>
							</td>
						</tr>
					";
					$roomsArr[] = t_encodeHTMLField($roomName)."_".$itemId;
					$guestArray = $GLOBALS['lDB']->get("
						SELECT DISTINCT
							pr_persona.pr_persona_ix,
							pr_persona.pr_name_last,
							pr_persona.pr_name_first,
							pr_persona.pr_email,
							pr_phone.pr_phone_number,
							rf_title.rf_title_ix,
							rf_title.rf_title_desc,
							pr_guest.pr_guest_primary_yn,
							pr_guest.pr_guest_note,
							pr_guest.pr_guest_memo
						FROM
							rv_res_item_guest
							INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
							INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
							LEFT JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix AND pr_phone.pr_default_yn = '1'
							LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
						WHERE
							rv_res_item_guest.rv_res_item_group_id = '$groupId'
					", 2);

					$blankCount = $totalCount - sizeof($guestArray);
					$accommTypeId = $GLOBALS['lDB']->get("
						SELECT
							rv_res_item_group.ac_accomm_type_id
						FROM
							rv_res_item_group
							INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
						WHERE
							rv_res_item_group.rv_res_item_group_ix = '$groupId'
					",4);
					$groupStatus = $GLOBALS['lDB']->get("
						SELECT
							rv_grp_status_ind,
							rv_grp_status_time
						FROM
							rv_res_item_group
							INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
						WHERE
							rv_res_item_group.rv_res_item_group_ix = '$groupId'
					",1);

					foreach($guestArray as $guestItem) {
						$checkGroup = $GLOBALS['lDB']->get("
							SELECT
								COUNT(rv_res_item_guest_id)
							FROM
								rv_res_item_guest
							WHERE
								rv_reservation_item_id = '$itemId'
								AND pr_guest_id = '$guestItem[pr_persona_ix]'
						",4);

						if($roomId != "0" && trim($roomId) != "") {
							$roomName = $GLOBALS['lDB']->get("SELECT ac_desc FROM ac_accomm_room WHERE ac_accomm_room_ix = '$roomId'",4);
							if($resItem['ac_accomm_type_id'] != $accommTypeId) {
								$roomName .= "/U";
							}
							$temp = explode(" ",$groupStatus['rv_grp_status_time']);
							$startDate = $temp[0];
							if($resItem['rv_item_date_depart'] != $startDate && $groupStatus['rv_grp_status_ind'] == "8") {
								$roomName .= "/E";
							}
						}

						$guestItem['primaryName'] = findPrimary($guestItem['pr_persona_ix']);

						$guestItem['count'] = $rowCount;

						if($guestItem['pr_guest_primary_yn'] == "1") {
							$guestItem['primaryChecked'] = "checked";
							$guestItem['showSelectPrimary'] = "visibility: hidden;";
						} else {
							$guestItem['primaryChecked'] = "";
							$guestItem['showSelectPrimary'] = "";
						}

						if($guestItem['pr_name_first'] == "") {
							$guestItem['pr_name_first'] = "FirstName";
						}
						if($guestItem['pr_name_last'] == "") {
							$guestItem['pr_name_last'] = "LastName";
						}
						if($guestItem['pr_phone_number'] == "") {
							$guestItem['pr_phone_number'] = "Telephone";
						}
						if($guestItem['pr_email'] == "") {
							$guestItem['pr_email'] = "Email";
						}

						$guestItem['pr_guest_note'] = trim($guestItem['pr_guest_note']);
						$guestItem['pr_guest_memo'] = trim($guestItem['pr_guest_memo']);
						$guestItem['showNote'] = "";
						$guestItem['showIntNote'] = "";
						$guestItem['showInfo'] = "";
						$guestItem['showDelete'] = "";
						$guestItem['roomid'] = $roomId;
						$guestItem['groupId'] = $groupId;
						$guestItem['resItemId'] = $itemId;

						// Check for unsaved modifications that may have been done before page reload
						// and overwrite with those changes
						if($_POST['allResItemGroupRoom'] != "") {
							$totalItemArr = unserialize($_POST['allResItemGroupRoom']);
							if(!is_array($totalItemArr)) $totalItemArr = array();
							$resId = $wizResId;
							foreach ($totalItemArr as $item) {
								foreach ($item as $key => $unsavedGuestListArr) {
									$data = explode("-", $key);
									if ($groupId == $data[0]){
										$unsavedGuestList = unserialize($unsavedGuestListArr);
										$GLOBALS['temp']['pr_persona_ix'] =  "";

										foreach($unsavedGuestList as $unsavedGuestKey=>$unsavedGuestItem) {
											// Existing Guest
								 			if($unsavedGuestItem['pr_persona_ix'] == $guestItem['pr_persona_ix']) {
												$guestItem['pr_name_first'] = trim($unsavedGuestItem['pr_name_first']);
												$guestItem['pr_name_last'] = trim($unsavedGuestItem['pr_name_last']);
												$guestItem['pr_phone_number'] = trim($unsavedGuestItem['pr_phone_number']);
												$guestItem['pr_email'] = trim($unsavedGuestItem['pr_email']);
												$guestItem['pr_guest_note'] = trim($unsavedGuestItem['pr_guest_note']);
												$guestItem['pr_guest_memo'] = trim($unsavedGuestItem['pr_guest_memo']);
												$guestItem['rf_title_ix'] = trim($unsavedGuestItem['pr_guest_memo']);
												$guestItem['rf_name_suffix_ix'] = isset($unsavedGuestItem['rf_name_suffix_ix'])?trim($unsavedGuestItem['rf_name_suffix_ix']):"";
								 			}
										}
									}

								}
							}
						}

						$titleRows = "";
						foreach($titleArray as $titleItem) {
							if($titleItem['rf_title_ix'] == $guestItem['rf_title_ix']) {
								$selected = " selected='selected' ";
							} else {
								$selected = "";
							}
							$titleRows .= "<option  value=\"$titleItem[rf_title_ix]\" $selected> $titleItem[rf_title_desc]</option>";
						}

						$suffixRows = "";
						foreach($suffixArray as $suffixItem) {
							if(isset($guestItem['rf_name_suffix_ix']) && $suffixItem['rf_name_suffix_ix'] == $guestItem['rf_name_suffix_ix']) {
								$selected = " selected ";
							} else {
								$selected = "";
							}
							$suffixRows .= "<option $selected value=\"$suffixItem[rf_name_suffix_ix]\" >$suffixItem[rf_suffix_desc]</option>";
						}

						$guestItem['titleOptions'] = $titleRows;
						$guestItem['suffixOptions'] = $suffixRows;


						$guestItem['existingGuest'] = "display:block;"; // Show the guest profile button

						for($tab=1; $tab<=11; $tab++) {
							$guestItem['tab'.$tab] = $tabcount++;
						}
						$guestEditRows .= showpage($guestItem,$guestEditHTML);
						$guestRowsArr[] = "guest".$rowCount."_".$roomId."_".$itemId;
						$rowCount++;
					}

					$titleRows = "";
					foreach($titleArray as $titleItem) {
						$titleRows .= "<option value=\"$titleItem[rf_title_ix]\">$titleItem[rf_title_desc]</option>";
					}
					$suffixRows = "";
					foreach($suffixArray as $suffixItem) {
						$suffixRows .= "<option value=\"$suffixItem[rf_name_suffix_ix]\">$suffixItem[rf_suffix_desc]</option>";
					}

					// New unsaved guests
					if(isset($_POST['allResItemGroupRoom']) && $_POST['allResItemGroupRoom'] != "") {
						$totalItemArr = unserialize($_POST['allResItemGroupRoom']);
						if(!is_array($totalItemArr)) $totalItemArr = array();
						$resId = $wizResId;
						foreach ($totalItemArr as $item) {
							foreach ($item as $key => $guestListArr) {
								$data = explode("-", $key);
								if ($groupId == $data[0]){
									$guestList = unserialize($guestListArr);
									$GLOBALS['temp']['pr_persona_ix'] =  "";

									foreach($guestList as $guestKey=>$guestItem) {
										// Existing Guest
							 			if($guestItem['pr_persona_ix'] != "0" && trim($guestItem['pr_persona_ix']) != "") {
							 				// Do nothing at this point
							 			} else {

											$titleRows = "";
											foreach($titleArray as $titleItem) {
												if($titleItem['rf_title_ix'] == $guestItem['rf_title_ix']) {
													$selected = " selected='selected' ";
												} else {
													$selected = "";
												}
												$titleRows .= "<option  value=\"$titleItem[rf_title_ix]\" $selected> $titleItem[rf_title_desc]</option>";
											}

											$suffixRows = "";
											foreach($suffixArray as $suffixItem) {
												if(isset($guestItem['rf_name_suffix_ix']) && $suffixItem['rf_name_suffix_ix'] == $guestItem['rf_name_suffix_ix']) {
													$selected = " selected ";
												} else {
													$selected = "";
												}
												$suffixRows .= "<option $selected value=\"$suffixItem[rf_name_suffix_ix]\" >$suffixItem[rf_suffix_desc]</option>";
											}

											$guestItem['titleOptions'] = $titleRows;
											$guestItem['suffixOptions'] = $suffixRows;

											$guestItem['count'] = $rowCount;

											for($tab=1; $tab<=12; $tab++) {
												$guestItem['tab'.$tab] = $tabcount++;
											}

											$guestItem['roomid'] = $roomId;
											$guestItem['groupId'] = $groupId;
											$guestItem['resItemId'] = $itemId;

											$guestItem['existingGuest'] = "display:none;"; // Hide the guest profile button

											$guestEditRows .= showpage($guestItem,$guestEditHTML);
											$guestRowsArr[] = "guest".$rowCount."_".$roomId."_".$itemId;
											$rowCount++;
											$blankCount--;
							 			}
									}
								}
							}
						}
					}

					// Blank rows
					for($count = 0; $count < $blankCount; $count++) {
						$guestItem = array();
						$guestItem['pr_name_last'] = "LastName";
						$guestItem['pr_name_first'] = "FirstName";
						$guestItem['pr_email'] = "Email";
						$guestItem['pr_phone_number'] = "Telephone";
						$guestItem['count'] = $rowCount;
						$guestItem['roomid'] = $roomId;
						$guestItem['pr_persona_ix'] = "";
						$guestItem['primaryName'] = "";
						$guestItem['showNote'] = "";
						$guestItem['showIntNote'] = "";
						$guestItem['showInfo'] = "visibility: hidden;";
						$guestItem['showDelete'] = "visibility: hidden;";
						$guestItem['pr_guest_note'] = "";
						$guestItem['pr_guest_memo'] = "";
						$guestItem['rv_reservation_item_id'] = $itemId;
						$guestItem['groupId'] = $groupId;
						$guestItem['resItemId'] = $itemId;
						$guestItem['titleOptions'] = $titleRows;
						$guestItem['suffixOptions'] = $suffixRows;
						for($tab=1; $tab<=12; $tab++) {
							$guestItem['tab'.$tab] = $tabcount++;
						}
						$guestItem['existingGuest'] = "display:none;"; // Hide the guest profile button
						$guestEditRows .= showpage($guestItem,$guestEditHTML);
						$guestRowsArr[] = "guest".$rowCount."_".$roomId."_".$itemId;
						$rowCount++;
					}
				}
			}

			$blankRooms = $totalRoom - count($groupIds);
			for($i = 1; $i <= $blankRooms; $i++) {
				$rowCount = 0;
				$roomName = "Room".$blankRoomCount;
				$guestEditRows .= "
					<tr>
						<td colspan=\"10\" id=\"table".$blankRoomCount."_".$itemId."\">
						<table cellpadding=\"0\" cellapacing=\"0\" border=\"0\">
						   <tr><td>
						   <input class=\"button bGuestPaste\" value=\"\" onclick=\"pasteRoom('','','".$itemId."');\" style=\"width: 21px; height: 20px; text-align: left; display:none;\" type=\"button\" id=\"".t_encodeHTMLField($roomName)."_".$itemId."\" tabindex=\"".$tabcount++."\">
							</td><td>
							<input class=\"button bRooms\" value=\"\" onclick=\"selectRoom('','".$blankRoomCount."', '".$itemId."');\" style=\"width: 21px; height: 20px; text-align: left;\" type=\"button\" tabindex=\"".$tabcount++."\" id=\"bRoom".t_encodeHTMLField($roomName)."_".$itemId."\">
							<input type=\"text\" value=\"Room #\" readonly>
							</td>
							<td>
							<button id=\"categoryDropdownButton_".t_encodeHTMLField($roomName)."_".$itemId."\" type=\"button\" class=\"button bDropDown\" style=\"width: 16px; height: 20px;\" onclick=\"showItinMenu(event,'','".$blankRoomCount."', '".$itemId."');\" tabindex=\"".$tabcount++."\"></button>
							</td></tr></table>
						</td>
					</tr>
				";
				$roomsArr[] = $roomName."_".$itemId;
				if($grpStr == "") {
					$grpStr = "-".$blankRoomCount;
				} else {
					$grpStr .= "_"."-".$blankRoomCount;
				}
				$titleRows = "";
				foreach($titleArray as $titleItem) {
					$titleRows .= "<option value=\"$titleItem[rf_title_ix]\">$titleItem[rf_title_desc]</option>";
				}
				$suffixRows = "";
				foreach($suffixArray as $suffixItem) {
					$suffixRows .= "<option value=\"$suffixItem[rf_name_suffix_ix]\">$suffixItem[rf_suffix_desc]</option>";
				}
				for($count = 0; $count < $totalCount; $count++) {
					$guestItem = array();
					$guestItem['pr_name_last'] = "LastName";
					$guestItem['pr_name_first'] = "FirstName";
					$guestItem['pr_email'] = "Email";
					$guestItem['pr_phone_number'] = "Telephone";
					$guestItem['count'] = $rowCount;
					$guestItem['roomid'] = $blankRoomCount;
					$guestItem['pr_persona_ix'] = "";
					$guestItem['primaryName'] = "";
					$guestItem['showNote'] = "";
					$guestItem['showIntNote'] = "";
					$guestItem['showInfo'] = "visibility: hidden;";
					$guestItem['showDelete'] = "visibility: hidden;";
					$guestItem['pr_guest_note'] = "";
					$guestItem['pr_guest_memo'] = "";
					$guestItem['rv_reservation_item_id'] = $itemId;
					$guestItem['groupId'] = "";
					//$guestItem['groupId'] = $groupId;
					$guestItem['resItemId'] = $itemId;
					$guestItem['titleOptions'] = $titleRows;
					$guestItem['suffixOptions'] = $suffixRows;
					for($tab=1; $tab<=12; $tab++) {
						$guestItem['tab'.$tab] = $tabcount++;
					}
					$guestItem['existingGuest'] = "display:none;"; // Hide the guest profile button
					$guestEditRows .= showpage($guestItem,$guestEditHTML);
					$guestRowsArr[] = "guest".$rowCount."_".$blankRoomCount."_".$itemId;
					$rowCount++;
				}
				$blankRoomCount++;
			}

			$GLOBALS['temp']['rowCount'] = $rowCount;
			$rowCountArr .= "rowCountArr['$itemId'] = $rowCount;";

			$totalHTML .= str_replace("!guestEditRows!",$guestEditRows,
			  str_replace("!itinHTML!",$itinHTML,
			  str_replace("!showTravel!","",
			  $itinRowHTML)));

			$combStr .= $grpStr;
		}
		$GLOBALS['temp']['roomsArr'] = implode(":", $roomsArr);
		$GLOBALS['temp']['guestsArr'] = implode(":", $guestRowsArr);
		$GLOBALS['temp']['combStr'] = $combStr;
		$GLOBALS['temp']['guestItinDetails'] = $totalHTML;
		$GLOBALS['temp']['rowCountArr'] = $rowCountArr;
	}
}

$GLOBALS['temp']['tabTop'] 	= $tabcount++;
$GLOBALS['temp']['tabCancel'] 	= $tabcount++;
$GLOBALS['temp']['tabGo'] 	= $tabcount++;
$GLOBALS['tabcount'] = $tabcount;

$hideList = array($form."_rf_country_id");
$GLOBALS[$form]->Hide($hideList);

$disableList = array($form."_guest_nationality");
$GLOBALS[$form]->Disable($disableList);

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"0\">\n";

$GLOBALS['temp']['exchTableVis'] = "hidden";

$GLOBALS['temp']['travelClass'] 	= "disabled";
$GLOBALS['temp']['travelArrive'] 	= "";
$GLOBALS['temp']['travelDepart'] 	= "";
$GLOBALS['temp']['travelTransfer'] 	= "";

$GLOBALS['temp']['wizResId'] = $wizResId;

$GLOBALS['temp']['duplicateCheckId'] = "";

// Set the reservation to expire in 10 + rf_default minutes from loadtime
if ($_SESSION['addedExpiry'] != true) {
	$pad = $GLOBALS['lDB']->get("SELECT rf_res_create_expiry_mins FROM rf_default", 4);
	$total = ($pad + 10) * 60;
	$expiry = date("Y-m-d H:i:s",mktime(date("H"), date("i"), date("s")+$total,date("m"), date("d"), date("Y")));
	$GLOBALS['lDB']->put("UPDATE rv_reservation SET rv_create_expiry_date = '$expiry' WHERE rv_reservation_ix = '$wizResId'");
	session_set("addedExpiry",true);
}
// End reservation expiry update


// Set the expiry timer
$now 	= date("U");
$expiry = explode(" ",$lDB->get("SELECT rv_create_expiry_date from rv_reservation WHERE rv_reservation_ix = '$wizResId'", 4));
$temp1 	= explode("-",$expiry[0]);
$temp2 	= explode(":",$expiry[1]);
$expire = date("U",mktime($temp2[0],$temp2[1],$temp2[2],$temp1[1],$temp1[2],$temp1[0]));
$timer 	= $expire - $now;
$GLOBALS['temp']['timer'] = $timer;
// End expiry timer

$GLOBALS['lDB']->isMaster = $tempMasterData;

$GLOBALS['temp']['rv_date_arrive'] = $GLOBALS['lDB']->get("SELECT rv_date_arrive FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];

$rf_reservation_status_id = $GLOBALS['lDB']->get("
	SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'
",4);

if($rf_reservation_status_id < 20) {
	$GLOBALS['temp']['guestRoomingClass'] = "collapse printCollapse";
} else {
	$GLOBALS['temp']['guestRoomingClass'] = "expand";
}

if(
	(isset($_POST['guestImportList']) && $_POST['guestImportList'] != "")
	|| (isset($_POST['allResItemGroupRoom']) && $_POST['allResItemGroupRoom'] != "")
	|| (isset($_POST['setRoomId']) && $_POST['setRoomId'] != "")
){
	$GLOBALS['temp']['showGuestDetails'] = "expand";
	$GLOBALS['temp']['guestDetailButtonText'] = "Guest Details <<";
} else {
	$GLOBALS['temp']['showGuestDetails'] = "collapse printCollapse";
	$GLOBALS['temp']['guestDetailButtonText'] = "Guest Details >>";
}

// Block booking details
$blockDetails = $GLOBALS['lDB']->get("
	SELECT
		bl_block.bl_block_ix,
		bl_block.bl_block_name
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
		LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
		LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
	WHERE
		draw_down_item.rv_reservation_id = '$wizResId'
",1);

if (!empty($blockDetails)) {
	$blockDetailsTableHTML = "
	<table align='center' id='tblBlockDetails' class='table' width='770'>
		<col width='5' />
		<col width='756' />
		<col width='5' />
		<tr>
			<td class='br colLt'><img src='/resource/Resrequest/Application/public/img/1x1.gif' width='5' height='25' alt='' /></td>
			<td class='bt bb colLtt' valign='middle'>
				<table align='center' id='tblBlockDetails' class='table' width='100%'>
					<col width='200' />
					<col width='100' />
					<col width='100' />
					<col width='255' />
					<tr>
						<td class='colLtt'>&nbsp;&nbsp;Block template details</td>
						<td class='frmLbl2Col'><label>Number</label></td>
						<td class='frmVal2Col'>!bl_block_ix!</td>
						<td class='frmLbl2Col'><label>Name</label></td>
						<td class='frmVal2Col'>!bl_block_name!</td>
					</tr>
				</table>
			</td>
			<td class='bl colLt'><img src='/resource/Resrequest/Application/public/img/1x1.gif' width='5' height='25' alt='' /></td>
		</tr>
	</table>

	";
	$GLOBALS['temp']['blockDetails'] = showpage($blockDetails, $blockDetailsTableHTML);
	$GLOBALS['temp']['step1Description'] = 'Step 1: Block';
} else {
	$GLOBALS['temp']['blockDetails'] = '';
	$GLOBALS['temp']['step1Description'] = 'Step 1: Calendar';
}
