<?php
/*
* $Id: init.form398.php,v 1.2 2011-05-17 14:08:33 light Exp $
*
* $Log: init.form398.php,v $
* Revision 1.2  2011-05-17 14:08:33  light
* Bug #7585 - PHP5 fixes
*
* Revision 1.1  2010-01-11 17:39:27  light
* Bug #6622 - User Prefences (Default page & Email templates)
*
*
*/


/**
* init.form398.php - Email Templates
* Job: 782
* Function: 118 (Email Templates)
*/

define("ACTION_UPDATE",1);
define("ACTION_NEW",2);
define("ACTION_DELETE",3);

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/template.htm");
}

$pf_object_id = db_pf_object_by_name("email_templates");

$pf_option_id = isset($_POST['option_id'])?$_POST['option_id']:"";

$_POST['action'] = isset($_POST['action'])?$_POST['action']:"";

switch ($_POST['action']){

case ACTION_UPDATE:

	if ($_POST["pf_option_default_yn"] == 1){
		$default = true;
	} else {
		$default = false;
	}

	if ($pf_option_id == ""){		// insert
		
		$pf_option_id = db_pf_option_insert($pf_object_id,$_POST['pf_option_name'],$_POST['pf_option_name'],$_POST['pf_level_ind'],false,$default,$pf_option_favourite_yn=false,$_POST['pf_option_name']);
		
	
	} else {						// update

		db_pf_option_update($pf_option_id,$_POST['pf_option_name'],$_POST['pf_option_name'],$_POST['pf_level_ind'],$GLOBALS['userid'],$default,$pf_option_favourite_yn=false,$_POST['pf_option_name']);
	}
	
	db_pf_field_update($pf_option_id,"templateText",$_POST['templateText']);
	
	
	break;
case ACTION_NEW:

	
	break;
case ACTION_DELETE:
		

	if ($pf_option_id != ""){
		db_pf_option_delete($pf_option_id);
	}		
	
	$pf_option_id = "";
	$_POST['action'] = "";
	
	
	break;
default:

	break;				

}

$pf_level_ind = db_pf_option_level($pf_option_id);

$fieldList = array(
	"Consultant" => array(
		"Consultant|Firstname" => "Firstname",
		"Consultant|Lastname" => "Lastname",
		"Consultant|Telephone" => "Telephone",
		"Consultant|Email" => "Email",
		"Consultant|Postal" => "Postal",
		"Consultant|Physical" => "Physical"
	),
	"Consultant Relationship" => array(
		"ConsultantRel|Organisation Name" => "Organisation Name",
		"ConsultantRel|Telephone" => "Telephone",
		"ConsultantRel|Fax" => "Fax",
		"ConsultantRel|Email" => "Email",
		"ConsultantRel|Postal Address" => "Postal Address",
		"ConsultantRel|Physical Address" => "Physical Address",
		"ConsultantRel|URL" => "URL"
	),
	"Reservation Details" => array(
		"ResDetails|Contact Firstname" => "Contact Firstname",
		"ResDetails|Contact Lastname" => "Contact Lastname",
		"ResDetails|Agent" => "Agent",
	),
	"Res Office" => array(
		"ResOffice|Organisation Name" => "Organisation Name",
		"ResOffice|Telephone" => "Telephone",
		"ResOffice|Fax" => "Fax",
		"ResOffice|Email" => "Email",
		"ResOffice|Postal Address" => "Postal Address",
		"ResOffice|Physical Address" => "Physical Address",
		"ResOffice|URL" => "URL"
	),
	"Principal" => array(
		"Principal|Organisation Name" => "Organisation Name",
		"Principal|Telephone" => "Telephone",
		"Principal|Fax" => "Fax",
		"Principal|Email" => "Email",
		"Principal|Postal Address" => "Postal Address",
		"Principal|Physical Address" => "Physical Address",
		"Principal|URL" => "URL"
	),
	"Payment" => array(
		"Payment|CreditCardLink" => array(
			'label'=>"Credit Card Link",
			'overlib'=>"This will insert the full raw URL into this template."
		)
	)
);


$sectionHeadHTML = "
	<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#cfc';\" onmouseout=\"this.style.backgroundColor='#fff';\" style=\"background-color: #fff;\">
		<td class=\"\" valign=\"top\"><strong>!SectionName!:</strong></td>
	</tr>
";

$fieldListHTML = "
	<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#cfc'; !Overlib!\" onmouseout=\"this.style.backgroundColor='#fff'; !OverlibClose!\" style=\"background-color: #fff;\" onclick=\"insertField('!FieldKey!');\">
		<td class=\"\" valign=\"top\">!FieldName!</td>
	</tr>
";


$fieldListRows = "";

foreach($fieldList as $sectionName => $section){

	$sectionRow['SectionName'] = $sectionName;
	$fieldListRows .= showpage($sectionRow,$sectionHeadHTML);	
	
	foreach($section as $fieldKey => $field) {
		if(!is_array($field)) {
			$fieldRow['FieldName'] = $field;
			$fieldRow['Overlib'] = "";
			$fieldRow['OverlibClose'] = "";
		} else {
			$fieldRow['FieldName'] = $field['label'];
			$fieldRow['Overlib'] = "overlib('" . t_encodeOverlib($field['overlib']) . "');";
			$fieldRow['OverlibClose'] = "nd();";
		}
		$fieldRow['FieldKey'] = $fieldKey;		
		$fieldListRows .= showpage($fieldRow,$fieldListHTML);
	}

}

$GLOBALS['temp']['fieldListRows'] = $fieldListRows;


$GLOBALS['temp']['templateRows'] = createTemplateList("loadTemplate", FALSE, $pf_option_id);
$GLOBALS['temp']['LevelOptions'] = 	"<option value=\"7\" !7_selected!>User</option>";
if (TemplatesManagementAccess()){
	$GLOBALS['temp']['LevelOptions'] .= "<option value=\"5\" !5_selected!>Environment</option>";
	if ($GLOBALS['isPropServer'] != "1") { $GLOBALS['temp']['LevelOptions'] .= "<option value=\"3\" !3_selected!>Global</option>" ; }
}

if ($pf_option_id != ""){
	

	$GLOBALS['temp']['option_id'] = $pf_option_id;
	$GLOBALS['temp']['pf_option_name'] = db_pf_option_get_name($pf_option_id);
	$GLOBALS['temp'][db_pf_option_level($pf_option_id).'_selected'] = "selected";
	$GLOBALS['temp']['default_checked'] = (db_pf_option_check_default($pf_option_id) == 1) ? "checked=\"checked\"" : "";
	$GLOBALS['temp']['textEdit'] = db_pf_field_by_name($pf_option_id, "templateText");	
	$GLOBALS['temp']['textView'] = $GLOBALS['temp']['textEdit'];
	$GLOBALS['temp']['txtEditMode'] = $_POST['action'];
	
} else {
	$GLOBALS['temp']['option_id'] = "";
	$GLOBALS['temp']['pf_option_name'] = "";
	$GLOBALS['temp']['pf_level_id'] = "";
	$GLOBALS['temp']['pf_option_default_yn'] = "";
	$GLOBALS['temp']['textEdit'] = "";
	$GLOBALS['temp']['textView'] = "Select a template from the list above";
	$GLOBALS['temp']['txtEditMode'] = $_POST['action'];
}

$GLOBALS['temp']['newEnabled']  = "hidden";
$GLOBALS['temp']['editEnabled']  = "hidden"; 		
$GLOBALS['temp']['delEnabled']  = "hidden";

if (TemplatesManagementAccess() && $GLOBALS['lDB']->isMaster = "1" && $GLOBALS['isPropServer'] != "1"){
	$GLOBALS['temp']['newEnabled']  = "visible";
	if ($pf_option_id != ""){
		$GLOBALS['temp']['editEnabled']  = "visible"; 		
		$GLOBALS['temp']['delEnabled']  = "visible"; 
	}

} elseif(TemplatesUpdateAccess()) {

	$GLOBALS['temp']['newEnabled']  = "visible";
	if ($pf_level_ind > 5 && $pf_option_id != ""){
		$GLOBALS['temp']['editEnabled']  = "visible"; 		
		$GLOBALS['temp']['delEnabled']  = "visible"; 
	}	
}
