<?php
/**
 * init.form40.php - Default Table
 * Job: 108
 * Function: 63 (System settings)
*/

use MaglLegacyApplication\Application\MaglLegacy;

$application = MaglLegacy::getInstance()->getApplication();
$serviceManager = $application->getServiceManager();
$em = $serviceManager->get('doctrine.entitymanager.orm_enterprise');
require_once "db.rf_sys_admin.php";
$commissionLabelImplemented = commissionLabelImplemented();
$exchDecimalPlacesImplemented = exchDecimalPlacesImplemented();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/default_table.htm");
	$fields = array(
		"rf_principal_id",
		"rf_res_office_id",
		"rf_sys_admin_id",
		"rf_auth_https_yn",
		"rf_auth_previous_password_yn",
		"rf_auth_previous_password_limit",
		"rf_auth_minimum_length_yn",
		"rf_auth_minimum_length_limit",
		"rf_auth_uppercase_yn",
		"rf_auth_lowercase_yn",
		"rf_auth_numeric_yn",
		"rf_auth_special_yn",
		"rf_auth_force_change_yn",
		"rf_show_allocs_yn",
		"rf_prov_expiry_days",
		"rf_res_create_expiry_mins",
		"rf_phone_type_id",
		"rt_rate_type_id",
		"rf_show_agent_note_yn",
		"rf_exch_expiry_days",
		"rf_exch_save_yn",
		"rf_exch_allow_update_yn",
		"rf_exch_show_past_yn",
		"rf_exch_master_db_ind",
		"rf_exch_master_db_id",
		"ac_pay_plan_id",
		"rf_invoice_title",
		"rf_itinerary_title",
		"rf_invoice_date",
		"rf_invoice_future_yn",
		"rf_proforma_title",
		"rf_book_limit",
		"rf_accomm_sort_ind",
		"rf_period_split",
		"rf_proforma_note",
		"rf_date_res_limit",
		"rf_res_create_expiry_internal",
		"rf_doc_settings",
		"rf_doc_header_res_office_yn",
		"rf_doc_header_res_office_type_ind",
		"rf_doc_header_res_office_url_yn",
		"rf_doc_header_logo_yn",
		"rf_doc_header_logo_type_ind",
		"rf_doc_header_invoice_yn",
		"rf_doc_tax_table_yn",
		"rf_doc_tax_table_rate_yn",
		"rf_doc_tax_table_total_yn",
		"rf_doc_summary_comp_group_label",
		"rf_doc_proforma_comp_group_label",
		"rf_doc_invoice_comp_group_label",
		"rf_persona_check_yn",
		"rf_persona_first_yn",
		"rf_persona_first_soundex_yn",
		"rf_persona_first_exact_yn",
		"rf_persona_first_match_yn",
		"rf_persona_first_match_limit",
		"rf_persona_last_yn",
		"rf_persona_last_soundex_yn",
		"rf_persona_last_exact_yn",
		"rf_persona_last_match_yn",
		"rf_persona_last_match_limit",
		"rf_site_title",
		"rf_site_description",
		"rf_site_keywords",
		"rf_analytics_yn",
		"rf_analytics_code",
		"rf_analytics_public_yn",
		"rf_analytics_external_yn",
		"rf_analytics_internal_yn",
		"rf_share_notes_yn",
		"rf_cancel_warn_yn",
		"rf_cancel_warn_note",
		"rf_room_cal_days",
		"rf_per_stay_yn",
		"rf_per_stay_auto_yn",
		"rf_payment_gateway_expiry_mins",
		"rf_payment_gateway_email_yn",
		"rf_statutory_label_1",
		"rf_statutory_label_2",
		"rf_statutory_label_3"
	);
	if ($commissionLabelImplemented) {
		$fields[] = "rf_commission_label_override";
	}
	if ($exchDecimalPlacesImplemented) {
		$fields[] = "rf_exch_decimal_places";
	}
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"rf_default",$fields,"rf_default_id = '$record'","","");
}

if (isset($_POST) && isset($_POST['rf_exch_decimal_places'])) {
	// Only allowed between 6 and 20
	if ($_POST['rf_exch_decimal_places'] > 20) {
		$_POST['rf_exch_decimal_places'] = 20;
	}
	if ($_POST['rf_exch_decimal_places'] < 6 || empty($_POST['rf_exch_decimal_places'])) {
		$_POST['rf_exch_decimal_places'] = 6;
	}
}

$hidelist = array();
$disablelist = array();

if($action == 3 && (!isMasterDB() || $GLOBALS['isPropServer'])) {
	redirectTo(" reservation.php?105");
	die();
}

// rsUpdate, delete or add a record
if (array_key_exists(1,$_SERVER['argv'])) {
	$rateId = $_SERVER['argv'][1];
	if ($_SERVER['argv'][2] == "add") {
		$GLOBALS['lDB']->insert_override = $rateId;
		$GLOBALS['lDB']->put("INSERT INTO rf_default_rate (rf_default_rate_id) VALUES ('$rateId')");
	}elseif($_SERVER['argv'][2] == "del") {
		$GLOBALS['lDB']->put("DELETE FROM rf_default_rate WHERE rf_default_rate_id = '$rateId'");
	}
}

$GLOBALS['temp']['showTaxDisabled'] = (!isMasterDB() || $GLOBALS['isPropServer']) ? "disabled" : "";

$GLOBALS['temp']['rateStyle'] = "";

if ($action != "3") {
	$GLOBALS['temp']['rateStyle'] = " style=\"visibility:hidden\"";
}

// Generate listing of all default rate types
$sql="
	SELECT
		rt_rate_type.rt_rate_type_ix as rt_rate_type_id,
		IF(rt_rate_type_inactive_yn <> 0, concat('* ',rt_rate_type.rt_rate_type_desc),rt_rate_type.rt_rate_type_desc) AS rt_rate_type_desc,
		rf_currency.rf_currency_symbol,
		rt_rate_type_inactive_yn
	FROM
		rf_default_rate
		INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default_rate.rf_default_rate_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	ORDER BY
		rt_rate_type.rt_rate_type_desc
";
$defaultRateList = $GLOBALS['lDB']->get($sql,2);

$defaultRateIdList = array();
$rateHTML = join("\n",file(__DIR__ . "/../../../public/html/default_rate_rows.htm"));
$GLOBALS['temp']['rRows'] = "";
for($a=0;$a<sizeof($defaultRateList);$a++) {
	$rateData = $defaultRateList[$a];
	array_push($defaultRateIdList,$rateData['rt_rate_type_id']);
	$rateData['style'] = $GLOBALS['temp']['rateStyle'];
	$GLOBALS['temp']['rRows'] .= showpage($rateData,$rateHTML);
}

if ($GLOBALS['temp']['rRows'] == ""){
	$GLOBALS['temp']['rRows'] .= "<tr><td height='15' colspan='2' class='small' align='center'>&nbsp;</td></tr>";
}

// Generate dropdown of all valid rate types
$GLOBALS[$form]->AddField("form40_rf_default_sysRateTypeId","sysRateTypeId","",3);
$sql="
	SELECT
		rt_rate_type.rt_rate_type_ix,
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type, rf_currency
	WHERE
		rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
		AND rt_rate_type_inactive_yn = '0'
		AND rt_rate_type.rt_rate_type_ix NOT IN ('".join("','",$defaultRateIdList)."')
	ORDER BY
		rt_rate_type.rt_rate_type_desc
";

$GLOBALS['form40_rf_default_sysRateTypeId']->Select(combolist($GLOBALS['lDB'],$sql));
$GLOBALS['form40_rf_default_sysRateTypeId']->Width = 300;
$GLOBALS['form40_rf_default_sysRateTypeId']->Size = 300;
$GLOBALS['form40_rf_default_sysRateTypeId']->TabIndex = 16;

// rsUpdate, refresh the default rate dropdown and the default rate listing
if (array_key_exists(1,$_SERVER['argv'])) {

	$listOut = "<table width='100%' height='50' border='0' cellspacing='0' cellpadding='0'>";
	$listOut .= $GLOBALS['temp']['rRows'];
	$listOut .= "<tr><td colspan='2'></td></tr></table>";

	// Declare host variables
	$rsUpdateInnerHTML = array();
	$rsUpdateValue = array();
	$rsUpdateVar = array();
	$rsFuncList = array();

	// Add values to arrays
	$rsUpdateInnerHTML['raterows'] = $listOut;
	$rsUpdateInnerHTML['ratespan'] = $GLOBALS['form40_rf_default_sysRateTypeId']->Show($action);

	array_push($rsFuncList,"toggleRateButton");
	array_push($rsFuncList,"''");

	// Output RS response
	echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
	die();
}


$record = "1";
$GLOBALS['autovar'] = "1";
if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = $GLOBALS['passthrurecord'];
		if ($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}
$GLOBALS['temp']['record'] = $record;

$GLOBALS[$form]->Get($action);

$table = $GLOBALS[$form]->TableList[0];

if ($record != "" || $action == "3" && $action != "1") {
	$GLOBALS[$table]->Refresh($record,$action);
}


$sql="
	SELECT
		pr_persona.pr_persona_ix,
		IF(pr_business.pr_bus_inactive_yn <> '0',CONCAT('* ',pr_persona.pr_name_last),pr_persona.pr_name_last) as pr_name_last
	FROM
		pr_business
		INNER JOIN pr_persona ON pr_business.pr_business_id = pr_persona.pr_persona_ix
	WHERE
		(
			pr_business.pr_bus_inactive_yn = '0'
			AND pr_persona.pr_web_addr IS NOT NULL
			AND pr_persona.pr_web_addr != ''
		) OR (
			pr_persona_ix = '".$GLOBALS['form40_rf_default_rf_principal_id']->Value."'
		)
";

$GLOBALS['form40_rf_default_rf_principal_id']->Select = combolist($GLOBALS['lDB'],$sql);
$GLOBALS['form40_rf_default_rf_principal_id']->Class = 3;
$GLOBALS['form40_rf_default_rf_principal_id']->Width = 200;
$GLOBALS['form40_rf_default_rf_principal_id']->Size = 60;
$GLOBALS['form40_rf_default_rf_principal_id']->TabIndex = 1;

$sql="
	SELECT DISTINCT
		pr_persona.pr_persona_ix,
		IF(pr_persona.pr_persona_inactive_yn <> '0' OR pr_business.pr_bus_inactive_yn <> '0',
		CONCAT('* ',pr_persona.pr_name_last), pr_persona.pr_name_last) as pr_name_last,
		pr_persona.pr_name_first
	FROM
		pr_persona
		INNER JOIN pr_business ON pr_business.pr_business_id = pr_persona.pr_persona_ix
		LEFT JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
	WHERE
		(
			pr_persona.pr_persona_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
			AND pr_phone.rf_phone_type_id != 'RS1'
			AND pr_phone.rf_phone_type_id IS NOT NULL
			AND pr_persona.pr_email IS NOT NULL AND pr_persona.pr_email != ''
		) OR (
			pr_persona.pr_persona_ix = '".$GLOBALS['form40_rf_default_rf_res_office_id']->Value."'
		)
";

$GLOBALS['form40_rf_default_rf_res_office_id']->Select = combolist($GLOBALS['lDB'],$sql);
$GLOBALS['form40_rf_default_rf_res_office_id']->Class = 3;
$GLOBALS['form40_rf_default_rf_res_office_id']->Width = 200;
$GLOBALS['form40_rf_default_rf_res_office_id']->Size = 60;
$GLOBALS['form40_rf_default_rf_res_office_id']->TabIndex = 2;

$sysAdmins = db_rf_sys_admin_id();
$sysAdminPrimary = db_rf_sys_admin_primary_id();

$sql="
	SELECT
		pr_persona.pr_persona_ix,
		IF(pr_user.pr_user_inactive_yn <> '0',CONCAT('* ',pr_persona.pr_name_last),pr_persona.pr_name_last) as pr_name_last,
		pr_persona.pr_name_first
	FROM
		pr_persona
		INNER JOIN pr_link ON pr_link.pr_link_from = pr_persona.pr_persona_ix AND pr_link.rf_link_type_id = 'RS1'
		INNER JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix
	WHERE
		(
			pr_persona.pr_org_yn = '0'
			AND pr_user.pr_user_inactive_yn = '0'
			AND pr_persona.pr_email != '' AND pr_persona.pr_email IS NOT NULL
		) OR (
			pr_persona.pr_persona_ix = '".$GLOBALS['form40_rf_default_rf_sys_admin_id']->Value."'
		)
	ORDER BY
		pr_persona.pr_name_first,
		pr_name_last
";

$persona = $GLOBALS['lDB']->get($sql,"2");
$sysAdminSelectOptions = $sysAdminListing = array();
$sysAdminListing = '';
foreach ($persona as $person) {
	$selected = in_array($person['pr_persona_ix'], $sysAdmins) ? "selected" : "";
	$sysAdminSelectOptions[] = '<option value="' . $person['pr_persona_ix'] . '" ' . $selected . '>' . trim($person['pr_name_first'] . ' ' . $person['pr_name_last']) . '</option>';
	if ($selected) {
		
		$sysAdminListing .= '<div>';
		$sysAdminListing .= '<i class="material-icons primarySysAdminIcon" adminId="' . $person['pr_persona_ix'] . '" onclick="setPrimarySysAdmin(\'' . $person['pr_persona_ix'] . '\')">star_outline</i>';
		$sysAdminListing .= '<a href="/reservation.php?47+' . $person['pr_persona_ix'] . '" class="link">' .
			trim($person['pr_name_first'] . ' ' . $person['pr_name_last']) .
			'</a>';
		$sysAdminListing .= '</div>';
	}
}
$GLOBALS['temp']['sysAdminSelectOptions'] = join('', $sysAdminSelectOptions);
$GLOBALS['temp']['sysAdminListing'] = $sysAdminListing;
$GLOBALS['temp']['sysAdminIDs'] = "'" . join("', '", $sysAdmins) . "'";
$GLOBALS['temp']['sysAdminListingIds'] = join(",", $sysAdmins);
$GLOBALS['temp']['sysAdminPrimary'] = $sysAdminPrimary;

$GLOBALS['form40_rf_default_rf_sys_admin_id']->Select = combolist($GLOBALS['lDB'],$sql);
$GLOBALS['form40_rf_default_rf_sys_admin_id']->Class = 3;
$GLOBALS['form40_rf_default_rf_sys_admin_id']->Width = 200;
$GLOBALS['form40_rf_default_rf_sys_admin_id']->Size = 60;
$GLOBALS['form40_rf_default_rf_sys_admin_id']->TabIndex = 3;

if ($pmode == "1" && sizeof($_POST) > 1) {
	if (isset($_POST['memos']) && $_POST['memos'] == "1") {
		$GLOBALS[$form.'_rf_default_rf_show_agent_note_yn']->SetValue(1);
	} else {
		$GLOBALS[$form.'_rf_default_rf_show_agent_note_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_exch_save_yn']) || $_POST['rf_exch_save_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_exch_save_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_exch_allow_update_yn']) || $_POST['rf_exch_allow_update_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_exch_allow_update_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_exch_show_past_yn']) || $_POST['rf_exch_show_past_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_exch_show_past_yn']->SetValue(0);
	}

	if (isset($_POST['payment_gateway_email']) && $_POST['payment_gateway_email'] == "1") {
		$GLOBALS['form40_rf_default_rf_payment_gateway_email_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_payment_gateway_email_yn']->SetValue(0);
	}
	if (isset($_POST['allocs']) && $_POST['allocs'] == "1") {
		$GLOBALS['form40_rf_default_rf_show_allocs_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_show_allocs_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_doc_header_res_office_yn']) || $_POST['rf_doc_header_res_office_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_doc_header_res_office_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_doc_header_res_office_url_yn']) || $_POST['rf_doc_header_res_office_url_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_doc_header_res_office_url_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_doc_header_logo_yn']) || $_POST['rf_doc_header_logo_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_doc_header_logo_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_doc_header_invoice_yn']) || $_POST['rf_doc_header_invoice_yn'] != "on") {
		$GLOBALS[$form.'_rf_default_rf_doc_header_invoice_yn']->SetValue(0);
	}

	if(isset($_POST['showTax']) && $_POST['showTax'] == "1") {
		$GLOBALS['form40_rf_default_rf_doc_settings']->SetValue(33554432);
	} else {
		$GLOBALS['form40_rf_default_rf_doc_settings']->SetValue(0);
	}
	if(isset($_POST['showTaxTable']) && $_POST['showTaxTable'] == "1") {
		$GLOBALS['form40_rf_default_rf_doc_tax_table_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_doc_tax_table_yn']->SetValue(0);
	}
	if(isset($_POST['showTaxTableRate']) && $_POST['showTaxTableRate'] == "1") {
		$GLOBALS['form40_rf_default_rf_doc_tax_table_rate_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_doc_tax_table_rate_yn']->SetValue(0);
	}
	if(isset($_POST['showTaxTableTotal']) && $_POST['showTaxTableTotal'] == "1") {
		$GLOBALS['form40_rf_default_rf_doc_tax_table_total_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_doc_tax_table_total_yn']->SetValue(0);
	}

	if (isset($_POST['accomSort']) && $_POST['accomSort'] == "1") {
		$GLOBALS['form40_rf_default_rf_accomm_sort_ind']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_accomm_sort_ind']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_check_yn']) || $_POST['rf_persona_check_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_check_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_soundex_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_exact_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_match_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_soundex_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_exact_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_match_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_first_yn']) || $_POST['rf_persona_first_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_first_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_soundex_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_exact_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_first_match_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_first_soundex_yn']) || $_POST['rf_persona_first_soundex_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_first_soundex_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_first_exact_yn']) || $_POST['rf_persona_first_exact_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_first_exact_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_first_match_yn']) || $_POST['rf_persona_first_match_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_first_match_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_last_yn']) || $_POST['rf_persona_last_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_last_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_soundex_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_exact_yn']->SetValue(0);
		$GLOBALS['form40_rf_default_rf_persona_last_match_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_last_soundex_yn']) || $_POST['rf_persona_last_soundex_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_last_soundex_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_last_exact_yn']) || $_POST['rf_persona_last_exact_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_last_exact_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_persona_last_match_yn']) || $_POST['rf_persona_last_match_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_persona_last_match_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_analytics_code']) || empty($_POST['rf_analytics_code'])) {
		$GLOBALS['form40_rf_default_rf_analytics_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_analytics_yn']) || $_POST['rf_analytics_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_analytics_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_analytics_public_yn']) || $_POST['rf_analytics_public_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_analytics_public_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_analytics_external_yn']) || $_POST['rf_analytics_external_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_analytics_external_yn']->SetValue(0);
	}
	if(!isset($_POST['rf_analytics_internal_yn']) || $_POST['rf_analytics_internal_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_analytics_internal_yn']->SetValue(0);
	}
	if(isset($_POST['noteEdit']) && $_POST['noteEdit'] == "1") {
		$GLOBALS['form40_rf_default_rf_share_notes_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_share_notes_yn']->SetValue(0);
	}
	if(isset($_POST['cancelWarn']) && $_POST['cancelWarn'] == "1") {
		$GLOBALS['form40_rf_default_rf_cancel_warn_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_cancel_warn_yn']->SetValue(0);
	}
	if(isset($_POST['invoicefuture']) && $_POST['invoicefuture'] == "1") {
		$GLOBALS['form40_rf_default_rf_invoice_future_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_invoice_future_yn']->SetValue(0);
	}
	if(isset($_POST['perstay']) && $_POST['perstay'] == "1") {
		$GLOBALS['form40_rf_default_rf_per_stay_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_per_stay_yn']->SetValue(0);
	}
	if(isset($_POST['perstayauto']) && $_POST['perstayauto'] == "1") {
		$GLOBALS['form40_rf_default_rf_per_stay_auto_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_per_stay_auto_yn']->SetValue(0);
	}

	if (isset($_POST['https_require']) && $_POST['https_require'] == "1" && $GLOBALS['https_enabled']) {
		$GLOBALS['form40_rf_default_rf_auth_https_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_auth_https_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_auth_previous_password_yn']) || $_POST['rf_auth_previous_password_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_auth_previous_password_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_auth_minimum_length_yn']) || $_POST['rf_auth_minimum_length_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_auth_minimum_length_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_auth_uppercase_yn']) || $_POST['rf_auth_uppercase_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_auth_uppercase_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_auth_lowercase_yn']) || $_POST['rf_auth_lowercase_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_auth_lowercase_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_auth_numeric_yn']) || $_POST['rf_auth_numeric_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_auth_numeric_yn']->SetValue(0);
	}

	if(!isset($_POST['rf_auth_special_yn']) || $_POST['rf_auth_special_yn'] != "on") {
		$GLOBALS['form40_rf_default_rf_auth_special_yn']->SetValue(0);
	}

	if (isset($_POST['force_change']) && $_POST['force_change'] == "1") {
		$GLOBALS['form40_rf_default_rf_auth_force_change_yn']->SetValue(1);
	} else {
		$GLOBALS['form40_rf_default_rf_auth_force_change_yn']->SetValue(0);
	}

	db_rf_sys_admin_save($_POST['sysAdminListingIds'], $_POST['sysAdminPrimary']);
}

$GLOBALS['temp']['memos_check_y'] = "";
$GLOBALS['temp']['memos_check_n'] = " checked";
if ($GLOBALS[$form.'_rf_default_rf_show_agent_note_yn']->Value != "0") {
	$GLOBALS['temp']['memos_check_y'] = " checked";
	$GLOBALS['temp']['memos_check_n'] = "";
}

$GLOBALS['temp']['payment_gateway_email_check_y'] = "";
$GLOBALS['temp']['payment_gateway_email_check_n'] = " checked";
if ($GLOBALS['form40_rf_default_rf_payment_gateway_email_yn']->Value != "0") {
	$GLOBALS['temp']['payment_gateway_email_check_y'] = " checked";
	$GLOBALS['temp']['payment_gateway_email_check_n'] = "";
}


$GLOBALS['temp']['allocs_check_y'] = "";
$GLOBALS['temp']['allocs_check_n'] = " checked";
if ($GLOBALS['form40_rf_default_rf_show_allocs_yn']->Value != "0") {
	$GLOBALS['temp']['allocs_check_y'] = " checked";
	$GLOBALS['temp']['allocs_check_n'] = "";
}

		/*"rf_doc_header_res_office_yn",
		"rf_doc_header_res_office_type_ind",
		"rf_doc_header_res_office_url_yn",
		"rf_doc_header_logo_yn",
		"rf_doc_header_logo_type_ind",
		"rf_doc_header_invoice_yn",*/
$GLOBALS['form40_rf_default_rf_doc_header_res_office_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_doc_header_res_office_yn']->onChange = "toggleDocHeaderResOffice();";

$GLOBALS['temp']['rf_doc_header_res_office_type_system'] = "";
$GLOBALS['temp']['rf_doc_header_res_office_type_first_parent'] = "";
if($GLOBALS['form40_rf_default_rf_doc_header_res_office_type_ind']->Value == 1) {
	$GLOBALS['temp']['rf_doc_header_res_office_type_first_parent'] = "checked";
} else {
	$GLOBALS['temp']['rf_doc_header_res_office_type_system'] = "checked";
}

$GLOBALS['form40_rf_default_rf_doc_header_res_office_url_yn']->Class = 9;

$GLOBALS['form40_rf_default_rf_doc_header_logo_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_doc_header_logo_yn']->onChange = "toggleDocHeaderLogo();";

$GLOBALS['temp']['rf_doc_header_logo_type_system'] = "";
$GLOBALS['temp']['rf_doc_header_logo_type_first_parent'] = "";
if($GLOBALS['form40_rf_default_rf_doc_header_logo_type_ind']->Value == 1) {
	$GLOBALS['temp']['rf_doc_header_logo_type_first_parent'] = "checked";
} else {
	$GLOBALS['temp']['rf_doc_header_logo_type_system'] = "checked";
}

$GLOBALS['form40_rf_default_rf_doc_header_invoice_yn']->Class = 9;

$GLOBALS['temp']['showTaxCheck'] = "";
if($GLOBALS['form40_rf_default_rf_doc_settings']->Value == 33554432) {
	$GLOBALS['temp']['showTaxCheck'] = "checked";
}

$GLOBALS['temp']['showTaxTableCheck'] = "";
if($GLOBALS['form40_rf_default_rf_doc_tax_table_yn']->Value == 1) {
	$GLOBALS['temp']['showTaxTableCheck'] = "checked";
}

if($GLOBALS['form40_rf_default_rf_doc_tax_table_rate_yn']->Value == 1) {
	$GLOBALS['temp']['showTaxTableRateCheck'] = "checked";
}

if($GLOBALS['form40_rf_default_rf_doc_tax_table_total_yn']->Value == 1) {
	$GLOBALS['temp']['showTaxTableTotalCheck'] = "checked";
}

$GLOBALS['form40_rf_default_rf_prov_expiry_days']->Size = 4;
$GLOBALS['form40_rf_default_rf_prov_expiry_days']->TabIndex = 6;
$GLOBALS['form40_rf_default_rf_prov_expiry_days']->StyleType = "txt";

$GLOBALS['form40_rf_default_rf_exch_expiry_days']->Size = 4;
$GLOBALS['form40_rf_default_rf_exch_expiry_days']->TabIndex = 7;
$GLOBALS['form40_rf_default_rf_exch_expiry_days']->StyleType = "txt";

$GLOBALS['form40_rf_default_rf_exch_save_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_exch_save_yn']->onChange = "toggleExch();";

$GLOBALS['form40_rf_default_rf_exch_allow_update_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_exch_show_past_yn']->Class = 9;

$GLOBALS['form40_rf_default_rf_exch_master_db_ind']->Select(array("1:|:Each environment manages their own exchange rates","2:|:Nominate a specific environment to manage exchange rates"));
$GLOBALS['form40_rf_default_rf_exch_master_db_ind']->onChange = "toggleExchMaster();";
$GLOBALS['form40_rf_default_rf_exch_master_db_ind']->Width = 340;
$GLOBALS['form40_rf_default_rf_exch_master_db_ind']->Size = 100;
$GLOBALS['form40_rf_default_rf_exch_master_db_ind']->TabIndex = 15;

$databases = combolist($GLOBALS['lDB'],"
	SELECT
		rf_database.rf_database_id,
		CONCAT(rf_database.rf_db_description,CONCAT(' (',CONCAT(rf_database.rf_db_code,')')))
	FROM
		rf_database
	WHERE
		rf_database.rf_db_inactive_yn = '0'
	ORDER BY
		rf_database.rf_db_code
");
array_unshift($databases,"0:|:Reservation Office (Master)");
$GLOBALS['form40_rf_default_rf_exch_master_db_id']->Select($databases);
$GLOBALS['form40_rf_default_rf_exch_master_db_id']->Width = 340;
$GLOBALS['form40_rf_default_rf_exch_master_db_id']->Size = 100;
$GLOBALS['form40_rf_default_rf_exch_master_db_id']->TabIndex = 15;

$GLOBALS['form40_rf_default_rf_res_create_expiry_internal']->Size = 4;
$GLOBALS['form40_rf_default_rf_res_create_expiry_internal']->TabIndex = 8;
$GLOBALS['form40_rf_default_rf_res_create_expiry_internal']->StyleType = "txt";

$GLOBALS['form40_rf_default_rf_res_create_expiry_mins']->Size = 4;
$GLOBALS['form40_rf_default_rf_res_create_expiry_mins']->TabIndex = 8;
$GLOBALS['form40_rf_default_rf_res_create_expiry_mins']->StyleType = "txt";

$GLOBALS['form40_rf_default_rf_payment_gateway_expiry_mins']->Size = 4;
$GLOBALS['form40_rf_default_rf_payment_gateway_expiry_mins']->TabIndex = 8;
$GLOBALS['form40_rf_default_rf_payment_gateway_expiry_mins']->StyleType = "txt";


$sql = "
	SELECT
		rf_phone_type_ix,
		IF(rf_phone_inactive_yn <> '0',CONCAT('* ',rf_phone_type_desc),rf_phone_type_desc) as rf_phone_type_desc
	FROM
		rf_phone_type
	WHERE
		rf_phone_inactive_yn = '0'
		OR rf_phone_type.rf_phone_type_ix = '".$GLOBALS['form40_rf_default_rf_phone_type_id']->Value."'
      ORDER BY
         rf_phone_type_desc
";
$GLOBALS['form40_rf_default_rf_phone_type_id']->Select = combolist($GLOBALS['lDB'],$sql);
$GLOBALS['form40_rf_default_rf_phone_type_id']->Class = 3;
$GLOBALS['form40_rf_default_rf_phone_type_id']->Width = 200;
$GLOBALS['form40_rf_default_rf_phone_type_id']->TabIndex = 9;

if ($pmode == "0") {
	$monArray = array();
	$months = range(1,12);
	array_push($monArray,"");
	for($i=1;$i<13;$i++) {
		array_push($monArray,$i /*str_pad($i,2,"0",STR_PAD_LEFT)*/.":|:".date("M",mktime(0,0,0,$i,1,2000)));
	}

	$dayArray = array();
	$days = range(1,31);
	array_push($dayArray,"");
	for($i=1;$i<32;$i++) {
		array_push($dayArray,$i /*str_pad($i,2,"0",STR_PAD_LEFT)*/.":|:".date("d",mktime(0,0,0,1,$i,2000)));
	}

	$start = explode(" ",$GLOBALS['form40_rf_default_rf_date_res_limit']->Value);
	$tsta = explode("-",$start[0]);
	$staDay = $tsta[2];
	$staMonth = $tsta[1];
	$staYear = $tsta[0];
	if ($staYear <= "0000") {
		$staYear = date("Y");
	}
	if ($staMonth <= "0" || $staMonth >= "13") {
		$staMonth = date("m");
	}
	if ($staDay <= "0" || $staDay >= "32") {
		$staDay = date("d");
	}
	$GLOBALS['temp']['staDay'] = ltrim($staDay, '0');
	$GLOBALS['temp']['staMonth'] = $staMonth;
	$GLOBALS['temp']['staYear'] = $staYear;


} else {
	if(sizeof($_POST) > 1) {
		$start = $_POST['staYear']."-".$_POST['staMonth']."-".$_POST['staDay'];
		$GLOBALS['form40_rf_default_rf_date_res_limit']->SetValue($start);
	}
}

$sql = "
	SELECT
		rt_rate_type_ix,
		IF(rt_rate_type_inactive_yn <> '0',CONCAT('* ',rt_rate_type_desc),rt_rate_type_desc) as rt_rate_type_desc
	FROM
		rt_rate_type
	WHERE
		rt_rate_type_inactive_yn = '0'
		OR rt_rate_type.rt_rate_type_ix = '".$GLOBALS['form40_rf_default_rt_rate_type_id']->Value."'
	ORDER BY
		rt_rate_type_desc
";
$GLOBALS['form40_rf_default_rt_rate_type_id']->Select(combolist($GLOBALS['lDB'],$sql));
$GLOBALS['form40_rf_default_rt_rate_type_id']->TabIndex = 10;
$GLOBALS['form40_rf_default_rt_rate_type_id']->Width = 200;
$GLOBALS['form40_rf_default_rt_rate_type_id']->Size = 60;

$sql = "
	SELECT
		ac_pay_plan_ix,
		IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc)
	FROM
		ac_pay_plan
	WHERE
		ac_pay_plan.ac_pay_plan_inactive_yn = 0
		OR ac_pay_plan.ac_pay_plan_ix = '".$GLOBALS['form40_rf_default_ac_pay_plan_id']->Value."'
	ORDER BY
		ac_pay_plan_desc
";
$GLOBALS['form40_rf_default_ac_pay_plan_id']->Select(combolist($GLOBALS['lDB'],$sql));
$GLOBALS['form40_rf_default_ac_pay_plan_id']->TabIndex = 11;
$GLOBALS['form40_rf_default_ac_pay_plan_id']->Width = 200;

$GLOBALS['form40_rf_default_rf_invoice_title']->Size = 30;
$GLOBALS['form40_rf_default_rf_invoice_title']->Width = 200;
$GLOBALS['form40_rf_default_rf_invoice_title']->TabIndex = 12;
$GLOBALS['form40_rf_default_rf_invoice_title']->StyleType = "txt";
if ($GLOBALS['form40_rf_default_rf_invoice_title']->Value == "") {
	$GLOBALS['form40_rf_default_rf_invoice_title']->Value = "Invoice";
}

$GLOBALS[$form.'_rf_default_rf_itinerary_title']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_itinerary_title']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_itinerary_title']->TabIndex = 12;
$GLOBALS[$form.'_rf_default_rf_itinerary_title']->StyleType = "txt";

$invoice_date = array("1:|:Departure Date","2:|:Arrival Date");
$GLOBALS['form40_rf_default_rf_invoice_date']->Select($invoice_date);
$GLOBALS['form40_rf_default_rf_invoice_date']->TabIndex = 11;
$GLOBALS['form40_rf_default_rf_invoice_date']->Width = 200;
$GLOBALS['form40_rf_default_rf_invoice_date']->Size = 60;

$GLOBALS['form40_rf_default_rf_proforma_title']->Size = 30;
$GLOBALS['form40_rf_default_rf_proforma_title']->Width = 200;
$GLOBALS['form40_rf_default_rf_proforma_title']->TabIndex = 13;
$GLOBALS['form40_rf_default_rf_proforma_title']->StyleType = "txt";
if ($GLOBALS['form40_rf_default_rf_proforma_title']->Value == "") {
	$GLOBALS['form40_rf_default_rf_proforma_title']->Value = "Proforma";
}

$GLOBALS['form40_rf_default_rf_book_limit']->Size = 4;
$GLOBALS['form40_rf_default_rf_book_limit']->TabIndex = 14;
$GLOBALS['form40_rf_default_rf_book_limit']->StyleType = "txt";

$GLOBALS['form40_rf_default_rf_period_split']->Select(array("1:|:Use first day's rate","2:|:Split item per period"));
$GLOBALS['form40_rf_default_rf_period_split']->Width = 200;
$GLOBALS['form40_rf_default_rf_period_split']->Size = 100;
$GLOBALS['form40_rf_default_rf_period_split']->TabIndex = 15;

$GLOBALS['form40_rf_default_rf_proforma_note']->Class = 5;
$GLOBALS['form40_rf_default_rf_proforma_note']->StyleType = "txt";
$GLOBALS['form40_rf_default_rf_proforma_note']->Rows = 3;
$GLOBALS['form40_rf_default_rf_proforma_note']->Cols = 69;
$GLOBALS['form40_rf_default_rf_proforma_note']->TabIndex = 16;


$GLOBALS[$form.'_rf_default_rf_doc_summary_comp_group_label']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_doc_summary_comp_group_label']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_doc_summary_comp_group_label']->TabIndex = 12;
$GLOBALS[$form.'_rf_default_rf_doc_summary_comp_group_label']->StyleType = "txt";

$GLOBALS[$form.'_rf_default_rf_doc_proforma_comp_group_label']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_doc_proforma_comp_group_label']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_doc_proforma_comp_group_label']->TabIndex = 12;
$GLOBALS[$form.'_rf_default_rf_doc_proforma_comp_group_label']->StyleType = "txt";

$GLOBALS[$form.'_rf_default_rf_doc_invoice_comp_group_label']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_doc_invoice_comp_group_label']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_doc_invoice_comp_group_label']->TabIndex = 12;
$GLOBALS[$form.'_rf_default_rf_doc_invoice_comp_group_label']->StyleType = "txt";

$GLOBALS[$form.'_rf_default_rf_statutory_label_1']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_statutory_label_1']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_statutory_label_1']->StyleType = "txt";

$GLOBALS[$form.'_rf_default_rf_statutory_label_2']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_statutory_label_2']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_statutory_label_2']->StyleType = "txt";

$GLOBALS[$form.'_rf_default_rf_statutory_label_3']->Size = 30;
$GLOBALS[$form.'_rf_default_rf_statutory_label_3']->Width = 200;
$GLOBALS[$form.'_rf_default_rf_statutory_label_3']->StyleType = "txt";


$GLOBALS['temp']['accom_sort_room'] = "";
$GLOBALS['temp']['accom_sort_type'] = " checked";
if ($GLOBALS['form40_rf_default_rf_accomm_sort_ind']->Value != "0") {
	$GLOBALS['temp']['accom_sort_room'] = " checked";
	$GLOBALS['temp']['accom_sort_type'] = "";
}


$GLOBALS['form40_rf_default_rf_persona_check_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_first_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_first_soundex_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_first_exact_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_first_match_yn']->Class = 9;

$GLOBALS['form40_rf_default_rf_persona_first_match_limit']->Class = 1;
$GLOBALS['form40_rf_default_rf_persona_first_match_limit']->Size = 4;

$GLOBALS['form40_rf_default_rf_persona_last_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_last_soundex_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_last_exact_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_persona_last_match_yn']->Class = 9;

$GLOBALS['form40_rf_default_rf_persona_last_match_limit']->Class = 1;
$GLOBALS['form40_rf_default_rf_persona_last_match_limit']->Size = 4;

/*
		"rf_site_title",
		"rf_site_description",
		"rf_site_keywords",
		"rf_analytics_yn",
		"rf_analytics_code",
		"rf_analytics_public_yn",
		"rf_analytics_external_yn",
		"rf_analytics_internal_yn"
 */

$GLOBALS['form40_rf_default_rf_analytics_code']->Class = 1;
$GLOBALS['form40_rf_default_rf_analytics_code']->Width = 640;
$GLOBALS['form40_rf_default_rf_analytics_code']->onChange = "toggleAnalytics();";

$GLOBALS['form40_rf_default_rf_analytics_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_analytics_yn']->onChange = "toggleAnalytics();";

$GLOBALS['form40_rf_default_rf_analytics_public_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_analytics_external_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_analytics_internal_yn']->Class = 9;
$GLOBALS['temp']['analytics_overlib'] = "";
$rf_analytics_code = trim($GLOBALS['lDB']->get("SELECT rf_analytics_code FROM rf_default",4));
if($rf_analytics_code == "") {
	array_push($disablelist,"form40_rf_default_rf_analytics_yn");
	array_push($disablelist,"form40_rf_default_rf_analytics_public_yn");
	array_push($disablelist,"form40_rf_default_rf_analytics_external_yn");
	array_push($disablelist,"form40_rf_default_rf_analytics_internal_yn");
	$GLOBALS['temp']['analytics_overlib'] = "onmouseover=\"overlib('Paste your Google Analytics Id and click Save to activate and setup your Google Analytics defaults');\" onmouseout=\"nd()\"";
}

$GLOBALS['form40_rf_default_rf_site_title']->Class = 1;
$GLOBALS['form40_rf_default_rf_site_title']->Width = 480;
$GLOBALS['form40_rf_default_rf_site_description']->Class = 1;
$GLOBALS['form40_rf_default_rf_site_description']->Width = 640;
$GLOBALS['form40_rf_default_rf_site_keywords']->Class = 1;
$GLOBALS['form40_rf_default_rf_site_keywords']->Width = 640;


$GLOBALS['temp']['noteEditYesChecked'] = "";
$GLOBALS['temp']['noteEditNoChecked'] = " checked";
if ($GLOBALS['form40_rf_default_rf_share_notes_yn']->Value != "0") {
	$GLOBALS['temp']['noteEditYesChecked'] = "checked";
	$GLOBALS['temp']['noteEditNoChecked'] = "";
}

$GLOBALS['temp']['cancelWarnYesChecked'] = "";
$GLOBALS['temp']['cancelWarnNoChecked'] = " checked";
if ($GLOBALS['form40_rf_default_rf_cancel_warn_yn']->Value != "0") {
	$GLOBALS['temp']['cancelWarnYesChecked'] = "checked";
	$GLOBALS['temp']['cancelWarnNoChecked'] = "";
}

$GLOBALS['form40_rf_default_rf_cancel_warn_note']->Class = 5;
$GLOBALS['form40_rf_default_rf_cancel_warn_note']->StyleType = "txt";
$GLOBALS['form40_rf_default_rf_cancel_warn_note']->Rows = 3;
$GLOBALS['form40_rf_default_rf_cancel_warn_note']->Cols = 50;
$GLOBALS['form40_rf_default_rf_cancel_warn_note']->TabIndex = 16;


$GLOBALS['form40_rf_default_rf_room_cal_days']->Size = 4;
$GLOBALS['form40_rf_default_rf_room_cal_days']->TabIndex = 6;
$GLOBALS['form40_rf_default_rf_room_cal_days']->StyleType = "txt";


$GLOBALS['temp']['chkdisable'] = "";
if ($action == "1") {
	$GLOBALS['temp']['chkdisable'] = " disabled";
}

$GLOBALS['temp']['invoice_future_check_y'] = "";
$GLOBALS['temp']['invoice_future_check_n'] = "";
if($GLOBALS['form40_rf_default_rf_invoice_future_yn']->Value != "0") {
	$GLOBALS['temp']['invoice_future_check_y'] = " checked";
} else {
	$GLOBALS['temp']['invoice_future_check_n'] = " checked";
}

$GLOBALS['temp']['per_stay_check_y'] = "";
$GLOBALS['temp']['per_stay_check_n'] = " checked";
if ($GLOBALS['form40_rf_default_rf_per_stay_yn']->Value != "0") {
	$GLOBALS['temp']['per_stay_check_y'] = " checked";
	$GLOBALS['temp']['per_stay_check_n'] = "";
}

$GLOBALS['temp']['per_stay_check_auto_y'] = "";
$GLOBALS['temp']['per_stay_check_auto_n'] = " checked";
if ($GLOBALS['form40_rf_default_rf_per_stay_auto_yn']->Value != "0") {
	$GLOBALS['temp']['per_stay_check_auto_y'] = " checked";
	$GLOBALS['temp']['per_stay_check_auto_n'] = "";
}


$GLOBALS['temp']['https_require_check_y'] = "";
$GLOBALS['temp']['https_require_check_n'] = " checked";
if ($GLOBALS['form40_rf_default_rf_auth_https_yn']->Value != "0") {
	$GLOBALS['temp']['https_require_check_y'] = " checked";
	$GLOBALS['temp']['https_require_check_n'] = "";
}

$GLOBALS['temp']['https_require_overlib'] = "";
$GLOBALS['temp']['https_require_disabled'] = "";
if(!$GLOBALS['https_enabled']) {
	$GLOBALS['temp']['https_require_overlib'] = "onmouseover=\"overlib('Require HTTPS may only be toggled on an HTTPS connection');\" onmouseout=\"nd();\"";
	$GLOBALS['temp']['https_require_disabled'] = "disabled";
}

$GLOBALS['temp']['internalTab'] = "";
$GLOBALS['temp']['internalArea'] = "";
if (strtolower($GLOBALS['username']) == "censysad") {
	$GLOBALS['temp']['internalTab'] = join("\n",file(__DIR__ . "/../../../public/html/default_table_internal_tab.htm"));
	$GLOBALS['temp']['internalArea'] = showpage([
		'chkdisable' => $GLOBALS['temp']['chkdisable']
	],join("\n",file(__DIR__ . "/../../../public/html/default_table_internal.htm")));
}

$offlineCheck = $lDB->get("
	SELECT
		COUNT(*)
	FROM
		rf_database
	WHERE
		rf_database.rf_db_code NOT LIKE 'W%'
		AND rf_database.rf_db_inactive_yn = '0'
",4);
$GLOBALS['temp']['has_offline'] = ($offlineCheck > 0?"1":"0");

$GLOBALS['form40_rf_default_rf_auth_previous_password_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_auth_previous_password_limit']->Width = 40;

$GLOBALS['form40_rf_default_rf_auth_minimum_length_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_auth_minimum_length_limit']->Width = 40;

$GLOBALS['form40_rf_default_rf_auth_uppercase_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_auth_lowercase_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_auth_numeric_yn']->Class = 9;
$GLOBALS['form40_rf_default_rf_auth_special_yn']->Class = 9;

$GLOBALS['temp']['force_change_check_y'] = "";
$GLOBALS['temp']['force_change_check_n'] = " checked";
if ($GLOBALS['form40_rf_default_rf_auth_force_change_yn']->Value != "0") {
	$GLOBALS['temp']['force_change_check_y'] = " checked";
	$GLOBALS['temp']['force_change_check_n'] = "";
}

$GLOBALS['temp']['showCommissionLabelOverride'] = "display: none;";
$GLOBALS['temp'][$form.'_rf_default_rf_commission_label_override'] = "";

if ($commissionLabelImplemented) {
	$GLOBALS[$form.'_rf_default_rf_commission_label_override']->Size = 30;
	$GLOBALS[$form.'_rf_default_rf_commission_label_override']->Width = 200;
	$GLOBALS[$form.'_rf_default_rf_commission_label_override']->TabIndex = 12;
	$GLOBALS[$form.'_rf_default_rf_commission_label_override']->StyleType = "txt";
	$GLOBALS['temp']['showCommissionLabelOverride'] = "";
}

$GLOBALS['temp']['showExchDecimalPlaces'] = "display: none;";

if ($exchDecimalPlacesImplemented) {
	$GLOBALS['temp']['rf_exch_decimal_places_value'] = $GLOBALS['form40_rf_default_rf_exch_decimal_places']->Value;
	$GLOBALS['temp']['showExchDecimalPlaces'] = "";
}

$GLOBALS[$form]->Hide($hidelist);
$GLOBALS[$form]->Disable($disablelist);

// Start Guest Services

// Save updated guest field settings
if (!empty($_POST['guest_field_settings'])) {
    $guestFieldSettings = json_decode($_POST['guest_field_settings'], true);

    foreach ($guestFieldSettings as $guestFieldId => $setting) {
        $guestField = $em->getRepository('Resrequest\DB\Enterprise\Entity\RfObjRegistrationCard')->findBy([
			'rfObjRegistrationCardIx' => $guestFieldId,
			'rfObjRegistrationCardSysCode' => [1,2]
		])[0];

        $sysCode = $guestField->getRfObjRegistrationCardSysCode();

        // Prevent edits on uneditable fields
        if ($sysCode != 2) {
            $guestField->setRfObjRegistrationCardMandatoryYn($setting);
            $em->persist($guestField);
            $em->flush();
        }
    }
    $_POST['guest_field_settings'] = false;
}

// Generate guest field rows
$guestFieldsQuery = $em->createQueryBuilder();
$guestFields = $guestFieldsQuery
    ->select(
        [
            'guestField.rfObjRegistrationCardIx AS id',
            'guestField.rfObjRegistrationCardLabel AS name',
            'guestField.rfObjRegistrationCardMandatoryYn AS compulsory',
            'guestField.rfObjRegistrationCardSysCode AS code',
        ]
    )
    ->from('Resrequest\DB\Enterprise\Entity\RfObjRegistrationCard', 'guestField')
	->where('guestField.rfObjRegistrationCardSysCode IN(1,2)')
	->orderBy('guestField.rfObjRegistrationCardSortSeq')
    ->getQuery()
    ->getResult();

$guestFieldRowsHTML = '';
foreach ($guestFields as $guestField) {
    $checked = $guestField['compulsory'] ? 'checked' : '';
    $disabled = '';
    $overlib = '';

    if ($guestField['code'] == 2) {
        $overlib = "onmouseover=\"overlib('This field cannot be edited');\" onmouseout=\"nd();\"";
        $disabled = 'disabled';
    }

    $guestFieldRowsHTML .=
    "<tr {$overlib}>
        <td>
            {$guestField['name']}
        </td>
        <td>
            <input
                type=\"checkbox\"
                {$checked}
                id=\"{$guestField['id']}\"
                onchange=\"updateGuestFieldCompulsory(this)\"
                {$disabled}
            />
        </td>
    </tr>";
}

$GLOBALS['temp']['guestFieldRows'] = $guestFieldRowsHTML;

// Save indemnity message
$rfDefault = $em->getRepository('Resrequest\DB\Enterprise\Entity\RfDefault')->findOneBy([]);
if (key_exists('guest_indemnity_message', $_POST)) {
	$rfDefault->setRfGuestIndemnityMessage($_POST['guest_indemnity_message']);
	$em->persist($rfDefault);
	$em->flush();
}

// Generate indemnity message
$guestIndemnityMessage = $rfDefault->getRfGuestIndemnityMessage();
$GLOBALS['temp']['guestIndemnityMessage'] = $guestIndemnityMessage;

// End Guest Services

// Start Access Control Toolbar Setup
$newr = 106;
$edit = 108;
$view = 105;
$dele = 110;
$sedit = 109;
$snewr = 107;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";          // DEBUG - Added by Richard - new never available in Default Table
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";
// End Access Control Toolbar Setup
$GLOBALS['temp']['hideRateButton'] = " style=\"visibility: hidden;\" ";
switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['new_record'] = "reservation.php?106";
	$GLOBALS['temp']['edit_view'] = "reservation.php?108";
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = "107";
	$GLOBALS['temp']['new_record'] = "reservation.php?106";
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['mode'] = "new";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "109";
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['new_record'] = "reservation.php?106";
	$GLOBALS['temp']['edit_view'] = "reservation.php?105";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?110";
	$GLOBALS['temp']['hideRateButton'] = "";
	break;
case (4) : // Delete Record
	$GLOBALS['initrecord'] = $record;
	$GLOBALS['delrecord'] = $record;
	break;
}

